#version unofficial megapov 0.6;

#declare test_miroir_inc = off;


#include "colors.inc"
#include "woods.inc"


#declare htM = 25;
#declare lgM = 18;
#declare epM = 1;
#declare rcM = 2;

#declare Miroir1 = union {
	box { <rcM, 0, 0>, <lgM-rcM, rcM, -epM> }
	box { <rcM, htM, 0>, <lgM-rcM, htM-rcM, -epM> }
	box { <0, rcM, 0>, <rcM, htM-rcM, -epM> }
	box { <lgM, rcM, 0>, <lgM-rcM, htM-rcM, -epM> }
	intersection {
		box { <0, 0, 0>, <rcM, rcM, -epM> }
		cylinder { <rcM, rcM, .001>, <rcM, rcM, -epM-.001>, rcM }
	}
	intersection {
		box { <lgM, 0, 0>, <lgM-rcM, rcM, -epM> }
		cylinder { <lgM-rcM, rcM, .001>, <lgM-rcM, rcM, -epM-.001>, rcM }
	}
	intersection {
		box { <0, htM, 0>, <rcM, htM-rcM, -epM> }
		cylinder { <rcM, htM-rcM, .001>, <rcM, htM-rcM, -epM-.001>, rcM }
	}
	intersection {
		box { <lgM, htM, 0>, <lgM-rcM, htM-rcM, -epM> }
		cylinder { <lgM-rcM, htM-rcM, .001>, <lgM-rcM, htM-rcM, -epM-.001>, rcM }
	}
}


#declare HF_Crack = union {
	height_field {
		pattern 50, 10 {
			hf_gray_16
			bozo
			warp { turbulence .6 octaves 5 omega .4 lambda 4 }
			scale <.2, 10, 1>
			color_map { [0 rgb 0] [1 rgb 1]}
		}
		scale <1,3,-1>
		translate 5*y
	}
	box { <0, -5, 0>, <1, 5, -1> }
	scale <2*lgM, 1, epM>
	translate -x*lgM/2
}

#declare Miroir2 = 	union {
	intersection {
		box { <rcM, rcM, -epM/4>, <lgM-rcM, htM-rcM, -epM*3/4> }
		object { HF_Crack rotate -z*30 translate 8*y }
	}
	intersection {
		box { <rcM, rcM, -epM/4>, <lgM-rcM, htM-rcM, -epM*3/4> }
		object { HF_Crack rotate -z*30 translate 8*y inverse }
		object { HF_Crack rotate z*60 translate 5*y+8*x }
		rotate x*.5
		translate -z*epM/12 +.1*x
	}
	intersection {
		box { <rcM, rcM, -epM/4>, <lgM-rcM, htM-rcM, -epM*3/4> }
		object { HF_Crack rotate -z*30 translate 8*y inverse }
		object { HF_Crack rotate z*60 translate 5*y+8*x inverse }
		rotate -x*.4
		translate z*epM/15 +.1*y - .1*x
	}
}

#declare rcM2 = rcM/8;

#declare Miroir = union {
	// cadre
	difference {
		object { Miroir1 }
		cylinder { <rcM/2, rcM-.001, -epM>, <rcM/2, htM-rcM+.001, -epM>, rcM2 }
		cylinder { <lgM-rcM/2, rcM-.001, -epM>, <lgM-rcM/2, htM-rcM+.001, -epM>, rcM2 }
		cylinder { <rcM-.001, rcM/2, -epM>, <lgM-rcM+.001, rcM/2, -epM>, rcM2 }
		cylinder { <rcM-.001, htM-rcM/2, -epM>, <lgM-rcM+.001, htM-rcM/2, -epM>, rcM2 }
		intersection {
			box { <0, 0, -epM+rcM2+.001>, <rcM, rcM, -epM-rcM2-.001> }
			torus { rcM/2, rcM2 rotate x*90 translate <rcM, rcM, -epM> }
		}
		intersection {
			box { <lgM, 0, -epM+rcM2+.001>, <lgM-rcM, rcM, -epM-rcM2-.001> }
			torus { rcM/2, rcM2 rotate x*90 translate <lgM-rcM, rcM, -epM> }
		}
		intersection {
			box { <0, htM, -epM+rcM2+.001>, <rcM, htM-rcM, -epM-rcM2-.001> }
			torus { rcM/2, rcM2 rotate x*90 translate <rcM, htM-rcM, -epM> }
		}
		intersection {
			box { <lgM, htM, -epM+rcM2+.001>, <lgM-rcM, htM-rcM, -epM-rcM2-.001> }
			torus { rcM/2, rcM2 rotate x*90 translate <lgM-rcM, htM-rcM, -epM> }
		}
	}
	box { <rcM, rcM, -epM/4>, <lgM-rcM, htM-rcM, 0> }
	// Miroir
	object { Miroir2 texture { pigment { rgb 0 } } finish { reflection 1 specular .2 roughness .01 } }
	texture { T_Wood3 rotate x*90 }
}

#if (test_miroir_inc)


camera {
	location <20, 30, -50>
		angle 40
	look_at <10, 15, 0>
}

light_source { <-20, 15, -30>*100 color rgb 1.2 }

plane { y, 0 texture {  pigment { rgb 1 } normal { bumps .5 } } }

object { Miroir }

#end
