#version unofficial megapov 0.6;

#declare test_horloge_inc = off;


#declare T_Pendule1 = texture {
	pigment { color rgb <.8, .7, .2> }
	normal { dents .3 scale .3 }
	finish { reflection_min .2 reflection_max .6 specular .7 roughness .005 }
}

#declare T_Pendule2 = texture {
	pigment { color rgb <1.000,0.995,0.950> }
	normal { granite .08 scale .1 }
	finish { phong 0.7 }
}

#declare T_Pendule3 = texture {
	pigment { color rgb <0.145,0.255,0.537> }
	finish { phong 0.7 }
}

#declare P_Pied = union {
	union {
		torus { 7, .1 }
		cone { 0, 7, y, 6 }
		torus { 6, .1 translate y }
		translate .5*y
	}
	intersection {
		union {
			sphere { 0, 1 translate 1.5*y -5.5*z }
			sphere { 0, 1 translate 1.5*y -5.5*z rotate y*120 }
			sphere { 0, 1 translate 1.5*y -5.5*z rotate -y*120 }
		}
		box { <-6, 0, -6>, <6, .6, 6> }
	}
}

#declare P_Colonne = difference {
	cylinder { 0, 14*y, .5 }
	#local i=0;
	#while (i<360)
		cylinder { -.1*y, 14.1*y, .2 translate .6*x rotate i*y }
		#local i=i+20;
	#end
}

#declare P_Support = union {
	object { P_Colonne translate  3.5*x - 2.5*z }
	sphere { 0, .5     translate  3.5*x - 2.5*z + 14*y }
	object { P_Colonne translate  3.5*x + 2.5*z }
	sphere { 0, .5     translate  3.5*x + 2.5*z + 14*y }
	object { P_Colonne translate -3.5*x - 2.5*z }
	sphere { 0, .5     translate -3.5*x - 2.5*z + 14*y }
	object { P_Colonne translate -3.5*x + 2.5*z }
	sphere { 0, .5     translate -3.5*x + 2.5*z + 14*y }
	difference {
		box { <-3.5, 6, -2.5> , < 3.5, 13,  2.5> }
		box { <-1, 5.99, -.2>, < 1, 7, .2> }
	}
	torus { 3.3, .3 rotate x*90 scale <1,1,.8> translate .5*(13+6)*y - 2.5*z }
}

#declare P_Pendule = union {
	cylinder { -.2*z, .2*z, 1 }
	cylinder { -1.2*y, 5*y, .1 }
}

#macro CenteredText(mot, ht)
	#local Mot = text {
		ttf "folkard_.ttf"
		mot
		.2,0
	}
	#local mini = min_extent(Mot);
	#local maxi = max_extent(Mot);
	object { Mot translate -maxi.y*y + (-mini.x - .5*(mini.x+maxi.x))*x scale ht/(maxi.y-mini.y) }
#end

#declare P_Cadrant = union {
	cylinder { .5*z, 0, 3.3 texture { T_Pendule2 } }
	cylinder { .1*z, -.3*z, .05 }
	cylinder { -.29*z, -.32*z, .1 }
	union {
		intersection {
			box { <-.1, -.1, -0.28>, <.1, 2.3, -.26> rotate 2*z }
			box { <-.1, -.1, -0.28>, <.1, 2.3, -.26> rotate -2*z }
			box { <-.1, -.1, -0.28>, <.1, 2.3, -.26> }
		}
		intersection {
			box { <-.1, .1, -0.28>, <.1, -0.5, -.26> rotate 20*z }
			box { <-.1, .1, -0.28>, <.1, -0.5, -.26> rotate -20*z }
			box { <-.1, .1, -0.28>, <.1, -0.5, -.26> }
		}
		rotate -45*z
	}
	union {
		intersection {
			box { <-.1, -.1, -0.28>, <.1, 2.3, -.26> rotate 4*z }
			box { <-.1, -.1, -0.28>, <.1, 2.3, -.26> rotate -4*z }
			box { <-.1, -.1, -0.28>, <.1, 2.3, -.26> }
		}
		intersection {
			box { <-.1, .1, -0.28>, <.1, -0.5, -.26> rotate 20*z }
			box { <-.1, .1, -0.28>, <.1, -0.5, -.26> rotate -20*z }
			box { <-.1, .1, -0.28>, <.1, -0.5, -.26> }
		}
		rotate 25*z
		translate .05*z
	}
	object { CenteredText("XII", .5) translate 2.8*y -.1*z }
	object { CenteredText("I", .5) translate 2.8*y -.1*z rotate -30*z }
	object { CenteredText("II", .5) translate 2.8*y -.1*z rotate -60*z }
	object { CenteredText("III", .5) translate 2.8*y -.1*z rotate -90*z }
	object { CenteredText("XI", .5) translate 2.8*y -.1*z rotate 30*z }
	object { CenteredText("X", .5) translate 2.8*y -.1*z rotate 60*z }
	object { CenteredText("IX", .5) translate 2.8*y -.1*z rotate 90*z }
	object { CenteredText("VI", .5) translate (-2.8+.5)*y -.1*z }
	object { CenteredText("V", .5) translate (-2.8+.5)*y -.1*z rotate 30*z }
	object { CenteredText("IV", .5) translate (-2.8+.5)*y -.1*z rotate 60*z }
	object { CenteredText("VII", .5) translate (-2.8+.5)*y -.1*z rotate -30*z }
	object { CenteredText("VIII", .5) translate (-2.8+.5)*y -.1*z rotate -60*z }
	texture { T_Pendule3 }
}


#declare Pendule = union {
	object { P_Pied texture { T_Pendule1 } }
	object { P_Support translate 1.5*y texture { T_Pendule1 } }
	object { P_Pendule  translate -5*y rotate z*10 translate (5+1.5+1.50)*y texture { T_Pendule1 } }
	object { P_Cadrant translate (1.5+.5*(13+6))*y - 2.55*z }
}




#if (test_horloge_inc)

plane { y, 0 pigment { rgb .85 } }


object { Pendule }


camera {location <-20, 15, -45> angle 35 look_at 7*y }

light_source { <1,1,-2>*1000 color rgb 1 }

#end

