#version unofficial megapov 0.6;

#declare test_plancher_inc = off;

#if (test_plancher_inc)
	#declare Use_HF_Plancher = on;
	#include "colors.inc"
	#include "woods.inc"

	#declare Xfond1 = -150;
	#declare Xfond2 =  200;
	#declare Yfond1 =    0;
	#declare Yfond2 =  100;
	#declare Yfond3 =  220;
	#declare Zfond1 =  400;
	#declare Afond  =   30;
	#declare Xfen1 =    55;
	#declare Xfen2 =   115;

#end


#if (Use_HF_Plancher)

//==================
// TEXTURES PLANCHER
//==================

#declare N_Pl1 = normal {
	bozo
	warp { turbulence <.3, 0, 0> octaves 2 omega .6 lambda 2 }
	slope_map {
		[.700 <1, 0>]
		[.700 <1, -3>]
		[.950 <0, -3>]
		[.950 <0, 0>]
	}
	scale <.05, .05, 1>
}

#declare T_Plancher = array[6]

#local i=0;
#while (i<6)
	#declare T_Plancher[i] = texture{
		#switch (i)
			#case (0) T_Wood5 #break
			#case (1) T_Wood8 #break
			#case (2) T_Wood15 #break
			#case (3) T_Wood18 #break
			#case (4) T_Wood25 #break
			#case (5) T_Wood33 #break
		#end
		normal{ N_Pl1 }
		finish { brilliance .8 specular .2 roughness .01 }
		scale 10
		warp {
			black_hole <0, 0, 0>, 1
			falloff 1
			strength 1.2
			turbulence <0.5, 0, 0.5>
			repeat <3,0,3>
			inverse
		}
		scale 2
	}
	texture{
		pigment{
			wrinkles
			turbulence 0.1 octaves 2
			color_map{
				[0.0 Tan filter 0.6]
				[0.5 Clear]
				[1.0 Clear]
			}
		}
		scale 6
	}
	#local i=i+1;
#end

#local stp1=seed(1234);
#local stp2=seed(1234);
#local incx=(Xfond2-Xfond1)/35;
#local demi=0;
#local lgz=75;


//==================
// LE HF
//==================
#declare HfBois = height_field {
	pattern 200,800 {
		hf_gray_16
		wood
		rotate x*90
		turbulence <0.05, 0.1, .2>
		octaves 5
		lambda 4
		color_map {
			[0.00 White*.7]
			[0.05 White*.7]
			[0.10 White]
			[0.15 White]
			[0.20 White*.7]
			[0.25 White*.6]
			[0.30 White]
			[0.35 White]
			[0.40 White*.7]
			[0.45 White*.7]
			[0.50 White]
			[0.55 White]
			[0.60 White*.8]
			[0.65 White*.7]
			[0.70 White]
			[0.80 White]
			[0.85 White*.6]
			[0.90 White*.7]
			[0.95 White]
			[1 White*.8]
		}
		warp {
			black_hole <0, 0, 0>, 1
			falloff 1
			strength 1.1
			turbulence <0.5, 0.5, 0>
			repeat <2.5,2.5,0>
			inverse
		}
		scale <1/2, 1/8, 1>
	}
}

#declare HfBois1 = object { HfBois translate -.5*x-.5*z scale <2*incx, .4, 4*lgz> }

//=====================
// ON POSE LES PLANCHES
//=====================

union {
#local i=Xfond1;
#while (i<Xfond2)
	#local lng = lgz*(1+demi);
//	box { <-incx/2, -1, -lng/2>, <incx/2, 0, lng/2>
	union {
		box { <-incx/2, -1, -lng/2>, <incx/2, -.6, lng/2> }
		intersection {
			object { HfBois1 #if (rand(stp1) > .5) scale <1,1,-1> #end}
			#local tempx = (-incx/4 + rand(stp2)*incx/2);
			#local tempz = (-lgz/4 + rand(stp2)*lgz/2);
			box {<-incx/2, 0, -lng/2>, <incx/2, 0.4, lng/2> translate <tempx, 0, tempz> }
			translate <-tempx, -.4, -tempz>
		}

		scale <.95, 1, .995>
		rotate x*(-.2+.4*rand(stp2))
		rotate z*(-.5+1*rand(stp2))
		translate <incx/2, 0, -lng/2>
		translate <i, .1*rand(stp2), Zfond1>
		texture { T_Plancher[mod(int(rand(stp1)*4321),6)] translate (-100+200*rand(stp2))*(x+z) }
	}
//	box { <-incx/2, -1, -lgz>, <incx/2, 0, lgz>
	union {
		box { <-incx/2, -1, -lgz>, <incx/2, -.6, lgz> }
		intersection {
			object { HfBois1 #if (rand(stp1) > .5) scale <1,1,-1> #end}
			#local tempx = (-incx/4 + rand(stp2)*incx/2);
			#local tempz = (-lgz/4 + rand(stp2)*lgz/2);
			box {<-incx/2, 0, -lgz>, <incx/2, 0.4, lgz> translate <tempx, 0, tempz> }
			translate <-tempx, -.4, -tempz>
		}

		scale <.95, 1, .995>
		rotate x*(-.2+.4*rand(stp2))
		rotate z*(-0.5+1*rand(stp2))
		translate <incx/2, 0, -lgz>
		translate <i, .1*rand(stp2), Zfond1-lng>
		texture { T_Plancher[mod(int(rand(stp1)*4321),6)] translate (-100+200*rand(stp2))*(x+z) }
	}
	#local demi = 1-demi;
	#local i = i+incx;
#end
}


//==========================
// INSTALLATION DES PLINTHES
//==========================

#local stp1=seed(1234);
#local stp2=seed(1234);
#local i=Xfond1;
#local lgp=(Xfond2-Xfond1)/2;
#local demi=0;
#local htp1=7;
#local htp2=.5;

#declare Plinthe = union {
	box { <0, 0, 0>, <lgp, .6, htp1+htp2> }
	intersection {
		union {
			box { <0, 0, 0>, <lgp, .4, htp1> }
			cylinder { <0, 0, htp1>, <lgp, 0, htp1>, htp2 scale <1,.4/htp2,1>}
		}
		object { HfBois
			rotate y*90
			translate z
			scale <lgp, .4, htp1+htp2>
		}
		translate .6*y
	}
}

union {
	object { Plinthe
		texture { T_Plancher[2] rotate y*90 translate 20*z }
		rotate -90*x
		translate <Xfond1, .1+.2*rand(stp1), Zfond1>
	}
	object { Plinthe
		texture { T_Plancher[1] rotate y*90 translate 20*z }
		rotate -90*x
		translate <Xfond1 + lgp+.1, .1+.2*rand(stp1), Zfond1>
	}
}
object { Plinthe
	texture { T_Plancher[3] rotate y*90 translate 20*z }
	rotate -90*x
	scale <-1,1,1>
	rotate -90*y
	translate <Xfond1, .1+.2*rand(stp1), Zfond1>
}


#else

plane { y, 0
	texture { T_Wood23
		normal { wood .1 translate 1000*x warp { turbulence .2 octaves 2 } }
		finish { specular .7 roughness .1 phong .7 phong_size 4 }
		scale 10
	}
}

#end

#if (test_plancher_inc)

plane { -z, -Zfond1 pigment { rgb .85 } }
plane { x, Xfond1 pigment { rgb .85 } }

camera {
	location <160, 70, -50>
	right x*2
	up y
	angle 30
	look_at <60, 30, 200>
}

#declare Lamp_Pos = <Xfond1+45, 70, Zfond1-140+40>;

light_source { Lamp_Pos + 20*y color rgb <1, .95, .6>*1.7
	fade_distance 180
	fade_power 2
}

light_source { <90, 50, -50>, color rgb<.45,.55,1>*.45 shadowless }

#end
