#version unofficial megapov 0.6;

// File generated by sPatch, Copyright 1996-1998 by Mike Clifton
#ifndef (IMPORT_SPATCH)

background { color rgb <0, 0, 0> }

camera {
	location <20, 13.0, -50>
	angle 30
	look_at <0.000, 6, 0.000>
}

light_source { < 0, 100, -200 > color rgb <1, 1, 1> }
light_source { < 200, 10, 0 > color rgb <0.4, 0.5, 0.4> }
light_source { < -50, 10, 200 > color rgb <0.5, 0.5, 0.35> }

plane { -z, -50 pigment { color rgb 1 } }

// plancher 
#include "colors.inc"
#include "woods.inc"

#declare N_Pl1 = normal {
	bozo
	warp { turbulence <.3, 0, 0> octaves 2 omega .6 lambda 2 }
	slope_map {
		[.700 <1, 0>]
		[.700 <1, -2>]
		[.950 <0, -2>]
		[.950 <0, 0>]
	}
	scale <.1, .1, 2>
}

/*
#declare T_Plancher = texture {
	T_Wood31
	normal {
		average
		normal_map {
			[1 N_Pl1 ]
			[1 N_Pl1 scale .2 ]
			[1 bozo .4 scale <.3, .3, .6> ]
		}
	}
	finish { specular .5 roughness .03 phong .3 phong_size 10 }
	scale 10
}
*/

#declare T_Plancher = texture{
	T_Wood8
	normal{ N_Pl1 }
	finish { brilliance .9 specular .2 roughness .01 }
	scale 10
	warp {
		black_hole <0, 0, 0>, 1
		falloff 1
		strength 1.2
		turbulence <0.5, 0, 0.5>
		repeat <3,0,3>
		inverse
	}
	scale 2
}
texture{
	pigment{
		bozo
		turbulence 0.3
		color_map{
			[0.0 Tan filter 0.4]
			[0.5 Clear]
			[1.0 Clear]
		}
	}
	scale 6
}


#local stp=seed(1234);
#local i=-100;
#local incx=200/35;
#local demi=0;
#local lgz=75;

union {
#while (i<100)
	#local lng = lgz*(1+demi);
	box { <-incx/2, -1, -lng/2>, <incx/2, 0, lng/2>
		scale <.95, 1, .995>
		rotate x*(-.2+.4*rand(stp))
		rotate z*(-.5+1*rand(stp))
		translate <incx/2, 0, -lng/2>
		translate <i, .1*rand(stp), 100>
		texture { T_Plancher translate (-100+200*rand(stp))*(x+z) }
	}
	box { <-incx/2, -1, -lgz>, <incx/2, 0, lgz>
		scale <.95, 1, .995>
		rotate x*(-.2+.4*rand(stp))
		rotate z*(-0.5+1*rand(stp))
		translate <incx/2, 0, -lgz>
		translate <i, .1*rand(stp), 100-lng>
		texture { T_Plancher translate (-100+200*rand(stp))*(x+z) }
	}
	#local demi = 1-demi;
	#local i = i+incx;
#end
}



#end

union {
// Layer 1
union {
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.500, 0.000, 0.000> <5.500, 0.000, -1.263> <4.782, 0.000, -2.996> <3.889, 0.000, -3.889> 
		<5.575, 0.150, 0.000> <5.575, 0.150, -1.263> <4.835, 0.150, -3.049> <3.942, 0.150, -3.942> 
		<5.325, 0.350, 0.000> <5.325, 0.350, -1.205> <4.618, 0.350, -2.913> <3.765, 0.350, -3.765> 
		<5.250, 0.500, 0.000> <5.250, 0.500, -1.205> <4.565, 0.500, -2.860> <3.712, 0.500, -3.712> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.500, 0.000, 0.000> <5.575, 0.150, 0.000> <5.325, 0.350, 0.000> <5.250, 0.500, 0.000> 
		<5.500, 0.000, 1.263> <5.575, 0.150, 1.263> <5.325, 0.350, 1.205> <5.250, 0.500, 1.205> 
		<4.782, 0.000, 2.996> <4.835, 0.150, 3.049> <4.618, 0.350, 2.913> <4.565, 0.500, 2.860> 
		<3.889, 0.000, 3.889> <3.942, 0.150, 3.942> <3.765, 0.350, 3.765> <3.712, 0.500, 3.712> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.500, 0.000, 0.000> <5.433, -0.134, 0.000> <5.150, 0.000, 0.000> <5.000, 0.000, 0.000> 
		<5.500, 0.000, -1.263> <5.433, -0.134, -1.263> <5.150, 0.000, -1.148> <5.000, 0.000, -1.148> 
		<4.782, 0.000, -2.996> <4.735, -0.134, -2.949> <4.453, 0.000, -2.830> <4.347, 0.000, -2.724> 
		<3.889, 0.000, -3.889> <3.842, -0.134, -3.842> <3.642, 0.000, -3.642> <3.536, 0.000, -3.536> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.500, 0.000, 0.000> <5.500, 0.000, 1.263> <4.782, 0.000, 2.996> <3.889, 0.000, 3.889> 
		<5.433, -0.134, 0.000> <5.433, -0.134, 1.263> <4.735, -0.134, 2.949> <3.842, -0.134, 3.842> 
		<5.150, 0.000, 0.000> <5.150, 0.000, 1.148> <4.453, 0.000, 2.830> <3.642, 0.000, 3.642> 
		<5.000, 0.000, 0.000> <5.000, 0.000, 1.148> <4.347, 0.000, 2.724> <3.536, 0.000, 3.536> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.250, 0.500, 0.000> <5.250, 0.500, -1.205> <4.565, 0.500, -2.860> <3.712, 0.500, -3.712> 
		<5.475, 0.650, 0.000> <5.475, 0.650, -1.205> <4.724, 0.650, -3.019> <3.871, 0.650, -3.871> 
		<5.727, 0.758, 0.000> <5.727, 0.758, -1.378> <5.024, 0.758, -3.076> <4.050, 0.758, -4.050> 
		<6.000, 1.000, 0.000> <6.000, 1.000, -1.378> <5.217, 1.000, -3.268> <4.243, 1.000, -4.243> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.250, 0.500, 0.000> <5.475, 0.650, 0.000> <5.727, 0.758, 0.000> <6.000, 1.000, 0.000> 
		<5.250, 0.500, 1.205> <5.475, 0.650, 1.205> <5.727, 0.758, 1.378> <6.000, 1.000, 1.378> 
		<4.565, 0.500, 2.860> <4.724, 0.650, 3.019> <5.024, 0.758, 3.076> <5.217, 1.000, 3.268> 
		<3.712, 0.500, 3.712> <3.871, 0.650, 3.871> <4.050, 0.758, 4.050> <4.243, 1.000, 4.243> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<6.000, 1.000, 0.000> <6.000, 1.000, -1.378> <5.217, 1.000, -3.268> <4.243, 1.000, -4.243> 
		<6.642, 1.570, 0.000> <6.642, 1.570, -1.378> <5.670, 1.570, -3.722> <4.696, 1.570, -4.696> 
		<7.440, 2.416, 0.000> <7.440, 2.416, -1.722> <6.479, 2.416, -4.043> <5.261, 2.416, -5.261> 
		<7.500, 2.500, 0.000> <7.500, 2.500, -1.722> <6.521, 2.500, -4.086> <5.303, 2.500, -5.303> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<6.000, 1.000, 0.000> <6.642, 1.570, 0.000> <7.440, 2.416, 0.000> <7.500, 2.500, 0.000> 
		<6.000, 1.000, 1.378> <6.642, 1.570, 1.378> <7.440, 2.416, 1.722> <7.500, 2.500, 1.722> 
		<5.217, 1.000, 3.268> <5.670, 1.570, 3.722> <6.479, 2.416, 4.043> <6.521, 2.500, 4.086> 
		<4.243, 1.000, 4.243> <4.696, 1.570, 4.696> <5.261, 2.416, 5.261> <5.303, 2.500, 5.303> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<8.500, 4.500, 0.000> <8.500, 4.500, -1.952> <7.390, 4.500, -4.630> <6.010, 4.500, -6.010> 
		<8.777, 5.886, 0.000> <8.777, 5.886, -1.952> <7.586, 5.886, -4.826> <6.206, 5.886, -6.206> 
		<8.607, 6.679, 0.000> <8.607, 6.679, -1.952> <7.466, 6.679, -4.706> <6.086, 6.679, -6.086> 
		<8.500, 7.500, 0.000> <8.500, 7.500, -1.952> <7.390, 7.500, -4.630> <6.010, 7.500, -6.010> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<8.500, 4.500, 0.000> <8.777, 5.886, 0.000> <8.607, 6.679, 0.000> <8.500, 7.500, 0.000> 
		<8.500, 4.500, 1.952> <8.777, 5.886, 1.952> <8.607, 6.679, 1.952> <8.500, 7.500, 1.952> 
		<7.390, 4.500, 4.630> <7.586, 5.886, 4.826> <7.466, 6.679, 4.706> <7.390, 7.500, 4.630> 
		<6.010, 4.500, 6.010> <6.206, 5.886, 6.206> <6.086, 6.679, 6.086> <6.010, 7.500, 6.010> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<8.500, 4.500, 0.000> <8.293, 3.467, 0.000> <7.563, 2.588, 0.000> <7.500, 2.500, 0.000> 
		<8.500, 4.500, -1.952> <8.293, 3.467, -1.952> <7.563, 2.588, -1.722> <7.500, 2.500, -1.722> 
		<7.390, 4.500, -4.630> <7.244, 3.467, -4.484> <6.566, 2.588, -4.130> <6.521, 2.500, -4.086> 
		<6.010, 4.500, -6.010> <5.864, 3.467, -5.864> <5.348, 2.588, -5.348> <5.303, 2.500, -5.303> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<8.500, 4.500, 0.000> <8.500, 4.500, 1.952> <7.390, 4.500, 4.630> <6.010, 4.500, 6.010> 
		<8.293, 3.467, 0.000> <8.293, 3.467, 1.952> <7.244, 3.467, 4.484> <5.864, 3.467, 5.864> 
		<7.563, 2.588, 0.000> <7.563, 2.588, 1.722> <6.566, 2.588, 4.130> <5.348, 2.588, 5.348> 
		<7.500, 2.500, 0.000> <7.500, 2.500, 1.722> <6.521, 2.500, 4.086> <5.303, 2.500, 5.303> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<8.500, 7.500, 0.000> <8.500, 7.500, -1.952> <7.390, 7.500, -4.630> <6.010, 7.500, -6.010> 
		<8.398, 8.280, 0.000> <8.398, 8.280, -1.952> <7.319, 8.280, -4.558> <5.938, 8.280, -5.938> 
		<7.781, 9.843, 0.000> <7.781, 9.843, -1.779> <6.760, 9.843, -4.244> <5.502, 9.843, -5.502> 
		<7.750, 10.250, 0.000> <7.750, 10.250, -1.779> <6.738, 10.250, -4.222> <5.480, 10.250, -5.480> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<8.500, 7.500, 0.000> <8.398, 8.280, 0.000> <7.781, 9.843, 0.000> <7.750, 10.250, 0.000> 
		<8.500, 7.500, 1.952> <8.398, 8.280, 1.952> <7.781, 9.843, 1.779> <7.750, 10.250, 1.779> 
		<7.390, 7.500, 4.630> <7.319, 8.280, 4.558> <6.760, 9.843, 4.244> <6.738, 10.250, 4.222> 
		<6.010, 7.500, 6.010> <5.938, 8.280, 5.938> <5.502, 9.843, 5.502> <5.480, 10.250, 5.480> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<7.750, 10.250, 0.000> <7.750, 10.250, -1.779> <6.738, 10.250, -4.222> <5.480, 10.250, -5.480> 
		<7.742, 10.351, 0.000> <7.742, 10.351, -1.779> <6.733, 10.351, -4.216> <5.475, 10.351, -5.475> 
		<8.328, 10.438, 0.000> <8.328, 10.438, -1.894> <7.228, 10.438, -4.549> <5.889, 10.438, -5.889> 
		<8.250, 10.750, 0.000> <8.250, 10.750, -1.894> <7.173, 10.750, -4.494> <5.834, 10.750, -5.834> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<7.750, 10.250, 0.000> <7.742, 10.351, 0.000> <8.328, 10.438, 0.000> <8.250, 10.750, 0.000> 
		<7.750, 10.250, 1.779> <7.742, 10.351, 1.779> <8.328, 10.438, 1.894> <8.250, 10.750, 1.894> 
		<6.738, 10.250, 4.222> <6.733, 10.351, 4.216> <7.228, 10.438, 4.549> <7.173, 10.750, 4.494> 
		<5.480, 10.250, 5.480> <5.475, 10.351, 5.475> <5.889, 10.438, 5.889> <5.834, 10.750, 5.834> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<8.250, 10.750, 0.000> <8.250, 10.750, -1.894> <7.173, 10.750, -4.494> <5.834, 10.750, -5.834> 
		<8.151, 11.148, 0.000> <8.151, 11.148, -1.894> <7.103, 11.148, -4.424> <5.763, 11.148, -5.763> 
		<7.770, 11.250, 0.000> <7.770, 11.250, -1.722> <6.712, 11.250, -4.277> <5.495, 11.250, -5.495> 
		<7.500, 11.250, 0.000> <7.500, 11.250, -1.722> <6.521, 11.250, -4.086> <5.303, 11.250, -5.303> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<8.250, 10.750, 0.000> <8.151, 11.148, 0.000> <7.770, 11.250, 0.000> <7.500, 11.250, 0.000> 
		<8.250, 10.750, 1.894> <8.151, 11.148, 1.894> <7.770, 11.250, 1.722> <7.500, 11.250, 1.722> 
		<7.173, 10.750, 4.494> <7.103, 11.148, 4.424> <6.712, 11.250, 4.277> <6.521, 11.250, 4.086> 
		<5.834, 10.750, 5.834> <5.763, 11.148, 5.763> <5.495, 11.250, 5.495> <5.303, 11.250, 5.303> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<7.500, 11.250, 0.000> <7.500, 11.250, -1.722> <6.521, 11.250, -4.086> <5.303, 11.250, -5.303> 
		<7.230, 11.250, 0.000> <7.230, 11.250, -1.722> <6.330, 11.250, -3.894> <5.112, 11.250, -5.112> 
		<6.750, 11.020, 0.000> <6.750, 11.020, -1.550> <5.869, 11.020, -3.677> <4.773, 11.020, -4.773> 
		<6.750, 10.750, 0.000> <6.750, 10.750, -1.550> <5.869, 10.750, -3.677> <4.773, 10.750, -4.773> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<7.500, 11.250, 0.000> <7.230, 11.250, 0.000> <6.750, 11.020, 0.000> <6.750, 10.750, 0.000> 
		<7.500, 11.250, 1.722> <7.230, 11.250, 1.722> <6.750, 11.020, 1.550> <6.750, 10.750, 1.550> 
		<6.521, 11.250, 4.086> <6.330, 11.250, 3.894> <5.869, 11.020, 3.677> <5.869, 10.750, 3.677> 
		<5.303, 11.250, 5.303> <5.112, 11.250, 5.112> <4.773, 11.020, 4.773> <4.773, 10.750, 4.773> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<6.750, 10.750, 0.000> <6.750, 10.750, -1.550> <5.869, 10.750, -3.677> <4.773, 10.750, -4.773> 
		<6.750, 9.967, 0.000> <6.750, 9.967, -1.550> <5.869, 9.967, -3.677> <4.773, 9.967, -4.773> 
		<7.371, 9.022, 0.000> <7.371, 9.022, -1.722> <6.430, 9.022, -3.995> <5.212, 9.022, -5.212> 
		<7.500, 8.250, 0.000> <7.500, 8.250, -1.722> <6.521, 8.250, -4.086> <5.303, 8.250, -5.303> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<6.750, 10.750, 0.000> <6.750, 9.967, 0.000> <7.371, 9.022, 0.000> <7.500, 8.250, 0.000> 
		<6.750, 10.750, 1.550> <6.750, 9.967, 1.550> <7.371, 9.022, 1.722> <7.500, 8.250, 1.722> 
		<5.869, 10.750, 3.677> <5.869, 9.967, 3.677> <6.430, 9.022, 3.995> <6.521, 8.250, 4.086> 
		<4.773, 10.750, 4.773> <4.773, 9.967, 4.773> <5.212, 9.022, 5.212> <5.303, 8.250, 5.303> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<7.500, 8.250, 0.000> <7.500, 8.250, -1.722> <6.521, 8.250, -4.086> <5.303, 8.250, -5.303> 
		<7.673, 7.212, 0.000> <7.673, 7.212, -1.722> <6.643, 7.212, -4.208> <5.426, 7.212, -5.426> 
		<8.060, 5.756, 0.000> <8.060, 5.756, -1.779> <6.957, 5.756, -4.441> <5.699, 5.756, -5.699> 
		<7.750, 4.750, 0.000> <7.750, 4.750, -1.779> <6.738, 4.750, -4.222> <5.480, 4.750, -5.480> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<7.500, 8.250, 0.000> <7.673, 7.212, 0.000> <8.060, 5.756, 0.000> <7.750, 4.750, 0.000> 
		<7.500, 8.250, 1.722> <7.673, 7.212, 1.722> <8.060, 5.756, 1.779> <7.750, 4.750, 1.779> 
		<6.521, 8.250, 4.086> <6.643, 7.212, 4.208> <6.957, 5.756, 4.441> <6.738, 4.750, 4.222> 
		<5.303, 8.250, 5.303> <5.426, 7.212, 5.426> <5.699, 5.756, 5.699> <5.480, 4.750, 5.480> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<7.750, 4.750, 0.000> <7.750, 4.750, -1.779> <6.738, 4.750, -4.222> <5.480, 4.750, -5.480> 
		<7.419, 3.675, 0.000> <7.419, 3.675, -1.779> <6.504, 3.675, -3.988> <5.246, 3.675, -5.246> 
		<6.428, 2.385, 0.000> <6.428, 2.385, -1.263> <5.439, 2.385, -3.653> <4.546, 2.385, -4.546> 
		<5.500, 1.750, 0.000> <5.500, 1.750, -1.263> <4.782, 1.750, -2.996> <3.889, 1.750, -3.889> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<7.750, 4.750, 0.000> <7.419, 3.675, 0.000> <6.428, 2.385, 0.000> <5.500, 1.750, 0.000> 
		<7.750, 4.750, 1.779> <7.419, 3.675, 1.779> <6.428, 2.385, 1.263> <5.500, 1.750, 1.263> 
		<6.738, 4.750, 4.222> <6.504, 3.675, 3.988> <5.439, 2.385, 3.653> <4.782, 1.750, 2.996> 
		<5.480, 4.750, 5.480> <5.246, 3.675, 5.246> <4.546, 2.385, 4.546> <3.889, 1.750, 3.889> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.500, 1.750, 0.000> <5.500, 1.750, -1.263> <4.782, 1.750, -2.996> <3.889, 1.750, -3.889> 
		<4.878, 1.324, 0.000> <4.878, 1.324, -1.263> <4.342, 1.324, -2.556> <3.449, 1.324, -3.449> 
		<3.753, 1.534, 0.000> <3.753, 1.534, -0.689> <3.141, 1.534, -2.167> <2.654, 1.534, -2.654> 
		<3.000, 1.500, 0.000> <3.000, 1.500, -0.689> <2.608, 1.500, -1.634> <2.121, 1.500, -2.121> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.500, 1.750, 0.000> <4.878, 1.324, 0.000> <3.753, 1.534, 0.000> <3.000, 1.500, 0.000> 
		<5.500, 1.750, 1.263> <4.878, 1.324, 1.263> <3.753, 1.534, 0.689> <3.000, 1.500, 0.689> 
		<4.782, 1.750, 2.996> <4.342, 1.324, 2.556> <3.141, 1.534, 2.167> <2.608, 1.500, 1.634> 
		<3.889, 1.750, 3.889> <3.449, 1.324, 3.449> <2.654, 1.534, 2.654> <2.121, 1.500, 2.121> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.000, 0.000, 0.000> <3.500, 0.000, 0.000> <1.500, 0.000, 0.000> <0.000, 0.000, 0.000> 
		<5.000, 0.000, -1.148> <3.500, 0.000, -1.148> <1.500, 0.000, 0.000> <0.000, 0.000, 0.000> 
		<4.347, 0.000, -2.724> <3.287, 0.000, -1.663> <1.061, 0.000, -1.061> <0.000, 0.000, 0.000> 
		<3.536, 0.000, -3.536> <2.475, 0.000, -2.475> <1.061, 0.000, -1.061> <0.000, 0.000, 0.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.000, 0.000, 0.000> <5.000, 0.000, 1.148> <4.347, 0.000, 2.724> <3.536, 0.000, 3.536> 
		<3.500, 0.000, 0.000> <3.500, 0.000, 1.148> <3.287, 0.000, 1.663> <2.475, 0.000, 2.475> 
		<1.500, 0.000, 0.000> <1.500, 0.000, 0.000> <1.061, 0.000, 1.061> <1.061, 0.000, 1.061> 
		<0.000, 0.000, 0.000> <0.000, 0.000, 0.000> <0.000, 0.000, 0.000> <0.000, 0.000, 0.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.000, 1.500, 0.000> <3.000, 1.500, -0.689> <2.608, 1.500, -1.634> <2.121, 1.500, -2.121> 
		<2.101, 1.459, 0.000> <2.101, 1.459, -0.689> <1.973, 1.459, -0.999> <1.486, 1.459, -1.486> 
		<0.900, 1.500, 0.000> <0.900, 1.500, 0.000> <0.636, 1.500, -0.636> <0.636, 1.500, -0.636> 
		<0.000, 1.500, 0.000> <0.000, 1.500, 0.000> <0.000, 1.500, 0.000> <0.000, 1.500, 0.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.000, 1.500, 0.000> <2.101, 1.459, 0.000> <0.900, 1.500, 0.000> <0.000, 1.500, 0.000> 
		<3.000, 1.500, 0.689> <2.101, 1.459, 0.689> <0.900, 1.500, 0.000> <0.000, 1.500, 0.000> 
		<2.608, 1.500, 1.634> <1.973, 1.459, 0.999> <0.636, 1.500, 0.636> <0.000, 1.500, 0.000> 
		<2.121, 1.500, 2.121> <1.486, 1.459, 1.486> <0.636, 1.500, 0.636> <0.000, 1.500, 0.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, 1.500, 0.000> <0.000, 1.500, 0.000> <0.000, 1.500, 0.000> <0.000, 1.500, 0.000> 
		<0.636, 1.500, 0.636> <0.636, 1.500, 0.636> <-0.000, 1.500, 0.900> <-0.000, 1.500, 0.900> 
		<1.486, 1.459, 1.486> <0.999, 1.459, 1.973> <0.689, 1.459, 2.101> <-0.000, 1.459, 2.101> 
		<2.121, 1.500, 2.121> <1.634, 1.500, 2.608> <0.689, 1.500, 3.000> <-0.000, 1.500, 3.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, 1.500, 0.000> <0.000, 1.500, 0.000> <0.000, 1.500, 0.000> <0.000, 1.500, 0.000> 
		<-0.000, 1.500, 0.900> <-0.000, 1.500, 0.900> <-0.636, 1.500, 0.636> <-0.636, 1.500, 0.636> 
		<-0.000, 1.459, 2.101> <-0.689, 1.459, 2.101> <-0.999, 1.459, 1.973> <-1.486, 1.459, 1.486> 
		<-0.000, 1.500, 3.000> <-0.689, 1.500, 3.000> <-1.634, 1.500, 2.608> <-2.121, 1.500, 2.121> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, 1.500, 0.000> <0.000, 1.500, 0.000> <0.000, 1.500, 0.000> <0.000, 1.500, 0.000> 
		<-0.636, 1.500, 0.636> <-0.636, 1.500, 0.636> <-0.900, 1.500, -0.000> <-0.900, 1.500, -0.000> 
		<-1.486, 1.459, 1.486> <-1.973, 1.459, 0.999> <-2.101, 1.459, 0.689> <-2.101, 1.459, -0.000> 
		<-2.121, 1.500, 2.121> <-2.608, 1.500, 1.634> <-3.000, 1.500, 0.689> <-3.000, 1.500, -0.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, 1.500, 0.000> <0.000, 1.500, 0.000> <0.000, 1.500, 0.000> <0.000, 1.500, 0.000> 
		<-0.900, 1.500, -0.000> <-0.900, 1.500, -0.000> <-0.636, 1.500, -0.636> <-0.636, 1.500, -0.636> 
		<-2.101, 1.459, -0.000> <-2.101, 1.459, -0.689> <-1.973, 1.459, -0.999> <-1.486, 1.459, -1.486> 
		<-3.000, 1.500, -0.000> <-3.000, 1.500, -0.689> <-2.608, 1.500, -1.634> <-2.121, 1.500, -2.121> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, 1.500, 0.000> <0.000, 1.500, 0.000> <0.000, 1.500, 0.000> <0.000, 1.500, 0.000> 
		<-0.636, 1.500, -0.636> <-0.636, 1.500, -0.636> <0.000, 1.500, -0.900> <0.000, 1.500, -0.900> 
		<-1.486, 1.459, -1.486> <-0.999, 1.459, -1.973> <-0.689, 1.459, -2.101> <0.000, 1.459, -2.101> 
		<-2.121, 1.500, -2.121> <-1.634, 1.500, -2.608> <-0.689, 1.500, -3.000> <0.000, 1.500, -3.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, 1.500, 0.000> <0.000, 1.500, 0.000> <0.000, 1.500, 0.000> <0.000, 1.500, 0.000> 
		<0.000, 1.500, -0.900> <0.000, 1.500, -0.900> <0.636, 1.500, -0.636> <0.636, 1.500, -0.636> 
		<0.000, 1.459, -2.101> <0.689, 1.459, -2.101> <0.999, 1.459, -1.973> <1.486, 1.459, -1.486> 
		<0.000, 1.500, -3.000> <0.689, 1.500, -3.000> <1.634, 1.500, -2.608> <2.121, 1.500, -2.121> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.121, 1.500, 2.121> <1.634, 1.500, 2.608> <0.689, 1.500, 3.000> <-0.000, 1.500, 3.000> 
		<2.654, 1.534, 2.654> <2.167, 1.534, 3.141> <0.689, 1.534, 3.753> <-0.000, 1.534, 3.753> 
		<3.449, 1.324, 3.449> <2.556, 1.324, 4.342> <1.263, 1.324, 4.878> <-0.000, 1.324, 4.878> 
		<3.889, 1.750, 3.889> <2.996, 1.750, 4.782> <1.263, 1.750, 5.500> <-0.000, 1.750, 5.500> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.000, 1.500, 3.000> <-0.689, 1.500, 3.000> <-1.634, 1.500, 2.608> <-2.121, 1.500, 2.121> 
		<-0.000, 1.534, 3.753> <-0.689, 1.534, 3.753> <-2.167, 1.534, 3.141> <-2.654, 1.534, 2.654> 
		<-0.000, 1.324, 4.878> <-1.263, 1.324, 4.878> <-2.556, 1.324, 4.342> <-3.449, 1.324, 3.449> 
		<-0.000, 1.750, 5.500> <-1.263, 1.750, 5.500> <-2.996, 1.750, 4.782> <-3.889, 1.750, 3.889> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.121, 1.500, 2.121> <-2.608, 1.500, 1.634> <-3.000, 1.500, 0.689> <-3.000, 1.500, -0.000> 
		<-2.654, 1.534, 2.654> <-3.141, 1.534, 2.167> <-3.753, 1.534, 0.689> <-3.753, 1.534, -0.000> 
		<-3.449, 1.324, 3.449> <-4.342, 1.324, 2.556> <-4.878, 1.324, 1.263> <-4.878, 1.324, -0.000> 
		<-3.889, 1.750, 3.889> <-4.782, 1.750, 2.996> <-5.500, 1.750, 1.263> <-5.500, 1.750, -0.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.000, 1.500, -0.000> <-3.000, 1.500, -0.689> <-2.608, 1.500, -1.634> <-2.121, 1.500, -2.121> 
		<-3.753, 1.534, -0.000> <-3.753, 1.534, -0.689> <-3.141, 1.534, -2.167> <-2.654, 1.534, -2.654> 
		<-4.878, 1.324, -0.000> <-4.878, 1.324, -1.263> <-4.342, 1.324, -2.556> <-3.449, 1.324, -3.449> 
		<-5.500, 1.750, -0.000> <-5.500, 1.750, -1.263> <-4.782, 1.750, -2.996> <-3.889, 1.750, -3.889> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.121, 1.500, -2.121> <-1.634, 1.500, -2.608> <-0.689, 1.500, -3.000> <0.000, 1.500, -3.000> 
		<-2.654, 1.534, -2.654> <-2.167, 1.534, -3.141> <-0.689, 1.534, -3.753> <0.000, 1.534, -3.753> 
		<-3.449, 1.324, -3.449> <-2.556, 1.324, -4.342> <-1.263, 1.324, -4.878> <0.000, 1.324, -4.878> 
		<-3.889, 1.750, -3.889> <-2.996, 1.750, -4.782> <-1.263, 1.750, -5.500> <0.000, 1.750, -5.500> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, 1.500, -3.000> <0.689, 1.500, -3.000> <1.634, 1.500, -2.608> <2.121, 1.500, -2.121> 
		<0.000, 1.534, -3.753> <0.689, 1.534, -3.753> <2.167, 1.534, -3.141> <2.654, 1.534, -2.654> 
		<0.000, 1.324, -4.878> <1.263, 1.324, -4.878> <2.556, 1.324, -4.342> <3.449, 1.324, -3.449> 
		<0.000, 1.750, -5.500> <1.263, 1.750, -5.500> <2.996, 1.750, -4.782> <3.889, 1.750, -3.889> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.889, 1.750, 3.889> <2.996, 1.750, 4.782> <1.263, 1.750, 5.500> <-0.000, 1.750, 5.500> 
		<4.546, 2.385, 4.546> <3.653, 2.385, 5.439> <1.263, 2.385, 6.428> <-0.000, 2.385, 6.428> 
		<5.246, 3.675, 5.246> <3.988, 3.675, 6.504> <1.779, 3.675, 7.419> <-0.000, 3.675, 7.419> 
		<5.480, 4.750, 5.480> <4.222, 4.750, 6.738> <1.779, 4.750, 7.750> <-0.000, 4.750, 7.750> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.000, 1.750, 5.500> <-1.263, 1.750, 5.500> <-2.996, 1.750, 4.782> <-3.889, 1.750, 3.889> 
		<-0.000, 2.385, 6.428> <-1.263, 2.385, 6.428> <-3.653, 2.385, 5.439> <-4.546, 2.385, 4.546> 
		<-0.000, 3.675, 7.419> <-1.779, 3.675, 7.419> <-3.988, 3.675, 6.504> <-5.246, 3.675, 5.246> 
		<-0.000, 4.750, 7.750> <-1.779, 4.750, 7.750> <-4.222, 4.750, 6.738> <-5.480, 4.750, 5.480> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.889, 1.750, 3.889> <-4.782, 1.750, 2.996> <-5.500, 1.750, 1.263> <-5.500, 1.750, -0.000> 
		<-4.546, 2.385, 4.546> <-5.439, 2.385, 3.653> <-6.428, 2.385, 1.263> <-6.428, 2.385, -0.000> 
		<-5.246, 3.675, 5.246> <-6.504, 3.675, 3.988> <-7.419, 3.675, 1.779> <-7.419, 3.675, -0.000> 
		<-5.480, 4.750, 5.480> <-6.738, 4.750, 4.222> <-7.750, 4.750, 1.779> <-7.750, 4.750, -0.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-5.500, 1.750, -0.000> <-5.500, 1.750, -1.263> <-4.782, 1.750, -2.996> <-3.889, 1.750, -3.889> 
		<-6.428, 2.385, -0.000> <-6.428, 2.385, -1.263> <-5.439, 2.385, -3.653> <-4.546, 2.385, -4.546> 
		<-7.419, 3.675, -0.000> <-7.419, 3.675, -1.779> <-6.504, 3.675, -3.988> <-5.246, 3.675, -5.246> 
		<-7.750, 4.750, -0.000> <-7.750, 4.750, -1.779> <-6.738, 4.750, -4.222> <-5.480, 4.750, -5.480> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.889, 1.750, -3.889> <-2.996, 1.750, -4.782> <-1.263, 1.750, -5.500> <0.000, 1.750, -5.500> 
		<-4.546, 2.385, -4.546> <-3.653, 2.385, -5.439> <-1.263, 2.385, -6.428> <0.000, 2.385, -6.428> 
		<-5.246, 3.675, -5.246> <-3.988, 3.675, -6.504> <-1.779, 3.675, -7.419> <0.000, 3.675, -7.419> 
		<-5.480, 4.750, -5.480> <-4.222, 4.750, -6.738> <-1.779, 4.750, -7.750> <0.000, 4.750, -7.750> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, 1.750, -5.500> <1.263, 1.750, -5.500> <2.996, 1.750, -4.782> <3.889, 1.750, -3.889> 
		<0.000, 2.385, -6.428> <1.263, 2.385, -6.428> <3.653, 2.385, -5.439> <4.546, 2.385, -4.546> 
		<0.000, 3.675, -7.419> <1.779, 3.675, -7.419> <3.988, 3.675, -6.504> <5.246, 3.675, -5.246> 
		<0.000, 4.750, -7.750> <1.779, 4.750, -7.750> <4.222, 4.750, -6.738> <5.480, 4.750, -5.480> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.480, 4.750, 5.480> <4.222, 4.750, 6.738> <1.779, 4.750, 7.750> <-0.000, 4.750, 7.750> 
		<5.699, 5.756, 5.699> <4.441, 5.756, 6.957> <1.779, 5.756, 8.060> <-0.000, 5.756, 8.060> 
		<5.426, 7.212, 5.426> <4.208, 7.212, 6.643> <1.722, 7.212, 7.673> <-0.000, 7.212, 7.673> 
		<5.303, 8.250, 5.303> <4.086, 8.250, 6.521> <1.722, 8.250, 7.500> <-0.000, 8.250, 7.500> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.000, 4.750, 7.750> <-1.779, 4.750, 7.750> <-4.222, 4.750, 6.738> <-5.480, 4.750, 5.480> 
		<-0.000, 5.756, 8.060> <-1.779, 5.756, 8.060> <-4.441, 5.756, 6.957> <-5.699, 5.756, 5.699> 
		<-0.000, 7.212, 7.673> <-1.722, 7.212, 7.673> <-4.208, 7.212, 6.643> <-5.426, 7.212, 5.426> 
		<-0.000, 8.250, 7.500> <-1.722, 8.250, 7.500> <-4.086, 8.250, 6.521> <-5.303, 8.250, 5.303> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-5.480, 4.750, 5.480> <-6.738, 4.750, 4.222> <-7.750, 4.750, 1.779> <-7.750, 4.750, -0.000> 
		<-5.699, 5.756, 5.699> <-6.957, 5.756, 4.441> <-8.060, 5.756, 1.779> <-8.060, 5.756, -0.000> 
		<-5.426, 7.212, 5.426> <-6.643, 7.212, 4.208> <-7.673, 7.212, 1.722> <-7.673, 7.212, -0.000> 
		<-5.303, 8.250, 5.303> <-6.521, 8.250, 4.086> <-7.500, 8.250, 1.722> <-7.500, 8.250, -0.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-7.750, 4.750, -0.000> <-7.750, 4.750, -1.779> <-6.738, 4.750, -4.222> <-5.480, 4.750, -5.480> 
		<-8.060, 5.756, -0.000> <-8.060, 5.756, -1.779> <-6.957, 5.756, -4.441> <-5.699, 5.756, -5.699> 
		<-7.673, 7.212, -0.000> <-7.673, 7.212, -1.722> <-6.643, 7.212, -4.208> <-5.426, 7.212, -5.426> 
		<-7.500, 8.250, -0.000> <-7.500, 8.250, -1.722> <-6.521, 8.250, -4.086> <-5.303, 8.250, -5.303> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-5.480, 4.750, -5.480> <-4.222, 4.750, -6.738> <-1.779, 4.750, -7.750> <0.000, 4.750, -7.750> 
		<-5.699, 5.756, -5.699> <-4.441, 5.756, -6.957> <-1.779, 5.756, -8.060> <0.000, 5.756, -8.060> 
		<-5.426, 7.212, -5.426> <-4.208, 7.212, -6.643> <-1.722, 7.212, -7.673> <0.000, 7.212, -7.673> 
		<-5.303, 8.250, -5.303> <-4.086, 8.250, -6.521> <-1.722, 8.250, -7.500> <0.000, 8.250, -7.500> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, 4.750, -7.750> <1.779, 4.750, -7.750> <4.222, 4.750, -6.738> <5.480, 4.750, -5.480> 
		<0.000, 5.756, -8.060> <1.779, 5.756, -8.060> <4.441, 5.756, -6.957> <5.699, 5.756, -5.699> 
		<0.000, 7.212, -7.673> <1.722, 7.212, -7.673> <4.208, 7.212, -6.643> <5.426, 7.212, -5.426> 
		<0.000, 8.250, -7.500> <1.722, 8.250, -7.500> <4.086, 8.250, -6.521> <5.303, 8.250, -5.303> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.303, 8.250, 5.303> <4.086, 8.250, 6.521> <1.722, 8.250, 7.500> <-0.000, 8.250, 7.500> 
		<5.212, 9.022, 5.212> <3.995, 9.022, 6.430> <1.722, 9.022, 7.371> <-0.000, 9.022, 7.371> 
		<4.773, 9.967, 4.773> <3.677, 9.967, 5.869> <1.550, 9.967, 6.750> <-0.000, 9.967, 6.750> 
		<4.773, 10.750, 4.773> <3.677, 10.750, 5.869> <1.550, 10.750, 6.750> <-0.000, 10.750, 6.750> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.000, 8.250, 7.500> <-1.722, 8.250, 7.500> <-4.086, 8.250, 6.521> <-5.303, 8.250, 5.303> 
		<-0.000, 9.022, 7.371> <-1.722, 9.022, 7.371> <-3.995, 9.022, 6.430> <-5.212, 9.022, 5.212> 
		<-0.000, 9.967, 6.750> <-1.550, 9.967, 6.750> <-3.677, 9.967, 5.869> <-4.773, 9.967, 4.773> 
		<-0.000, 10.750, 6.750> <-1.550, 10.750, 6.750> <-3.677, 10.750, 5.869> <-4.773, 10.750, 4.773> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-5.303, 8.250, 5.303> <-6.521, 8.250, 4.086> <-7.500, 8.250, 1.722> <-7.500, 8.250, -0.000> 
		<-5.212, 9.022, 5.212> <-6.430, 9.022, 3.995> <-7.371, 9.022, 1.722> <-7.371, 9.022, -0.000> 
		<-4.773, 9.967, 4.773> <-5.869, 9.967, 3.677> <-6.750, 9.967, 1.550> <-6.750, 9.967, -0.000> 
		<-4.773, 10.750, 4.773> <-5.869, 10.750, 3.677> <-6.750, 10.750, 1.550> <-6.750, 10.750, -0.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-7.500, 8.250, -0.000> <-7.500, 8.250, -1.722> <-6.521, 8.250, -4.086> <-5.303, 8.250, -5.303> 
		<-7.371, 9.022, -0.000> <-7.371, 9.022, -1.722> <-6.430, 9.022, -3.995> <-5.212, 9.022, -5.212> 
		<-6.750, 9.967, -0.000> <-6.750, 9.967, -1.550> <-5.869, 9.967, -3.677> <-4.773, 9.967, -4.773> 
		<-6.750, 10.750, -0.000> <-6.750, 10.750, -1.550> <-5.869, 10.750, -3.677> <-4.773, 10.750, -4.773> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-5.303, 8.250, -5.303> <-4.086, 8.250, -6.521> <-1.722, 8.250, -7.500> <0.000, 8.250, -7.500> 
		<-5.212, 9.022, -5.212> <-3.995, 9.022, -6.430> <-1.722, 9.022, -7.371> <0.000, 9.022, -7.371> 
		<-4.773, 9.967, -4.773> <-3.677, 9.967, -5.869> <-1.550, 9.967, -6.750> <0.000, 9.967, -6.750> 
		<-4.773, 10.750, -4.773> <-3.677, 10.750, -5.869> <-1.550, 10.750, -6.750> <0.000, 10.750, -6.750> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, 8.250, -7.500> <1.722, 8.250, -7.500> <4.086, 8.250, -6.521> <5.303, 8.250, -5.303> 
		<0.000, 9.022, -7.371> <1.722, 9.022, -7.371> <3.995, 9.022, -6.430> <5.212, 9.022, -5.212> 
		<0.000, 9.967, -6.750> <1.550, 9.967, -6.750> <3.677, 9.967, -5.869> <4.773, 9.967, -4.773> 
		<0.000, 10.750, -6.750> <1.550, 10.750, -6.750> <3.677, 10.750, -5.869> <4.773, 10.750, -4.773> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.773, 10.750, 4.773> <3.677, 10.750, 5.869> <1.550, 10.750, 6.750> <-0.000, 10.750, 6.750> 
		<4.773, 11.020, 4.773> <3.677, 11.020, 5.869> <1.550, 11.020, 6.750> <-0.000, 11.020, 6.750> 
		<5.112, 11.250, 5.112> <3.894, 11.250, 6.330> <1.722, 11.250, 7.230> <-0.000, 11.250, 7.230> 
		<5.303, 11.250, 5.303> <4.086, 11.250, 6.521> <1.722, 11.250, 7.500> <-0.000, 11.250, 7.500> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.000, 10.750, 6.750> <-1.550, 10.750, 6.750> <-3.677, 10.750, 5.869> <-4.773, 10.750, 4.773> 
		<-0.000, 11.020, 6.750> <-1.550, 11.020, 6.750> <-3.677, 11.020, 5.869> <-4.773, 11.020, 4.773> 
		<-0.000, 11.250, 7.230> <-1.722, 11.250, 7.230> <-3.894, 11.250, 6.330> <-5.112, 11.250, 5.112> 
		<-0.000, 11.250, 7.500> <-1.722, 11.250, 7.500> <-4.086, 11.250, 6.521> <-5.303, 11.250, 5.303> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.773, 10.750, 4.773> <-5.869, 10.750, 3.677> <-6.750, 10.750, 1.550> <-6.750, 10.750, -0.000> 
		<-4.773, 11.020, 4.773> <-5.869, 11.020, 3.677> <-6.750, 11.020, 1.550> <-6.750, 11.020, -0.000> 
		<-5.112, 11.250, 5.112> <-6.330, 11.250, 3.894> <-7.230, 11.250, 1.722> <-7.230, 11.250, -0.000> 
		<-5.303, 11.250, 5.303> <-6.521, 11.250, 4.086> <-7.500, 11.250, 1.722> <-7.500, 11.250, -0.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-6.750, 10.750, -0.000> <-6.750, 10.750, -1.550> <-5.869, 10.750, -3.677> <-4.773, 10.750, -4.773> 
		<-6.750, 11.020, -0.000> <-6.750, 11.020, -1.550> <-5.869, 11.020, -3.677> <-4.773, 11.020, -4.773> 
		<-7.230, 11.250, -0.000> <-7.230, 11.250, -1.722> <-6.330, 11.250, -3.894> <-5.112, 11.250, -5.112> 
		<-7.500, 11.250, -0.000> <-7.500, 11.250, -1.722> <-6.521, 11.250, -4.086> <-5.303, 11.250, -5.303> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.773, 10.750, -4.773> <-3.677, 10.750, -5.869> <-1.550, 10.750, -6.750> <0.000, 10.750, -6.750> 
		<-4.773, 11.020, -4.773> <-3.677, 11.020, -5.869> <-1.550, 11.020, -6.750> <0.000, 11.020, -6.750> 
		<-5.112, 11.250, -5.112> <-3.894, 11.250, -6.330> <-1.722, 11.250, -7.230> <0.000, 11.250, -7.230> 
		<-5.303, 11.250, -5.303> <-4.086, 11.250, -6.521> <-1.722, 11.250, -7.500> <0.000, 11.250, -7.500> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, 10.750, -6.750> <1.550, 10.750, -6.750> <3.677, 10.750, -5.869> <4.773, 10.750, -4.773> 
		<0.000, 11.020, -6.750> <1.550, 11.020, -6.750> <3.677, 11.020, -5.869> <4.773, 11.020, -4.773> 
		<0.000, 11.250, -7.230> <1.722, 11.250, -7.230> <3.894, 11.250, -6.330> <5.112, 11.250, -5.112> 
		<0.000, 11.250, -7.500> <1.722, 11.250, -7.500> <4.086, 11.250, -6.521> <5.303, 11.250, -5.303> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.303, 11.250, 5.303> <4.086, 11.250, 6.521> <1.722, 11.250, 7.500> <-0.000, 11.250, 7.500> 
		<5.495, 11.250, 5.495> <4.277, 11.250, 6.712> <1.722, 11.250, 7.770> <-0.000, 11.250, 7.770> 
		<5.763, 11.148, 5.763> <4.424, 11.148, 7.103> <1.894, 11.148, 8.151> <-0.000, 11.148, 8.151> 
		<5.834, 10.750, 5.834> <4.494, 10.750, 7.173> <1.894, 10.750, 8.250> <-0.000, 10.750, 8.250> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.000, 11.250, 7.500> <-1.722, 11.250, 7.500> <-4.086, 11.250, 6.521> <-5.303, 11.250, 5.303> 
		<-0.000, 11.250, 7.770> <-1.722, 11.250, 7.770> <-4.277, 11.250, 6.712> <-5.495, 11.250, 5.495> 
		<-0.000, 11.148, 8.151> <-1.894, 11.148, 8.151> <-4.424, 11.148, 7.103> <-5.763, 11.148, 5.763> 
		<-0.000, 10.750, 8.250> <-1.894, 10.750, 8.250> <-4.494, 10.750, 7.173> <-5.834, 10.750, 5.834> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-5.303, 11.250, 5.303> <-6.521, 11.250, 4.086> <-7.500, 11.250, 1.722> <-7.500, 11.250, -0.000> 
		<-5.495, 11.250, 5.495> <-6.712, 11.250, 4.277> <-7.770, 11.250, 1.722> <-7.770, 11.250, -0.000> 
		<-5.763, 11.148, 5.763> <-7.103, 11.148, 4.424> <-8.151, 11.148, 1.894> <-8.151, 11.148, -0.000> 
		<-5.834, 10.750, 5.834> <-7.173, 10.750, 4.494> <-8.250, 10.750, 1.894> <-8.250, 10.750, -0.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-7.500, 11.250, -0.000> <-7.500, 11.250, -1.722> <-6.521, 11.250, -4.086> <-5.303, 11.250, -5.303> 
		<-7.770, 11.250, -0.000> <-7.770, 11.250, -1.722> <-6.712, 11.250, -4.277> <-5.495, 11.250, -5.495> 
		<-8.151, 11.148, -0.000> <-8.151, 11.148, -1.894> <-7.103, 11.148, -4.424> <-5.763, 11.148, -5.763> 
		<-8.250, 10.750, -0.000> <-8.250, 10.750, -1.894> <-7.173, 10.750, -4.494> <-5.834, 10.750, -5.834> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-5.303, 11.250, -5.303> <-4.086, 11.250, -6.521> <-1.722, 11.250, -7.500> <0.000, 11.250, -7.500> 
		<-5.495, 11.250, -5.495> <-4.277, 11.250, -6.712> <-1.722, 11.250, -7.770> <0.000, 11.250, -7.770> 
		<-5.763, 11.148, -5.763> <-4.424, 11.148, -7.103> <-1.894, 11.148, -8.151> <0.000, 11.148, -8.151> 
		<-5.834, 10.750, -5.834> <-4.494, 10.750, -7.173> <-1.894, 10.750, -8.250> <0.000, 10.750, -8.250> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, 11.250, -7.500> <1.722, 11.250, -7.500> <4.086, 11.250, -6.521> <5.303, 11.250, -5.303> 
		<0.000, 11.250, -7.770> <1.722, 11.250, -7.770> <4.277, 11.250, -6.712> <5.495, 11.250, -5.495> 
		<0.000, 11.148, -8.151> <1.894, 11.148, -8.151> <4.424, 11.148, -7.103> <5.763, 11.148, -5.763> 
		<0.000, 10.750, -8.250> <1.894, 10.750, -8.250> <4.494, 10.750, -7.173> <5.834, 10.750, -5.834> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.834, 10.750, 5.834> <4.494, 10.750, 7.173> <1.894, 10.750, 8.250> <-0.000, 10.750, 8.250> 
		<5.889, 10.438, 5.889> <4.549, 10.438, 7.228> <1.894, 10.438, 8.328> <-0.000, 10.438, 8.328> 
		<5.475, 10.351, 5.475> <4.216, 10.351, 6.733> <1.779, 10.351, 7.742> <-0.000, 10.351, 7.742> 
		<5.480, 10.250, 5.480> <4.222, 10.250, 6.738> <1.779, 10.250, 7.750> <-0.000, 10.250, 7.750> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.000, 10.750, 8.250> <-1.894, 10.750, 8.250> <-4.494, 10.750, 7.173> <-5.834, 10.750, 5.834> 
		<-0.000, 10.438, 8.328> <-1.894, 10.438, 8.328> <-4.549, 10.438, 7.228> <-5.889, 10.438, 5.889> 
		<-0.000, 10.351, 7.742> <-1.779, 10.351, 7.742> <-4.216, 10.351, 6.733> <-5.475, 10.351, 5.475> 
		<-0.000, 10.250, 7.750> <-1.779, 10.250, 7.750> <-4.222, 10.250, 6.738> <-5.480, 10.250, 5.480> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-5.834, 10.750, 5.834> <-7.173, 10.750, 4.494> <-8.250, 10.750, 1.894> <-8.250, 10.750, -0.000> 
		<-5.889, 10.438, 5.889> <-7.228, 10.438, 4.549> <-8.328, 10.438, 1.894> <-8.328, 10.438, -0.000> 
		<-5.475, 10.351, 5.475> <-6.733, 10.351, 4.216> <-7.742, 10.351, 1.779> <-7.742, 10.351, -0.000> 
		<-5.480, 10.250, 5.480> <-6.738, 10.250, 4.222> <-7.750, 10.250, 1.779> <-7.750, 10.250, -0.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-8.250, 10.750, -0.000> <-8.250, 10.750, -1.894> <-7.173, 10.750, -4.494> <-5.834, 10.750, -5.834> 
		<-8.328, 10.438, -0.000> <-8.328, 10.438, -1.894> <-7.228, 10.438, -4.549> <-5.889, 10.438, -5.889> 
		<-7.742, 10.351, -0.000> <-7.742, 10.351, -1.779> <-6.733, 10.351, -4.216> <-5.475, 10.351, -5.475> 
		<-7.750, 10.250, -0.000> <-7.750, 10.250, -1.779> <-6.738, 10.250, -4.222> <-5.480, 10.250, -5.480> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-5.834, 10.750, -5.834> <-4.494, 10.750, -7.173> <-1.894, 10.750, -8.250> <0.000, 10.750, -8.250> 
		<-5.889, 10.438, -5.889> <-4.549, 10.438, -7.228> <-1.894, 10.438, -8.328> <0.000, 10.438, -8.328> 
		<-5.475, 10.351, -5.475> <-4.216, 10.351, -6.733> <-1.779, 10.351, -7.742> <0.000, 10.351, -7.742> 
		<-5.480, 10.250, -5.480> <-4.222, 10.250, -6.738> <-1.779, 10.250, -7.750> <0.000, 10.250, -7.750> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, 10.750, -8.250> <1.894, 10.750, -8.250> <4.494, 10.750, -7.173> <5.834, 10.750, -5.834> 
		<0.000, 10.438, -8.328> <1.894, 10.438, -8.328> <4.549, 10.438, -7.228> <5.889, 10.438, -5.889> 
		<0.000, 10.351, -7.742> <1.779, 10.351, -7.742> <4.216, 10.351, -6.733> <5.475, 10.351, -5.475> 
		<0.000, 10.250, -7.750> <1.779, 10.250, -7.750> <4.222, 10.250, -6.738> <5.480, 10.250, -5.480> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.480, 10.250, 5.480> <4.222, 10.250, 6.738> <1.779, 10.250, 7.750> <-0.000, 10.250, 7.750> 
		<5.502, 9.843, 5.502> <4.244, 9.843, 6.760> <1.779, 9.843, 7.781> <-0.000, 9.843, 7.781> 
		<5.938, 8.280, 5.938> <4.558, 8.280, 7.319> <1.952, 8.280, 8.398> <-0.000, 8.280, 8.398> 
		<6.010, 7.500, 6.010> <4.630, 7.500, 7.390> <1.952, 7.500, 8.500> <-0.000, 7.500, 8.500> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.000, 10.250, 7.750> <-1.779, 10.250, 7.750> <-4.222, 10.250, 6.738> <-5.480, 10.250, 5.480> 
		<-0.000, 9.843, 7.781> <-1.779, 9.843, 7.781> <-4.244, 9.843, 6.760> <-5.502, 9.843, 5.502> 
		<-0.000, 8.280, 8.398> <-1.952, 8.280, 8.398> <-4.558, 8.280, 7.319> <-5.938, 8.280, 5.938> 
		<-0.000, 7.500, 8.500> <-1.952, 7.500, 8.500> <-4.630, 7.500, 7.390> <-6.010, 7.500, 6.010> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-5.480, 10.250, 5.480> <-6.738, 10.250, 4.222> <-7.750, 10.250, 1.779> <-7.750, 10.250, -0.000> 
		<-5.502, 9.843, 5.502> <-6.760, 9.843, 4.244> <-7.781, 9.843, 1.779> <-7.781, 9.843, -0.000> 
		<-5.938, 8.280, 5.938> <-7.319, 8.280, 4.558> <-8.398, 8.280, 1.952> <-8.398, 8.280, -0.000> 
		<-6.010, 7.500, 6.010> <-7.390, 7.500, 4.630> <-8.500, 7.500, 1.952> <-8.500, 7.500, -0.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-7.750, 10.250, -0.000> <-7.750, 10.250, -1.779> <-6.738, 10.250, -4.222> <-5.480, 10.250, -5.480> 
		<-7.781, 9.843, -0.000> <-7.781, 9.843, -1.779> <-6.760, 9.843, -4.244> <-5.502, 9.843, -5.502> 
		<-8.398, 8.280, -0.000> <-8.398, 8.280, -1.952> <-7.319, 8.280, -4.558> <-5.938, 8.280, -5.938> 
		<-8.500, 7.500, -0.000> <-8.500, 7.500, -1.952> <-7.390, 7.500, -4.630> <-6.010, 7.500, -6.010> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-5.480, 10.250, -5.480> <-4.222, 10.250, -6.738> <-1.779, 10.250, -7.750> <0.000, 10.250, -7.750> 
		<-5.502, 9.843, -5.502> <-4.244, 9.843, -6.760> <-1.779, 9.843, -7.781> <0.000, 9.843, -7.781> 
		<-5.938, 8.280, -5.938> <-4.558, 8.280, -7.319> <-1.952, 8.280, -8.398> <0.000, 8.280, -8.398> 
		<-6.010, 7.500, -6.010> <-4.630, 7.500, -7.390> <-1.952, 7.500, -8.500> <0.000, 7.500, -8.500> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, 10.250, -7.750> <1.779, 10.250, -7.750> <4.222, 10.250, -6.738> <5.480, 10.250, -5.480> 
		<0.000, 9.843, -7.781> <1.779, 9.843, -7.781> <4.244, 9.843, -6.760> <5.502, 9.843, -5.502> 
		<0.000, 8.280, -8.398> <1.952, 8.280, -8.398> <4.558, 8.280, -7.319> <5.938, 8.280, -5.938> 
		<0.000, 7.500, -8.500> <1.952, 7.500, -8.500> <4.630, 7.500, -7.390> <6.010, 7.500, -6.010> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<6.010, 7.500, 6.010> <4.630, 7.500, 7.390> <1.952, 7.500, 8.500> <-0.000, 7.500, 8.500> 
		<6.086, 6.679, 6.086> <4.706, 6.679, 7.466> <1.952, 6.679, 8.607> <-0.000, 6.679, 8.607> 
		<6.206, 5.886, 6.206> <4.826, 5.886, 7.586> <1.952, 5.886, 8.777> <-0.000, 5.886, 8.777> 
		<6.010, 4.500, 6.010> <4.630, 4.500, 7.390> <1.952, 4.500, 8.500> <-0.000, 4.500, 8.500> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.000, 7.500, 8.500> <-1.952, 7.500, 8.500> <-4.630, 7.500, 7.390> <-6.010, 7.500, 6.010> 
		<-0.000, 6.679, 8.607> <-1.952, 6.679, 8.607> <-4.706, 6.679, 7.466> <-6.086, 6.679, 6.086> 
		<-0.000, 5.886, 8.777> <-1.952, 5.886, 8.777> <-4.826, 5.886, 7.586> <-6.206, 5.886, 6.206> 
		<-0.000, 4.500, 8.500> <-1.952, 4.500, 8.500> <-4.630, 4.500, 7.390> <-6.010, 4.500, 6.010> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-6.010, 7.500, 6.010> <-7.390, 7.500, 4.630> <-8.500, 7.500, 1.952> <-8.500, 7.500, -0.000> 
		<-6.086, 6.679, 6.086> <-7.466, 6.679, 4.706> <-8.607, 6.679, 1.952> <-8.607, 6.679, -0.000> 
		<-6.206, 5.886, 6.206> <-7.586, 5.886, 4.826> <-8.777, 5.886, 1.952> <-8.777, 5.886, -0.000> 
		<-6.010, 4.500, 6.010> <-7.390, 4.500, 4.630> <-8.500, 4.500, 1.952> <-8.500, 4.500, -0.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-8.500, 7.500, -0.000> <-8.500, 7.500, -1.952> <-7.390, 7.500, -4.630> <-6.010, 7.500, -6.010> 
		<-8.607, 6.679, -0.000> <-8.607, 6.679, -1.952> <-7.466, 6.679, -4.706> <-6.086, 6.679, -6.086> 
		<-8.777, 5.886, -0.000> <-8.777, 5.886, -1.952> <-7.586, 5.886, -4.826> <-6.206, 5.886, -6.206> 
		<-8.500, 4.500, -0.000> <-8.500, 4.500, -1.952> <-7.390, 4.500, -4.630> <-6.010, 4.500, -6.010> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-6.010, 7.500, -6.010> <-4.630, 7.500, -7.390> <-1.952, 7.500, -8.500> <0.000, 7.500, -8.500> 
		<-6.086, 6.679, -6.086> <-4.706, 6.679, -7.466> <-1.952, 6.679, -8.607> <0.000, 6.679, -8.607> 
		<-6.206, 5.886, -6.206> <-4.826, 5.886, -7.586> <-1.952, 5.886, -8.777> <0.000, 5.886, -8.777> 
		<-6.010, 4.500, -6.010> <-4.630, 4.500, -7.390> <-1.952, 4.500, -8.500> <0.000, 4.500, -8.500> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, 7.500, -8.500> <1.952, 7.500, -8.500> <4.630, 7.500, -7.390> <6.010, 7.500, -6.010> 
		<0.000, 6.679, -8.607> <1.952, 6.679, -8.607> <4.706, 6.679, -7.466> <6.086, 6.679, -6.086> 
		<0.000, 5.886, -8.777> <1.952, 5.886, -8.777> <4.826, 5.886, -7.586> <6.206, 5.886, -6.206> 
		<0.000, 4.500, -8.500> <1.952, 4.500, -8.500> <4.630, 4.500, -7.390> <6.010, 4.500, -6.010> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<6.010, 4.500, 6.010> <4.630, 4.500, 7.390> <1.952, 4.500, 8.500> <-0.000, 4.500, 8.500> 
		<5.864, 3.467, 5.864> <4.484, 3.467, 7.244> <1.952, 3.467, 8.293> <-0.000, 3.467, 8.293> 
		<5.348, 2.588, 5.348> <4.130, 2.588, 6.566> <1.722, 2.588, 7.563> <-0.000, 2.588, 7.563> 
		<5.303, 2.500, 5.303> <4.086, 2.500, 6.521> <1.722, 2.500, 7.500> <-0.000, 2.500, 7.500> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.000, 4.500, 8.500> <-1.952, 4.500, 8.500> <-4.630, 4.500, 7.390> <-6.010, 4.500, 6.010> 
		<-0.000, 3.467, 8.293> <-1.952, 3.467, 8.293> <-4.484, 3.467, 7.244> <-5.864, 3.467, 5.864> 
		<-0.000, 2.588, 7.563> <-1.722, 2.588, 7.563> <-4.130, 2.588, 6.566> <-5.348, 2.588, 5.348> 
		<-0.000, 2.500, 7.500> <-1.722, 2.500, 7.500> <-4.086, 2.500, 6.521> <-5.303, 2.500, 5.303> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-6.010, 4.500, 6.010> <-7.390, 4.500, 4.630> <-8.500, 4.500, 1.952> <-8.500, 4.500, -0.000> 
		<-5.864, 3.467, 5.864> <-7.244, 3.467, 4.484> <-8.293, 3.467, 1.952> <-8.293, 3.467, -0.000> 
		<-5.348, 2.588, 5.348> <-6.566, 2.588, 4.130> <-7.563, 2.588, 1.722> <-7.563, 2.588, -0.000> 
		<-5.303, 2.500, 5.303> <-6.521, 2.500, 4.086> <-7.500, 2.500, 1.722> <-7.500, 2.500, -0.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-8.500, 4.500, -0.000> <-8.500, 4.500, -1.952> <-7.390, 4.500, -4.630> <-6.010, 4.500, -6.010> 
		<-8.293, 3.467, -0.000> <-8.293, 3.467, -1.952> <-7.244, 3.467, -4.484> <-5.864, 3.467, -5.864> 
		<-7.563, 2.588, -0.000> <-7.563, 2.588, -1.722> <-6.566, 2.588, -4.130> <-5.348, 2.588, -5.348> 
		<-7.500, 2.500, -0.000> <-7.500, 2.500, -1.722> <-6.521, 2.500, -4.086> <-5.303, 2.500, -5.303> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-6.010, 4.500, -6.010> <-4.630, 4.500, -7.390> <-1.952, 4.500, -8.500> <0.000, 4.500, -8.500> 
		<-5.864, 3.467, -5.864> <-4.484, 3.467, -7.244> <-1.952, 3.467, -8.293> <0.000, 3.467, -8.293> 
		<-5.348, 2.588, -5.348> <-4.130, 2.588, -6.566> <-1.722, 2.588, -7.563> <0.000, 2.588, -7.563> 
		<-5.303, 2.500, -5.303> <-4.086, 2.500, -6.521> <-1.722, 2.500, -7.500> <0.000, 2.500, -7.500> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, 4.500, -8.500> <1.952, 4.500, -8.500> <4.630, 4.500, -7.390> <6.010, 4.500, -6.010> 
		<0.000, 3.467, -8.293> <1.952, 3.467, -8.293> <4.484, 3.467, -7.244> <5.864, 3.467, -5.864> 
		<0.000, 2.588, -7.563> <1.722, 2.588, -7.563> <4.130, 2.588, -6.566> <5.348, 2.588, -5.348> 
		<0.000, 2.500, -7.500> <1.722, 2.500, -7.500> <4.086, 2.500, -6.521> <5.303, 2.500, -5.303> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.303, 2.500, 5.303> <4.086, 2.500, 6.521> <1.722, 2.500, 7.500> <-0.000, 2.500, 7.500> 
		<5.261, 2.416, 5.261> <4.043, 2.416, 6.479> <1.722, 2.416, 7.440> <-0.000, 2.416, 7.440> 
		<4.696, 1.570, 4.696> <3.722, 1.570, 5.670> <1.378, 1.570, 6.642> <-0.000, 1.570, 6.642> 
		<4.243, 1.000, 4.243> <3.268, 1.000, 5.217> <1.378, 1.000, 6.000> <-0.000, 1.000, 6.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.000, 2.500, 7.500> <-1.722, 2.500, 7.500> <-4.086, 2.500, 6.521> <-5.303, 2.500, 5.303> 
		<-0.000, 2.416, 7.440> <-1.722, 2.416, 7.440> <-4.043, 2.416, 6.479> <-5.261, 2.416, 5.261> 
		<-0.000, 1.570, 6.642> <-1.378, 1.570, 6.642> <-3.722, 1.570, 5.670> <-4.696, 1.570, 4.696> 
		<-0.000, 1.000, 6.000> <-1.378, 1.000, 6.000> <-3.268, 1.000, 5.217> <-4.243, 1.000, 4.243> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-5.303, 2.500, 5.303> <-6.521, 2.500, 4.086> <-7.500, 2.500, 1.722> <-7.500, 2.500, -0.000> 
		<-5.261, 2.416, 5.261> <-6.479, 2.416, 4.043> <-7.440, 2.416, 1.722> <-7.440, 2.416, -0.000> 
		<-4.696, 1.570, 4.696> <-5.670, 1.570, 3.722> <-6.642, 1.570, 1.378> <-6.642, 1.570, -0.000> 
		<-4.243, 1.000, 4.243> <-5.217, 1.000, 3.268> <-6.000, 1.000, 1.378> <-6.000, 1.000, -0.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-7.500, 2.500, -0.000> <-7.500, 2.500, -1.722> <-6.521, 2.500, -4.086> <-5.303, 2.500, -5.303> 
		<-7.440, 2.416, -0.000> <-7.440, 2.416, -1.722> <-6.479, 2.416, -4.043> <-5.261, 2.416, -5.261> 
		<-6.642, 1.570, -0.000> <-6.642, 1.570, -1.378> <-5.670, 1.570, -3.722> <-4.696, 1.570, -4.696> 
		<-6.000, 1.000, -0.000> <-6.000, 1.000, -1.378> <-5.217, 1.000, -3.268> <-4.243, 1.000, -4.243> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-5.303, 2.500, -5.303> <-4.086, 2.500, -6.521> <-1.722, 2.500, -7.500> <0.000, 2.500, -7.500> 
		<-5.261, 2.416, -5.261> <-4.043, 2.416, -6.479> <-1.722, 2.416, -7.440> <0.000, 2.416, -7.440> 
		<-4.696, 1.570, -4.696> <-3.722, 1.570, -5.670> <-1.378, 1.570, -6.642> <0.000, 1.570, -6.642> 
		<-4.243, 1.000, -4.243> <-3.268, 1.000, -5.217> <-1.378, 1.000, -6.000> <0.000, 1.000, -6.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, 2.500, -7.500> <1.722, 2.500, -7.500> <4.086, 2.500, -6.521> <5.303, 2.500, -5.303> 
		<0.000, 2.416, -7.440> <1.722, 2.416, -7.440> <4.043, 2.416, -6.479> <5.261, 2.416, -5.261> 
		<0.000, 1.570, -6.642> <1.378, 1.570, -6.642> <3.722, 1.570, -5.670> <4.696, 1.570, -4.696> 
		<0.000, 1.000, -6.000> <1.378, 1.000, -6.000> <3.268, 1.000, -5.217> <4.243, 1.000, -4.243> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.243, 1.000, 4.243> <3.268, 1.000, 5.217> <1.378, 1.000, 6.000> <-0.000, 1.000, 6.000> 
		<4.050, 0.758, 4.050> <3.076, 0.758, 5.024> <1.378, 0.758, 5.727> <-0.000, 0.758, 5.727> 
		<3.871, 0.650, 3.871> <3.019, 0.650, 4.724> <1.205, 0.650, 5.475> <-0.000, 0.650, 5.475> 
		<3.712, 0.500, 3.712> <2.860, 0.500, 4.565> <1.205, 0.500, 5.250> <-0.000, 0.500, 5.250> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.000, 1.000, 6.000> <-1.378, 1.000, 6.000> <-3.268, 1.000, 5.217> <-4.243, 1.000, 4.243> 
		<-0.000, 0.758, 5.727> <-1.378, 0.758, 5.727> <-3.076, 0.758, 5.024> <-4.050, 0.758, 4.050> 
		<-0.000, 0.650, 5.475> <-1.205, 0.650, 5.475> <-3.019, 0.650, 4.724> <-3.871, 0.650, 3.871> 
		<-0.000, 0.500, 5.250> <-1.205, 0.500, 5.250> <-2.860, 0.500, 4.565> <-3.712, 0.500, 3.712> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.243, 1.000, 4.243> <-5.217, 1.000, 3.268> <-6.000, 1.000, 1.378> <-6.000, 1.000, -0.000> 
		<-4.050, 0.758, 4.050> <-5.024, 0.758, 3.076> <-5.727, 0.758, 1.378> <-5.727, 0.758, -0.000> 
		<-3.871, 0.650, 3.871> <-4.724, 0.650, 3.019> <-5.475, 0.650, 1.205> <-5.475, 0.650, -0.000> 
		<-3.712, 0.500, 3.712> <-4.565, 0.500, 2.860> <-5.250, 0.500, 1.205> <-5.250, 0.500, -0.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-6.000, 1.000, -0.000> <-6.000, 1.000, -1.378> <-5.217, 1.000, -3.268> <-4.243, 1.000, -4.243> 
		<-5.727, 0.758, -0.000> <-5.727, 0.758, -1.378> <-5.024, 0.758, -3.076> <-4.050, 0.758, -4.050> 
		<-5.475, 0.650, -0.000> <-5.475, 0.650, -1.205> <-4.724, 0.650, -3.019> <-3.871, 0.650, -3.871> 
		<-5.250, 0.500, -0.000> <-5.250, 0.500, -1.205> <-4.565, 0.500, -2.860> <-3.712, 0.500, -3.712> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-4.243, 1.000, -4.243> <-3.268, 1.000, -5.217> <-1.378, 1.000, -6.000> <0.000, 1.000, -6.000> 
		<-4.050, 0.758, -4.050> <-3.076, 0.758, -5.024> <-1.378, 0.758, -5.727> <0.000, 0.758, -5.727> 
		<-3.871, 0.650, -3.871> <-3.019, 0.650, -4.724> <-1.205, 0.650, -5.475> <0.000, 0.650, -5.475> 
		<-3.712, 0.500, -3.712> <-2.860, 0.500, -4.565> <-1.205, 0.500, -5.250> <0.000, 0.500, -5.250> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, 1.000, -6.000> <1.378, 1.000, -6.000> <3.268, 1.000, -5.217> <4.243, 1.000, -4.243> 
		<0.000, 0.758, -5.727> <1.378, 0.758, -5.727> <3.076, 0.758, -5.024> <4.050, 0.758, -4.050> 
		<0.000, 0.650, -5.475> <1.205, 0.650, -5.475> <3.019, 0.650, -4.724> <3.871, 0.650, -3.871> 
		<0.000, 0.500, -5.250> <1.205, 0.500, -5.250> <2.860, 0.500, -4.565> <3.712, 0.500, -3.712> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.712, 0.500, 3.712> <2.860, 0.500, 4.565> <1.205, 0.500, 5.250> <-0.000, 0.500, 5.250> 
		<3.765, 0.350, 3.765> <2.913, 0.350, 4.618> <1.205, 0.350, 5.325> <-0.000, 0.350, 5.325> 
		<3.942, 0.150, 3.942> <3.049, 0.150, 4.835> <1.263, 0.150, 5.575> <-0.000, 0.150, 5.575> 
		<3.889, 0.000, 3.889> <2.996, 0.000, 4.782> <1.263, 0.000, 5.500> <-0.000, 0.000, 5.500> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.000, 0.500, 5.250> <-1.205, 0.500, 5.250> <-2.860, 0.500, 4.565> <-3.712, 0.500, 3.712> 
		<-0.000, 0.350, 5.325> <-1.205, 0.350, 5.325> <-2.913, 0.350, 4.618> <-3.765, 0.350, 3.765> 
		<-0.000, 0.150, 5.575> <-1.263, 0.150, 5.575> <-3.049, 0.150, 4.835> <-3.942, 0.150, 3.942> 
		<-0.000, 0.000, 5.500> <-1.263, 0.000, 5.500> <-2.996, 0.000, 4.782> <-3.889, 0.000, 3.889> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.712, 0.500, 3.712> <-4.565, 0.500, 2.860> <-5.250, 0.500, 1.205> <-5.250, 0.500, -0.000> 
		<-3.765, 0.350, 3.765> <-4.618, 0.350, 2.913> <-5.325, 0.350, 1.205> <-5.325, 0.350, -0.000> 
		<-3.942, 0.150, 3.942> <-4.835, 0.150, 3.049> <-5.575, 0.150, 1.263> <-5.575, 0.150, -0.000> 
		<-3.889, 0.000, 3.889> <-4.782, 0.000, 2.996> <-5.500, 0.000, 1.263> <-5.500, 0.000, -0.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-5.250, 0.500, -0.000> <-5.250, 0.500, -1.205> <-4.565, 0.500, -2.860> <-3.712, 0.500, -3.712> 
		<-5.325, 0.350, -0.000> <-5.325, 0.350, -1.205> <-4.618, 0.350, -2.913> <-3.765, 0.350, -3.765> 
		<-5.575, 0.150, -0.000> <-5.575, 0.150, -1.263> <-4.835, 0.150, -3.049> <-3.942, 0.150, -3.942> 
		<-5.500, 0.000, -0.000> <-5.500, 0.000, -1.263> <-4.782, 0.000, -2.996> <-3.889, 0.000, -3.889> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.712, 0.500, -3.712> <-2.860, 0.500, -4.565> <-1.205, 0.500, -5.250> <0.000, 0.500, -5.250> 
		<-3.765, 0.350, -3.765> <-2.913, 0.350, -4.618> <-1.205, 0.350, -5.325> <0.000, 0.350, -5.325> 
		<-3.942, 0.150, -3.942> <-3.049, 0.150, -4.835> <-1.263, 0.150, -5.575> <0.000, 0.150, -5.575> 
		<-3.889, 0.000, -3.889> <-2.996, 0.000, -4.782> <-1.263, 0.000, -5.500> <0.000, 0.000, -5.500> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, 0.500, -5.250> <1.205, 0.500, -5.250> <2.860, 0.500, -4.565> <3.712, 0.500, -3.712> 
		<0.000, 0.350, -5.325> <1.205, 0.350, -5.325> <2.913, 0.350, -4.618> <3.765, 0.350, -3.765> 
		<0.000, 0.150, -5.575> <1.263, 0.150, -5.575> <3.049, 0.150, -4.835> <3.942, 0.150, -3.942> 
		<0.000, 0.000, -5.500> <1.263, 0.000, -5.500> <2.996, 0.000, -4.782> <3.889, 0.000, -3.889> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.889, 0.000, 3.889> <2.996, 0.000, 4.782> <1.263, 0.000, 5.500> <-0.000, 0.000, 5.500> 
		<3.842, -0.134, 3.842> <2.949, -0.134, 4.735> <1.263, -0.134, 5.433> <-0.000, -0.134, 5.433> 
		<3.642, 0.000, 3.642> <2.830, 0.000, 4.453> <1.148, 0.000, 5.150> <-0.000, 0.000, 5.150> 
		<3.536, 0.000, 3.536> <2.724, 0.000, 4.347> <1.148, 0.000, 5.000> <-0.000, 0.000, 5.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.000, 0.000, 5.500> <-1.263, 0.000, 5.500> <-2.996, 0.000, 4.782> <-3.889, 0.000, 3.889> 
		<-0.000, -0.134, 5.433> <-1.263, -0.134, 5.433> <-2.949, -0.134, 4.735> <-3.842, -0.134, 3.842> 
		<-0.000, 0.000, 5.150> <-1.148, 0.000, 5.150> <-2.830, 0.000, 4.453> <-3.642, 0.000, 3.642> 
		<-0.000, 0.000, 5.000> <-1.148, 0.000, 5.000> <-2.724, 0.000, 4.347> <-3.536, 0.000, 3.536> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.889, 0.000, 3.889> <-4.782, 0.000, 2.996> <-5.500, 0.000, 1.263> <-5.500, 0.000, -0.000> 
		<-3.842, -0.134, 3.842> <-4.735, -0.134, 2.949> <-5.433, -0.134, 1.263> <-5.433, -0.134, -0.000> 
		<-3.642, 0.000, 3.642> <-4.453, 0.000, 2.830> <-5.150, 0.000, 1.148> <-5.150, 0.000, -0.000> 
		<-3.536, 0.000, 3.536> <-4.347, 0.000, 2.724> <-5.000, 0.000, 1.148> <-5.000, 0.000, -0.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-5.500, 0.000, -0.000> <-5.500, 0.000, -1.263> <-4.782, 0.000, -2.996> <-3.889, 0.000, -3.889> 
		<-5.433, -0.134, -0.000> <-5.433, -0.134, -1.263> <-4.735, -0.134, -2.949> <-3.842, -0.134, -3.842> 
		<-5.150, 0.000, -0.000> <-5.150, 0.000, -1.148> <-4.453, 0.000, -2.830> <-3.642, 0.000, -3.642> 
		<-5.000, 0.000, -0.000> <-5.000, 0.000, -1.148> <-4.347, 0.000, -2.724> <-3.536, 0.000, -3.536> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.889, 0.000, -3.889> <-2.996, 0.000, -4.782> <-1.263, 0.000, -5.500> <0.000, 0.000, -5.500> 
		<-3.842, -0.134, -3.842> <-2.949, -0.134, -4.735> <-1.263, -0.134, -5.433> <0.000, -0.134, -5.433> 
		<-3.642, 0.000, -3.642> <-2.830, 0.000, -4.453> <-1.148, 0.000, -5.150> <0.000, 0.000, -5.150> 
		<-3.536, 0.000, -3.536> <-2.724, 0.000, -4.347> <-1.148, 0.000, -5.000> <0.000, 0.000, -5.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, 0.000, -5.500> <1.263, 0.000, -5.500> <2.996, 0.000, -4.782> <3.889, 0.000, -3.889> 
		<0.000, -0.134, -5.433> <1.263, -0.134, -5.433> <2.949, -0.134, -4.735> <3.842, -0.134, -3.842> 
		<0.000, 0.000, -5.150> <1.148, 0.000, -5.150> <2.830, 0.000, -4.453> <3.642, 0.000, -3.642> 
		<0.000, 0.000, -5.000> <1.148, 0.000, -5.000> <2.724, 0.000, -4.347> <3.536, 0.000, -3.536> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.536, 0.000, 3.536> <2.724, 0.000, 4.347> <1.148, 0.000, 5.000> <-0.000, 0.000, 5.000> 
		<2.475, 0.000, 2.475> <1.663, 0.000, 3.287> <1.148, 0.000, 3.500> <-0.000, 0.000, 3.500> 
		<1.061, 0.000, 1.061> <1.061, 0.000, 1.061> <-0.000, 0.000, 1.500> <-0.000, 0.000, 1.500> 
		<0.000, 0.000, 0.000> <0.000, 0.000, 0.000> <0.000, 0.000, 0.000> <0.000, 0.000, 0.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.000, 0.000, 5.000> <-1.148, 0.000, 5.000> <-2.724, 0.000, 4.347> <-3.536, 0.000, 3.536> 
		<-0.000, 0.000, 3.500> <-1.148, 0.000, 3.500> <-1.663, 0.000, 3.287> <-2.475, 0.000, 2.475> 
		<-0.000, 0.000, 1.500> <-0.000, 0.000, 1.500> <-1.061, 0.000, 1.061> <-1.061, 0.000, 1.061> 
		<0.000, 0.000, 0.000> <0.000, 0.000, 0.000> <0.000, 0.000, 0.000> <0.000, 0.000, 0.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.536, 0.000, 3.536> <-4.347, 0.000, 2.724> <-5.000, 0.000, 1.148> <-5.000, 0.000, -0.000> 
		<-2.475, 0.000, 2.475> <-3.287, 0.000, 1.663> <-3.500, 0.000, 1.148> <-3.500, 0.000, -0.000> 
		<-1.061, 0.000, 1.061> <-1.061, 0.000, 1.061> <-1.500, 0.000, -0.000> <-1.500, 0.000, -0.000> 
		<0.000, 0.000, 0.000> <0.000, 0.000, 0.000> <0.000, 0.000, 0.000> <0.000, 0.000, 0.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-5.000, 0.000, -0.000> <-5.000, 0.000, -1.148> <-4.347, 0.000, -2.724> <-3.536, 0.000, -3.536> 
		<-3.500, 0.000, -0.000> <-3.500, 0.000, -1.148> <-3.287, 0.000, -1.663> <-2.475, 0.000, -2.475> 
		<-1.500, 0.000, -0.000> <-1.500, 0.000, -0.000> <-1.061, 0.000, -1.061> <-1.061, 0.000, -1.061> 
		<0.000, 0.000, 0.000> <0.000, 0.000, 0.000> <0.000, 0.000, 0.000> <0.000, 0.000, 0.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.536, 0.000, -3.536> <-2.724, 0.000, -4.347> <-1.148, 0.000, -5.000> <0.000, 0.000, -5.000> 
		<-2.475, 0.000, -2.475> <-1.663, 0.000, -3.287> <-1.148, 0.000, -3.500> <0.000, 0.000, -3.500> 
		<-1.061, 0.000, -1.061> <-1.061, 0.000, -1.061> <0.000, 0.000, -1.500> <0.000, 0.000, -1.500> 
		<0.000, 0.000, 0.000> <0.000, 0.000, 0.000> <0.000, 0.000, 0.000> <0.000, 0.000, 0.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, 0.000, -5.000> <1.148, 0.000, -5.000> <2.724, 0.000, -4.347> <3.536, 0.000, -3.536> 
		<0.000, 0.000, -3.500> <1.148, 0.000, -3.500> <1.663, 0.000, -3.287> <2.475, 0.000, -2.475> 
		<0.000, 0.000, -1.500> <0.000, 0.000, -1.500> <1.061, 0.000, -1.061> <1.061, 0.000, -1.061> 
		<0.000, 0.000, 0.000> <0.000, 0.000, 0.000> <0.000, 0.000, 0.000> <0.000, 0.000, 0.000> 
	}
#local N1 = normal { granite .08 scale .1 }
#local N2 = normal {
	gradient y
	scale 12
	normal_map {
		[.25 bumps 0]
		[.35 radial .1 sine_wave frequency 40 ]
		[.65 radial .1 sine_wave frequency 40 ]
		[.75 bumps 0]
	}
}
	texture {
		pigment { color rgb <1.000,0.995,0.950> }
		normal { average normal_map {[1 N1][1 N2]} }
		finish { phong 0.2 phong_size 30 specular .2 roughness .005 }
	}
	texture {
		pigment {
			gradient y
			scale 12
			warp { turbulence .1 octaves 2 lambda 2 }
			scale <.1, 1, .1>
			color_map {
				[.63 color rgbf 1  ]
				[.73 color rgb <0.263,0.561,0.796> ]
				[.75 color rgb <0.263,0.561,0.796> ]
				[.75 color rgbf 1  ]
			}
		}
	}
	texture {
		pigment {
			pigment_pattern {
				image_map { tga "lys" once }
				warp { repeat 2*x }
				scale <1/16, 3*2*pi/6, 1>
				translate 4*y
				warp { cylindrical }
			}
			color_map {
				[.2 color rgbf 1 ]
				[.2 color rgb <0.263,0.561,0.796>]
			}
		}
	}
	texture {
		pigment {
			wrinkles
			color_map {
				[0.0 Tan filter 0.3]
				[0.8 Clear]
				[1.0 Clear]
			}
			scale 2
		}
		normal {
			crackle
			turbulence .3
			scale 10
			slope_map {
				[0.010 <0, 3>]
				[0.015 <1, 3>]
				[0.015 <1, 0>]
			}
		}
	}
}
// Layer 2
union {
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.750, 2.300, 6.739> <-0.750, 2.650, 7.322> <-0.750, 3.225, 8.046> <-0.750, 3.467, 8.681> 
		<-0.972, 2.201, 6.688> <-0.972, 2.552, 7.270> <-0.972, 3.139, 8.116> <-0.972, 3.381, 8.751> 
		<-0.853, 1.680, 6.416> <-0.853, 2.056, 7.245> <-0.853, 2.642, 8.258> <-0.853, 2.926, 9.123> 
		<-0.750, 1.635, 6.392> <-0.750, 2.010, 7.221> <-0.750, 2.603, 8.291> <-0.750, 2.886, 9.156> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.750, 2.300, 6.739> <-0.306, 2.497, 6.842> <0.380, 2.464, 6.824> <0.750, 2.300, 6.739> 
		<-0.750, 2.650, 7.322> <-0.306, 2.847, 7.424> <0.380, 2.814, 7.407> <0.750, 2.650, 7.322> 
		<-0.750, 3.225, 8.046> <-0.306, 3.397, 7.906> <0.380, 3.368, 7.929> <0.750, 3.225, 8.046> 
		<-0.750, 3.467, 8.681> <-0.306, 3.639, 8.541> <0.380, 3.611, 8.564> <0.750, 3.467, 8.681> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.750, 2.300, 6.739> <0.935, 2.218, 6.696> <0.919, 1.709, 6.431> <0.750, 1.635, 6.392> 
		<0.750, 2.650, 7.322> <0.935, 2.568, 7.279> <0.919, 2.085, 7.260> <0.750, 2.010, 7.221> 
		<0.750, 3.225, 8.046> <0.935, 3.153, 8.104> <0.919, 2.668, 8.238> <0.750, 2.603, 8.291> 
		<0.750, 3.467, 8.681> <0.935, 3.396, 8.740> <0.919, 2.952, 9.102> <0.750, 2.886, 9.156> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.750, 1.635, 6.392> <0.413, 1.485, 6.314> <-0.544, 1.543, 6.345> <-0.750, 1.635, 6.392> 
		<0.750, 2.010, 7.221> <0.413, 1.861, 7.143> <-0.544, 1.919, 7.174> <-0.750, 2.010, 7.221> 
		<0.750, 2.603, 8.291> <0.413, 2.472, 8.397> <-0.544, 2.523, 8.356> <-0.750, 2.603, 8.291> 
		<0.750, 2.886, 9.156> <0.413, 2.756, 9.262> <-0.544, 2.807, 9.221> <-0.750, 2.886, 9.156> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.750, 3.467, 8.681> <-0.750, 3.659, 9.184> <-0.750, 3.543, 9.949> <-0.750, 3.719, 10.458> 
		<-0.972, 3.381, 8.751> <-0.972, 3.573, 9.254> <-0.972, 3.453, 10.015> <-0.972, 3.629, 10.524> 
		<-0.853, 2.926, 9.123> <-0.853, 3.091, 9.626> <-0.853, 2.958, 10.383> <-0.853, 3.157, 10.873> 
		<-0.750, 2.886, 9.156> <-0.750, 3.051, 9.658> <-0.750, 2.916, 10.414> <-0.750, 3.116, 10.904> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.750, 3.467, 8.681> <-0.306, 3.639, 8.541> <0.380, 3.611, 8.564> <0.750, 3.467, 8.681> 
		<-0.750, 3.659, 9.184> <-0.306, 3.831, 9.044> <0.380, 3.803, 9.067> <0.750, 3.659, 9.184> 
		<-0.750, 3.543, 9.949> <-0.306, 3.721, 9.817> <0.380, 3.691, 9.839> <0.750, 3.543, 9.949> 
		<-0.750, 3.719, 10.458> <-0.306, 3.897, 10.326> <0.380, 3.867, 10.348> <0.750, 3.719, 10.458> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.750, 3.467, 8.681> <0.935, 3.396, 8.740> <0.919, 2.952, 9.102> <0.750, 2.886, 9.156> 
		<0.750, 3.659, 9.184> <0.935, 3.588, 9.243> <0.919, 3.117, 9.605> <0.750, 3.051, 9.658> 
		<0.750, 3.543, 9.949> <0.935, 3.468, 10.004> <0.919, 2.984, 10.364> <0.750, 2.916, 10.414> 
		<0.750, 3.719, 10.458> <0.935, 3.644, 10.513> <0.919, 3.183, 10.854> <0.750, 3.116, 10.904> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.750, 2.886, 9.156> <0.413, 2.756, 9.262> <-0.544, 2.807, 9.221> <-0.750, 2.886, 9.156> 
		<0.750, 3.051, 9.658> <0.413, 2.921, 9.765> <-0.544, 2.972, 9.723> <-0.750, 3.051, 9.658> 
		<0.750, 2.916, 10.414> <0.413, 2.781, 10.514> <-0.544, 2.834, 10.475> <-0.750, 2.916, 10.414> 
		<0.750, 3.116, 10.904> <0.413, 2.980, 11.004> <-0.544, 3.033, 10.965> <-0.750, 3.116, 10.904> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.750, 3.719, 10.458> <-0.750, 3.890, 10.952> <-0.750, 4.128, 11.743> <-0.750, 4.603, 11.961> 
		<-0.972, 3.629, 10.524> <-0.972, 3.801, 11.018> <-0.972, 4.084, 11.845> <-0.972, 4.560, 12.063> 
		<-0.853, 3.157, 10.873> <-0.853, 3.396, 11.461> <-0.853, 3.749, 12.343> <-0.853, 4.328, 12.603> 
		<-0.750, 3.116, 10.904> <-0.750, 3.355, 11.491> <-0.750, 3.729, 12.390> <-0.750, 4.308, 12.651> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.750, 3.719, 10.458> <-0.306, 3.897, 10.326> <0.380, 3.867, 10.348> <0.750, 3.719, 10.458> 
		<-0.750, 3.890, 10.952> <-0.306, 4.068, 10.820> <0.380, 4.039, 10.842> <0.750, 3.890, 10.952> 
		<-0.750, 4.128, 11.743> <-0.306, 4.215, 11.539> <0.380, 4.201, 11.573> <0.750, 4.128, 11.743> 
		<-0.750, 4.603, 11.961> <-0.306, 4.691, 11.758> <0.380, 4.676, 11.792> <0.750, 4.603, 11.961> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.750, 3.719, 10.458> <0.935, 3.644, 10.513> <0.919, 3.183, 10.854> <0.750, 3.116, 10.904> 
		<0.750, 3.890, 10.952> <0.935, 3.816, 11.007> <0.919, 3.422, 11.441> <0.750, 3.355, 11.491> 
		<0.750, 4.128, 11.743> <0.935, 4.091, 11.828> <0.919, 3.762, 12.313> <0.750, 3.729, 12.390> 
		<0.750, 4.603, 11.961> <0.935, 4.567, 12.046> <0.919, 4.341, 12.573> <0.750, 4.308, 12.651> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.750, 3.116, 10.904> <0.413, 2.980, 11.004> <-0.544, 3.033, 10.965> <-0.750, 3.116, 10.904> 
		<0.750, 3.355, 11.491> <0.413, 3.219, 11.592> <-0.544, 3.272, 11.553> <-0.750, 3.355, 11.491> 
		<0.750, 3.729, 12.390> <0.413, 3.663, 12.545> <-0.544, 3.688, 12.485> <-0.750, 3.729, 12.390> 
		<0.750, 4.308, 12.651> <0.413, 4.241, 12.806> <-0.544, 4.267, 12.745> <-0.750, 4.308, 12.651> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.750, 4.603, 11.961> <-0.750, 5.468, 12.358> <-0.750, 6.805, 12.317> <-0.750, 7.756, 12.310> 
		<-0.972, 4.560, 12.063> <-0.972, 5.425, 12.460> <-0.972, 6.824, 12.427> <-0.972, 7.775, 12.419> 
		<-0.853, 4.328, 12.603> <-0.853, 5.312, 13.046> <-0.853, 6.805, 12.858> <-0.853, 7.875, 12.998> 
		<-0.750, 4.308, 12.651> <-0.750, 5.292, 13.094> <-0.750, 6.814, 12.908> <-0.750, 7.884, 13.049> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.750, 4.603, 11.961> <-0.306, 4.691, 11.758> <0.380, 4.676, 11.792> <0.750, 4.603, 11.961> 
		<-0.750, 5.468, 12.358> <-0.306, 5.556, 12.154> <0.380, 5.541, 12.188> <0.750, 5.468, 12.358> 
		<-0.750, 6.805, 12.317> <-0.306, 6.767, 12.099> <0.380, 6.773, 12.135> <0.750, 6.805, 12.317> 
		<-0.750, 7.756, 12.310> <-0.306, 7.718, 12.091> <0.380, 7.725, 12.128> <0.750, 7.756, 12.310> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.750, 4.603, 11.961> <0.935, 4.567, 12.046> <0.919, 4.341, 12.573> <0.750, 4.308, 12.651> 
		<0.750, 5.468, 12.358> <0.935, 5.432, 12.443> <0.919, 5.325, 13.016> <0.750, 5.292, 13.094> 
		<0.750, 6.805, 12.317> <0.935, 6.820, 12.409> <0.919, 6.799, 12.825> <0.750, 6.814, 12.908> 
		<0.750, 7.756, 12.310> <0.935, 7.772, 12.401> <0.919, 7.870, 12.966> <0.750, 7.884, 13.049> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.750, 4.308, 12.651> <0.413, 4.241, 12.806> <-0.544, 4.267, 12.745> <-0.750, 4.308, 12.651> 
		<0.750, 5.292, 13.094> <0.413, 5.226, 13.248> <-0.544, 5.252, 13.188> <-0.750, 5.292, 13.094> 
		<0.750, 6.814, 12.908> <0.413, 6.842, 13.074> <-0.544, 6.831, 13.010> <-0.750, 6.814, 12.908> 
		<0.750, 7.884, 13.049> <0.413, 7.913, 13.215> <-0.544, 7.901, 13.150> <-0.750, 7.884, 13.049> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.750, 7.756, 12.310> <-0.750, 7.962, 12.308> <-0.750, 8.262, 12.127> <-0.750, 8.327, 11.932> 
		<-0.972, 7.775, 12.419> <-0.972, 7.981, 12.418> <-1.100, 8.419, 12.439> <-1.100, 8.484, 12.244> 
		<-0.853, 7.875, 12.998> <-0.853, 8.213, 13.043> <-0.805, 8.886, 13.426> <-0.805, 8.974, 13.218> 
		<-0.750, 7.884, 13.049> <-0.750, 8.222, 13.093> <-0.750, 8.911, 13.475> <-0.750, 8.999, 13.267> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.750, 7.756, 12.310> <-0.306, 7.718, 12.091> <0.380, 7.725, 12.128> <0.750, 7.756, 12.310> 
		<-0.750, 7.962, 12.308> <-0.306, 7.924, 12.090> <0.380, 7.930, 12.126> <0.750, 7.962, 12.308> 
		<-0.750, 8.262, 12.127> <-0.398, 8.105, 11.814> <0.457, 8.131, 11.867> <0.750, 8.262, 12.127> 
		<-0.750, 8.327, 11.932> <-0.398, 8.170, 11.620> <0.457, 8.196, 11.672> <0.750, 8.327, 11.932> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.750, 7.756, 12.310> <0.935, 7.772, 12.401> <0.919, 7.870, 12.966> <0.750, 7.884, 13.049> 
		<0.750, 7.962, 12.308> <0.935, 7.977, 12.400> <0.919, 8.207, 13.010> <0.750, 8.222, 13.093> 
		<0.750, 8.262, 12.127> <1.042, 8.393, 12.387> <0.909, 8.840, 13.334> <0.750, 8.911, 13.475> 
		<0.750, 8.327, 11.932> <1.042, 8.458, 12.192> <0.909, 8.928, 13.126> <0.750, 8.999, 13.267> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.750, 7.884, 13.049> <0.413, 7.913, 13.215> <-0.544, 7.901, 13.150> <-0.750, 7.884, 13.049> 
		<0.750, 8.222, 13.093> <0.413, 8.251, 13.260> <-0.544, 8.239, 13.195> <-0.750, 8.222, 13.093> 
		<0.750, 8.911, 13.475> <0.591, 8.982, 13.617> <-0.695, 8.935, 13.524> <-0.750, 8.911, 13.475> 
		<0.750, 8.999, 13.267> <0.591, 9.070, 13.409> <-0.695, 9.023, 13.316> <-0.750, 8.999, 13.267> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.750, 8.327, 11.932> <-0.750, 8.518, 11.361> <-0.750, 8.590, 10.538> <-0.750, 8.548, 9.937> 
		<-1.100, 8.484, 12.244> <-1.100, 8.675, 11.673> <-0.972, 8.698, 10.512> <-0.972, 8.656, 9.911> 
		<-0.805, 8.974, 13.218> <-0.805, 9.247, 12.575> <-0.853, 9.270, 10.828> <-0.853, 9.228, 9.775> 
		<-0.750, 8.999, 13.267> <-0.750, 9.271, 12.624> <-0.750, 9.320, 10.817> <-0.750, 9.278, 9.763> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.750, 8.327, 11.932> <-0.398, 8.170, 11.620> <0.457, 8.196, 11.672> <0.750, 8.327, 11.932> 
		<-0.750, 8.518, 11.361> <-0.398, 8.361, 11.048> <0.457, 8.387, 11.100> <0.750, 8.518, 11.361> 
		<-0.750, 8.590, 10.538> <-0.306, 8.374, 10.589> <0.380, 8.410, 10.581> <0.750, 8.590, 10.538> 
		<-0.750, 8.548, 9.937> <-0.306, 8.332, 9.988> <0.380, 8.368, 9.980> <0.750, 8.548, 9.937> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.750, 8.327, 11.932> <1.042, 8.458, 12.192> <0.909, 8.928, 13.126> <0.750, 8.999, 13.267> 
		<0.750, 8.518, 11.361> <1.042, 8.649, 11.621> <0.909, 9.200, 12.483> <0.750, 9.271, 12.624> 
		<0.750, 8.590, 10.538> <0.935, 8.680, 10.516> <0.919, 9.238, 10.836> <0.750, 9.320, 10.817> 
		<0.750, 8.548, 9.937> <0.935, 8.638, 9.915> <0.919, 9.196, 9.782> <0.750, 9.278, 9.763> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.750, 8.999, 13.267> <0.591, 9.070, 13.409> <-0.695, 9.023, 13.316> <-0.750, 8.999, 13.267> 
		<0.750, 9.271, 12.624> <0.591, 9.343, 12.766> <-0.695, 9.296, 12.673> <-0.750, 9.271, 12.624> 
		<0.750, 9.320, 10.817> <0.413, 9.484, 10.777> <-0.544, 9.420, 10.793> <-0.750, 9.320, 10.817> 
		<0.750, 9.278, 9.763> <0.413, 9.442, 9.724> <-0.544, 9.378, 9.739> <-0.750, 9.278, 9.763> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.750, 8.048, 7.937> <-0.972, 8.156, 7.911> <-0.853, 8.728, 7.775> <-0.750, 8.778, 7.763> 
		<-0.750, 8.198, 8.537> <-0.972, 8.306, 8.511> <-0.853, 8.878, 8.375> <-0.750, 8.928, 8.363> 
		<-0.750, 8.505, 9.320> <-0.972, 8.613, 9.294> <-0.853, 9.203, 9.157> <-0.750, 9.253, 9.145> 
		<-0.750, 8.548, 9.937> <-0.972, 8.656, 9.911> <-0.853, 9.228, 9.775> <-0.750, 9.278, 9.763> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.750, 8.048, 7.937> <-0.750, 8.198, 8.537> <-0.750, 8.505, 9.320> <-0.750, 8.548, 9.937> 
		<-0.306, 7.832, 7.988> <-0.306, 7.982, 8.588> <-0.306, 8.289, 9.371> <-0.306, 8.332, 9.988> 
		<0.380, 7.868, 7.980> <0.380, 8.018, 8.580> <0.380, 8.325, 9.363> <0.380, 8.368, 9.980> 
		<0.750, 8.048, 7.937> <0.750, 8.198, 8.537> <0.750, 8.505, 9.320> <0.750, 8.548, 9.937> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.750, 8.048, 7.937> <0.750, 8.198, 8.537> <0.750, 8.505, 9.320> <0.750, 8.548, 9.937> 
		<0.935, 8.138, 7.915> <0.935, 8.288, 8.515> <0.935, 8.595, 9.298> <0.935, 8.638, 9.915> 
		<0.919, 8.696, 7.782> <0.919, 8.846, 8.382> <0.919, 9.171, 9.164> <0.919, 9.196, 9.782> 
		<0.750, 8.778, 7.763> <0.750, 8.928, 8.363> <0.750, 9.253, 9.145> <0.750, 9.278, 9.763> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.750, 8.778, 7.763> <0.750, 8.928, 8.363> <0.750, 9.253, 9.145> <0.750, 9.278, 9.763> 
		<0.413, 8.942, 7.724> <0.413, 9.092, 8.324> <0.413, 9.417, 9.106> <0.413, 9.442, 9.724> 
		<-0.544, 8.878, 7.739> <-0.544, 9.028, 8.339> <-0.544, 9.353, 9.121> <-0.544, 9.378, 9.739> 
		<-0.750, 8.778, 7.763> <-0.750, 8.928, 8.363> <-0.750, 9.253, 9.145> <-0.750, 9.278, 9.763> 
	}

	texture {
		pigment { color rgb <1.000,0.995,0.950> }
		normal {  N1 }
		finish { phong 0.2 phong_size 30 specular .2 roughness .005 }
	}
	texture {
		pigment {
			wrinkles
			color_map {
				[0.0 Tan filter 0.3]
				[0.8 Clear]
				[1.0 Clear]
			}
			scale 2
		}
		normal {
			crackle
			turbulence .3
			scale 10
			slope_map {
				[0.010 <0, 3>]
				[0.015 <1, 3>]
				[0.015 <1, 0>]
			}
		}
	}
}

#ifndef (IMPORT_SPATCH)
	translate .2*y
	rotate -y*120
#end

}
