// ==== Standard POV-Ray Includes ====
#include "colors.inc"	// Standard Color definitions
#include "textures.inc"	// Standard Texture definitions
#include "teclado_base.inc"                 
/*#include "teclado_textures.inc"

                                            
global_settings {
  adc_bailout 0.003922
  ambient_light <0.94902,0.94902,0.898039>
  assumed_gamma 1.9
  hf_gray_16 off
  irid_wavelength <0.247059,0.176471,0.137255>
  max_intersections 64
  max_trace_level 10
  number_of_waves 10
  radiosity {
    brightness       3.3
    count            100
    distance_maximum 0.0
    error_bound      0.4
    gray_threshold   0.5
    low_error_factor 0.8
    minimum_reuse    0.015
    nearest_count    6
    recursion_limit  1
  }
}

background { color <1.000,1.000,1.000> }

camera {  //  Camera Camera01
  location  <     0,     9,      550>  
  right <-1.33333,0,0>
  angle 5
  look_at   <     0,      9,      0>
}

//
// *******  L I G H T S *******
//

light_source {   // Light002
  <0.0, 0.0, 0.0>
  color rgb <1.000, 1.000, 1.000>
  translate  <47.538185, 32.075018, 7.994862>
  shadowless
}

light_source {   // Light001
  <0.0, 0.0, 0.0>
  color rgb <1.000, 1.000, 1.000>
  translate  <-16.071449, -48.322549, 57.706162>
  shadowless
}
  */

#include "tecla.inc"
#declare ancho_tecla=1.87;
#declare alto_tecla=1.9;
#declare posX=0;
#declare posZ=0;
#declare posY=0;

#macro Poner_Tecla()
        object {crear_tecla(ancho_tecla,alto_tecla) translate <posX,posY,posZ>}
        #declare posX=posX+ancho_tecla;

#end        

#macro Poner_Tecla_Especial(x_t)
        object{crear_tecla(x_t*ancho_tecla,alto_tecla) translate <posX+((x_t-1)/2)*ancho_tecla,posY,posZ>}
        #declare posX=posX+x_t*ancho_tecla;

#end        

#macro Separar_x(p)
        #declare posX=posX+(p*ancho_tecla);
#end        

#macro Separar_y(p)
        #declare posY=posY-((p+1)*alto_tecla);
        #declare posX=0;
#end        

#macro Poner_Grupo_Teclas(n)
        #declare i=0;
        #while (i<n)
                Poner_Tecla()
                #declare i=i+1;
        #end
#end
       
#declare Teclas=union{

        Poner_Grupo_Teclas(1)
        Separar_x(1)         
        Poner_Grupo_Teclas(4)
        Separar_x(.5)         
        Poner_Grupo_Teclas(4)
        Separar_x(.5)         
        Poner_Grupo_Teclas(4)
        Separar_x(.5)       
        Poner_Grupo_Teclas(3)
        Separar_y(.5)   
        
        #declare posZ=-.32; 

        Poner_Grupo_Teclas(15)
        Separar_x(.5)       
        Poner_Grupo_Teclas(3)
        Separar_x(.5)       
        Poner_Grupo_Teclas(4)    //NumKeyb
        Separar_y(0)    

        #declare posZ=-.54; 

        
        Poner_Tecla_Especial(1.25)  //Tab
        Poner_Grupo_Teclas(12)
        
        union {crear_tecla_enter(1.75*ancho_tecla,2.5*ancho_tecla,1*ancho_tecla,1*ancho_tecla) scale -1*x translate <posX+((.75)/2)*ancho_tecla,posY,posZ>}  //enter
        
        Separar_x(1.75)       //el Enter
        
        Separar_x(.5)       
        Poner_Grupo_Teclas(3)
        Separar_x(.5)       
        Poner_Grupo_Teclas(4)  //NumKeyb
        
        
        Separar_y(0)    
        
        #declare posZ=-.70; 

        Poner_Tecla_Especial(1.5)  //Caps Lock
        Poner_Grupo_Teclas(11)
        Separar_x(2.5)           //el Enter
        Separar_x(4)              
        Poner_Grupo_Teclas(4)    //NumKeyb
        Separar_y(0)    
        
        #declare posZ=-.80; 

        Poner_Tecla_Especial(1.2)  //Shift-l
        Poner_Grupo_Teclas(11)          
        Poner_Tecla_Especial(1.8)  //Shift-r
        Poner_Grupo_Teclas(1)      //Turbo
        Separar_x(1.5)              
        Poner_Grupo_Teclas(1)      //up
        Separar_x(1.5)              
        Poner_Grupo_Teclas(4)      //NumKeyb
        Separar_y(0)    
                
        #declare posZ=-.85; 
        
        Poner_Tecla_Especial(1.2)  //Ctrl-l
        Poner_Tecla_Especial(1.2)  //MS-W
        Poner_Tecla_Especial(1.2)  //Alt-l
        
        Poner_Tecla_Especial(6.6)  //Space
        
        Poner_Tecla_Especial(1.2)  //Alt-r
        Poner_Tecla_Especial(1.2)  //MS-W
        Poner_Tecla_Especial(1.2)  //MS-Menu
        Poner_Tecla_Especial(1.2)  //Ctrl-r
        Separar_x(.5)              
        Poner_Grupo_Teclas(3)      //left-down-right
        Separar_x(.5)              
        Poner_Grupo_Teclas(4)      //NumKeyb
        
        
        translate  <-20.486624, 13.5, 3.2>
        

}



declare teclas_text=
texture {
      material_map {
         png "las_teclas.png"
         texture {  //used with index 0
            pigment {Black}
         }
               texture
      {      
         pigment
         {
            color rgb <0.91, 0.91, 0.85>
         }      
         normal
         {
            granite , 0.02
         }      
         finish
         {
            ambient 0.1
            phong 0.043133
            phong_size 100.0
            roughness 0.1
            crand 0.05
         }
      }

      }
        scale <43.0,13.25,1>
        translate <-21.25,1.65,0>}                                                                                        

   }


#declare Teclado=union {object {Teclado_Base }
        object {Teclas 
                texture {teclas_text}
        }    
        material{Base_Azul_Orig}      
        }       
        

        


