#include "colors.inc"
#include "textures.inc"
#include "woods.inc"

#include "wwalls.pov"
#include "wbuddy.pov"
#include "wtorch.pov"
#include "wtexture.pov"
#include "wdiamond.pov"

#declare drawTheLeftWall=1;
#declare drawTheLeftWallThings=300;
#declare drawTheRightWall=1;
#declare drawTheRightWallThings=280;
#declare drawTheFloors=1;
#declare drawTheBuddies=1;
#declare elemCount=500;// 500;
#declare drawTheBalcony=1;
#declare drawCenterPost=1;
#declare debugTexture=0;

#if (debugTexture > 0)
    #declare caveTexture=texture {pigment{color White}} 
#end

#declare buddySize=0.7;

#declare gaussStat = array[9] {0.0,0.1,0.5,0.9,1.0,0.9,0.5,0.1,0.0} // Gauss-like


/*
camera {
  location <-10, 20, -24>
  look_at <-30, 15, 0>
}
*/

#declare cameraLocation=<33, 10, -24>;

camera {
  location cameraLocation
  look_at <0, 0, 0>
}
/*
camera {
  location <13, 10, 14>
  look_at <0, 10, 30>
}
*/


background { color Black }

// light_source { <50, 200, -100> colour White }

light_source { <0, 15, 0> colour Gray80 
    fade_power 1
    fade_distance 10
}
/*
light_source { <0.8, 16, -0.1> colour Gray30 
    fade_power 1
    fade_distance 10
}
light_source { <-0.3, 17, 0.6> colour Gray30 
    fade_power 1
    fade_distance 10
}
*/

#declare rs = seed(0);
#declare hrs = seed(10);

#macro element(size)
    #declare altRand=rand(rs);
    #alternative (altRand)
    #case (0.25) 
        object{
            floorFeature2(size)
            //scale <0.5+0.5*rand(rs),1+0.7*rand(rs),0.5+0.5*rand(rs)>
            #if (pow(layoutPosition.x-cameraLocation.x,2)+pow(layoutPosition.y-cameraLocation.y,2)<200)
            scale 0.25 // not to make an obstacle in the camera's view
            #end
            texture {caveTexture translate layoutPosition}
        }
    #case (0.75) object{ buddy(size) scale <1,0.85+0.3*rand(hrs),1>}
    #end
#end

#declare layoutPosition=<1,0,1>;
#declare layoutSuccess=1;
#declare layoutUp=<0,0,0>;

#declare gx=60;
#declare gz=76;
#declare ground=
object {
    wall(21,23,gx+1,gz+1,10)
    translate y*3
    texture {caveTexture}
    normal {caveNormal}
}

/*
height_field {
    tga "wbottom.tga"
    smooth
    translate <-0.5,-0.5,-0.5>
    scale <gx,5,gz>
    pigment{color White}
}
*/
#declare balconyY=13;
#declare gb=40;
// under the balcony
#if (drawTheLeftWall>0)
#declare theLeftWallThing=
object {
    wall(15,32,30,gz,10)
}
#declare theLeftWall=
union {
    object {
        theLeftWallThing
    }
    layout {
        object {theLeftWallThing rotate y*90}
        layout_on_top
        layout_count drawTheLeftWallThings
        layout_distance 2
        "wallFeature2"
        rotate y*-90
    }
    rotate z*-90
    translate <-gx/2+2,15,0>
    texture {caveTexture}
    normal {caveNormal}
}
#end
/*
box {
    <-gx/2-1,-5,-gz/2> <-gx/2,balconyY,gz/2>
    pigment{color White}
}
*/
// left upper wall
/*
box {
    <-gx/2-1,balconyY,-gz/2> <-gx/2,30,gz/2>
    pigment{color White}
}
*/
// right wall
#if (drawTheRightWall>0)
#declare theRightWallThing=
object {
    wall(24,15,gx,30,6)
}
#declare theRightWall=
union {
    object {
        theRightWallThing
    }
    layout {
        object {theRightWallThing}
        layout_on_top
        layout_count drawTheRightWallThings
        layout_distance 2
        "wallFeature2"
    }
    rotate x*-90
    translate <0,15,gz/2-3>
    texture {caveTexture}
    normal {caveNormal}
}
#end
/*
box {
    <-gx/2-1,-5,gz/2> <gx/2,30,gz/2+1>
    pigment{color White}
}
*/
#declare b1=<-gx/2-9,15,0>;
// light_source { b1 +<10,5,0> colour Gray30 }
#if (drawTheLeftWall>0)
    difference {
        object {theLeftWall}
        
        object {
            balconySubstract()
            translate b1
            texture {caveTexture}
            normal {caveNormal}
        }
        
    }
    union {
        #declare theBalcony=
        object {
            balcony()
            translate b1
            texture {caveTexture}
            normal {caveNormal}
        }
        object {theBalcony}
        #if (drawTheBalcony>0)
        layout {
            object {theBalcony translate y*-20}
            layout_on_top
            layout_count 10
            layout_size buddySize
            layout_distance 2.6
            layout_random_stream seed(1)
            "buddy"
            translate y*20
        }
        #end
        /*
        object {
            buddy(buddySize) 
            translate b1+<0,1,0>
        }
        */
        object {
            torch(1,5)
            rotate y*-90
            translate b1+<4,2,4>
        }
        object {
            torch(1,5)
            rotate y*-90
            translate b1+<4,2,-4>
        } 

    }
#end
#if (drawTheRightWall>0)
    object {theRightWall}
#end

/*
#declare balconyForLayout=

object {
    balcony(15,22,gx/4,gz/3,1)
    rotate y*20
    translate <-gx/2+gx/4-5,balconyY, gz/4+5>
    texture {caveTexture}
}
*/

/*
object {
    balcony(15,15,gx/4,gz/2,1)
    scale <1,-1,1>
    translate <-gx/2+gx/4,balconyY, gz/5>
    pigment{color White}
}
*/
/*
#declare balconyForLayout=intersection {
    cylinder {
        <0,0,0>, <0,1,0> gb
        scale <0.5,1,1>
    }
    box {
        <0,-1,-gz> <gx,2,gz>
    }
    box {
        <0,-1,-gz> <gx,2,gz/2-gz/5>
    }
    translate <-gx/2,balconyY, gz/5>
    pigment{color White}
}
*/
#if (drawTheFloors>0)
/*
    #if (drawTheBalcony>0)
        object {balconyForLayout}
    #end
*/    
    object {ground}
#end

#if (drawTheFloors>0)
#declare groundForLayout=
intersection{
    union {
        object{ground}
        #if (drawTheLeftWall)
        object{theLeftWall}
        #end
        #if (drawTheRightWall)
        object{theRightWall}
        #end
    }
    box {<-gx/2-2,-10,-gz/2+1> <gx/2-1,20,gz/2+2>}
    pigment{color White}
}
#end

#if (drawCenterPost>0)
#declare layoutPosition = <0,0,0>;
#macro specialFloorFeature(size)
    #if (layoutPosition.y > -5)
        #declare layoutSuccess=0;
    #end
    object{floorFeature(1) scale <0.6,0.9,0.6>}
#end
    #declare theCenterPost=object {
        centerPost(6,20)
        translate y*-10
        texture {caveTexture}
        // normal {caveNormal}
    }
    object{theCenterPost}
    //sphere {<0,11,0> 0.3 pigment {color Red}}
    object {diamond scale 3 translate y*10}
    #declare ti=0;
    #declare nti=5;
    #while (ti < nti)
        object {
            torch(1,8)
            translate z*-3.0
            rotate y*(360*ti/nti)
            translate y*-2.1
        }
        #declare ti=ti+1;
    #end
    layout {
        object {theCenterPost}
        layout_surface
        layout_count 20
        layout_random_stream seed(4)
        "specialFloorFeature"
        texture {caveTexture}
    }
#end

#declare space=15;
// the Floor


#if (drawTheBuddies>0)

layout {
    object {groundForLayout}
    layout_on_top
    layout_count elemCount
    layout_size buddySize
    layout_distance 1.7                         
    layout_random_stream seed(0)
    "element"
}

// the Balcony
/*
#if (drawTheBalcony>0)
layout {
    object {balconyForLayout}
    layout_on_top
    layout_count 35
    layout_size buddySize
    layout_distance 2.6
    layout_random_stream seed(1)
    "buddy"
}
#end // drawTheBalcony
*/

#end // drawTheBuddies
