#include "colors.inc"
#include "textures.inc"

#declare debugMode=0;

#declare gaussStat = array[9] {0.0,0.1,0.5,0.9,1.0,0.9,0.5,0.1,0.0} // Gauss-like

#if (debugMode>0)
camera {
  location <10, 5, -5>
  look_at <0, 0, 0>
  scale 0.6
}
background { color Black }
box {
    <-10,-5,0> <10,5,1> pigment {color White}
}

// light_source { <50, 200, -100> colour White }
/*
light_source { <0, 15, 0> colour Gray80 
    fade_power 1
    fade_distance 10
}
light_source { <0.8, 16, -0.1> colour Gray30 
    fade_power 1
    fade_distance 10
}
light_source { <-0.3, 17, 0.6> colour Gray30 
    fade_power 1
    fade_distance 10
}
*/
#end

#declare trs = seed(2);

#macro torch(size, dist)
union {
    // the hanler
    difference {
        union {
            cone {
                <0,0,0.2> 0.0
                <0,1,-0.5> 0.14
            }
            cone {
                <0,1,0.1> 0.08
                <0,0.8,-0.4> 0.08
            }
        }
        cone {
            <0,0,0.2> 0.0
            <0,1.01,-0.51> 0.11
        }
        texture {Silver_Metal}
    }
    // the torch
    cone {
        <0,1,-0.5> 0.08
        <0,1.6,-0.9> 0.09  
        no_shadow
        texture {
            pigment {
                Dark_Wood
            }
        }
    }
    light_source {
        <0,0,0>
        #declare clr=<0.2*rand(trs)+0.8,0.5*rand(trs)+0.5,0.2>;
        color rgb clr 
        fade_power 1
        fade_distance dist
        looks_like {
            sphere {
                <0,0,0> 1 
                scale <0.15,0.3,0.15>
                rotate x*-30
                texture {
                    pigment { 
                        color rgb clr
                    }
                }
                /*   
                interior {
                    media {
                        emission rgb <1,1,1>
                    }
                } 
                */
                finish {
                    ambient 0.5
                    diffuse 0.5
                    brilliance 0
                    phong 0
                }
            }
        }
        translate <0,1.8,-1>
    }
    rotate x*5       
}    
#end

#if (debugMode>0)

light_source { <0, 15, -10> colour White
    fade_power 1
    fade_distance 20
}

object {torch(1,5)}
object {torch(1,5) translate x*5}
object {torch(1,5) translate x*-5}
#end