
#declare wrs=seed(0);

#declare rightGaussStat = array[5] {1.0,0.9,0.5,0.1,0.0} // Gauss-like right part

#macro wall(nx,nz,sx,sz,sy)
blob {
    threshold 0.6
    #declare j=0;
    #while (j<=nz)
        #declare i=0;
        #while (i<=nx)
            #declare yy=-1.1*sin(pi*i/nx)-1.1*sin(pi*j/nz)+0.5*rand(wrs);
            sphere { <(i/nx-0.5) *10,yy,(j/nz-0.5)*10>, 1/*3*(rand(rs)+0.1)*/, 1}
            #declare i=i+1;
        #end
        #declare j=j+1;
    #end
    scale <sx/10,sy,sz/10>
    // sphere { <1,0,0>, 1, 1}
    // texture { pigment {White}}//marble color_map {[0.0 Black] [1 White]}turbulence 1}  }
    // scale <1.4,2,1.1>
}
#end

#macro wallFeature(size)
blob {
    threshold 0.6
    #declare j=0;
    #declare nz=10*rand(wrs)+5;
    #while (j<=nz)
        sphere {
            <0,0,0> 1, 1
            scale <0.8,0.8,2>
            translate x*makevalue(gaussStat, 0, 0.6, wrs)
            translate y*makevalue(gaussStat, 0, 0.6, wrs)
            translate z*makevalue(gaussStat, 0, nz/3, wrs)
        }
        #declare j=j+1;
    #end
    scale <0.8,0.8,1.2>
    scale (0.8+1*rand(wrs))
}
/*
cylinder {
    <0,0,-2> <0,0,2> 1
}
*/
#end

#macro wallFeature2(size)
// union {
blob {
    #if (abs(layoutUp.z) < 0.2)
        #declare twoSided=1;
    #else
        #declare twoSided=0;
    #end    
    threshold 0.1
    #declare j=0;
    #declare nz=15 + twoSided*10;
    #while (j<=nz)
        sphere {
            <0,0,0> 1, 1
            #if (twoSided>0)
                #declare cz = makevalue(gaussStat, 0, 3, wrs);
            #else
                #declare cz = makevalue(rightGaussStat, 1.5, 1.5, wrs);
            #end
            //#debug concat("cz=",str(cz,5,5),"\n")
            scale <1/(abs(cz)+1),1/(abs(cz)+1),1+(abs(cz)+1)/3>
            scale 0.5
            translate x*makevalue(gaussStat, 0, 0.6, wrs)/(1+abs(cz))
            translate y*makevalue(gaussStat, 0, 0.6, wrs)/(1+abs(cz))
            translate z*cz
        }
        #declare j=j+1;
    #end
    //scale <0.8,0.8,1.2>
    scale (0.8+1*rand(wrs))
    #if (layoutUp.z < 0)
        rotate x*180
    #end
    scale 1+rand(wrs)
}
#end

#macro floorFeature(size)
union {
//blob {
//   threshold 0.3
    #declare j=0;
    #declare nz=10*rand(wrs)+5;
    #while (j<=nz)
        sphere {
            <0,0,0> 1//, 1
            scale <0.8,0.8,1.7>
            #declare cz = makevalue(rightGaussStat, 0, nz/6, wrs);
            translate x*makevalue(gaussStat, 0, 0.6, wrs)*nz/6/(1+cz)
            translate y*makevalue(gaussStat, 0, 0.6, wrs)*nz/6/(1+cz)
            translate z*cz
        }
        #declare j=j+1;
    #end
    scale <0.8,0.8,1.2>
    scale (0.8+1*rand(wrs))
    rotate x*-90
}
/*
cylinder {
    <0,0,-2> <0,0,2> 1
}
*/
#end            

#macro floorFeature2(size)
// union {
blob {
    threshold 0.1
    #declare j=0;
    #declare nz=16;
    #while (j<=nz)
        sphere {
            <0,0,0> 1, 1
            #declare cz = makevalue(rightGaussStat, 1.5, 1.5, wrs);
            //#debug concat("cz=",str(cz,5,5),"\n")
            scale <1/(cz+1),1/(cz+1),1+(cz+1)/3>
            scale 0.5
            translate x*makevalue(gaussStat, 0, 0.6, wrs)/(1+cz)
            translate y*makevalue(gaussStat, 0, 0.6, wrs)/(1+cz)
            translate z*cz
        }
        #declare j=j+1;
    #end
    //scale <0.8,0.8,1.2>
    scale (0.8+1*rand(wrs))
    rotate x*-90
}
#end

#macro oldbalcony(nx,nz,sx,sz,sy)
blob {
    threshold 0.6
    #declare j=0;
    #while (j<=nz)
        #declare i=0;
        #while (i<=nx)
            #declare yy=2.5-2.5*sin(pi/2*i/nx)+0.7*rand(wrs);
            sphere { <(i/nx-0.5) *10,yy,(j/nz-0.5)*10>, 1/*3*(rand(rs)+0.1)*/, 1}
            #declare i=i+1;
        #end
        #declare j=j+1;
    #end
    scale <sx/10,sy,sz/10>
    // sphere { <1,0,0>, 1, 1}
    // texture { pigment {White}}//marble color_map {[0.0 Black] [1 White]}turbulence 1}  }
    // scale <1.4,2,1.1>
}
#end

#macro centerPostN(sr,sy,nnr,nny,theRadius,theStrength)
blob {
    threshold 0.5
    #declare j=0;
    #declare ny=nny;
    #while (j<=ny)
        #declare i=0;
        #declare nr=nnr-j*1.5;
        #if (nr<1)
            #declare nr=1;
        #end
        #declare rotRand=rand(wrs);
        #while (i<nr)
            sphere { <0,0,0>,
                theRadius*(1-0.5*j/ny),
                theStrength
                scale <1,2,1> 
                translate <sr*pow(1-j/ny,2)+pow(1-j/ny,2)*rand(wrs),j/ny*sy,0>
                rotate y*360*(rotRand+i/nr)}
            #declare i=i+1;
        #end
        #declare j=j+1;
    #end
    // sphere { <1,0,0>, 1, 1}
    // texture { pigment {White}}//marble color_map {[0.0 Black] [1 White]}turbulence 1}  }
    // scale <1.4,2,1.1>
}
#end

#macro centerPost(sr,sy)
    centerPostN(sr,sy,30,24,1.3,1)
#end

#macro balcony()
blob {
    threshold 0.6
    #declare j=0;
    #declare nj=10;
    #while (j<=nj)
        #declare i=0;
        #declare ni=10+2*j;
        #while (i<=ni)
            sphere { <sqrt(j/nj)*5+0.6*rand(wrs),2*j/nj,0>, 1, 1 rotate y*(200*i/ni-100)}
            #declare i=i+1;
        #end
        #declare j=j+1;
    #end
    //scale <sx/10,sy,sz/10>
    // sphere { <1,0,0>, 1, 1}
    // texture { pigment {White}}//marble color_map {[0.0 Black] [1 White]}turbulence 1}  }
    // scale <1.4,2,1.1>
}
#end

#macro balconySubstract()
blob {
    threshold 0.6
    #declare j=0;
    #declare nj=10;
    #while (j<=nj)
        #declare i=0;
        #declare ni=7+2*j;
        #while (i<=ni)
            sphere { <(j/nj)*2+0.3*rand(wrs),0,0>, 1, 1 rotate y*(160*i/ni-80)}
            #declare i=i+1;
        #end
        #declare j=j+1;
    #end
    rotate z*90
    scale<8,2,1>
    translate y*2
    //scale <sx/10,sy,sz/10>
    // sphere { <1,0,0>, 1, 1}
    // texture { pigment {White}}//marble color_map {[0.0 Black] [1 White]}turbulence 1}  }
    // scale <1.4,2,1.1>
}
#end

/*
light_source { <50, 200, -100> colour rgb<1,1,1> }
//light_source { <-5, 14, 2> colour Gray70 }
camera {
  location <10, 5, -10>
  look_at <0, 0, 0>
}

object {balconySubstract()
    pigment{rgb <1,1,1>}
}
*/