//  Persistence of Vision Raytracer V3.1
//  World definition file.
//
//  Contains 1 lights, 23 materials and 46 primitives.
//
//  This file was generated for POV-Ray V3.1 by
//  Moray V3.3 For Windows Copyright (c) 1993-2000 Lutz + Kretzschmar
//

//  Date : 02/10/2001    (10.02.2001)
//

/*
  The text between these two comments is in MorayPOV.INC and is
  automatically included in all POV files that Moray exports.
*/

default {
  texture {
    pigment { rgb <1,0,0> }
  }
}

/* // Scene Comment

This scene was created with Moray For Windows.

*/ // End Scene Comment

global_settings {
  adc_bailout 0.003922
  ambient_light <0.176471,0.239216,1.0>
  assumed_gamma 1.9
  hf_gray_16 off
  irid_wavelength <0.247059,0.176471,0.137255>
  max_intersections 64
  max_trace_level 10
  number_of_waves 10
  radiosity {
    brightness       3.3
    count            100
    distance_maximum 0.0
    error_bound      0.4
    gray_threshold   0.5
    low_error_factor 0.8
    minimum_reuse    0.015
    nearest_count    6
    recursion_limit  1
  }
}

background { color <0.000,0.055,0.686> }

fog {
  fog_type 2    // Ground Fog
  distance     100.0
  color <0.447059,0.341176,0.211765,0.058824,0.0>
  up           <0,0,1>
  fog_offset   0.0
  fog_alt      5.0
}

fog {
  fog_type 1    // Constant
  distance     50.0
  color <0.607843,0.423529,0.011765,0.352941,0.372549>
  turbulence   <1.0,0.0,0.0>
    omega      0.5
    lambda     2.0
    octaves    6
    turb_depth 0.0
}

fog {
  fog_type 2    // Ground Fog
  distance     10.0
  color <0.007843,0.101961,0.6,0.0,0.603922>
  up           <0,0,1>
  fog_offset   0.0
  fog_alt      5.0
}

camera {  //  Camera StdCam
  location  <    119.830,      89.763,      22.275>
  sky       <    0.00000,     0.00000,     1.00000> // Use right handed-system 
  up        <        0.0,         0.0,         1.0> // Where Z is up
  right     <    1.38192,         0.0,         0.0> // Right Vector is adjusted to compensate for spherical (Moray) vs. planar (POV-Ray) aspect ratio
  angle         54.40000    // Vertical      40.800
  look_at   <     15.520,      31.197,       7.660>
}

//
// *******  L I G H T S *******
//

light_source {   // Light1
  <0.0, 0.0, 0.0>
  color rgb <1.000, 0.971, 1.000>*8.5705
  translate  <0.0, 48.424444, 67.123671>
}


//
// ********  MATERIALS  *******
//

#include "desert.inc"


//
// ********  REFERENCED OBJECTS  *******
//

#declare RndCube001 = merge {
  sphere { <0.4000, 0.4000, 0.4000>, 0.1000 }
  sphere { <0.4000, -0.4000, 0.4000>, 0.1000 }
  sphere { <-0.4000, -0.4000, 0.4000>, 0.1000 }
  sphere { <-0.4000, 0.4000, 0.4000>, 0.1000 }
  sphere { <0.4000, 0.4000, -0.4000>, 0.1000 }
  sphere { <0.4000, -0.4000, -0.4000>, 0.1000 }
  sphere { <-0.4000, -0.4000, -0.4000>, 0.1000 }
  sphere { <-0.4000, 0.4000, -0.4000>, 0.1000 }
  cylinder { <0.4000, 0.4000, 0.4000>, <-0.4000, 0.4000, 0.4000>, 0.1000 }
  cylinder { <0.4000, -0.4000, 0.4000>, <-0.4000, -0.4000, 0.4000>, 0.1000 }
  cylinder { <0.4000, -0.4000, -0.4000>, <-0.4000, -0.4000, -0.4000>, 0.1000 }
  cylinder { <0.4000, 0.4000, -0.4000>, <-0.4000, 0.4000, -0.4000>, 0.1000 }
  cylinder { <0.4000, 0.4000, -0.4000>, <0.4000, 0.4000, 0.4000>, 0.1000 }
  cylinder { <0.4000, -0.4000, -0.4000>, <0.4000, -0.4000, 0.4000>, 0.1000 }
  cylinder { <-0.4000, -0.4000, -0.4000>, <-0.4000, -0.4000, 0.4000>, 0.1000 }
  cylinder { <-0.4000, 0.4000, -0.4000>, <-0.4000, 0.4000, 0.4000>, 0.1000 }
  cylinder { <0.4000, 0.4000, 0.4000>, <0.4000, -0.4000, 0.4000>, 0.1000 }
  cylinder { <0.4000, 0.4000, -0.4000>, <0.4000, -0.4000, -0.4000>, 0.1000 }
  cylinder { <-0.4000, 0.4000, -0.4000>, <-0.4000, -0.4000, -0.4000>, 0.1000 }
  cylinder { <-0.4000, 0.4000, 0.4000>, <-0.4000, -0.4000, 0.4000>, 0.1000 }
  box { <-0.4000, -0.4000, -0.5000> <0.4000, 0.4000, 0.5000> }
  box { <-0.4000, -0.5000, -0.4000> <0.4000, 0.5000, 0.4000> }
  box { <-0.5000, -0.4000, -0.4000> <0.5000, 0.4000, 0.4000> }
  scale <-5.770473, -9.858502, -3.185115>
  rotate <-180.0, 0.0, -180.0>
  translate  <-0.074403, 0.0, 0.938628>
}




//
// ********  OBJECTS  *******
//

sphere { // Sphere003
  <0,0,0>,1
  material {
    distantfires
  }
  scale 7.421019
  translate  <-146.733223, 43.322405, 52.559822>
}


object {   // HgtFld003
  height_field {
    tga "C:\Program Files\Moray For Windows\Maps\shallows.tga"
    water_level 0.0
    smooth
  }
  rotate    <-90, 0, 0> // Turn onto XY plane. Now points along -Z
  scale     <  2, 2,-2> // Scale to Cube size. Now points along +Z
  translate < -1,-1,-1> // Center around origin
  material {
    seabed
  }
  scale <30.829271, 45.411259, 2.0>
  rotate -37.289188*z
  translate  <0.697522, 9.185212, 0.734486>
}


union { // BezPtch005
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.484452, 0.296593, -1.364935>, <-1.863276, 1.643866, 0.050435>, <-1.837969, 0.503714, 0.150705>, <-1.830785, 0.504767, 0.176295>, 
      <0.509328, 1.288512, -0.720744>, <-1.863276, 2.561159, 0.047860>, <-2.633988, 1.321504, 0.148130>, <-2.626805, 1.322557, 0.173720>, 
      <0.509328, 2.205804, -0.723318>, <-1.863276, 3.478451, 0.045285>, <-1.589212, 2.786059, 0.145555>, <-1.706407, 2.712486, 0.171145>, 
      <0.248134, 2.799713, -0.725893>, <-2.385664, 3.748977, 0.042711>, <-1.713590, 3.628725, 0.142980>, <-1.768596, 3.592464, 0.168570>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.830785, 0.504767, 0.176295>, <-1.823602, 0.505820, 0.201884>, <-1.837155, 1.647696, 0.143489>, <0.510573, 0.300422, -1.271881>, 
      <-2.626805, 1.322557, 0.173720>, <-2.619622, 1.323610, 0.199310>, <-1.837155, 2.564988, 0.140914>, <0.535448, 1.292341, -0.627689>, 
      <-1.706407, 2.712486, 0.171145>, <-1.823602, 2.638912, 0.196735>, <-1.837155, 3.482280, 0.138340>, <0.535448, 2.209633, -0.630264>, 
      <-1.768596, 3.592464, 0.168570>, <-1.823602, 3.556204, 0.194160>, <-2.359543, 3.578677, 0.135765>, <0.274254, 2.716478, -0.632839>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.510573, 0.300422, -1.271881>, <2.858301, -1.046852, -2.687251>, <7.509610, -2.891774, -4.678068>, <7.502427, -2.892827, -4.703658>, 
      <0.535448, 1.292341, -0.627689>, <2.908052, 0.019694, -1.396293>, <3.828018, -1.626223, -4.431886>, <3.820835, -1.627276, -4.457476>, 
      <0.535448, 2.209633, -0.630264>, <2.908052, 0.936986, -1.398868>, <3.828018, -0.708931, -4.434461>, <3.820835, -0.709984, -4.460051>, 
      <0.274254, 2.716478, -0.632839>, <2.908052, 1.854279, -1.401443>, <2.459859, 1.775526, -2.297732>, <2.452676, 1.774472, -2.323322>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <7.502427, -2.892827, -4.703658>, <7.495244, -2.893880, -4.729248>, <2.832180, -1.050681, -2.780305>, <0.484452, 0.296593, -1.364935>, 
      <3.820835, -1.627276, -4.457476>, <3.813652, -1.628329, -4.483066>, <2.881931, 0.015865, -1.489347>, <0.509328, 1.288512, -0.720744>, 
      <3.820835, -0.709984, -4.460051>, <3.813652, -0.711037, -4.485641>, <2.881931, 0.933157, -1.491922>, <0.509328, 2.205804, -0.723318>, 
      <2.452676, 1.774472, -2.323322>, <2.445493, 1.773419, -2.348912>, <2.881931, 1.850449, -1.494497>, <0.248134, 2.799713, -0.725893>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.248134, 2.799713, -0.725893>, <-2.385664, 3.748977, 0.042711>, <-1.713590, 3.628725, 0.142980>, <-1.768596, 3.592464, 0.168570>, 
      <-0.013060, 3.393622, -0.728468>, <-2.908052, 4.019503, 0.040136>, <-1.837969, 4.471390, 0.140406>, <-1.830785, 4.472443, 0.165996>, 
      <-0.585200, 4.435292, -0.059401>, <-2.908052, 4.936795, 0.037561>, <-1.837969, 5.388682, 0.137831>, <-1.830785, 5.389735, 0.163421>, 
      <-0.891788, 5.385182, -0.061975>, <-2.908052, 5.854087, 0.034987>, <-1.837969, 6.305974, 0.135256>, <-1.830785, 6.307027, 0.160846>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.768596, 3.592464, 0.168570>, <-1.823602, 3.556204, 0.194160>, <-2.359543, 3.578677, 0.135765>, <0.274254, 2.716478, -0.632839>, 
      <-1.830785, 4.472443, 0.165996>, <-1.823602, 4.473496, 0.191586>, <-2.881931, 3.675073, 0.133190>, <0.013060, 3.223322, -0.635414>, 
      <-1.830785, 5.389735, 0.163421>, <-1.823602, 5.390788, 0.189011>, <-2.881931, 4.592365, 0.130615>, <-0.559079, 4.264992, 0.033653>, 
      <-1.830785, 6.307027, 0.160846>, <-1.823602, 6.308080, 0.186436>, <-2.881931, 5.509657, 0.128041>, <-0.868446, 5.214901, 0.031079>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.274254, 2.716478, -0.632839>, <2.908052, 1.854279, -1.401443>, <2.459859, 1.775526, -2.297732>, <2.452676, 1.774472, -2.323322>, 
      <0.013060, 3.223322, -0.635414>, <2.908052, 2.771571, -1.404017>, <1.091700, 4.259982, -0.161004>, <1.084517, 4.258929, -0.186593>, 
      <-0.559079, 4.264992, 0.033653>, <1.763773, 3.937619, -0.063309>, <1.091700, 4.679761, -0.163578>, <1.084517, 4.678708, -0.189168>, 
      <-0.868446, 5.214901, 0.031079>, <1.145039, 4.920145, -0.065883>, <0.840899, 5.313986, -0.166153>, <0.835244, 5.312923, -0.191743>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <2.452676, 1.774472, -2.323322>, <2.445493, 1.773419, -2.348912>, <2.881931, 1.850449, -1.494497>, <0.248134, 2.799713, -0.725893>, 
      <1.084517, 4.258929, -0.186593>, <1.077334, 4.257876, -0.212183>, <2.881931, 2.767741, -1.497072>, <-0.013060, 3.393622, -0.728468>, 
      <1.084517, 4.678708, -0.189168>, <1.077334, 4.677655, -0.214758>, <1.737653, 3.933790, -0.156363>, <-0.585200, 4.435292, -0.059401>, 
      <0.835244, 5.312923, -0.191743>, <0.829589, 5.311859, -0.217333>, <1.124476, 4.916276, -0.158937>, <-0.891788, 5.385182, -0.061975>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.891788, 5.385182, -0.061975>, <-2.908052, 5.854087, 0.034987>, <-1.837969, 6.305974, 0.135256>, <-1.830785, 6.307027, 0.160846>, 
      <-1.198376, 6.335071, -0.064550>, <-2.908052, 6.771379, 0.032412>, <-1.837969, 7.223266, 0.132682>, <-1.830785, 7.224319, 0.158271>, 
      <-1.198376, 7.087556, -0.067125>, <-2.908052, 7.340412, 0.029837>, <-1.837969, 7.792300, 0.130107>, <-1.830785, 7.793353, 0.155697>, 
      <-1.291125, 8.045973, -0.069700>, <-2.908052, 8.279654, 0.027262>, <-1.837969, 8.709592, 0.127532>, <-1.830785, 8.710645, 0.153122>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.830785, 6.307027, 0.160846>, <-1.823602, 6.308080, 0.186436>, <-2.881931, 5.509657, 0.128041>, <-0.868446, 5.214901, 0.031079>, 
      <-1.830785, 7.224319, 0.158271>, <-1.823602, 7.225372, 0.183861>, <-2.881931, 6.426949, 0.125466>, <-1.177814, 6.164810, 0.028504>, 
      <-1.830785, 7.793353, 0.155697>, <-1.823602, 7.794406, 0.181287>, <-2.881931, 7.344242, 0.122891>, <-1.177814, 7.091424, 0.025929>, 
      <-1.830785, 8.710645, 0.153122>, <-1.823602, 8.711698, 0.178712>, <-2.881931, 8.283493, 0.120317>, <-1.273996, 8.049787, 0.023355>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.868446, 5.214901, 0.031079>, <1.145039, 4.920145, -0.065883>, <0.840899, 5.313986, -0.166153>, <0.835244, 5.312923, -0.191743>, 
      <-1.177814, 6.164810, 0.028504>, <0.526304, 5.902670, -0.068458>, <0.590098, 5.948211, -0.168728>, <0.585971, 5.947137, -0.194318>, 
      <-1.177814, 7.091424, 0.025929>, <0.526304, 6.838606, -0.071033>, <0.590098, 6.884148, -0.171302>, <0.585971, 6.883073, -0.196892>, 
      <-1.273996, 8.049787, 0.023355>, <0.333940, 7.816081, -0.073607>, <-0.148789, 7.513490, -0.173877>, <-0.151027, 7.512448, -0.199467>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.835244, 5.312923, -0.191743>, <0.829589, 5.311859, -0.217333>, <1.124476, 4.916276, -0.158937>, <-0.891788, 5.385182, -0.061975>, 
      <0.585971, 5.947137, -0.194318>, <0.581845, 5.946062, -0.219908>, <0.511299, 5.898763, -0.161512>, <-1.198376, 6.335071, -0.064550>, 
      <0.585971, 6.883073, -0.196892>, <0.581845, 6.881999, -0.222482>, <0.511299, 6.834699, -0.164087>, <-1.198376, 7.087556, -0.067125>, 
      <-0.151027, 7.512448, -0.199467>, <-0.153265, 7.511406, -0.225057>, <0.325801, 7.812292, -0.166662>, <-1.291125, 8.045973, -0.069700>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.291125, 8.045973, -0.069700>, <-2.908052, 8.279654, 0.027262>, <-1.837969, 8.709592, 0.127532>, <-1.830785, 8.710645, 0.153122>, 
      <-1.383874, 9.004390, -0.072274>, <-2.908052, 9.218896, 0.024688>, <-1.837969, 9.626884, 0.124957>, <-1.830785, 9.627937, 0.150547>, 
      <-1.681301, 10.721647, -0.025098>, <-2.885572, 11.773419, 0.121615>, <-2.885572, 11.728212, 0.221885>, <-2.885572, 11.729290, 0.247475>, 
      <-2.885572, 12.454438, 0.022079>, <-2.885572, 12.716896, 0.119041>, <-2.885572, 12.667196, 0.219310>, <-2.885572, 12.668274, 0.244900>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.830785, 8.710645, 0.153122>, <-1.823602, 8.711698, 0.178712>, <-2.881931, 8.283493, 0.120317>, <-1.273996, 8.049787, 0.023355>, 
      <-1.830785, 9.627937, 0.150547>, <-1.823602, 9.628990, 0.176137>, <-2.881931, 9.222744, 0.117742>, <-1.370178, 9.008150, 0.020780>, 
      <-2.885572, 11.729290, 0.247475>, <-2.885572, 11.730368, 0.273065>, <-2.885572, 11.777357, 0.214670>, <-1.683463, 10.725452, 0.067956>, 
      <-2.885572, 12.668274, 0.244900>, <-2.885572, 12.669352, 0.270490>, <-2.885572, 12.720834, 0.212095>, <-2.885572, 12.458287, 0.115133>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.273996, 8.049787, 0.023355>, <0.333940, 7.816081, -0.073607>, <-0.148789, 7.513490, -0.173877>, <-0.151027, 7.512448, -0.199467>, 
      <-1.370178, 9.008150, 0.020780>, <0.141575, 8.793556, -0.076182>, <-0.887676, 8.142833, -0.176452>, <-0.888026, 8.141823, -0.202042>, 
      <-1.683463, 10.725452, 0.067956>, <-0.481354, 9.673547, -0.078757>, <-0.872448, 9.669590, -0.179027>, <-0.871259, 9.668580, -0.204617>, 
      <-2.885572, 12.458287, 0.115133>, <-2.885572, 12.195739, 0.018171>, <-2.885572, 12.367104, -0.124969>, <-2.885572, 12.278363, -0.129124>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.151027, 7.512448, -0.199467>, <-0.153265, 7.511406, -0.225057>, <0.325801, 7.812292, -0.166662>, <-1.291125, 8.045973, -0.069700>, 
      <-0.888026, 8.141823, -0.202042>, <-0.888376, 8.140814, -0.227632>, <0.140303, 8.789884, -0.169236>, <-1.383874, 9.004390, -0.072274>, 
      <-0.871259, 9.668580, -0.204617>, <-0.870070, 9.667571, -0.230206>, <-0.477031, 9.669875, -0.171811>, <-1.681301, 10.721647, -0.025098>, 
      <-2.885572, 12.278363, -0.129124>, <-2.885572, 12.189621, -0.133279>, <-2.885572, 12.191980, -0.074883>, <-2.885572, 12.454438, 0.022079>
    }
  }
  material {
    carpet
  }
  scale <1.961625, 1.64473, 1.614534>
  rotate <167.700912, -164.027939, 6.841578>
  translate  <-21.362024, 14.396392, 31.41241>
}




torus { // Torus005
  1.5, 0.5  rotate -x*90
  material {
    Brass_Valley
  }
  scale <-0.856465, -0.856465, -0.7>
  rotate <-162.012878, -202.960281, -172.781815>
  translate  <-37.735447, 18.186514, 29.102819>
}


#declare BezPtch004 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.010392, 0.000000, 0.103396>, <0.290527, 0.002971, 0.104823>, <0.311311, 0.002971, -0.101969>, <0.010392, 0.000000, -0.103396>, 
      <-0.329448, 2.104972, 0.324015>, <1.088607, 2.136522, 0.287011>, <1.109391, 2.136522, -0.259460>, <-0.302817, 2.104972, -0.329568>, 
      <-0.029386, 4.010621, 0.380202>, <2.478879, 4.026154, 0.408204>, <2.511362, 4.026154, -0.352492>, <0.003094, 4.010621, -0.380495>, 
      <-0.026882, 6.161666, -0.404714>, <1.616914, 6.173672, -0.373428>, <1.642243, 6.173672, -1.599340>, <-0.001555, 6.161666, -1.630626>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.010392, 0.000000, -0.103396>, <-0.290527, -0.002971, -0.104823>, <-0.311311, -0.002971, 0.101969>, <-0.010392, 0.000000, 0.103396>, 
      <-0.302817, 2.104972, -0.329568>, <-1.715024, 2.073422, -0.399676>, <-1.747503, 2.073422, 0.361020>, <-0.329448, 2.104972, 0.324015>, 
      <0.003094, 4.010621, -0.380495>, <-2.505173, 3.995087, -0.408498>, <-2.537651, 3.995087, 0.352199>, <-0.029386, 4.010621, 0.380202>, 
      <-0.001555, 6.161666, -1.630626>, <-1.645352, 6.149661, -1.661912>, <-1.670677, 6.149661, -0.435999>, <-0.026882, 6.161666, -0.404714>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.026882, 6.161666, -0.404714>, <1.616914, 6.173672, -0.373428>, <1.642243, 6.173672, -1.599340>, <-0.001555, 6.161666, -1.630626>, 
      <-0.024378, 8.312712, -1.189629>, <0.754948, 8.321190, -1.155060>, <0.773124, 8.321190, -2.846189>, <-0.006203, 8.312712, -2.880757>, 
      <-0.028201, 10.361136, -1.189798>, <0.751126, 10.369614, -1.155230>, <0.769301, 10.369614, -2.846358>, <-0.010026, 10.361136, -2.880927>, 
      <-0.045228, 12.199154, -0.404982>, <1.598568, 12.211160, -0.373696>, <1.623897, 12.211160, -1.599609>, <-0.019901, 12.199154, -1.630894>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.001555, 6.161666, -1.630626>, <-1.645352, 6.149661, -1.661912>, <-1.670677, 6.149661, -0.435999>, <-0.026882, 6.161666, -0.404714>, 
      <-0.006203, 8.312712, -2.880757>, <-0.785531, 8.304234, -2.915326>, <-0.803704, 8.304234, -1.224197>, <-0.024378, 8.312712, -1.189629>, 
      <-0.010026, 10.361136, -2.880927>, <-0.789353, 10.352658, -2.915495>, <-0.807527, 10.352658, -1.224367>, <-0.028201, 10.361136, -1.189798>, 
      <-0.019901, 12.199154, -1.630894>, <-1.663698, 12.187148, -1.662180>, <-1.689023, 12.187148, -0.436267>, <-0.045228, 12.199154, -0.404982>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.045228, 12.199154, -0.404982>, <1.598568, 12.211160, -0.373696>, <1.623897, 12.211160, -1.599609>, <-0.019901, 12.199154, -1.630894>, 
      <-0.062255, 14.037173, 0.379835>, <2.446010, 14.052706, 0.407837>, <2.478493, 14.052706, -0.352859>, <-0.029775, 14.037173, -0.380862>, 
      <-0.045363, 17.005036, 0.272797>, <1.058007, 17.015928, 0.286627>, <1.078791, 17.015928, -0.259844>, <-0.024580, 17.005036, -0.273674>, 
      <-0.049735, 19.130665, 0.103209>, <0.251184, 19.133636, 0.104637>, <0.271968, 19.133636, -0.102155>, <-0.028951, 19.130665, -0.103583>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.019901, 12.199154, -1.630894>, <-1.663698, 12.187148, -1.662180>, <-1.689023, 12.187148, -0.436267>, <-0.045228, 12.199154, -0.404982>, 
      <-0.029775, 14.037173, -0.380862>, <-2.538042, 14.021639, -0.408865>, <-2.570520, 14.021639, 0.351832>, <-0.062255, 14.037173, 0.379835>, 
      <-0.024580, 17.005036, -0.273674>, <-1.127950, 16.994144, -0.287504>, <-1.148732, 16.994144, 0.258967>, <-0.045363, 17.005036, 0.272797>, 
      <-0.028951, 19.130665, -0.103583>, <-0.329871, 19.127695, -0.105010>, <-0.350654, 19.127695, 0.101782>, <-0.049735, 19.130665, 0.103209>
    }
  }
  material {
    shelftex
  }
  scale <0.654858, 0.364015, 0.228485>
  rotate <10.232773, 0.170395, 94.725349>
  translate  <78.738716, 2.264199, 44.387405>
}
union { // seagull1
  object { BezPtch004 }
  cone { // Cone002
    <0,0,0>, 0.0, <0,0,1>, 1.0
    material {
      Tom_Wood
    }
    scale <0.073881, 0.081799, 0.806348>
    rotate <72.843071, 1.861525, 7.594241>
    translate  <75.182752, 3.66889, 44.258102>
  }
  sphere { // Sphere002
    <0,0,0>,1
    material {
      shelftex
    }
    scale <0.215002, 0.395164, 0.192185>
    rotate 6.433733*z
    translate  <75.317955, 2.72277, 44.562595>
  }
  rotate <-0.488544, 0.0, -17.247471>
  translate  <-67.81719, 36.767355, -9.079931>
}


torus { // Torus004
  1.5, 0.5  rotate -x*90
  material {
    Brass_Valley
  }
  scale -0.856465
  rotate <183.96286, -180.014267, -171.209747>
  translate  <3.741416, 77.102302, 16.591532>
}


merge {  // RndDisc004
  difference {
    cylinder { <0,0,1>,<0,0,0>, 1   scale <0.9000, 0.9000, 1.0000> }
    cylinder { <0,0,1>,<0,0,0>, 1   scale <0.6000, 0.6000, 1.0200> translate -0.0100*z }
  }
  difference {
    cylinder { <0,0,1>,<0,0,0>, 1   scale <1.0000, 1.0000, 0.8000> translate 0.1000*z }
    cylinder { <0,0,1>,<0,0,0>, 1   scale <0.5000, 0.5000, 1.0200> translate -0.0900*z }
  }
  torus { 0.9000, 0.1000  rotate -x*90 translate  0.9000*z bounded_by { box { <-1.0020, -1.0020, 0.7980>, <1.0020, 1.0020, 1.0020> } } }
  torus { 0.9000, 0.1000  rotate -x*90 translate  0.1000*z bounded_by { box { <-1.0020, -1.0020, -0.0020>, <1.0020, 1.0020, 0.2020> } } }
  torus { 0.6000, 0.1000  rotate -x*90 translate  0.9000*z bounded_by { box { <-0.7020, -0.7020, 0.7980>, <0.7020, 0.7020, 1.0020> } } }
  torus { 0.6000, 0.1000  rotate -x*90 translate  0.1000*z bounded_by { box { <-0.6020, -0.6020, -0.0020>, <0.6020, 0.6020, 0.1020> } } }
  material {
    BallWood
  }
  scale <0.67263, -0.455531, 36.589096>
  rotate <2.273014, -0.204714, -0.346132>
  translate  <3.901493, 78.706117, -19.312746>
}


union { // BezPtch002
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.484452, 0.296593, -1.364935>, <-1.863276, 1.643866, 0.050435>, <-1.837969, 0.503714, 0.150705>, <-1.830785, 0.504767, 0.176295>, 
      <0.509328, 1.288512, -0.720744>, <-1.863276, 2.561159, 0.047860>, <-2.633988, 1.321504, 0.148130>, <-2.626805, 1.322557, 0.173720>, 
      <0.509328, 2.205804, -0.723318>, <-1.863276, 3.478451, 0.045285>, <-1.589212, 2.786059, 0.145555>, <-1.706407, 2.712486, 0.171145>, 
      <0.248134, 2.799713, -0.725893>, <-2.385664, 3.748977, 0.042711>, <-1.713590, 3.628725, 0.142980>, <-1.768596, 3.592464, 0.168570>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.830785, 0.504767, 0.176295>, <-1.823602, 0.505820, 0.201884>, <-1.837155, 1.647696, 0.143489>, <0.510573, 0.300422, -1.271881>, 
      <-2.626805, 1.322557, 0.173720>, <-2.619622, 1.323610, 0.199310>, <-1.837155, 2.564988, 0.140914>, <0.535448, 1.292341, -0.627689>, 
      <-1.706407, 2.712486, 0.171145>, <-1.823602, 2.638912, 0.196735>, <-1.837155, 3.482280, 0.138340>, <0.535448, 2.209633, -0.630264>, 
      <-1.768596, 3.592464, 0.168570>, <-1.823602, 3.556204, 0.194160>, <-2.359543, 3.578677, 0.135765>, <0.274254, 2.716478, -0.632839>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.510573, 0.300422, -1.271881>, <2.858301, -1.046852, -2.687251>, <7.509610, -2.891774, -4.678068>, <7.502427, -2.892827, -4.703658>, 
      <0.535448, 1.292341, -0.627689>, <2.908052, 0.019694, -1.396293>, <3.828018, -1.626223, -4.431886>, <3.820835, -1.627276, -4.457476>, 
      <0.535448, 2.209633, -0.630264>, <2.908052, 0.936986, -1.398868>, <3.828018, -0.708931, -4.434461>, <3.820835, -0.709984, -4.460051>, 
      <0.274254, 2.716478, -0.632839>, <2.908052, 1.854279, -1.401443>, <2.459859, 1.775526, -2.297732>, <2.452676, 1.774472, -2.323322>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <7.502427, -2.892827, -4.703658>, <7.495244, -2.893880, -4.729248>, <2.832180, -1.050681, -2.780305>, <0.484452, 0.296593, -1.364935>, 
      <3.820835, -1.627276, -4.457476>, <3.813652, -1.628329, -4.483066>, <2.881931, 0.015865, -1.489347>, <0.509328, 1.288512, -0.720744>, 
      <3.820835, -0.709984, -4.460051>, <3.813652, -0.711037, -4.485641>, <2.881931, 0.933157, -1.491922>, <0.509328, 2.205804, -0.723318>, 
      <2.452676, 1.774472, -2.323322>, <2.445493, 1.773419, -2.348912>, <2.881931, 1.850449, -1.494497>, <0.248134, 2.799713, -0.725893>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.248134, 2.799713, -0.725893>, <-2.385664, 3.748977, 0.042711>, <-1.713590, 3.628725, 0.142980>, <-1.768596, 3.592464, 0.168570>, 
      <-0.013060, 3.393622, -0.728468>, <-2.908052, 4.019503, 0.040136>, <-1.837969, 4.471390, 0.140406>, <-1.830785, 4.472443, 0.165996>, 
      <-0.585200, 4.435292, -0.059401>, <-2.908052, 4.936795, 0.037561>, <-1.837969, 5.388682, 0.137831>, <-1.830785, 5.389735, 0.163421>, 
      <-0.891788, 5.385182, -0.061975>, <-2.908052, 5.854087, 0.034987>, <-1.837969, 6.305974, 0.135256>, <-1.830785, 6.307027, 0.160846>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.768596, 3.592464, 0.168570>, <-1.823602, 3.556204, 0.194160>, <-2.359543, 3.578677, 0.135765>, <0.274254, 2.716478, -0.632839>, 
      <-1.830785, 4.472443, 0.165996>, <-1.823602, 4.473496, 0.191586>, <-2.881931, 3.675073, 0.133190>, <0.013060, 3.223322, -0.635414>, 
      <-1.830785, 5.389735, 0.163421>, <-1.823602, 5.390788, 0.189011>, <-2.881931, 4.592365, 0.130615>, <-0.559079, 4.264992, 0.033653>, 
      <-1.830785, 6.307027, 0.160846>, <-1.823602, 6.308080, 0.186436>, <-2.881931, 5.509657, 0.128041>, <-0.868446, 5.214901, 0.031079>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.274254, 2.716478, -0.632839>, <2.908052, 1.854279, -1.401443>, <2.459859, 1.775526, -2.297732>, <2.452676, 1.774472, -2.323322>, 
      <0.013060, 3.223322, -0.635414>, <2.908052, 2.771571, -1.404017>, <1.091700, 4.259982, -0.161004>, <1.084517, 4.258929, -0.186593>, 
      <-0.559079, 4.264992, 0.033653>, <1.763773, 3.937619, -0.063309>, <1.091700, 4.679761, -0.163578>, <1.084517, 4.678708, -0.189168>, 
      <-0.868446, 5.214901, 0.031079>, <1.145039, 4.920145, -0.065883>, <0.840899, 5.313986, -0.166153>, <0.835244, 5.312923, -0.191743>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <2.452676, 1.774472, -2.323322>, <2.445493, 1.773419, -2.348912>, <2.881931, 1.850449, -1.494497>, <0.248134, 2.799713, -0.725893>, 
      <1.084517, 4.258929, -0.186593>, <1.077334, 4.257876, -0.212183>, <2.881931, 2.767741, -1.497072>, <-0.013060, 3.393622, -0.728468>, 
      <1.084517, 4.678708, -0.189168>, <1.077334, 4.677655, -0.214758>, <1.737653, 3.933790, -0.156363>, <-0.585200, 4.435292, -0.059401>, 
      <0.835244, 5.312923, -0.191743>, <0.829589, 5.311859, -0.217333>, <1.124476, 4.916276, -0.158937>, <-0.891788, 5.385182, -0.061975>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.891788, 5.385182, -0.061975>, <-2.908052, 5.854087, 0.034987>, <-1.837969, 6.305974, 0.135256>, <-1.830785, 6.307027, 0.160846>, 
      <-1.198376, 6.335071, -0.064550>, <-2.908052, 6.771379, 0.032412>, <-1.837969, 7.223266, 0.132682>, <-1.830785, 7.224319, 0.158271>, 
      <-1.198376, 7.087556, -0.067125>, <-2.908052, 7.340412, 0.029837>, <-1.837969, 7.792300, 0.130107>, <-1.830785, 7.793353, 0.155697>, 
      <-1.291125, 8.045973, -0.069700>, <-2.908052, 8.279654, 0.027262>, <-1.837969, 8.709592, 0.127532>, <-1.830785, 8.710645, 0.153122>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.830785, 6.307027, 0.160846>, <-1.823602, 6.308080, 0.186436>, <-2.881931, 5.509657, 0.128041>, <-0.868446, 5.214901, 0.031079>, 
      <-1.830785, 7.224319, 0.158271>, <-1.823602, 7.225372, 0.183861>, <-2.881931, 6.426949, 0.125466>, <-1.177814, 6.164810, 0.028504>, 
      <-1.830785, 7.793353, 0.155697>, <-1.823602, 7.794406, 0.181287>, <-2.881931, 7.344242, 0.122891>, <-1.177814, 7.091424, 0.025929>, 
      <-1.830785, 8.710645, 0.153122>, <-1.823602, 8.711698, 0.178712>, <-2.881931, 8.283493, 0.120317>, <-1.273996, 8.049787, 0.023355>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.868446, 5.214901, 0.031079>, <1.145039, 4.920145, -0.065883>, <0.840899, 5.313986, -0.166153>, <0.835244, 5.312923, -0.191743>, 
      <-1.177814, 6.164810, 0.028504>, <0.526304, 5.902670, -0.068458>, <0.590098, 5.948211, -0.168728>, <0.585971, 5.947137, -0.194318>, 
      <-1.177814, 7.091424, 0.025929>, <0.526304, 6.838606, -0.071033>, <0.590098, 6.884148, -0.171302>, <0.585971, 6.883073, -0.196892>, 
      <-1.273996, 8.049787, 0.023355>, <0.333940, 7.816081, -0.073607>, <-0.148789, 7.513490, -0.173877>, <-0.151027, 7.512448, -0.199467>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.835244, 5.312923, -0.191743>, <0.829589, 5.311859, -0.217333>, <1.124476, 4.916276, -0.158937>, <-0.891788, 5.385182, -0.061975>, 
      <0.585971, 5.947137, -0.194318>, <0.581845, 5.946062, -0.219908>, <0.511299, 5.898763, -0.161512>, <-1.198376, 6.335071, -0.064550>, 
      <0.585971, 6.883073, -0.196892>, <0.581845, 6.881999, -0.222482>, <0.511299, 6.834699, -0.164087>, <-1.198376, 7.087556, -0.067125>, 
      <-0.151027, 7.512448, -0.199467>, <-0.153265, 7.511406, -0.225057>, <0.325801, 7.812292, -0.166662>, <-1.291125, 8.045973, -0.069700>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.291125, 8.045973, -0.069700>, <-2.908052, 8.279654, 0.027262>, <-1.837969, 8.709592, 0.127532>, <-1.830785, 8.710645, 0.153122>, 
      <-1.383874, 9.004390, -0.072274>, <-2.908052, 9.218896, 0.024688>, <-1.837969, 9.626884, 0.124957>, <-1.830785, 9.627937, 0.150547>, 
      <-1.681301, 10.721647, -0.025098>, <-2.885572, 11.773419, 0.121615>, <-2.885572, 11.728212, 0.221885>, <-2.885572, 11.729290, 0.247475>, 
      <-2.885572, 12.454438, 0.022079>, <-2.885572, 12.716896, 0.119041>, <-2.885572, 12.667196, 0.219310>, <-2.885572, 12.668274, 0.244900>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.830785, 8.710645, 0.153122>, <-1.823602, 8.711698, 0.178712>, <-2.881931, 8.283493, 0.120317>, <-1.273996, 8.049787, 0.023355>, 
      <-1.830785, 9.627937, 0.150547>, <-1.823602, 9.628990, 0.176137>, <-2.881931, 9.222744, 0.117742>, <-1.370178, 9.008150, 0.020780>, 
      <-2.885572, 11.729290, 0.247475>, <-2.885572, 11.730368, 0.273065>, <-2.885572, 11.777357, 0.214670>, <-1.683463, 10.725452, 0.067956>, 
      <-2.885572, 12.668274, 0.244900>, <-2.885572, 12.669352, 0.270490>, <-2.885572, 12.720834, 0.212095>, <-2.885572, 12.458287, 0.115133>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.273996, 8.049787, 0.023355>, <0.333940, 7.816081, -0.073607>, <-0.148789, 7.513490, -0.173877>, <-0.151027, 7.512448, -0.199467>, 
      <-1.370178, 9.008150, 0.020780>, <0.141575, 8.793556, -0.076182>, <-0.887676, 8.142833, -0.176452>, <-0.888026, 8.141823, -0.202042>, 
      <-1.683463, 10.725452, 0.067956>, <-0.481354, 9.673547, -0.078757>, <-0.872448, 9.669590, -0.179027>, <-0.871259, 9.668580, -0.204617>, 
      <-2.885572, 12.458287, 0.115133>, <-2.885572, 12.195739, 0.018171>, <-2.885572, 12.367104, -0.124969>, <-2.885572, 12.278363, -0.129124>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.151027, 7.512448, -0.199467>, <-0.153265, 7.511406, -0.225057>, <0.325801, 7.812292, -0.166662>, <-1.291125, 8.045973, -0.069700>, 
      <-0.888026, 8.141823, -0.202042>, <-0.888376, 8.140814, -0.227632>, <0.140303, 8.789884, -0.169236>, <-1.383874, 9.004390, -0.072274>, 
      <-0.871259, 9.668580, -0.204617>, <-0.870070, 9.667571, -0.230206>, <-0.477031, 9.669875, -0.171811>, <-1.681301, 10.721647, -0.025098>, 
      <-2.885572, 12.278363, -0.129124>, <-2.885572, 12.189621, -0.133279>, <-2.885572, 12.191980, -0.074883>, <-2.885572, 12.454438, 0.022079>
    }
  }
  material {
    carpet
  }
  scale <3.0, 0.5, 2.0>
  rotate <-146.671249, -174.19191, -229.429291>
  translate  <5.172244, 68.649523, 14.126335>
}


merge {  // RndDisc003
  difference {
    cylinder { <0,0,1>,<0,0,0>, 1   scale <0.9000, 0.9000, 1.0000> }
    cylinder { <0,0,1>,<0,0,0>, 1   scale <0.6000, 0.6000, 1.0200> translate -0.0100*z }
  }
  difference {
    cylinder { <0,0,1>,<0,0,0>, 1   scale <1.0000, 1.0000, 0.8000> translate 0.1000*z }
    cylinder { <0,0,1>,<0,0,0>, 1   scale <0.5000, 0.5000, 1.0200> translate -0.0900*z }
  }
  torus { 0.9000, 0.1000  rotate -x*90 translate  0.9000*z bounded_by { box { <-1.0020, -1.0020, 0.7980>, <1.0020, 1.0020, 1.0020> } } }
  torus { 0.9000, 0.1000  rotate -x*90 translate  0.1000*z bounded_by { box { <-1.0020, -1.0020, -0.0020>, <1.0020, 1.0020, 0.2020> } } }
  torus { 0.6000, 0.1000  rotate -x*90 translate  0.9000*z bounded_by { box { <-0.7020, -0.7020, 0.7980>, <0.7020, 0.7020, 1.0020> } } }
  torus { 0.6000, 0.1000  rotate -x*90 translate  0.1000*z bounded_by { box { <-0.6020, -0.6020, -0.0020>, <0.6020, 0.6020, 0.1020> } } }
  material {
    BallWood
  }
  scale <0.192163, -0.485176, 36.599522>
  rotate <14.622756, -0.310709, -0.362747>
  translate  <75.209868, 39.240004, -20.83829>
}


object {   // gabbehmat1
  height_field {
    tga "C:\Program Files\Moray For Windows\Maps\shallows.tga"
    water_level 0.0
  }
  rotate    <-90, 0, 0> // Turn onto XY plane. Now points along -Z
  scale     <  2, 2,-2> // Scale to Cube size. Now points along +Z
  translate < -1,-1,-1> // Center around origin
  material {
    gabbeh_1
  }
  scale <13.316669, 21.127832, 0.5>
  rotate 73.298035*z
  translate  <36.094627, 23.867879, 0.685051>
}


merge {  // RndCube015
  sphere { <0.4000, 0.4000, 0.4000>, 0.1000 }
  sphere { <0.4000, -0.4000, 0.4000>, 0.1000 }
  sphere { <-0.4000, -0.4000, 0.4000>, 0.1000 }
  sphere { <-0.4000, 0.4000, 0.4000>, 0.1000 }
  sphere { <0.4000, 0.4000, -0.4000>, 0.1000 }
  sphere { <0.4000, -0.4000, -0.4000>, 0.1000 }
  sphere { <-0.4000, -0.4000, -0.4000>, 0.1000 }
  sphere { <-0.4000, 0.4000, -0.4000>, 0.1000 }
  cylinder { <0.4000, 0.4000, 0.4000>, <-0.4000, 0.4000, 0.4000>, 0.1000 }
  cylinder { <0.4000, -0.4000, 0.4000>, <-0.4000, -0.4000, 0.4000>, 0.1000 }
  cylinder { <0.4000, -0.4000, -0.4000>, <-0.4000, -0.4000, -0.4000>, 0.1000 }
  cylinder { <0.4000, 0.4000, -0.4000>, <-0.4000, 0.4000, -0.4000>, 0.1000 }
  cylinder { <0.4000, 0.4000, -0.4000>, <0.4000, 0.4000, 0.4000>, 0.1000 }
  cylinder { <0.4000, -0.4000, -0.4000>, <0.4000, -0.4000, 0.4000>, 0.1000 }
  cylinder { <-0.4000, -0.4000, -0.4000>, <-0.4000, -0.4000, 0.4000>, 0.1000 }
  cylinder { <-0.4000, 0.4000, -0.4000>, <-0.4000, 0.4000, 0.4000>, 0.1000 }
  cylinder { <0.4000, 0.4000, 0.4000>, <0.4000, -0.4000, 0.4000>, 0.1000 }
  cylinder { <0.4000, 0.4000, -0.4000>, <0.4000, -0.4000, -0.4000>, 0.1000 }
  cylinder { <-0.4000, 0.4000, -0.4000>, <-0.4000, -0.4000, -0.4000>, 0.1000 }
  cylinder { <-0.4000, 0.4000, 0.4000>, <-0.4000, -0.4000, 0.4000>, 0.1000 }
  box { <-0.4000, -0.4000, -0.5000> <0.4000, 0.4000, 0.5000> }
  box { <-0.4000, -0.5000, -0.4000> <0.4000, 0.5000, 0.4000> }
  box { <-0.5000, -0.4000, -0.4000> <0.5000, 0.4000, 0.4000> }
  material {
    Asteroid
  }
  scale <-9.075027, -10.713011, -5.485598>
  rotate <-0.0, -180.0, -179.487534>
  translate  <4.621249, -11.897035, 11.450647>
}


merge {  // RndCube014
  sphere { <0.4000, 0.4000, 0.4000>, 0.1000 }
  sphere { <0.4000, -0.4000, 0.4000>, 0.1000 }
  sphere { <-0.4000, -0.4000, 0.4000>, 0.1000 }
  sphere { <-0.4000, 0.4000, 0.4000>, 0.1000 }
  sphere { <0.4000, 0.4000, -0.4000>, 0.1000 }
  sphere { <0.4000, -0.4000, -0.4000>, 0.1000 }
  sphere { <-0.4000, -0.4000, -0.4000>, 0.1000 }
  sphere { <-0.4000, 0.4000, -0.4000>, 0.1000 }
  cylinder { <0.4000, 0.4000, 0.4000>, <-0.4000, 0.4000, 0.4000>, 0.1000 }
  cylinder { <0.4000, -0.4000, 0.4000>, <-0.4000, -0.4000, 0.4000>, 0.1000 }
  cylinder { <0.4000, -0.4000, -0.4000>, <-0.4000, -0.4000, -0.4000>, 0.1000 }
  cylinder { <0.4000, 0.4000, -0.4000>, <-0.4000, 0.4000, -0.4000>, 0.1000 }
  cylinder { <0.4000, 0.4000, -0.4000>, <0.4000, 0.4000, 0.4000>, 0.1000 }
  cylinder { <0.4000, -0.4000, -0.4000>, <0.4000, -0.4000, 0.4000>, 0.1000 }
  cylinder { <-0.4000, -0.4000, -0.4000>, <-0.4000, -0.4000, 0.4000>, 0.1000 }
  cylinder { <-0.4000, 0.4000, -0.4000>, <-0.4000, 0.4000, 0.4000>, 0.1000 }
  cylinder { <0.4000, 0.4000, 0.4000>, <0.4000, -0.4000, 0.4000>, 0.1000 }
  cylinder { <0.4000, 0.4000, -0.4000>, <0.4000, -0.4000, -0.4000>, 0.1000 }
  cylinder { <-0.4000, 0.4000, -0.4000>, <-0.4000, -0.4000, -0.4000>, 0.1000 }
  cylinder { <-0.4000, 0.4000, 0.4000>, <-0.4000, -0.4000, 0.4000>, 0.1000 }
  box { <-0.4000, -0.4000, -0.5000> <0.4000, 0.4000, 0.5000> }
  box { <-0.4000, -0.5000, -0.4000> <0.4000, 0.5000, 0.4000> }
  box { <-0.5000, -0.4000, -0.4000> <0.5000, 0.4000, 0.4000> }
  material {
    Asteroid
  }
  scale <-9.075027, -10.713011, -5.485598>
  rotate <-0.0, -180.0, -179.487534>
  translate  <-1.981265, -8.78997, 11.450647>
}


merge {  // RndCube013
  sphere { <0.4000, 0.4000, 0.4000>, 0.1000 }
  sphere { <0.4000, -0.4000, 0.4000>, 0.1000 }
  sphere { <-0.4000, -0.4000, 0.4000>, 0.1000 }
  sphere { <-0.4000, 0.4000, 0.4000>, 0.1000 }
  sphere { <0.4000, 0.4000, -0.4000>, 0.1000 }
  sphere { <0.4000, -0.4000, -0.4000>, 0.1000 }
  sphere { <-0.4000, -0.4000, -0.4000>, 0.1000 }
  sphere { <-0.4000, 0.4000, -0.4000>, 0.1000 }
  cylinder { <0.4000, 0.4000, 0.4000>, <-0.4000, 0.4000, 0.4000>, 0.1000 }
  cylinder { <0.4000, -0.4000, 0.4000>, <-0.4000, -0.4000, 0.4000>, 0.1000 }
  cylinder { <0.4000, -0.4000, -0.4000>, <-0.4000, -0.4000, -0.4000>, 0.1000 }
  cylinder { <0.4000, 0.4000, -0.4000>, <-0.4000, 0.4000, -0.4000>, 0.1000 }
  cylinder { <0.4000, 0.4000, -0.4000>, <0.4000, 0.4000, 0.4000>, 0.1000 }
  cylinder { <0.4000, -0.4000, -0.4000>, <0.4000, -0.4000, 0.4000>, 0.1000 }
  cylinder { <-0.4000, -0.4000, -0.4000>, <-0.4000, -0.4000, 0.4000>, 0.1000 }
  cylinder { <-0.4000, 0.4000, -0.4000>, <-0.4000, 0.4000, 0.4000>, 0.1000 }
  cylinder { <0.4000, 0.4000, 0.4000>, <0.4000, -0.4000, 0.4000>, 0.1000 }
  cylinder { <0.4000, 0.4000, -0.4000>, <0.4000, -0.4000, -0.4000>, 0.1000 }
  cylinder { <-0.4000, 0.4000, -0.4000>, <-0.4000, -0.4000, -0.4000>, 0.1000 }
  cylinder { <-0.4000, 0.4000, 0.4000>, <-0.4000, -0.4000, 0.4000>, 0.1000 }
  box { <-0.4000, -0.4000, -0.5000> <0.4000, 0.4000, 0.5000> }
  box { <-0.4000, -0.5000, -0.4000> <0.4000, 0.5000, 0.4000> }
  box { <-0.5000, -0.4000, -0.4000> <0.5000, 0.4000, 0.4000> }
  material {
    Asteroid
  }
  scale <-8.536794, -13.579533, -4.247494>
  rotate <-0.0, -180.0, -275.710236>
  translate  <6.364373, -12.95916, 16.290721>
}


merge {  // RndCube012
  sphere { <0.4000, 0.4000, 0.4000>, 0.1000 }
  sphere { <0.4000, -0.4000, 0.4000>, 0.1000 }
  sphere { <-0.4000, -0.4000, 0.4000>, 0.1000 }
  sphere { <-0.4000, 0.4000, 0.4000>, 0.1000 }
  sphere { <0.4000, 0.4000, -0.4000>, 0.1000 }
  sphere { <0.4000, -0.4000, -0.4000>, 0.1000 }
  sphere { <-0.4000, -0.4000, -0.4000>, 0.1000 }
  sphere { <-0.4000, 0.4000, -0.4000>, 0.1000 }
  cylinder { <0.4000, 0.4000, 0.4000>, <-0.4000, 0.4000, 0.4000>, 0.1000 }
  cylinder { <0.4000, -0.4000, 0.4000>, <-0.4000, -0.4000, 0.4000>, 0.1000 }
  cylinder { <0.4000, -0.4000, -0.4000>, <-0.4000, -0.4000, -0.4000>, 0.1000 }
  cylinder { <0.4000, 0.4000, -0.4000>, <-0.4000, 0.4000, -0.4000>, 0.1000 }
  cylinder { <0.4000, 0.4000, -0.4000>, <0.4000, 0.4000, 0.4000>, 0.1000 }
  cylinder { <0.4000, -0.4000, -0.4000>, <0.4000, -0.4000, 0.4000>, 0.1000 }
  cylinder { <-0.4000, -0.4000, -0.4000>, <-0.4000, -0.4000, 0.4000>, 0.1000 }
  cylinder { <-0.4000, 0.4000, -0.4000>, <-0.4000, 0.4000, 0.4000>, 0.1000 }
  cylinder { <0.4000, 0.4000, 0.4000>, <0.4000, -0.4000, 0.4000>, 0.1000 }
  cylinder { <0.4000, 0.4000, -0.4000>, <0.4000, -0.4000, -0.4000>, 0.1000 }
  cylinder { <-0.4000, 0.4000, -0.4000>, <-0.4000, -0.4000, -0.4000>, 0.1000 }
  cylinder { <-0.4000, 0.4000, 0.4000>, <-0.4000, -0.4000, 0.4000>, 0.1000 }
  box { <-0.4000, -0.4000, -0.5000> <0.4000, 0.4000, 0.5000> }
  box { <-0.4000, -0.5000, -0.4000> <0.4000, 0.5000, 0.4000> }
  box { <-0.5000, -0.4000, -0.4000> <0.5000, 0.4000, 0.4000> }
  material {
    Asteroid
  }
  scale <-8.536794, -13.579533, -4.247494>
  rotate <-0.0, -180.0, -275.710236>
  translate  <-8.788668, -16.137439, 16.290721>
}


mesh {  // Dome2
triangle { <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.039206, 0.002055, 0.999229> }
triangle { <0.039206, 0.002055, 0.999229>, <0.039260, 0.000000, 0.999229>, <0.000000, 0.000000, 1.000000> }
triangle { <0.039260, 0.000000, 0.999229>, <0.039206, 0.002055, 0.999229>, <0.078352, 0.004106, 0.996917> }
triangle { <0.078352, 0.004106, 0.996917>, <0.078459, 0.000000, 0.996917>, <0.039260, 0.000000, 0.999229> }
triangle { <0.078459, 0.000000, 0.996917>, <0.078352, 0.004106, 0.996917>, <0.117376, 0.006151, 0.993068> }
triangle { <0.117376, 0.006151, 0.993068>, <0.117537, 0.000000, 0.993068>, <0.078459, 0.000000, 0.996917> }
triangle { <0.117537, 0.000000, 0.993068>, <0.117376, 0.006151, 0.993068>, <0.156220, 0.008187, 0.987688> }
triangle { <0.156220, 0.008187, 0.987688>, <0.156434, 0.000000, 0.987688>, <0.117537, 0.000000, 0.993068> }
triangle { <0.156434, 0.000000, 0.987688>, <0.156220, 0.008187, 0.987688>, <0.194823, 0.010210, 0.980785> }
triangle { <0.194823, 0.010210, 0.980785>, <0.195090, 0.000000, 0.980785>, <0.156434, 0.000000, 0.987688> }
triangle { <0.195090, 0.000000, 0.980785>, <0.194823, 0.010210, 0.980785>, <0.233125, 0.012218, 0.972370> }
triangle { <0.233125, 0.012218, 0.972370>, <0.233445, 0.000000, 0.972370>, <0.195090, 0.000000, 0.980785> }
triangle { <0.233445, 0.000000, 0.972370>, <0.233125, 0.012218, 0.972370>, <0.271068, 0.014206, 0.962455> }
triangle { <0.271068, 0.014206, 0.962455>, <0.271440, 0.000000, 0.962455>, <0.233445, 0.000000, 0.972370> }
triangle { <0.271440, 0.000000, 0.962455>, <0.271068, 0.014206, 0.962455>, <0.308593, 0.016173, 0.951057> }
triangle { <0.308593, 0.016173, 0.951057>, <0.309017, 0.000000, 0.951057>, <0.271440, 0.000000, 0.962455> }
triangle { <0.309017, 0.000000, 0.951057>, <0.308593, 0.016173, 0.951057>, <0.345643, 0.018114, 0.938191> }
triangle { <0.345643, 0.018114, 0.938191>, <0.346117, 0.000000, 0.938191>, <0.309017, 0.000000, 0.951057> }
triangle { <0.346117, 0.000000, 0.938191>, <0.345643, 0.018114, 0.938191>, <0.382159, 0.020028, 0.923880> }
triangle { <0.382159, 0.020028, 0.923880>, <0.382683, 0.000000, 0.923880>, <0.346117, 0.000000, 0.938191> }
triangle { <0.382683, 0.000000, 0.923880>, <0.382159, 0.020028, 0.923880>, <0.418086, 0.021911, 0.908143> }
triangle { <0.418086, 0.021911, 0.908143>, <0.418660, 0.000000, 0.908143>, <0.382683, 0.000000, 0.923880> }
triangle { <0.418660, 0.000000, 0.908143>, <0.418086, 0.021911, 0.908143>, <0.453368, 0.023760, 0.891007> }
triangle { <0.453368, 0.023760, 0.891007>, <0.453990, 0.000000, 0.891007>, <0.418660, 0.000000, 0.908143> }
triangle { <0.453990, 0.000000, 0.891007>, <0.453368, 0.023760, 0.891007>, <0.487952, 0.025572, 0.872496> }
triangle { <0.487952, 0.025572, 0.872496>, <0.488621, 0.000000, 0.872496>, <0.453990, 0.000000, 0.891007> }
triangle { <0.488621, 0.000000, 0.872496>, <0.487952, 0.025572, 0.872496>, <0.521782, 0.027345, 0.852640> }
triangle { <0.521782, 0.027345, 0.852640>, <0.522499, 0.000000, 0.852640>, <0.488621, 0.000000, 0.872496> }
triangle { <0.522499, 0.000000, 0.852640>, <0.521782, 0.027345, 0.852640>, <0.554809, 0.029076, 0.831470> }
triangle { <0.554809, 0.029076, 0.831470>, <0.555570, 0.000000, 0.831470>, <0.522499, 0.000000, 0.852640> }
triangle { <0.555570, 0.000000, 0.831470>, <0.554809, 0.029076, 0.831470>, <0.586980, 0.030762, 0.809017> }
triangle { <0.586980, 0.030762, 0.809017>, <0.587785, 0.000000, 0.809017>, <0.555570, 0.000000, 0.831470> }
triangle { <0.587785, 0.000000, 0.809017>, <0.586980, 0.030762, 0.809017>, <0.618246, 0.032401, 0.785317> }
triangle { <0.618246, 0.032401, 0.785317>, <0.619094, 0.000000, 0.785317>, <0.587785, 0.000000, 0.809017> }
triangle { <0.619094, 0.000000, 0.785317>, <0.618246, 0.032401, 0.785317>, <0.648558, 0.033989, 0.760406> }
triangle { <0.648558, 0.033989, 0.760406>, <0.649448, 0.000000, 0.760406>, <0.619094, 0.000000, 0.785317> }
triangle { <0.649448, 0.000000, 0.760406>, <0.648558, 0.033989, 0.760406>, <0.677870, 0.035526, 0.734323> }
triangle { <0.677870, 0.035526, 0.734323>, <0.678801, 0.000000, 0.734323>, <0.649448, 0.000000, 0.760406> }
triangle { <0.678801, 0.000000, 0.734323>, <0.677870, 0.035526, 0.734323>, <0.706138, 0.037007, 0.707107> }
triangle { <0.706138, 0.037007, 0.707107>, <0.707107, 0.000000, 0.707107>, <0.678801, 0.000000, 0.734323> }
triangle { <0.707107, 0.000000, 0.707107>, <0.706138, 0.037007, 0.707107>, <0.733316, 0.038431, 0.678801> }
triangle { <0.733316, 0.038431, 0.678801>, <0.734323, 0.000000, 0.678801>, <0.707107, 0.000000, 0.707107> }
triangle { <0.734323, 0.000000, 0.678801>, <0.733316, 0.038431, 0.678801>, <0.759364, 0.039797, 0.649448> }
triangle { <0.759364, 0.039797, 0.649448>, <0.760406, 0.000000, 0.649448>, <0.734323, 0.000000, 0.678801> }
triangle { <0.760406, 0.000000, 0.649448>, <0.759364, 0.039797, 0.649448>, <0.784241, 0.041100, 0.619094> }
triangle { <0.784241, 0.041100, 0.619094>, <0.785317, 0.000000, 0.619094>, <0.760406, 0.000000, 0.649448> }
triangle { <0.785317, 0.000000, 0.619094>, <0.784241, 0.041100, 0.619094>, <0.807908, 0.042341, 0.587785> }
triangle { <0.807908, 0.042341, 0.587785>, <0.809017, 0.000000, 0.587785>, <0.785317, 0.000000, 0.619094> }
triangle { <0.809017, 0.000000, 0.587785>, <0.807908, 0.042341, 0.587785>, <0.830330, 0.043516, 0.555570> }
triangle { <0.830330, 0.043516, 0.555570>, <0.831470, 0.000000, 0.555570>, <0.809017, 0.000000, 0.587785> }
triangle { <0.831470, 0.000000, 0.555570>, <0.830330, 0.043516, 0.555570>, <0.851472, 0.044624, 0.522499> }
triangle { <0.851472, 0.044624, 0.522499>, <0.852640, 0.000000, 0.522499>, <0.831470, 0.000000, 0.555570> }
triangle { <0.852640, 0.000000, 0.522499>, <0.851472, 0.044624, 0.522499>, <0.871300, 0.045663, 0.488621> }
triangle { <0.871300, 0.045663, 0.488621>, <0.872496, 0.000000, 0.488621>, <0.852640, 0.000000, 0.522499> }
triangle { <0.872496, 0.000000, 0.488621>, <0.871300, 0.045663, 0.488621>, <0.889785, 0.046632, 0.453990> }
triangle { <0.889785, 0.046632, 0.453990>, <0.891007, 0.000000, 0.453990>, <0.872496, 0.000000, 0.488621> }
triangle { <0.891007, 0.000000, 0.453990>, <0.889785, 0.046632, 0.453990>, <0.906899, 0.047529, 0.418660> }
triangle { <0.906899, 0.047529, 0.418660>, <0.908143, 0.000000, 0.418660>, <0.891007, 0.000000, 0.453990> }
triangle { <0.908143, 0.000000, 0.418660>, <0.906899, 0.047529, 0.418660>, <0.922613, 0.048352, 0.382683> }
triangle { <0.922613, 0.048352, 0.382683>, <0.923880, 0.000000, 0.382683>, <0.908143, 0.000000, 0.418660> }
triangle { <0.923880, 0.000000, 0.382683>, <0.922613, 0.048352, 0.382683>, <0.936906, 0.049101, 0.346117> }
triangle { <0.936906, 0.049101, 0.346117>, <0.938191, 0.000000, 0.346117>, <0.923880, 0.000000, 0.382683> }
triangle { <0.938191, 0.000000, 0.346117>, <0.936906, 0.049101, 0.346117>, <0.949753, 0.049774, 0.309017> }
triangle { <0.949753, 0.049774, 0.309017>, <0.951057, 0.000000, 0.309017>, <0.938191, 0.000000, 0.346117> }
triangle { <0.951057, 0.000000, 0.309017>, <0.949753, 0.049774, 0.309017>, <0.961136, 0.050371, 0.271440> }
triangle { <0.961136, 0.050371, 0.271440>, <0.962455, 0.000000, 0.271440>, <0.951057, 0.000000, 0.309017> }
triangle { <0.962455, 0.000000, 0.271440>, <0.961136, 0.050371, 0.271440>, <0.971037, 0.050890, 0.233445> }
triangle { <0.971037, 0.050890, 0.233445>, <0.972370, 0.000000, 0.233445>, <0.962455, 0.000000, 0.271440> }
triangle { <0.972370, 0.000000, 0.233445>, <0.971037, 0.050890, 0.233445>, <0.979441, 0.051330, 0.195090> }
triangle { <0.979441, 0.051330, 0.195090>, <0.980785, 0.000000, 0.195090>, <0.972370, 0.000000, 0.233445> }
triangle { <0.980785, 0.000000, 0.195090>, <0.979441, 0.051330, 0.195090>, <0.986335, 0.051692, 0.156434> }
triangle { <0.986335, 0.051692, 0.156434>, <0.987688, 0.000000, 0.156434>, <0.980785, 0.000000, 0.195090> }
triangle { <0.987688, 0.000000, 0.156434>, <0.986335, 0.051692, 0.156434>, <0.991707, 0.051973, 0.117537> }
triangle { <0.991707, 0.051973, 0.117537>, <0.993068, 0.000000, 0.117537>, <0.987688, 0.000000, 0.156434> }
triangle { <0.993068, 0.000000, 0.117537>, <0.991707, 0.051973, 0.117537>, <0.995551, 0.052175, 0.078459> }
triangle { <0.995551, 0.052175, 0.078459>, <0.996917, 0.000000, 0.078459>, <0.993068, 0.000000, 0.117537> }
triangle { <0.996917, 0.000000, 0.078459>, <0.995551, 0.052175, 0.078459>, <0.997860, 0.052296, 0.039260> }
triangle { <0.997860, 0.052296, 0.039260>, <0.999229, 0.000000, 0.039260>, <0.996917, 0.000000, 0.078459> }
triangle { <0.999229, 0.000000, 0.039260>, <0.997860, 0.052296, 0.039260>, <0.998630, 0.052336, -0.000000> }
triangle { <0.998630, 0.052336, -0.000000>, <1.000000, 0.000000, -0.000000>, <0.999229, 0.000000, 0.039260> }
triangle { <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.039045, 0.004104, 0.999229> }
triangle { <0.039045, 0.004104, 0.999229>, <0.039206, 0.002055, 0.999229>, <0.000000, 0.000000, 1.000000> }
triangle { <0.039206, 0.002055, 0.999229>, <0.039045, 0.004104, 0.999229>, <0.078029, 0.008201, 0.996917> }
triangle { <0.078029, 0.008201, 0.996917>, <0.078352, 0.004106, 0.996917>, <0.039206, 0.002055, 0.999229> }
triangle { <0.078352, 0.004106, 0.996917>, <0.078029, 0.008201, 0.996917>, <0.116894, 0.012286, 0.993068> }
triangle { <0.116894, 0.012286, 0.993068>, <0.117376, 0.006151, 0.993068>, <0.078352, 0.004106, 0.996917> }
triangle { <0.117376, 0.006151, 0.993068>, <0.116894, 0.012286, 0.993068>, <0.155578, 0.016352, 0.987688> }
triangle { <0.155578, 0.016352, 0.987688>, <0.156220, 0.008187, 0.987688>, <0.117376, 0.006151, 0.993068> }
triangle { <0.156220, 0.008187, 0.987688>, <0.155578, 0.016352, 0.987688>, <0.194022, 0.020392, 0.980785> }
triangle { <0.194022, 0.020392, 0.980785>, <0.194823, 0.010210, 0.980785>, <0.156220, 0.008187, 0.987688> }
triangle { <0.194823, 0.010210, 0.980785>, <0.194022, 0.020392, 0.980785>, <0.232167, 0.024402, 0.972370> }
triangle { <0.232167, 0.024402, 0.972370>, <0.233125, 0.012218, 0.972370>, <0.194823, 0.010210, 0.980785> }
triangle { <0.233125, 0.012218, 0.972370>, <0.232167, 0.024402, 0.972370>, <0.269953, 0.028373, 0.962455> }
triangle { <0.269953, 0.028373, 0.962455>, <0.271068, 0.014206, 0.962455>, <0.233125, 0.012218, 0.972370> }
triangle { <0.271068, 0.014206, 0.962455>, <0.269953, 0.028373, 0.962455>, <0.307324, 0.032301, 0.951057> }
triangle { <0.307324, 0.032301, 0.951057>, <0.308593, 0.016173, 0.951057>, <0.271068, 0.014206, 0.962455> }
triangle { <0.308593, 0.016173, 0.951057>, <0.307324, 0.032301, 0.951057>, <0.344221, 0.036179, 0.938191> }
triangle { <0.344221, 0.036179, 0.938191>, <0.345643, 0.018114, 0.938191>, <0.308593, 0.016173, 0.951057> }
triangle { <0.345643, 0.018114, 0.938191>, <0.344221, 0.036179, 0.938191>, <0.380587, 0.040001, 0.923880> }
triangle { <0.380587, 0.040001, 0.923880>, <0.382159, 0.020028, 0.923880>, <0.345643, 0.018114, 0.938191> }
triangle { <0.382159, 0.020028, 0.923880>, <0.380587, 0.040001, 0.923880>, <0.416366, 0.043762, 0.908143> }
triangle { <0.416366, 0.043762, 0.908143>, <0.418086, 0.021911, 0.908143>, <0.382159, 0.020028, 0.923880> }
triangle { <0.418086, 0.021911, 0.908143>, <0.416366, 0.043762, 0.908143>, <0.451503, 0.047455, 0.891007> }
triangle { <0.451503, 0.047455, 0.891007>, <0.453368, 0.023760, 0.891007>, <0.418086, 0.021911, 0.908143> }
triangle { <0.453368, 0.023760, 0.891007>, <0.451503, 0.047455, 0.891007>, <0.485945, 0.051075, 0.872496> }
triangle { <0.485945, 0.051075, 0.872496>, <0.487952, 0.025572, 0.872496>, <0.453368, 0.023760, 0.891007> }
triangle { <0.487952, 0.025572, 0.872496>, <0.485945, 0.051075, 0.872496>, <0.519636, 0.054616, 0.852640> }
triangle { <0.519636, 0.054616, 0.852640>, <0.521782, 0.027345, 0.852640>, <0.487952, 0.025572, 0.872496> }
triangle { <0.521782, 0.027345, 0.852640>, <0.519636, 0.054616, 0.852640>, <0.552527, 0.058073, 0.831470> }
triangle { <0.552527, 0.058073, 0.831470>, <0.554809, 0.029076, 0.831470>, <0.521782, 0.027345, 0.852640> }
triangle { <0.554809, 0.029076, 0.831470>, <0.552527, 0.058073, 0.831470>, <0.584565, 0.061440, 0.809017> }
triangle { <0.584565, 0.061440, 0.809017>, <0.586980, 0.030762, 0.809017>, <0.554809, 0.029076, 0.831470> }
triangle { <0.586980, 0.030762, 0.809017>, <0.584565, 0.061440, 0.809017>, <0.615702, 0.064713, 0.785317> }
triangle { <0.615702, 0.064713, 0.785317>, <0.618246, 0.032401, 0.785317>, <0.586980, 0.030762, 0.809017> }
triangle { <0.618246, 0.032401, 0.785317>, <0.615702, 0.064713, 0.785317>, <0.645890, 0.067886, 0.760406> }
triangle { <0.645890, 0.067886, 0.760406>, <0.648558, 0.033989, 0.760406>, <0.618246, 0.032401, 0.785317> }
triangle { <0.648558, 0.033989, 0.760406>, <0.645890, 0.067886, 0.760406>, <0.675082, 0.070954, 0.734323> }
triangle { <0.675082, 0.070954, 0.734323>, <0.677870, 0.035526, 0.734323>, <0.648558, 0.033989, 0.760406> }
triangle { <0.677870, 0.035526, 0.734323>, <0.675082, 0.070954, 0.734323>, <0.703233, 0.073913, 0.707107> }
triangle { <0.703233, 0.073913, 0.707107>, <0.706138, 0.037007, 0.707107>, <0.677870, 0.035526, 0.734323> }
triangle { <0.706138, 0.037007, 0.707107>, <0.703233, 0.073913, 0.707107>, <0.730300, 0.076758, 0.678801> }
triangle { <0.730300, 0.076758, 0.678801>, <0.733316, 0.038431, 0.678801>, <0.706138, 0.037007, 0.707107> }
triangle { <0.733316, 0.038431, 0.678801>, <0.730300, 0.076758, 0.678801>, <0.756240, 0.079484, 0.649448> }
triangle { <0.756240, 0.079484, 0.649448>, <0.759364, 0.039797, 0.649448>, <0.733316, 0.038431, 0.678801> }
triangle { <0.759364, 0.039797, 0.649448>, <0.756240, 0.079484, 0.649448>, <0.781015, 0.082088, 0.619094> }
triangle { <0.781015, 0.082088, 0.619094>, <0.784241, 0.041100, 0.619094>, <0.759364, 0.039797, 0.649448> }
triangle { <0.784241, 0.041100, 0.619094>, <0.781015, 0.082088, 0.619094>, <0.804585, 0.084565, 0.587785> }
triangle { <0.804585, 0.084565, 0.587785>, <0.807908, 0.042341, 0.587785>, <0.784241, 0.041100, 0.619094> }
triangle { <0.807908, 0.042341, 0.587785>, <0.804585, 0.084565, 0.587785>, <0.826915, 0.086912, 0.555570> }
triangle { <0.826915, 0.086912, 0.555570>, <0.830330, 0.043516, 0.555570>, <0.807908, 0.042341, 0.587785> }
triangle { <0.830330, 0.043516, 0.555570>, <0.826915, 0.086912, 0.555570>, <0.847969, 0.089125, 0.522499> }
triangle { <0.847969, 0.089125, 0.522499>, <0.851472, 0.044624, 0.522499>, <0.830330, 0.043516, 0.555570> }
triangle { <0.851472, 0.044624, 0.522499>, <0.847969, 0.089125, 0.522499>, <0.867716, 0.091201, 0.488621> }
triangle { <0.867716, 0.091201, 0.488621>, <0.871300, 0.045663, 0.488621>, <0.851472, 0.044624, 0.522499> }
triangle { <0.871300, 0.045663, 0.488621>, <0.867716, 0.091201, 0.488621>, <0.886125, 0.093136, 0.453990> }
triangle { <0.886125, 0.093136, 0.453990>, <0.889785, 0.046632, 0.453990>, <0.871300, 0.045663, 0.488621> }
triangle { <0.889785, 0.046632, 0.453990>, <0.886125, 0.093136, 0.453990>, <0.903168, 0.094927, 0.418660> }
triangle { <0.903168, 0.094927, 0.418660>, <0.906899, 0.047529, 0.418660>, <0.889785, 0.046632, 0.453990> }
triangle { <0.906899, 0.047529, 0.418660>, <0.903168, 0.094927, 0.418660>, <0.918818, 0.096572, 0.382683> }
triangle { <0.918818, 0.096572, 0.382683>, <0.922613, 0.048352, 0.382683>, <0.906899, 0.047529, 0.418660> }
triangle { <0.922613, 0.048352, 0.382683>, <0.918818, 0.096572, 0.382683>, <0.933052, 0.098068, 0.346117> }
triangle { <0.933052, 0.098068, 0.346117>, <0.936906, 0.049101, 0.346117>, <0.922613, 0.048352, 0.382683> }
triangle { <0.936906, 0.049101, 0.346117>, <0.933052, 0.098068, 0.346117>, <0.945847, 0.099412, 0.309017> }
triangle { <0.945847, 0.099412, 0.309017>, <0.949753, 0.049774, 0.309017>, <0.936906, 0.049101, 0.346117> }
triangle { <0.949753, 0.049774, 0.309017>, <0.945847, 0.099412, 0.309017>, <0.957183, 0.100604, 0.271440> }
triangle { <0.957183, 0.100604, 0.271440>, <0.961136, 0.050371, 0.271440>, <0.949753, 0.049774, 0.309017> }
triangle { <0.961136, 0.050371, 0.271440>, <0.957183, 0.100604, 0.271440>, <0.967043, 0.101640, 0.233445> }
triangle { <0.967043, 0.101640, 0.233445>, <0.971037, 0.050890, 0.233445>, <0.961136, 0.050371, 0.271440> }
triangle { <0.971037, 0.050890, 0.233445>, <0.967043, 0.101640, 0.233445>, <0.975412, 0.102520, 0.195090> }
triangle { <0.975412, 0.102520, 0.195090>, <0.979441, 0.051330, 0.195090>, <0.971037, 0.050890, 0.233445> }
triangle { <0.979441, 0.051330, 0.195090>, <0.975412, 0.102520, 0.195090>, <0.982278, 0.103242, 0.156434> }
triangle { <0.982278, 0.103242, 0.156434>, <0.986335, 0.051692, 0.156434>, <0.979441, 0.051330, 0.195090> }
triangle { <0.986335, 0.051692, 0.156434>, <0.982278, 0.103242, 0.156434>, <0.987628, 0.103804, 0.117537> }
triangle { <0.987628, 0.103804, 0.117537>, <0.991707, 0.051973, 0.117537>, <0.986335, 0.051692, 0.156434> }
triangle { <0.991707, 0.051973, 0.117537>, <0.987628, 0.103804, 0.117537>, <0.991456, 0.104206, 0.078459> }
triangle { <0.991456, 0.104206, 0.078459>, <0.995551, 0.052175, 0.078459>, <0.991707, 0.051973, 0.117537> }
triangle { <0.995551, 0.052175, 0.078459>, <0.991456, 0.104206, 0.078459>, <0.993755, 0.104448, 0.039260> }
triangle { <0.993755, 0.104448, 0.039260>, <0.997860, 0.052296, 0.039260>, <0.995551, 0.052175, 0.078459> }
triangle { <0.997860, 0.052296, 0.039260>, <0.993755, 0.104448, 0.039260>, <0.994522, 0.104528, -0.000000> }
triangle { <0.994522, 0.104528, -0.000000>, <0.998630, 0.052336, -0.000000>, <0.997860, 0.052296, 0.039260> }
triangle { <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.038776, 0.006142, 0.999229> }
triangle { <0.038776, 0.006142, 0.999229>, <0.039045, 0.004104, 0.999229>, <0.000000, 0.000000, 1.000000> }
triangle { <0.039045, 0.004104, 0.999229>, <0.038776, 0.006142, 0.999229>, <0.077493, 0.012274, 0.996917> }
triangle { <0.077493, 0.012274, 0.996917>, <0.078029, 0.008201, 0.996917>, <0.039045, 0.004104, 0.999229> }
triangle { <0.078029, 0.008201, 0.996917>, <0.077493, 0.012274, 0.996917>, <0.116090, 0.018387, 0.993068> }
triangle { <0.116090, 0.018387, 0.993068>, <0.116894, 0.012286, 0.993068>, <0.078029, 0.008201, 0.996917> }
triangle { <0.116894, 0.012286, 0.993068>, <0.116090, 0.018387, 0.993068>, <0.154508, 0.024472, 0.987688> }
triangle { <0.154508, 0.024472, 0.987688>, <0.155578, 0.016352, 0.987688>, <0.116894, 0.012286, 0.993068> }
triangle { <0.155578, 0.016352, 0.987688>, <0.154508, 0.024472, 0.987688>, <0.192688, 0.030519, 0.980785> }
triangle { <0.192688, 0.030519, 0.980785>, <0.194022, 0.020392, 0.980785>, <0.155578, 0.016352, 0.987688> }
triangle { <0.194022, 0.020392, 0.980785>, <0.192688, 0.030519, 0.980785>, <0.230571, 0.036519, 0.972370> }
triangle { <0.230571, 0.036519, 0.972370>, <0.232167, 0.024402, 0.972370>, <0.194022, 0.020392, 0.980785> }
triangle { <0.232167, 0.024402, 0.972370>, <0.230571, 0.036519, 0.972370>, <0.268099, 0.042463, 0.962455> }
triangle { <0.268099, 0.042463, 0.962455>, <0.269953, 0.028373, 0.962455>, <0.232167, 0.024402, 0.972370> }
triangle { <0.269953, 0.028373, 0.962455>, <0.268099, 0.042463, 0.962455>, <0.305212, 0.048341, 0.951057> }
triangle { <0.305212, 0.048341, 0.951057>, <0.307324, 0.032301, 0.951057>, <0.269953, 0.028373, 0.962455> }
triangle { <0.307324, 0.032301, 0.951057>, <0.305212, 0.048341, 0.951057>, <0.341856, 0.054145, 0.938191> }
triangle { <0.341856, 0.054145, 0.938191>, <0.344221, 0.036179, 0.938191>, <0.307324, 0.032301, 0.951057> }
triangle { <0.344221, 0.036179, 0.938191>, <0.341856, 0.054145, 0.938191>, <0.377972, 0.059865, 0.923880> }
triangle { <0.377972, 0.059865, 0.923880>, <0.380587, 0.040001, 0.923880>, <0.344221, 0.036179, 0.938191> }
triangle { <0.380587, 0.040001, 0.923880>, <0.377972, 0.059865, 0.923880>, <0.413505, 0.065493, 0.908143> }
triangle { <0.413505, 0.065493, 0.908143>, <0.416366, 0.043762, 0.908143>, <0.380587, 0.040001, 0.923880> }
triangle { <0.416366, 0.043762, 0.908143>, <0.413505, 0.065493, 0.908143>, <0.448401, 0.071020, 0.891007> }
triangle { <0.448401, 0.071020, 0.891007>, <0.451503, 0.047455, 0.891007>, <0.416366, 0.043762, 0.908143> }
triangle { <0.451503, 0.047455, 0.891007>, <0.448401, 0.071020, 0.891007>, <0.482606, 0.076437, 0.872496> }
triangle { <0.482606, 0.076437, 0.872496>, <0.485945, 0.051075, 0.872496>, <0.451503, 0.047455, 0.891007> }
triangle { <0.485945, 0.051075, 0.872496>, <0.482606, 0.076437, 0.872496>, <0.516066, 0.081737, 0.852640> }
triangle { <0.516066, 0.081737, 0.852640>, <0.519636, 0.054616, 0.852640>, <0.485945, 0.051075, 0.872496> }
triangle { <0.519636, 0.054616, 0.852640>, <0.516066, 0.081737, 0.852640>, <0.548730, 0.086910, 0.831470> }
triangle { <0.548730, 0.086910, 0.831470>, <0.552527, 0.058073, 0.831470>, <0.519636, 0.054616, 0.852640> }
triangle { <0.552527, 0.058073, 0.831470>, <0.548730, 0.086910, 0.831470>, <0.580549, 0.091950, 0.809017> }
triangle { <0.580549, 0.091950, 0.809017>, <0.584565, 0.061440, 0.809017>, <0.552527, 0.058073, 0.831470> }
triangle { <0.584565, 0.061440, 0.809017>, <0.580549, 0.091950, 0.809017>, <0.611472, 0.096848, 0.785317> }
triangle { <0.611472, 0.096848, 0.785317>, <0.615702, 0.064713, 0.785317>, <0.584565, 0.061440, 0.809017> }
triangle { <0.615702, 0.064713, 0.785317>, <0.611472, 0.096848, 0.785317>, <0.641452, 0.101596, 0.760406> }
triangle { <0.641452, 0.101596, 0.760406>, <0.645890, 0.067886, 0.760406>, <0.615702, 0.064713, 0.785317> }
triangle { <0.645890, 0.067886, 0.760406>, <0.641452, 0.101596, 0.760406>, <0.670444, 0.106188, 0.734323> }
triangle { <0.670444, 0.106188, 0.734323>, <0.675082, 0.070954, 0.734323>, <0.645890, 0.067886, 0.760406> }
triangle { <0.675082, 0.070954, 0.734323>, <0.670444, 0.106188, 0.734323>, <0.698401, 0.110616, 0.707107> }
triangle { <0.698401, 0.110616, 0.707107>, <0.703233, 0.073913, 0.707107>, <0.675082, 0.070954, 0.734323> }
triangle { <0.703233, 0.073913, 0.707107>, <0.698401, 0.110616, 0.707107>, <0.725282, 0.114873, 0.678801> }
triangle { <0.725282, 0.114873, 0.678801>, <0.730300, 0.076758, 0.678801>, <0.703233, 0.073913, 0.707107> }
triangle { <0.730300, 0.076758, 0.678801>, <0.725282, 0.114873, 0.678801>, <0.751044, 0.118954, 0.649448> }
triangle { <0.751044, 0.118954, 0.649448>, <0.756240, 0.079484, 0.649448>, <0.730300, 0.076758, 0.678801> }
triangle { <0.756240, 0.079484, 0.649448>, <0.751044, 0.118954, 0.649448>, <0.775648, 0.122851, 0.619094> }
triangle { <0.775648, 0.122851, 0.619094>, <0.781015, 0.082088, 0.619094>, <0.756240, 0.079484, 0.649448> }
triangle { <0.781015, 0.082088, 0.619094>, <0.775648, 0.122851, 0.619094>, <0.799057, 0.126558, 0.587785> }
triangle { <0.799057, 0.126558, 0.587785>, <0.804585, 0.084565, 0.587785>, <0.781015, 0.082088, 0.619094> }
triangle { <0.804585, 0.084565, 0.587785>, <0.799057, 0.126558, 0.587785>, <0.821233, 0.130071, 0.555570> }
triangle { <0.821233, 0.130071, 0.555570>, <0.826915, 0.086912, 0.555570>, <0.804585, 0.084565, 0.587785> }
triangle { <0.826915, 0.086912, 0.555570>, <0.821233, 0.130071, 0.555570>, <0.842143, 0.133382, 0.522499> }
triangle { <0.842143, 0.133382, 0.522499>, <0.847969, 0.089125, 0.522499>, <0.826915, 0.086912, 0.555570> }
triangle { <0.847969, 0.089125, 0.522499>, <0.842143, 0.133382, 0.522499>, <0.861754, 0.136488, 0.488621> }
triangle { <0.861754, 0.136488, 0.488621>, <0.867716, 0.091201, 0.488621>, <0.847969, 0.089125, 0.522499> }
triangle { <0.867716, 0.091201, 0.488621>, <0.861754, 0.136488, 0.488621>, <0.880037, 0.139384, 0.453990> }
triangle { <0.880037, 0.139384, 0.453990>, <0.886125, 0.093136, 0.453990>, <0.867716, 0.091201, 0.488621> }
triangle { <0.886125, 0.093136, 0.453990>, <0.880037, 0.139384, 0.453990>, <0.896962, 0.142065, 0.418660> }
triangle { <0.896962, 0.142065, 0.418660>, <0.903168, 0.094927, 0.418660>, <0.886125, 0.093136, 0.453990> }
triangle { <0.903168, 0.094927, 0.418660>, <0.896962, 0.142065, 0.418660>, <0.912505, 0.144527, 0.382683> }
triangle { <0.912505, 0.144527, 0.382683>, <0.918818, 0.096572, 0.382683>, <0.903168, 0.094927, 0.418660> }
triangle { <0.918818, 0.096572, 0.382683>, <0.912505, 0.144527, 0.382683>, <0.926641, 0.146765, 0.346117> }
triangle { <0.926641, 0.146765, 0.346117>, <0.933052, 0.098068, 0.346117>, <0.918818, 0.096572, 0.382683> }
triangle { <0.933052, 0.098068, 0.346117>, <0.926641, 0.146765, 0.346117>, <0.939347, 0.148778, 0.309017> }
triangle { <0.939347, 0.148778, 0.309017>, <0.945847, 0.099412, 0.309017>, <0.933052, 0.098068, 0.346117> }
triangle { <0.945847, 0.099412, 0.309017>, <0.939347, 0.148778, 0.309017>, <0.950606, 0.150561, 0.271440> }
triangle { <0.950606, 0.150561, 0.271440>, <0.957183, 0.100604, 0.271440>, <0.945847, 0.099412, 0.309017> }
triangle { <0.957183, 0.100604, 0.271440>, <0.950606, 0.150561, 0.271440>, <0.960398, 0.152112, 0.233445> }
triangle { <0.960398, 0.152112, 0.233445>, <0.967043, 0.101640, 0.233445>, <0.957183, 0.100604, 0.271440> }
triangle { <0.967043, 0.101640, 0.233445>, <0.960398, 0.152112, 0.233445>, <0.968710, 0.153429, 0.195090> }
triangle { <0.968710, 0.153429, 0.195090>, <0.975412, 0.102520, 0.195090>, <0.967043, 0.101640, 0.233445> }
triangle { <0.975412, 0.102520, 0.195090>, <0.968710, 0.153429, 0.195090>, <0.975528, 0.154508, 0.156434> }
triangle { <0.975528, 0.154508, 0.156434>, <0.982278, 0.103242, 0.156434>, <0.975412, 0.102520, 0.195090> }
triangle { <0.982278, 0.103242, 0.156434>, <0.975528, 0.154508, 0.156434>, <0.980842, 0.155350, 0.117537> }
triangle { <0.980842, 0.155350, 0.117537>, <0.987628, 0.103804, 0.117537>, <0.982278, 0.103242, 0.156434> }
triangle { <0.987628, 0.103804, 0.117537>, <0.980842, 0.155350, 0.117537>, <0.984644, 0.155952, 0.078459> }
triangle { <0.984644, 0.155952, 0.078459>, <0.991456, 0.104206, 0.078459>, <0.987628, 0.103804, 0.117537> }
triangle { <0.991456, 0.104206, 0.078459>, <0.984644, 0.155952, 0.078459>, <0.986927, 0.156314, 0.039260> }
triangle { <0.986927, 0.156314, 0.039260>, <0.993755, 0.104448, 0.039260>, <0.991456, 0.104206, 0.078459> }
triangle { <0.993755, 0.104448, 0.039260>, <0.986927, 0.156314, 0.039260>, <0.987688, 0.156434, -0.000000> }
triangle { <0.987688, 0.156434, -0.000000>, <0.994522, 0.104528, -0.000000>, <0.993755, 0.104448, 0.039260> }
triangle { <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.038402, 0.008163, 0.999229> }
triangle { <0.038402, 0.008163, 0.999229>, <0.038776, 0.006142, 0.999229>, <0.000000, 0.000000, 1.000000> }
triangle { <0.038776, 0.006142, 0.999229>, <0.038402, 0.008163, 0.999229>, <0.076745, 0.016313, 0.996917> }
triangle { <0.076745, 0.016313, 0.996917>, <0.077493, 0.012274, 0.996917>, <0.038776, 0.006142, 0.999229> }
triangle { <0.077493, 0.012274, 0.996917>, <0.076745, 0.016313, 0.996917>, <0.114969, 0.024437, 0.993068> }
triangle { <0.114969, 0.024437, 0.993068>, <0.116090, 0.018387, 0.993068>, <0.077493, 0.012274, 0.996917> }
triangle { <0.116090, 0.018387, 0.993068>, <0.114969, 0.024437, 0.993068>, <0.153016, 0.032525, 0.987688> }
triangle { <0.153016, 0.032525, 0.987688>, <0.154508, 0.024472, 0.987688>, <0.116090, 0.018387, 0.993068> }
triangle { <0.154508, 0.024472, 0.987688>, <0.153016, 0.032525, 0.987688>, <0.190827, 0.040562, 0.980785> }
triangle { <0.190827, 0.040562, 0.980785>, <0.192688, 0.030519, 0.980785>, <0.154508, 0.024472, 0.987688> }
triangle { <0.192688, 0.030519, 0.980785>, <0.190827, 0.040562, 0.980785>, <0.228344, 0.048536, 0.972370> }
triangle { <0.228344, 0.048536, 0.972370>, <0.230571, 0.036519, 0.972370>, <0.192688, 0.030519, 0.980785> }
triangle { <0.230571, 0.036519, 0.972370>, <0.228344, 0.048536, 0.972370>, <0.265509, 0.056436, 0.962455> }
triangle { <0.265509, 0.056436, 0.962455>, <0.268099, 0.042463, 0.962455>, <0.230571, 0.036519, 0.972370> }
triangle { <0.268099, 0.042463, 0.962455>, <0.265509, 0.056436, 0.962455>, <0.302264, 0.064248, 0.951057> }
triangle { <0.302264, 0.064248, 0.951057>, <0.305212, 0.048341, 0.951057>, <0.268099, 0.042463, 0.962455> }
triangle { <0.305212, 0.048341, 0.951057>, <0.302264, 0.064248, 0.951057>, <0.338554, 0.071962, 0.938191> }
triangle { <0.338554, 0.071962, 0.938191>, <0.341856, 0.054145, 0.938191>, <0.305212, 0.048341, 0.951057> }
triangle { <0.341856, 0.054145, 0.938191>, <0.338554, 0.071962, 0.938191>, <0.374321, 0.079564, 0.923880> }
triangle { <0.374321, 0.079564, 0.923880>, <0.377972, 0.059865, 0.923880>, <0.341856, 0.054145, 0.938191> }
triangle { <0.377972, 0.059865, 0.923880>, <0.374321, 0.079564, 0.923880>, <0.409511, 0.087044, 0.908143> }
triangle { <0.409511, 0.087044, 0.908143>, <0.413505, 0.065493, 0.908143>, <0.377972, 0.059865, 0.923880> }
triangle { <0.413505, 0.065493, 0.908143>, <0.409511, 0.087044, 0.908143>, <0.444070, 0.094390, 0.891007> }
triangle { <0.444070, 0.094390, 0.891007>, <0.448401, 0.071020, 0.891007>, <0.413505, 0.065493, 0.908143> }
triangle { <0.448401, 0.071020, 0.891007>, <0.444070, 0.094390, 0.891007>, <0.477944, 0.101590, 0.872496> }
triangle { <0.477944, 0.101590, 0.872496>, <0.482606, 0.076437, 0.872496>, <0.448401, 0.071020, 0.891007> }
triangle { <0.482606, 0.076437, 0.872496>, <0.477944, 0.101590, 0.872496>, <0.511081, 0.108634, 0.852640> }
triangle { <0.511081, 0.108634, 0.852640>, <0.516066, 0.081737, 0.852640>, <0.482606, 0.076437, 0.872496> }
triangle { <0.516066, 0.081737, 0.852640>, <0.511081, 0.108634, 0.852640>, <0.543430, 0.115510, 0.831470> }
triangle { <0.543430, 0.115510, 0.831470>, <0.548730, 0.086910, 0.831470>, <0.516066, 0.081737, 0.852640> }
triangle { <0.548730, 0.086910, 0.831470>, <0.543430, 0.115510, 0.831470>, <0.574941, 0.122207, 0.809017> }
triangle { <0.574941, 0.122207, 0.809017>, <0.580549, 0.091950, 0.809017>, <0.548730, 0.086910, 0.831470> }
triangle { <0.580549, 0.091950, 0.809017>, <0.574941, 0.122207, 0.809017>, <0.605565, 0.128717, 0.785317> }
triangle { <0.605565, 0.128717, 0.785317>, <0.611472, 0.096848, 0.785317>, <0.580549, 0.091950, 0.809017> }
triangle { <0.611472, 0.096848, 0.785317>, <0.605565, 0.128717, 0.785317>, <0.635256, 0.135028, 0.760406> }
triangle { <0.635256, 0.135028, 0.760406>, <0.641452, 0.101596, 0.760406>, <0.611472, 0.096848, 0.785317> }
triangle { <0.641452, 0.101596, 0.760406>, <0.635256, 0.135028, 0.760406>, <0.663967, 0.141131, 0.734323> }
triangle { <0.663967, 0.141131, 0.734323>, <0.670444, 0.106188, 0.734323>, <0.641452, 0.101596, 0.760406> }
triangle { <0.670444, 0.106188, 0.734323>, <0.663967, 0.141131, 0.734323>, <0.691655, 0.147016, 0.707107> }
triangle { <0.691655, 0.147016, 0.707107>, <0.698401, 0.110616, 0.707107>, <0.670444, 0.106188, 0.734323> }
triangle { <0.698401, 0.110616, 0.707107>, <0.691655, 0.147016, 0.707107>, <0.718276, 0.152674, 0.678801> }
triangle { <0.718276, 0.152674, 0.678801>, <0.725282, 0.114873, 0.678801>, <0.698401, 0.110616, 0.707107> }
triangle { <0.725282, 0.114873, 0.678801>, <0.718276, 0.152674, 0.678801>, <0.743789, 0.158097, 0.649448> }
triangle { <0.743789, 0.158097, 0.649448>, <0.751044, 0.118954, 0.649448>, <0.725282, 0.114873, 0.678801> }
triangle { <0.751044, 0.118954, 0.649448>, <0.743789, 0.158097, 0.649448>, <0.768156, 0.163277, 0.619094> }
triangle { <0.768156, 0.163277, 0.619094>, <0.775648, 0.122851, 0.619094>, <0.751044, 0.118954, 0.649448> }
triangle { <0.775648, 0.122851, 0.619094>, <0.768156, 0.163277, 0.619094>, <0.791338, 0.168204, 0.587785> }
triangle { <0.791338, 0.168204, 0.587785>, <0.799057, 0.126558, 0.587785>, <0.775648, 0.122851, 0.619094> }
triangle { <0.799057, 0.126558, 0.587785>, <0.791338, 0.168204, 0.587785>, <0.813300, 0.172872, 0.555570> }
triangle { <0.813300, 0.172872, 0.555570>, <0.821233, 0.130071, 0.555570>, <0.799057, 0.126558, 0.587785> }
triangle { <0.821233, 0.130071, 0.555570>, <0.813300, 0.172872, 0.555570>, <0.834008, 0.177274, 0.522499> }
triangle { <0.834008, 0.177274, 0.522499>, <0.842143, 0.133382, 0.522499>, <0.821233, 0.130071, 0.555570> }
triangle { <0.842143, 0.133382, 0.522499>, <0.834008, 0.177274, 0.522499>, <0.853430, 0.181402, 0.488621> }
triangle { <0.853430, 0.181402, 0.488621>, <0.861754, 0.136488, 0.488621>, <0.842143, 0.133382, 0.522499> }
triangle { <0.861754, 0.136488, 0.488621>, <0.853430, 0.181402, 0.488621>, <0.871536, 0.185251, 0.453990> }
triangle { <0.871536, 0.185251, 0.453990>, <0.880037, 0.139384, 0.453990>, <0.861754, 0.136488, 0.488621> }
triangle { <0.880037, 0.139384, 0.453990>, <0.871536, 0.185251, 0.453990>, <0.888298, 0.188814, 0.418660> }
triangle { <0.888298, 0.188814, 0.418660>, <0.896962, 0.142065, 0.418660>, <0.880037, 0.139384, 0.453990> }
triangle { <0.896962, 0.142065, 0.418660>, <0.888298, 0.188814, 0.418660>, <0.903691, 0.192085, 0.382683> }
triangle { <0.903691, 0.192085, 0.382683>, <0.912505, 0.144527, 0.382683>, <0.896962, 0.142065, 0.418660> }
triangle { <0.912505, 0.144527, 0.382683>, <0.903691, 0.192085, 0.382683>, <0.917690, 0.195061, 0.346117> }
triangle { <0.917690, 0.195061, 0.346117>, <0.926641, 0.146765, 0.346117>, <0.912505, 0.144527, 0.382683> }
triangle { <0.926641, 0.146765, 0.346117>, <0.917690, 0.195061, 0.346117>, <0.930274, 0.197736, 0.309017> }
triangle { <0.930274, 0.197736, 0.309017>, <0.939347, 0.148778, 0.309017>, <0.926641, 0.146765, 0.346117> }
triangle { <0.939347, 0.148778, 0.309017>, <0.930274, 0.197736, 0.309017>, <0.941423, 0.200106, 0.271440> }
triangle { <0.941423, 0.200106, 0.271440>, <0.950606, 0.150561, 0.271440>, <0.939347, 0.148778, 0.309017> }
triangle { <0.950606, 0.150561, 0.271440>, <0.941423, 0.200106, 0.271440>, <0.951121, 0.202167, 0.233445> }
triangle { <0.951121, 0.202167, 0.233445>, <0.960398, 0.152112, 0.233445>, <0.950606, 0.150561, 0.271440> }
triangle { <0.960398, 0.152112, 0.233445>, <0.951121, 0.202167, 0.233445>, <0.959353, 0.203917, 0.195090> }
triangle { <0.959353, 0.203917, 0.195090>, <0.968710, 0.153429, 0.195090>, <0.960398, 0.152112, 0.233445> }
triangle { <0.968710, 0.153429, 0.195090>, <0.959353, 0.203917, 0.195090>, <0.966105, 0.205352, 0.156434> }
triangle { <0.966105, 0.205352, 0.156434>, <0.975528, 0.154508, 0.156434>, <0.968710, 0.153429, 0.195090> }
triangle { <0.975528, 0.154508, 0.156434>, <0.966105, 0.205352, 0.156434>, <0.971368, 0.206471, 0.117537> }
triangle { <0.971368, 0.206471, 0.117537>, <0.980842, 0.155350, 0.117537>, <0.975528, 0.154508, 0.156434> }
triangle { <0.980842, 0.155350, 0.117537>, <0.971368, 0.206471, 0.117537>, <0.975132, 0.207271, 0.078459> }
triangle { <0.975132, 0.207271, 0.078459>, <0.984644, 0.155952, 0.078459>, <0.980842, 0.155350, 0.117537> }
triangle { <0.984644, 0.155952, 0.078459>, <0.975132, 0.207271, 0.078459>, <0.977393, 0.207751, 0.039260> }
triangle { <0.977393, 0.207751, 0.039260>, <0.986927, 0.156314, 0.039260>, <0.984644, 0.155952, 0.078459> }
triangle { <0.986927, 0.156314, 0.039260>, <0.977393, 0.207751, 0.039260>, <0.978148, 0.207912, -0.000000> }
triangle { <0.978148, 0.207912, -0.000000>, <0.987688, 0.156434, -0.000000>, <0.986927, 0.156314, 0.039260> }
triangle { <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.037922, 0.010161, 0.999229> }
triangle { <0.037922, 0.010161, 0.999229>, <0.038402, 0.008163, 0.999229>, <0.000000, 0.000000, 1.000000> }
triangle { <0.038402, 0.008163, 0.999229>, <0.037922, 0.010161, 0.999229>, <0.075786, 0.020307, 0.996917> }
triangle { <0.075786, 0.020307, 0.996917>, <0.076745, 0.016313, 0.996917>, <0.038402, 0.008163, 0.999229> }
triangle { <0.076745, 0.016313, 0.996917>, <0.075786, 0.020307, 0.996917>, <0.113532, 0.030421, 0.993068> }
triangle { <0.113532, 0.030421, 0.993068>, <0.114969, 0.024437, 0.993068>, <0.076745, 0.016313, 0.996917> }
triangle { <0.114969, 0.024437, 0.993068>, <0.113532, 0.030421, 0.993068>, <0.151104, 0.040488, 0.987688> }
triangle { <0.151104, 0.040488, 0.987688>, <0.153016, 0.032525, 0.987688>, <0.114969, 0.024437, 0.993068> }
triangle { <0.153016, 0.032525, 0.987688>, <0.151104, 0.040488, 0.987688>, <0.188443, 0.050493, 0.980785> }
triangle { <0.188443, 0.050493, 0.980785>, <0.190827, 0.040562, 0.980785>, <0.153016, 0.032525, 0.987688> }
triangle { <0.190827, 0.040562, 0.980785>, <0.188443, 0.050493, 0.980785>, <0.225491, 0.060420, 0.972370> }
triangle { <0.225491, 0.060420, 0.972370>, <0.228344, 0.048536, 0.972370>, <0.190827, 0.040562, 0.980785> }
triangle { <0.228344, 0.048536, 0.972370>, <0.225491, 0.060420, 0.972370>, <0.262191, 0.070254, 0.962455> }
triangle { <0.262191, 0.070254, 0.962455>, <0.265509, 0.056436, 0.962455>, <0.228344, 0.048536, 0.972370> }
triangle { <0.265509, 0.056436, 0.962455>, <0.262191, 0.070254, 0.962455>, <0.298487, 0.079979, 0.951057> }
triangle { <0.298487, 0.079979, 0.951057>, <0.302264, 0.064248, 0.951057>, <0.265509, 0.056436, 0.962455> }
triangle { <0.302264, 0.064248, 0.951057>, <0.298487, 0.079979, 0.951057>, <0.334323, 0.089582, 0.938191> }
triangle { <0.334323, 0.089582, 0.938191>, <0.338554, 0.071962, 0.938191>, <0.302264, 0.064248, 0.951057> }
triangle { <0.338554, 0.071962, 0.938191>, <0.334323, 0.089582, 0.938191>, <0.369644, 0.099046, 0.923880> }
triangle { <0.369644, 0.099046, 0.923880>, <0.374321, 0.079564, 0.923880>, <0.338554, 0.071962, 0.938191> }
triangle { <0.374321, 0.079564, 0.923880>, <0.369644, 0.099046, 0.923880>, <0.404394, 0.108357, 0.908143> }
triangle { <0.404394, 0.108357, 0.908143>, <0.409511, 0.087044, 0.908143>, <0.374321, 0.079564, 0.923880> }
triangle { <0.409511, 0.087044, 0.908143>, <0.404394, 0.108357, 0.908143>, <0.438521, 0.117501, 0.891007> }
triangle { <0.438521, 0.117501, 0.891007>, <0.444070, 0.094390, 0.891007>, <0.409511, 0.087044, 0.908143> }
triangle { <0.444070, 0.094390, 0.891007>, <0.438521, 0.117501, 0.891007>, <0.471972, 0.126464, 0.872496> }
triangle { <0.471972, 0.126464, 0.872496>, <0.477944, 0.101590, 0.872496>, <0.444070, 0.094390, 0.891007> }
triangle { <0.477944, 0.101590, 0.872496>, <0.471972, 0.126464, 0.872496>, <0.504695, 0.135233, 0.852640> }
triangle { <0.504695, 0.135233, 0.852640>, <0.511081, 0.108634, 0.852640>, <0.477944, 0.101590, 0.872496> }
triangle { <0.511081, 0.108634, 0.852640>, <0.504695, 0.135233, 0.852640>, <0.536640, 0.143792, 0.831470> }
triangle { <0.536640, 0.143792, 0.831470>, <0.543430, 0.115510, 0.831470>, <0.511081, 0.108634, 0.852640> }
triangle { <0.543430, 0.115510, 0.831470>, <0.536640, 0.143792, 0.831470>, <0.567757, 0.152130, 0.809017> }
triangle { <0.567757, 0.152130, 0.809017>, <0.574941, 0.122207, 0.809017>, <0.543430, 0.115510, 0.831470> }
triangle { <0.574941, 0.122207, 0.809017>, <0.567757, 0.152130, 0.809017>, <0.597999, 0.160233, 0.785317> }
triangle { <0.597999, 0.160233, 0.785317>, <0.605565, 0.128717, 0.785317>, <0.574941, 0.122207, 0.809017> }
triangle { <0.605565, 0.128717, 0.785317>, <0.597999, 0.160233, 0.785317>, <0.627319, 0.168090, 0.760406> }
triangle { <0.627319, 0.168090, 0.760406>, <0.635256, 0.135028, 0.760406>, <0.605565, 0.128717, 0.785317> }
triangle { <0.635256, 0.135028, 0.760406>, <0.627319, 0.168090, 0.760406>, <0.655671, 0.175687, 0.734323> }
triangle { <0.655671, 0.175687, 0.734323>, <0.663967, 0.141131, 0.734323>, <0.635256, 0.135028, 0.760406> }
triangle { <0.663967, 0.141131, 0.734323>, <0.655671, 0.175687, 0.734323>, <0.683013, 0.183013, 0.707107> }
triangle { <0.683013, 0.183013, 0.707107>, <0.691655, 0.147016, 0.707107>, <0.663967, 0.141131, 0.734323> }
triangle { <0.691655, 0.147016, 0.707107>, <0.683013, 0.183013, 0.707107>, <0.709301, 0.190057, 0.678801> }
triangle { <0.709301, 0.190057, 0.678801>, <0.718276, 0.152674, 0.678801>, <0.691655, 0.147016, 0.707107> }
triangle { <0.718276, 0.152674, 0.678801>, <0.709301, 0.190057, 0.678801>, <0.734496, 0.196808, 0.649448> }
triangle { <0.734496, 0.196808, 0.649448>, <0.743789, 0.158097, 0.649448>, <0.718276, 0.152674, 0.678801> }
triangle { <0.743789, 0.158097, 0.649448>, <0.734496, 0.196808, 0.649448>, <0.758558, 0.203255, 0.619094> }
triangle { <0.758558, 0.203255, 0.619094>, <0.768156, 0.163277, 0.619094>, <0.743789, 0.158097, 0.649448> }
triangle { <0.768156, 0.163277, 0.619094>, <0.758558, 0.203255, 0.619094>, <0.781450, 0.209389, 0.587785> }
triangle { <0.781450, 0.209389, 0.587785>, <0.791338, 0.168204, 0.587785>, <0.768156, 0.163277, 0.619094> }
triangle { <0.791338, 0.168204, 0.587785>, <0.781450, 0.209389, 0.587785>, <0.803138, 0.215200, 0.555570> }
triangle { <0.803138, 0.215200, 0.555570>, <0.813300, 0.172872, 0.555570>, <0.791338, 0.168204, 0.587785> }
triangle { <0.813300, 0.172872, 0.555570>, <0.803138, 0.215200, 0.555570>, <0.823587, 0.220680, 0.522499> }
triangle { <0.823587, 0.220680, 0.522499>, <0.834008, 0.177274, 0.522499>, <0.813300, 0.172872, 0.555570> }
triangle { <0.834008, 0.177274, 0.522499>, <0.823587, 0.220680, 0.522499>, <0.842766, 0.225819, 0.488621> }
triangle { <0.842766, 0.225819, 0.488621>, <0.853430, 0.181402, 0.488621>, <0.834008, 0.177274, 0.522499> }
triangle { <0.853430, 0.181402, 0.488621>, <0.842766, 0.225819, 0.488621>, <0.860646, 0.230609, 0.453990> }
triangle { <0.860646, 0.230609, 0.453990>, <0.871536, 0.185251, 0.453990>, <0.853430, 0.181402, 0.488621> }
triangle { <0.871536, 0.185251, 0.453990>, <0.860646, 0.230609, 0.453990>, <0.877199, 0.235045, 0.418660> }
triangle { <0.877199, 0.235045, 0.418660>, <0.888298, 0.188814, 0.418660>, <0.871536, 0.185251, 0.453990> }
triangle { <0.888298, 0.188814, 0.418660>, <0.877199, 0.235045, 0.418660>, <0.892399, 0.239118, 0.382683> }
triangle { <0.892399, 0.239118, 0.382683>, <0.903691, 0.192085, 0.382683>, <0.888298, 0.188814, 0.418660> }
triangle { <0.903691, 0.192085, 0.382683>, <0.892399, 0.239118, 0.382683>, <0.906223, 0.242822, 0.346117> }
triangle { <0.906223, 0.242822, 0.346117>, <0.917690, 0.195061, 0.346117>, <0.903691, 0.192085, 0.382683> }
triangle { <0.917690, 0.195061, 0.346117>, <0.906223, 0.242822, 0.346117>, <0.918650, 0.246152, 0.309017> }
triangle { <0.918650, 0.246152, 0.309017>, <0.930274, 0.197736, 0.309017>, <0.917690, 0.195061, 0.346117> }
triangle { <0.930274, 0.197736, 0.309017>, <0.918650, 0.246152, 0.309017>, <0.929660, 0.249102, 0.271440> }
triangle { <0.929660, 0.249102, 0.271440>, <0.941423, 0.200106, 0.271440>, <0.930274, 0.197736, 0.309017> }
triangle { <0.941423, 0.200106, 0.271440>, <0.929660, 0.249102, 0.271440>, <0.939237, 0.251668, 0.233445> }
triangle { <0.939237, 0.251668, 0.233445>, <0.951121, 0.202167, 0.233445>, <0.941423, 0.200106, 0.271440> }
triangle { <0.951121, 0.202167, 0.233445>, <0.939237, 0.251668, 0.233445>, <0.947366, 0.253846, 0.195090> }
triangle { <0.947366, 0.253846, 0.195090>, <0.959353, 0.203917, 0.195090>, <0.951121, 0.202167, 0.233445> }
triangle { <0.959353, 0.203917, 0.195090>, <0.947366, 0.253846, 0.195090>, <0.954034, 0.255633, 0.156434> }
triangle { <0.954034, 0.255633, 0.156434>, <0.966105, 0.205352, 0.156434>, <0.959353, 0.203917, 0.195090> }
triangle { <0.966105, 0.205352, 0.156434>, <0.954034, 0.255633, 0.156434>, <0.959230, 0.257025, 0.117537> }
triangle { <0.959230, 0.257025, 0.117537>, <0.971368, 0.206471, 0.117537>, <0.966105, 0.205352, 0.156434> }
triangle { <0.971368, 0.206471, 0.117537>, <0.959230, 0.257025, 0.117537>, <0.962948, 0.258021, 0.078459> }
triangle { <0.962948, 0.258021, 0.078459>, <0.975132, 0.207271, 0.078459>, <0.971368, 0.206471, 0.117537> }
triangle { <0.975132, 0.207271, 0.078459>, <0.962948, 0.258021, 0.078459>, <0.965181, 0.258620, 0.039260> }
triangle { <0.965181, 0.258620, 0.039260>, <0.977393, 0.207751, 0.039260>, <0.975132, 0.207271, 0.078459> }
triangle { <0.977393, 0.207751, 0.039260>, <0.965181, 0.258620, 0.039260>, <0.965926, 0.258819, -0.000000> }
triangle { <0.965926, 0.258819, -0.000000>, <0.978148, 0.207912, -0.000000>, <0.977393, 0.207751, 0.039260> }
triangle { <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.037338, 0.012132, 0.999229> }
triangle { <0.037338, 0.012132, 0.999229>, <0.037922, 0.010161, 0.999229>, <0.000000, 0.000000, 1.000000> }
triangle { <0.037922, 0.010161, 0.999229>, <0.037338, 0.012132, 0.999229>, <0.074619, 0.024245, 0.996917> }
triangle { <0.074619, 0.024245, 0.996917>, <0.075786, 0.020307, 0.996917>, <0.037922, 0.010161, 0.999229> }
triangle { <0.075786, 0.020307, 0.996917>, <0.074619, 0.024245, 0.996917>, <0.111785, 0.036321, 0.993068> }
triangle { <0.111785, 0.036321, 0.993068>, <0.113532, 0.030421, 0.993068>, <0.075786, 0.020307, 0.996917> }
triangle { <0.113532, 0.030421, 0.993068>, <0.111785, 0.036321, 0.993068>, <0.148778, 0.048341, 0.987688> }
triangle { <0.148778, 0.048341, 0.987688>, <0.151104, 0.040488, 0.987688>, <0.113532, 0.030421, 0.993068> }
triangle { <0.151104, 0.040488, 0.987688>, <0.148778, 0.048341, 0.987688>, <0.185542, 0.060286, 0.980785> }
triangle { <0.185542, 0.060286, 0.980785>, <0.188443, 0.050493, 0.980785>, <0.151104, 0.040488, 0.987688> }
triangle { <0.188443, 0.050493, 0.980785>, <0.185542, 0.060286, 0.980785>, <0.222020, 0.072139, 0.972370> }
triangle { <0.222020, 0.072139, 0.972370>, <0.225491, 0.060420, 0.972370>, <0.188443, 0.050493, 0.980785> }
triangle { <0.225491, 0.060420, 0.972370>, <0.222020, 0.072139, 0.972370>, <0.258155, 0.083880, 0.962455> }
triangle { <0.258155, 0.083880, 0.962455>, <0.262191, 0.070254, 0.962455>, <0.225491, 0.060420, 0.972370> }
triangle { <0.262191, 0.070254, 0.962455>, <0.258155, 0.083880, 0.962455>, <0.293893, 0.095492, 0.951057> }
triangle { <0.293893, 0.095492, 0.951057>, <0.298487, 0.079979, 0.951057>, <0.262191, 0.070254, 0.962455> }
triangle { <0.298487, 0.079979, 0.951057>, <0.293893, 0.095492, 0.951057>, <0.329177, 0.106956, 0.938191> }
triangle { <0.329177, 0.106956, 0.938191>, <0.334323, 0.089582, 0.938191>, <0.298487, 0.079979, 0.951057> }
triangle { <0.334323, 0.089582, 0.938191>, <0.329177, 0.106956, 0.938191>, <0.363954, 0.118256, 0.923880> }
triangle { <0.363954, 0.118256, 0.923880>, <0.369644, 0.099046, 0.923880>, <0.334323, 0.089582, 0.938191> }
triangle { <0.369644, 0.099046, 0.923880>, <0.363954, 0.118256, 0.923880>, <0.398169, 0.129373, 0.908143> }
triangle { <0.398169, 0.129373, 0.908143>, <0.404394, 0.108357, 0.908143>, <0.369644, 0.099046, 0.923880> }
triangle { <0.404394, 0.108357, 0.908143>, <0.398169, 0.129373, 0.908143>, <0.431771, 0.140291, 0.891007> }
triangle { <0.431771, 0.140291, 0.891007>, <0.438521, 0.117501, 0.891007>, <0.404394, 0.108357, 0.908143> }
triangle { <0.438521, 0.117501, 0.891007>, <0.431771, 0.140291, 0.891007>, <0.464706, 0.150992, 0.872496> }
triangle { <0.464706, 0.150992, 0.872496>, <0.471972, 0.126464, 0.872496>, <0.438521, 0.117501, 0.891007> }
triangle { <0.471972, 0.126464, 0.872496>, <0.464706, 0.150992, 0.872496>, <0.496926, 0.161461, 0.852640> }
triangle { <0.496926, 0.161461, 0.852640>, <0.504695, 0.135233, 0.852640>, <0.471972, 0.126464, 0.872496> }
triangle { <0.504695, 0.135233, 0.852640>, <0.496926, 0.161461, 0.852640>, <0.528379, 0.171681, 0.831470> }
triangle { <0.528379, 0.171681, 0.831470>, <0.536640, 0.143792, 0.831470>, <0.504695, 0.135233, 0.852640> }
triangle { <0.536640, 0.143792, 0.831470>, <0.528379, 0.171681, 0.831470>, <0.559017, 0.181636, 0.809017> }
triangle { <0.559017, 0.181636, 0.809017>, <0.567757, 0.152130, 0.809017>, <0.536640, 0.143792, 0.831470> }
triangle { <0.567757, 0.152130, 0.809017>, <0.559017, 0.181636, 0.809017>, <0.588793, 0.191311, 0.785317> }
triangle { <0.588793, 0.191311, 0.785317>, <0.597999, 0.160233, 0.785317>, <0.567757, 0.152130, 0.809017> }
triangle { <0.597999, 0.160233, 0.785317>, <0.588793, 0.191311, 0.785317>, <0.617662, 0.200690, 0.760406> }
triangle { <0.617662, 0.200690, 0.760406>, <0.627319, 0.168090, 0.760406>, <0.597999, 0.160233, 0.785317> }
triangle { <0.627319, 0.168090, 0.760406>, <0.617662, 0.200690, 0.760406>, <0.645578, 0.209761, 0.734323> }
triangle { <0.645578, 0.209761, 0.734323>, <0.655671, 0.175687, 0.734323>, <0.627319, 0.168090, 0.760406> }
triangle { <0.655671, 0.175687, 0.734323>, <0.645578, 0.209761, 0.734323>, <0.672499, 0.218508, 0.707107> }
triangle { <0.672499, 0.218508, 0.707107>, <0.683013, 0.183013, 0.707107>, <0.655671, 0.175687, 0.734323> }
triangle { <0.683013, 0.183013, 0.707107>, <0.672499, 0.218508, 0.707107>, <0.698382, 0.226918, 0.678801> }
triangle { <0.698382, 0.226918, 0.678801>, <0.709301, 0.190057, 0.678801>, <0.683013, 0.183013, 0.707107> }
triangle { <0.709301, 0.190057, 0.678801>, <0.698382, 0.226918, 0.678801>, <0.723189, 0.234978, 0.649448> }
triangle { <0.723189, 0.234978, 0.649448>, <0.734496, 0.196808, 0.649448>, <0.709301, 0.190057, 0.678801> }
triangle { <0.734496, 0.196808, 0.649448>, <0.723189, 0.234978, 0.649448>, <0.746881, 0.242676, 0.619094> }
triangle { <0.746881, 0.242676, 0.619094>, <0.758558, 0.203255, 0.619094>, <0.734496, 0.196808, 0.649448> }
triangle { <0.758558, 0.203255, 0.619094>, <0.746881, 0.242676, 0.619094>, <0.769421, 0.250000, 0.587785> }
triangle { <0.769421, 0.250000, 0.587785>, <0.781450, 0.209389, 0.587785>, <0.758558, 0.203255, 0.619094> }
triangle { <0.781450, 0.209389, 0.587785>, <0.769421, 0.250000, 0.587785>, <0.790775, 0.256938, 0.555570> }
triangle { <0.790775, 0.256938, 0.555570>, <0.803138, 0.215200, 0.555570>, <0.781450, 0.209389, 0.587785> }
triangle { <0.803138, 0.215200, 0.555570>, <0.790775, 0.256938, 0.555570>, <0.810909, 0.263480, 0.522499> }
triangle { <0.810909, 0.263480, 0.522499>, <0.823587, 0.220680, 0.522499>, <0.803138, 0.215200, 0.555570> }
triangle { <0.823587, 0.220680, 0.522499>, <0.810909, 0.263480, 0.522499>, <0.829793, 0.269616, 0.488621> }
triangle { <0.829793, 0.269616, 0.488621>, <0.842766, 0.225819, 0.488621>, <0.823587, 0.220680, 0.522499> }
triangle { <0.842766, 0.225819, 0.488621>, <0.829793, 0.269616, 0.488621>, <0.847398, 0.275336, 0.453990> }
triangle { <0.847398, 0.275336, 0.453990>, <0.860646, 0.230609, 0.453990>, <0.842766, 0.225819, 0.488621> }
triangle { <0.860646, 0.230609, 0.453990>, <0.847398, 0.275336, 0.453990>, <0.863695, 0.280632, 0.418660> }
triangle { <0.863695, 0.280632, 0.418660>, <0.877199, 0.235045, 0.418660>, <0.860646, 0.230609, 0.453990> }
triangle { <0.877199, 0.235045, 0.418660>, <0.863695, 0.280632, 0.418660>, <0.878662, 0.285494, 0.382683> }
triangle { <0.878662, 0.285494, 0.382683>, <0.892399, 0.239118, 0.382683>, <0.877199, 0.235045, 0.418660> }
triangle { <0.892399, 0.239118, 0.382683>, <0.878662, 0.285494, 0.382683>, <0.892273, 0.289917, 0.346117> }
triangle { <0.892273, 0.289917, 0.346117>, <0.906223, 0.242822, 0.346117>, <0.892399, 0.239118, 0.382683> }
triangle { <0.906223, 0.242822, 0.346117>, <0.892273, 0.289917, 0.346117>, <0.904508, 0.293893, 0.309017> }
triangle { <0.904508, 0.293893, 0.309017>, <0.918650, 0.246152, 0.309017>, <0.906223, 0.242822, 0.346117> }
triangle { <0.918650, 0.246152, 0.309017>, <0.904508, 0.293893, 0.309017>, <0.915349, 0.297415, 0.271440> }
triangle { <0.915349, 0.297415, 0.271440>, <0.929660, 0.249102, 0.271440>, <0.918650, 0.246152, 0.309017> }
triangle { <0.929660, 0.249102, 0.271440>, <0.915349, 0.297415, 0.271440>, <0.924779, 0.300479, 0.233445> }
triangle { <0.924779, 0.300479, 0.233445>, <0.939237, 0.251668, 0.233445>, <0.929660, 0.249102, 0.271440> }
triangle { <0.939237, 0.251668, 0.233445>, <0.924779, 0.300479, 0.233445>, <0.932782, 0.303079, 0.195090> }
triangle { <0.932782, 0.303079, 0.195090>, <0.947366, 0.253846, 0.195090>, <0.939237, 0.251668, 0.233445> }
triangle { <0.947366, 0.253846, 0.195090>, <0.932782, 0.303079, 0.195090>, <0.939347, 0.305212, 0.156434> }
triangle { <0.939347, 0.305212, 0.156434>, <0.954034, 0.255633, 0.156434>, <0.947366, 0.253846, 0.195090> }
triangle { <0.954034, 0.255633, 0.156434>, <0.939347, 0.305212, 0.156434>, <0.944464, 0.306875, 0.117537> }
triangle { <0.944464, 0.306875, 0.117537>, <0.959230, 0.257025, 0.117537>, <0.954034, 0.255633, 0.156434> }
triangle { <0.959230, 0.257025, 0.117537>, <0.944464, 0.306875, 0.117537>, <0.948125, 0.308064, 0.078459> }
triangle { <0.948125, 0.308064, 0.078459>, <0.962948, 0.258021, 0.078459>, <0.959230, 0.257025, 0.117537> }
triangle { <0.962948, 0.258021, 0.078459>, <0.948125, 0.308064, 0.078459>, <0.950323, 0.308779, 0.039260> }
triangle { <0.950323, 0.308779, 0.039260>, <0.965181, 0.258620, 0.039260>, <0.962948, 0.258021, 0.078459> }
triangle { <0.965181, 0.258620, 0.039260>, <0.950323, 0.308779, 0.039260>, <0.951057, 0.309017, -0.000000> }
triangle { <0.951057, 0.309017, -0.000000>, <0.965926, 0.258819, -0.000000>, <0.965181, 0.258620, 0.039260> }
triangle { <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.036652, 0.014069, 0.999229> }
triangle { <0.036652, 0.014069, 0.999229>, <0.037338, 0.012132, 0.999229>, <0.000000, 0.000000, 1.000000> }
triangle { <0.037338, 0.012132, 0.999229>, <0.036652, 0.014069, 0.999229>, <0.073248, 0.028117, 0.996917> }
triangle { <0.073248, 0.028117, 0.996917>, <0.074619, 0.024245, 0.996917>, <0.037338, 0.012132, 0.999229> }
triangle { <0.074619, 0.024245, 0.996917>, <0.073248, 0.028117, 0.996917>, <0.109731, 0.042122, 0.993068> }
triangle { <0.109731, 0.042122, 0.993068>, <0.111785, 0.036321, 0.993068>, <0.074619, 0.024245, 0.996917> }
triangle { <0.111785, 0.036321, 0.993068>, <0.109731, 0.042122, 0.993068>, <0.146044, 0.056061, 0.987688> }
triangle { <0.146044, 0.056061, 0.987688>, <0.148778, 0.048341, 0.987688>, <0.111785, 0.036321, 0.993068> }
triangle { <0.148778, 0.048341, 0.987688>, <0.146044, 0.056061, 0.987688>, <0.182133, 0.069914, 0.980785> }
triangle { <0.182133, 0.069914, 0.980785>, <0.185542, 0.060286, 0.980785>, <0.148778, 0.048341, 0.987688> }
triangle { <0.185542, 0.060286, 0.980785>, <0.182133, 0.069914, 0.980785>, <0.217940, 0.083659, 0.972370> }
triangle { <0.217940, 0.083659, 0.972370>, <0.222020, 0.072139, 0.972370>, <0.185542, 0.060286, 0.980785> }
triangle { <0.222020, 0.072139, 0.972370>, <0.217940, 0.083659, 0.972370>, <0.253411, 0.097276, 0.962455> }
triangle { <0.253411, 0.097276, 0.962455>, <0.258155, 0.083880, 0.962455>, <0.222020, 0.072139, 0.972370> }
triangle { <0.258155, 0.083880, 0.962455>, <0.253411, 0.097276, 0.962455>, <0.288492, 0.110742, 0.951057> }
triangle { <0.288492, 0.110742, 0.951057>, <0.293893, 0.095492, 0.951057>, <0.258155, 0.083880, 0.962455> }
triangle { <0.293893, 0.095492, 0.951057>, <0.288492, 0.110742, 0.951057>, <0.323128, 0.124037, 0.938191> }
triangle { <0.323128, 0.124037, 0.938191>, <0.329177, 0.106956, 0.938191>, <0.293893, 0.095492, 0.951057> }
triangle { <0.329177, 0.106956, 0.938191>, <0.323128, 0.124037, 0.938191>, <0.357266, 0.137141, 0.923880> }
triangle { <0.357266, 0.137141, 0.923880>, <0.363954, 0.118256, 0.923880>, <0.329177, 0.106956, 0.938191> }
triangle { <0.363954, 0.118256, 0.923880>, <0.357266, 0.137141, 0.923880>, <0.390853, 0.150034, 0.908143> }
triangle { <0.390853, 0.150034, 0.908143>, <0.398169, 0.129373, 0.908143>, <0.363954, 0.118256, 0.923880> }
triangle { <0.398169, 0.129373, 0.908143>, <0.390853, 0.150034, 0.908143>, <0.423837, 0.162696, 0.891007> }
triangle { <0.423837, 0.162696, 0.891007>, <0.431771, 0.140291, 0.891007>, <0.398169, 0.129373, 0.908143> }
triangle { <0.431771, 0.140291, 0.891007>, <0.423837, 0.162696, 0.891007>, <0.456167, 0.175106, 0.872496> }
triangle { <0.456167, 0.175106, 0.872496>, <0.464706, 0.150992, 0.872496>, <0.431771, 0.140291, 0.891007> }
triangle { <0.464706, 0.150992, 0.872496>, <0.456167, 0.175106, 0.872496>, <0.487794, 0.187247, 0.852640> }
triangle { <0.487794, 0.187247, 0.852640>, <0.496926, 0.161461, 0.852640>, <0.464706, 0.150992, 0.872496> }
triangle { <0.496926, 0.161461, 0.852640>, <0.487794, 0.187247, 0.852640>, <0.518669, 0.199099, 0.831470> }
triangle { <0.518669, 0.199099, 0.831470>, <0.528379, 0.171681, 0.831470>, <0.496926, 0.161461, 0.852640> }
triangle { <0.528379, 0.171681, 0.831470>, <0.518669, 0.199099, 0.831470>, <0.548745, 0.210643, 0.809017> }
triangle { <0.548745, 0.210643, 0.809017>, <0.559017, 0.181636, 0.809017>, <0.528379, 0.171681, 0.831470> }
triangle { <0.559017, 0.181636, 0.809017>, <0.548745, 0.210643, 0.809017>, <0.577974, 0.221863, 0.785317> }
triangle { <0.577974, 0.221863, 0.785317>, <0.588793, 0.191311, 0.785317>, <0.559017, 0.181636, 0.809017> }
triangle { <0.588793, 0.191311, 0.785317>, <0.577974, 0.221863, 0.785317>, <0.606312, 0.232741, 0.760406> }
triangle { <0.606312, 0.232741, 0.760406>, <0.617662, 0.200690, 0.760406>, <0.588793, 0.191311, 0.785317> }
triangle { <0.617662, 0.200690, 0.760406>, <0.606312, 0.232741, 0.760406>, <0.633715, 0.243260, 0.734323> }
triangle { <0.633715, 0.243260, 0.734323>, <0.645578, 0.209761, 0.734323>, <0.617662, 0.200690, 0.760406> }
triangle { <0.645578, 0.209761, 0.734323>, <0.633715, 0.243260, 0.734323>, <0.660141, 0.253404, 0.707107> }
triangle { <0.660141, 0.253404, 0.707107>, <0.672499, 0.218508, 0.707107>, <0.645578, 0.209761, 0.734323> }
triangle { <0.672499, 0.218508, 0.707107>, <0.660141, 0.253404, 0.707107>, <0.685549, 0.263158, 0.678801> }
triangle { <0.685549, 0.263158, 0.678801>, <0.698382, 0.226918, 0.678801>, <0.672499, 0.218508, 0.707107> }
triangle { <0.698382, 0.226918, 0.678801>, <0.685549, 0.263158, 0.678801>, <0.709900, 0.272505, 0.649448> }
triangle { <0.709900, 0.272505, 0.649448>, <0.723189, 0.234978, 0.649448>, <0.698382, 0.226918, 0.678801> }
triangle { <0.723189, 0.234978, 0.649448>, <0.709900, 0.272505, 0.649448>, <0.733157, 0.281432, 0.619094> }
triangle { <0.733157, 0.281432, 0.619094>, <0.746881, 0.242676, 0.619094>, <0.723189, 0.234978, 0.649448> }
triangle { <0.746881, 0.242676, 0.619094>, <0.733157, 0.281432, 0.619094>, <0.755282, 0.289926, 0.587785> }
triangle { <0.755282, 0.289926, 0.587785>, <0.769421, 0.250000, 0.587785>, <0.746881, 0.242676, 0.619094> }
triangle { <0.769421, 0.250000, 0.587785>, <0.755282, 0.289926, 0.587785>, <0.776244, 0.297972, 0.555570> }
triangle { <0.776244, 0.297972, 0.555570>, <0.790775, 0.256938, 0.555570>, <0.769421, 0.250000, 0.587785> }
triangle { <0.790775, 0.256938, 0.555570>, <0.776244, 0.297972, 0.555570>, <0.796008, 0.305559, 0.522499> }
triangle { <0.796008, 0.305559, 0.522499>, <0.810909, 0.263480, 0.522499>, <0.790775, 0.256938, 0.555570> }
triangle { <0.810909, 0.263480, 0.522499>, <0.796008, 0.305559, 0.522499>, <0.814545, 0.312675, 0.488621> }
triangle { <0.814545, 0.312675, 0.488621>, <0.829793, 0.269616, 0.488621>, <0.810909, 0.263480, 0.522499> }
triangle { <0.829793, 0.269616, 0.488621>, <0.814545, 0.312675, 0.488621>, <0.831826, 0.319308, 0.453990> }
triangle { <0.831826, 0.319308, 0.453990>, <0.847398, 0.275336, 0.453990>, <0.829793, 0.269616, 0.488621> }
triangle { <0.847398, 0.275336, 0.453990>, <0.831826, 0.319308, 0.453990>, <0.847825, 0.325449, 0.418660> }
triangle { <0.847825, 0.325449, 0.418660>, <0.863695, 0.280632, 0.418660>, <0.847398, 0.275336, 0.453990> }
triangle { <0.863695, 0.280632, 0.418660>, <0.847825, 0.325449, 0.418660>, <0.862516, 0.331089, 0.382683> }
triangle { <0.862516, 0.331089, 0.382683>, <0.878662, 0.285494, 0.382683>, <0.863695, 0.280632, 0.418660> }
triangle { <0.878662, 0.285494, 0.382683>, <0.862516, 0.331089, 0.382683>, <0.875877, 0.336218, 0.346117> }
triangle { <0.875877, 0.336218, 0.346117>, <0.892273, 0.289917, 0.346117>, <0.878662, 0.285494, 0.382683> }
triangle { <0.892273, 0.289917, 0.346117>, <0.875877, 0.336218, 0.346117>, <0.887888, 0.340828, 0.309017> }
triangle { <0.887888, 0.340828, 0.309017>, <0.904508, 0.293893, 0.309017>, <0.892273, 0.289917, 0.346117> }
triangle { <0.904508, 0.293893, 0.309017>, <0.887888, 0.340828, 0.309017>, <0.898529, 0.344913, 0.271440> }
triangle { <0.898529, 0.344913, 0.271440>, <0.915349, 0.297415, 0.271440>, <0.904508, 0.293893, 0.309017> }
triangle { <0.915349, 0.297415, 0.271440>, <0.898529, 0.344913, 0.271440>, <0.907786, 0.348466, 0.233445> }
triangle { <0.907786, 0.348466, 0.233445>, <0.924779, 0.300479, 0.233445>, <0.915349, 0.297415, 0.271440> }
triangle { <0.924779, 0.300479, 0.233445>, <0.907786, 0.348466, 0.233445>, <0.915642, 0.351482, 0.195090> }
triangle { <0.915642, 0.351482, 0.195090>, <0.932782, 0.303079, 0.195090>, <0.924779, 0.300479, 0.233445> }
triangle { <0.932782, 0.303079, 0.195090>, <0.915642, 0.351482, 0.195090>, <0.922087, 0.353956, 0.156434> }
triangle { <0.922087, 0.353956, 0.156434>, <0.939347, 0.305212, 0.156434>, <0.932782, 0.303079, 0.195090> }
triangle { <0.939347, 0.305212, 0.156434>, <0.922087, 0.353956, 0.156434>, <0.927109, 0.355884, 0.117537> }
triangle { <0.927109, 0.355884, 0.117537>, <0.944464, 0.306875, 0.117537>, <0.939347, 0.305212, 0.156434> }
triangle { <0.944464, 0.306875, 0.117537>, <0.927109, 0.355884, 0.117537>, <0.930703, 0.357263, 0.078459> }
triangle { <0.930703, 0.357263, 0.078459>, <0.948125, 0.308064, 0.078459>, <0.944464, 0.306875, 0.117537> }
triangle { <0.948125, 0.308064, 0.078459>, <0.930703, 0.357263, 0.078459>, <0.932861, 0.358092, 0.039260> }
triangle { <0.932861, 0.358092, 0.039260>, <0.950323, 0.308779, 0.039260>, <0.948125, 0.308064, 0.078459> }
triangle { <0.950323, 0.308779, 0.039260>, <0.932861, 0.358092, 0.039260>, <0.933580, 0.358368, -0.000000> }
triangle { <0.933580, 0.358368, -0.000000>, <0.951057, 0.309017, -0.000000>, <0.950323, 0.308779, 0.039260> }
triangle { <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.035866, 0.015968, 0.999229> }
triangle { <0.035866, 0.015968, 0.999229>, <0.036652, 0.014069, 0.999229>, <0.000000, 0.000000, 1.000000> }
triangle { <0.036652, 0.014069, 0.999229>, <0.035866, 0.015968, 0.999229>, <0.071676, 0.031912, 0.996917> }
triangle { <0.071676, 0.031912, 0.996917>, <0.073248, 0.028117, 0.996917>, <0.036652, 0.014069, 0.999229> }
triangle { <0.073248, 0.028117, 0.996917>, <0.071676, 0.031912, 0.996917>, <0.107376, 0.047807, 0.993068> }
triangle { <0.107376, 0.047807, 0.993068>, <0.109731, 0.042122, 0.993068>, <0.073248, 0.028117, 0.996917> }
triangle { <0.109731, 0.042122, 0.993068>, <0.107376, 0.047807, 0.993068>, <0.142910, 0.063628, 0.987688> }
triangle { <0.142910, 0.063628, 0.987688>, <0.146044, 0.056061, 0.987688>, <0.109731, 0.042122, 0.993068> }
triangle { <0.146044, 0.056061, 0.987688>, <0.142910, 0.063628, 0.987688>, <0.178224, 0.079350, 0.980785> }
triangle { <0.178224, 0.079350, 0.980785>, <0.182133, 0.069914, 0.980785>, <0.146044, 0.056061, 0.987688> }
triangle { <0.182133, 0.069914, 0.980785>, <0.178224, 0.079350, 0.980785>, <0.213263, 0.094951, 0.972370> }
triangle { <0.213263, 0.094951, 0.972370>, <0.217940, 0.083659, 0.972370>, <0.182133, 0.069914, 0.980785> }
triangle { <0.217940, 0.083659, 0.972370>, <0.213263, 0.094951, 0.972370>, <0.247973, 0.110405, 0.962455> }
triangle { <0.247973, 0.110405, 0.962455>, <0.253411, 0.097276, 0.962455>, <0.217940, 0.083659, 0.972370> }
triangle { <0.253411, 0.097276, 0.962455>, <0.247973, 0.110405, 0.962455>, <0.282301, 0.125689, 0.951057> }
triangle { <0.282301, 0.125689, 0.951057>, <0.288492, 0.110742, 0.951057>, <0.253411, 0.097276, 0.962455> }
triangle { <0.288492, 0.110742, 0.951057>, <0.282301, 0.125689, 0.951057>, <0.316194, 0.140778, 0.938191> }
triangle { <0.316194, 0.140778, 0.938191>, <0.323128, 0.124037, 0.938191>, <0.288492, 0.110742, 0.951057> }
triangle { <0.323128, 0.124037, 0.938191>, <0.316194, 0.140778, 0.938191>, <0.349599, 0.155651, 0.923880> }
triangle { <0.349599, 0.155651, 0.923880>, <0.357266, 0.137141, 0.923880>, <0.323128, 0.124037, 0.938191> }
triangle { <0.357266, 0.137141, 0.923880>, <0.349599, 0.155651, 0.923880>, <0.382465, 0.170284, 0.908143> }
triangle { <0.382465, 0.170284, 0.908143>, <0.390853, 0.150034, 0.908143>, <0.357266, 0.137141, 0.923880> }
triangle { <0.390853, 0.150034, 0.908143>, <0.382465, 0.170284, 0.908143>, <0.414741, 0.184655, 0.891007> }
triangle { <0.414741, 0.184655, 0.891007>, <0.423837, 0.162696, 0.891007>, <0.390853, 0.150034, 0.908143> }
triangle { <0.423837, 0.162696, 0.891007>, <0.414741, 0.184655, 0.891007>, <0.446378, 0.198740, 0.872496> }
triangle { <0.446378, 0.198740, 0.872496>, <0.456167, 0.175106, 0.872496>, <0.423837, 0.162696, 0.891007> }
triangle { <0.456167, 0.175106, 0.872496>, <0.446378, 0.198740, 0.872496>, <0.477326, 0.212519, 0.852640> }
triangle { <0.477326, 0.212519, 0.852640>, <0.487794, 0.187247, 0.852640>, <0.456167, 0.175106, 0.872496> }
triangle { <0.487794, 0.187247, 0.852640>, <0.477326, 0.212519, 0.852640>, <0.507539, 0.225971, 0.831470> }
triangle { <0.507539, 0.225971, 0.831470>, <0.518669, 0.199099, 0.831470>, <0.487794, 0.187247, 0.852640> }
triangle { <0.518669, 0.199099, 0.831470>, <0.507539, 0.225971, 0.831470>, <0.536969, 0.239074, 0.809017> }
triangle { <0.536969, 0.239074, 0.809017>, <0.548745, 0.210643, 0.809017>, <0.518669, 0.199099, 0.831470> }
triangle { <0.548745, 0.210643, 0.809017>, <0.536969, 0.239074, 0.809017>, <0.565570, 0.251808, 0.785317> }
triangle { <0.565570, 0.251808, 0.785317>, <0.577974, 0.221863, 0.785317>, <0.548745, 0.210643, 0.809017> }
triangle { <0.577974, 0.221863, 0.785317>, <0.565570, 0.251808, 0.785317>, <0.593300, 0.264154, 0.760406> }
triangle { <0.593300, 0.264154, 0.760406>, <0.606312, 0.232741, 0.760406>, <0.577974, 0.221863, 0.785317> }
triangle { <0.606312, 0.232741, 0.760406>, <0.593300, 0.264154, 0.760406>, <0.620115, 0.276093, 0.734323> }
triangle { <0.620115, 0.276093, 0.734323>, <0.633715, 0.243260, 0.734323>, <0.606312, 0.232741, 0.760406> }
triangle { <0.633715, 0.243260, 0.734323>, <0.620115, 0.276093, 0.734323>, <0.645974, 0.287606, 0.707107> }
triangle { <0.645974, 0.287606, 0.707107>, <0.660141, 0.253404, 0.707107>, <0.633715, 0.243260, 0.734323> }
triangle { <0.660141, 0.253404, 0.707107>, <0.645974, 0.287606, 0.707107>, <0.670837, 0.298676, 0.678801> }
triangle { <0.670837, 0.298676, 0.678801>, <0.685549, 0.263158, 0.678801>, <0.660141, 0.253404, 0.707107> }
triangle { <0.685549, 0.263158, 0.678801>, <0.670837, 0.298676, 0.678801>, <0.694665, 0.309285, 0.649448> }
triangle { <0.694665, 0.309285, 0.649448>, <0.709900, 0.272505, 0.649448>, <0.685549, 0.263158, 0.678801> }
triangle { <0.709900, 0.272505, 0.649448>, <0.694665, 0.309285, 0.649448>, <0.717423, 0.319417, 0.619094> }
triangle { <0.717423, 0.319417, 0.619094>, <0.733157, 0.281432, 0.619094>, <0.709900, 0.272505, 0.649448> }
triangle { <0.733157, 0.281432, 0.619094>, <0.717423, 0.319417, 0.619094>, <0.739074, 0.329057, 0.587785> }
triangle { <0.739074, 0.329057, 0.587785>, <0.755282, 0.289926, 0.587785>, <0.733157, 0.281432, 0.619094> }
triangle { <0.755282, 0.289926, 0.587785>, <0.739074, 0.329057, 0.587785>, <0.759585, 0.338189, 0.555570> }
triangle { <0.759585, 0.338189, 0.555570>, <0.776244, 0.297972, 0.555570>, <0.755282, 0.289926, 0.587785> }
triangle { <0.776244, 0.297972, 0.555570>, <0.759585, 0.338189, 0.555570>, <0.778926, 0.346800, 0.522499> }
triangle { <0.778926, 0.346800, 0.522499>, <0.796008, 0.305559, 0.522499>, <0.776244, 0.297972, 0.555570> }
triangle { <0.796008, 0.305559, 0.522499>, <0.778926, 0.346800, 0.522499>, <0.797065, 0.354876, 0.488621> }
triangle { <0.797065, 0.354876, 0.488621>, <0.814545, 0.312675, 0.488621>, <0.796008, 0.305559, 0.522499> }
triangle { <0.814545, 0.312675, 0.488621>, <0.797065, 0.354876, 0.488621>, <0.813975, 0.362405, 0.453990> }
triangle { <0.813975, 0.362405, 0.453990>, <0.831826, 0.319308, 0.453990>, <0.814545, 0.312675, 0.488621> }
triangle { <0.831826, 0.319308, 0.453990>, <0.813975, 0.362405, 0.453990>, <0.829630, 0.369375, 0.418660> }
triangle { <0.829630, 0.369375, 0.418660>, <0.847825, 0.325449, 0.418660>, <0.831826, 0.319308, 0.453990> }
triangle { <0.847825, 0.325449, 0.418660>, <0.829630, 0.369375, 0.418660>, <0.844006, 0.375776, 0.382683> }
triangle { <0.844006, 0.375776, 0.382683>, <0.862516, 0.331089, 0.382683>, <0.847825, 0.325449, 0.418660> }
triangle { <0.862516, 0.331089, 0.382683>, <0.844006, 0.375776, 0.382683>, <0.857080, 0.381597, 0.346117> }
triangle { <0.857080, 0.381597, 0.346117>, <0.875877, 0.336218, 0.346117>, <0.862516, 0.331089, 0.382683> }
triangle { <0.875877, 0.336218, 0.346117>, <0.857080, 0.381597, 0.346117>, <0.868833, 0.386830, 0.309017> }
triangle { <0.868833, 0.386830, 0.309017>, <0.887888, 0.340828, 0.309017>, <0.875877, 0.336218, 0.346117> }
triangle { <0.887888, 0.340828, 0.309017>, <0.868833, 0.386830, 0.309017>, <0.879247, 0.391466, 0.271440> }
triangle { <0.879247, 0.391466, 0.271440>, <0.898529, 0.344913, 0.271440>, <0.887888, 0.340828, 0.309017> }
triangle { <0.898529, 0.344913, 0.271440>, <0.879247, 0.391466, 0.271440>, <0.888304, 0.395498, 0.233445> }
triangle { <0.888304, 0.395498, 0.233445>, <0.907786, 0.348466, 0.233445>, <0.898529, 0.344913, 0.271440> }
triangle { <0.907786, 0.348466, 0.233445>, <0.888304, 0.395498, 0.233445>, <0.895992, 0.398921, 0.195090> }
triangle { <0.895992, 0.398921, 0.195090>, <0.915642, 0.351482, 0.195090>, <0.907786, 0.348466, 0.233445> }
triangle { <0.915642, 0.351482, 0.195090>, <0.895992, 0.398921, 0.195090>, <0.902298, 0.401729, 0.156434> }
triangle { <0.902298, 0.401729, 0.156434>, <0.922087, 0.353956, 0.156434>, <0.915642, 0.351482, 0.195090> }
triangle { <0.922087, 0.353956, 0.156434>, <0.902298, 0.401729, 0.156434>, <0.907213, 0.403917, 0.117537> }
triangle { <0.907213, 0.403917, 0.117537>, <0.927109, 0.355884, 0.117537>, <0.922087, 0.353956, 0.156434> }
triangle { <0.927109, 0.355884, 0.117537>, <0.907213, 0.403917, 0.117537>, <0.910729, 0.405483, 0.078459> }
triangle { <0.910729, 0.405483, 0.078459>, <0.930703, 0.357263, 0.078459>, <0.927109, 0.355884, 0.117537> }
triangle { <0.930703, 0.357263, 0.078459>, <0.910729, 0.405483, 0.078459>, <0.912841, 0.406423, 0.039260> }
triangle { <0.912841, 0.406423, 0.039260>, <0.932861, 0.358092, 0.039260>, <0.930703, 0.357263, 0.078459> }
triangle { <0.932861, 0.358092, 0.039260>, <0.912841, 0.406423, 0.039260>, <0.913545, 0.406737, -0.000000> }
triangle { <0.913545, 0.406737, -0.000000>, <0.933580, 0.358368, -0.000000>, <0.932861, 0.358092, 0.039260> }
triangle { <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.034981, 0.017824, 0.999229> }
triangle { <0.034981, 0.017824, 0.999229>, <0.035866, 0.015968, 0.999229>, <0.000000, 0.000000, 1.000000> }
triangle { <0.035866, 0.015968, 0.999229>, <0.034981, 0.017824, 0.999229>, <0.069908, 0.035620, 0.996917> }
triangle { <0.069908, 0.035620, 0.996917>, <0.071676, 0.031912, 0.996917>, <0.035866, 0.015968, 0.999229> }
triangle { <0.071676, 0.031912, 0.996917>, <0.069908, 0.035620, 0.996917>, <0.104727, 0.053361, 0.993068> }
triangle { <0.104727, 0.053361, 0.993068>, <0.107376, 0.047807, 0.993068>, <0.071676, 0.031912, 0.996917> }
triangle { <0.107376, 0.047807, 0.993068>, <0.104727, 0.053361, 0.993068>, <0.139384, 0.071020, 0.987688> }
triangle { <0.139384, 0.071020, 0.987688>, <0.142910, 0.063628, 0.987688>, <0.107376, 0.047807, 0.993068> }
triangle { <0.142910, 0.063628, 0.987688>, <0.139384, 0.071020, 0.987688>, <0.173827, 0.088569, 0.980785> }
triangle { <0.173827, 0.088569, 0.980785>, <0.178224, 0.079350, 0.980785>, <0.142910, 0.063628, 0.987688> }
triangle { <0.178224, 0.079350, 0.980785>, <0.173827, 0.088569, 0.980785>, <0.208001, 0.105982, 0.972370> }
triangle { <0.208001, 0.105982, 0.972370>, <0.213263, 0.094951, 0.972370>, <0.178224, 0.079350, 0.980785> }
triangle { <0.213263, 0.094951, 0.972370>, <0.208001, 0.105982, 0.972370>, <0.241855, 0.123231, 0.962455> }
triangle { <0.241855, 0.123231, 0.962455>, <0.247973, 0.110405, 0.962455>, <0.213263, 0.094951, 0.972370> }
triangle { <0.247973, 0.110405, 0.962455>, <0.241855, 0.123231, 0.962455>, <0.275336, 0.140291, 0.951057> }
triangle { <0.275336, 0.140291, 0.951057>, <0.282301, 0.125689, 0.951057>, <0.247973, 0.110405, 0.962455> }
triangle { <0.282301, 0.125689, 0.951057>, <0.275336, 0.140291, 0.951057>, <0.308393, 0.157134, 0.938191> }
triangle { <0.308393, 0.157134, 0.938191>, <0.316194, 0.140778, 0.938191>, <0.282301, 0.125689, 0.951057> }
triangle { <0.316194, 0.140778, 0.938191>, <0.308393, 0.157134, 0.938191>, <0.340973, 0.173735, 0.923880> }
triangle { <0.340973, 0.173735, 0.923880>, <0.349599, 0.155651, 0.923880>, <0.316194, 0.140778, 0.938191> }
triangle { <0.349599, 0.155651, 0.923880>, <0.340973, 0.173735, 0.923880>, <0.373029, 0.190068, 0.908143> }
triangle { <0.373029, 0.190068, 0.908143>, <0.382465, 0.170284, 0.908143>, <0.349599, 0.155651, 0.923880> }
triangle { <0.382465, 0.170284, 0.908143>, <0.373029, 0.190068, 0.908143>, <0.404508, 0.206107, 0.891007> }
triangle { <0.404508, 0.206107, 0.891007>, <0.414741, 0.184655, 0.891007>, <0.382465, 0.170284, 0.908143> }
triangle { <0.414741, 0.184655, 0.891007>, <0.404508, 0.206107, 0.891007>, <0.435365, 0.221829, 0.872496> }
triangle { <0.435365, 0.221829, 0.872496>, <0.446378, 0.198740, 0.872496>, <0.414741, 0.184655, 0.891007> }
triangle { <0.446378, 0.198740, 0.872496>, <0.435365, 0.221829, 0.872496>, <0.465550, 0.237209, 0.852640> }
triangle { <0.465550, 0.237209, 0.852640>, <0.477326, 0.212519, 0.852640>, <0.446378, 0.198740, 0.872496> }
triangle { <0.477326, 0.212519, 0.852640>, <0.465550, 0.237209, 0.852640>, <0.495017, 0.252224, 0.831470> }
triangle { <0.495017, 0.252224, 0.831470>, <0.507539, 0.225971, 0.831470>, <0.477326, 0.212519, 0.852640> }
triangle { <0.507539, 0.225971, 0.831470>, <0.495017, 0.252224, 0.831470>, <0.523720, 0.266849, 0.809017> }
triangle { <0.523720, 0.266849, 0.809017>, <0.536969, 0.239074, 0.809017>, <0.507539, 0.225971, 0.831470> }
triangle { <0.536969, 0.239074, 0.809017>, <0.523720, 0.266849, 0.809017>, <0.551617, 0.281063, 0.785317> }
triangle { <0.551617, 0.281063, 0.785317>, <0.565570, 0.251808, 0.785317>, <0.536969, 0.239074, 0.809017> }
triangle { <0.565570, 0.251808, 0.785317>, <0.551617, 0.281063, 0.785317>, <0.578662, 0.294843, 0.760406> }
triangle { <0.578662, 0.294843, 0.760406>, <0.593300, 0.264154, 0.760406>, <0.565570, 0.251808, 0.785317> }
triangle { <0.593300, 0.264154, 0.760406>, <0.578662, 0.294843, 0.760406>, <0.604816, 0.308169, 0.734323> }
triangle { <0.604816, 0.308169, 0.734323>, <0.620115, 0.276093, 0.734323>, <0.593300, 0.264154, 0.760406> }
triangle { <0.620115, 0.276093, 0.734323>, <0.604816, 0.308169, 0.734323>, <0.630037, 0.321020, 0.707107> }
triangle { <0.630037, 0.321020, 0.707107>, <0.645974, 0.287606, 0.707107>, <0.620115, 0.276093, 0.734323> }
triangle { <0.645974, 0.287606, 0.707107>, <0.630037, 0.321020, 0.707107>, <0.654286, 0.333375, 0.678801> }
triangle { <0.654286, 0.333375, 0.678801>, <0.670837, 0.298676, 0.678801>, <0.645974, 0.287606, 0.707107> }
triangle { <0.670837, 0.298676, 0.678801>, <0.654286, 0.333375, 0.678801>, <0.677527, 0.345217, 0.649448> }
triangle { <0.677527, 0.345217, 0.649448>, <0.694665, 0.309285, 0.649448>, <0.670837, 0.298676, 0.678801> }
triangle { <0.694665, 0.309285, 0.649448>, <0.677527, 0.345217, 0.649448>, <0.699723, 0.356526, 0.619094> }
triangle { <0.699723, 0.356526, 0.619094>, <0.717423, 0.319417, 0.619094>, <0.694665, 0.309285, 0.649448> }
triangle { <0.717423, 0.319417, 0.619094>, <0.699723, 0.356526, 0.619094>, <0.720839, 0.367286, 0.587785> }
triangle { <0.720839, 0.367286, 0.587785>, <0.739074, 0.329057, 0.587785>, <0.717423, 0.319417, 0.619094> }
triangle { <0.739074, 0.329057, 0.587785>, <0.720839, 0.367286, 0.587785>, <0.740845, 0.377479, 0.555570> }
triangle { <0.740845, 0.377479, 0.555570>, <0.759585, 0.338189, 0.555570>, <0.739074, 0.329057, 0.587785> }
triangle { <0.759585, 0.338189, 0.555570>, <0.740845, 0.377479, 0.555570>, <0.759708, 0.387091, 0.522499> }
triangle { <0.759708, 0.387091, 0.522499>, <0.778926, 0.346800, 0.522499>, <0.759585, 0.338189, 0.555570> }
triangle { <0.778926, 0.346800, 0.522499>, <0.759708, 0.387091, 0.522499>, <0.777400, 0.396105, 0.488621> }
triangle { <0.777400, 0.396105, 0.488621>, <0.797065, 0.354876, 0.488621>, <0.778926, 0.346800, 0.522499> }
triangle { <0.797065, 0.354876, 0.488621>, <0.777400, 0.396105, 0.488621>, <0.793893, 0.404508, 0.453990> }
triangle { <0.793893, 0.404508, 0.453990>, <0.813975, 0.362405, 0.453990>, <0.797065, 0.354876, 0.488621> }
triangle { <0.813975, 0.362405, 0.453990>, <0.793893, 0.404508, 0.453990>, <0.809161, 0.412288, 0.418660> }
triangle { <0.809161, 0.412288, 0.418660>, <0.829630, 0.369375, 0.418660>, <0.813975, 0.362405, 0.453990> }
triangle { <0.829630, 0.369375, 0.418660>, <0.809161, 0.412288, 0.418660>, <0.823183, 0.419433, 0.382683> }
triangle { <0.823183, 0.419433, 0.382683>, <0.844006, 0.375776, 0.382683>, <0.829630, 0.369375, 0.418660> }
triangle { <0.844006, 0.375776, 0.382683>, <0.823183, 0.419433, 0.382683>, <0.835935, 0.425930, 0.346117> }
triangle { <0.835935, 0.425930, 0.346117>, <0.857080, 0.381597, 0.346117>, <0.844006, 0.375776, 0.382683> }
triangle { <0.857080, 0.381597, 0.346117>, <0.835935, 0.425930, 0.346117>, <0.847398, 0.431771, 0.309017> }
triangle { <0.847398, 0.431771, 0.309017>, <0.868833, 0.386830, 0.309017>, <0.857080, 0.381597, 0.346117> }
triangle { <0.868833, 0.386830, 0.309017>, <0.847398, 0.431771, 0.309017>, <0.857554, 0.436946, 0.271440> }
triangle { <0.857554, 0.436946, 0.271440>, <0.879247, 0.391466, 0.271440>, <0.868833, 0.386830, 0.309017> }
triangle { <0.879247, 0.391466, 0.271440>, <0.857554, 0.436946, 0.271440>, <0.866388, 0.441447, 0.233445> }
triangle { <0.866388, 0.441447, 0.233445>, <0.888304, 0.395498, 0.233445>, <0.879247, 0.391466, 0.271440> }
triangle { <0.888304, 0.395498, 0.233445>, <0.866388, 0.441447, 0.233445>, <0.873886, 0.445267, 0.195090> }
triangle { <0.873886, 0.445267, 0.195090>, <0.895992, 0.398921, 0.195090>, <0.888304, 0.395498, 0.233445> }
triangle { <0.895992, 0.398921, 0.195090>, <0.873886, 0.445267, 0.195090>, <0.880037, 0.448401, 0.156434> }
triangle { <0.880037, 0.448401, 0.156434>, <0.902298, 0.401729, 0.156434>, <0.895992, 0.398921, 0.195090> }
triangle { <0.902298, 0.401729, 0.156434>, <0.880037, 0.448401, 0.156434>, <0.884830, 0.450844, 0.117537> }
triangle { <0.884830, 0.450844, 0.117537>, <0.907213, 0.403917, 0.117537>, <0.902298, 0.401729, 0.156434> }
triangle { <0.907213, 0.403917, 0.117537>, <0.884830, 0.450844, 0.117537>, <0.888260, 0.452591, 0.078459> }
triangle { <0.888260, 0.452591, 0.078459>, <0.910729, 0.405483, 0.078459>, <0.907213, 0.403917, 0.117537> }
triangle { <0.910729, 0.405483, 0.078459>, <0.888260, 0.452591, 0.078459>, <0.890320, 0.453640, 0.039260> }
triangle { <0.890320, 0.453640, 0.039260>, <0.912841, 0.406423, 0.039260>, <0.910729, 0.405483, 0.078459> }
triangle { <0.912841, 0.406423, 0.039260>, <0.890320, 0.453640, 0.039260>, <0.891007, 0.453990, -0.000000> }
triangle { <0.891007, 0.453990, -0.000000>, <0.913545, 0.406737, -0.000000>, <0.912841, 0.406423, 0.039260> }
triangle { <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.034000, 0.019630, 0.999229> }
triangle { <0.034000, 0.019630, 0.999229>, <0.034981, 0.017824, 0.999229>, <0.000000, 0.000000, 1.000000> }
triangle { <0.034981, 0.017824, 0.999229>, <0.034000, 0.019630, 0.999229>, <0.067948, 0.039230, 0.996917> }
triangle { <0.067948, 0.039230, 0.996917>, <0.069908, 0.035620, 0.996917>, <0.034981, 0.017824, 0.999229> }
triangle { <0.069908, 0.035620, 0.996917>, <0.067948, 0.039230, 0.996917>, <0.101790, 0.058769, 0.993068> }
triangle { <0.101790, 0.058769, 0.993068>, <0.104727, 0.053361, 0.993068>, <0.069908, 0.035620, 0.996917> }
triangle { <0.104727, 0.053361, 0.993068>, <0.101790, 0.058769, 0.993068>, <0.135476, 0.078217, 0.987688> }
triangle { <0.135476, 0.078217, 0.987688>, <0.139384, 0.071020, 0.987688>, <0.104727, 0.053361, 0.993068> }
triangle { <0.139384, 0.071020, 0.987688>, <0.135476, 0.078217, 0.987688>, <0.168953, 0.097545, 0.980785> }
triangle { <0.168953, 0.097545, 0.980785>, <0.173827, 0.088569, 0.980785>, <0.139384, 0.071020, 0.987688> }
triangle { <0.173827, 0.088569, 0.980785>, <0.168953, 0.097545, 0.980785>, <0.202170, 0.116723, 0.972370> }
triangle { <0.202170, 0.116723, 0.972370>, <0.208001, 0.105982, 0.972370>, <0.173827, 0.088569, 0.980785> }
triangle { <0.208001, 0.105982, 0.972370>, <0.202170, 0.116723, 0.972370>, <0.235074, 0.135720, 0.962455> }
triangle { <0.235074, 0.135720, 0.962455>, <0.241855, 0.123231, 0.962455>, <0.208001, 0.105982, 0.972370> }
triangle { <0.241855, 0.123231, 0.962455>, <0.235074, 0.135720, 0.962455>, <0.267617, 0.154508, 0.951057> }
triangle { <0.267617, 0.154508, 0.951057>, <0.275336, 0.140291, 0.951057>, <0.241855, 0.123231, 0.962455> }
triangle { <0.275336, 0.140291, 0.951057>, <0.267617, 0.154508, 0.951057>, <0.299746, 0.173059, 0.938191> }
triangle { <0.299746, 0.173059, 0.938191>, <0.308393, 0.157134, 0.938191>, <0.275336, 0.140291, 0.951057> }
triangle { <0.308393, 0.157134, 0.938191>, <0.299746, 0.173059, 0.938191>, <0.331414, 0.191342, 0.923880> }
triangle { <0.331414, 0.191342, 0.923880>, <0.340973, 0.173735, 0.923880>, <0.308393, 0.157134, 0.938191> }
triangle { <0.340973, 0.173735, 0.923880>, <0.331414, 0.191342, 0.923880>, <0.362570, 0.209330, 0.908143> }
triangle { <0.362570, 0.209330, 0.908143>, <0.373029, 0.190068, 0.908143>, <0.340973, 0.173735, 0.923880> }
triangle { <0.373029, 0.190068, 0.908143>, <0.362570, 0.209330, 0.908143>, <0.393167, 0.226995, 0.891007> }
triangle { <0.393167, 0.226995, 0.891007>, <0.404508, 0.206107, 0.891007>, <0.373029, 0.190068, 0.908143> }
triangle { <0.404508, 0.206107, 0.891007>, <0.393167, 0.226995, 0.891007>, <0.423158, 0.244311, 0.872496> }
triangle { <0.423158, 0.244311, 0.872496>, <0.435365, 0.221829, 0.872496>, <0.404508, 0.206107, 0.891007> }
triangle { <0.435365, 0.221829, 0.872496>, <0.423158, 0.244311, 0.872496>, <0.452497, 0.261249, 0.852640> }
triangle { <0.452497, 0.261249, 0.852640>, <0.465550, 0.237209, 0.852640>, <0.435365, 0.221829, 0.872496> }
triangle { <0.465550, 0.237209, 0.852640>, <0.452497, 0.261249, 0.852640>, <0.481138, 0.277785, 0.831470> }
triangle { <0.481138, 0.277785, 0.831470>, <0.495017, 0.252224, 0.831470>, <0.465550, 0.237209, 0.852640> }
triangle { <0.495017, 0.252224, 0.831470>, <0.481138, 0.277785, 0.831470>, <0.509037, 0.293893, 0.809017> }
triangle { <0.509037, 0.293893, 0.809017>, <0.523720, 0.266849, 0.809017>, <0.495017, 0.252224, 0.831470> }
triangle { <0.523720, 0.266849, 0.809017>, <0.509037, 0.293893, 0.809017>, <0.536151, 0.309547, 0.785317> }
triangle { <0.536151, 0.309547, 0.785317>, <0.551617, 0.281063, 0.785317>, <0.523720, 0.266849, 0.809017> }
triangle { <0.551617, 0.281063, 0.785317>, <0.536151, 0.309547, 0.785317>, <0.562439, 0.324724, 0.760406> }
triangle { <0.562439, 0.324724, 0.760406>, <0.578662, 0.294843, 0.760406>, <0.551617, 0.281063, 0.785317> }
triangle { <0.578662, 0.294843, 0.760406>, <0.562439, 0.324724, 0.760406>, <0.587859, 0.339400, 0.734323> }
triangle { <0.587859, 0.339400, 0.734323>, <0.604816, 0.308169, 0.734323>, <0.578662, 0.294843, 0.760406> }
triangle { <0.604816, 0.308169, 0.734323>, <0.587859, 0.339400, 0.734323>, <0.612372, 0.353553, 0.707107> }
triangle { <0.612372, 0.353553, 0.707107>, <0.630037, 0.321020, 0.707107>, <0.604816, 0.308169, 0.734323> }
triangle { <0.630037, 0.321020, 0.707107>, <0.612372, 0.353553, 0.707107>, <0.635942, 0.367161, 0.678801> }
triangle { <0.635942, 0.367161, 0.678801>, <0.654286, 0.333375, 0.678801>, <0.630037, 0.321020, 0.707107> }
triangle { <0.654286, 0.333375, 0.678801>, <0.635942, 0.367161, 0.678801>, <0.658531, 0.380203, 0.649448> }
triangle { <0.658531, 0.380203, 0.649448>, <0.677527, 0.345217, 0.649448>, <0.654286, 0.333375, 0.678801> }
triangle { <0.677527, 0.345217, 0.649448>, <0.658531, 0.380203, 0.649448>, <0.680104, 0.392658, 0.619094> }
triangle { <0.680104, 0.392658, 0.619094>, <0.699723, 0.356526, 0.619094>, <0.677527, 0.345217, 0.649448> }
triangle { <0.699723, 0.356526, 0.619094>, <0.680104, 0.392658, 0.619094>, <0.700629, 0.404508, 0.587785> }
triangle { <0.700629, 0.404508, 0.587785>, <0.720839, 0.367286, 0.587785>, <0.699723, 0.356526, 0.619094> }
triangle { <0.720839, 0.367286, 0.587785>, <0.700629, 0.404508, 0.587785>, <0.720074, 0.415735, 0.555570> }
triangle { <0.720074, 0.415735, 0.555570>, <0.740845, 0.377479, 0.555570>, <0.720839, 0.367286, 0.587785> }
triangle { <0.740845, 0.377479, 0.555570>, <0.720074, 0.415735, 0.555570>, <0.738408, 0.426320, 0.522499> }
triangle { <0.738408, 0.426320, 0.522499>, <0.759708, 0.387091, 0.522499>, <0.740845, 0.377479, 0.555570> }
triangle { <0.759708, 0.387091, 0.522499>, <0.738408, 0.426320, 0.522499>, <0.755604, 0.436248, 0.488621> }
triangle { <0.755604, 0.436248, 0.488621>, <0.777400, 0.396105, 0.488621>, <0.759708, 0.387091, 0.522499> }
triangle { <0.777400, 0.396105, 0.488621>, <0.755604, 0.436248, 0.488621>, <0.771634, 0.445503, 0.453990> }
triangle { <0.771634, 0.445503, 0.453990>, <0.793893, 0.404508, 0.453990>, <0.777400, 0.396105, 0.488621> }
triangle { <0.793893, 0.404508, 0.453990>, <0.771634, 0.445503, 0.453990>, <0.786475, 0.454072, 0.418660> }
triangle { <0.786475, 0.454072, 0.418660>, <0.809161, 0.412288, 0.418660>, <0.793893, 0.404508, 0.453990> }
triangle { <0.809161, 0.412288, 0.418660>, <0.786475, 0.454072, 0.418660>, <0.800103, 0.461940, 0.382683> }
triangle { <0.800103, 0.461940, 0.382683>, <0.823183, 0.419433, 0.382683>, <0.809161, 0.412288, 0.418660> }
triangle { <0.823183, 0.419433, 0.382683>, <0.800103, 0.461940, 0.382683>, <0.812498, 0.469096, 0.346117> }
triangle { <0.812498, 0.469096, 0.346117>, <0.835935, 0.425930, 0.346117>, <0.823183, 0.419433, 0.382683> }
triangle { <0.835935, 0.425930, 0.346117>, <0.812498, 0.469096, 0.346117>, <0.823639, 0.475528, 0.309017> }
triangle { <0.823639, 0.475528, 0.309017>, <0.847398, 0.431771, 0.309017>, <0.835935, 0.425930, 0.346117> }
triangle { <0.847398, 0.431771, 0.309017>, <0.823639, 0.475528, 0.309017>, <0.833511, 0.481228, 0.271440> }
triangle { <0.833511, 0.481228, 0.271440>, <0.857554, 0.436946, 0.271440>, <0.847398, 0.431771, 0.309017> }
triangle { <0.857554, 0.436946, 0.271440>, <0.833511, 0.481228, 0.271440>, <0.842097, 0.486185, 0.233445> }
triangle { <0.842097, 0.486185, 0.233445>, <0.866388, 0.441447, 0.233445>, <0.857554, 0.436946, 0.271440> }
triangle { <0.866388, 0.441447, 0.233445>, <0.842097, 0.486185, 0.233445>, <0.849385, 0.490393, 0.195090> }
triangle { <0.849385, 0.490393, 0.195090>, <0.873886, 0.445267, 0.195090>, <0.866388, 0.441447, 0.233445> }
triangle { <0.873886, 0.445267, 0.195090>, <0.849385, 0.490393, 0.195090>, <0.855363, 0.493844, 0.156434> }
triangle { <0.855363, 0.493844, 0.156434>, <0.880037, 0.448401, 0.156434>, <0.873886, 0.445267, 0.195090> }
triangle { <0.880037, 0.448401, 0.156434>, <0.855363, 0.493844, 0.156434>, <0.860023, 0.496534, 0.117537> }
triangle { <0.860023, 0.496534, 0.117537>, <0.884830, 0.450844, 0.117537>, <0.880037, 0.448401, 0.156434> }
triangle { <0.884830, 0.450844, 0.117537>, <0.860023, 0.496534, 0.117537>, <0.863356, 0.498459, 0.078459> }
triangle { <0.863356, 0.498459, 0.078459>, <0.888260, 0.452591, 0.078459>, <0.884830, 0.450844, 0.117537> }
triangle { <0.888260, 0.452591, 0.078459>, <0.863356, 0.498459, 0.078459>, <0.865358, 0.499615, 0.039260> }
triangle { <0.865358, 0.499615, 0.039260>, <0.890320, 0.453640, 0.039260>, <0.888260, 0.452591, 0.078459> }
triangle { <0.890320, 0.453640, 0.039260>, <0.865358, 0.499615, 0.039260>, <0.866025, 0.500000, -0.000000> }
triangle { <0.866025, 0.500000, -0.000000>, <0.891007, 0.453990, -0.000000>, <0.890320, 0.453640, 0.039260> }
triangle { <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.032926, 0.021382, 0.999229> }
triangle { <0.032926, 0.021382, 0.999229>, <0.034000, 0.019630, 0.999229>, <0.000000, 0.000000, 1.000000> }
triangle { <0.034000, 0.019630, 0.999229>, <0.032926, 0.021382, 0.999229>, <0.065801, 0.042732, 0.996917> }
triangle { <0.065801, 0.042732, 0.996917>, <0.067948, 0.039230, 0.996917>, <0.034000, 0.019630, 0.999229> }
triangle { <0.067948, 0.039230, 0.996917>, <0.065801, 0.042732, 0.996917>, <0.098575, 0.064015, 0.993068> }
triangle { <0.098575, 0.064015, 0.993068>, <0.101790, 0.058769, 0.993068>, <0.067948, 0.039230, 0.996917> }
triangle { <0.101790, 0.058769, 0.993068>, <0.098575, 0.064015, 0.993068>, <0.131197, 0.085200, 0.987688> }
triangle { <0.131197, 0.085200, 0.987688>, <0.135476, 0.078217, 0.987688>, <0.101790, 0.058769, 0.993068> }
triangle { <0.135476, 0.078217, 0.987688>, <0.131197, 0.085200, 0.987688>, <0.163617, 0.106254, 0.980785> }
triangle { <0.163617, 0.106254, 0.980785>, <0.168953, 0.097545, 0.980785>, <0.135476, 0.078217, 0.987688> }
triangle { <0.168953, 0.097545, 0.980785>, <0.163617, 0.106254, 0.980785>, <0.195784, 0.127143, 0.972370> }
triangle { <0.195784, 0.127143, 0.972370>, <0.202170, 0.116723, 0.972370>, <0.168953, 0.097545, 0.980785> }
triangle { <0.202170, 0.116723, 0.972370>, <0.195784, 0.127143, 0.972370>, <0.227649, 0.147837, 0.962455> }
triangle { <0.227649, 0.147837, 0.962455>, <0.235074, 0.135720, 0.962455>, <0.202170, 0.116723, 0.972370> }
triangle { <0.235074, 0.135720, 0.962455>, <0.227649, 0.147837, 0.962455>, <0.259163, 0.168303, 0.951057> }
triangle { <0.259163, 0.168303, 0.951057>, <0.267617, 0.154508, 0.951057>, <0.235074, 0.135720, 0.962455> }
triangle { <0.267617, 0.154508, 0.951057>, <0.259163, 0.168303, 0.951057>, <0.290278, 0.188509, 0.938191> }
triangle { <0.290278, 0.188509, 0.938191>, <0.299746, 0.173059, 0.938191>, <0.267617, 0.154508, 0.951057> }
triangle { <0.299746, 0.173059, 0.938191>, <0.290278, 0.188509, 0.938191>, <0.320945, 0.208424, 0.923880> }
triangle { <0.320945, 0.208424, 0.923880>, <0.331414, 0.191342, 0.923880>, <0.299746, 0.173059, 0.938191> }
triangle { <0.331414, 0.191342, 0.923880>, <0.320945, 0.208424, 0.923880>, <0.351118, 0.228018, 0.908143> }
triangle { <0.351118, 0.228018, 0.908143>, <0.362570, 0.209330, 0.908143>, <0.331414, 0.191342, 0.923880> }
triangle { <0.362570, 0.209330, 0.908143>, <0.351118, 0.228018, 0.908143>, <0.380748, 0.247261, 0.891007> }
triangle { <0.380748, 0.247261, 0.891007>, <0.393167, 0.226995, 0.891007>, <0.362570, 0.209330, 0.908143> }
triangle { <0.393167, 0.226995, 0.891007>, <0.380748, 0.247261, 0.891007>, <0.409792, 0.266122, 0.872496> }
triangle { <0.409792, 0.266122, 0.872496>, <0.423158, 0.244311, 0.872496>, <0.393167, 0.226995, 0.891007> }
triangle { <0.423158, 0.244311, 0.872496>, <0.409792, 0.266122, 0.872496>, <0.438204, 0.284573, 0.852640> }
triangle { <0.438204, 0.284573, 0.852640>, <0.452497, 0.261249, 0.852640>, <0.423158, 0.244311, 0.872496> }
triangle { <0.452497, 0.261249, 0.852640>, <0.438204, 0.284573, 0.852640>, <0.465940, 0.302585, 0.831470> }
triangle { <0.465940, 0.302585, 0.831470>, <0.481138, 0.277785, 0.831470>, <0.452497, 0.261249, 0.852640> }
triangle { <0.481138, 0.277785, 0.831470>, <0.465940, 0.302585, 0.831470>, <0.492958, 0.320131, 0.809017> }
triangle { <0.492958, 0.320131, 0.809017>, <0.509037, 0.293893, 0.809017>, <0.481138, 0.277785, 0.831470> }
triangle { <0.509037, 0.293893, 0.809017>, <0.492958, 0.320131, 0.809017>, <0.519216, 0.337183, 0.785317> }
triangle { <0.519216, 0.337183, 0.785317>, <0.536151, 0.309547, 0.785317>, <0.509037, 0.293893, 0.809017> }
triangle { <0.536151, 0.309547, 0.785317>, <0.519216, 0.337183, 0.785317>, <0.544673, 0.353715, 0.760406> }
triangle { <0.544673, 0.353715, 0.760406>, <0.562439, 0.324724, 0.760406>, <0.536151, 0.309547, 0.785317> }
triangle { <0.562439, 0.324724, 0.760406>, <0.544673, 0.353715, 0.760406>, <0.569290, 0.369701, 0.734323> }
triangle { <0.569290, 0.369701, 0.734323>, <0.587859, 0.339400, 0.734323>, <0.562439, 0.324724, 0.760406> }
triangle { <0.587859, 0.339400, 0.734323>, <0.569290, 0.369701, 0.734323>, <0.593030, 0.385118, 0.707107> }
triangle { <0.593030, 0.385118, 0.707107>, <0.612372, 0.353553, 0.707107>, <0.587859, 0.339400, 0.734323> }
triangle { <0.612372, 0.353553, 0.707107>, <0.593030, 0.385118, 0.707107>, <0.615855, 0.399941, 0.678801> }
triangle { <0.615855, 0.399941, 0.678801>, <0.635942, 0.367161, 0.678801>, <0.612372, 0.353553, 0.707107> }
triangle { <0.635942, 0.367161, 0.678801>, <0.615855, 0.399941, 0.678801>, <0.637730, 0.414147, 0.649448> }
triangle { <0.637730, 0.414147, 0.649448>, <0.658531, 0.380203, 0.649448>, <0.635942, 0.367161, 0.678801> }
triangle { <0.658531, 0.380203, 0.649448>, <0.637730, 0.414147, 0.649448>, <0.658622, 0.427714, 0.619094> }
triangle { <0.658622, 0.427714, 0.619094>, <0.680104, 0.392658, 0.619094>, <0.658531, 0.380203, 0.649448> }
triangle { <0.680104, 0.392658, 0.619094>, <0.658622, 0.427714, 0.619094>, <0.678499, 0.440622, 0.587785> }
triangle { <0.678499, 0.440622, 0.587785>, <0.700629, 0.404508, 0.587785>, <0.680104, 0.392658, 0.619094> }
triangle { <0.700629, 0.404508, 0.587785>, <0.678499, 0.440622, 0.587785>, <0.697329, 0.452851, 0.555570> }
triangle { <0.697329, 0.452851, 0.555570>, <0.720074, 0.415735, 0.555570>, <0.700629, 0.404508, 0.587785> }
triangle { <0.720074, 0.415735, 0.555570>, <0.697329, 0.452851, 0.555570>, <0.715084, 0.464381, 0.522499> }
triangle { <0.715084, 0.464381, 0.522499>, <0.738408, 0.426320, 0.522499>, <0.720074, 0.415735, 0.555570> }
triangle { <0.738408, 0.426320, 0.522499>, <0.715084, 0.464381, 0.522499>, <0.731737, 0.475195, 0.488621> }
triangle { <0.731737, 0.475195, 0.488621>, <0.755604, 0.436248, 0.488621>, <0.738408, 0.426320, 0.522499> }
triangle { <0.755604, 0.436248, 0.488621>, <0.731737, 0.475195, 0.488621>, <0.747261, 0.485277, 0.453990> }
triangle { <0.747261, 0.485277, 0.453990>, <0.771634, 0.445503, 0.453990>, <0.755604, 0.436248, 0.488621> }
triangle { <0.771634, 0.445503, 0.453990>, <0.747261, 0.485277, 0.453990>, <0.761633, 0.494610, 0.418660> }
triangle { <0.761633, 0.494610, 0.418660>, <0.786475, 0.454072, 0.418660>, <0.771634, 0.445503, 0.453990> }
triangle { <0.786475, 0.454072, 0.418660>, <0.761633, 0.494610, 0.418660>, <0.774831, 0.503181, 0.382683> }
triangle { <0.774831, 0.503181, 0.382683>, <0.800103, 0.461940, 0.382683>, <0.786475, 0.454072, 0.418660> }
triangle { <0.800103, 0.461940, 0.382683>, <0.774831, 0.503181, 0.382683>, <0.786833, 0.510976, 0.346117> }
triangle { <0.786833, 0.510976, 0.346117>, <0.812498, 0.469096, 0.346117>, <0.800103, 0.461940, 0.382683> }
triangle { <0.812498, 0.469096, 0.346117>, <0.786833, 0.510976, 0.346117>, <0.797623, 0.517983, 0.309017> }
triangle { <0.797623, 0.517983, 0.309017>, <0.823639, 0.475528, 0.309017>, <0.812498, 0.469096, 0.346117> }
triangle { <0.823639, 0.475528, 0.309017>, <0.797623, 0.517983, 0.309017>, <0.807183, 0.524191, 0.271440> }
triangle { <0.807183, 0.524191, 0.271440>, <0.833511, 0.481228, 0.271440>, <0.823639, 0.475528, 0.309017> }
triangle { <0.833511, 0.481228, 0.271440>, <0.807183, 0.524191, 0.271440>, <0.815498, 0.529591, 0.233445> }
triangle { <0.815498, 0.529591, 0.233445>, <0.842097, 0.486185, 0.233445>, <0.833511, 0.481228, 0.271440> }
triangle { <0.842097, 0.486185, 0.233445>, <0.815498, 0.529591, 0.233445>, <0.822556, 0.534174, 0.195090> }
triangle { <0.822556, 0.534174, 0.195090>, <0.849385, 0.490393, 0.195090>, <0.842097, 0.486185, 0.233445> }
triangle { <0.849385, 0.490393, 0.195090>, <0.822556, 0.534174, 0.195090>, <0.828345, 0.537934, 0.156434> }
triangle { <0.828345, 0.537934, 0.156434>, <0.855363, 0.493844, 0.156434>, <0.849385, 0.490393, 0.195090> }
triangle { <0.855363, 0.493844, 0.156434>, <0.828345, 0.537934, 0.156434>, <0.832857, 0.540864, 0.117537> }
triangle { <0.832857, 0.540864, 0.117537>, <0.860023, 0.496534, 0.117537>, <0.855363, 0.493844, 0.156434> }
triangle { <0.860023, 0.496534, 0.117537>, <0.832857, 0.540864, 0.117537>, <0.836085, 0.542960, 0.078459> }
triangle { <0.836085, 0.542960, 0.078459>, <0.863356, 0.498459, 0.078459>, <0.860023, 0.496534, 0.117537> }
triangle { <0.863356, 0.498459, 0.078459>, <0.836085, 0.542960, 0.078459>, <0.838024, 0.544219, 0.039260> }
triangle { <0.838024, 0.544219, 0.039260>, <0.865358, 0.499615, 0.039260>, <0.863356, 0.498459, 0.078459> }
triangle { <0.865358, 0.499615, 0.039260>, <0.838024, 0.544219, 0.039260>, <0.838671, 0.544639, -0.000000> }
triangle { <0.838671, 0.544639, -0.000000>, <0.866025, 0.500000, -0.000000>, <0.865358, 0.499615, 0.039260> }
triangle { <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.031762, 0.023076, 0.999229> }
triangle { <0.031762, 0.023076, 0.999229>, <0.032926, 0.021382, 0.999229>, <0.000000, 0.000000, 1.000000> }
triangle { <0.032926, 0.021382, 0.999229>, <0.031762, 0.023076, 0.999229>, <0.063475, 0.046117, 0.996917> }
triangle { <0.063475, 0.046117, 0.996917>, <0.065801, 0.042732, 0.996917>, <0.032926, 0.021382, 0.999229> }
triangle { <0.065801, 0.042732, 0.996917>, <0.063475, 0.046117, 0.996917>, <0.095090, 0.069087, 0.993068> }
triangle { <0.095090, 0.069087, 0.993068>, <0.098575, 0.064015, 0.993068>, <0.065801, 0.042732, 0.996917> }
triangle { <0.098575, 0.064015, 0.993068>, <0.095090, 0.069087, 0.993068>, <0.126558, 0.091950, 0.987688> }
triangle { <0.126558, 0.091950, 0.987688>, <0.131197, 0.085200, 0.987688>, <0.098575, 0.064015, 0.993068> }
triangle { <0.131197, 0.085200, 0.987688>, <0.126558, 0.091950, 0.987688>, <0.157831, 0.114671, 0.980785> }
triangle { <0.157831, 0.114671, 0.980785>, <0.163617, 0.106254, 0.980785>, <0.131197, 0.085200, 0.987688> }
triangle { <0.163617, 0.106254, 0.980785>, <0.157831, 0.114671, 0.980785>, <0.188861, 0.137216, 0.972370> }
triangle { <0.188861, 0.137216, 0.972370>, <0.195784, 0.127143, 0.972370>, <0.163617, 0.106254, 0.980785> }
triangle { <0.195784, 0.127143, 0.972370>, <0.188861, 0.137216, 0.972370>, <0.219600, 0.159549, 0.962455> }
triangle { <0.219600, 0.159549, 0.962455>, <0.227649, 0.147837, 0.962455>, <0.195784, 0.127143, 0.972370> }
triangle { <0.227649, 0.147837, 0.962455>, <0.219600, 0.159549, 0.962455>, <0.250000, 0.181636, 0.951057> }
triangle { <0.250000, 0.181636, 0.951057>, <0.259163, 0.168303, 0.951057>, <0.227649, 0.147837, 0.962455> }
triangle { <0.259163, 0.168303, 0.951057>, <0.250000, 0.181636, 0.951057>, <0.280015, 0.203443, 0.938191> }
triangle { <0.280015, 0.203443, 0.938191>, <0.290278, 0.188509, 0.938191>, <0.259163, 0.168303, 0.951057> }
triangle { <0.290278, 0.188509, 0.938191>, <0.280015, 0.203443, 0.938191>, <0.309597, 0.224936, 0.923880> }
triangle { <0.309597, 0.224936, 0.923880>, <0.320945, 0.208424, 0.923880>, <0.290278, 0.188509, 0.938191> }
triangle { <0.320945, 0.208424, 0.923880>, <0.309597, 0.224936, 0.923880>, <0.338703, 0.246082, 0.908143> }
triangle { <0.338703, 0.246082, 0.908143>, <0.351118, 0.228018, 0.908143>, <0.320945, 0.208424, 0.923880> }
triangle { <0.351118, 0.228018, 0.908143>, <0.338703, 0.246082, 0.908143>, <0.367286, 0.266849, 0.891007> }
triangle { <0.367286, 0.266849, 0.891007>, <0.380748, 0.247261, 0.891007>, <0.351118, 0.228018, 0.908143> }
triangle { <0.380748, 0.247261, 0.891007>, <0.367286, 0.266849, 0.891007>, <0.395303, 0.287204, 0.872496> }
triangle { <0.395303, 0.287204, 0.872496>, <0.409792, 0.266122, 0.872496>, <0.380748, 0.247261, 0.891007> }
triangle { <0.409792, 0.266122, 0.872496>, <0.395303, 0.287204, 0.872496>, <0.422710, 0.307117, 0.852640> }
triangle { <0.422710, 0.307117, 0.852640>, <0.438204, 0.284573, 0.852640>, <0.409792, 0.266122, 0.872496> }
triangle { <0.438204, 0.284573, 0.852640>, <0.422710, 0.307117, 0.852640>, <0.449466, 0.326556, 0.831470> }
triangle { <0.449466, 0.326556, 0.831470>, <0.465940, 0.302585, 0.831470>, <0.438204, 0.284573, 0.852640> }
triangle { <0.465940, 0.302585, 0.831470>, <0.449466, 0.326556, 0.831470>, <0.475528, 0.345492, 0.809017> }
triangle { <0.475528, 0.345492, 0.809017>, <0.492958, 0.320131, 0.809017>, <0.465940, 0.302585, 0.831470> }
triangle { <0.492958, 0.320131, 0.809017>, <0.475528, 0.345492, 0.809017>, <0.500858, 0.363894, 0.785317> }
triangle { <0.500858, 0.363894, 0.785317>, <0.519216, 0.337183, 0.785317>, <0.492958, 0.320131, 0.809017> }
triangle { <0.519216, 0.337183, 0.785317>, <0.500858, 0.363894, 0.785317>, <0.525415, 0.381736, 0.760406> }
triangle { <0.525415, 0.381736, 0.760406>, <0.544673, 0.353715, 0.760406>, <0.519216, 0.337183, 0.785317> }
triangle { <0.544673, 0.353715, 0.760406>, <0.525415, 0.381736, 0.760406>, <0.549161, 0.398989, 0.734323> }
triangle { <0.549161, 0.398989, 0.734323>, <0.569290, 0.369701, 0.734323>, <0.544673, 0.353715, 0.760406> }
triangle { <0.569290, 0.369701, 0.734323>, <0.549161, 0.398989, 0.734323>, <0.572061, 0.415627, 0.707107> }
triangle { <0.572061, 0.415627, 0.707107>, <0.593030, 0.385118, 0.707107>, <0.569290, 0.369701, 0.734323> }
triangle { <0.593030, 0.385118, 0.707107>, <0.572061, 0.415627, 0.707107>, <0.594079, 0.431624, 0.678801> }
triangle { <0.594079, 0.431624, 0.678801>, <0.615855, 0.399941, 0.678801>, <0.593030, 0.385118, 0.707107> }
triangle { <0.615855, 0.399941, 0.678801>, <0.594079, 0.431624, 0.678801>, <0.615181, 0.446955, 0.649448> }
triangle { <0.615181, 0.446955, 0.649448>, <0.637730, 0.414147, 0.649448>, <0.615855, 0.399941, 0.678801> }
triangle { <0.637730, 0.414147, 0.649448>, <0.615181, 0.446955, 0.649448>, <0.635335, 0.461598, 0.619094> }
triangle { <0.635335, 0.461598, 0.619094>, <0.658622, 0.427714, 0.619094>, <0.637730, 0.414147, 0.649448> }
triangle { <0.658622, 0.427714, 0.619094>, <0.635335, 0.461598, 0.619094>, <0.654508, 0.475528, 0.587785> }
triangle { <0.654508, 0.475528, 0.587785>, <0.678499, 0.440622, 0.587785>, <0.658622, 0.427714, 0.619094> }
triangle { <0.678499, 0.440622, 0.587785>, <0.654508, 0.475528, 0.587785>, <0.672673, 0.488726, 0.555570> }
triangle { <0.672673, 0.488726, 0.555570>, <0.697329, 0.452851, 0.555570>, <0.678499, 0.440622, 0.587785> }
triangle { <0.697329, 0.452851, 0.555570>, <0.672673, 0.488726, 0.555570>, <0.689800, 0.501169, 0.522499> }
triangle { <0.689800, 0.501169, 0.522499>, <0.715084, 0.464381, 0.522499>, <0.697329, 0.452851, 0.555570> }
triangle { <0.715084, 0.464381, 0.522499>, <0.689800, 0.501169, 0.522499>, <0.705864, 0.512840, 0.488621> }
triangle { <0.705864, 0.512840, 0.488621>, <0.731737, 0.475195, 0.488621>, <0.715084, 0.464381, 0.522499> }
triangle { <0.731737, 0.475195, 0.488621>, <0.705864, 0.512840, 0.488621>, <0.720839, 0.523720, 0.453990> }
triangle { <0.720839, 0.523720, 0.453990>, <0.747261, 0.485277, 0.453990>, <0.731737, 0.475195, 0.488621> }
triangle { <0.747261, 0.485277, 0.453990>, <0.720839, 0.523720, 0.453990>, <0.734703, 0.533793, 0.418660> }
triangle { <0.734703, 0.533793, 0.418660>, <0.761633, 0.494610, 0.418660>, <0.747261, 0.485277, 0.453990> }
triangle { <0.761633, 0.494610, 0.418660>, <0.734703, 0.533793, 0.418660>, <0.747434, 0.543043, 0.382683> }
triangle { <0.747434, 0.543043, 0.382683>, <0.774831, 0.503181, 0.382683>, <0.761633, 0.494610, 0.418660> }
triangle { <0.774831, 0.503181, 0.382683>, <0.747434, 0.543043, 0.382683>, <0.759013, 0.551455, 0.346117> }
triangle { <0.759013, 0.551455, 0.346117>, <0.786833, 0.510976, 0.346117>, <0.774831, 0.503181, 0.382683> }
triangle { <0.786833, 0.510976, 0.346117>, <0.759013, 0.551455, 0.346117>, <0.769421, 0.559017, 0.309017> }
triangle { <0.769421, 0.559017, 0.309017>, <0.797623, 0.517983, 0.309017>, <0.786833, 0.510976, 0.346117> }
triangle { <0.797623, 0.517983, 0.309017>, <0.769421, 0.559017, 0.309017>, <0.778643, 0.565717, 0.271440> }
triangle { <0.778643, 0.565717, 0.271440>, <0.807183, 0.524191, 0.271440>, <0.797623, 0.517983, 0.309017> }
triangle { <0.807183, 0.524191, 0.271440>, <0.778643, 0.565717, 0.271440>, <0.786664, 0.571545, 0.233445> }
triangle { <0.786664, 0.571545, 0.233445>, <0.815498, 0.529591, 0.233445>, <0.807183, 0.524191, 0.271440> }
triangle { <0.815498, 0.529591, 0.233445>, <0.786664, 0.571545, 0.233445>, <0.793472, 0.576491, 0.195090> }
triangle { <0.793472, 0.576491, 0.195090>, <0.822556, 0.534174, 0.195090>, <0.815498, 0.529591, 0.233445> }
triangle { <0.822556, 0.534174, 0.195090>, <0.793472, 0.576491, 0.195090>, <0.799057, 0.580549, 0.156434> }
triangle { <0.799057, 0.580549, 0.156434>, <0.828345, 0.537934, 0.156434>, <0.822556, 0.534174, 0.195090> }
triangle { <0.828345, 0.537934, 0.156434>, <0.799057, 0.580549, 0.156434>, <0.803409, 0.583711, 0.117537> }
triangle { <0.803409, 0.583711, 0.117537>, <0.832857, 0.540864, 0.117537>, <0.828345, 0.537934, 0.156434> }
triangle { <0.832857, 0.540864, 0.117537>, <0.803409, 0.583711, 0.117537>, <0.806523, 0.585973, 0.078459> }
triangle { <0.806523, 0.585973, 0.078459>, <0.836085, 0.542960, 0.078459>, <0.832857, 0.540864, 0.117537> }
triangle { <0.836085, 0.542960, 0.078459>, <0.806523, 0.585973, 0.078459>, <0.808393, 0.587332, 0.039260> }
triangle { <0.808393, 0.587332, 0.039260>, <0.838024, 0.544219, 0.039260>, <0.836085, 0.542960, 0.078459> }
triangle { <0.838024, 0.544219, 0.039260>, <0.808393, 0.587332, 0.039260>, <0.809017, 0.587785, -0.000000> }
triangle { <0.809017, 0.587785, -0.000000>, <0.838671, 0.544639, -0.000000>, <0.838024, 0.544219, 0.039260> }
triangle { <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.030511, 0.024707, 0.999229> }
triangle { <0.030511, 0.024707, 0.999229>, <0.031762, 0.023076, 0.999229>, <0.000000, 0.000000, 1.000000> }
triangle { <0.031762, 0.023076, 0.999229>, <0.030511, 0.024707, 0.999229>, <0.060974, 0.049376, 0.996917> }
triangle { <0.060974, 0.049376, 0.996917>, <0.063475, 0.046117, 0.996917>, <0.031762, 0.023076, 0.999229> }
triangle { <0.063475, 0.046117, 0.996917>, <0.060974, 0.049376, 0.996917>, <0.091344, 0.073969, 0.993068> }
triangle { <0.091344, 0.073969, 0.993068>, <0.095090, 0.069087, 0.993068>, <0.063475, 0.046117, 0.996917> }
triangle { <0.095090, 0.069087, 0.993068>, <0.091344, 0.073969, 0.993068>, <0.121572, 0.098447, 0.987688> }
triangle { <0.121572, 0.098447, 0.987688>, <0.126558, 0.091950, 0.987688>, <0.095090, 0.069087, 0.993068> }
triangle { <0.126558, 0.091950, 0.987688>, <0.121572, 0.098447, 0.987688>, <0.151614, 0.122774, 0.980785> }
triangle { <0.151614, 0.122774, 0.980785>, <0.157831, 0.114671, 0.980785>, <0.126558, 0.091950, 0.987688> }
triangle { <0.157831, 0.114671, 0.980785>, <0.151614, 0.122774, 0.980785>, <0.181421, 0.146912, 0.972370> }
triangle { <0.181421, 0.146912, 0.972370>, <0.188861, 0.137216, 0.972370>, <0.157831, 0.114671, 0.980785> }
triangle { <0.188861, 0.137216, 0.972370>, <0.181421, 0.146912, 0.972370>, <0.210949, 0.170823, 0.962455> }
triangle { <0.210949, 0.170823, 0.962455>, <0.219600, 0.159549, 0.962455>, <0.188861, 0.137216, 0.972370> }
triangle { <0.219600, 0.159549, 0.962455>, <0.210949, 0.170823, 0.962455>, <0.240151, 0.194471, 0.951057> }
triangle { <0.240151, 0.194471, 0.951057>, <0.250000, 0.181636, 0.951057>, <0.219600, 0.159549, 0.962455> }
triangle { <0.250000, 0.181636, 0.951057>, <0.240151, 0.194471, 0.951057>, <0.268983, 0.217819, 0.938191> }
triangle { <0.268983, 0.217819, 0.938191>, <0.280015, 0.203443, 0.938191>, <0.250000, 0.181636, 0.951057> }
triangle { <0.280015, 0.203443, 0.938191>, <0.268983, 0.217819, 0.938191>, <0.297401, 0.240830, 0.923880> }
triangle { <0.297401, 0.240830, 0.923880>, <0.309597, 0.224936, 0.923880>, <0.280015, 0.203443, 0.938191> }
triangle { <0.309597, 0.224936, 0.923880>, <0.297401, 0.240830, 0.923880>, <0.325360, 0.263471, 0.908143> }
triangle { <0.325360, 0.263471, 0.908143>, <0.338703, 0.246082, 0.908143>, <0.309597, 0.224936, 0.923880> }
triangle { <0.338703, 0.246082, 0.908143>, <0.325360, 0.263471, 0.908143>, <0.352817, 0.285705, 0.891007> }
triangle { <0.352817, 0.285705, 0.891007>, <0.367286, 0.266849, 0.891007>, <0.338703, 0.246082, 0.908143> }
triangle { <0.367286, 0.266849, 0.891007>, <0.352817, 0.285705, 0.891007>, <0.379730, 0.307499, 0.872496> }
triangle { <0.379730, 0.307499, 0.872496>, <0.395303, 0.287204, 0.872496>, <0.367286, 0.266849, 0.891007> }
triangle { <0.395303, 0.287204, 0.872496>, <0.379730, 0.307499, 0.872496>, <0.406058, 0.328819, 0.852640> }
triangle { <0.406058, 0.328819, 0.852640>, <0.422710, 0.307117, 0.852640>, <0.395303, 0.287204, 0.872496> }
triangle { <0.422710, 0.307117, 0.852640>, <0.406058, 0.328819, 0.852640>, <0.431759, 0.349632, 0.831470> }
triangle { <0.431759, 0.349632, 0.831470>, <0.449466, 0.326556, 0.831470>, <0.422710, 0.307117, 0.852640> }
triangle { <0.449466, 0.326556, 0.831470>, <0.431759, 0.349632, 0.831470>, <0.456795, 0.369905, 0.809017> }
triangle { <0.456795, 0.369905, 0.809017>, <0.475528, 0.345492, 0.809017>, <0.449466, 0.326556, 0.831470> }
triangle { <0.475528, 0.345492, 0.809017>, <0.456795, 0.369905, 0.809017>, <0.481126, 0.389608, 0.785317> }
triangle { <0.481126, 0.389608, 0.785317>, <0.500858, 0.363894, 0.785317>, <0.475528, 0.345492, 0.809017> }
triangle { <0.500858, 0.363894, 0.785317>, <0.481126, 0.389608, 0.785317>, <0.504716, 0.408711, 0.760406> }
triangle { <0.504716, 0.408711, 0.760406>, <0.525415, 0.381736, 0.760406>, <0.500858, 0.363894, 0.785317> }
triangle { <0.525415, 0.381736, 0.760406>, <0.504716, 0.408711, 0.760406>, <0.527527, 0.427183, 0.734323> }
triangle { <0.527527, 0.427183, 0.734323>, <0.549161, 0.398989, 0.734323>, <0.525415, 0.381736, 0.760406> }
triangle { <0.549161, 0.398989, 0.734323>, <0.527527, 0.427183, 0.734323>, <0.549525, 0.444997, 0.707107> }
triangle { <0.549525, 0.444997, 0.707107>, <0.572061, 0.415627, 0.707107>, <0.549161, 0.398989, 0.734323> }
triangle { <0.572061, 0.415627, 0.707107>, <0.549525, 0.444997, 0.707107>, <0.570676, 0.462124, 0.678801> }
triangle { <0.570676, 0.462124, 0.678801>, <0.594079, 0.431624, 0.678801>, <0.572061, 0.415627, 0.707107> }
triangle { <0.594079, 0.431624, 0.678801>, <0.570676, 0.462124, 0.678801>, <0.590946, 0.478539, 0.649448> }
triangle { <0.590946, 0.478539, 0.649448>, <0.615181, 0.446955, 0.649448>, <0.594079, 0.431624, 0.678801> }
triangle { <0.615181, 0.446955, 0.649448>, <0.590946, 0.478539, 0.649448>, <0.610306, 0.494216, 0.619094> }
triangle { <0.610306, 0.494216, 0.619094>, <0.635335, 0.461598, 0.619094>, <0.615181, 0.446955, 0.649448> }
triangle { <0.635335, 0.461598, 0.619094>, <0.610306, 0.494216, 0.619094>, <0.628724, 0.509131, 0.587785> }
triangle { <0.628724, 0.509131, 0.587785>, <0.654508, 0.475528, 0.587785>, <0.635335, 0.461598, 0.619094> }
triangle { <0.654508, 0.475528, 0.587785>, <0.628724, 0.509131, 0.587785>, <0.646173, 0.523261, 0.555570> }
triangle { <0.646173, 0.523261, 0.555570>, <0.672673, 0.488726, 0.555570>, <0.654508, 0.475528, 0.587785> }
triangle { <0.672673, 0.488726, 0.555570>, <0.646173, 0.523261, 0.555570>, <0.662626, 0.536584, 0.522499> }
triangle { <0.662626, 0.536584, 0.522499>, <0.689800, 0.501169, 0.522499>, <0.672673, 0.488726, 0.555570> }
triangle { <0.689800, 0.501169, 0.522499>, <0.662626, 0.536584, 0.522499>, <0.678057, 0.549080, 0.488621> }
triangle { <0.678057, 0.549080, 0.488621>, <0.705864, 0.512840, 0.488621>, <0.689800, 0.501169, 0.522499> }
triangle { <0.705864, 0.512840, 0.488621>, <0.678057, 0.549080, 0.488621>, <0.692442, 0.560729, 0.453990> }
triangle { <0.692442, 0.560729, 0.453990>, <0.720839, 0.523720, 0.453990>, <0.705864, 0.512840, 0.488621> }
triangle { <0.720839, 0.523720, 0.453990>, <0.692442, 0.560729, 0.453990>, <0.705760, 0.571513, 0.418660> }
triangle { <0.705760, 0.571513, 0.418660>, <0.734703, 0.533793, 0.418660>, <0.720839, 0.523720, 0.453990> }
triangle { <0.734703, 0.533793, 0.418660>, <0.705760, 0.571513, 0.418660>, <0.717989, 0.581416, 0.382683> }
triangle { <0.717989, 0.581416, 0.382683>, <0.747434, 0.543043, 0.382683>, <0.734703, 0.533793, 0.418660> }
triangle { <0.747434, 0.543043, 0.382683>, <0.717989, 0.581416, 0.382683>, <0.729112, 0.590423, 0.346117> }
triangle { <0.729112, 0.590423, 0.346117>, <0.759013, 0.551455, 0.346117>, <0.747434, 0.543043, 0.382683> }
triangle { <0.759013, 0.551455, 0.346117>, <0.729112, 0.590423, 0.346117>, <0.739110, 0.598519, 0.309017> }
triangle { <0.739110, 0.598519, 0.309017>, <0.769421, 0.559017, 0.309017>, <0.759013, 0.551455, 0.346117> }
triangle { <0.769421, 0.559017, 0.309017>, <0.739110, 0.598519, 0.309017>, <0.747968, 0.605693, 0.271440> }
triangle { <0.747968, 0.605693, 0.271440>, <0.778643, 0.565717, 0.271440>, <0.769421, 0.559017, 0.309017> }
triangle { <0.778643, 0.565717, 0.271440>, <0.747968, 0.605693, 0.271440>, <0.755673, 0.611932, 0.233445> }
triangle { <0.755673, 0.611932, 0.233445>, <0.786664, 0.571545, 0.233445>, <0.778643, 0.565717, 0.271440> }
triangle { <0.786664, 0.571545, 0.233445>, <0.755673, 0.611932, 0.233445>, <0.762213, 0.617228, 0.195090> }
triangle { <0.762213, 0.617228, 0.195090>, <0.793472, 0.576491, 0.195090>, <0.786664, 0.571545, 0.233445> }
triangle { <0.793472, 0.576491, 0.195090>, <0.762213, 0.617228, 0.195090>, <0.767578, 0.621572, 0.156434> }
triangle { <0.767578, 0.621572, 0.156434>, <0.799057, 0.580549, 0.156434>, <0.793472, 0.576491, 0.195090> }
triangle { <0.799057, 0.580549, 0.156434>, <0.767578, 0.621572, 0.156434>, <0.771759, 0.624958, 0.117537> }
triangle { <0.771759, 0.624958, 0.117537>, <0.803409, 0.583711, 0.117537>, <0.799057, 0.580549, 0.156434> }
triangle { <0.803409, 0.583711, 0.117537>, <0.771759, 0.624958, 0.117537>, <0.774750, 0.627380, 0.078459> }
triangle { <0.774750, 0.627380, 0.078459>, <0.806523, 0.585973, 0.078459>, <0.803409, 0.583711, 0.117537> }
triangle { <0.806523, 0.585973, 0.078459>, <0.774750, 0.627380, 0.078459>, <0.776547, 0.628835, 0.039260> }
triangle { <0.776547, 0.628835, 0.039260>, <0.808393, 0.587332, 0.039260>, <0.806523, 0.585973, 0.078459> }
triangle { <0.808393, 0.587332, 0.039260>, <0.776547, 0.628835, 0.039260>, <0.777146, 0.629320, -0.000000> }
triangle { <0.777146, 0.629320, -0.000000>, <0.809017, 0.587785, -0.000000>, <0.808393, 0.587332, 0.039260> }
triangle { <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.029176, 0.026270, 0.999229> }
triangle { <0.029176, 0.026270, 0.999229>, <0.030511, 0.024707, 0.999229>, <0.000000, 0.000000, 1.000000> }
triangle { <0.030511, 0.024707, 0.999229>, <0.029176, 0.026270, 0.999229>, <0.058306, 0.052499, 0.996917> }
triangle { <0.058306, 0.052499, 0.996917>, <0.060974, 0.049376, 0.996917>, <0.030511, 0.024707, 0.999229> }
triangle { <0.060974, 0.049376, 0.996917>, <0.058306, 0.052499, 0.996917>, <0.087347, 0.078648, 0.993068> }
triangle { <0.087347, 0.078648, 0.993068>, <0.091344, 0.073969, 0.993068>, <0.060974, 0.049376, 0.996917> }
triangle { <0.091344, 0.073969, 0.993068>, <0.087347, 0.078648, 0.993068>, <0.116253, 0.104675, 0.987688> }
triangle { <0.116253, 0.104675, 0.987688>, <0.121572, 0.098447, 0.987688>, <0.091344, 0.073969, 0.993068> }
triangle { <0.121572, 0.098447, 0.987688>, <0.116253, 0.104675, 0.987688>, <0.144980, 0.130541, 0.980785> }
triangle { <0.144980, 0.130541, 0.980785>, <0.151614, 0.122774, 0.980785>, <0.121572, 0.098447, 0.987688> }
triangle { <0.151614, 0.122774, 0.980785>, <0.144980, 0.130541, 0.980785>, <0.173484, 0.156205, 0.972370> }
triangle { <0.173484, 0.156205, 0.972370>, <0.181421, 0.146912, 0.972370>, <0.151614, 0.122774, 0.980785> }
triangle { <0.181421, 0.146912, 0.972370>, <0.173484, 0.156205, 0.972370>, <0.201720, 0.181629, 0.962455> }
triangle { <0.201720, 0.181629, 0.962455>, <0.210949, 0.170823, 0.962455>, <0.181421, 0.146912, 0.972370> }
triangle { <0.210949, 0.170823, 0.962455>, <0.201720, 0.181629, 0.962455>, <0.229644, 0.206773, 0.951057> }
triangle { <0.229644, 0.206773, 0.951057>, <0.240151, 0.194471, 0.951057>, <0.210949, 0.170823, 0.962455> }
triangle { <0.240151, 0.194471, 0.951057>, <0.229644, 0.206773, 0.951057>, <0.257215, 0.231598, 0.938191> }
triangle { <0.257215, 0.231598, 0.938191>, <0.268983, 0.217819, 0.938191>, <0.240151, 0.194471, 0.951057> }
triangle { <0.268983, 0.217819, 0.938191>, <0.257215, 0.231598, 0.938191>, <0.284389, 0.256065, 0.923880> }
triangle { <0.284389, 0.256065, 0.923880>, <0.297401, 0.240830, 0.923880>, <0.268983, 0.217819, 0.938191> }
triangle { <0.297401, 0.240830, 0.923880>, <0.284389, 0.256065, 0.923880>, <0.311125, 0.280138, 0.908143> }
triangle { <0.311125, 0.280138, 0.908143>, <0.325360, 0.263471, 0.908143>, <0.297401, 0.240830, 0.923880> }
triangle { <0.325360, 0.263471, 0.908143>, <0.311125, 0.280138, 0.908143>, <0.337381, 0.303779, 0.891007> }
triangle { <0.337381, 0.303779, 0.891007>, <0.352817, 0.285705, 0.891007>, <0.325360, 0.263471, 0.908143> }
triangle { <0.352817, 0.285705, 0.891007>, <0.337381, 0.303779, 0.891007>, <0.363116, 0.326951, 0.872496> }
triangle { <0.363116, 0.326951, 0.872496>, <0.379730, 0.307499, 0.872496>, <0.352817, 0.285705, 0.891007> }
triangle { <0.379730, 0.307499, 0.872496>, <0.363116, 0.326951, 0.872496>, <0.388292, 0.349620, 0.852640> }
triangle { <0.388292, 0.349620, 0.852640>, <0.406058, 0.328819, 0.852640>, <0.379730, 0.307499, 0.872496> }
triangle { <0.406058, 0.328819, 0.852640>, <0.388292, 0.349620, 0.852640>, <0.412869, 0.371749, 0.831470> }
triangle { <0.412869, 0.371749, 0.831470>, <0.431759, 0.349632, 0.831470>, <0.406058, 0.328819, 0.852640> }
triangle { <0.431759, 0.349632, 0.831470>, <0.412869, 0.371749, 0.831470>, <0.436810, 0.393305, 0.809017> }
triangle { <0.436810, 0.393305, 0.809017>, <0.456795, 0.369905, 0.809017>, <0.431759, 0.349632, 0.831470> }
triangle { <0.456795, 0.369905, 0.809017>, <0.436810, 0.393305, 0.809017>, <0.460076, 0.414255, 0.785317> }
triangle { <0.460076, 0.414255, 0.785317>, <0.481126, 0.389608, 0.785317>, <0.456795, 0.369905, 0.809017> }
triangle { <0.481126, 0.389608, 0.785317>, <0.460076, 0.414255, 0.785317>, <0.482634, 0.434566, 0.760406> }
triangle { <0.482634, 0.434566, 0.760406>, <0.504716, 0.408711, 0.760406>, <0.481126, 0.389608, 0.785317> }
triangle { <0.504716, 0.408711, 0.760406>, <0.482634, 0.434566, 0.760406>, <0.504447, 0.454206, 0.734323> }
triangle { <0.504447, 0.454206, 0.734323>, <0.527527, 0.427183, 0.734323>, <0.504716, 0.408711, 0.760406> }
triangle { <0.527527, 0.427183, 0.734323>, <0.504447, 0.454206, 0.734323>, <0.525483, 0.473147, 0.707107> }
triangle { <0.525483, 0.473147, 0.707107>, <0.549525, 0.444997, 0.707107>, <0.527527, 0.427183, 0.734323> }
triangle { <0.549525, 0.444997, 0.707107>, <0.525483, 0.473147, 0.707107>, <0.545708, 0.491358, 0.678801> }
triangle { <0.545708, 0.491358, 0.678801>, <0.570676, 0.462124, 0.678801>, <0.549525, 0.444997, 0.707107> }
triangle { <0.570676, 0.462124, 0.678801>, <0.545708, 0.491358, 0.678801>, <0.565092, 0.508811, 0.649448> }
triangle { <0.565092, 0.508811, 0.649448>, <0.590946, 0.478539, 0.649448>, <0.570676, 0.462124, 0.678801> }
triangle { <0.590946, 0.478539, 0.649448>, <0.565092, 0.508811, 0.649448>, <0.583604, 0.525480, 0.619094> }
triangle { <0.583604, 0.525480, 0.619094>, <0.610306, 0.494216, 0.619094>, <0.590946, 0.478539, 0.649448> }
triangle { <0.610306, 0.494216, 0.619094>, <0.583604, 0.525480, 0.619094>, <0.601217, 0.541338, 0.587785> }
triangle { <0.601217, 0.541338, 0.587785>, <0.628724, 0.509131, 0.587785>, <0.610306, 0.494216, 0.619094> }
triangle { <0.628724, 0.509131, 0.587785>, <0.601217, 0.541338, 0.587785>, <0.617902, 0.556362, 0.555570> }
triangle { <0.617902, 0.556362, 0.555570>, <0.646173, 0.523261, 0.555570>, <0.628724, 0.509131, 0.587785> }
triangle { <0.646173, 0.523261, 0.555570>, <0.617902, 0.556362, 0.555570>, <0.633635, 0.570528, 0.522499> }
triangle { <0.633635, 0.570528, 0.522499>, <0.662626, 0.536584, 0.522499>, <0.646173, 0.523261, 0.555570> }
triangle { <0.662626, 0.536584, 0.522499>, <0.633635, 0.570528, 0.522499>, <0.648391, 0.583814, 0.488621> }
triangle { <0.648391, 0.583814, 0.488621>, <0.678057, 0.549080, 0.488621>, <0.662626, 0.536584, 0.522499> }
triangle { <0.678057, 0.549080, 0.488621>, <0.648391, 0.583814, 0.488621>, <0.662147, 0.596200, 0.453990> }
triangle { <0.662147, 0.596200, 0.453990>, <0.692442, 0.560729, 0.453990>, <0.678057, 0.549080, 0.488621> }
triangle { <0.692442, 0.560729, 0.453990>, <0.662147, 0.596200, 0.453990>, <0.674882, 0.607666, 0.418660> }
triangle { <0.674882, 0.607666, 0.418660>, <0.705760, 0.571513, 0.418660>, <0.692442, 0.560729, 0.453990> }
triangle { <0.705760, 0.571513, 0.418660>, <0.674882, 0.607666, 0.418660>, <0.686576, 0.618196, 0.382683> }
triangle { <0.686576, 0.618196, 0.382683>, <0.717989, 0.581416, 0.382683>, <0.705760, 0.571513, 0.418660> }
triangle { <0.717989, 0.581416, 0.382683>, <0.686576, 0.618196, 0.382683>, <0.697212, 0.627773, 0.346117> }
triangle { <0.697212, 0.627773, 0.346117>, <0.729112, 0.590423, 0.346117>, <0.717989, 0.581416, 0.382683> }
triangle { <0.729112, 0.590423, 0.346117>, <0.697212, 0.627773, 0.346117>, <0.706773, 0.636381, 0.309017> }
triangle { <0.706773, 0.636381, 0.309017>, <0.739110, 0.598519, 0.309017>, <0.729112, 0.590423, 0.346117> }
triangle { <0.739110, 0.598519, 0.309017>, <0.706773, 0.636381, 0.309017>, <0.715244, 0.644008, 0.271440> }
triangle { <0.715244, 0.644008, 0.271440>, <0.747968, 0.605693, 0.271440>, <0.739110, 0.598519, 0.309017> }
triangle { <0.747968, 0.605693, 0.271440>, <0.715244, 0.644008, 0.271440>, <0.722612, 0.650642, 0.233445> }
triangle { <0.722612, 0.650642, 0.233445>, <0.755673, 0.611932, 0.233445>, <0.747968, 0.605693, 0.271440> }
triangle { <0.755673, 0.611932, 0.233445>, <0.722612, 0.650642, 0.233445>, <0.728866, 0.656273, 0.195090> }
triangle { <0.728866, 0.656273, 0.195090>, <0.762213, 0.617228, 0.195090>, <0.755673, 0.611932, 0.233445> }
triangle { <0.762213, 0.617228, 0.195090>, <0.728866, 0.656273, 0.195090>, <0.733995, 0.660892, 0.156434> }
triangle { <0.733995, 0.660892, 0.156434>, <0.767578, 0.621572, 0.156434>, <0.762213, 0.617228, 0.195090> }
triangle { <0.767578, 0.621572, 0.156434>, <0.733995, 0.660892, 0.156434>, <0.737994, 0.664492, 0.117537> }
triangle { <0.737994, 0.664492, 0.117537>, <0.771759, 0.624958, 0.117537>, <0.767578, 0.621572, 0.156434> }
triangle { <0.771759, 0.624958, 0.117537>, <0.737994, 0.664492, 0.117537>, <0.740854, 0.667068, 0.078459> }
triangle { <0.740854, 0.667068, 0.078459>, <0.774750, 0.627380, 0.078459>, <0.771759, 0.624958, 0.117537> }
triangle { <0.774750, 0.627380, 0.078459>, <0.740854, 0.667068, 0.078459>, <0.742572, 0.668615, 0.039260> }
triangle { <0.742572, 0.668615, 0.039260>, <0.776547, 0.628835, 0.039260>, <0.774750, 0.627380, 0.078459> }
triangle { <0.776547, 0.628835, 0.039260>, <0.742572, 0.668615, 0.039260>, <0.743145, 0.669131, -0.000000> }
triangle { <0.743145, 0.669131, -0.000000>, <0.777146, 0.629320, -0.000000>, <0.776547, 0.628835, 0.039260> }
triangle { <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.027761, 0.027761, 0.999229> }
triangle { <0.027761, 0.027761, 0.999229>, <0.029176, 0.026270, 0.999229>, <0.000000, 0.000000, 1.000000> }
triangle { <0.029176, 0.026270, 0.999229>, <0.027761, 0.027761, 0.999229>, <0.055479, 0.055479, 0.996917> }
triangle { <0.055479, 0.055479, 0.996917>, <0.058306, 0.052499, 0.996917>, <0.029176, 0.026270, 0.999229> }
triangle { <0.058306, 0.052499, 0.996917>, <0.055479, 0.055479, 0.996917>, <0.083111, 0.083111, 0.993068> }
triangle { <0.083111, 0.083111, 0.993068>, <0.087347, 0.078648, 0.993068>, <0.058306, 0.052499, 0.996917> }
triangle { <0.087347, 0.078648, 0.993068>, <0.083111, 0.083111, 0.993068>, <0.110616, 0.110616, 0.987688> }
triangle { <0.110616, 0.110616, 0.987688>, <0.116253, 0.104675, 0.987688>, <0.087347, 0.078648, 0.993068> }
triangle { <0.116253, 0.104675, 0.987688>, <0.110616, 0.110616, 0.987688>, <0.137950, 0.137950, 0.980785> }
triangle { <0.137950, 0.137950, 0.980785>, <0.144980, 0.130541, 0.980785>, <0.116253, 0.104675, 0.987688> }
triangle { <0.144980, 0.130541, 0.980785>, <0.137950, 0.137950, 0.980785>, <0.165071, 0.165071, 0.972370> }
triangle { <0.165071, 0.165071, 0.972370>, <0.173484, 0.156205, 0.972370>, <0.144980, 0.130541, 0.980785> }
triangle { <0.173484, 0.156205, 0.972370>, <0.165071, 0.165071, 0.972370>, <0.191937, 0.191937, 0.962455> }
triangle { <0.191937, 0.191937, 0.962455>, <0.201720, 0.181629, 0.962455>, <0.173484, 0.156205, 0.972370> }
triangle { <0.201720, 0.181629, 0.962455>, <0.191937, 0.191937, 0.962455>, <0.218508, 0.218508, 0.951057> }
triangle { <0.218508, 0.218508, 0.951057>, <0.229644, 0.206773, 0.951057>, <0.201720, 0.181629, 0.962455> }
triangle { <0.229644, 0.206773, 0.951057>, <0.218508, 0.218508, 0.951057>, <0.244742, 0.244742, 0.938191> }
triangle { <0.244742, 0.244742, 0.938191>, <0.257215, 0.231598, 0.938191>, <0.229644, 0.206773, 0.951057> }
triangle { <0.257215, 0.231598, 0.938191>, <0.244742, 0.244742, 0.938191>, <0.270598, 0.270598, 0.923880> }
triangle { <0.270598, 0.270598, 0.923880>, <0.284389, 0.256065, 0.923880>, <0.257215, 0.231598, 0.938191> }
triangle { <0.284389, 0.256065, 0.923880>, <0.270598, 0.270598, 0.923880>, <0.296037, 0.296037, 0.908143> }
triangle { <0.296037, 0.296037, 0.908143>, <0.311125, 0.280138, 0.908143>, <0.284389, 0.256065, 0.923880> }
triangle { <0.311125, 0.280138, 0.908143>, <0.296037, 0.296037, 0.908143>, <0.321020, 0.321020, 0.891007> }
triangle { <0.321020, 0.321020, 0.891007>, <0.337381, 0.303779, 0.891007>, <0.311125, 0.280138, 0.908143> }
triangle { <0.337381, 0.303779, 0.891007>, <0.321020, 0.321020, 0.891007>, <0.345507, 0.345507, 0.872496> }
triangle { <0.345507, 0.345507, 0.872496>, <0.363116, 0.326951, 0.872496>, <0.337381, 0.303779, 0.891007> }
triangle { <0.363116, 0.326951, 0.872496>, <0.345507, 0.345507, 0.872496>, <0.369462, 0.369462, 0.852640> }
triangle { <0.369462, 0.369462, 0.852640>, <0.388292, 0.349620, 0.852640>, <0.363116, 0.326951, 0.872496> }
triangle { <0.388292, 0.349620, 0.852640>, <0.369462, 0.369462, 0.852640>, <0.392847, 0.392847, 0.831470> }
triangle { <0.392847, 0.392847, 0.831470>, <0.412869, 0.371749, 0.831470>, <0.388292, 0.349620, 0.852640> }
triangle { <0.412869, 0.371749, 0.831470>, <0.392847, 0.392847, 0.831470>, <0.415627, 0.415627, 0.809017> }
triangle { <0.415627, 0.415627, 0.809017>, <0.436810, 0.393305, 0.809017>, <0.412869, 0.371749, 0.831470> }
triangle { <0.436810, 0.393305, 0.809017>, <0.415627, 0.415627, 0.809017>, <0.437766, 0.437766, 0.785317> }
triangle { <0.437766, 0.437766, 0.785317>, <0.460076, 0.414255, 0.785317>, <0.436810, 0.393305, 0.809017> }
triangle { <0.460076, 0.414255, 0.785317>, <0.437766, 0.437766, 0.785317>, <0.459229, 0.459229, 0.760406> }
triangle { <0.459229, 0.459229, 0.760406>, <0.482634, 0.434566, 0.760406>, <0.460076, 0.414255, 0.785317> }
triangle { <0.482634, 0.434566, 0.760406>, <0.459229, 0.459229, 0.760406>, <0.479985, 0.479985, 0.734323> }
triangle { <0.479985, 0.479985, 0.734323>, <0.504447, 0.454206, 0.734323>, <0.482634, 0.434566, 0.760406> }
triangle { <0.504447, 0.454206, 0.734323>, <0.479985, 0.479985, 0.734323>, <0.500000, 0.500000, 0.707107> }
triangle { <0.500000, 0.500000, 0.707107>, <0.525483, 0.473147, 0.707107>, <0.504447, 0.454206, 0.734323> }
triangle { <0.525483, 0.473147, 0.707107>, <0.500000, 0.500000, 0.707107>, <0.519244, 0.519244, 0.678801> }
triangle { <0.519244, 0.519244, 0.678801>, <0.545708, 0.491358, 0.678801>, <0.525483, 0.473147, 0.707107> }
triangle { <0.545708, 0.491358, 0.678801>, <0.519244, 0.519244, 0.678801>, <0.537688, 0.537688, 0.649448> }
triangle { <0.537688, 0.537688, 0.649448>, <0.565092, 0.508811, 0.649448>, <0.545708, 0.491358, 0.678801> }
triangle { <0.565092, 0.508811, 0.649448>, <0.537688, 0.537688, 0.649448>, <0.555303, 0.555303, 0.619094> }
triangle { <0.555303, 0.555303, 0.619094>, <0.583604, 0.525480, 0.619094>, <0.565092, 0.508811, 0.649448> }
triangle { <0.583604, 0.525480, 0.619094>, <0.555303, 0.555303, 0.619094>, <0.572061, 0.572061, 0.587785> }
triangle { <0.572061, 0.572061, 0.587785>, <0.601217, 0.541338, 0.587785>, <0.583604, 0.525480, 0.619094> }
triangle { <0.601217, 0.541338, 0.587785>, <0.572061, 0.572061, 0.587785>, <0.587938, 0.587938, 0.555570> }
triangle { <0.587938, 0.587938, 0.555570>, <0.617902, 0.556362, 0.555570>, <0.601217, 0.541338, 0.587785> }
triangle { <0.617902, 0.556362, 0.555570>, <0.587938, 0.587938, 0.555570>, <0.602908, 0.602908, 0.522499> }
triangle { <0.602908, 0.602908, 0.522499>, <0.633635, 0.570528, 0.522499>, <0.617902, 0.556362, 0.555570> }
triangle { <0.633635, 0.570528, 0.522499>, <0.602908, 0.602908, 0.522499>, <0.616948, 0.616948, 0.488621> }
triangle { <0.616948, 0.616948, 0.488621>, <0.648391, 0.583814, 0.488621>, <0.633635, 0.570528, 0.522499> }
triangle { <0.648391, 0.583814, 0.488621>, <0.616948, 0.616948, 0.488621>, <0.630037, 0.630037, 0.453990> }
triangle { <0.630037, 0.630037, 0.453990>, <0.662147, 0.596200, 0.453990>, <0.648391, 0.583814, 0.488621> }
triangle { <0.662147, 0.596200, 0.453990>, <0.630037, 0.630037, 0.453990>, <0.642154, 0.642154, 0.418660> }
triangle { <0.642154, 0.642154, 0.418660>, <0.674882, 0.607666, 0.418660>, <0.662147, 0.596200, 0.453990> }
triangle { <0.674882, 0.607666, 0.418660>, <0.642154, 0.642154, 0.418660>, <0.653281, 0.653281, 0.382683> }
triangle { <0.653281, 0.653281, 0.382683>, <0.686576, 0.618196, 0.382683>, <0.674882, 0.607666, 0.418660> }
triangle { <0.686576, 0.618196, 0.382683>, <0.653281, 0.653281, 0.382683>, <0.663401, 0.663401, 0.346117> }
triangle { <0.663401, 0.663401, 0.346117>, <0.697212, 0.627773, 0.346117>, <0.686576, 0.618196, 0.382683> }
triangle { <0.697212, 0.627773, 0.346117>, <0.663401, 0.663401, 0.346117>, <0.672499, 0.672499, 0.309017> }
triangle { <0.672499, 0.672499, 0.309017>, <0.706773, 0.636381, 0.309017>, <0.697212, 0.627773, 0.346117> }
triangle { <0.706773, 0.636381, 0.309017>, <0.672499, 0.672499, 0.309017>, <0.680559, 0.680559, 0.271440> }
triangle { <0.680559, 0.680559, 0.271440>, <0.715244, 0.644008, 0.271440>, <0.706773, 0.636381, 0.309017> }
triangle { <0.715244, 0.644008, 0.271440>, <0.680559, 0.680559, 0.271440>, <0.687569, 0.687569, 0.233445> }
triangle { <0.687569, 0.687569, 0.233445>, <0.722612, 0.650642, 0.233445>, <0.715244, 0.644008, 0.271440> }
triangle { <0.722612, 0.650642, 0.233445>, <0.687569, 0.687569, 0.233445>, <0.693520, 0.693520, 0.195090> }
triangle { <0.693520, 0.693520, 0.195090>, <0.728866, 0.656273, 0.195090>, <0.722612, 0.650642, 0.233445> }
triangle { <0.728866, 0.656273, 0.195090>, <0.693520, 0.693520, 0.195090>, <0.698401, 0.698401, 0.156434> }
triangle { <0.698401, 0.698401, 0.156434>, <0.733995, 0.660892, 0.156434>, <0.728866, 0.656273, 0.195090> }
triangle { <0.733995, 0.660892, 0.156434>, <0.698401, 0.698401, 0.156434>, <0.702205, 0.702205, 0.117537> }
triangle { <0.702205, 0.702205, 0.117537>, <0.737994, 0.664492, 0.117537>, <0.733995, 0.660892, 0.156434> }
triangle { <0.737994, 0.664492, 0.117537>, <0.702205, 0.702205, 0.117537>, <0.704927, 0.704927, 0.078459> }
triangle { <0.704927, 0.704927, 0.078459>, <0.740854, 0.667068, 0.078459>, <0.737994, 0.664492, 0.117537> }
triangle { <0.740854, 0.667068, 0.078459>, <0.704927, 0.704927, 0.078459>, <0.706562, 0.706562, 0.039260> }
triangle { <0.706562, 0.706562, 0.039260>, <0.742572, 0.668615, 0.039260>, <0.740854, 0.667068, 0.078459> }
triangle { <0.742572, 0.668615, 0.039260>, <0.706562, 0.706562, 0.039260>, <0.707107, 0.707107, -0.000000> }
triangle { <0.707107, 0.707107, -0.000000>, <0.743145, 0.669131, -0.000000>, <0.742572, 0.668615, 0.039260> }
triangle { <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.026270, 0.029176, 0.999229> }
triangle { <0.026270, 0.029176, 0.999229>, <0.027761, 0.027761, 0.999229>, <0.000000, 0.000000, 1.000000> }
triangle { <0.027761, 0.027761, 0.999229>, <0.026270, 0.029176, 0.999229>, <0.052499, 0.058306, 0.996917> }
triangle { <0.052499, 0.058306, 0.996917>, <0.055479, 0.055479, 0.996917>, <0.027761, 0.027761, 0.999229> }
triangle { <0.055479, 0.055479, 0.996917>, <0.052499, 0.058306, 0.996917>, <0.078648, 0.087347, 0.993068> }
triangle { <0.078648, 0.087347, 0.993068>, <0.083111, 0.083111, 0.993068>, <0.055479, 0.055479, 0.996917> }
triangle { <0.083111, 0.083111, 0.993068>, <0.078648, 0.087347, 0.993068>, <0.104675, 0.116253, 0.987688> }
triangle { <0.104675, 0.116253, 0.987688>, <0.110616, 0.110616, 0.987688>, <0.083111, 0.083111, 0.993068> }
triangle { <0.110616, 0.110616, 0.987688>, <0.104675, 0.116253, 0.987688>, <0.130541, 0.144980, 0.980785> }
triangle { <0.130541, 0.144980, 0.980785>, <0.137950, 0.137950, 0.980785>, <0.110616, 0.110616, 0.987688> }
triangle { <0.137950, 0.137950, 0.980785>, <0.130541, 0.144980, 0.980785>, <0.156205, 0.173484, 0.972370> }
triangle { <0.156205, 0.173484, 0.972370>, <0.165071, 0.165071, 0.972370>, <0.137950, 0.137950, 0.980785> }
triangle { <0.165071, 0.165071, 0.972370>, <0.156205, 0.173484, 0.972370>, <0.181629, 0.201720, 0.962455> }
triangle { <0.181629, 0.201720, 0.962455>, <0.191937, 0.191937, 0.962455>, <0.165071, 0.165071, 0.972370> }
triangle { <0.191937, 0.191937, 0.962455>, <0.181629, 0.201720, 0.962455>, <0.206773, 0.229644, 0.951057> }
triangle { <0.206773, 0.229644, 0.951057>, <0.218508, 0.218508, 0.951057>, <0.191937, 0.191937, 0.962455> }
triangle { <0.218508, 0.218508, 0.951057>, <0.206773, 0.229644, 0.951057>, <0.231598, 0.257215, 0.938191> }
triangle { <0.231598, 0.257215, 0.938191>, <0.244742, 0.244742, 0.938191>, <0.218508, 0.218508, 0.951057> }
triangle { <0.244742, 0.244742, 0.938191>, <0.231598, 0.257215, 0.938191>, <0.256065, 0.284389, 0.923880> }
triangle { <0.256065, 0.284389, 0.923880>, <0.270598, 0.270598, 0.923880>, <0.244742, 0.244742, 0.938191> }
triangle { <0.270598, 0.270598, 0.923880>, <0.256065, 0.284389, 0.923880>, <0.280138, 0.311125, 0.908143> }
triangle { <0.280138, 0.311125, 0.908143>, <0.296037, 0.296037, 0.908143>, <0.270598, 0.270598, 0.923880> }
triangle { <0.296037, 0.296037, 0.908143>, <0.280138, 0.311125, 0.908143>, <0.303779, 0.337381, 0.891007> }
triangle { <0.303779, 0.337381, 0.891007>, <0.321020, 0.321020, 0.891007>, <0.296037, 0.296037, 0.908143> }
triangle { <0.321020, 0.321020, 0.891007>, <0.303779, 0.337381, 0.891007>, <0.326951, 0.363116, 0.872496> }
triangle { <0.326951, 0.363116, 0.872496>, <0.345507, 0.345507, 0.872496>, <0.321020, 0.321020, 0.891007> }
triangle { <0.345507, 0.345507, 0.872496>, <0.326951, 0.363116, 0.872496>, <0.349620, 0.388292, 0.852640> }
triangle { <0.349620, 0.388292, 0.852640>, <0.369462, 0.369462, 0.852640>, <0.345507, 0.345507, 0.872496> }
triangle { <0.369462, 0.369462, 0.852640>, <0.349620, 0.388292, 0.852640>, <0.371749, 0.412869, 0.831470> }
triangle { <0.371749, 0.412869, 0.831470>, <0.392847, 0.392847, 0.831470>, <0.369462, 0.369462, 0.852640> }
triangle { <0.392847, 0.392847, 0.831470>, <0.371749, 0.412869, 0.831470>, <0.393305, 0.436810, 0.809017> }
triangle { <0.393305, 0.436810, 0.809017>, <0.415627, 0.415627, 0.809017>, <0.392847, 0.392847, 0.831470> }
triangle { <0.415627, 0.415627, 0.809017>, <0.393305, 0.436810, 0.809017>, <0.414255, 0.460076, 0.785317> }
triangle { <0.414255, 0.460076, 0.785317>, <0.437766, 0.437766, 0.785317>, <0.415627, 0.415627, 0.809017> }
triangle { <0.437766, 0.437766, 0.785317>, <0.414255, 0.460076, 0.785317>, <0.434566, 0.482634, 0.760406> }
triangle { <0.434566, 0.482634, 0.760406>, <0.459229, 0.459229, 0.760406>, <0.437766, 0.437766, 0.785317> }
triangle { <0.459229, 0.459229, 0.760406>, <0.434566, 0.482634, 0.760406>, <0.454206, 0.504447, 0.734323> }
triangle { <0.454206, 0.504447, 0.734323>, <0.479985, 0.479985, 0.734323>, <0.459229, 0.459229, 0.760406> }
triangle { <0.479985, 0.479985, 0.734323>, <0.454206, 0.504447, 0.734323>, <0.473147, 0.525483, 0.707107> }
triangle { <0.473147, 0.525483, 0.707107>, <0.500000, 0.500000, 0.707107>, <0.479985, 0.479985, 0.734323> }
triangle { <0.500000, 0.500000, 0.707107>, <0.473147, 0.525483, 0.707107>, <0.491358, 0.545708, 0.678801> }
triangle { <0.491358, 0.545708, 0.678801>, <0.519244, 0.519244, 0.678801>, <0.500000, 0.500000, 0.707107> }
triangle { <0.519244, 0.519244, 0.678801>, <0.491358, 0.545708, 0.678801>, <0.508811, 0.565092, 0.649448> }
triangle { <0.508811, 0.565092, 0.649448>, <0.537688, 0.537688, 0.649448>, <0.519244, 0.519244, 0.678801> }
triangle { <0.537688, 0.537688, 0.649448>, <0.508811, 0.565092, 0.649448>, <0.525480, 0.583604, 0.619094> }
triangle { <0.525480, 0.583604, 0.619094>, <0.555303, 0.555303, 0.619094>, <0.537688, 0.537688, 0.649448> }
triangle { <0.555303, 0.555303, 0.619094>, <0.525480, 0.583604, 0.619094>, <0.541338, 0.601217, 0.587785> }
triangle { <0.541338, 0.601217, 0.587785>, <0.572061, 0.572061, 0.587785>, <0.555303, 0.555303, 0.619094> }
triangle { <0.572061, 0.572061, 0.587785>, <0.541338, 0.601217, 0.587785>, <0.556362, 0.617902, 0.555570> }
triangle { <0.556362, 0.617902, 0.555570>, <0.587938, 0.587938, 0.555570>, <0.572061, 0.572061, 0.587785> }
triangle { <0.587938, 0.587938, 0.555570>, <0.556362, 0.617902, 0.555570>, <0.570528, 0.633635, 0.522499> }
triangle { <0.570528, 0.633635, 0.522499>, <0.602908, 0.602908, 0.522499>, <0.587938, 0.587938, 0.555570> }
triangle { <0.602908, 0.602908, 0.522499>, <0.570528, 0.633635, 0.522499>, <0.583814, 0.648391, 0.488621> }
triangle { <0.583814, 0.648391, 0.488621>, <0.616948, 0.616948, 0.488621>, <0.602908, 0.602908, 0.522499> }
triangle { <0.616948, 0.616948, 0.488621>, <0.583814, 0.648391, 0.488621>, <0.596200, 0.662147, 0.453990> }
triangle { <0.596200, 0.662147, 0.453990>, <0.630037, 0.630037, 0.453990>, <0.616948, 0.616948, 0.488621> }
triangle { <0.630037, 0.630037, 0.453990>, <0.596200, 0.662147, 0.453990>, <0.607666, 0.674882, 0.418660> }
triangle { <0.607666, 0.674882, 0.418660>, <0.642154, 0.642154, 0.418660>, <0.630037, 0.630037, 0.453990> }
triangle { <0.642154, 0.642154, 0.418660>, <0.607666, 0.674882, 0.418660>, <0.618196, 0.686576, 0.382683> }
triangle { <0.618196, 0.686576, 0.382683>, <0.653281, 0.653281, 0.382683>, <0.642154, 0.642154, 0.418660> }
triangle { <0.653281, 0.653281, 0.382683>, <0.618196, 0.686576, 0.382683>, <0.627773, 0.697212, 0.346117> }
triangle { <0.627773, 0.697212, 0.346117>, <0.663401, 0.663401, 0.346117>, <0.653281, 0.653281, 0.382683> }
triangle { <0.663401, 0.663401, 0.346117>, <0.627773, 0.697212, 0.346117>, <0.636381, 0.706773, 0.309017> }
triangle { <0.636381, 0.706773, 0.309017>, <0.672499, 0.672499, 0.309017>, <0.663401, 0.663401, 0.346117> }
triangle { <0.672499, 0.672499, 0.309017>, <0.636381, 0.706773, 0.309017>, <0.644008, 0.715244, 0.271440> }
triangle { <0.644008, 0.715244, 0.271440>, <0.680559, 0.680559, 0.271440>, <0.672499, 0.672499, 0.309017> }
triangle { <0.680559, 0.680559, 0.271440>, <0.644008, 0.715244, 0.271440>, <0.650642, 0.722612, 0.233445> }
triangle { <0.650642, 0.722612, 0.233445>, <0.687569, 0.687569, 0.233445>, <0.680559, 0.680559, 0.271440> }
triangle { <0.687569, 0.687569, 0.233445>, <0.650642, 0.722612, 0.233445>, <0.656273, 0.728866, 0.195090> }
triangle { <0.656273, 0.728866, 0.195090>, <0.693520, 0.693520, 0.195090>, <0.687569, 0.687569, 0.233445> }
triangle { <0.693520, 0.693520, 0.195090>, <0.656273, 0.728866, 0.195090>, <0.660892, 0.733995, 0.156434> }
triangle { <0.660892, 0.733995, 0.156434>, <0.698401, 0.698401, 0.156434>, <0.693520, 0.693520, 0.195090> }
triangle { <0.698401, 0.698401, 0.156434>, <0.660892, 0.733995, 0.156434>, <0.664492, 0.737994, 0.117537> }
triangle { <0.664492, 0.737994, 0.117537>, <0.702205, 0.702205, 0.117537>, <0.698401, 0.698401, 0.156434> }
triangle { <0.702205, 0.702205, 0.117537>, <0.664492, 0.737994, 0.117537>, <0.667068, 0.740854, 0.078459> }
triangle { <0.667068, 0.740854, 0.078459>, <0.704927, 0.704927, 0.078459>, <0.702205, 0.702205, 0.117537> }
triangle { <0.704927, 0.704927, 0.078459>, <0.667068, 0.740854, 0.078459>, <0.668615, 0.742572, 0.039260> }
triangle { <0.668615, 0.742572, 0.039260>, <0.706562, 0.706562, 0.039260>, <0.704927, 0.704927, 0.078459> }
triangle { <0.706562, 0.706562, 0.039260>, <0.668615, 0.742572, 0.039260>, <0.669131, 0.743145, -0.000000> }
triangle { <0.669131, 0.743145, -0.000000>, <0.707107, 0.707107, -0.000000>, <0.706562, 0.706562, 0.039260> }
triangle { <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.024707, 0.030511, 0.999229> }
triangle { <0.024707, 0.030511, 0.999229>, <0.026270, 0.029176, 0.999229>, <0.000000, 0.000000, 1.000000> }
triangle { <0.026270, 0.029176, 0.999229>, <0.024707, 0.030511, 0.999229>, <0.049376, 0.060974, 0.996917> }
triangle { <0.049376, 0.060974, 0.996917>, <0.052499, 0.058306, 0.996917>, <0.026270, 0.029176, 0.999229> }
triangle { <0.052499, 0.058306, 0.996917>, <0.049376, 0.060974, 0.996917>, <0.073969, 0.091344, 0.993068> }
triangle { <0.073969, 0.091344, 0.993068>, <0.078648, 0.087347, 0.993068>, <0.052499, 0.058306, 0.996917> }
triangle { <0.078648, 0.087347, 0.993068>, <0.073969, 0.091344, 0.993068>, <0.098447, 0.121572, 0.987688> }
triangle { <0.098447, 0.121572, 0.987688>, <0.104675, 0.116253, 0.987688>, <0.078648, 0.087347, 0.993068> }
triangle { <0.104675, 0.116253, 0.987688>, <0.098447, 0.121572, 0.987688>, <0.122774, 0.151614, 0.980785> }
triangle { <0.122774, 0.151614, 0.980785>, <0.130541, 0.144980, 0.980785>, <0.104675, 0.116253, 0.987688> }
triangle { <0.130541, 0.144980, 0.980785>, <0.122774, 0.151614, 0.980785>, <0.146912, 0.181421, 0.972370> }
triangle { <0.146912, 0.181421, 0.972370>, <0.156205, 0.173484, 0.972370>, <0.130541, 0.144980, 0.980785> }
triangle { <0.156205, 0.173484, 0.972370>, <0.146912, 0.181421, 0.972370>, <0.170823, 0.210949, 0.962455> }
triangle { <0.170823, 0.210949, 0.962455>, <0.181629, 0.201720, 0.962455>, <0.156205, 0.173484, 0.972370> }
triangle { <0.181629, 0.201720, 0.962455>, <0.170823, 0.210949, 0.962455>, <0.194471, 0.240151, 0.951057> }
triangle { <0.194471, 0.240151, 0.951057>, <0.206773, 0.229644, 0.951057>, <0.181629, 0.201720, 0.962455> }
triangle { <0.206773, 0.229644, 0.951057>, <0.194471, 0.240151, 0.951057>, <0.217819, 0.268983, 0.938191> }
triangle { <0.217819, 0.268983, 0.938191>, <0.231598, 0.257215, 0.938191>, <0.206773, 0.229644, 0.951057> }
triangle { <0.231598, 0.257215, 0.938191>, <0.217819, 0.268983, 0.938191>, <0.240830, 0.297401, 0.923880> }
triangle { <0.240830, 0.297401, 0.923880>, <0.256065, 0.284389, 0.923880>, <0.231598, 0.257215, 0.938191> }
triangle { <0.256065, 0.284389, 0.923880>, <0.240830, 0.297401, 0.923880>, <0.263471, 0.325360, 0.908143> }
triangle { <0.263471, 0.325360, 0.908143>, <0.280138, 0.311125, 0.908143>, <0.256065, 0.284389, 0.923880> }
triangle { <0.280138, 0.311125, 0.908143>, <0.263471, 0.325360, 0.908143>, <0.285705, 0.352817, 0.891007> }
triangle { <0.285705, 0.352817, 0.891007>, <0.303779, 0.337381, 0.891007>, <0.280138, 0.311125, 0.908143> }
triangle { <0.303779, 0.337381, 0.891007>, <0.285705, 0.352817, 0.891007>, <0.307499, 0.379730, 0.872496> }
triangle { <0.307499, 0.379730, 0.872496>, <0.326951, 0.363116, 0.872496>, <0.303779, 0.337381, 0.891007> }
triangle { <0.326951, 0.363116, 0.872496>, <0.307499, 0.379730, 0.872496>, <0.328819, 0.406058, 0.852640> }
triangle { <0.328819, 0.406058, 0.852640>, <0.349620, 0.388292, 0.852640>, <0.326951, 0.363116, 0.872496> }
triangle { <0.349620, 0.388292, 0.852640>, <0.328819, 0.406058, 0.852640>, <0.349632, 0.431759, 0.831470> }
triangle { <0.349632, 0.431759, 0.831470>, <0.371749, 0.412869, 0.831470>, <0.349620, 0.388292, 0.852640> }
triangle { <0.371749, 0.412869, 0.831470>, <0.349632, 0.431759, 0.831470>, <0.369905, 0.456795, 0.809017> }
triangle { <0.369905, 0.456795, 0.809017>, <0.393305, 0.436810, 0.809017>, <0.371749, 0.412869, 0.831470> }
triangle { <0.393305, 0.436810, 0.809017>, <0.369905, 0.456795, 0.809017>, <0.389608, 0.481126, 0.785317> }
triangle { <0.389608, 0.481126, 0.785317>, <0.414255, 0.460076, 0.785317>, <0.393305, 0.436810, 0.809017> }
triangle { <0.414255, 0.460076, 0.785317>, <0.389608, 0.481126, 0.785317>, <0.408711, 0.504716, 0.760406> }
triangle { <0.408711, 0.504716, 0.760406>, <0.434566, 0.482634, 0.760406>, <0.414255, 0.460076, 0.785317> }
triangle { <0.434566, 0.482634, 0.760406>, <0.408711, 0.504716, 0.760406>, <0.427183, 0.527527, 0.734323> }
triangle { <0.427183, 0.527527, 0.734323>, <0.454206, 0.504447, 0.734323>, <0.434566, 0.482634, 0.760406> }
triangle { <0.454206, 0.504447, 0.734323>, <0.427183, 0.527527, 0.734323>, <0.444997, 0.549525, 0.707107> }
triangle { <0.444997, 0.549525, 0.707107>, <0.473147, 0.525483, 0.707107>, <0.454206, 0.504447, 0.734323> }
triangle { <0.473147, 0.525483, 0.707107>, <0.444997, 0.549525, 0.707107>, <0.462124, 0.570676, 0.678801> }
triangle { <0.462124, 0.570676, 0.678801>, <0.491358, 0.545708, 0.678801>, <0.473147, 0.525483, 0.707107> }
triangle { <0.491358, 0.545708, 0.678801>, <0.462124, 0.570676, 0.678801>, <0.478539, 0.590946, 0.649448> }
triangle { <0.478539, 0.590946, 0.649448>, <0.508811, 0.565092, 0.649448>, <0.491358, 0.545708, 0.678801> }
triangle { <0.508811, 0.565092, 0.649448>, <0.478539, 0.590946, 0.649448>, <0.494216, 0.610306, 0.619094> }
triangle { <0.494216, 0.610306, 0.619094>, <0.525480, 0.583604, 0.619094>, <0.508811, 0.565092, 0.649448> }
triangle { <0.525480, 0.583604, 0.619094>, <0.494216, 0.610306, 0.619094>, <0.509131, 0.628724, 0.587785> }
triangle { <0.509131, 0.628724, 0.587785>, <0.541338, 0.601217, 0.587785>, <0.525480, 0.583604, 0.619094> }
triangle { <0.541338, 0.601217, 0.587785>, <0.509131, 0.628724, 0.587785>, <0.523261, 0.646173, 0.555570> }
triangle { <0.523261, 0.646173, 0.555570>, <0.556362, 0.617902, 0.555570>, <0.541338, 0.601217, 0.587785> }
triangle { <0.556362, 0.617902, 0.555570>, <0.523261, 0.646173, 0.555570>, <0.536584, 0.662626, 0.522499> }
triangle { <0.536584, 0.662626, 0.522499>, <0.570528, 0.633635, 0.522499>, <0.556362, 0.617902, 0.555570> }
triangle { <0.570528, 0.633635, 0.522499>, <0.536584, 0.662626, 0.522499>, <0.549080, 0.678057, 0.488621> }
triangle { <0.549080, 0.678057, 0.488621>, <0.583814, 0.648391, 0.488621>, <0.570528, 0.633635, 0.522499> }
triangle { <0.583814, 0.648391, 0.488621>, <0.549080, 0.678057, 0.488621>, <0.560729, 0.692442, 0.453990> }
triangle { <0.560729, 0.692442, 0.453990>, <0.596200, 0.662147, 0.453990>, <0.583814, 0.648391, 0.488621> }
triangle { <0.596200, 0.662147, 0.453990>, <0.560729, 0.692442, 0.453990>, <0.571513, 0.705760, 0.418660> }
triangle { <0.571513, 0.705760, 0.418660>, <0.607666, 0.674882, 0.418660>, <0.596200, 0.662147, 0.453990> }
triangle { <0.607666, 0.674882, 0.418660>, <0.571513, 0.705760, 0.418660>, <0.581416, 0.717989, 0.382683> }
triangle { <0.581416, 0.717989, 0.382683>, <0.618196, 0.686576, 0.382683>, <0.607666, 0.674882, 0.418660> }
triangle { <0.618196, 0.686576, 0.382683>, <0.581416, 0.717989, 0.382683>, <0.590423, 0.729112, 0.346117> }
triangle { <0.590423, 0.729112, 0.346117>, <0.627773, 0.697212, 0.346117>, <0.618196, 0.686576, 0.382683> }
triangle { <0.627773, 0.697212, 0.346117>, <0.590423, 0.729112, 0.346117>, <0.598519, 0.739110, 0.309017> }
triangle { <0.598519, 0.739110, 0.309017>, <0.636381, 0.706773, 0.309017>, <0.627773, 0.697212, 0.346117> }
triangle { <0.636381, 0.706773, 0.309017>, <0.598519, 0.739110, 0.309017>, <0.605693, 0.747968, 0.271440> }
triangle { <0.605693, 0.747968, 0.271440>, <0.644008, 0.715244, 0.271440>, <0.636381, 0.706773, 0.309017> }
triangle { <0.644008, 0.715244, 0.271440>, <0.605693, 0.747968, 0.271440>, <0.611932, 0.755673, 0.233445> }
triangle { <0.611932, 0.755673, 0.233445>, <0.650642, 0.722612, 0.233445>, <0.644008, 0.715244, 0.271440> }
triangle { <0.650642, 0.722612, 0.233445>, <0.611932, 0.755673, 0.233445>, <0.617228, 0.762213, 0.195090> }
triangle { <0.617228, 0.762213, 0.195090>, <0.656273, 0.728866, 0.195090>, <0.650642, 0.722612, 0.233445> }
triangle { <0.656273, 0.728866, 0.195090>, <0.617228, 0.762213, 0.195090>, <0.621572, 0.767578, 0.156434> }
triangle { <0.621572, 0.767578, 0.156434>, <0.660892, 0.733995, 0.156434>, <0.656273, 0.728866, 0.195090> }
triangle { <0.660892, 0.733995, 0.156434>, <0.621572, 0.767578, 0.156434>, <0.624958, 0.771759, 0.117537> }
triangle { <0.624958, 0.771759, 0.117537>, <0.664492, 0.737994, 0.117537>, <0.660892, 0.733995, 0.156434> }
triangle { <0.664492, 0.737994, 0.117537>, <0.624958, 0.771759, 0.117537>, <0.627380, 0.774750, 0.078459> }
triangle { <0.627380, 0.774750, 0.078459>, <0.667068, 0.740854, 0.078459>, <0.664492, 0.737994, 0.117537> }
triangle { <0.667068, 0.740854, 0.078459>, <0.627380, 0.774750, 0.078459>, <0.628835, 0.776547, 0.039260> }
triangle { <0.628835, 0.776547, 0.039260>, <0.668615, 0.742572, 0.039260>, <0.667068, 0.740854, 0.078459> }
triangle { <0.668615, 0.742572, 0.039260>, <0.628835, 0.776547, 0.039260>, <0.629320, 0.777146, -0.000000> }
triangle { <0.629320, 0.777146, -0.000000>, <0.669131, 0.743145, -0.000000>, <0.668615, 0.742572, 0.039260> }
triangle { <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.023076, 0.031762, 0.999229> }
triangle { <0.023076, 0.031762, 0.999229>, <0.024707, 0.030511, 0.999229>, <0.000000, 0.000000, 1.000000> }
triangle { <0.024707, 0.030511, 0.999229>, <0.023076, 0.031762, 0.999229>, <0.046117, 0.063475, 0.996917> }
triangle { <0.046117, 0.063475, 0.996917>, <0.049376, 0.060974, 0.996917>, <0.024707, 0.030511, 0.999229> }
triangle { <0.049376, 0.060974, 0.996917>, <0.046117, 0.063475, 0.996917>, <0.069087, 0.095090, 0.993068> }
triangle { <0.069087, 0.095090, 0.993068>, <0.073969, 0.091344, 0.993068>, <0.049376, 0.060974, 0.996917> }
triangle { <0.073969, 0.091344, 0.993068>, <0.069087, 0.095090, 0.993068>, <0.091950, 0.126558, 0.987688> }
triangle { <0.091950, 0.126558, 0.987688>, <0.098447, 0.121572, 0.987688>, <0.073969, 0.091344, 0.993068> }
triangle { <0.098447, 0.121572, 0.987688>, <0.091950, 0.126558, 0.987688>, <0.114671, 0.157831, 0.980785> }
triangle { <0.114671, 0.157831, 0.980785>, <0.122774, 0.151614, 0.980785>, <0.098447, 0.121572, 0.987688> }
triangle { <0.122774, 0.151614, 0.980785>, <0.114671, 0.157831, 0.980785>, <0.137216, 0.188861, 0.972370> }
triangle { <0.137216, 0.188861, 0.972370>, <0.146912, 0.181421, 0.972370>, <0.122774, 0.151614, 0.980785> }
triangle { <0.146912, 0.181421, 0.972370>, <0.137216, 0.188861, 0.972370>, <0.159549, 0.219600, 0.962455> }
triangle { <0.159549, 0.219600, 0.962455>, <0.170823, 0.210949, 0.962455>, <0.146912, 0.181421, 0.972370> }
triangle { <0.170823, 0.210949, 0.962455>, <0.159549, 0.219600, 0.962455>, <0.181636, 0.250000, 0.951057> }
triangle { <0.181636, 0.250000, 0.951057>, <0.194471, 0.240151, 0.951057>, <0.170823, 0.210949, 0.962455> }
triangle { <0.194471, 0.240151, 0.951057>, <0.181636, 0.250000, 0.951057>, <0.203443, 0.280015, 0.938191> }
triangle { <0.203443, 0.280015, 0.938191>, <0.217819, 0.268983, 0.938191>, <0.194471, 0.240151, 0.951057> }
triangle { <0.217819, 0.268983, 0.938191>, <0.203443, 0.280015, 0.938191>, <0.224936, 0.309597, 0.923880> }
triangle { <0.224936, 0.309597, 0.923880>, <0.240830, 0.297401, 0.923880>, <0.217819, 0.268983, 0.938191> }
triangle { <0.240830, 0.297401, 0.923880>, <0.224936, 0.309597, 0.923880>, <0.246082, 0.338703, 0.908143> }
triangle { <0.246082, 0.338703, 0.908143>, <0.263471, 0.325360, 0.908143>, <0.240830, 0.297401, 0.923880> }
triangle { <0.263471, 0.325360, 0.908143>, <0.246082, 0.338703, 0.908143>, <0.266849, 0.367286, 0.891007> }
triangle { <0.266849, 0.367286, 0.891007>, <0.285705, 0.352817, 0.891007>, <0.263471, 0.325360, 0.908143> }
triangle { <0.285705, 0.352817, 0.891007>, <0.266849, 0.367286, 0.891007>, <0.287204, 0.395303, 0.872496> }
triangle { <0.287204, 0.395303, 0.872496>, <0.307499, 0.379730, 0.872496>, <0.285705, 0.352817, 0.891007> }
triangle { <0.307499, 0.379730, 0.872496>, <0.287204, 0.395303, 0.872496>, <0.307117, 0.422710, 0.852640> }
triangle { <0.307117, 0.422710, 0.852640>, <0.328819, 0.406058, 0.852640>, <0.307499, 0.379730, 0.872496> }
triangle { <0.328819, 0.406058, 0.852640>, <0.307117, 0.422710, 0.852640>, <0.326556, 0.449466, 0.831470> }
triangle { <0.326556, 0.449466, 0.831470>, <0.349632, 0.431759, 0.831470>, <0.328819, 0.406058, 0.852640> }
triangle { <0.349632, 0.431759, 0.831470>, <0.326556, 0.449466, 0.831470>, <0.345492, 0.475528, 0.809017> }
triangle { <0.345492, 0.475528, 0.809017>, <0.369905, 0.456795, 0.809017>, <0.349632, 0.431759, 0.831470> }
triangle { <0.369905, 0.456795, 0.809017>, <0.345492, 0.475528, 0.809017>, <0.363894, 0.500858, 0.785317> }
triangle { <0.363894, 0.500858, 0.785317>, <0.389608, 0.481126, 0.785317>, <0.369905, 0.456795, 0.809017> }
triangle { <0.389608, 0.481126, 0.785317>, <0.363894, 0.500858, 0.785317>, <0.381736, 0.525415, 0.760406> }
triangle { <0.381736, 0.525415, 0.760406>, <0.408711, 0.504716, 0.760406>, <0.389608, 0.481126, 0.785317> }
triangle { <0.408711, 0.504716, 0.760406>, <0.381736, 0.525415, 0.760406>, <0.398989, 0.549161, 0.734323> }
triangle { <0.398989, 0.549161, 0.734323>, <0.427183, 0.527527, 0.734323>, <0.408711, 0.504716, 0.760406> }
triangle { <0.427183, 0.527527, 0.734323>, <0.398989, 0.549161, 0.734323>, <0.415627, 0.572061, 0.707107> }
triangle { <0.415627, 0.572061, 0.707107>, <0.444997, 0.549525, 0.707107>, <0.427183, 0.527527, 0.734323> }
triangle { <0.444997, 0.549525, 0.707107>, <0.415627, 0.572061, 0.707107>, <0.431624, 0.594079, 0.678801> }
triangle { <0.431624, 0.594079, 0.678801>, <0.462124, 0.570676, 0.678801>, <0.444997, 0.549525, 0.707107> }
triangle { <0.462124, 0.570676, 0.678801>, <0.431624, 0.594079, 0.678801>, <0.446955, 0.615181, 0.649448> }
triangle { <0.446955, 0.615181, 0.649448>, <0.478539, 0.590946, 0.649448>, <0.462124, 0.570676, 0.678801> }
triangle { <0.478539, 0.590946, 0.649448>, <0.446955, 0.615181, 0.649448>, <0.461598, 0.635335, 0.619094> }
triangle { <0.461598, 0.635335, 0.619094>, <0.494216, 0.610306, 0.619094>, <0.478539, 0.590946, 0.649448> }
triangle { <0.494216, 0.610306, 0.619094>, <0.461598, 0.635335, 0.619094>, <0.475528, 0.654508, 0.587785> }
triangle { <0.475528, 0.654508, 0.587785>, <0.509131, 0.628724, 0.587785>, <0.494216, 0.610306, 0.619094> }
triangle { <0.509131, 0.628724, 0.587785>, <0.475528, 0.654508, 0.587785>, <0.488726, 0.672673, 0.555570> }
triangle { <0.488726, 0.672673, 0.555570>, <0.523261, 0.646173, 0.555570>, <0.509131, 0.628724, 0.587785> }
triangle { <0.523261, 0.646173, 0.555570>, <0.488726, 0.672673, 0.555570>, <0.501169, 0.689800, 0.522499> }
triangle { <0.501169, 0.689800, 0.522499>, <0.536584, 0.662626, 0.522499>, <0.523261, 0.646173, 0.555570> }
triangle { <0.536584, 0.662626, 0.522499>, <0.501169, 0.689800, 0.522499>, <0.512840, 0.705864, 0.488621> }
triangle { <0.512840, 0.705864, 0.488621>, <0.549080, 0.678057, 0.488621>, <0.536584, 0.662626, 0.522499> }
triangle { <0.549080, 0.678057, 0.488621>, <0.512840, 0.705864, 0.488621>, <0.523720, 0.720839, 0.453990> }
triangle { <0.523720, 0.720839, 0.453990>, <0.560729, 0.692442, 0.453990>, <0.549080, 0.678057, 0.488621> }
triangle { <0.560729, 0.692442, 0.453990>, <0.523720, 0.720839, 0.453990>, <0.533793, 0.734703, 0.418660> }
triangle { <0.533793, 0.734703, 0.418660>, <0.571513, 0.705760, 0.418660>, <0.560729, 0.692442, 0.453990> }
triangle { <0.571513, 0.705760, 0.418660>, <0.533793, 0.734703, 0.418660>, <0.543043, 0.747434, 0.382683> }
triangle { <0.543043, 0.747434, 0.382683>, <0.581416, 0.717989, 0.382683>, <0.571513, 0.705760, 0.418660> }
triangle { <0.581416, 0.717989, 0.382683>, <0.543043, 0.747434, 0.382683>, <0.551455, 0.759013, 0.346117> }
triangle { <0.551455, 0.759013, 0.346117>, <0.590423, 0.729112, 0.346117>, <0.581416, 0.717989, 0.382683> }
triangle { <0.590423, 0.729112, 0.346117>, <0.551455, 0.759013, 0.346117>, <0.559017, 0.769421, 0.309017> }
triangle { <0.559017, 0.769421, 0.309017>, <0.598519, 0.739110, 0.309017>, <0.590423, 0.729112, 0.346117> }
triangle { <0.598519, 0.739110, 0.309017>, <0.559017, 0.769421, 0.309017>, <0.565717, 0.778643, 0.271440> }
triangle { <0.565717, 0.778643, 0.271440>, <0.605693, 0.747968, 0.271440>, <0.598519, 0.739110, 0.309017> }
triangle { <0.605693, 0.747968, 0.271440>, <0.565717, 0.778643, 0.271440>, <0.571545, 0.786664, 0.233445> }
triangle { <0.571545, 0.786664, 0.233445>, <0.611932, 0.755673, 0.233445>, <0.605693, 0.747968, 0.271440> }
triangle { <0.611932, 0.755673, 0.233445>, <0.571545, 0.786664, 0.233445>, <0.576491, 0.793472, 0.195090> }
triangle { <0.576491, 0.793472, 0.195090>, <0.617228, 0.762213, 0.195090>, <0.611932, 0.755673, 0.233445> }
triangle { <0.617228, 0.762213, 0.195090>, <0.576491, 0.793472, 0.195090>, <0.580549, 0.799057, 0.156434> }
triangle { <0.580549, 0.799057, 0.156434>, <0.621572, 0.767578, 0.156434>, <0.617228, 0.762213, 0.195090> }
triangle { <0.621572, 0.767578, 0.156434>, <0.580549, 0.799057, 0.156434>, <0.583711, 0.803409, 0.117537> }
triangle { <0.583711, 0.803409, 0.117537>, <0.624958, 0.771759, 0.117537>, <0.621572, 0.767578, 0.156434> }
triangle { <0.624958, 0.771759, 0.117537>, <0.583711, 0.803409, 0.117537>, <0.585973, 0.806523, 0.078459> }
triangle { <0.585973, 0.806523, 0.078459>, <0.627380, 0.774750, 0.078459>, <0.624958, 0.771759, 0.117537> }
triangle { <0.627380, 0.774750, 0.078459>, <0.585973, 0.806523, 0.078459>, <0.587332, 0.808393, 0.039260> }
triangle { <0.587332, 0.808393, 0.039260>, <0.628835, 0.776547, 0.039260>, <0.627380, 0.774750, 0.078459> }
triangle { <0.628835, 0.776547, 0.039260>, <0.587332, 0.808393, 0.039260>, <0.587785, 0.809017, -0.000000> }
triangle { <0.587785, 0.809017, -0.000000>, <0.629320, 0.777146, -0.000000>, <0.628835, 0.776547, 0.039260> }
triangle { <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.021382, 0.032926, 0.999229> }
triangle { <0.021382, 0.032926, 0.999229>, <0.023076, 0.031762, 0.999229>, <0.000000, 0.000000, 1.000000> }
triangle { <0.023076, 0.031762, 0.999229>, <0.021382, 0.032926, 0.999229>, <0.042732, 0.065801, 0.996917> }
triangle { <0.042732, 0.065801, 0.996917>, <0.046117, 0.063475, 0.996917>, <0.023076, 0.031762, 0.999229> }
triangle { <0.046117, 0.063475, 0.996917>, <0.042732, 0.065801, 0.996917>, <0.064015, 0.098575, 0.993068> }
triangle { <0.064015, 0.098575, 0.993068>, <0.069087, 0.095090, 0.993068>, <0.046117, 0.063475, 0.996917> }
triangle { <0.069087, 0.095090, 0.993068>, <0.064015, 0.098575, 0.993068>, <0.085200, 0.131197, 0.987688> }
triangle { <0.085200, 0.131197, 0.987688>, <0.091950, 0.126558, 0.987688>, <0.069087, 0.095090, 0.993068> }
triangle { <0.091950, 0.126558, 0.987688>, <0.085200, 0.131197, 0.987688>, <0.106254, 0.163617, 0.980785> }
triangle { <0.106254, 0.163617, 0.980785>, <0.114671, 0.157831, 0.980785>, <0.091950, 0.126558, 0.987688> }
triangle { <0.114671, 0.157831, 0.980785>, <0.106254, 0.163617, 0.980785>, <0.127143, 0.195784, 0.972370> }
triangle { <0.127143, 0.195784, 0.972370>, <0.137216, 0.188861, 0.972370>, <0.114671, 0.157831, 0.980785> }
triangle { <0.137216, 0.188861, 0.972370>, <0.127143, 0.195784, 0.972370>, <0.147837, 0.227649, 0.962455> }
triangle { <0.147837, 0.227649, 0.962455>, <0.159549, 0.219600, 0.962455>, <0.137216, 0.188861, 0.972370> }
triangle { <0.159549, 0.219600, 0.962455>, <0.147837, 0.227649, 0.962455>, <0.168303, 0.259163, 0.951057> }
triangle { <0.168303, 0.259163, 0.951057>, <0.181636, 0.250000, 0.951057>, <0.159549, 0.219600, 0.962455> }
triangle { <0.181636, 0.250000, 0.951057>, <0.168303, 0.259163, 0.951057>, <0.188509, 0.290278, 0.938191> }
triangle { <0.188509, 0.290278, 0.938191>, <0.203443, 0.280015, 0.938191>, <0.181636, 0.250000, 0.951057> }
triangle { <0.203443, 0.280015, 0.938191>, <0.188509, 0.290278, 0.938191>, <0.208424, 0.320945, 0.923880> }
triangle { <0.208424, 0.320945, 0.923880>, <0.224936, 0.309597, 0.923880>, <0.203443, 0.280015, 0.938191> }
triangle { <0.224936, 0.309597, 0.923880>, <0.208424, 0.320945, 0.923880>, <0.228018, 0.351118, 0.908143> }
triangle { <0.228018, 0.351118, 0.908143>, <0.246082, 0.338703, 0.908143>, <0.224936, 0.309597, 0.923880> }
triangle { <0.246082, 0.338703, 0.908143>, <0.228018, 0.351118, 0.908143>, <0.247261, 0.380748, 0.891007> }
triangle { <0.247261, 0.380748, 0.891007>, <0.266849, 0.367286, 0.891007>, <0.246082, 0.338703, 0.908143> }
triangle { <0.266849, 0.367286, 0.891007>, <0.247261, 0.380748, 0.891007>, <0.266122, 0.409792, 0.872496> }
triangle { <0.266122, 0.409792, 0.872496>, <0.287204, 0.395303, 0.872496>, <0.266849, 0.367286, 0.891007> }
triangle { <0.287204, 0.395303, 0.872496>, <0.266122, 0.409792, 0.872496>, <0.284573, 0.438204, 0.852640> }
triangle { <0.284573, 0.438204, 0.852640>, <0.307117, 0.422710, 0.852640>, <0.287204, 0.395303, 0.872496> }
triangle { <0.307117, 0.422710, 0.852640>, <0.284573, 0.438204, 0.852640>, <0.302585, 0.465940, 0.831470> }
triangle { <0.302585, 0.465940, 0.831470>, <0.326556, 0.449466, 0.831470>, <0.307117, 0.422710, 0.852640> }
triangle { <0.326556, 0.449466, 0.831470>, <0.302585, 0.465940, 0.831470>, <0.320131, 0.492958, 0.809017> }
triangle { <0.320131, 0.492958, 0.809017>, <0.345492, 0.475528, 0.809017>, <0.326556, 0.449466, 0.831470> }
triangle { <0.345492, 0.475528, 0.809017>, <0.320131, 0.492958, 0.809017>, <0.337183, 0.519216, 0.785317> }
triangle { <0.337183, 0.519216, 0.785317>, <0.363894, 0.500858, 0.785317>, <0.345492, 0.475528, 0.809017> }
triangle { <0.363894, 0.500858, 0.785317>, <0.337183, 0.519216, 0.785317>, <0.353715, 0.544673, 0.760406> }
triangle { <0.353715, 0.544673, 0.760406>, <0.381736, 0.525415, 0.760406>, <0.363894, 0.500858, 0.785317> }
triangle { <0.381736, 0.525415, 0.760406>, <0.353715, 0.544673, 0.760406>, <0.369701, 0.569290, 0.734323> }
triangle { <0.369701, 0.569290, 0.734323>, <0.398989, 0.549161, 0.734323>, <0.381736, 0.525415, 0.760406> }
triangle { <0.398989, 0.549161, 0.734323>, <0.369701, 0.569290, 0.734323>, <0.385118, 0.593030, 0.707107> }
triangle { <0.385118, 0.593030, 0.707107>, <0.415627, 0.572061, 0.707107>, <0.398989, 0.549161, 0.734323> }
triangle { <0.415627, 0.572061, 0.707107>, <0.385118, 0.593030, 0.707107>, <0.399941, 0.615855, 0.678801> }
triangle { <0.399941, 0.615855, 0.678801>, <0.431624, 0.594079, 0.678801>, <0.415627, 0.572061, 0.707107> }
triangle { <0.431624, 0.594079, 0.678801>, <0.399941, 0.615855, 0.678801>, <0.414147, 0.637730, 0.649448> }
triangle { <0.414147, 0.637730, 0.649448>, <0.446955, 0.615181, 0.649448>, <0.431624, 0.594079, 0.678801> }
triangle { <0.446955, 0.615181, 0.649448>, <0.414147, 0.637730, 0.649448>, <0.427714, 0.658622, 0.619094> }
triangle { <0.427714, 0.658622, 0.619094>, <0.461598, 0.635335, 0.619094>, <0.446955, 0.615181, 0.649448> }
triangle { <0.461598, 0.635335, 0.619094>, <0.427714, 0.658622, 0.619094>, <0.440622, 0.678499, 0.587785> }
triangle { <0.440622, 0.678499, 0.587785>, <0.475528, 0.654508, 0.587785>, <0.461598, 0.635335, 0.619094> }
triangle { <0.475528, 0.654508, 0.587785>, <0.440622, 0.678499, 0.587785>, <0.452851, 0.697329, 0.555570> }
triangle { <0.452851, 0.697329, 0.555570>, <0.488726, 0.672673, 0.555570>, <0.475528, 0.654508, 0.587785> }
triangle { <0.488726, 0.672673, 0.555570>, <0.452851, 0.697329, 0.555570>, <0.464381, 0.715084, 0.522499> }
triangle { <0.464381, 0.715084, 0.522499>, <0.501169, 0.689800, 0.522499>, <0.488726, 0.672673, 0.555570> }
triangle { <0.501169, 0.689800, 0.522499>, <0.464381, 0.715084, 0.522499>, <0.475195, 0.731737, 0.488621> }
triangle { <0.475195, 0.731737, 0.488621>, <0.512840, 0.705864, 0.488621>, <0.501169, 0.689800, 0.522499> }
triangle { <0.512840, 0.705864, 0.488621>, <0.475195, 0.731737, 0.488621>, <0.485277, 0.747261, 0.453990> }
triangle { <0.485277, 0.747261, 0.453990>, <0.523720, 0.720839, 0.453990>, <0.512840, 0.705864, 0.488621> }
triangle { <0.523720, 0.720839, 0.453990>, <0.485277, 0.747261, 0.453990>, <0.494610, 0.761633, 0.418660> }
triangle { <0.494610, 0.761633, 0.418660>, <0.533793, 0.734703, 0.418660>, <0.523720, 0.720839, 0.453990> }
triangle { <0.533793, 0.734703, 0.418660>, <0.494610, 0.761633, 0.418660>, <0.503181, 0.774831, 0.382683> }
triangle { <0.503181, 0.774831, 0.382683>, <0.543043, 0.747434, 0.382683>, <0.533793, 0.734703, 0.418660> }
triangle { <0.543043, 0.747434, 0.382683>, <0.503181, 0.774831, 0.382683>, <0.510976, 0.786833, 0.346117> }
triangle { <0.510976, 0.786833, 0.346117>, <0.551455, 0.759013, 0.346117>, <0.543043, 0.747434, 0.382683> }
triangle { <0.551455, 0.759013, 0.346117>, <0.510976, 0.786833, 0.346117>, <0.517983, 0.797623, 0.309017> }
triangle { <0.517983, 0.797623, 0.309017>, <0.559017, 0.769421, 0.309017>, <0.551455, 0.759013, 0.346117> }
triangle { <0.559017, 0.769421, 0.309017>, <0.517983, 0.797623, 0.309017>, <0.524191, 0.807183, 0.271440> }
triangle { <0.524191, 0.807183, 0.271440>, <0.565717, 0.778643, 0.271440>, <0.559017, 0.769421, 0.309017> }
triangle { <0.565717, 0.778643, 0.271440>, <0.524191, 0.807183, 0.271440>, <0.529591, 0.815498, 0.233445> }
triangle { <0.529591, 0.815498, 0.233445>, <0.571545, 0.786664, 0.233445>, <0.565717, 0.778643, 0.271440> }
triangle { <0.571545, 0.786664, 0.233445>, <0.529591, 0.815498, 0.233445>, <0.534174, 0.822556, 0.195090> }
triangle { <0.534174, 0.822556, 0.195090>, <0.576491, 0.793472, 0.195090>, <0.571545, 0.786664, 0.233445> }
triangle { <0.576491, 0.793472, 0.195090>, <0.534174, 0.822556, 0.195090>, <0.537934, 0.828345, 0.156434> }
triangle { <0.537934, 0.828345, 0.156434>, <0.580549, 0.799057, 0.156434>, <0.576491, 0.793472, 0.195090> }
triangle { <0.580549, 0.799057, 0.156434>, <0.537934, 0.828345, 0.156434>, <0.540864, 0.832857, 0.117537> }
triangle { <0.540864, 0.832857, 0.117537>, <0.583711, 0.803409, 0.117537>, <0.580549, 0.799057, 0.156434> }
triangle { <0.583711, 0.803409, 0.117537>, <0.540864, 0.832857, 0.117537>, <0.542960, 0.836085, 0.078459> }
triangle { <0.542960, 0.836085, 0.078459>, <0.585973, 0.806523, 0.078459>, <0.583711, 0.803409, 0.117537> }
triangle { <0.585973, 0.806523, 0.078459>, <0.542960, 0.836085, 0.078459>, <0.544219, 0.838024, 0.039260> }
triangle { <0.544219, 0.838024, 0.039260>, <0.587332, 0.808393, 0.039260>, <0.585973, 0.806523, 0.078459> }
triangle { <0.587332, 0.808393, 0.039260>, <0.544219, 0.838024, 0.039260>, <0.544639, 0.838671, -0.000000> }
triangle { <0.544639, 0.838671, -0.000000>, <0.587785, 0.809017, -0.000000>, <0.587332, 0.808393, 0.039260> }
triangle { <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.019630, 0.034000, 0.999229> }
triangle { <0.019630, 0.034000, 0.999229>, <0.021382, 0.032926, 0.999229>, <0.000000, 0.000000, 1.000000> }
triangle { <0.021382, 0.032926, 0.999229>, <0.019630, 0.034000, 0.999229>, <0.039230, 0.067948, 0.996917> }
triangle { <0.039230, 0.067948, 0.996917>, <0.042732, 0.065801, 0.996917>, <0.021382, 0.032926, 0.999229> }
triangle { <0.042732, 0.065801, 0.996917>, <0.039230, 0.067948, 0.996917>, <0.058769, 0.101790, 0.993068> }
triangle { <0.058769, 0.101790, 0.993068>, <0.064015, 0.098575, 0.993068>, <0.042732, 0.065801, 0.996917> }
triangle { <0.064015, 0.098575, 0.993068>, <0.058769, 0.101790, 0.993068>, <0.078217, 0.135476, 0.987688> }
triangle { <0.078217, 0.135476, 0.987688>, <0.085200, 0.131197, 0.987688>, <0.064015, 0.098575, 0.993068> }
triangle { <0.085200, 0.131197, 0.987688>, <0.078217, 0.135476, 0.987688>, <0.097545, 0.168953, 0.980785> }
triangle { <0.097545, 0.168953, 0.980785>, <0.106254, 0.163617, 0.980785>, <0.085200, 0.131197, 0.987688> }
triangle { <0.106254, 0.163617, 0.980785>, <0.097545, 0.168953, 0.980785>, <0.116723, 0.202170, 0.972370> }
triangle { <0.116723, 0.202170, 0.972370>, <0.127143, 0.195784, 0.972370>, <0.106254, 0.163617, 0.980785> }
triangle { <0.127143, 0.195784, 0.972370>, <0.116723, 0.202170, 0.972370>, <0.135720, 0.235074, 0.962455> }
triangle { <0.135720, 0.235074, 0.962455>, <0.147837, 0.227649, 0.962455>, <0.127143, 0.195784, 0.972370> }
triangle { <0.147837, 0.227649, 0.962455>, <0.135720, 0.235074, 0.962455>, <0.154508, 0.267617, 0.951057> }
triangle { <0.154508, 0.267617, 0.951057>, <0.168303, 0.259163, 0.951057>, <0.147837, 0.227649, 0.962455> }
triangle { <0.168303, 0.259163, 0.951057>, <0.154508, 0.267617, 0.951057>, <0.173059, 0.299746, 0.938191> }
triangle { <0.173059, 0.299746, 0.938191>, <0.188509, 0.290278, 0.938191>, <0.168303, 0.259163, 0.951057> }
triangle { <0.188509, 0.290278, 0.938191>, <0.173059, 0.299746, 0.938191>, <0.191342, 0.331414, 0.923880> }
triangle { <0.191342, 0.331414, 0.923880>, <0.208424, 0.320945, 0.923880>, <0.188509, 0.290278, 0.938191> }
triangle { <0.208424, 0.320945, 0.923880>, <0.191342, 0.331414, 0.923880>, <0.209330, 0.362570, 0.908143> }
triangle { <0.209330, 0.362570, 0.908143>, <0.228018, 0.351118, 0.908143>, <0.208424, 0.320945, 0.923880> }
triangle { <0.228018, 0.351118, 0.908143>, <0.209330, 0.362570, 0.908143>, <0.226995, 0.393167, 0.891007> }
triangle { <0.226995, 0.393167, 0.891007>, <0.247261, 0.380748, 0.891007>, <0.228018, 0.351118, 0.908143> }
triangle { <0.247261, 0.380748, 0.891007>, <0.226995, 0.393167, 0.891007>, <0.244311, 0.423158, 0.872496> }
triangle { <0.244311, 0.423158, 0.872496>, <0.266122, 0.409792, 0.872496>, <0.247261, 0.380748, 0.891007> }
triangle { <0.266122, 0.409792, 0.872496>, <0.244311, 0.423158, 0.872496>, <0.261249, 0.452497, 0.852640> }
triangle { <0.261249, 0.452497, 0.852640>, <0.284573, 0.438204, 0.852640>, <0.266122, 0.409792, 0.872496> }
triangle { <0.284573, 0.438204, 0.852640>, <0.261249, 0.452497, 0.852640>, <0.277785, 0.481138, 0.831470> }
triangle { <0.277785, 0.481138, 0.831470>, <0.302585, 0.465940, 0.831470>, <0.284573, 0.438204, 0.852640> }
triangle { <0.302585, 0.465940, 0.831470>, <0.277785, 0.481138, 0.831470>, <0.293893, 0.509037, 0.809017> }
triangle { <0.293893, 0.509037, 0.809017>, <0.320131, 0.492958, 0.809017>, <0.302585, 0.465940, 0.831470> }
triangle { <0.320131, 0.492958, 0.809017>, <0.293893, 0.509037, 0.809017>, <0.309547, 0.536151, 0.785317> }
triangle { <0.309547, 0.536151, 0.785317>, <0.337183, 0.519216, 0.785317>, <0.320131, 0.492958, 0.809017> }
triangle { <0.337183, 0.519216, 0.785317>, <0.309547, 0.536151, 0.785317>, <0.324724, 0.562439, 0.760406> }
triangle { <0.324724, 0.562439, 0.760406>, <0.353715, 0.544673, 0.760406>, <0.337183, 0.519216, 0.785317> }
triangle { <0.353715, 0.544673, 0.760406>, <0.324724, 0.562439, 0.760406>, <0.339400, 0.587859, 0.734323> }
triangle { <0.339400, 0.587859, 0.734323>, <0.369701, 0.569290, 0.734323>, <0.353715, 0.544673, 0.760406> }
triangle { <0.369701, 0.569290, 0.734323>, <0.339400, 0.587859, 0.734323>, <0.353553, 0.612372, 0.707107> }
triangle { <0.353553, 0.612372, 0.707107>, <0.385118, 0.593030, 0.707107>, <0.369701, 0.569290, 0.734323> }
triangle { <0.385118, 0.593030, 0.707107>, <0.353553, 0.612372, 0.707107>, <0.367161, 0.635942, 0.678801> }
triangle { <0.367161, 0.635942, 0.678801>, <0.399941, 0.615855, 0.678801>, <0.385118, 0.593030, 0.707107> }
triangle { <0.399941, 0.615855, 0.678801>, <0.367161, 0.635942, 0.678801>, <0.380203, 0.658531, 0.649448> }
triangle { <0.380203, 0.658531, 0.649448>, <0.414147, 0.637730, 0.649448>, <0.399941, 0.615855, 0.678801> }
triangle { <0.414147, 0.637730, 0.649448>, <0.380203, 0.658531, 0.649448>, <0.392658, 0.680104, 0.619094> }
triangle { <0.392658, 0.680104, 0.619094>, <0.427714, 0.658622, 0.619094>, <0.414147, 0.637730, 0.649448> }
triangle { <0.427714, 0.658622, 0.619094>, <0.392658, 0.680104, 0.619094>, <0.404508, 0.700629, 0.587785> }
triangle { <0.404508, 0.700629, 0.587785>, <0.440622, 0.678499, 0.587785>, <0.427714, 0.658622, 0.619094> }
triangle { <0.440622, 0.678499, 0.587785>, <0.404508, 0.700629, 0.587785>, <0.415735, 0.720074, 0.555570> }
triangle { <0.415735, 0.720074, 0.555570>, <0.452851, 0.697329, 0.555570>, <0.440622, 0.678499, 0.587785> }
triangle { <0.452851, 0.697329, 0.555570>, <0.415735, 0.720074, 0.555570>, <0.426320, 0.738408, 0.522499> }
triangle { <0.426320, 0.738408, 0.522499>, <0.464381, 0.715084, 0.522499>, <0.452851, 0.697329, 0.555570> }
triangle { <0.464381, 0.715084, 0.522499>, <0.426320, 0.738408, 0.522499>, <0.436248, 0.755604, 0.488621> }
triangle { <0.436248, 0.755604, 0.488621>, <0.475195, 0.731737, 0.488621>, <0.464381, 0.715084, 0.522499> }
triangle { <0.475195, 0.731737, 0.488621>, <0.436248, 0.755604, 0.488621>, <0.445503, 0.771634, 0.453990> }
triangle { <0.445503, 0.771634, 0.453990>, <0.485277, 0.747261, 0.453990>, <0.475195, 0.731737, 0.488621> }
triangle { <0.485277, 0.747261, 0.453990>, <0.445503, 0.771634, 0.453990>, <0.454072, 0.786475, 0.418660> }
triangle { <0.454072, 0.786475, 0.418660>, <0.494610, 0.761633, 0.418660>, <0.485277, 0.747261, 0.453990> }
triangle { <0.494610, 0.761633, 0.418660>, <0.454072, 0.786475, 0.418660>, <0.461940, 0.800103, 0.382683> }
triangle { <0.461940, 0.800103, 0.382683>, <0.503181, 0.774831, 0.382683>, <0.494610, 0.761633, 0.418660> }
triangle { <0.503181, 0.774831, 0.382683>, <0.461940, 0.800103, 0.382683>, <0.469096, 0.812498, 0.346117> }
triangle { <0.469096, 0.812498, 0.346117>, <0.510976, 0.786833, 0.346117>, <0.503181, 0.774831, 0.382683> }
triangle { <0.510976, 0.786833, 0.346117>, <0.469096, 0.812498, 0.346117>, <0.475528, 0.823639, 0.309017> }
triangle { <0.475528, 0.823639, 0.309017>, <0.517983, 0.797623, 0.309017>, <0.510976, 0.786833, 0.346117> }
triangle { <0.517983, 0.797623, 0.309017>, <0.475528, 0.823639, 0.309017>, <0.481228, 0.833511, 0.271440> }
triangle { <0.481228, 0.833511, 0.271440>, <0.524191, 0.807183, 0.271440>, <0.517983, 0.797623, 0.309017> }
triangle { <0.524191, 0.807183, 0.271440>, <0.481228, 0.833511, 0.271440>, <0.486185, 0.842097, 0.233445> }
triangle { <0.486185, 0.842097, 0.233445>, <0.529591, 0.815498, 0.233445>, <0.524191, 0.807183, 0.271440> }
triangle { <0.529591, 0.815498, 0.233445>, <0.486185, 0.842097, 0.233445>, <0.490393, 0.849385, 0.195090> }
triangle { <0.490393, 0.849385, 0.195090>, <0.534174, 0.822556, 0.195090>, <0.529591, 0.815498, 0.233445> }
triangle { <0.534174, 0.822556, 0.195090>, <0.490393, 0.849385, 0.195090>, <0.493844, 0.855363, 0.156434> }
triangle { <0.493844, 0.855363, 0.156434>, <0.537934, 0.828345, 0.156434>, <0.534174, 0.822556, 0.195090> }
triangle { <0.537934, 0.828345, 0.156434>, <0.493844, 0.855363, 0.156434>, <0.496534, 0.860023, 0.117537> }
triangle { <0.496534, 0.860023, 0.117537>, <0.540864, 0.832857, 0.117537>, <0.537934, 0.828345, 0.156434> }
triangle { <0.540864, 0.832857, 0.117537>, <0.496534, 0.860023, 0.117537>, <0.498459, 0.863356, 0.078459> }
triangle { <0.498459, 0.863356, 0.078459>, <0.542960, 0.836085, 0.078459>, <0.540864, 0.832857, 0.117537> }
triangle { <0.542960, 0.836085, 0.078459>, <0.498459, 0.863356, 0.078459>, <0.499615, 0.865358, 0.039260> }
triangle { <0.499615, 0.865358, 0.039260>, <0.544219, 0.838024, 0.039260>, <0.542960, 0.836085, 0.078459> }
triangle { <0.544219, 0.838024, 0.039260>, <0.499615, 0.865358, 0.039260>, <0.500000, 0.866025, -0.000000> }
triangle { <0.500000, 0.866025, -0.000000>, <0.544639, 0.838671, -0.000000>, <0.544219, 0.838024, 0.039260> }
triangle { <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.017824, 0.034981, 0.999229> }
triangle { <0.017824, 0.034981, 0.999229>, <0.019630, 0.034000, 0.999229>, <0.000000, 0.000000, 1.000000> }
triangle { <0.019630, 0.034000, 0.999229>, <0.017824, 0.034981, 0.999229>, <0.035620, 0.069908, 0.996917> }
triangle { <0.035620, 0.069908, 0.996917>, <0.039230, 0.067948, 0.996917>, <0.019630, 0.034000, 0.999229> }
triangle { <0.039230, 0.067948, 0.996917>, <0.035620, 0.069908, 0.996917>, <0.053361, 0.104727, 0.993068> }
triangle { <0.053361, 0.104727, 0.993068>, <0.058769, 0.101790, 0.993068>, <0.039230, 0.067948, 0.996917> }
triangle { <0.058769, 0.101790, 0.993068>, <0.053361, 0.104727, 0.993068>, <0.071020, 0.139384, 0.987688> }
triangle { <0.071020, 0.139384, 0.987688>, <0.078217, 0.135476, 0.987688>, <0.058769, 0.101790, 0.993068> }
triangle { <0.078217, 0.135476, 0.987688>, <0.071020, 0.139384, 0.987688>, <0.088569, 0.173827, 0.980785> }
triangle { <0.088569, 0.173827, 0.980785>, <0.097545, 0.168953, 0.980785>, <0.078217, 0.135476, 0.987688> }
triangle { <0.097545, 0.168953, 0.980785>, <0.088569, 0.173827, 0.980785>, <0.105982, 0.208001, 0.972370> }
triangle { <0.105982, 0.208001, 0.972370>, <0.116723, 0.202170, 0.972370>, <0.097545, 0.168953, 0.980785> }
triangle { <0.116723, 0.202170, 0.972370>, <0.105982, 0.208001, 0.972370>, <0.123231, 0.241855, 0.962455> }
triangle { <0.123231, 0.241855, 0.962455>, <0.135720, 0.235074, 0.962455>, <0.116723, 0.202170, 0.972370> }
triangle { <0.135720, 0.235074, 0.962455>, <0.123231, 0.241855, 0.962455>, <0.140291, 0.275336, 0.951057> }
triangle { <0.140291, 0.275336, 0.951057>, <0.154508, 0.267617, 0.951057>, <0.135720, 0.235074, 0.962455> }
triangle { <0.154508, 0.267617, 0.951057>, <0.140291, 0.275336, 0.951057>, <0.157134, 0.308393, 0.938191> }
triangle { <0.157134, 0.308393, 0.938191>, <0.173059, 0.299746, 0.938191>, <0.154508, 0.267617, 0.951057> }
triangle { <0.173059, 0.299746, 0.938191>, <0.157134, 0.308393, 0.938191>, <0.173735, 0.340973, 0.923880> }
triangle { <0.173735, 0.340973, 0.923880>, <0.191342, 0.331414, 0.923880>, <0.173059, 0.299746, 0.938191> }
triangle { <0.191342, 0.331414, 0.923880>, <0.173735, 0.340973, 0.923880>, <0.190068, 0.373029, 0.908143> }
triangle { <0.190068, 0.373029, 0.908143>, <0.209330, 0.362570, 0.908143>, <0.191342, 0.331414, 0.923880> }
triangle { <0.209330, 0.362570, 0.908143>, <0.190068, 0.373029, 0.908143>, <0.206107, 0.404508, 0.891007> }
triangle { <0.206107, 0.404508, 0.891007>, <0.226995, 0.393167, 0.891007>, <0.209330, 0.362570, 0.908143> }
triangle { <0.226995, 0.393167, 0.891007>, <0.206107, 0.404508, 0.891007>, <0.221829, 0.435365, 0.872496> }
triangle { <0.221829, 0.435365, 0.872496>, <0.244311, 0.423158, 0.872496>, <0.226995, 0.393167, 0.891007> }
triangle { <0.244311, 0.423158, 0.872496>, <0.221829, 0.435365, 0.872496>, <0.237209, 0.465550, 0.852640> }
triangle { <0.237209, 0.465550, 0.852640>, <0.261249, 0.452497, 0.852640>, <0.244311, 0.423158, 0.872496> }
triangle { <0.261249, 0.452497, 0.852640>, <0.237209, 0.465550, 0.852640>, <0.252224, 0.495017, 0.831470> }
triangle { <0.252224, 0.495017, 0.831470>, <0.277785, 0.481138, 0.831470>, <0.261249, 0.452497, 0.852640> }
triangle { <0.277785, 0.481138, 0.831470>, <0.252224, 0.495017, 0.831470>, <0.266849, 0.523720, 0.809017> }
triangle { <0.266849, 0.523720, 0.809017>, <0.293893, 0.509037, 0.809017>, <0.277785, 0.481138, 0.831470> }
triangle { <0.293893, 0.509037, 0.809017>, <0.266849, 0.523720, 0.809017>, <0.281063, 0.551617, 0.785317> }
triangle { <0.281063, 0.551617, 0.785317>, <0.309547, 0.536151, 0.785317>, <0.293893, 0.509037, 0.809017> }
triangle { <0.309547, 0.536151, 0.785317>, <0.281063, 0.551617, 0.785317>, <0.294843, 0.578662, 0.760406> }
triangle { <0.294843, 0.578662, 0.760406>, <0.324724, 0.562439, 0.760406>, <0.309547, 0.536151, 0.785317> }
triangle { <0.324724, 0.562439, 0.760406>, <0.294843, 0.578662, 0.760406>, <0.308169, 0.604816, 0.734323> }
triangle { <0.308169, 0.604816, 0.734323>, <0.339400, 0.587859, 0.734323>, <0.324724, 0.562439, 0.760406> }
triangle { <0.339400, 0.587859, 0.734323>, <0.308169, 0.604816, 0.734323>, <0.321020, 0.630037, 0.707107> }
triangle { <0.321020, 0.630037, 0.707107>, <0.353553, 0.612372, 0.707107>, <0.339400, 0.587859, 0.734323> }
triangle { <0.353553, 0.612372, 0.707107>, <0.321020, 0.630037, 0.707107>, <0.333375, 0.654286, 0.678801> }
triangle { <0.333375, 0.654286, 0.678801>, <0.367161, 0.635942, 0.678801>, <0.353553, 0.612372, 0.707107> }
triangle { <0.367161, 0.635942, 0.678801>, <0.333375, 0.654286, 0.678801>, <0.345217, 0.677527, 0.649448> }
triangle { <0.345217, 0.677527, 0.649448>, <0.380203, 0.658531, 0.649448>, <0.367161, 0.635942, 0.678801> }
triangle { <0.380203, 0.658531, 0.649448>, <0.345217, 0.677527, 0.649448>, <0.356526, 0.699723, 0.619094> }
triangle { <0.356526, 0.699723, 0.619094>, <0.392658, 0.680104, 0.619094>, <0.380203, 0.658531, 0.649448> }
triangle { <0.392658, 0.680104, 0.619094>, <0.356526, 0.699723, 0.619094>, <0.367286, 0.720839, 0.587785> }
triangle { <0.367286, 0.720839, 0.587785>, <0.404508, 0.700629, 0.587785>, <0.392658, 0.680104, 0.619094> }
triangle { <0.404508, 0.700629, 0.587785>, <0.367286, 0.720839, 0.587785>, <0.377479, 0.740845, 0.555570> }
triangle { <0.377479, 0.740845, 0.555570>, <0.415735, 0.720074, 0.555570>, <0.404508, 0.700629, 0.587785> }
triangle { <0.415735, 0.720074, 0.555570>, <0.377479, 0.740845, 0.555570>, <0.387091, 0.759708, 0.522499> }
triangle { <0.387091, 0.759708, 0.522499>, <0.426320, 0.738408, 0.522499>, <0.415735, 0.720074, 0.555570> }
triangle { <0.426320, 0.738408, 0.522499>, <0.387091, 0.759708, 0.522499>, <0.396105, 0.777400, 0.488621> }
triangle { <0.396105, 0.777400, 0.488621>, <0.436248, 0.755604, 0.488621>, <0.426320, 0.738408, 0.522499> }
triangle { <0.436248, 0.755604, 0.488621>, <0.396105, 0.777400, 0.488621>, <0.404508, 0.793893, 0.453990> }
triangle { <0.404508, 0.793893, 0.453990>, <0.445503, 0.771634, 0.453990>, <0.436248, 0.755604, 0.488621> }
triangle { <0.445503, 0.771634, 0.453990>, <0.404508, 0.793893, 0.453990>, <0.412288, 0.809161, 0.418660> }
triangle { <0.412288, 0.809161, 0.418660>, <0.454072, 0.786475, 0.418660>, <0.445503, 0.771634, 0.453990> }
triangle { <0.454072, 0.786475, 0.418660>, <0.412288, 0.809161, 0.418660>, <0.419433, 0.823183, 0.382683> }
triangle { <0.419433, 0.823183, 0.382683>, <0.461940, 0.800103, 0.382683>, <0.454072, 0.786475, 0.418660> }
triangle { <0.461940, 0.800103, 0.382683>, <0.419433, 0.823183, 0.382683>, <0.425930, 0.835935, 0.346117> }
triangle { <0.425930, 0.835935, 0.346117>, <0.469096, 0.812498, 0.346117>, <0.461940, 0.800103, 0.382683> }
triangle { <0.469096, 0.812498, 0.346117>, <0.425930, 0.835935, 0.346117>, <0.431771, 0.847398, 0.309017> }
triangle { <0.431771, 0.847398, 0.309017>, <0.475528, 0.823639, 0.309017>, <0.469096, 0.812498, 0.346117> }
triangle { <0.475528, 0.823639, 0.309017>, <0.431771, 0.847398, 0.309017>, <0.436946, 0.857554, 0.271440> }
triangle { <0.436946, 0.857554, 0.271440>, <0.481228, 0.833511, 0.271440>, <0.475528, 0.823639, 0.309017> }
triangle { <0.481228, 0.833511, 0.271440>, <0.436946, 0.857554, 0.271440>, <0.441447, 0.866388, 0.233445> }
triangle { <0.441447, 0.866388, 0.233445>, <0.486185, 0.842097, 0.233445>, <0.481228, 0.833511, 0.271440> }
triangle { <0.486185, 0.842097, 0.233445>, <0.441447, 0.866388, 0.233445>, <0.445267, 0.873886, 0.195090> }
triangle { <0.445267, 0.873886, 0.195090>, <0.490393, 0.849385, 0.195090>, <0.486185, 0.842097, 0.233445> }
triangle { <0.490393, 0.849385, 0.195090>, <0.445267, 0.873886, 0.195090>, <0.448401, 0.880037, 0.156434> }
triangle { <0.448401, 0.880037, 0.156434>, <0.493844, 0.855363, 0.156434>, <0.490393, 0.849385, 0.195090> }
triangle { <0.493844, 0.855363, 0.156434>, <0.448401, 0.880037, 0.156434>, <0.450844, 0.884830, 0.117537> }
triangle { <0.450844, 0.884830, 0.117537>, <0.496534, 0.860023, 0.117537>, <0.493844, 0.855363, 0.156434> }
triangle { <0.496534, 0.860023, 0.117537>, <0.450844, 0.884830, 0.117537>, <0.452591, 0.888260, 0.078459> }
triangle { <0.452591, 0.888260, 0.078459>, <0.498459, 0.863356, 0.078459>, <0.496534, 0.860023, 0.117537> }
triangle { <0.498459, 0.863356, 0.078459>, <0.452591, 0.888260, 0.078459>, <0.453640, 0.890320, 0.039260> }
triangle { <0.453640, 0.890320, 0.039260>, <0.499615, 0.865358, 0.039260>, <0.498459, 0.863356, 0.078459> }
triangle { <0.499615, 0.865358, 0.039260>, <0.453640, 0.890320, 0.039260>, <0.453990, 0.891007, -0.000000> }
triangle { <0.453990, 0.891007, -0.000000>, <0.500000, 0.866025, -0.000000>, <0.499615, 0.865358, 0.039260> }
triangle { <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.015968, 0.035866, 0.999229> }
triangle { <0.015968, 0.035866, 0.999229>, <0.017824, 0.034981, 0.999229>, <0.000000, 0.000000, 1.000000> }
triangle { <0.017824, 0.034981, 0.999229>, <0.015968, 0.035866, 0.999229>, <0.031912, 0.071676, 0.996917> }
triangle { <0.031912, 0.071676, 0.996917>, <0.035620, 0.069908, 0.996917>, <0.017824, 0.034981, 0.999229> }
triangle { <0.035620, 0.069908, 0.996917>, <0.031912, 0.071676, 0.996917>, <0.047807, 0.107376, 0.993068> }
triangle { <0.047807, 0.107376, 0.993068>, <0.053361, 0.104727, 0.993068>, <0.035620, 0.069908, 0.996917> }
triangle { <0.053361, 0.104727, 0.993068>, <0.047807, 0.107376, 0.993068>, <0.063628, 0.142910, 0.987688> }
triangle { <0.063628, 0.142910, 0.987688>, <0.071020, 0.139384, 0.987688>, <0.053361, 0.104727, 0.993068> }
triangle { <0.071020, 0.139384, 0.987688>, <0.063628, 0.142910, 0.987688>, <0.079350, 0.178224, 0.980785> }
triangle { <0.079350, 0.178224, 0.980785>, <0.088569, 0.173827, 0.980785>, <0.071020, 0.139384, 0.987688> }
triangle { <0.088569, 0.173827, 0.980785>, <0.079350, 0.178224, 0.980785>, <0.094951, 0.213263, 0.972370> }
triangle { <0.094951, 0.213263, 0.972370>, <0.105982, 0.208001, 0.972370>, <0.088569, 0.173827, 0.980785> }
triangle { <0.105982, 0.208001, 0.972370>, <0.094951, 0.213263, 0.972370>, <0.110405, 0.247973, 0.962455> }
triangle { <0.110405, 0.247973, 0.962455>, <0.123231, 0.241855, 0.962455>, <0.105982, 0.208001, 0.972370> }
triangle { <0.123231, 0.241855, 0.962455>, <0.110405, 0.247973, 0.962455>, <0.125689, 0.282301, 0.951057> }
triangle { <0.125689, 0.282301, 0.951057>, <0.140291, 0.275336, 0.951057>, <0.123231, 0.241855, 0.962455> }
triangle { <0.140291, 0.275336, 0.951057>, <0.125689, 0.282301, 0.951057>, <0.140778, 0.316194, 0.938191> }
triangle { <0.140778, 0.316194, 0.938191>, <0.157134, 0.308393, 0.938191>, <0.140291, 0.275336, 0.951057> }
triangle { <0.157134, 0.308393, 0.938191>, <0.140778, 0.316194, 0.938191>, <0.155651, 0.349599, 0.923880> }
triangle { <0.155651, 0.349599, 0.923880>, <0.173735, 0.340973, 0.923880>, <0.157134, 0.308393, 0.938191> }
triangle { <0.173735, 0.340973, 0.923880>, <0.155651, 0.349599, 0.923880>, <0.170284, 0.382465, 0.908143> }
triangle { <0.170284, 0.382465, 0.908143>, <0.190068, 0.373029, 0.908143>, <0.173735, 0.340973, 0.923880> }
triangle { <0.190068, 0.373029, 0.908143>, <0.170284, 0.382465, 0.908143>, <0.184655, 0.414741, 0.891007> }
triangle { <0.184655, 0.414741, 0.891007>, <0.206107, 0.404508, 0.891007>, <0.190068, 0.373029, 0.908143> }
triangle { <0.206107, 0.404508, 0.891007>, <0.184655, 0.414741, 0.891007>, <0.198740, 0.446378, 0.872496> }
triangle { <0.198740, 0.446378, 0.872496>, <0.221829, 0.435365, 0.872496>, <0.206107, 0.404508, 0.891007> }
triangle { <0.221829, 0.435365, 0.872496>, <0.198740, 0.446378, 0.872496>, <0.212519, 0.477326, 0.852640> }
triangle { <0.212519, 0.477326, 0.852640>, <0.237209, 0.465550, 0.852640>, <0.221829, 0.435365, 0.872496> }
triangle { <0.237209, 0.465550, 0.852640>, <0.212519, 0.477326, 0.852640>, <0.225971, 0.507539, 0.831470> }
triangle { <0.225971, 0.507539, 0.831470>, <0.252224, 0.495017, 0.831470>, <0.237209, 0.465550, 0.852640> }
triangle { <0.252224, 0.495017, 0.831470>, <0.225971, 0.507539, 0.831470>, <0.239074, 0.536969, 0.809017> }
triangle { <0.239074, 0.536969, 0.809017>, <0.266849, 0.523720, 0.809017>, <0.252224, 0.495017, 0.831470> }
triangle { <0.266849, 0.523720, 0.809017>, <0.239074, 0.536969, 0.809017>, <0.251808, 0.565570, 0.785317> }
triangle { <0.251808, 0.565570, 0.785317>, <0.281063, 0.551617, 0.785317>, <0.266849, 0.523720, 0.809017> }
triangle { <0.281063, 0.551617, 0.785317>, <0.251808, 0.565570, 0.785317>, <0.264154, 0.593300, 0.760406> }
triangle { <0.264154, 0.593300, 0.760406>, <0.294843, 0.578662, 0.760406>, <0.281063, 0.551617, 0.785317> }
triangle { <0.294843, 0.578662, 0.760406>, <0.264154, 0.593300, 0.760406>, <0.276093, 0.620115, 0.734323> }
triangle { <0.276093, 0.620115, 0.734323>, <0.308169, 0.604816, 0.734323>, <0.294843, 0.578662, 0.760406> }
triangle { <0.308169, 0.604816, 0.734323>, <0.276093, 0.620115, 0.734323>, <0.287606, 0.645974, 0.707107> }
triangle { <0.287606, 0.645974, 0.707107>, <0.321020, 0.630037, 0.707107>, <0.308169, 0.604816, 0.734323> }
triangle { <0.321020, 0.630037, 0.707107>, <0.287606, 0.645974, 0.707107>, <0.298676, 0.670837, 0.678801> }
triangle { <0.298676, 0.670837, 0.678801>, <0.333375, 0.654286, 0.678801>, <0.321020, 0.630037, 0.707107> }
triangle { <0.333375, 0.654286, 0.678801>, <0.298676, 0.670837, 0.678801>, <0.309285, 0.694665, 0.649448> }
triangle { <0.309285, 0.694665, 0.649448>, <0.345217, 0.677527, 0.649448>, <0.333375, 0.654286, 0.678801> }
triangle { <0.345217, 0.677527, 0.649448>, <0.309285, 0.694665, 0.649448>, <0.319417, 0.717423, 0.619094> }
triangle { <0.319417, 0.717423, 0.619094>, <0.356526, 0.699723, 0.619094>, <0.345217, 0.677527, 0.649448> }
triangle { <0.356526, 0.699723, 0.619094>, <0.319417, 0.717423, 0.619094>, <0.329057, 0.739074, 0.587785> }
triangle { <0.329057, 0.739074, 0.587785>, <0.367286, 0.720839, 0.587785>, <0.356526, 0.699723, 0.619094> }
triangle { <0.367286, 0.720839, 0.587785>, <0.329057, 0.739074, 0.587785>, <0.338189, 0.759585, 0.555570> }
triangle { <0.338189, 0.759585, 0.555570>, <0.377479, 0.740845, 0.555570>, <0.367286, 0.720839, 0.587785> }
triangle { <0.377479, 0.740845, 0.555570>, <0.338189, 0.759585, 0.555570>, <0.346800, 0.778926, 0.522499> }
triangle { <0.346800, 0.778926, 0.522499>, <0.387091, 0.759708, 0.522499>, <0.377479, 0.740845, 0.555570> }
triangle { <0.387091, 0.759708, 0.522499>, <0.346800, 0.778926, 0.522499>, <0.354876, 0.797065, 0.488621> }
triangle { <0.354876, 0.797065, 0.488621>, <0.396105, 0.777400, 0.488621>, <0.387091, 0.759708, 0.522499> }
triangle { <0.396105, 0.777400, 0.488621>, <0.354876, 0.797065, 0.488621>, <0.362405, 0.813975, 0.453990> }
triangle { <0.362405, 0.813975, 0.453990>, <0.404508, 0.793893, 0.453990>, <0.396105, 0.777400, 0.488621> }
triangle { <0.404508, 0.793893, 0.453990>, <0.362405, 0.813975, 0.453990>, <0.369375, 0.829630, 0.418660> }
triangle { <0.369375, 0.829630, 0.418660>, <0.412288, 0.809161, 0.418660>, <0.404508, 0.793893, 0.453990> }
triangle { <0.412288, 0.809161, 0.418660>, <0.369375, 0.829630, 0.418660>, <0.375776, 0.844006, 0.382683> }
triangle { <0.375776, 0.844006, 0.382683>, <0.419433, 0.823183, 0.382683>, <0.412288, 0.809161, 0.418660> }
triangle { <0.419433, 0.823183, 0.382683>, <0.375776, 0.844006, 0.382683>, <0.381597, 0.857080, 0.346117> }
triangle { <0.381597, 0.857080, 0.346117>, <0.425930, 0.835935, 0.346117>, <0.419433, 0.823183, 0.382683> }
triangle { <0.425930, 0.835935, 0.346117>, <0.381597, 0.857080, 0.346117>, <0.386830, 0.868833, 0.309017> }
triangle { <0.386830, 0.868833, 0.309017>, <0.431771, 0.847398, 0.309017>, <0.425930, 0.835935, 0.346117> }
triangle { <0.431771, 0.847398, 0.309017>, <0.386830, 0.868833, 0.309017>, <0.391466, 0.879247, 0.271440> }
triangle { <0.391466, 0.879247, 0.271440>, <0.436946, 0.857554, 0.271440>, <0.431771, 0.847398, 0.309017> }
triangle { <0.436946, 0.857554, 0.271440>, <0.391466, 0.879247, 0.271440>, <0.395498, 0.888304, 0.233445> }
triangle { <0.395498, 0.888304, 0.233445>, <0.441447, 0.866388, 0.233445>, <0.436946, 0.857554, 0.271440> }
triangle { <0.441447, 0.866388, 0.233445>, <0.395498, 0.888304, 0.233445>, <0.398921, 0.895992, 0.195090> }
triangle { <0.398921, 0.895992, 0.195090>, <0.445267, 0.873886, 0.195090>, <0.441447, 0.866388, 0.233445> }
triangle { <0.445267, 0.873886, 0.195090>, <0.398921, 0.895992, 0.195090>, <0.401729, 0.902298, 0.156434> }
triangle { <0.401729, 0.902298, 0.156434>, <0.448401, 0.880037, 0.156434>, <0.445267, 0.873886, 0.195090> }
triangle { <0.448401, 0.880037, 0.156434>, <0.401729, 0.902298, 0.156434>, <0.403917, 0.907213, 0.117537> }
triangle { <0.403917, 0.907213, 0.117537>, <0.450844, 0.884830, 0.117537>, <0.448401, 0.880037, 0.156434> }
triangle { <0.450844, 0.884830, 0.117537>, <0.403917, 0.907213, 0.117537>, <0.405483, 0.910729, 0.078459> }
triangle { <0.405483, 0.910729, 0.078459>, <0.452591, 0.888260, 0.078459>, <0.450844, 0.884830, 0.117537> }
triangle { <0.452591, 0.888260, 0.078459>, <0.405483, 0.910729, 0.078459>, <0.406423, 0.912841, 0.039260> }
triangle { <0.406423, 0.912841, 0.039260>, <0.453640, 0.890320, 0.039260>, <0.452591, 0.888260, 0.078459> }
triangle { <0.453640, 0.890320, 0.039260>, <0.406423, 0.912841, 0.039260>, <0.406737, 0.913545, -0.000000> }
triangle { <0.406737, 0.913545, -0.000000>, <0.453990, 0.891007, -0.000000>, <0.453640, 0.890320, 0.039260> }
triangle { <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.014069, 0.036652, 0.999229> }
triangle { <0.014069, 0.036652, 0.999229>, <0.015968, 0.035866, 0.999229>, <0.000000, 0.000000, 1.000000> }
triangle { <0.015968, 0.035866, 0.999229>, <0.014069, 0.036652, 0.999229>, <0.028117, 0.073248, 0.996917> }
triangle { <0.028117, 0.073248, 0.996917>, <0.031912, 0.071676, 0.996917>, <0.015968, 0.035866, 0.999229> }
triangle { <0.031912, 0.071676, 0.996917>, <0.028117, 0.073248, 0.996917>, <0.042122, 0.109731, 0.993068> }
triangle { <0.042122, 0.109731, 0.993068>, <0.047807, 0.107376, 0.993068>, <0.031912, 0.071676, 0.996917> }
triangle { <0.047807, 0.107376, 0.993068>, <0.042122, 0.109731, 0.993068>, <0.056061, 0.146044, 0.987688> }
triangle { <0.056061, 0.146044, 0.987688>, <0.063628, 0.142910, 0.987688>, <0.047807, 0.107376, 0.993068> }
triangle { <0.063628, 0.142910, 0.987688>, <0.056061, 0.146044, 0.987688>, <0.069914, 0.182133, 0.980785> }
triangle { <0.069914, 0.182133, 0.980785>, <0.079350, 0.178224, 0.980785>, <0.063628, 0.142910, 0.987688> }
triangle { <0.079350, 0.178224, 0.980785>, <0.069914, 0.182133, 0.980785>, <0.083659, 0.217940, 0.972370> }
triangle { <0.083659, 0.217940, 0.972370>, <0.094951, 0.213263, 0.972370>, <0.079350, 0.178224, 0.980785> }
triangle { <0.094951, 0.213263, 0.972370>, <0.083659, 0.217940, 0.972370>, <0.097276, 0.253411, 0.962455> }
triangle { <0.097276, 0.253411, 0.962455>, <0.110405, 0.247973, 0.962455>, <0.094951, 0.213263, 0.972370> }
triangle { <0.110405, 0.247973, 0.962455>, <0.097276, 0.253411, 0.962455>, <0.110742, 0.288492, 0.951057> }
triangle { <0.110742, 0.288492, 0.951057>, <0.125689, 0.282301, 0.951057>, <0.110405, 0.247973, 0.962455> }
triangle { <0.125689, 0.282301, 0.951057>, <0.110742, 0.288492, 0.951057>, <0.124037, 0.323128, 0.938191> }
triangle { <0.124037, 0.323128, 0.938191>, <0.140778, 0.316194, 0.938191>, <0.125689, 0.282301, 0.951057> }
triangle { <0.140778, 0.316194, 0.938191>, <0.124037, 0.323128, 0.938191>, <0.137141, 0.357266, 0.923880> }
triangle { <0.137141, 0.357266, 0.923880>, <0.155651, 0.349599, 0.923880>, <0.140778, 0.316194, 0.938191> }
triangle { <0.155651, 0.349599, 0.923880>, <0.137141, 0.357266, 0.923880>, <0.150034, 0.390853, 0.908143> }
triangle { <0.150034, 0.390853, 0.908143>, <0.170284, 0.382465, 0.908143>, <0.155651, 0.349599, 0.923880> }
triangle { <0.170284, 0.382465, 0.908143>, <0.150034, 0.390853, 0.908143>, <0.162696, 0.423837, 0.891007> }
triangle { <0.162696, 0.423837, 0.891007>, <0.184655, 0.414741, 0.891007>, <0.170284, 0.382465, 0.908143> }
triangle { <0.184655, 0.414741, 0.891007>, <0.162696, 0.423837, 0.891007>, <0.175106, 0.456167, 0.872496> }
triangle { <0.175106, 0.456167, 0.872496>, <0.198740, 0.446378, 0.872496>, <0.184655, 0.414741, 0.891007> }
triangle { <0.198740, 0.446378, 0.872496>, <0.175106, 0.456167, 0.872496>, <0.187247, 0.487794, 0.852640> }
triangle { <0.187247, 0.487794, 0.852640>, <0.212519, 0.477326, 0.852640>, <0.198740, 0.446378, 0.872496> }
triangle { <0.212519, 0.477326, 0.852640>, <0.187247, 0.487794, 0.852640>, <0.199099, 0.518669, 0.831470> }
triangle { <0.199099, 0.518669, 0.831470>, <0.225971, 0.507539, 0.831470>, <0.212519, 0.477326, 0.852640> }
triangle { <0.225971, 0.507539, 0.831470>, <0.199099, 0.518669, 0.831470>, <0.210643, 0.548745, 0.809017> }
triangle { <0.210643, 0.548745, 0.809017>, <0.239074, 0.536969, 0.809017>, <0.225971, 0.507539, 0.831470> }
triangle { <0.239074, 0.536969, 0.809017>, <0.210643, 0.548745, 0.809017>, <0.221863, 0.577974, 0.785317> }
triangle { <0.221863, 0.577974, 0.785317>, <0.251808, 0.565570, 0.785317>, <0.239074, 0.536969, 0.809017> }
triangle { <0.251808, 0.565570, 0.785317>, <0.221863, 0.577974, 0.785317>, <0.232741, 0.606312, 0.760406> }
triangle { <0.232741, 0.606312, 0.760406>, <0.264154, 0.593300, 0.760406>, <0.251808, 0.565570, 0.785317> }
triangle { <0.264154, 0.593300, 0.760406>, <0.232741, 0.606312, 0.760406>, <0.243260, 0.633715, 0.734323> }
triangle { <0.243260, 0.633715, 0.734323>, <0.276093, 0.620115, 0.734323>, <0.264154, 0.593300, 0.760406> }
triangle { <0.276093, 0.620115, 0.734323>, <0.243260, 0.633715, 0.734323>, <0.253404, 0.660141, 0.707107> }
triangle { <0.253404, 0.660141, 0.707107>, <0.287606, 0.645974, 0.707107>, <0.276093, 0.620115, 0.734323> }
triangle { <0.287606, 0.645974, 0.707107>, <0.253404, 0.660141, 0.707107>, <0.263158, 0.685549, 0.678801> }
triangle { <0.263158, 0.685549, 0.678801>, <0.298676, 0.670837, 0.678801>, <0.287606, 0.645974, 0.707107> }
triangle { <0.298676, 0.670837, 0.678801>, <0.263158, 0.685549, 0.678801>, <0.272505, 0.709900, 0.649448> }
triangle { <0.272505, 0.709900, 0.649448>, <0.309285, 0.694665, 0.649448>, <0.298676, 0.670837, 0.678801> }
triangle { <0.309285, 0.694665, 0.649448>, <0.272505, 0.709900, 0.649448>, <0.281432, 0.733157, 0.619094> }
triangle { <0.281432, 0.733157, 0.619094>, <0.319417, 0.717423, 0.619094>, <0.309285, 0.694665, 0.649448> }
triangle { <0.319417, 0.717423, 0.619094>, <0.281432, 0.733157, 0.619094>, <0.289926, 0.755282, 0.587785> }
triangle { <0.289926, 0.755282, 0.587785>, <0.329057, 0.739074, 0.587785>, <0.319417, 0.717423, 0.619094> }
triangle { <0.329057, 0.739074, 0.587785>, <0.289926, 0.755282, 0.587785>, <0.297972, 0.776244, 0.555570> }
triangle { <0.297972, 0.776244, 0.555570>, <0.338189, 0.759585, 0.555570>, <0.329057, 0.739074, 0.587785> }
triangle { <0.338189, 0.759585, 0.555570>, <0.297972, 0.776244, 0.555570>, <0.305559, 0.796008, 0.522499> }
triangle { <0.305559, 0.796008, 0.522499>, <0.346800, 0.778926, 0.522499>, <0.338189, 0.759585, 0.555570> }
triangle { <0.346800, 0.778926, 0.522499>, <0.305559, 0.796008, 0.522499>, <0.312675, 0.814545, 0.488621> }
triangle { <0.312675, 0.814545, 0.488621>, <0.354876, 0.797065, 0.488621>, <0.346800, 0.778926, 0.522499> }
triangle { <0.354876, 0.797065, 0.488621>, <0.312675, 0.814545, 0.488621>, <0.319308, 0.831826, 0.453990> }
triangle { <0.319308, 0.831826, 0.453990>, <0.362405, 0.813975, 0.453990>, <0.354876, 0.797065, 0.488621> }
triangle { <0.362405, 0.813975, 0.453990>, <0.319308, 0.831826, 0.453990>, <0.325449, 0.847825, 0.418660> }
triangle { <0.325449, 0.847825, 0.418660>, <0.369375, 0.829630, 0.418660>, <0.362405, 0.813975, 0.453990> }
triangle { <0.369375, 0.829630, 0.418660>, <0.325449, 0.847825, 0.418660>, <0.331089, 0.862516, 0.382683> }
triangle { <0.331089, 0.862516, 0.382683>, <0.375776, 0.844006, 0.382683>, <0.369375, 0.829630, 0.418660> }
triangle { <0.375776, 0.844006, 0.382683>, <0.331089, 0.862516, 0.382683>, <0.336218, 0.875877, 0.346117> }
triangle { <0.336218, 0.875877, 0.346117>, <0.381597, 0.857080, 0.346117>, <0.375776, 0.844006, 0.382683> }
triangle { <0.381597, 0.857080, 0.346117>, <0.336218, 0.875877, 0.346117>, <0.340828, 0.887888, 0.309017> }
triangle { <0.340828, 0.887888, 0.309017>, <0.386830, 0.868833, 0.309017>, <0.381597, 0.857080, 0.346117> }
triangle { <0.386830, 0.868833, 0.309017>, <0.340828, 0.887888, 0.309017>, <0.344913, 0.898529, 0.271440> }
triangle { <0.344913, 0.898529, 0.271440>, <0.391466, 0.879247, 0.271440>, <0.386830, 0.868833, 0.309017> }
triangle { <0.391466, 0.879247, 0.271440>, <0.344913, 0.898529, 0.271440>, <0.348466, 0.907786, 0.233445> }
triangle { <0.348466, 0.907786, 0.233445>, <0.395498, 0.888304, 0.233445>, <0.391466, 0.879247, 0.271440> }
triangle { <0.395498, 0.888304, 0.233445>, <0.348466, 0.907786, 0.233445>, <0.351482, 0.915642, 0.195090> }
triangle { <0.351482, 0.915642, 0.195090>, <0.398921, 0.895992, 0.195090>, <0.395498, 0.888304, 0.233445> }
triangle { <0.398921, 0.895992, 0.195090>, <0.351482, 0.915642, 0.195090>, <0.353956, 0.922087, 0.156434> }
triangle { <0.353956, 0.922087, 0.156434>, <0.401729, 0.902298, 0.156434>, <0.398921, 0.895992, 0.195090> }
triangle { <0.401729, 0.902298, 0.156434>, <0.353956, 0.922087, 0.156434>, <0.355884, 0.927109, 0.117537> }
triangle { <0.355884, 0.927109, 0.117537>, <0.403917, 0.907213, 0.117537>, <0.401729, 0.902298, 0.156434> }
triangle { <0.403917, 0.907213, 0.117537>, <0.355884, 0.927109, 0.117537>, <0.357263, 0.930703, 0.078459> }
triangle { <0.357263, 0.930703, 0.078459>, <0.405483, 0.910729, 0.078459>, <0.403917, 0.907213, 0.117537> }
triangle { <0.405483, 0.910729, 0.078459>, <0.357263, 0.930703, 0.078459>, <0.358092, 0.932861, 0.039260> }
triangle { <0.358092, 0.932861, 0.039260>, <0.406423, 0.912841, 0.039260>, <0.405483, 0.910729, 0.078459> }
triangle { <0.406423, 0.912841, 0.039260>, <0.358092, 0.932861, 0.039260>, <0.358368, 0.933580, -0.000000> }
triangle { <0.358368, 0.933580, -0.000000>, <0.406737, 0.913545, -0.000000>, <0.406423, 0.912841, 0.039260> }
triangle { <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.012132, 0.037338, 0.999229> }
triangle { <0.012132, 0.037338, 0.999229>, <0.014069, 0.036652, 0.999229>, <0.000000, 0.000000, 1.000000> }
triangle { <0.014069, 0.036652, 0.999229>, <0.012132, 0.037338, 0.999229>, <0.024245, 0.074619, 0.996917> }
triangle { <0.024245, 0.074619, 0.996917>, <0.028117, 0.073248, 0.996917>, <0.014069, 0.036652, 0.999229> }
triangle { <0.028117, 0.073248, 0.996917>, <0.024245, 0.074619, 0.996917>, <0.036321, 0.111785, 0.993068> }
triangle { <0.036321, 0.111785, 0.993068>, <0.042122, 0.109731, 0.993068>, <0.028117, 0.073248, 0.996917> }
triangle { <0.042122, 0.109731, 0.993068>, <0.036321, 0.111785, 0.993068>, <0.048341, 0.148778, 0.987688> }
triangle { <0.048341, 0.148778, 0.987688>, <0.056061, 0.146044, 0.987688>, <0.042122, 0.109731, 0.993068> }
triangle { <0.056061, 0.146044, 0.987688>, <0.048341, 0.148778, 0.987688>, <0.060286, 0.185542, 0.980785> }
triangle { <0.060286, 0.185542, 0.980785>, <0.069914, 0.182133, 0.980785>, <0.056061, 0.146044, 0.987688> }
triangle { <0.069914, 0.182133, 0.980785>, <0.060286, 0.185542, 0.980785>, <0.072139, 0.222020, 0.972370> }
triangle { <0.072139, 0.222020, 0.972370>, <0.083659, 0.217940, 0.972370>, <0.069914, 0.182133, 0.980785> }
triangle { <0.083659, 0.217940, 0.972370>, <0.072139, 0.222020, 0.972370>, <0.083880, 0.258155, 0.962455> }
triangle { <0.083880, 0.258155, 0.962455>, <0.097276, 0.253411, 0.962455>, <0.083659, 0.217940, 0.972370> }
triangle { <0.097276, 0.253411, 0.962455>, <0.083880, 0.258155, 0.962455>, <0.095492, 0.293893, 0.951057> }
triangle { <0.095492, 0.293893, 0.951057>, <0.110742, 0.288492, 0.951057>, <0.097276, 0.253411, 0.962455> }
triangle { <0.110742, 0.288492, 0.951057>, <0.095492, 0.293893, 0.951057>, <0.106956, 0.329177, 0.938191> }
triangle { <0.106956, 0.329177, 0.938191>, <0.124037, 0.323128, 0.938191>, <0.110742, 0.288492, 0.951057> }
triangle { <0.124037, 0.323128, 0.938191>, <0.106956, 0.329177, 0.938191>, <0.118256, 0.363954, 0.923880> }
triangle { <0.118256, 0.363954, 0.923880>, <0.137141, 0.357266, 0.923880>, <0.124037, 0.323128, 0.938191> }
triangle { <0.137141, 0.357266, 0.923880>, <0.118256, 0.363954, 0.923880>, <0.129373, 0.398169, 0.908143> }
triangle { <0.129373, 0.398169, 0.908143>, <0.150034, 0.390853, 0.908143>, <0.137141, 0.357266, 0.923880> }
triangle { <0.150034, 0.390853, 0.908143>, <0.129373, 0.398169, 0.908143>, <0.140291, 0.431771, 0.891007> }
triangle { <0.140291, 0.431771, 0.891007>, <0.162696, 0.423837, 0.891007>, <0.150034, 0.390853, 0.908143> }
triangle { <0.162696, 0.423837, 0.891007>, <0.140291, 0.431771, 0.891007>, <0.150992, 0.464706, 0.872496> }
triangle { <0.150992, 0.464706, 0.872496>, <0.175106, 0.456167, 0.872496>, <0.162696, 0.423837, 0.891007> }
triangle { <0.175106, 0.456167, 0.872496>, <0.150992, 0.464706, 0.872496>, <0.161461, 0.496926, 0.852640> }
triangle { <0.161461, 0.496926, 0.852640>, <0.187247, 0.487794, 0.852640>, <0.175106, 0.456167, 0.872496> }
triangle { <0.187247, 0.487794, 0.852640>, <0.161461, 0.496926, 0.852640>, <0.171681, 0.528379, 0.831470> }
triangle { <0.171681, 0.528379, 0.831470>, <0.199099, 0.518669, 0.831470>, <0.187247, 0.487794, 0.852640> }
triangle { <0.199099, 0.518669, 0.831470>, <0.171681, 0.528379, 0.831470>, <0.181636, 0.559017, 0.809017> }
triangle { <0.181636, 0.559017, 0.809017>, <0.210643, 0.548745, 0.809017>, <0.199099, 0.518669, 0.831470> }
triangle { <0.210643, 0.548745, 0.809017>, <0.181636, 0.559017, 0.809017>, <0.191311, 0.588793, 0.785317> }
triangle { <0.191311, 0.588793, 0.785317>, <0.221863, 0.577974, 0.785317>, <0.210643, 0.548745, 0.809017> }
triangle { <0.221863, 0.577974, 0.785317>, <0.191311, 0.588793, 0.785317>, <0.200690, 0.617662, 0.760406> }
triangle { <0.200690, 0.617662, 0.760406>, <0.232741, 0.606312, 0.760406>, <0.221863, 0.577974, 0.785317> }
triangle { <0.232741, 0.606312, 0.760406>, <0.200690, 0.617662, 0.760406>, <0.209761, 0.645578, 0.734323> }
triangle { <0.209761, 0.645578, 0.734323>, <0.243260, 0.633715, 0.734323>, <0.232741, 0.606312, 0.760406> }
triangle { <0.243260, 0.633715, 0.734323>, <0.209761, 0.645578, 0.734323>, <0.218508, 0.672499, 0.707107> }
triangle { <0.218508, 0.672499, 0.707107>, <0.253404, 0.660141, 0.707107>, <0.243260, 0.633715, 0.734323> }
triangle { <0.253404, 0.660141, 0.707107>, <0.218508, 0.672499, 0.707107>, <0.226918, 0.698382, 0.678801> }
triangle { <0.226918, 0.698382, 0.678801>, <0.263158, 0.685549, 0.678801>, <0.253404, 0.660141, 0.707107> }
triangle { <0.263158, 0.685549, 0.678801>, <0.226918, 0.698382, 0.678801>, <0.234978, 0.723189, 0.649448> }
triangle { <0.234978, 0.723189, 0.649448>, <0.272505, 0.709900, 0.649448>, <0.263158, 0.685549, 0.678801> }
triangle { <0.272505, 0.709900, 0.649448>, <0.234978, 0.723189, 0.649448>, <0.242676, 0.746881, 0.619094> }
triangle { <0.242676, 0.746881, 0.619094>, <0.281432, 0.733157, 0.619094>, <0.272505, 0.709900, 0.649448> }
triangle { <0.281432, 0.733157, 0.619094>, <0.242676, 0.746881, 0.619094>, <0.250000, 0.769421, 0.587785> }
triangle { <0.250000, 0.769421, 0.587785>, <0.289926, 0.755282, 0.587785>, <0.281432, 0.733157, 0.619094> }
triangle { <0.289926, 0.755282, 0.587785>, <0.250000, 0.769421, 0.587785>, <0.256938, 0.790775, 0.555570> }
triangle { <0.256938, 0.790775, 0.555570>, <0.297972, 0.776244, 0.555570>, <0.289926, 0.755282, 0.587785> }
triangle { <0.297972, 0.776244, 0.555570>, <0.256938, 0.790775, 0.555570>, <0.263480, 0.810909, 0.522499> }
triangle { <0.263480, 0.810909, 0.522499>, <0.305559, 0.796008, 0.522499>, <0.297972, 0.776244, 0.555570> }
triangle { <0.305559, 0.796008, 0.522499>, <0.263480, 0.810909, 0.522499>, <0.269616, 0.829793, 0.488621> }
triangle { <0.269616, 0.829793, 0.488621>, <0.312675, 0.814545, 0.488621>, <0.305559, 0.796008, 0.522499> }
triangle { <0.312675, 0.814545, 0.488621>, <0.269616, 0.829793, 0.488621>, <0.275336, 0.847398, 0.453990> }
triangle { <0.275336, 0.847398, 0.453990>, <0.319308, 0.831826, 0.453990>, <0.312675, 0.814545, 0.488621> }
triangle { <0.319308, 0.831826, 0.453990>, <0.275336, 0.847398, 0.453990>, <0.280632, 0.863695, 0.418660> }
triangle { <0.280632, 0.863695, 0.418660>, <0.325449, 0.847825, 0.418660>, <0.319308, 0.831826, 0.453990> }
triangle { <0.325449, 0.847825, 0.418660>, <0.280632, 0.863695, 0.418660>, <0.285494, 0.878662, 0.382683> }
triangle { <0.285494, 0.878662, 0.382683>, <0.331089, 0.862516, 0.382683>, <0.325449, 0.847825, 0.418660> }
triangle { <0.331089, 0.862516, 0.382683>, <0.285494, 0.878662, 0.382683>, <0.289917, 0.892273, 0.346117> }
triangle { <0.289917, 0.892273, 0.346117>, <0.336218, 0.875877, 0.346117>, <0.331089, 0.862516, 0.382683> }
triangle { <0.336218, 0.875877, 0.346117>, <0.289917, 0.892273, 0.346117>, <0.293893, 0.904508, 0.309017> }
triangle { <0.293893, 0.904508, 0.309017>, <0.340828, 0.887888, 0.309017>, <0.336218, 0.875877, 0.346117> }
triangle { <0.340828, 0.887888, 0.309017>, <0.293893, 0.904508, 0.309017>, <0.297415, 0.915349, 0.271440> }
triangle { <0.297415, 0.915349, 0.271440>, <0.344913, 0.898529, 0.271440>, <0.340828, 0.887888, 0.309017> }
triangle { <0.344913, 0.898529, 0.271440>, <0.297415, 0.915349, 0.271440>, <0.300479, 0.924779, 0.233445> }
triangle { <0.300479, 0.924779, 0.233445>, <0.348466, 0.907786, 0.233445>, <0.344913, 0.898529, 0.271440> }
triangle { <0.348466, 0.907786, 0.233445>, <0.300479, 0.924779, 0.233445>, <0.303079, 0.932782, 0.195090> }
triangle { <0.303079, 0.932782, 0.195090>, <0.351482, 0.915642, 0.195090>, <0.348466, 0.907786, 0.233445> }
triangle { <0.351482, 0.915642, 0.195090>, <0.303079, 0.932782, 0.195090>, <0.305212, 0.939347, 0.156434> }
triangle { <0.305212, 0.939347, 0.156434>, <0.353956, 0.922087, 0.156434>, <0.351482, 0.915642, 0.195090> }
triangle { <0.353956, 0.922087, 0.156434>, <0.305212, 0.939347, 0.156434>, <0.306875, 0.944464, 0.117537> }
triangle { <0.306875, 0.944464, 0.117537>, <0.355884, 0.927109, 0.117537>, <0.353956, 0.922087, 0.156434> }
triangle { <0.355884, 0.927109, 0.117537>, <0.306875, 0.944464, 0.117537>, <0.308064, 0.948125, 0.078459> }
triangle { <0.308064, 0.948125, 0.078459>, <0.357263, 0.930703, 0.078459>, <0.355884, 0.927109, 0.117537> }
triangle { <0.357263, 0.930703, 0.078459>, <0.308064, 0.948125, 0.078459>, <0.308779, 0.950323, 0.039260> }
triangle { <0.308779, 0.950323, 0.039260>, <0.358092, 0.932861, 0.039260>, <0.357263, 0.930703, 0.078459> }
triangle { <0.358092, 0.932861, 0.039260>, <0.308779, 0.950323, 0.039260>, <0.309017, 0.951057, -0.000000> }
triangle { <0.309017, 0.951057, -0.000000>, <0.358368, 0.933580, -0.000000>, <0.358092, 0.932861, 0.039260> }
triangle { <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.010161, 0.037922, 0.999229> }
triangle { <0.010161, 0.037922, 0.999229>, <0.012132, 0.037338, 0.999229>, <0.000000, 0.000000, 1.000000> }
triangle { <0.012132, 0.037338, 0.999229>, <0.010161, 0.037922, 0.999229>, <0.020307, 0.075786, 0.996917> }
triangle { <0.020307, 0.075786, 0.996917>, <0.024245, 0.074619, 0.996917>, <0.012132, 0.037338, 0.999229> }
triangle { <0.024245, 0.074619, 0.996917>, <0.020307, 0.075786, 0.996917>, <0.030421, 0.113532, 0.993068> }
triangle { <0.030421, 0.113532, 0.993068>, <0.036321, 0.111785, 0.993068>, <0.024245, 0.074619, 0.996917> }
triangle { <0.036321, 0.111785, 0.993068>, <0.030421, 0.113532, 0.993068>, <0.040488, 0.151104, 0.987688> }
triangle { <0.040488, 0.151104, 0.987688>, <0.048341, 0.148778, 0.987688>, <0.036321, 0.111785, 0.993068> }
triangle { <0.048341, 0.148778, 0.987688>, <0.040488, 0.151104, 0.987688>, <0.050493, 0.188443, 0.980785> }
triangle { <0.050493, 0.188443, 0.980785>, <0.060286, 0.185542, 0.980785>, <0.048341, 0.148778, 0.987688> }
triangle { <0.060286, 0.185542, 0.980785>, <0.050493, 0.188443, 0.980785>, <0.060420, 0.225491, 0.972370> }
triangle { <0.060420, 0.225491, 0.972370>, <0.072139, 0.222020, 0.972370>, <0.060286, 0.185542, 0.980785> }
triangle { <0.072139, 0.222020, 0.972370>, <0.060420, 0.225491, 0.972370>, <0.070254, 0.262191, 0.962455> }
triangle { <0.070254, 0.262191, 0.962455>, <0.083880, 0.258155, 0.962455>, <0.072139, 0.222020, 0.972370> }
triangle { <0.083880, 0.258155, 0.962455>, <0.070254, 0.262191, 0.962455>, <0.079979, 0.298487, 0.951057> }
triangle { <0.079979, 0.298487, 0.951057>, <0.095492, 0.293893, 0.951057>, <0.083880, 0.258155, 0.962455> }
triangle { <0.095492, 0.293893, 0.951057>, <0.079979, 0.298487, 0.951057>, <0.089582, 0.334323, 0.938191> }
triangle { <0.089582, 0.334323, 0.938191>, <0.106956, 0.329177, 0.938191>, <0.095492, 0.293893, 0.951057> }
triangle { <0.106956, 0.329177, 0.938191>, <0.089582, 0.334323, 0.938191>, <0.099046, 0.369644, 0.923880> }
triangle { <0.099046, 0.369644, 0.923880>, <0.118256, 0.363954, 0.923880>, <0.106956, 0.329177, 0.938191> }
triangle { <0.118256, 0.363954, 0.923880>, <0.099046, 0.369644, 0.923880>, <0.108357, 0.404394, 0.908143> }
triangle { <0.108357, 0.404394, 0.908143>, <0.129373, 0.398169, 0.908143>, <0.118256, 0.363954, 0.923880> }
triangle { <0.129373, 0.398169, 0.908143>, <0.108357, 0.404394, 0.908143>, <0.117501, 0.438521, 0.891007> }
triangle { <0.117501, 0.438521, 0.891007>, <0.140291, 0.431771, 0.891007>, <0.129373, 0.398169, 0.908143> }
triangle { <0.140291, 0.431771, 0.891007>, <0.117501, 0.438521, 0.891007>, <0.126464, 0.471972, 0.872496> }
triangle { <0.126464, 0.471972, 0.872496>, <0.150992, 0.464706, 0.872496>, <0.140291, 0.431771, 0.891007> }
triangle { <0.150992, 0.464706, 0.872496>, <0.126464, 0.471972, 0.872496>, <0.135233, 0.504695, 0.852640> }
triangle { <0.135233, 0.504695, 0.852640>, <0.161461, 0.496926, 0.852640>, <0.150992, 0.464706, 0.872496> }
triangle { <0.161461, 0.496926, 0.852640>, <0.135233, 0.504695, 0.852640>, <0.143792, 0.536640, 0.831470> }
triangle { <0.143792, 0.536640, 0.831470>, <0.171681, 0.528379, 0.831470>, <0.161461, 0.496926, 0.852640> }
triangle { <0.171681, 0.528379, 0.831470>, <0.143792, 0.536640, 0.831470>, <0.152130, 0.567757, 0.809017> }
triangle { <0.152130, 0.567757, 0.809017>, <0.181636, 0.559017, 0.809017>, <0.171681, 0.528379, 0.831470> }
triangle { <0.181636, 0.559017, 0.809017>, <0.152130, 0.567757, 0.809017>, <0.160233, 0.597999, 0.785317> }
triangle { <0.160233, 0.597999, 0.785317>, <0.191311, 0.588793, 0.785317>, <0.181636, 0.559017, 0.809017> }
triangle { <0.191311, 0.588793, 0.785317>, <0.160233, 0.597999, 0.785317>, <0.168090, 0.627319, 0.760406> }
triangle { <0.168090, 0.627319, 0.760406>, <0.200690, 0.617662, 0.760406>, <0.191311, 0.588793, 0.785317> }
triangle { <0.200690, 0.617662, 0.760406>, <0.168090, 0.627319, 0.760406>, <0.175687, 0.655671, 0.734323> }
triangle { <0.175687, 0.655671, 0.734323>, <0.209761, 0.645578, 0.734323>, <0.200690, 0.617662, 0.760406> }
triangle { <0.209761, 0.645578, 0.734323>, <0.175687, 0.655671, 0.734323>, <0.183013, 0.683013, 0.707107> }
triangle { <0.183013, 0.683013, 0.707107>, <0.218508, 0.672499, 0.707107>, <0.209761, 0.645578, 0.734323> }
triangle { <0.218508, 0.672499, 0.707107>, <0.183013, 0.683013, 0.707107>, <0.190057, 0.709301, 0.678801> }
triangle { <0.190057, 0.709301, 0.678801>, <0.226918, 0.698382, 0.678801>, <0.218508, 0.672499, 0.707107> }
triangle { <0.226918, 0.698382, 0.678801>, <0.190057, 0.709301, 0.678801>, <0.196808, 0.734496, 0.649448> }
triangle { <0.196808, 0.734496, 0.649448>, <0.234978, 0.723189, 0.649448>, <0.226918, 0.698382, 0.678801> }
triangle { <0.234978, 0.723189, 0.649448>, <0.196808, 0.734496, 0.649448>, <0.203255, 0.758558, 0.619094> }
triangle { <0.203255, 0.758558, 0.619094>, <0.242676, 0.746881, 0.619094>, <0.234978, 0.723189, 0.649448> }
triangle { <0.242676, 0.746881, 0.619094>, <0.203255, 0.758558, 0.619094>, <0.209389, 0.781450, 0.587785> }
triangle { <0.209389, 0.781450, 0.587785>, <0.250000, 0.769421, 0.587785>, <0.242676, 0.746881, 0.619094> }
triangle { <0.250000, 0.769421, 0.587785>, <0.209389, 0.781450, 0.587785>, <0.215200, 0.803138, 0.555570> }
triangle { <0.215200, 0.803138, 0.555570>, <0.256938, 0.790775, 0.555570>, <0.250000, 0.769421, 0.587785> }
triangle { <0.256938, 0.790775, 0.555570>, <0.215200, 0.803138, 0.555570>, <0.220680, 0.823587, 0.522499> }
triangle { <0.220680, 0.823587, 0.522499>, <0.263480, 0.810909, 0.522499>, <0.256938, 0.790775, 0.555570> }
triangle { <0.263480, 0.810909, 0.522499>, <0.220680, 0.823587, 0.522499>, <0.225819, 0.842766, 0.488621> }
triangle { <0.225819, 0.842766, 0.488621>, <0.269616, 0.829793, 0.488621>, <0.263480, 0.810909, 0.522499> }
triangle { <0.269616, 0.829793, 0.488621>, <0.225819, 0.842766, 0.488621>, <0.230609, 0.860646, 0.453990> }
triangle { <0.230609, 0.860646, 0.453990>, <0.275336, 0.847398, 0.453990>, <0.269616, 0.829793, 0.488621> }
triangle { <0.275336, 0.847398, 0.453990>, <0.230609, 0.860646, 0.453990>, <0.235045, 0.877199, 0.418660> }
triangle { <0.235045, 0.877199, 0.418660>, <0.280632, 0.863695, 0.418660>, <0.275336, 0.847398, 0.453990> }
triangle { <0.280632, 0.863695, 0.418660>, <0.235045, 0.877199, 0.418660>, <0.239118, 0.892399, 0.382683> }
triangle { <0.239118, 0.892399, 0.382683>, <0.285494, 0.878662, 0.382683>, <0.280632, 0.863695, 0.418660> }
triangle { <0.285494, 0.878662, 0.382683>, <0.239118, 0.892399, 0.382683>, <0.242822, 0.906223, 0.346117> }
triangle { <0.242822, 0.906223, 0.346117>, <0.289917, 0.892273, 0.346117>, <0.285494, 0.878662, 0.382683> }
triangle { <0.289917, 0.892273, 0.346117>, <0.242822, 0.906223, 0.346117>, <0.246152, 0.918650, 0.309017> }
triangle { <0.246152, 0.918650, 0.309017>, <0.293893, 0.904508, 0.309017>, <0.289917, 0.892273, 0.346117> }
triangle { <0.293893, 0.904508, 0.309017>, <0.246152, 0.918650, 0.309017>, <0.249102, 0.929660, 0.271440> }
triangle { <0.249102, 0.929660, 0.271440>, <0.297415, 0.915349, 0.271440>, <0.293893, 0.904508, 0.309017> }
triangle { <0.297415, 0.915349, 0.271440>, <0.249102, 0.929660, 0.271440>, <0.251668, 0.939237, 0.233445> }
triangle { <0.251668, 0.939237, 0.233445>, <0.300479, 0.924779, 0.233445>, <0.297415, 0.915349, 0.271440> }
triangle { <0.300479, 0.924779, 0.233445>, <0.251668, 0.939237, 0.233445>, <0.253846, 0.947366, 0.195090> }
triangle { <0.253846, 0.947366, 0.195090>, <0.303079, 0.932782, 0.195090>, <0.300479, 0.924779, 0.233445> }
triangle { <0.303079, 0.932782, 0.195090>, <0.253846, 0.947366, 0.195090>, <0.255633, 0.954034, 0.156434> }
triangle { <0.255633, 0.954034, 0.156434>, <0.305212, 0.939347, 0.156434>, <0.303079, 0.932782, 0.195090> }
triangle { <0.305212, 0.939347, 0.156434>, <0.255633, 0.954034, 0.156434>, <0.257025, 0.959230, 0.117537> }
triangle { <0.257025, 0.959230, 0.117537>, <0.306875, 0.944464, 0.117537>, <0.305212, 0.939347, 0.156434> }
triangle { <0.306875, 0.944464, 0.117537>, <0.257025, 0.959230, 0.117537>, <0.258021, 0.962948, 0.078459> }
triangle { <0.258021, 0.962948, 0.078459>, <0.308064, 0.948125, 0.078459>, <0.306875, 0.944464, 0.117537> }
triangle { <0.308064, 0.948125, 0.078459>, <0.258021, 0.962948, 0.078459>, <0.258620, 0.965181, 0.039260> }
triangle { <0.258620, 0.965181, 0.039260>, <0.308779, 0.950323, 0.039260>, <0.308064, 0.948125, 0.078459> }
triangle { <0.308779, 0.950323, 0.039260>, <0.258620, 0.965181, 0.039260>, <0.258819, 0.965926, -0.000000> }
triangle { <0.258819, 0.965926, -0.000000>, <0.309017, 0.951057, -0.000000>, <0.308779, 0.950323, 0.039260> }
triangle { <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.008163, 0.038402, 0.999229> }
triangle { <0.008163, 0.038402, 0.999229>, <0.010161, 0.037922, 0.999229>, <0.000000, 0.000000, 1.000000> }
triangle { <0.010161, 0.037922, 0.999229>, <0.008163, 0.038402, 0.999229>, <0.016313, 0.076745, 0.996917> }
triangle { <0.016313, 0.076745, 0.996917>, <0.020307, 0.075786, 0.996917>, <0.010161, 0.037922, 0.999229> }
triangle { <0.020307, 0.075786, 0.996917>, <0.016313, 0.076745, 0.996917>, <0.024437, 0.114969, 0.993068> }
triangle { <0.024437, 0.114969, 0.993068>, <0.030421, 0.113532, 0.993068>, <0.020307, 0.075786, 0.996917> }
triangle { <0.030421, 0.113532, 0.993068>, <0.024437, 0.114969, 0.993068>, <0.032525, 0.153016, 0.987688> }
triangle { <0.032525, 0.153016, 0.987688>, <0.040488, 0.151104, 0.987688>, <0.030421, 0.113532, 0.993068> }
triangle { <0.040488, 0.151104, 0.987688>, <0.032525, 0.153016, 0.987688>, <0.040562, 0.190827, 0.980785> }
triangle { <0.040562, 0.190827, 0.980785>, <0.050493, 0.188443, 0.980785>, <0.040488, 0.151104, 0.987688> }
triangle { <0.050493, 0.188443, 0.980785>, <0.040562, 0.190827, 0.980785>, <0.048536, 0.228344, 0.972370> }
triangle { <0.048536, 0.228344, 0.972370>, <0.060420, 0.225491, 0.972370>, <0.050493, 0.188443, 0.980785> }
triangle { <0.060420, 0.225491, 0.972370>, <0.048536, 0.228344, 0.972370>, <0.056436, 0.265509, 0.962455> }
triangle { <0.056436, 0.265509, 0.962455>, <0.070254, 0.262191, 0.962455>, <0.060420, 0.225491, 0.972370> }
triangle { <0.070254, 0.262191, 0.962455>, <0.056436, 0.265509, 0.962455>, <0.064248, 0.302264, 0.951057> }
triangle { <0.064248, 0.302264, 0.951057>, <0.079979, 0.298487, 0.951057>, <0.070254, 0.262191, 0.962455> }
triangle { <0.079979, 0.298487, 0.951057>, <0.064248, 0.302264, 0.951057>, <0.071962, 0.338554, 0.938191> }
triangle { <0.071962, 0.338554, 0.938191>, <0.089582, 0.334323, 0.938191>, <0.079979, 0.298487, 0.951057> }
triangle { <0.089582, 0.334323, 0.938191>, <0.071962, 0.338554, 0.938191>, <0.079564, 0.374321, 0.923880> }
triangle { <0.079564, 0.374321, 0.923880>, <0.099046, 0.369644, 0.923880>, <0.089582, 0.334323, 0.938191> }
triangle { <0.099046, 0.369644, 0.923880>, <0.079564, 0.374321, 0.923880>, <0.087044, 0.409511, 0.908143> }
triangle { <0.087044, 0.409511, 0.908143>, <0.108357, 0.404394, 0.908143>, <0.099046, 0.369644, 0.923880> }
triangle { <0.108357, 0.404394, 0.908143>, <0.087044, 0.409511, 0.908143>, <0.094390, 0.444070, 0.891007> }
triangle { <0.094390, 0.444070, 0.891007>, <0.117501, 0.438521, 0.891007>, <0.108357, 0.404394, 0.908143> }
triangle { <0.117501, 0.438521, 0.891007>, <0.094390, 0.444070, 0.891007>, <0.101590, 0.477944, 0.872496> }
triangle { <0.101590, 0.477944, 0.872496>, <0.126464, 0.471972, 0.872496>, <0.117501, 0.438521, 0.891007> }
triangle { <0.126464, 0.471972, 0.872496>, <0.101590, 0.477944, 0.872496>, <0.108634, 0.511081, 0.852640> }
triangle { <0.108634, 0.511081, 0.852640>, <0.135233, 0.504695, 0.852640>, <0.126464, 0.471972, 0.872496> }
triangle { <0.135233, 0.504695, 0.852640>, <0.108634, 0.511081, 0.852640>, <0.115510, 0.543430, 0.831470> }
triangle { <0.115510, 0.543430, 0.831470>, <0.143792, 0.536640, 0.831470>, <0.135233, 0.504695, 0.852640> }
triangle { <0.143792, 0.536640, 0.831470>, <0.115510, 0.543430, 0.831470>, <0.122207, 0.574941, 0.809017> }
triangle { <0.122207, 0.574941, 0.809017>, <0.152130, 0.567757, 0.809017>, <0.143792, 0.536640, 0.831470> }
triangle { <0.152130, 0.567757, 0.809017>, <0.122207, 0.574941, 0.809017>, <0.128717, 0.605565, 0.785317> }
triangle { <0.128717, 0.605565, 0.785317>, <0.160233, 0.597999, 0.785317>, <0.152130, 0.567757, 0.809017> }
triangle { <0.160233, 0.597999, 0.785317>, <0.128717, 0.605565, 0.785317>, <0.135028, 0.635256, 0.760406> }
triangle { <0.135028, 0.635256, 0.760406>, <0.168090, 0.627319, 0.760406>, <0.160233, 0.597999, 0.785317> }
triangle { <0.168090, 0.627319, 0.760406>, <0.135028, 0.635256, 0.760406>, <0.141131, 0.663967, 0.734323> }
triangle { <0.141131, 0.663967, 0.734323>, <0.175687, 0.655671, 0.734323>, <0.168090, 0.627319, 0.760406> }
triangle { <0.175687, 0.655671, 0.734323>, <0.141131, 0.663967, 0.734323>, <0.147016, 0.691655, 0.707107> }
triangle { <0.147016, 0.691655, 0.707107>, <0.183013, 0.683013, 0.707107>, <0.175687, 0.655671, 0.734323> }
triangle { <0.183013, 0.683013, 0.707107>, <0.147016, 0.691655, 0.707107>, <0.152674, 0.718276, 0.678801> }
triangle { <0.152674, 0.718276, 0.678801>, <0.190057, 0.709301, 0.678801>, <0.183013, 0.683013, 0.707107> }
triangle { <0.190057, 0.709301, 0.678801>, <0.152674, 0.718276, 0.678801>, <0.158097, 0.743789, 0.649448> }
triangle { <0.158097, 0.743789, 0.649448>, <0.196808, 0.734496, 0.649448>, <0.190057, 0.709301, 0.678801> }
triangle { <0.196808, 0.734496, 0.649448>, <0.158097, 0.743789, 0.649448>, <0.163277, 0.768156, 0.619094> }
triangle { <0.163277, 0.768156, 0.619094>, <0.203255, 0.758558, 0.619094>, <0.196808, 0.734496, 0.649448> }
triangle { <0.203255, 0.758558, 0.619094>, <0.163277, 0.768156, 0.619094>, <0.168204, 0.791338, 0.587785> }
triangle { <0.168204, 0.791338, 0.587785>, <0.209389, 0.781450, 0.587785>, <0.203255, 0.758558, 0.619094> }
triangle { <0.209389, 0.781450, 0.587785>, <0.168204, 0.791338, 0.587785>, <0.172872, 0.813300, 0.555570> }
triangle { <0.172872, 0.813300, 0.555570>, <0.215200, 0.803138, 0.555570>, <0.209389, 0.781450, 0.587785> }
triangle { <0.215200, 0.803138, 0.555570>, <0.172872, 0.813300, 0.555570>, <0.177274, 0.834008, 0.522499> }
triangle { <0.177274, 0.834008, 0.522499>, <0.220680, 0.823587, 0.522499>, <0.215200, 0.803138, 0.555570> }
triangle { <0.220680, 0.823587, 0.522499>, <0.177274, 0.834008, 0.522499>, <0.181402, 0.853430, 0.488621> }
triangle { <0.181402, 0.853430, 0.488621>, <0.225819, 0.842766, 0.488621>, <0.220680, 0.823587, 0.522499> }
triangle { <0.225819, 0.842766, 0.488621>, <0.181402, 0.853430, 0.488621>, <0.185251, 0.871536, 0.453990> }
triangle { <0.185251, 0.871536, 0.453990>, <0.230609, 0.860646, 0.453990>, <0.225819, 0.842766, 0.488621> }
triangle { <0.230609, 0.860646, 0.453990>, <0.185251, 0.871536, 0.453990>, <0.188814, 0.888298, 0.418660> }
triangle { <0.188814, 0.888298, 0.418660>, <0.235045, 0.877199, 0.418660>, <0.230609, 0.860646, 0.453990> }
triangle { <0.235045, 0.877199, 0.418660>, <0.188814, 0.888298, 0.418660>, <0.192085, 0.903691, 0.382683> }
triangle { <0.192085, 0.903691, 0.382683>, <0.239118, 0.892399, 0.382683>, <0.235045, 0.877199, 0.418660> }
triangle { <0.239118, 0.892399, 0.382683>, <0.192085, 0.903691, 0.382683>, <0.195061, 0.917690, 0.346117> }
triangle { <0.195061, 0.917690, 0.346117>, <0.242822, 0.906223, 0.346117>, <0.239118, 0.892399, 0.382683> }
triangle { <0.242822, 0.906223, 0.346117>, <0.195061, 0.917690, 0.346117>, <0.197736, 0.930274, 0.309017> }
triangle { <0.197736, 0.930274, 0.309017>, <0.246152, 0.918650, 0.309017>, <0.242822, 0.906223, 0.346117> }
triangle { <0.246152, 0.918650, 0.309017>, <0.197736, 0.930274, 0.309017>, <0.200106, 0.941423, 0.271440> }
triangle { <0.200106, 0.941423, 0.271440>, <0.249102, 0.929660, 0.271440>, <0.246152, 0.918650, 0.309017> }
triangle { <0.249102, 0.929660, 0.271440>, <0.200106, 0.941423, 0.271440>, <0.202167, 0.951121, 0.233445> }
triangle { <0.202167, 0.951121, 0.233445>, <0.251668, 0.939237, 0.233445>, <0.249102, 0.929660, 0.271440> }
triangle { <0.251668, 0.939237, 0.233445>, <0.202167, 0.951121, 0.233445>, <0.203917, 0.959353, 0.195090> }
triangle { <0.203917, 0.959353, 0.195090>, <0.253846, 0.947366, 0.195090>, <0.251668, 0.939237, 0.233445> }
triangle { <0.253846, 0.947366, 0.195090>, <0.203917, 0.959353, 0.195090>, <0.205352, 0.966105, 0.156434> }
triangle { <0.205352, 0.966105, 0.156434>, <0.255633, 0.954034, 0.156434>, <0.253846, 0.947366, 0.195090> }
triangle { <0.255633, 0.954034, 0.156434>, <0.205352, 0.966105, 0.156434>, <0.206471, 0.971368, 0.117537> }
triangle { <0.206471, 0.971368, 0.117537>, <0.257025, 0.959230, 0.117537>, <0.255633, 0.954034, 0.156434> }
triangle { <0.257025, 0.959230, 0.117537>, <0.206471, 0.971368, 0.117537>, <0.207271, 0.975132, 0.078459> }
triangle { <0.207271, 0.975132, 0.078459>, <0.258021, 0.962948, 0.078459>, <0.257025, 0.959230, 0.117537> }
triangle { <0.258021, 0.962948, 0.078459>, <0.207271, 0.975132, 0.078459>, <0.207751, 0.977393, 0.039260> }
triangle { <0.207751, 0.977393, 0.039260>, <0.258620, 0.965181, 0.039260>, <0.258021, 0.962948, 0.078459> }
triangle { <0.258620, 0.965181, 0.039260>, <0.207751, 0.977393, 0.039260>, <0.207912, 0.978148, -0.000000> }
triangle { <0.207912, 0.978148, -0.000000>, <0.258819, 0.965926, -0.000000>, <0.258620, 0.965181, 0.039260> }
triangle { <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.006142, 0.038776, 0.999229> }
triangle { <0.006142, 0.038776, 0.999229>, <0.008163, 0.038402, 0.999229>, <0.000000, 0.000000, 1.000000> }
triangle { <0.008163, 0.038402, 0.999229>, <0.006142, 0.038776, 0.999229>, <0.012274, 0.077493, 0.996917> }
triangle { <0.012274, 0.077493, 0.996917>, <0.016313, 0.076745, 0.996917>, <0.008163, 0.038402, 0.999229> }
triangle { <0.016313, 0.076745, 0.996917>, <0.012274, 0.077493, 0.996917>, <0.018387, 0.116090, 0.993068> }
triangle { <0.018387, 0.116090, 0.993068>, <0.024437, 0.114969, 0.993068>, <0.016313, 0.076745, 0.996917> }
triangle { <0.024437, 0.114969, 0.993068>, <0.018387, 0.116090, 0.993068>, <0.024472, 0.154508, 0.987688> }
triangle { <0.024472, 0.154508, 0.987688>, <0.032525, 0.153016, 0.987688>, <0.024437, 0.114969, 0.993068> }
triangle { <0.032525, 0.153016, 0.987688>, <0.024472, 0.154508, 0.987688>, <0.030519, 0.192688, 0.980785> }
triangle { <0.030519, 0.192688, 0.980785>, <0.040562, 0.190827, 0.980785>, <0.032525, 0.153016, 0.987688> }
triangle { <0.040562, 0.190827, 0.980785>, <0.030519, 0.192688, 0.980785>, <0.036519, 0.230571, 0.972370> }
triangle { <0.036519, 0.230571, 0.972370>, <0.048536, 0.228344, 0.972370>, <0.040562, 0.190827, 0.980785> }
triangle { <0.048536, 0.228344, 0.972370>, <0.036519, 0.230571, 0.972370>, <0.042463, 0.268099, 0.962455> }
triangle { <0.042463, 0.268099, 0.962455>, <0.056436, 0.265509, 0.962455>, <0.048536, 0.228344, 0.972370> }
triangle { <0.056436, 0.265509, 0.962455>, <0.042463, 0.268099, 0.962455>, <0.048341, 0.305212, 0.951057> }
triangle { <0.048341, 0.305212, 0.951057>, <0.064248, 0.302264, 0.951057>, <0.056436, 0.265509, 0.962455> }
triangle { <0.064248, 0.302264, 0.951057>, <0.048341, 0.305212, 0.951057>, <0.054145, 0.341856, 0.938191> }
triangle { <0.054145, 0.341856, 0.938191>, <0.071962, 0.338554, 0.938191>, <0.064248, 0.302264, 0.951057> }
triangle { <0.071962, 0.338554, 0.938191>, <0.054145, 0.341856, 0.938191>, <0.059865, 0.377972, 0.923880> }
triangle { <0.059865, 0.377972, 0.923880>, <0.079564, 0.374321, 0.923880>, <0.071962, 0.338554, 0.938191> }
triangle { <0.079564, 0.374321, 0.923880>, <0.059865, 0.377972, 0.923880>, <0.065493, 0.413505, 0.908143> }
triangle { <0.065493, 0.413505, 0.908143>, <0.087044, 0.409511, 0.908143>, <0.079564, 0.374321, 0.923880> }
triangle { <0.087044, 0.409511, 0.908143>, <0.065493, 0.413505, 0.908143>, <0.071020, 0.448401, 0.891007> }
triangle { <0.071020, 0.448401, 0.891007>, <0.094390, 0.444070, 0.891007>, <0.087044, 0.409511, 0.908143> }
triangle { <0.094390, 0.444070, 0.891007>, <0.071020, 0.448401, 0.891007>, <0.076437, 0.482606, 0.872496> }
triangle { <0.076437, 0.482606, 0.872496>, <0.101590, 0.477944, 0.872496>, <0.094390, 0.444070, 0.891007> }
triangle { <0.101590, 0.477944, 0.872496>, <0.076437, 0.482606, 0.872496>, <0.081737, 0.516066, 0.852640> }
triangle { <0.081737, 0.516066, 0.852640>, <0.108634, 0.511081, 0.852640>, <0.101590, 0.477944, 0.872496> }
triangle { <0.108634, 0.511081, 0.852640>, <0.081737, 0.516066, 0.852640>, <0.086910, 0.548730, 0.831470> }
triangle { <0.086910, 0.548730, 0.831470>, <0.115510, 0.543430, 0.831470>, <0.108634, 0.511081, 0.852640> }
triangle { <0.115510, 0.543430, 0.831470>, <0.086910, 0.548730, 0.831470>, <0.091950, 0.580549, 0.809017> }
triangle { <0.091950, 0.580549, 0.809017>, <0.122207, 0.574941, 0.809017>, <0.115510, 0.543430, 0.831470> }
triangle { <0.122207, 0.574941, 0.809017>, <0.091950, 0.580549, 0.809017>, <0.096848, 0.611472, 0.785317> }
triangle { <0.096848, 0.611472, 0.785317>, <0.128717, 0.605565, 0.785317>, <0.122207, 0.574941, 0.809017> }
triangle { <0.128717, 0.605565, 0.785317>, <0.096848, 0.611472, 0.785317>, <0.101596, 0.641452, 0.760406> }
triangle { <0.101596, 0.641452, 0.760406>, <0.135028, 0.635256, 0.760406>, <0.128717, 0.605565, 0.785317> }
triangle { <0.135028, 0.635256, 0.760406>, <0.101596, 0.641452, 0.760406>, <0.106188, 0.670444, 0.734323> }
triangle { <0.106188, 0.670444, 0.734323>, <0.141131, 0.663967, 0.734323>, <0.135028, 0.635256, 0.760406> }
triangle { <0.141131, 0.663967, 0.734323>, <0.106188, 0.670444, 0.734323>, <0.110616, 0.698401, 0.707107> }
triangle { <0.110616, 0.698401, 0.707107>, <0.147016, 0.691655, 0.707107>, <0.141131, 0.663967, 0.734323> }
triangle { <0.147016, 0.691655, 0.707107>, <0.110616, 0.698401, 0.707107>, <0.114873, 0.725282, 0.678801> }
triangle { <0.114873, 0.725282, 0.678801>, <0.152674, 0.718276, 0.678801>, <0.147016, 0.691655, 0.707107> }
triangle { <0.152674, 0.718276, 0.678801>, <0.114873, 0.725282, 0.678801>, <0.118954, 0.751044, 0.649448> }
triangle { <0.118954, 0.751044, 0.649448>, <0.158097, 0.743789, 0.649448>, <0.152674, 0.718276, 0.678801> }
triangle { <0.158097, 0.743789, 0.649448>, <0.118954, 0.751044, 0.649448>, <0.122851, 0.775648, 0.619094> }
triangle { <0.122851, 0.775648, 0.619094>, <0.163277, 0.768156, 0.619094>, <0.158097, 0.743789, 0.649448> }
triangle { <0.163277, 0.768156, 0.619094>, <0.122851, 0.775648, 0.619094>, <0.126558, 0.799057, 0.587785> }
triangle { <0.126558, 0.799057, 0.587785>, <0.168204, 0.791338, 0.587785>, <0.163277, 0.768156, 0.619094> }
triangle { <0.168204, 0.791338, 0.587785>, <0.126558, 0.799057, 0.587785>, <0.130071, 0.821233, 0.555570> }
triangle { <0.130071, 0.821233, 0.555570>, <0.172872, 0.813300, 0.555570>, <0.168204, 0.791338, 0.587785> }
triangle { <0.172872, 0.813300, 0.555570>, <0.130071, 0.821233, 0.555570>, <0.133382, 0.842143, 0.522499> }
triangle { <0.133382, 0.842143, 0.522499>, <0.177274, 0.834008, 0.522499>, <0.172872, 0.813300, 0.555570> }
triangle { <0.177274, 0.834008, 0.522499>, <0.133382, 0.842143, 0.522499>, <0.136488, 0.861754, 0.488621> }
triangle { <0.136488, 0.861754, 0.488621>, <0.181402, 0.853430, 0.488621>, <0.177274, 0.834008, 0.522499> }
triangle { <0.181402, 0.853430, 0.488621>, <0.136488, 0.861754, 0.488621>, <0.139384, 0.880037, 0.453990> }
triangle { <0.139384, 0.880037, 0.453990>, <0.185251, 0.871536, 0.453990>, <0.181402, 0.853430, 0.488621> }
triangle { <0.185251, 0.871536, 0.453990>, <0.139384, 0.880037, 0.453990>, <0.142065, 0.896962, 0.418660> }
triangle { <0.142065, 0.896962, 0.418660>, <0.188814, 0.888298, 0.418660>, <0.185251, 0.871536, 0.453990> }
triangle { <0.188814, 0.888298, 0.418660>, <0.142065, 0.896962, 0.418660>, <0.144527, 0.912505, 0.382683> }
triangle { <0.144527, 0.912505, 0.382683>, <0.192085, 0.903691, 0.382683>, <0.188814, 0.888298, 0.418660> }
triangle { <0.192085, 0.903691, 0.382683>, <0.144527, 0.912505, 0.382683>, <0.146765, 0.926641, 0.346117> }
triangle { <0.146765, 0.926641, 0.346117>, <0.195061, 0.917690, 0.346117>, <0.192085, 0.903691, 0.382683> }
triangle { <0.195061, 0.917690, 0.346117>, <0.146765, 0.926641, 0.346117>, <0.148778, 0.939347, 0.309017> }
triangle { <0.148778, 0.939347, 0.309017>, <0.197736, 0.930274, 0.309017>, <0.195061, 0.917690, 0.346117> }
triangle { <0.197736, 0.930274, 0.309017>, <0.148778, 0.939347, 0.309017>, <0.150561, 0.950606, 0.271440> }
triangle { <0.150561, 0.950606, 0.271440>, <0.200106, 0.941423, 0.271440>, <0.197736, 0.930274, 0.309017> }
triangle { <0.200106, 0.941423, 0.271440>, <0.150561, 0.950606, 0.271440>, <0.152112, 0.960398, 0.233445> }
triangle { <0.152112, 0.960398, 0.233445>, <0.202167, 0.951121, 0.233445>, <0.200106, 0.941423, 0.271440> }
triangle { <0.202167, 0.951121, 0.233445>, <0.152112, 0.960398, 0.233445>, <0.153429, 0.968710, 0.195090> }
triangle { <0.153429, 0.968710, 0.195090>, <0.203917, 0.959353, 0.195090>, <0.202167, 0.951121, 0.233445> }
triangle { <0.203917, 0.959353, 0.195090>, <0.153429, 0.968710, 0.195090>, <0.154508, 0.975528, 0.156434> }
triangle { <0.154508, 0.975528, 0.156434>, <0.205352, 0.966105, 0.156434>, <0.203917, 0.959353, 0.195090> }
triangle { <0.205352, 0.966105, 0.156434>, <0.154508, 0.975528, 0.156434>, <0.155350, 0.980842, 0.117537> }
triangle { <0.155350, 0.980842, 0.117537>, <0.206471, 0.971368, 0.117537>, <0.205352, 0.966105, 0.156434> }
triangle { <0.206471, 0.971368, 0.117537>, <0.155350, 0.980842, 0.117537>, <0.155952, 0.984644, 0.078459> }
triangle { <0.155952, 0.984644, 0.078459>, <0.207271, 0.975132, 0.078459>, <0.206471, 0.971368, 0.117537> }
triangle { <0.207271, 0.975132, 0.078459>, <0.155952, 0.984644, 0.078459>, <0.156314, 0.986927, 0.039260> }
triangle { <0.156314, 0.986927, 0.039260>, <0.207751, 0.977393, 0.039260>, <0.207271, 0.975132, 0.078459> }
triangle { <0.207751, 0.977393, 0.039260>, <0.156314, 0.986927, 0.039260>, <0.156434, 0.987688, -0.000000> }
triangle { <0.156434, 0.987688, -0.000000>, <0.207912, 0.978148, -0.000000>, <0.207751, 0.977393, 0.039260> }
triangle { <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.004104, 0.039045, 0.999229> }
triangle { <0.004104, 0.039045, 0.999229>, <0.006142, 0.038776, 0.999229>, <0.000000, 0.000000, 1.000000> }
triangle { <0.006142, 0.038776, 0.999229>, <0.004104, 0.039045, 0.999229>, <0.008201, 0.078029, 0.996917> }
triangle { <0.008201, 0.078029, 0.996917>, <0.012274, 0.077493, 0.996917>, <0.006142, 0.038776, 0.999229> }
triangle { <0.012274, 0.077493, 0.996917>, <0.008201, 0.078029, 0.996917>, <0.012286, 0.116894, 0.993068> }
triangle { <0.012286, 0.116894, 0.993068>, <0.018387, 0.116090, 0.993068>, <0.012274, 0.077493, 0.996917> }
triangle { <0.018387, 0.116090, 0.993068>, <0.012286, 0.116894, 0.993068>, <0.016352, 0.155578, 0.987688> }
triangle { <0.016352, 0.155578, 0.987688>, <0.024472, 0.154508, 0.987688>, <0.018387, 0.116090, 0.993068> }
triangle { <0.024472, 0.154508, 0.987688>, <0.016352, 0.155578, 0.987688>, <0.020392, 0.194022, 0.980785> }
triangle { <0.020392, 0.194022, 0.980785>, <0.030519, 0.192688, 0.980785>, <0.024472, 0.154508, 0.987688> }
triangle { <0.030519, 0.192688, 0.980785>, <0.020392, 0.194022, 0.980785>, <0.024402, 0.232167, 0.972370> }
triangle { <0.024402, 0.232167, 0.972370>, <0.036519, 0.230571, 0.972370>, <0.030519, 0.192688, 0.980785> }
triangle { <0.036519, 0.230571, 0.972370>, <0.024402, 0.232167, 0.972370>, <0.028373, 0.269953, 0.962455> }
triangle { <0.028373, 0.269953, 0.962455>, <0.042463, 0.268099, 0.962455>, <0.036519, 0.230571, 0.972370> }
triangle { <0.042463, 0.268099, 0.962455>, <0.028373, 0.269953, 0.962455>, <0.032301, 0.307324, 0.951057> }
triangle { <0.032301, 0.307324, 0.951057>, <0.048341, 0.305212, 0.951057>, <0.042463, 0.268099, 0.962455> }
triangle { <0.048341, 0.305212, 0.951057>, <0.032301, 0.307324, 0.951057>, <0.036179, 0.344221, 0.938191> }
triangle { <0.036179, 0.344221, 0.938191>, <0.054145, 0.341856, 0.938191>, <0.048341, 0.305212, 0.951057> }
triangle { <0.054145, 0.341856, 0.938191>, <0.036179, 0.344221, 0.938191>, <0.040001, 0.380587, 0.923880> }
triangle { <0.040001, 0.380587, 0.923880>, <0.059865, 0.377972, 0.923880>, <0.054145, 0.341856, 0.938191> }
triangle { <0.059865, 0.377972, 0.923880>, <0.040001, 0.380587, 0.923880>, <0.043762, 0.416366, 0.908143> }
triangle { <0.043762, 0.416366, 0.908143>, <0.065493, 0.413505, 0.908143>, <0.059865, 0.377972, 0.923880> }
triangle { <0.065493, 0.413505, 0.908143>, <0.043762, 0.416366, 0.908143>, <0.047455, 0.451503, 0.891007> }
triangle { <0.047455, 0.451503, 0.891007>, <0.071020, 0.448401, 0.891007>, <0.065493, 0.413505, 0.908143> }
triangle { <0.071020, 0.448401, 0.891007>, <0.047455, 0.451503, 0.891007>, <0.051075, 0.485945, 0.872496> }
triangle { <0.051075, 0.485945, 0.872496>, <0.076437, 0.482606, 0.872496>, <0.071020, 0.448401, 0.891007> }
triangle { <0.076437, 0.482606, 0.872496>, <0.051075, 0.485945, 0.872496>, <0.054616, 0.519636, 0.852640> }
triangle { <0.054616, 0.519636, 0.852640>, <0.081737, 0.516066, 0.852640>, <0.076437, 0.482606, 0.872496> }
triangle { <0.081737, 0.516066, 0.852640>, <0.054616, 0.519636, 0.852640>, <0.058073, 0.552527, 0.831470> }
triangle { <0.058073, 0.552527, 0.831470>, <0.086910, 0.548730, 0.831470>, <0.081737, 0.516066, 0.852640> }
triangle { <0.086910, 0.548730, 0.831470>, <0.058073, 0.552527, 0.831470>, <0.061440, 0.584565, 0.809017> }
triangle { <0.061440, 0.584565, 0.809017>, <0.091950, 0.580549, 0.809017>, <0.086910, 0.548730, 0.831470> }
triangle { <0.091950, 0.580549, 0.809017>, <0.061440, 0.584565, 0.809017>, <0.064713, 0.615702, 0.785317> }
triangle { <0.064713, 0.615702, 0.785317>, <0.096848, 0.611472, 0.785317>, <0.091950, 0.580549, 0.809017> }
triangle { <0.096848, 0.611472, 0.785317>, <0.064713, 0.615702, 0.785317>, <0.067886, 0.645890, 0.760406> }
triangle { <0.067886, 0.645890, 0.760406>, <0.101596, 0.641452, 0.760406>, <0.096848, 0.611472, 0.785317> }
triangle { <0.101596, 0.641452, 0.760406>, <0.067886, 0.645890, 0.760406>, <0.070954, 0.675082, 0.734323> }
triangle { <0.070954, 0.675082, 0.734323>, <0.106188, 0.670444, 0.734323>, <0.101596, 0.641452, 0.760406> }
triangle { <0.106188, 0.670444, 0.734323>, <0.070954, 0.675082, 0.734323>, <0.073913, 0.703233, 0.707107> }
triangle { <0.073913, 0.703233, 0.707107>, <0.110616, 0.698401, 0.707107>, <0.106188, 0.670444, 0.734323> }
triangle { <0.110616, 0.698401, 0.707107>, <0.073913, 0.703233, 0.707107>, <0.076758, 0.730300, 0.678801> }
triangle { <0.076758, 0.730300, 0.678801>, <0.114873, 0.725282, 0.678801>, <0.110616, 0.698401, 0.707107> }
triangle { <0.114873, 0.725282, 0.678801>, <0.076758, 0.730300, 0.678801>, <0.079484, 0.756240, 0.649448> }
triangle { <0.079484, 0.756240, 0.649448>, <0.118954, 0.751044, 0.649448>, <0.114873, 0.725282, 0.678801> }
triangle { <0.118954, 0.751044, 0.649448>, <0.079484, 0.756240, 0.649448>, <0.082088, 0.781015, 0.619094> }
triangle { <0.082088, 0.781015, 0.619094>, <0.122851, 0.775648, 0.619094>, <0.118954, 0.751044, 0.649448> }
triangle { <0.122851, 0.775648, 0.619094>, <0.082088, 0.781015, 0.619094>, <0.084565, 0.804585, 0.587785> }
triangle { <0.084565, 0.804585, 0.587785>, <0.126558, 0.799057, 0.587785>, <0.122851, 0.775648, 0.619094> }
triangle { <0.126558, 0.799057, 0.587785>, <0.084565, 0.804585, 0.587785>, <0.086912, 0.826915, 0.555570> }
triangle { <0.086912, 0.826915, 0.555570>, <0.130071, 0.821233, 0.555570>, <0.126558, 0.799057, 0.587785> }
triangle { <0.130071, 0.821233, 0.555570>, <0.086912, 0.826915, 0.555570>, <0.089125, 0.847969, 0.522499> }
triangle { <0.089125, 0.847969, 0.522499>, <0.133382, 0.842143, 0.522499>, <0.130071, 0.821233, 0.555570> }
triangle { <0.133382, 0.842143, 0.522499>, <0.089125, 0.847969, 0.522499>, <0.091201, 0.867716, 0.488621> }
triangle { <0.091201, 0.867716, 0.488621>, <0.136488, 0.861754, 0.488621>, <0.133382, 0.842143, 0.522499> }
triangle { <0.136488, 0.861754, 0.488621>, <0.091201, 0.867716, 0.488621>, <0.093136, 0.886125, 0.453990> }
triangle { <0.093136, 0.886125, 0.453990>, <0.139384, 0.880037, 0.453990>, <0.136488, 0.861754, 0.488621> }
triangle { <0.139384, 0.880037, 0.453990>, <0.093136, 0.886125, 0.453990>, <0.094927, 0.903168, 0.418660> }
triangle { <0.094927, 0.903168, 0.418660>, <0.142065, 0.896962, 0.418660>, <0.139384, 0.880037, 0.453990> }
triangle { <0.142065, 0.896962, 0.418660>, <0.094927, 0.903168, 0.418660>, <0.096572, 0.918818, 0.382683> }
triangle { <0.096572, 0.918818, 0.382683>, <0.144527, 0.912505, 0.382683>, <0.142065, 0.896962, 0.418660> }
triangle { <0.144527, 0.912505, 0.382683>, <0.096572, 0.918818, 0.382683>, <0.098068, 0.933052, 0.346117> }
triangle { <0.098068, 0.933052, 0.346117>, <0.146765, 0.926641, 0.346117>, <0.144527, 0.912505, 0.382683> }
triangle { <0.146765, 0.926641, 0.346117>, <0.098068, 0.933052, 0.346117>, <0.099412, 0.945847, 0.309017> }
triangle { <0.099412, 0.945847, 0.309017>, <0.148778, 0.939347, 0.309017>, <0.146765, 0.926641, 0.346117> }
triangle { <0.148778, 0.939347, 0.309017>, <0.099412, 0.945847, 0.309017>, <0.100604, 0.957183, 0.271440> }
triangle { <0.100604, 0.957183, 0.271440>, <0.150561, 0.950606, 0.271440>, <0.148778, 0.939347, 0.309017> }
triangle { <0.150561, 0.950606, 0.271440>, <0.100604, 0.957183, 0.271440>, <0.101640, 0.967043, 0.233445> }
triangle { <0.101640, 0.967043, 0.233445>, <0.152112, 0.960398, 0.233445>, <0.150561, 0.950606, 0.271440> }
triangle { <0.152112, 0.960398, 0.233445>, <0.101640, 0.967043, 0.233445>, <0.102520, 0.975412, 0.195090> }
triangle { <0.102520, 0.975412, 0.195090>, <0.153429, 0.968710, 0.195090>, <0.152112, 0.960398, 0.233445> }
triangle { <0.153429, 0.968710, 0.195090>, <0.102520, 0.975412, 0.195090>, <0.103242, 0.982278, 0.156434> }
triangle { <0.103242, 0.982278, 0.156434>, <0.154508, 0.975528, 0.156434>, <0.153429, 0.968710, 0.195090> }
triangle { <0.154508, 0.975528, 0.156434>, <0.103242, 0.982278, 0.156434>, <0.103804, 0.987628, 0.117537> }
triangle { <0.103804, 0.987628, 0.117537>, <0.155350, 0.980842, 0.117537>, <0.154508, 0.975528, 0.156434> }
triangle { <0.155350, 0.980842, 0.117537>, <0.103804, 0.987628, 0.117537>, <0.104206, 0.991456, 0.078459> }
triangle { <0.104206, 0.991456, 0.078459>, <0.155952, 0.984644, 0.078459>, <0.155350, 0.980842, 0.117537> }
triangle { <0.155952, 0.984644, 0.078459>, <0.104206, 0.991456, 0.078459>, <0.104448, 0.993755, 0.039260> }
triangle { <0.104448, 0.993755, 0.039260>, <0.156314, 0.986927, 0.039260>, <0.155952, 0.984644, 0.078459> }
triangle { <0.156314, 0.986927, 0.039260>, <0.104448, 0.993755, 0.039260>, <0.104528, 0.994522, -0.000000> }
triangle { <0.104528, 0.994522, -0.000000>, <0.156434, 0.987688, -0.000000>, <0.156314, 0.986927, 0.039260> }
triangle { <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.002055, 0.039206, 0.999229> }
triangle { <0.002055, 0.039206, 0.999229>, <0.004104, 0.039045, 0.999229>, <0.000000, 0.000000, 1.000000> }
triangle { <0.004104, 0.039045, 0.999229>, <0.002055, 0.039206, 0.999229>, <0.004106, 0.078352, 0.996917> }
triangle { <0.004106, 0.078352, 0.996917>, <0.008201, 0.078029, 0.996917>, <0.004104, 0.039045, 0.999229> }
triangle { <0.008201, 0.078029, 0.996917>, <0.004106, 0.078352, 0.996917>, <0.006151, 0.117376, 0.993068> }
triangle { <0.006151, 0.117376, 0.993068>, <0.012286, 0.116894, 0.993068>, <0.008201, 0.078029, 0.996917> }
triangle { <0.012286, 0.116894, 0.993068>, <0.006151, 0.117376, 0.993068>, <0.008187, 0.156220, 0.987688> }
triangle { <0.008187, 0.156220, 0.987688>, <0.016352, 0.155578, 0.987688>, <0.012286, 0.116894, 0.993068> }
triangle { <0.016352, 0.155578, 0.987688>, <0.008187, 0.156220, 0.987688>, <0.010210, 0.194823, 0.980785> }
triangle { <0.010210, 0.194823, 0.980785>, <0.020392, 0.194022, 0.980785>, <0.016352, 0.155578, 0.987688> }
triangle { <0.020392, 0.194022, 0.980785>, <0.010210, 0.194823, 0.980785>, <0.012218, 0.233125, 0.972370> }
triangle { <0.012218, 0.233125, 0.972370>, <0.024402, 0.232167, 0.972370>, <0.020392, 0.194022, 0.980785> }
triangle { <0.024402, 0.232167, 0.972370>, <0.012218, 0.233125, 0.972370>, <0.014206, 0.271068, 0.962455> }
triangle { <0.014206, 0.271068, 0.962455>, <0.028373, 0.269953, 0.962455>, <0.024402, 0.232167, 0.972370> }
triangle { <0.028373, 0.269953, 0.962455>, <0.014206, 0.271068, 0.962455>, <0.016173, 0.308593, 0.951057> }
triangle { <0.016173, 0.308593, 0.951057>, <0.032301, 0.307324, 0.951057>, <0.028373, 0.269953, 0.962455> }
triangle { <0.032301, 0.307324, 0.951057>, <0.016173, 0.308593, 0.951057>, <0.018114, 0.345643, 0.938191> }
triangle { <0.018114, 0.345643, 0.938191>, <0.036179, 0.344221, 0.938191>, <0.032301, 0.307324, 0.951057> }
triangle { <0.036179, 0.344221, 0.938191>, <0.018114, 0.345643, 0.938191>, <0.020028, 0.382159, 0.923880> }
triangle { <0.020028, 0.382159, 0.923880>, <0.040001, 0.380587, 0.923880>, <0.036179, 0.344221, 0.938191> }
triangle { <0.040001, 0.380587, 0.923880>, <0.020028, 0.382159, 0.923880>, <0.021911, 0.418086, 0.908143> }
triangle { <0.021911, 0.418086, 0.908143>, <0.043762, 0.416366, 0.908143>, <0.040001, 0.380587, 0.923880> }
triangle { <0.043762, 0.416366, 0.908143>, <0.021911, 0.418086, 0.908143>, <0.023760, 0.453368, 0.891007> }
triangle { <0.023760, 0.453368, 0.891007>, <0.047455, 0.451503, 0.891007>, <0.043762, 0.416366, 0.908143> }
triangle { <0.047455, 0.451503, 0.891007>, <0.023760, 0.453368, 0.891007>, <0.025572, 0.487952, 0.872496> }
triangle { <0.025572, 0.487952, 0.872496>, <0.051075, 0.485945, 0.872496>, <0.047455, 0.451503, 0.891007> }
triangle { <0.051075, 0.485945, 0.872496>, <0.025572, 0.487952, 0.872496>, <0.027345, 0.521782, 0.852640> }
triangle { <0.027345, 0.521782, 0.852640>, <0.054616, 0.519636, 0.852640>, <0.051075, 0.485945, 0.872496> }
triangle { <0.054616, 0.519636, 0.852640>, <0.027345, 0.521782, 0.852640>, <0.029076, 0.554809, 0.831470> }
triangle { <0.029076, 0.554809, 0.831470>, <0.058073, 0.552527, 0.831470>, <0.054616, 0.519636, 0.852640> }
triangle { <0.058073, 0.552527, 0.831470>, <0.029076, 0.554809, 0.831470>, <0.030762, 0.586980, 0.809017> }
triangle { <0.030762, 0.586980, 0.809017>, <0.061440, 0.584565, 0.809017>, <0.058073, 0.552527, 0.831470> }
triangle { <0.061440, 0.584565, 0.809017>, <0.030762, 0.586980, 0.809017>, <0.032401, 0.618246, 0.785317> }
triangle { <0.032401, 0.618246, 0.785317>, <0.064713, 0.615702, 0.785317>, <0.061440, 0.584565, 0.809017> }
triangle { <0.064713, 0.615702, 0.785317>, <0.032401, 0.618246, 0.785317>, <0.033989, 0.648558, 0.760406> }
triangle { <0.033989, 0.648558, 0.760406>, <0.067886, 0.645890, 0.760406>, <0.064713, 0.615702, 0.785317> }
triangle { <0.067886, 0.645890, 0.760406>, <0.033989, 0.648558, 0.760406>, <0.035526, 0.677870, 0.734323> }
triangle { <0.035526, 0.677870, 0.734323>, <0.070954, 0.675082, 0.734323>, <0.067886, 0.645890, 0.760406> }
triangle { <0.070954, 0.675082, 0.734323>, <0.035526, 0.677870, 0.734323>, <0.037007, 0.706138, 0.707107> }
triangle { <0.037007, 0.706138, 0.707107>, <0.073913, 0.703233, 0.707107>, <0.070954, 0.675082, 0.734323> }
triangle { <0.073913, 0.703233, 0.707107>, <0.037007, 0.706138, 0.707107>, <0.038431, 0.733316, 0.678801> }
triangle { <0.038431, 0.733316, 0.678801>, <0.076758, 0.730300, 0.678801>, <0.073913, 0.703233, 0.707107> }
triangle { <0.076758, 0.730300, 0.678801>, <0.038431, 0.733316, 0.678801>, <0.039797, 0.759364, 0.649448> }
triangle { <0.039797, 0.759364, 0.649448>, <0.079484, 0.756240, 0.649448>, <0.076758, 0.730300, 0.678801> }
triangle { <0.079484, 0.756240, 0.649448>, <0.039797, 0.759364, 0.649448>, <0.041100, 0.784241, 0.619094> }
triangle { <0.041100, 0.784241, 0.619094>, <0.082088, 0.781015, 0.619094>, <0.079484, 0.756240, 0.649448> }
triangle { <0.082088, 0.781015, 0.619094>, <0.041100, 0.784241, 0.619094>, <0.042341, 0.807908, 0.587785> }
triangle { <0.042341, 0.807908, 0.587785>, <0.084565, 0.804585, 0.587785>, <0.082088, 0.781015, 0.619094> }
triangle { <0.084565, 0.804585, 0.587785>, <0.042341, 0.807908, 0.587785>, <0.043516, 0.830330, 0.555570> }
triangle { <0.043516, 0.830330, 0.555570>, <0.086912, 0.826915, 0.555570>, <0.084565, 0.804585, 0.587785> }
triangle { <0.086912, 0.826915, 0.555570>, <0.043516, 0.830330, 0.555570>, <0.044624, 0.851472, 0.522499> }
triangle { <0.044624, 0.851472, 0.522499>, <0.089125, 0.847969, 0.522499>, <0.086912, 0.826915, 0.555570> }
triangle { <0.089125, 0.847969, 0.522499>, <0.044624, 0.851472, 0.522499>, <0.045663, 0.871300, 0.488621> }
triangle { <0.045663, 0.871300, 0.488621>, <0.091201, 0.867716, 0.488621>, <0.089125, 0.847969, 0.522499> }
triangle { <0.091201, 0.867716, 0.488621>, <0.045663, 0.871300, 0.488621>, <0.046632, 0.889785, 0.453990> }
triangle { <0.046632, 0.889785, 0.453990>, <0.093136, 0.886125, 0.453990>, <0.091201, 0.867716, 0.488621> }
triangle { <0.093136, 0.886125, 0.453990>, <0.046632, 0.889785, 0.453990>, <0.047529, 0.906899, 0.418660> }
triangle { <0.047529, 0.906899, 0.418660>, <0.094927, 0.903168, 0.418660>, <0.093136, 0.886125, 0.453990> }
triangle { <0.094927, 0.903168, 0.418660>, <0.047529, 0.906899, 0.418660>, <0.048352, 0.922613, 0.382683> }
triangle { <0.048352, 0.922613, 0.382683>, <0.096572, 0.918818, 0.382683>, <0.094927, 0.903168, 0.418660> }
triangle { <0.096572, 0.918818, 0.382683>, <0.048352, 0.922613, 0.382683>, <0.049101, 0.936906, 0.346117> }
triangle { <0.049101, 0.936906, 0.346117>, <0.098068, 0.933052, 0.346117>, <0.096572, 0.918818, 0.382683> }
triangle { <0.098068, 0.933052, 0.346117>, <0.049101, 0.936906, 0.346117>, <0.049774, 0.949753, 0.309017> }
triangle { <0.049774, 0.949753, 0.309017>, <0.099412, 0.945847, 0.309017>, <0.098068, 0.933052, 0.346117> }
triangle { <0.099412, 0.945847, 0.309017>, <0.049774, 0.949753, 0.309017>, <0.050371, 0.961136, 0.271440> }
triangle { <0.050371, 0.961136, 0.271440>, <0.100604, 0.957183, 0.271440>, <0.099412, 0.945847, 0.309017> }
triangle { <0.100604, 0.957183, 0.271440>, <0.050371, 0.961136, 0.271440>, <0.050890, 0.971037, 0.233445> }
triangle { <0.050890, 0.971037, 0.233445>, <0.101640, 0.967043, 0.233445>, <0.100604, 0.957183, 0.271440> }
triangle { <0.101640, 0.967043, 0.233445>, <0.050890, 0.971037, 0.233445>, <0.051330, 0.979441, 0.195090> }
triangle { <0.051330, 0.979441, 0.195090>, <0.102520, 0.975412, 0.195090>, <0.101640, 0.967043, 0.233445> }
triangle { <0.102520, 0.975412, 0.195090>, <0.051330, 0.979441, 0.195090>, <0.051692, 0.986335, 0.156434> }
triangle { <0.051692, 0.986335, 0.156434>, <0.103242, 0.982278, 0.156434>, <0.102520, 0.975412, 0.195090> }
triangle { <0.103242, 0.982278, 0.156434>, <0.051692, 0.986335, 0.156434>, <0.051973, 0.991707, 0.117537> }
triangle { <0.051973, 0.991707, 0.117537>, <0.103804, 0.987628, 0.117537>, <0.103242, 0.982278, 0.156434> }
triangle { <0.103804, 0.987628, 0.117537>, <0.051973, 0.991707, 0.117537>, <0.052175, 0.995551, 0.078459> }
triangle { <0.052175, 0.995551, 0.078459>, <0.104206, 0.991456, 0.078459>, <0.103804, 0.987628, 0.117537> }
triangle { <0.104206, 0.991456, 0.078459>, <0.052175, 0.995551, 0.078459>, <0.052296, 0.997860, 0.039260> }
triangle { <0.052296, 0.997860, 0.039260>, <0.104448, 0.993755, 0.039260>, <0.104206, 0.991456, 0.078459> }
triangle { <0.104448, 0.993755, 0.039260>, <0.052296, 0.997860, 0.039260>, <0.052336, 0.998630, -0.000000> }
triangle { <0.052336, 0.998630, -0.000000>, <0.104528, 0.994522, -0.000000>, <0.104448, 0.993755, 0.039260> }
triangle { <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <-0.000000, 0.039260, 0.999229> }
triangle { <-0.000000, 0.039260, 0.999229>, <0.002055, 0.039206, 0.999229>, <0.000000, 0.000000, 1.000000> }
triangle { <0.002055, 0.039206, 0.999229>, <-0.000000, 0.039260, 0.999229>, <-0.000000, 0.078459, 0.996917> }
triangle { <-0.000000, 0.078459, 0.996917>, <0.004106, 0.078352, 0.996917>, <0.002055, 0.039206, 0.999229> }
triangle { <0.004106, 0.078352, 0.996917>, <-0.000000, 0.078459, 0.996917>, <-0.000000, 0.117537, 0.993068> }
triangle { <-0.000000, 0.117537, 0.993068>, <0.006151, 0.117376, 0.993068>, <0.004106, 0.078352, 0.996917> }
triangle { <0.006151, 0.117376, 0.993068>, <-0.000000, 0.117537, 0.993068>, <-0.000000, 0.156434, 0.987688> }
triangle { <-0.000000, 0.156434, 0.987688>, <0.008187, 0.156220, 0.987688>, <0.006151, 0.117376, 0.993068> }
triangle { <0.008187, 0.156220, 0.987688>, <-0.000000, 0.156434, 0.987688>, <-0.000000, 0.195090, 0.980785> }
triangle { <-0.000000, 0.195090, 0.980785>, <0.010210, 0.194823, 0.980785>, <0.008187, 0.156220, 0.987688> }
triangle { <0.010210, 0.194823, 0.980785>, <-0.000000, 0.195090, 0.980785>, <-0.000000, 0.233445, 0.972370> }
triangle { <-0.000000, 0.233445, 0.972370>, <0.012218, 0.233125, 0.972370>, <0.010210, 0.194823, 0.980785> }
triangle { <0.012218, 0.233125, 0.972370>, <-0.000000, 0.233445, 0.972370>, <-0.000000, 0.271440, 0.962455> }
triangle { <-0.000000, 0.271440, 0.962455>, <0.014206, 0.271068, 0.962455>, <0.012218, 0.233125, 0.972370> }
triangle { <0.014206, 0.271068, 0.962455>, <-0.000000, 0.271440, 0.962455>, <-0.000000, 0.309017, 0.951057> }
triangle { <-0.000000, 0.309017, 0.951057>, <0.016173, 0.308593, 0.951057>, <0.014206, 0.271068, 0.962455> }
triangle { <0.016173, 0.308593, 0.951057>, <-0.000000, 0.309017, 0.951057>, <-0.000000, 0.346117, 0.938191> }
triangle { <-0.000000, 0.346117, 0.938191>, <0.018114, 0.345643, 0.938191>, <0.016173, 0.308593, 0.951057> }
triangle { <0.018114, 0.345643, 0.938191>, <-0.000000, 0.346117, 0.938191>, <-0.000000, 0.382683, 0.923880> }
triangle { <-0.000000, 0.382683, 0.923880>, <0.020028, 0.382159, 0.923880>, <0.018114, 0.345643, 0.938191> }
triangle { <0.020028, 0.382159, 0.923880>, <-0.000000, 0.382683, 0.923880>, <-0.000000, 0.418660, 0.908143> }
triangle { <-0.000000, 0.418660, 0.908143>, <0.021911, 0.418086, 0.908143>, <0.020028, 0.382159, 0.923880> }
triangle { <0.021911, 0.418086, 0.908143>, <-0.000000, 0.418660, 0.908143>, <-0.000000, 0.453990, 0.891007> }
triangle { <-0.000000, 0.453990, 0.891007>, <0.023760, 0.453368, 0.891007>, <0.021911, 0.418086, 0.908143> }
triangle { <0.023760, 0.453368, 0.891007>, <-0.000000, 0.453990, 0.891007>, <-0.000000, 0.488621, 0.872496> }
triangle { <-0.000000, 0.488621, 0.872496>, <0.025572, 0.487952, 0.872496>, <0.023760, 0.453368, 0.891007> }
triangle { <0.025572, 0.487952, 0.872496>, <-0.000000, 0.488621, 0.872496>, <-0.000000, 0.522499, 0.852640> }
triangle { <-0.000000, 0.522499, 0.852640>, <0.027345, 0.521782, 0.852640>, <0.025572, 0.487952, 0.872496> }
triangle { <0.027345, 0.521782, 0.852640>, <-0.000000, 0.522499, 0.852640>, <-0.000000, 0.555570, 0.831470> }
triangle { <-0.000000, 0.555570, 0.831470>, <0.029076, 0.554809, 0.831470>, <0.027345, 0.521782, 0.852640> }
triangle { <0.029076, 0.554809, 0.831470>, <-0.000000, 0.555570, 0.831470>, <-0.000000, 0.587785, 0.809017> }
triangle { <-0.000000, 0.587785, 0.809017>, <0.030762, 0.586980, 0.809017>, <0.029076, 0.554809, 0.831470> }
triangle { <0.030762, 0.586980, 0.809017>, <-0.000000, 0.587785, 0.809017>, <-0.000000, 0.619094, 0.785317> }
triangle { <-0.000000, 0.619094, 0.785317>, <0.032401, 0.618246, 0.785317>, <0.030762, 0.586980, 0.809017> }
triangle { <0.032401, 0.618246, 0.785317>, <-0.000000, 0.619094, 0.785317>, <-0.000000, 0.649448, 0.760406> }
triangle { <-0.000000, 0.649448, 0.760406>, <0.033989, 0.648558, 0.760406>, <0.032401, 0.618246, 0.785317> }
triangle { <0.033989, 0.648558, 0.760406>, <-0.000000, 0.649448, 0.760406>, <-0.000000, 0.678801, 0.734323> }
triangle { <-0.000000, 0.678801, 0.734323>, <0.035526, 0.677870, 0.734323>, <0.033989, 0.648558, 0.760406> }
triangle { <0.035526, 0.677870, 0.734323>, <-0.000000, 0.678801, 0.734323>, <-0.000000, 0.707107, 0.707107> }
triangle { <-0.000000, 0.707107, 0.707107>, <0.037007, 0.706138, 0.707107>, <0.035526, 0.677870, 0.734323> }
triangle { <0.037007, 0.706138, 0.707107>, <-0.000000, 0.707107, 0.707107>, <-0.000000, 0.734323, 0.678801> }
triangle { <-0.000000, 0.734323, 0.678801>, <0.038431, 0.733316, 0.678801>, <0.037007, 0.706138, 0.707107> }
triangle { <0.038431, 0.733316, 0.678801>, <-0.000000, 0.734323, 0.678801>, <-0.000000, 0.760406, 0.649448> }
triangle { <-0.000000, 0.760406, 0.649448>, <0.039797, 0.759364, 0.649448>, <0.038431, 0.733316, 0.678801> }
triangle { <0.039797, 0.759364, 0.649448>, <-0.000000, 0.760406, 0.649448>, <-0.000000, 0.785317, 0.619094> }
triangle { <-0.000000, 0.785317, 0.619094>, <0.041100, 0.784241, 0.619094>, <0.039797, 0.759364, 0.649448> }
triangle { <0.041100, 0.784241, 0.619094>, <-0.000000, 0.785317, 0.619094>, <-0.000000, 0.809017, 0.587785> }
triangle { <-0.000000, 0.809017, 0.587785>, <0.042341, 0.807908, 0.587785>, <0.041100, 0.784241, 0.619094> }
triangle { <0.042341, 0.807908, 0.587785>, <-0.000000, 0.809017, 0.587785>, <-0.000000, 0.831470, 0.555570> }
triangle { <-0.000000, 0.831470, 0.555570>, <0.043516, 0.830330, 0.555570>, <0.042341, 0.807908, 0.587785> }
triangle { <0.043516, 0.830330, 0.555570>, <-0.000000, 0.831470, 0.555570>, <-0.000000, 0.852640, 0.522499> }
triangle { <-0.000000, 0.852640, 0.522499>, <0.044624, 0.851472, 0.522499>, <0.043516, 0.830330, 0.555570> }
triangle { <0.044624, 0.851472, 0.522499>, <-0.000000, 0.852640, 0.522499>, <-0.000000, 0.872496, 0.488621> }
triangle { <-0.000000, 0.872496, 0.488621>, <0.045663, 0.871300, 0.488621>, <0.044624, 0.851472, 0.522499> }
triangle { <0.045663, 0.871300, 0.488621>, <-0.000000, 0.872496, 0.488621>, <-0.000000, 0.891007, 0.453990> }
triangle { <-0.000000, 0.891007, 0.453990>, <0.046632, 0.889785, 0.453990>, <0.045663, 0.871300, 0.488621> }
triangle { <0.046632, 0.889785, 0.453990>, <-0.000000, 0.891007, 0.453990>, <-0.000000, 0.908143, 0.418660> }
triangle { <-0.000000, 0.908143, 0.418660>, <0.047529, 0.906899, 0.418660>, <0.046632, 0.889785, 0.453990> }
triangle { <0.047529, 0.906899, 0.418660>, <-0.000000, 0.908143, 0.418660>, <-0.000000, 0.923880, 0.382683> }
triangle { <-0.000000, 0.923880, 0.382683>, <0.048352, 0.922613, 0.382683>, <0.047529, 0.906899, 0.418660> }
triangle { <0.048352, 0.922613, 0.382683>, <-0.000000, 0.923880, 0.382683>, <-0.000000, 0.938191, 0.346117> }
triangle { <-0.000000, 0.938191, 0.346117>, <0.049101, 0.936906, 0.346117>, <0.048352, 0.922613, 0.382683> }
triangle { <0.049101, 0.936906, 0.346117>, <-0.000000, 0.938191, 0.346117>, <-0.000000, 0.951057, 0.309017> }
triangle { <-0.000000, 0.951057, 0.309017>, <0.049774, 0.949753, 0.309017>, <0.049101, 0.936906, 0.346117> }
triangle { <0.049774, 0.949753, 0.309017>, <-0.000000, 0.951057, 0.309017>, <-0.000000, 0.962455, 0.271440> }
triangle { <-0.000000, 0.962455, 0.271440>, <0.050371, 0.961136, 0.271440>, <0.049774, 0.949753, 0.309017> }
triangle { <0.050371, 0.961136, 0.271440>, <-0.000000, 0.962455, 0.271440>, <-0.000000, 0.972370, 0.233445> }
triangle { <-0.000000, 0.972370, 0.233445>, <0.050890, 0.971037, 0.233445>, <0.050371, 0.961136, 0.271440> }
triangle { <0.050890, 0.971037, 0.233445>, <-0.000000, 0.972370, 0.233445>, <-0.000000, 0.980785, 0.195090> }
triangle { <-0.000000, 0.980785, 0.195090>, <0.051330, 0.979441, 0.195090>, <0.050890, 0.971037, 0.233445> }
triangle { <0.051330, 0.979441, 0.195090>, <-0.000000, 0.980785, 0.195090>, <-0.000000, 0.987688, 0.156434> }
triangle { <-0.000000, 0.987688, 0.156434>, <0.051692, 0.986335, 0.156434>, <0.051330, 0.979441, 0.195090> }
triangle { <0.051692, 0.986335, 0.156434>, <-0.000000, 0.987688, 0.156434>, <-0.000000, 0.993068, 0.117537> }
triangle { <-0.000000, 0.993068, 0.117537>, <0.051973, 0.991707, 0.117537>, <0.051692, 0.986335, 0.156434> }
triangle { <0.051973, 0.991707, 0.117537>, <-0.000000, 0.993068, 0.117537>, <-0.000000, 0.996917, 0.078459> }
triangle { <-0.000000, 0.996917, 0.078459>, <0.052175, 0.995551, 0.078459>, <0.051973, 0.991707, 0.117537> }
triangle { <0.052175, 0.995551, 0.078459>, <-0.000000, 0.996917, 0.078459>, <-0.000000, 0.999229, 0.039260> }
triangle { <-0.000000, 0.999229, 0.039260>, <0.052296, 0.997860, 0.039260>, <0.052175, 0.995551, 0.078459> }
triangle { <0.052296, 0.997860, 0.039260>, <-0.000000, 0.999229, 0.039260>, <-0.000000, 1.000000, -0.000000> }
triangle { <-0.000000, 1.000000, -0.000000>, <0.052336, 0.998630, -0.000000>, <0.052296, 0.997860, 0.039260> }
triangle { <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <-0.002055, 0.039206, 0.999229> }
triangle { <-0.002055, 0.039206, 0.999229>, <-0.000000, 0.039260, 0.999229>, <0.000000, 0.000000, 1.000000> }
triangle { <-0.000000, 0.039260, 0.999229>, <-0.002055, 0.039206, 0.999229>, <-0.004106, 0.078352, 0.996917> }
triangle { <-0.004106, 0.078352, 0.996917>, <-0.000000, 0.078459, 0.996917>, <-0.000000, 0.039260, 0.999229> }
triangle { <-0.000000, 0.078459, 0.996917>, <-0.004106, 0.078352, 0.996917>, <-0.006151, 0.117376, 0.993068> }
triangle { <-0.006151, 0.117376, 0.993068>, <-0.000000, 0.117537, 0.993068>, <-0.000000, 0.078459, 0.996917> }
triangle { <-0.000000, 0.117537, 0.993068>, <-0.006151, 0.117376, 0.993068>, <-0.008187, 0.156220, 0.987688> }
triangle { <-0.008187, 0.156220, 0.987688>, <-0.000000, 0.156434, 0.987688>, <-0.000000, 0.117537, 0.993068> }
triangle { <-0.000000, 0.156434, 0.987688>, <-0.008187, 0.156220, 0.987688>, <-0.010210, 0.194823, 0.980785> }
triangle { <-0.010210, 0.194823, 0.980785>, <-0.000000, 0.195090, 0.980785>, <-0.000000, 0.156434, 0.987688> }
triangle { <-0.000000, 0.195090, 0.980785>, <-0.010210, 0.194823, 0.980785>, <-0.012218, 0.233125, 0.972370> }
triangle { <-0.012218, 0.233125, 0.972370>, <-0.000000, 0.233445, 0.972370>, <-0.000000, 0.195090, 0.980785> }
triangle { <-0.000000, 0.233445, 0.972370>, <-0.012218, 0.233125, 0.972370>, <-0.014206, 0.271068, 0.962455> }
triangle { <-0.014206, 0.271068, 0.962455>, <-0.000000, 0.271440, 0.962455>, <-0.000000, 0.233445, 0.972370> }
triangle { <-0.000000, 0.271440, 0.962455>, <-0.014206, 0.271068, 0.962455>, <-0.016173, 0.308593, 0.951057> }
triangle { <-0.016173, 0.308593, 0.951057>, <-0.000000, 0.309017, 0.951057>, <-0.000000, 0.271440, 0.962455> }
triangle { <-0.000000, 0.309017, 0.951057>, <-0.016173, 0.308593, 0.951057>, <-0.018114, 0.345643, 0.938191> }
triangle { <-0.018114, 0.345643, 0.938191>, <-0.000000, 0.346117, 0.938191>, <-0.000000, 0.309017, 0.951057> }
triangle { <-0.000000, 0.346117, 0.938191>, <-0.018114, 0.345643, 0.938191>, <-0.020028, 0.382159, 0.923880> }
triangle { <-0.020028, 0.382159, 0.923880>, <-0.000000, 0.382683, 0.923880>, <-0.000000, 0.346117, 0.938191> }
triangle { <-0.000000, 0.382683, 0.923880>, <-0.020028, 0.382159, 0.923880>, <-0.021911, 0.418086, 0.908143> }
triangle { <-0.021911, 0.418086, 0.908143>, <-0.000000, 0.418660, 0.908143>, <-0.000000, 0.382683, 0.923880> }
triangle { <-0.000000, 0.418660, 0.908143>, <-0.021911, 0.418086, 0.908143>, <-0.023760, 0.453368, 0.891007> }
triangle { <-0.023760, 0.453368, 0.891007>, <-0.000000, 0.453990, 0.891007>, <-0.000000, 0.418660, 0.908143> }
triangle { <-0.000000, 0.453990, 0.891007>, <-0.023760, 0.453368, 0.891007>, <-0.025572, 0.487952, 0.872496> }
triangle { <-0.025572, 0.487952, 0.872496>, <-0.000000, 0.488621, 0.872496>, <-0.000000, 0.453990, 0.891007> }
triangle { <-0.000000, 0.488621, 0.872496>, <-0.025572, 0.487952, 0.872496>, <-0.027345, 0.521782, 0.852640> }
triangle { <-0.027345, 0.521782, 0.852640>, <-0.000000, 0.522499, 0.852640>, <-0.000000, 0.488621, 0.872496> }
triangle { <-0.000000, 0.522499, 0.852640>, <-0.027345, 0.521782, 0.852640>, <-0.029076, 0.554809, 0.831470> }
triangle { <-0.029076, 0.554809, 0.831470>, <-0.000000, 0.555570, 0.831470>, <-0.000000, 0.522499, 0.852640> }
triangle { <-0.000000, 0.555570, 0.831470>, <-0.029076, 0.554809, 0.831470>, <-0.030762, 0.586980, 0.809017> }
triangle { <-0.030762, 0.586980, 0.809017>, <-0.000000, 0.587785, 0.809017>, <-0.000000, 0.555570, 0.831470> }
triangle { <-0.000000, 0.587785, 0.809017>, <-0.030762, 0.586980, 0.809017>, <-0.032401, 0.618246, 0.785317> }
triangle { <-0.032401, 0.618246, 0.785317>, <-0.000000, 0.619094, 0.785317>, <-0.000000, 0.587785, 0.809017> }
triangle { <-0.000000, 0.619094, 0.785317>, <-0.032401, 0.618246, 0.785317>, <-0.033989, 0.648558, 0.760406> }
triangle { <-0.033989, 0.648558, 0.760406>, <-0.000000, 0.649448, 0.760406>, <-0.000000, 0.619094, 0.785317> }
triangle { <-0.000000, 0.649448, 0.760406>, <-0.033989, 0.648558, 0.760406>, <-0.035526, 0.677870, 0.734323> }
triangle { <-0.035526, 0.677870, 0.734323>, <-0.000000, 0.678801, 0.734323>, <-0.000000, 0.649448, 0.760406> }
triangle { <-0.000000, 0.678801, 0.734323>, <-0.035526, 0.677870, 0.734323>, <-0.037007, 0.706138, 0.707107> }
triangle { <-0.037007, 0.706138, 0.707107>, <-0.000000, 0.707107, 0.707107>, <-0.000000, 0.678801, 0.734323> }
triangle { <-0.000000, 0.707107, 0.707107>, <-0.037007, 0.706138, 0.707107>, <-0.038431, 0.733316, 0.678801> }
triangle { <-0.038431, 0.733316, 0.678801>, <-0.000000, 0.734323, 0.678801>, <-0.000000, 0.707107, 0.707107> }
triangle { <-0.000000, 0.734323, 0.678801>, <-0.038431, 0.733316, 0.678801>, <-0.039797, 0.759364, 0.649448> }
triangle { <-0.039797, 0.759364, 0.649448>, <-0.000000, 0.760406, 0.649448>, <-0.000000, 0.734323, 0.678801> }
triangle { <-0.000000, 0.760406, 0.649448>, <-0.039797, 0.759364, 0.649448>, <-0.041100, 0.784241, 0.619094> }
triangle { <-0.041100, 0.784241, 0.619094>, <-0.000000, 0.785317, 0.619094>, <-0.000000, 0.760406, 0.649448> }
triangle { <-0.000000, 0.785317, 0.619094>, <-0.041100, 0.784241, 0.619094>, <-0.042341, 0.807908, 0.587785> }
triangle { <-0.042341, 0.807908, 0.587785>, <-0.000000, 0.809017, 0.587785>, <-0.000000, 0.785317, 0.619094> }
triangle { <-0.000000, 0.809017, 0.587785>, <-0.042341, 0.807908, 0.587785>, <-0.043516, 0.830330, 0.555570> }
triangle { <-0.043516, 0.830330, 0.555570>, <-0.000000, 0.831470, 0.555570>, <-0.000000, 0.809017, 0.587785> }
triangle { <-0.000000, 0.831470, 0.555570>, <-0.043516, 0.830330, 0.555570>, <-0.044624, 0.851472, 0.522499> }
triangle { <-0.044624, 0.851472, 0.522499>, <-0.000000, 0.852640, 0.522499>, <-0.000000, 0.831470, 0.555570> }
triangle { <-0.000000, 0.852640, 0.522499>, <-0.044624, 0.851472, 0.522499>, <-0.045663, 0.871300, 0.488621> }
triangle { <-0.045663, 0.871300, 0.488621>, <-0.000000, 0.872496, 0.488621>, <-0.000000, 0.852640, 0.522499> }
triangle { <-0.000000, 0.872496, 0.488621>, <-0.045663, 0.871300, 0.488621>, <-0.046632, 0.889785, 0.453990> }
triangle { <-0.046632, 0.889785, 0.453990>, <-0.000000, 0.891007, 0.453990>, <-0.000000, 0.872496, 0.488621> }
triangle { <-0.000000, 0.891007, 0.453990>, <-0.046632, 0.889785, 0.453990>, <-0.047529, 0.906899, 0.418660> }
triangle { <-0.047529, 0.906899, 0.418660>, <-0.000000, 0.908143, 0.418660>, <-0.000000, 0.891007, 0.453990> }
triangle { <-0.000000, 0.908143, 0.418660>, <-0.047529, 0.906899, 0.418660>, <-0.048352, 0.922613, 0.382683> }
triangle { <-0.048352, 0.922613, 0.382683>, <-0.000000, 0.923880, 0.382683>, <-0.000000, 0.908143, 0.418660> }
triangle { <-0.000000, 0.923880, 0.382683>, <-0.048352, 0.922613, 0.382683>, <-0.049101, 0.936906, 0.346117> }
triangle { <-0.049101, 0.936906, 0.346117>, <-0.000000, 0.938191, 0.346117>, <-0.000000, 0.923880, 0.382683> }
triangle { <-0.000000, 0.938191, 0.346117>, <-0.049101, 0.936906, 0.346117>, <-0.049774, 0.949753, 0.309017> }
triangle { <-0.049774, 0.949753, 0.309017>, <-0.000000, 0.951057, 0.309017>, <-0.000000, 0.938191, 0.346117> }
triangle { <-0.000000, 0.951057, 0.309017>, <-0.049774, 0.949753, 0.309017>, <-0.050371, 0.961136, 0.271440> }
triangle { <-0.050371, 0.961136, 0.271440>, <-0.000000, 0.962455, 0.271440>, <-0.000000, 0.951057, 0.309017> }
triangle { <-0.000000, 0.962455, 0.271440>, <-0.050371, 0.961136, 0.271440>, <-0.050890, 0.971037, 0.233445> }
triangle { <-0.050890, 0.971037, 0.233445>, <-0.000000, 0.972370, 0.233445>, <-0.000000, 0.962455, 0.271440> }
triangle { <-0.000000, 0.972370, 0.233445>, <-0.050890, 0.971037, 0.233445>, <-0.051330, 0.979441, 0.195090> }
triangle { <-0.051330, 0.979441, 0.195090>, <-0.000000, 0.980785, 0.195090>, <-0.000000, 0.972370, 0.233445> }
triangle { <-0.000000, 0.980785, 0.195090>, <-0.051330, 0.979441, 0.195090>, <-0.051692, 0.986335, 0.156434> }
triangle { <-0.051692, 0.986335, 0.156434>, <-0.000000, 0.987688, 0.156434>, <-0.000000, 0.980785, 0.195090> }
triangle { <-0.000000, 0.987688, 0.156434>, <-0.051692, 0.986335, 0.156434>, <-0.051973, 0.991707, 0.117537> }
triangle { <-0.051973, 0.991707, 0.117537>, <-0.000000, 0.993068, 0.117537>, <-0.000000, 0.987688, 0.156434> }
triangle { <-0.000000, 0.993068, 0.117537>, <-0.051973, 0.991707, 0.117537>, <-0.052175, 0.995551, 0.078459> }
triangle { <-0.052175, 0.995551, 0.078459>, <-0.000000, 0.996917, 0.078459>, <-0.000000, 0.993068, 0.117537> }
triangle { <-0.000000, 0.996917, 0.078459>, <-0.052175, 0.995551, 0.078459>, <-0.052296, 0.997860, 0.039260> }
triangle { <-0.052296, 0.997860, 0.039260>, <-0.000000, 0.999229, 0.039260>, <-0.000000, 0.996917, 0.078459> }
triangle { <-0.000000, 0.999229, 0.039260>, <-0.052296, 0.997860, 0.039260>, <-0.052336, 0.998630, -0.000000> }
triangle { <-0.052336, 0.998630, -0.000000>, <-0.000000, 1.000000, -0.000000>, <-0.000000, 0.999229, 0.039260> }
triangle { <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <-0.004104, 0.039045, 0.999229> }
triangle { <-0.004104, 0.039045, 0.999229>, <-0.002055, 0.039206, 0.999229>, <0.000000, 0.000000, 1.000000> }
triangle { <-0.002055, 0.039206, 0.999229>, <-0.004104, 0.039045, 0.999229>, <-0.008201, 0.078029, 0.996917> }
triangle { <-0.008201, 0.078029, 0.996917>, <-0.004106, 0.078352, 0.996917>, <-0.002055, 0.039206, 0.999229> }
triangle { <-0.004106, 0.078352, 0.996917>, <-0.008201, 0.078029, 0.996917>, <-0.012286, 0.116894, 0.993068> }
triangle { <-0.012286, 0.116894, 0.993068>, <-0.006151, 0.117376, 0.993068>, <-0.004106, 0.078352, 0.996917> }
triangle { <-0.006151, 0.117376, 0.993068>, <-0.012286, 0.116894, 0.993068>, <-0.016352, 0.155578, 0.987688> }
triangle { <-0.016352, 0.155578, 0.987688>, <-0.008187, 0.156220, 0.987688>, <-0.006151, 0.117376, 0.993068> }
triangle { <-0.008187, 0.156220, 0.987688>, <-0.016352, 0.155578, 0.987688>, <-0.020392, 0.194022, 0.980785> }
triangle { <-0.020392, 0.194022, 0.980785>, <-0.010210, 0.194823, 0.980785>, <-0.008187, 0.156220, 0.987688> }
triangle { <-0.010210, 0.194823, 0.980785>, <-0.020392, 0.194022, 0.980785>, <-0.024402, 0.232167, 0.972370> }
triangle { <-0.024402, 0.232167, 0.972370>, <-0.012218, 0.233125, 0.972370>, <-0.010210, 0.194823, 0.980785> }
triangle { <-0.012218, 0.233125, 0.972370>, <-0.024402, 0.232167, 0.972370>, <-0.028373, 0.269953, 0.962455> }
triangle { <-0.028373, 0.269953, 0.962455>, <-0.014206, 0.271068, 0.962455>, <-0.012218, 0.233125, 0.972370> }
triangle { <-0.014206, 0.271068, 0.962455>, <-0.028373, 0.269953, 0.962455>, <-0.032301, 0.307324, 0.951057> }
triangle { <-0.032301, 0.307324, 0.951057>, <-0.016173, 0.308593, 0.951057>, <-0.014206, 0.271068, 0.962455> }
triangle { <-0.016173, 0.308593, 0.951057>, <-0.032301, 0.307324, 0.951057>, <-0.036179, 0.344221, 0.938191> }
triangle { <-0.036179, 0.344221, 0.938191>, <-0.018114, 0.345643, 0.938191>, <-0.016173, 0.308593, 0.951057> }
triangle { <-0.018114, 0.345643, 0.938191>, <-0.036179, 0.344221, 0.938191>, <-0.040001, 0.380587, 0.923880> }
triangle { <-0.040001, 0.380587, 0.923880>, <-0.020028, 0.382159, 0.923880>, <-0.018114, 0.345643, 0.938191> }
triangle { <-0.020028, 0.382159, 0.923880>, <-0.040001, 0.380587, 0.923880>, <-0.043762, 0.416366, 0.908143> }
triangle { <-0.043762, 0.416366, 0.908143>, <-0.021911, 0.418086, 0.908143>, <-0.020028, 0.382159, 0.923880> }
triangle { <-0.021911, 0.418086, 0.908143>, <-0.043762, 0.416366, 0.908143>, <-0.047455, 0.451503, 0.891007> }
triangle { <-0.047455, 0.451503, 0.891007>, <-0.023760, 0.453368, 0.891007>, <-0.021911, 0.418086, 0.908143> }
triangle { <-0.023760, 0.453368, 0.891007>, <-0.047455, 0.451503, 0.891007>, <-0.051075, 0.485945, 0.872496> }
triangle { <-0.051075, 0.485945, 0.872496>, <-0.025572, 0.487952, 0.872496>, <-0.023760, 0.453368, 0.891007> }
triangle { <-0.025572, 0.487952, 0.872496>, <-0.051075, 0.485945, 0.872496>, <-0.054616, 0.519636, 0.852640> }
triangle { <-0.054616, 0.519636, 0.852640>, <-0.027345, 0.521782, 0.852640>, <-0.025572, 0.487952, 0.872496> }
triangle { <-0.027345, 0.521782, 0.852640>, <-0.054616, 0.519636, 0.852640>, <-0.058073, 0.552527, 0.831470> }
triangle { <-0.058073, 0.552527, 0.831470>, <-0.029076, 0.554809, 0.831470>, <-0.027345, 0.521782, 0.852640> }
triangle { <-0.029076, 0.554809, 0.831470>, <-0.058073, 0.552527, 0.831470>, <-0.061440, 0.584565, 0.809017> }
triangle { <-0.061440, 0.584565, 0.809017>, <-0.030762, 0.586980, 0.809017>, <-0.029076, 0.554809, 0.831470> }
triangle { <-0.030762, 0.586980, 0.809017>, <-0.061440, 0.584565, 0.809017>, <-0.064713, 0.615702, 0.785317> }
triangle { <-0.064713, 0.615702, 0.785317>, <-0.032401, 0.618246, 0.785317>, <-0.030762, 0.586980, 0.809017> }
triangle { <-0.032401, 0.618246, 0.785317>, <-0.064713, 0.615702, 0.785317>, <-0.067886, 0.645890, 0.760406> }
triangle { <-0.067886, 0.645890, 0.760406>, <-0.033989, 0.648558, 0.760406>, <-0.032401, 0.618246, 0.785317> }
triangle { <-0.033989, 0.648558, 0.760406>, <-0.067886, 0.645890, 0.760406>, <-0.070954, 0.675082, 0.734323> }
triangle { <-0.070954, 0.675082, 0.734323>, <-0.035526, 0.677870, 0.734323>, <-0.033989, 0.648558, 0.760406> }
triangle { <-0.035526, 0.677870, 0.734323>, <-0.070954, 0.675082, 0.734323>, <-0.073913, 0.703233, 0.707107> }
triangle { <-0.073913, 0.703233, 0.707107>, <-0.037007, 0.706138, 0.707107>, <-0.035526, 0.677870, 0.734323> }
triangle { <-0.037007, 0.706138, 0.707107>, <-0.073913, 0.703233, 0.707107>, <-0.076758, 0.730300, 0.678801> }
triangle { <-0.076758, 0.730300, 0.678801>, <-0.038431, 0.733316, 0.678801>, <-0.037007, 0.706138, 0.707107> }
triangle { <-0.038431, 0.733316, 0.678801>, <-0.076758, 0.730300, 0.678801>, <-0.079484, 0.756240, 0.649448> }
triangle { <-0.079484, 0.756240, 0.649448>, <-0.039797, 0.759364, 0.649448>, <-0.038431, 0.733316, 0.678801> }
triangle { <-0.039797, 0.759364, 0.649448>, <-0.079484, 0.756240, 0.649448>, <-0.082088, 0.781015, 0.619094> }
triangle { <-0.082088, 0.781015, 0.619094>, <-0.041100, 0.784241, 0.619094>, <-0.039797, 0.759364, 0.649448> }
triangle { <-0.041100, 0.784241, 0.619094>, <-0.082088, 0.781015, 0.619094>, <-0.084565, 0.804585, 0.587785> }
triangle { <-0.084565, 0.804585, 0.587785>, <-0.042341, 0.807908, 0.587785>, <-0.041100, 0.784241, 0.619094> }
triangle { <-0.042341, 0.807908, 0.587785>, <-0.084565, 0.804585, 0.587785>, <-0.086912, 0.826915, 0.555570> }
triangle { <-0.086912, 0.826915, 0.555570>, <-0.043516, 0.830330, 0.555570>, <-0.042341, 0.807908, 0.587785> }
triangle { <-0.043516, 0.830330, 0.555570>, <-0.086912, 0.826915, 0.555570>, <-0.089125, 0.847969, 0.522499> }
triangle { <-0.089125, 0.847969, 0.522499>, <-0.044624, 0.851472, 0.522499>, <-0.043516, 0.830330, 0.555570> }
triangle { <-0.044624, 0.851472, 0.522499>, <-0.089125, 0.847969, 0.522499>, <-0.091201, 0.867716, 0.488621> }
triangle { <-0.091201, 0.867716, 0.488621>, <-0.045663, 0.871300, 0.488621>, <-0.044624, 0.851472, 0.522499> }
triangle { <-0.045663, 0.871300, 0.488621>, <-0.091201, 0.867716, 0.488621>, <-0.093136, 0.886125, 0.453990> }
triangle { <-0.093136, 0.886125, 0.453990>, <-0.046632, 0.889785, 0.453990>, <-0.045663, 0.871300, 0.488621> }
triangle { <-0.046632, 0.889785, 0.453990>, <-0.093136, 0.886125, 0.453990>, <-0.094927, 0.903168, 0.418660> }
triangle { <-0.094927, 0.903168, 0.418660>, <-0.047529, 0.906899, 0.418660>, <-0.046632, 0.889785, 0.453990> }
triangle { <-0.047529, 0.906899, 0.418660>, <-0.094927, 0.903168, 0.418660>, <-0.096572, 0.918818, 0.382683> }
triangle { <-0.096572, 0.918818, 0.382683>, <-0.048352, 0.922613, 0.382683>, <-0.047529, 0.906899, 0.418660> }
triangle { <-0.048352, 0.922613, 0.382683>, <-0.096572, 0.918818, 0.382683>, <-0.098068, 0.933052, 0.346117> }
triangle { <-0.098068, 0.933052, 0.346117>, <-0.049101, 0.936906, 0.346117>, <-0.048352, 0.922613, 0.382683> }
triangle { <-0.049101, 0.936906, 0.346117>, <-0.098068, 0.933052, 0.346117>, <-0.099412, 0.945847, 0.309017> }
triangle { <-0.099412, 0.945847, 0.309017>, <-0.049774, 0.949753, 0.309017>, <-0.049101, 0.936906, 0.346117> }
triangle { <-0.049774, 0.949753, 0.309017>, <-0.099412, 0.945847, 0.309017>, <-0.100604, 0.957183, 0.271440> }
triangle { <-0.100604, 0.957183, 0.271440>, <-0.050371, 0.961136, 0.271440>, <-0.049774, 0.949753, 0.309017> }
triangle { <-0.050371, 0.961136, 0.271440>, <-0.100604, 0.957183, 0.271440>, <-0.101640, 0.967043, 0.233445> }
triangle { <-0.101640, 0.967043, 0.233445>, <-0.050890, 0.971037, 0.233445>, <-0.050371, 0.961136, 0.271440> }
triangle { <-0.050890, 0.971037, 0.233445>, <-0.101640, 0.967043, 0.233445>, <-0.102520, 0.975412, 0.195090> }
triangle { <-0.102520, 0.975412, 0.195090>, <-0.051330, 0.979441, 0.195090>, <-0.050890, 0.971037, 0.233445> }
triangle { <-0.051330, 0.979441, 0.195090>, <-0.102520, 0.975412, 0.195090>, <-0.103242, 0.982278, 0.156434> }
triangle { <-0.103242, 0.982278, 0.156434>, <-0.051692, 0.986335, 0.156434>, <-0.051330, 0.979441, 0.195090> }
triangle { <-0.051692, 0.986335, 0.156434>, <-0.103242, 0.982278, 0.156434>, <-0.103804, 0.987628, 0.117537> }
triangle { <-0.103804, 0.987628, 0.117537>, <-0.051973, 0.991707, 0.117537>, <-0.051692, 0.986335, 0.156434> }
triangle { <-0.051973, 0.991707, 0.117537>, <-0.103804, 0.987628, 0.117537>, <-0.104206, 0.991456, 0.078459> }
triangle { <-0.104206, 0.991456, 0.078459>, <-0.052175, 0.995551, 0.078459>, <-0.051973, 0.991707, 0.117537> }
triangle { <-0.052175, 0.995551, 0.078459>, <-0.104206, 0.991456, 0.078459>, <-0.104448, 0.993755, 0.039260> }
triangle { <-0.104448, 0.993755, 0.039260>, <-0.052296, 0.997860, 0.039260>, <-0.052175, 0.995551, 0.078459> }
triangle { <-0.052296, 0.997860, 0.039260>, <-0.104448, 0.993755, 0.039260>, <-0.104528, 0.994522, -0.000000> }
triangle { <-0.104528, 0.994522, -0.000000>, <-0.052336, 0.998630, -0.000000>, <-0.052296, 0.997860, 0.039260> }
triangle { <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <-0.006142, 0.038776, 0.999229> }
triangle { <-0.006142, 0.038776, 0.999229>, <-0.004104, 0.039045, 0.999229>, <0.000000, 0.000000, 1.000000> }
triangle { <-0.004104, 0.039045, 0.999229>, <-0.006142, 0.038776, 0.999229>, <-0.012274, 0.077493, 0.996917> }
triangle { <-0.012274, 0.077493, 0.996917>, <-0.008201, 0.078029, 0.996917>, <-0.004104, 0.039045, 0.999229> }
triangle { <-0.008201, 0.078029, 0.996917>, <-0.012274, 0.077493, 0.996917>, <-0.018387, 0.116090, 0.993068> }
triangle { <-0.018387, 0.116090, 0.993068>, <-0.012286, 0.116894, 0.993068>, <-0.008201, 0.078029, 0.996917> }
triangle { <-0.012286, 0.116894, 0.993068>, <-0.018387, 0.116090, 0.993068>, <-0.024472, 0.154508, 0.987688> }
triangle { <-0.024472, 0.154508, 0.987688>, <-0.016352, 0.155578, 0.987688>, <-0.012286, 0.116894, 0.993068> }
triangle { <-0.016352, 0.155578, 0.987688>, <-0.024472, 0.154508, 0.987688>, <-0.030519, 0.192688, 0.980785> }
triangle { <-0.030519, 0.192688, 0.980785>, <-0.020392, 0.194022, 0.980785>, <-0.016352, 0.155578, 0.987688> }
triangle { <-0.020392, 0.194022, 0.980785>, <-0.030519, 0.192688, 0.980785>, <-0.036519, 0.230571, 0.972370> }
triangle { <-0.036519, 0.230571, 0.972370>, <-0.024402, 0.232167, 0.972370>, <-0.020392, 0.194022, 0.980785> }
triangle { <-0.024402, 0.232167, 0.972370>, <-0.036519, 0.230571, 0.972370>, <-0.042463, 0.268099, 0.962455> }
triangle { <-0.042463, 0.268099, 0.962455>, <-0.028373, 0.269953, 0.962455>, <-0.024402, 0.232167, 0.972370> }
triangle { <-0.028373, 0.269953, 0.962455>, <-0.042463, 0.268099, 0.962455>, <-0.048341, 0.305212, 0.951057> }
triangle { <-0.048341, 0.305212, 0.951057>, <-0.032301, 0.307324, 0.951057>, <-0.028373, 0.269953, 0.962455> }
triangle { <-0.032301, 0.307324, 0.951057>, <-0.048341, 0.305212, 0.951057>, <-0.054145, 0.341856, 0.938191> }
triangle { <-0.054145, 0.341856, 0.938191>, <-0.036179, 0.344221, 0.938191>, <-0.032301, 0.307324, 0.951057> }
triangle { <-0.036179, 0.344221, 0.938191>, <-0.054145, 0.341856, 0.938191>, <-0.059865, 0.377972, 0.923880> }
triangle { <-0.059865, 0.377972, 0.923880>, <-0.040001, 0.380587, 0.923880>, <-0.036179, 0.344221, 0.938191> }
triangle { <-0.040001, 0.380587, 0.923880>, <-0.059865, 0.377972, 0.923880>, <-0.065493, 0.413505, 0.908143> }
triangle { <-0.065493, 0.413505, 0.908143>, <-0.043762, 0.416366, 0.908143>, <-0.040001, 0.380587, 0.923880> }
triangle { <-0.043762, 0.416366, 0.908143>, <-0.065493, 0.413505, 0.908143>, <-0.071020, 0.448401, 0.891007> }
triangle { <-0.071020, 0.448401, 0.891007>, <-0.047455, 0.451503, 0.891007>, <-0.043762, 0.416366, 0.908143> }
triangle { <-0.047455, 0.451503, 0.891007>, <-0.071020, 0.448401, 0.891007>, <-0.076437, 0.482606, 0.872496> }
triangle { <-0.076437, 0.482606, 0.872496>, <-0.051075, 0.485945, 0.872496>, <-0.047455, 0.451503, 0.891007> }
triangle { <-0.051075, 0.485945, 0.872496>, <-0.076437, 0.482606, 0.872496>, <-0.081737, 0.516066, 0.852640> }
triangle { <-0.081737, 0.516066, 0.852640>, <-0.054616, 0.519636, 0.852640>, <-0.051075, 0.485945, 0.872496> }
triangle { <-0.054616, 0.519636, 0.852640>, <-0.081737, 0.516066, 0.852640>, <-0.086910, 0.548730, 0.831470> }
triangle { <-0.086910, 0.548730, 0.831470>, <-0.058073, 0.552527, 0.831470>, <-0.054616, 0.519636, 0.852640> }
triangle { <-0.058073, 0.552527, 0.831470>, <-0.086910, 0.548730, 0.831470>, <-0.091950, 0.580549, 0.809017> }
triangle { <-0.091950, 0.580549, 0.809017>, <-0.061440, 0.584565, 0.809017>, <-0.058073, 0.552527, 0.831470> }
triangle { <-0.061440, 0.584565, 0.809017>, <-0.091950, 0.580549, 0.809017>, <-0.096848, 0.611472, 0.785317> }
triangle { <-0.096848, 0.611472, 0.785317>, <-0.064713, 0.615702, 0.785317>, <-0.061440, 0.584565, 0.809017> }
triangle { <-0.064713, 0.615702, 0.785317>, <-0.096848, 0.611472, 0.785317>, <-0.101596, 0.641452, 0.760406> }
triangle { <-0.101596, 0.641452, 0.760406>, <-0.067886, 0.645890, 0.760406>, <-0.064713, 0.615702, 0.785317> }
triangle { <-0.067886, 0.645890, 0.760406>, <-0.101596, 0.641452, 0.760406>, <-0.106188, 0.670444, 0.734323> }
triangle { <-0.106188, 0.670444, 0.734323>, <-0.070954, 0.675082, 0.734323>, <-0.067886, 0.645890, 0.760406> }
triangle { <-0.070954, 0.675082, 0.734323>, <-0.106188, 0.670444, 0.734323>, <-0.110616, 0.698401, 0.707107> }
triangle { <-0.110616, 0.698401, 0.707107>, <-0.073913, 0.703233, 0.707107>, <-0.070954, 0.675082, 0.734323> }
triangle { <-0.073913, 0.703233, 0.707107>, <-0.110616, 0.698401, 0.707107>, <-0.114873, 0.725282, 0.678801> }
triangle { <-0.114873, 0.725282, 0.678801>, <-0.076758, 0.730300, 0.678801>, <-0.073913, 0.703233, 0.707107> }
triangle { <-0.076758, 0.730300, 0.678801>, <-0.114873, 0.725282, 0.678801>, <-0.118954, 0.751044, 0.649448> }
triangle { <-0.118954, 0.751044, 0.649448>, <-0.079484, 0.756240, 0.649448>, <-0.076758, 0.730300, 0.678801> }
triangle { <-0.079484, 0.756240, 0.649448>, <-0.118954, 0.751044, 0.649448>, <-0.122851, 0.775648, 0.619094> }
triangle { <-0.122851, 0.775648, 0.619094>, <-0.082088, 0.781015, 0.619094>, <-0.079484, 0.756240, 0.649448> }
triangle { <-0.082088, 0.781015, 0.619094>, <-0.122851, 0.775648, 0.619094>, <-0.126558, 0.799057, 0.587785> }
triangle { <-0.126558, 0.799057, 0.587785>, <-0.084565, 0.804585, 0.587785>, <-0.082088, 0.781015, 0.619094> }
triangle { <-0.084565, 0.804585, 0.587785>, <-0.126558, 0.799057, 0.587785>, <-0.130071, 0.821233, 0.555570> }
triangle { <-0.130071, 0.821233, 0.555570>, <-0.086912, 0.826915, 0.555570>, <-0.084565, 0.804585, 0.587785> }
triangle { <-0.086912, 0.826915, 0.555570>, <-0.130071, 0.821233, 0.555570>, <-0.133382, 0.842143, 0.522499> }
triangle { <-0.133382, 0.842143, 0.522499>, <-0.089125, 0.847969, 0.522499>, <-0.086912, 0.826915, 0.555570> }
triangle { <-0.089125, 0.847969, 0.522499>, <-0.133382, 0.842143, 0.522499>, <-0.136488, 0.861754, 0.488621> }
triangle { <-0.136488, 0.861754, 0.488621>, <-0.091201, 0.867716, 0.488621>, <-0.089125, 0.847969, 0.522499> }
triangle { <-0.091201, 0.867716, 0.488621>, <-0.136488, 0.861754, 0.488621>, <-0.139384, 0.880037, 0.453990> }
triangle { <-0.139384, 0.880037, 0.453990>, <-0.093136, 0.886125, 0.453990>, <-0.091201, 0.867716, 0.488621> }
triangle { <-0.093136, 0.886125, 0.453990>, <-0.139384, 0.880037, 0.453990>, <-0.142065, 0.896962, 0.418660> }
triangle { <-0.142065, 0.896962, 0.418660>, <-0.094927, 0.903168, 0.418660>, <-0.093136, 0.886125, 0.453990> }
triangle { <-0.094927, 0.903168, 0.418660>, <-0.142065, 0.896962, 0.418660>, <-0.144527, 0.912505, 0.382683> }
triangle { <-0.144527, 0.912505, 0.382683>, <-0.096572, 0.918818, 0.382683>, <-0.094927, 0.903168, 0.418660> }
triangle { <-0.096572, 0.918818, 0.382683>, <-0.144527, 0.912505, 0.382683>, <-0.146765, 0.926641, 0.346117> }
triangle { <-0.146765, 0.926641, 0.346117>, <-0.098068, 0.933052, 0.346117>, <-0.096572, 0.918818, 0.382683> }
triangle { <-0.098068, 0.933052, 0.346117>, <-0.146765, 0.926641, 0.346117>, <-0.148778, 0.939347, 0.309017> }
triangle { <-0.148778, 0.939347, 0.309017>, <-0.099412, 0.945847, 0.309017>, <-0.098068, 0.933052, 0.346117> }
triangle { <-0.099412, 0.945847, 0.309017>, <-0.148778, 0.939347, 0.309017>, <-0.150561, 0.950606, 0.271440> }
triangle { <-0.150561, 0.950606, 0.271440>, <-0.100604, 0.957183, 0.271440>, <-0.099412, 0.945847, 0.309017> }
triangle { <-0.100604, 0.957183, 0.271440>, <-0.150561, 0.950606, 0.271440>, <-0.152112, 0.960398, 0.233445> }
triangle { <-0.152112, 0.960398, 0.233445>, <-0.101640, 0.967043, 0.233445>, <-0.100604, 0.957183, 0.271440> }
triangle { <-0.101640, 0.967043, 0.233445>, <-0.152112, 0.960398, 0.233445>, <-0.153429, 0.968710, 0.195090> }
triangle { <-0.153429, 0.968710, 0.195090>, <-0.102520, 0.975412, 0.195090>, <-0.101640, 0.967043, 0.233445> }
triangle { <-0.102520, 0.975412, 0.195090>, <-0.153429, 0.968710, 0.195090>, <-0.154508, 0.975528, 0.156434> }
triangle { <-0.154508, 0.975528, 0.156434>, <-0.103242, 0.982278, 0.156434>, <-0.102520, 0.975412, 0.195090> }
triangle { <-0.103242, 0.982278, 0.156434>, <-0.154508, 0.975528, 0.156434>, <-0.155350, 0.980842, 0.117537> }
triangle { <-0.155350, 0.980842, 0.117537>, <-0.103804, 0.987628, 0.117537>, <-0.103242, 0.982278, 0.156434> }
triangle { <-0.103804, 0.987628, 0.117537>, <-0.155350, 0.980842, 0.117537>, <-0.155952, 0.984644, 0.078459> }
triangle { <-0.155952, 0.984644, 0.078459>, <-0.104206, 0.991456, 0.078459>, <-0.103804, 0.987628, 0.117537> }
triangle { <-0.104206, 0.991456, 0.078459>, <-0.155952, 0.984644, 0.078459>, <-0.156314, 0.986927, 0.039260> }
triangle { <-0.156314, 0.986927, 0.039260>, <-0.104448, 0.993755, 0.039260>, <-0.104206, 0.991456, 0.078459> }
triangle { <-0.104448, 0.993755, 0.039260>, <-0.156314, 0.986927, 0.039260>, <-0.156434, 0.987688, -0.000000> }
triangle { <-0.156434, 0.987688, -0.000000>, <-0.104528, 0.994522, -0.000000>, <-0.104448, 0.993755, 0.039260> }
triangle { <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <-0.008163, 0.038402, 0.999229> }
triangle { <-0.008163, 0.038402, 0.999229>, <-0.006142, 0.038776, 0.999229>, <0.000000, 0.000000, 1.000000> }
triangle { <-0.006142, 0.038776, 0.999229>, <-0.008163, 0.038402, 0.999229>, <-0.016313, 0.076745, 0.996917> }
triangle { <-0.016313, 0.076745, 0.996917>, <-0.012274, 0.077493, 0.996917>, <-0.006142, 0.038776, 0.999229> }
triangle { <-0.012274, 0.077493, 0.996917>, <-0.016313, 0.076745, 0.996917>, <-0.024437, 0.114969, 0.993068> }
triangle { <-0.024437, 0.114969, 0.993068>, <-0.018387, 0.116090, 0.993068>, <-0.012274, 0.077493, 0.996917> }
triangle { <-0.018387, 0.116090, 0.993068>, <-0.024437, 0.114969, 0.993068>, <-0.032525, 0.153016, 0.987688> }
triangle { <-0.032525, 0.153016, 0.987688>, <-0.024472, 0.154508, 0.987688>, <-0.018387, 0.116090, 0.993068> }
triangle { <-0.024472, 0.154508, 0.987688>, <-0.032525, 0.153016, 0.987688>, <-0.040562, 0.190827, 0.980785> }
triangle { <-0.040562, 0.190827, 0.980785>, <-0.030519, 0.192688, 0.980785>, <-0.024472, 0.154508, 0.987688> }
triangle { <-0.030519, 0.192688, 0.980785>, <-0.040562, 0.190827, 0.980785>, <-0.048536, 0.228344, 0.972370> }
triangle { <-0.048536, 0.228344, 0.972370>, <-0.036519, 0.230571, 0.972370>, <-0.030519, 0.192688, 0.980785> }
triangle { <-0.036519, 0.230571, 0.972370>, <-0.048536, 0.228344, 0.972370>, <-0.056436, 0.265509, 0.962455> }
triangle { <-0.056436, 0.265509, 0.962455>, <-0.042463, 0.268099, 0.962455>, <-0.036519, 0.230571, 0.972370> }
triangle { <-0.042463, 0.268099, 0.962455>, <-0.056436, 0.265509, 0.962455>, <-0.064248, 0.302264, 0.951057> }
triangle { <-0.064248, 0.302264, 0.951057>, <-0.048341, 0.305212, 0.951057>, <-0.042463, 0.268099, 0.962455> }
triangle { <-0.048341, 0.305212, 0.951057>, <-0.064248, 0.302264, 0.951057>, <-0.071962, 0.338554, 0.938191> }
triangle { <-0.071962, 0.338554, 0.938191>, <-0.054145, 0.341856, 0.938191>, <-0.048341, 0.305212, 0.951057> }
triangle { <-0.054145, 0.341856, 0.938191>, <-0.071962, 0.338554, 0.938191>, <-0.079564, 0.374321, 0.923880> }
triangle { <-0.079564, 0.374321, 0.923880>, <-0.059865, 0.377972, 0.923880>, <-0.054145, 0.341856, 0.938191> }
triangle { <-0.059865, 0.377972, 0.923880>, <-0.079564, 0.374321, 0.923880>, <-0.087044, 0.409511, 0.908143> }
triangle { <-0.087044, 0.409511, 0.908143>, <-0.065493, 0.413505, 0.908143>, <-0.059865, 0.377972, 0.923880> }
triangle { <-0.065493, 0.413505, 0.908143>, <-0.087044, 0.409511, 0.908143>, <-0.094390, 0.444070, 0.891007> }
triangle { <-0.094390, 0.444070, 0.891007>, <-0.071020, 0.448401, 0.891007>, <-0.065493, 0.413505, 0.908143> }
triangle { <-0.071020, 0.448401, 0.891007>, <-0.094390, 0.444070, 0.891007>, <-0.101590, 0.477944, 0.872496> }
triangle { <-0.101590, 0.477944, 0.872496>, <-0.076437, 0.482606, 0.872496>, <-0.071020, 0.448401, 0.891007> }
triangle { <-0.076437, 0.482606, 0.872496>, <-0.101590, 0.477944, 0.872496>, <-0.108634, 0.511081, 0.852640> }
triangle { <-0.108634, 0.511081, 0.852640>, <-0.081737, 0.516066, 0.852640>, <-0.076437, 0.482606, 0.872496> }
triangle { <-0.081737, 0.516066, 0.852640>, <-0.108634, 0.511081, 0.852640>, <-0.115510, 0.543430, 0.831470> }
triangle { <-0.115510, 0.543430, 0.831470>, <-0.086910, 0.548730, 0.831470>, <-0.081737, 0.516066, 0.852640> }
triangle { <-0.086910, 0.548730, 0.831470>, <-0.115510, 0.543430, 0.831470>, <-0.122207, 0.574941, 0.809017> }
triangle { <-0.122207, 0.574941, 0.809017>, <-0.091950, 0.580549, 0.809017>, <-0.086910, 0.548730, 0.831470> }
triangle { <-0.091950, 0.580549, 0.809017>, <-0.122207, 0.574941, 0.809017>, <-0.128717, 0.605565, 0.785317> }
triangle { <-0.128717, 0.605565, 0.785317>, <-0.096848, 0.611472, 0.785317>, <-0.091950, 0.580549, 0.809017> }
triangle { <-0.096848, 0.611472, 0.785317>, <-0.128717, 0.605565, 0.785317>, <-0.135028, 0.635256, 0.760406> }
triangle { <-0.135028, 0.635256, 0.760406>, <-0.101596, 0.641452, 0.760406>, <-0.096848, 0.611472, 0.785317> }
triangle { <-0.101596, 0.641452, 0.760406>, <-0.135028, 0.635256, 0.760406>, <-0.141131, 0.663967, 0.734323> }
triangle { <-0.141131, 0.663967, 0.734323>, <-0.106188, 0.670444, 0.734323>, <-0.101596, 0.641452, 0.760406> }
triangle { <-0.106188, 0.670444, 0.734323>, <-0.141131, 0.663967, 0.734323>, <-0.147016, 0.691655, 0.707107> }
triangle { <-0.147016, 0.691655, 0.707107>, <-0.110616, 0.698401, 0.707107>, <-0.106188, 0.670444, 0.734323> }
triangle { <-0.110616, 0.698401, 0.707107>, <-0.147016, 0.691655, 0.707107>, <-0.152674, 0.718276, 0.678801> }
triangle { <-0.152674, 0.718276, 0.678801>, <-0.114873, 0.725282, 0.678801>, <-0.110616, 0.698401, 0.707107> }
triangle { <-0.114873, 0.725282, 0.678801>, <-0.152674, 0.718276, 0.678801>, <-0.158097, 0.743789, 0.649448> }
triangle { <-0.158097, 0.743789, 0.649448>, <-0.118954, 0.751044, 0.649448>, <-0.114873, 0.725282, 0.678801> }
triangle { <-0.118954, 0.751044, 0.649448>, <-0.158097, 0.743789, 0.649448>, <-0.163277, 0.768156, 0.619094> }
triangle { <-0.163277, 0.768156, 0.619094>, <-0.122851, 0.775648, 0.619094>, <-0.118954, 0.751044, 0.649448> }
triangle { <-0.122851, 0.775648, 0.619094>, <-0.163277, 0.768156, 0.619094>, <-0.168204, 0.791338, 0.587785> }
triangle { <-0.168204, 0.791338, 0.587785>, <-0.126558, 0.799057, 0.587785>, <-0.122851, 0.775648, 0.619094> }
triangle { <-0.126558, 0.799057, 0.587785>, <-0.168204, 0.791338, 0.587785>, <-0.172872, 0.813300, 0.555570> }
triangle { <-0.172872, 0.813300, 0.555570>, <-0.130071, 0.821233, 0.555570>, <-0.126558, 0.799057, 0.587785> }
triangle { <-0.130071, 0.821233, 0.555570>, <-0.172872, 0.813300, 0.555570>, <-0.177274, 0.834008, 0.522499> }
triangle { <-0.177274, 0.834008, 0.522499>, <-0.133382, 0.842143, 0.522499>, <-0.130071, 0.821233, 0.555570> }
triangle { <-0.133382, 0.842143, 0.522499>, <-0.177274, 0.834008, 0.522499>, <-0.181402, 0.853430, 0.488621> }
triangle { <-0.181402, 0.853430, 0.488621>, <-0.136488, 0.861754, 0.488621>, <-0.133382, 0.842143, 0.522499> }
triangle { <-0.136488, 0.861754, 0.488621>, <-0.181402, 0.853430, 0.488621>, <-0.185251, 0.871536, 0.453990> }
triangle { <-0.185251, 0.871536, 0.453990>, <-0.139384, 0.880037, 0.453990>, <-0.136488, 0.861754, 0.488621> }
triangle { <-0.139384, 0.880037, 0.453990>, <-0.185251, 0.871536, 0.453990>, <-0.188814, 0.888298, 0.418660> }
triangle { <-0.188814, 0.888298, 0.418660>, <-0.142065, 0.896962, 0.418660>, <-0.139384, 0.880037, 0.453990> }
triangle { <-0.142065, 0.896962, 0.418660>, <-0.188814, 0.888298, 0.418660>, <-0.192085, 0.903691, 0.382683> }
triangle { <-0.192085, 0.903691, 0.382683>, <-0.144527, 0.912505, 0.382683>, <-0.142065, 0.896962, 0.418660> }
triangle { <-0.144527, 0.912505, 0.382683>, <-0.192085, 0.903691, 0.382683>, <-0.195061, 0.917690, 0.346117> }
triangle { <-0.195061, 0.917690, 0.346117>, <-0.146765, 0.926641, 0.346117>, <-0.144527, 0.912505, 0.382683> }
triangle { <-0.146765, 0.926641, 0.346117>, <-0.195061, 0.917690, 0.346117>, <-0.197736, 0.930274, 0.309017> }
triangle { <-0.197736, 0.930274, 0.309017>, <-0.148778, 0.939347, 0.309017>, <-0.146765, 0.926641, 0.346117> }
triangle { <-0.148778, 0.939347, 0.309017>, <-0.197736, 0.930274, 0.309017>, <-0.200106, 0.941423, 0.271440> }
triangle { <-0.200106, 0.941423, 0.271440>, <-0.150561, 0.950606, 0.271440>, <-0.148778, 0.939347, 0.309017> }
triangle { <-0.150561, 0.950606, 0.271440>, <-0.200106, 0.941423, 0.271440>, <-0.202167, 0.951121, 0.233445> }
triangle { <-0.202167, 0.951121, 0.233445>, <-0.152112, 0.960398, 0.233445>, <-0.150561, 0.950606, 0.271440> }
triangle { <-0.152112, 0.960398, 0.233445>, <-0.202167, 0.951121, 0.233445>, <-0.203917, 0.959353, 0.195090> }
triangle { <-0.203917, 0.959353, 0.195090>, <-0.153429, 0.968710, 0.195090>, <-0.152112, 0.960398, 0.233445> }
triangle { <-0.153429, 0.968710, 0.195090>, <-0.203917, 0.959353, 0.195090>, <-0.205352, 0.966105, 0.156434> }
triangle { <-0.205352, 0.966105, 0.156434>, <-0.154508, 0.975528, 0.156434>, <-0.153429, 0.968710, 0.195090> }
triangle { <-0.154508, 0.975528, 0.156434>, <-0.205352, 0.966105, 0.156434>, <-0.206471, 0.971368, 0.117537> }
triangle { <-0.206471, 0.971368, 0.117537>, <-0.155350, 0.980842, 0.117537>, <-0.154508, 0.975528, 0.156434> }
triangle { <-0.155350, 0.980842, 0.117537>, <-0.206471, 0.971368, 0.117537>, <-0.207271, 0.975132, 0.078459> }
triangle { <-0.207271, 0.975132, 0.078459>, <-0.155952, 0.984644, 0.078459>, <-0.155350, 0.980842, 0.117537> }
triangle { <-0.155952, 0.984644, 0.078459>, <-0.207271, 0.975132, 0.078459>, <-0.207751, 0.977393, 0.039260> }
triangle { <-0.207751, 0.977393, 0.039260>, <-0.156314, 0.986927, 0.039260>, <-0.155952, 0.984644, 0.078459> }
triangle { <-0.156314, 0.986927, 0.039260>, <-0.207751, 0.977393, 0.039260>, <-0.207912, 0.978148, -0.000000> }
triangle { <-0.207912, 0.978148, -0.000000>, <-0.156434, 0.987688, -0.000000>, <-0.156314, 0.986927, 0.039260> }
triangle { <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <-0.010161, 0.037922, 0.999229> }
triangle { <-0.010161, 0.037922, 0.999229>, <-0.008163, 0.038402, 0.999229>, <0.000000, 0.000000, 1.000000> }
triangle { <-0.008163, 0.038402, 0.999229>, <-0.010161, 0.037922, 0.999229>, <-0.020307, 0.075786, 0.996917> }
triangle { <-0.020307, 0.075786, 0.996917>, <-0.016313, 0.076745, 0.996917>, <-0.008163, 0.038402, 0.999229> }
triangle { <-0.016313, 0.076745, 0.996917>, <-0.020307, 0.075786, 0.996917>, <-0.030421, 0.113532, 0.993068> }
triangle { <-0.030421, 0.113532, 0.993068>, <-0.024437, 0.114969, 0.993068>, <-0.016313, 0.076745, 0.996917> }
triangle { <-0.024437, 0.114969, 0.993068>, <-0.030421, 0.113532, 0.993068>, <-0.040488, 0.151104, 0.987688> }
triangle { <-0.040488, 0.151104, 0.987688>, <-0.032525, 0.153016, 0.987688>, <-0.024437, 0.114969, 0.993068> }
triangle { <-0.032525, 0.153016, 0.987688>, <-0.040488, 0.151104, 0.987688>, <-0.050493, 0.188443, 0.980785> }
triangle { <-0.050493, 0.188443, 0.980785>, <-0.040562, 0.190827, 0.980785>, <-0.032525, 0.153016, 0.987688> }
triangle { <-0.040562, 0.190827, 0.980785>, <-0.050493, 0.188443, 0.980785>, <-0.060420, 0.225491, 0.972370> }
triangle { <-0.060420, 0.225491, 0.972370>, <-0.048536, 0.228344, 0.972370>, <-0.040562, 0.190827, 0.980785> }
triangle { <-0.048536, 0.228344, 0.972370>, <-0.060420, 0.225491, 0.972370>, <-0.070254, 0.262191, 0.962455> }
triangle { <-0.070254, 0.262191, 0.962455>, <-0.056436, 0.265509, 0.962455>, <-0.048536, 0.228344, 0.972370> }
triangle { <-0.056436, 0.265509, 0.962455>, <-0.070254, 0.262191, 0.962455>, <-0.079979, 0.298487, 0.951057> }
triangle { <-0.079979, 0.298487, 0.951057>, <-0.064248, 0.302264, 0.951057>, <-0.056436, 0.265509, 0.962455> }
triangle { <-0.064248, 0.302264, 0.951057>, <-0.079979, 0.298487, 0.951057>, <-0.089582, 0.334323, 0.938191> }
triangle { <-0.089582, 0.334323, 0.938191>, <-0.071962, 0.338554, 0.938191>, <-0.064248, 0.302264, 0.951057> }
triangle { <-0.071962, 0.338554, 0.938191>, <-0.089582, 0.334323, 0.938191>, <-0.099046, 0.369644, 0.923880> }
triangle { <-0.099046, 0.369644, 0.923880>, <-0.079564, 0.374321, 0.923880>, <-0.071962, 0.338554, 0.938191> }
triangle { <-0.079564, 0.374321, 0.923880>, <-0.099046, 0.369644, 0.923880>, <-0.108357, 0.404394, 0.908143> }
triangle { <-0.108357, 0.404394, 0.908143>, <-0.087044, 0.409511, 0.908143>, <-0.079564, 0.374321, 0.923880> }
triangle { <-0.087044, 0.409511, 0.908143>, <-0.108357, 0.404394, 0.908143>, <-0.117501, 0.438521, 0.891007> }
triangle { <-0.117501, 0.438521, 0.891007>, <-0.094390, 0.444070, 0.891007>, <-0.087044, 0.409511, 0.908143> }
triangle { <-0.094390, 0.444070, 0.891007>, <-0.117501, 0.438521, 0.891007>, <-0.126464, 0.471972, 0.872496> }
triangle { <-0.126464, 0.471972, 0.872496>, <-0.101590, 0.477944, 0.872496>, <-0.094390, 0.444070, 0.891007> }
triangle { <-0.101590, 0.477944, 0.872496>, <-0.126464, 0.471972, 0.872496>, <-0.135233, 0.504695, 0.852640> }
triangle { <-0.135233, 0.504695, 0.852640>, <-0.108634, 0.511081, 0.852640>, <-0.101590, 0.477944, 0.872496> }
triangle { <-0.108634, 0.511081, 0.852640>, <-0.135233, 0.504695, 0.852640>, <-0.143792, 0.536640, 0.831470> }
triangle { <-0.143792, 0.536640, 0.831470>, <-0.115510, 0.543430, 0.831470>, <-0.108634, 0.511081, 0.852640> }
triangle { <-0.115510, 0.543430, 0.831470>, <-0.143792, 0.536640, 0.831470>, <-0.152130, 0.567757, 0.809017> }
triangle { <-0.152130, 0.567757, 0.809017>, <-0.122207, 0.574941, 0.809017>, <-0.115510, 0.543430, 0.831470> }
triangle { <-0.122207, 0.574941, 0.809017>, <-0.152130, 0.567757, 0.809017>, <-0.160233, 0.597999, 0.785317> }
triangle { <-0.160233, 0.597999, 0.785317>, <-0.128717, 0.605565, 0.785317>, <-0.122207, 0.574941, 0.809017> }
triangle { <-0.128717, 0.605565, 0.785317>, <-0.160233, 0.597999, 0.785317>, <-0.168090, 0.627319, 0.760406> }
triangle { <-0.168090, 0.627319, 0.760406>, <-0.135028, 0.635256, 0.760406>, <-0.128717, 0.605565, 0.785317> }
triangle { <-0.135028, 0.635256, 0.760406>, <-0.168090, 0.627319, 0.760406>, <-0.175687, 0.655671, 0.734323> }
triangle { <-0.175687, 0.655671, 0.734323>, <-0.141131, 0.663967, 0.734323>, <-0.135028, 0.635256, 0.760406> }
triangle { <-0.141131, 0.663967, 0.734323>, <-0.175687, 0.655671, 0.734323>, <-0.183013, 0.683013, 0.707107> }
triangle { <-0.183013, 0.683013, 0.707107>, <-0.147016, 0.691655, 0.707107>, <-0.141131, 0.663967, 0.734323> }
triangle { <-0.147016, 0.691655, 0.707107>, <-0.183013, 0.683013, 0.707107>, <-0.190057, 0.709301, 0.678801> }
triangle { <-0.190057, 0.709301, 0.678801>, <-0.152674, 0.718276, 0.678801>, <-0.147016, 0.691655, 0.707107> }
triangle { <-0.152674, 0.718276, 0.678801>, <-0.190057, 0.709301, 0.678801>, <-0.196808, 0.734496, 0.649448> }
triangle { <-0.196808, 0.734496, 0.649448>, <-0.158097, 0.743789, 0.649448>, <-0.152674, 0.718276, 0.678801> }
triangle { <-0.158097, 0.743789, 0.649448>, <-0.196808, 0.734496, 0.649448>, <-0.203255, 0.758558, 0.619094> }
triangle { <-0.203255, 0.758558, 0.619094>, <-0.163277, 0.768156, 0.619094>, <-0.158097, 0.743789, 0.649448> }
triangle { <-0.163277, 0.768156, 0.619094>, <-0.203255, 0.758558, 0.619094>, <-0.209389, 0.781450, 0.587785> }
triangle { <-0.209389, 0.781450, 0.587785>, <-0.168204, 0.791338, 0.587785>, <-0.163277, 0.768156, 0.619094> }
triangle { <-0.168204, 0.791338, 0.587785>, <-0.209389, 0.781450, 0.587785>, <-0.215200, 0.803138, 0.555570> }
triangle { <-0.215200, 0.803138, 0.555570>, <-0.172872, 0.813300, 0.555570>, <-0.168204, 0.791338, 0.587785> }
triangle { <-0.172872, 0.813300, 0.555570>, <-0.215200, 0.803138, 0.555570>, <-0.220680, 0.823587, 0.522499> }
triangle { <-0.220680, 0.823587, 0.522499>, <-0.177274, 0.834008, 0.522499>, <-0.172872, 0.813300, 0.555570> }
triangle { <-0.177274, 0.834008, 0.522499>, <-0.220680, 0.823587, 0.522499>, <-0.225819, 0.842766, 0.488621> }
triangle { <-0.225819, 0.842766, 0.488621>, <-0.181402, 0.853430, 0.488621>, <-0.177274, 0.834008, 0.522499> }
triangle { <-0.181402, 0.853430, 0.488621>, <-0.225819, 0.842766, 0.488621>, <-0.230609, 0.860646, 0.453990> }
triangle { <-0.230609, 0.860646, 0.453990>, <-0.185251, 0.871536, 0.453990>, <-0.181402, 0.853430, 0.488621> }
triangle { <-0.185251, 0.871536, 0.453990>, <-0.230609, 0.860646, 0.453990>, <-0.235045, 0.877199, 0.418660> }
triangle { <-0.235045, 0.877199, 0.418660>, <-0.188814, 0.888298, 0.418660>, <-0.185251, 0.871536, 0.453990> }
triangle { <-0.188814, 0.888298, 0.418660>, <-0.235045, 0.877199, 0.418660>, <-0.239118, 0.892399, 0.382683> }
triangle { <-0.239118, 0.892399, 0.382683>, <-0.192085, 0.903691, 0.382683>, <-0.188814, 0.888298, 0.418660> }
triangle { <-0.192085, 0.903691, 0.382683>, <-0.239118, 0.892399, 0.382683>, <-0.242822, 0.906223, 0.346117> }
triangle { <-0.242822, 0.906223, 0.346117>, <-0.195061, 0.917690, 0.346117>, <-0.192085, 0.903691, 0.382683> }
triangle { <-0.195061, 0.917690, 0.346117>, <-0.242822, 0.906223, 0.346117>, <-0.246152, 0.918650, 0.309017> }
triangle { <-0.246152, 0.918650, 0.309017>, <-0.197736, 0.930274, 0.309017>, <-0.195061, 0.917690, 0.346117> }
triangle { <-0.197736, 0.930274, 0.309017>, <-0.246152, 0.918650, 0.309017>, <-0.249102, 0.929660, 0.271440> }
triangle { <-0.249102, 0.929660, 0.271440>, <-0.200106, 0.941423, 0.271440>, <-0.197736, 0.930274, 0.309017> }
triangle { <-0.200106, 0.941423, 0.271440>, <-0.249102, 0.929660, 0.271440>, <-0.251668, 0.939237, 0.233445> }
triangle { <-0.251668, 0.939237, 0.233445>, <-0.202167, 0.951121, 0.233445>, <-0.200106, 0.941423, 0.271440> }
triangle { <-0.202167, 0.951121, 0.233445>, <-0.251668, 0.939237, 0.233445>, <-0.253846, 0.947366, 0.195090> }
triangle { <-0.253846, 0.947366, 0.195090>, <-0.203917, 0.959353, 0.195090>, <-0.202167, 0.951121, 0.233445> }
triangle { <-0.203917, 0.959353, 0.195090>, <-0.253846, 0.947366, 0.195090>, <-0.255633, 0.954034, 0.156434> }
triangle { <-0.255633, 0.954034, 0.156434>, <-0.205352, 0.966105, 0.156434>, <-0.203917, 0.959353, 0.195090> }
triangle { <-0.205352, 0.966105, 0.156434>, <-0.255633, 0.954034, 0.156434>, <-0.257025, 0.959230, 0.117537> }
triangle { <-0.257025, 0.959230, 0.117537>, <-0.206471, 0.971368, 0.117537>, <-0.205352, 0.966105, 0.156434> }
triangle { <-0.206471, 0.971368, 0.117537>, <-0.257025, 0.959230, 0.117537>, <-0.258021, 0.962948, 0.078459> }
triangle { <-0.258021, 0.962948, 0.078459>, <-0.207271, 0.975132, 0.078459>, <-0.206471, 0.971368, 0.117537> }
triangle { <-0.207271, 0.975132, 0.078459>, <-0.258021, 0.962948, 0.078459>, <-0.258620, 0.965181, 0.039260> }
triangle { <-0.258620, 0.965181, 0.039260>, <-0.207751, 0.977393, 0.039260>, <-0.207271, 0.975132, 0.078459> }
triangle { <-0.207751, 0.977393, 0.039260>, <-0.258620, 0.965181, 0.039260>, <-0.258819, 0.965926, -0.000000> }
triangle { <-0.258819, 0.965926, -0.000000>, <-0.207912, 0.978148, -0.000000>, <-0.207751, 0.977393, 0.039260> }
triangle { <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <-0.012132, 0.037338, 0.999229> }
triangle { <-0.012132, 0.037338, 0.999229>, <-0.010161, 0.037922, 0.999229>, <0.000000, 0.000000, 1.000000> }
triangle { <-0.010161, 0.037922, 0.999229>, <-0.012132, 0.037338, 0.999229>, <-0.024245, 0.074619, 0.996917> }
triangle { <-0.024245, 0.074619, 0.996917>, <-0.020307, 0.075786, 0.996917>, <-0.010161, 0.037922, 0.999229> }
triangle { <-0.020307, 0.075786, 0.996917>, <-0.024245, 0.074619, 0.996917>, <-0.036321, 0.111785, 0.993068> }
triangle { <-0.036321, 0.111785, 0.993068>, <-0.030421, 0.113532, 0.993068>, <-0.020307, 0.075786, 0.996917> }
triangle { <-0.030421, 0.113532, 0.993068>, <-0.036321, 0.111785, 0.993068>, <-0.048341, 0.148778, 0.987688> }
triangle { <-0.048341, 0.148778, 0.987688>, <-0.040488, 0.151104, 0.987688>, <-0.030421, 0.113532, 0.993068> }
triangle { <-0.040488, 0.151104, 0.987688>, <-0.048341, 0.148778, 0.987688>, <-0.060286, 0.185542, 0.980785> }
triangle { <-0.060286, 0.185542, 0.980785>, <-0.050493, 0.188443, 0.980785>, <-0.040488, 0.151104, 0.987688> }
triangle { <-0.050493, 0.188443, 0.980785>, <-0.060286, 0.185542, 0.980785>, <-0.072139, 0.222020, 0.972370> }
triangle { <-0.072139, 0.222020, 0.972370>, <-0.060420, 0.225491, 0.972370>, <-0.050493, 0.188443, 0.980785> }
triangle { <-0.060420, 0.225491, 0.972370>, <-0.072139, 0.222020, 0.972370>, <-0.083880, 0.258155, 0.962455> }
triangle { <-0.083880, 0.258155, 0.962455>, <-0.070254, 0.262191, 0.962455>, <-0.060420, 0.225491, 0.972370> }
triangle { <-0.070254, 0.262191, 0.962455>, <-0.083880, 0.258155, 0.962455>, <-0.095492, 0.293893, 0.951057> }
triangle { <-0.095492, 0.293893, 0.951057>, <-0.079979, 0.298487, 0.951057>, <-0.070254, 0.262191, 0.962455> }
triangle { <-0.079979, 0.298487, 0.951057>, <-0.095492, 0.293893, 0.951057>, <-0.106956, 0.329177, 0.938191> }
triangle { <-0.106956, 0.329177, 0.938191>, <-0.089582, 0.334323, 0.938191>, <-0.079979, 0.298487, 0.951057> }
triangle { <-0.089582, 0.334323, 0.938191>, <-0.106956, 0.329177, 0.938191>, <-0.118256, 0.363954, 0.923880> }
triangle { <-0.118256, 0.363954, 0.923880>, <-0.099046, 0.369644, 0.923880>, <-0.089582, 0.334323, 0.938191> }
triangle { <-0.099046, 0.369644, 0.923880>, <-0.118256, 0.363954, 0.923880>, <-0.129373, 0.398169, 0.908143> }
triangle { <-0.129373, 0.398169, 0.908143>, <-0.108357, 0.404394, 0.908143>, <-0.099046, 0.369644, 0.923880> }
triangle { <-0.108357, 0.404394, 0.908143>, <-0.129373, 0.398169, 0.908143>, <-0.140291, 0.431771, 0.891007> }
triangle { <-0.140291, 0.431771, 0.891007>, <-0.117501, 0.438521, 0.891007>, <-0.108357, 0.404394, 0.908143> }
triangle { <-0.117501, 0.438521, 0.891007>, <-0.140291, 0.431771, 0.891007>, <-0.150992, 0.464706, 0.872496> }
triangle { <-0.150992, 0.464706, 0.872496>, <-0.126464, 0.471972, 0.872496>, <-0.117501, 0.438521, 0.891007> }
triangle { <-0.126464, 0.471972, 0.872496>, <-0.150992, 0.464706, 0.872496>, <-0.161461, 0.496926, 0.852640> }
triangle { <-0.161461, 0.496926, 0.852640>, <-0.135233, 0.504695, 0.852640>, <-0.126464, 0.471972, 0.872496> }
triangle { <-0.135233, 0.504695, 0.852640>, <-0.161461, 0.496926, 0.852640>, <-0.171681, 0.528379, 0.831470> }
triangle { <-0.171681, 0.528379, 0.831470>, <-0.143792, 0.536640, 0.831470>, <-0.135233, 0.504695, 0.852640> }
triangle { <-0.143792, 0.536640, 0.831470>, <-0.171681, 0.528379, 0.831470>, <-0.181636, 0.559017, 0.809017> }
triangle { <-0.181636, 0.559017, 0.809017>, <-0.152130, 0.567757, 0.809017>, <-0.143792, 0.536640, 0.831470> }
triangle { <-0.152130, 0.567757, 0.809017>, <-0.181636, 0.559017, 0.809017>, <-0.191311, 0.588793, 0.785317> }
triangle { <-0.191311, 0.588793, 0.785317>, <-0.160233, 0.597999, 0.785317>, <-0.152130, 0.567757, 0.809017> }
triangle { <-0.160233, 0.597999, 0.785317>, <-0.191311, 0.588793, 0.785317>, <-0.200690, 0.617662, 0.760406> }
triangle { <-0.200690, 0.617662, 0.760406>, <-0.168090, 0.627319, 0.760406>, <-0.160233, 0.597999, 0.785317> }
triangle { <-0.168090, 0.627319, 0.760406>, <-0.200690, 0.617662, 0.760406>, <-0.209761, 0.645578, 0.734323> }
triangle { <-0.209761, 0.645578, 0.734323>, <-0.175687, 0.655671, 0.734323>, <-0.168090, 0.627319, 0.760406> }
triangle { <-0.175687, 0.655671, 0.734323>, <-0.209761, 0.645578, 0.734323>, <-0.218508, 0.672499, 0.707107> }
triangle { <-0.218508, 0.672499, 0.707107>, <-0.183013, 0.683013, 0.707107>, <-0.175687, 0.655671, 0.734323> }
triangle { <-0.183013, 0.683013, 0.707107>, <-0.218508, 0.672499, 0.707107>, <-0.226918, 0.698382, 0.678801> }
triangle { <-0.226918, 0.698382, 0.678801>, <-0.190057, 0.709301, 0.678801>, <-0.183013, 0.683013, 0.707107> }
triangle { <-0.190057, 0.709301, 0.678801>, <-0.226918, 0.698382, 0.678801>, <-0.234978, 0.723189, 0.649448> }
triangle { <-0.234978, 0.723189, 0.649448>, <-0.196808, 0.734496, 0.649448>, <-0.190057, 0.709301, 0.678801> }
triangle { <-0.196808, 0.734496, 0.649448>, <-0.234978, 0.723189, 0.649448>, <-0.242676, 0.746881, 0.619094> }
triangle { <-0.242676, 0.746881, 0.619094>, <-0.203255, 0.758558, 0.619094>, <-0.196808, 0.734496, 0.649448> }
triangle { <-0.203255, 0.758558, 0.619094>, <-0.242676, 0.746881, 0.619094>, <-0.250000, 0.769421, 0.587785> }
triangle { <-0.250000, 0.769421, 0.587785>, <-0.209389, 0.781450, 0.587785>, <-0.203255, 0.758558, 0.619094> }
triangle { <-0.209389, 0.781450, 0.587785>, <-0.250000, 0.769421, 0.587785>, <-0.256938, 0.790775, 0.555570> }
triangle { <-0.256938, 0.790775, 0.555570>, <-0.215200, 0.803138, 0.555570>, <-0.209389, 0.781450, 0.587785> }
triangle { <-0.215200, 0.803138, 0.555570>, <-0.256938, 0.790775, 0.555570>, <-0.263480, 0.810909, 0.522499> }
triangle { <-0.263480, 0.810909, 0.522499>, <-0.220680, 0.823587, 0.522499>, <-0.215200, 0.803138, 0.555570> }
triangle { <-0.220680, 0.823587, 0.522499>, <-0.263480, 0.810909, 0.522499>, <-0.269616, 0.829793, 0.488621> }
triangle { <-0.269616, 0.829793, 0.488621>, <-0.225819, 0.842766, 0.488621>, <-0.220680, 0.823587, 0.522499> }
triangle { <-0.225819, 0.842766, 0.488621>, <-0.269616, 0.829793, 0.488621>, <-0.275336, 0.847398, 0.453990> }
triangle { <-0.275336, 0.847398, 0.453990>, <-0.230609, 0.860646, 0.453990>, <-0.225819, 0.842766, 0.488621> }
triangle { <-0.230609, 0.860646, 0.453990>, <-0.275336, 0.847398, 0.453990>, <-0.280632, 0.863695, 0.418660> }
triangle { <-0.280632, 0.863695, 0.418660>, <-0.235045, 0.877199, 0.418660>, <-0.230609, 0.860646, 0.453990> }
triangle { <-0.235045, 0.877199, 0.418660>, <-0.280632, 0.863695, 0.418660>, <-0.285494, 0.878662, 0.382683> }
triangle { <-0.285494, 0.878662, 0.382683>, <-0.239118, 0.892399, 0.382683>, <-0.235045, 0.877199, 0.418660> }
triangle { <-0.239118, 0.892399, 0.382683>, <-0.285494, 0.878662, 0.382683>, <-0.289917, 0.892273, 0.346117> }
triangle { <-0.289917, 0.892273, 0.346117>, <-0.242822, 0.906223, 0.346117>, <-0.239118, 0.892399, 0.382683> }
triangle { <-0.242822, 0.906223, 0.346117>, <-0.289917, 0.892273, 0.346117>, <-0.293893, 0.904508, 0.309017> }
triangle { <-0.293893, 0.904508, 0.309017>, <-0.246152, 0.918650, 0.309017>, <-0.242822, 0.906223, 0.346117> }
triangle { <-0.246152, 0.918650, 0.309017>, <-0.293893, 0.904508, 0.309017>, <-0.297415, 0.915349, 0.271440> }
triangle { <-0.297415, 0.915349, 0.271440>, <-0.249102, 0.929660, 0.271440>, <-0.246152, 0.918650, 0.309017> }
triangle { <-0.249102, 0.929660, 0.271440>, <-0.297415, 0.915349, 0.271440>, <-0.300479, 0.924779, 0.233445> }
triangle { <-0.300479, 0.924779, 0.233445>, <-0.251668, 0.939237, 0.233445>, <-0.249102, 0.929660, 0.271440> }
triangle { <-0.251668, 0.939237, 0.233445>, <-0.300479, 0.924779, 0.233445>, <-0.303079, 0.932782, 0.195090> }
triangle { <-0.303079, 0.932782, 0.195090>, <-0.253846, 0.947366, 0.195090>, <-0.251668, 0.939237, 0.233445> }
triangle { <-0.253846, 0.947366, 0.195090>, <-0.303079, 0.932782, 0.195090>, <-0.305212, 0.939347, 0.156434> }
triangle { <-0.305212, 0.939347, 0.156434>, <-0.255633, 0.954034, 0.156434>, <-0.253846, 0.947366, 0.195090> }
triangle { <-0.255633, 0.954034, 0.156434>, <-0.305212, 0.939347, 0.156434>, <-0.306875, 0.944464, 0.117537> }
triangle { <-0.306875, 0.944464, 0.117537>, <-0.257025, 0.959230, 0.117537>, <-0.255633, 0.954034, 0.156434> }
triangle { <-0.257025, 0.959230, 0.117537>, <-0.306875, 0.944464, 0.117537>, <-0.308064, 0.948125, 0.078459> }
triangle { <-0.308064, 0.948125, 0.078459>, <-0.258021, 0.962948, 0.078459>, <-0.257025, 0.959230, 0.117537> }
triangle { <-0.258021, 0.962948, 0.078459>, <-0.308064, 0.948125, 0.078459>, <-0.308779, 0.950323, 0.039260> }
triangle { <-0.308779, 0.950323, 0.039260>, <-0.258620, 0.965181, 0.039260>, <-0.258021, 0.962948, 0.078459> }
triangle { <-0.258620, 0.965181, 0.039260>, <-0.308779, 0.950323, 0.039260>, <-0.309017, 0.951057, -0.000000> }
triangle { <-0.309017, 0.951057, -0.000000>, <-0.258819, 0.965926, -0.000000>, <-0.258620, 0.965181, 0.039260> }
triangle { <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <-0.014069, 0.036652, 0.999229> }
triangle { <-0.014069, 0.036652, 0.999229>, <-0.012132, 0.037338, 0.999229>, <0.000000, 0.000000, 1.000000> }
triangle { <-0.012132, 0.037338, 0.999229>, <-0.014069, 0.036652, 0.999229>, <-0.028117, 0.073248, 0.996917> }
triangle { <-0.028117, 0.073248, 0.996917>, <-0.024245, 0.074619, 0.996917>, <-0.012132, 0.037338, 0.999229> }
triangle { <-0.024245, 0.074619, 0.996917>, <-0.028117, 0.073248, 0.996917>, <-0.042122, 0.109731, 0.993068> }
triangle { <-0.042122, 0.109731, 0.993068>, <-0.036321, 0.111785, 0.993068>, <-0.024245, 0.074619, 0.996917> }
triangle { <-0.036321, 0.111785, 0.993068>, <-0.042122, 0.109731, 0.993068>, <-0.056061, 0.146044, 0.987688> }
triangle { <-0.056061, 0.146044, 0.987688>, <-0.048341, 0.148778, 0.987688>, <-0.036321, 0.111785, 0.993068> }
triangle { <-0.048341, 0.148778, 0.987688>, <-0.056061, 0.146044, 0.987688>, <-0.069914, 0.182133, 0.980785> }
triangle { <-0.069914, 0.182133, 0.980785>, <-0.060286, 0.185542, 0.980785>, <-0.048341, 0.148778, 0.987688> }
triangle { <-0.060286, 0.185542, 0.980785>, <-0.069914, 0.182133, 0.980785>, <-0.083659, 0.217940, 0.972370> }
triangle { <-0.083659, 0.217940, 0.972370>, <-0.072139, 0.222020, 0.972370>, <-0.060286, 0.185542, 0.980785> }
triangle { <-0.072139, 0.222020, 0.972370>, <-0.083659, 0.217940, 0.972370>, <-0.097276, 0.253411, 0.962455> }
triangle { <-0.097276, 0.253411, 0.962455>, <-0.083880, 0.258155, 0.962455>, <-0.072139, 0.222020, 0.972370> }
triangle { <-0.083880, 0.258155, 0.962455>, <-0.097276, 0.253411, 0.962455>, <-0.110742, 0.288492, 0.951057> }
triangle { <-0.110742, 0.288492, 0.951057>, <-0.095492, 0.293893, 0.951057>, <-0.083880, 0.258155, 0.962455> }
triangle { <-0.095492, 0.293893, 0.951057>, <-0.110742, 0.288492, 0.951057>, <-0.124037, 0.323128, 0.938191> }
triangle { <-0.124037, 0.323128, 0.938191>, <-0.106956, 0.329177, 0.938191>, <-0.095492, 0.293893, 0.951057> }
triangle { <-0.106956, 0.329177, 0.938191>, <-0.124037, 0.323128, 0.938191>, <-0.137141, 0.357266, 0.923880> }
triangle { <-0.137141, 0.357266, 0.923880>, <-0.118256, 0.363954, 0.923880>, <-0.106956, 0.329177, 0.938191> }
triangle { <-0.118256, 0.363954, 0.923880>, <-0.137141, 0.357266, 0.923880>, <-0.150034, 0.390853, 0.908143> }
triangle { <-0.150034, 0.390853, 0.908143>, <-0.129373, 0.398169, 0.908143>, <-0.118256, 0.363954, 0.923880> }
triangle { <-0.129373, 0.398169, 0.908143>, <-0.150034, 0.390853, 0.908143>, <-0.162696, 0.423837, 0.891007> }
triangle { <-0.162696, 0.423837, 0.891007>, <-0.140291, 0.431771, 0.891007>, <-0.129373, 0.398169, 0.908143> }
triangle { <-0.140291, 0.431771, 0.891007>, <-0.162696, 0.423837, 0.891007>, <-0.175106, 0.456167, 0.872496> }
triangle { <-0.175106, 0.456167, 0.872496>, <-0.150992, 0.464706, 0.872496>, <-0.140291, 0.431771, 0.891007> }
triangle { <-0.150992, 0.464706, 0.872496>, <-0.175106, 0.456167, 0.872496>, <-0.187247, 0.487794, 0.852640> }
triangle { <-0.187247, 0.487794, 0.852640>, <-0.161461, 0.496926, 0.852640>, <-0.150992, 0.464706, 0.872496> }
triangle { <-0.161461, 0.496926, 0.852640>, <-0.187247, 0.487794, 0.852640>, <-0.199099, 0.518669, 0.831470> }
triangle { <-0.199099, 0.518669, 0.831470>, <-0.171681, 0.528379, 0.831470>, <-0.161461, 0.496926, 0.852640> }
triangle { <-0.171681, 0.528379, 0.831470>, <-0.199099, 0.518669, 0.831470>, <-0.210643, 0.548745, 0.809017> }
triangle { <-0.210643, 0.548745, 0.809017>, <-0.181636, 0.559017, 0.809017>, <-0.171681, 0.528379, 0.831470> }
triangle { <-0.181636, 0.559017, 0.809017>, <-0.210643, 0.548745, 0.809017>, <-0.221863, 0.577974, 0.785317> }
triangle { <-0.221863, 0.577974, 0.785317>, <-0.191311, 0.588793, 0.785317>, <-0.181636, 0.559017, 0.809017> }
triangle { <-0.191311, 0.588793, 0.785317>, <-0.221863, 0.577974, 0.785317>, <-0.232741, 0.606312, 0.760406> }
triangle { <-0.232741, 0.606312, 0.760406>, <-0.200690, 0.617662, 0.760406>, <-0.191311, 0.588793, 0.785317> }
triangle { <-0.200690, 0.617662, 0.760406>, <-0.232741, 0.606312, 0.760406>, <-0.243260, 0.633715, 0.734323> }
triangle { <-0.243260, 0.633715, 0.734323>, <-0.209761, 0.645578, 0.734323>, <-0.200690, 0.617662, 0.760406> }
triangle { <-0.209761, 0.645578, 0.734323>, <-0.243260, 0.633715, 0.734323>, <-0.253404, 0.660141, 0.707107> }
triangle { <-0.253404, 0.660141, 0.707107>, <-0.218508, 0.672499, 0.707107>, <-0.209761, 0.645578, 0.734323> }
triangle { <-0.218508, 0.672499, 0.707107>, <-0.253404, 0.660141, 0.707107>, <-0.263158, 0.685549, 0.678801> }
triangle { <-0.263158, 0.685549, 0.678801>, <-0.226918, 0.698382, 0.678801>, <-0.218508, 0.672499, 0.707107> }
triangle { <-0.226918, 0.698382, 0.678801>, <-0.263158, 0.685549, 0.678801>, <-0.272505, 0.709900, 0.649448> }
triangle { <-0.272505, 0.709900, 0.649448>, <-0.234978, 0.723189, 0.649448>, <-0.226918, 0.698382, 0.678801> }
triangle { <-0.234978, 0.723189, 0.649448>, <-0.272505, 0.709900, 0.649448>, <-0.281432, 0.733157, 0.619094> }
triangle { <-0.281432, 0.733157, 0.619094>, <-0.242676, 0.746881, 0.619094>, <-0.234978, 0.723189, 0.649448> }
triangle { <-0.242676, 0.746881, 0.619094>, <-0.281432, 0.733157, 0.619094>, <-0.289926, 0.755282, 0.587785> }
triangle { <-0.289926, 0.755282, 0.587785>, <-0.250000, 0.769421, 0.587785>, <-0.242676, 0.746881, 0.619094> }
triangle { <-0.250000, 0.769421, 0.587785>, <-0.289926, 0.755282, 0.587785>, <-0.297972, 0.776244, 0.555570> }
triangle { <-0.297972, 0.776244, 0.555570>, <-0.256938, 0.790775, 0.555570>, <-0.250000, 0.769421, 0.587785> }
triangle { <-0.256938, 0.790775, 0.555570>, <-0.297972, 0.776244, 0.555570>, <-0.305559, 0.796008, 0.522499> }
triangle { <-0.305559, 0.796008, 0.522499>, <-0.263480, 0.810909, 0.522499>, <-0.256938, 0.790775, 0.555570> }
triangle { <-0.263480, 0.810909, 0.522499>, <-0.305559, 0.796008, 0.522499>, <-0.312675, 0.814545, 0.488621> }
triangle { <-0.312675, 0.814545, 0.488621>, <-0.269616, 0.829793, 0.488621>, <-0.263480, 0.810909, 0.522499> }
triangle { <-0.269616, 0.829793, 0.488621>, <-0.312675, 0.814545, 0.488621>, <-0.319308, 0.831826, 0.453990> }
triangle { <-0.319308, 0.831826, 0.453990>, <-0.275336, 0.847398, 0.453990>, <-0.269616, 0.829793, 0.488621> }
triangle { <-0.275336, 0.847398, 0.453990>, <-0.319308, 0.831826, 0.453990>, <-0.325449, 0.847825, 0.418660> }
triangle { <-0.325449, 0.847825, 0.418660>, <-0.280632, 0.863695, 0.418660>, <-0.275336, 0.847398, 0.453990> }
triangle { <-0.280632, 0.863695, 0.418660>, <-0.325449, 0.847825, 0.418660>, <-0.331089, 0.862516, 0.382683> }
triangle { <-0.331089, 0.862516, 0.382683>, <-0.285494, 0.878662, 0.382683>, <-0.280632, 0.863695, 0.418660> }
triangle { <-0.285494, 0.878662, 0.382683>, <-0.331089, 0.862516, 0.382683>, <-0.336218, 0.875877, 0.346117> }
triangle { <-0.336218, 0.875877, 0.346117>, <-0.289917, 0.892273, 0.346117>, <-0.285494, 0.878662, 0.382683> }
triangle { <-0.289917, 0.892273, 0.346117>, <-0.336218, 0.875877, 0.346117>, <-0.340828, 0.887888, 0.309017> }
triangle { <-0.340828, 0.887888, 0.309017>, <-0.293893, 0.904508, 0.309017>, <-0.289917, 0.892273, 0.346117> }
triangle { <-0.293893, 0.904508, 0.309017>, <-0.340828, 0.887888, 0.309017>, <-0.344913, 0.898529, 0.271440> }
triangle { <-0.344913, 0.898529, 0.271440>, <-0.297415, 0.915349, 0.271440>, <-0.293893, 0.904508, 0.309017> }
triangle { <-0.297415, 0.915349, 0.271440>, <-0.344913, 0.898529, 0.271440>, <-0.348466, 0.907786, 0.233445> }
triangle { <-0.348466, 0.907786, 0.233445>, <-0.300479, 0.924779, 0.233445>, <-0.297415, 0.915349, 0.271440> }
triangle { <-0.300479, 0.924779, 0.233445>, <-0.348466, 0.907786, 0.233445>, <-0.351482, 0.915642, 0.195090> }
triangle { <-0.351482, 0.915642, 0.195090>, <-0.303079, 0.932782, 0.195090>, <-0.300479, 0.924779, 0.233445> }
triangle { <-0.303079, 0.932782, 0.195090>, <-0.351482, 0.915642, 0.195090>, <-0.353956, 0.922087, 0.156434> }
triangle { <-0.353956, 0.922087, 0.156434>, <-0.305212, 0.939347, 0.156434>, <-0.303079, 0.932782, 0.195090> }
triangle { <-0.305212, 0.939347, 0.156434>, <-0.353956, 0.922087, 0.156434>, <-0.355884, 0.927109, 0.117537> }
triangle { <-0.355884, 0.927109, 0.117537>, <-0.306875, 0.944464, 0.117537>, <-0.305212, 0.939347, 0.156434> }
triangle { <-0.306875, 0.944464, 0.117537>, <-0.355884, 0.927109, 0.117537>, <-0.357263, 0.930703, 0.078459> }
triangle { <-0.357263, 0.930703, 0.078459>, <-0.308064, 0.948125, 0.078459>, <-0.306875, 0.944464, 0.117537> }
triangle { <-0.308064, 0.948125, 0.078459>, <-0.357263, 0.930703, 0.078459>, <-0.358092, 0.932861, 0.039260> }
triangle { <-0.358092, 0.932861, 0.039260>, <-0.308779, 0.950323, 0.039260>, <-0.308064, 0.948125, 0.078459> }
triangle { <-0.308779, 0.950323, 0.039260>, <-0.358092, 0.932861, 0.039260>, <-0.358368, 0.933580, -0.000000> }
triangle { <-0.358368, 0.933580, -0.000000>, <-0.309017, 0.951057, -0.000000>, <-0.308779, 0.950323, 0.039260> }
triangle { <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <-0.015968, 0.035866, 0.999229> }
triangle { <-0.015968, 0.035866, 0.999229>, <-0.014069, 0.036652, 0.999229>, <0.000000, 0.000000, 1.000000> }
triangle { <-0.014069, 0.036652, 0.999229>, <-0.015968, 0.035866, 0.999229>, <-0.031912, 0.071676, 0.996917> }
triangle { <-0.031912, 0.071676, 0.996917>, <-0.028117, 0.073248, 0.996917>, <-0.014069, 0.036652, 0.999229> }
triangle { <-0.028117, 0.073248, 0.996917>, <-0.031912, 0.071676, 0.996917>, <-0.047807, 0.107376, 0.993068> }
triangle { <-0.047807, 0.107376, 0.993068>, <-0.042122, 0.109731, 0.993068>, <-0.028117, 0.073248, 0.996917> }
triangle { <-0.042122, 0.109731, 0.993068>, <-0.047807, 0.107376, 0.993068>, <-0.063628, 0.142910, 0.987688> }
triangle { <-0.063628, 0.142910, 0.987688>, <-0.056061, 0.146044, 0.987688>, <-0.042122, 0.109731, 0.993068> }
triangle { <-0.056061, 0.146044, 0.987688>, <-0.063628, 0.142910, 0.987688>, <-0.079350, 0.178224, 0.980785> }
triangle { <-0.079350, 0.178224, 0.980785>, <-0.069914, 0.182133, 0.980785>, <-0.056061, 0.146044, 0.987688> }
triangle { <-0.069914, 0.182133, 0.980785>, <-0.079350, 0.178224, 0.980785>, <-0.094951, 0.213263, 0.972370> }
triangle { <-0.094951, 0.213263, 0.972370>, <-0.083659, 0.217940, 0.972370>, <-0.069914, 0.182133, 0.980785> }
triangle { <-0.083659, 0.217940, 0.972370>, <-0.094951, 0.213263, 0.972370>, <-0.110405, 0.247973, 0.962455> }
triangle { <-0.110405, 0.247973, 0.962455>, <-0.097276, 0.253411, 0.962455>, <-0.083659, 0.217940, 0.972370> }
triangle { <-0.097276, 0.253411, 0.962455>, <-0.110405, 0.247973, 0.962455>, <-0.125689, 0.282301, 0.951057> }
triangle { <-0.125689, 0.282301, 0.951057>, <-0.110742, 0.288492, 0.951057>, <-0.097276, 0.253411, 0.962455> }
triangle { <-0.110742, 0.288492, 0.951057>, <-0.125689, 0.282301, 0.951057>, <-0.140778, 0.316194, 0.938191> }
triangle { <-0.140778, 0.316194, 0.938191>, <-0.124037, 0.323128, 0.938191>, <-0.110742, 0.288492, 0.951057> }
triangle { <-0.124037, 0.323128, 0.938191>, <-0.140778, 0.316194, 0.938191>, <-0.155651, 0.349599, 0.923880> }
triangle { <-0.155651, 0.349599, 0.923880>, <-0.137141, 0.357266, 0.923880>, <-0.124037, 0.323128, 0.938191> }
triangle { <-0.137141, 0.357266, 0.923880>, <-0.155651, 0.349599, 0.923880>, <-0.170284, 0.382465, 0.908143> }
triangle { <-0.170284, 0.382465, 0.908143>, <-0.150034, 0.390853, 0.908143>, <-0.137141, 0.357266, 0.923880> }
triangle { <-0.150034, 0.390853, 0.908143>, <-0.170284, 0.382465, 0.908143>, <-0.184655, 0.414741, 0.891007> }
triangle { <-0.184655, 0.414741, 0.891007>, <-0.162696, 0.423837, 0.891007>, <-0.150034, 0.390853, 0.908143> }
triangle { <-0.162696, 0.423837, 0.891007>, <-0.184655, 0.414741, 0.891007>, <-0.198740, 0.446378, 0.872496> }
triangle { <-0.198740, 0.446378, 0.872496>, <-0.175106, 0.456167, 0.872496>, <-0.162696, 0.423837, 0.891007> }
triangle { <-0.175106, 0.456167, 0.872496>, <-0.198740, 0.446378, 0.872496>, <-0.212519, 0.477326, 0.852640> }
triangle { <-0.212519, 0.477326, 0.852640>, <-0.187247, 0.487794, 0.852640>, <-0.175106, 0.456167, 0.872496> }
triangle { <-0.187247, 0.487794, 0.852640>, <-0.212519, 0.477326, 0.852640>, <-0.225971, 0.507539, 0.831470> }
triangle { <-0.225971, 0.507539, 0.831470>, <-0.199099, 0.518669, 0.831470>, <-0.187247, 0.487794, 0.852640> }
triangle { <-0.199099, 0.518669, 0.831470>, <-0.225971, 0.507539, 0.831470>, <-0.239074, 0.536969, 0.809017> }
triangle { <-0.239074, 0.536969, 0.809017>, <-0.210643, 0.548745, 0.809017>, <-0.199099, 0.518669, 0.831470> }
triangle { <-0.210643, 0.548745, 0.809017>, <-0.239074, 0.536969, 0.809017>, <-0.251808, 0.565570, 0.785317> }
triangle { <-0.251808, 0.565570, 0.785317>, <-0.221863, 0.577974, 0.785317>, <-0.210643, 0.548745, 0.809017> }
triangle { <-0.221863, 0.577974, 0.785317>, <-0.251808, 0.565570, 0.785317>, <-0.264154, 0.593300, 0.760406> }
triangle { <-0.264154, 0.593300, 0.760406>, <-0.232741, 0.606312, 0.760406>, <-0.221863, 0.577974, 0.785317> }
triangle { <-0.232741, 0.606312, 0.760406>, <-0.264154, 0.593300, 0.760406>, <-0.276093, 0.620115, 0.734323> }
triangle { <-0.276093, 0.620115, 0.734323>, <-0.243260, 0.633715, 0.734323>, <-0.232741, 0.606312, 0.760406> }
triangle { <-0.243260, 0.633715, 0.734323>, <-0.276093, 0.620115, 0.734323>, <-0.287606, 0.645974, 0.707107> }
triangle { <-0.287606, 0.645974, 0.707107>, <-0.253404, 0.660141, 0.707107>, <-0.243260, 0.633715, 0.734323> }
triangle { <-0.253404, 0.660141, 0.707107>, <-0.287606, 0.645974, 0.707107>, <-0.298676, 0.670837, 0.678801> }
triangle { <-0.298676, 0.670837, 0.678801>, <-0.263158, 0.685549, 0.678801>, <-0.253404, 0.660141, 0.707107> }
triangle { <-0.263158, 0.685549, 0.678801>, <-0.298676, 0.670837, 0.678801>, <-0.309285, 0.694665, 0.649448> }
triangle { <-0.309285, 0.694665, 0.649448>, <-0.272505, 0.709900, 0.649448>, <-0.263158, 0.685549, 0.678801> }
triangle { <-0.272505, 0.709900, 0.649448>, <-0.309285, 0.694665, 0.649448>, <-0.319417, 0.717423, 0.619094> }
triangle { <-0.319417, 0.717423, 0.619094>, <-0.281432, 0.733157, 0.619094>, <-0.272505, 0.709900, 0.649448> }
triangle { <-0.281432, 0.733157, 0.619094>, <-0.319417, 0.717423, 0.619094>, <-0.329057, 0.739074, 0.587785> }
triangle { <-0.329057, 0.739074, 0.587785>, <-0.289926, 0.755282, 0.587785>, <-0.281432, 0.733157, 0.619094> }
triangle { <-0.289926, 0.755282, 0.587785>, <-0.329057, 0.739074, 0.587785>, <-0.338189, 0.759585, 0.555570> }
triangle { <-0.338189, 0.759585, 0.555570>, <-0.297972, 0.776244, 0.555570>, <-0.289926, 0.755282, 0.587785> }
triangle { <-0.297972, 0.776244, 0.555570>, <-0.338189, 0.759585, 0.555570>, <-0.346800, 0.778926, 0.522499> }
triangle { <-0.346800, 0.778926, 0.522499>, <-0.305559, 0.796008, 0.522499>, <-0.297972, 0.776244, 0.555570> }
triangle { <-0.305559, 0.796008, 0.522499>, <-0.346800, 0.778926, 0.522499>, <-0.354876, 0.797065, 0.488621> }
triangle { <-0.354876, 0.797065, 0.488621>, <-0.312675, 0.814545, 0.488621>, <-0.305559, 0.796008, 0.522499> }
triangle { <-0.312675, 0.814545, 0.488621>, <-0.354876, 0.797065, 0.488621>, <-0.362405, 0.813975, 0.453990> }
triangle { <-0.362405, 0.813975, 0.453990>, <-0.319308, 0.831826, 0.453990>, <-0.312675, 0.814545, 0.488621> }
triangle { <-0.319308, 0.831826, 0.453990>, <-0.362405, 0.813975, 0.453990>, <-0.369375, 0.829630, 0.418660> }
triangle { <-0.369375, 0.829630, 0.418660>, <-0.325449, 0.847825, 0.418660>, <-0.319308, 0.831826, 0.453990> }
triangle { <-0.325449, 0.847825, 0.418660>, <-0.369375, 0.829630, 0.418660>, <-0.375776, 0.844006, 0.382683> }
triangle { <-0.375776, 0.844006, 0.382683>, <-0.331089, 0.862516, 0.382683>, <-0.325449, 0.847825, 0.418660> }
triangle { <-0.331089, 0.862516, 0.382683>, <-0.375776, 0.844006, 0.382683>, <-0.381597, 0.857080, 0.346117> }
triangle { <-0.381597, 0.857080, 0.346117>, <-0.336218, 0.875877, 0.346117>, <-0.331089, 0.862516, 0.382683> }
triangle { <-0.336218, 0.875877, 0.346117>, <-0.381597, 0.857080, 0.346117>, <-0.386830, 0.868833, 0.309017> }
triangle { <-0.386830, 0.868833, 0.309017>, <-0.340828, 0.887888, 0.309017>, <-0.336218, 0.875877, 0.346117> }
triangle { <-0.340828, 0.887888, 0.309017>, <-0.386830, 0.868833, 0.309017>, <-0.391466, 0.879247, 0.271440> }
triangle { <-0.391466, 0.879247, 0.271440>, <-0.344913, 0.898529, 0.271440>, <-0.340828, 0.887888, 0.309017> }
triangle { <-0.344913, 0.898529, 0.271440>, <-0.391466, 0.879247, 0.271440>, <-0.395498, 0.888304, 0.233445> }
triangle { <-0.395498, 0.888304, 0.233445>, <-0.348466, 0.907786, 0.233445>, <-0.344913, 0.898529, 0.271440> }
triangle { <-0.348466, 0.907786, 0.233445>, <-0.395498, 0.888304, 0.233445>, <-0.398921, 0.895992, 0.195090> }
triangle { <-0.398921, 0.895992, 0.195090>, <-0.351482, 0.915642, 0.195090>, <-0.348466, 0.907786, 0.233445> }
triangle { <-0.351482, 0.915642, 0.195090>, <-0.398921, 0.895992, 0.195090>, <-0.401729, 0.902298, 0.156434> }
triangle { <-0.401729, 0.902298, 0.156434>, <-0.353956, 0.922087, 0.156434>, <-0.351482, 0.915642, 0.195090> }
triangle { <-0.353956, 0.922087, 0.156434>, <-0.401729, 0.902298, 0.156434>, <-0.403917, 0.907213, 0.117537> }
triangle { <-0.403917, 0.907213, 0.117537>, <-0.355884, 0.927109, 0.117537>, <-0.353956, 0.922087, 0.156434> }
triangle { <-0.355884, 0.927109, 0.117537>, <-0.403917, 0.907213, 0.117537>, <-0.405483, 0.910729, 0.078459> }
triangle { <-0.405483, 0.910729, 0.078459>, <-0.357263, 0.930703, 0.078459>, <-0.355884, 0.927109, 0.117537> }
triangle { <-0.357263, 0.930703, 0.078459>, <-0.405483, 0.910729, 0.078459>, <-0.406423, 0.912841, 0.039260> }
triangle { <-0.406423, 0.912841, 0.039260>, <-0.358092, 0.932861, 0.039260>, <-0.357263, 0.930703, 0.078459> }
triangle { <-0.358092, 0.932861, 0.039260>, <-0.406423, 0.912841, 0.039260>, <-0.406737, 0.913545, -0.000000> }
triangle { <-0.406737, 0.913545, -0.000000>, <-0.358368, 0.933580, -0.000000>, <-0.358092, 0.932861, 0.039260> }
triangle { <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <-0.017824, 0.034981, 0.999229> }
triangle { <-0.017824, 0.034981, 0.999229>, <-0.015968, 0.035866, 0.999229>, <0.000000, 0.000000, 1.000000> }
triangle { <-0.015968, 0.035866, 0.999229>, <-0.017824, 0.034981, 0.999229>, <-0.035620, 0.069908, 0.996917> }
triangle { <-0.035620, 0.069908, 0.996917>, <-0.031912, 0.071676, 0.996917>, <-0.015968, 0.035866, 0.999229> }
triangle { <-0.031912, 0.071676, 0.996917>, <-0.035620, 0.069908, 0.996917>, <-0.053361, 0.104727, 0.993068> }
triangle { <-0.053361, 0.104727, 0.993068>, <-0.047807, 0.107376, 0.993068>, <-0.031912, 0.071676, 0.996917> }
triangle { <-0.047807, 0.107376, 0.993068>, <-0.053361, 0.104727, 0.993068>, <-0.071020, 0.139384, 0.987688> }
triangle { <-0.071020, 0.139384, 0.987688>, <-0.063628, 0.142910, 0.987688>, <-0.047807, 0.107376, 0.993068> }
triangle { <-0.063628, 0.142910, 0.987688>, <-0.071020, 0.139384, 0.987688>, <-0.088569, 0.173827, 0.980785> }
triangle { <-0.088569, 0.173827, 0.980785>, <-0.079350, 0.178224, 0.980785>, <-0.063628, 0.142910, 0.987688> }
triangle { <-0.079350, 0.178224, 0.980785>, <-0.088569, 0.173827, 0.980785>, <-0.105982, 0.208001, 0.972370> }
triangle { <-0.105982, 0.208001, 0.972370>, <-0.094951, 0.213263, 0.972370>, <-0.079350, 0.178224, 0.980785> }
triangle { <-0.094951, 0.213263, 0.972370>, <-0.105982, 0.208001, 0.972370>, <-0.123231, 0.241855, 0.962455> }
triangle { <-0.123231, 0.241855, 0.962455>, <-0.110405, 0.247973, 0.962455>, <-0.094951, 0.213263, 0.972370> }
triangle { <-0.110405, 0.247973, 0.962455>, <-0.123231, 0.241855, 0.962455>, <-0.140291, 0.275336, 0.951057> }
triangle { <-0.140291, 0.275336, 0.951057>, <-0.125689, 0.282301, 0.951057>, <-0.110405, 0.247973, 0.962455> }
triangle { <-0.125689, 0.282301, 0.951057>, <-0.140291, 0.275336, 0.951057>, <-0.157134, 0.308393, 0.938191> }
triangle { <-0.157134, 0.308393, 0.938191>, <-0.140778, 0.316194, 0.938191>, <-0.125689, 0.282301, 0.951057> }
triangle { <-0.140778, 0.316194, 0.938191>, <-0.157134, 0.308393, 0.938191>, <-0.173735, 0.340973, 0.923880> }
triangle { <-0.173735, 0.340973, 0.923880>, <-0.155651, 0.349599, 0.923880>, <-0.140778, 0.316194, 0.938191> }
triangle { <-0.155651, 0.349599, 0.923880>, <-0.173735, 0.340973, 0.923880>, <-0.190068, 0.373029, 0.908143> }
triangle { <-0.190068, 0.373029, 0.908143>, <-0.170284, 0.382465, 0.908143>, <-0.155651, 0.349599, 0.923880> }
triangle { <-0.170284, 0.382465, 0.908143>, <-0.190068, 0.373029, 0.908143>, <-0.206107, 0.404508, 0.891007> }
triangle { <-0.206107, 0.404508, 0.891007>, <-0.184655, 0.414741, 0.891007>, <-0.170284, 0.382465, 0.908143> }
triangle { <-0.184655, 0.414741, 0.891007>, <-0.206107, 0.404508, 0.891007>, <-0.221829, 0.435365, 0.872496> }
triangle { <-0.221829, 0.435365, 0.872496>, <-0.198740, 0.446378, 0.872496>, <-0.184655, 0.414741, 0.891007> }
triangle { <-0.198740, 0.446378, 0.872496>, <-0.221829, 0.435365, 0.872496>, <-0.237209, 0.465550, 0.852640> }
triangle { <-0.237209, 0.465550, 0.852640>, <-0.212519, 0.477326, 0.852640>, <-0.198740, 0.446378, 0.872496> }
triangle { <-0.212519, 0.477326, 0.852640>, <-0.237209, 0.465550, 0.852640>, <-0.252224, 0.495017, 0.831470> }
triangle { <-0.252224, 0.495017, 0.831470>, <-0.225971, 0.507539, 0.831470>, <-0.212519, 0.477326, 0.852640> }
triangle { <-0.225971, 0.507539, 0.831470>, <-0.252224, 0.495017, 0.831470>, <-0.266849, 0.523720, 0.809017> }
triangle { <-0.266849, 0.523720, 0.809017>, <-0.239074, 0.536969, 0.809017>, <-0.225971, 0.507539, 0.831470> }
triangle { <-0.239074, 0.536969, 0.809017>, <-0.266849, 0.523720, 0.809017>, <-0.281063, 0.551617, 0.785317> }
triangle { <-0.281063, 0.551617, 0.785317>, <-0.251808, 0.565570, 0.785317>, <-0.239074, 0.536969, 0.809017> }
triangle { <-0.251808, 0.565570, 0.785317>, <-0.281063, 0.551617, 0.785317>, <-0.294843, 0.578662, 0.760406> }
triangle { <-0.294843, 0.578662, 0.760406>, <-0.264154, 0.593300, 0.760406>, <-0.251808, 0.565570, 0.785317> }
triangle { <-0.264154, 0.593300, 0.760406>, <-0.294843, 0.578662, 0.760406>, <-0.308169, 0.604816, 0.734323> }
triangle { <-0.308169, 0.604816, 0.734323>, <-0.276093, 0.620115, 0.734323>, <-0.264154, 0.593300, 0.760406> }
triangle { <-0.276093, 0.620115, 0.734323>, <-0.308169, 0.604816, 0.734323>, <-0.321020, 0.630037, 0.707107> }
triangle { <-0.321020, 0.630037, 0.707107>, <-0.287606, 0.645974, 0.707107>, <-0.276093, 0.620115, 0.734323> }
triangle { <-0.287606, 0.645974, 0.707107>, <-0.321020, 0.630037, 0.707107>, <-0.333375, 0.654286, 0.678801> }
triangle { <-0.333375, 0.654286, 0.678801>, <-0.298676, 0.670837, 0.678801>, <-0.287606, 0.645974, 0.707107> }
triangle { <-0.298676, 0.670837, 0.678801>, <-0.333375, 0.654286, 0.678801>, <-0.345217, 0.677527, 0.649448> }
triangle { <-0.345217, 0.677527, 0.649448>, <-0.309285, 0.694665, 0.649448>, <-0.298676, 0.670837, 0.678801> }
triangle { <-0.309285, 0.694665, 0.649448>, <-0.345217, 0.677527, 0.649448>, <-0.356526, 0.699723, 0.619094> }
triangle { <-0.356526, 0.699723, 0.619094>, <-0.319417, 0.717423, 0.619094>, <-0.309285, 0.694665, 0.649448> }
triangle { <-0.319417, 0.717423, 0.619094>, <-0.356526, 0.699723, 0.619094>, <-0.367286, 0.720839, 0.587785> }
triangle { <-0.367286, 0.720839, 0.587785>, <-0.329057, 0.739074, 0.587785>, <-0.319417, 0.717423, 0.619094> }
triangle { <-0.329057, 0.739074, 0.587785>, <-0.367286, 0.720839, 0.587785>, <-0.377479, 0.740845, 0.555570> }
triangle { <-0.377479, 0.740845, 0.555570>, <-0.338189, 0.759585, 0.555570>, <-0.329057, 0.739074, 0.587785> }
triangle { <-0.338189, 0.759585, 0.555570>, <-0.377479, 0.740845, 0.555570>, <-0.387091, 0.759708, 0.522499> }
triangle { <-0.387091, 0.759708, 0.522499>, <-0.346800, 0.778926, 0.522499>, <-0.338189, 0.759585, 0.555570> }
triangle { <-0.346800, 0.778926, 0.522499>, <-0.387091, 0.759708, 0.522499>, <-0.396105, 0.777400, 0.488621> }
triangle { <-0.396105, 0.777400, 0.488621>, <-0.354876, 0.797065, 0.488621>, <-0.346800, 0.778926, 0.522499> }
triangle { <-0.354876, 0.797065, 0.488621>, <-0.396105, 0.777400, 0.488621>, <-0.404508, 0.793893, 0.453990> }
triangle { <-0.404508, 0.793893, 0.453990>, <-0.362405, 0.813975, 0.453990>, <-0.354876, 0.797065, 0.488621> }
triangle { <-0.362405, 0.813975, 0.453990>, <-0.404508, 0.793893, 0.453990>, <-0.412288, 0.809161, 0.418660> }
triangle { <-0.412288, 0.809161, 0.418660>, <-0.369375, 0.829630, 0.418660>, <-0.362405, 0.813975, 0.453990> }
triangle { <-0.369375, 0.829630, 0.418660>, <-0.412288, 0.809161, 0.418660>, <-0.419433, 0.823183, 0.382683> }
triangle { <-0.419433, 0.823183, 0.382683>, <-0.375776, 0.844006, 0.382683>, <-0.369375, 0.829630, 0.418660> }
triangle { <-0.375776, 0.844006, 0.382683>, <-0.419433, 0.823183, 0.382683>, <-0.425930, 0.835935, 0.346117> }
triangle { <-0.425930, 0.835935, 0.346117>, <-0.381597, 0.857080, 0.346117>, <-0.375776, 0.844006, 0.382683> }
triangle { <-0.381597, 0.857080, 0.346117>, <-0.425930, 0.835935, 0.346117>, <-0.431771, 0.847398, 0.309017> }
triangle { <-0.431771, 0.847398, 0.309017>, <-0.386830, 0.868833, 0.309017>, <-0.381597, 0.857080, 0.346117> }
triangle { <-0.386830, 0.868833, 0.309017>, <-0.431771, 0.847398, 0.309017>, <-0.436946, 0.857554, 0.271440> }
triangle { <-0.436946, 0.857554, 0.271440>, <-0.391466, 0.879247, 0.271440>, <-0.386830, 0.868833, 0.309017> }
triangle { <-0.391466, 0.879247, 0.271440>, <-0.436946, 0.857554, 0.271440>, <-0.441447, 0.866388, 0.233445> }
triangle { <-0.441447, 0.866388, 0.233445>, <-0.395498, 0.888304, 0.233445>, <-0.391466, 0.879247, 0.271440> }
triangle { <-0.395498, 0.888304, 0.233445>, <-0.441447, 0.866388, 0.233445>, <-0.445267, 0.873886, 0.195090> }
triangle { <-0.445267, 0.873886, 0.195090>, <-0.398921, 0.895992, 0.195090>, <-0.395498, 0.888304, 0.233445> }
triangle { <-0.398921, 0.895992, 0.195090>, <-0.445267, 0.873886, 0.195090>, <-0.448401, 0.880037, 0.156434> }
triangle { <-0.448401, 0.880037, 0.156434>, <-0.401729, 0.902298, 0.156434>, <-0.398921, 0.895992, 0.195090> }
triangle { <-0.401729, 0.902298, 0.156434>, <-0.448401, 0.880037, 0.156434>, <-0.450844, 0.884830, 0.117537> }
triangle { <-0.450844, 0.884830, 0.117537>, <-0.403917, 0.907213, 0.117537>, <-0.401729, 0.902298, 0.156434> }
triangle { <-0.403917, 0.907213, 0.117537>, <-0.450844, 0.884830, 0.117537>, <-0.452591, 0.888260, 0.078459> }
triangle { <-0.452591, 0.888260, 0.078459>, <-0.405483, 0.910729, 0.078459>, <-0.403917, 0.907213, 0.117537> }
triangle { <-0.405483, 0.910729, 0.078459>, <-0.452591, 0.888260, 0.078459>, <-0.453640, 0.890320, 0.039260> }
triangle { <-0.453640, 0.890320, 0.039260>, <-0.406423, 0.912841, 0.039260>, <-0.405483, 0.910729, 0.078459> }
triangle { <-0.406423, 0.912841, 0.039260>, <-0.453640, 0.890320, 0.039260>, <-0.453990, 0.891007, -0.000000> }
triangle { <-0.453990, 0.891007, -0.000000>, <-0.406737, 0.913545, -0.000000>, <-0.406423, 0.912841, 0.039260> }
triangle { <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <-0.019630, 0.034000, 0.999229> }
triangle { <-0.019630, 0.034000, 0.999229>, <-0.017824, 0.034981, 0.999229>, <0.000000, 0.000000, 1.000000> }
triangle { <-0.017824, 0.034981, 0.999229>, <-0.019630, 0.034000, 0.999229>, <-0.039230, 0.067948, 0.996917> }
triangle { <-0.039230, 0.067948, 0.996917>, <-0.035620, 0.069908, 0.996917>, <-0.017824, 0.034981, 0.999229> }
triangle { <-0.035620, 0.069908, 0.996917>, <-0.039230, 0.067948, 0.996917>, <-0.058769, 0.101790, 0.993068> }
triangle { <-0.058769, 0.101790, 0.993068>, <-0.053361, 0.104727, 0.993068>, <-0.035620, 0.069908, 0.996917> }
triangle { <-0.053361, 0.104727, 0.993068>, <-0.058769, 0.101790, 0.993068>, <-0.078217, 0.135476, 0.987688> }
triangle { <-0.078217, 0.135476, 0.987688>, <-0.071020, 0.139384, 0.987688>, <-0.053361, 0.104727, 0.993068> }
triangle { <-0.071020, 0.139384, 0.987688>, <-0.078217, 0.135476, 0.987688>, <-0.097545, 0.168953, 0.980785> }
triangle { <-0.097545, 0.168953, 0.980785>, <-0.088569, 0.173827, 0.980785>, <-0.071020, 0.139384, 0.987688> }
triangle { <-0.088569, 0.173827, 0.980785>, <-0.097545, 0.168953, 0.980785>, <-0.116723, 0.202170, 0.972370> }
triangle { <-0.116723, 0.202170, 0.972370>, <-0.105982, 0.208001, 0.972370>, <-0.088569, 0.173827, 0.980785> }
triangle { <-0.105982, 0.208001, 0.972370>, <-0.116723, 0.202170, 0.972370>, <-0.135720, 0.235074, 0.962455> }
triangle { <-0.135720, 0.235074, 0.962455>, <-0.123231, 0.241855, 0.962455>, <-0.105982, 0.208001, 0.972370> }
triangle { <-0.123231, 0.241855, 0.962455>, <-0.135720, 0.235074, 0.962455>, <-0.154508, 0.267617, 0.951057> }
triangle { <-0.154508, 0.267617, 0.951057>, <-0.140291, 0.275336, 0.951057>, <-0.123231, 0.241855, 0.962455> }
triangle { <-0.140291, 0.275336, 0.951057>, <-0.154508, 0.267617, 0.951057>, <-0.173059, 0.299746, 0.938191> }
triangle { <-0.173059, 0.299746, 0.938191>, <-0.157134, 0.308393, 0.938191>, <-0.140291, 0.275336, 0.951057> }
triangle { <-0.157134, 0.308393, 0.938191>, <-0.173059, 0.299746, 0.938191>, <-0.191342, 0.331414, 0.923880> }
triangle { <-0.191342, 0.331414, 0.923880>, <-0.173735, 0.340973, 0.923880>, <-0.157134, 0.308393, 0.938191> }
triangle { <-0.173735, 0.340973, 0.923880>, <-0.191342, 0.331414, 0.923880>, <-0.209330, 0.362570, 0.908143> }
triangle { <-0.209330, 0.362570, 0.908143>, <-0.190068, 0.373029, 0.908143>, <-0.173735, 0.340973, 0.923880> }
triangle { <-0.190068, 0.373029, 0.908143>, <-0.209330, 0.362570, 0.908143>, <-0.226995, 0.393167, 0.891007> }
triangle { <-0.226995, 0.393167, 0.891007>, <-0.206107, 0.404508, 0.891007>, <-0.190068, 0.373029, 0.908143> }
triangle { <-0.206107, 0.404508, 0.891007>, <-0.226995, 0.393167, 0.891007>, <-0.244311, 0.423158, 0.872496> }
triangle { <-0.244311, 0.423158, 0.872496>, <-0.221829, 0.435365, 0.872496>, <-0.206107, 0.404508, 0.891007> }
triangle { <-0.221829, 0.435365, 0.872496>, <-0.244311, 0.423158, 0.872496>, <-0.261249, 0.452497, 0.852640> }
triangle { <-0.261249, 0.452497, 0.852640>, <-0.237209, 0.465550, 0.852640>, <-0.221829, 0.435365, 0.872496> }
triangle { <-0.237209, 0.465550, 0.852640>, <-0.261249, 0.452497, 0.852640>, <-0.277785, 0.481138, 0.831470> }
triangle { <-0.277785, 0.481138, 0.831470>, <-0.252224, 0.495017, 0.831470>, <-0.237209, 0.465550, 0.852640> }
triangle { <-0.252224, 0.495017, 0.831470>, <-0.277785, 0.481138, 0.831470>, <-0.293893, 0.509037, 0.809017> }
triangle { <-0.293893, 0.509037, 0.809017>, <-0.266849, 0.523720, 0.809017>, <-0.252224, 0.495017, 0.831470> }
triangle { <-0.266849, 0.523720, 0.809017>, <-0.293893, 0.509037, 0.809017>, <-0.309547, 0.536151, 0.785317> }
triangle { <-0.309547, 0.536151, 0.785317>, <-0.281063, 0.551617, 0.785317>, <-0.266849, 0.523720, 0.809017> }
triangle { <-0.281063, 0.551617, 0.785317>, <-0.309547, 0.536151, 0.785317>, <-0.324724, 0.562439, 0.760406> }
triangle { <-0.324724, 0.562439, 0.760406>, <-0.294843, 0.578662, 0.760406>, <-0.281063, 0.551617, 0.785317> }
triangle { <-0.294843, 0.578662, 0.760406>, <-0.324724, 0.562439, 0.760406>, <-0.339400, 0.587859, 0.734323> }
triangle { <-0.339400, 0.587859, 0.734323>, <-0.308169, 0.604816, 0.734323>, <-0.294843, 0.578662, 0.760406> }
triangle { <-0.308169, 0.604816, 0.734323>, <-0.339400, 0.587859, 0.734323>, <-0.353553, 0.612372, 0.707107> }
triangle { <-0.353553, 0.612372, 0.707107>, <-0.321020, 0.630037, 0.707107>, <-0.308169, 0.604816, 0.734323> }
triangle { <-0.321020, 0.630037, 0.707107>, <-0.353553, 0.612372, 0.707107>, <-0.367161, 0.635942, 0.678801> }
triangle { <-0.367161, 0.635942, 0.678801>, <-0.333375, 0.654286, 0.678801>, <-0.321020, 0.630037, 0.707107> }
triangle { <-0.333375, 0.654286, 0.678801>, <-0.367161, 0.635942, 0.678801>, <-0.380203, 0.658531, 0.649448> }
triangle { <-0.380203, 0.658531, 0.649448>, <-0.345217, 0.677527, 0.649448>, <-0.333375, 0.654286, 0.678801> }
triangle { <-0.345217, 0.677527, 0.649448>, <-0.380203, 0.658531, 0.649448>, <-0.392658, 0.680104, 0.619094> }
triangle { <-0.392658, 0.680104, 0.619094>, <-0.356526, 0.699723, 0.619094>, <-0.345217, 0.677527, 0.649448> }
triangle { <-0.356526, 0.699723, 0.619094>, <-0.392658, 0.680104, 0.619094>, <-0.404508, 0.700629, 0.587785> }
triangle { <-0.404508, 0.700629, 0.587785>, <-0.367286, 0.720839, 0.587785>, <-0.356526, 0.699723, 0.619094> }
triangle { <-0.367286, 0.720839, 0.587785>, <-0.404508, 0.700629, 0.587785>, <-0.415735, 0.720074, 0.555570> }
triangle { <-0.415735, 0.720074, 0.555570>, <-0.377479, 0.740845, 0.555570>, <-0.367286, 0.720839, 0.587785> }
triangle { <-0.377479, 0.740845, 0.555570>, <-0.415735, 0.720074, 0.555570>, <-0.426320, 0.738408, 0.522499> }
triangle { <-0.426320, 0.738408, 0.522499>, <-0.387091, 0.759708, 0.522499>, <-0.377479, 0.740845, 0.555570> }
triangle { <-0.387091, 0.759708, 0.522499>, <-0.426320, 0.738408, 0.522499>, <-0.436248, 0.755604, 0.488621> }
triangle { <-0.436248, 0.755604, 0.488621>, <-0.396105, 0.777400, 0.488621>, <-0.387091, 0.759708, 0.522499> }
triangle { <-0.396105, 0.777400, 0.488621>, <-0.436248, 0.755604, 0.488621>, <-0.445503, 0.771634, 0.453990> }
triangle { <-0.445503, 0.771634, 0.453990>, <-0.404508, 0.793893, 0.453990>, <-0.396105, 0.777400, 0.488621> }
triangle { <-0.404508, 0.793893, 0.453990>, <-0.445503, 0.771634, 0.453990>, <-0.454072, 0.786475, 0.418660> }
triangle { <-0.454072, 0.786475, 0.418660>, <-0.412288, 0.809161, 0.418660>, <-0.404508, 0.793893, 0.453990> }
triangle { <-0.412288, 0.809161, 0.418660>, <-0.454072, 0.786475, 0.418660>, <-0.461940, 0.800103, 0.382683> }
triangle { <-0.461940, 0.800103, 0.382683>, <-0.419433, 0.823183, 0.382683>, <-0.412288, 0.809161, 0.418660> }
triangle { <-0.419433, 0.823183, 0.382683>, <-0.461940, 0.800103, 0.382683>, <-0.469096, 0.812498, 0.346117> }
triangle { <-0.469096, 0.812498, 0.346117>, <-0.425930, 0.835935, 0.346117>, <-0.419433, 0.823183, 0.382683> }
triangle { <-0.425930, 0.835935, 0.346117>, <-0.469096, 0.812498, 0.346117>, <-0.475528, 0.823639, 0.309017> }
triangle { <-0.475528, 0.823639, 0.309017>, <-0.431771, 0.847398, 0.309017>, <-0.425930, 0.835935, 0.346117> }
triangle { <-0.431771, 0.847398, 0.309017>, <-0.475528, 0.823639, 0.309017>, <-0.481228, 0.833511, 0.271440> }
triangle { <-0.481228, 0.833511, 0.271440>, <-0.436946, 0.857554, 0.271440>, <-0.431771, 0.847398, 0.309017> }
triangle { <-0.436946, 0.857554, 0.271440>, <-0.481228, 0.833511, 0.271440>, <-0.486185, 0.842097, 0.233445> }
triangle { <-0.486185, 0.842097, 0.233445>, <-0.441447, 0.866388, 0.233445>, <-0.436946, 0.857554, 0.271440> }
triangle { <-0.441447, 0.866388, 0.233445>, <-0.486185, 0.842097, 0.233445>, <-0.490393, 0.849385, 0.195090> }
triangle { <-0.490393, 0.849385, 0.195090>, <-0.445267, 0.873886, 0.195090>, <-0.441447, 0.866388, 0.233445> }
triangle { <-0.445267, 0.873886, 0.195090>, <-0.490393, 0.849385, 0.195090>, <-0.493844, 0.855363, 0.156434> }
triangle { <-0.493844, 0.855363, 0.156434>, <-0.448401, 0.880037, 0.156434>, <-0.445267, 0.873886, 0.195090> }
triangle { <-0.448401, 0.880037, 0.156434>, <-0.493844, 0.855363, 0.156434>, <-0.496534, 0.860023, 0.117537> }
triangle { <-0.496534, 0.860023, 0.117537>, <-0.450844, 0.884830, 0.117537>, <-0.448401, 0.880037, 0.156434> }
triangle { <-0.450844, 0.884830, 0.117537>, <-0.496534, 0.860023, 0.117537>, <-0.498459, 0.863356, 0.078459> }
triangle { <-0.498459, 0.863356, 0.078459>, <-0.452591, 0.888260, 0.078459>, <-0.450844, 0.884830, 0.117537> }
triangle { <-0.452591, 0.888260, 0.078459>, <-0.498459, 0.863356, 0.078459>, <-0.499615, 0.865358, 0.039260> }
triangle { <-0.499615, 0.865358, 0.039260>, <-0.453640, 0.890320, 0.039260>, <-0.452591, 0.888260, 0.078459> }
triangle { <-0.453640, 0.890320, 0.039260>, <-0.499615, 0.865358, 0.039260>, <-0.500000, 0.866025, -0.000000> }
triangle { <-0.500000, 0.866025, -0.000000>, <-0.453990, 0.891007, -0.000000>, <-0.453640, 0.890320, 0.039260> }
triangle { <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <-0.021382, 0.032926, 0.999229> }
triangle { <-0.021382, 0.032926, 0.999229>, <-0.019630, 0.034000, 0.999229>, <0.000000, 0.000000, 1.000000> }
triangle { <-0.019630, 0.034000, 0.999229>, <-0.021382, 0.032926, 0.999229>, <-0.042732, 0.065801, 0.996917> }
triangle { <-0.042732, 0.065801, 0.996917>, <-0.039230, 0.067948, 0.996917>, <-0.019630, 0.034000, 0.999229> }
triangle { <-0.039230, 0.067948, 0.996917>, <-0.042732, 0.065801, 0.996917>, <-0.064015, 0.098575, 0.993068> }
triangle { <-0.064015, 0.098575, 0.993068>, <-0.058769, 0.101790, 0.993068>, <-0.039230, 0.067948, 0.996917> }
triangle { <-0.058769, 0.101790, 0.993068>, <-0.064015, 0.098575, 0.993068>, <-0.085200, 0.131197, 0.987688> }
triangle { <-0.085200, 0.131197, 0.987688>, <-0.078217, 0.135476, 0.987688>, <-0.058769, 0.101790, 0.993068> }
triangle { <-0.078217, 0.135476, 0.987688>, <-0.085200, 0.131197, 0.987688>, <-0.106254, 0.163617, 0.980785> }
triangle { <-0.106254, 0.163617, 0.980785>, <-0.097545, 0.168953, 0.980785>, <-0.078217, 0.135476, 0.987688> }
triangle { <-0.097545, 0.168953, 0.980785>, <-0.106254, 0.163617, 0.980785>, <-0.127143, 0.195784, 0.972370> }
triangle { <-0.127143, 0.195784, 0.972370>, <-0.116723, 0.202170, 0.972370>, <-0.097545, 0.168953, 0.980785> }
triangle { <-0.116723, 0.202170, 0.972370>, <-0.127143, 0.195784, 0.972370>, <-0.147837, 0.227649, 0.962455> }
triangle { <-0.147837, 0.227649, 0.962455>, <-0.135720, 0.235074, 0.962455>, <-0.116723, 0.202170, 0.972370> }
triangle { <-0.135720, 0.235074, 0.962455>, <-0.147837, 0.227649, 0.962455>, <-0.168303, 0.259163, 0.951057> }
triangle { <-0.168303, 0.259163, 0.951057>, <-0.154508, 0.267617, 0.951057>, <-0.135720, 0.235074, 0.962455> }
triangle { <-0.154508, 0.267617, 0.951057>, <-0.168303, 0.259163, 0.951057>, <-0.188509, 0.290278, 0.938191> }
triangle { <-0.188509, 0.290278, 0.938191>, <-0.173059, 0.299746, 0.938191>, <-0.154508, 0.267617, 0.951057> }
triangle { <-0.173059, 0.299746, 0.938191>, <-0.188509, 0.290278, 0.938191>, <-0.208424, 0.320945, 0.923880> }
triangle { <-0.208424, 0.320945, 0.923880>, <-0.191342, 0.331414, 0.923880>, <-0.173059, 0.299746, 0.938191> }
triangle { <-0.191342, 0.331414, 0.923880>, <-0.208424, 0.320945, 0.923880>, <-0.228018, 0.351118, 0.908143> }
triangle { <-0.228018, 0.351118, 0.908143>, <-0.209330, 0.362570, 0.908143>, <-0.191342, 0.331414, 0.923880> }
triangle { <-0.209330, 0.362570, 0.908143>, <-0.228018, 0.351118, 0.908143>, <-0.247261, 0.380748, 0.891007> }
triangle { <-0.247261, 0.380748, 0.891007>, <-0.226995, 0.393167, 0.891007>, <-0.209330, 0.362570, 0.908143> }
triangle { <-0.226995, 0.393167, 0.891007>, <-0.247261, 0.380748, 0.891007>, <-0.266122, 0.409792, 0.872496> }
triangle { <-0.266122, 0.409792, 0.872496>, <-0.244311, 0.423158, 0.872496>, <-0.226995, 0.393167, 0.891007> }
triangle { <-0.244311, 0.423158, 0.872496>, <-0.266122, 0.409792, 0.872496>, <-0.284573, 0.438204, 0.852640> }
triangle { <-0.284573, 0.438204, 0.852640>, <-0.261249, 0.452497, 0.852640>, <-0.244311, 0.423158, 0.872496> }
triangle { <-0.261249, 0.452497, 0.852640>, <-0.284573, 0.438204, 0.852640>, <-0.302585, 0.465940, 0.831470> }
triangle { <-0.302585, 0.465940, 0.831470>, <-0.277785, 0.481138, 0.831470>, <-0.261249, 0.452497, 0.852640> }
triangle { <-0.277785, 0.481138, 0.831470>, <-0.302585, 0.465940, 0.831470>, <-0.320131, 0.492958, 0.809017> }
triangle { <-0.320131, 0.492958, 0.809017>, <-0.293893, 0.509037, 0.809017>, <-0.277785, 0.481138, 0.831470> }
triangle { <-0.293893, 0.509037, 0.809017>, <-0.320131, 0.492958, 0.809017>, <-0.337183, 0.519216, 0.785317> }
triangle { <-0.337183, 0.519216, 0.785317>, <-0.309547, 0.536151, 0.785317>, <-0.293893, 0.509037, 0.809017> }
triangle { <-0.309547, 0.536151, 0.785317>, <-0.337183, 0.519216, 0.785317>, <-0.353715, 0.544673, 0.760406> }
triangle { <-0.353715, 0.544673, 0.760406>, <-0.324724, 0.562439, 0.760406>, <-0.309547, 0.536151, 0.785317> }
triangle { <-0.324724, 0.562439, 0.760406>, <-0.353715, 0.544673, 0.760406>, <-0.369701, 0.569290, 0.734323> }
triangle { <-0.369701, 0.569290, 0.734323>, <-0.339400, 0.587859, 0.734323>, <-0.324724, 0.562439, 0.760406> }
triangle { <-0.339400, 0.587859, 0.734323>, <-0.369701, 0.569290, 0.734323>, <-0.385118, 0.593030, 0.707107> }
triangle { <-0.385118, 0.593030, 0.707107>, <-0.353553, 0.612372, 0.707107>, <-0.339400, 0.587859, 0.734323> }
triangle { <-0.353553, 0.612372, 0.707107>, <-0.385118, 0.593030, 0.707107>, <-0.399941, 0.615855, 0.678801> }
triangle { <-0.399941, 0.615855, 0.678801>, <-0.367161, 0.635942, 0.678801>, <-0.353553, 0.612372, 0.707107> }
triangle { <-0.367161, 0.635942, 0.678801>, <-0.399941, 0.615855, 0.678801>, <-0.414147, 0.637730, 0.649448> }
triangle { <-0.414147, 0.637730, 0.649448>, <-0.380203, 0.658531, 0.649448>, <-0.367161, 0.635942, 0.678801> }
triangle { <-0.380203, 0.658531, 0.649448>, <-0.414147, 0.637730, 0.649448>, <-0.427714, 0.658622, 0.619094> }
triangle { <-0.427714, 0.658622, 0.619094>, <-0.392658, 0.680104, 0.619094>, <-0.380203, 0.658531, 0.649448> }
triangle { <-0.392658, 0.680104, 0.619094>, <-0.427714, 0.658622, 0.619094>, <-0.440622, 0.678499, 0.587785> }
triangle { <-0.440622, 0.678499, 0.587785>, <-0.404508, 0.700629, 0.587785>, <-0.392658, 0.680104, 0.619094> }
triangle { <-0.404508, 0.700629, 0.587785>, <-0.440622, 0.678499, 0.587785>, <-0.452851, 0.697329, 0.555570> }
triangle { <-0.452851, 0.697329, 0.555570>, <-0.415735, 0.720074, 0.555570>, <-0.404508, 0.700629, 0.587785> }
triangle { <-0.415735, 0.720074, 0.555570>, <-0.452851, 0.697329, 0.555570>, <-0.464381, 0.715084, 0.522499> }
triangle { <-0.464381, 0.715084, 0.522499>, <-0.426320, 0.738408, 0.522499>, <-0.415735, 0.720074, 0.555570> }
triangle { <-0.426320, 0.738408, 0.522499>, <-0.464381, 0.715084, 0.522499>, <-0.475195, 0.731737, 0.488621> }
triangle { <-0.475195, 0.731737, 0.488621>, <-0.436248, 0.755604, 0.488621>, <-0.426320, 0.738408, 0.522499> }
triangle { <-0.436248, 0.755604, 0.488621>, <-0.475195, 0.731737, 0.488621>, <-0.485277, 0.747261, 0.453990> }
triangle { <-0.485277, 0.747261, 0.453990>, <-0.445503, 0.771634, 0.453990>, <-0.436248, 0.755604, 0.488621> }
triangle { <-0.445503, 0.771634, 0.453990>, <-0.485277, 0.747261, 0.453990>, <-0.494610, 0.761633, 0.418660> }
triangle { <-0.494610, 0.761633, 0.418660>, <-0.454072, 0.786475, 0.418660>, <-0.445503, 0.771634, 0.453990> }
triangle { <-0.454072, 0.786475, 0.418660>, <-0.494610, 0.761633, 0.418660>, <-0.503181, 0.774831, 0.382683> }
triangle { <-0.503181, 0.774831, 0.382683>, <-0.461940, 0.800103, 0.382683>, <-0.454072, 0.786475, 0.418660> }
triangle { <-0.461940, 0.800103, 0.382683>, <-0.503181, 0.774831, 0.382683>, <-0.510976, 0.786833, 0.346117> }
triangle { <-0.510976, 0.786833, 0.346117>, <-0.469096, 0.812498, 0.346117>, <-0.461940, 0.800103, 0.382683> }
triangle { <-0.469096, 0.812498, 0.346117>, <-0.510976, 0.786833, 0.346117>, <-0.517983, 0.797623, 0.309017> }
triangle { <-0.517983, 0.797623, 0.309017>, <-0.475528, 0.823639, 0.309017>, <-0.469096, 0.812498, 0.346117> }
triangle { <-0.475528, 0.823639, 0.309017>, <-0.517983, 0.797623, 0.309017>, <-0.524191, 0.807183, 0.271440> }
triangle { <-0.524191, 0.807183, 0.271440>, <-0.481228, 0.833511, 0.271440>, <-0.475528, 0.823639, 0.309017> }
triangle { <-0.481228, 0.833511, 0.271440>, <-0.524191, 0.807183, 0.271440>, <-0.529591, 0.815498, 0.233445> }
triangle { <-0.529591, 0.815498, 0.233445>, <-0.486185, 0.842097, 0.233445>, <-0.481228, 0.833511, 0.271440> }
triangle { <-0.486185, 0.842097, 0.233445>, <-0.529591, 0.815498, 0.233445>, <-0.534174, 0.822556, 0.195090> }
triangle { <-0.534174, 0.822556, 0.195090>, <-0.490393, 0.849385, 0.195090>, <-0.486185, 0.842097, 0.233445> }
triangle { <-0.490393, 0.849385, 0.195090>, <-0.534174, 0.822556, 0.195090>, <-0.537934, 0.828345, 0.156434> }
triangle { <-0.537934, 0.828345, 0.156434>, <-0.493844, 0.855363, 0.156434>, <-0.490393, 0.849385, 0.195090> }
triangle { <-0.493844, 0.855363, 0.156434>, <-0.537934, 0.828345, 0.156434>, <-0.540864, 0.832857, 0.117537> }
triangle { <-0.540864, 0.832857, 0.117537>, <-0.496534, 0.860023, 0.117537>, <-0.493844, 0.855363, 0.156434> }
triangle { <-0.496534, 0.860023, 0.117537>, <-0.540864, 0.832857, 0.117537>, <-0.542960, 0.836085, 0.078459> }
triangle { <-0.542960, 0.836085, 0.078459>, <-0.498459, 0.863356, 0.078459>, <-0.496534, 0.860023, 0.117537> }
triangle { <-0.498459, 0.863356, 0.078459>, <-0.542960, 0.836085, 0.078459>, <-0.544219, 0.838024, 0.039260> }
triangle { <-0.544219, 0.838024, 0.039260>, <-0.499615, 0.865358, 0.039260>, <-0.498459, 0.863356, 0.078459> }
triangle { <-0.499615, 0.865358, 0.039260>, <-0.544219, 0.838024, 0.039260>, <-0.544639, 0.838671, -0.000000> }
triangle { <-0.544639, 0.838671, -0.000000>, <-0.500000, 0.866025, -0.000000>, <-0.499615, 0.865358, 0.039260> }
triangle { <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <-0.023076, 0.031762, 0.999229> }
triangle { <-0.023076, 0.031762, 0.999229>, <-0.021382, 0.032926, 0.999229>, <0.000000, 0.000000, 1.000000> }
triangle { <-0.021382, 0.032926, 0.999229>, <-0.023076, 0.031762, 0.999229>, <-0.046117, 0.063475, 0.996917> }
triangle { <-0.046117, 0.063475, 0.996917>, <-0.042732, 0.065801, 0.996917>, <-0.021382, 0.032926, 0.999229> }
triangle { <-0.042732, 0.065801, 0.996917>, <-0.046117, 0.063475, 0.996917>, <-0.069087, 0.095090, 0.993068> }
triangle { <-0.069087, 0.095090, 0.993068>, <-0.064015, 0.098575, 0.993068>, <-0.042732, 0.065801, 0.996917> }
triangle { <-0.064015, 0.098575, 0.993068>, <-0.069087, 0.095090, 0.993068>, <-0.091950, 0.126558, 0.987688> }
triangle { <-0.091950, 0.126558, 0.987688>, <-0.085200, 0.131197, 0.987688>, <-0.064015, 0.098575, 0.993068> }
triangle { <-0.085200, 0.131197, 0.987688>, <-0.091950, 0.126558, 0.987688>, <-0.114671, 0.157831, 0.980785> }
triangle { <-0.114671, 0.157831, 0.980785>, <-0.106254, 0.163617, 0.980785>, <-0.085200, 0.131197, 0.987688> }
triangle { <-0.106254, 0.163617, 0.980785>, <-0.114671, 0.157831, 0.980785>, <-0.137216, 0.188861, 0.972370> }
triangle { <-0.137216, 0.188861, 0.972370>, <-0.127143, 0.195784, 0.972370>, <-0.106254, 0.163617, 0.980785> }
triangle { <-0.127143, 0.195784, 0.972370>, <-0.137216, 0.188861, 0.972370>, <-0.159549, 0.219600, 0.962455> }
triangle { <-0.159549, 0.219600, 0.962455>, <-0.147837, 0.227649, 0.962455>, <-0.127143, 0.195784, 0.972370> }
triangle { <-0.147837, 0.227649, 0.962455>, <-0.159549, 0.219600, 0.962455>, <-0.181636, 0.250000, 0.951057> }
triangle { <-0.181636, 0.250000, 0.951057>, <-0.168303, 0.259163, 0.951057>, <-0.147837, 0.227649, 0.962455> }
triangle { <-0.168303, 0.259163, 0.951057>, <-0.181636, 0.250000, 0.951057>, <-0.203443, 0.280015, 0.938191> }
triangle { <-0.203443, 0.280015, 0.938191>, <-0.188509, 0.290278, 0.938191>, <-0.168303, 0.259163, 0.951057> }
triangle { <-0.188509, 0.290278, 0.938191>, <-0.203443, 0.280015, 0.938191>, <-0.224936, 0.309597, 0.923880> }
triangle { <-0.224936, 0.309597, 0.923880>, <-0.208424, 0.320945, 0.923880>, <-0.188509, 0.290278, 0.938191> }
triangle { <-0.208424, 0.320945, 0.923880>, <-0.224936, 0.309597, 0.923880>, <-0.246082, 0.338703, 0.908143> }
triangle { <-0.246082, 0.338703, 0.908143>, <-0.228018, 0.351118, 0.908143>, <-0.208424, 0.320945, 0.923880> }
triangle { <-0.228018, 0.351118, 0.908143>, <-0.246082, 0.338703, 0.908143>, <-0.266849, 0.367286, 0.891007> }
triangle { <-0.266849, 0.367286, 0.891007>, <-0.247261, 0.380748, 0.891007>, <-0.228018, 0.351118, 0.908143> }
triangle { <-0.247261, 0.380748, 0.891007>, <-0.266849, 0.367286, 0.891007>, <-0.287204, 0.395303, 0.872496> }
triangle { <-0.287204, 0.395303, 0.872496>, <-0.266122, 0.409792, 0.872496>, <-0.247261, 0.380748, 0.891007> }
triangle { <-0.266122, 0.409792, 0.872496>, <-0.287204, 0.395303, 0.872496>, <-0.307117, 0.422710, 0.852640> }
triangle { <-0.307117, 0.422710, 0.852640>, <-0.284573, 0.438204, 0.852640>, <-0.266122, 0.409792, 0.872496> }
triangle { <-0.284573, 0.438204, 0.852640>, <-0.307117, 0.422710, 0.852640>, <-0.326556, 0.449466, 0.831470> }
triangle { <-0.326556, 0.449466, 0.831470>, <-0.302585, 0.465940, 0.831470>, <-0.284573, 0.438204, 0.852640> }
triangle { <-0.302585, 0.465940, 0.831470>, <-0.326556, 0.449466, 0.831470>, <-0.345492, 0.475528, 0.809017> }
triangle { <-0.345492, 0.475528, 0.809017>, <-0.320131, 0.492958, 0.809017>, <-0.302585, 0.465940, 0.831470> }
triangle { <-0.320131, 0.492958, 0.809017>, <-0.345492, 0.475528, 0.809017>, <-0.363894, 0.500858, 0.785317> }
triangle { <-0.363894, 0.500858, 0.785317>, <-0.337183, 0.519216, 0.785317>, <-0.320131, 0.492958, 0.809017> }
triangle { <-0.337183, 0.519216, 0.785317>, <-0.363894, 0.500858, 0.785317>, <-0.381736, 0.525415, 0.760406> }
triangle { <-0.381736, 0.525415, 0.760406>, <-0.353715, 0.544673, 0.760406>, <-0.337183, 0.519216, 0.785317> }
triangle { <-0.353715, 0.544673, 0.760406>, <-0.381736, 0.525415, 0.760406>, <-0.398989, 0.549161, 0.734323> }
triangle { <-0.398989, 0.549161, 0.734323>, <-0.369701, 0.569290, 0.734323>, <-0.353715, 0.544673, 0.760406> }
triangle { <-0.369701, 0.569290, 0.734323>, <-0.398989, 0.549161, 0.734323>, <-0.415627, 0.572061, 0.707107> }
triangle { <-0.415627, 0.572061, 0.707107>, <-0.385118, 0.593030, 0.707107>, <-0.369701, 0.569290, 0.734323> }
triangle { <-0.385118, 0.593030, 0.707107>, <-0.415627, 0.572061, 0.707107>, <-0.431624, 0.594079, 0.678801> }
triangle { <-0.431624, 0.594079, 0.678801>, <-0.399941, 0.615855, 0.678801>, <-0.385118, 0.593030, 0.707107> }
triangle { <-0.399941, 0.615855, 0.678801>, <-0.431624, 0.594079, 0.678801>, <-0.446955, 0.615181, 0.649448> }
triangle { <-0.446955, 0.615181, 0.649448>, <-0.414147, 0.637730, 0.649448>, <-0.399941, 0.615855, 0.678801> }
triangle { <-0.414147, 0.637730, 0.649448>, <-0.446955, 0.615181, 0.649448>, <-0.461598, 0.635335, 0.619094> }
triangle { <-0.461598, 0.635335, 0.619094>, <-0.427714, 0.658622, 0.619094>, <-0.414147, 0.637730, 0.649448> }
triangle { <-0.427714, 0.658622, 0.619094>, <-0.461598, 0.635335, 0.619094>, <-0.475528, 0.654508, 0.587785> }
triangle { <-0.475528, 0.654508, 0.587785>, <-0.440622, 0.678499, 0.587785>, <-0.427714, 0.658622, 0.619094> }
triangle { <-0.440622, 0.678499, 0.587785>, <-0.475528, 0.654508, 0.587785>, <-0.488726, 0.672673, 0.555570> }
triangle { <-0.488726, 0.672673, 0.555570>, <-0.452851, 0.697329, 0.555570>, <-0.440622, 0.678499, 0.587785> }
triangle { <-0.452851, 0.697329, 0.555570>, <-0.488726, 0.672673, 0.555570>, <-0.501169, 0.689800, 0.522499> }
triangle { <-0.501169, 0.689800, 0.522499>, <-0.464381, 0.715084, 0.522499>, <-0.452851, 0.697329, 0.555570> }
triangle { <-0.464381, 0.715084, 0.522499>, <-0.501169, 0.689800, 0.522499>, <-0.512840, 0.705864, 0.488621> }
triangle { <-0.512840, 0.705864, 0.488621>, <-0.475195, 0.731737, 0.488621>, <-0.464381, 0.715084, 0.522499> }
triangle { <-0.475195, 0.731737, 0.488621>, <-0.512840, 0.705864, 0.488621>, <-0.523720, 0.720839, 0.453990> }
triangle { <-0.523720, 0.720839, 0.453990>, <-0.485277, 0.747261, 0.453990>, <-0.475195, 0.731737, 0.488621> }
triangle { <-0.485277, 0.747261, 0.453990>, <-0.523720, 0.720839, 0.453990>, <-0.533793, 0.734703, 0.418660> }
triangle { <-0.533793, 0.734703, 0.418660>, <-0.494610, 0.761633, 0.418660>, <-0.485277, 0.747261, 0.453990> }
triangle { <-0.494610, 0.761633, 0.418660>, <-0.533793, 0.734703, 0.418660>, <-0.543043, 0.747434, 0.382683> }
triangle { <-0.543043, 0.747434, 0.382683>, <-0.503181, 0.774831, 0.382683>, <-0.494610, 0.761633, 0.418660> }
triangle { <-0.503181, 0.774831, 0.382683>, <-0.543043, 0.747434, 0.382683>, <-0.551455, 0.759013, 0.346117> }
triangle { <-0.551455, 0.759013, 0.346117>, <-0.510976, 0.786833, 0.346117>, <-0.503181, 0.774831, 0.382683> }
triangle { <-0.510976, 0.786833, 0.346117>, <-0.551455, 0.759013, 0.346117>, <-0.559017, 0.769421, 0.309017> }
triangle { <-0.559017, 0.769421, 0.309017>, <-0.517983, 0.797623, 0.309017>, <-0.510976, 0.786833, 0.346117> }
triangle { <-0.517983, 0.797623, 0.309017>, <-0.559017, 0.769421, 0.309017>, <-0.565717, 0.778643, 0.271440> }
triangle { <-0.565717, 0.778643, 0.271440>, <-0.524191, 0.807183, 0.271440>, <-0.517983, 0.797623, 0.309017> }
triangle { <-0.524191, 0.807183, 0.271440>, <-0.565717, 0.778643, 0.271440>, <-0.571545, 0.786664, 0.233445> }
triangle { <-0.571545, 0.786664, 0.233445>, <-0.529591, 0.815498, 0.233445>, <-0.524191, 0.807183, 0.271440> }
triangle { <-0.529591, 0.815498, 0.233445>, <-0.571545, 0.786664, 0.233445>, <-0.576491, 0.793472, 0.195090> }
triangle { <-0.576491, 0.793472, 0.195090>, <-0.534174, 0.822556, 0.195090>, <-0.529591, 0.815498, 0.233445> }
triangle { <-0.534174, 0.822556, 0.195090>, <-0.576491, 0.793472, 0.195090>, <-0.580549, 0.799057, 0.156434> }
triangle { <-0.580549, 0.799057, 0.156434>, <-0.537934, 0.828345, 0.156434>, <-0.534174, 0.822556, 0.195090> }
triangle { <-0.537934, 0.828345, 0.156434>, <-0.580549, 0.799057, 0.156434>, <-0.583711, 0.803409, 0.117537> }
triangle { <-0.583711, 0.803409, 0.117537>, <-0.540864, 0.832857, 0.117537>, <-0.537934, 0.828345, 0.156434> }
triangle { <-0.540864, 0.832857, 0.117537>, <-0.583711, 0.803409, 0.117537>, <-0.585973, 0.806523, 0.078459> }
triangle { <-0.585973, 0.806523, 0.078459>, <-0.542960, 0.836085, 0.078459>, <-0.540864, 0.832857, 0.117537> }
triangle { <-0.542960, 0.836085, 0.078459>, <-0.585973, 0.806523, 0.078459>, <-0.587332, 0.808393, 0.039260> }
triangle { <-0.587332, 0.808393, 0.039260>, <-0.544219, 0.838024, 0.039260>, <-0.542960, 0.836085, 0.078459> }
triangle { <-0.544219, 0.838024, 0.039260>, <-0.587332, 0.808393, 0.039260>, <-0.587785, 0.809017, -0.000000> }
triangle { <-0.587785, 0.809017, -0.000000>, <-0.544639, 0.838671, -0.000000>, <-0.544219, 0.838024, 0.039260> }
triangle { <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <-0.024707, 0.030511, 0.999229> }
triangle { <-0.024707, 0.030511, 0.999229>, <-0.023076, 0.031762, 0.999229>, <0.000000, 0.000000, 1.000000> }
triangle { <-0.023076, 0.031762, 0.999229>, <-0.024707, 0.030511, 0.999229>, <-0.049376, 0.060974, 0.996917> }
triangle { <-0.049376, 0.060974, 0.996917>, <-0.046117, 0.063475, 0.996917>, <-0.023076, 0.031762, 0.999229> }
triangle { <-0.046117, 0.063475, 0.996917>, <-0.049376, 0.060974, 0.996917>, <-0.073969, 0.091344, 0.993068> }
triangle { <-0.073969, 0.091344, 0.993068>, <-0.069087, 0.095090, 0.993068>, <-0.046117, 0.063475, 0.996917> }
triangle { <-0.069087, 0.095090, 0.993068>, <-0.073969, 0.091344, 0.993068>, <-0.098447, 0.121572, 0.987688> }
triangle { <-0.098447, 0.121572, 0.987688>, <-0.091950, 0.126558, 0.987688>, <-0.069087, 0.095090, 0.993068> }
triangle { <-0.091950, 0.126558, 0.987688>, <-0.098447, 0.121572, 0.987688>, <-0.122774, 0.151614, 0.980785> }
triangle { <-0.122774, 0.151614, 0.980785>, <-0.114671, 0.157831, 0.980785>, <-0.091950, 0.126558, 0.987688> }
triangle { <-0.114671, 0.157831, 0.980785>, <-0.122774, 0.151614, 0.980785>, <-0.146912, 0.181421, 0.972370> }
triangle { <-0.146912, 0.181421, 0.972370>, <-0.137216, 0.188861, 0.972370>, <-0.114671, 0.157831, 0.980785> }
triangle { <-0.137216, 0.188861, 0.972370>, <-0.146912, 0.181421, 0.972370>, <-0.170823, 0.210949, 0.962455> }
triangle { <-0.170823, 0.210949, 0.962455>, <-0.159549, 0.219600, 0.962455>, <-0.137216, 0.188861, 0.972370> }
triangle { <-0.159549, 0.219600, 0.962455>, <-0.170823, 0.210949, 0.962455>, <-0.194471, 0.240151, 0.951057> }
triangle { <-0.194471, 0.240151, 0.951057>, <-0.181636, 0.250000, 0.951057>, <-0.159549, 0.219600, 0.962455> }
triangle { <-0.181636, 0.250000, 0.951057>, <-0.194471, 0.240151, 0.951057>, <-0.217819, 0.268983, 0.938191> }
triangle { <-0.217819, 0.268983, 0.938191>, <-0.203443, 0.280015, 0.938191>, <-0.181636, 0.250000, 0.951057> }
triangle { <-0.203443, 0.280015, 0.938191>, <-0.217819, 0.268983, 0.938191>, <-0.240830, 0.297401, 0.923880> }
triangle { <-0.240830, 0.297401, 0.923880>, <-0.224936, 0.309597, 0.923880>, <-0.203443, 0.280015, 0.938191> }
triangle { <-0.224936, 0.309597, 0.923880>, <-0.240830, 0.297401, 0.923880>, <-0.263471, 0.325360, 0.908143> }
triangle { <-0.263471, 0.325360, 0.908143>, <-0.246082, 0.338703, 0.908143>, <-0.224936, 0.309597, 0.923880> }
triangle { <-0.246082, 0.338703, 0.908143>, <-0.263471, 0.325360, 0.908143>, <-0.285705, 0.352817, 0.891007> }
triangle { <-0.285705, 0.352817, 0.891007>, <-0.266849, 0.367286, 0.891007>, <-0.246082, 0.338703, 0.908143> }
triangle { <-0.266849, 0.367286, 0.891007>, <-0.285705, 0.352817, 0.891007>, <-0.307499, 0.379730, 0.872496> }
triangle { <-0.307499, 0.379730, 0.872496>, <-0.287204, 0.395303, 0.872496>, <-0.266849, 0.367286, 0.891007> }
triangle { <-0.287204, 0.395303, 0.872496>, <-0.307499, 0.379730, 0.872496>, <-0.328819, 0.406058, 0.852640> }
triangle { <-0.328819, 0.406058, 0.852640>, <-0.307117, 0.422710, 0.852640>, <-0.287204, 0.395303, 0.872496> }
triangle { <-0.307117, 0.422710, 0.852640>, <-0.328819, 0.406058, 0.852640>, <-0.349632, 0.431759, 0.831470> }
triangle { <-0.349632, 0.431759, 0.831470>, <-0.326556, 0.449466, 0.831470>, <-0.307117, 0.422710, 0.852640> }
triangle { <-0.326556, 0.449466, 0.831470>, <-0.349632, 0.431759, 0.831470>, <-0.369905, 0.456795, 0.809017> }
triangle { <-0.369905, 0.456795, 0.809017>, <-0.345492, 0.475528, 0.809017>, <-0.326556, 0.449466, 0.831470> }
triangle { <-0.345492, 0.475528, 0.809017>, <-0.369905, 0.456795, 0.809017>, <-0.389608, 0.481126, 0.785317> }
triangle { <-0.389608, 0.481126, 0.785317>, <-0.363894, 0.500858, 0.785317>, <-0.345492, 0.475528, 0.809017> }
triangle { <-0.363894, 0.500858, 0.785317>, <-0.389608, 0.481126, 0.785317>, <-0.408711, 0.504716, 0.760406> }
triangle { <-0.408711, 0.504716, 0.760406>, <-0.381736, 0.525415, 0.760406>, <-0.363894, 0.500858, 0.785317> }
triangle { <-0.381736, 0.525415, 0.760406>, <-0.408711, 0.504716, 0.760406>, <-0.427183, 0.527527, 0.734323> }
triangle { <-0.427183, 0.527527, 0.734323>, <-0.398989, 0.549161, 0.734323>, <-0.381736, 0.525415, 0.760406> }
triangle { <-0.398989, 0.549161, 0.734323>, <-0.427183, 0.527527, 0.734323>, <-0.444997, 0.549525, 0.707107> }
triangle { <-0.444997, 0.549525, 0.707107>, <-0.415627, 0.572061, 0.707107>, <-0.398989, 0.549161, 0.734323> }
triangle { <-0.415627, 0.572061, 0.707107>, <-0.444997, 0.549525, 0.707107>, <-0.462124, 0.570676, 0.678801> }
triangle { <-0.462124, 0.570676, 0.678801>, <-0.431624, 0.594079, 0.678801>, <-0.415627, 0.572061, 0.707107> }
triangle { <-0.431624, 0.594079, 0.678801>, <-0.462124, 0.570676, 0.678801>, <-0.478539, 0.590946, 0.649448> }
triangle { <-0.478539, 0.590946, 0.649448>, <-0.446955, 0.615181, 0.649448>, <-0.431624, 0.594079, 0.678801> }
triangle { <-0.446955, 0.615181, 0.649448>, <-0.478539, 0.590946, 0.649448>, <-0.494216, 0.610306, 0.619094> }
triangle { <-0.494216, 0.610306, 0.619094>, <-0.461598, 0.635335, 0.619094>, <-0.446955, 0.615181, 0.649448> }
triangle { <-0.461598, 0.635335, 0.619094>, <-0.494216, 0.610306, 0.619094>, <-0.509131, 0.628724, 0.587785> }
triangle { <-0.509131, 0.628724, 0.587785>, <-0.475528, 0.654508, 0.587785>, <-0.461598, 0.635335, 0.619094> }
triangle { <-0.475528, 0.654508, 0.587785>, <-0.509131, 0.628724, 0.587785>, <-0.523261, 0.646173, 0.555570> }
triangle { <-0.523261, 0.646173, 0.555570>, <-0.488726, 0.672673, 0.555570>, <-0.475528, 0.654508, 0.587785> }
triangle { <-0.488726, 0.672673, 0.555570>, <-0.523261, 0.646173, 0.555570>, <-0.536584, 0.662626, 0.522499> }
triangle { <-0.536584, 0.662626, 0.522499>, <-0.501169, 0.689800, 0.522499>, <-0.488726, 0.672673, 0.555570> }
triangle { <-0.501169, 0.689800, 0.522499>, <-0.536584, 0.662626, 0.522499>, <-0.549080, 0.678057, 0.488621> }
triangle { <-0.549080, 0.678057, 0.488621>, <-0.512840, 0.705864, 0.488621>, <-0.501169, 0.689800, 0.522499> }
triangle { <-0.512840, 0.705864, 0.488621>, <-0.549080, 0.678057, 0.488621>, <-0.560729, 0.692442, 0.453990> }
triangle { <-0.560729, 0.692442, 0.453990>, <-0.523720, 0.720839, 0.453990>, <-0.512840, 0.705864, 0.488621> }
triangle { <-0.523720, 0.720839, 0.453990>, <-0.560729, 0.692442, 0.453990>, <-0.571513, 0.705760, 0.418660> }
triangle { <-0.571513, 0.705760, 0.418660>, <-0.533793, 0.734703, 0.418660>, <-0.523720, 0.720839, 0.453990> }
triangle { <-0.533793, 0.734703, 0.418660>, <-0.571513, 0.705760, 0.418660>, <-0.581416, 0.717989, 0.382683> }
triangle { <-0.581416, 0.717989, 0.382683>, <-0.543043, 0.747434, 0.382683>, <-0.533793, 0.734703, 0.418660> }
triangle { <-0.543043, 0.747434, 0.382683>, <-0.581416, 0.717989, 0.382683>, <-0.590423, 0.729112, 0.346117> }
triangle { <-0.590423, 0.729112, 0.346117>, <-0.551455, 0.759013, 0.346117>, <-0.543043, 0.747434, 0.382683> }
triangle { <-0.551455, 0.759013, 0.346117>, <-0.590423, 0.729112, 0.346117>, <-0.598519, 0.739110, 0.309017> }
triangle { <-0.598519, 0.739110, 0.309017>, <-0.559017, 0.769421, 0.309017>, <-0.551455, 0.759013, 0.346117> }
triangle { <-0.559017, 0.769421, 0.309017>, <-0.598519, 0.739110, 0.309017>, <-0.605693, 0.747968, 0.271440> }
triangle { <-0.605693, 0.747968, 0.271440>, <-0.565717, 0.778643, 0.271440>, <-0.559017, 0.769421, 0.309017> }
triangle { <-0.565717, 0.778643, 0.271440>, <-0.605693, 0.747968, 0.271440>, <-0.611932, 0.755673, 0.233445> }
triangle { <-0.611932, 0.755673, 0.233445>, <-0.571545, 0.786664, 0.233445>, <-0.565717, 0.778643, 0.271440> }
triangle { <-0.571545, 0.786664, 0.233445>, <-0.611932, 0.755673, 0.233445>, <-0.617228, 0.762213, 0.195090> }
triangle { <-0.617228, 0.762213, 0.195090>, <-0.576491, 0.793472, 0.195090>, <-0.571545, 0.786664, 0.233445> }
triangle { <-0.576491, 0.793472, 0.195090>, <-0.617228, 0.762213, 0.195090>, <-0.621572, 0.767578, 0.156434> }
triangle { <-0.621572, 0.767578, 0.156434>, <-0.580549, 0.799057, 0.156434>, <-0.576491, 0.793472, 0.195090> }
triangle { <-0.580549, 0.799057, 0.156434>, <-0.621572, 0.767578, 0.156434>, <-0.624958, 0.771759, 0.117537> }
triangle { <-0.624958, 0.771759, 0.117537>, <-0.583711, 0.803409, 0.117537>, <-0.580549, 0.799057, 0.156434> }
triangle { <-0.583711, 0.803409, 0.117537>, <-0.624958, 0.771759, 0.117537>, <-0.627380, 0.774750, 0.078459> }
triangle { <-0.627380, 0.774750, 0.078459>, <-0.585973, 0.806523, 0.078459>, <-0.583711, 0.803409, 0.117537> }
triangle { <-0.585973, 0.806523, 0.078459>, <-0.627380, 0.774750, 0.078459>, <-0.628835, 0.776547, 0.039260> }
triangle { <-0.628835, 0.776547, 0.039260>, <-0.587332, 0.808393, 0.039260>, <-0.585973, 0.806523, 0.078459> }
triangle { <-0.587332, 0.808393, 0.039260>, <-0.628835, 0.776547, 0.039260>, <-0.629320, 0.777146, -0.000000> }
triangle { <-0.629320, 0.777146, -0.000000>, <-0.587785, 0.809017, -0.000000>, <-0.587332, 0.808393, 0.039260> }
triangle { <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <-0.026270, 0.029176, 0.999229> }
triangle { <-0.026270, 0.029176, 0.999229>, <-0.024707, 0.030511, 0.999229>, <0.000000, 0.000000, 1.000000> }
triangle { <-0.024707, 0.030511, 0.999229>, <-0.026270, 0.029176, 0.999229>, <-0.052499, 0.058306, 0.996917> }
triangle { <-0.052499, 0.058306, 0.996917>, <-0.049376, 0.060974, 0.996917>, <-0.024707, 0.030511, 0.999229> }
triangle { <-0.049376, 0.060974, 0.996917>, <-0.052499, 0.058306, 0.996917>, <-0.078648, 0.087347, 0.993068> }
triangle { <-0.078648, 0.087347, 0.993068>, <-0.073969, 0.091344, 0.993068>, <-0.049376, 0.060974, 0.996917> }
triangle { <-0.073969, 0.091344, 0.993068>, <-0.078648, 0.087347, 0.993068>, <-0.104675, 0.116253, 0.987688> }
triangle { <-0.104675, 0.116253, 0.987688>, <-0.098447, 0.121572, 0.987688>, <-0.073969, 0.091344, 0.993068> }
triangle { <-0.098447, 0.121572, 0.987688>, <-0.104675, 0.116253, 0.987688>, <-0.130541, 0.144980, 0.980785> }
triangle { <-0.130541, 0.144980, 0.980785>, <-0.122774, 0.151614, 0.980785>, <-0.098447, 0.121572, 0.987688> }
triangle { <-0.122774, 0.151614, 0.980785>, <-0.130541, 0.144980, 0.980785>, <-0.156205, 0.173484, 0.972370> }
triangle { <-0.156205, 0.173484, 0.972370>, <-0.146912, 0.181421, 0.972370>, <-0.122774, 0.151614, 0.980785> }
triangle { <-0.146912, 0.181421, 0.972370>, <-0.156205, 0.173484, 0.972370>, <-0.181629, 0.201720, 0.962455> }
triangle { <-0.181629, 0.201720, 0.962455>, <-0.170823, 0.210949, 0.962455>, <-0.146912, 0.181421, 0.972370> }
triangle { <-0.170823, 0.210949, 0.962455>, <-0.181629, 0.201720, 0.962455>, <-0.206773, 0.229644, 0.951057> }
triangle { <-0.206773, 0.229644, 0.951057>, <-0.194471, 0.240151, 0.951057>, <-0.170823, 0.210949, 0.962455> }
triangle { <-0.194471, 0.240151, 0.951057>, <-0.206773, 0.229644, 0.951057>, <-0.231598, 0.257215, 0.938191> }
triangle { <-0.231598, 0.257215, 0.938191>, <-0.217819, 0.268983, 0.938191>, <-0.194471, 0.240151, 0.951057> }
triangle { <-0.217819, 0.268983, 0.938191>, <-0.231598, 0.257215, 0.938191>, <-0.256065, 0.284389, 0.923880> }
triangle { <-0.256065, 0.284389, 0.923880>, <-0.240830, 0.297401, 0.923880>, <-0.217819, 0.268983, 0.938191> }
triangle { <-0.240830, 0.297401, 0.923880>, <-0.256065, 0.284389, 0.923880>, <-0.280138, 0.311125, 0.908143> }
triangle { <-0.280138, 0.311125, 0.908143>, <-0.263471, 0.325360, 0.908143>, <-0.240830, 0.297401, 0.923880> }
triangle { <-0.263471, 0.325360, 0.908143>, <-0.280138, 0.311125, 0.908143>, <-0.303779, 0.337381, 0.891007> }
triangle { <-0.303779, 0.337381, 0.891007>, <-0.285705, 0.352817, 0.891007>, <-0.263471, 0.325360, 0.908143> }
triangle { <-0.285705, 0.352817, 0.891007>, <-0.303779, 0.337381, 0.891007>, <-0.326951, 0.363116, 0.872496> }
triangle { <-0.326951, 0.363116, 0.872496>, <-0.307499, 0.379730, 0.872496>, <-0.285705, 0.352817, 0.891007> }
triangle { <-0.307499, 0.379730, 0.872496>, <-0.326951, 0.363116, 0.872496>, <-0.349620, 0.388292, 0.852640> }
triangle { <-0.349620, 0.388292, 0.852640>, <-0.328819, 0.406058, 0.852640>, <-0.307499, 0.379730, 0.872496> }
triangle { <-0.328819, 0.406058, 0.852640>, <-0.349620, 0.388292, 0.852640>, <-0.371749, 0.412869, 0.831470> }
triangle { <-0.371749, 0.412869, 0.831470>, <-0.349632, 0.431759, 0.831470>, <-0.328819, 0.406058, 0.852640> }
triangle { <-0.349632, 0.431759, 0.831470>, <-0.371749, 0.412869, 0.831470>, <-0.393305, 0.436810, 0.809017> }
triangle { <-0.393305, 0.436810, 0.809017>, <-0.369905, 0.456795, 0.809017>, <-0.349632, 0.431759, 0.831470> }
triangle { <-0.369905, 0.456795, 0.809017>, <-0.393305, 0.436810, 0.809017>, <-0.414255, 0.460076, 0.785317> }
triangle { <-0.414255, 0.460076, 0.785317>, <-0.389608, 0.481126, 0.785317>, <-0.369905, 0.456795, 0.809017> }
triangle { <-0.389608, 0.481126, 0.785317>, <-0.414255, 0.460076, 0.785317>, <-0.434566, 0.482634, 0.760406> }
triangle { <-0.434566, 0.482634, 0.760406>, <-0.408711, 0.504716, 0.760406>, <-0.389608, 0.481126, 0.785317> }
triangle { <-0.408711, 0.504716, 0.760406>, <-0.434566, 0.482634, 0.760406>, <-0.454206, 0.504447, 0.734323> }
triangle { <-0.454206, 0.504447, 0.734323>, <-0.427183, 0.527527, 0.734323>, <-0.408711, 0.504716, 0.760406> }
triangle { <-0.427183, 0.527527, 0.734323>, <-0.454206, 0.504447, 0.734323>, <-0.473147, 0.525483, 0.707107> }
triangle { <-0.473147, 0.525483, 0.707107>, <-0.444997, 0.549525, 0.707107>, <-0.427183, 0.527527, 0.734323> }
triangle { <-0.444997, 0.549525, 0.707107>, <-0.473147, 0.525483, 0.707107>, <-0.491358, 0.545708, 0.678801> }
triangle { <-0.491358, 0.545708, 0.678801>, <-0.462124, 0.570676, 0.678801>, <-0.444997, 0.549525, 0.707107> }
triangle { <-0.462124, 0.570676, 0.678801>, <-0.491358, 0.545708, 0.678801>, <-0.508811, 0.565092, 0.649448> }
triangle { <-0.508811, 0.565092, 0.649448>, <-0.478539, 0.590946, 0.649448>, <-0.462124, 0.570676, 0.678801> }
triangle { <-0.478539, 0.590946, 0.649448>, <-0.508811, 0.565092, 0.649448>, <-0.525480, 0.583604, 0.619094> }
triangle { <-0.525480, 0.583604, 0.619094>, <-0.494216, 0.610306, 0.619094>, <-0.478539, 0.590946, 0.649448> }
triangle { <-0.494216, 0.610306, 0.619094>, <-0.525480, 0.583604, 0.619094>, <-0.541338, 0.601217, 0.587785> }
triangle { <-0.541338, 0.601217, 0.587785>, <-0.509131, 0.628724, 0.587785>, <-0.494216, 0.610306, 0.619094> }
triangle { <-0.509131, 0.628724, 0.587785>, <-0.541338, 0.601217, 0.587785>, <-0.556362, 0.617902, 0.555570> }
triangle { <-0.556362, 0.617902, 0.555570>, <-0.523261, 0.646173, 0.555570>, <-0.509131, 0.628724, 0.587785> }
triangle { <-0.523261, 0.646173, 0.555570>, <-0.556362, 0.617902, 0.555570>, <-0.570528, 0.633635, 0.522499> }
triangle { <-0.570528, 0.633635, 0.522499>, <-0.536584, 0.662626, 0.522499>, <-0.523261, 0.646173, 0.555570> }
triangle { <-0.536584, 0.662626, 0.522499>, <-0.570528, 0.633635, 0.522499>, <-0.583814, 0.648391, 0.488621> }
triangle { <-0.583814, 0.648391, 0.488621>, <-0.549080, 0.678057, 0.488621>, <-0.536584, 0.662626, 0.522499> }
triangle { <-0.549080, 0.678057, 0.488621>, <-0.583814, 0.648391, 0.488621>, <-0.596200, 0.662147, 0.453990> }
triangle { <-0.596200, 0.662147, 0.453990>, <-0.560729, 0.692442, 0.453990>, <-0.549080, 0.678057, 0.488621> }
triangle { <-0.560729, 0.692442, 0.453990>, <-0.596200, 0.662147, 0.453990>, <-0.607666, 0.674882, 0.418660> }
triangle { <-0.607666, 0.674882, 0.418660>, <-0.571513, 0.705760, 0.418660>, <-0.560729, 0.692442, 0.453990> }
triangle { <-0.571513, 0.705760, 0.418660>, <-0.607666, 0.674882, 0.418660>, <-0.618196, 0.686576, 0.382683> }
triangle { <-0.618196, 0.686576, 0.382683>, <-0.581416, 0.717989, 0.382683>, <-0.571513, 0.705760, 0.418660> }
triangle { <-0.581416, 0.717989, 0.382683>, <-0.618196, 0.686576, 0.382683>, <-0.627773, 0.697212, 0.346117> }
triangle { <-0.627773, 0.697212, 0.346117>, <-0.590423, 0.729112, 0.346117>, <-0.581416, 0.717989, 0.382683> }
triangle { <-0.590423, 0.729112, 0.346117>, <-0.627773, 0.697212, 0.346117>, <-0.636381, 0.706773, 0.309017> }
triangle { <-0.636381, 0.706773, 0.309017>, <-0.598519, 0.739110, 0.309017>, <-0.590423, 0.729112, 0.346117> }
triangle { <-0.598519, 0.739110, 0.309017>, <-0.636381, 0.706773, 0.309017>, <-0.644008, 0.715244, 0.271440> }
triangle { <-0.644008, 0.715244, 0.271440>, <-0.605693, 0.747968, 0.271440>, <-0.598519, 0.739110, 0.309017> }
triangle { <-0.605693, 0.747968, 0.271440>, <-0.644008, 0.715244, 0.271440>, <-0.650642, 0.722612, 0.233445> }
triangle { <-0.650642, 0.722612, 0.233445>, <-0.611932, 0.755673, 0.233445>, <-0.605693, 0.747968, 0.271440> }
triangle { <-0.611932, 0.755673, 0.233445>, <-0.650642, 0.722612, 0.233445>, <-0.656273, 0.728866, 0.195090> }
triangle { <-0.656273, 0.728866, 0.195090>, <-0.617228, 0.762213, 0.195090>, <-0.611932, 0.755673, 0.233445> }
triangle { <-0.617228, 0.762213, 0.195090>, <-0.656273, 0.728866, 0.195090>, <-0.660892, 0.733995, 0.156434> }
triangle { <-0.660892, 0.733995, 0.156434>, <-0.621572, 0.767578, 0.156434>, <-0.617228, 0.762213, 0.195090> }
triangle { <-0.621572, 0.767578, 0.156434>, <-0.660892, 0.733995, 0.156434>, <-0.664492, 0.737994, 0.117537> }
triangle { <-0.664492, 0.737994, 0.117537>, <-0.624958, 0.771759, 0.117537>, <-0.621572, 0.767578, 0.156434> }
triangle { <-0.624958, 0.771759, 0.117537>, <-0.664492, 0.737994, 0.117537>, <-0.667068, 0.740854, 0.078459> }
triangle { <-0.667068, 0.740854, 0.078459>, <-0.627380, 0.774750, 0.078459>, <-0.624958, 0.771759, 0.117537> }
triangle { <-0.627380, 0.774750, 0.078459>, <-0.667068, 0.740854, 0.078459>, <-0.668615, 0.742572, 0.039260> }
triangle { <-0.668615, 0.742572, 0.039260>, <-0.628835, 0.776547, 0.039260>, <-0.627380, 0.774750, 0.078459> }
triangle { <-0.628835, 0.776547, 0.039260>, <-0.668615, 0.742572, 0.039260>, <-0.669131, 0.743145, -0.000000> }
triangle { <-0.669131, 0.743145, -0.000000>, <-0.629320, 0.777146, -0.000000>, <-0.628835, 0.776547, 0.039260> }
triangle { <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <-0.027761, 0.027761, 0.999229> }
triangle { <-0.027761, 0.027761, 0.999229>, <-0.026270, 0.029176, 0.999229>, <0.000000, 0.000000, 1.000000> }
triangle { <-0.026270, 0.029176, 0.999229>, <-0.027761, 0.027761, 0.999229>, <-0.055479, 0.055479, 0.996917> }
triangle { <-0.055479, 0.055479, 0.996917>, <-0.052499, 0.058306, 0.996917>, <-0.026270, 0.029176, 0.999229> }
triangle { <-0.052499, 0.058306, 0.996917>, <-0.055479, 0.055479, 0.996917>, <-0.083111, 0.083111, 0.993068> }
triangle { <-0.083111, 0.083111, 0.993068>, <-0.078648, 0.087347, 0.993068>, <-0.052499, 0.058306, 0.996917> }
triangle { <-0.078648, 0.087347, 0.993068>, <-0.083111, 0.083111, 0.993068>, <-0.110616, 0.110616, 0.987688> }
triangle { <-0.110616, 0.110616, 0.987688>, <-0.104675, 0.116253, 0.987688>, <-0.078648, 0.087347, 0.993068> }
triangle { <-0.104675, 0.116253, 0.987688>, <-0.110616, 0.110616, 0.987688>, <-0.137950, 0.137950, 0.980785> }
triangle { <-0.137950, 0.137950, 0.980785>, <-0.130541, 0.144980, 0.980785>, <-0.104675, 0.116253, 0.987688> }
triangle { <-0.130541, 0.144980, 0.980785>, <-0.137950, 0.137950, 0.980785>, <-0.165071, 0.165071, 0.972370> }
triangle { <-0.165071, 0.165071, 0.972370>, <-0.156205, 0.173484, 0.972370>, <-0.130541, 0.144980, 0.980785> }
triangle { <-0.156205, 0.173484, 0.972370>, <-0.165071, 0.165071, 0.972370>, <-0.191937, 0.191937, 0.962455> }
triangle { <-0.191937, 0.191937, 0.962455>, <-0.181629, 0.201720, 0.962455>, <-0.156205, 0.173484, 0.972370> }
triangle { <-0.181629, 0.201720, 0.962455>, <-0.191937, 0.191937, 0.962455>, <-0.218508, 0.218508, 0.951057> }
triangle { <-0.218508, 0.218508, 0.951057>, <-0.206773, 0.229644, 0.951057>, <-0.181629, 0.201720, 0.962455> }
triangle { <-0.206773, 0.229644, 0.951057>, <-0.218508, 0.218508, 0.951057>, <-0.244742, 0.244742, 0.938191> }
triangle { <-0.244742, 0.244742, 0.938191>, <-0.231598, 0.257215, 0.938191>, <-0.206773, 0.229644, 0.951057> }
triangle { <-0.231598, 0.257215, 0.938191>, <-0.244742, 0.244742, 0.938191>, <-0.270598, 0.270598, 0.923880> }
triangle { <-0.270598, 0.270598, 0.923880>, <-0.256065, 0.284389, 0.923880>, <-0.231598, 0.257215, 0.938191> }
triangle { <-0.256065, 0.284389, 0.923880>, <-0.270598, 0.270598, 0.923880>, <-0.296037, 0.296037, 0.908143> }
triangle { <-0.296037, 0.296037, 0.908143>, <-0.280138, 0.311125, 0.908143>, <-0.256065, 0.284389, 0.923880> }
triangle { <-0.280138, 0.311125, 0.908143>, <-0.296037, 0.296037, 0.908143>, <-0.321020, 0.321020, 0.891007> }
triangle { <-0.321020, 0.321020, 0.891007>, <-0.303779, 0.337381, 0.891007>, <-0.280138, 0.311125, 0.908143> }
triangle { <-0.303779, 0.337381, 0.891007>, <-0.321020, 0.321020, 0.891007>, <-0.345507, 0.345507, 0.872496> }
triangle { <-0.345507, 0.345507, 0.872496>, <-0.326951, 0.363116, 0.872496>, <-0.303779, 0.337381, 0.891007> }
triangle { <-0.326951, 0.363116, 0.872496>, <-0.345507, 0.345507, 0.872496>, <-0.369462, 0.369462, 0.852640> }
triangle { <-0.369462, 0.369462, 0.852640>, <-0.349620, 0.388292, 0.852640>, <-0.326951, 0.363116, 0.872496> }
triangle { <-0.349620, 0.388292, 0.852640>, <-0.369462, 0.369462, 0.852640>, <-0.392847, 0.392847, 0.831470> }
triangle { <-0.392847, 0.392847, 0.831470>, <-0.371749, 0.412869, 0.831470>, <-0.349620, 0.388292, 0.852640> }
triangle { <-0.371749, 0.412869, 0.831470>, <-0.392847, 0.392847, 0.831470>, <-0.415627, 0.415627, 0.809017> }
triangle { <-0.415627, 0.415627, 0.809017>, <-0.393305, 0.436810, 0.809017>, <-0.371749, 0.412869, 0.831470> }
triangle { <-0.393305, 0.436810, 0.809017>, <-0.415627, 0.415627, 0.809017>, <-0.437766, 0.437766, 0.785317> }
triangle { <-0.437766, 0.437766, 0.785317>, <-0.414255, 0.460076, 0.785317>, <-0.393305, 0.436810, 0.809017> }
triangle { <-0.414255, 0.460076, 0.785317>, <-0.437766, 0.437766, 0.785317>, <-0.459229, 0.459229, 0.760406> }
triangle { <-0.459229, 0.459229, 0.760406>, <-0.434566, 0.482634, 0.760406>, <-0.414255, 0.460076, 0.785317> }
triangle { <-0.434566, 0.482634, 0.760406>, <-0.459229, 0.459229, 0.760406>, <-0.479985, 0.479985, 0.734323> }
triangle { <-0.479985, 0.479985, 0.734323>, <-0.454206, 0.504447, 0.734323>, <-0.434566, 0.482634, 0.760406> }
triangle { <-0.454206, 0.504447, 0.734323>, <-0.479985, 0.479985, 0.734323>, <-0.500000, 0.500000, 0.707107> }
triangle { <-0.500000, 0.500000, 0.707107>, <-0.473147, 0.525483, 0.707107>, <-0.454206, 0.504447, 0.734323> }
triangle { <-0.473147, 0.525483, 0.707107>, <-0.500000, 0.500000, 0.707107>, <-0.519244, 0.519244, 0.678801> }
triangle { <-0.519244, 0.519244, 0.678801>, <-0.491358, 0.545708, 0.678801>, <-0.473147, 0.525483, 0.707107> }
triangle { <-0.491358, 0.545708, 0.678801>, <-0.519244, 0.519244, 0.678801>, <-0.537688, 0.537688, 0.649448> }
triangle { <-0.537688, 0.537688, 0.649448>, <-0.508811, 0.565092, 0.649448>, <-0.491358, 0.545708, 0.678801> }
triangle { <-0.508811, 0.565092, 0.649448>, <-0.537688, 0.537688, 0.649448>, <-0.555303, 0.555303, 0.619094> }
triangle { <-0.555303, 0.555303, 0.619094>, <-0.525480, 0.583604, 0.619094>, <-0.508811, 0.565092, 0.649448> }
triangle { <-0.525480, 0.583604, 0.619094>, <-0.555303, 0.555303, 0.619094>, <-0.572061, 0.572061, 0.587785> }
triangle { <-0.572061, 0.572061, 0.587785>, <-0.541338, 0.601217, 0.587785>, <-0.525480, 0.583604, 0.619094> }
triangle { <-0.541338, 0.601217, 0.587785>, <-0.572061, 0.572061, 0.587785>, <-0.587938, 0.587938, 0.555570> }
triangle { <-0.587938, 0.587938, 0.555570>, <-0.556362, 0.617902, 0.555570>, <-0.541338, 0.601217, 0.587785> }
triangle { <-0.556362, 0.617902, 0.555570>, <-0.587938, 0.587938, 0.555570>, <-0.602908, 0.602908, 0.522499> }
triangle { <-0.602908, 0.602908, 0.522499>, <-0.570528, 0.633635, 0.522499>, <-0.556362, 0.617902, 0.555570> }
triangle { <-0.570528, 0.633635, 0.522499>, <-0.602908, 0.602908, 0.522499>, <-0.616948, 0.616948, 0.488621> }
triangle { <-0.616948, 0.616948, 0.488621>, <-0.583814, 0.648391, 0.488621>, <-0.570528, 0.633635, 0.522499> }
triangle { <-0.583814, 0.648391, 0.488621>, <-0.616948, 0.616948, 0.488621>, <-0.630037, 0.630037, 0.453990> }
triangle { <-0.630037, 0.630037, 0.453990>, <-0.596200, 0.662147, 0.453990>, <-0.583814, 0.648391, 0.488621> }
triangle { <-0.596200, 0.662147, 0.453990>, <-0.630037, 0.630037, 0.453990>, <-0.642154, 0.642154, 0.418660> }
triangle { <-0.642154, 0.642154, 0.418660>, <-0.607666, 0.674882, 0.418660>, <-0.596200, 0.662147, 0.453990> }
triangle { <-0.607666, 0.674882, 0.418660>, <-0.642154, 0.642154, 0.418660>, <-0.653281, 0.653281, 0.382683> }
triangle { <-0.653281, 0.653281, 0.382683>, <-0.618196, 0.686576, 0.382683>, <-0.607666, 0.674882, 0.418660> }
triangle { <-0.618196, 0.686576, 0.382683>, <-0.653281, 0.653281, 0.382683>, <-0.663401, 0.663401, 0.346117> }
triangle { <-0.663401, 0.663401, 0.346117>, <-0.627773, 0.697212, 0.346117>, <-0.618196, 0.686576, 0.382683> }
triangle { <-0.627773, 0.697212, 0.346117>, <-0.663401, 0.663401, 0.346117>, <-0.672499, 0.672499, 0.309017> }
triangle { <-0.672499, 0.672499, 0.309017>, <-0.636381, 0.706773, 0.309017>, <-0.627773, 0.697212, 0.346117> }
triangle { <-0.636381, 0.706773, 0.309017>, <-0.672499, 0.672499, 0.309017>, <-0.680559, 0.680559, 0.271440> }
triangle { <-0.680559, 0.680559, 0.271440>, <-0.644008, 0.715244, 0.271440>, <-0.636381, 0.706773, 0.309017> }
triangle { <-0.644008, 0.715244, 0.271440>, <-0.680559, 0.680559, 0.271440>, <-0.687569, 0.687569, 0.233445> }
triangle { <-0.687569, 0.687569, 0.233445>, <-0.650642, 0.722612, 0.233445>, <-0.644008, 0.715244, 0.271440> }
triangle { <-0.650642, 0.722612, 0.233445>, <-0.687569, 0.687569, 0.233445>, <-0.693520, 0.693520, 0.195090> }
triangle { <-0.693520, 0.693520, 0.195090>, <-0.656273, 0.728866, 0.195090>, <-0.650642, 0.722612, 0.233445> }
triangle { <-0.656273, 0.728866, 0.195090>, <-0.693520, 0.693520, 0.195090>, <-0.698401, 0.698401, 0.156434> }
triangle { <-0.698401, 0.698401, 0.156434>, <-0.660892, 0.733995, 0.156434>, <-0.656273, 0.728866, 0.195090> }
triangle { <-0.660892, 0.733995, 0.156434>, <-0.698401, 0.698401, 0.156434>, <-0.702205, 0.702205, 0.117537> }
triangle { <-0.702205, 0.702205, 0.117537>, <-0.664492, 0.737994, 0.117537>, <-0.660892, 0.733995, 0.156434> }
triangle { <-0.664492, 0.737994, 0.117537>, <-0.702205, 0.702205, 0.117537>, <-0.704927, 0.704927, 0.078459> }
triangle { <-0.704927, 0.704927, 0.078459>, <-0.667068, 0.740854, 0.078459>, <-0.664492, 0.737994, 0.117537> }
triangle { <-0.667068, 0.740854, 0.078459>, <-0.704927, 0.704927, 0.078459>, <-0.706562, 0.706562, 0.039260> }
triangle { <-0.706562, 0.706562, 0.039260>, <-0.668615, 0.742572, 0.039260>, <-0.667068, 0.740854, 0.078459> }
triangle { <-0.668615, 0.742572, 0.039260>, <-0.706562, 0.706562, 0.039260>, <-0.707107, 0.707107, -0.000000> }
triangle { <-0.707107, 0.707107, -0.000000>, <-0.669131, 0.743145, -0.000000>, <-0.668615, 0.742572, 0.039260> }
triangle { <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <-0.029176, 0.026270, 0.999229> }
triangle { <-0.029176, 0.026270, 0.999229>, <-0.027761, 0.027761, 0.999229>, <0.000000, 0.000000, 1.000000> }
triangle { <-0.027761, 0.027761, 0.999229>, <-0.029176, 0.026270, 0.999229>, <-0.058306, 0.052499, 0.996917> }
triangle { <-0.058306, 0.052499, 0.996917>, <-0.055479, 0.055479, 0.996917>, <-0.027761, 0.027761, 0.999229> }
triangle { <-0.055479, 0.055479, 0.996917>, <-0.058306, 0.052499, 0.996917>, <-0.087347, 0.078648, 0.993068> }
triangle { <-0.087347, 0.078648, 0.993068>, <-0.083111, 0.083111, 0.993068>, <-0.055479, 0.055479, 0.996917> }
triangle { <-0.083111, 0.083111, 0.993068>, <-0.087347, 0.078648, 0.993068>, <-0.116253, 0.104675, 0.987688> }
triangle { <-0.116253, 0.104675, 0.987688>, <-0.110616, 0.110616, 0.987688>, <-0.083111, 0.083111, 0.993068> }
triangle { <-0.110616, 0.110616, 0.987688>, <-0.116253, 0.104675, 0.987688>, <-0.144980, 0.130541, 0.980785> }
triangle { <-0.144980, 0.130541, 0.980785>, <-0.137950, 0.137950, 0.980785>, <-0.110616, 0.110616, 0.987688> }
triangle { <-0.137950, 0.137950, 0.980785>, <-0.144980, 0.130541, 0.980785>, <-0.173484, 0.156205, 0.972370> }
triangle { <-0.173484, 0.156205, 0.972370>, <-0.165071, 0.165071, 0.972370>, <-0.137950, 0.137950, 0.980785> }
triangle { <-0.165071, 0.165071, 0.972370>, <-0.173484, 0.156205, 0.972370>, <-0.201720, 0.181629, 0.962455> }
triangle { <-0.201720, 0.181629, 0.962455>, <-0.191937, 0.191937, 0.962455>, <-0.165071, 0.165071, 0.972370> }
triangle { <-0.191937, 0.191937, 0.962455>, <-0.201720, 0.181629, 0.962455>, <-0.229644, 0.206773, 0.951057> }
triangle { <-0.229644, 0.206773, 0.951057>, <-0.218508, 0.218508, 0.951057>, <-0.191937, 0.191937, 0.962455> }
triangle { <-0.218508, 0.218508, 0.951057>, <-0.229644, 0.206773, 0.951057>, <-0.257215, 0.231598, 0.938191> }
triangle { <-0.257215, 0.231598, 0.938191>, <-0.244742, 0.244742, 0.938191>, <-0.218508, 0.218508, 0.951057> }
triangle { <-0.244742, 0.244742, 0.938191>, <-0.257215, 0.231598, 0.938191>, <-0.284389, 0.256065, 0.923880> }
triangle { <-0.284389, 0.256065, 0.923880>, <-0.270598, 0.270598, 0.923880>, <-0.244742, 0.244742, 0.938191> }
triangle { <-0.270598, 0.270598, 0.923880>, <-0.284389, 0.256065, 0.923880>, <-0.311125, 0.280138, 0.908143> }
triangle { <-0.311125, 0.280138, 0.908143>, <-0.296037, 0.296037, 0.908143>, <-0.270598, 0.270598, 0.923880> }
triangle { <-0.296037, 0.296037, 0.908143>, <-0.311125, 0.280138, 0.908143>, <-0.337381, 0.303779, 0.891007> }
triangle { <-0.337381, 0.303779, 0.891007>, <-0.321020, 0.321020, 0.891007>, <-0.296037, 0.296037, 0.908143> }
triangle { <-0.321020, 0.321020, 0.891007>, <-0.337381, 0.303779, 0.891007>, <-0.363116, 0.326951, 0.872496> }
triangle { <-0.363116, 0.326951, 0.872496>, <-0.345507, 0.345507, 0.872496>, <-0.321020, 0.321020, 0.891007> }
triangle { <-0.345507, 0.345507, 0.872496>, <-0.363116, 0.326951, 0.872496>, <-0.388292, 0.349620, 0.852640> }
triangle { <-0.388292, 0.349620, 0.852640>, <-0.369462, 0.369462, 0.852640>, <-0.345507, 0.345507, 0.872496> }
triangle { <-0.369462, 0.369462, 0.852640>, <-0.388292, 0.349620, 0.852640>, <-0.412869, 0.371749, 0.831470> }
triangle { <-0.412869, 0.371749, 0.831470>, <-0.392847, 0.392847, 0.831470>, <-0.369462, 0.369462, 0.852640> }
triangle { <-0.392847, 0.392847, 0.831470>, <-0.412869, 0.371749, 0.831470>, <-0.436810, 0.393305, 0.809017> }
triangle { <-0.436810, 0.393305, 0.809017>, <-0.415627, 0.415627, 0.809017>, <-0.392847, 0.392847, 0.831470> }
triangle { <-0.415627, 0.415627, 0.809017>, <-0.436810, 0.393305, 0.809017>, <-0.460076, 0.414255, 0.785317> }
triangle { <-0.460076, 0.414255, 0.785317>, <-0.437766, 0.437766, 0.785317>, <-0.415627, 0.415627, 0.809017> }
triangle { <-0.437766, 0.437766, 0.785317>, <-0.460076, 0.414255, 0.785317>, <-0.482634, 0.434566, 0.760406> }
triangle { <-0.482634, 0.434566, 0.760406>, <-0.459229, 0.459229, 0.760406>, <-0.437766, 0.437766, 0.785317> }
triangle { <-0.459229, 0.459229, 0.760406>, <-0.482634, 0.434566, 0.760406>, <-0.504447, 0.454206, 0.734323> }
triangle { <-0.504447, 0.454206, 0.734323>, <-0.479985, 0.479985, 0.734323>, <-0.459229, 0.459229, 0.760406> }
triangle { <-0.479985, 0.479985, 0.734323>, <-0.504447, 0.454206, 0.734323>, <-0.525483, 0.473147, 0.707107> }
triangle { <-0.525483, 0.473147, 0.707107>, <-0.500000, 0.500000, 0.707107>, <-0.479985, 0.479985, 0.734323> }
triangle { <-0.500000, 0.500000, 0.707107>, <-0.525483, 0.473147, 0.707107>, <-0.545708, 0.491358, 0.678801> }
triangle { <-0.545708, 0.491358, 0.678801>, <-0.519244, 0.519244, 0.678801>, <-0.500000, 0.500000, 0.707107> }
triangle { <-0.519244, 0.519244, 0.678801>, <-0.545708, 0.491358, 0.678801>, <-0.565092, 0.508811, 0.649448> }
triangle { <-0.565092, 0.508811, 0.649448>, <-0.537688, 0.537688, 0.649448>, <-0.519244, 0.519244, 0.678801> }
triangle { <-0.537688, 0.537688, 0.649448>, <-0.565092, 0.508811, 0.649448>, <-0.583604, 0.525480, 0.619094> }
triangle { <-0.583604, 0.525480, 0.619094>, <-0.555303, 0.555303, 0.619094>, <-0.537688, 0.537688, 0.649448> }
triangle { <-0.555303, 0.555303, 0.619094>, <-0.583604, 0.525480, 0.619094>, <-0.601217, 0.541338, 0.587785> }
triangle { <-0.601217, 0.541338, 0.587785>, <-0.572061, 0.572061, 0.587785>, <-0.555303, 0.555303, 0.619094> }
triangle { <-0.572061, 0.572061, 0.587785>, <-0.601217, 0.541338, 0.587785>, <-0.617902, 0.556362, 0.555570> }
triangle { <-0.617902, 0.556362, 0.555570>, <-0.587938, 0.587938, 0.555570>, <-0.572061, 0.572061, 0.587785> }
triangle { <-0.587938, 0.587938, 0.555570>, <-0.617902, 0.556362, 0.555570>, <-0.633635, 0.570528, 0.522499> }
triangle { <-0.633635, 0.570528, 0.522499>, <-0.602908, 0.602908, 0.522499>, <-0.587938, 0.587938, 0.555570> }
triangle { <-0.602908, 0.602908, 0.522499>, <-0.633635, 0.570528, 0.522499>, <-0.648391, 0.583814, 0.488621> }
triangle { <-0.648391, 0.583814, 0.488621>, <-0.616948, 0.616948, 0.488621>, <-0.602908, 0.602908, 0.522499> }
triangle { <-0.616948, 0.616948, 0.488621>, <-0.648391, 0.583814, 0.488621>, <-0.662147, 0.596200, 0.453990> }
triangle { <-0.662147, 0.596200, 0.453990>, <-0.630037, 0.630037, 0.453990>, <-0.616948, 0.616948, 0.488621> }
triangle { <-0.630037, 0.630037, 0.453990>, <-0.662147, 0.596200, 0.453990>, <-0.674882, 0.607666, 0.418660> }
triangle { <-0.674882, 0.607666, 0.418660>, <-0.642154, 0.642154, 0.418660>, <-0.630037, 0.630037, 0.453990> }
triangle { <-0.642154, 0.642154, 0.418660>, <-0.674882, 0.607666, 0.418660>, <-0.686576, 0.618196, 0.382683> }
triangle { <-0.686576, 0.618196, 0.382683>, <-0.653281, 0.653281, 0.382683>, <-0.642154, 0.642154, 0.418660> }
triangle { <-0.653281, 0.653281, 0.382683>, <-0.686576, 0.618196, 0.382683>, <-0.697212, 0.627773, 0.346117> }
triangle { <-0.697212, 0.627773, 0.346117>, <-0.663401, 0.663401, 0.346117>, <-0.653281, 0.653281, 0.382683> }
triangle { <-0.663401, 0.663401, 0.346117>, <-0.697212, 0.627773, 0.346117>, <-0.706773, 0.636381, 0.309017> }
triangle { <-0.706773, 0.636381, 0.309017>, <-0.672499, 0.672499, 0.309017>, <-0.663401, 0.663401, 0.346117> }
triangle { <-0.672499, 0.672499, 0.309017>, <-0.706773, 0.636381, 0.309017>, <-0.715244, 0.644008, 0.271440> }
triangle { <-0.715244, 0.644008, 0.271440>, <-0.680559, 0.680559, 0.271440>, <-0.672499, 0.672499, 0.309017> }
triangle { <-0.680559, 0.680559, 0.271440>, <-0.715244, 0.644008, 0.271440>, <-0.722612, 0.650642, 0.233445> }
triangle { <-0.722612, 0.650642, 0.233445>, <-0.687569, 0.687569, 0.233445>, <-0.680559, 0.680559, 0.271440> }
triangle { <-0.687569, 0.687569, 0.233445>, <-0.722612, 0.650642, 0.233445>, <-0.728866, 0.656273, 0.195090> }
triangle { <-0.728866, 0.656273, 0.195090>, <-0.693520, 0.693520, 0.195090>, <-0.687569, 0.687569, 0.233445> }
triangle { <-0.693520, 0.693520, 0.195090>, <-0.728866, 0.656273, 0.195090>, <-0.733995, 0.660892, 0.156434> }
triangle { <-0.733995, 0.660892, 0.156434>, <-0.698401, 0.698401, 0.156434>, <-0.693520, 0.693520, 0.195090> }
triangle { <-0.698401, 0.698401, 0.156434>, <-0.733995, 0.660892, 0.156434>, <-0.737994, 0.664492, 0.117537> }
triangle { <-0.737994, 0.664492, 0.117537>, <-0.702205, 0.702205, 0.117537>, <-0.698401, 0.698401, 0.156434> }
triangle { <-0.702205, 0.702205, 0.117537>, <-0.737994, 0.664492, 0.117537>, <-0.740854, 0.667068, 0.078459> }
triangle { <-0.740854, 0.667068, 0.078459>, <-0.704927, 0.704927, 0.078459>, <-0.702205, 0.702205, 0.117537> }
triangle { <-0.704927, 0.704927, 0.078459>, <-0.740854, 0.667068, 0.078459>, <-0.742572, 0.668615, 0.039260> }
triangle { <-0.742572, 0.668615, 0.039260>, <-0.706562, 0.706562, 0.039260>, <-0.704927, 0.704927, 0.078459> }
triangle { <-0.706562, 0.706562, 0.039260>, <-0.742572, 0.668615, 0.039260>, <-0.743145, 0.669131, -0.000000> }
triangle { <-0.743145, 0.669131, -0.000000>, <-0.707107, 0.707107, -0.000000>, <-0.706562, 0.706562, 0.039260> }
triangle { <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <-0.030511, 0.024707, 0.999229> }
triangle { <-0.030511, 0.024707, 0.999229>, <-0.029176, 0.026270, 0.999229>, <0.000000, 0.000000, 1.000000> }
triangle { <-0.029176, 0.026270, 0.999229>, <-0.030511, 0.024707, 0.999229>, <-0.060974, 0.049376, 0.996917> }
triangle { <-0.060974, 0.049376, 0.996917>, <-0.058306, 0.052499, 0.996917>, <-0.029176, 0.026270, 0.999229> }
triangle { <-0.058306, 0.052499, 0.996917>, <-0.060974, 0.049376, 0.996917>, <-0.091344, 0.073969, 0.993068> }
triangle { <-0.091344, 0.073969, 0.993068>, <-0.087347, 0.078648, 0.993068>, <-0.058306, 0.052499, 0.996917> }
triangle { <-0.087347, 0.078648, 0.993068>, <-0.091344, 0.073969, 0.993068>, <-0.121572, 0.098447, 0.987688> }
triangle { <-0.121572, 0.098447, 0.987688>, <-0.116253, 0.104675, 0.987688>, <-0.087347, 0.078648, 0.993068> }
triangle { <-0.116253, 0.104675, 0.987688>, <-0.121572, 0.098447, 0.987688>, <-0.151614, 0.122774, 0.980785> }
triangle { <-0.151614, 0.122774, 0.980785>, <-0.144980, 0.130541, 0.980785>, <-0.116253, 0.104675, 0.987688> }
triangle { <-0.144980, 0.130541, 0.980785>, <-0.151614, 0.122774, 0.980785>, <-0.181421, 0.146912, 0.972370> }
triangle { <-0.181421, 0.146912, 0.972370>, <-0.173484, 0.156205, 0.972370>, <-0.144980, 0.130541, 0.980785> }
triangle { <-0.173484, 0.156205, 0.972370>, <-0.181421, 0.146912, 0.972370>, <-0.210949, 0.170823, 0.962455> }
triangle { <-0.210949, 0.170823, 0.962455>, <-0.201720, 0.181629, 0.962455>, <-0.173484, 0.156205, 0.972370> }
triangle { <-0.201720, 0.181629, 0.962455>, <-0.210949, 0.170823, 0.962455>, <-0.240151, 0.194471, 0.951057> }
triangle { <-0.240151, 0.194471, 0.951057>, <-0.229644, 0.206773, 0.951057>, <-0.201720, 0.181629, 0.962455> }
triangle { <-0.229644, 0.206773, 0.951057>, <-0.240151, 0.194471, 0.951057>, <-0.268983, 0.217819, 0.938191> }
triangle { <-0.268983, 0.217819, 0.938191>, <-0.257215, 0.231598, 0.938191>, <-0.229644, 0.206773, 0.951057> }
triangle { <-0.257215, 0.231598, 0.938191>, <-0.268983, 0.217819, 0.938191>, <-0.297401, 0.240830, 0.923880> }
triangle { <-0.297401, 0.240830, 0.923880>, <-0.284389, 0.256065, 0.923880>, <-0.257215, 0.231598, 0.938191> }
triangle { <-0.284389, 0.256065, 0.923880>, <-0.297401, 0.240830, 0.923880>, <-0.325360, 0.263471, 0.908143> }
triangle { <-0.325360, 0.263471, 0.908143>, <-0.311125, 0.280138, 0.908143>, <-0.284389, 0.256065, 0.923880> }
triangle { <-0.311125, 0.280138, 0.908143>, <-0.325360, 0.263471, 0.908143>, <-0.352817, 0.285705, 0.891007> }
triangle { <-0.352817, 0.285705, 0.891007>, <-0.337381, 0.303779, 0.891007>, <-0.311125, 0.280138, 0.908143> }
triangle { <-0.337381, 0.303779, 0.891007>, <-0.352817, 0.285705, 0.891007>, <-0.379730, 0.307499, 0.872496> }
triangle { <-0.379730, 0.307499, 0.872496>, <-0.363116, 0.326951, 0.872496>, <-0.337381, 0.303779, 0.891007> }
triangle { <-0.363116, 0.326951, 0.872496>, <-0.379730, 0.307499, 0.872496>, <-0.406058, 0.328819, 0.852640> }
triangle { <-0.406058, 0.328819, 0.852640>, <-0.388292, 0.349620, 0.852640>, <-0.363116, 0.326951, 0.872496> }
triangle { <-0.388292, 0.349620, 0.852640>, <-0.406058, 0.328819, 0.852640>, <-0.431759, 0.349632, 0.831470> }
triangle { <-0.431759, 0.349632, 0.831470>, <-0.412869, 0.371749, 0.831470>, <-0.388292, 0.349620, 0.852640> }
triangle { <-0.412869, 0.371749, 0.831470>, <-0.431759, 0.349632, 0.831470>, <-0.456795, 0.369905, 0.809017> }
triangle { <-0.456795, 0.369905, 0.809017>, <-0.436810, 0.393305, 0.809017>, <-0.412869, 0.371749, 0.831470> }
triangle { <-0.436810, 0.393305, 0.809017>, <-0.456795, 0.369905, 0.809017>, <-0.481126, 0.389608, 0.785317> }
triangle { <-0.481126, 0.389608, 0.785317>, <-0.460076, 0.414255, 0.785317>, <-0.436810, 0.393305, 0.809017> }
triangle { <-0.460076, 0.414255, 0.785317>, <-0.481126, 0.389608, 0.785317>, <-0.504716, 0.408711, 0.760406> }
triangle { <-0.504716, 0.408711, 0.760406>, <-0.482634, 0.434566, 0.760406>, <-0.460076, 0.414255, 0.785317> }
triangle { <-0.482634, 0.434566, 0.760406>, <-0.504716, 0.408711, 0.760406>, <-0.527527, 0.427183, 0.734323> }
triangle { <-0.527527, 0.427183, 0.734323>, <-0.504447, 0.454206, 0.734323>, <-0.482634, 0.434566, 0.760406> }
triangle { <-0.504447, 0.454206, 0.734323>, <-0.527527, 0.427183, 0.734323>, <-0.549525, 0.444997, 0.707107> }
triangle { <-0.549525, 0.444997, 0.707107>, <-0.525483, 0.473147, 0.707107>, <-0.504447, 0.454206, 0.734323> }
triangle { <-0.525483, 0.473147, 0.707107>, <-0.549525, 0.444997, 0.707107>, <-0.570676, 0.462124, 0.678801> }
triangle { <-0.570676, 0.462124, 0.678801>, <-0.545708, 0.491358, 0.678801>, <-0.525483, 0.473147, 0.707107> }
triangle { <-0.545708, 0.491358, 0.678801>, <-0.570676, 0.462124, 0.678801>, <-0.590946, 0.478539, 0.649448> }
triangle { <-0.590946, 0.478539, 0.649448>, <-0.565092, 0.508811, 0.649448>, <-0.545708, 0.491358, 0.678801> }
triangle { <-0.565092, 0.508811, 0.649448>, <-0.590946, 0.478539, 0.649448>, <-0.610306, 0.494216, 0.619094> }
triangle { <-0.610306, 0.494216, 0.619094>, <-0.583604, 0.525480, 0.619094>, <-0.565092, 0.508811, 0.649448> }
triangle { <-0.583604, 0.525480, 0.619094>, <-0.610306, 0.494216, 0.619094>, <-0.628724, 0.509131, 0.587785> }
triangle { <-0.628724, 0.509131, 0.587785>, <-0.601217, 0.541338, 0.587785>, <-0.583604, 0.525480, 0.619094> }
triangle { <-0.601217, 0.541338, 0.587785>, <-0.628724, 0.509131, 0.587785>, <-0.646173, 0.523261, 0.555570> }
triangle { <-0.646173, 0.523261, 0.555570>, <-0.617902, 0.556362, 0.555570>, <-0.601217, 0.541338, 0.587785> }
triangle { <-0.617902, 0.556362, 0.555570>, <-0.646173, 0.523261, 0.555570>, <-0.662626, 0.536584, 0.522499> }
triangle { <-0.662626, 0.536584, 0.522499>, <-0.633635, 0.570528, 0.522499>, <-0.617902, 0.556362, 0.555570> }
triangle { <-0.633635, 0.570528, 0.522499>, <-0.662626, 0.536584, 0.522499>, <-0.678057, 0.549080, 0.488621> }
triangle { <-0.678057, 0.549080, 0.488621>, <-0.648391, 0.583814, 0.488621>, <-0.633635, 0.570528, 0.522499> }
triangle { <-0.648391, 0.583814, 0.488621>, <-0.678057, 0.549080, 0.488621>, <-0.692442, 0.560729, 0.453990> }
triangle { <-0.692442, 0.560729, 0.453990>, <-0.662147, 0.596200, 0.453990>, <-0.648391, 0.583814, 0.488621> }
triangle { <-0.662147, 0.596200, 0.453990>, <-0.692442, 0.560729, 0.453990>, <-0.705760, 0.571513, 0.418660> }
triangle { <-0.705760, 0.571513, 0.418660>, <-0.674882, 0.607666, 0.418660>, <-0.662147, 0.596200, 0.453990> }
triangle { <-0.674882, 0.607666, 0.418660>, <-0.705760, 0.571513, 0.418660>, <-0.717989, 0.581416, 0.382683> }
triangle { <-0.717989, 0.581416, 0.382683>, <-0.686576, 0.618196, 0.382683>, <-0.674882, 0.607666, 0.418660> }
triangle { <-0.686576, 0.618196, 0.382683>, <-0.717989, 0.581416, 0.382683>, <-0.729112, 0.590423, 0.346117> }
triangle { <-0.729112, 0.590423, 0.346117>, <-0.697212, 0.627773, 0.346117>, <-0.686576, 0.618196, 0.382683> }
triangle { <-0.697212, 0.627773, 0.346117>, <-0.729112, 0.590423, 0.346117>, <-0.739110, 0.598519, 0.309017> }
triangle { <-0.739110, 0.598519, 0.309017>, <-0.706773, 0.636381, 0.309017>, <-0.697212, 0.627773, 0.346117> }
triangle { <-0.706773, 0.636381, 0.309017>, <-0.739110, 0.598519, 0.309017>, <-0.747968, 0.605693, 0.271440> }
triangle { <-0.747968, 0.605693, 0.271440>, <-0.715244, 0.644008, 0.271440>, <-0.706773, 0.636381, 0.309017> }
triangle { <-0.715244, 0.644008, 0.271440>, <-0.747968, 0.605693, 0.271440>, <-0.755673, 0.611932, 0.233445> }
triangle { <-0.755673, 0.611932, 0.233445>, <-0.722612, 0.650642, 0.233445>, <-0.715244, 0.644008, 0.271440> }
triangle { <-0.722612, 0.650642, 0.233445>, <-0.755673, 0.611932, 0.233445>, <-0.762213, 0.617228, 0.195090> }
triangle { <-0.762213, 0.617228, 0.195090>, <-0.728866, 0.656273, 0.195090>, <-0.722612, 0.650642, 0.233445> }
triangle { <-0.728866, 0.656273, 0.195090>, <-0.762213, 0.617228, 0.195090>, <-0.767578, 0.621572, 0.156434> }
triangle { <-0.767578, 0.621572, 0.156434>, <-0.733995, 0.660892, 0.156434>, <-0.728866, 0.656273, 0.195090> }
triangle { <-0.733995, 0.660892, 0.156434>, <-0.767578, 0.621572, 0.156434>, <-0.771759, 0.624958, 0.117537> }
triangle { <-0.771759, 0.624958, 0.117537>, <-0.737994, 0.664492, 0.117537>, <-0.733995, 0.660892, 0.156434> }
triangle { <-0.737994, 0.664492, 0.117537>, <-0.771759, 0.624958, 0.117537>, <-0.774750, 0.627380, 0.078459> }
triangle { <-0.774750, 0.627380, 0.078459>, <-0.740854, 0.667068, 0.078459>, <-0.737994, 0.664492, 0.117537> }
triangle { <-0.740854, 0.667068, 0.078459>, <-0.774750, 0.627380, 0.078459>, <-0.776547, 0.628835, 0.039260> }
triangle { <-0.776547, 0.628835, 0.039260>, <-0.742572, 0.668615, 0.039260>, <-0.740854, 0.667068, 0.078459> }
triangle { <-0.742572, 0.668615, 0.039260>, <-0.776547, 0.628835, 0.039260>, <-0.777146, 0.629320, -0.000000> }
triangle { <-0.777146, 0.629320, -0.000000>, <-0.743145, 0.669131, -0.000000>, <-0.742572, 0.668615, 0.039260> }
triangle { <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <-0.031762, 0.023076, 0.999229> }
triangle { <-0.031762, 0.023076, 0.999229>, <-0.030511, 0.024707, 0.999229>, <0.000000, 0.000000, 1.000000> }
triangle { <-0.030511, 0.024707, 0.999229>, <-0.031762, 0.023076, 0.999229>, <-0.063475, 0.046117, 0.996917> }
triangle { <-0.063475, 0.046117, 0.996917>, <-0.060974, 0.049376, 0.996917>, <-0.030511, 0.024707, 0.999229> }
triangle { <-0.060974, 0.049376, 0.996917>, <-0.063475, 0.046117, 0.996917>, <-0.095090, 0.069087, 0.993068> }
triangle { <-0.095090, 0.069087, 0.993068>, <-0.091344, 0.073969, 0.993068>, <-0.060974, 0.049376, 0.996917> }
triangle { <-0.091344, 0.073969, 0.993068>, <-0.095090, 0.069087, 0.993068>, <-0.126558, 0.091950, 0.987688> }
triangle { <-0.126558, 0.091950, 0.987688>, <-0.121572, 0.098447, 0.987688>, <-0.091344, 0.073969, 0.993068> }
triangle { <-0.121572, 0.098447, 0.987688>, <-0.126558, 0.091950, 0.987688>, <-0.157831, 0.114671, 0.980785> }
triangle { <-0.157831, 0.114671, 0.980785>, <-0.151614, 0.122774, 0.980785>, <-0.121572, 0.098447, 0.987688> }
triangle { <-0.151614, 0.122774, 0.980785>, <-0.157831, 0.114671, 0.980785>, <-0.188861, 0.137216, 0.972370> }
triangle { <-0.188861, 0.137216, 0.972370>, <-0.181421, 0.146912, 0.972370>, <-0.151614, 0.122774, 0.980785> }
triangle { <-0.181421, 0.146912, 0.972370>, <-0.188861, 0.137216, 0.972370>, <-0.219600, 0.159549, 0.962455> }
triangle { <-0.219600, 0.159549, 0.962455>, <-0.210949, 0.170823, 0.962455>, <-0.181421, 0.146912, 0.972370> }
triangle { <-0.210949, 0.170823, 0.962455>, <-0.219600, 0.159549, 0.962455>, <-0.250000, 0.181636, 0.951057> }
triangle { <-0.250000, 0.181636, 0.951057>, <-0.240151, 0.194471, 0.951057>, <-0.210949, 0.170823, 0.962455> }
triangle { <-0.240151, 0.194471, 0.951057>, <-0.250000, 0.181636, 0.951057>, <-0.280015, 0.203443, 0.938191> }
triangle { <-0.280015, 0.203443, 0.938191>, <-0.268983, 0.217819, 0.938191>, <-0.240151, 0.194471, 0.951057> }
triangle { <-0.268983, 0.217819, 0.938191>, <-0.280015, 0.203443, 0.938191>, <-0.309597, 0.224936, 0.923880> }
triangle { <-0.309597, 0.224936, 0.923880>, <-0.297401, 0.240830, 0.923880>, <-0.268983, 0.217819, 0.938191> }
triangle { <-0.297401, 0.240830, 0.923880>, <-0.309597, 0.224936, 0.923880>, <-0.338703, 0.246082, 0.908143> }
triangle { <-0.338703, 0.246082, 0.908143>, <-0.325360, 0.263471, 0.908143>, <-0.297401, 0.240830, 0.923880> }
triangle { <-0.325360, 0.263471, 0.908143>, <-0.338703, 0.246082, 0.908143>, <-0.367286, 0.266849, 0.891007> }
triangle { <-0.367286, 0.266849, 0.891007>, <-0.352817, 0.285705, 0.891007>, <-0.325360, 0.263471, 0.908143> }
triangle { <-0.352817, 0.285705, 0.891007>, <-0.367286, 0.266849, 0.891007>, <-0.395303, 0.287204, 0.872496> }
triangle { <-0.395303, 0.287204, 0.872496>, <-0.379730, 0.307499, 0.872496>, <-0.352817, 0.285705, 0.891007> }
triangle { <-0.379730, 0.307499, 0.872496>, <-0.395303, 0.287204, 0.872496>, <-0.422710, 0.307117, 0.852640> }
triangle { <-0.422710, 0.307117, 0.852640>, <-0.406058, 0.328819, 0.852640>, <-0.379730, 0.307499, 0.872496> }
triangle { <-0.406058, 0.328819, 0.852640>, <-0.422710, 0.307117, 0.852640>, <-0.449466, 0.326556, 0.831470> }
triangle { <-0.449466, 0.326556, 0.831470>, <-0.431759, 0.349632, 0.831470>, <-0.406058, 0.328819, 0.852640> }
triangle { <-0.431759, 0.349632, 0.831470>, <-0.449466, 0.326556, 0.831470>, <-0.475528, 0.345492, 0.809017> }
triangle { <-0.475528, 0.345492, 0.809017>, <-0.456795, 0.369905, 0.809017>, <-0.431759, 0.349632, 0.831470> }
triangle { <-0.456795, 0.369905, 0.809017>, <-0.475528, 0.345492, 0.809017>, <-0.500858, 0.363894, 0.785317> }
triangle { <-0.500858, 0.363894, 0.785317>, <-0.481126, 0.389608, 0.785317>, <-0.456795, 0.369905, 0.809017> }
triangle { <-0.481126, 0.389608, 0.785317>, <-0.500858, 0.363894, 0.785317>, <-0.525415, 0.381736, 0.760406> }
triangle { <-0.525415, 0.381736, 0.760406>, <-0.504716, 0.408711, 0.760406>, <-0.481126, 0.389608, 0.785317> }
triangle { <-0.504716, 0.408711, 0.760406>, <-0.525415, 0.381736, 0.760406>, <-0.549161, 0.398989, 0.734323> }
triangle { <-0.549161, 0.398989, 0.734323>, <-0.527527, 0.427183, 0.734323>, <-0.504716, 0.408711, 0.760406> }
triangle { <-0.527527, 0.427183, 0.734323>, <-0.549161, 0.398989, 0.734323>, <-0.572061, 0.415627, 0.707107> }
triangle { <-0.572061, 0.415627, 0.707107>, <-0.549525, 0.444997, 0.707107>, <-0.527527, 0.427183, 0.734323> }
triangle { <-0.549525, 0.444997, 0.707107>, <-0.572061, 0.415627, 0.707107>, <-0.594079, 0.431624, 0.678801> }
triangle { <-0.594079, 0.431624, 0.678801>, <-0.570676, 0.462124, 0.678801>, <-0.549525, 0.444997, 0.707107> }
triangle { <-0.570676, 0.462124, 0.678801>, <-0.594079, 0.431624, 0.678801>, <-0.615181, 0.446955, 0.649448> }
triangle { <-0.615181, 0.446955, 0.649448>, <-0.590946, 0.478539, 0.649448>, <-0.570676, 0.462124, 0.678801> }
triangle { <-0.590946, 0.478539, 0.649448>, <-0.615181, 0.446955, 0.649448>, <-0.635335, 0.461598, 0.619094> }
triangle { <-0.635335, 0.461598, 0.619094>, <-0.610306, 0.494216, 0.619094>, <-0.590946, 0.478539, 0.649448> }
triangle { <-0.610306, 0.494216, 0.619094>, <-0.635335, 0.461598, 0.619094>, <-0.654508, 0.475528, 0.587785> }
triangle { <-0.654508, 0.475528, 0.587785>, <-0.628724, 0.509131, 0.587785>, <-0.610306, 0.494216, 0.619094> }
triangle { <-0.628724, 0.509131, 0.587785>, <-0.654508, 0.475528, 0.587785>, <-0.672673, 0.488726, 0.555570> }
triangle { <-0.672673, 0.488726, 0.555570>, <-0.646173, 0.523261, 0.555570>, <-0.628724, 0.509131, 0.587785> }
triangle { <-0.646173, 0.523261, 0.555570>, <-0.672673, 0.488726, 0.555570>, <-0.689800, 0.501169, 0.522499> }
triangle { <-0.689800, 0.501169, 0.522499>, <-0.662626, 0.536584, 0.522499>, <-0.646173, 0.523261, 0.555570> }
triangle { <-0.662626, 0.536584, 0.522499>, <-0.689800, 0.501169, 0.522499>, <-0.705864, 0.512840, 0.488621> }
triangle { <-0.705864, 0.512840, 0.488621>, <-0.678057, 0.549080, 0.488621>, <-0.662626, 0.536584, 0.522499> }
triangle { <-0.678057, 0.549080, 0.488621>, <-0.705864, 0.512840, 0.488621>, <-0.720839, 0.523720, 0.453990> }
triangle { <-0.720839, 0.523720, 0.453990>, <-0.692442, 0.560729, 0.453990>, <-0.678057, 0.549080, 0.488621> }
triangle { <-0.692442, 0.560729, 0.453990>, <-0.720839, 0.523720, 0.453990>, <-0.734703, 0.533793, 0.418660> }
triangle { <-0.734703, 0.533793, 0.418660>, <-0.705760, 0.571513, 0.418660>, <-0.692442, 0.560729, 0.453990> }
triangle { <-0.705760, 0.571513, 0.418660>, <-0.734703, 0.533793, 0.418660>, <-0.747434, 0.543043, 0.382683> }
triangle { <-0.747434, 0.543043, 0.382683>, <-0.717989, 0.581416, 0.382683>, <-0.705760, 0.571513, 0.418660> }
triangle { <-0.717989, 0.581416, 0.382683>, <-0.747434, 0.543043, 0.382683>, <-0.759013, 0.551455, 0.346117> }
triangle { <-0.759013, 0.551455, 0.346117>, <-0.729112, 0.590423, 0.346117>, <-0.717989, 0.581416, 0.382683> }
triangle { <-0.729112, 0.590423, 0.346117>, <-0.759013, 0.551455, 0.346117>, <-0.769421, 0.559017, 0.309017> }
triangle { <-0.769421, 0.559017, 0.309017>, <-0.739110, 0.598519, 0.309017>, <-0.729112, 0.590423, 0.346117> }
triangle { <-0.739110, 0.598519, 0.309017>, <-0.769421, 0.559017, 0.309017>, <-0.778643, 0.565717, 0.271440> }
triangle { <-0.778643, 0.565717, 0.271440>, <-0.747968, 0.605693, 0.271440>, <-0.739110, 0.598519, 0.309017> }
triangle { <-0.747968, 0.605693, 0.271440>, <-0.778643, 0.565717, 0.271440>, <-0.786664, 0.571545, 0.233445> }
triangle { <-0.786664, 0.571545, 0.233445>, <-0.755673, 0.611932, 0.233445>, <-0.747968, 0.605693, 0.271440> }
triangle { <-0.755673, 0.611932, 0.233445>, <-0.786664, 0.571545, 0.233445>, <-0.793472, 0.576491, 0.195090> }
triangle { <-0.793472, 0.576491, 0.195090>, <-0.762213, 0.617228, 0.195090>, <-0.755673, 0.611932, 0.233445> }
triangle { <-0.762213, 0.617228, 0.195090>, <-0.793472, 0.576491, 0.195090>, <-0.799057, 0.580549, 0.156434> }
triangle { <-0.799057, 0.580549, 0.156434>, <-0.767578, 0.621572, 0.156434>, <-0.762213, 0.617228, 0.195090> }
triangle { <-0.767578, 0.621572, 0.156434>, <-0.799057, 0.580549, 0.156434>, <-0.803409, 0.583711, 0.117537> }
triangle { <-0.803409, 0.583711, 0.117537>, <-0.771759, 0.624958, 0.117537>, <-0.767578, 0.621572, 0.156434> }
triangle { <-0.771759, 0.624958, 0.117537>, <-0.803409, 0.583711, 0.117537>, <-0.806523, 0.585973, 0.078459> }
triangle { <-0.806523, 0.585973, 0.078459>, <-0.774750, 0.627380, 0.078459>, <-0.771759, 0.624958, 0.117537> }
triangle { <-0.774750, 0.627380, 0.078459>, <-0.806523, 0.585973, 0.078459>, <-0.808393, 0.587332, 0.039260> }
triangle { <-0.808393, 0.587332, 0.039260>, <-0.776547, 0.628835, 0.039260>, <-0.774750, 0.627380, 0.078459> }
triangle { <-0.776547, 0.628835, 0.039260>, <-0.808393, 0.587332, 0.039260>, <-0.809017, 0.587785, -0.000000> }
triangle { <-0.809017, 0.587785, -0.000000>, <-0.777146, 0.629320, -0.000000>, <-0.776547, 0.628835, 0.039260> }
triangle { <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <-0.032926, 0.021382, 0.999229> }
triangle { <-0.032926, 0.021382, 0.999229>, <-0.031762, 0.023076, 0.999229>, <0.000000, 0.000000, 1.000000> }
triangle { <-0.031762, 0.023076, 0.999229>, <-0.032926, 0.021382, 0.999229>, <-0.065801, 0.042732, 0.996917> }
triangle { <-0.065801, 0.042732, 0.996917>, <-0.063475, 0.046117, 0.996917>, <-0.031762, 0.023076, 0.999229> }
triangle { <-0.063475, 0.046117, 0.996917>, <-0.065801, 0.042732, 0.996917>, <-0.098575, 0.064015, 0.993068> }
triangle { <-0.098575, 0.064015, 0.993068>, <-0.095090, 0.069087, 0.993068>, <-0.063475, 0.046117, 0.996917> }
triangle { <-0.095090, 0.069087, 0.993068>, <-0.098575, 0.064015, 0.993068>, <-0.131197, 0.085200, 0.987688> }
triangle { <-0.131197, 0.085200, 0.987688>, <-0.126558, 0.091950, 0.987688>, <-0.095090, 0.069087, 0.993068> }
triangle { <-0.126558, 0.091950, 0.987688>, <-0.131197, 0.085200, 0.987688>, <-0.163617, 0.106254, 0.980785> }
triangle { <-0.163617, 0.106254, 0.980785>, <-0.157831, 0.114671, 0.980785>, <-0.126558, 0.091950, 0.987688> }
triangle { <-0.157831, 0.114671, 0.980785>, <-0.163617, 0.106254, 0.980785>, <-0.195784, 0.127143, 0.972370> }
triangle { <-0.195784, 0.127143, 0.972370>, <-0.188861, 0.137216, 0.972370>, <-0.157831, 0.114671, 0.980785> }
triangle { <-0.188861, 0.137216, 0.972370>, <-0.195784, 0.127143, 0.972370>, <-0.227649, 0.147837, 0.962455> }
triangle { <-0.227649, 0.147837, 0.962455>, <-0.219600, 0.159549, 0.962455>, <-0.188861, 0.137216, 0.972370> }
triangle { <-0.219600, 0.159549, 0.962455>, <-0.227649, 0.147837, 0.962455>, <-0.259163, 0.168303, 0.951057> }
triangle { <-0.259163, 0.168303, 0.951057>, <-0.250000, 0.181636, 0.951057>, <-0.219600, 0.159549, 0.962455> }
triangle { <-0.250000, 0.181636, 0.951057>, <-0.259163, 0.168303, 0.951057>, <-0.290278, 0.188509, 0.938191> }
triangle { <-0.290278, 0.188509, 0.938191>, <-0.280015, 0.203443, 0.938191>, <-0.250000, 0.181636, 0.951057> }
triangle { <-0.280015, 0.203443, 0.938191>, <-0.290278, 0.188509, 0.938191>, <-0.320945, 0.208424, 0.923880> }
triangle { <-0.320945, 0.208424, 0.923880>, <-0.309597, 0.224936, 0.923880>, <-0.280015, 0.203443, 0.938191> }
triangle { <-0.309597, 0.224936, 0.923880>, <-0.320945, 0.208424, 0.923880>, <-0.351118, 0.228018, 0.908143> }
triangle { <-0.351118, 0.228018, 0.908143>, <-0.338703, 0.246082, 0.908143>, <-0.309597, 0.224936, 0.923880> }
triangle { <-0.338703, 0.246082, 0.908143>, <-0.351118, 0.228018, 0.908143>, <-0.380748, 0.247261, 0.891007> }
triangle { <-0.380748, 0.247261, 0.891007>, <-0.367286, 0.266849, 0.891007>, <-0.338703, 0.246082, 0.908143> }
triangle { <-0.367286, 0.266849, 0.891007>, <-0.380748, 0.247261, 0.891007>, <-0.409792, 0.266122, 0.872496> }
triangle { <-0.409792, 0.266122, 0.872496>, <-0.395303, 0.287204, 0.872496>, <-0.367286, 0.266849, 0.891007> }
triangle { <-0.395303, 0.287204, 0.872496>, <-0.409792, 0.266122, 0.872496>, <-0.438204, 0.284573, 0.852640> }
triangle { <-0.438204, 0.284573, 0.852640>, <-0.422710, 0.307117, 0.852640>, <-0.395303, 0.287204, 0.872496> }
triangle { <-0.422710, 0.307117, 0.852640>, <-0.438204, 0.284573, 0.852640>, <-0.465940, 0.302585, 0.831470> }
triangle { <-0.465940, 0.302585, 0.831470>, <-0.449466, 0.326556, 0.831470>, <-0.422710, 0.307117, 0.852640> }
triangle { <-0.449466, 0.326556, 0.831470>, <-0.465940, 0.302585, 0.831470>, <-0.492958, 0.320131, 0.809017> }
triangle { <-0.492958, 0.320131, 0.809017>, <-0.475528, 0.345492, 0.809017>, <-0.449466, 0.326556, 0.831470> }
triangle { <-0.475528, 0.345492, 0.809017>, <-0.492958, 0.320131, 0.809017>, <-0.519216, 0.337183, 0.785317> }
triangle { <-0.519216, 0.337183, 0.785317>, <-0.500858, 0.363894, 0.785317>, <-0.475528, 0.345492, 0.809017> }
triangle { <-0.500858, 0.363894, 0.785317>, <-0.519216, 0.337183, 0.785317>, <-0.544673, 0.353715, 0.760406> }
triangle { <-0.544673, 0.353715, 0.760406>, <-0.525415, 0.381736, 0.760406>, <-0.500858, 0.363894, 0.785317> }
triangle { <-0.525415, 0.381736, 0.760406>, <-0.544673, 0.353715, 0.760406>, <-0.569290, 0.369701, 0.734323> }
triangle { <-0.569290, 0.369701, 0.734323>, <-0.549161, 0.398989, 0.734323>, <-0.525415, 0.381736, 0.760406> }
triangle { <-0.549161, 0.398989, 0.734323>, <-0.569290, 0.369701, 0.734323>, <-0.593030, 0.385118, 0.707107> }
triangle { <-0.593030, 0.385118, 0.707107>, <-0.572061, 0.415627, 0.707107>, <-0.549161, 0.398989, 0.734323> }
triangle { <-0.572061, 0.415627, 0.707107>, <-0.593030, 0.385118, 0.707107>, <-0.615855, 0.399941, 0.678801> }
triangle { <-0.615855, 0.399941, 0.678801>, <-0.594079, 0.431624, 0.678801>, <-0.572061, 0.415627, 0.707107> }
triangle { <-0.594079, 0.431624, 0.678801>, <-0.615855, 0.399941, 0.678801>, <-0.637730, 0.414147, 0.649448> }
triangle { <-0.637730, 0.414147, 0.649448>, <-0.615181, 0.446955, 0.649448>, <-0.594079, 0.431624, 0.678801> }
triangle { <-0.615181, 0.446955, 0.649448>, <-0.637730, 0.414147, 0.649448>, <-0.658622, 0.427714, 0.619094> }
triangle { <-0.658622, 0.427714, 0.619094>, <-0.635335, 0.461598, 0.619094>, <-0.615181, 0.446955, 0.649448> }
triangle { <-0.635335, 0.461598, 0.619094>, <-0.658622, 0.427714, 0.619094>, <-0.678499, 0.440622, 0.587785> }
triangle { <-0.678499, 0.440622, 0.587785>, <-0.654508, 0.475528, 0.587785>, <-0.635335, 0.461598, 0.619094> }
triangle { <-0.654508, 0.475528, 0.587785>, <-0.678499, 0.440622, 0.587785>, <-0.697329, 0.452851, 0.555570> }
triangle { <-0.697329, 0.452851, 0.555570>, <-0.672673, 0.488726, 0.555570>, <-0.654508, 0.475528, 0.587785> }
triangle { <-0.672673, 0.488726, 0.555570>, <-0.697329, 0.452851, 0.555570>, <-0.715084, 0.464381, 0.522499> }
triangle { <-0.715084, 0.464381, 0.522499>, <-0.689800, 0.501169, 0.522499>, <-0.672673, 0.488726, 0.555570> }
triangle { <-0.689800, 0.501169, 0.522499>, <-0.715084, 0.464381, 0.522499>, <-0.731737, 0.475195, 0.488621> }
triangle { <-0.731737, 0.475195, 0.488621>, <-0.705864, 0.512840, 0.488621>, <-0.689800, 0.501169, 0.522499> }
triangle { <-0.705864, 0.512840, 0.488621>, <-0.731737, 0.475195, 0.488621>, <-0.747261, 0.485277, 0.453990> }
triangle { <-0.747261, 0.485277, 0.453990>, <-0.720839, 0.523720, 0.453990>, <-0.705864, 0.512840, 0.488621> }
triangle { <-0.720839, 0.523720, 0.453990>, <-0.747261, 0.485277, 0.453990>, <-0.761633, 0.494610, 0.418660> }
triangle { <-0.761633, 0.494610, 0.418660>, <-0.734703, 0.533793, 0.418660>, <-0.720839, 0.523720, 0.453990> }
triangle { <-0.734703, 0.533793, 0.418660>, <-0.761633, 0.494610, 0.418660>, <-0.774831, 0.503181, 0.382683> }
triangle { <-0.774831, 0.503181, 0.382683>, <-0.747434, 0.543043, 0.382683>, <-0.734703, 0.533793, 0.418660> }
triangle { <-0.747434, 0.543043, 0.382683>, <-0.774831, 0.503181, 0.382683>, <-0.786833, 0.510976, 0.346117> }
triangle { <-0.786833, 0.510976, 0.346117>, <-0.759013, 0.551455, 0.346117>, <-0.747434, 0.543043, 0.382683> }
triangle { <-0.759013, 0.551455, 0.346117>, <-0.786833, 0.510976, 0.346117>, <-0.797623, 0.517983, 0.309017> }
triangle { <-0.797623, 0.517983, 0.309017>, <-0.769421, 0.559017, 0.309017>, <-0.759013, 0.551455, 0.346117> }
triangle { <-0.769421, 0.559017, 0.309017>, <-0.797623, 0.517983, 0.309017>, <-0.807183, 0.524191, 0.271440> }
triangle { <-0.807183, 0.524191, 0.271440>, <-0.778643, 0.565717, 0.271440>, <-0.769421, 0.559017, 0.309017> }
triangle { <-0.778643, 0.565717, 0.271440>, <-0.807183, 0.524191, 0.271440>, <-0.815498, 0.529591, 0.233445> }
triangle { <-0.815498, 0.529591, 0.233445>, <-0.786664, 0.571545, 0.233445>, <-0.778643, 0.565717, 0.271440> }
triangle { <-0.786664, 0.571545, 0.233445>, <-0.815498, 0.529591, 0.233445>, <-0.822556, 0.534174, 0.195090> }
triangle { <-0.822556, 0.534174, 0.195090>, <-0.793472, 0.576491, 0.195090>, <-0.786664, 0.571545, 0.233445> }
triangle { <-0.793472, 0.576491, 0.195090>, <-0.822556, 0.534174, 0.195090>, <-0.828345, 0.537934, 0.156434> }
triangle { <-0.828345, 0.537934, 0.156434>, <-0.799057, 0.580549, 0.156434>, <-0.793472, 0.576491, 0.195090> }
triangle { <-0.799057, 0.580549, 0.156434>, <-0.828345, 0.537934, 0.156434>, <-0.832857, 0.540864, 0.117537> }
triangle { <-0.832857, 0.540864, 0.117537>, <-0.803409, 0.583711, 0.117537>, <-0.799057, 0.580549, 0.156434> }
triangle { <-0.803409, 0.583711, 0.117537>, <-0.832857, 0.540864, 0.117537>, <-0.836085, 0.542960, 0.078459> }
triangle { <-0.836085, 0.542960, 0.078459>, <-0.806523, 0.585973, 0.078459>, <-0.803409, 0.583711, 0.117537> }
triangle { <-0.806523, 0.585973, 0.078459>, <-0.836085, 0.542960, 0.078459>, <-0.838024, 0.544219, 0.039260> }
triangle { <-0.838024, 0.544219, 0.039260>, <-0.808393, 0.587332, 0.039260>, <-0.806523, 0.585973, 0.078459> }
triangle { <-0.808393, 0.587332, 0.039260>, <-0.838024, 0.544219, 0.039260>, <-0.838671, 0.544639, -0.000000> }
triangle { <-0.838671, 0.544639, -0.000000>, <-0.809017, 0.587785, -0.000000>, <-0.808393, 0.587332, 0.039260> }
triangle { <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <-0.034000, 0.019630, 0.999229> }
triangle { <-0.034000, 0.019630, 0.999229>, <-0.032926, 0.021382, 0.999229>, <0.000000, 0.000000, 1.000000> }
triangle { <-0.032926, 0.021382, 0.999229>, <-0.034000, 0.019630, 0.999229>, <-0.067948, 0.039230, 0.996917> }
triangle { <-0.067948, 0.039230, 0.996917>, <-0.065801, 0.042732, 0.996917>, <-0.032926, 0.021382, 0.999229> }
triangle { <-0.065801, 0.042732, 0.996917>, <-0.067948, 0.039230, 0.996917>, <-0.101790, 0.058769, 0.993068> }
triangle { <-0.101790, 0.058769, 0.993068>, <-0.098575, 0.064015, 0.993068>, <-0.065801, 0.042732, 0.996917> }
triangle { <-0.098575, 0.064015, 0.993068>, <-0.101790, 0.058769, 0.993068>, <-0.135476, 0.078217, 0.987688> }
triangle { <-0.135476, 0.078217, 0.987688>, <-0.131197, 0.085200, 0.987688>, <-0.098575, 0.064015, 0.993068> }
triangle { <-0.131197, 0.085200, 0.987688>, <-0.135476, 0.078217, 0.987688>, <-0.168953, 0.097545, 0.980785> }
triangle { <-0.168953, 0.097545, 0.980785>, <-0.163617, 0.106254, 0.980785>, <-0.131197, 0.085200, 0.987688> }
triangle { <-0.163617, 0.106254, 0.980785>, <-0.168953, 0.097545, 0.980785>, <-0.202170, 0.116723, 0.972370> }
triangle { <-0.202170, 0.116723, 0.972370>, <-0.195784, 0.127143, 0.972370>, <-0.163617, 0.106254, 0.980785> }
triangle { <-0.195784, 0.127143, 0.972370>, <-0.202170, 0.116723, 0.972370>, <-0.235074, 0.135720, 0.962455> }
triangle { <-0.235074, 0.135720, 0.962455>, <-0.227649, 0.147837, 0.962455>, <-0.195784, 0.127143, 0.972370> }
triangle { <-0.227649, 0.147837, 0.962455>, <-0.235074, 0.135720, 0.962455>, <-0.267617, 0.154508, 0.951057> }
triangle { <-0.267617, 0.154508, 0.951057>, <-0.259163, 0.168303, 0.951057>, <-0.227649, 0.147837, 0.962455> }
triangle { <-0.259163, 0.168303, 0.951057>, <-0.267617, 0.154508, 0.951057>, <-0.299746, 0.173059, 0.938191> }
triangle { <-0.299746, 0.173059, 0.938191>, <-0.290278, 0.188509, 0.938191>, <-0.259163, 0.168303, 0.951057> }
triangle { <-0.290278, 0.188509, 0.938191>, <-0.299746, 0.173059, 0.938191>, <-0.331414, 0.191342, 0.923880> }
triangle { <-0.331414, 0.191342, 0.923880>, <-0.320945, 0.208424, 0.923880>, <-0.290278, 0.188509, 0.938191> }
triangle { <-0.320945, 0.208424, 0.923880>, <-0.331414, 0.191342, 0.923880>, <-0.362570, 0.209330, 0.908143> }
triangle { <-0.362570, 0.209330, 0.908143>, <-0.351118, 0.228018, 0.908143>, <-0.320945, 0.208424, 0.923880> }
triangle { <-0.351118, 0.228018, 0.908143>, <-0.362570, 0.209330, 0.908143>, <-0.393167, 0.226995, 0.891007> }
triangle { <-0.393167, 0.226995, 0.891007>, <-0.380748, 0.247261, 0.891007>, <-0.351118, 0.228018, 0.908143> }
triangle { <-0.380748, 0.247261, 0.891007>, <-0.393167, 0.226995, 0.891007>, <-0.423158, 0.244311, 0.872496> }
triangle { <-0.423158, 0.244311, 0.872496>, <-0.409792, 0.266122, 0.872496>, <-0.380748, 0.247261, 0.891007> }
triangle { <-0.409792, 0.266122, 0.872496>, <-0.423158, 0.244311, 0.872496>, <-0.452497, 0.261249, 0.852640> }
triangle { <-0.452497, 0.261249, 0.852640>, <-0.438204, 0.284573, 0.852640>, <-0.409792, 0.266122, 0.872496> }
triangle { <-0.438204, 0.284573, 0.852640>, <-0.452497, 0.261249, 0.852640>, <-0.481138, 0.277785, 0.831470> }
triangle { <-0.481138, 0.277785, 0.831470>, <-0.465940, 0.302585, 0.831470>, <-0.438204, 0.284573, 0.852640> }
triangle { <-0.465940, 0.302585, 0.831470>, <-0.481138, 0.277785, 0.831470>, <-0.509037, 0.293893, 0.809017> }
triangle { <-0.509037, 0.293893, 0.809017>, <-0.492958, 0.320131, 0.809017>, <-0.465940, 0.302585, 0.831470> }
triangle { <-0.492958, 0.320131, 0.809017>, <-0.509037, 0.293893, 0.809017>, <-0.536151, 0.309547, 0.785317> }
triangle { <-0.536151, 0.309547, 0.785317>, <-0.519216, 0.337183, 0.785317>, <-0.492958, 0.320131, 0.809017> }
triangle { <-0.519216, 0.337183, 0.785317>, <-0.536151, 0.309547, 0.785317>, <-0.562439, 0.324724, 0.760406> }
triangle { <-0.562439, 0.324724, 0.760406>, <-0.544673, 0.353715, 0.760406>, <-0.519216, 0.337183, 0.785317> }
triangle { <-0.544673, 0.353715, 0.760406>, <-0.562439, 0.324724, 0.760406>, <-0.587859, 0.339400, 0.734323> }
triangle { <-0.587859, 0.339400, 0.734323>, <-0.569290, 0.369701, 0.734323>, <-0.544673, 0.353715, 0.760406> }
triangle { <-0.569290, 0.369701, 0.734323>, <-0.587859, 0.339400, 0.734323>, <-0.612372, 0.353553, 0.707107> }
triangle { <-0.612372, 0.353553, 0.707107>, <-0.593030, 0.385118, 0.707107>, <-0.569290, 0.369701, 0.734323> }
triangle { <-0.593030, 0.385118, 0.707107>, <-0.612372, 0.353553, 0.707107>, <-0.635942, 0.367161, 0.678801> }
triangle { <-0.635942, 0.367161, 0.678801>, <-0.615855, 0.399941, 0.678801>, <-0.593030, 0.385118, 0.707107> }
triangle { <-0.615855, 0.399941, 0.678801>, <-0.635942, 0.367161, 0.678801>, <-0.658531, 0.380203, 0.649448> }
triangle { <-0.658531, 0.380203, 0.649448>, <-0.637730, 0.414147, 0.649448>, <-0.615855, 0.399941, 0.678801> }
triangle { <-0.637730, 0.414147, 0.649448>, <-0.658531, 0.380203, 0.649448>, <-0.680104, 0.392658, 0.619094> }
triangle { <-0.680104, 0.392658, 0.619094>, <-0.658622, 0.427714, 0.619094>, <-0.637730, 0.414147, 0.649448> }
triangle { <-0.658622, 0.427714, 0.619094>, <-0.680104, 0.392658, 0.619094>, <-0.700629, 0.404508, 0.587785> }
triangle { <-0.700629, 0.404508, 0.587785>, <-0.678499, 0.440622, 0.587785>, <-0.658622, 0.427714, 0.619094> }
triangle { <-0.678499, 0.440622, 0.587785>, <-0.700629, 0.404508, 0.587785>, <-0.720074, 0.415735, 0.555570> }
triangle { <-0.720074, 0.415735, 0.555570>, <-0.697329, 0.452851, 0.555570>, <-0.678499, 0.440622, 0.587785> }
triangle { <-0.697329, 0.452851, 0.555570>, <-0.720074, 0.415735, 0.555570>, <-0.738408, 0.426320, 0.522499> }
triangle { <-0.738408, 0.426320, 0.522499>, <-0.715084, 0.464381, 0.522499>, <-0.697329, 0.452851, 0.555570> }
triangle { <-0.715084, 0.464381, 0.522499>, <-0.738408, 0.426320, 0.522499>, <-0.755604, 0.436248, 0.488621> }
triangle { <-0.755604, 0.436248, 0.488621>, <-0.731737, 0.475195, 0.488621>, <-0.715084, 0.464381, 0.522499> }
triangle { <-0.731737, 0.475195, 0.488621>, <-0.755604, 0.436248, 0.488621>, <-0.771634, 0.445503, 0.453990> }
triangle { <-0.771634, 0.445503, 0.453990>, <-0.747261, 0.485277, 0.453990>, <-0.731737, 0.475195, 0.488621> }
triangle { <-0.747261, 0.485277, 0.453990>, <-0.771634, 0.445503, 0.453990>, <-0.786475, 0.454072, 0.418660> }
triangle { <-0.786475, 0.454072, 0.418660>, <-0.761633, 0.494610, 0.418660>, <-0.747261, 0.485277, 0.453990> }
triangle { <-0.761633, 0.494610, 0.418660>, <-0.786475, 0.454072, 0.418660>, <-0.800103, 0.461940, 0.382683> }
triangle { <-0.800103, 0.461940, 0.382683>, <-0.774831, 0.503181, 0.382683>, <-0.761633, 0.494610, 0.418660> }
triangle { <-0.774831, 0.503181, 0.382683>, <-0.800103, 0.461940, 0.382683>, <-0.812498, 0.469096, 0.346117> }
triangle { <-0.812498, 0.469096, 0.346117>, <-0.786833, 0.510976, 0.346117>, <-0.774831, 0.503181, 0.382683> }
triangle { <-0.786833, 0.510976, 0.346117>, <-0.812498, 0.469096, 0.346117>, <-0.823639, 0.475528, 0.309017> }
triangle { <-0.823639, 0.475528, 0.309017>, <-0.797623, 0.517983, 0.309017>, <-0.786833, 0.510976, 0.346117> }
triangle { <-0.797623, 0.517983, 0.309017>, <-0.823639, 0.475528, 0.309017>, <-0.833511, 0.481228, 0.271440> }
triangle { <-0.833511, 0.481228, 0.271440>, <-0.807183, 0.524191, 0.271440>, <-0.797623, 0.517983, 0.309017> }
triangle { <-0.807183, 0.524191, 0.271440>, <-0.833511, 0.481228, 0.271440>, <-0.842097, 0.486185, 0.233445> }
triangle { <-0.842097, 0.486185, 0.233445>, <-0.815498, 0.529591, 0.233445>, <-0.807183, 0.524191, 0.271440> }
triangle { <-0.815498, 0.529591, 0.233445>, <-0.842097, 0.486185, 0.233445>, <-0.849385, 0.490393, 0.195090> }
triangle { <-0.849385, 0.490393, 0.195090>, <-0.822556, 0.534174, 0.195090>, <-0.815498, 0.529591, 0.233445> }
triangle { <-0.822556, 0.534174, 0.195090>, <-0.849385, 0.490393, 0.195090>, <-0.855363, 0.493844, 0.156434> }
triangle { <-0.855363, 0.493844, 0.156434>, <-0.828345, 0.537934, 0.156434>, <-0.822556, 0.534174, 0.195090> }
triangle { <-0.828345, 0.537934, 0.156434>, <-0.855363, 0.493844, 0.156434>, <-0.860023, 0.496534, 0.117537> }
triangle { <-0.860023, 0.496534, 0.117537>, <-0.832857, 0.540864, 0.117537>, <-0.828345, 0.537934, 0.156434> }
triangle { <-0.832857, 0.540864, 0.117537>, <-0.860023, 0.496534, 0.117537>, <-0.863356, 0.498459, 0.078459> }
triangle { <-0.863356, 0.498459, 0.078459>, <-0.836085, 0.542960, 0.078459>, <-0.832857, 0.540864, 0.117537> }
triangle { <-0.836085, 0.542960, 0.078459>, <-0.863356, 0.498459, 0.078459>, <-0.865358, 0.499615, 0.039260> }
triangle { <-0.865358, 0.499615, 0.039260>, <-0.838024, 0.544219, 0.039260>, <-0.836085, 0.542960, 0.078459> }
triangle { <-0.838024, 0.544219, 0.039260>, <-0.865358, 0.499615, 0.039260>, <-0.866025, 0.500000, -0.000000> }
triangle { <-0.866025, 0.500000, -0.000000>, <-0.838671, 0.544639, -0.000000>, <-0.838024, 0.544219, 0.039260> }
triangle { <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <-0.034981, 0.017824, 0.999229> }
triangle { <-0.034981, 0.017824, 0.999229>, <-0.034000, 0.019630, 0.999229>, <0.000000, 0.000000, 1.000000> }
triangle { <-0.034000, 0.019630, 0.999229>, <-0.034981, 0.017824, 0.999229>, <-0.069908, 0.035620, 0.996917> }
triangle { <-0.069908, 0.035620, 0.996917>, <-0.067948, 0.039230, 0.996917>, <-0.034000, 0.019630, 0.999229> }
triangle { <-0.067948, 0.039230, 0.996917>, <-0.069908, 0.035620, 0.996917>, <-0.104727, 0.053361, 0.993068> }
triangle { <-0.104727, 0.053361, 0.993068>, <-0.101790, 0.058769, 0.993068>, <-0.067948, 0.039230, 0.996917> }
triangle { <-0.101790, 0.058769, 0.993068>, <-0.104727, 0.053361, 0.993068>, <-0.139384, 0.071020, 0.987688> }
triangle { <-0.139384, 0.071020, 0.987688>, <-0.135476, 0.078217, 0.987688>, <-0.101790, 0.058769, 0.993068> }
triangle { <-0.135476, 0.078217, 0.987688>, <-0.139384, 0.071020, 0.987688>, <-0.173827, 0.088569, 0.980785> }
triangle { <-0.173827, 0.088569, 0.980785>, <-0.168953, 0.097545, 0.980785>, <-0.135476, 0.078217, 0.987688> }
triangle { <-0.168953, 0.097545, 0.980785>, <-0.173827, 0.088569, 0.980785>, <-0.208001, 0.105982, 0.972370> }
triangle { <-0.208001, 0.105982, 0.972370>, <-0.202170, 0.116723, 0.972370>, <-0.168953, 0.097545, 0.980785> }
triangle { <-0.202170, 0.116723, 0.972370>, <-0.208001, 0.105982, 0.972370>, <-0.241855, 0.123231, 0.962455> }
triangle { <-0.241855, 0.123231, 0.962455>, <-0.235074, 0.135720, 0.962455>, <-0.202170, 0.116723, 0.972370> }
triangle { <-0.235074, 0.135720, 0.962455>, <-0.241855, 0.123231, 0.962455>, <-0.275336, 0.140291, 0.951057> }
triangle { <-0.275336, 0.140291, 0.951057>, <-0.267617, 0.154508, 0.951057>, <-0.235074, 0.135720, 0.962455> }
triangle { <-0.267617, 0.154508, 0.951057>, <-0.275336, 0.140291, 0.951057>, <-0.308393, 0.157134, 0.938191> }
triangle { <-0.308393, 0.157134, 0.938191>, <-0.299746, 0.173059, 0.938191>, <-0.267617, 0.154508, 0.951057> }
triangle { <-0.299746, 0.173059, 0.938191>, <-0.308393, 0.157134, 0.938191>, <-0.340973, 0.173735, 0.923880> }
triangle { <-0.340973, 0.173735, 0.923880>, <-0.331414, 0.191342, 0.923880>, <-0.299746, 0.173059, 0.938191> }
triangle { <-0.331414, 0.191342, 0.923880>, <-0.340973, 0.173735, 0.923880>, <-0.373029, 0.190068, 0.908143> }
triangle { <-0.373029, 0.190068, 0.908143>, <-0.362570, 0.209330, 0.908143>, <-0.331414, 0.191342, 0.923880> }
triangle { <-0.362570, 0.209330, 0.908143>, <-0.373029, 0.190068, 0.908143>, <-0.404508, 0.206107, 0.891007> }
triangle { <-0.404508, 0.206107, 0.891007>, <-0.393167, 0.226995, 0.891007>, <-0.362570, 0.209330, 0.908143> }
triangle { <-0.393167, 0.226995, 0.891007>, <-0.404508, 0.206107, 0.891007>, <-0.435365, 0.221829, 0.872496> }
triangle { <-0.435365, 0.221829, 0.872496>, <-0.423158, 0.244311, 0.872496>, <-0.393167, 0.226995, 0.891007> }
triangle { <-0.423158, 0.244311, 0.872496>, <-0.435365, 0.221829, 0.872496>, <-0.465550, 0.237209, 0.852640> }
triangle { <-0.465550, 0.237209, 0.852640>, <-0.452497, 0.261249, 0.852640>, <-0.423158, 0.244311, 0.872496> }
triangle { <-0.452497, 0.261249, 0.852640>, <-0.465550, 0.237209, 0.852640>, <-0.495017, 0.252224, 0.831470> }
triangle { <-0.495017, 0.252224, 0.831470>, <-0.481138, 0.277785, 0.831470>, <-0.452497, 0.261249, 0.852640> }
triangle { <-0.481138, 0.277785, 0.831470>, <-0.495017, 0.252224, 0.831470>, <-0.523720, 0.266849, 0.809017> }
triangle { <-0.523720, 0.266849, 0.809017>, <-0.509037, 0.293893, 0.809017>, <-0.481138, 0.277785, 0.831470> }
triangle { <-0.509037, 0.293893, 0.809017>, <-0.523720, 0.266849, 0.809017>, <-0.551617, 0.281063, 0.785317> }
triangle { <-0.551617, 0.281063, 0.785317>, <-0.536151, 0.309547, 0.785317>, <-0.509037, 0.293893, 0.809017> }
triangle { <-0.536151, 0.309547, 0.785317>, <-0.551617, 0.281063, 0.785317>, <-0.578662, 0.294843, 0.760406> }
triangle { <-0.578662, 0.294843, 0.760406>, <-0.562439, 0.324724, 0.760406>, <-0.536151, 0.309547, 0.785317> }
triangle { <-0.562439, 0.324724, 0.760406>, <-0.578662, 0.294843, 0.760406>, <-0.604816, 0.308169, 0.734323> }
triangle { <-0.604816, 0.308169, 0.734323>, <-0.587859, 0.339400, 0.734323>, <-0.562439, 0.324724, 0.760406> }
triangle { <-0.587859, 0.339400, 0.734323>, <-0.604816, 0.308169, 0.734323>, <-0.630037, 0.321020, 0.707107> }
triangle { <-0.630037, 0.321020, 0.707107>, <-0.612372, 0.353553, 0.707107>, <-0.587859, 0.339400, 0.734323> }
triangle { <-0.612372, 0.353553, 0.707107>, <-0.630037, 0.321020, 0.707107>, <-0.654286, 0.333375, 0.678801> }
triangle { <-0.654286, 0.333375, 0.678801>, <-0.635942, 0.367161, 0.678801>, <-0.612372, 0.353553, 0.707107> }
triangle { <-0.635942, 0.367161, 0.678801>, <-0.654286, 0.333375, 0.678801>, <-0.677527, 0.345217, 0.649448> }
triangle { <-0.677527, 0.345217, 0.649448>, <-0.658531, 0.380203, 0.649448>, <-0.635942, 0.367161, 0.678801> }
triangle { <-0.658531, 0.380203, 0.649448>, <-0.677527, 0.345217, 0.649448>, <-0.699723, 0.356526, 0.619094> }
triangle { <-0.699723, 0.356526, 0.619094>, <-0.680104, 0.392658, 0.619094>, <-0.658531, 0.380203, 0.649448> }
triangle { <-0.680104, 0.392658, 0.619094>, <-0.699723, 0.356526, 0.619094>, <-0.720839, 0.367286, 0.587785> }
triangle { <-0.720839, 0.367286, 0.587785>, <-0.700629, 0.404508, 0.587785>, <-0.680104, 0.392658, 0.619094> }
triangle { <-0.700629, 0.404508, 0.587785>, <-0.720839, 0.367286, 0.587785>, <-0.740845, 0.377479, 0.555570> }
triangle { <-0.740845, 0.377479, 0.555570>, <-0.720074, 0.415735, 0.555570>, <-0.700629, 0.404508, 0.587785> }
triangle { <-0.720074, 0.415735, 0.555570>, <-0.740845, 0.377479, 0.555570>, <-0.759708, 0.387091, 0.522499> }
triangle { <-0.759708, 0.387091, 0.522499>, <-0.738408, 0.426320, 0.522499>, <-0.720074, 0.415735, 0.555570> }
triangle { <-0.738408, 0.426320, 0.522499>, <-0.759708, 0.387091, 0.522499>, <-0.777400, 0.396105, 0.488621> }
triangle { <-0.777400, 0.396105, 0.488621>, <-0.755604, 0.436248, 0.488621>, <-0.738408, 0.426320, 0.522499> }
triangle { <-0.755604, 0.436248, 0.488621>, <-0.777400, 0.396105, 0.488621>, <-0.793893, 0.404508, 0.453990> }
triangle { <-0.793893, 0.404508, 0.453990>, <-0.771634, 0.445503, 0.453990>, <-0.755604, 0.436248, 0.488621> }
triangle { <-0.771634, 0.445503, 0.453990>, <-0.793893, 0.404508, 0.453990>, <-0.809161, 0.412288, 0.418660> }
triangle { <-0.809161, 0.412288, 0.418660>, <-0.786475, 0.454072, 0.418660>, <-0.771634, 0.445503, 0.453990> }
triangle { <-0.786475, 0.454072, 0.418660>, <-0.809161, 0.412288, 0.418660>, <-0.823183, 0.419433, 0.382683> }
triangle { <-0.823183, 0.419433, 0.382683>, <-0.800103, 0.461940, 0.382683>, <-0.786475, 0.454072, 0.418660> }
triangle { <-0.800103, 0.461940, 0.382683>, <-0.823183, 0.419433, 0.382683>, <-0.835935, 0.425930, 0.346117> }
triangle { <-0.835935, 0.425930, 0.346117>, <-0.812498, 0.469096, 0.346117>, <-0.800103, 0.461940, 0.382683> }
triangle { <-0.812498, 0.469096, 0.346117>, <-0.835935, 0.425930, 0.346117>, <-0.847398, 0.431771, 0.309017> }
triangle { <-0.847398, 0.431771, 0.309017>, <-0.823639, 0.475528, 0.309017>, <-0.812498, 0.469096, 0.346117> }
triangle { <-0.823639, 0.475528, 0.309017>, <-0.847398, 0.431771, 0.309017>, <-0.857554, 0.436946, 0.271440> }
triangle { <-0.857554, 0.436946, 0.271440>, <-0.833511, 0.481228, 0.271440>, <-0.823639, 0.475528, 0.309017> }
triangle { <-0.833511, 0.481228, 0.271440>, <-0.857554, 0.436946, 0.271440>, <-0.866388, 0.441447, 0.233445> }
triangle { <-0.866388, 0.441447, 0.233445>, <-0.842097, 0.486185, 0.233445>, <-0.833511, 0.481228, 0.271440> }
triangle { <-0.842097, 0.486185, 0.233445>, <-0.866388, 0.441447, 0.233445>, <-0.873886, 0.445267, 0.195090> }
triangle { <-0.873886, 0.445267, 0.195090>, <-0.849385, 0.490393, 0.195090>, <-0.842097, 0.486185, 0.233445> }
triangle { <-0.849385, 0.490393, 0.195090>, <-0.873886, 0.445267, 0.195090>, <-0.880037, 0.448401, 0.156434> }
triangle { <-0.880037, 0.448401, 0.156434>, <-0.855363, 0.493844, 0.156434>, <-0.849385, 0.490393, 0.195090> }
triangle { <-0.855363, 0.493844, 0.156434>, <-0.880037, 0.448401, 0.156434>, <-0.884830, 0.450844, 0.117537> }
triangle { <-0.884830, 0.450844, 0.117537>, <-0.860023, 0.496534, 0.117537>, <-0.855363, 0.493844, 0.156434> }
triangle { <-0.860023, 0.496534, 0.117537>, <-0.884830, 0.450844, 0.117537>, <-0.888260, 0.452591, 0.078459> }
triangle { <-0.888260, 0.452591, 0.078459>, <-0.863356, 0.498459, 0.078459>, <-0.860023, 0.496534, 0.117537> }
triangle { <-0.863356, 0.498459, 0.078459>, <-0.888260, 0.452591, 0.078459>, <-0.890320, 0.453640, 0.039260> }
triangle { <-0.890320, 0.453640, 0.039260>, <-0.865358, 0.499615, 0.039260>, <-0.863356, 0.498459, 0.078459> }
triangle { <-0.865358, 0.499615, 0.039260>, <-0.890320, 0.453640, 0.039260>, <-0.891007, 0.453990, -0.000000> }
triangle { <-0.891007, 0.453990, -0.000000>, <-0.866025, 0.500000, -0.000000>, <-0.865358, 0.499615, 0.039260> }
triangle { <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <-0.035866, 0.015968, 0.999229> }
triangle { <-0.035866, 0.015968, 0.999229>, <-0.034981, 0.017824, 0.999229>, <0.000000, 0.000000, 1.000000> }
triangle { <-0.034981, 0.017824, 0.999229>, <-0.035866, 0.015968, 0.999229>, <-0.071676, 0.031912, 0.996917> }
triangle { <-0.071676, 0.031912, 0.996917>, <-0.069908, 0.035620, 0.996917>, <-0.034981, 0.017824, 0.999229> }
triangle { <-0.069908, 0.035620, 0.996917>, <-0.071676, 0.031912, 0.996917>, <-0.107376, 0.047807, 0.993068> }
triangle { <-0.107376, 0.047807, 0.993068>, <-0.104727, 0.053361, 0.993068>, <-0.069908, 0.035620, 0.996917> }
triangle { <-0.104727, 0.053361, 0.993068>, <-0.107376, 0.047807, 0.993068>, <-0.142910, 0.063628, 0.987688> }
triangle { <-0.142910, 0.063628, 0.987688>, <-0.139384, 0.071020, 0.987688>, <-0.104727, 0.053361, 0.993068> }
triangle { <-0.139384, 0.071020, 0.987688>, <-0.142910, 0.063628, 0.987688>, <-0.178224, 0.079350, 0.980785> }
triangle { <-0.178224, 0.079350, 0.980785>, <-0.173827, 0.088569, 0.980785>, <-0.139384, 0.071020, 0.987688> }
triangle { <-0.173827, 0.088569, 0.980785>, <-0.178224, 0.079350, 0.980785>, <-0.213263, 0.094951, 0.972370> }
triangle { <-0.213263, 0.094951, 0.972370>, <-0.208001, 0.105982, 0.972370>, <-0.173827, 0.088569, 0.980785> }
triangle { <-0.208001, 0.105982, 0.972370>, <-0.213263, 0.094951, 0.972370>, <-0.247973, 0.110405, 0.962455> }
triangle { <-0.247973, 0.110405, 0.962455>, <-0.241855, 0.123231, 0.962455>, <-0.208001, 0.105982, 0.972370> }
triangle { <-0.241855, 0.123231, 0.962455>, <-0.247973, 0.110405, 0.962455>, <-0.282301, 0.125689, 0.951057> }
triangle { <-0.282301, 0.125689, 0.951057>, <-0.275336, 0.140291, 0.951057>, <-0.241855, 0.123231, 0.962455> }
triangle { <-0.275336, 0.140291, 0.951057>, <-0.282301, 0.125689, 0.951057>, <-0.316194, 0.140778, 0.938191> }
triangle { <-0.316194, 0.140778, 0.938191>, <-0.308393, 0.157134, 0.938191>, <-0.275336, 0.140291, 0.951057> }
triangle { <-0.308393, 0.157134, 0.938191>, <-0.316194, 0.140778, 0.938191>, <-0.349599, 0.155651, 0.923880> }
triangle { <-0.349599, 0.155651, 0.923880>, <-0.340973, 0.173735, 0.923880>, <-0.308393, 0.157134, 0.938191> }
triangle { <-0.340973, 0.173735, 0.923880>, <-0.349599, 0.155651, 0.923880>, <-0.382465, 0.170284, 0.908143> }
triangle { <-0.382465, 0.170284, 0.908143>, <-0.373029, 0.190068, 0.908143>, <-0.340973, 0.173735, 0.923880> }
triangle { <-0.373029, 0.190068, 0.908143>, <-0.382465, 0.170284, 0.908143>, <-0.414741, 0.184655, 0.891007> }
triangle { <-0.414741, 0.184655, 0.891007>, <-0.404508, 0.206107, 0.891007>, <-0.373029, 0.190068, 0.908143> }
triangle { <-0.404508, 0.206107, 0.891007>, <-0.414741, 0.184655, 0.891007>, <-0.446378, 0.198740, 0.872496> }
triangle { <-0.446378, 0.198740, 0.872496>, <-0.435365, 0.221829, 0.872496>, <-0.404508, 0.206107, 0.891007> }
triangle { <-0.435365, 0.221829, 0.872496>, <-0.446378, 0.198740, 0.872496>, <-0.477326, 0.212519, 0.852640> }
triangle { <-0.477326, 0.212519, 0.852640>, <-0.465550, 0.237209, 0.852640>, <-0.435365, 0.221829, 0.872496> }
triangle { <-0.465550, 0.237209, 0.852640>, <-0.477326, 0.212519, 0.852640>, <-0.507539, 0.225971, 0.831470> }
triangle { <-0.507539, 0.225971, 0.831470>, <-0.495017, 0.252224, 0.831470>, <-0.465550, 0.237209, 0.852640> }
triangle { <-0.495017, 0.252224, 0.831470>, <-0.507539, 0.225971, 0.831470>, <-0.536969, 0.239074, 0.809017> }
triangle { <-0.536969, 0.239074, 0.809017>, <-0.523720, 0.266849, 0.809017>, <-0.495017, 0.252224, 0.831470> }
triangle { <-0.523720, 0.266849, 0.809017>, <-0.536969, 0.239074, 0.809017>, <-0.565570, 0.251808, 0.785317> }
triangle { <-0.565570, 0.251808, 0.785317>, <-0.551617, 0.281063, 0.785317>, <-0.523720, 0.266849, 0.809017> }
triangle { <-0.551617, 0.281063, 0.785317>, <-0.565570, 0.251808, 0.785317>, <-0.593300, 0.264154, 0.760406> }
triangle { <-0.593300, 0.264154, 0.760406>, <-0.578662, 0.294843, 0.760406>, <-0.551617, 0.281063, 0.785317> }
triangle { <-0.578662, 0.294843, 0.760406>, <-0.593300, 0.264154, 0.760406>, <-0.620115, 0.276093, 0.734323> }
triangle { <-0.620115, 0.276093, 0.734323>, <-0.604816, 0.308169, 0.734323>, <-0.578662, 0.294843, 0.760406> }
triangle { <-0.604816, 0.308169, 0.734323>, <-0.620115, 0.276093, 0.734323>, <-0.645974, 0.287606, 0.707107> }
triangle { <-0.645974, 0.287606, 0.707107>, <-0.630037, 0.321020, 0.707107>, <-0.604816, 0.308169, 0.734323> }
triangle { <-0.630037, 0.321020, 0.707107>, <-0.645974, 0.287606, 0.707107>, <-0.670837, 0.298676, 0.678801> }
triangle { <-0.670837, 0.298676, 0.678801>, <-0.654286, 0.333375, 0.678801>, <-0.630037, 0.321020, 0.707107> }
triangle { <-0.654286, 0.333375, 0.678801>, <-0.670837, 0.298676, 0.678801>, <-0.694665, 0.309285, 0.649448> }
triangle { <-0.694665, 0.309285, 0.649448>, <-0.677527, 0.345217, 0.649448>, <-0.654286, 0.333375, 0.678801> }
triangle { <-0.677527, 0.345217, 0.649448>, <-0.694665, 0.309285, 0.649448>, <-0.717423, 0.319417, 0.619094> }
triangle { <-0.717423, 0.319417, 0.619094>, <-0.699723, 0.356526, 0.619094>, <-0.677527, 0.345217, 0.649448> }
triangle { <-0.699723, 0.356526, 0.619094>, <-0.717423, 0.319417, 0.619094>, <-0.739074, 0.329057, 0.587785> }
triangle { <-0.739074, 0.329057, 0.587785>, <-0.720839, 0.367286, 0.587785>, <-0.699723, 0.356526, 0.619094> }
triangle { <-0.720839, 0.367286, 0.587785>, <-0.739074, 0.329057, 0.587785>, <-0.759585, 0.338189, 0.555570> }
triangle { <-0.759585, 0.338189, 0.555570>, <-0.740845, 0.377479, 0.555570>, <-0.720839, 0.367286, 0.587785> }
triangle { <-0.740845, 0.377479, 0.555570>, <-0.759585, 0.338189, 0.555570>, <-0.778926, 0.346800, 0.522499> }
triangle { <-0.778926, 0.346800, 0.522499>, <-0.759708, 0.387091, 0.522499>, <-0.740845, 0.377479, 0.555570> }
triangle { <-0.759708, 0.387091, 0.522499>, <-0.778926, 0.346800, 0.522499>, <-0.797065, 0.354876, 0.488621> }
triangle { <-0.797065, 0.354876, 0.488621>, <-0.777400, 0.396105, 0.488621>, <-0.759708, 0.387091, 0.522499> }
triangle { <-0.777400, 0.396105, 0.488621>, <-0.797065, 0.354876, 0.488621>, <-0.813975, 0.362405, 0.453990> }
triangle { <-0.813975, 0.362405, 0.453990>, <-0.793893, 0.404508, 0.453990>, <-0.777400, 0.396105, 0.488621> }
triangle { <-0.793893, 0.404508, 0.453990>, <-0.813975, 0.362405, 0.453990>, <-0.829630, 0.369375, 0.418660> }
triangle { <-0.829630, 0.369375, 0.418660>, <-0.809161, 0.412288, 0.418660>, <-0.793893, 0.404508, 0.453990> }
triangle { <-0.809161, 0.412288, 0.418660>, <-0.829630, 0.369375, 0.418660>, <-0.844006, 0.375776, 0.382683> }
triangle { <-0.844006, 0.375776, 0.382683>, <-0.823183, 0.419433, 0.382683>, <-0.809161, 0.412288, 0.418660> }
triangle { <-0.823183, 0.419433, 0.382683>, <-0.844006, 0.375776, 0.382683>, <-0.857080, 0.381597, 0.346117> }
triangle { <-0.857080, 0.381597, 0.346117>, <-0.835935, 0.425930, 0.346117>, <-0.823183, 0.419433, 0.382683> }
triangle { <-0.835935, 0.425930, 0.346117>, <-0.857080, 0.381597, 0.346117>, <-0.868833, 0.386830, 0.309017> }
triangle { <-0.868833, 0.386830, 0.309017>, <-0.847398, 0.431771, 0.309017>, <-0.835935, 0.425930, 0.346117> }
triangle { <-0.847398, 0.431771, 0.309017>, <-0.868833, 0.386830, 0.309017>, <-0.879247, 0.391466, 0.271440> }
triangle { <-0.879247, 0.391466, 0.271440>, <-0.857554, 0.436946, 0.271440>, <-0.847398, 0.431771, 0.309017> }
triangle { <-0.857554, 0.436946, 0.271440>, <-0.879247, 0.391466, 0.271440>, <-0.888304, 0.395498, 0.233445> }
triangle { <-0.888304, 0.395498, 0.233445>, <-0.866388, 0.441447, 0.233445>, <-0.857554, 0.436946, 0.271440> }
triangle { <-0.866388, 0.441447, 0.233445>, <-0.888304, 0.395498, 0.233445>, <-0.895992, 0.398921, 0.195090> }
triangle { <-0.895992, 0.398921, 0.195090>, <-0.873886, 0.445267, 0.195090>, <-0.866388, 0.441447, 0.233445> }
triangle { <-0.873886, 0.445267, 0.195090>, <-0.895992, 0.398921, 0.195090>, <-0.902298, 0.401729, 0.156434> }
triangle { <-0.902298, 0.401729, 0.156434>, <-0.880037, 0.448401, 0.156434>, <-0.873886, 0.445267, 0.195090> }
triangle { <-0.880037, 0.448401, 0.156434>, <-0.902298, 0.401729, 0.156434>, <-0.907213, 0.403917, 0.117537> }
triangle { <-0.907213, 0.403917, 0.117537>, <-0.884830, 0.450844, 0.117537>, <-0.880037, 0.448401, 0.156434> }
triangle { <-0.884830, 0.450844, 0.117537>, <-0.907213, 0.403917, 0.117537>, <-0.910729, 0.405483, 0.078459> }
triangle { <-0.910729, 0.405483, 0.078459>, <-0.888260, 0.452591, 0.078459>, <-0.884830, 0.450844, 0.117537> }
triangle { <-0.888260, 0.452591, 0.078459>, <-0.910729, 0.405483, 0.078459>, <-0.912841, 0.406423, 0.039260> }
triangle { <-0.912841, 0.406423, 0.039260>, <-0.890320, 0.453640, 0.039260>, <-0.888260, 0.452591, 0.078459> }
triangle { <-0.890320, 0.453640, 0.039260>, <-0.912841, 0.406423, 0.039260>, <-0.913545, 0.406737, -0.000000> }
triangle { <-0.913545, 0.406737, -0.000000>, <-0.891007, 0.453990, -0.000000>, <-0.890320, 0.453640, 0.039260> }
triangle { <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <-0.036652, 0.014069, 0.999229> }
triangle { <-0.036652, 0.014069, 0.999229>, <-0.035866, 0.015968, 0.999229>, <0.000000, 0.000000, 1.000000> }
triangle { <-0.035866, 0.015968, 0.999229>, <-0.036652, 0.014069, 0.999229>, <-0.073248, 0.028117, 0.996917> }
triangle { <-0.073248, 0.028117, 0.996917>, <-0.071676, 0.031912, 0.996917>, <-0.035866, 0.015968, 0.999229> }
triangle { <-0.071676, 0.031912, 0.996917>, <-0.073248, 0.028117, 0.996917>, <-0.109731, 0.042122, 0.993068> }
triangle { <-0.109731, 0.042122, 0.993068>, <-0.107376, 0.047807, 0.993068>, <-0.071676, 0.031912, 0.996917> }
triangle { <-0.107376, 0.047807, 0.993068>, <-0.109731, 0.042122, 0.993068>, <-0.146044, 0.056061, 0.987688> }
triangle { <-0.146044, 0.056061, 0.987688>, <-0.142910, 0.063628, 0.987688>, <-0.107376, 0.047807, 0.993068> }
triangle { <-0.142910, 0.063628, 0.987688>, <-0.146044, 0.056061, 0.987688>, <-0.182133, 0.069914, 0.980785> }
triangle { <-0.182133, 0.069914, 0.980785>, <-0.178224, 0.079350, 0.980785>, <-0.142910, 0.063628, 0.987688> }
triangle { <-0.178224, 0.079350, 0.980785>, <-0.182133, 0.069914, 0.980785>, <-0.217940, 0.083659, 0.972370> }
triangle { <-0.217940, 0.083659, 0.972370>, <-0.213263, 0.094951, 0.972370>, <-0.178224, 0.079350, 0.980785> }
triangle { <-0.213263, 0.094951, 0.972370>, <-0.217940, 0.083659, 0.972370>, <-0.253411, 0.097276, 0.962455> }
triangle { <-0.253411, 0.097276, 0.962455>, <-0.247973, 0.110405, 0.962455>, <-0.213263, 0.094951, 0.972370> }
triangle { <-0.247973, 0.110405, 0.962455>, <-0.253411, 0.097276, 0.962455>, <-0.288492, 0.110742, 0.951057> }
triangle { <-0.288492, 0.110742, 0.951057>, <-0.282301, 0.125689, 0.951057>, <-0.247973, 0.110405, 0.962455> }
triangle { <-0.282301, 0.125689, 0.951057>, <-0.288492, 0.110742, 0.951057>, <-0.323128, 0.124037, 0.938191> }
triangle { <-0.323128, 0.124037, 0.938191>, <-0.316194, 0.140778, 0.938191>, <-0.282301, 0.125689, 0.951057> }
triangle { <-0.316194, 0.140778, 0.938191>, <-0.323128, 0.124037, 0.938191>, <-0.357266, 0.137141, 0.923880> }
triangle { <-0.357266, 0.137141, 0.923880>, <-0.349599, 0.155651, 0.923880>, <-0.316194, 0.140778, 0.938191> }
triangle { <-0.349599, 0.155651, 0.923880>, <-0.357266, 0.137141, 0.923880>, <-0.390853, 0.150034, 0.908143> }
triangle { <-0.390853, 0.150034, 0.908143>, <-0.382465, 0.170284, 0.908143>, <-0.349599, 0.155651, 0.923880> }
triangle { <-0.382465, 0.170284, 0.908143>, <-0.390853, 0.150034, 0.908143>, <-0.423837, 0.162696, 0.891007> }
triangle { <-0.423837, 0.162696, 0.891007>, <-0.414741, 0.184655, 0.891007>, <-0.382465, 0.170284, 0.908143> }
triangle { <-0.414741, 0.184655, 0.891007>, <-0.423837, 0.162696, 0.891007>, <-0.456167, 0.175106, 0.872496> }
triangle { <-0.456167, 0.175106, 0.872496>, <-0.446378, 0.198740, 0.872496>, <-0.414741, 0.184655, 0.891007> }
triangle { <-0.446378, 0.198740, 0.872496>, <-0.456167, 0.175106, 0.872496>, <-0.487794, 0.187247, 0.852640> }
triangle { <-0.487794, 0.187247, 0.852640>, <-0.477326, 0.212519, 0.852640>, <-0.446378, 0.198740, 0.872496> }
triangle { <-0.477326, 0.212519, 0.852640>, <-0.487794, 0.187247, 0.852640>, <-0.518669, 0.199099, 0.831470> }
triangle { <-0.518669, 0.199099, 0.831470>, <-0.507539, 0.225971, 0.831470>, <-0.477326, 0.212519, 0.852640> }
triangle { <-0.507539, 0.225971, 0.831470>, <-0.518669, 0.199099, 0.831470>, <-0.548745, 0.210643, 0.809017> }
triangle { <-0.548745, 0.210643, 0.809017>, <-0.536969, 0.239074, 0.809017>, <-0.507539, 0.225971, 0.831470> }
triangle { <-0.536969, 0.239074, 0.809017>, <-0.548745, 0.210643, 0.809017>, <-0.577974, 0.221863, 0.785317> }
triangle { <-0.577974, 0.221863, 0.785317>, <-0.565570, 0.251808, 0.785317>, <-0.536969, 0.239074, 0.809017> }
triangle { <-0.565570, 0.251808, 0.785317>, <-0.577974, 0.221863, 0.785317>, <-0.606312, 0.232741, 0.760406> }
triangle { <-0.606312, 0.232741, 0.760406>, <-0.593300, 0.264154, 0.760406>, <-0.565570, 0.251808, 0.785317> }
triangle { <-0.593300, 0.264154, 0.760406>, <-0.606312, 0.232741, 0.760406>, <-0.633715, 0.243260, 0.734323> }
triangle { <-0.633715, 0.243260, 0.734323>, <-0.620115, 0.276093, 0.734323>, <-0.593300, 0.264154, 0.760406> }
triangle { <-0.620115, 0.276093, 0.734323>, <-0.633715, 0.243260, 0.734323>, <-0.660141, 0.253404, 0.707107> }
triangle { <-0.660141, 0.253404, 0.707107>, <-0.645974, 0.287606, 0.707107>, <-0.620115, 0.276093, 0.734323> }
triangle { <-0.645974, 0.287606, 0.707107>, <-0.660141, 0.253404, 0.707107>, <-0.685549, 0.263158, 0.678801> }
triangle { <-0.685549, 0.263158, 0.678801>, <-0.670837, 0.298676, 0.678801>, <-0.645974, 0.287606, 0.707107> }
triangle { <-0.670837, 0.298676, 0.678801>, <-0.685549, 0.263158, 0.678801>, <-0.709900, 0.272505, 0.649448> }
triangle { <-0.709900, 0.272505, 0.649448>, <-0.694665, 0.309285, 0.649448>, <-0.670837, 0.298676, 0.678801> }
triangle { <-0.694665, 0.309285, 0.649448>, <-0.709900, 0.272505, 0.649448>, <-0.733157, 0.281432, 0.619094> }
triangle { <-0.733157, 0.281432, 0.619094>, <-0.717423, 0.319417, 0.619094>, <-0.694665, 0.309285, 0.649448> }
triangle { <-0.717423, 0.319417, 0.619094>, <-0.733157, 0.281432, 0.619094>, <-0.755282, 0.289926, 0.587785> }
triangle { <-0.755282, 0.289926, 0.587785>, <-0.739074, 0.329057, 0.587785>, <-0.717423, 0.319417, 0.619094> }
triangle { <-0.739074, 0.329057, 0.587785>, <-0.755282, 0.289926, 0.587785>, <-0.776244, 0.297972, 0.555570> }
triangle { <-0.776244, 0.297972, 0.555570>, <-0.759585, 0.338189, 0.555570>, <-0.739074, 0.329057, 0.587785> }
triangle { <-0.759585, 0.338189, 0.555570>, <-0.776244, 0.297972, 0.555570>, <-0.796008, 0.305559, 0.522499> }
triangle { <-0.796008, 0.305559, 0.522499>, <-0.778926, 0.346800, 0.522499>, <-0.759585, 0.338189, 0.555570> }
triangle { <-0.778926, 0.346800, 0.522499>, <-0.796008, 0.305559, 0.522499>, <-0.814545, 0.312675, 0.488621> }
triangle { <-0.814545, 0.312675, 0.488621>, <-0.797065, 0.354876, 0.488621>, <-0.778926, 0.346800, 0.522499> }
triangle { <-0.797065, 0.354876, 0.488621>, <-0.814545, 0.312675, 0.488621>, <-0.831826, 0.319308, 0.453990> }
triangle { <-0.831826, 0.319308, 0.453990>, <-0.813975, 0.362405, 0.453990>, <-0.797065, 0.354876, 0.488621> }
triangle { <-0.813975, 0.362405, 0.453990>, <-0.831826, 0.319308, 0.453990>, <-0.847825, 0.325449, 0.418660> }
triangle { <-0.847825, 0.325449, 0.418660>, <-0.829630, 0.369375, 0.418660>, <-0.813975, 0.362405, 0.453990> }
triangle { <-0.829630, 0.369375, 0.418660>, <-0.847825, 0.325449, 0.418660>, <-0.862516, 0.331089, 0.382683> }
triangle { <-0.862516, 0.331089, 0.382683>, <-0.844006, 0.375776, 0.382683>, <-0.829630, 0.369375, 0.418660> }
triangle { <-0.844006, 0.375776, 0.382683>, <-0.862516, 0.331089, 0.382683>, <-0.875877, 0.336218, 0.346117> }
triangle { <-0.875877, 0.336218, 0.346117>, <-0.857080, 0.381597, 0.346117>, <-0.844006, 0.375776, 0.382683> }
triangle { <-0.857080, 0.381597, 0.346117>, <-0.875877, 0.336218, 0.346117>, <-0.887888, 0.340828, 0.309017> }
triangle { <-0.887888, 0.340828, 0.309017>, <-0.868833, 0.386830, 0.309017>, <-0.857080, 0.381597, 0.346117> }
triangle { <-0.868833, 0.386830, 0.309017>, <-0.887888, 0.340828, 0.309017>, <-0.898529, 0.344913, 0.271440> }
triangle { <-0.898529, 0.344913, 0.271440>, <-0.879247, 0.391466, 0.271440>, <-0.868833, 0.386830, 0.309017> }
triangle { <-0.879247, 0.391466, 0.271440>, <-0.898529, 0.344913, 0.271440>, <-0.907786, 0.348466, 0.233445> }
triangle { <-0.907786, 0.348466, 0.233445>, <-0.888304, 0.395498, 0.233445>, <-0.879247, 0.391466, 0.271440> }
triangle { <-0.888304, 0.395498, 0.233445>, <-0.907786, 0.348466, 0.233445>, <-0.915642, 0.351482, 0.195090> }
triangle { <-0.915642, 0.351482, 0.195090>, <-0.895992, 0.398921, 0.195090>, <-0.888304, 0.395498, 0.233445> }
triangle { <-0.895992, 0.398921, 0.195090>, <-0.915642, 0.351482, 0.195090>, <-0.922087, 0.353956, 0.156434> }
triangle { <-0.922087, 0.353956, 0.156434>, <-0.902298, 0.401729, 0.156434>, <-0.895992, 0.398921, 0.195090> }
triangle { <-0.902298, 0.401729, 0.156434>, <-0.922087, 0.353956, 0.156434>, <-0.927109, 0.355884, 0.117537> }
triangle { <-0.927109, 0.355884, 0.117537>, <-0.907213, 0.403917, 0.117537>, <-0.902298, 0.401729, 0.156434> }
triangle { <-0.907213, 0.403917, 0.117537>, <-0.927109, 0.355884, 0.117537>, <-0.930703, 0.357263, 0.078459> }
triangle { <-0.930703, 0.357263, 0.078459>, <-0.910729, 0.405483, 0.078459>, <-0.907213, 0.403917, 0.117537> }
triangle { <-0.910729, 0.405483, 0.078459>, <-0.930703, 0.357263, 0.078459>, <-0.932861, 0.358092, 0.039260> }
triangle { <-0.932861, 0.358092, 0.039260>, <-0.912841, 0.406423, 0.039260>, <-0.910729, 0.405483, 0.078459> }
triangle { <-0.912841, 0.406423, 0.039260>, <-0.932861, 0.358092, 0.039260>, <-0.933580, 0.358368, -0.000000> }
triangle { <-0.933580, 0.358368, -0.000000>, <-0.913545, 0.406737, -0.000000>, <-0.912841, 0.406423, 0.039260> }
triangle { <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <-0.037338, 0.012132, 0.999229> }
triangle { <-0.037338, 0.012132, 0.999229>, <-0.036652, 0.014069, 0.999229>, <0.000000, 0.000000, 1.000000> }
triangle { <-0.036652, 0.014069, 0.999229>, <-0.037338, 0.012132, 0.999229>, <-0.074619, 0.024245, 0.996917> }
triangle { <-0.074619, 0.024245, 0.996917>, <-0.073248, 0.028117, 0.996917>, <-0.036652, 0.014069, 0.999229> }
triangle { <-0.073248, 0.028117, 0.996917>, <-0.074619, 0.024245, 0.996917>, <-0.111785, 0.036321, 0.993068> }
triangle { <-0.111785, 0.036321, 0.993068>, <-0.109731, 0.042122, 0.993068>, <-0.073248, 0.028117, 0.996917> }
triangle { <-0.109731, 0.042122, 0.993068>, <-0.111785, 0.036321, 0.993068>, <-0.148778, 0.048341, 0.987688> }
triangle { <-0.148778, 0.048341, 0.987688>, <-0.146044, 0.056061, 0.987688>, <-0.109731, 0.042122, 0.993068> }
triangle { <-0.146044, 0.056061, 0.987688>, <-0.148778, 0.048341, 0.987688>, <-0.185542, 0.060286, 0.980785> }
triangle { <-0.185542, 0.060286, 0.980785>, <-0.182133, 0.069914, 0.980785>, <-0.146044, 0.056061, 0.987688> }
triangle { <-0.182133, 0.069914, 0.980785>, <-0.185542, 0.060286, 0.980785>, <-0.222020, 0.072139, 0.972370> }
triangle { <-0.222020, 0.072139, 0.972370>, <-0.217940, 0.083659, 0.972370>, <-0.182133, 0.069914, 0.980785> }
triangle { <-0.217940, 0.083659, 0.972370>, <-0.222020, 0.072139, 0.972370>, <-0.258155, 0.083880, 0.962455> }
triangle { <-0.258155, 0.083880, 0.962455>, <-0.253411, 0.097276, 0.962455>, <-0.217940, 0.083659, 0.972370> }
triangle { <-0.253411, 0.097276, 0.962455>, <-0.258155, 0.083880, 0.962455>, <-0.293893, 0.095492, 0.951057> }
triangle { <-0.293893, 0.095492, 0.951057>, <-0.288492, 0.110742, 0.951057>, <-0.253411, 0.097276, 0.962455> }
triangle { <-0.288492, 0.110742, 0.951057>, <-0.293893, 0.095492, 0.951057>, <-0.329177, 0.106956, 0.938191> }
triangle { <-0.329177, 0.106956, 0.938191>, <-0.323128, 0.124037, 0.938191>, <-0.288492, 0.110742, 0.951057> }
triangle { <-0.323128, 0.124037, 0.938191>, <-0.329177, 0.106956, 0.938191>, <-0.363954, 0.118256, 0.923880> }
triangle { <-0.363954, 0.118256, 0.923880>, <-0.357266, 0.137141, 0.923880>, <-0.323128, 0.124037, 0.938191> }
triangle { <-0.357266, 0.137141, 0.923880>, <-0.363954, 0.118256, 0.923880>, <-0.398169, 0.129373, 0.908143> }
triangle { <-0.398169, 0.129373, 0.908143>, <-0.390853, 0.150034, 0.908143>, <-0.357266, 0.137141, 0.923880> }
triangle { <-0.390853, 0.150034, 0.908143>, <-0.398169, 0.129373, 0.908143>, <-0.431771, 0.140291, 0.891007> }
triangle { <-0.431771, 0.140291, 0.891007>, <-0.423837, 0.162696, 0.891007>, <-0.390853, 0.150034, 0.908143> }
triangle { <-0.423837, 0.162696, 0.891007>, <-0.431771, 0.140291, 0.891007>, <-0.464706, 0.150992, 0.872496> }
triangle { <-0.464706, 0.150992, 0.872496>, <-0.456167, 0.175106, 0.872496>, <-0.423837, 0.162696, 0.891007> }
triangle { <-0.456167, 0.175106, 0.872496>, <-0.464706, 0.150992, 0.872496>, <-0.496926, 0.161461, 0.852640> }
triangle { <-0.496926, 0.161461, 0.852640>, <-0.487794, 0.187247, 0.852640>, <-0.456167, 0.175106, 0.872496> }
triangle { <-0.487794, 0.187247, 0.852640>, <-0.496926, 0.161461, 0.852640>, <-0.528379, 0.171681, 0.831470> }
triangle { <-0.528379, 0.171681, 0.831470>, <-0.518669, 0.199099, 0.831470>, <-0.487794, 0.187247, 0.852640> }
triangle { <-0.518669, 0.199099, 0.831470>, <-0.528379, 0.171681, 0.831470>, <-0.559017, 0.181636, 0.809017> }
triangle { <-0.559017, 0.181636, 0.809017>, <-0.548745, 0.210643, 0.809017>, <-0.518669, 0.199099, 0.831470> }
triangle { <-0.548745, 0.210643, 0.809017>, <-0.559017, 0.181636, 0.809017>, <-0.588793, 0.191311, 0.785317> }
triangle { <-0.588793, 0.191311, 0.785317>, <-0.577974, 0.221863, 0.785317>, <-0.548745, 0.210643, 0.809017> }
triangle { <-0.577974, 0.221863, 0.785317>, <-0.588793, 0.191311, 0.785317>, <-0.617662, 0.200690, 0.760406> }
triangle { <-0.617662, 0.200690, 0.760406>, <-0.606312, 0.232741, 0.760406>, <-0.577974, 0.221863, 0.785317> }
triangle { <-0.606312, 0.232741, 0.760406>, <-0.617662, 0.200690, 0.760406>, <-0.645578, 0.209761, 0.734323> }
triangle { <-0.645578, 0.209761, 0.734323>, <-0.633715, 0.243260, 0.734323>, <-0.606312, 0.232741, 0.760406> }
triangle { <-0.633715, 0.243260, 0.734323>, <-0.645578, 0.209761, 0.734323>, <-0.672499, 0.218508, 0.707107> }
triangle { <-0.672499, 0.218508, 0.707107>, <-0.660141, 0.253404, 0.707107>, <-0.633715, 0.243260, 0.734323> }
triangle { <-0.660141, 0.253404, 0.707107>, <-0.672499, 0.218508, 0.707107>, <-0.698382, 0.226918, 0.678801> }
triangle { <-0.698382, 0.226918, 0.678801>, <-0.685549, 0.263158, 0.678801>, <-0.660141, 0.253404, 0.707107> }
triangle { <-0.685549, 0.263158, 0.678801>, <-0.698382, 0.226918, 0.678801>, <-0.723189, 0.234978, 0.649448> }
triangle { <-0.723189, 0.234978, 0.649448>, <-0.709900, 0.272505, 0.649448>, <-0.685549, 0.263158, 0.678801> }
triangle { <-0.709900, 0.272505, 0.649448>, <-0.723189, 0.234978, 0.649448>, <-0.746881, 0.242676, 0.619094> }
triangle { <-0.746881, 0.242676, 0.619094>, <-0.733157, 0.281432, 0.619094>, <-0.709900, 0.272505, 0.649448> }
triangle { <-0.733157, 0.281432, 0.619094>, <-0.746881, 0.242676, 0.619094>, <-0.769421, 0.250000, 0.587785> }
triangle { <-0.769421, 0.250000, 0.587785>, <-0.755282, 0.289926, 0.587785>, <-0.733157, 0.281432, 0.619094> }
triangle { <-0.755282, 0.289926, 0.587785>, <-0.769421, 0.250000, 0.587785>, <-0.790775, 0.256938, 0.555570> }
triangle { <-0.790775, 0.256938, 0.555570>, <-0.776244, 0.297972, 0.555570>, <-0.755282, 0.289926, 0.587785> }
triangle { <-0.776244, 0.297972, 0.555570>, <-0.790775, 0.256938, 0.555570>, <-0.810909, 0.263480, 0.522499> }
triangle { <-0.810909, 0.263480, 0.522499>, <-0.796008, 0.305559, 0.522499>, <-0.776244, 0.297972, 0.555570> }
triangle { <-0.796008, 0.305559, 0.522499>, <-0.810909, 0.263480, 0.522499>, <-0.829793, 0.269616, 0.488621> }
triangle { <-0.829793, 0.269616, 0.488621>, <-0.814545, 0.312675, 0.488621>, <-0.796008, 0.305559, 0.522499> }
triangle { <-0.814545, 0.312675, 0.488621>, <-0.829793, 0.269616, 0.488621>, <-0.847398, 0.275336, 0.453990> }
triangle { <-0.847398, 0.275336, 0.453990>, <-0.831826, 0.319308, 0.453990>, <-0.814545, 0.312675, 0.488621> }
triangle { <-0.831826, 0.319308, 0.453990>, <-0.847398, 0.275336, 0.453990>, <-0.863695, 0.280632, 0.418660> }
triangle { <-0.863695, 0.280632, 0.418660>, <-0.847825, 0.325449, 0.418660>, <-0.831826, 0.319308, 0.453990> }
triangle { <-0.847825, 0.325449, 0.418660>, <-0.863695, 0.280632, 0.418660>, <-0.878662, 0.285494, 0.382683> }
triangle { <-0.878662, 0.285494, 0.382683>, <-0.862516, 0.331089, 0.382683>, <-0.847825, 0.325449, 0.418660> }
triangle { <-0.862516, 0.331089, 0.382683>, <-0.878662, 0.285494, 0.382683>, <-0.892273, 0.289917, 0.346117> }
triangle { <-0.892273, 0.289917, 0.346117>, <-0.875877, 0.336218, 0.346117>, <-0.862516, 0.331089, 0.382683> }
triangle { <-0.875877, 0.336218, 0.346117>, <-0.892273, 0.289917, 0.346117>, <-0.904508, 0.293893, 0.309017> }
triangle { <-0.904508, 0.293893, 0.309017>, <-0.887888, 0.340828, 0.309017>, <-0.875877, 0.336218, 0.346117> }
triangle { <-0.887888, 0.340828, 0.309017>, <-0.904508, 0.293893, 0.309017>, <-0.915349, 0.297415, 0.271440> }
triangle { <-0.915349, 0.297415, 0.271440>, <-0.898529, 0.344913, 0.271440>, <-0.887888, 0.340828, 0.309017> }
triangle { <-0.898529, 0.344913, 0.271440>, <-0.915349, 0.297415, 0.271440>, <-0.924779, 0.300479, 0.233445> }
triangle { <-0.924779, 0.300479, 0.233445>, <-0.907786, 0.348466, 0.233445>, <-0.898529, 0.344913, 0.271440> }
triangle { <-0.907786, 0.348466, 0.233445>, <-0.924779, 0.300479, 0.233445>, <-0.932782, 0.303079, 0.195090> }
triangle { <-0.932782, 0.303079, 0.195090>, <-0.915642, 0.351482, 0.195090>, <-0.907786, 0.348466, 0.233445> }
triangle { <-0.915642, 0.351482, 0.195090>, <-0.932782, 0.303079, 0.195090>, <-0.939347, 0.305212, 0.156434> }
triangle { <-0.939347, 0.305212, 0.156434>, <-0.922087, 0.353956, 0.156434>, <-0.915642, 0.351482, 0.195090> }
triangle { <-0.922087, 0.353956, 0.156434>, <-0.939347, 0.305212, 0.156434>, <-0.944464, 0.306875, 0.117537> }
triangle { <-0.944464, 0.306875, 0.117537>, <-0.927109, 0.355884, 0.117537>, <-0.922087, 0.353956, 0.156434> }
triangle { <-0.927109, 0.355884, 0.117537>, <-0.944464, 0.306875, 0.117537>, <-0.948125, 0.308064, 0.078459> }
triangle { <-0.948125, 0.308064, 0.078459>, <-0.930703, 0.357263, 0.078459>, <-0.927109, 0.355884, 0.117537> }
triangle { <-0.930703, 0.357263, 0.078459>, <-0.948125, 0.308064, 0.078459>, <-0.950323, 0.308779, 0.039260> }
triangle { <-0.950323, 0.308779, 0.039260>, <-0.932861, 0.358092, 0.039260>, <-0.930703, 0.357263, 0.078459> }
triangle { <-0.932861, 0.358092, 0.039260>, <-0.950323, 0.308779, 0.039260>, <-0.951057, 0.309017, -0.000000> }
triangle { <-0.951057, 0.309017, -0.000000>, <-0.933580, 0.358368, -0.000000>, <-0.932861, 0.358092, 0.039260> }
triangle { <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <-0.037922, 0.010161, 0.999229> }
triangle { <-0.037922, 0.010161, 0.999229>, <-0.037338, 0.012132, 0.999229>, <0.000000, 0.000000, 1.000000> }
triangle { <-0.037338, 0.012132, 0.999229>, <-0.037922, 0.010161, 0.999229>, <-0.075786, 0.020307, 0.996917> }
triangle { <-0.075786, 0.020307, 0.996917>, <-0.074619, 0.024245, 0.996917>, <-0.037338, 0.012132, 0.999229> }
triangle { <-0.074619, 0.024245, 0.996917>, <-0.075786, 0.020307, 0.996917>, <-0.113532, 0.030421, 0.993068> }
triangle { <-0.113532, 0.030421, 0.993068>, <-0.111785, 0.036321, 0.993068>, <-0.074619, 0.024245, 0.996917> }
triangle { <-0.111785, 0.036321, 0.993068>, <-0.113532, 0.030421, 0.993068>, <-0.151104, 0.040488, 0.987688> }
triangle { <-0.151104, 0.040488, 0.987688>, <-0.148778, 0.048341, 0.987688>, <-0.111785, 0.036321, 0.993068> }
triangle { <-0.148778, 0.048341, 0.987688>, <-0.151104, 0.040488, 0.987688>, <-0.188443, 0.050493, 0.980785> }
triangle { <-0.188443, 0.050493, 0.980785>, <-0.185542, 0.060286, 0.980785>, <-0.148778, 0.048341, 0.987688> }
triangle { <-0.185542, 0.060286, 0.980785>, <-0.188443, 0.050493, 0.980785>, <-0.225491, 0.060420, 0.972370> }
triangle { <-0.225491, 0.060420, 0.972370>, <-0.222020, 0.072139, 0.972370>, <-0.185542, 0.060286, 0.980785> }
triangle { <-0.222020, 0.072139, 0.972370>, <-0.225491, 0.060420, 0.972370>, <-0.262191, 0.070254, 0.962455> }
triangle { <-0.262191, 0.070254, 0.962455>, <-0.258155, 0.083880, 0.962455>, <-0.222020, 0.072139, 0.972370> }
triangle { <-0.258155, 0.083880, 0.962455>, <-0.262191, 0.070254, 0.962455>, <-0.298487, 0.079979, 0.951057> }
triangle { <-0.298487, 0.079979, 0.951057>, <-0.293893, 0.095492, 0.951057>, <-0.258155, 0.083880, 0.962455> }
triangle { <-0.293893, 0.095492, 0.951057>, <-0.298487, 0.079979, 0.951057>, <-0.334323, 0.089582, 0.938191> }
triangle { <-0.334323, 0.089582, 0.938191>, <-0.329177, 0.106956, 0.938191>, <-0.293893, 0.095492, 0.951057> }
triangle { <-0.329177, 0.106956, 0.938191>, <-0.334323, 0.089582, 0.938191>, <-0.369644, 0.099046, 0.923880> }
triangle { <-0.369644, 0.099046, 0.923880>, <-0.363954, 0.118256, 0.923880>, <-0.329177, 0.106956, 0.938191> }
triangle { <-0.363954, 0.118256, 0.923880>, <-0.369644, 0.099046, 0.923880>, <-0.404394, 0.108357, 0.908143> }
triangle { <-0.404394, 0.108357, 0.908143>, <-0.398169, 0.129373, 0.908143>, <-0.363954, 0.118256, 0.923880> }
triangle { <-0.398169, 0.129373, 0.908143>, <-0.404394, 0.108357, 0.908143>, <-0.438521, 0.117501, 0.891007> }
triangle { <-0.438521, 0.117501, 0.891007>, <-0.431771, 0.140291, 0.891007>, <-0.398169, 0.129373, 0.908143> }
triangle { <-0.431771, 0.140291, 0.891007>, <-0.438521, 0.117501, 0.891007>, <-0.471972, 0.126464, 0.872496> }
triangle { <-0.471972, 0.126464, 0.872496>, <-0.464706, 0.150992, 0.872496>, <-0.431771, 0.140291, 0.891007> }
triangle { <-0.464706, 0.150992, 0.872496>, <-0.471972, 0.126464, 0.872496>, <-0.504695, 0.135233, 0.852640> }
triangle { <-0.504695, 0.135233, 0.852640>, <-0.496926, 0.161461, 0.852640>, <-0.464706, 0.150992, 0.872496> }
triangle { <-0.496926, 0.161461, 0.852640>, <-0.504695, 0.135233, 0.852640>, <-0.536640, 0.143792, 0.831470> }
triangle { <-0.536640, 0.143792, 0.831470>, <-0.528379, 0.171681, 0.831470>, <-0.496926, 0.161461, 0.852640> }
triangle { <-0.528379, 0.171681, 0.831470>, <-0.536640, 0.143792, 0.831470>, <-0.567757, 0.152130, 0.809017> }
triangle { <-0.567757, 0.152130, 0.809017>, <-0.559017, 0.181636, 0.809017>, <-0.528379, 0.171681, 0.831470> }
triangle { <-0.559017, 0.181636, 0.809017>, <-0.567757, 0.152130, 0.809017>, <-0.597999, 0.160233, 0.785317> }
triangle { <-0.597999, 0.160233, 0.785317>, <-0.588793, 0.191311, 0.785317>, <-0.559017, 0.181636, 0.809017> }
triangle { <-0.588793, 0.191311, 0.785317>, <-0.597999, 0.160233, 0.785317>, <-0.627319, 0.168090, 0.760406> }
triangle { <-0.627319, 0.168090, 0.760406>, <-0.617662, 0.200690, 0.760406>, <-0.588793, 0.191311, 0.785317> }
triangle { <-0.617662, 0.200690, 0.760406>, <-0.627319, 0.168090, 0.760406>, <-0.655671, 0.175687, 0.734323> }
triangle { <-0.655671, 0.175687, 0.734323>, <-0.645578, 0.209761, 0.734323>, <-0.617662, 0.200690, 0.760406> }
triangle { <-0.645578, 0.209761, 0.734323>, <-0.655671, 0.175687, 0.734323>, <-0.683013, 0.183013, 0.707107> }
triangle { <-0.683013, 0.183013, 0.707107>, <-0.672499, 0.218508, 0.707107>, <-0.645578, 0.209761, 0.734323> }
triangle { <-0.672499, 0.218508, 0.707107>, <-0.683013, 0.183013, 0.707107>, <-0.709301, 0.190057, 0.678801> }
triangle { <-0.709301, 0.190057, 0.678801>, <-0.698382, 0.226918, 0.678801>, <-0.672499, 0.218508, 0.707107> }
triangle { <-0.698382, 0.226918, 0.678801>, <-0.709301, 0.190057, 0.678801>, <-0.734496, 0.196808, 0.649448> }
triangle { <-0.734496, 0.196808, 0.649448>, <-0.723189, 0.234978, 0.649448>, <-0.698382, 0.226918, 0.678801> }
triangle { <-0.723189, 0.234978, 0.649448>, <-0.734496, 0.196808, 0.649448>, <-0.758558, 0.203255, 0.619094> }
triangle { <-0.758558, 0.203255, 0.619094>, <-0.746881, 0.242676, 0.619094>, <-0.723189, 0.234978, 0.649448> }
triangle { <-0.746881, 0.242676, 0.619094>, <-0.758558, 0.203255, 0.619094>, <-0.781450, 0.209389, 0.587785> }
triangle { <-0.781450, 0.209389, 0.587785>, <-0.769421, 0.250000, 0.587785>, <-0.746881, 0.242676, 0.619094> }
triangle { <-0.769421, 0.250000, 0.587785>, <-0.781450, 0.209389, 0.587785>, <-0.803138, 0.215200, 0.555570> }
triangle { <-0.803138, 0.215200, 0.555570>, <-0.790775, 0.256938, 0.555570>, <-0.769421, 0.250000, 0.587785> }
triangle { <-0.790775, 0.256938, 0.555570>, <-0.803138, 0.215200, 0.555570>, <-0.823587, 0.220680, 0.522499> }
triangle { <-0.823587, 0.220680, 0.522499>, <-0.810909, 0.263480, 0.522499>, <-0.790775, 0.256938, 0.555570> }
triangle { <-0.810909, 0.263480, 0.522499>, <-0.823587, 0.220680, 0.522499>, <-0.842766, 0.225819, 0.488621> }
triangle { <-0.842766, 0.225819, 0.488621>, <-0.829793, 0.269616, 0.488621>, <-0.810909, 0.263480, 0.522499> }
triangle { <-0.829793, 0.269616, 0.488621>, <-0.842766, 0.225819, 0.488621>, <-0.860646, 0.230609, 0.453990> }
triangle { <-0.860646, 0.230609, 0.453990>, <-0.847398, 0.275336, 0.453990>, <-0.829793, 0.269616, 0.488621> }
triangle { <-0.847398, 0.275336, 0.453990>, <-0.860646, 0.230609, 0.453990>, <-0.877199, 0.235045, 0.418660> }
triangle { <-0.877199, 0.235045, 0.418660>, <-0.863695, 0.280632, 0.418660>, <-0.847398, 0.275336, 0.453990> }
triangle { <-0.863695, 0.280632, 0.418660>, <-0.877199, 0.235045, 0.418660>, <-0.892399, 0.239118, 0.382683> }
triangle { <-0.892399, 0.239118, 0.382683>, <-0.878662, 0.285494, 0.382683>, <-0.863695, 0.280632, 0.418660> }
triangle { <-0.878662, 0.285494, 0.382683>, <-0.892399, 0.239118, 0.382683>, <-0.906223, 0.242822, 0.346117> }
triangle { <-0.906223, 0.242822, 0.346117>, <-0.892273, 0.289917, 0.346117>, <-0.878662, 0.285494, 0.382683> }
triangle { <-0.892273, 0.289917, 0.346117>, <-0.906223, 0.242822, 0.346117>, <-0.918650, 0.246152, 0.309017> }
triangle { <-0.918650, 0.246152, 0.309017>, <-0.904508, 0.293893, 0.309017>, <-0.892273, 0.289917, 0.346117> }
triangle { <-0.904508, 0.293893, 0.309017>, <-0.918650, 0.246152, 0.309017>, <-0.929660, 0.249102, 0.271440> }
triangle { <-0.929660, 0.249102, 0.271440>, <-0.915349, 0.297415, 0.271440>, <-0.904508, 0.293893, 0.309017> }
triangle { <-0.915349, 0.297415, 0.271440>, <-0.929660, 0.249102, 0.271440>, <-0.939237, 0.251668, 0.233445> }
triangle { <-0.939237, 0.251668, 0.233445>, <-0.924779, 0.300479, 0.233445>, <-0.915349, 0.297415, 0.271440> }
triangle { <-0.924779, 0.300479, 0.233445>, <-0.939237, 0.251668, 0.233445>, <-0.947366, 0.253846, 0.195090> }
triangle { <-0.947366, 0.253846, 0.195090>, <-0.932782, 0.303079, 0.195090>, <-0.924779, 0.300479, 0.233445> }
triangle { <-0.932782, 0.303079, 0.195090>, <-0.947366, 0.253846, 0.195090>, <-0.954034, 0.255633, 0.156434> }
triangle { <-0.954034, 0.255633, 0.156434>, <-0.939347, 0.305212, 0.156434>, <-0.932782, 0.303079, 0.195090> }
triangle { <-0.939347, 0.305212, 0.156434>, <-0.954034, 0.255633, 0.156434>, <-0.959230, 0.257025, 0.117537> }
triangle { <-0.959230, 0.257025, 0.117537>, <-0.944464, 0.306875, 0.117537>, <-0.939347, 0.305212, 0.156434> }
triangle { <-0.944464, 0.306875, 0.117537>, <-0.959230, 0.257025, 0.117537>, <-0.962948, 0.258021, 0.078459> }
triangle { <-0.962948, 0.258021, 0.078459>, <-0.948125, 0.308064, 0.078459>, <-0.944464, 0.306875, 0.117537> }
triangle { <-0.948125, 0.308064, 0.078459>, <-0.962948, 0.258021, 0.078459>, <-0.965181, 0.258620, 0.039260> }
triangle { <-0.965181, 0.258620, 0.039260>, <-0.950323, 0.308779, 0.039260>, <-0.948125, 0.308064, 0.078459> }
triangle { <-0.950323, 0.308779, 0.039260>, <-0.965181, 0.258620, 0.039260>, <-0.965926, 0.258819, -0.000000> }
triangle { <-0.965926, 0.258819, -0.000000>, <-0.951057, 0.309017, -0.000000>, <-0.950323, 0.308779, 0.039260> }
triangle { <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <-0.038402, 0.008163, 0.999229> }
triangle { <-0.038402, 0.008163, 0.999229>, <-0.037922, 0.010161, 0.999229>, <0.000000, 0.000000, 1.000000> }
triangle { <-0.037922, 0.010161, 0.999229>, <-0.038402, 0.008163, 0.999229>, <-0.076745, 0.016313, 0.996917> }
triangle { <-0.076745, 0.016313, 0.996917>, <-0.075786, 0.020307, 0.996917>, <-0.037922, 0.010161, 0.999229> }
triangle { <-0.075786, 0.020307, 0.996917>, <-0.076745, 0.016313, 0.996917>, <-0.114969, 0.024437, 0.993068> }
triangle { <-0.114969, 0.024437, 0.993068>, <-0.113532, 0.030421, 0.993068>, <-0.075786, 0.020307, 0.996917> }
triangle { <-0.113532, 0.030421, 0.993068>, <-0.114969, 0.024437, 0.993068>, <-0.153016, 0.032525, 0.987688> }
triangle { <-0.153016, 0.032525, 0.987688>, <-0.151104, 0.040488, 0.987688>, <-0.113532, 0.030421, 0.993068> }
triangle { <-0.151104, 0.040488, 0.987688>, <-0.153016, 0.032525, 0.987688>, <-0.190827, 0.040562, 0.980785> }
triangle { <-0.190827, 0.040562, 0.980785>, <-0.188443, 0.050493, 0.980785>, <-0.151104, 0.040488, 0.987688> }
triangle { <-0.188443, 0.050493, 0.980785>, <-0.190827, 0.040562, 0.980785>, <-0.228344, 0.048536, 0.972370> }
triangle { <-0.228344, 0.048536, 0.972370>, <-0.225491, 0.060420, 0.972370>, <-0.188443, 0.050493, 0.980785> }
triangle { <-0.225491, 0.060420, 0.972370>, <-0.228344, 0.048536, 0.972370>, <-0.265509, 0.056436, 0.962455> }
triangle { <-0.265509, 0.056436, 0.962455>, <-0.262191, 0.070254, 0.962455>, <-0.225491, 0.060420, 0.972370> }
triangle { <-0.262191, 0.070254, 0.962455>, <-0.265509, 0.056436, 0.962455>, <-0.302264, 0.064248, 0.951057> }
triangle { <-0.302264, 0.064248, 0.951057>, <-0.298487, 0.079979, 0.951057>, <-0.262191, 0.070254, 0.962455> }
triangle { <-0.298487, 0.079979, 0.951057>, <-0.302264, 0.064248, 0.951057>, <-0.338554, 0.071962, 0.938191> }
triangle { <-0.338554, 0.071962, 0.938191>, <-0.334323, 0.089582, 0.938191>, <-0.298487, 0.079979, 0.951057> }
triangle { <-0.334323, 0.089582, 0.938191>, <-0.338554, 0.071962, 0.938191>, <-0.374321, 0.079564, 0.923880> }
triangle { <-0.374321, 0.079564, 0.923880>, <-0.369644, 0.099046, 0.923880>, <-0.334323, 0.089582, 0.938191> }
triangle { <-0.369644, 0.099046, 0.923880>, <-0.374321, 0.079564, 0.923880>, <-0.409511, 0.087044, 0.908143> }
triangle { <-0.409511, 0.087044, 0.908143>, <-0.404394, 0.108357, 0.908143>, <-0.369644, 0.099046, 0.923880> }
triangle { <-0.404394, 0.108357, 0.908143>, <-0.409511, 0.087044, 0.908143>, <-0.444070, 0.094390, 0.891007> }
triangle { <-0.444070, 0.094390, 0.891007>, <-0.438521, 0.117501, 0.891007>, <-0.404394, 0.108357, 0.908143> }
triangle { <-0.438521, 0.117501, 0.891007>, <-0.444070, 0.094390, 0.891007>, <-0.477944, 0.101590, 0.872496> }
triangle { <-0.477944, 0.101590, 0.872496>, <-0.471972, 0.126464, 0.872496>, <-0.438521, 0.117501, 0.891007> }
triangle { <-0.471972, 0.126464, 0.872496>, <-0.477944, 0.101590, 0.872496>, <-0.511081, 0.108634, 0.852640> }
triangle { <-0.511081, 0.108634, 0.852640>, <-0.504695, 0.135233, 0.852640>, <-0.471972, 0.126464, 0.872496> }
triangle { <-0.504695, 0.135233, 0.852640>, <-0.511081, 0.108634, 0.852640>, <-0.543430, 0.115510, 0.831470> }
triangle { <-0.543430, 0.115510, 0.831470>, <-0.536640, 0.143792, 0.831470>, <-0.504695, 0.135233, 0.852640> }
triangle { <-0.536640, 0.143792, 0.831470>, <-0.543430, 0.115510, 0.831470>, <-0.574941, 0.122207, 0.809017> }
triangle { <-0.574941, 0.122207, 0.809017>, <-0.567757, 0.152130, 0.809017>, <-0.536640, 0.143792, 0.831470> }
triangle { <-0.567757, 0.152130, 0.809017>, <-0.574941, 0.122207, 0.809017>, <-0.605565, 0.128717, 0.785317> }
triangle { <-0.605565, 0.128717, 0.785317>, <-0.597999, 0.160233, 0.785317>, <-0.567757, 0.152130, 0.809017> }
triangle { <-0.597999, 0.160233, 0.785317>, <-0.605565, 0.128717, 0.785317>, <-0.635256, 0.135028, 0.760406> }
triangle { <-0.635256, 0.135028, 0.760406>, <-0.627319, 0.168090, 0.760406>, <-0.597999, 0.160233, 0.785317> }
triangle { <-0.627319, 0.168090, 0.760406>, <-0.635256, 0.135028, 0.760406>, <-0.663967, 0.141131, 0.734323> }
triangle { <-0.663967, 0.141131, 0.734323>, <-0.655671, 0.175687, 0.734323>, <-0.627319, 0.168090, 0.760406> }
triangle { <-0.655671, 0.175687, 0.734323>, <-0.663967, 0.141131, 0.734323>, <-0.691655, 0.147016, 0.707107> }
triangle { <-0.691655, 0.147016, 0.707107>, <-0.683013, 0.183013, 0.707107>, <-0.655671, 0.175687, 0.734323> }
triangle { <-0.683013, 0.183013, 0.707107>, <-0.691655, 0.147016, 0.707107>, <-0.718276, 0.152674, 0.678801> }
triangle { <-0.718276, 0.152674, 0.678801>, <-0.709301, 0.190057, 0.678801>, <-0.683013, 0.183013, 0.707107> }
triangle { <-0.709301, 0.190057, 0.678801>, <-0.718276, 0.152674, 0.678801>, <-0.743789, 0.158097, 0.649448> }
triangle { <-0.743789, 0.158097, 0.649448>, <-0.734496, 0.196808, 0.649448>, <-0.709301, 0.190057, 0.678801> }
triangle { <-0.734496, 0.196808, 0.649448>, <-0.743789, 0.158097, 0.649448>, <-0.768156, 0.163277, 0.619094> }
triangle { <-0.768156, 0.163277, 0.619094>, <-0.758558, 0.203255, 0.619094>, <-0.734496, 0.196808, 0.649448> }
triangle { <-0.758558, 0.203255, 0.619094>, <-0.768156, 0.163277, 0.619094>, <-0.791338, 0.168204, 0.587785> }
triangle { <-0.791338, 0.168204, 0.587785>, <-0.781450, 0.209389, 0.587785>, <-0.758558, 0.203255, 0.619094> }
triangle { <-0.781450, 0.209389, 0.587785>, <-0.791338, 0.168204, 0.587785>, <-0.813300, 0.172872, 0.555570> }
triangle { <-0.813300, 0.172872, 0.555570>, <-0.803138, 0.215200, 0.555570>, <-0.781450, 0.209389, 0.587785> }
triangle { <-0.803138, 0.215200, 0.555570>, <-0.813300, 0.172872, 0.555570>, <-0.834008, 0.177274, 0.522499> }
triangle { <-0.834008, 0.177274, 0.522499>, <-0.823587, 0.220680, 0.522499>, <-0.803138, 0.215200, 0.555570> }
triangle { <-0.823587, 0.220680, 0.522499>, <-0.834008, 0.177274, 0.522499>, <-0.853430, 0.181402, 0.488621> }
triangle { <-0.853430, 0.181402, 0.488621>, <-0.842766, 0.225819, 0.488621>, <-0.823587, 0.220680, 0.522499> }
triangle { <-0.842766, 0.225819, 0.488621>, <-0.853430, 0.181402, 0.488621>, <-0.871536, 0.185251, 0.453990> }
triangle { <-0.871536, 0.185251, 0.453990>, <-0.860646, 0.230609, 0.453990>, <-0.842766, 0.225819, 0.488621> }
triangle { <-0.860646, 0.230609, 0.453990>, <-0.871536, 0.185251, 0.453990>, <-0.888298, 0.188814, 0.418660> }
triangle { <-0.888298, 0.188814, 0.418660>, <-0.877199, 0.235045, 0.418660>, <-0.860646, 0.230609, 0.453990> }
triangle { <-0.877199, 0.235045, 0.418660>, <-0.888298, 0.188814, 0.418660>, <-0.903691, 0.192085, 0.382683> }
triangle { <-0.903691, 0.192085, 0.382683>, <-0.892399, 0.239118, 0.382683>, <-0.877199, 0.235045, 0.418660> }
triangle { <-0.892399, 0.239118, 0.382683>, <-0.903691, 0.192085, 0.382683>, <-0.917690, 0.195061, 0.346117> }
triangle { <-0.917690, 0.195061, 0.346117>, <-0.906223, 0.242822, 0.346117>, <-0.892399, 0.239118, 0.382683> }
triangle { <-0.906223, 0.242822, 0.346117>, <-0.917690, 0.195061, 0.346117>, <-0.930274, 0.197736, 0.309017> }
triangle { <-0.930274, 0.197736, 0.309017>, <-0.918650, 0.246152, 0.309017>, <-0.906223, 0.242822, 0.346117> }
triangle { <-0.918650, 0.246152, 0.309017>, <-0.930274, 0.197736, 0.309017>, <-0.941423, 0.200106, 0.271440> }
triangle { <-0.941423, 0.200106, 0.271440>, <-0.929660, 0.249102, 0.271440>, <-0.918650, 0.246152, 0.309017> }
triangle { <-0.929660, 0.249102, 0.271440>, <-0.941423, 0.200106, 0.271440>, <-0.951121, 0.202167, 0.233445> }
triangle { <-0.951121, 0.202167, 0.233445>, <-0.939237, 0.251668, 0.233445>, <-0.929660, 0.249102, 0.271440> }
triangle { <-0.939237, 0.251668, 0.233445>, <-0.951121, 0.202167, 0.233445>, <-0.959353, 0.203917, 0.195090> }
triangle { <-0.959353, 0.203917, 0.195090>, <-0.947366, 0.253846, 0.195090>, <-0.939237, 0.251668, 0.233445> }
triangle { <-0.947366, 0.253846, 0.195090>, <-0.959353, 0.203917, 0.195090>, <-0.966105, 0.205352, 0.156434> }
triangle { <-0.966105, 0.205352, 0.156434>, <-0.954034, 0.255633, 0.156434>, <-0.947366, 0.253846, 0.195090> }
triangle { <-0.954034, 0.255633, 0.156434>, <-0.966105, 0.205352, 0.156434>, <-0.971368, 0.206471, 0.117537> }
triangle { <-0.971368, 0.206471, 0.117537>, <-0.959230, 0.257025, 0.117537>, <-0.954034, 0.255633, 0.156434> }
triangle { <-0.959230, 0.257025, 0.117537>, <-0.971368, 0.206471, 0.117537>, <-0.975132, 0.207271, 0.078459> }
triangle { <-0.975132, 0.207271, 0.078459>, <-0.962948, 0.258021, 0.078459>, <-0.959230, 0.257025, 0.117537> }
triangle { <-0.962948, 0.258021, 0.078459>, <-0.975132, 0.207271, 0.078459>, <-0.977393, 0.207751, 0.039260> }
triangle { <-0.977393, 0.207751, 0.039260>, <-0.965181, 0.258620, 0.039260>, <-0.962948, 0.258021, 0.078459> }
triangle { <-0.965181, 0.258620, 0.039260>, <-0.977393, 0.207751, 0.039260>, <-0.978148, 0.207912, -0.000000> }
triangle { <-0.978148, 0.207912, -0.000000>, <-0.965926, 0.258819, -0.000000>, <-0.965181, 0.258620, 0.039260> }
triangle { <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <-0.038776, 0.006142, 0.999229> }
triangle { <-0.038776, 0.006142, 0.999229>, <-0.038402, 0.008163, 0.999229>, <0.000000, 0.000000, 1.000000> }
triangle { <-0.038402, 0.008163, 0.999229>, <-0.038776, 0.006142, 0.999229>, <-0.077493, 0.012274, 0.996917> }
triangle { <-0.077493, 0.012274, 0.996917>, <-0.076745, 0.016313, 0.996917>, <-0.038402, 0.008163, 0.999229> }
triangle { <-0.076745, 0.016313, 0.996917>, <-0.077493, 0.012274, 0.996917>, <-0.116090, 0.018387, 0.993068> }
triangle { <-0.116090, 0.018387, 0.993068>, <-0.114969, 0.024437, 0.993068>, <-0.076745, 0.016313, 0.996917> }
triangle { <-0.114969, 0.024437, 0.993068>, <-0.116090, 0.018387, 0.993068>, <-0.154508, 0.024472, 0.987688> }
triangle { <-0.154508, 0.024472, 0.987688>, <-0.153016, 0.032525, 0.987688>, <-0.114969, 0.024437, 0.993068> }
triangle { <-0.153016, 0.032525, 0.987688>, <-0.154508, 0.024472, 0.987688>, <-0.192688, 0.030519, 0.980785> }
triangle { <-0.192688, 0.030519, 0.980785>, <-0.190827, 0.040562, 0.980785>, <-0.153016, 0.032525, 0.987688> }
triangle { <-0.190827, 0.040562, 0.980785>, <-0.192688, 0.030519, 0.980785>, <-0.230571, 0.036519, 0.972370> }
triangle { <-0.230571, 0.036519, 0.972370>, <-0.228344, 0.048536, 0.972370>, <-0.190827, 0.040562, 0.980785> }
triangle { <-0.228344, 0.048536, 0.972370>, <-0.230571, 0.036519, 0.972370>, <-0.268099, 0.042463, 0.962455> }
triangle { <-0.268099, 0.042463, 0.962455>, <-0.265509, 0.056436, 0.962455>, <-0.228344, 0.048536, 0.972370> }
triangle { <-0.265509, 0.056436, 0.962455>, <-0.268099, 0.042463, 0.962455>, <-0.305212, 0.048341, 0.951057> }
triangle { <-0.305212, 0.048341, 0.951057>, <-0.302264, 0.064248, 0.951057>, <-0.265509, 0.056436, 0.962455> }
triangle { <-0.302264, 0.064248, 0.951057>, <-0.305212, 0.048341, 0.951057>, <-0.341856, 0.054145, 0.938191> }
triangle { <-0.341856, 0.054145, 0.938191>, <-0.338554, 0.071962, 0.938191>, <-0.302264, 0.064248, 0.951057> }
triangle { <-0.338554, 0.071962, 0.938191>, <-0.341856, 0.054145, 0.938191>, <-0.377972, 0.059865, 0.923880> }
triangle { <-0.377972, 0.059865, 0.923880>, <-0.374321, 0.079564, 0.923880>, <-0.338554, 0.071962, 0.938191> }
triangle { <-0.374321, 0.079564, 0.923880>, <-0.377972, 0.059865, 0.923880>, <-0.413505, 0.065493, 0.908143> }
triangle { <-0.413505, 0.065493, 0.908143>, <-0.409511, 0.087044, 0.908143>, <-0.374321, 0.079564, 0.923880> }
triangle { <-0.409511, 0.087044, 0.908143>, <-0.413505, 0.065493, 0.908143>, <-0.448401, 0.071020, 0.891007> }
triangle { <-0.448401, 0.071020, 0.891007>, <-0.444070, 0.094390, 0.891007>, <-0.409511, 0.087044, 0.908143> }
triangle { <-0.444070, 0.094390, 0.891007>, <-0.448401, 0.071020, 0.891007>, <-0.482606, 0.076437, 0.872496> }
triangle { <-0.482606, 0.076437, 0.872496>, <-0.477944, 0.101590, 0.872496>, <-0.444070, 0.094390, 0.891007> }
triangle { <-0.477944, 0.101590, 0.872496>, <-0.482606, 0.076437, 0.872496>, <-0.516066, 0.081737, 0.852640> }
triangle { <-0.516066, 0.081737, 0.852640>, <-0.511081, 0.108634, 0.852640>, <-0.477944, 0.101590, 0.872496> }
triangle { <-0.511081, 0.108634, 0.852640>, <-0.516066, 0.081737, 0.852640>, <-0.548730, 0.086910, 0.831470> }
triangle { <-0.548730, 0.086910, 0.831470>, <-0.543430, 0.115510, 0.831470>, <-0.511081, 0.108634, 0.852640> }
triangle { <-0.543430, 0.115510, 0.831470>, <-0.548730, 0.086910, 0.831470>, <-0.580549, 0.091950, 0.809017> }
triangle { <-0.580549, 0.091950, 0.809017>, <-0.574941, 0.122207, 0.809017>, <-0.543430, 0.115510, 0.831470> }
triangle { <-0.574941, 0.122207, 0.809017>, <-0.580549, 0.091950, 0.809017>, <-0.611472, 0.096848, 0.785317> }
triangle { <-0.611472, 0.096848, 0.785317>, <-0.605565, 0.128717, 0.785317>, <-0.574941, 0.122207, 0.809017> }
triangle { <-0.605565, 0.128717, 0.785317>, <-0.611472, 0.096848, 0.785317>, <-0.641452, 0.101596, 0.760406> }
triangle { <-0.641452, 0.101596, 0.760406>, <-0.635256, 0.135028, 0.760406>, <-0.605565, 0.128717, 0.785317> }
triangle { <-0.635256, 0.135028, 0.760406>, <-0.641452, 0.101596, 0.760406>, <-0.670444, 0.106188, 0.734323> }
triangle { <-0.670444, 0.106188, 0.734323>, <-0.663967, 0.141131, 0.734323>, <-0.635256, 0.135028, 0.760406> }
triangle { <-0.663967, 0.141131, 0.734323>, <-0.670444, 0.106188, 0.734323>, <-0.698401, 0.110616, 0.707107> }
triangle { <-0.698401, 0.110616, 0.707107>, <-0.691655, 0.147016, 0.707107>, <-0.663967, 0.141131, 0.734323> }
triangle { <-0.691655, 0.147016, 0.707107>, <-0.698401, 0.110616, 0.707107>, <-0.725282, 0.114873, 0.678801> }
triangle { <-0.725282, 0.114873, 0.678801>, <-0.718276, 0.152674, 0.678801>, <-0.691655, 0.147016, 0.707107> }
triangle { <-0.718276, 0.152674, 0.678801>, <-0.725282, 0.114873, 0.678801>, <-0.751044, 0.118954, 0.649448> }
triangle { <-0.751044, 0.118954, 0.649448>, <-0.743789, 0.158097, 0.649448>, <-0.718276, 0.152674, 0.678801> }
triangle { <-0.743789, 0.158097, 0.649448>, <-0.751044, 0.118954, 0.649448>, <-0.775648, 0.122851, 0.619094> }
triangle { <-0.775648, 0.122851, 0.619094>, <-0.768156, 0.163277, 0.619094>, <-0.743789, 0.158097, 0.649448> }
triangle { <-0.768156, 0.163277, 0.619094>, <-0.775648, 0.122851, 0.619094>, <-0.799057, 0.126558, 0.587785> }
triangle { <-0.799057, 0.126558, 0.587785>, <-0.791338, 0.168204, 0.587785>, <-0.768156, 0.163277, 0.619094> }
triangle { <-0.791338, 0.168204, 0.587785>, <-0.799057, 0.126558, 0.587785>, <-0.821233, 0.130071, 0.555570> }
triangle { <-0.821233, 0.130071, 0.555570>, <-0.813300, 0.172872, 0.555570>, <-0.791338, 0.168204, 0.587785> }
triangle { <-0.813300, 0.172872, 0.555570>, <-0.821233, 0.130071, 0.555570>, <-0.842143, 0.133382, 0.522499> }
triangle { <-0.842143, 0.133382, 0.522499>, <-0.834008, 0.177274, 0.522499>, <-0.813300, 0.172872, 0.555570> }
triangle { <-0.834008, 0.177274, 0.522499>, <-0.842143, 0.133382, 0.522499>, <-0.861754, 0.136488, 0.488621> }
triangle { <-0.861754, 0.136488, 0.488621>, <-0.853430, 0.181402, 0.488621>, <-0.834008, 0.177274, 0.522499> }
triangle { <-0.853430, 0.181402, 0.488621>, <-0.861754, 0.136488, 0.488621>, <-0.880037, 0.139384, 0.453990> }
triangle { <-0.880037, 0.139384, 0.453990>, <-0.871536, 0.185251, 0.453990>, <-0.853430, 0.181402, 0.488621> }
triangle { <-0.871536, 0.185251, 0.453990>, <-0.880037, 0.139384, 0.453990>, <-0.896962, 0.142065, 0.418660> }
triangle { <-0.896962, 0.142065, 0.418660>, <-0.888298, 0.188814, 0.418660>, <-0.871536, 0.185251, 0.453990> }
triangle { <-0.888298, 0.188814, 0.418660>, <-0.896962, 0.142065, 0.418660>, <-0.912505, 0.144527, 0.382683> }
triangle { <-0.912505, 0.144527, 0.382683>, <-0.903691, 0.192085, 0.382683>, <-0.888298, 0.188814, 0.418660> }
triangle { <-0.903691, 0.192085, 0.382683>, <-0.912505, 0.144527, 0.382683>, <-0.926641, 0.146765, 0.346117> }
triangle { <-0.926641, 0.146765, 0.346117>, <-0.917690, 0.195061, 0.346117>, <-0.903691, 0.192085, 0.382683> }
triangle { <-0.917690, 0.195061, 0.346117>, <-0.926641, 0.146765, 0.346117>, <-0.939347, 0.148778, 0.309017> }
triangle { <-0.939347, 0.148778, 0.309017>, <-0.930274, 0.197736, 0.309017>, <-0.917690, 0.195061, 0.346117> }
triangle { <-0.930274, 0.197736, 0.309017>, <-0.939347, 0.148778, 0.309017>, <-0.950606, 0.150561, 0.271440> }
triangle { <-0.950606, 0.150561, 0.271440>, <-0.941423, 0.200106, 0.271440>, <-0.930274, 0.197736, 0.309017> }
triangle { <-0.941423, 0.200106, 0.271440>, <-0.950606, 0.150561, 0.271440>, <-0.960398, 0.152112, 0.233445> }
triangle { <-0.960398, 0.152112, 0.233445>, <-0.951121, 0.202167, 0.233445>, <-0.941423, 0.200106, 0.271440> }
triangle { <-0.951121, 0.202167, 0.233445>, <-0.960398, 0.152112, 0.233445>, <-0.968710, 0.153429, 0.195090> }
triangle { <-0.968710, 0.153429, 0.195090>, <-0.959353, 0.203917, 0.195090>, <-0.951121, 0.202167, 0.233445> }
triangle { <-0.959353, 0.203917, 0.195090>, <-0.968710, 0.153429, 0.195090>, <-0.975528, 0.154508, 0.156434> }
triangle { <-0.975528, 0.154508, 0.156434>, <-0.966105, 0.205352, 0.156434>, <-0.959353, 0.203917, 0.195090> }
triangle { <-0.966105, 0.205352, 0.156434>, <-0.975528, 0.154508, 0.156434>, <-0.980842, 0.155350, 0.117537> }
triangle { <-0.980842, 0.155350, 0.117537>, <-0.971368, 0.206471, 0.117537>, <-0.966105, 0.205352, 0.156434> }
triangle { <-0.971368, 0.206471, 0.117537>, <-0.980842, 0.155350, 0.117537>, <-0.984644, 0.155952, 0.078459> }
triangle { <-0.984644, 0.155952, 0.078459>, <-0.975132, 0.207271, 0.078459>, <-0.971368, 0.206471, 0.117537> }
triangle { <-0.975132, 0.207271, 0.078459>, <-0.984644, 0.155952, 0.078459>, <-0.986927, 0.156314, 0.039260> }
triangle { <-0.986927, 0.156314, 0.039260>, <-0.977393, 0.207751, 0.039260>, <-0.975132, 0.207271, 0.078459> }
triangle { <-0.977393, 0.207751, 0.039260>, <-0.986927, 0.156314, 0.039260>, <-0.987688, 0.156434, -0.000000> }
triangle { <-0.987688, 0.156434, -0.000000>, <-0.978148, 0.207912, -0.000000>, <-0.977393, 0.207751, 0.039260> }
triangle { <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <-0.039045, 0.004104, 0.999229> }
triangle { <-0.039045, 0.004104, 0.999229>, <-0.038776, 0.006142, 0.999229>, <0.000000, 0.000000, 1.000000> }
triangle { <-0.038776, 0.006142, 0.999229>, <-0.039045, 0.004104, 0.999229>, <-0.078029, 0.008201, 0.996917> }
triangle { <-0.078029, 0.008201, 0.996917>, <-0.077493, 0.012274, 0.996917>, <-0.038776, 0.006142, 0.999229> }
triangle { <-0.077493, 0.012274, 0.996917>, <-0.078029, 0.008201, 0.996917>, <-0.116894, 0.012286, 0.993068> }
triangle { <-0.116894, 0.012286, 0.993068>, <-0.116090, 0.018387, 0.993068>, <-0.077493, 0.012274, 0.996917> }
triangle { <-0.116090, 0.018387, 0.993068>, <-0.116894, 0.012286, 0.993068>, <-0.155578, 0.016352, 0.987688> }
triangle { <-0.155578, 0.016352, 0.987688>, <-0.154508, 0.024472, 0.987688>, <-0.116090, 0.018387, 0.993068> }
triangle { <-0.154508, 0.024472, 0.987688>, <-0.155578, 0.016352, 0.987688>, <-0.194022, 0.020392, 0.980785> }
triangle { <-0.194022, 0.020392, 0.980785>, <-0.192688, 0.030519, 0.980785>, <-0.154508, 0.024472, 0.987688> }
triangle { <-0.192688, 0.030519, 0.980785>, <-0.194022, 0.020392, 0.980785>, <-0.232167, 0.024402, 0.972370> }
triangle { <-0.232167, 0.024402, 0.972370>, <-0.230571, 0.036519, 0.972370>, <-0.192688, 0.030519, 0.980785> }
triangle { <-0.230571, 0.036519, 0.972370>, <-0.232167, 0.024402, 0.972370>, <-0.269953, 0.028373, 0.962455> }
triangle { <-0.269953, 0.028373, 0.962455>, <-0.268099, 0.042463, 0.962455>, <-0.230571, 0.036519, 0.972370> }
triangle { <-0.268099, 0.042463, 0.962455>, <-0.269953, 0.028373, 0.962455>, <-0.307324, 0.032301, 0.951057> }
triangle { <-0.307324, 0.032301, 0.951057>, <-0.305212, 0.048341, 0.951057>, <-0.268099, 0.042463, 0.962455> }
triangle { <-0.305212, 0.048341, 0.951057>, <-0.307324, 0.032301, 0.951057>, <-0.344221, 0.036179, 0.938191> }
triangle { <-0.344221, 0.036179, 0.938191>, <-0.341856, 0.054145, 0.938191>, <-0.305212, 0.048341, 0.951057> }
triangle { <-0.341856, 0.054145, 0.938191>, <-0.344221, 0.036179, 0.938191>, <-0.380587, 0.040001, 0.923880> }
triangle { <-0.380587, 0.040001, 0.923880>, <-0.377972, 0.059865, 0.923880>, <-0.341856, 0.054145, 0.938191> }
triangle { <-0.377972, 0.059865, 0.923880>, <-0.380587, 0.040001, 0.923880>, <-0.416366, 0.043762, 0.908143> }
triangle { <-0.416366, 0.043762, 0.908143>, <-0.413505, 0.065493, 0.908143>, <-0.377972, 0.059865, 0.923880> }
triangle { <-0.413505, 0.065493, 0.908143>, <-0.416366, 0.043762, 0.908143>, <-0.451503, 0.047455, 0.891007> }
triangle { <-0.451503, 0.047455, 0.891007>, <-0.448401, 0.071020, 0.891007>, <-0.413505, 0.065493, 0.908143> }
triangle { <-0.448401, 0.071020, 0.891007>, <-0.451503, 0.047455, 0.891007>, <-0.485945, 0.051075, 0.872496> }
triangle { <-0.485945, 0.051075, 0.872496>, <-0.482606, 0.076437, 0.872496>, <-0.448401, 0.071020, 0.891007> }
triangle { <-0.482606, 0.076437, 0.872496>, <-0.485945, 0.051075, 0.872496>, <-0.519636, 0.054616, 0.852640> }
triangle { <-0.519636, 0.054616, 0.852640>, <-0.516066, 0.081737, 0.852640>, <-0.482606, 0.076437, 0.872496> }
triangle { <-0.516066, 0.081737, 0.852640>, <-0.519636, 0.054616, 0.852640>, <-0.552527, 0.058073, 0.831470> }
triangle { <-0.552527, 0.058073, 0.831470>, <-0.548730, 0.086910, 0.831470>, <-0.516066, 0.081737, 0.852640> }
triangle { <-0.548730, 0.086910, 0.831470>, <-0.552527, 0.058073, 0.831470>, <-0.584565, 0.061440, 0.809017> }
triangle { <-0.584565, 0.061440, 0.809017>, <-0.580549, 0.091950, 0.809017>, <-0.548730, 0.086910, 0.831470> }
triangle { <-0.580549, 0.091950, 0.809017>, <-0.584565, 0.061440, 0.809017>, <-0.615702, 0.064713, 0.785317> }
triangle { <-0.615702, 0.064713, 0.785317>, <-0.611472, 0.096848, 0.785317>, <-0.580549, 0.091950, 0.809017> }
triangle { <-0.611472, 0.096848, 0.785317>, <-0.615702, 0.064713, 0.785317>, <-0.645890, 0.067886, 0.760406> }
triangle { <-0.645890, 0.067886, 0.760406>, <-0.641452, 0.101596, 0.760406>, <-0.611472, 0.096848, 0.785317> }
triangle { <-0.641452, 0.101596, 0.760406>, <-0.645890, 0.067886, 0.760406>, <-0.675082, 0.070954, 0.734323> }
triangle { <-0.675082, 0.070954, 0.734323>, <-0.670444, 0.106188, 0.734323>, <-0.641452, 0.101596, 0.760406> }
triangle { <-0.670444, 0.106188, 0.734323>, <-0.675082, 0.070954, 0.734323>, <-0.703233, 0.073913, 0.707107> }
triangle { <-0.703233, 0.073913, 0.707107>, <-0.698401, 0.110616, 0.707107>, <-0.670444, 0.106188, 0.734323> }
triangle { <-0.698401, 0.110616, 0.707107>, <-0.703233, 0.073913, 0.707107>, <-0.730300, 0.076758, 0.678801> }
triangle { <-0.730300, 0.076758, 0.678801>, <-0.725282, 0.114873, 0.678801>, <-0.698401, 0.110616, 0.707107> }
triangle { <-0.725282, 0.114873, 0.678801>, <-0.730300, 0.076758, 0.678801>, <-0.756240, 0.079484, 0.649448> }
triangle { <-0.756240, 0.079484, 0.649448>, <-0.751044, 0.118954, 0.649448>, <-0.725282, 0.114873, 0.678801> }
triangle { <-0.751044, 0.118954, 0.649448>, <-0.756240, 0.079484, 0.649448>, <-0.781015, 0.082088, 0.619094> }
triangle { <-0.781015, 0.082088, 0.619094>, <-0.775648, 0.122851, 0.619094>, <-0.751044, 0.118954, 0.649448> }
triangle { <-0.775648, 0.122851, 0.619094>, <-0.781015, 0.082088, 0.619094>, <-0.804585, 0.084565, 0.587785> }
triangle { <-0.804585, 0.084565, 0.587785>, <-0.799057, 0.126558, 0.587785>, <-0.775648, 0.122851, 0.619094> }
triangle { <-0.799057, 0.126558, 0.587785>, <-0.804585, 0.084565, 0.587785>, <-0.826915, 0.086912, 0.555570> }
triangle { <-0.826915, 0.086912, 0.555570>, <-0.821233, 0.130071, 0.555570>, <-0.799057, 0.126558, 0.587785> }
triangle { <-0.821233, 0.130071, 0.555570>, <-0.826915, 0.086912, 0.555570>, <-0.847969, 0.089125, 0.522499> }
triangle { <-0.847969, 0.089125, 0.522499>, <-0.842143, 0.133382, 0.522499>, <-0.821233, 0.130071, 0.555570> }
triangle { <-0.842143, 0.133382, 0.522499>, <-0.847969, 0.089125, 0.522499>, <-0.867716, 0.091201, 0.488621> }
triangle { <-0.867716, 0.091201, 0.488621>, <-0.861754, 0.136488, 0.488621>, <-0.842143, 0.133382, 0.522499> }
triangle { <-0.861754, 0.136488, 0.488621>, <-0.867716, 0.091201, 0.488621>, <-0.886125, 0.093136, 0.453990> }
triangle { <-0.886125, 0.093136, 0.453990>, <-0.880037, 0.139384, 0.453990>, <-0.861754, 0.136488, 0.488621> }
triangle { <-0.880037, 0.139384, 0.453990>, <-0.886125, 0.093136, 0.453990>, <-0.903168, 0.094927, 0.418660> }
triangle { <-0.903168, 0.094927, 0.418660>, <-0.896962, 0.142065, 0.418660>, <-0.880037, 0.139384, 0.453990> }
triangle { <-0.896962, 0.142065, 0.418660>, <-0.903168, 0.094927, 0.418660>, <-0.918818, 0.096572, 0.382683> }
triangle { <-0.918818, 0.096572, 0.382683>, <-0.912505, 0.144527, 0.382683>, <-0.896962, 0.142065, 0.418660> }
triangle { <-0.912505, 0.144527, 0.382683>, <-0.918818, 0.096572, 0.382683>, <-0.933052, 0.098068, 0.346117> }
triangle { <-0.933052, 0.098068, 0.346117>, <-0.926641, 0.146765, 0.346117>, <-0.912505, 0.144527, 0.382683> }
triangle { <-0.926641, 0.146765, 0.346117>, <-0.933052, 0.098068, 0.346117>, <-0.945847, 0.099412, 0.309017> }
triangle { <-0.945847, 0.099412, 0.309017>, <-0.939347, 0.148778, 0.309017>, <-0.926641, 0.146765, 0.346117> }
triangle { <-0.939347, 0.148778, 0.309017>, <-0.945847, 0.099412, 0.309017>, <-0.957183, 0.100604, 0.271440> }
triangle { <-0.957183, 0.100604, 0.271440>, <-0.950606, 0.150561, 0.271440>, <-0.939347, 0.148778, 0.309017> }
triangle { <-0.950606, 0.150561, 0.271440>, <-0.957183, 0.100604, 0.271440>, <-0.967043, 0.101640, 0.233445> }
triangle { <-0.967043, 0.101640, 0.233445>, <-0.960398, 0.152112, 0.233445>, <-0.950606, 0.150561, 0.271440> }
triangle { <-0.960398, 0.152112, 0.233445>, <-0.967043, 0.101640, 0.233445>, <-0.975412, 0.102520, 0.195090> }
triangle { <-0.975412, 0.102520, 0.195090>, <-0.968710, 0.153429, 0.195090>, <-0.960398, 0.152112, 0.233445> }
triangle { <-0.968710, 0.153429, 0.195090>, <-0.975412, 0.102520, 0.195090>, <-0.982278, 0.103242, 0.156434> }
triangle { <-0.982278, 0.103242, 0.156434>, <-0.975528, 0.154508, 0.156434>, <-0.968710, 0.153429, 0.195090> }
triangle { <-0.975528, 0.154508, 0.156434>, <-0.982278, 0.103242, 0.156434>, <-0.987628, 0.103804, 0.117537> }
triangle { <-0.987628, 0.103804, 0.117537>, <-0.980842, 0.155350, 0.117537>, <-0.975528, 0.154508, 0.156434> }
triangle { <-0.980842, 0.155350, 0.117537>, <-0.987628, 0.103804, 0.117537>, <-0.991456, 0.104206, 0.078459> }
triangle { <-0.991456, 0.104206, 0.078459>, <-0.984644, 0.155952, 0.078459>, <-0.980842, 0.155350, 0.117537> }
triangle { <-0.984644, 0.155952, 0.078459>, <-0.991456, 0.104206, 0.078459>, <-0.993755, 0.104448, 0.039260> }
triangle { <-0.993755, 0.104448, 0.039260>, <-0.986927, 0.156314, 0.039260>, <-0.984644, 0.155952, 0.078459> }
triangle { <-0.986927, 0.156314, 0.039260>, <-0.993755, 0.104448, 0.039260>, <-0.994522, 0.104528, -0.000000> }
triangle { <-0.994522, 0.104528, -0.000000>, <-0.987688, 0.156434, -0.000000>, <-0.986927, 0.156314, 0.039260> }
triangle { <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <-0.039206, 0.002055, 0.999229> }
triangle { <-0.039206, 0.002055, 0.999229>, <-0.039045, 0.004104, 0.999229>, <0.000000, 0.000000, 1.000000> }
triangle { <-0.039045, 0.004104, 0.999229>, <-0.039206, 0.002055, 0.999229>, <-0.078352, 0.004106, 0.996917> }
triangle { <-0.078352, 0.004106, 0.996917>, <-0.078029, 0.008201, 0.996917>, <-0.039045, 0.004104, 0.999229> }
triangle { <-0.078029, 0.008201, 0.996917>, <-0.078352, 0.004106, 0.996917>, <-0.117376, 0.006151, 0.993068> }
triangle { <-0.117376, 0.006151, 0.993068>, <-0.116894, 0.012286, 0.993068>, <-0.078029, 0.008201, 0.996917> }
triangle { <-0.116894, 0.012286, 0.993068>, <-0.117376, 0.006151, 0.993068>, <-0.156220, 0.008187, 0.987688> }
triangle { <-0.156220, 0.008187, 0.987688>, <-0.155578, 0.016352, 0.987688>, <-0.116894, 0.012286, 0.993068> }
triangle { <-0.155578, 0.016352, 0.987688>, <-0.156220, 0.008187, 0.987688>, <-0.194823, 0.010210, 0.980785> }
triangle { <-0.194823, 0.010210, 0.980785>, <-0.194022, 0.020392, 0.980785>, <-0.155578, 0.016352, 0.987688> }
triangle { <-0.194022, 0.020392, 0.980785>, <-0.194823, 0.010210, 0.980785>, <-0.233125, 0.012218, 0.972370> }
triangle { <-0.233125, 0.012218, 0.972370>, <-0.232167, 0.024402, 0.972370>, <-0.194022, 0.020392, 0.980785> }
triangle { <-0.232167, 0.024402, 0.972370>, <-0.233125, 0.012218, 0.972370>, <-0.271068, 0.014206, 0.962455> }
triangle { <-0.271068, 0.014206, 0.962455>, <-0.269953, 0.028373, 0.962455>, <-0.232167, 0.024402, 0.972370> }
triangle { <-0.269953, 0.028373, 0.962455>, <-0.271068, 0.014206, 0.962455>, <-0.308593, 0.016173, 0.951057> }
triangle { <-0.308593, 0.016173, 0.951057>, <-0.307324, 0.032301, 0.951057>, <-0.269953, 0.028373, 0.962455> }
triangle { <-0.307324, 0.032301, 0.951057>, <-0.308593, 0.016173, 0.951057>, <-0.345643, 0.018114, 0.938191> }
triangle { <-0.345643, 0.018114, 0.938191>, <-0.344221, 0.036179, 0.938191>, <-0.307324, 0.032301, 0.951057> }
triangle { <-0.344221, 0.036179, 0.938191>, <-0.345643, 0.018114, 0.938191>, <-0.382159, 0.020028, 0.923880> }
triangle { <-0.382159, 0.020028, 0.923880>, <-0.380587, 0.040001, 0.923880>, <-0.344221, 0.036179, 0.938191> }
triangle { <-0.380587, 0.040001, 0.923880>, <-0.382159, 0.020028, 0.923880>, <-0.418086, 0.021911, 0.908143> }
triangle { <-0.418086, 0.021911, 0.908143>, <-0.416366, 0.043762, 0.908143>, <-0.380587, 0.040001, 0.923880> }
triangle { <-0.416366, 0.043762, 0.908143>, <-0.418086, 0.021911, 0.908143>, <-0.453368, 0.023760, 0.891007> }
triangle { <-0.453368, 0.023760, 0.891007>, <-0.451503, 0.047455, 0.891007>, <-0.416366, 0.043762, 0.908143> }
triangle { <-0.451503, 0.047455, 0.891007>, <-0.453368, 0.023760, 0.891007>, <-0.487952, 0.025572, 0.872496> }
triangle { <-0.487952, 0.025572, 0.872496>, <-0.485945, 0.051075, 0.872496>, <-0.451503, 0.047455, 0.891007> }
triangle { <-0.485945, 0.051075, 0.872496>, <-0.487952, 0.025572, 0.872496>, <-0.521782, 0.027345, 0.852640> }
triangle { <-0.521782, 0.027345, 0.852640>, <-0.519636, 0.054616, 0.852640>, <-0.485945, 0.051075, 0.872496> }
triangle { <-0.519636, 0.054616, 0.852640>, <-0.521782, 0.027345, 0.852640>, <-0.554809, 0.029076, 0.831470> }
triangle { <-0.554809, 0.029076, 0.831470>, <-0.552527, 0.058073, 0.831470>, <-0.519636, 0.054616, 0.852640> }
triangle { <-0.552527, 0.058073, 0.831470>, <-0.554809, 0.029076, 0.831470>, <-0.586980, 0.030762, 0.809017> }
triangle { <-0.586980, 0.030762, 0.809017>, <-0.584565, 0.061440, 0.809017>, <-0.552527, 0.058073, 0.831470> }
triangle { <-0.584565, 0.061440, 0.809017>, <-0.586980, 0.030762, 0.809017>, <-0.618246, 0.032401, 0.785317> }
triangle { <-0.618246, 0.032401, 0.785317>, <-0.615702, 0.064713, 0.785317>, <-0.584565, 0.061440, 0.809017> }
triangle { <-0.615702, 0.064713, 0.785317>, <-0.618246, 0.032401, 0.785317>, <-0.648558, 0.033989, 0.760406> }
triangle { <-0.648558, 0.033989, 0.760406>, <-0.645890, 0.067886, 0.760406>, <-0.615702, 0.064713, 0.785317> }
triangle { <-0.645890, 0.067886, 0.760406>, <-0.648558, 0.033989, 0.760406>, <-0.677870, 0.035526, 0.734323> }
triangle { <-0.677870, 0.035526, 0.734323>, <-0.675082, 0.070954, 0.734323>, <-0.645890, 0.067886, 0.760406> }
triangle { <-0.675082, 0.070954, 0.734323>, <-0.677870, 0.035526, 0.734323>, <-0.706138, 0.037007, 0.707107> }
triangle { <-0.706138, 0.037007, 0.707107>, <-0.703233, 0.073913, 0.707107>, <-0.675082, 0.070954, 0.734323> }
triangle { <-0.703233, 0.073913, 0.707107>, <-0.706138, 0.037007, 0.707107>, <-0.733316, 0.038431, 0.678801> }
triangle { <-0.733316, 0.038431, 0.678801>, <-0.730300, 0.076758, 0.678801>, <-0.703233, 0.073913, 0.707107> }
triangle { <-0.730300, 0.076758, 0.678801>, <-0.733316, 0.038431, 0.678801>, <-0.759364, 0.039797, 0.649448> }
triangle { <-0.759364, 0.039797, 0.649448>, <-0.756240, 0.079484, 0.649448>, <-0.730300, 0.076758, 0.678801> }
triangle { <-0.756240, 0.079484, 0.649448>, <-0.759364, 0.039797, 0.649448>, <-0.784241, 0.041100, 0.619094> }
triangle { <-0.784241, 0.041100, 0.619094>, <-0.781015, 0.082088, 0.619094>, <-0.756240, 0.079484, 0.649448> }
triangle { <-0.781015, 0.082088, 0.619094>, <-0.784241, 0.041100, 0.619094>, <-0.807908, 0.042341, 0.587785> }
triangle { <-0.807908, 0.042341, 0.587785>, <-0.804585, 0.084565, 0.587785>, <-0.781015, 0.082088, 0.619094> }
triangle { <-0.804585, 0.084565, 0.587785>, <-0.807908, 0.042341, 0.587785>, <-0.830330, 0.043516, 0.555570> }
triangle { <-0.830330, 0.043516, 0.555570>, <-0.826915, 0.086912, 0.555570>, <-0.804585, 0.084565, 0.587785> }
triangle { <-0.826915, 0.086912, 0.555570>, <-0.830330, 0.043516, 0.555570>, <-0.851472, 0.044624, 0.522499> }
triangle { <-0.851472, 0.044624, 0.522499>, <-0.847969, 0.089125, 0.522499>, <-0.826915, 0.086912, 0.555570> }
triangle { <-0.847969, 0.089125, 0.522499>, <-0.851472, 0.044624, 0.522499>, <-0.871300, 0.045663, 0.488621> }
triangle { <-0.871300, 0.045663, 0.488621>, <-0.867716, 0.091201, 0.488621>, <-0.847969, 0.089125, 0.522499> }
triangle { <-0.867716, 0.091201, 0.488621>, <-0.871300, 0.045663, 0.488621>, <-0.889785, 0.046632, 0.453990> }
triangle { <-0.889785, 0.046632, 0.453990>, <-0.886125, 0.093136, 0.453990>, <-0.867716, 0.091201, 0.488621> }
triangle { <-0.886125, 0.093136, 0.453990>, <-0.889785, 0.046632, 0.453990>, <-0.906899, 0.047529, 0.418660> }
triangle { <-0.906899, 0.047529, 0.418660>, <-0.903168, 0.094927, 0.418660>, <-0.886125, 0.093136, 0.453990> }
triangle { <-0.903168, 0.094927, 0.418660>, <-0.906899, 0.047529, 0.418660>, <-0.922613, 0.048352, 0.382683> }
triangle { <-0.922613, 0.048352, 0.382683>, <-0.918818, 0.096572, 0.382683>, <-0.903168, 0.094927, 0.418660> }
triangle { <-0.918818, 0.096572, 0.382683>, <-0.922613, 0.048352, 0.382683>, <-0.936906, 0.049101, 0.346117> }
triangle { <-0.936906, 0.049101, 0.346117>, <-0.933052, 0.098068, 0.346117>, <-0.918818, 0.096572, 0.382683> }
triangle { <-0.933052, 0.098068, 0.346117>, <-0.936906, 0.049101, 0.346117>, <-0.949753, 0.049774, 0.309017> }
triangle { <-0.949753, 0.049774, 0.309017>, <-0.945847, 0.099412, 0.309017>, <-0.933052, 0.098068, 0.346117> }
triangle { <-0.945847, 0.099412, 0.309017>, <-0.949753, 0.049774, 0.309017>, <-0.961136, 0.050371, 0.271440> }
triangle { <-0.961136, 0.050371, 0.271440>, <-0.957183, 0.100604, 0.271440>, <-0.945847, 0.099412, 0.309017> }
triangle { <-0.957183, 0.100604, 0.271440>, <-0.961136, 0.050371, 0.271440>, <-0.971037, 0.050890, 0.233445> }
triangle { <-0.971037, 0.050890, 0.233445>, <-0.967043, 0.101640, 0.233445>, <-0.957183, 0.100604, 0.271440> }
triangle { <-0.967043, 0.101640, 0.233445>, <-0.971037, 0.050890, 0.233445>, <-0.979441, 0.051330, 0.195090> }
triangle { <-0.979441, 0.051330, 0.195090>, <-0.975412, 0.102520, 0.195090>, <-0.967043, 0.101640, 0.233445> }
triangle { <-0.975412, 0.102520, 0.195090>, <-0.979441, 0.051330, 0.195090>, <-0.986335, 0.051692, 0.156434> }
triangle { <-0.986335, 0.051692, 0.156434>, <-0.982278, 0.103242, 0.156434>, <-0.975412, 0.102520, 0.195090> }
triangle { <-0.982278, 0.103242, 0.156434>, <-0.986335, 0.051692, 0.156434>, <-0.991707, 0.051973, 0.117537> }
triangle { <-0.991707, 0.051973, 0.117537>, <-0.987628, 0.103804, 0.117537>, <-0.982278, 0.103242, 0.156434> }
triangle { <-0.987628, 0.103804, 0.117537>, <-0.991707, 0.051973, 0.117537>, <-0.995551, 0.052175, 0.078459> }
triangle { <-0.995551, 0.052175, 0.078459>, <-0.991456, 0.104206, 0.078459>, <-0.987628, 0.103804, 0.117537> }
triangle { <-0.991456, 0.104206, 0.078459>, <-0.995551, 0.052175, 0.078459>, <-0.997860, 0.052296, 0.039260> }
triangle { <-0.997860, 0.052296, 0.039260>, <-0.993755, 0.104448, 0.039260>, <-0.991456, 0.104206, 0.078459> }
triangle { <-0.993755, 0.104448, 0.039260>, <-0.997860, 0.052296, 0.039260>, <-0.998630, 0.052336, -0.000000> }
triangle { <-0.998630, 0.052336, -0.000000>, <-0.994522, 0.104528, -0.000000>, <-0.993755, 0.104448, 0.039260> }
triangle { <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <-0.039260, -0.000000, 0.999229> }
triangle { <-0.039260, -0.000000, 0.999229>, <-0.039206, 0.002055, 0.999229>, <0.000000, 0.000000, 1.000000> }
triangle { <-0.039206, 0.002055, 0.999229>, <-0.039260, -0.000000, 0.999229>, <-0.078459, -0.000000, 0.996917> }
triangle { <-0.078459, -0.000000, 0.996917>, <-0.078352, 0.004106, 0.996917>, <-0.039206, 0.002055, 0.999229> }
triangle { <-0.078352, 0.004106, 0.996917>, <-0.078459, -0.000000, 0.996917>, <-0.117537, -0.000000, 0.993068> }
triangle { <-0.117537, -0.000000, 0.993068>, <-0.117376, 0.006151, 0.993068>, <-0.078352, 0.004106, 0.996917> }
triangle { <-0.117376, 0.006151, 0.993068>, <-0.117537, -0.000000, 0.993068>, <-0.156434, -0.000000, 0.987688> }
triangle { <-0.156434, -0.000000, 0.987688>, <-0.156220, 0.008187, 0.987688>, <-0.117376, 0.006151, 0.993068> }
triangle { <-0.156220, 0.008187, 0.987688>, <-0.156434, -0.000000, 0.987688>, <-0.195090, -0.000000, 0.980785> }
triangle { <-0.195090, -0.000000, 0.980785>, <-0.194823, 0.010210, 0.980785>, <-0.156220, 0.008187, 0.987688> }
triangle { <-0.194823, 0.010210, 0.980785>, <-0.195090, -0.000000, 0.980785>, <-0.233445, -0.000000, 0.972370> }
triangle { <-0.233445, -0.000000, 0.972370>, <-0.233125, 0.012218, 0.972370>, <-0.194823, 0.010210, 0.980785> }
triangle { <-0.233125, 0.012218, 0.972370>, <-0.233445, -0.000000, 0.972370>, <-0.271440, -0.000000, 0.962455> }
triangle { <-0.271440, -0.000000, 0.962455>, <-0.271068, 0.014206, 0.962455>, <-0.233125, 0.012218, 0.972370> }
triangle { <-0.271068, 0.014206, 0.962455>, <-0.271440, -0.000000, 0.962455>, <-0.309017, -0.000000, 0.951057> }
triangle { <-0.309017, -0.000000, 0.951057>, <-0.308593, 0.016173, 0.951057>, <-0.271068, 0.014206, 0.962455> }
triangle { <-0.308593, 0.016173, 0.951057>, <-0.309017, -0.000000, 0.951057>, <-0.346117, -0.000000, 0.938191> }
triangle { <-0.346117, -0.000000, 0.938191>, <-0.345643, 0.018114, 0.938191>, <-0.308593, 0.016173, 0.951057> }
triangle { <-0.345643, 0.018114, 0.938191>, <-0.346117, -0.000000, 0.938191>, <-0.382683, -0.000000, 0.923880> }
triangle { <-0.382683, -0.000000, 0.923880>, <-0.382159, 0.020028, 0.923880>, <-0.345643, 0.018114, 0.938191> }
triangle { <-0.382159, 0.020028, 0.923880>, <-0.382683, -0.000000, 0.923880>, <-0.418660, -0.000000, 0.908143> }
triangle { <-0.418660, -0.000000, 0.908143>, <-0.418086, 0.021911, 0.908143>, <-0.382159, 0.020028, 0.923880> }
triangle { <-0.418086, 0.021911, 0.908143>, <-0.418660, -0.000000, 0.908143>, <-0.453990, -0.000000, 0.891007> }
triangle { <-0.453990, -0.000000, 0.891007>, <-0.453368, 0.023760, 0.891007>, <-0.418086, 0.021911, 0.908143> }
triangle { <-0.453368, 0.023760, 0.891007>, <-0.453990, -0.000000, 0.891007>, <-0.488621, -0.000000, 0.872496> }
triangle { <-0.488621, -0.000000, 0.872496>, <-0.487952, 0.025572, 0.872496>, <-0.453368, 0.023760, 0.891007> }
triangle { <-0.487952, 0.025572, 0.872496>, <-0.488621, -0.000000, 0.872496>, <-0.522499, -0.000000, 0.852640> }
triangle { <-0.522499, -0.000000, 0.852640>, <-0.521782, 0.027345, 0.852640>, <-0.487952, 0.025572, 0.872496> }
triangle { <-0.521782, 0.027345, 0.852640>, <-0.522499, -0.000000, 0.852640>, <-0.555570, -0.000000, 0.831470> }
triangle { <-0.555570, -0.000000, 0.831470>, <-0.554809, 0.029076, 0.831470>, <-0.521782, 0.027345, 0.852640> }
triangle { <-0.554809, 0.029076, 0.831470>, <-0.555570, -0.000000, 0.831470>, <-0.587785, -0.000000, 0.809017> }
triangle { <-0.587785, -0.000000, 0.809017>, <-0.586980, 0.030762, 0.809017>, <-0.554809, 0.029076, 0.831470> }
triangle { <-0.586980, 0.030762, 0.809017>, <-0.587785, -0.000000, 0.809017>, <-0.619094, -0.000000, 0.785317> }
triangle { <-0.619094, -0.000000, 0.785317>, <-0.618246, 0.032401, 0.785317>, <-0.586980, 0.030762, 0.809017> }
triangle { <-0.618246, 0.032401, 0.785317>, <-0.619094, -0.000000, 0.785317>, <-0.649448, -0.000000, 0.760406> }
triangle { <-0.649448, -0.000000, 0.760406>, <-0.648558, 0.033989, 0.760406>, <-0.618246, 0.032401, 0.785317> }
triangle { <-0.648558, 0.033989, 0.760406>, <-0.649448, -0.000000, 0.760406>, <-0.678801, -0.000000, 0.734323> }
triangle { <-0.678801, -0.000000, 0.734323>, <-0.677870, 0.035526, 0.734323>, <-0.648558, 0.033989, 0.760406> }
triangle { <-0.677870, 0.035526, 0.734323>, <-0.678801, -0.000000, 0.734323>, <-0.707107, -0.000000, 0.707107> }
triangle { <-0.707107, -0.000000, 0.707107>, <-0.706138, 0.037007, 0.707107>, <-0.677870, 0.035526, 0.734323> }
triangle { <-0.706138, 0.037007, 0.707107>, <-0.707107, -0.000000, 0.707107>, <-0.734323, -0.000000, 0.678801> }
triangle { <-0.734323, -0.000000, 0.678801>, <-0.733316, 0.038431, 0.678801>, <-0.706138, 0.037007, 0.707107> }
triangle { <-0.733316, 0.038431, 0.678801>, <-0.734323, -0.000000, 0.678801>, <-0.760406, -0.000000, 0.649448> }
triangle { <-0.760406, -0.000000, 0.649448>, <-0.759364, 0.039797, 0.649448>, <-0.733316, 0.038431, 0.678801> }
triangle { <-0.759364, 0.039797, 0.649448>, <-0.760406, -0.000000, 0.649448>, <-0.785317, -0.000000, 0.619094> }
triangle { <-0.785317, -0.000000, 0.619094>, <-0.784241, 0.041100, 0.619094>, <-0.759364, 0.039797, 0.649448> }
triangle { <-0.784241, 0.041100, 0.619094>, <-0.785317, -0.000000, 0.619094>, <-0.809017, -0.000000, 0.587785> }
triangle { <-0.809017, -0.000000, 0.587785>, <-0.807908, 0.042341, 0.587785>, <-0.784241, 0.041100, 0.619094> }
triangle { <-0.807908, 0.042341, 0.587785>, <-0.809017, -0.000000, 0.587785>, <-0.831470, -0.000000, 0.555570> }
triangle { <-0.831470, -0.000000, 0.555570>, <-0.830330, 0.043516, 0.555570>, <-0.807908, 0.042341, 0.587785> }
triangle { <-0.830330, 0.043516, 0.555570>, <-0.831470, -0.000000, 0.555570>, <-0.852640, -0.000000, 0.522499> }
triangle { <-0.852640, -0.000000, 0.522499>, <-0.851472, 0.044624, 0.522499>, <-0.830330, 0.043516, 0.555570> }
triangle { <-0.851472, 0.044624, 0.522499>, <-0.852640, -0.000000, 0.522499>, <-0.872496, -0.000000, 0.488621> }
triangle { <-0.872496, -0.000000, 0.488621>, <-0.871300, 0.045663, 0.488621>, <-0.851472, 0.044624, 0.522499> }
triangle { <-0.871300, 0.045663, 0.488621>, <-0.872496, -0.000000, 0.488621>, <-0.891007, -0.000000, 0.453990> }
triangle { <-0.891007, -0.000000, 0.453990>, <-0.889785, 0.046632, 0.453990>, <-0.871300, 0.045663, 0.488621> }
triangle { <-0.889785, 0.046632, 0.453990>, <-0.891007, -0.000000, 0.453990>, <-0.908143, -0.000000, 0.418660> }
triangle { <-0.908143, -0.000000, 0.418660>, <-0.906899, 0.047529, 0.418660>, <-0.889785, 0.046632, 0.453990> }
triangle { <-0.906899, 0.047529, 0.418660>, <-0.908143, -0.000000, 0.418660>, <-0.923880, -0.000000, 0.382683> }
triangle { <-0.923880, -0.000000, 0.382683>, <-0.922613, 0.048352, 0.382683>, <-0.906899, 0.047529, 0.418660> }
triangle { <-0.922613, 0.048352, 0.382683>, <-0.923880, -0.000000, 0.382683>, <-0.938191, -0.000000, 0.346117> }
triangle { <-0.938191, -0.000000, 0.346117>, <-0.936906, 0.049101, 0.346117>, <-0.922613, 0.048352, 0.382683> }
triangle { <-0.936906, 0.049101, 0.346117>, <-0.938191, -0.000000, 0.346117>, <-0.951057, -0.000000, 0.309017> }
triangle { <-0.951057, -0.000000, 0.309017>, <-0.949753, 0.049774, 0.309017>, <-0.936906, 0.049101, 0.346117> }
triangle { <-0.949753, 0.049774, 0.309017>, <-0.951057, -0.000000, 0.309017>, <-0.962455, -0.000000, 0.271440> }
triangle { <-0.962455, -0.000000, 0.271440>, <-0.961136, 0.050371, 0.271440>, <-0.949753, 0.049774, 0.309017> }
triangle { <-0.961136, 0.050371, 0.271440>, <-0.962455, -0.000000, 0.271440>, <-0.972370, -0.000000, 0.233445> }
triangle { <-0.972370, -0.000000, 0.233445>, <-0.971037, 0.050890, 0.233445>, <-0.961136, 0.050371, 0.271440> }
triangle { <-0.971037, 0.050890, 0.233445>, <-0.972370, -0.000000, 0.233445>, <-0.980785, -0.000000, 0.195090> }
triangle { <-0.980785, -0.000000, 0.195090>, <-0.979441, 0.051330, 0.195090>, <-0.971037, 0.050890, 0.233445> }
triangle { <-0.979441, 0.051330, 0.195090>, <-0.980785, -0.000000, 0.195090>, <-0.987688, -0.000000, 0.156434> }
triangle { <-0.987688, -0.000000, 0.156434>, <-0.986335, 0.051692, 0.156434>, <-0.979441, 0.051330, 0.195090> }
triangle { <-0.986335, 0.051692, 0.156434>, <-0.987688, -0.000000, 0.156434>, <-0.993068, -0.000000, 0.117537> }
triangle { <-0.993068, -0.000000, 0.117537>, <-0.991707, 0.051973, 0.117537>, <-0.986335, 0.051692, 0.156434> }
triangle { <-0.991707, 0.051973, 0.117537>, <-0.993068, -0.000000, 0.117537>, <-0.996917, -0.000000, 0.078459> }
triangle { <-0.996917, -0.000000, 0.078459>, <-0.995551, 0.052175, 0.078459>, <-0.991707, 0.051973, 0.117537> }
triangle { <-0.995551, 0.052175, 0.078459>, <-0.996917, -0.000000, 0.078459>, <-0.999229, -0.000000, 0.039260> }
triangle { <-0.999229, -0.000000, 0.039260>, <-0.997860, 0.052296, 0.039260>, <-0.995551, 0.052175, 0.078459> }
triangle { <-0.997860, 0.052296, 0.039260>, <-0.999229, -0.000000, 0.039260>, <-1.000000, -0.000000, -0.000000> }
triangle { <-1.000000, -0.000000, -0.000000>, <-0.998630, 0.052336, -0.000000>, <-0.997860, 0.052296, 0.039260> }
triangle { <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <-0.039206, -0.002055, 0.999229> }
triangle { <-0.039206, -0.002055, 0.999229>, <-0.039260, -0.000000, 0.999229>, <0.000000, 0.000000, 1.000000> }
triangle { <-0.039260, -0.000000, 0.999229>, <-0.039206, -0.002055, 0.999229>, <-0.078352, -0.004106, 0.996917> }
triangle { <-0.078352, -0.004106, 0.996917>, <-0.078459, -0.000000, 0.996917>, <-0.039260, -0.000000, 0.999229> }
triangle { <-0.078459, -0.000000, 0.996917>, <-0.078352, -0.004106, 0.996917>, <-0.117376, -0.006151, 0.993068> }
triangle { <-0.117376, -0.006151, 0.993068>, <-0.117537, -0.000000, 0.993068>, <-0.078459, -0.000000, 0.996917> }
triangle { <-0.117537, -0.000000, 0.993068>, <-0.117376, -0.006151, 0.993068>, <-0.156220, -0.008187, 0.987688> }
triangle { <-0.156220, -0.008187, 0.987688>, <-0.156434, -0.000000, 0.987688>, <-0.117537, -0.000000, 0.993068> }
triangle { <-0.156434, -0.000000, 0.987688>, <-0.156220, -0.008187, 0.987688>, <-0.194823, -0.010210, 0.980785> }
triangle { <-0.194823, -0.010210, 0.980785>, <-0.195090, -0.000000, 0.980785>, <-0.156434, -0.000000, 0.987688> }
triangle { <-0.195090, -0.000000, 0.980785>, <-0.194823, -0.010210, 0.980785>, <-0.233125, -0.012218, 0.972370> }
triangle { <-0.233125, -0.012218, 0.972370>, <-0.233445, -0.000000, 0.972370>, <-0.195090, -0.000000, 0.980785> }
triangle { <-0.233445, -0.000000, 0.972370>, <-0.233125, -0.012218, 0.972370>, <-0.271068, -0.014206, 0.962455> }
triangle { <-0.271068, -0.014206, 0.962455>, <-0.271440, -0.000000, 0.962455>, <-0.233445, -0.000000, 0.972370> }
triangle { <-0.271440, -0.000000, 0.962455>, <-0.271068, -0.014206, 0.962455>, <-0.308593, -0.016173, 0.951057> }
triangle { <-0.308593, -0.016173, 0.951057>, <-0.309017, -0.000000, 0.951057>, <-0.271440, -0.000000, 0.962455> }
triangle { <-0.309017, -0.000000, 0.951057>, <-0.308593, -0.016173, 0.951057>, <-0.345643, -0.018114, 0.938191> }
triangle { <-0.345643, -0.018114, 0.938191>, <-0.346117, -0.000000, 0.938191>, <-0.309017, -0.000000, 0.951057> }
triangle { <-0.346117, -0.000000, 0.938191>, <-0.345643, -0.018114, 0.938191>, <-0.382159, -0.020028, 0.923880> }
triangle { <-0.382159, -0.020028, 0.923880>, <-0.382683, -0.000000, 0.923880>, <-0.346117, -0.000000, 0.938191> }
triangle { <-0.382683, -0.000000, 0.923880>, <-0.382159, -0.020028, 0.923880>, <-0.418086, -0.021911, 0.908143> }
triangle { <-0.418086, -0.021911, 0.908143>, <-0.418660, -0.000000, 0.908143>, <-0.382683, -0.000000, 0.923880> }
triangle { <-0.418660, -0.000000, 0.908143>, <-0.418086, -0.021911, 0.908143>, <-0.453368, -0.023760, 0.891007> }
triangle { <-0.453368, -0.023760, 0.891007>, <-0.453990, -0.000000, 0.891007>, <-0.418660, -0.000000, 0.908143> }
triangle { <-0.453990, -0.000000, 0.891007>, <-0.453368, -0.023760, 0.891007>, <-0.487952, -0.025572, 0.872496> }
triangle { <-0.487952, -0.025572, 0.872496>, <-0.488621, -0.000000, 0.872496>, <-0.453990, -0.000000, 0.891007> }
triangle { <-0.488621, -0.000000, 0.872496>, <-0.487952, -0.025572, 0.872496>, <-0.521782, -0.027345, 0.852640> }
triangle { <-0.521782, -0.027345, 0.852640>, <-0.522499, -0.000000, 0.852640>, <-0.488621, -0.000000, 0.872496> }
triangle { <-0.522499, -0.000000, 0.852640>, <-0.521782, -0.027345, 0.852640>, <-0.554809, -0.029076, 0.831470> }
triangle { <-0.554809, -0.029076, 0.831470>, <-0.555570, -0.000000, 0.831470>, <-0.522499, -0.000000, 0.852640> }
triangle { <-0.555570, -0.000000, 0.831470>, <-0.554809, -0.029076, 0.831470>, <-0.586980, -0.030762, 0.809017> }
triangle { <-0.586980, -0.030762, 0.809017>, <-0.587785, -0.000000, 0.809017>, <-0.555570, -0.000000, 0.831470> }
triangle { <-0.587785, -0.000000, 0.809017>, <-0.586980, -0.030762, 0.809017>, <-0.618246, -0.032401, 0.785317> }
triangle { <-0.618246, -0.032401, 0.785317>, <-0.619094, -0.000000, 0.785317>, <-0.587785, -0.000000, 0.809017> }
triangle { <-0.619094, -0.000000, 0.785317>, <-0.618246, -0.032401, 0.785317>, <-0.648558, -0.033989, 0.760406> }
triangle { <-0.648558, -0.033989, 0.760406>, <-0.649448, -0.000000, 0.760406>, <-0.619094, -0.000000, 0.785317> }
triangle { <-0.649448, -0.000000, 0.760406>, <-0.648558, -0.033989, 0.760406>, <-0.677870, -0.035526, 0.734323> }
triangle { <-0.677870, -0.035526, 0.734323>, <-0.678801, -0.000000, 0.734323>, <-0.649448, -0.000000, 0.760406> }
triangle { <-0.678801, -0.000000, 0.734323>, <-0.677870, -0.035526, 0.734323>, <-0.706138, -0.037007, 0.707107> }
triangle { <-0.706138, -0.037007, 0.707107>, <-0.707107, -0.000000, 0.707107>, <-0.678801, -0.000000, 0.734323> }
triangle { <-0.707107, -0.000000, 0.707107>, <-0.706138, -0.037007, 0.707107>, <-0.733316, -0.038431, 0.678801> }
triangle { <-0.733316, -0.038431, 0.678801>, <-0.734323, -0.000000, 0.678801>, <-0.707107, -0.000000, 0.707107> }
triangle { <-0.734323, -0.000000, 0.678801>, <-0.733316, -0.038431, 0.678801>, <-0.759364, -0.039797, 0.649448> }
triangle { <-0.759364, -0.039797, 0.649448>, <-0.760406, -0.000000, 0.649448>, <-0.734323, -0.000000, 0.678801> }
triangle { <-0.760406, -0.000000, 0.649448>, <-0.759364, -0.039797, 0.649448>, <-0.784241, -0.041100, 0.619094> }
triangle { <-0.784241, -0.041100, 0.619094>, <-0.785317, -0.000000, 0.619094>, <-0.760406, -0.000000, 0.649448> }
triangle { <-0.785317, -0.000000, 0.619094>, <-0.784241, -0.041100, 0.619094>, <-0.807908, -0.042341, 0.587785> }
triangle { <-0.807908, -0.042341, 0.587785>, <-0.809017, -0.000000, 0.587785>, <-0.785317, -0.000000, 0.619094> }
triangle { <-0.809017, -0.000000, 0.587785>, <-0.807908, -0.042341, 0.587785>, <-0.830330, -0.043516, 0.555570> }
triangle { <-0.830330, -0.043516, 0.555570>, <-0.831470, -0.000000, 0.555570>, <-0.809017, -0.000000, 0.587785> }
triangle { <-0.831470, -0.000000, 0.555570>, <-0.830330, -0.043516, 0.555570>, <-0.851472, -0.044624, 0.522499> }
triangle { <-0.851472, -0.044624, 0.522499>, <-0.852640, -0.000000, 0.522499>, <-0.831470, -0.000000, 0.555570> }
triangle { <-0.852640, -0.000000, 0.522499>, <-0.851472, -0.044624, 0.522499>, <-0.871300, -0.045663, 0.488621> }
triangle { <-0.871300, -0.045663, 0.488621>, <-0.872496, -0.000000, 0.488621>, <-0.852640, -0.000000, 0.522499> }
triangle { <-0.872496, -0.000000, 0.488621>, <-0.871300, -0.045663, 0.488621>, <-0.889785, -0.046632, 0.453990> }
triangle { <-0.889785, -0.046632, 0.453990>, <-0.891007, -0.000000, 0.453990>, <-0.872496, -0.000000, 0.488621> }
triangle { <-0.891007, -0.000000, 0.453990>, <-0.889785, -0.046632, 0.453990>, <-0.906899, -0.047529, 0.418660> }
triangle { <-0.906899, -0.047529, 0.418660>, <-0.908143, -0.000000, 0.418660>, <-0.891007, -0.000000, 0.453990> }
triangle { <-0.908143, -0.000000, 0.418660>, <-0.906899, -0.047529, 0.418660>, <-0.922613, -0.048352, 0.382683> }
triangle { <-0.922613, -0.048352, 0.382683>, <-0.923880, -0.000000, 0.382683>, <-0.908143, -0.000000, 0.418660> }
triangle { <-0.923880, -0.000000, 0.382683>, <-0.922613, -0.048352, 0.382683>, <-0.936906, -0.049101, 0.346117> }
triangle { <-0.936906, -0.049101, 0.346117>, <-0.938191, -0.000000, 0.346117>, <-0.923880, -0.000000, 0.382683> }
triangle { <-0.938191, -0.000000, 0.346117>, <-0.936906, -0.049101, 0.346117>, <-0.949753, -0.049774, 0.309017> }
triangle { <-0.949753, -0.049774, 0.309017>, <-0.951057, -0.000000, 0.309017>, <-0.938191, -0.000000, 0.346117> }
triangle { <-0.951057, -0.000000, 0.309017>, <-0.949753, -0.049774, 0.309017>, <-0.961136, -0.050371, 0.271440> }
triangle { <-0.961136, -0.050371, 0.271440>, <-0.962455, -0.000000, 0.271440>, <-0.951057, -0.000000, 0.309017> }
triangle { <-0.962455, -0.000000, 0.271440>, <-0.961136, -0.050371, 0.271440>, <-0.971037, -0.050890, 0.233445> }
triangle { <-0.971037, -0.050890, 0.233445>, <-0.972370, -0.000000, 0.233445>, <-0.962455, -0.000000, 0.271440> }
triangle { <-0.972370, -0.000000, 0.233445>, <-0.971037, -0.050890, 0.233445>, <-0.979441, -0.051330, 0.195090> }
triangle { <-0.979441, -0.051330, 0.195090>, <-0.980785, -0.000000, 0.195090>, <-0.972370, -0.000000, 0.233445> }
triangle { <-0.980785, -0.000000, 0.195090>, <-0.979441, -0.051330, 0.195090>, <-0.986335, -0.051692, 0.156434> }
triangle { <-0.986335, -0.051692, 0.156434>, <-0.987688, -0.000000, 0.156434>, <-0.980785, -0.000000, 0.195090> }
triangle { <-0.987688, -0.000000, 0.156434>, <-0.986335, -0.051692, 0.156434>, <-0.991707, -0.051973, 0.117537> }
triangle { <-0.991707, -0.051973, 0.117537>, <-0.993068, -0.000000, 0.117537>, <-0.987688, -0.000000, 0.156434> }
triangle { <-0.993068, -0.000000, 0.117537>, <-0.991707, -0.051973, 0.117537>, <-0.995551, -0.052175, 0.078459> }
triangle { <-0.995551, -0.052175, 0.078459>, <-0.996917, -0.000000, 0.078459>, <-0.993068, -0.000000, 0.117537> }
triangle { <-0.996917, -0.000000, 0.078459>, <-0.995551, -0.052175, 0.078459>, <-0.997860, -0.052296, 0.039260> }
triangle { <-0.997860, -0.052296, 0.039260>, <-0.999229, -0.000000, 0.039260>, <-0.996917, -0.000000, 0.078459> }
triangle { <-0.999229, -0.000000, 0.039260>, <-0.997860, -0.052296, 0.039260>, <-0.998630, -0.052336, -0.000000> }
triangle { <-0.998630, -0.052336, -0.000000>, <-1.000000, -0.000000, -0.000000>, <-0.999229, -0.000000, 0.039260> }
triangle { <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <-0.039045, -0.004104, 0.999229> }
triangle { <-0.039045, -0.004104, 0.999229>, <-0.039206, -0.002055, 0.999229>, <0.000000, 0.000000, 1.000000> }
triangle { <-0.039206, -0.002055, 0.999229>, <-0.039045, -0.004104, 0.999229>, <-0.078029, -0.008201, 0.996917> }
triangle { <-0.078029, -0.008201, 0.996917>, <-0.078352, -0.004106, 0.996917>, <-0.039206, -0.002055, 0.999229> }
triangle { <-0.078352, -0.004106, 0.996917>, <-0.078029, -0.008201, 0.996917>, <-0.116894, -0.012286, 0.993068> }
triangle { <-0.116894, -0.012286, 0.993068>, <-0.117376, -0.006151, 0.993068>, <-0.078352, -0.004106, 0.996917> }
triangle { <-0.117376, -0.006151, 0.993068>, <-0.116894, -0.012286, 0.993068>, <-0.155578, -0.016352, 0.987688> }
triangle { <-0.155578, -0.016352, 0.987688>, <-0.156220, -0.008187, 0.987688>, <-0.117376, -0.006151, 0.993068> }
triangle { <-0.156220, -0.008187, 0.987688>, <-0.155578, -0.016352, 0.987688>, <-0.194022, -0.020392, 0.980785> }
triangle { <-0.194022, -0.020392, 0.980785>, <-0.194823, -0.010210, 0.980785>, <-0.156220, -0.008187, 0.987688> }
triangle { <-0.194823, -0.010210, 0.980785>, <-0.194022, -0.020392, 0.980785>, <-0.232167, -0.024402, 0.972370> }
triangle { <-0.232167, -0.024402, 0.972370>, <-0.233125, -0.012218, 0.972370>, <-0.194823, -0.010210, 0.980785> }
triangle { <-0.233125, -0.012218, 0.972370>, <-0.232167, -0.024402, 0.972370>, <-0.269953, -0.028373, 0.962455> }
triangle { <-0.269953, -0.028373, 0.962455>, <-0.271068, -0.014206, 0.962455>, <-0.233125, -0.012218, 0.972370> }
triangle { <-0.271068, -0.014206, 0.962455>, <-0.269953, -0.028373, 0.962455>, <-0.307324, -0.032301, 0.951057> }
triangle { <-0.307324, -0.032301, 0.951057>, <-0.308593, -0.016173, 0.951057>, <-0.271068, -0.014206, 0.962455> }
triangle { <-0.308593, -0.016173, 0.951057>, <-0.307324, -0.032301, 0.951057>, <-0.344221, -0.036179, 0.938191> }
triangle { <-0.344221, -0.036179, 0.938191>, <-0.345643, -0.018114, 0.938191>, <-0.308593, -0.016173, 0.951057> }
triangle { <-0.345643, -0.018114, 0.938191>, <-0.344221, -0.036179, 0.938191>, <-0.380587, -0.040001, 0.923880> }
triangle { <-0.380587, -0.040001, 0.923880>, <-0.382159, -0.020028, 0.923880>, <-0.345643, -0.018114, 0.938191> }
triangle { <-0.382159, -0.020028, 0.923880>, <-0.380587, -0.040001, 0.923880>, <-0.416366, -0.043762, 0.908143> }
triangle { <-0.416366, -0.043762, 0.908143>, <-0.418086, -0.021911, 0.908143>, <-0.382159, -0.020028, 0.923880> }
triangle { <-0.418086, -0.021911, 0.908143>, <-0.416366, -0.043762, 0.908143>, <-0.451503, -0.047455, 0.891007> }
triangle { <-0.451503, -0.047455, 0.891007>, <-0.453368, -0.023760, 0.891007>, <-0.418086, -0.021911, 0.908143> }
triangle { <-0.453368, -0.023760, 0.891007>, <-0.451503, -0.047455, 0.891007>, <-0.485945, -0.051075, 0.872496> }
triangle { <-0.485945, -0.051075, 0.872496>, <-0.487952, -0.025572, 0.872496>, <-0.453368, -0.023760, 0.891007> }
triangle { <-0.487952, -0.025572, 0.872496>, <-0.485945, -0.051075, 0.872496>, <-0.519636, -0.054616, 0.852640> }
triangle { <-0.519636, -0.054616, 0.852640>, <-0.521782, -0.027345, 0.852640>, <-0.487952, -0.025572, 0.872496> }
triangle { <-0.521782, -0.027345, 0.852640>, <-0.519636, -0.054616, 0.852640>, <-0.552527, -0.058073, 0.831470> }
triangle { <-0.552527, -0.058073, 0.831470>, <-0.554809, -0.029076, 0.831470>, <-0.521782, -0.027345, 0.852640> }
triangle { <-0.554809, -0.029076, 0.831470>, <-0.552527, -0.058073, 0.831470>, <-0.584565, -0.061440, 0.809017> }
triangle { <-0.584565, -0.061440, 0.809017>, <-0.586980, -0.030762, 0.809017>, <-0.554809, -0.029076, 0.831470> }
triangle { <-0.586980, -0.030762, 0.809017>, <-0.584565, -0.061440, 0.809017>, <-0.615702, -0.064713, 0.785317> }
triangle { <-0.615702, -0.064713, 0.785317>, <-0.618246, -0.032401, 0.785317>, <-0.586980, -0.030762, 0.809017> }
triangle { <-0.618246, -0.032401, 0.785317>, <-0.615702, -0.064713, 0.785317>, <-0.645890, -0.067886, 0.760406> }
triangle { <-0.645890, -0.067886, 0.760406>, <-0.648558, -0.033989, 0.760406>, <-0.618246, -0.032401, 0.785317> }
triangle { <-0.648558, -0.033989, 0.760406>, <-0.645890, -0.067886, 0.760406>, <-0.675082, -0.070954, 0.734323> }
triangle { <-0.675082, -0.070954, 0.734323>, <-0.677870, -0.035526, 0.734323>, <-0.648558, -0.033989, 0.760406> }
triangle { <-0.677870, -0.035526, 0.734323>, <-0.675082, -0.070954, 0.734323>, <-0.703233, -0.073913, 0.707107> }
triangle { <-0.703233, -0.073913, 0.707107>, <-0.706138, -0.037007, 0.707107>, <-0.677870, -0.035526, 0.734323> }
triangle { <-0.706138, -0.037007, 0.707107>, <-0.703233, -0.073913, 0.707107>, <-0.730300, -0.076758, 0.678801> }
triangle { <-0.730300, -0.076758, 0.678801>, <-0.733316, -0.038431, 0.678801>, <-0.706138, -0.037007, 0.707107> }
triangle { <-0.733316, -0.038431, 0.678801>, <-0.730300, -0.076758, 0.678801>, <-0.756240, -0.079484, 0.649448> }
triangle { <-0.756240, -0.079484, 0.649448>, <-0.759364, -0.039797, 0.649448>, <-0.733316, -0.038431, 0.678801> }
triangle { <-0.759364, -0.039797, 0.649448>, <-0.756240, -0.079484, 0.649448>, <-0.781015, -0.082088, 0.619094> }
triangle { <-0.781015, -0.082088, 0.619094>, <-0.784241, -0.041100, 0.619094>, <-0.759364, -0.039797, 0.649448> }
triangle { <-0.784241, -0.041100, 0.619094>, <-0.781015, -0.082088, 0.619094>, <-0.804585, -0.084565, 0.587785> }
triangle { <-0.804585, -0.084565, 0.587785>, <-0.807908, -0.042341, 0.587785>, <-0.784241, -0.041100, 0.619094> }
triangle { <-0.807908, -0.042341, 0.587785>, <-0.804585, -0.084565, 0.587785>, <-0.826915, -0.086912, 0.555570> }
triangle { <-0.826915, -0.086912, 0.555570>, <-0.830330, -0.043516, 0.555570>, <-0.807908, -0.042341, 0.587785> }
triangle { <-0.830330, -0.043516, 0.555570>, <-0.826915, -0.086912, 0.555570>, <-0.847969, -0.089125, 0.522499> }
triangle { <-0.847969, -0.089125, 0.522499>, <-0.851472, -0.044624, 0.522499>, <-0.830330, -0.043516, 0.555570> }
triangle { <-0.851472, -0.044624, 0.522499>, <-0.847969, -0.089125, 0.522499>, <-0.867716, -0.091201, 0.488621> }
triangle { <-0.867716, -0.091201, 0.488621>, <-0.871300, -0.045663, 0.488621>, <-0.851472, -0.044624, 0.522499> }
triangle { <-0.871300, -0.045663, 0.488621>, <-0.867716, -0.091201, 0.488621>, <-0.886125, -0.093136, 0.453990> }
triangle { <-0.886125, -0.093136, 0.453990>, <-0.889785, -0.046632, 0.453990>, <-0.871300, -0.045663, 0.488621> }
triangle { <-0.889785, -0.046632, 0.453990>, <-0.886125, -0.093136, 0.453990>, <-0.903168, -0.094927, 0.418660> }
triangle { <-0.903168, -0.094927, 0.418660>, <-0.906899, -0.047529, 0.418660>, <-0.889785, -0.046632, 0.453990> }
triangle { <-0.906899, -0.047529, 0.418660>, <-0.903168, -0.094927, 0.418660>, <-0.918818, -0.096572, 0.382683> }
triangle { <-0.918818, -0.096572, 0.382683>, <-0.922613, -0.048352, 0.382683>, <-0.906899, -0.047529, 0.418660> }
triangle { <-0.922613, -0.048352, 0.382683>, <-0.918818, -0.096572, 0.382683>, <-0.933052, -0.098068, 0.346117> }
triangle { <-0.933052, -0.098068, 0.346117>, <-0.936906, -0.049101, 0.346117>, <-0.922613, -0.048352, 0.382683> }
triangle { <-0.936906, -0.049101, 0.346117>, <-0.933052, -0.098068, 0.346117>, <-0.945847, -0.099412, 0.309017> }
triangle { <-0.945847, -0.099412, 0.309017>, <-0.949753, -0.049774, 0.309017>, <-0.936906, -0.049101, 0.346117> }
triangle { <-0.949753, -0.049774, 0.309017>, <-0.945847, -0.099412, 0.309017>, <-0.957183, -0.100604, 0.271440> }
triangle { <-0.957183, -0.100604, 0.271440>, <-0.961136, -0.050371, 0.271440>, <-0.949753, -0.049774, 0.309017> }
triangle { <-0.961136, -0.050371, 0.271440>, <-0.957183, -0.100604, 0.271440>, <-0.967043, -0.101640, 0.233445> }
triangle { <-0.967043, -0.101640, 0.233445>, <-0.971037, -0.050890, 0.233445>, <-0.961136, -0.050371, 0.271440> }
triangle { <-0.971037, -0.050890, 0.233445>, <-0.967043, -0.101640, 0.233445>, <-0.975412, -0.102520, 0.195090> }
triangle { <-0.975412, -0.102520, 0.195090>, <-0.979441, -0.051330, 0.195090>, <-0.971037, -0.050890, 0.233445> }
triangle { <-0.979441, -0.051330, 0.195090>, <-0.975412, -0.102520, 0.195090>, <-0.982278, -0.103242, 0.156434> }
triangle { <-0.982278, -0.103242, 0.156434>, <-0.986335, -0.051692, 0.156434>, <-0.979441, -0.051330, 0.195090> }
triangle { <-0.986335, -0.051692, 0.156434>, <-0.982278, -0.103242, 0.156434>, <-0.987628, -0.103804, 0.117537> }
triangle { <-0.987628, -0.103804, 0.117537>, <-0.991707, -0.051973, 0.117537>, <-0.986335, -0.051692, 0.156434> }
triangle { <-0.991707, -0.051973, 0.117537>, <-0.987628, -0.103804, 0.117537>, <-0.991456, -0.104206, 0.078459> }
triangle { <-0.991456, -0.104206, 0.078459>, <-0.995551, -0.052175, 0.078459>, <-0.991707, -0.051973, 0.117537> }
triangle { <-0.995551, -0.052175, 0.078459>, <-0.991456, -0.104206, 0.078459>, <-0.993755, -0.104448, 0.039260> }
triangle { <-0.993755, -0.104448, 0.039260>, <-0.997860, -0.052296, 0.039260>, <-0.995551, -0.052175, 0.078459> }
triangle { <-0.997860, -0.052296, 0.039260>, <-0.993755, -0.104448, 0.039260>, <-0.994522, -0.104528, -0.000000> }
triangle { <-0.994522, -0.104528, -0.000000>, <-0.998630, -0.052336, -0.000000>, <-0.997860, -0.052296, 0.039260> }
triangle { <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <-0.038776, -0.006142, 0.999229> }
triangle { <-0.038776, -0.006142, 0.999229>, <-0.039045, -0.004104, 0.999229>, <0.000000, 0.000000, 1.000000> }
triangle { <-0.039045, -0.004104, 0.999229>, <-0.038776, -0.006142, 0.999229>, <-0.077493, -0.012274, 0.996917> }
triangle { <-0.077493, -0.012274, 0.996917>, <-0.078029, -0.008201, 0.996917>, <-0.039045, -0.004104, 0.999229> }
triangle { <-0.078029, -0.008201, 0.996917>, <-0.077493, -0.012274, 0.996917>, <-0.116090, -0.018387, 0.993068> }
triangle { <-0.116090, -0.018387, 0.993068>, <-0.116894, -0.012286, 0.993068>, <-0.078029, -0.008201, 0.996917> }
triangle { <-0.116894, -0.012286, 0.993068>, <-0.116090, -0.018387, 0.993068>, <-0.154508, -0.024472, 0.987688> }
triangle { <-0.154508, -0.024472, 0.987688>, <-0.155578, -0.016352, 0.987688>, <-0.116894, -0.012286, 0.993068> }
triangle { <-0.155578, -0.016352, 0.987688>, <-0.154508, -0.024472, 0.987688>, <-0.192688, -0.030519, 0.980785> }
triangle { <-0.192688, -0.030519, 0.980785>, <-0.194022, -0.020392, 0.980785>, <-0.155578, -0.016352, 0.987688> }
triangle { <-0.194022, -0.020392, 0.980785>, <-0.192688, -0.030519, 0.980785>, <-0.230571, -0.036519, 0.972370> }
triangle { <-0.230571, -0.036519, 0.972370>, <-0.232167, -0.024402, 0.972370>, <-0.194022, -0.020392, 0.980785> }
triangle { <-0.232167, -0.024402, 0.972370>, <-0.230571, -0.036519, 0.972370>, <-0.268099, -0.042463, 0.962455> }
triangle { <-0.268099, -0.042463, 0.962455>, <-0.269953, -0.028373, 0.962455>, <-0.232167, -0.024402, 0.972370> }
triangle { <-0.269953, -0.028373, 0.962455>, <-0.268099, -0.042463, 0.962455>, <-0.305212, -0.048341, 0.951057> }
triangle { <-0.305212, -0.048341, 0.951057>, <-0.307324, -0.032301, 0.951057>, <-0.269953, -0.028373, 0.962455> }
triangle { <-0.307324, -0.032301, 0.951057>, <-0.305212, -0.048341, 0.951057>, <-0.341856, -0.054145, 0.938191> }
triangle { <-0.341856, -0.054145, 0.938191>, <-0.344221, -0.036179, 0.938191>, <-0.307324, -0.032301, 0.951057> }
triangle { <-0.344221, -0.036179, 0.938191>, <-0.341856, -0.054145, 0.938191>, <-0.377972, -0.059865, 0.923880> }
triangle { <-0.377972, -0.059865, 0.923880>, <-0.380587, -0.040001, 0.923880>, <-0.344221, -0.036179, 0.938191> }
triangle { <-0.380587, -0.040001, 0.923880>, <-0.377972, -0.059865, 0.923880>, <-0.413505, -0.065493, 0.908143> }
triangle { <-0.413505, -0.065493, 0.908143>, <-0.416366, -0.043762, 0.908143>, <-0.380587, -0.040001, 0.923880> }
triangle { <-0.416366, -0.043762, 0.908143>, <-0.413505, -0.065493, 0.908143>, <-0.448401, -0.071020, 0.891007> }
triangle { <-0.448401, -0.071020, 0.891007>, <-0.451503, -0.047455, 0.891007>, <-0.416366, -0.043762, 0.908143> }
triangle { <-0.451503, -0.047455, 0.891007>, <-0.448401, -0.071020, 0.891007>, <-0.482606, -0.076437, 0.872496> }
triangle { <-0.482606, -0.076437, 0.872496>, <-0.485945, -0.051075, 0.872496>, <-0.451503, -0.047455, 0.891007> }
triangle { <-0.485945, -0.051075, 0.872496>, <-0.482606, -0.076437, 0.872496>, <-0.516066, -0.081737, 0.852640> }
triangle { <-0.516066, -0.081737, 0.852640>, <-0.519636, -0.054616, 0.852640>, <-0.485945, -0.051075, 0.872496> }
triangle { <-0.519636, -0.054616, 0.852640>, <-0.516066, -0.081737, 0.852640>, <-0.548730, -0.086910, 0.831470> }
triangle { <-0.548730, -0.086910, 0.831470>, <-0.552527, -0.058073, 0.831470>, <-0.519636, -0.054616, 0.852640> }
triangle { <-0.552527, -0.058073, 0.831470>, <-0.548730, -0.086910, 0.831470>, <-0.580549, -0.091950, 0.809017> }
triangle { <-0.580549, -0.091950, 0.809017>, <-0.584565, -0.061440, 0.809017>, <-0.552527, -0.058073, 0.831470> }
triangle { <-0.584565, -0.061440, 0.809017>, <-0.580549, -0.091950, 0.809017>, <-0.611472, -0.096848, 0.785317> }
triangle { <-0.611472, -0.096848, 0.785317>, <-0.615702, -0.064713, 0.785317>, <-0.584565, -0.061440, 0.809017> }
triangle { <-0.615702, -0.064713, 0.785317>, <-0.611472, -0.096848, 0.785317>, <-0.641452, -0.101596, 0.760406> }
triangle { <-0.641452, -0.101596, 0.760406>, <-0.645890, -0.067886, 0.760406>, <-0.615702, -0.064713, 0.785317> }
triangle { <-0.645890, -0.067886, 0.760406>, <-0.641452, -0.101596, 0.760406>, <-0.670444, -0.106188, 0.734323> }
triangle { <-0.670444, -0.106188, 0.734323>, <-0.675082, -0.070954, 0.734323>, <-0.645890, -0.067886, 0.760406> }
triangle { <-0.675082, -0.070954, 0.734323>, <-0.670444, -0.106188, 0.734323>, <-0.698401, -0.110616, 0.707107> }
triangle { <-0.698401, -0.110616, 0.707107>, <-0.703233, -0.073913, 0.707107>, <-0.675082, -0.070954, 0.734323> }
triangle { <-0.703233, -0.073913, 0.707107>, <-0.698401, -0.110616, 0.707107>, <-0.725282, -0.114873, 0.678801> }
triangle { <-0.725282, -0.114873, 0.678801>, <-0.730300, -0.076758, 0.678801>, <-0.703233, -0.073913, 0.707107> }
triangle { <-0.730300, -0.076758, 0.678801>, <-0.725282, -0.114873, 0.678801>, <-0.751044, -0.118954, 0.649448> }
triangle { <-0.751044, -0.118954, 0.649448>, <-0.756240, -0.079484, 0.649448>, <-0.730300, -0.076758, 0.678801> }
triangle { <-0.756240, -0.079484, 0.649448>, <-0.751044, -0.118954, 0.649448>, <-0.775648, -0.122851, 0.619094> }
triangle { <-0.775648, -0.122851, 0.619094>, <-0.781015, -0.082088, 0.619094>, <-0.756240, -0.079484, 0.649448> }
triangle { <-0.781015, -0.082088, 0.619094>, <-0.775648, -0.122851, 0.619094>, <-0.799057, -0.126558, 0.587785> }
triangle { <-0.799057, -0.126558, 0.587785>, <-0.804585, -0.084565, 0.587785>, <-0.781015, -0.082088, 0.619094> }
triangle { <-0.804585, -0.084565, 0.587785>, <-0.799057, -0.126558, 0.587785>, <-0.821233, -0.130071, 0.555570> }
triangle { <-0.821233, -0.130071, 0.555570>, <-0.826915, -0.086912, 0.555570>, <-0.804585, -0.084565, 0.587785> }
triangle { <-0.826915, -0.086912, 0.555570>, <-0.821233, -0.130071, 0.555570>, <-0.842143, -0.133382, 0.522499> }
triangle { <-0.842143, -0.133382, 0.522499>, <-0.847969, -0.089125, 0.522499>, <-0.826915, -0.086912, 0.555570> }
triangle { <-0.847969, -0.089125, 0.522499>, <-0.842143, -0.133382, 0.522499>, <-0.861754, -0.136488, 0.488621> }
triangle { <-0.861754, -0.136488, 0.488621>, <-0.867716, -0.091201, 0.488621>, <-0.847969, -0.089125, 0.522499> }
triangle { <-0.867716, -0.091201, 0.488621>, <-0.861754, -0.136488, 0.488621>, <-0.880037, -0.139384, 0.453990> }
triangle { <-0.880037, -0.139384, 0.453990>, <-0.886125, -0.093136, 0.453990>, <-0.867716, -0.091201, 0.488621> }
triangle { <-0.886125, -0.093136, 0.453990>, <-0.880037, -0.139384, 0.453990>, <-0.896962, -0.142065, 0.418660> }
triangle { <-0.896962, -0.142065, 0.418660>, <-0.903168, -0.094927, 0.418660>, <-0.886125, -0.093136, 0.453990> }
triangle { <-0.903168, -0.094927, 0.418660>, <-0.896962, -0.142065, 0.418660>, <-0.912505, -0.144527, 0.382683> }
triangle { <-0.912505, -0.144527, 0.382683>, <-0.918818, -0.096572, 0.382683>, <-0.903168, -0.094927, 0.418660> }
triangle { <-0.918818, -0.096572, 0.382683>, <-0.912505, -0.144527, 0.382683>, <-0.926641, -0.146765, 0.346117> }
triangle { <-0.926641, -0.146765, 0.346117>, <-0.933052, -0.098068, 0.346117>, <-0.918818, -0.096572, 0.382683> }
triangle { <-0.933052, -0.098068, 0.346117>, <-0.926641, -0.146765, 0.346117>, <-0.939347, -0.148778, 0.309017> }
triangle { <-0.939347, -0.148778, 0.309017>, <-0.945847, -0.099412, 0.309017>, <-0.933052, -0.098068, 0.346117> }
triangle { <-0.945847, -0.099412, 0.309017>, <-0.939347, -0.148778, 0.309017>, <-0.950606, -0.150561, 0.271440> }
triangle { <-0.950606, -0.150561, 0.271440>, <-0.957183, -0.100604, 0.271440>, <-0.945847, -0.099412, 0.309017> }
triangle { <-0.957183, -0.100604, 0.271440>, <-0.950606, -0.150561, 0.271440>, <-0.960398, -0.152112, 0.233445> }
triangle { <-0.960398, -0.152112, 0.233445>, <-0.967043, -0.101640, 0.233445>, <-0.957183, -0.100604, 0.271440> }
triangle { <-0.967043, -0.101640, 0.233445>, <-0.960398, -0.152112, 0.233445>, <-0.968710, -0.153429, 0.195090> }
triangle { <-0.968710, -0.153429, 0.195090>, <-0.975412, -0.102520, 0.195090>, <-0.967043, -0.101640, 0.233445> }
triangle { <-0.975412, -0.102520, 0.195090>, <-0.968710, -0.153429, 0.195090>, <-0.975528, -0.154508, 0.156434> }
triangle { <-0.975528, -0.154508, 0.156434>, <-0.982278, -0.103242, 0.156434>, <-0.975412, -0.102520, 0.195090> }
triangle { <-0.982278, -0.103242, 0.156434>, <-0.975528, -0.154508, 0.156434>, <-0.980842, -0.155350, 0.117537> }
triangle { <-0.980842, -0.155350, 0.117537>, <-0.987628, -0.103804, 0.117537>, <-0.982278, -0.103242, 0.156434> }
triangle { <-0.987628, -0.103804, 0.117537>, <-0.980842, -0.155350, 0.117537>, <-0.984644, -0.155952, 0.078459> }
triangle { <-0.984644, -0.155952, 0.078459>, <-0.991456, -0.104206, 0.078459>, <-0.987628, -0.103804, 0.117537> }
triangle { <-0.991456, -0.104206, 0.078459>, <-0.984644, -0.155952, 0.078459>, <-0.986927, -0.156314, 0.039260> }
triangle { <-0.986927, -0.156314, 0.039260>, <-0.993755, -0.104448, 0.039260>, <-0.991456, -0.104206, 0.078459> }
triangle { <-0.993755, -0.104448, 0.039260>, <-0.986927, -0.156314, 0.039260>, <-0.987688, -0.156434, -0.000000> }
triangle { <-0.987688, -0.156434, -0.000000>, <-0.994522, -0.104528, -0.000000>, <-0.993755, -0.104448, 0.039260> }
triangle { <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <-0.038402, -0.008163, 0.999229> }
triangle { <-0.038402, -0.008163, 0.999229>, <-0.038776, -0.006142, 0.999229>, <0.000000, 0.000000, 1.000000> }
triangle { <-0.038776, -0.006142, 0.999229>, <-0.038402, -0.008163, 0.999229>, <-0.076745, -0.016313, 0.996917> }
triangle { <-0.076745, -0.016313, 0.996917>, <-0.077493, -0.012274, 0.996917>, <-0.038776, -0.006142, 0.999229> }
triangle { <-0.077493, -0.012274, 0.996917>, <-0.076745, -0.016313, 0.996917>, <-0.114969, -0.024437, 0.993068> }
triangle { <-0.114969, -0.024437, 0.993068>, <-0.116090, -0.018387, 0.993068>, <-0.077493, -0.012274, 0.996917> }
triangle { <-0.116090, -0.018387, 0.993068>, <-0.114969, -0.024437, 0.993068>, <-0.153016, -0.032525, 0.987688> }
triangle { <-0.153016, -0.032525, 0.987688>, <-0.154508, -0.024472, 0.987688>, <-0.116090, -0.018387, 0.993068> }
triangle { <-0.154508, -0.024472, 0.987688>, <-0.153016, -0.032525, 0.987688>, <-0.190827, -0.040562, 0.980785> }
triangle { <-0.190827, -0.040562, 0.980785>, <-0.192688, -0.030519, 0.980785>, <-0.154508, -0.024472, 0.987688> }
triangle { <-0.192688, -0.030519, 0.980785>, <-0.190827, -0.040562, 0.980785>, <-0.228344, -0.048536, 0.972370> }
triangle { <-0.228344, -0.048536, 0.972370>, <-0.230571, -0.036519, 0.972370>, <-0.192688, -0.030519, 0.980785> }
triangle { <-0.230571, -0.036519, 0.972370>, <-0.228344, -0.048536, 0.972370>, <-0.265509, -0.056436, 0.962455> }
triangle { <-0.265509, -0.056436, 0.962455>, <-0.268099, -0.042463, 0.962455>, <-0.230571, -0.036519, 0.972370> }
triangle { <-0.268099, -0.042463, 0.962455>, <-0.265509, -0.056436, 0.962455>, <-0.302264, -0.064248, 0.951057> }
triangle { <-0.302264, -0.064248, 0.951057>, <-0.305212, -0.048341, 0.951057>, <-0.268099, -0.042463, 0.962455> }
triangle { <-0.305212, -0.048341, 0.951057>, <-0.302264, -0.064248, 0.951057>, <-0.338554, -0.071962, 0.938191> }
triangle { <-0.338554, -0.071962, 0.938191>, <-0.341856, -0.054145, 0.938191>, <-0.305212, -0.048341, 0.951057> }
triangle { <-0.341856, -0.054145, 0.938191>, <-0.338554, -0.071962, 0.938191>, <-0.374321, -0.079564, 0.923880> }
triangle { <-0.374321, -0.079564, 0.923880>, <-0.377972, -0.059865, 0.923880>, <-0.341856, -0.054145, 0.938191> }
triangle { <-0.377972, -0.059865, 0.923880>, <-0.374321, -0.079564, 0.923880>, <-0.409511, -0.087044, 0.908143> }
triangle { <-0.409511, -0.087044, 0.908143>, <-0.413505, -0.065493, 0.908143>, <-0.377972, -0.059865, 0.923880> }
triangle { <-0.413505, -0.065493, 0.908143>, <-0.409511, -0.087044, 0.908143>, <-0.444070, -0.094390, 0.891007> }
triangle { <-0.444070, -0.094390, 0.891007>, <-0.448401, -0.071020, 0.891007>, <-0.413505, -0.065493, 0.908143> }
triangle { <-0.448401, -0.071020, 0.891007>, <-0.444070, -0.094390, 0.891007>, <-0.477944, -0.101590, 0.872496> }
triangle { <-0.477944, -0.101590, 0.872496>, <-0.482606, -0.076437, 0.872496>, <-0.448401, -0.071020, 0.891007> }
triangle { <-0.482606, -0.076437, 0.872496>, <-0.477944, -0.101590, 0.872496>, <-0.511081, -0.108634, 0.852640> }
triangle { <-0.511081, -0.108634, 0.852640>, <-0.516066, -0.081737, 0.852640>, <-0.482606, -0.076437, 0.872496> }
triangle { <-0.516066, -0.081737, 0.852640>, <-0.511081, -0.108634, 0.852640>, <-0.543430, -0.115510, 0.831470> }
triangle { <-0.543430, -0.115510, 0.831470>, <-0.548730, -0.086910, 0.831470>, <-0.516066, -0.081737, 0.852640> }
triangle { <-0.548730, -0.086910, 0.831470>, <-0.543430, -0.115510, 0.831470>, <-0.574941, -0.122207, 0.809017> }
triangle { <-0.574941, -0.122207, 0.809017>, <-0.580549, -0.091950, 0.809017>, <-0.548730, -0.086910, 0.831470> }
triangle { <-0.580549, -0.091950, 0.809017>, <-0.574941, -0.122207, 0.809017>, <-0.605565, -0.128717, 0.785317> }
triangle { <-0.605565, -0.128717, 0.785317>, <-0.611472, -0.096848, 0.785317>, <-0.580549, -0.091950, 0.809017> }
triangle { <-0.611472, -0.096848, 0.785317>, <-0.605565, -0.128717, 0.785317>, <-0.635256, -0.135028, 0.760406> }
triangle { <-0.635256, -0.135028, 0.760406>, <-0.641452, -0.101596, 0.760406>, <-0.611472, -0.096848, 0.785317> }
triangle { <-0.641452, -0.101596, 0.760406>, <-0.635256, -0.135028, 0.760406>, <-0.663967, -0.141131, 0.734323> }
triangle { <-0.663967, -0.141131, 0.734323>, <-0.670444, -0.106188, 0.734323>, <-0.641452, -0.101596, 0.760406> }
triangle { <-0.670444, -0.106188, 0.734323>, <-0.663967, -0.141131, 0.734323>, <-0.691655, -0.147016, 0.707107> }
triangle { <-0.691655, -0.147016, 0.707107>, <-0.698401, -0.110616, 0.707107>, <-0.670444, -0.106188, 0.734323> }
triangle { <-0.698401, -0.110616, 0.707107>, <-0.691655, -0.147016, 0.707107>, <-0.718276, -0.152674, 0.678801> }
triangle { <-0.718276, -0.152674, 0.678801>, <-0.725282, -0.114873, 0.678801>, <-0.698401, -0.110616, 0.707107> }
triangle { <-0.725282, -0.114873, 0.678801>, <-0.718276, -0.152674, 0.678801>, <-0.743789, -0.158097, 0.649448> }
triangle { <-0.743789, -0.158097, 0.649448>, <-0.751044, -0.118954, 0.649448>, <-0.725282, -0.114873, 0.678801> }
triangle { <-0.751044, -0.118954, 0.649448>, <-0.743789, -0.158097, 0.649448>, <-0.768156, -0.163277, 0.619094> }
triangle { <-0.768156, -0.163277, 0.619094>, <-0.775648, -0.122851, 0.619094>, <-0.751044, -0.118954, 0.649448> }
triangle { <-0.775648, -0.122851, 0.619094>, <-0.768156, -0.163277, 0.619094>, <-0.791338, -0.168204, 0.587785> }
triangle { <-0.791338, -0.168204, 0.587785>, <-0.799057, -0.126558, 0.587785>, <-0.775648, -0.122851, 0.619094> }
triangle { <-0.799057, -0.126558, 0.587785>, <-0.791338, -0.168204, 0.587785>, <-0.813300, -0.172872, 0.555570> }
triangle { <-0.813300, -0.172872, 0.555570>, <-0.821233, -0.130071, 0.555570>, <-0.799057, -0.126558, 0.587785> }
triangle { <-0.821233, -0.130071, 0.555570>, <-0.813300, -0.172872, 0.555570>, <-0.834008, -0.177274, 0.522499> }
triangle { <-0.834008, -0.177274, 0.522499>, <-0.842143, -0.133382, 0.522499>, <-0.821233, -0.130071, 0.555570> }
triangle { <-0.842143, -0.133382, 0.522499>, <-0.834008, -0.177274, 0.522499>, <-0.853430, -0.181402, 0.488621> }
triangle { <-0.853430, -0.181402, 0.488621>, <-0.861754, -0.136488, 0.488621>, <-0.842143, -0.133382, 0.522499> }
triangle { <-0.861754, -0.136488, 0.488621>, <-0.853430, -0.181402, 0.488621>, <-0.871536, -0.185251, 0.453990> }
triangle { <-0.871536, -0.185251, 0.453990>, <-0.880037, -0.139384, 0.453990>, <-0.861754, -0.136488, 0.488621> }
triangle { <-0.880037, -0.139384, 0.453990>, <-0.871536, -0.185251, 0.453990>, <-0.888298, -0.188814, 0.418660> }
triangle { <-0.888298, -0.188814, 0.418660>, <-0.896962, -0.142065, 0.418660>, <-0.880037, -0.139384, 0.453990> }
triangle { <-0.896962, -0.142065, 0.418660>, <-0.888298, -0.188814, 0.418660>, <-0.903691, -0.192085, 0.382683> }
triangle { <-0.903691, -0.192085, 0.382683>, <-0.912505, -0.144527, 0.382683>, <-0.896962, -0.142065, 0.418660> }
triangle { <-0.912505, -0.144527, 0.382683>, <-0.903691, -0.192085, 0.382683>, <-0.917690, -0.195061, 0.346117> }
triangle { <-0.917690, -0.195061, 0.346117>, <-0.926641, -0.146765, 0.346117>, <-0.912505, -0.144527, 0.382683> }
triangle { <-0.926641, -0.146765, 0.346117>, <-0.917690, -0.195061, 0.346117>, <-0.930274, -0.197736, 0.309017> }
triangle { <-0.930274, -0.197736, 0.309017>, <-0.939347, -0.148778, 0.309017>, <-0.926641, -0.146765, 0.346117> }
triangle { <-0.939347, -0.148778, 0.309017>, <-0.930274, -0.197736, 0.309017>, <-0.941423, -0.200106, 0.271440> }
triangle { <-0.941423, -0.200106, 0.271440>, <-0.950606, -0.150561, 0.271440>, <-0.939347, -0.148778, 0.309017> }
triangle { <-0.950606, -0.150561, 0.271440>, <-0.941423, -0.200106, 0.271440>, <-0.951121, -0.202167, 0.233445> }
triangle { <-0.951121, -0.202167, 0.233445>, <-0.960398, -0.152112, 0.233445>, <-0.950606, -0.150561, 0.271440> }
triangle { <-0.960398, -0.152112, 0.233445>, <-0.951121, -0.202167, 0.233445>, <-0.959353, -0.203917, 0.195090> }
triangle { <-0.959353, -0.203917, 0.195090>, <-0.968710, -0.153429, 0.195090>, <-0.960398, -0.152112, 0.233445> }
triangle { <-0.968710, -0.153429, 0.195090>, <-0.959353, -0.203917, 0.195090>, <-0.966105, -0.205352, 0.156434> }
triangle { <-0.966105, -0.205352, 0.156434>, <-0.975528, -0.154508, 0.156434>, <-0.968710, -0.153429, 0.195090> }
triangle { <-0.975528, -0.154508, 0.156434>, <-0.966105, -0.205352, 0.156434>, <-0.971368, -0.206471, 0.117537> }
triangle { <-0.971368, -0.206471, 0.117537>, <-0.980842, -0.155350, 0.117537>, <-0.975528, -0.154508, 0.156434> }
triangle { <-0.980842, -0.155350, 0.117537>, <-0.971368, -0.206471, 0.117537>, <-0.975132, -0.207271, 0.078459> }
triangle { <-0.975132, -0.207271, 0.078459>, <-0.984644, -0.155952, 0.078459>, <-0.980842, -0.155350, 0.117537> }
triangle { <-0.984644, -0.155952, 0.078459>, <-0.975132, -0.207271, 0.078459>, <-0.977393, -0.207751, 0.039260> }
triangle { <-0.977393, -0.207751, 0.039260>, <-0.986927, -0.156314, 0.039260>, <-0.984644, -0.155952, 0.078459> }
triangle { <-0.986927, -0.156314, 0.039260>, <-0.977393, -0.207751, 0.039260>, <-0.978148, -0.207912, -0.000000> }
triangle { <-0.978148, -0.207912, -0.000000>, <-0.987688, -0.156434, -0.000000>, <-0.986927, -0.156314, 0.039260> }
triangle { <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <-0.037922, -0.010161, 0.999229> }
triangle { <-0.037922, -0.010161, 0.999229>, <-0.038402, -0.008163, 0.999229>, <0.000000, 0.000000, 1.000000> }
triangle { <-0.038402, -0.008163, 0.999229>, <-0.037922, -0.010161, 0.999229>, <-0.075786, -0.020307, 0.996917> }
triangle { <-0.075786, -0.020307, 0.996917>, <-0.076745, -0.016313, 0.996917>, <-0.038402, -0.008163, 0.999229> }
triangle { <-0.076745, -0.016313, 0.996917>, <-0.075786, -0.020307, 0.996917>, <-0.113532, -0.030421, 0.993068> }
triangle { <-0.113532, -0.030421, 0.993068>, <-0.114969, -0.024437, 0.993068>, <-0.076745, -0.016313, 0.996917> }
triangle { <-0.114969, -0.024437, 0.993068>, <-0.113532, -0.030421, 0.993068>, <-0.151104, -0.040488, 0.987688> }
triangle { <-0.151104, -0.040488, 0.987688>, <-0.153016, -0.032525, 0.987688>, <-0.114969, -0.024437, 0.993068> }
triangle { <-0.153016, -0.032525, 0.987688>, <-0.151104, -0.040488, 0.987688>, <-0.188443, -0.050493, 0.980785> }
triangle { <-0.188443, -0.050493, 0.980785>, <-0.190827, -0.040562, 0.980785>, <-0.153016, -0.032525, 0.987688> }
triangle { <-0.190827, -0.040562, 0.980785>, <-0.188443, -0.050493, 0.980785>, <-0.225491, -0.060420, 0.972370> }
triangle { <-0.225491, -0.060420, 0.972370>, <-0.228344, -0.048536, 0.972370>, <-0.190827, -0.040562, 0.980785> }
triangle { <-0.228344, -0.048536, 0.972370>, <-0.225491, -0.060420, 0.972370>, <-0.262191, -0.070254, 0.962455> }
triangle { <-0.262191, -0.070254, 0.962455>, <-0.265509, -0.056436, 0.962455>, <-0.228344, -0.048536, 0.972370> }
triangle { <-0.265509, -0.056436, 0.962455>, <-0.262191, -0.070254, 0.962455>, <-0.298487, -0.079979, 0.951057> }
triangle { <-0.298487, -0.079979, 0.951057>, <-0.302264, -0.064248, 0.951057>, <-0.265509, -0.056436, 0.962455> }
triangle { <-0.302264, -0.064248, 0.951057>, <-0.298487, -0.079979, 0.951057>, <-0.334323, -0.089582, 0.938191> }
triangle { <-0.334323, -0.089582, 0.938191>, <-0.338554, -0.071962, 0.938191>, <-0.302264, -0.064248, 0.951057> }
triangle { <-0.338554, -0.071962, 0.938191>, <-0.334323, -0.089582, 0.938191>, <-0.369644, -0.099046, 0.923880> }
triangle { <-0.369644, -0.099046, 0.923880>, <-0.374321, -0.079564, 0.923880>, <-0.338554, -0.071962, 0.938191> }
triangle { <-0.374321, -0.079564, 0.923880>, <-0.369644, -0.099046, 0.923880>, <-0.404394, -0.108357, 0.908143> }
triangle { <-0.404394, -0.108357, 0.908143>, <-0.409511, -0.087044, 0.908143>, <-0.374321, -0.079564, 0.923880> }
triangle { <-0.409511, -0.087044, 0.908143>, <-0.404394, -0.108357, 0.908143>, <-0.438521, -0.117501, 0.891007> }
triangle { <-0.438521, -0.117501, 0.891007>, <-0.444070, -0.094390, 0.891007>, <-0.409511, -0.087044, 0.908143> }
triangle { <-0.444070, -0.094390, 0.891007>, <-0.438521, -0.117501, 0.891007>, <-0.471972, -0.126464, 0.872496> }
triangle { <-0.471972, -0.126464, 0.872496>, <-0.477944, -0.101590, 0.872496>, <-0.444070, -0.094390, 0.891007> }
triangle { <-0.477944, -0.101590, 0.872496>, <-0.471972, -0.126464, 0.872496>, <-0.504695, -0.135233, 0.852640> }
triangle { <-0.504695, -0.135233, 0.852640>, <-0.511081, -0.108634, 0.852640>, <-0.477944, -0.101590, 0.872496> }
triangle { <-0.511081, -0.108634, 0.852640>, <-0.504695, -0.135233, 0.852640>, <-0.536640, -0.143792, 0.831470> }
triangle { <-0.536640, -0.143792, 0.831470>, <-0.543430, -0.115510, 0.831470>, <-0.511081, -0.108634, 0.852640> }
triangle { <-0.543430, -0.115510, 0.831470>, <-0.536640, -0.143792, 0.831470>, <-0.567757, -0.152130, 0.809017> }
triangle { <-0.567757, -0.152130, 0.809017>, <-0.574941, -0.122207, 0.809017>, <-0.543430, -0.115510, 0.831470> }
triangle { <-0.574941, -0.122207, 0.809017>, <-0.567757, -0.152130, 0.809017>, <-0.597999, -0.160233, 0.785317> }
triangle { <-0.597999, -0.160233, 0.785317>, <-0.605565, -0.128717, 0.785317>, <-0.574941, -0.122207, 0.809017> }
triangle { <-0.605565, -0.128717, 0.785317>, <-0.597999, -0.160233, 0.785317>, <-0.627319, -0.168090, 0.760406> }
triangle { <-0.627319, -0.168090, 0.760406>, <-0.635256, -0.135028, 0.760406>, <-0.605565, -0.128717, 0.785317> }
triangle { <-0.635256, -0.135028, 0.760406>, <-0.627319, -0.168090, 0.760406>, <-0.655671, -0.175687, 0.734323> }
triangle { <-0.655671, -0.175687, 0.734323>, <-0.663967, -0.141131, 0.734323>, <-0.635256, -0.135028, 0.760406> }
triangle { <-0.663967, -0.141131, 0.734323>, <-0.655671, -0.175687, 0.734323>, <-0.683013, -0.183013, 0.707107> }
triangle { <-0.683013, -0.183013, 0.707107>, <-0.691655, -0.147016, 0.707107>, <-0.663967, -0.141131, 0.734323> }
triangle { <-0.691655, -0.147016, 0.707107>, <-0.683013, -0.183013, 0.707107>, <-0.709301, -0.190057, 0.678801> }
triangle { <-0.709301, -0.190057, 0.678801>, <-0.718276, -0.152674, 0.678801>, <-0.691655, -0.147016, 0.707107> }
triangle { <-0.718276, -0.152674, 0.678801>, <-0.709301, -0.190057, 0.678801>, <-0.734496, -0.196808, 0.649448> }
triangle { <-0.734496, -0.196808, 0.649448>, <-0.743789, -0.158097, 0.649448>, <-0.718276, -0.152674, 0.678801> }
triangle { <-0.743789, -0.158097, 0.649448>, <-0.734496, -0.196808, 0.649448>, <-0.758558, -0.203255, 0.619094> }
triangle { <-0.758558, -0.203255, 0.619094>, <-0.768156, -0.163277, 0.619094>, <-0.743789, -0.158097, 0.649448> }
triangle { <-0.768156, -0.163277, 0.619094>, <-0.758558, -0.203255, 0.619094>, <-0.781450, -0.209389, 0.587785> }
triangle { <-0.781450, -0.209389, 0.587785>, <-0.791338, -0.168204, 0.587785>, <-0.768156, -0.163277, 0.619094> }
triangle { <-0.791338, -0.168204, 0.587785>, <-0.781450, -0.209389, 0.587785>, <-0.803138, -0.215200, 0.555570> }
triangle { <-0.803138, -0.215200, 0.555570>, <-0.813300, -0.172872, 0.555570>, <-0.791338, -0.168204, 0.587785> }
triangle { <-0.813300, -0.172872, 0.555570>, <-0.803138, -0.215200, 0.555570>, <-0.823587, -0.220680, 0.522499> }
triangle { <-0.823587, -0.220680, 0.522499>, <-0.834008, -0.177274, 0.522499>, <-0.813300, -0.172872, 0.555570> }
triangle { <-0.834008, -0.177274, 0.522499>, <-0.823587, -0.220680, 0.522499>, <-0.842766, -0.225819, 0.488621> }
triangle { <-0.842766, -0.225819, 0.488621>, <-0.853430, -0.181402, 0.488621>, <-0.834008, -0.177274, 0.522499> }
triangle { <-0.853430, -0.181402, 0.488621>, <-0.842766, -0.225819, 0.488621>, <-0.860646, -0.230609, 0.453990> }
triangle { <-0.860646, -0.230609, 0.453990>, <-0.871536, -0.185251, 0.453990>, <-0.853430, -0.181402, 0.488621> }
triangle { <-0.871536, -0.185251, 0.453990>, <-0.860646, -0.230609, 0.453990>, <-0.877199, -0.235045, 0.418660> }
triangle { <-0.877199, -0.235045, 0.418660>, <-0.888298, -0.188814, 0.418660>, <-0.871536, -0.185251, 0.453990> }
triangle { <-0.888298, -0.188814, 0.418660>, <-0.877199, -0.235045, 0.418660>, <-0.892399, -0.239118, 0.382683> }
triangle { <-0.892399, -0.239118, 0.382683>, <-0.903691, -0.192085, 0.382683>, <-0.888298, -0.188814, 0.418660> }
triangle { <-0.903691, -0.192085, 0.382683>, <-0.892399, -0.239118, 0.382683>, <-0.906223, -0.242822, 0.346117> }
triangle { <-0.906223, -0.242822, 0.346117>, <-0.917690, -0.195061, 0.346117>, <-0.903691, -0.192085, 0.382683> }
triangle { <-0.917690, -0.195061, 0.346117>, <-0.906223, -0.242822, 0.346117>, <-0.918650, -0.246152, 0.309017> }
triangle { <-0.918650, -0.246152, 0.309017>, <-0.930274, -0.197736, 0.309017>, <-0.917690, -0.195061, 0.346117> }
triangle { <-0.930274, -0.197736, 0.309017>, <-0.918650, -0.246152, 0.309017>, <-0.929660, -0.249102, 0.271440> }
triangle { <-0.929660, -0.249102, 0.271440>, <-0.941423, -0.200106, 0.271440>, <-0.930274, -0.197736, 0.309017> }
triangle { <-0.941423, -0.200106, 0.271440>, <-0.929660, -0.249102, 0.271440>, <-0.939237, -0.251668, 0.233445> }
triangle { <-0.939237, -0.251668, 0.233445>, <-0.951121, -0.202167, 0.233445>, <-0.941423, -0.200106, 0.271440> }
triangle { <-0.951121, -0.202167, 0.233445>, <-0.939237, -0.251668, 0.233445>, <-0.947366, -0.253846, 0.195090> }
triangle { <-0.947366, -0.253846, 0.195090>, <-0.959353, -0.203917, 0.195090>, <-0.951121, -0.202167, 0.233445> }
triangle { <-0.959353, -0.203917, 0.195090>, <-0.947366, -0.253846, 0.195090>, <-0.954034, -0.255633, 0.156434> }
triangle { <-0.954034, -0.255633, 0.156434>, <-0.966105, -0.205352, 0.156434>, <-0.959353, -0.203917, 0.195090> }
triangle { <-0.966105, -0.205352, 0.156434>, <-0.954034, -0.255633, 0.156434>, <-0.959230, -0.257025, 0.117537> }
triangle { <-0.959230, -0.257025, 0.117537>, <-0.971368, -0.206471, 0.117537>, <-0.966105, -0.205352, 0.156434> }
triangle { <-0.971368, -0.206471, 0.117537>, <-0.959230, -0.257025, 0.117537>, <-0.962948, -0.258021, 0.078459> }
triangle { <-0.962948, -0.258021, 0.078459>, <-0.975132, -0.207271, 0.078459>, <-0.971368, -0.206471, 0.117537> }
triangle { <-0.975132, -0.207271, 0.078459>, <-0.962948, -0.258021, 0.078459>, <-0.965181, -0.258620, 0.039260> }
triangle { <-0.965181, -0.258620, 0.039260>, <-0.977393, -0.207751, 0.039260>, <-0.975132, -0.207271, 0.078459> }
triangle { <-0.977393, -0.207751, 0.039260>, <-0.965181, -0.258620, 0.039260>, <-0.965926, -0.258819, -0.000000> }
triangle { <-0.965926, -0.258819, -0.000000>, <-0.978148, -0.207912, -0.000000>, <-0.977393, -0.207751, 0.039260> }
triangle { <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <-0.037338, -0.012132, 0.999229> }
triangle { <-0.037338, -0.012132, 0.999229>, <-0.037922, -0.010161, 0.999229>, <0.000000, 0.000000, 1.000000> }
triangle { <-0.037922, -0.010161, 0.999229>, <-0.037338, -0.012132, 0.999229>, <-0.074619, -0.024245, 0.996917> }
triangle { <-0.074619, -0.024245, 0.996917>, <-0.075786, -0.020307, 0.996917>, <-0.037922, -0.010161, 0.999229> }
triangle { <-0.075786, -0.020307, 0.996917>, <-0.074619, -0.024245, 0.996917>, <-0.111785, -0.036321, 0.993068> }
triangle { <-0.111785, -0.036321, 0.993068>, <-0.113532, -0.030421, 0.993068>, <-0.075786, -0.020307, 0.996917> }
triangle { <-0.113532, -0.030421, 0.993068>, <-0.111785, -0.036321, 0.993068>, <-0.148778, -0.048341, 0.987688> }
triangle { <-0.148778, -0.048341, 0.987688>, <-0.151104, -0.040488, 0.987688>, <-0.113532, -0.030421, 0.993068> }
triangle { <-0.151104, -0.040488, 0.987688>, <-0.148778, -0.048341, 0.987688>, <-0.185542, -0.060286, 0.980785> }
triangle { <-0.185542, -0.060286, 0.980785>, <-0.188443, -0.050493, 0.980785>, <-0.151104, -0.040488, 0.987688> }
triangle { <-0.188443, -0.050493, 0.980785>, <-0.185542, -0.060286, 0.980785>, <-0.222020, -0.072139, 0.972370> }
triangle { <-0.222020, -0.072139, 0.972370>, <-0.225491, -0.060420, 0.972370>, <-0.188443, -0.050493, 0.980785> }
triangle { <-0.225491, -0.060420, 0.972370>, <-0.222020, -0.072139, 0.972370>, <-0.258155, -0.083880, 0.962455> }
triangle { <-0.258155, -0.083880, 0.962455>, <-0.262191, -0.070254, 0.962455>, <-0.225491, -0.060420, 0.972370> }
triangle { <-0.262191, -0.070254, 0.962455>, <-0.258155, -0.083880, 0.962455>, <-0.293893, -0.095492, 0.951057> }
triangle { <-0.293893, -0.095492, 0.951057>, <-0.298487, -0.079979, 0.951057>, <-0.262191, -0.070254, 0.962455> }
triangle { <-0.298487, -0.079979, 0.951057>, <-0.293893, -0.095492, 0.951057>, <-0.329177, -0.106956, 0.938191> }
triangle { <-0.329177, -0.106956, 0.938191>, <-0.334323, -0.089582, 0.938191>, <-0.298487, -0.079979, 0.951057> }
triangle { <-0.334323, -0.089582, 0.938191>, <-0.329177, -0.106956, 0.938191>, <-0.363954, -0.118256, 0.923880> }
triangle { <-0.363954, -0.118256, 0.923880>, <-0.369644, -0.099046, 0.923880>, <-0.334323, -0.089582, 0.938191> }
triangle { <-0.369644, -0.099046, 0.923880>, <-0.363954, -0.118256, 0.923880>, <-0.398169, -0.129373, 0.908143> }
triangle { <-0.398169, -0.129373, 0.908143>, <-0.404394, -0.108357, 0.908143>, <-0.369644, -0.099046, 0.923880> }
triangle { <-0.404394, -0.108357, 0.908143>, <-0.398169, -0.129373, 0.908143>, <-0.431771, -0.140291, 0.891007> }
triangle { <-0.431771, -0.140291, 0.891007>, <-0.438521, -0.117501, 0.891007>, <-0.404394, -0.108357, 0.908143> }
triangle { <-0.438521, -0.117501, 0.891007>, <-0.431771, -0.140291, 0.891007>, <-0.464706, -0.150992, 0.872496> }
triangle { <-0.464706, -0.150992, 0.872496>, <-0.471972, -0.126464, 0.872496>, <-0.438521, -0.117501, 0.891007> }
triangle { <-0.471972, -0.126464, 0.872496>, <-0.464706, -0.150992, 0.872496>, <-0.496926, -0.161461, 0.852640> }
triangle { <-0.496926, -0.161461, 0.852640>, <-0.504695, -0.135233, 0.852640>, <-0.471972, -0.126464, 0.872496> }
triangle { <-0.504695, -0.135233, 0.852640>, <-0.496926, -0.161461, 0.852640>, <-0.528379, -0.171681, 0.831470> }
triangle { <-0.528379, -0.171681, 0.831470>, <-0.536640, -0.143792, 0.831470>, <-0.504695, -0.135233, 0.852640> }
triangle { <-0.536640, -0.143792, 0.831470>, <-0.528379, -0.171681, 0.831470>, <-0.559017, -0.181636, 0.809017> }
triangle { <-0.559017, -0.181636, 0.809017>, <-0.567757, -0.152130, 0.809017>, <-0.536640, -0.143792, 0.831470> }
triangle { <-0.567757, -0.152130, 0.809017>, <-0.559017, -0.181636, 0.809017>, <-0.588793, -0.191311, 0.785317> }
triangle { <-0.588793, -0.191311, 0.785317>, <-0.597999, -0.160233, 0.785317>, <-0.567757, -0.152130, 0.809017> }
triangle { <-0.597999, -0.160233, 0.785317>, <-0.588793, -0.191311, 0.785317>, <-0.617662, -0.200690, 0.760406> }
triangle { <-0.617662, -0.200690, 0.760406>, <-0.627319, -0.168090, 0.760406>, <-0.597999, -0.160233, 0.785317> }
triangle { <-0.627319, -0.168090, 0.760406>, <-0.617662, -0.200690, 0.760406>, <-0.645578, -0.209761, 0.734323> }
triangle { <-0.645578, -0.209761, 0.734323>, <-0.655671, -0.175687, 0.734323>, <-0.627319, -0.168090, 0.760406> }
triangle { <-0.655671, -0.175687, 0.734323>, <-0.645578, -0.209761, 0.734323>, <-0.672499, -0.218508, 0.707107> }
triangle { <-0.672499, -0.218508, 0.707107>, <-0.683013, -0.183013, 0.707107>, <-0.655671, -0.175687, 0.734323> }
triangle { <-0.683013, -0.183013, 0.707107>, <-0.672499, -0.218508, 0.707107>, <-0.698382, -0.226918, 0.678801> }
triangle { <-0.698382, -0.226918, 0.678801>, <-0.709301, -0.190057, 0.678801>, <-0.683013, -0.183013, 0.707107> }
triangle { <-0.709301, -0.190057, 0.678801>, <-0.698382, -0.226918, 0.678801>, <-0.723189, -0.234978, 0.649448> }
triangle { <-0.723189, -0.234978, 0.649448>, <-0.734496, -0.196808, 0.649448>, <-0.709301, -0.190057, 0.678801> }
triangle { <-0.734496, -0.196808, 0.649448>, <-0.723189, -0.234978, 0.649448>, <-0.746881, -0.242676, 0.619094> }
triangle { <-0.746881, -0.242676, 0.619094>, <-0.758558, -0.203255, 0.619094>, <-0.734496, -0.196808, 0.649448> }
triangle { <-0.758558, -0.203255, 0.619094>, <-0.746881, -0.242676, 0.619094>, <-0.769421, -0.250000, 0.587785> }
triangle { <-0.769421, -0.250000, 0.587785>, <-0.781450, -0.209389, 0.587785>, <-0.758558, -0.203255, 0.619094> }
triangle { <-0.781450, -0.209389, 0.587785>, <-0.769421, -0.250000, 0.587785>, <-0.790775, -0.256938, 0.555570> }
triangle { <-0.790775, -0.256938, 0.555570>, <-0.803138, -0.215200, 0.555570>, <-0.781450, -0.209389, 0.587785> }
triangle { <-0.803138, -0.215200, 0.555570>, <-0.790775, -0.256938, 0.555570>, <-0.810909, -0.263480, 0.522499> }
triangle { <-0.810909, -0.263480, 0.522499>, <-0.823587, -0.220680, 0.522499>, <-0.803138, -0.215200, 0.555570> }
triangle { <-0.823587, -0.220680, 0.522499>, <-0.810909, -0.263480, 0.522499>, <-0.829793, -0.269616, 0.488621> }
triangle { <-0.829793, -0.269616, 0.488621>, <-0.842766, -0.225819, 0.488621>, <-0.823587, -0.220680, 0.522499> }
triangle { <-0.842766, -0.225819, 0.488621>, <-0.829793, -0.269616, 0.488621>, <-0.847398, -0.275336, 0.453990> }
triangle { <-0.847398, -0.275336, 0.453990>, <-0.860646, -0.230609, 0.453990>, <-0.842766, -0.225819, 0.488621> }
triangle { <-0.860646, -0.230609, 0.453990>, <-0.847398, -0.275336, 0.453990>, <-0.863695, -0.280632, 0.418660> }
triangle { <-0.863695, -0.280632, 0.418660>, <-0.877199, -0.235045, 0.418660>, <-0.860646, -0.230609, 0.453990> }
triangle { <-0.877199, -0.235045, 0.418660>, <-0.863695, -0.280632, 0.418660>, <-0.878662, -0.285494, 0.382683> }
triangle { <-0.878662, -0.285494, 0.382683>, <-0.892399, -0.239118, 0.382683>, <-0.877199, -0.235045, 0.418660> }
triangle { <-0.892399, -0.239118, 0.382683>, <-0.878662, -0.285494, 0.382683>, <-0.892273, -0.289917, 0.346117> }
triangle { <-0.892273, -0.289917, 0.346117>, <-0.906223, -0.242822, 0.346117>, <-0.892399, -0.239118, 0.382683> }
triangle { <-0.906223, -0.242822, 0.346117>, <-0.892273, -0.289917, 0.346117>, <-0.904508, -0.293893, 0.309017> }
triangle { <-0.904508, -0.293893, 0.309017>, <-0.918650, -0.246152, 0.309017>, <-0.906223, -0.242822, 0.346117> }
triangle { <-0.918650, -0.246152, 0.309017>, <-0.904508, -0.293893, 0.309017>, <-0.915349, -0.297415, 0.271440> }
triangle { <-0.915349, -0.297415, 0.271440>, <-0.929660, -0.249102, 0.271440>, <-0.918650, -0.246152, 0.309017> }
triangle { <-0.929660, -0.249102, 0.271440>, <-0.915349, -0.297415, 0.271440>, <-0.924779, -0.300479, 0.233445> }
triangle { <-0.924779, -0.300479, 0.233445>, <-0.939237, -0.251668, 0.233445>, <-0.929660, -0.249102, 0.271440> }
triangle { <-0.939237, -0.251668, 0.233445>, <-0.924779, -0.300479, 0.233445>, <-0.932782, -0.303079, 0.195090> }
triangle { <-0.932782, -0.303079, 0.195090>, <-0.947366, -0.253846, 0.195090>, <-0.939237, -0.251668, 0.233445> }
triangle { <-0.947366, -0.253846, 0.195090>, <-0.932782, -0.303079, 0.195090>, <-0.939347, -0.305212, 0.156434> }
triangle { <-0.939347, -0.305212, 0.156434>, <-0.954034, -0.255633, 0.156434>, <-0.947366, -0.253846, 0.195090> }
triangle { <-0.954034, -0.255633, 0.156434>, <-0.939347, -0.305212, 0.156434>, <-0.944464, -0.306875, 0.117537> }
triangle { <-0.944464, -0.306875, 0.117537>, <-0.959230, -0.257025, 0.117537>, <-0.954034, -0.255633, 0.156434> }
triangle { <-0.959230, -0.257025, 0.117537>, <-0.944464, -0.306875, 0.117537>, <-0.948125, -0.308064, 0.078459> }
triangle { <-0.948125, -0.308064, 0.078459>, <-0.962948, -0.258021, 0.078459>, <-0.959230, -0.257025, 0.117537> }
triangle { <-0.962948, -0.258021, 0.078459>, <-0.948125, -0.308064, 0.078459>, <-0.950323, -0.308779, 0.039260> }
triangle { <-0.950323, -0.308779, 0.039260>, <-0.965181, -0.258620, 0.039260>, <-0.962948, -0.258021, 0.078459> }
triangle { <-0.965181, -0.258620, 0.039260>, <-0.950323, -0.308779, 0.039260>, <-0.951057, -0.309017, -0.000000> }
triangle { <-0.951057, -0.309017, -0.000000>, <-0.965926, -0.258819, -0.000000>, <-0.965181, -0.258620, 0.039260> }
triangle { <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <-0.036652, -0.014069, 0.999229> }
triangle { <-0.036652, -0.014069, 0.999229>, <-0.037338, -0.012132, 0.999229>, <0.000000, 0.000000, 1.000000> }
triangle { <-0.037338, -0.012132, 0.999229>, <-0.036652, -0.014069, 0.999229>, <-0.073248, -0.028117, 0.996917> }
triangle { <-0.073248, -0.028117, 0.996917>, <-0.074619, -0.024245, 0.996917>, <-0.037338, -0.012132, 0.999229> }
triangle { <-0.074619, -0.024245, 0.996917>, <-0.073248, -0.028117, 0.996917>, <-0.109731, -0.042122, 0.993068> }
triangle { <-0.109731, -0.042122, 0.993068>, <-0.111785, -0.036321, 0.993068>, <-0.074619, -0.024245, 0.996917> }
triangle { <-0.111785, -0.036321, 0.993068>, <-0.109731, -0.042122, 0.993068>, <-0.146044, -0.056061, 0.987688> }
triangle { <-0.146044, -0.056061, 0.987688>, <-0.148778, -0.048341, 0.987688>, <-0.111785, -0.036321, 0.993068> }
triangle { <-0.148778, -0.048341, 0.987688>, <-0.146044, -0.056061, 0.987688>, <-0.182133, -0.069914, 0.980785> }
triangle { <-0.182133, -0.069914, 0.980785>, <-0.185542, -0.060286, 0.980785>, <-0.148778, -0.048341, 0.987688> }
triangle { <-0.185542, -0.060286, 0.980785>, <-0.182133, -0.069914, 0.980785>, <-0.217940, -0.083659, 0.972370> }
triangle { <-0.217940, -0.083659, 0.972370>, <-0.222020, -0.072139, 0.972370>, <-0.185542, -0.060286, 0.980785> }
triangle { <-0.222020, -0.072139, 0.972370>, <-0.217940, -0.083659, 0.972370>, <-0.253411, -0.097276, 0.962455> }
triangle { <-0.253411, -0.097276, 0.962455>, <-0.258155, -0.083880, 0.962455>, <-0.222020, -0.072139, 0.972370> }
triangle { <-0.258155, -0.083880, 0.962455>, <-0.253411, -0.097276, 0.962455>, <-0.288492, -0.110742, 0.951057> }
triangle { <-0.288492, -0.110742, 0.951057>, <-0.293893, -0.095492, 0.951057>, <-0.258155, -0.083880, 0.962455> }
triangle { <-0.293893, -0.095492, 0.951057>, <-0.288492, -0.110742, 0.951057>, <-0.323128, -0.124037, 0.938191> }
triangle { <-0.323128, -0.124037, 0.938191>, <-0.329177, -0.106956, 0.938191>, <-0.293893, -0.095492, 0.951057> }
triangle { <-0.329177, -0.106956, 0.938191>, <-0.323128, -0.124037, 0.938191>, <-0.357266, -0.137141, 0.923880> }
triangle { <-0.357266, -0.137141, 0.923880>, <-0.363954, -0.118256, 0.923880>, <-0.329177, -0.106956, 0.938191> }
triangle { <-0.363954, -0.118256, 0.923880>, <-0.357266, -0.137141, 0.923880>, <-0.390853, -0.150034, 0.908143> }
triangle { <-0.390853, -0.150034, 0.908143>, <-0.398169, -0.129373, 0.908143>, <-0.363954, -0.118256, 0.923880> }
triangle { <-0.398169, -0.129373, 0.908143>, <-0.390853, -0.150034, 0.908143>, <-0.423837, -0.162696, 0.891007> }
triangle { <-0.423837, -0.162696, 0.891007>, <-0.431771, -0.140291, 0.891007>, <-0.398169, -0.129373, 0.908143> }
triangle { <-0.431771, -0.140291, 0.891007>, <-0.423837, -0.162696, 0.891007>, <-0.456167, -0.175106, 0.872496> }
triangle { <-0.456167, -0.175106, 0.872496>, <-0.464706, -0.150992, 0.872496>, <-0.431771, -0.140291, 0.891007> }
triangle { <-0.464706, -0.150992, 0.872496>, <-0.456167, -0.175106, 0.872496>, <-0.487794, -0.187247, 0.852640> }
triangle { <-0.487794, -0.187247, 0.852640>, <-0.496926, -0.161461, 0.852640>, <-0.464706, -0.150992, 0.872496> }
triangle { <-0.496926, -0.161461, 0.852640>, <-0.487794, -0.187247, 0.852640>, <-0.518669, -0.199099, 0.831470> }
triangle { <-0.518669, -0.199099, 0.831470>, <-0.528379, -0.171681, 0.831470>, <-0.496926, -0.161461, 0.852640> }
triangle { <-0.528379, -0.171681, 0.831470>, <-0.518669, -0.199099, 0.831470>, <-0.548745, -0.210643, 0.809017> }
triangle { <-0.548745, -0.210643, 0.809017>, <-0.559017, -0.181636, 0.809017>, <-0.528379, -0.171681, 0.831470> }
triangle { <-0.559017, -0.181636, 0.809017>, <-0.548745, -0.210643, 0.809017>, <-0.577974, -0.221863, 0.785317> }
triangle { <-0.577974, -0.221863, 0.785317>, <-0.588793, -0.191311, 0.785317>, <-0.559017, -0.181636, 0.809017> }
triangle { <-0.588793, -0.191311, 0.785317>, <-0.577974, -0.221863, 0.785317>, <-0.606312, -0.232741, 0.760406> }
triangle { <-0.606312, -0.232741, 0.760406>, <-0.617662, -0.200690, 0.760406>, <-0.588793, -0.191311, 0.785317> }
triangle { <-0.617662, -0.200690, 0.760406>, <-0.606312, -0.232741, 0.760406>, <-0.633715, -0.243260, 0.734323> }
triangle { <-0.633715, -0.243260, 0.734323>, <-0.645578, -0.209761, 0.734323>, <-0.617662, -0.200690, 0.760406> }
triangle { <-0.645578, -0.209761, 0.734323>, <-0.633715, -0.243260, 0.734323>, <-0.660141, -0.253404, 0.707107> }
triangle { <-0.660141, -0.253404, 0.707107>, <-0.672499, -0.218508, 0.707107>, <-0.645578, -0.209761, 0.734323> }
triangle { <-0.672499, -0.218508, 0.707107>, <-0.660141, -0.253404, 0.707107>, <-0.685549, -0.263158, 0.678801> }
triangle { <-0.685549, -0.263158, 0.678801>, <-0.698382, -0.226918, 0.678801>, <-0.672499, -0.218508, 0.707107> }
triangle { <-0.698382, -0.226918, 0.678801>, <-0.685549, -0.263158, 0.678801>, <-0.709900, -0.272505, 0.649448> }
triangle { <-0.709900, -0.272505, 0.649448>, <-0.723189, -0.234978, 0.649448>, <-0.698382, -0.226918, 0.678801> }
triangle { <-0.723189, -0.234978, 0.649448>, <-0.709900, -0.272505, 0.649448>, <-0.733157, -0.281432, 0.619094> }
triangle { <-0.733157, -0.281432, 0.619094>, <-0.746881, -0.242676, 0.619094>, <-0.723189, -0.234978, 0.649448> }
triangle { <-0.746881, -0.242676, 0.619094>, <-0.733157, -0.281432, 0.619094>, <-0.755282, -0.289926, 0.587785> }
triangle { <-0.755282, -0.289926, 0.587785>, <-0.769421, -0.250000, 0.587785>, <-0.746881, -0.242676, 0.619094> }
triangle { <-0.769421, -0.250000, 0.587785>, <-0.755282, -0.289926, 0.587785>, <-0.776244, -0.297972, 0.555570> }
triangle { <-0.776244, -0.297972, 0.555570>, <-0.790775, -0.256938, 0.555570>, <-0.769421, -0.250000, 0.587785> }
triangle { <-0.790775, -0.256938, 0.555570>, <-0.776244, -0.297972, 0.555570>, <-0.796008, -0.305559, 0.522499> }
triangle { <-0.796008, -0.305559, 0.522499>, <-0.810909, -0.263480, 0.522499>, <-0.790775, -0.256938, 0.555570> }
triangle { <-0.810909, -0.263480, 0.522499>, <-0.796008, -0.305559, 0.522499>, <-0.814545, -0.312675, 0.488621> }
triangle { <-0.814545, -0.312675, 0.488621>, <-0.829793, -0.269616, 0.488621>, <-0.810909, -0.263480, 0.522499> }
triangle { <-0.829793, -0.269616, 0.488621>, <-0.814545, -0.312675, 0.488621>, <-0.831826, -0.319308, 0.453990> }
triangle { <-0.831826, -0.319308, 0.453990>, <-0.847398, -0.275336, 0.453990>, <-0.829793, -0.269616, 0.488621> }
triangle { <-0.847398, -0.275336, 0.453990>, <-0.831826, -0.319308, 0.453990>, <-0.847825, -0.325449, 0.418660> }
triangle { <-0.847825, -0.325449, 0.418660>, <-0.863695, -0.280632, 0.418660>, <-0.847398, -0.275336, 0.453990> }
triangle { <-0.863695, -0.280632, 0.418660>, <-0.847825, -0.325449, 0.418660>, <-0.862516, -0.331089, 0.382683> }
triangle { <-0.862516, -0.331089, 0.382683>, <-0.878662, -0.285494, 0.382683>, <-0.863695, -0.280632, 0.418660> }
triangle { <-0.878662, -0.285494, 0.382683>, <-0.862516, -0.331089, 0.382683>, <-0.875877, -0.336218, 0.346117> }
triangle { <-0.875877, -0.336218, 0.346117>, <-0.892273, -0.289917, 0.346117>, <-0.878662, -0.285494, 0.382683> }
triangle { <-0.892273, -0.289917, 0.346117>, <-0.875877, -0.336218, 0.346117>, <-0.887888, -0.340828, 0.309017> }
triangle { <-0.887888, -0.340828, 0.309017>, <-0.904508, -0.293893, 0.309017>, <-0.892273, -0.289917, 0.346117> }
triangle { <-0.904508, -0.293893, 0.309017>, <-0.887888, -0.340828, 0.309017>, <-0.898529, -0.344913, 0.271440> }
triangle { <-0.898529, -0.344913, 0.271440>, <-0.915349, -0.297415, 0.271440>, <-0.904508, -0.293893, 0.309017> }
triangle { <-0.915349, -0.297415, 0.271440>, <-0.898529, -0.344913, 0.271440>, <-0.907786, -0.348466, 0.233445> }
triangle { <-0.907786, -0.348466, 0.233445>, <-0.924779, -0.300479, 0.233445>, <-0.915349, -0.297415, 0.271440> }
triangle { <-0.924779, -0.300479, 0.233445>, <-0.907786, -0.348466, 0.233445>, <-0.915642, -0.351482, 0.195090> }
triangle { <-0.915642, -0.351482, 0.195090>, <-0.932782, -0.303079, 0.195090>, <-0.924779, -0.300479, 0.233445> }
triangle { <-0.932782, -0.303079, 0.195090>, <-0.915642, -0.351482, 0.195090>, <-0.922087, -0.353956, 0.156434> }
triangle { <-0.922087, -0.353956, 0.156434>, <-0.939347, -0.305212, 0.156434>, <-0.932782, -0.303079, 0.195090> }
triangle { <-0.939347, -0.305212, 0.156434>, <-0.922087, -0.353956, 0.156434>, <-0.927109, -0.355884, 0.117537> }
triangle { <-0.927109, -0.355884, 0.117537>, <-0.944464, -0.306875, 0.117537>, <-0.939347, -0.305212, 0.156434> }
triangle { <-0.944464, -0.306875, 0.117537>, <-0.927109, -0.355884, 0.117537>, <-0.930703, -0.357263, 0.078459> }
triangle { <-0.930703, -0.357263, 0.078459>, <-0.948125, -0.308064, 0.078459>, <-0.944464, -0.306875, 0.117537> }
triangle { <-0.948125, -0.308064, 0.078459>, <-0.930703, -0.357263, 0.078459>, <-0.932861, -0.358092, 0.039260> }
triangle { <-0.932861, -0.358092, 0.039260>, <-0.950323, -0.308779, 0.039260>, <-0.948125, -0.308064, 0.078459> }
triangle { <-0.950323, -0.308779, 0.039260>, <-0.932861, -0.358092, 0.039260>, <-0.933580, -0.358368, -0.000000> }
triangle { <-0.933580, -0.358368, -0.000000>, <-0.951057, -0.309017, -0.000000>, <-0.950323, -0.308779, 0.039260> }
triangle { <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <-0.035866, -0.015968, 0.999229> }
triangle { <-0.035866, -0.015968, 0.999229>, <-0.036652, -0.014069, 0.999229>, <0.000000, 0.000000, 1.000000> }
triangle { <-0.036652, -0.014069, 0.999229>, <-0.035866, -0.015968, 0.999229>, <-0.071676, -0.031912, 0.996917> }
triangle { <-0.071676, -0.031912, 0.996917>, <-0.073248, -0.028117, 0.996917>, <-0.036652, -0.014069, 0.999229> }
triangle { <-0.073248, -0.028117, 0.996917>, <-0.071676, -0.031912, 0.996917>, <-0.107376, -0.047807, 0.993068> }
triangle { <-0.107376, -0.047807, 0.993068>, <-0.109731, -0.042122, 0.993068>, <-0.073248, -0.028117, 0.996917> }
triangle { <-0.109731, -0.042122, 0.993068>, <-0.107376, -0.047807, 0.993068>, <-0.142910, -0.063628, 0.987688> }
triangle { <-0.142910, -0.063628, 0.987688>, <-0.146044, -0.056061, 0.987688>, <-0.109731, -0.042122, 0.993068> }
triangle { <-0.146044, -0.056061, 0.987688>, <-0.142910, -0.063628, 0.987688>, <-0.178224, -0.079350, 0.980785> }
triangle { <-0.178224, -0.079350, 0.980785>, <-0.182133, -0.069914, 0.980785>, <-0.146044, -0.056061, 0.987688> }
triangle { <-0.182133, -0.069914, 0.980785>, <-0.178224, -0.079350, 0.980785>, <-0.213263, -0.094951, 0.972370> }
triangle { <-0.213263, -0.094951, 0.972370>, <-0.217940, -0.083659, 0.972370>, <-0.182133, -0.069914, 0.980785> }
triangle { <-0.217940, -0.083659, 0.972370>, <-0.213263, -0.094951, 0.972370>, <-0.247973, -0.110405, 0.962455> }
triangle { <-0.247973, -0.110405, 0.962455>, <-0.253411, -0.097276, 0.962455>, <-0.217940, -0.083659, 0.972370> }
triangle { <-0.253411, -0.097276, 0.962455>, <-0.247973, -0.110405, 0.962455>, <-0.282301, -0.125689, 0.951057> }
triangle { <-0.282301, -0.125689, 0.951057>, <-0.288492, -0.110742, 0.951057>, <-0.253411, -0.097276, 0.962455> }
triangle { <-0.288492, -0.110742, 0.951057>, <-0.282301, -0.125689, 0.951057>, <-0.316194, -0.140778, 0.938191> }
triangle { <-0.316194, -0.140778, 0.938191>, <-0.323128, -0.124037, 0.938191>, <-0.288492, -0.110742, 0.951057> }
triangle { <-0.323128, -0.124037, 0.938191>, <-0.316194, -0.140778, 0.938191>, <-0.349599, -0.155651, 0.923880> }
triangle { <-0.349599, -0.155651, 0.923880>, <-0.357266, -0.137141, 0.923880>, <-0.323128, -0.124037, 0.938191> }
triangle { <-0.357266, -0.137141, 0.923880>, <-0.349599, -0.155651, 0.923880>, <-0.382465, -0.170284, 0.908143> }
triangle { <-0.382465, -0.170284, 0.908143>, <-0.390853, -0.150034, 0.908143>, <-0.357266, -0.137141, 0.923880> }
triangle { <-0.390853, -0.150034, 0.908143>, <-0.382465, -0.170284, 0.908143>, <-0.414741, -0.184655, 0.891007> }
triangle { <-0.414741, -0.184655, 0.891007>, <-0.423837, -0.162696, 0.891007>, <-0.390853, -0.150034, 0.908143> }
triangle { <-0.423837, -0.162696, 0.891007>, <-0.414741, -0.184655, 0.891007>, <-0.446378, -0.198740, 0.872496> }
triangle { <-0.446378, -0.198740, 0.872496>, <-0.456167, -0.175106, 0.872496>, <-0.423837, -0.162696, 0.891007> }
triangle { <-0.456167, -0.175106, 0.872496>, <-0.446378, -0.198740, 0.872496>, <-0.477326, -0.212519, 0.852640> }
triangle { <-0.477326, -0.212519, 0.852640>, <-0.487794, -0.187247, 0.852640>, <-0.456167, -0.175106, 0.872496> }
triangle { <-0.487794, -0.187247, 0.852640>, <-0.477326, -0.212519, 0.852640>, <-0.507539, -0.225971, 0.831470> }
triangle { <-0.507539, -0.225971, 0.831470>, <-0.518669, -0.199099, 0.831470>, <-0.487794, -0.187247, 0.852640> }
triangle { <-0.518669, -0.199099, 0.831470>, <-0.507539, -0.225971, 0.831470>, <-0.536969, -0.239074, 0.809017> }
triangle { <-0.536969, -0.239074, 0.809017>, <-0.548745, -0.210643, 0.809017>, <-0.518669, -0.199099, 0.831470> }
triangle { <-0.548745, -0.210643, 0.809017>, <-0.536969, -0.239074, 0.809017>, <-0.565570, -0.251808, 0.785317> }
triangle { <-0.565570, -0.251808, 0.785317>, <-0.577974, -0.221863, 0.785317>, <-0.548745, -0.210643, 0.809017> }
triangle { <-0.577974, -0.221863, 0.785317>, <-0.565570, -0.251808, 0.785317>, <-0.593300, -0.264154, 0.760406> }
triangle { <-0.593300, -0.264154, 0.760406>, <-0.606312, -0.232741, 0.760406>, <-0.577974, -0.221863, 0.785317> }
triangle { <-0.606312, -0.232741, 0.760406>, <-0.593300, -0.264154, 0.760406>, <-0.620115, -0.276093, 0.734323> }
triangle { <-0.620115, -0.276093, 0.734323>, <-0.633715, -0.243260, 0.734323>, <-0.606312, -0.232741, 0.760406> }
triangle { <-0.633715, -0.243260, 0.734323>, <-0.620115, -0.276093, 0.734323>, <-0.645974, -0.287606, 0.707107> }
triangle { <-0.645974, -0.287606, 0.707107>, <-0.660141, -0.253404, 0.707107>, <-0.633715, -0.243260, 0.734323> }
triangle { <-0.660141, -0.253404, 0.707107>, <-0.645974, -0.287606, 0.707107>, <-0.670837, -0.298676, 0.678801> }
triangle { <-0.670837, -0.298676, 0.678801>, <-0.685549, -0.263158, 0.678801>, <-0.660141, -0.253404, 0.707107> }
triangle { <-0.685549, -0.263158, 0.678801>, <-0.670837, -0.298676, 0.678801>, <-0.694665, -0.309285, 0.649448> }
triangle { <-0.694665, -0.309285, 0.649448>, <-0.709900, -0.272505, 0.649448>, <-0.685549, -0.263158, 0.678801> }
triangle { <-0.709900, -0.272505, 0.649448>, <-0.694665, -0.309285, 0.649448>, <-0.717423, -0.319417, 0.619094> }
triangle { <-0.717423, -0.319417, 0.619094>, <-0.733157, -0.281432, 0.619094>, <-0.709900, -0.272505, 0.649448> }
triangle { <-0.733157, -0.281432, 0.619094>, <-0.717423, -0.319417, 0.619094>, <-0.739074, -0.329057, 0.587785> }
triangle { <-0.739074, -0.329057, 0.587785>, <-0.755282, -0.289926, 0.587785>, <-0.733157, -0.281432, 0.619094> }
triangle { <-0.755282, -0.289926, 0.587785>, <-0.739074, -0.329057, 0.587785>, <-0.759585, -0.338189, 0.555570> }
triangle { <-0.759585, -0.338189, 0.555570>, <-0.776244, -0.297972, 0.555570>, <-0.755282, -0.289926, 0.587785> }
triangle { <-0.776244, -0.297972, 0.555570>, <-0.759585, -0.338189, 0.555570>, <-0.778926, -0.346800, 0.522499> }
triangle { <-0.778926, -0.346800, 0.522499>, <-0.796008, -0.305559, 0.522499>, <-0.776244, -0.297972, 0.555570> }
triangle { <-0.796008, -0.305559, 0.522499>, <-0.778926, -0.346800, 0.522499>, <-0.797065, -0.354876, 0.488621> }
triangle { <-0.797065, -0.354876, 0.488621>, <-0.814545, -0.312675, 0.488621>, <-0.796008, -0.305559, 0.522499> }
triangle { <-0.814545, -0.312675, 0.488621>, <-0.797065, -0.354876, 0.488621>, <-0.813975, -0.362405, 0.453990> }
triangle { <-0.813975, -0.362405, 0.453990>, <-0.831826, -0.319308, 0.453990>, <-0.814545, -0.312675, 0.488621> }
triangle { <-0.831826, -0.319308, 0.453990>, <-0.813975, -0.362405, 0.453990>, <-0.829630, -0.369375, 0.418660> }
triangle { <-0.829630, -0.369375, 0.418660>, <-0.847825, -0.325449, 0.418660>, <-0.831826, -0.319308, 0.453990> }
triangle { <-0.847825, -0.325449, 0.418660>, <-0.829630, -0.369375, 0.418660>, <-0.844006, -0.375776, 0.382683> }
triangle { <-0.844006, -0.375776, 0.382683>, <-0.862516, -0.331089, 0.382683>, <-0.847825, -0.325449, 0.418660> }
triangle { <-0.862516, -0.331089, 0.382683>, <-0.844006, -0.375776, 0.382683>, <-0.857080, -0.381597, 0.346117> }
triangle { <-0.857080, -0.381597, 0.346117>, <-0.875877, -0.336218, 0.346117>, <-0.862516, -0.331089, 0.382683> }
triangle { <-0.875877, -0.336218, 0.346117>, <-0.857080, -0.381597, 0.346117>, <-0.868833, -0.386830, 0.309017> }
triangle { <-0.868833, -0.386830, 0.309017>, <-0.887888, -0.340828, 0.309017>, <-0.875877, -0.336218, 0.346117> }
triangle { <-0.887888, -0.340828, 0.309017>, <-0.868833, -0.386830, 0.309017>, <-0.879247, -0.391466, 0.271440> }
triangle { <-0.879247, -0.391466, 0.271440>, <-0.898529, -0.344913, 0.271440>, <-0.887888, -0.340828, 0.309017> }
triangle { <-0.898529, -0.344913, 0.271440>, <-0.879247, -0.391466, 0.271440>, <-0.888304, -0.395498, 0.233445> }
triangle { <-0.888304, -0.395498, 0.233445>, <-0.907786, -0.348466, 0.233445>, <-0.898529, -0.344913, 0.271440> }
triangle { <-0.907786, -0.348466, 0.233445>, <-0.888304, -0.395498, 0.233445>, <-0.895992, -0.398921, 0.195090> }
triangle { <-0.895992, -0.398921, 0.195090>, <-0.915642, -0.351482, 0.195090>, <-0.907786, -0.348466, 0.233445> }
triangle { <-0.915642, -0.351482, 0.195090>, <-0.895992, -0.398921, 0.195090>, <-0.902298, -0.401729, 0.156434> }
triangle { <-0.902298, -0.401729, 0.156434>, <-0.922087, -0.353956, 0.156434>, <-0.915642, -0.351482, 0.195090> }
triangle { <-0.922087, -0.353956, 0.156434>, <-0.902298, -0.401729, 0.156434>, <-0.907213, -0.403917, 0.117537> }
triangle { <-0.907213, -0.403917, 0.117537>, <-0.927109, -0.355884, 0.117537>, <-0.922087, -0.353956, 0.156434> }
triangle { <-0.927109, -0.355884, 0.117537>, <-0.907213, -0.403917, 0.117537>, <-0.910729, -0.405483, 0.078459> }
triangle { <-0.910729, -0.405483, 0.078459>, <-0.930703, -0.357263, 0.078459>, <-0.927109, -0.355884, 0.117537> }
triangle { <-0.930703, -0.357263, 0.078459>, <-0.910729, -0.405483, 0.078459>, <-0.912841, -0.406423, 0.039260> }
triangle { <-0.912841, -0.406423, 0.039260>, <-0.932861, -0.358092, 0.039260>, <-0.930703, -0.357263, 0.078459> }
triangle { <-0.932861, -0.358092, 0.039260>, <-0.912841, -0.406423, 0.039260>, <-0.913545, -0.406737, -0.000000> }
triangle { <-0.913545, -0.406737, -0.000000>, <-0.933580, -0.358368, -0.000000>, <-0.932861, -0.358092, 0.039260> }
triangle { <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <-0.034981, -0.017824, 0.999229> }
triangle { <-0.034981, -0.017824, 0.999229>, <-0.035866, -0.015968, 0.999229>, <0.000000, 0.000000, 1.000000> }
triangle { <-0.035866, -0.015968, 0.999229>, <-0.034981, -0.017824, 0.999229>, <-0.069908, -0.035620, 0.996917> }
triangle { <-0.069908, -0.035620, 0.996917>, <-0.071676, -0.031912, 0.996917>, <-0.035866, -0.015968, 0.999229> }
triangle { <-0.071676, -0.031912, 0.996917>, <-0.069908, -0.035620, 0.996917>, <-0.104727, -0.053361, 0.993068> }
triangle { <-0.104727, -0.053361, 0.993068>, <-0.107376, -0.047807, 0.993068>, <-0.071676, -0.031912, 0.996917> }
triangle { <-0.107376, -0.047807, 0.993068>, <-0.104727, -0.053361, 0.993068>, <-0.139384, -0.071020, 0.987688> }
triangle { <-0.139384, -0.071020, 0.987688>, <-0.142910, -0.063628, 0.987688>, <-0.107376, -0.047807, 0.993068> }
triangle { <-0.142910, -0.063628, 0.987688>, <-0.139384, -0.071020, 0.987688>, <-0.173827, -0.088569, 0.980785> }
triangle { <-0.173827, -0.088569, 0.980785>, <-0.178224, -0.079350, 0.980785>, <-0.142910, -0.063628, 0.987688> }
triangle { <-0.178224, -0.079350, 0.980785>, <-0.173827, -0.088569, 0.980785>, <-0.208001, -0.105982, 0.972370> }
triangle { <-0.208001, -0.105982, 0.972370>, <-0.213263, -0.094951, 0.972370>, <-0.178224, -0.079350, 0.980785> }
triangle { <-0.213263, -0.094951, 0.972370>, <-0.208001, -0.105982, 0.972370>, <-0.241855, -0.123231, 0.962455> }
triangle { <-0.241855, -0.123231, 0.962455>, <-0.247973, -0.110405, 0.962455>, <-0.213263, -0.094951, 0.972370> }
triangle { <-0.247973, -0.110405, 0.962455>, <-0.241855, -0.123231, 0.962455>, <-0.275336, -0.140291, 0.951057> }
triangle { <-0.275336, -0.140291, 0.951057>, <-0.282301, -0.125689, 0.951057>, <-0.247973, -0.110405, 0.962455> }
triangle { <-0.282301, -0.125689, 0.951057>, <-0.275336, -0.140291, 0.951057>, <-0.308393, -0.157134, 0.938191> }
triangle { <-0.308393, -0.157134, 0.938191>, <-0.316194, -0.140778, 0.938191>, <-0.282301, -0.125689, 0.951057> }
triangle { <-0.316194, -0.140778, 0.938191>, <-0.308393, -0.157134, 0.938191>, <-0.340973, -0.173735, 0.923880> }
triangle { <-0.340973, -0.173735, 0.923880>, <-0.349599, -0.155651, 0.923880>, <-0.316194, -0.140778, 0.938191> }
triangle { <-0.349599, -0.155651, 0.923880>, <-0.340973, -0.173735, 0.923880>, <-0.373029, -0.190068, 0.908143> }
triangle { <-0.373029, -0.190068, 0.908143>, <-0.382465, -0.170284, 0.908143>, <-0.349599, -0.155651, 0.923880> }
triangle { <-0.382465, -0.170284, 0.908143>, <-0.373029, -0.190068, 0.908143>, <-0.404508, -0.206107, 0.891007> }
triangle { <-0.404508, -0.206107, 0.891007>, <-0.414741, -0.184655, 0.891007>, <-0.382465, -0.170284, 0.908143> }
triangle { <-0.414741, -0.184655, 0.891007>, <-0.404508, -0.206107, 0.891007>, <-0.435365, -0.221829, 0.872496> }
triangle { <-0.435365, -0.221829, 0.872496>, <-0.446378, -0.198740, 0.872496>, <-0.414741, -0.184655, 0.891007> }
triangle { <-0.446378, -0.198740, 0.872496>, <-0.435365, -0.221829, 0.872496>, <-0.465550, -0.237209, 0.852640> }
triangle { <-0.465550, -0.237209, 0.852640>, <-0.477326, -0.212519, 0.852640>, <-0.446378, -0.198740, 0.872496> }
triangle { <-0.477326, -0.212519, 0.852640>, <-0.465550, -0.237209, 0.852640>, <-0.495017, -0.252224, 0.831470> }
triangle { <-0.495017, -0.252224, 0.831470>, <-0.507539, -0.225971, 0.831470>, <-0.477326, -0.212519, 0.852640> }
triangle { <-0.507539, -0.225971, 0.831470>, <-0.495017, -0.252224, 0.831470>, <-0.523720, -0.266849, 0.809017> }
triangle { <-0.523720, -0.266849, 0.809017>, <-0.536969, -0.239074, 0.809017>, <-0.507539, -0.225971, 0.831470> }
triangle { <-0.536969, -0.239074, 0.809017>, <-0.523720, -0.266849, 0.809017>, <-0.551617, -0.281063, 0.785317> }
triangle { <-0.551617, -0.281063, 0.785317>, <-0.565570, -0.251808, 0.785317>, <-0.536969, -0.239074, 0.809017> }
triangle { <-0.565570, -0.251808, 0.785317>, <-0.551617, -0.281063, 0.785317>, <-0.578662, -0.294843, 0.760406> }
triangle { <-0.578662, -0.294843, 0.760406>, <-0.593300, -0.264154, 0.760406>, <-0.565570, -0.251808, 0.785317> }
triangle { <-0.593300, -0.264154, 0.760406>, <-0.578662, -0.294843, 0.760406>, <-0.604816, -0.308169, 0.734323> }
triangle { <-0.604816, -0.308169, 0.734323>, <-0.620115, -0.276093, 0.734323>, <-0.593300, -0.264154, 0.760406> }
triangle { <-0.620115, -0.276093, 0.734323>, <-0.604816, -0.308169, 0.734323>, <-0.630037, -0.321020, 0.707107> }
triangle { <-0.630037, -0.321020, 0.707107>, <-0.645974, -0.287606, 0.707107>, <-0.620115, -0.276093, 0.734323> }
triangle { <-0.645974, -0.287606, 0.707107>, <-0.630037, -0.321020, 0.707107>, <-0.654286, -0.333375, 0.678801> }
triangle { <-0.654286, -0.333375, 0.678801>, <-0.670837, -0.298676, 0.678801>, <-0.645974, -0.287606, 0.707107> }
triangle { <-0.670837, -0.298676, 0.678801>, <-0.654286, -0.333375, 0.678801>, <-0.677527, -0.345217, 0.649448> }
triangle { <-0.677527, -0.345217, 0.649448>, <-0.694665, -0.309285, 0.649448>, <-0.670837, -0.298676, 0.678801> }
triangle { <-0.694665, -0.309285, 0.649448>, <-0.677527, -0.345217, 0.649448>, <-0.699723, -0.356526, 0.619094> }
triangle { <-0.699723, -0.356526, 0.619094>, <-0.717423, -0.319417, 0.619094>, <-0.694665, -0.309285, 0.649448> }
triangle { <-0.717423, -0.319417, 0.619094>, <-0.699723, -0.356526, 0.619094>, <-0.720839, -0.367286, 0.587785> }
triangle { <-0.720839, -0.367286, 0.587785>, <-0.739074, -0.329057, 0.587785>, <-0.717423, -0.319417, 0.619094> }
triangle { <-0.739074, -0.329057, 0.587785>, <-0.720839, -0.367286, 0.587785>, <-0.740845, -0.377479, 0.555570> }
triangle { <-0.740845, -0.377479, 0.555570>, <-0.759585, -0.338189, 0.555570>, <-0.739074, -0.329057, 0.587785> }
triangle { <-0.759585, -0.338189, 0.555570>, <-0.740845, -0.377479, 0.555570>, <-0.759708, -0.387091, 0.522499> }
triangle { <-0.759708, -0.387091, 0.522499>, <-0.778926, -0.346800, 0.522499>, <-0.759585, -0.338189, 0.555570> }
triangle { <-0.778926, -0.346800, 0.522499>, <-0.759708, -0.387091, 0.522499>, <-0.777400, -0.396105, 0.488621> }
triangle { <-0.777400, -0.396105, 0.488621>, <-0.797065, -0.354876, 0.488621>, <-0.778926, -0.346800, 0.522499> }
triangle { <-0.797065, -0.354876, 0.488621>, <-0.777400, -0.396105, 0.488621>, <-0.793893, -0.404508, 0.453990> }
triangle { <-0.793893, -0.404508, 0.453990>, <-0.813975, -0.362405, 0.453990>, <-0.797065, -0.354876, 0.488621> }
triangle { <-0.813975, -0.362405, 0.453990>, <-0.793893, -0.404508, 0.453990>, <-0.809161, -0.412288, 0.418660> }
triangle { <-0.809161, -0.412288, 0.418660>, <-0.829630, -0.369375, 0.418660>, <-0.813975, -0.362405, 0.453990> }
triangle { <-0.829630, -0.369375, 0.418660>, <-0.809161, -0.412288, 0.418660>, <-0.823183, -0.419433, 0.382683> }
triangle { <-0.823183, -0.419433, 0.382683>, <-0.844006, -0.375776, 0.382683>, <-0.829630, -0.369375, 0.418660> }
triangle { <-0.844006, -0.375776, 0.382683>, <-0.823183, -0.419433, 0.382683>, <-0.835935, -0.425930, 0.346117> }
triangle { <-0.835935, -0.425930, 0.346117>, <-0.857080, -0.381597, 0.346117>, <-0.844006, -0.375776, 0.382683> }
triangle { <-0.857080, -0.381597, 0.346117>, <-0.835935, -0.425930, 0.346117>, <-0.847398, -0.431771, 0.309017> }
triangle { <-0.847398, -0.431771, 0.309017>, <-0.868833, -0.386830, 0.309017>, <-0.857080, -0.381597, 0.346117> }
triangle { <-0.868833, -0.386830, 0.309017>, <-0.847398, -0.431771, 0.309017>, <-0.857554, -0.436946, 0.271440> }
triangle { <-0.857554, -0.436946, 0.271440>, <-0.879247, -0.391466, 0.271440>, <-0.868833, -0.386830, 0.309017> }
triangle { <-0.879247, -0.391466, 0.271440>, <-0.857554, -0.436946, 0.271440>, <-0.866388, -0.441447, 0.233445> }
triangle { <-0.866388, -0.441447, 0.233445>, <-0.888304, -0.395498, 0.233445>, <-0.879247, -0.391466, 0.271440> }
triangle { <-0.888304, -0.395498, 0.233445>, <-0.866388, -0.441447, 0.233445>, <-0.873886, -0.445267, 0.195090> }
triangle { <-0.873886, -0.445267, 0.195090>, <-0.895992, -0.398921, 0.195090>, <-0.888304, -0.395498, 0.233445> }
triangle { <-0.895992, -0.398921, 0.195090>, <-0.873886, -0.445267, 0.195090>, <-0.880037, -0.448401, 0.156434> }
triangle { <-0.880037, -0.448401, 0.156434>, <-0.902298, -0.401729, 0.156434>, <-0.895992, -0.398921, 0.195090> }
triangle { <-0.902298, -0.401729, 0.156434>, <-0.880037, -0.448401, 0.156434>, <-0.884830, -0.450844, 0.117537> }
triangle { <-0.884830, -0.450844, 0.117537>, <-0.907213, -0.403917, 0.117537>, <-0.902298, -0.401729, 0.156434> }
triangle { <-0.907213, -0.403917, 0.117537>, <-0.884830, -0.450844, 0.117537>, <-0.888260, -0.452591, 0.078459> }
triangle { <-0.888260, -0.452591, 0.078459>, <-0.910729, -0.405483, 0.078459>, <-0.907213, -0.403917, 0.117537> }
triangle { <-0.910729, -0.405483, 0.078459>, <-0.888260, -0.452591, 0.078459>, <-0.890320, -0.453640, 0.039260> }
triangle { <-0.890320, -0.453640, 0.039260>, <-0.912841, -0.406423, 0.039260>, <-0.910729, -0.405483, 0.078459> }
triangle { <-0.912841, -0.406423, 0.039260>, <-0.890320, -0.453640, 0.039260>, <-0.891007, -0.453991, -0.000000> }
triangle { <-0.891007, -0.453991, -0.000000>, <-0.913545, -0.406737, -0.000000>, <-0.912841, -0.406423, 0.039260> }
triangle { <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <-0.034000, -0.019630, 0.999229> }
triangle { <-0.034000, -0.019630, 0.999229>, <-0.034981, -0.017824, 0.999229>, <0.000000, 0.000000, 1.000000> }
triangle { <-0.034981, -0.017824, 0.999229>, <-0.034000, -0.019630, 0.999229>, <-0.067948, -0.039230, 0.996917> }
triangle { <-0.067948, -0.039230, 0.996917>, <-0.069908, -0.035620, 0.996917>, <-0.034981, -0.017824, 0.999229> }
triangle { <-0.069908, -0.035620, 0.996917>, <-0.067948, -0.039230, 0.996917>, <-0.101790, -0.058769, 0.993068> }
triangle { <-0.101790, -0.058769, 0.993068>, <-0.104727, -0.053361, 0.993068>, <-0.069908, -0.035620, 0.996917> }
triangle { <-0.104727, -0.053361, 0.993068>, <-0.101790, -0.058769, 0.993068>, <-0.135476, -0.078217, 0.987688> }
triangle { <-0.135476, -0.078217, 0.987688>, <-0.139384, -0.071020, 0.987688>, <-0.104727, -0.053361, 0.993068> }
triangle { <-0.139384, -0.071020, 0.987688>, <-0.135476, -0.078217, 0.987688>, <-0.168953, -0.097545, 0.980785> }
triangle { <-0.168953, -0.097545, 0.980785>, <-0.173827, -0.088569, 0.980785>, <-0.139384, -0.071020, 0.987688> }
triangle { <-0.173827, -0.088569, 0.980785>, <-0.168953, -0.097545, 0.980785>, <-0.202170, -0.116723, 0.972370> }
triangle { <-0.202170, -0.116723, 0.972370>, <-0.208001, -0.105982, 0.972370>, <-0.173827, -0.088569, 0.980785> }
triangle { <-0.208001, -0.105982, 0.972370>, <-0.202170, -0.116723, 0.972370>, <-0.235074, -0.135720, 0.962455> }
triangle { <-0.235074, -0.135720, 0.962455>, <-0.241855, -0.123231, 0.962455>, <-0.208001, -0.105982, 0.972370> }
triangle { <-0.241855, -0.123231, 0.962455>, <-0.235074, -0.135720, 0.962455>, <-0.267617, -0.154508, 0.951057> }
triangle { <-0.267617, -0.154508, 0.951057>, <-0.275336, -0.140291, 0.951057>, <-0.241855, -0.123231, 0.962455> }
triangle { <-0.275336, -0.140291, 0.951057>, <-0.267617, -0.154508, 0.951057>, <-0.299746, -0.173059, 0.938191> }
triangle { <-0.299746, -0.173059, 0.938191>, <-0.308393, -0.157134, 0.938191>, <-0.275336, -0.140291, 0.951057> }
triangle { <-0.308393, -0.157134, 0.938191>, <-0.299746, -0.173059, 0.938191>, <-0.331414, -0.191342, 0.923880> }
triangle { <-0.331414, -0.191342, 0.923880>, <-0.340973, -0.173735, 0.923880>, <-0.308393, -0.157134, 0.938191> }
triangle { <-0.340973, -0.173735, 0.923880>, <-0.331414, -0.191342, 0.923880>, <-0.362570, -0.209330, 0.908143> }
triangle { <-0.362570, -0.209330, 0.908143>, <-0.373029, -0.190068, 0.908143>, <-0.340973, -0.173735, 0.923880> }
triangle { <-0.373029, -0.190068, 0.908143>, <-0.362570, -0.209330, 0.908143>, <-0.393167, -0.226995, 0.891007> }
triangle { <-0.393167, -0.226995, 0.891007>, <-0.404508, -0.206107, 0.891007>, <-0.373029, -0.190068, 0.908143> }
triangle { <-0.404508, -0.206107, 0.891007>, <-0.393167, -0.226995, 0.891007>, <-0.423158, -0.244311, 0.872496> }
triangle { <-0.423158, -0.244311, 0.872496>, <-0.435365, -0.221829, 0.872496>, <-0.404508, -0.206107, 0.891007> }
triangle { <-0.435365, -0.221829, 0.872496>, <-0.423158, -0.244311, 0.872496>, <-0.452497, -0.261249, 0.852640> }
triangle { <-0.452497, -0.261249, 0.852640>, <-0.465550, -0.237209, 0.852640>, <-0.435365, -0.221829, 0.872496> }
triangle { <-0.465550, -0.237209, 0.852640>, <-0.452497, -0.261249, 0.852640>, <-0.481138, -0.277785, 0.831470> }
triangle { <-0.481138, -0.277785, 0.831470>, <-0.495017, -0.252224, 0.831470>, <-0.465550, -0.237209, 0.852640> }
triangle { <-0.495017, -0.252224, 0.831470>, <-0.481138, -0.277785, 0.831470>, <-0.509037, -0.293893, 0.809017> }
triangle { <-0.509037, -0.293893, 0.809017>, <-0.523720, -0.266849, 0.809017>, <-0.495017, -0.252224, 0.831470> }
triangle { <-0.523720, -0.266849, 0.809017>, <-0.509037, -0.293893, 0.809017>, <-0.536151, -0.309547, 0.785317> }
triangle { <-0.536151, -0.309547, 0.785317>, <-0.551617, -0.281063, 0.785317>, <-0.523720, -0.266849, 0.809017> }
triangle { <-0.551617, -0.281063, 0.785317>, <-0.536151, -0.309547, 0.785317>, <-0.562439, -0.324724, 0.760406> }
triangle { <-0.562439, -0.324724, 0.760406>, <-0.578662, -0.294843, 0.760406>, <-0.551617, -0.281063, 0.785317> }
triangle { <-0.578662, -0.294843, 0.760406>, <-0.562439, -0.324724, 0.760406>, <-0.587859, -0.339400, 0.734323> }
triangle { <-0.587859, -0.339400, 0.734323>, <-0.604816, -0.308169, 0.734323>, <-0.578662, -0.294843, 0.760406> }
triangle { <-0.604816, -0.308169, 0.734323>, <-0.587859, -0.339400, 0.734323>, <-0.612372, -0.353553, 0.707107> }
triangle { <-0.612372, -0.353553, 0.707107>, <-0.630037, -0.321020, 0.707107>, <-0.604816, -0.308169, 0.734323> }
triangle { <-0.630037, -0.321020, 0.707107>, <-0.612372, -0.353553, 0.707107>, <-0.635942, -0.367161, 0.678801> }
triangle { <-0.635942, -0.367161, 0.678801>, <-0.654286, -0.333375, 0.678801>, <-0.630037, -0.321020, 0.707107> }
triangle { <-0.654286, -0.333375, 0.678801>, <-0.635942, -0.367161, 0.678801>, <-0.658531, -0.380203, 0.649448> }
triangle { <-0.658531, -0.380203, 0.649448>, <-0.677527, -0.345217, 0.649448>, <-0.654286, -0.333375, 0.678801> }
triangle { <-0.677527, -0.345217, 0.649448>, <-0.658531, -0.380203, 0.649448>, <-0.680104, -0.392658, 0.619094> }
triangle { <-0.680104, -0.392658, 0.619094>, <-0.699723, -0.356526, 0.619094>, <-0.677527, -0.345217, 0.649448> }
triangle { <-0.699723, -0.356526, 0.619094>, <-0.680104, -0.392658, 0.619094>, <-0.700629, -0.404508, 0.587785> }
triangle { <-0.700629, -0.404508, 0.587785>, <-0.720839, -0.367286, 0.587785>, <-0.699723, -0.356526, 0.619094> }
triangle { <-0.720839, -0.367286, 0.587785>, <-0.700629, -0.404508, 0.587785>, <-0.720074, -0.415735, 0.555570> }
triangle { <-0.720074, -0.415735, 0.555570>, <-0.740845, -0.377479, 0.555570>, <-0.720839, -0.367286, 0.587785> }
triangle { <-0.740845, -0.377479, 0.555570>, <-0.720074, -0.415735, 0.555570>, <-0.738408, -0.426320, 0.522499> }
triangle { <-0.738408, -0.426320, 0.522499>, <-0.759708, -0.387091, 0.522499>, <-0.740845, -0.377479, 0.555570> }
triangle { <-0.759708, -0.387091, 0.522499>, <-0.738408, -0.426320, 0.522499>, <-0.755604, -0.436248, 0.488621> }
triangle { <-0.755604, -0.436248, 0.488621>, <-0.777400, -0.396105, 0.488621>, <-0.759708, -0.387091, 0.522499> }
triangle { <-0.777400, -0.396105, 0.488621>, <-0.755604, -0.436248, 0.488621>, <-0.771634, -0.445503, 0.453990> }
triangle { <-0.771634, -0.445503, 0.453990>, <-0.793893, -0.404508, 0.453990>, <-0.777400, -0.396105, 0.488621> }
triangle { <-0.793893, -0.404508, 0.453990>, <-0.771634, -0.445503, 0.453990>, <-0.786475, -0.454072, 0.418660> }
triangle { <-0.786475, -0.454072, 0.418660>, <-0.809161, -0.412288, 0.418660>, <-0.793893, -0.404508, 0.453990> }
triangle { <-0.809161, -0.412288, 0.418660>, <-0.786475, -0.454072, 0.418660>, <-0.800103, -0.461940, 0.382683> }
triangle { <-0.800103, -0.461940, 0.382683>, <-0.823183, -0.419433, 0.382683>, <-0.809161, -0.412288, 0.418660> }
triangle { <-0.823183, -0.419433, 0.382683>, <-0.800103, -0.461940, 0.382683>, <-0.812498, -0.469096, 0.346117> }
triangle { <-0.812498, -0.469096, 0.346117>, <-0.835935, -0.425930, 0.346117>, <-0.823183, -0.419433, 0.382683> }
triangle { <-0.835935, -0.425930, 0.346117>, <-0.812498, -0.469096, 0.346117>, <-0.823639, -0.475528, 0.309017> }
triangle { <-0.823639, -0.475528, 0.309017>, <-0.847398, -0.431771, 0.309017>, <-0.835935, -0.425930, 0.346117> }
triangle { <-0.847398, -0.431771, 0.309017>, <-0.823639, -0.475528, 0.309017>, <-0.833511, -0.481228, 0.271440> }
triangle { <-0.833511, -0.481228, 0.271440>, <-0.857554, -0.436946, 0.271440>, <-0.847398, -0.431771, 0.309017> }
triangle { <-0.857554, -0.436946, 0.271440>, <-0.833511, -0.481228, 0.271440>, <-0.842097, -0.486185, 0.233445> }
triangle { <-0.842097, -0.486185, 0.233445>, <-0.866388, -0.441447, 0.233445>, <-0.857554, -0.436946, 0.271440> }
triangle { <-0.866388, -0.441447, 0.233445>, <-0.842097, -0.486185, 0.233445>, <-0.849385, -0.490393, 0.195090> }
triangle { <-0.849385, -0.490393, 0.195090>, <-0.873886, -0.445267, 0.195090>, <-0.866388, -0.441447, 0.233445> }
triangle { <-0.873886, -0.445267, 0.195090>, <-0.849385, -0.490393, 0.195090>, <-0.855363, -0.493844, 0.156434> }
triangle { <-0.855363, -0.493844, 0.156434>, <-0.880037, -0.448401, 0.156434>, <-0.873886, -0.445267, 0.195090> }
triangle { <-0.880037, -0.448401, 0.156434>, <-0.855363, -0.493844, 0.156434>, <-0.860023, -0.496534, 0.117537> }
triangle { <-0.860023, -0.496534, 0.117537>, <-0.884830, -0.450844, 0.117537>, <-0.880037, -0.448401, 0.156434> }
triangle { <-0.884830, -0.450844, 0.117537>, <-0.860023, -0.496534, 0.117537>, <-0.863356, -0.498459, 0.078459> }
triangle { <-0.863356, -0.498459, 0.078459>, <-0.888260, -0.452591, 0.078459>, <-0.884830, -0.450844, 0.117537> }
triangle { <-0.888260, -0.452591, 0.078459>, <-0.863356, -0.498459, 0.078459>, <-0.865358, -0.499615, 0.039260> }
triangle { <-0.865358, -0.499615, 0.039260>, <-0.890320, -0.453640, 0.039260>, <-0.888260, -0.452591, 0.078459> }
triangle { <-0.890320, -0.453640, 0.039260>, <-0.865358, -0.499615, 0.039260>, <-0.866025, -0.500000, -0.000000> }
triangle { <-0.866025, -0.500000, -0.000000>, <-0.891007, -0.453991, -0.000000>, <-0.890320, -0.453640, 0.039260> }
triangle { <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <-0.032926, -0.021382, 0.999229> }
triangle { <-0.032926, -0.021382, 0.999229>, <-0.034000, -0.019630, 0.999229>, <0.000000, 0.000000, 1.000000> }
triangle { <-0.034000, -0.019630, 0.999229>, <-0.032926, -0.021382, 0.999229>, <-0.065801, -0.042732, 0.996917> }
triangle { <-0.065801, -0.042732, 0.996917>, <-0.067948, -0.039230, 0.996917>, <-0.034000, -0.019630, 0.999229> }
triangle { <-0.067948, -0.039230, 0.996917>, <-0.065801, -0.042732, 0.996917>, <-0.098575, -0.064015, 0.993068> }
triangle { <-0.098575, -0.064015, 0.993068>, <-0.101790, -0.058769, 0.993068>, <-0.067948, -0.039230, 0.996917> }
triangle { <-0.101790, -0.058769, 0.993068>, <-0.098575, -0.064015, 0.993068>, <-0.131197, -0.085200, 0.987688> }
triangle { <-0.131197, -0.085200, 0.987688>, <-0.135476, -0.078217, 0.987688>, <-0.101790, -0.058769, 0.993068> }
triangle { <-0.135476, -0.078217, 0.987688>, <-0.131197, -0.085200, 0.987688>, <-0.163617, -0.106254, 0.980785> }
triangle { <-0.163617, -0.106254, 0.980785>, <-0.168953, -0.097545, 0.980785>, <-0.135476, -0.078217, 0.987688> }
triangle { <-0.168953, -0.097545, 0.980785>, <-0.163617, -0.106254, 0.980785>, <-0.195784, -0.127143, 0.972370> }
triangle { <-0.195784, -0.127143, 0.972370>, <-0.202170, -0.116723, 0.972370>, <-0.168953, -0.097545, 0.980785> }
triangle { <-0.202170, -0.116723, 0.972370>, <-0.195784, -0.127143, 0.972370>, <-0.227649, -0.147837, 0.962455> }
triangle { <-0.227649, -0.147837, 0.962455>, <-0.235074, -0.135720, 0.962455>, <-0.202170, -0.116723, 0.972370> }
triangle { <-0.235074, -0.135720, 0.962455>, <-0.227649, -0.147837, 0.962455>, <-0.259163, -0.168303, 0.951057> }
triangle { <-0.259163, -0.168303, 0.951057>, <-0.267617, -0.154508, 0.951057>, <-0.235074, -0.135720, 0.962455> }
triangle { <-0.267617, -0.154508, 0.951057>, <-0.259163, -0.168303, 0.951057>, <-0.290278, -0.188509, 0.938191> }
triangle { <-0.290278, -0.188509, 0.938191>, <-0.299746, -0.173059, 0.938191>, <-0.267617, -0.154508, 0.951057> }
triangle { <-0.299746, -0.173059, 0.938191>, <-0.290278, -0.188509, 0.938191>, <-0.320945, -0.208424, 0.923880> }
triangle { <-0.320945, -0.208424, 0.923880>, <-0.331414, -0.191342, 0.923880>, <-0.299746, -0.173059, 0.938191> }
triangle { <-0.331414, -0.191342, 0.923880>, <-0.320945, -0.208424, 0.923880>, <-0.351118, -0.228018, 0.908143> }
triangle { <-0.351118, -0.228018, 0.908143>, <-0.362570, -0.209330, 0.908143>, <-0.331414, -0.191342, 0.923880> }
triangle { <-0.362570, -0.209330, 0.908143>, <-0.351118, -0.228018, 0.908143>, <-0.380748, -0.247261, 0.891007> }
triangle { <-0.380748, -0.247261, 0.891007>, <-0.393167, -0.226995, 0.891007>, <-0.362570, -0.209330, 0.908143> }
triangle { <-0.393167, -0.226995, 0.891007>, <-0.380748, -0.247261, 0.891007>, <-0.409792, -0.266122, 0.872496> }
triangle { <-0.409792, -0.266122, 0.872496>, <-0.423158, -0.244311, 0.872496>, <-0.393167, -0.226995, 0.891007> }
triangle { <-0.423158, -0.244311, 0.872496>, <-0.409792, -0.266122, 0.872496>, <-0.438204, -0.284573, 0.852640> }
triangle { <-0.438204, -0.284573, 0.852640>, <-0.452497, -0.261249, 0.852640>, <-0.423158, -0.244311, 0.872496> }
triangle { <-0.452497, -0.261249, 0.852640>, <-0.438204, -0.284573, 0.852640>, <-0.465940, -0.302585, 0.831470> }
triangle { <-0.465940, -0.302585, 0.831470>, <-0.481138, -0.277785, 0.831470>, <-0.452497, -0.261249, 0.852640> }
triangle { <-0.481138, -0.277785, 0.831470>, <-0.465940, -0.302585, 0.831470>, <-0.492958, -0.320131, 0.809017> }
triangle { <-0.492958, -0.320131, 0.809017>, <-0.509037, -0.293893, 0.809017>, <-0.481138, -0.277785, 0.831470> }
triangle { <-0.509037, -0.293893, 0.809017>, <-0.492958, -0.320131, 0.809017>, <-0.519216, -0.337183, 0.785317> }
triangle { <-0.519216, -0.337183, 0.785317>, <-0.536151, -0.309547, 0.785317>, <-0.509037, -0.293893, 0.809017> }
triangle { <-0.536151, -0.309547, 0.785317>, <-0.519216, -0.337183, 0.785317>, <-0.544673, -0.353715, 0.760406> }
triangle { <-0.544673, -0.353715, 0.760406>, <-0.562439, -0.324724, 0.760406>, <-0.536151, -0.309547, 0.785317> }
triangle { <-0.562439, -0.324724, 0.760406>, <-0.544673, -0.353715, 0.760406>, <-0.569290, -0.369701, 0.734323> }
triangle { <-0.569290, -0.369701, 0.734323>, <-0.587859, -0.339400, 0.734323>, <-0.562439, -0.324724, 0.760406> }
triangle { <-0.587859, -0.339400, 0.734323>, <-0.569290, -0.369701, 0.734323>, <-0.593030, -0.385118, 0.707107> }
triangle { <-0.593030, -0.385118, 0.707107>, <-0.612372, -0.353553, 0.707107>, <-0.587859, -0.339400, 0.734323> }
triangle { <-0.612372, -0.353553, 0.707107>, <-0.593030, -0.385118, 0.707107>, <-0.615855, -0.399941, 0.678801> }
triangle { <-0.615855, -0.399941, 0.678801>, <-0.635942, -0.367161, 0.678801>, <-0.612372, -0.353553, 0.707107> }
triangle { <-0.635942, -0.367161, 0.678801>, <-0.615855, -0.399941, 0.678801>, <-0.637730, -0.414147, 0.649448> }
triangle { <-0.637730, -0.414147, 0.649448>, <-0.658531, -0.380203, 0.649448>, <-0.635942, -0.367161, 0.678801> }
triangle { <-0.658531, -0.380203, 0.649448>, <-0.637730, -0.414147, 0.649448>, <-0.658622, -0.427714, 0.619094> }
triangle { <-0.658622, -0.427714, 0.619094>, <-0.680104, -0.392658, 0.619094>, <-0.658531, -0.380203, 0.649448> }
triangle { <-0.680104, -0.392658, 0.619094>, <-0.658622, -0.427714, 0.619094>, <-0.678499, -0.440622, 0.587785> }
triangle { <-0.678499, -0.440622, 0.587785>, <-0.700629, -0.404508, 0.587785>, <-0.680104, -0.392658, 0.619094> }
triangle { <-0.700629, -0.404508, 0.587785>, <-0.678499, -0.440622, 0.587785>, <-0.697329, -0.452851, 0.555570> }
triangle { <-0.697329, -0.452851, 0.555570>, <-0.720074, -0.415735, 0.555570>, <-0.700629, -0.404508, 0.587785> }
triangle { <-0.720074, -0.415735, 0.555570>, <-0.697329, -0.452851, 0.555570>, <-0.715084, -0.464381, 0.522499> }
triangle { <-0.715084, -0.464381, 0.522499>, <-0.738408, -0.426320, 0.522499>, <-0.720074, -0.415735, 0.555570> }
triangle { <-0.738408, -0.426320, 0.522499>, <-0.715084, -0.464381, 0.522499>, <-0.731737, -0.475195, 0.488621> }
triangle { <-0.731737, -0.475195, 0.488621>, <-0.755604, -0.436248, 0.488621>, <-0.738408, -0.426320, 0.522499> }
triangle { <-0.755604, -0.436248, 0.488621>, <-0.731737, -0.475195, 0.488621>, <-0.747261, -0.485277, 0.453990> }
triangle { <-0.747261, -0.485277, 0.453990>, <-0.771634, -0.445503, 0.453990>, <-0.755604, -0.436248, 0.488621> }
triangle { <-0.771634, -0.445503, 0.453990>, <-0.747261, -0.485277, 0.453990>, <-0.761633, -0.494610, 0.418660> }
triangle { <-0.761633, -0.494610, 0.418660>, <-0.786475, -0.454072, 0.418660>, <-0.771634, -0.445503, 0.453990> }
triangle { <-0.786475, -0.454072, 0.418660>, <-0.761633, -0.494610, 0.418660>, <-0.774831, -0.503181, 0.382683> }
triangle { <-0.774831, -0.503181, 0.382683>, <-0.800103, -0.461940, 0.382683>, <-0.786475, -0.454072, 0.418660> }
triangle { <-0.800103, -0.461940, 0.382683>, <-0.774831, -0.503181, 0.382683>, <-0.786833, -0.510976, 0.346117> }
triangle { <-0.786833, -0.510976, 0.346117>, <-0.812498, -0.469096, 0.346117>, <-0.800103, -0.461940, 0.382683> }
triangle { <-0.812498, -0.469096, 0.346117>, <-0.786833, -0.510976, 0.346117>, <-0.797623, -0.517983, 0.309017> }
triangle { <-0.797623, -0.517983, 0.309017>, <-0.823639, -0.475528, 0.309017>, <-0.812498, -0.469096, 0.346117> }
triangle { <-0.823639, -0.475528, 0.309017>, <-0.797623, -0.517983, 0.309017>, <-0.807183, -0.524191, 0.271440> }
triangle { <-0.807183, -0.524191, 0.271440>, <-0.833511, -0.481228, 0.271440>, <-0.823639, -0.475528, 0.309017> }
triangle { <-0.833511, -0.481228, 0.271440>, <-0.807183, -0.524191, 0.271440>, <-0.815498, -0.529591, 0.233445> }
triangle { <-0.815498, -0.529591, 0.233445>, <-0.842097, -0.486185, 0.233445>, <-0.833511, -0.481228, 0.271440> }
triangle { <-0.842097, -0.486185, 0.233445>, <-0.815498, -0.529591, 0.233445>, <-0.822556, -0.534174, 0.195090> }
triangle { <-0.822556, -0.534174, 0.195090>, <-0.849385, -0.490393, 0.195090>, <-0.842097, -0.486185, 0.233445> }
triangle { <-0.849385, -0.490393, 0.195090>, <-0.822556, -0.534174, 0.195090>, <-0.828345, -0.537934, 0.156434> }
triangle { <-0.828345, -0.537934, 0.156434>, <-0.855363, -0.493844, 0.156434>, <-0.849385, -0.490393, 0.195090> }
triangle { <-0.855363, -0.493844, 0.156434>, <-0.828345, -0.537934, 0.156434>, <-0.832857, -0.540864, 0.117537> }
triangle { <-0.832857, -0.540864, 0.117537>, <-0.860023, -0.496534, 0.117537>, <-0.855363, -0.493844, 0.156434> }
triangle { <-0.860023, -0.496534, 0.117537>, <-0.832857, -0.540864, 0.117537>, <-0.836085, -0.542960, 0.078459> }
triangle { <-0.836085, -0.542960, 0.078459>, <-0.863356, -0.498459, 0.078459>, <-0.860023, -0.496534, 0.117537> }
triangle { <-0.863356, -0.498459, 0.078459>, <-0.836085, -0.542960, 0.078459>, <-0.838024, -0.544219, 0.039260> }
triangle { <-0.838024, -0.544219, 0.039260>, <-0.865358, -0.499615, 0.039260>, <-0.863356, -0.498459, 0.078459> }
triangle { <-0.865358, -0.499615, 0.039260>, <-0.838024, -0.544219, 0.039260>, <-0.838671, -0.544639, -0.000000> }
triangle { <-0.838671, -0.544639, -0.000000>, <-0.866025, -0.500000, -0.000000>, <-0.865358, -0.499615, 0.039260> }
triangle { <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <-0.031762, -0.023076, 0.999229> }
triangle { <-0.031762, -0.023076, 0.999229>, <-0.032926, -0.021382, 0.999229>, <0.000000, 0.000000, 1.000000> }
triangle { <-0.032926, -0.021382, 0.999229>, <-0.031762, -0.023076, 0.999229>, <-0.063475, -0.046117, 0.996917> }
triangle { <-0.063475, -0.046117, 0.996917>, <-0.065801, -0.042732, 0.996917>, <-0.032926, -0.021382, 0.999229> }
triangle { <-0.065801, -0.042732, 0.996917>, <-0.063475, -0.046117, 0.996917>, <-0.095090, -0.069087, 0.993068> }
triangle { <-0.095090, -0.069087, 0.993068>, <-0.098575, -0.064015, 0.993068>, <-0.065801, -0.042732, 0.996917> }
triangle { <-0.098575, -0.064015, 0.993068>, <-0.095090, -0.069087, 0.993068>, <-0.126558, -0.091950, 0.987688> }
triangle { <-0.126558, -0.091950, 0.987688>, <-0.131197, -0.085200, 0.987688>, <-0.098575, -0.064015, 0.993068> }
triangle { <-0.131197, -0.085200, 0.987688>, <-0.126558, -0.091950, 0.987688>, <-0.157831, -0.114671, 0.980785> }
triangle { <-0.157831, -0.114671, 0.980785>, <-0.163617, -0.106254, 0.980785>, <-0.131197, -0.085200, 0.987688> }
triangle { <-0.163617, -0.106254, 0.980785>, <-0.157831, -0.114671, 0.980785>, <-0.188861, -0.137216, 0.972370> }
triangle { <-0.188861, -0.137216, 0.972370>, <-0.195784, -0.127143, 0.972370>, <-0.163617, -0.106254, 0.980785> }
triangle { <-0.195784, -0.127143, 0.972370>, <-0.188861, -0.137216, 0.972370>, <-0.219600, -0.159549, 0.962455> }
triangle { <-0.219600, -0.159549, 0.962455>, <-0.227649, -0.147837, 0.962455>, <-0.195784, -0.127143, 0.972370> }
triangle { <-0.227649, -0.147837, 0.962455>, <-0.219600, -0.159549, 0.962455>, <-0.250000, -0.181636, 0.951057> }
triangle { <-0.250000, -0.181636, 0.951057>, <-0.259163, -0.168303, 0.951057>, <-0.227649, -0.147837, 0.962455> }
triangle { <-0.259163, -0.168303, 0.951057>, <-0.250000, -0.181636, 0.951057>, <-0.280015, -0.203443, 0.938191> }
triangle { <-0.280015, -0.203443, 0.938191>, <-0.290278, -0.188509, 0.938191>, <-0.259163, -0.168303, 0.951057> }
triangle { <-0.290278, -0.188509, 0.938191>, <-0.280015, -0.203443, 0.938191>, <-0.309597, -0.224936, 0.923880> }
triangle { <-0.309597, -0.224936, 0.923880>, <-0.320945, -0.208424, 0.923880>, <-0.290278, -0.188509, 0.938191> }
triangle { <-0.320945, -0.208424, 0.923880>, <-0.309597, -0.224936, 0.923880>, <-0.338703, -0.246082, 0.908143> }
triangle { <-0.338703, -0.246082, 0.908143>, <-0.351118, -0.228018, 0.908143>, <-0.320945, -0.208424, 0.923880> }
triangle { <-0.351118, -0.228018, 0.908143>, <-0.338703, -0.246082, 0.908143>, <-0.367286, -0.266849, 0.891007> }
triangle { <-0.367286, -0.266849, 0.891007>, <-0.380748, -0.247261, 0.891007>, <-0.351118, -0.228018, 0.908143> }
triangle { <-0.380748, -0.247261, 0.891007>, <-0.367286, -0.266849, 0.891007>, <-0.395303, -0.287204, 0.872496> }
triangle { <-0.395303, -0.287204, 0.872496>, <-0.409792, -0.266122, 0.872496>, <-0.380748, -0.247261, 0.891007> }
triangle { <-0.409792, -0.266122, 0.872496>, <-0.395303, -0.287204, 0.872496>, <-0.422710, -0.307117, 0.852640> }
triangle { <-0.422710, -0.307117, 0.852640>, <-0.438204, -0.284573, 0.852640>, <-0.409792, -0.266122, 0.872496> }
triangle { <-0.438204, -0.284573, 0.852640>, <-0.422710, -0.307117, 0.852640>, <-0.449466, -0.326556, 0.831470> }
triangle { <-0.449466, -0.326556, 0.831470>, <-0.465940, -0.302585, 0.831470>, <-0.438204, -0.284573, 0.852640> }
triangle { <-0.465940, -0.302585, 0.831470>, <-0.449466, -0.326556, 0.831470>, <-0.475528, -0.345492, 0.809017> }
triangle { <-0.475528, -0.345492, 0.809017>, <-0.492958, -0.320131, 0.809017>, <-0.465940, -0.302585, 0.831470> }
triangle { <-0.492958, -0.320131, 0.809017>, <-0.475528, -0.345492, 0.809017>, <-0.500858, -0.363894, 0.785317> }
triangle { <-0.500858, -0.363894, 0.785317>, <-0.519216, -0.337183, 0.785317>, <-0.492958, -0.320131, 0.809017> }
triangle { <-0.519216, -0.337183, 0.785317>, <-0.500858, -0.363894, 0.785317>, <-0.525415, -0.381736, 0.760406> }
triangle { <-0.525415, -0.381736, 0.760406>, <-0.544673, -0.353715, 0.760406>, <-0.519216, -0.337183, 0.785317> }
triangle { <-0.544673, -0.353715, 0.760406>, <-0.525415, -0.381736, 0.760406>, <-0.549161, -0.398989, 0.734323> }
triangle { <-0.549161, -0.398989, 0.734323>, <-0.569290, -0.369701, 0.734323>, <-0.544673, -0.353715, 0.760406> }
triangle { <-0.569290, -0.369701, 0.734323>, <-0.549161, -0.398989, 0.734323>, <-0.572061, -0.415627, 0.707107> }
triangle { <-0.572061, -0.415627, 0.707107>, <-0.593030, -0.385118, 0.707107>, <-0.569290, -0.369701, 0.734323> }
triangle { <-0.593030, -0.385118, 0.707107>, <-0.572061, -0.415627, 0.707107>, <-0.594079, -0.431624, 0.678801> }
triangle { <-0.594079, -0.431624, 0.678801>, <-0.615855, -0.399941, 0.678801>, <-0.593030, -0.385118, 0.707107> }
triangle { <-0.615855, -0.399941, 0.678801>, <-0.594079, -0.431624, 0.678801>, <-0.615181, -0.446955, 0.649448> }
triangle { <-0.615181, -0.446955, 0.649448>, <-0.637730, -0.414147, 0.649448>, <-0.615855, -0.399941, 0.678801> }
triangle { <-0.637730, -0.414147, 0.649448>, <-0.615181, -0.446955, 0.649448>, <-0.635335, -0.461598, 0.619094> }
triangle { <-0.635335, -0.461598, 0.619094>, <-0.658622, -0.427714, 0.619094>, <-0.637730, -0.414147, 0.649448> }
triangle { <-0.658622, -0.427714, 0.619094>, <-0.635335, -0.461598, 0.619094>, <-0.654508, -0.475528, 0.587785> }
triangle { <-0.654508, -0.475528, 0.587785>, <-0.678499, -0.440622, 0.587785>, <-0.658622, -0.427714, 0.619094> }
triangle { <-0.678499, -0.440622, 0.587785>, <-0.654508, -0.475528, 0.587785>, <-0.672673, -0.488726, 0.555570> }
triangle { <-0.672673, -0.488726, 0.555570>, <-0.697329, -0.452851, 0.555570>, <-0.678499, -0.440622, 0.587785> }
triangle { <-0.697329, -0.452851, 0.555570>, <-0.672673, -0.488726, 0.555570>, <-0.689800, -0.501169, 0.522499> }
triangle { <-0.689800, -0.501169, 0.522499>, <-0.715084, -0.464381, 0.522499>, <-0.697329, -0.452851, 0.555570> }
triangle { <-0.715084, -0.464381, 0.522499>, <-0.689800, -0.501169, 0.522499>, <-0.705864, -0.512840, 0.488621> }
triangle { <-0.705864, -0.512840, 0.488621>, <-0.731737, -0.475195, 0.488621>, <-0.715084, -0.464381, 0.522499> }
triangle { <-0.731737, -0.475195, 0.488621>, <-0.705864, -0.512840, 0.488621>, <-0.720839, -0.523720, 0.453990> }
triangle { <-0.720839, -0.523720, 0.453990>, <-0.747261, -0.485277, 0.453990>, <-0.731737, -0.475195, 0.488621> }
triangle { <-0.747261, -0.485277, 0.453990>, <-0.720839, -0.523720, 0.453990>, <-0.734703, -0.533793, 0.418660> }
triangle { <-0.734703, -0.533793, 0.418660>, <-0.761633, -0.494610, 0.418660>, <-0.747261, -0.485277, 0.453990> }
triangle { <-0.761633, -0.494610, 0.418660>, <-0.734703, -0.533793, 0.418660>, <-0.747434, -0.543043, 0.382683> }
triangle { <-0.747434, -0.543043, 0.382683>, <-0.774831, -0.503181, 0.382683>, <-0.761633, -0.494610, 0.418660> }
triangle { <-0.774831, -0.503181, 0.382683>, <-0.747434, -0.543043, 0.382683>, <-0.759013, -0.551455, 0.346117> }
triangle { <-0.759013, -0.551455, 0.346117>, <-0.786833, -0.510976, 0.346117>, <-0.774831, -0.503181, 0.382683> }
triangle { <-0.786833, -0.510976, 0.346117>, <-0.759013, -0.551455, 0.346117>, <-0.769421, -0.559017, 0.309017> }
triangle { <-0.769421, -0.559017, 0.309017>, <-0.797623, -0.517983, 0.309017>, <-0.786833, -0.510976, 0.346117> }
triangle { <-0.797623, -0.517983, 0.309017>, <-0.769421, -0.559017, 0.309017>, <-0.778643, -0.565717, 0.271440> }
triangle { <-0.778643, -0.565717, 0.271440>, <-0.807183, -0.524191, 0.271440>, <-0.797623, -0.517983, 0.309017> }
triangle { <-0.807183, -0.524191, 0.271440>, <-0.778643, -0.565717, 0.271440>, <-0.786664, -0.571545, 0.233445> }
triangle { <-0.786664, -0.571545, 0.233445>, <-0.815498, -0.529591, 0.233445>, <-0.807183, -0.524191, 0.271440> }
triangle { <-0.815498, -0.529591, 0.233445>, <-0.786664, -0.571545, 0.233445>, <-0.793472, -0.576491, 0.195090> }
triangle { <-0.793472, -0.576491, 0.195090>, <-0.822556, -0.534174, 0.195090>, <-0.815498, -0.529591, 0.233445> }
triangle { <-0.822556, -0.534174, 0.195090>, <-0.793472, -0.576491, 0.195090>, <-0.799057, -0.580549, 0.156434> }
triangle { <-0.799057, -0.580549, 0.156434>, <-0.828345, -0.537934, 0.156434>, <-0.822556, -0.534174, 0.195090> }
triangle { <-0.828345, -0.537934, 0.156434>, <-0.799057, -0.580549, 0.156434>, <-0.803409, -0.583711, 0.117537> }
triangle { <-0.803409, -0.583711, 0.117537>, <-0.832857, -0.540864, 0.117537>, <-0.828345, -0.537934, 0.156434> }
triangle { <-0.832857, -0.540864, 0.117537>, <-0.803409, -0.583711, 0.117537>, <-0.806523, -0.585973, 0.078459> }
triangle { <-0.806523, -0.585973, 0.078459>, <-0.836085, -0.542960, 0.078459>, <-0.832857, -0.540864, 0.117537> }
triangle { <-0.836085, -0.542960, 0.078459>, <-0.806523, -0.585973, 0.078459>, <-0.808393, -0.587332, 0.039260> }
triangle { <-0.808393, -0.587332, 0.039260>, <-0.838024, -0.544219, 0.039260>, <-0.836085, -0.542960, 0.078459> }
triangle { <-0.838024, -0.544219, 0.039260>, <-0.808393, -0.587332, 0.039260>, <-0.809017, -0.587785, -0.000000> }
triangle { <-0.809017, -0.587785, -0.000000>, <-0.838671, -0.544639, -0.000000>, <-0.838024, -0.544219, 0.039260> }
triangle { <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <-0.030511, -0.024707, 0.999229> }
triangle { <-0.030511, -0.024707, 0.999229>, <-0.031762, -0.023076, 0.999229>, <0.000000, 0.000000, 1.000000> }
triangle { <-0.031762, -0.023076, 0.999229>, <-0.030511, -0.024707, 0.999229>, <-0.060974, -0.049376, 0.996917> }
triangle { <-0.060974, -0.049376, 0.996917>, <-0.063475, -0.046117, 0.996917>, <-0.031762, -0.023076, 0.999229> }
triangle { <-0.063475, -0.046117, 0.996917>, <-0.060974, -0.049376, 0.996917>, <-0.091344, -0.073969, 0.993068> }
triangle { <-0.091344, -0.073969, 0.993068>, <-0.095090, -0.069087, 0.993068>, <-0.063475, -0.046117, 0.996917> }
triangle { <-0.095090, -0.069087, 0.993068>, <-0.091344, -0.073969, 0.993068>, <-0.121572, -0.098447, 0.987688> }
triangle { <-0.121572, -0.098447, 0.987688>, <-0.126558, -0.091950, 0.987688>, <-0.095090, -0.069087, 0.993068> }
triangle { <-0.126558, -0.091950, 0.987688>, <-0.121572, -0.098447, 0.987688>, <-0.151614, -0.122774, 0.980785> }
triangle { <-0.151614, -0.122774, 0.980785>, <-0.157831, -0.114671, 0.980785>, <-0.126558, -0.091950, 0.987688> }
triangle { <-0.157831, -0.114671, 0.980785>, <-0.151614, -0.122774, 0.980785>, <-0.181421, -0.146912, 0.972370> }
triangle { <-0.181421, -0.146912, 0.972370>, <-0.188861, -0.137216, 0.972370>, <-0.157831, -0.114671, 0.980785> }
triangle { <-0.188861, -0.137216, 0.972370>, <-0.181421, -0.146912, 0.972370>, <-0.210949, -0.170823, 0.962455> }
triangle { <-0.210949, -0.170823, 0.962455>, <-0.219600, -0.159549, 0.962455>, <-0.188861, -0.137216, 0.972370> }
triangle { <-0.219600, -0.159549, 0.962455>, <-0.210949, -0.170823, 0.962455>, <-0.240151, -0.194471, 0.951057> }
triangle { <-0.240151, -0.194471, 0.951057>, <-0.250000, -0.181636, 0.951057>, <-0.219600, -0.159549, 0.962455> }
triangle { <-0.250000, -0.181636, 0.951057>, <-0.240151, -0.194471, 0.951057>, <-0.268983, -0.217819, 0.938191> }
triangle { <-0.268983, -0.217819, 0.938191>, <-0.280015, -0.203443, 0.938191>, <-0.250000, -0.181636, 0.951057> }
triangle { <-0.280015, -0.203443, 0.938191>, <-0.268983, -0.217819, 0.938191>, <-0.297401, -0.240830, 0.923880> }
triangle { <-0.297401, -0.240830, 0.923880>, <-0.309597, -0.224936, 0.923880>, <-0.280015, -0.203443, 0.938191> }
triangle { <-0.309597, -0.224936, 0.923880>, <-0.297401, -0.240830, 0.923880>, <-0.325360, -0.263471, 0.908143> }
triangle { <-0.325360, -0.263471, 0.908143>, <-0.338703, -0.246082, 0.908143>, <-0.309597, -0.224936, 0.923880> }
triangle { <-0.338703, -0.246082, 0.908143>, <-0.325360, -0.263471, 0.908143>, <-0.352817, -0.285705, 0.891007> }
triangle { <-0.352817, -0.285705, 0.891007>, <-0.367286, -0.266849, 0.891007>, <-0.338703, -0.246082, 0.908143> }
triangle { <-0.367286, -0.266849, 0.891007>, <-0.352817, -0.285705, 0.891007>, <-0.379730, -0.307499, 0.872496> }
triangle { <-0.379730, -0.307499, 0.872496>, <-0.395303, -0.287204, 0.872496>, <-0.367286, -0.266849, 0.891007> }
triangle { <-0.395303, -0.287204, 0.872496>, <-0.379730, -0.307499, 0.872496>, <-0.406058, -0.328819, 0.852640> }
triangle { <-0.406058, -0.328819, 0.852640>, <-0.422710, -0.307117, 0.852640>, <-0.395303, -0.287204, 0.872496> }
triangle { <-0.422710, -0.307117, 0.852640>, <-0.406058, -0.328819, 0.852640>, <-0.431759, -0.349632, 0.831470> }
triangle { <-0.431759, -0.349632, 0.831470>, <-0.449466, -0.326556, 0.831470>, <-0.422710, -0.307117, 0.852640> }
triangle { <-0.449466, -0.326556, 0.831470>, <-0.431759, -0.349632, 0.831470>, <-0.456795, -0.369905, 0.809017> }
triangle { <-0.456795, -0.369905, 0.809017>, <-0.475528, -0.345492, 0.809017>, <-0.449466, -0.326556, 0.831470> }
triangle { <-0.475528, -0.345492, 0.809017>, <-0.456795, -0.369905, 0.809017>, <-0.481126, -0.389608, 0.785317> }
triangle { <-0.481126, -0.389608, 0.785317>, <-0.500858, -0.363894, 0.785317>, <-0.475528, -0.345492, 0.809017> }
triangle { <-0.500858, -0.363894, 0.785317>, <-0.481126, -0.389608, 0.785317>, <-0.504716, -0.408711, 0.760406> }
triangle { <-0.504716, -0.408711, 0.760406>, <-0.525415, -0.381736, 0.760406>, <-0.500858, -0.363894, 0.785317> }
triangle { <-0.525415, -0.381736, 0.760406>, <-0.504716, -0.408711, 0.760406>, <-0.527527, -0.427183, 0.734323> }
triangle { <-0.527527, -0.427183, 0.734323>, <-0.549161, -0.398989, 0.734323>, <-0.525415, -0.381736, 0.760406> }
triangle { <-0.549161, -0.398989, 0.734323>, <-0.527527, -0.427183, 0.734323>, <-0.549525, -0.444997, 0.707107> }
triangle { <-0.549525, -0.444997, 0.707107>, <-0.572061, -0.415627, 0.707107>, <-0.549161, -0.398989, 0.734323> }
triangle { <-0.572061, -0.415627, 0.707107>, <-0.549525, -0.444997, 0.707107>, <-0.570676, -0.462124, 0.678801> }
triangle { <-0.570676, -0.462124, 0.678801>, <-0.594079, -0.431624, 0.678801>, <-0.572061, -0.415627, 0.707107> }
triangle { <-0.594079, -0.431624, 0.678801>, <-0.570676, -0.462124, 0.678801>, <-0.590946, -0.478539, 0.649448> }
triangle { <-0.590946, -0.478539, 0.649448>, <-0.615181, -0.446955, 0.649448>, <-0.594079, -0.431624, 0.678801> }
triangle { <-0.615181, -0.446955, 0.649448>, <-0.590946, -0.478539, 0.649448>, <-0.610306, -0.494216, 0.619094> }
triangle { <-0.610306, -0.494216, 0.619094>, <-0.635335, -0.461598, 0.619094>, <-0.615181, -0.446955, 0.649448> }
triangle { <-0.635335, -0.461598, 0.619094>, <-0.610306, -0.494216, 0.619094>, <-0.628724, -0.509131, 0.587785> }
triangle { <-0.628724, -0.509131, 0.587785>, <-0.654508, -0.475528, 0.587785>, <-0.635335, -0.461598, 0.619094> }
triangle { <-0.654508, -0.475528, 0.587785>, <-0.628724, -0.509131, 0.587785>, <-0.646173, -0.523261, 0.555570> }
triangle { <-0.646173, -0.523261, 0.555570>, <-0.672673, -0.488726, 0.555570>, <-0.654508, -0.475528, 0.587785> }
triangle { <-0.672673, -0.488726, 0.555570>, <-0.646173, -0.523261, 0.555570>, <-0.662626, -0.536584, 0.522499> }
triangle { <-0.662626, -0.536584, 0.522499>, <-0.689800, -0.501169, 0.522499>, <-0.672673, -0.488726, 0.555570> }
triangle { <-0.689800, -0.501169, 0.522499>, <-0.662626, -0.536584, 0.522499>, <-0.678057, -0.549080, 0.488621> }
triangle { <-0.678057, -0.549080, 0.488621>, <-0.705864, -0.512840, 0.488621>, <-0.689800, -0.501169, 0.522499> }
triangle { <-0.705864, -0.512840, 0.488621>, <-0.678057, -0.549080, 0.488621>, <-0.692442, -0.560729, 0.453990> }
triangle { <-0.692442, -0.560729, 0.453990>, <-0.720839, -0.523720, 0.453990>, <-0.705864, -0.512840, 0.488621> }
triangle { <-0.720839, -0.523720, 0.453990>, <-0.692442, -0.560729, 0.453990>, <-0.705760, -0.571513, 0.418660> }
triangle { <-0.705760, -0.571513, 0.418660>, <-0.734703, -0.533793, 0.418660>, <-0.720839, -0.523720, 0.453990> }
triangle { <-0.734703, -0.533793, 0.418660>, <-0.705760, -0.571513, 0.418660>, <-0.717989, -0.581416, 0.382683> }
triangle { <-0.717989, -0.581416, 0.382683>, <-0.747434, -0.543043, 0.382683>, <-0.734703, -0.533793, 0.418660> }
triangle { <-0.747434, -0.543043, 0.382683>, <-0.717989, -0.581416, 0.382683>, <-0.729112, -0.590423, 0.346117> }
triangle { <-0.729112, -0.590423, 0.346117>, <-0.759013, -0.551455, 0.346117>, <-0.747434, -0.543043, 0.382683> }
triangle { <-0.759013, -0.551455, 0.346117>, <-0.729112, -0.590423, 0.346117>, <-0.739110, -0.598519, 0.309017> }
triangle { <-0.739110, -0.598519, 0.309017>, <-0.769421, -0.559017, 0.309017>, <-0.759013, -0.551455, 0.346117> }
triangle { <-0.769421, -0.559017, 0.309017>, <-0.739110, -0.598519, 0.309017>, <-0.747968, -0.605693, 0.271440> }
triangle { <-0.747968, -0.605693, 0.271440>, <-0.778643, -0.565717, 0.271440>, <-0.769421, -0.559017, 0.309017> }
triangle { <-0.778643, -0.565717, 0.271440>, <-0.747968, -0.605693, 0.271440>, <-0.755673, -0.611932, 0.233445> }
triangle { <-0.755673, -0.611932, 0.233445>, <-0.786664, -0.571545, 0.233445>, <-0.778643, -0.565717, 0.271440> }
triangle { <-0.786664, -0.571545, 0.233445>, <-0.755673, -0.611932, 0.233445>, <-0.762213, -0.617228, 0.195090> }
triangle { <-0.762213, -0.617228, 0.195090>, <-0.793472, -0.576491, 0.195090>, <-0.786664, -0.571545, 0.233445> }
triangle { <-0.793472, -0.576491, 0.195090>, <-0.762213, -0.617228, 0.195090>, <-0.767578, -0.621572, 0.156434> }
triangle { <-0.767578, -0.621572, 0.156434>, <-0.799057, -0.580549, 0.156434>, <-0.793472, -0.576491, 0.195090> }
triangle { <-0.799057, -0.580549, 0.156434>, <-0.767578, -0.621572, 0.156434>, <-0.771759, -0.624958, 0.117537> }
triangle { <-0.771759, -0.624958, 0.117537>, <-0.803409, -0.583711, 0.117537>, <-0.799057, -0.580549, 0.156434> }
triangle { <-0.803409, -0.583711, 0.117537>, <-0.771759, -0.624958, 0.117537>, <-0.774750, -0.627380, 0.078459> }
triangle { <-0.774750, -0.627380, 0.078459>, <-0.806523, -0.585973, 0.078459>, <-0.803409, -0.583711, 0.117537> }
triangle { <-0.806523, -0.585973, 0.078459>, <-0.774750, -0.627380, 0.078459>, <-0.776547, -0.628835, 0.039260> }
triangle { <-0.776547, -0.628835, 0.039260>, <-0.808393, -0.587332, 0.039260>, <-0.806523, -0.585973, 0.078459> }
triangle { <-0.808393, -0.587332, 0.039260>, <-0.776547, -0.628835, 0.039260>, <-0.777146, -0.629320, -0.000000> }
triangle { <-0.777146, -0.629320, -0.000000>, <-0.809017, -0.587785, -0.000000>, <-0.808393, -0.587332, 0.039260> }
triangle { <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <-0.029176, -0.026270, 0.999229> }
triangle { <-0.029176, -0.026270, 0.999229>, <-0.030511, -0.024707, 0.999229>, <0.000000, 0.000000, 1.000000> }
triangle { <-0.030511, -0.024707, 0.999229>, <-0.029176, -0.026270, 0.999229>, <-0.058306, -0.052499, 0.996917> }
triangle { <-0.058306, -0.052499, 0.996917>, <-0.060974, -0.049376, 0.996917>, <-0.030511, -0.024707, 0.999229> }
triangle { <-0.060974, -0.049376, 0.996917>, <-0.058306, -0.052499, 0.996917>, <-0.087347, -0.078648, 0.993068> }
triangle { <-0.087347, -0.078648, 0.993068>, <-0.091344, -0.073969, 0.993068>, <-0.060974, -0.049376, 0.996917> }
triangle { <-0.091344, -0.073969, 0.993068>, <-0.087347, -0.078648, 0.993068>, <-0.116253, -0.104675, 0.987688> }
triangle { <-0.116253, -0.104675, 0.987688>, <-0.121572, -0.098447, 0.987688>, <-0.091344, -0.073969, 0.993068> }
triangle { <-0.121572, -0.098447, 0.987688>, <-0.116253, -0.104675, 0.987688>, <-0.144980, -0.130541, 0.980785> }
triangle { <-0.144980, -0.130541, 0.980785>, <-0.151614, -0.122774, 0.980785>, <-0.121572, -0.098447, 0.987688> }
triangle { <-0.151614, -0.122774, 0.980785>, <-0.144980, -0.130541, 0.980785>, <-0.173484, -0.156205, 0.972370> }
triangle { <-0.173484, -0.156205, 0.972370>, <-0.181421, -0.146912, 0.972370>, <-0.151614, -0.122774, 0.980785> }
triangle { <-0.181421, -0.146912, 0.972370>, <-0.173484, -0.156205, 0.972370>, <-0.201720, -0.181629, 0.962455> }
triangle { <-0.201720, -0.181629, 0.962455>, <-0.210949, -0.170823, 0.962455>, <-0.181421, -0.146912, 0.972370> }
triangle { <-0.210949, -0.170823, 0.962455>, <-0.201720, -0.181629, 0.962455>, <-0.229644, -0.206773, 0.951057> }
triangle { <-0.229644, -0.206773, 0.951057>, <-0.240151, -0.194471, 0.951057>, <-0.210949, -0.170823, 0.962455> }
triangle { <-0.240151, -0.194471, 0.951057>, <-0.229644, -0.206773, 0.951057>, <-0.257215, -0.231598, 0.938191> }
triangle { <-0.257215, -0.231598, 0.938191>, <-0.268983, -0.217819, 0.938191>, <-0.240151, -0.194471, 0.951057> }
triangle { <-0.268983, -0.217819, 0.938191>, <-0.257215, -0.231598, 0.938191>, <-0.284389, -0.256065, 0.923880> }
triangle { <-0.284389, -0.256065, 0.923880>, <-0.297401, -0.240830, 0.923880>, <-0.268983, -0.217819, 0.938191> }
triangle { <-0.297401, -0.240830, 0.923880>, <-0.284389, -0.256065, 0.923880>, <-0.311125, -0.280138, 0.908143> }
triangle { <-0.311125, -0.280138, 0.908143>, <-0.325360, -0.263471, 0.908143>, <-0.297401, -0.240830, 0.923880> }
triangle { <-0.325360, -0.263471, 0.908143>, <-0.311125, -0.280138, 0.908143>, <-0.337381, -0.303779, 0.891007> }
triangle { <-0.337381, -0.303779, 0.891007>, <-0.352817, -0.285705, 0.891007>, <-0.325360, -0.263471, 0.908143> }
triangle { <-0.352817, -0.285705, 0.891007>, <-0.337381, -0.303779, 0.891007>, <-0.363116, -0.326951, 0.872496> }
triangle { <-0.363116, -0.326951, 0.872496>, <-0.379730, -0.307499, 0.872496>, <-0.352817, -0.285705, 0.891007> }
triangle { <-0.379730, -0.307499, 0.872496>, <-0.363116, -0.326951, 0.872496>, <-0.388292, -0.349620, 0.852640> }
triangle { <-0.388292, -0.349620, 0.852640>, <-0.406058, -0.328819, 0.852640>, <-0.379730, -0.307499, 0.872496> }
triangle { <-0.406058, -0.328819, 0.852640>, <-0.388292, -0.349620, 0.852640>, <-0.412869, -0.371749, 0.831470> }
triangle { <-0.412869, -0.371749, 0.831470>, <-0.431759, -0.349632, 0.831470>, <-0.406058, -0.328819, 0.852640> }
triangle { <-0.431759, -0.349632, 0.831470>, <-0.412869, -0.371749, 0.831470>, <-0.436810, -0.393305, 0.809017> }
triangle { <-0.436810, -0.393305, 0.809017>, <-0.456795, -0.369905, 0.809017>, <-0.431759, -0.349632, 0.831470> }
triangle { <-0.456795, -0.369905, 0.809017>, <-0.436810, -0.393305, 0.809017>, <-0.460076, -0.414255, 0.785317> }
triangle { <-0.460076, -0.414255, 0.785317>, <-0.481126, -0.389608, 0.785317>, <-0.456795, -0.369905, 0.809017> }
triangle { <-0.481126, -0.389608, 0.785317>, <-0.460076, -0.414255, 0.785317>, <-0.482634, -0.434566, 0.760406> }
triangle { <-0.482634, -0.434566, 0.760406>, <-0.504716, -0.408711, 0.760406>, <-0.481126, -0.389608, 0.785317> }
triangle { <-0.504716, -0.408711, 0.760406>, <-0.482634, -0.434566, 0.760406>, <-0.504447, -0.454206, 0.734323> }
triangle { <-0.504447, -0.454206, 0.734323>, <-0.527527, -0.427183, 0.734323>, <-0.504716, -0.408711, 0.760406> }
triangle { <-0.527527, -0.427183, 0.734323>, <-0.504447, -0.454206, 0.734323>, <-0.525483, -0.473147, 0.707107> }
triangle { <-0.525483, -0.473147, 0.707107>, <-0.549525, -0.444997, 0.707107>, <-0.527527, -0.427183, 0.734323> }
triangle { <-0.549525, -0.444997, 0.707107>, <-0.525483, -0.473147, 0.707107>, <-0.545708, -0.491358, 0.678801> }
triangle { <-0.545708, -0.491358, 0.678801>, <-0.570676, -0.462124, 0.678801>, <-0.549525, -0.444997, 0.707107> }
triangle { <-0.570676, -0.462124, 0.678801>, <-0.545708, -0.491358, 0.678801>, <-0.565092, -0.508811, 0.649448> }
triangle { <-0.565092, -0.508811, 0.649448>, <-0.590946, -0.478539, 0.649448>, <-0.570676, -0.462124, 0.678801> }
triangle { <-0.590946, -0.478539, 0.649448>, <-0.565092, -0.508811, 0.649448>, <-0.583604, -0.525480, 0.619094> }
triangle { <-0.583604, -0.525480, 0.619094>, <-0.610306, -0.494216, 0.619094>, <-0.590946, -0.478539, 0.649448> }
triangle { <-0.610306, -0.494216, 0.619094>, <-0.583604, -0.525480, 0.619094>, <-0.601217, -0.541338, 0.587785> }
triangle { <-0.601217, -0.541338, 0.587785>, <-0.628724, -0.509131, 0.587785>, <-0.610306, -0.494216, 0.619094> }
triangle { <-0.628724, -0.509131, 0.587785>, <-0.601217, -0.541338, 0.587785>, <-0.617902, -0.556362, 0.555570> }
triangle { <-0.617902, -0.556362, 0.555570>, <-0.646173, -0.523261, 0.555570>, <-0.628724, -0.509131, 0.587785> }
triangle { <-0.646173, -0.523261, 0.555570>, <-0.617902, -0.556362, 0.555570>, <-0.633635, -0.570528, 0.522499> }
triangle { <-0.633635, -0.570528, 0.522499>, <-0.662626, -0.536584, 0.522499>, <-0.646173, -0.523261, 0.555570> }
triangle { <-0.662626, -0.536584, 0.522499>, <-0.633635, -0.570528, 0.522499>, <-0.648391, -0.583814, 0.488621> }
triangle { <-0.648391, -0.583814, 0.488621>, <-0.678057, -0.549080, 0.488621>, <-0.662626, -0.536584, 0.522499> }
triangle { <-0.678057, -0.549080, 0.488621>, <-0.648391, -0.583814, 0.488621>, <-0.662147, -0.596200, 0.453990> }
triangle { <-0.662147, -0.596200, 0.453990>, <-0.692442, -0.560729, 0.453990>, <-0.678057, -0.549080, 0.488621> }
triangle { <-0.692442, -0.560729, 0.453990>, <-0.662147, -0.596200, 0.453990>, <-0.674882, -0.607666, 0.418660> }
triangle { <-0.674882, -0.607666, 0.418660>, <-0.705760, -0.571513, 0.418660>, <-0.692442, -0.560729, 0.453990> }
triangle { <-0.705760, -0.571513, 0.418660>, <-0.674882, -0.607666, 0.418660>, <-0.686576, -0.618196, 0.382683> }
triangle { <-0.686576, -0.618196, 0.382683>, <-0.717989, -0.581416, 0.382683>, <-0.705760, -0.571513, 0.418660> }
triangle { <-0.717989, -0.581416, 0.382683>, <-0.686576, -0.618196, 0.382683>, <-0.697212, -0.627773, 0.346117> }
triangle { <-0.697212, -0.627773, 0.346117>, <-0.729112, -0.590423, 0.346117>, <-0.717989, -0.581416, 0.382683> }
triangle { <-0.729112, -0.590423, 0.346117>, <-0.697212, -0.627773, 0.346117>, <-0.706773, -0.636381, 0.309017> }
triangle { <-0.706773, -0.636381, 0.309017>, <-0.739110, -0.598519, 0.309017>, <-0.729112, -0.590423, 0.346117> }
triangle { <-0.739110, -0.598519, 0.309017>, <-0.706773, -0.636381, 0.309017>, <-0.715244, -0.644008, 0.271440> }
triangle { <-0.715244, -0.644008, 0.271440>, <-0.747968, -0.605693, 0.271440>, <-0.739110, -0.598519, 0.309017> }
triangle { <-0.747968, -0.605693, 0.271440>, <-0.715244, -0.644008, 0.271440>, <-0.722612, -0.650642, 0.233445> }
triangle { <-0.722612, -0.650642, 0.233445>, <-0.755673, -0.611932, 0.233445>, <-0.747968, -0.605693, 0.271440> }
triangle { <-0.755673, -0.611932, 0.233445>, <-0.722612, -0.650642, 0.233445>, <-0.728866, -0.656273, 0.195090> }
triangle { <-0.728866, -0.656273, 0.195090>, <-0.762213, -0.617228, 0.195090>, <-0.755673, -0.611932, 0.233445> }
triangle { <-0.762213, -0.617228, 0.195090>, <-0.728866, -0.656273, 0.195090>, <-0.733995, -0.660892, 0.156434> }
triangle { <-0.733995, -0.660892, 0.156434>, <-0.767578, -0.621572, 0.156434>, <-0.762213, -0.617228, 0.195090> }
triangle { <-0.767578, -0.621572, 0.156434>, <-0.733995, -0.660892, 0.156434>, <-0.737994, -0.664492, 0.117537> }
triangle { <-0.737994, -0.664492, 0.117537>, <-0.771759, -0.624958, 0.117537>, <-0.767578, -0.621572, 0.156434> }
triangle { <-0.771759, -0.624958, 0.117537>, <-0.737994, -0.664492, 0.117537>, <-0.740854, -0.667068, 0.078459> }
triangle { <-0.740854, -0.667068, 0.078459>, <-0.774750, -0.627380, 0.078459>, <-0.771759, -0.624958, 0.117537> }
triangle { <-0.774750, -0.627380, 0.078459>, <-0.740854, -0.667068, 0.078459>, <-0.742572, -0.668615, 0.039260> }
triangle { <-0.742572, -0.668615, 0.039260>, <-0.776547, -0.628835, 0.039260>, <-0.774750, -0.627380, 0.078459> }
triangle { <-0.776547, -0.628835, 0.039260>, <-0.742572, -0.668615, 0.039260>, <-0.743145, -0.669131, -0.000000> }
triangle { <-0.743145, -0.669131, -0.000000>, <-0.777146, -0.629320, -0.000000>, <-0.776547, -0.628835, 0.039260> }
triangle { <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <-0.027761, -0.027761, 0.999229> }
triangle { <-0.027761, -0.027761, 0.999229>, <-0.029176, -0.026270, 0.999229>, <0.000000, 0.000000, 1.000000> }
triangle { <-0.029176, -0.026270, 0.999229>, <-0.027761, -0.027761, 0.999229>, <-0.055479, -0.055479, 0.996917> }
triangle { <-0.055479, -0.055479, 0.996917>, <-0.058306, -0.052499, 0.996917>, <-0.029176, -0.026270, 0.999229> }
triangle { <-0.058306, -0.052499, 0.996917>, <-0.055479, -0.055479, 0.996917>, <-0.083111, -0.083111, 0.993068> }
triangle { <-0.083111, -0.083111, 0.993068>, <-0.087347, -0.078648, 0.993068>, <-0.058306, -0.052499, 0.996917> }
triangle { <-0.087347, -0.078648, 0.993068>, <-0.083111, -0.083111, 0.993068>, <-0.110616, -0.110616, 0.987688> }
triangle { <-0.110616, -0.110616, 0.987688>, <-0.116253, -0.104675, 0.987688>, <-0.087347, -0.078648, 0.993068> }
triangle { <-0.116253, -0.104675, 0.987688>, <-0.110616, -0.110616, 0.987688>, <-0.137950, -0.137950, 0.980785> }
triangle { <-0.137950, -0.137950, 0.980785>, <-0.144980, -0.130541, 0.980785>, <-0.116253, -0.104675, 0.987688> }
triangle { <-0.144980, -0.130541, 0.980785>, <-0.137950, -0.137950, 0.980785>, <-0.165071, -0.165071, 0.972370> }
triangle { <-0.165071, -0.165071, 0.972370>, <-0.173484, -0.156205, 0.972370>, <-0.144980, -0.130541, 0.980785> }
triangle { <-0.173484, -0.156205, 0.972370>, <-0.165071, -0.165071, 0.972370>, <-0.191937, -0.191937, 0.962455> }
triangle { <-0.191937, -0.191937, 0.962455>, <-0.201720, -0.181629, 0.962455>, <-0.173484, -0.156205, 0.972370> }
triangle { <-0.201720, -0.181629, 0.962455>, <-0.191937, -0.191937, 0.962455>, <-0.218508, -0.218508, 0.951057> }
triangle { <-0.218508, -0.218508, 0.951057>, <-0.229644, -0.206773, 0.951057>, <-0.201720, -0.181629, 0.962455> }
triangle { <-0.229644, -0.206773, 0.951057>, <-0.218508, -0.218508, 0.951057>, <-0.244742, -0.244742, 0.938191> }
triangle { <-0.244742, -0.244742, 0.938191>, <-0.257215, -0.231598, 0.938191>, <-0.229644, -0.206773, 0.951057> }
triangle { <-0.257215, -0.231598, 0.938191>, <-0.244742, -0.244742, 0.938191>, <-0.270598, -0.270598, 0.923880> }
triangle { <-0.270598, -0.270598, 0.923880>, <-0.284389, -0.256065, 0.923880>, <-0.257215, -0.231598, 0.938191> }
triangle { <-0.284389, -0.256065, 0.923880>, <-0.270598, -0.270598, 0.923880>, <-0.296037, -0.296037, 0.908143> }
triangle { <-0.296037, -0.296037, 0.908143>, <-0.311125, -0.280138, 0.908143>, <-0.284389, -0.256065, 0.923880> }
triangle { <-0.311125, -0.280138, 0.908143>, <-0.296037, -0.296037, 0.908143>, <-0.321020, -0.321020, 0.891007> }
triangle { <-0.321020, -0.321020, 0.891007>, <-0.337381, -0.303779, 0.891007>, <-0.311125, -0.280138, 0.908143> }
triangle { <-0.337381, -0.303779, 0.891007>, <-0.321020, -0.321020, 0.891007>, <-0.345507, -0.345507, 0.872496> }
triangle { <-0.345507, -0.345507, 0.872496>, <-0.363116, -0.326951, 0.872496>, <-0.337381, -0.303779, 0.891007> }
triangle { <-0.363116, -0.326951, 0.872496>, <-0.345507, -0.345507, 0.872496>, <-0.369462, -0.369462, 0.852640> }
triangle { <-0.369462, -0.369462, 0.852640>, <-0.388292, -0.349620, 0.852640>, <-0.363116, -0.326951, 0.872496> }
triangle { <-0.388292, -0.349620, 0.852640>, <-0.369462, -0.369462, 0.852640>, <-0.392847, -0.392847, 0.831470> }
triangle { <-0.392847, -0.392847, 0.831470>, <-0.412869, -0.371749, 0.831470>, <-0.388292, -0.349620, 0.852640> }
triangle { <-0.412869, -0.371749, 0.831470>, <-0.392847, -0.392847, 0.831470>, <-0.415627, -0.415627, 0.809017> }
triangle { <-0.415627, -0.415627, 0.809017>, <-0.436810, -0.393305, 0.809017>, <-0.412869, -0.371749, 0.831470> }
triangle { <-0.436810, -0.393305, 0.809017>, <-0.415627, -0.415627, 0.809017>, <-0.437766, -0.437766, 0.785317> }
triangle { <-0.437766, -0.437766, 0.785317>, <-0.460076, -0.414255, 0.785317>, <-0.436810, -0.393305, 0.809017> }
triangle { <-0.460076, -0.414255, 0.785317>, <-0.437766, -0.437766, 0.785317>, <-0.459229, -0.459229, 0.760406> }
triangle { <-0.459229, -0.459229, 0.760406>, <-0.482634, -0.434566, 0.760406>, <-0.460076, -0.414255, 0.785317> }
triangle { <-0.482634, -0.434566, 0.760406>, <-0.459229, -0.459229, 0.760406>, <-0.479985, -0.479985, 0.734323> }
triangle { <-0.479985, -0.479985, 0.734323>, <-0.504447, -0.454206, 0.734323>, <-0.482634, -0.434566, 0.760406> }
triangle { <-0.504447, -0.454206, 0.734323>, <-0.479985, -0.479985, 0.734323>, <-0.500000, -0.500000, 0.707107> }
triangle { <-0.500000, -0.500000, 0.707107>, <-0.525483, -0.473147, 0.707107>, <-0.504447, -0.454206, 0.734323> }
triangle { <-0.525483, -0.473147, 0.707107>, <-0.500000, -0.500000, 0.707107>, <-0.519244, -0.519244, 0.678801> }
triangle { <-0.519244, -0.519244, 0.678801>, <-0.545708, -0.491358, 0.678801>, <-0.525483, -0.473147, 0.707107> }
triangle { <-0.545708, -0.491358, 0.678801>, <-0.519244, -0.519244, 0.678801>, <-0.537688, -0.537688, 0.649448> }
triangle { <-0.537688, -0.537688, 0.649448>, <-0.565092, -0.508811, 0.649448>, <-0.545708, -0.491358, 0.678801> }
triangle { <-0.565092, -0.508811, 0.649448>, <-0.537688, -0.537688, 0.649448>, <-0.555303, -0.555303, 0.619094> }
triangle { <-0.555303, -0.555303, 0.619094>, <-0.583604, -0.525480, 0.619094>, <-0.565092, -0.508811, 0.649448> }
triangle { <-0.583604, -0.525480, 0.619094>, <-0.555303, -0.555303, 0.619094>, <-0.572061, -0.572061, 0.587785> }
triangle { <-0.572061, -0.572061, 0.587785>, <-0.601217, -0.541338, 0.587785>, <-0.583604, -0.525480, 0.619094> }
triangle { <-0.601217, -0.541338, 0.587785>, <-0.572061, -0.572061, 0.587785>, <-0.587938, -0.587938, 0.555570> }
triangle { <-0.587938, -0.587938, 0.555570>, <-0.617902, -0.556362, 0.555570>, <-0.601217, -0.541338, 0.587785> }
triangle { <-0.617902, -0.556362, 0.555570>, <-0.587938, -0.587938, 0.555570>, <-0.602908, -0.602908, 0.522499> }
triangle { <-0.602908, -0.602908, 0.522499>, <-0.633635, -0.570528, 0.522499>, <-0.617902, -0.556362, 0.555570> }
triangle { <-0.633635, -0.570528, 0.522499>, <-0.602908, -0.602908, 0.522499>, <-0.616948, -0.616948, 0.488621> }
triangle { <-0.616948, -0.616948, 0.488621>, <-0.648391, -0.583814, 0.488621>, <-0.633635, -0.570528, 0.522499> }
triangle { <-0.648391, -0.583814, 0.488621>, <-0.616948, -0.616948, 0.488621>, <-0.630037, -0.630037, 0.453990> }
triangle { <-0.630037, -0.630037, 0.453990>, <-0.662147, -0.596200, 0.453990>, <-0.648391, -0.583814, 0.488621> }
triangle { <-0.662147, -0.596200, 0.453990>, <-0.630037, -0.630037, 0.453990>, <-0.642154, -0.642154, 0.418660> }
triangle { <-0.642154, -0.642154, 0.418660>, <-0.674882, -0.607666, 0.418660>, <-0.662147, -0.596200, 0.453990> }
triangle { <-0.674882, -0.607666, 0.418660>, <-0.642154, -0.642154, 0.418660>, <-0.653281, -0.653281, 0.382683> }
triangle { <-0.653281, -0.653281, 0.382683>, <-0.686576, -0.618196, 0.382683>, <-0.674882, -0.607666, 0.418660> }
triangle { <-0.686576, -0.618196, 0.382683>, <-0.653281, -0.653281, 0.382683>, <-0.663401, -0.663401, 0.346117> }
triangle { <-0.663401, -0.663401, 0.346117>, <-0.697212, -0.627773, 0.346117>, <-0.686576, -0.618196, 0.382683> }
triangle { <-0.697212, -0.627773, 0.346117>, <-0.663401, -0.663401, 0.346117>, <-0.672499, -0.672499, 0.309017> }
triangle { <-0.672499, -0.672499, 0.309017>, <-0.706773, -0.636381, 0.309017>, <-0.697212, -0.627773, 0.346117> }
triangle { <-0.706773, -0.636381, 0.309017>, <-0.672499, -0.672499, 0.309017>, <-0.680559, -0.680559, 0.271440> }
triangle { <-0.680559, -0.680559, 0.271440>, <-0.715244, -0.644008, 0.271440>, <-0.706773, -0.636381, 0.309017> }
triangle { <-0.715244, -0.644008, 0.271440>, <-0.680559, -0.680559, 0.271440>, <-0.687569, -0.687569, 0.233445> }
triangle { <-0.687569, -0.687569, 0.233445>, <-0.722612, -0.650642, 0.233445>, <-0.715244, -0.644008, 0.271440> }
triangle { <-0.722612, -0.650642, 0.233445>, <-0.687569, -0.687569, 0.233445>, <-0.693520, -0.693520, 0.195090> }
triangle { <-0.693520, -0.693520, 0.195090>, <-0.728866, -0.656273, 0.195090>, <-0.722612, -0.650642, 0.233445> }
triangle { <-0.728866, -0.656273, 0.195090>, <-0.693520, -0.693520, 0.195090>, <-0.698401, -0.698401, 0.156434> }
triangle { <-0.698401, -0.698401, 0.156434>, <-0.733995, -0.660892, 0.156434>, <-0.728866, -0.656273, 0.195090> }
triangle { <-0.733995, -0.660892, 0.156434>, <-0.698401, -0.698401, 0.156434>, <-0.702205, -0.702205, 0.117537> }
triangle { <-0.702205, -0.702205, 0.117537>, <-0.737994, -0.664492, 0.117537>, <-0.733995, -0.660892, 0.156434> }
triangle { <-0.737994, -0.664492, 0.117537>, <-0.702205, -0.702205, 0.117537>, <-0.704927, -0.704927, 0.078459> }
triangle { <-0.704927, -0.704927, 0.078459>, <-0.740854, -0.667068, 0.078459>, <-0.737994, -0.664492, 0.117537> }
triangle { <-0.740854, -0.667068, 0.078459>, <-0.704927, -0.704927, 0.078459>, <-0.706562, -0.706562, 0.039260> }
triangle { <-0.706562, -0.706562, 0.039260>, <-0.742572, -0.668615, 0.039260>, <-0.740854, -0.667068, 0.078459> }
triangle { <-0.742572, -0.668615, 0.039260>, <-0.706562, -0.706562, 0.039260>, <-0.707107, -0.707107, -0.000000> }
triangle { <-0.707107, -0.707107, -0.000000>, <-0.743145, -0.669131, -0.000000>, <-0.742572, -0.668615, 0.039260> }
triangle { <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <-0.026270, -0.029176, 0.999229> }
triangle { <-0.026270, -0.029176, 0.999229>, <-0.027761, -0.027761, 0.999229>, <0.000000, 0.000000, 1.000000> }
triangle { <-0.027761, -0.027761, 0.999229>, <-0.026270, -0.029176, 0.999229>, <-0.052499, -0.058306, 0.996917> }
triangle { <-0.052499, -0.058306, 0.996917>, <-0.055479, -0.055479, 0.996917>, <-0.027761, -0.027761, 0.999229> }
triangle { <-0.055479, -0.055479, 0.996917>, <-0.052499, -0.058306, 0.996917>, <-0.078648, -0.087347, 0.993068> }
triangle { <-0.078648, -0.087347, 0.993068>, <-0.083111, -0.083111, 0.993068>, <-0.055479, -0.055479, 0.996917> }
triangle { <-0.083111, -0.083111, 0.993068>, <-0.078648, -0.087347, 0.993068>, <-0.104675, -0.116253, 0.987688> }
triangle { <-0.104675, -0.116253, 0.987688>, <-0.110616, -0.110616, 0.987688>, <-0.083111, -0.083111, 0.993068> }
triangle { <-0.110616, -0.110616, 0.987688>, <-0.104675, -0.116253, 0.987688>, <-0.130541, -0.144980, 0.980785> }
triangle { <-0.130541, -0.144980, 0.980785>, <-0.137950, -0.137950, 0.980785>, <-0.110616, -0.110616, 0.987688> }
triangle { <-0.137950, -0.137950, 0.980785>, <-0.130541, -0.144980, 0.980785>, <-0.156205, -0.173484, 0.972370> }
triangle { <-0.156205, -0.173484, 0.972370>, <-0.165071, -0.165071, 0.972370>, <-0.137950, -0.137950, 0.980785> }
triangle { <-0.165071, -0.165071, 0.972370>, <-0.156205, -0.173484, 0.972370>, <-0.181629, -0.201720, 0.962455> }
triangle { <-0.181629, -0.201720, 0.962455>, <-0.191937, -0.191937, 0.962455>, <-0.165071, -0.165071, 0.972370> }
triangle { <-0.191937, -0.191937, 0.962455>, <-0.181629, -0.201720, 0.962455>, <-0.206773, -0.229644, 0.951057> }
triangle { <-0.206773, -0.229644, 0.951057>, <-0.218508, -0.218508, 0.951057>, <-0.191937, -0.191937, 0.962455> }
triangle { <-0.218508, -0.218508, 0.951057>, <-0.206773, -0.229644, 0.951057>, <-0.231598, -0.257215, 0.938191> }
triangle { <-0.231598, -0.257215, 0.938191>, <-0.244742, -0.244742, 0.938191>, <-0.218508, -0.218508, 0.951057> }
triangle { <-0.244742, -0.244742, 0.938191>, <-0.231598, -0.257215, 0.938191>, <-0.256065, -0.284389, 0.923880> }
triangle { <-0.256065, -0.284389, 0.923880>, <-0.270598, -0.270598, 0.923880>, <-0.244742, -0.244742, 0.938191> }
triangle { <-0.270598, -0.270598, 0.923880>, <-0.256065, -0.284389, 0.923880>, <-0.280138, -0.311125, 0.908143> }
triangle { <-0.280138, -0.311125, 0.908143>, <-0.296037, -0.296037, 0.908143>, <-0.270598, -0.270598, 0.923880> }
triangle { <-0.296037, -0.296037, 0.908143>, <-0.280138, -0.311125, 0.908143>, <-0.303779, -0.337381, 0.891007> }
triangle { <-0.303779, -0.337381, 0.891007>, <-0.321020, -0.321020, 0.891007>, <-0.296037, -0.296037, 0.908143> }
triangle { <-0.321020, -0.321020, 0.891007>, <-0.303779, -0.337381, 0.891007>, <-0.326951, -0.363116, 0.872496> }
triangle { <-0.326951, -0.363116, 0.872496>, <-0.345507, -0.345507, 0.872496>, <-0.321020, -0.321020, 0.891007> }
triangle { <-0.345507, -0.345507, 0.872496>, <-0.326951, -0.363116, 0.872496>, <-0.349620, -0.388292, 0.852640> }
triangle { <-0.349620, -0.388292, 0.852640>, <-0.369462, -0.369462, 0.852640>, <-0.345507, -0.345507, 0.872496> }
triangle { <-0.369462, -0.369462, 0.852640>, <-0.349620, -0.388292, 0.852640>, <-0.371749, -0.412869, 0.831470> }
triangle { <-0.371749, -0.412869, 0.831470>, <-0.392847, -0.392847, 0.831470>, <-0.369462, -0.369462, 0.852640> }
triangle { <-0.392847, -0.392847, 0.831470>, <-0.371749, -0.412869, 0.831470>, <-0.393305, -0.436810, 0.809017> }
triangle { <-0.393305, -0.436810, 0.809017>, <-0.415627, -0.415627, 0.809017>, <-0.392847, -0.392847, 0.831470> }
triangle { <-0.415627, -0.415627, 0.809017>, <-0.393305, -0.436810, 0.809017>, <-0.414255, -0.460076, 0.785317> }
triangle { <-0.414255, -0.460076, 0.785317>, <-0.437766, -0.437766, 0.785317>, <-0.415627, -0.415627, 0.809017> }
triangle { <-0.437766, -0.437766, 0.785317>, <-0.414255, -0.460076, 0.785317>, <-0.434566, -0.482634, 0.760406> }
triangle { <-0.434566, -0.482634, 0.760406>, <-0.459229, -0.459229, 0.760406>, <-0.437766, -0.437766, 0.785317> }
triangle { <-0.459229, -0.459229, 0.760406>, <-0.434566, -0.482634, 0.760406>, <-0.454206, -0.504447, 0.734323> }
triangle { <-0.454206, -0.504447, 0.734323>, <-0.479985, -0.479985, 0.734323>, <-0.459229, -0.459229, 0.760406> }
triangle { <-0.479985, -0.479985, 0.734323>, <-0.454206, -0.504447, 0.734323>, <-0.473147, -0.525483, 0.707107> }
triangle { <-0.473147, -0.525483, 0.707107>, <-0.500000, -0.500000, 0.707107>, <-0.479985, -0.479985, 0.734323> }
triangle { <-0.500000, -0.500000, 0.707107>, <-0.473147, -0.525483, 0.707107>, <-0.491358, -0.545708, 0.678801> }
triangle { <-0.491358, -0.545708, 0.678801>, <-0.519244, -0.519244, 0.678801>, <-0.500000, -0.500000, 0.707107> }
triangle { <-0.519244, -0.519244, 0.678801>, <-0.491358, -0.545708, 0.678801>, <-0.508811, -0.565092, 0.649448> }
triangle { <-0.508811, -0.565092, 0.649448>, <-0.537688, -0.537688, 0.649448>, <-0.519244, -0.519244, 0.678801> }
triangle { <-0.537688, -0.537688, 0.649448>, <-0.508811, -0.565092, 0.649448>, <-0.525480, -0.583604, 0.619094> }
triangle { <-0.525480, -0.583604, 0.619094>, <-0.555303, -0.555303, 0.619094>, <-0.537688, -0.537688, 0.649448> }
triangle { <-0.555303, -0.555303, 0.619094>, <-0.525480, -0.583604, 0.619094>, <-0.541338, -0.601217, 0.587785> }
triangle { <-0.541338, -0.601217, 0.587785>, <-0.572061, -0.572061, 0.587785>, <-0.555303, -0.555303, 0.619094> }
triangle { <-0.572061, -0.572061, 0.587785>, <-0.541338, -0.601217, 0.587785>, <-0.556362, -0.617902, 0.555570> }
triangle { <-0.556362, -0.617902, 0.555570>, <-0.587938, -0.587938, 0.555570>, <-0.572061, -0.572061, 0.587785> }
triangle { <-0.587938, -0.587938, 0.555570>, <-0.556362, -0.617902, 0.555570>, <-0.570528, -0.633635, 0.522499> }
triangle { <-0.570528, -0.633635, 0.522499>, <-0.602908, -0.602908, 0.522499>, <-0.587938, -0.587938, 0.555570> }
triangle { <-0.602908, -0.602908, 0.522499>, <-0.570528, -0.633635, 0.522499>, <-0.583814, -0.648391, 0.488621> }
triangle { <-0.583814, -0.648391, 0.488621>, <-0.616948, -0.616948, 0.488621>, <-0.602908, -0.602908, 0.522499> }
triangle { <-0.616948, -0.616948, 0.488621>, <-0.583814, -0.648391, 0.488621>, <-0.596200, -0.662147, 0.453990> }
triangle { <-0.596200, -0.662147, 0.453990>, <-0.630037, -0.630037, 0.453990>, <-0.616948, -0.616948, 0.488621> }
triangle { <-0.630037, -0.630037, 0.453990>, <-0.596200, -0.662147, 0.453990>, <-0.607666, -0.674882, 0.418660> }
triangle { <-0.607666, -0.674882, 0.418660>, <-0.642154, -0.642154, 0.418660>, <-0.630037, -0.630037, 0.453990> }
triangle { <-0.642154, -0.642154, 0.418660>, <-0.607666, -0.674882, 0.418660>, <-0.618196, -0.686576, 0.382683> }
triangle { <-0.618196, -0.686576, 0.382683>, <-0.653281, -0.653281, 0.382683>, <-0.642154, -0.642154, 0.418660> }
triangle { <-0.653281, -0.653281, 0.382683>, <-0.618196, -0.686576, 0.382683>, <-0.627773, -0.697212, 0.346117> }
triangle { <-0.627773, -0.697212, 0.346117>, <-0.663401, -0.663401, 0.346117>, <-0.653281, -0.653281, 0.382683> }
triangle { <-0.663401, -0.663401, 0.346117>, <-0.627773, -0.697212, 0.346117>, <-0.636381, -0.706773, 0.309017> }
triangle { <-0.636381, -0.706773, 0.309017>, <-0.672499, -0.672499, 0.309017>, <-0.663401, -0.663401, 0.346117> }
triangle { <-0.672499, -0.672499, 0.309017>, <-0.636381, -0.706773, 0.309017>, <-0.644008, -0.715244, 0.271440> }
triangle { <-0.644008, -0.715244, 0.271440>, <-0.680559, -0.680559, 0.271440>, <-0.672499, -0.672499, 0.309017> }
triangle { <-0.680559, -0.680559, 0.271440>, <-0.644008, -0.715244, 0.271440>, <-0.650642, -0.722612, 0.233445> }
triangle { <-0.650642, -0.722612, 0.233445>, <-0.687569, -0.687569, 0.233445>, <-0.680559, -0.680559, 0.271440> }
triangle { <-0.687569, -0.687569, 0.233445>, <-0.650642, -0.722612, 0.233445>, <-0.656273, -0.728866, 0.195090> }
triangle { <-0.656273, -0.728866, 0.195090>, <-0.693520, -0.693520, 0.195090>, <-0.687569, -0.687569, 0.233445> }
triangle { <-0.693520, -0.693520, 0.195090>, <-0.656273, -0.728866, 0.195090>, <-0.660892, -0.733995, 0.156434> }
triangle { <-0.660892, -0.733995, 0.156434>, <-0.698401, -0.698401, 0.156434>, <-0.693520, -0.693520, 0.195090> }
triangle { <-0.698401, -0.698401, 0.156434>, <-0.660892, -0.733995, 0.156434>, <-0.664492, -0.737994, 0.117537> }
triangle { <-0.664492, -0.737994, 0.117537>, <-0.702205, -0.702205, 0.117537>, <-0.698401, -0.698401, 0.156434> }
triangle { <-0.702205, -0.702205, 0.117537>, <-0.664492, -0.737994, 0.117537>, <-0.667068, -0.740854, 0.078459> }
triangle { <-0.667068, -0.740854, 0.078459>, <-0.704927, -0.704927, 0.078459>, <-0.702205, -0.702205, 0.117537> }
triangle { <-0.704927, -0.704927, 0.078459>, <-0.667068, -0.740854, 0.078459>, <-0.668615, -0.742572, 0.039260> }
triangle { <-0.668615, -0.742572, 0.039260>, <-0.706562, -0.706562, 0.039260>, <-0.704927, -0.704927, 0.078459> }
triangle { <-0.706562, -0.706562, 0.039260>, <-0.668615, -0.742572, 0.039260>, <-0.669131, -0.743145, -0.000000> }
triangle { <-0.669131, -0.743145, -0.000000>, <-0.707107, -0.707107, -0.000000>, <-0.706562, -0.706562, 0.039260> }
triangle { <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <-0.024707, -0.030511, 0.999229> }
triangle { <-0.024707, -0.030511, 0.999229>, <-0.026270, -0.029176, 0.999229>, <0.000000, 0.000000, 1.000000> }
triangle { <-0.026270, -0.029176, 0.999229>, <-0.024707, -0.030511, 0.999229>, <-0.049376, -0.060974, 0.996917> }
triangle { <-0.049376, -0.060974, 0.996917>, <-0.052499, -0.058306, 0.996917>, <-0.026270, -0.029176, 0.999229> }
triangle { <-0.052499, -0.058306, 0.996917>, <-0.049376, -0.060974, 0.996917>, <-0.073969, -0.091344, 0.993068> }
triangle { <-0.073969, -0.091344, 0.993068>, <-0.078648, -0.087347, 0.993068>, <-0.052499, -0.058306, 0.996917> }
triangle { <-0.078648, -0.087347, 0.993068>, <-0.073969, -0.091344, 0.993068>, <-0.098447, -0.121572, 0.987688> }
triangle { <-0.098447, -0.121572, 0.987688>, <-0.104675, -0.116253, 0.987688>, <-0.078648, -0.087347, 0.993068> }
triangle { <-0.104675, -0.116253, 0.987688>, <-0.098447, -0.121572, 0.987688>, <-0.122774, -0.151614, 0.980785> }
triangle { <-0.122774, -0.151614, 0.980785>, <-0.130541, -0.144980, 0.980785>, <-0.104675, -0.116253, 0.987688> }
triangle { <-0.130541, -0.144980, 0.980785>, <-0.122774, -0.151614, 0.980785>, <-0.146912, -0.181421, 0.972370> }
triangle { <-0.146912, -0.181421, 0.972370>, <-0.156205, -0.173484, 0.972370>, <-0.130541, -0.144980, 0.980785> }
triangle { <-0.156205, -0.173484, 0.972370>, <-0.146912, -0.181421, 0.972370>, <-0.170823, -0.210949, 0.962455> }
triangle { <-0.170823, -0.210949, 0.962455>, <-0.181629, -0.201720, 0.962455>, <-0.156205, -0.173484, 0.972370> }
triangle { <-0.181629, -0.201720, 0.962455>, <-0.170823, -0.210949, 0.962455>, <-0.194471, -0.240151, 0.951057> }
triangle { <-0.194471, -0.240151, 0.951057>, <-0.206773, -0.229644, 0.951057>, <-0.181629, -0.201720, 0.962455> }
triangle { <-0.206773, -0.229644, 0.951057>, <-0.194471, -0.240151, 0.951057>, <-0.217819, -0.268983, 0.938191> }
triangle { <-0.217819, -0.268983, 0.938191>, <-0.231598, -0.257215, 0.938191>, <-0.206773, -0.229644, 0.951057> }
triangle { <-0.231598, -0.257215, 0.938191>, <-0.217819, -0.268983, 0.938191>, <-0.240830, -0.297401, 0.923880> }
triangle { <-0.240830, -0.297401, 0.923880>, <-0.256065, -0.284389, 0.923880>, <-0.231598, -0.257215, 0.938191> }
triangle { <-0.256065, -0.284389, 0.923880>, <-0.240830, -0.297401, 0.923880>, <-0.263471, -0.325360, 0.908143> }
triangle { <-0.263471, -0.325360, 0.908143>, <-0.280138, -0.311125, 0.908143>, <-0.256065, -0.284389, 0.923880> }
triangle { <-0.280138, -0.311125, 0.908143>, <-0.263471, -0.325360, 0.908143>, <-0.285705, -0.352817, 0.891007> }
triangle { <-0.285705, -0.352817, 0.891007>, <-0.303779, -0.337381, 0.891007>, <-0.280138, -0.311125, 0.908143> }
triangle { <-0.303779, -0.337381, 0.891007>, <-0.285705, -0.352817, 0.891007>, <-0.307499, -0.379730, 0.872496> }
triangle { <-0.307499, -0.379730, 0.872496>, <-0.326951, -0.363116, 0.872496>, <-0.303779, -0.337381, 0.891007> }
triangle { <-0.326951, -0.363116, 0.872496>, <-0.307499, -0.379730, 0.872496>, <-0.328819, -0.406058, 0.852640> }
triangle { <-0.328819, -0.406058, 0.852640>, <-0.349620, -0.388292, 0.852640>, <-0.326951, -0.363116, 0.872496> }
triangle { <-0.349620, -0.388292, 0.852640>, <-0.328819, -0.406058, 0.852640>, <-0.349632, -0.431759, 0.831470> }
triangle { <-0.349632, -0.431759, 0.831470>, <-0.371749, -0.412869, 0.831470>, <-0.349620, -0.388292, 0.852640> }
triangle { <-0.371749, -0.412869, 0.831470>, <-0.349632, -0.431759, 0.831470>, <-0.369905, -0.456795, 0.809017> }
triangle { <-0.369905, -0.456795, 0.809017>, <-0.393305, -0.436810, 0.809017>, <-0.371749, -0.412869, 0.831470> }
triangle { <-0.393305, -0.436810, 0.809017>, <-0.369905, -0.456795, 0.809017>, <-0.389608, -0.481126, 0.785317> }
triangle { <-0.389608, -0.481126, 0.785317>, <-0.414255, -0.460076, 0.785317>, <-0.393305, -0.436810, 0.809017> }
triangle { <-0.414255, -0.460076, 0.785317>, <-0.389608, -0.481126, 0.785317>, <-0.408711, -0.504716, 0.760406> }
triangle { <-0.408711, -0.504716, 0.760406>, <-0.434566, -0.482634, 0.760406>, <-0.414255, -0.460076, 0.785317> }
triangle { <-0.434566, -0.482634, 0.760406>, <-0.408711, -0.504716, 0.760406>, <-0.427183, -0.527527, 0.734323> }
triangle { <-0.427183, -0.527527, 0.734323>, <-0.454206, -0.504447, 0.734323>, <-0.434566, -0.482634, 0.760406> }
triangle { <-0.454206, -0.504447, 0.734323>, <-0.427183, -0.527527, 0.734323>, <-0.444997, -0.549525, 0.707107> }
triangle { <-0.444997, -0.549525, 0.707107>, <-0.473147, -0.525483, 0.707107>, <-0.454206, -0.504447, 0.734323> }
triangle { <-0.473147, -0.525483, 0.707107>, <-0.444997, -0.549525, 0.707107>, <-0.462124, -0.570676, 0.678801> }
triangle { <-0.462124, -0.570676, 0.678801>, <-0.491358, -0.545708, 0.678801>, <-0.473147, -0.525483, 0.707107> }
triangle { <-0.491358, -0.545708, 0.678801>, <-0.462124, -0.570676, 0.678801>, <-0.478539, -0.590946, 0.649448> }
triangle { <-0.478539, -0.590946, 0.649448>, <-0.508811, -0.565092, 0.649448>, <-0.491358, -0.545708, 0.678801> }
triangle { <-0.508811, -0.565092, 0.649448>, <-0.478539, -0.590946, 0.649448>, <-0.494216, -0.610306, 0.619094> }
triangle { <-0.494216, -0.610306, 0.619094>, <-0.525480, -0.583604, 0.619094>, <-0.508811, -0.565092, 0.649448> }
triangle { <-0.525480, -0.583604, 0.619094>, <-0.494216, -0.610306, 0.619094>, <-0.509131, -0.628724, 0.587785> }
triangle { <-0.509131, -0.628724, 0.587785>, <-0.541338, -0.601217, 0.587785>, <-0.525480, -0.583604, 0.619094> }
triangle { <-0.541338, -0.601217, 0.587785>, <-0.509131, -0.628724, 0.587785>, <-0.523261, -0.646173, 0.555570> }
triangle { <-0.523261, -0.646173, 0.555570>, <-0.556362, -0.617902, 0.555570>, <-0.541338, -0.601217, 0.587785> }
triangle { <-0.556362, -0.617902, 0.555570>, <-0.523261, -0.646173, 0.555570>, <-0.536584, -0.662626, 0.522499> }
triangle { <-0.536584, -0.662626, 0.522499>, <-0.570528, -0.633635, 0.522499>, <-0.556362, -0.617902, 0.555570> }
triangle { <-0.570528, -0.633635, 0.522499>, <-0.536584, -0.662626, 0.522499>, <-0.549080, -0.678057, 0.488621> }
triangle { <-0.549080, -0.678057, 0.488621>, <-0.583814, -0.648391, 0.488621>, <-0.570528, -0.633635, 0.522499> }
triangle { <-0.583814, -0.648391, 0.488621>, <-0.549080, -0.678057, 0.488621>, <-0.560729, -0.692442, 0.453990> }
triangle { <-0.560729, -0.692442, 0.453990>, <-0.596200, -0.662147, 0.453990>, <-0.583814, -0.648391, 0.488621> }
triangle { <-0.596200, -0.662147, 0.453990>, <-0.560729, -0.692442, 0.453990>, <-0.571513, -0.705760, 0.418660> }
triangle { <-0.571513, -0.705760, 0.418660>, <-0.607666, -0.674882, 0.418660>, <-0.596200, -0.662147, 0.453990> }
triangle { <-0.607666, -0.674882, 0.418660>, <-0.571513, -0.705760, 0.418660>, <-0.581416, -0.717989, 0.382683> }
triangle { <-0.581416, -0.717989, 0.382683>, <-0.618196, -0.686576, 0.382683>, <-0.607666, -0.674882, 0.418660> }
triangle { <-0.618196, -0.686576, 0.382683>, <-0.581416, -0.717989, 0.382683>, <-0.590423, -0.729112, 0.346117> }
triangle { <-0.590423, -0.729112, 0.346117>, <-0.627773, -0.697212, 0.346117>, <-0.618196, -0.686576, 0.382683> }
triangle { <-0.627773, -0.697212, 0.346117>, <-0.590423, -0.729112, 0.346117>, <-0.598519, -0.739110, 0.309017> }
triangle { <-0.598519, -0.739110, 0.309017>, <-0.636381, -0.706773, 0.309017>, <-0.627773, -0.697212, 0.346117> }
triangle { <-0.636381, -0.706773, 0.309017>, <-0.598519, -0.739110, 0.309017>, <-0.605693, -0.747968, 0.271440> }
triangle { <-0.605693, -0.747968, 0.271440>, <-0.644008, -0.715244, 0.271440>, <-0.636381, -0.706773, 0.309017> }
triangle { <-0.644008, -0.715244, 0.271440>, <-0.605693, -0.747968, 0.271440>, <-0.611932, -0.755673, 0.233445> }
triangle { <-0.611932, -0.755673, 0.233445>, <-0.650642, -0.722612, 0.233445>, <-0.644008, -0.715244, 0.271440> }
triangle { <-0.650642, -0.722612, 0.233445>, <-0.611932, -0.755673, 0.233445>, <-0.617228, -0.762213, 0.195090> }
triangle { <-0.617228, -0.762213, 0.195090>, <-0.656273, -0.728866, 0.195090>, <-0.650642, -0.722612, 0.233445> }
triangle { <-0.656273, -0.728866, 0.195090>, <-0.617228, -0.762213, 0.195090>, <-0.621572, -0.767578, 0.156434> }
triangle { <-0.621572, -0.767578, 0.156434>, <-0.660892, -0.733995, 0.156434>, <-0.656273, -0.728866, 0.195090> }
triangle { <-0.660892, -0.733995, 0.156434>, <-0.621572, -0.767578, 0.156434>, <-0.624958, -0.771759, 0.117537> }
triangle { <-0.624958, -0.771759, 0.117537>, <-0.664492, -0.737994, 0.117537>, <-0.660892, -0.733995, 0.156434> }
triangle { <-0.664492, -0.737994, 0.117537>, <-0.624958, -0.771759, 0.117537>, <-0.627380, -0.774750, 0.078459> }
triangle { <-0.627380, -0.774750, 0.078459>, <-0.667068, -0.740854, 0.078459>, <-0.664492, -0.737994, 0.117537> }
triangle { <-0.667068, -0.740854, 0.078459>, <-0.627380, -0.774750, 0.078459>, <-0.628835, -0.776547, 0.039260> }
triangle { <-0.628835, -0.776547, 0.039260>, <-0.668615, -0.742572, 0.039260>, <-0.667068, -0.740854, 0.078459> }
triangle { <-0.668615, -0.742572, 0.039260>, <-0.628835, -0.776547, 0.039260>, <-0.629320, -0.777146, -0.000000> }
triangle { <-0.629320, -0.777146, -0.000000>, <-0.669131, -0.743145, -0.000000>, <-0.668615, -0.742572, 0.039260> }
triangle { <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <-0.023076, -0.031762, 0.999229> }
triangle { <-0.023076, -0.031762, 0.999229>, <-0.024707, -0.030511, 0.999229>, <0.000000, 0.000000, 1.000000> }
triangle { <-0.024707, -0.030511, 0.999229>, <-0.023076, -0.031762, 0.999229>, <-0.046117, -0.063475, 0.996917> }
triangle { <-0.046117, -0.063475, 0.996917>, <-0.049376, -0.060974, 0.996917>, <-0.024707, -0.030511, 0.999229> }
triangle { <-0.049376, -0.060974, 0.996917>, <-0.046117, -0.063475, 0.996917>, <-0.069087, -0.095090, 0.993068> }
triangle { <-0.069087, -0.095090, 0.993068>, <-0.073969, -0.091344, 0.993068>, <-0.049376, -0.060974, 0.996917> }
triangle { <-0.073969, -0.091344, 0.993068>, <-0.069087, -0.095090, 0.993068>, <-0.091950, -0.126558, 0.987688> }
triangle { <-0.091950, -0.126558, 0.987688>, <-0.098447, -0.121572, 0.987688>, <-0.073969, -0.091344, 0.993068> }
triangle { <-0.098447, -0.121572, 0.987688>, <-0.091950, -0.126558, 0.987688>, <-0.114671, -0.157831, 0.980785> }
triangle { <-0.114671, -0.157831, 0.980785>, <-0.122774, -0.151614, 0.980785>, <-0.098447, -0.121572, 0.987688> }
triangle { <-0.122774, -0.151614, 0.980785>, <-0.114671, -0.157831, 0.980785>, <-0.137216, -0.188861, 0.972370> }
triangle { <-0.137216, -0.188861, 0.972370>, <-0.146912, -0.181421, 0.972370>, <-0.122774, -0.151614, 0.980785> }
triangle { <-0.146912, -0.181421, 0.972370>, <-0.137216, -0.188861, 0.972370>, <-0.159549, -0.219600, 0.962455> }
triangle { <-0.159549, -0.219600, 0.962455>, <-0.170823, -0.210949, 0.962455>, <-0.146912, -0.181421, 0.972370> }
triangle { <-0.170823, -0.210949, 0.962455>, <-0.159549, -0.219600, 0.962455>, <-0.181636, -0.250000, 0.951057> }
triangle { <-0.181636, -0.250000, 0.951057>, <-0.194471, -0.240151, 0.951057>, <-0.170823, -0.210949, 0.962455> }
triangle { <-0.194471, -0.240151, 0.951057>, <-0.181636, -0.250000, 0.951057>, <-0.203443, -0.280015, 0.938191> }
triangle { <-0.203443, -0.280015, 0.938191>, <-0.217819, -0.268983, 0.938191>, <-0.194471, -0.240151, 0.951057> }
triangle { <-0.217819, -0.268983, 0.938191>, <-0.203443, -0.280015, 0.938191>, <-0.224936, -0.309597, 0.923880> }
triangle { <-0.224936, -0.309597, 0.923880>, <-0.240830, -0.297401, 0.923880>, <-0.217819, -0.268983, 0.938191> }
triangle { <-0.240830, -0.297401, 0.923880>, <-0.224936, -0.309597, 0.923880>, <-0.246082, -0.338703, 0.908143> }
triangle { <-0.246082, -0.338703, 0.908143>, <-0.263471, -0.325360, 0.908143>, <-0.240830, -0.297401, 0.923880> }
triangle { <-0.263471, -0.325360, 0.908143>, <-0.246082, -0.338703, 0.908143>, <-0.266849, -0.367286, 0.891007> }
triangle { <-0.266849, -0.367286, 0.891007>, <-0.285705, -0.352817, 0.891007>, <-0.263471, -0.325360, 0.908143> }
triangle { <-0.285705, -0.352817, 0.891007>, <-0.266849, -0.367286, 0.891007>, <-0.287204, -0.395303, 0.872496> }
triangle { <-0.287204, -0.395303, 0.872496>, <-0.307499, -0.379730, 0.872496>, <-0.285705, -0.352817, 0.891007> }
triangle { <-0.307499, -0.379730, 0.872496>, <-0.287204, -0.395303, 0.872496>, <-0.307117, -0.422710, 0.852640> }
triangle { <-0.307117, -0.422710, 0.852640>, <-0.328819, -0.406058, 0.852640>, <-0.307499, -0.379730, 0.872496> }
triangle { <-0.328819, -0.406058, 0.852640>, <-0.307117, -0.422710, 0.852640>, <-0.326556, -0.449466, 0.831470> }
triangle { <-0.326556, -0.449466, 0.831470>, <-0.349632, -0.431759, 0.831470>, <-0.328819, -0.406058, 0.852640> }
triangle { <-0.349632, -0.431759, 0.831470>, <-0.326556, -0.449466, 0.831470>, <-0.345492, -0.475528, 0.809017> }
triangle { <-0.345492, -0.475528, 0.809017>, <-0.369905, -0.456795, 0.809017>, <-0.349632, -0.431759, 0.831470> }
triangle { <-0.369905, -0.456795, 0.809017>, <-0.345492, -0.475528, 0.809017>, <-0.363894, -0.500858, 0.785317> }
triangle { <-0.363894, -0.500858, 0.785317>, <-0.389608, -0.481126, 0.785317>, <-0.369905, -0.456795, 0.809017> }
triangle { <-0.389608, -0.481126, 0.785317>, <-0.363894, -0.500858, 0.785317>, <-0.381736, -0.525415, 0.760406> }
triangle { <-0.381736, -0.525415, 0.760406>, <-0.408711, -0.504716, 0.760406>, <-0.389608, -0.481126, 0.785317> }
triangle { <-0.408711, -0.504716, 0.760406>, <-0.381736, -0.525415, 0.760406>, <-0.398989, -0.549161, 0.734323> }
triangle { <-0.398989, -0.549161, 0.734323>, <-0.427183, -0.527527, 0.734323>, <-0.408711, -0.504716, 0.760406> }
triangle { <-0.427183, -0.527527, 0.734323>, <-0.398989, -0.549161, 0.734323>, <-0.415627, -0.572061, 0.707107> }
triangle { <-0.415627, -0.572061, 0.707107>, <-0.444997, -0.549525, 0.707107>, <-0.427183, -0.527527, 0.734323> }
triangle { <-0.444997, -0.549525, 0.707107>, <-0.415627, -0.572061, 0.707107>, <-0.431624, -0.594079, 0.678801> }
triangle { <-0.431624, -0.594079, 0.678801>, <-0.462124, -0.570676, 0.678801>, <-0.444997, -0.549525, 0.707107> }
triangle { <-0.462124, -0.570676, 0.678801>, <-0.431624, -0.594079, 0.678801>, <-0.446955, -0.615181, 0.649448> }
triangle { <-0.446955, -0.615181, 0.649448>, <-0.478539, -0.590946, 0.649448>, <-0.462124, -0.570676, 0.678801> }
triangle { <-0.478539, -0.590946, 0.649448>, <-0.446955, -0.615181, 0.649448>, <-0.461598, -0.635335, 0.619094> }
triangle { <-0.461598, -0.635335, 0.619094>, <-0.494216, -0.610306, 0.619094>, <-0.478539, -0.590946, 0.649448> }
triangle { <-0.494216, -0.610306, 0.619094>, <-0.461598, -0.635335, 0.619094>, <-0.475528, -0.654508, 0.587785> }
triangle { <-0.475528, -0.654508, 0.587785>, <-0.509131, -0.628724, 0.587785>, <-0.494216, -0.610306, 0.619094> }
triangle { <-0.509131, -0.628724, 0.587785>, <-0.475528, -0.654508, 0.587785>, <-0.488726, -0.672673, 0.555570> }
triangle { <-0.488726, -0.672673, 0.555570>, <-0.523261, -0.646173, 0.555570>, <-0.509131, -0.628724, 0.587785> }
triangle { <-0.523261, -0.646173, 0.555570>, <-0.488726, -0.672673, 0.555570>, <-0.501169, -0.689800, 0.522499> }
triangle { <-0.501169, -0.689800, 0.522499>, <-0.536584, -0.662626, 0.522499>, <-0.523261, -0.646173, 0.555570> }
triangle { <-0.536584, -0.662626, 0.522499>, <-0.501169, -0.689800, 0.522499>, <-0.512840, -0.705864, 0.488621> }
triangle { <-0.512840, -0.705864, 0.488621>, <-0.549080, -0.678057, 0.488621>, <-0.536584, -0.662626, 0.522499> }
triangle { <-0.549080, -0.678057, 0.488621>, <-0.512840, -0.705864, 0.488621>, <-0.523720, -0.720839, 0.453990> }
triangle { <-0.523720, -0.720839, 0.453990>, <-0.560729, -0.692442, 0.453990>, <-0.549080, -0.678057, 0.488621> }
triangle { <-0.560729, -0.692442, 0.453990>, <-0.523720, -0.720839, 0.453990>, <-0.533793, -0.734703, 0.418660> }
triangle { <-0.533793, -0.734703, 0.418660>, <-0.571513, -0.705760, 0.418660>, <-0.560729, -0.692442, 0.453990> }
triangle { <-0.571513, -0.705760, 0.418660>, <-0.533793, -0.734703, 0.418660>, <-0.543043, -0.747434, 0.382683> }
triangle { <-0.543043, -0.747434, 0.382683>, <-0.581416, -0.717989, 0.382683>, <-0.571513, -0.705760, 0.418660> }
triangle { <-0.581416, -0.717989, 0.382683>, <-0.543043, -0.747434, 0.382683>, <-0.551455, -0.759013, 0.346117> }
triangle { <-0.551455, -0.759013, 0.346117>, <-0.590423, -0.729112, 0.346117>, <-0.581416, -0.717989, 0.382683> }
triangle { <-0.590423, -0.729112, 0.346117>, <-0.551455, -0.759013, 0.346117>, <-0.559017, -0.769421, 0.309017> }
triangle { <-0.559017, -0.769421, 0.309017>, <-0.598519, -0.739110, 0.309017>, <-0.590423, -0.729112, 0.346117> }
triangle { <-0.598519, -0.739110, 0.309017>, <-0.559017, -0.769421, 0.309017>, <-0.565717, -0.778643, 0.271440> }
triangle { <-0.565717, -0.778643, 0.271440>, <-0.605693, -0.747968, 0.271440>, <-0.598519, -0.739110, 0.309017> }
triangle { <-0.605693, -0.747968, 0.271440>, <-0.565717, -0.778643, 0.271440>, <-0.571545, -0.786664, 0.233445> }
triangle { <-0.571545, -0.786664, 0.233445>, <-0.611932, -0.755673, 0.233445>, <-0.605693, -0.747968, 0.271440> }
triangle { <-0.611932, -0.755673, 0.233445>, <-0.571545, -0.786664, 0.233445>, <-0.576491, -0.793472, 0.195090> }
triangle { <-0.576491, -0.793472, 0.195090>, <-0.617228, -0.762213, 0.195090>, <-0.611932, -0.755673, 0.233445> }
triangle { <-0.617228, -0.762213, 0.195090>, <-0.576491, -0.793472, 0.195090>, <-0.580549, -0.799057, 0.156434> }
triangle { <-0.580549, -0.799057, 0.156434>, <-0.621572, -0.767578, 0.156434>, <-0.617228, -0.762213, 0.195090> }
triangle { <-0.621572, -0.767578, 0.156434>, <-0.580549, -0.799057, 0.156434>, <-0.583711, -0.803409, 0.117537> }
triangle { <-0.583711, -0.803409, 0.117537>, <-0.624958, -0.771759, 0.117537>, <-0.621572, -0.767578, 0.156434> }
triangle { <-0.624958, -0.771759, 0.117537>, <-0.583711, -0.803409, 0.117537>, <-0.585973, -0.806523, 0.078459> }
triangle { <-0.585973, -0.806523, 0.078459>, <-0.627380, -0.774750, 0.078459>, <-0.624958, -0.771759, 0.117537> }
triangle { <-0.627380, -0.774750, 0.078459>, <-0.585973, -0.806523, 0.078459>, <-0.587332, -0.808393, 0.039260> }
triangle { <-0.587332, -0.808393, 0.039260>, <-0.628835, -0.776547, 0.039260>, <-0.627380, -0.774750, 0.078459> }
triangle { <-0.628835, -0.776547, 0.039260>, <-0.587332, -0.808393, 0.039260>, <-0.587785, -0.809017, -0.000000> }
triangle { <-0.587785, -0.809017, -0.000000>, <-0.629320, -0.777146, -0.000000>, <-0.628835, -0.776547, 0.039260> }
triangle { <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <-0.021382, -0.032926, 0.999229> }
triangle { <-0.021382, -0.032926, 0.999229>, <-0.023076, -0.031762, 0.999229>, <0.000000, 0.000000, 1.000000> }
triangle { <-0.023076, -0.031762, 0.999229>, <-0.021382, -0.032926, 0.999229>, <-0.042732, -0.065801, 0.996917> }
triangle { <-0.042732, -0.065801, 0.996917>, <-0.046117, -0.063475, 0.996917>, <-0.023076, -0.031762, 0.999229> }
triangle { <-0.046117, -0.063475, 0.996917>, <-0.042732, -0.065801, 0.996917>, <-0.064015, -0.098575, 0.993068> }
triangle { <-0.064015, -0.098575, 0.993068>, <-0.069087, -0.095090, 0.993068>, <-0.046117, -0.063475, 0.996917> }
triangle { <-0.069087, -0.095090, 0.993068>, <-0.064015, -0.098575, 0.993068>, <-0.085200, -0.131197, 0.987688> }
triangle { <-0.085200, -0.131197, 0.987688>, <-0.091950, -0.126558, 0.987688>, <-0.069087, -0.095090, 0.993068> }
triangle { <-0.091950, -0.126558, 0.987688>, <-0.085200, -0.131197, 0.987688>, <-0.106254, -0.163617, 0.980785> }
triangle { <-0.106254, -0.163617, 0.980785>, <-0.114671, -0.157831, 0.980785>, <-0.091950, -0.126558, 0.987688> }
triangle { <-0.114671, -0.157831, 0.980785>, <-0.106254, -0.163617, 0.980785>, <-0.127143, -0.195784, 0.972370> }
triangle { <-0.127143, -0.195784, 0.972370>, <-0.137216, -0.188861, 0.972370>, <-0.114671, -0.157831, 0.980785> }
triangle { <-0.137216, -0.188861, 0.972370>, <-0.127143, -0.195784, 0.972370>, <-0.147837, -0.227649, 0.962455> }
triangle { <-0.147837, -0.227649, 0.962455>, <-0.159549, -0.219600, 0.962455>, <-0.137216, -0.188861, 0.972370> }
triangle { <-0.159549, -0.219600, 0.962455>, <-0.147837, -0.227649, 0.962455>, <-0.168303, -0.259163, 0.951057> }
triangle { <-0.168303, -0.259163, 0.951057>, <-0.181636, -0.250000, 0.951057>, <-0.159549, -0.219600, 0.962455> }
triangle { <-0.181636, -0.250000, 0.951057>, <-0.168303, -0.259163, 0.951057>, <-0.188509, -0.290278, 0.938191> }
triangle { <-0.188509, -0.290278, 0.938191>, <-0.203443, -0.280015, 0.938191>, <-0.181636, -0.250000, 0.951057> }
triangle { <-0.203443, -0.280015, 0.938191>, <-0.188509, -0.290278, 0.938191>, <-0.208424, -0.320945, 0.923880> }
triangle { <-0.208424, -0.320945, 0.923880>, <-0.224936, -0.309597, 0.923880>, <-0.203443, -0.280015, 0.938191> }
triangle { <-0.224936, -0.309597, 0.923880>, <-0.208424, -0.320945, 0.923880>, <-0.228018, -0.351118, 0.908143> }
triangle { <-0.228018, -0.351118, 0.908143>, <-0.246082, -0.338703, 0.908143>, <-0.224936, -0.309597, 0.923880> }
triangle { <-0.246082, -0.338703, 0.908143>, <-0.228018, -0.351118, 0.908143>, <-0.247261, -0.380748, 0.891007> }
triangle { <-0.247261, -0.380748, 0.891007>, <-0.266849, -0.367286, 0.891007>, <-0.246082, -0.338703, 0.908143> }
triangle { <-0.266849, -0.367286, 0.891007>, <-0.247261, -0.380748, 0.891007>, <-0.266122, -0.409792, 0.872496> }
triangle { <-0.266122, -0.409792, 0.872496>, <-0.287204, -0.395303, 0.872496>, <-0.266849, -0.367286, 0.891007> }
triangle { <-0.287204, -0.395303, 0.872496>, <-0.266122, -0.409792, 0.872496>, <-0.284573, -0.438204, 0.852640> }
triangle { <-0.284573, -0.438204, 0.852640>, <-0.307117, -0.422710, 0.852640>, <-0.287204, -0.395303, 0.872496> }
triangle { <-0.307117, -0.422710, 0.852640>, <-0.284573, -0.438204, 0.852640>, <-0.302585, -0.465940, 0.831470> }
triangle { <-0.302585, -0.465940, 0.831470>, <-0.326556, -0.449466, 0.831470>, <-0.307117, -0.422710, 0.852640> }
triangle { <-0.326556, -0.449466, 0.831470>, <-0.302585, -0.465940, 0.831470>, <-0.320131, -0.492958, 0.809017> }
triangle { <-0.320131, -0.492958, 0.809017>, <-0.345492, -0.475528, 0.809017>, <-0.326556, -0.449466, 0.831470> }
triangle { <-0.345492, -0.475528, 0.809017>, <-0.320131, -0.492958, 0.809017>, <-0.337183, -0.519216, 0.785317> }
triangle { <-0.337183, -0.519216, 0.785317>, <-0.363894, -0.500858, 0.785317>, <-0.345492, -0.475528, 0.809017> }
triangle { <-0.363894, -0.500858, 0.785317>, <-0.337183, -0.519216, 0.785317>, <-0.353715, -0.544673, 0.760406> }
triangle { <-0.353715, -0.544673, 0.760406>, <-0.381736, -0.525415, 0.760406>, <-0.363894, -0.500858, 0.785317> }
triangle { <-0.381736, -0.525415, 0.760406>, <-0.353715, -0.544673, 0.760406>, <-0.369701, -0.569290, 0.734323> }
triangle { <-0.369701, -0.569290, 0.734323>, <-0.398989, -0.549161, 0.734323>, <-0.381736, -0.525415, 0.760406> }
triangle { <-0.398989, -0.549161, 0.734323>, <-0.369701, -0.569290, 0.734323>, <-0.385118, -0.593030, 0.707107> }
triangle { <-0.385118, -0.593030, 0.707107>, <-0.415627, -0.572061, 0.707107>, <-0.398989, -0.549161, 0.734323> }
triangle { <-0.415627, -0.572061, 0.707107>, <-0.385118, -0.593030, 0.707107>, <-0.399941, -0.615855, 0.678801> }
triangle { <-0.399941, -0.615855, 0.678801>, <-0.431624, -0.594079, 0.678801>, <-0.415627, -0.572061, 0.707107> }
triangle { <-0.431624, -0.594079, 0.678801>, <-0.399941, -0.615855, 0.678801>, <-0.414147, -0.637730, 0.649448> }
triangle { <-0.414147, -0.637730, 0.649448>, <-0.446955, -0.615181, 0.649448>, <-0.431624, -0.594079, 0.678801> }
triangle { <-0.446955, -0.615181, 0.649448>, <-0.414147, -0.637730, 0.649448>, <-0.427714, -0.658622, 0.619094> }
triangle { <-0.427714, -0.658622, 0.619094>, <-0.461598, -0.635335, 0.619094>, <-0.446955, -0.615181, 0.649448> }
triangle { <-0.461598, -0.635335, 0.619094>, <-0.427714, -0.658622, 0.619094>, <-0.440622, -0.678499, 0.587785> }
triangle { <-0.440622, -0.678499, 0.587785>, <-0.475528, -0.654508, 0.587785>, <-0.461598, -0.635335, 0.619094> }
triangle { <-0.475528, -0.654508, 0.587785>, <-0.440622, -0.678499, 0.587785>, <-0.452851, -0.697329, 0.555570> }
triangle { <-0.452851, -0.697329, 0.555570>, <-0.488726, -0.672673, 0.555570>, <-0.475528, -0.654508, 0.587785> }
triangle { <-0.488726, -0.672673, 0.555570>, <-0.452851, -0.697329, 0.555570>, <-0.464381, -0.715084, 0.522499> }
triangle { <-0.464381, -0.715084, 0.522499>, <-0.501169, -0.689800, 0.522499>, <-0.488726, -0.672673, 0.555570> }
triangle { <-0.501169, -0.689800, 0.522499>, <-0.464381, -0.715084, 0.522499>, <-0.475195, -0.731737, 0.488621> }
triangle { <-0.475195, -0.731737, 0.488621>, <-0.512840, -0.705864, 0.488621>, <-0.501169, -0.689800, 0.522499> }
triangle { <-0.512840, -0.705864, 0.488621>, <-0.475195, -0.731737, 0.488621>, <-0.485277, -0.747261, 0.453990> }
triangle { <-0.485277, -0.747261, 0.453990>, <-0.523720, -0.720839, 0.453990>, <-0.512840, -0.705864, 0.488621> }
triangle { <-0.523720, -0.720839, 0.453990>, <-0.485277, -0.747261, 0.453990>, <-0.494610, -0.761633, 0.418660> }
triangle { <-0.494610, -0.761633, 0.418660>, <-0.533793, -0.734703, 0.418660>, <-0.523720, -0.720839, 0.453990> }
triangle { <-0.533793, -0.734703, 0.418660>, <-0.494610, -0.761633, 0.418660>, <-0.503181, -0.774831, 0.382683> }
triangle { <-0.503181, -0.774831, 0.382683>, <-0.543043, -0.747434, 0.382683>, <-0.533793, -0.734703, 0.418660> }
triangle { <-0.543043, -0.747434, 0.382683>, <-0.503181, -0.774831, 0.382683>, <-0.510976, -0.786833, 0.346117> }
triangle { <-0.510976, -0.786833, 0.346117>, <-0.551455, -0.759013, 0.346117>, <-0.543043, -0.747434, 0.382683> }
triangle { <-0.551455, -0.759013, 0.346117>, <-0.510976, -0.786833, 0.346117>, <-0.517983, -0.797623, 0.309017> }
triangle { <-0.517983, -0.797623, 0.309017>, <-0.559017, -0.769421, 0.309017>, <-0.551455, -0.759013, 0.346117> }
triangle { <-0.559017, -0.769421, 0.309017>, <-0.517983, -0.797623, 0.309017>, <-0.524191, -0.807183, 0.271440> }
triangle { <-0.524191, -0.807183, 0.271440>, <-0.565717, -0.778643, 0.271440>, <-0.559017, -0.769421, 0.309017> }
triangle { <-0.565717, -0.778643, 0.271440>, <-0.524191, -0.807183, 0.271440>, <-0.529591, -0.815498, 0.233445> }
triangle { <-0.529591, -0.815498, 0.233445>, <-0.571545, -0.786664, 0.233445>, <-0.565717, -0.778643, 0.271440> }
triangle { <-0.571545, -0.786664, 0.233445>, <-0.529591, -0.815498, 0.233445>, <-0.534174, -0.822556, 0.195090> }
triangle { <-0.534174, -0.822556, 0.195090>, <-0.576491, -0.793472, 0.195090>, <-0.571545, -0.786664, 0.233445> }
triangle { <-0.576491, -0.793472, 0.195090>, <-0.534174, -0.822556, 0.195090>, <-0.537934, -0.828345, 0.156434> }
triangle { <-0.537934, -0.828345, 0.156434>, <-0.580549, -0.799057, 0.156434>, <-0.576491, -0.793472, 0.195090> }
triangle { <-0.580549, -0.799057, 0.156434>, <-0.537934, -0.828345, 0.156434>, <-0.540864, -0.832857, 0.117537> }
triangle { <-0.540864, -0.832857, 0.117537>, <-0.583711, -0.803409, 0.117537>, <-0.580549, -0.799057, 0.156434> }
triangle { <-0.583711, -0.803409, 0.117537>, <-0.540864, -0.832857, 0.117537>, <-0.542960, -0.836085, 0.078459> }
triangle { <-0.542960, -0.836085, 0.078459>, <-0.585973, -0.806523, 0.078459>, <-0.583711, -0.803409, 0.117537> }
triangle { <-0.585973, -0.806523, 0.078459>, <-0.542960, -0.836085, 0.078459>, <-0.544219, -0.838024, 0.039260> }
triangle { <-0.544219, -0.838024, 0.039260>, <-0.587332, -0.808393, 0.039260>, <-0.585973, -0.806523, 0.078459> }
triangle { <-0.587332, -0.808393, 0.039260>, <-0.544219, -0.838024, 0.039260>, <-0.544639, -0.838671, -0.000000> }
triangle { <-0.544639, -0.838671, -0.000000>, <-0.587785, -0.809017, -0.000000>, <-0.587332, -0.808393, 0.039260> }
triangle { <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <-0.019630, -0.034000, 0.999229> }
triangle { <-0.019630, -0.034000, 0.999229>, <-0.021382, -0.032926, 0.999229>, <0.000000, 0.000000, 1.000000> }
triangle { <-0.021382, -0.032926, 0.999229>, <-0.019630, -0.034000, 0.999229>, <-0.039230, -0.067948, 0.996917> }
triangle { <-0.039230, -0.067948, 0.996917>, <-0.042732, -0.065801, 0.996917>, <-0.021382, -0.032926, 0.999229> }
triangle { <-0.042732, -0.065801, 0.996917>, <-0.039230, -0.067948, 0.996917>, <-0.058769, -0.101790, 0.993068> }
triangle { <-0.058769, -0.101790, 0.993068>, <-0.064015, -0.098575, 0.993068>, <-0.042732, -0.065801, 0.996917> }
triangle { <-0.064015, -0.098575, 0.993068>, <-0.058769, -0.101790, 0.993068>, <-0.078217, -0.135476, 0.987688> }
triangle { <-0.078217, -0.135476, 0.987688>, <-0.085200, -0.131197, 0.987688>, <-0.064015, -0.098575, 0.993068> }
triangle { <-0.085200, -0.131197, 0.987688>, <-0.078217, -0.135476, 0.987688>, <-0.097545, -0.168953, 0.980785> }
triangle { <-0.097545, -0.168953, 0.980785>, <-0.106254, -0.163617, 0.980785>, <-0.085200, -0.131197, 0.987688> }
triangle { <-0.106254, -0.163617, 0.980785>, <-0.097545, -0.168953, 0.980785>, <-0.116723, -0.202170, 0.972370> }
triangle { <-0.116723, -0.202170, 0.972370>, <-0.127143, -0.195784, 0.972370>, <-0.106254, -0.163617, 0.980785> }
triangle { <-0.127143, -0.195784, 0.972370>, <-0.116723, -0.202170, 0.972370>, <-0.135720, -0.235074, 0.962455> }
triangle { <-0.135720, -0.235074, 0.962455>, <-0.147837, -0.227649, 0.962455>, <-0.127143, -0.195784, 0.972370> }
triangle { <-0.147837, -0.227649, 0.962455>, <-0.135720, -0.235074, 0.962455>, <-0.154508, -0.267617, 0.951057> }
triangle { <-0.154508, -0.267617, 0.951057>, <-0.168303, -0.259163, 0.951057>, <-0.147837, -0.227649, 0.962455> }
triangle { <-0.168303, -0.259163, 0.951057>, <-0.154508, -0.267617, 0.951057>, <-0.173059, -0.299746, 0.938191> }
triangle { <-0.173059, -0.299746, 0.938191>, <-0.188509, -0.290278, 0.938191>, <-0.168303, -0.259163, 0.951057> }
triangle { <-0.188509, -0.290278, 0.938191>, <-0.173059, -0.299746, 0.938191>, <-0.191342, -0.331414, 0.923880> }
triangle { <-0.191342, -0.331414, 0.923880>, <-0.208424, -0.320945, 0.923880>, <-0.188509, -0.290278, 0.938191> }
triangle { <-0.208424, -0.320945, 0.923880>, <-0.191342, -0.331414, 0.923880>, <-0.209330, -0.362570, 0.908143> }
triangle { <-0.209330, -0.362570, 0.908143>, <-0.228018, -0.351118, 0.908143>, <-0.208424, -0.320945, 0.923880> }
triangle { <-0.228018, -0.351118, 0.908143>, <-0.209330, -0.362570, 0.908143>, <-0.226995, -0.393167, 0.891007> }
triangle { <-0.226995, -0.393167, 0.891007>, <-0.247261, -0.380748, 0.891007>, <-0.228018, -0.351118, 0.908143> }
triangle { <-0.247261, -0.380748, 0.891007>, <-0.226995, -0.393167, 0.891007>, <-0.244311, -0.423158, 0.872496> }
triangle { <-0.244311, -0.423158, 0.872496>, <-0.266122, -0.409792, 0.872496>, <-0.247261, -0.380748, 0.891007> }
triangle { <-0.266122, -0.409792, 0.872496>, <-0.244311, -0.423158, 0.872496>, <-0.261249, -0.452497, 0.852640> }
triangle { <-0.261249, -0.452497, 0.852640>, <-0.284573, -0.438204, 0.852640>, <-0.266122, -0.409792, 0.872496> }
triangle { <-0.284573, -0.438204, 0.852640>, <-0.261249, -0.452497, 0.852640>, <-0.277785, -0.481138, 0.831470> }
triangle { <-0.277785, -0.481138, 0.831470>, <-0.302585, -0.465940, 0.831470>, <-0.284573, -0.438204, 0.852640> }
triangle { <-0.302585, -0.465940, 0.831470>, <-0.277785, -0.481138, 0.831470>, <-0.293893, -0.509037, 0.809017> }
triangle { <-0.293893, -0.509037, 0.809017>, <-0.320131, -0.492958, 0.809017>, <-0.302585, -0.465940, 0.831470> }
triangle { <-0.320131, -0.492958, 0.809017>, <-0.293893, -0.509037, 0.809017>, <-0.309547, -0.536151, 0.785317> }
triangle { <-0.309547, -0.536151, 0.785317>, <-0.337183, -0.519216, 0.785317>, <-0.320131, -0.492958, 0.809017> }
triangle { <-0.337183, -0.519216, 0.785317>, <-0.309547, -0.536151, 0.785317>, <-0.324724, -0.562439, 0.760406> }
triangle { <-0.324724, -0.562439, 0.760406>, <-0.353715, -0.544673, 0.760406>, <-0.337183, -0.519216, 0.785317> }
triangle { <-0.353715, -0.544673, 0.760406>, <-0.324724, -0.562439, 0.760406>, <-0.339400, -0.587859, 0.734323> }
triangle { <-0.339400, -0.587859, 0.734323>, <-0.369701, -0.569290, 0.734323>, <-0.353715, -0.544673, 0.760406> }
triangle { <-0.369701, -0.569290, 0.734323>, <-0.339400, -0.587859, 0.734323>, <-0.353553, -0.612372, 0.707107> }
triangle { <-0.353553, -0.612372, 0.707107>, <-0.385118, -0.593030, 0.707107>, <-0.369701, -0.569290, 0.734323> }
triangle { <-0.385118, -0.593030, 0.707107>, <-0.353553, -0.612372, 0.707107>, <-0.367161, -0.635942, 0.678801> }
triangle { <-0.367161, -0.635942, 0.678801>, <-0.399941, -0.615855, 0.678801>, <-0.385118, -0.593030, 0.707107> }
triangle { <-0.399941, -0.615855, 0.678801>, <-0.367161, -0.635942, 0.678801>, <-0.380203, -0.658531, 0.649448> }
triangle { <-0.380203, -0.658531, 0.649448>, <-0.414147, -0.637730, 0.649448>, <-0.399941, -0.615855, 0.678801> }
triangle { <-0.414147, -0.637730, 0.649448>, <-0.380203, -0.658531, 0.649448>, <-0.392658, -0.680104, 0.619094> }
triangle { <-0.392658, -0.680104, 0.619094>, <-0.427714, -0.658622, 0.619094>, <-0.414147, -0.637730, 0.649448> }
triangle { <-0.427714, -0.658622, 0.619094>, <-0.392658, -0.680104, 0.619094>, <-0.404508, -0.700629, 0.587785> }
triangle { <-0.404508, -0.700629, 0.587785>, <-0.440622, -0.678499, 0.587785>, <-0.427714, -0.658622, 0.619094> }
triangle { <-0.440622, -0.678499, 0.587785>, <-0.404508, -0.700629, 0.587785>, <-0.415735, -0.720074, 0.555570> }
triangle { <-0.415735, -0.720074, 0.555570>, <-0.452851, -0.697329, 0.555570>, <-0.440622, -0.678499, 0.587785> }
triangle { <-0.452851, -0.697329, 0.555570>, <-0.415735, -0.720074, 0.555570>, <-0.426320, -0.738408, 0.522499> }
triangle { <-0.426320, -0.738408, 0.522499>, <-0.464381, -0.715084, 0.522499>, <-0.452851, -0.697329, 0.555570> }
triangle { <-0.464381, -0.715084, 0.522499>, <-0.426320, -0.738408, 0.522499>, <-0.436248, -0.755604, 0.488621> }
triangle { <-0.436248, -0.755604, 0.488621>, <-0.475195, -0.731737, 0.488621>, <-0.464381, -0.715084, 0.522499> }
triangle { <-0.475195, -0.731737, 0.488621>, <-0.436248, -0.755604, 0.488621>, <-0.445503, -0.771634, 0.453990> }
triangle { <-0.445503, -0.771634, 0.453990>, <-0.485277, -0.747261, 0.453990>, <-0.475195, -0.731737, 0.488621> }
triangle { <-0.485277, -0.747261, 0.453990>, <-0.445503, -0.771634, 0.453990>, <-0.454072, -0.786475, 0.418660> }
triangle { <-0.454072, -0.786475, 0.418660>, <-0.494610, -0.761633, 0.418660>, <-0.485277, -0.747261, 0.453990> }
triangle { <-0.494610, -0.761633, 0.418660>, <-0.454072, -0.786475, 0.418660>, <-0.461940, -0.800103, 0.382683> }
triangle { <-0.461940, -0.800103, 0.382683>, <-0.503181, -0.774831, 0.382683>, <-0.494610, -0.761633, 0.418660> }
triangle { <-0.503181, -0.774831, 0.382683>, <-0.461940, -0.800103, 0.382683>, <-0.469096, -0.812498, 0.346117> }
triangle { <-0.469096, -0.812498, 0.346117>, <-0.510976, -0.786833, 0.346117>, <-0.503181, -0.774831, 0.382683> }
triangle { <-0.510976, -0.786833, 0.346117>, <-0.469096, -0.812498, 0.346117>, <-0.475528, -0.823639, 0.309017> }
triangle { <-0.475528, -0.823639, 0.309017>, <-0.517983, -0.797623, 0.309017>, <-0.510976, -0.786833, 0.346117> }
triangle { <-0.517983, -0.797623, 0.309017>, <-0.475528, -0.823639, 0.309017>, <-0.481228, -0.833511, 0.271440> }
triangle { <-0.481228, -0.833511, 0.271440>, <-0.524191, -0.807183, 0.271440>, <-0.517983, -0.797623, 0.309017> }
triangle { <-0.524191, -0.807183, 0.271440>, <-0.481228, -0.833511, 0.271440>, <-0.486185, -0.842097, 0.233445> }
triangle { <-0.486185, -0.842097, 0.233445>, <-0.529591, -0.815498, 0.233445>, <-0.524191, -0.807183, 0.271440> }
triangle { <-0.529591, -0.815498, 0.233445>, <-0.486185, -0.842097, 0.233445>, <-0.490393, -0.849385, 0.195090> }
triangle { <-0.490393, -0.849385, 0.195090>, <-0.534174, -0.822556, 0.195090>, <-0.529591, -0.815498, 0.233445> }
triangle { <-0.534174, -0.822556, 0.195090>, <-0.490393, -0.849385, 0.195090>, <-0.493844, -0.855363, 0.156434> }
triangle { <-0.493844, -0.855363, 0.156434>, <-0.537934, -0.828345, 0.156434>, <-0.534174, -0.822556, 0.195090> }
triangle { <-0.537934, -0.828345, 0.156434>, <-0.493844, -0.855363, 0.156434>, <-0.496534, -0.860023, 0.117537> }
triangle { <-0.496534, -0.860023, 0.117537>, <-0.540864, -0.832857, 0.117537>, <-0.537934, -0.828345, 0.156434> }
triangle { <-0.540864, -0.832857, 0.117537>, <-0.496534, -0.860023, 0.117537>, <-0.498459, -0.863356, 0.078459> }
triangle { <-0.498459, -0.863356, 0.078459>, <-0.542960, -0.836085, 0.078459>, <-0.540864, -0.832857, 0.117537> }
triangle { <-0.542960, -0.836085, 0.078459>, <-0.498459, -0.863356, 0.078459>, <-0.499615, -0.865358, 0.039260> }
triangle { <-0.499615, -0.865358, 0.039260>, <-0.544219, -0.838024, 0.039260>, <-0.542960, -0.836085, 0.078459> }
triangle { <-0.544219, -0.838024, 0.039260>, <-0.499615, -0.865358, 0.039260>, <-0.500000, -0.866025, -0.000000> }
triangle { <-0.500000, -0.866025, -0.000000>, <-0.544639, -0.838671, -0.000000>, <-0.544219, -0.838024, 0.039260> }
triangle { <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <-0.017824, -0.034981, 0.999229> }
triangle { <-0.017824, -0.034981, 0.999229>, <-0.019630, -0.034000, 0.999229>, <0.000000, 0.000000, 1.000000> }
triangle { <-0.019630, -0.034000, 0.999229>, <-0.017824, -0.034981, 0.999229>, <-0.035620, -0.069908, 0.996917> }
triangle { <-0.035620, -0.069908, 0.996917>, <-0.039230, -0.067948, 0.996917>, <-0.019630, -0.034000, 0.999229> }
triangle { <-0.039230, -0.067948, 0.996917>, <-0.035620, -0.069908, 0.996917>, <-0.053361, -0.104727, 0.993068> }
triangle { <-0.053361, -0.104727, 0.993068>, <-0.058769, -0.101790, 0.993068>, <-0.039230, -0.067948, 0.996917> }
triangle { <-0.058769, -0.101790, 0.993068>, <-0.053361, -0.104727, 0.993068>, <-0.071020, -0.139384, 0.987688> }
triangle { <-0.071020, -0.139384, 0.987688>, <-0.078217, -0.135476, 0.987688>, <-0.058769, -0.101790, 0.993068> }
triangle { <-0.078217, -0.135476, 0.987688>, <-0.071020, -0.139384, 0.987688>, <-0.088569, -0.173827, 0.980785> }
triangle { <-0.088569, -0.173827, 0.980785>, <-0.097545, -0.168953, 0.980785>, <-0.078217, -0.135476, 0.987688> }
triangle { <-0.097545, -0.168953, 0.980785>, <-0.088569, -0.173827, 0.980785>, <-0.105982, -0.208001, 0.972370> }
triangle { <-0.105982, -0.208001, 0.972370>, <-0.116723, -0.202170, 0.972370>, <-0.097545, -0.168953, 0.980785> }
triangle { <-0.116723, -0.202170, 0.972370>, <-0.105982, -0.208001, 0.972370>, <-0.123231, -0.241855, 0.962455> }
triangle { <-0.123231, -0.241855, 0.962455>, <-0.135720, -0.235074, 0.962455>, <-0.116723, -0.202170, 0.972370> }
triangle { <-0.135720, -0.235074, 0.962455>, <-0.123231, -0.241855, 0.962455>, <-0.140291, -0.275336, 0.951057> }
triangle { <-0.140291, -0.275336, 0.951057>, <-0.154508, -0.267617, 0.951057>, <-0.135720, -0.235074, 0.962455> }
triangle { <-0.154508, -0.267617, 0.951057>, <-0.140291, -0.275336, 0.951057>, <-0.157134, -0.308393, 0.938191> }
triangle { <-0.157134, -0.308393, 0.938191>, <-0.173059, -0.299746, 0.938191>, <-0.154508, -0.267617, 0.951057> }
triangle { <-0.173059, -0.299746, 0.938191>, <-0.157134, -0.308393, 0.938191>, <-0.173735, -0.340973, 0.923880> }
triangle { <-0.173735, -0.340973, 0.923880>, <-0.191342, -0.331414, 0.923880>, <-0.173059, -0.299746, 0.938191> }
triangle { <-0.191342, -0.331414, 0.923880>, <-0.173735, -0.340973, 0.923880>, <-0.190068, -0.373029, 0.908143> }
triangle { <-0.190068, -0.373029, 0.908143>, <-0.209330, -0.362570, 0.908143>, <-0.191342, -0.331414, 0.923880> }
triangle { <-0.209330, -0.362570, 0.908143>, <-0.190068, -0.373029, 0.908143>, <-0.206107, -0.404508, 0.891007> }
triangle { <-0.206107, -0.404508, 0.891007>, <-0.226995, -0.393167, 0.891007>, <-0.209330, -0.362570, 0.908143> }
triangle { <-0.226995, -0.393167, 0.891007>, <-0.206107, -0.404508, 0.891007>, <-0.221829, -0.435365, 0.872496> }
triangle { <-0.221829, -0.435365, 0.872496>, <-0.244311, -0.423158, 0.872496>, <-0.226995, -0.393167, 0.891007> }
triangle { <-0.244311, -0.423158, 0.872496>, <-0.221829, -0.435365, 0.872496>, <-0.237209, -0.465550, 0.852640> }
triangle { <-0.237209, -0.465550, 0.852640>, <-0.261249, -0.452497, 0.852640>, <-0.244311, -0.423158, 0.872496> }
triangle { <-0.261249, -0.452497, 0.852640>, <-0.237209, -0.465550, 0.852640>, <-0.252224, -0.495017, 0.831470> }
triangle { <-0.252224, -0.495017, 0.831470>, <-0.277785, -0.481138, 0.831470>, <-0.261249, -0.452497, 0.852640> }
triangle { <-0.277785, -0.481138, 0.831470>, <-0.252224, -0.495017, 0.831470>, <-0.266849, -0.523720, 0.809017> }
triangle { <-0.266849, -0.523720, 0.809017>, <-0.293893, -0.509037, 0.809017>, <-0.277785, -0.481138, 0.831470> }
triangle { <-0.293893, -0.509037, 0.809017>, <-0.266849, -0.523720, 0.809017>, <-0.281063, -0.551617, 0.785317> }
triangle { <-0.281063, -0.551617, 0.785317>, <-0.309547, -0.536151, 0.785317>, <-0.293893, -0.509037, 0.809017> }
triangle { <-0.309547, -0.536151, 0.785317>, <-0.281063, -0.551617, 0.785317>, <-0.294843, -0.578662, 0.760406> }
triangle { <-0.294843, -0.578662, 0.760406>, <-0.324724, -0.562439, 0.760406>, <-0.309547, -0.536151, 0.785317> }
triangle { <-0.324724, -0.562439, 0.760406>, <-0.294843, -0.578662, 0.760406>, <-0.308169, -0.604816, 0.734323> }
triangle { <-0.308169, -0.604816, 0.734323>, <-0.339400, -0.587859, 0.734323>, <-0.324724, -0.562439, 0.760406> }
triangle { <-0.339400, -0.587859, 0.734323>, <-0.308169, -0.604816, 0.734323>, <-0.321020, -0.630037, 0.707107> }
triangle { <-0.321020, -0.630037, 0.707107>, <-0.353553, -0.612372, 0.707107>, <-0.339400, -0.587859, 0.734323> }
triangle { <-0.353553, -0.612372, 0.707107>, <-0.321020, -0.630037, 0.707107>, <-0.333375, -0.654286, 0.678801> }
triangle { <-0.333375, -0.654286, 0.678801>, <-0.367161, -0.635942, 0.678801>, <-0.353553, -0.612372, 0.707107> }
triangle { <-0.367161, -0.635942, 0.678801>, <-0.333375, -0.654286, 0.678801>, <-0.345217, -0.677527, 0.649448> }
triangle { <-0.345217, -0.677527, 0.649448>, <-0.380203, -0.658531, 0.649448>, <-0.367161, -0.635942, 0.678801> }
triangle { <-0.380203, -0.658531, 0.649448>, <-0.345217, -0.677527, 0.649448>, <-0.356526, -0.699723, 0.619094> }
triangle { <-0.356526, -0.699723, 0.619094>, <-0.392658, -0.680104, 0.619094>, <-0.380203, -0.658531, 0.649448> }
triangle { <-0.392658, -0.680104, 0.619094>, <-0.356526, -0.699723, 0.619094>, <-0.367286, -0.720839, 0.587785> }
triangle { <-0.367286, -0.720839, 0.587785>, <-0.404508, -0.700629, 0.587785>, <-0.392658, -0.680104, 0.619094> }
triangle { <-0.404508, -0.700629, 0.587785>, <-0.367286, -0.720839, 0.587785>, <-0.377479, -0.740845, 0.555570> }
triangle { <-0.377479, -0.740845, 0.555570>, <-0.415735, -0.720074, 0.555570>, <-0.404508, -0.700629, 0.587785> }
triangle { <-0.415735, -0.720074, 0.555570>, <-0.377479, -0.740845, 0.555570>, <-0.387091, -0.759708, 0.522499> }
triangle { <-0.387091, -0.759708, 0.522499>, <-0.426320, -0.738408, 0.522499>, <-0.415735, -0.720074, 0.555570> }
triangle { <-0.426320, -0.738408, 0.522499>, <-0.387091, -0.759708, 0.522499>, <-0.396105, -0.777400, 0.488621> }
triangle { <-0.396105, -0.777400, 0.488621>, <-0.436248, -0.755604, 0.488621>, <-0.426320, -0.738408, 0.522499> }
triangle { <-0.436248, -0.755604, 0.488621>, <-0.396105, -0.777400, 0.488621>, <-0.404508, -0.793893, 0.453990> }
triangle { <-0.404508, -0.793893, 0.453990>, <-0.445503, -0.771634, 0.453990>, <-0.436248, -0.755604, 0.488621> }
triangle { <-0.445503, -0.771634, 0.453990>, <-0.404508, -0.793893, 0.453990>, <-0.412288, -0.809161, 0.418660> }
triangle { <-0.412288, -0.809161, 0.418660>, <-0.454072, -0.786475, 0.418660>, <-0.445503, -0.771634, 0.453990> }
triangle { <-0.454072, -0.786475, 0.418660>, <-0.412288, -0.809161, 0.418660>, <-0.419433, -0.823183, 0.382683> }
triangle { <-0.419433, -0.823183, 0.382683>, <-0.461940, -0.800103, 0.382683>, <-0.454072, -0.786475, 0.418660> }
triangle { <-0.461940, -0.800103, 0.382683>, <-0.419433, -0.823183, 0.382683>, <-0.425930, -0.835935, 0.346117> }
triangle { <-0.425930, -0.835935, 0.346117>, <-0.469096, -0.812498, 0.346117>, <-0.461940, -0.800103, 0.382683> }
triangle { <-0.469096, -0.812498, 0.346117>, <-0.425930, -0.835935, 0.346117>, <-0.431771, -0.847398, 0.309017> }
triangle { <-0.431771, -0.847398, 0.309017>, <-0.475528, -0.823639, 0.309017>, <-0.469096, -0.812498, 0.346117> }
triangle { <-0.475528, -0.823639, 0.309017>, <-0.431771, -0.847398, 0.309017>, <-0.436946, -0.857554, 0.271440> }
triangle { <-0.436946, -0.857554, 0.271440>, <-0.481228, -0.833511, 0.271440>, <-0.475528, -0.823639, 0.309017> }
triangle { <-0.481228, -0.833511, 0.271440>, <-0.436946, -0.857554, 0.271440>, <-0.441447, -0.866388, 0.233445> }
triangle { <-0.441447, -0.866388, 0.233445>, <-0.486185, -0.842097, 0.233445>, <-0.481228, -0.833511, 0.271440> }
triangle { <-0.486185, -0.842097, 0.233445>, <-0.441447, -0.866388, 0.233445>, <-0.445267, -0.873886, 0.195090> }
triangle { <-0.445267, -0.873886, 0.195090>, <-0.490393, -0.849385, 0.195090>, <-0.486185, -0.842097, 0.233445> }
triangle { <-0.490393, -0.849385, 0.195090>, <-0.445267, -0.873886, 0.195090>, <-0.448401, -0.880037, 0.156434> }
triangle { <-0.448401, -0.880037, 0.156434>, <-0.493844, -0.855363, 0.156434>, <-0.490393, -0.849385, 0.195090> }
triangle { <-0.493844, -0.855363, 0.156434>, <-0.448401, -0.880037, 0.156434>, <-0.450844, -0.884830, 0.117537> }
triangle { <-0.450844, -0.884830, 0.117537>, <-0.496534, -0.860023, 0.117537>, <-0.493844, -0.855363, 0.156434> }
triangle { <-0.496534, -0.860023, 0.117537>, <-0.450844, -0.884830, 0.117537>, <-0.452591, -0.888260, 0.078459> }
triangle { <-0.452591, -0.888260, 0.078459>, <-0.498459, -0.863356, 0.078459>, <-0.496534, -0.860023, 0.117537> }
triangle { <-0.498459, -0.863356, 0.078459>, <-0.452591, -0.888260, 0.078459>, <-0.453640, -0.890320, 0.039260> }
triangle { <-0.453640, -0.890320, 0.039260>, <-0.499615, -0.865358, 0.039260>, <-0.498459, -0.863356, 0.078459> }
triangle { <-0.499615, -0.865358, 0.039260>, <-0.453640, -0.890320, 0.039260>, <-0.453990, -0.891007, -0.000000> }
triangle { <-0.453990, -0.891007, -0.000000>, <-0.500000, -0.866025, -0.000000>, <-0.499615, -0.865358, 0.039260> }
triangle { <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <-0.015968, -0.035866, 0.999229> }
triangle { <-0.015968, -0.035866, 0.999229>, <-0.017824, -0.034981, 0.999229>, <0.000000, 0.000000, 1.000000> }
triangle { <-0.017824, -0.034981, 0.999229>, <-0.015968, -0.035866, 0.999229>, <-0.031912, -0.071676, 0.996917> }
triangle { <-0.031912, -0.071676, 0.996917>, <-0.035620, -0.069908, 0.996917>, <-0.017824, -0.034981, 0.999229> }
triangle { <-0.035620, -0.069908, 0.996917>, <-0.031912, -0.071676, 0.996917>, <-0.047807, -0.107376, 0.993068> }
triangle { <-0.047807, -0.107376, 0.993068>, <-0.053361, -0.104727, 0.993068>, <-0.035620, -0.069908, 0.996917> }
triangle { <-0.053361, -0.104727, 0.993068>, <-0.047807, -0.107376, 0.993068>, <-0.063628, -0.142910, 0.987688> }
triangle { <-0.063628, -0.142910, 0.987688>, <-0.071020, -0.139384, 0.987688>, <-0.053361, -0.104727, 0.993068> }
triangle { <-0.071020, -0.139384, 0.987688>, <-0.063628, -0.142910, 0.987688>, <-0.079350, -0.178224, 0.980785> }
triangle { <-0.079350, -0.178224, 0.980785>, <-0.088569, -0.173827, 0.980785>, <-0.071020, -0.139384, 0.987688> }
triangle { <-0.088569, -0.173827, 0.980785>, <-0.079350, -0.178224, 0.980785>, <-0.094951, -0.213263, 0.972370> }
triangle { <-0.094951, -0.213263, 0.972370>, <-0.105982, -0.208001, 0.972370>, <-0.088569, -0.173827, 0.980785> }
triangle { <-0.105982, -0.208001, 0.972370>, <-0.094951, -0.213263, 0.972370>, <-0.110405, -0.247973, 0.962455> }
triangle { <-0.110405, -0.247973, 0.962455>, <-0.123231, -0.241855, 0.962455>, <-0.105982, -0.208001, 0.972370> }
triangle { <-0.123231, -0.241855, 0.962455>, <-0.110405, -0.247973, 0.962455>, <-0.125689, -0.282301, 0.951057> }
triangle { <-0.125689, -0.282301, 0.951057>, <-0.140291, -0.275336, 0.951057>, <-0.123231, -0.241855, 0.962455> }
triangle { <-0.140291, -0.275336, 0.951057>, <-0.125689, -0.282301, 0.951057>, <-0.140778, -0.316194, 0.938191> }
triangle { <-0.140778, -0.316194, 0.938191>, <-0.157134, -0.308393, 0.938191>, <-0.140291, -0.275336, 0.951057> }
triangle { <-0.157134, -0.308393, 0.938191>, <-0.140778, -0.316194, 0.938191>, <-0.155651, -0.349599, 0.923880> }
triangle { <-0.155651, -0.349599, 0.923880>, <-0.173735, -0.340973, 0.923880>, <-0.157134, -0.308393, 0.938191> }
triangle { <-0.173735, -0.340973, 0.923880>, <-0.155651, -0.349599, 0.923880>, <-0.170284, -0.382465, 0.908143> }
triangle { <-0.170284, -0.382465, 0.908143>, <-0.190068, -0.373029, 0.908143>, <-0.173735, -0.340973, 0.923880> }
triangle { <-0.190068, -0.373029, 0.908143>, <-0.170284, -0.382465, 0.908143>, <-0.184655, -0.414741, 0.891007> }
triangle { <-0.184655, -0.414741, 0.891007>, <-0.206107, -0.404508, 0.891007>, <-0.190068, -0.373029, 0.908143> }
triangle { <-0.206107, -0.404508, 0.891007>, <-0.184655, -0.414741, 0.891007>, <-0.198740, -0.446378, 0.872496> }
triangle { <-0.198740, -0.446378, 0.872496>, <-0.221829, -0.435365, 0.872496>, <-0.206107, -0.404508, 0.891007> }
triangle { <-0.221829, -0.435365, 0.872496>, <-0.198740, -0.446378, 0.872496>, <-0.212519, -0.477326, 0.852640> }
triangle { <-0.212519, -0.477326, 0.852640>, <-0.237209, -0.465550, 0.852640>, <-0.221829, -0.435365, 0.872496> }
triangle { <-0.237209, -0.465550, 0.852640>, <-0.212519, -0.477326, 0.852640>, <-0.225971, -0.507539, 0.831470> }
triangle { <-0.225971, -0.507539, 0.831470>, <-0.252224, -0.495017, 0.831470>, <-0.237209, -0.465550, 0.852640> }
triangle { <-0.252224, -0.495017, 0.831470>, <-0.225971, -0.507539, 0.831470>, <-0.239074, -0.536969, 0.809017> }
triangle { <-0.239074, -0.536969, 0.809017>, <-0.266849, -0.523720, 0.809017>, <-0.252224, -0.495017, 0.831470> }
triangle { <-0.266849, -0.523720, 0.809017>, <-0.239074, -0.536969, 0.809017>, <-0.251808, -0.565570, 0.785317> }
triangle { <-0.251808, -0.565570, 0.785317>, <-0.281063, -0.551617, 0.785317>, <-0.266849, -0.523720, 0.809017> }
triangle { <-0.281063, -0.551617, 0.785317>, <-0.251808, -0.565570, 0.785317>, <-0.264154, -0.593300, 0.760406> }
triangle { <-0.264154, -0.593300, 0.760406>, <-0.294843, -0.578662, 0.760406>, <-0.281063, -0.551617, 0.785317> }
triangle { <-0.294843, -0.578662, 0.760406>, <-0.264154, -0.593300, 0.760406>, <-0.276093, -0.620115, 0.734323> }
triangle { <-0.276093, -0.620115, 0.734323>, <-0.308169, -0.604816, 0.734323>, <-0.294843, -0.578662, 0.760406> }
triangle { <-0.308169, -0.604816, 0.734323>, <-0.276093, -0.620115, 0.734323>, <-0.287606, -0.645974, 0.707107> }
triangle { <-0.287606, -0.645974, 0.707107>, <-0.321020, -0.630037, 0.707107>, <-0.308169, -0.604816, 0.734323> }
triangle { <-0.321020, -0.630037, 0.707107>, <-0.287606, -0.645974, 0.707107>, <-0.298676, -0.670837, 0.678801> }
triangle { <-0.298676, -0.670837, 0.678801>, <-0.333375, -0.654286, 0.678801>, <-0.321020, -0.630037, 0.707107> }
triangle { <-0.333375, -0.654286, 0.678801>, <-0.298676, -0.670837, 0.678801>, <-0.309285, -0.694665, 0.649448> }
triangle { <-0.309285, -0.694665, 0.649448>, <-0.345217, -0.677527, 0.649448>, <-0.333375, -0.654286, 0.678801> }
triangle { <-0.345217, -0.677527, 0.649448>, <-0.309285, -0.694665, 0.649448>, <-0.319417, -0.717423, 0.619094> }
triangle { <-0.319417, -0.717423, 0.619094>, <-0.356526, -0.699723, 0.619094>, <-0.345217, -0.677527, 0.649448> }
triangle { <-0.356526, -0.699723, 0.619094>, <-0.319417, -0.717423, 0.619094>, <-0.329057, -0.739074, 0.587785> }
triangle { <-0.329057, -0.739074, 0.587785>, <-0.367286, -0.720839, 0.587785>, <-0.356526, -0.699723, 0.619094> }
triangle { <-0.367286, -0.720839, 0.587785>, <-0.329057, -0.739074, 0.587785>, <-0.338189, -0.759585, 0.555570> }
triangle { <-0.338189, -0.759585, 0.555570>, <-0.377479, -0.740845, 0.555570>, <-0.367286, -0.720839, 0.587785> }
triangle { <-0.377479, -0.740845, 0.555570>, <-0.338189, -0.759585, 0.555570>, <-0.346800, -0.778926, 0.522499> }
triangle { <-0.346800, -0.778926, 0.522499>, <-0.387091, -0.759708, 0.522499>, <-0.377479, -0.740845, 0.555570> }
triangle { <-0.387091, -0.759708, 0.522499>, <-0.346800, -0.778926, 0.522499>, <-0.354876, -0.797065, 0.488621> }
triangle { <-0.354876, -0.797065, 0.488621>, <-0.396105, -0.777400, 0.488621>, <-0.387091, -0.759708, 0.522499> }
triangle { <-0.396105, -0.777400, 0.488621>, <-0.354876, -0.797065, 0.488621>, <-0.362405, -0.813975, 0.453990> }
triangle { <-0.362405, -0.813975, 0.453990>, <-0.404508, -0.793893, 0.453990>, <-0.396105, -0.777400, 0.488621> }
triangle { <-0.404508, -0.793893, 0.453990>, <-0.362405, -0.813975, 0.453990>, <-0.369375, -0.829630, 0.418660> }
triangle { <-0.369375, -0.829630, 0.418660>, <-0.412288, -0.809161, 0.418660>, <-0.404508, -0.793893, 0.453990> }
triangle { <-0.412288, -0.809161, 0.418660>, <-0.369375, -0.829630, 0.418660>, <-0.375776, -0.844006, 0.382683> }
triangle { <-0.375776, -0.844006, 0.382683>, <-0.419433, -0.823183, 0.382683>, <-0.412288, -0.809161, 0.418660> }
triangle { <-0.419433, -0.823183, 0.382683>, <-0.375776, -0.844006, 0.382683>, <-0.381597, -0.857080, 0.346117> }
triangle { <-0.381597, -0.857080, 0.346117>, <-0.425930, -0.835935, 0.346117>, <-0.419433, -0.823183, 0.382683> }
triangle { <-0.425930, -0.835935, 0.346117>, <-0.381597, -0.857080, 0.346117>, <-0.386830, -0.868833, 0.309017> }
triangle { <-0.386830, -0.868833, 0.309017>, <-0.431771, -0.847398, 0.309017>, <-0.425930, -0.835935, 0.346117> }
triangle { <-0.431771, -0.847398, 0.309017>, <-0.386830, -0.868833, 0.309017>, <-0.391466, -0.879247, 0.271440> }
triangle { <-0.391466, -0.879247, 0.271440>, <-0.436946, -0.857554, 0.271440>, <-0.431771, -0.847398, 0.309017> }
triangle { <-0.436946, -0.857554, 0.271440>, <-0.391466, -0.879247, 0.271440>, <-0.395498, -0.888304, 0.233445> }
triangle { <-0.395498, -0.888304, 0.233445>, <-0.441447, -0.866388, 0.233445>, <-0.436946, -0.857554, 0.271440> }
triangle { <-0.441447, -0.866388, 0.233445>, <-0.395498, -0.888304, 0.233445>, <-0.398921, -0.895992, 0.195090> }
triangle { <-0.398921, -0.895992, 0.195090>, <-0.445267, -0.873886, 0.195090>, <-0.441447, -0.866388, 0.233445> }
triangle { <-0.445267, -0.873886, 0.195090>, <-0.398921, -0.895992, 0.195090>, <-0.401729, -0.902298, 0.156434> }
triangle { <-0.401729, -0.902298, 0.156434>, <-0.448401, -0.880037, 0.156434>, <-0.445267, -0.873886, 0.195090> }
triangle { <-0.448401, -0.880037, 0.156434>, <-0.401729, -0.902298, 0.156434>, <-0.403917, -0.907213, 0.117537> }
triangle { <-0.403917, -0.907213, 0.117537>, <-0.450844, -0.884830, 0.117537>, <-0.448401, -0.880037, 0.156434> }
triangle { <-0.450844, -0.884830, 0.117537>, <-0.403917, -0.907213, 0.117537>, <-0.405483, -0.910729, 0.078459> }
triangle { <-0.405483, -0.910729, 0.078459>, <-0.452591, -0.888260, 0.078459>, <-0.450844, -0.884830, 0.117537> }
triangle { <-0.452591, -0.888260, 0.078459>, <-0.405483, -0.910729, 0.078459>, <-0.406423, -0.912841, 0.039260> }
triangle { <-0.406423, -0.912841, 0.039260>, <-0.453640, -0.890320, 0.039260>, <-0.452591, -0.888260, 0.078459> }
triangle { <-0.453640, -0.890320, 0.039260>, <-0.406423, -0.912841, 0.039260>, <-0.406737, -0.913545, -0.000000> }
triangle { <-0.406737, -0.913545, -0.000000>, <-0.453990, -0.891007, -0.000000>, <-0.453640, -0.890320, 0.039260> }
triangle { <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <-0.014069, -0.036652, 0.999229> }
triangle { <-0.014069, -0.036652, 0.999229>, <-0.015968, -0.035866, 0.999229>, <0.000000, 0.000000, 1.000000> }
triangle { <-0.015968, -0.035866, 0.999229>, <-0.014069, -0.036652, 0.999229>, <-0.028117, -0.073248, 0.996917> }
triangle { <-0.028117, -0.073248, 0.996917>, <-0.031912, -0.071676, 0.996917>, <-0.015968, -0.035866, 0.999229> }
triangle { <-0.031912, -0.071676, 0.996917>, <-0.028117, -0.073248, 0.996917>, <-0.042122, -0.109731, 0.993068> }
triangle { <-0.042122, -0.109731, 0.993068>, <-0.047807, -0.107376, 0.993068>, <-0.031912, -0.071676, 0.996917> }
triangle { <-0.047807, -0.107376, 0.993068>, <-0.042122, -0.109731, 0.993068>, <-0.056061, -0.146044, 0.987688> }
triangle { <-0.056061, -0.146044, 0.987688>, <-0.063628, -0.142910, 0.987688>, <-0.047807, -0.107376, 0.993068> }
triangle { <-0.063628, -0.142910, 0.987688>, <-0.056061, -0.146044, 0.987688>, <-0.069914, -0.182133, 0.980785> }
triangle { <-0.069914, -0.182133, 0.980785>, <-0.079350, -0.178224, 0.980785>, <-0.063628, -0.142910, 0.987688> }
triangle { <-0.079350, -0.178224, 0.980785>, <-0.069914, -0.182133, 0.980785>, <-0.083659, -0.217940, 0.972370> }
triangle { <-0.083659, -0.217940, 0.972370>, <-0.094951, -0.213263, 0.972370>, <-0.079350, -0.178224, 0.980785> }
triangle { <-0.094951, -0.213263, 0.972370>, <-0.083659, -0.217940, 0.972370>, <-0.097276, -0.253411, 0.962455> }
triangle { <-0.097276, -0.253411, 0.962455>, <-0.110405, -0.247973, 0.962455>, <-0.094951, -0.213263, 0.972370> }
triangle { <-0.110405, -0.247973, 0.962455>, <-0.097276, -0.253411, 0.962455>, <-0.110742, -0.288492, 0.951057> }
triangle { <-0.110742, -0.288492, 0.951057>, <-0.125689, -0.282301, 0.951057>, <-0.110405, -0.247973, 0.962455> }
triangle { <-0.125689, -0.282301, 0.951057>, <-0.110742, -0.288492, 0.951057>, <-0.124037, -0.323128, 0.938191> }
triangle { <-0.124037, -0.323128, 0.938191>, <-0.140778, -0.316194, 0.938191>, <-0.125689, -0.282301, 0.951057> }
triangle { <-0.140778, -0.316194, 0.938191>, <-0.124037, -0.323128, 0.938191>, <-0.137141, -0.357266, 0.923880> }
triangle { <-0.137141, -0.357266, 0.923880>, <-0.155651, -0.349599, 0.923880>, <-0.140778, -0.316194, 0.938191> }
triangle { <-0.155651, -0.349599, 0.923880>, <-0.137141, -0.357266, 0.923880>, <-0.150034, -0.390853, 0.908143> }
triangle { <-0.150034, -0.390853, 0.908143>, <-0.170284, -0.382465, 0.908143>, <-0.155651, -0.349599, 0.923880> }
triangle { <-0.170284, -0.382465, 0.908143>, <-0.150034, -0.390853, 0.908143>, <-0.162696, -0.423837, 0.891007> }
triangle { <-0.162696, -0.423837, 0.891007>, <-0.184655, -0.414741, 0.891007>, <-0.170284, -0.382465, 0.908143> }
triangle { <-0.184655, -0.414741, 0.891007>, <-0.162696, -0.423837, 0.891007>, <-0.175106, -0.456167, 0.872496> }
triangle { <-0.175106, -0.456167, 0.872496>, <-0.198740, -0.446378, 0.872496>, <-0.184655, -0.414741, 0.891007> }
triangle { <-0.198740, -0.446378, 0.872496>, <-0.175106, -0.456167, 0.872496>, <-0.187247, -0.487794, 0.852640> }
triangle { <-0.187247, -0.487794, 0.852640>, <-0.212519, -0.477326, 0.852640>, <-0.198740, -0.446378, 0.872496> }
triangle { <-0.212519, -0.477326, 0.852640>, <-0.187247, -0.487794, 0.852640>, <-0.199099, -0.518669, 0.831470> }
triangle { <-0.199099, -0.518669, 0.831470>, <-0.225971, -0.507539, 0.831470>, <-0.212519, -0.477326, 0.852640> }
triangle { <-0.225971, -0.507539, 0.831470>, <-0.199099, -0.518669, 0.831470>, <-0.210643, -0.548745, 0.809017> }
triangle { <-0.210643, -0.548745, 0.809017>, <-0.239074, -0.536969, 0.809017>, <-0.225971, -0.507539, 0.831470> }
triangle { <-0.239074, -0.536969, 0.809017>, <-0.210643, -0.548745, 0.809017>, <-0.221863, -0.577974, 0.785317> }
triangle { <-0.221863, -0.577974, 0.785317>, <-0.251808, -0.565570, 0.785317>, <-0.239074, -0.536969, 0.809017> }
triangle { <-0.251808, -0.565570, 0.785317>, <-0.221863, -0.577974, 0.785317>, <-0.232741, -0.606312, 0.760406> }
triangle { <-0.232741, -0.606312, 0.760406>, <-0.264154, -0.593300, 0.760406>, <-0.251808, -0.565570, 0.785317> }
triangle { <-0.264154, -0.593300, 0.760406>, <-0.232741, -0.606312, 0.760406>, <-0.243260, -0.633715, 0.734323> }
triangle { <-0.243260, -0.633715, 0.734323>, <-0.276093, -0.620115, 0.734323>, <-0.264154, -0.593300, 0.760406> }
triangle { <-0.276093, -0.620115, 0.734323>, <-0.243260, -0.633715, 0.734323>, <-0.253404, -0.660141, 0.707107> }
triangle { <-0.253404, -0.660141, 0.707107>, <-0.287606, -0.645974, 0.707107>, <-0.276093, -0.620115, 0.734323> }
triangle { <-0.287606, -0.645974, 0.707107>, <-0.253404, -0.660141, 0.707107>, <-0.263158, -0.685549, 0.678801> }
triangle { <-0.263158, -0.685549, 0.678801>, <-0.298676, -0.670837, 0.678801>, <-0.287606, -0.645974, 0.707107> }
triangle { <-0.298676, -0.670837, 0.678801>, <-0.263158, -0.685549, 0.678801>, <-0.272505, -0.709900, 0.649448> }
triangle { <-0.272505, -0.709900, 0.649448>, <-0.309285, -0.694665, 0.649448>, <-0.298676, -0.670837, 0.678801> }
triangle { <-0.309285, -0.694665, 0.649448>, <-0.272505, -0.709900, 0.649448>, <-0.281432, -0.733157, 0.619094> }
triangle { <-0.281432, -0.733157, 0.619094>, <-0.319417, -0.717423, 0.619094>, <-0.309285, -0.694665, 0.649448> }
triangle { <-0.319417, -0.717423, 0.619094>, <-0.281432, -0.733157, 0.619094>, <-0.289926, -0.755282, 0.587785> }
triangle { <-0.289926, -0.755282, 0.587785>, <-0.329057, -0.739074, 0.587785>, <-0.319417, -0.717423, 0.619094> }
triangle { <-0.329057, -0.739074, 0.587785>, <-0.289926, -0.755282, 0.587785>, <-0.297972, -0.776244, 0.555570> }
triangle { <-0.297972, -0.776244, 0.555570>, <-0.338189, -0.759585, 0.555570>, <-0.329057, -0.739074, 0.587785> }
triangle { <-0.338189, -0.759585, 0.555570>, <-0.297972, -0.776244, 0.555570>, <-0.305559, -0.796008, 0.522499> }
triangle { <-0.305559, -0.796008, 0.522499>, <-0.346800, -0.778926, 0.522499>, <-0.338189, -0.759585, 0.555570> }
triangle { <-0.346800, -0.778926, 0.522499>, <-0.305559, -0.796008, 0.522499>, <-0.312675, -0.814545, 0.488621> }
triangle { <-0.312675, -0.814545, 0.488621>, <-0.354876, -0.797065, 0.488621>, <-0.346800, -0.778926, 0.522499> }
triangle { <-0.354876, -0.797065, 0.488621>, <-0.312675, -0.814545, 0.488621>, <-0.319308, -0.831826, 0.453990> }
triangle { <-0.319308, -0.831826, 0.453990>, <-0.362405, -0.813975, 0.453990>, <-0.354876, -0.797065, 0.488621> }
triangle { <-0.362405, -0.813975, 0.453990>, <-0.319308, -0.831826, 0.453990>, <-0.325449, -0.847825, 0.418660> }
triangle { <-0.325449, -0.847825, 0.418660>, <-0.369375, -0.829630, 0.418660>, <-0.362405, -0.813975, 0.453990> }
triangle { <-0.369375, -0.829630, 0.418660>, <-0.325449, -0.847825, 0.418660>, <-0.331089, -0.862516, 0.382683> }
triangle { <-0.331089, -0.862516, 0.382683>, <-0.375776, -0.844006, 0.382683>, <-0.369375, -0.829630, 0.418660> }
triangle { <-0.375776, -0.844006, 0.382683>, <-0.331089, -0.862516, 0.382683>, <-0.336218, -0.875877, 0.346117> }
triangle { <-0.336218, -0.875877, 0.346117>, <-0.381597, -0.857080, 0.346117>, <-0.375776, -0.844006, 0.382683> }
triangle { <-0.381597, -0.857080, 0.346117>, <-0.336218, -0.875877, 0.346117>, <-0.340828, -0.887888, 0.309017> }
triangle { <-0.340828, -0.887888, 0.309017>, <-0.386830, -0.868833, 0.309017>, <-0.381597, -0.857080, 0.346117> }
triangle { <-0.386830, -0.868833, 0.309017>, <-0.340828, -0.887888, 0.309017>, <-0.344913, -0.898529, 0.271440> }
triangle { <-0.344913, -0.898529, 0.271440>, <-0.391466, -0.879247, 0.271440>, <-0.386830, -0.868833, 0.309017> }
triangle { <-0.391466, -0.879247, 0.271440>, <-0.344913, -0.898529, 0.271440>, <-0.348466, -0.907786, 0.233445> }
triangle { <-0.348466, -0.907786, 0.233445>, <-0.395498, -0.888304, 0.233445>, <-0.391466, -0.879247, 0.271440> }
triangle { <-0.395498, -0.888304, 0.233445>, <-0.348466, -0.907786, 0.233445>, <-0.351482, -0.915642, 0.195090> }
triangle { <-0.351482, -0.915642, 0.195090>, <-0.398921, -0.895992, 0.195090>, <-0.395498, -0.888304, 0.233445> }
triangle { <-0.398921, -0.895992, 0.195090>, <-0.351482, -0.915642, 0.195090>, <-0.353956, -0.922087, 0.156434> }
triangle { <-0.353956, -0.922087, 0.156434>, <-0.401729, -0.902298, 0.156434>, <-0.398921, -0.895992, 0.195090> }
triangle { <-0.401729, -0.902298, 0.156434>, <-0.353956, -0.922087, 0.156434>, <-0.355884, -0.927109, 0.117537> }
triangle { <-0.355884, -0.927109, 0.117537>, <-0.403917, -0.907213, 0.117537>, <-0.401729, -0.902298, 0.156434> }
triangle { <-0.403917, -0.907213, 0.117537>, <-0.355884, -0.927109, 0.117537>, <-0.357263, -0.930703, 0.078459> }
triangle { <-0.357263, -0.930703, 0.078459>, <-0.405483, -0.910729, 0.078459>, <-0.403917, -0.907213, 0.117537> }
triangle { <-0.405483, -0.910729, 0.078459>, <-0.357263, -0.930703, 0.078459>, <-0.358092, -0.932861, 0.039260> }
triangle { <-0.358092, -0.932861, 0.039260>, <-0.406423, -0.912841, 0.039260>, <-0.405483, -0.910729, 0.078459> }
triangle { <-0.406423, -0.912841, 0.039260>, <-0.358092, -0.932861, 0.039260>, <-0.358368, -0.933580, -0.000000> }
triangle { <-0.358368, -0.933580, -0.000000>, <-0.406737, -0.913545, -0.000000>, <-0.406423, -0.912841, 0.039260> }
triangle { <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <-0.012132, -0.037338, 0.999229> }
triangle { <-0.012132, -0.037338, 0.999229>, <-0.014069, -0.036652, 0.999229>, <0.000000, 0.000000, 1.000000> }
triangle { <-0.014069, -0.036652, 0.999229>, <-0.012132, -0.037338, 0.999229>, <-0.024245, -0.074619, 0.996917> }
triangle { <-0.024245, -0.074619, 0.996917>, <-0.028117, -0.073248, 0.996917>, <-0.014069, -0.036652, 0.999229> }
triangle { <-0.028117, -0.073248, 0.996917>, <-0.024245, -0.074619, 0.996917>, <-0.036321, -0.111785, 0.993068> }
triangle { <-0.036321, -0.111785, 0.993068>, <-0.042122, -0.109731, 0.993068>, <-0.028117, -0.073248, 0.996917> }
triangle { <-0.042122, -0.109731, 0.993068>, <-0.036321, -0.111785, 0.993068>, <-0.048341, -0.148778, 0.987688> }
triangle { <-0.048341, -0.148778, 0.987688>, <-0.056061, -0.146044, 0.987688>, <-0.042122, -0.109731, 0.993068> }
triangle { <-0.056061, -0.146044, 0.987688>, <-0.048341, -0.148778, 0.987688>, <-0.060286, -0.185542, 0.980785> }
triangle { <-0.060286, -0.185542, 0.980785>, <-0.069914, -0.182133, 0.980785>, <-0.056061, -0.146044, 0.987688> }
triangle { <-0.069914, -0.182133, 0.980785>, <-0.060286, -0.185542, 0.980785>, <-0.072139, -0.222020, 0.972370> }
triangle { <-0.072139, -0.222020, 0.972370>, <-0.083659, -0.217940, 0.972370>, <-0.069914, -0.182133, 0.980785> }
triangle { <-0.083659, -0.217940, 0.972370>, <-0.072139, -0.222020, 0.972370>, <-0.083880, -0.258155, 0.962455> }
triangle { <-0.083880, -0.258155, 0.962455>, <-0.097276, -0.253411, 0.962455>, <-0.083659, -0.217940, 0.972370> }
triangle { <-0.097276, -0.253411, 0.962455>, <-0.083880, -0.258155, 0.962455>, <-0.095492, -0.293893, 0.951057> }
triangle { <-0.095492, -0.293893, 0.951057>, <-0.110742, -0.288492, 0.951057>, <-0.097276, -0.253411, 0.962455> }
triangle { <-0.110742, -0.288492, 0.951057>, <-0.095492, -0.293893, 0.951057>, <-0.106956, -0.329177, 0.938191> }
triangle { <-0.106956, -0.329177, 0.938191>, <-0.124037, -0.323128, 0.938191>, <-0.110742, -0.288492, 0.951057> }
triangle { <-0.124037, -0.323128, 0.938191>, <-0.106956, -0.329177, 0.938191>, <-0.118256, -0.363954, 0.923880> }
triangle { <-0.118256, -0.363954, 0.923880>, <-0.137141, -0.357266, 0.923880>, <-0.124037, -0.323128, 0.938191> }
triangle { <-0.137141, -0.357266, 0.923880>, <-0.118256, -0.363954, 0.923880>, <-0.129373, -0.398169, 0.908143> }
triangle { <-0.129373, -0.398169, 0.908143>, <-0.150034, -0.390853, 0.908143>, <-0.137141, -0.357266, 0.923880> }
triangle { <-0.150034, -0.390853, 0.908143>, <-0.129373, -0.398169, 0.908143>, <-0.140291, -0.431771, 0.891007> }
triangle { <-0.140291, -0.431771, 0.891007>, <-0.162696, -0.423837, 0.891007>, <-0.150034, -0.390853, 0.908143> }
triangle { <-0.162696, -0.423837, 0.891007>, <-0.140291, -0.431771, 0.891007>, <-0.150992, -0.464706, 0.872496> }
triangle { <-0.150992, -0.464706, 0.872496>, <-0.175106, -0.456167, 0.872496>, <-0.162696, -0.423837, 0.891007> }
triangle { <-0.175106, -0.456167, 0.872496>, <-0.150992, -0.464706, 0.872496>, <-0.161461, -0.496926, 0.852640> }
triangle { <-0.161461, -0.496926, 0.852640>, <-0.187247, -0.487794, 0.852640>, <-0.175106, -0.456167, 0.872496> }
triangle { <-0.187247, -0.487794, 0.852640>, <-0.161461, -0.496926, 0.852640>, <-0.171681, -0.528379, 0.831470> }
triangle { <-0.171681, -0.528379, 0.831470>, <-0.199099, -0.518669, 0.831470>, <-0.187247, -0.487794, 0.852640> }
triangle { <-0.199099, -0.518669, 0.831470>, <-0.171681, -0.528379, 0.831470>, <-0.181636, -0.559017, 0.809017> }
triangle { <-0.181636, -0.559017, 0.809017>, <-0.210643, -0.548745, 0.809017>, <-0.199099, -0.518669, 0.831470> }
triangle { <-0.210643, -0.548745, 0.809017>, <-0.181636, -0.559017, 0.809017>, <-0.191311, -0.588793, 0.785317> }
triangle { <-0.191311, -0.588793, 0.785317>, <-0.221863, -0.577974, 0.785317>, <-0.210643, -0.548745, 0.809017> }
triangle { <-0.221863, -0.577974, 0.785317>, <-0.191311, -0.588793, 0.785317>, <-0.200690, -0.617662, 0.760406> }
triangle { <-0.200690, -0.617662, 0.760406>, <-0.232741, -0.606312, 0.760406>, <-0.221863, -0.577974, 0.785317> }
triangle { <-0.232741, -0.606312, 0.760406>, <-0.200690, -0.617662, 0.760406>, <-0.209761, -0.645578, 0.734323> }
triangle { <-0.209761, -0.645578, 0.734323>, <-0.243260, -0.633715, 0.734323>, <-0.232741, -0.606312, 0.760406> }
triangle { <-0.243260, -0.633715, 0.734323>, <-0.209761, -0.645578, 0.734323>, <-0.218508, -0.672499, 0.707107> }
triangle { <-0.218508, -0.672499, 0.707107>, <-0.253404, -0.660141, 0.707107>, <-0.243260, -0.633715, 0.734323> }
triangle { <-0.253404, -0.660141, 0.707107>, <-0.218508, -0.672499, 0.707107>, <-0.226918, -0.698382, 0.678801> }
triangle { <-0.226918, -0.698382, 0.678801>, <-0.263158, -0.685549, 0.678801>, <-0.253404, -0.660141, 0.707107> }
triangle { <-0.263158, -0.685549, 0.678801>, <-0.226918, -0.698382, 0.678801>, <-0.234978, -0.723189, 0.649448> }
triangle { <-0.234978, -0.723189, 0.649448>, <-0.272505, -0.709900, 0.649448>, <-0.263158, -0.685549, 0.678801> }
triangle { <-0.272505, -0.709900, 0.649448>, <-0.234978, -0.723189, 0.649448>, <-0.242676, -0.746881, 0.619094> }
triangle { <-0.242676, -0.746881, 0.619094>, <-0.281432, -0.733157, 0.619094>, <-0.272505, -0.709900, 0.649448> }
triangle { <-0.281432, -0.733157, 0.619094>, <-0.242676, -0.746881, 0.619094>, <-0.250000, -0.769421, 0.587785> }
triangle { <-0.250000, -0.769421, 0.587785>, <-0.289926, -0.755282, 0.587785>, <-0.281432, -0.733157, 0.619094> }
triangle { <-0.289926, -0.755282, 0.587785>, <-0.250000, -0.769421, 0.587785>, <-0.256938, -0.790775, 0.555570> }
triangle { <-0.256938, -0.790775, 0.555570>, <-0.297972, -0.776244, 0.555570>, <-0.289926, -0.755282, 0.587785> }
triangle { <-0.297972, -0.776244, 0.555570>, <-0.256938, -0.790775, 0.555570>, <-0.263480, -0.810909, 0.522499> }
triangle { <-0.263480, -0.810909, 0.522499>, <-0.305559, -0.796008, 0.522499>, <-0.297972, -0.776244, 0.555570> }
triangle { <-0.305559, -0.796008, 0.522499>, <-0.263480, -0.810909, 0.522499>, <-0.269616, -0.829793, 0.488621> }
triangle { <-0.269616, -0.829793, 0.488621>, <-0.312675, -0.814545, 0.488621>, <-0.305559, -0.796008, 0.522499> }
triangle { <-0.312675, -0.814545, 0.488621>, <-0.269616, -0.829793, 0.488621>, <-0.275336, -0.847398, 0.453990> }
triangle { <-0.275336, -0.847398, 0.453990>, <-0.319308, -0.831826, 0.453990>, <-0.312675, -0.814545, 0.488621> }
triangle { <-0.319308, -0.831826, 0.453990>, <-0.275336, -0.847398, 0.453990>, <-0.280632, -0.863695, 0.418660> }
triangle { <-0.280632, -0.863695, 0.418660>, <-0.325449, -0.847825, 0.418660>, <-0.319308, -0.831826, 0.453990> }
triangle { <-0.325449, -0.847825, 0.418660>, <-0.280632, -0.863695, 0.418660>, <-0.285494, -0.878662, 0.382683> }
triangle { <-0.285494, -0.878662, 0.382683>, <-0.331089, -0.862516, 0.382683>, <-0.325449, -0.847825, 0.418660> }
triangle { <-0.331089, -0.862516, 0.382683>, <-0.285494, -0.878662, 0.382683>, <-0.289917, -0.892273, 0.346117> }
triangle { <-0.289917, -0.892273, 0.346117>, <-0.336218, -0.875877, 0.346117>, <-0.331089, -0.862516, 0.382683> }
triangle { <-0.336218, -0.875877, 0.346117>, <-0.289917, -0.892273, 0.346117>, <-0.293893, -0.904508, 0.309017> }
triangle { <-0.293893, -0.904508, 0.309017>, <-0.340828, -0.887888, 0.309017>, <-0.336218, -0.875877, 0.346117> }
triangle { <-0.340828, -0.887888, 0.309017>, <-0.293893, -0.904508, 0.309017>, <-0.297415, -0.915349, 0.271440> }
triangle { <-0.297415, -0.915349, 0.271440>, <-0.344913, -0.898529, 0.271440>, <-0.340828, -0.887888, 0.309017> }
triangle { <-0.344913, -0.898529, 0.271440>, <-0.297415, -0.915349, 0.271440>, <-0.300479, -0.924779, 0.233445> }
triangle { <-0.300479, -0.924779, 0.233445>, <-0.348466, -0.907786, 0.233445>, <-0.344913, -0.898529, 0.271440> }
triangle { <-0.348466, -0.907786, 0.233445>, <-0.300479, -0.924779, 0.233445>, <-0.303079, -0.932782, 0.195090> }
triangle { <-0.303079, -0.932782, 0.195090>, <-0.351482, -0.915642, 0.195090>, <-0.348466, -0.907786, 0.233445> }
triangle { <-0.351482, -0.915642, 0.195090>, <-0.303079, -0.932782, 0.195090>, <-0.305212, -0.939347, 0.156434> }
triangle { <-0.305212, -0.939347, 0.156434>, <-0.353956, -0.922087, 0.156434>, <-0.351482, -0.915642, 0.195090> }
triangle { <-0.353956, -0.922087, 0.156434>, <-0.305212, -0.939347, 0.156434>, <-0.306875, -0.944464, 0.117537> }
triangle { <-0.306875, -0.944464, 0.117537>, <-0.355884, -0.927109, 0.117537>, <-0.353956, -0.922087, 0.156434> }
triangle { <-0.355884, -0.927109, 0.117537>, <-0.306875, -0.944464, 0.117537>, <-0.308064, -0.948125, 0.078459> }
triangle { <-0.308064, -0.948125, 0.078459>, <-0.357263, -0.930703, 0.078459>, <-0.355884, -0.927109, 0.117537> }
triangle { <-0.357263, -0.930703, 0.078459>, <-0.308064, -0.948125, 0.078459>, <-0.308779, -0.950323, 0.039260> }
triangle { <-0.308779, -0.950323, 0.039260>, <-0.358092, -0.932861, 0.039260>, <-0.357263, -0.930703, 0.078459> }
triangle { <-0.358092, -0.932861, 0.039260>, <-0.308779, -0.950323, 0.039260>, <-0.309017, -0.951057, -0.000000> }
triangle { <-0.309017, -0.951057, -0.000000>, <-0.358368, -0.933580, -0.000000>, <-0.358092, -0.932861, 0.039260> }
triangle { <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <-0.010161, -0.037922, 0.999229> }
triangle { <-0.010161, -0.037922, 0.999229>, <-0.012132, -0.037338, 0.999229>, <0.000000, 0.000000, 1.000000> }
triangle { <-0.012132, -0.037338, 0.999229>, <-0.010161, -0.037922, 0.999229>, <-0.020307, -0.075786, 0.996917> }
triangle { <-0.020307, -0.075786, 0.996917>, <-0.024245, -0.074619, 0.996917>, <-0.012132, -0.037338, 0.999229> }
triangle { <-0.024245, -0.074619, 0.996917>, <-0.020307, -0.075786, 0.996917>, <-0.030421, -0.113532, 0.993068> }
triangle { <-0.030421, -0.113532, 0.993068>, <-0.036321, -0.111785, 0.993068>, <-0.024245, -0.074619, 0.996917> }
triangle { <-0.036321, -0.111785, 0.993068>, <-0.030421, -0.113532, 0.993068>, <-0.040488, -0.151104, 0.987688> }
triangle { <-0.040488, -0.151104, 0.987688>, <-0.048341, -0.148778, 0.987688>, <-0.036321, -0.111785, 0.993068> }
triangle { <-0.048341, -0.148778, 0.987688>, <-0.040488, -0.151104, 0.987688>, <-0.050493, -0.188443, 0.980785> }
triangle { <-0.050493, -0.188443, 0.980785>, <-0.060286, -0.185542, 0.980785>, <-0.048341, -0.148778, 0.987688> }
triangle { <-0.060286, -0.185542, 0.980785>, <-0.050493, -0.188443, 0.980785>, <-0.060420, -0.225491, 0.972370> }
triangle { <-0.060420, -0.225491, 0.972370>, <-0.072139, -0.222020, 0.972370>, <-0.060286, -0.185542, 0.980785> }
triangle { <-0.072139, -0.222020, 0.972370>, <-0.060420, -0.225491, 0.972370>, <-0.070254, -0.262191, 0.962455> }
triangle { <-0.070254, -0.262191, 0.962455>, <-0.083880, -0.258155, 0.962455>, <-0.072139, -0.222020, 0.972370> }
triangle { <-0.083880, -0.258155, 0.962455>, <-0.070254, -0.262191, 0.962455>, <-0.079979, -0.298487, 0.951057> }
triangle { <-0.079979, -0.298487, 0.951057>, <-0.095492, -0.293893, 0.951057>, <-0.083880, -0.258155, 0.962455> }
triangle { <-0.095492, -0.293893, 0.951057>, <-0.079979, -0.298487, 0.951057>, <-0.089582, -0.334323, 0.938191> }
triangle { <-0.089582, -0.334323, 0.938191>, <-0.106956, -0.329177, 0.938191>, <-0.095492, -0.293893, 0.951057> }
triangle { <-0.106956, -0.329177, 0.938191>, <-0.089582, -0.334323, 0.938191>, <-0.099046, -0.369644, 0.923880> }
triangle { <-0.099046, -0.369644, 0.923880>, <-0.118256, -0.363954, 0.923880>, <-0.106956, -0.329177, 0.938191> }
triangle { <-0.118256, -0.363954, 0.923880>, <-0.099046, -0.369644, 0.923880>, <-0.108357, -0.404394, 0.908143> }
triangle { <-0.108357, -0.404394, 0.908143>, <-0.129373, -0.398169, 0.908143>, <-0.118256, -0.363954, 0.923880> }
triangle { <-0.129373, -0.398169, 0.908143>, <-0.108357, -0.404394, 0.908143>, <-0.117501, -0.438521, 0.891007> }
triangle { <-0.117501, -0.438521, 0.891007>, <-0.140291, -0.431771, 0.891007>, <-0.129373, -0.398169, 0.908143> }
triangle { <-0.140291, -0.431771, 0.891007>, <-0.117501, -0.438521, 0.891007>, <-0.126464, -0.471972, 0.872496> }
triangle { <-0.126464, -0.471972, 0.872496>, <-0.150992, -0.464706, 0.872496>, <-0.140291, -0.431771, 0.891007> }
triangle { <-0.150992, -0.464706, 0.872496>, <-0.126464, -0.471972, 0.872496>, <-0.135233, -0.504695, 0.852640> }
triangle { <-0.135233, -0.504695, 0.852640>, <-0.161461, -0.496926, 0.852640>, <-0.150992, -0.464706, 0.872496> }
triangle { <-0.161461, -0.496926, 0.852640>, <-0.135233, -0.504695, 0.852640>, <-0.143792, -0.536640, 0.831470> }
triangle { <-0.143792, -0.536640, 0.831470>, <-0.171681, -0.528379, 0.831470>, <-0.161461, -0.496926, 0.852640> }
triangle { <-0.171681, -0.528379, 0.831470>, <-0.143792, -0.536640, 0.831470>, <-0.152130, -0.567757, 0.809017> }
triangle { <-0.152130, -0.567757, 0.809017>, <-0.181636, -0.559017, 0.809017>, <-0.171681, -0.528379, 0.831470> }
triangle { <-0.181636, -0.559017, 0.809017>, <-0.152130, -0.567757, 0.809017>, <-0.160233, -0.597999, 0.785317> }
triangle { <-0.160233, -0.597999, 0.785317>, <-0.191311, -0.588793, 0.785317>, <-0.181636, -0.559017, 0.809017> }
triangle { <-0.191311, -0.588793, 0.785317>, <-0.160233, -0.597999, 0.785317>, <-0.168090, -0.627319, 0.760406> }
triangle { <-0.168090, -0.627319, 0.760406>, <-0.200690, -0.617662, 0.760406>, <-0.191311, -0.588793, 0.785317> }
triangle { <-0.200690, -0.617662, 0.760406>, <-0.168090, -0.627319, 0.760406>, <-0.175687, -0.655671, 0.734323> }
triangle { <-0.175687, -0.655671, 0.734323>, <-0.209761, -0.645578, 0.734323>, <-0.200690, -0.617662, 0.760406> }
triangle { <-0.209761, -0.645578, 0.734323>, <-0.175687, -0.655671, 0.734323>, <-0.183013, -0.683013, 0.707107> }
triangle { <-0.183013, -0.683013, 0.707107>, <-0.218508, -0.672499, 0.707107>, <-0.209761, -0.645578, 0.734323> }
triangle { <-0.218508, -0.672499, 0.707107>, <-0.183013, -0.683013, 0.707107>, <-0.190057, -0.709301, 0.678801> }
triangle { <-0.190057, -0.709301, 0.678801>, <-0.226918, -0.698382, 0.678801>, <-0.218508, -0.672499, 0.707107> }
triangle { <-0.226918, -0.698382, 0.678801>, <-0.190057, -0.709301, 0.678801>, <-0.196808, -0.734496, 0.649448> }
triangle { <-0.196808, -0.734496, 0.649448>, <-0.234978, -0.723189, 0.649448>, <-0.226918, -0.698382, 0.678801> }
triangle { <-0.234978, -0.723189, 0.649448>, <-0.196808, -0.734496, 0.649448>, <-0.203255, -0.758558, 0.619094> }
triangle { <-0.203255, -0.758558, 0.619094>, <-0.242676, -0.746881, 0.619094>, <-0.234978, -0.723189, 0.649448> }
triangle { <-0.242676, -0.746881, 0.619094>, <-0.203255, -0.758558, 0.619094>, <-0.209389, -0.781450, 0.587785> }
triangle { <-0.209389, -0.781450, 0.587785>, <-0.250000, -0.769421, 0.587785>, <-0.242676, -0.746881, 0.619094> }
triangle { <-0.250000, -0.769421, 0.587785>, <-0.209389, -0.781450, 0.587785>, <-0.215200, -0.803138, 0.555570> }
triangle { <-0.215200, -0.803138, 0.555570>, <-0.256938, -0.790775, 0.555570>, <-0.250000, -0.769421, 0.587785> }
triangle { <-0.256938, -0.790775, 0.555570>, <-0.215200, -0.803138, 0.555570>, <-0.220680, -0.823587, 0.522499> }
triangle { <-0.220680, -0.823587, 0.522499>, <-0.263480, -0.810909, 0.522499>, <-0.256938, -0.790775, 0.555570> }
triangle { <-0.263480, -0.810909, 0.522499>, <-0.220680, -0.823587, 0.522499>, <-0.225819, -0.842766, 0.488621> }
triangle { <-0.225819, -0.842766, 0.488621>, <-0.269616, -0.829793, 0.488621>, <-0.263480, -0.810909, 0.522499> }
triangle { <-0.269616, -0.829793, 0.488621>, <-0.225819, -0.842766, 0.488621>, <-0.230609, -0.860646, 0.453990> }
triangle { <-0.230609, -0.860646, 0.453990>, <-0.275336, -0.847398, 0.453990>, <-0.269616, -0.829793, 0.488621> }
triangle { <-0.275336, -0.847398, 0.453990>, <-0.230609, -0.860646, 0.453990>, <-0.235045, -0.877199, 0.418660> }
triangle { <-0.235045, -0.877199, 0.418660>, <-0.280632, -0.863695, 0.418660>, <-0.275336, -0.847398, 0.453990> }
triangle { <-0.280632, -0.863695, 0.418660>, <-0.235045, -0.877199, 0.418660>, <-0.239118, -0.892399, 0.382683> }
triangle { <-0.239118, -0.892399, 0.382683>, <-0.285494, -0.878662, 0.382683>, <-0.280632, -0.863695, 0.418660> }
triangle { <-0.285494, -0.878662, 0.382683>, <-0.239118, -0.892399, 0.382683>, <-0.242822, -0.906223, 0.346117> }
triangle { <-0.242822, -0.906223, 0.346117>, <-0.289917, -0.892273, 0.346117>, <-0.285494, -0.878662, 0.382683> }
triangle { <-0.289917, -0.892273, 0.346117>, <-0.242822, -0.906223, 0.346117>, <-0.246152, -0.918650, 0.309017> }
triangle { <-0.246152, -0.918650, 0.309017>, <-0.293893, -0.904508, 0.309017>, <-0.289917, -0.892273, 0.346117> }
triangle { <-0.293893, -0.904508, 0.309017>, <-0.246152, -0.918650, 0.309017>, <-0.249102, -0.929660, 0.271440> }
triangle { <-0.249102, -0.929660, 0.271440>, <-0.297415, -0.915349, 0.271440>, <-0.293893, -0.904508, 0.309017> }
triangle { <-0.297415, -0.915349, 0.271440>, <-0.249102, -0.929660, 0.271440>, <-0.251668, -0.939237, 0.233445> }
triangle { <-0.251668, -0.939237, 0.233445>, <-0.300479, -0.924779, 0.233445>, <-0.297415, -0.915349, 0.271440> }
triangle { <-0.300479, -0.924779, 0.233445>, <-0.251668, -0.939237, 0.233445>, <-0.253846, -0.947366, 0.195090> }
triangle { <-0.253846, -0.947366, 0.195090>, <-0.303079, -0.932782, 0.195090>, <-0.300479, -0.924779, 0.233445> }
triangle { <-0.303079, -0.932782, 0.195090>, <-0.253846, -0.947366, 0.195090>, <-0.255633, -0.954034, 0.156434> }
triangle { <-0.255633, -0.954034, 0.156434>, <-0.305212, -0.939347, 0.156434>, <-0.303079, -0.932782, 0.195090> }
triangle { <-0.305212, -0.939347, 0.156434>, <-0.255633, -0.954034, 0.156434>, <-0.257025, -0.959230, 0.117537> }
triangle { <-0.257025, -0.959230, 0.117537>, <-0.306875, -0.944464, 0.117537>, <-0.305212, -0.939347, 0.156434> }
triangle { <-0.306875, -0.944464, 0.117537>, <-0.257025, -0.959230, 0.117537>, <-0.258021, -0.962948, 0.078459> }
triangle { <-0.258021, -0.962948, 0.078459>, <-0.308064, -0.948125, 0.078459>, <-0.306875, -0.944464, 0.117537> }
triangle { <-0.308064, -0.948125, 0.078459>, <-0.258021, -0.962948, 0.078459>, <-0.258620, -0.965181, 0.039260> }
triangle { <-0.258620, -0.965181, 0.039260>, <-0.308779, -0.950323, 0.039260>, <-0.308064, -0.948125, 0.078459> }
triangle { <-0.308779, -0.950323, 0.039260>, <-0.258620, -0.965181, 0.039260>, <-0.258819, -0.965926, -0.000000> }
triangle { <-0.258819, -0.965926, -0.000000>, <-0.309017, -0.951057, -0.000000>, <-0.308779, -0.950323, 0.039260> }
triangle { <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <-0.008163, -0.038402, 0.999229> }
triangle { <-0.008163, -0.038402, 0.999229>, <-0.010161, -0.037922, 0.999229>, <0.000000, 0.000000, 1.000000> }
triangle { <-0.010161, -0.037922, 0.999229>, <-0.008163, -0.038402, 0.999229>, <-0.016313, -0.076745, 0.996917> }
triangle { <-0.016313, -0.076745, 0.996917>, <-0.020307, -0.075786, 0.996917>, <-0.010161, -0.037922, 0.999229> }
triangle { <-0.020307, -0.075786, 0.996917>, <-0.016313, -0.076745, 0.996917>, <-0.024437, -0.114969, 0.993068> }
triangle { <-0.024437, -0.114969, 0.993068>, <-0.030421, -0.113532, 0.993068>, <-0.020307, -0.075786, 0.996917> }
triangle { <-0.030421, -0.113532, 0.993068>, <-0.024437, -0.114969, 0.993068>, <-0.032525, -0.153016, 0.987688> }
triangle { <-0.032525, -0.153016, 0.987688>, <-0.040488, -0.151104, 0.987688>, <-0.030421, -0.113532, 0.993068> }
triangle { <-0.040488, -0.151104, 0.987688>, <-0.032525, -0.153016, 0.987688>, <-0.040562, -0.190827, 0.980785> }
triangle { <-0.040562, -0.190827, 0.980785>, <-0.050493, -0.188443, 0.980785>, <-0.040488, -0.151104, 0.987688> }
triangle { <-0.050493, -0.188443, 0.980785>, <-0.040562, -0.190827, 0.980785>, <-0.048536, -0.228344, 0.972370> }
triangle { <-0.048536, -0.228344, 0.972370>, <-0.060420, -0.225491, 0.972370>, <-0.050493, -0.188443, 0.980785> }
triangle { <-0.060420, -0.225491, 0.972370>, <-0.048536, -0.228344, 0.972370>, <-0.056436, -0.265509, 0.962455> }
triangle { <-0.056436, -0.265509, 0.962455>, <-0.070254, -0.262191, 0.962455>, <-0.060420, -0.225491, 0.972370> }
triangle { <-0.070254, -0.262191, 0.962455>, <-0.056436, -0.265509, 0.962455>, <-0.064248, -0.302264, 0.951057> }
triangle { <-0.064248, -0.302264, 0.951057>, <-0.079979, -0.298487, 0.951057>, <-0.070254, -0.262191, 0.962455> }
triangle { <-0.079979, -0.298487, 0.951057>, <-0.064248, -0.302264, 0.951057>, <-0.071962, -0.338554, 0.938191> }
triangle { <-0.071962, -0.338554, 0.938191>, <-0.089582, -0.334323, 0.938191>, <-0.079979, -0.298487, 0.951057> }
triangle { <-0.089582, -0.334323, 0.938191>, <-0.071962, -0.338554, 0.938191>, <-0.079564, -0.374321, 0.923880> }
triangle { <-0.079564, -0.374321, 0.923880>, <-0.099046, -0.369644, 0.923880>, <-0.089582, -0.334323, 0.938191> }
triangle { <-0.099046, -0.369644, 0.923880>, <-0.079564, -0.374321, 0.923880>, <-0.087044, -0.409511, 0.908143> }
triangle { <-0.087044, -0.409511, 0.908143>, <-0.108357, -0.404394, 0.908143>, <-0.099046, -0.369644, 0.923880> }
triangle { <-0.108357, -0.404394, 0.908143>, <-0.087044, -0.409511, 0.908143>, <-0.094390, -0.444070, 0.891007> }
triangle { <-0.094390, -0.444070, 0.891007>, <-0.117501, -0.438521, 0.891007>, <-0.108357, -0.404394, 0.908143> }
triangle { <-0.117501, -0.438521, 0.891007>, <-0.094390, -0.444070, 0.891007>, <-0.101590, -0.477944, 0.872496> }
triangle { <-0.101590, -0.477944, 0.872496>, <-0.126464, -0.471972, 0.872496>, <-0.117501, -0.438521, 0.891007> }
triangle { <-0.126464, -0.471972, 0.872496>, <-0.101590, -0.477944, 0.872496>, <-0.108634, -0.511081, 0.852640> }
triangle { <-0.108634, -0.511081, 0.852640>, <-0.135233, -0.504695, 0.852640>, <-0.126464, -0.471972, 0.872496> }
triangle { <-0.135233, -0.504695, 0.852640>, <-0.108634, -0.511081, 0.852640>, <-0.115510, -0.543430, 0.831470> }
triangle { <-0.115510, -0.543430, 0.831470>, <-0.143792, -0.536640, 0.831470>, <-0.135233, -0.504695, 0.852640> }
triangle { <-0.143792, -0.536640, 0.831470>, <-0.115510, -0.543430, 0.831470>, <-0.122207, -0.574941, 0.809017> }
triangle { <-0.122207, -0.574941, 0.809017>, <-0.152130, -0.567757, 0.809017>, <-0.143792, -0.536640, 0.831470> }
triangle { <-0.152130, -0.567757, 0.809017>, <-0.122207, -0.574941, 0.809017>, <-0.128717, -0.605565, 0.785317> }
triangle { <-0.128717, -0.605565, 0.785317>, <-0.160233, -0.597999, 0.785317>, <-0.152130, -0.567757, 0.809017> }
triangle { <-0.160233, -0.597999, 0.785317>, <-0.128717, -0.605565, 0.785317>, <-0.135028, -0.635256, 0.760406> }
triangle { <-0.135028, -0.635256, 0.760406>, <-0.168090, -0.627319, 0.760406>, <-0.160233, -0.597999, 0.785317> }
triangle { <-0.168090, -0.627319, 0.760406>, <-0.135028, -0.635256, 0.760406>, <-0.141131, -0.663967, 0.734323> }
triangle { <-0.141131, -0.663967, 0.734323>, <-0.175687, -0.655671, 0.734323>, <-0.168090, -0.627319, 0.760406> }
triangle { <-0.175687, -0.655671, 0.734323>, <-0.141131, -0.663967, 0.734323>, <-0.147016, -0.691655, 0.707107> }
triangle { <-0.147016, -0.691655, 0.707107>, <-0.183013, -0.683013, 0.707107>, <-0.175687, -0.655671, 0.734323> }
triangle { <-0.183013, -0.683013, 0.707107>, <-0.147016, -0.691655, 0.707107>, <-0.152674, -0.718276, 0.678801> }
triangle { <-0.152674, -0.718276, 0.678801>, <-0.190057, -0.709301, 0.678801>, <-0.183013, -0.683013, 0.707107> }
triangle { <-0.190057, -0.709301, 0.678801>, <-0.152674, -0.718276, 0.678801>, <-0.158097, -0.743789, 0.649448> }
triangle { <-0.158097, -0.743789, 0.649448>, <-0.196808, -0.734496, 0.649448>, <-0.190057, -0.709301, 0.678801> }
triangle { <-0.196808, -0.734496, 0.649448>, <-0.158097, -0.743789, 0.649448>, <-0.163277, -0.768156, 0.619094> }
triangle { <-0.163277, -0.768156, 0.619094>, <-0.203255, -0.758558, 0.619094>, <-0.196808, -0.734496, 0.649448> }
triangle { <-0.203255, -0.758558, 0.619094>, <-0.163277, -0.768156, 0.619094>, <-0.168204, -0.791338, 0.587785> }
triangle { <-0.168204, -0.791338, 0.587785>, <-0.209389, -0.781450, 0.587785>, <-0.203255, -0.758558, 0.619094> }
triangle { <-0.209389, -0.781450, 0.587785>, <-0.168204, -0.791338, 0.587785>, <-0.172872, -0.813300, 0.555570> }
triangle { <-0.172872, -0.813300, 0.555570>, <-0.215200, -0.803138, 0.555570>, <-0.209389, -0.781450, 0.587785> }
triangle { <-0.215200, -0.803138, 0.555570>, <-0.172872, -0.813300, 0.555570>, <-0.177274, -0.834008, 0.522499> }
triangle { <-0.177274, -0.834008, 0.522499>, <-0.220680, -0.823587, 0.522499>, <-0.215200, -0.803138, 0.555570> }
triangle { <-0.220680, -0.823587, 0.522499>, <-0.177274, -0.834008, 0.522499>, <-0.181402, -0.853430, 0.488621> }
triangle { <-0.181402, -0.853430, 0.488621>, <-0.225819, -0.842766, 0.488621>, <-0.220680, -0.823587, 0.522499> }
triangle { <-0.225819, -0.842766, 0.488621>, <-0.181402, -0.853430, 0.488621>, <-0.185251, -0.871536, 0.453990> }
triangle { <-0.185251, -0.871536, 0.453990>, <-0.230609, -0.860646, 0.453990>, <-0.225819, -0.842766, 0.488621> }
triangle { <-0.230609, -0.860646, 0.453990>, <-0.185251, -0.871536, 0.453990>, <-0.188814, -0.888298, 0.418660> }
triangle { <-0.188814, -0.888298, 0.418660>, <-0.235045, -0.877199, 0.418660>, <-0.230609, -0.860646, 0.453990> }
triangle { <-0.235045, -0.877199, 0.418660>, <-0.188814, -0.888298, 0.418660>, <-0.192085, -0.903691, 0.382683> }
triangle { <-0.192085, -0.903691, 0.382683>, <-0.239118, -0.892399, 0.382683>, <-0.235045, -0.877199, 0.418660> }
triangle { <-0.239118, -0.892399, 0.382683>, <-0.192085, -0.903691, 0.382683>, <-0.195061, -0.917690, 0.346117> }
triangle { <-0.195061, -0.917690, 0.346117>, <-0.242822, -0.906223, 0.346117>, <-0.239118, -0.892399, 0.382683> }
triangle { <-0.242822, -0.906223, 0.346117>, <-0.195061, -0.917690, 0.346117>, <-0.197736, -0.930274, 0.309017> }
triangle { <-0.197736, -0.930274, 0.309017>, <-0.246152, -0.918650, 0.309017>, <-0.242822, -0.906223, 0.346117> }
triangle { <-0.246152, -0.918650, 0.309017>, <-0.197736, -0.930274, 0.309017>, <-0.200106, -0.941423, 0.271440> }
triangle { <-0.200106, -0.941423, 0.271440>, <-0.249102, -0.929660, 0.271440>, <-0.246152, -0.918650, 0.309017> }
triangle { <-0.249102, -0.929660, 0.271440>, <-0.200106, -0.941423, 0.271440>, <-0.202167, -0.951121, 0.233445> }
triangle { <-0.202167, -0.951121, 0.233445>, <-0.251668, -0.939237, 0.233445>, <-0.249102, -0.929660, 0.271440> }
triangle { <-0.251668, -0.939237, 0.233445>, <-0.202167, -0.951121, 0.233445>, <-0.203917, -0.959353, 0.195090> }
triangle { <-0.203917, -0.959353, 0.195090>, <-0.253846, -0.947366, 0.195090>, <-0.251668, -0.939237, 0.233445> }
triangle { <-0.253846, -0.947366, 0.195090>, <-0.203917, -0.959353, 0.195090>, <-0.205352, -0.966105, 0.156434> }
triangle { <-0.205352, -0.966105, 0.156434>, <-0.255633, -0.954034, 0.156434>, <-0.253846, -0.947366, 0.195090> }
triangle { <-0.255633, -0.954034, 0.156434>, <-0.205352, -0.966105, 0.156434>, <-0.206471, -0.971368, 0.117537> }
triangle { <-0.206471, -0.971368, 0.117537>, <-0.257025, -0.959230, 0.117537>, <-0.255633, -0.954034, 0.156434> }
triangle { <-0.257025, -0.959230, 0.117537>, <-0.206471, -0.971368, 0.117537>, <-0.207271, -0.975132, 0.078459> }
triangle { <-0.207271, -0.975132, 0.078459>, <-0.258021, -0.962948, 0.078459>, <-0.257025, -0.959230, 0.117537> }
triangle { <-0.258021, -0.962948, 0.078459>, <-0.207271, -0.975132, 0.078459>, <-0.207751, -0.977393, 0.039260> }
triangle { <-0.207751, -0.977393, 0.039260>, <-0.258620, -0.965181, 0.039260>, <-0.258021, -0.962948, 0.078459> }
triangle { <-0.258620, -0.965181, 0.039260>, <-0.207751, -0.977393, 0.039260>, <-0.207912, -0.978148, -0.000000> }
triangle { <-0.207912, -0.978148, -0.000000>, <-0.258819, -0.965926, -0.000000>, <-0.258620, -0.965181, 0.039260> }
triangle { <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <-0.006142, -0.038776, 0.999229> }
triangle { <-0.006142, -0.038776, 0.999229>, <-0.008163, -0.038402, 0.999229>, <0.000000, 0.000000, 1.000000> }
triangle { <-0.008163, -0.038402, 0.999229>, <-0.006142, -0.038776, 0.999229>, <-0.012274, -0.077493, 0.996917> }
triangle { <-0.012274, -0.077493, 0.996917>, <-0.016313, -0.076745, 0.996917>, <-0.008163, -0.038402, 0.999229> }
triangle { <-0.016313, -0.076745, 0.996917>, <-0.012274, -0.077493, 0.996917>, <-0.018387, -0.116090, 0.993068> }
triangle { <-0.018387, -0.116090, 0.993068>, <-0.024437, -0.114969, 0.993068>, <-0.016313, -0.076745, 0.996917> }
triangle { <-0.024437, -0.114969, 0.993068>, <-0.018387, -0.116090, 0.993068>, <-0.024472, -0.154508, 0.987688> }
triangle { <-0.024472, -0.154508, 0.987688>, <-0.032525, -0.153016, 0.987688>, <-0.024437, -0.114969, 0.993068> }
triangle { <-0.032525, -0.153016, 0.987688>, <-0.024472, -0.154508, 0.987688>, <-0.030519, -0.192688, 0.980785> }
triangle { <-0.030519, -0.192688, 0.980785>, <-0.040562, -0.190827, 0.980785>, <-0.032525, -0.153016, 0.987688> }
triangle { <-0.040562, -0.190827, 0.980785>, <-0.030519, -0.192688, 0.980785>, <-0.036519, -0.230571, 0.972370> }
triangle { <-0.036519, -0.230571, 0.972370>, <-0.048536, -0.228344, 0.972370>, <-0.040562, -0.190827, 0.980785> }
triangle { <-0.048536, -0.228344, 0.972370>, <-0.036519, -0.230571, 0.972370>, <-0.042463, -0.268099, 0.962455> }
triangle { <-0.042463, -0.268099, 0.962455>, <-0.056436, -0.265509, 0.962455>, <-0.048536, -0.228344, 0.972370> }
triangle { <-0.056436, -0.265509, 0.962455>, <-0.042463, -0.268099, 0.962455>, <-0.048341, -0.305212, 0.951057> }
triangle { <-0.048341, -0.305212, 0.951057>, <-0.064248, -0.302264, 0.951057>, <-0.056436, -0.265509, 0.962455> }
triangle { <-0.064248, -0.302264, 0.951057>, <-0.048341, -0.305212, 0.951057>, <-0.054145, -0.341856, 0.938191> }
triangle { <-0.054145, -0.341856, 0.938191>, <-0.071962, -0.338554, 0.938191>, <-0.064248, -0.302264, 0.951057> }
triangle { <-0.071962, -0.338554, 0.938191>, <-0.054145, -0.341856, 0.938191>, <-0.059865, -0.377972, 0.923880> }
triangle { <-0.059865, -0.377972, 0.923880>, <-0.079564, -0.374321, 0.923880>, <-0.071962, -0.338554, 0.938191> }
triangle { <-0.079564, -0.374321, 0.923880>, <-0.059865, -0.377972, 0.923880>, <-0.065493, -0.413505, 0.908143> }
triangle { <-0.065493, -0.413505, 0.908143>, <-0.087044, -0.409511, 0.908143>, <-0.079564, -0.374321, 0.923880> }
triangle { <-0.087044, -0.409511, 0.908143>, <-0.065493, -0.413505, 0.908143>, <-0.071020, -0.448401, 0.891007> }
triangle { <-0.071020, -0.448401, 0.891007>, <-0.094390, -0.444070, 0.891007>, <-0.087044, -0.409511, 0.908143> }
triangle { <-0.094390, -0.444070, 0.891007>, <-0.071020, -0.448401, 0.891007>, <-0.076437, -0.482606, 0.872496> }
triangle { <-0.076437, -0.482606, 0.872496>, <-0.101590, -0.477944, 0.872496>, <-0.094390, -0.444070, 0.891007> }
triangle { <-0.101590, -0.477944, 0.872496>, <-0.076437, -0.482606, 0.872496>, <-0.081737, -0.516066, 0.852640> }
triangle { <-0.081737, -0.516066, 0.852640>, <-0.108634, -0.511081, 0.852640>, <-0.101590, -0.477944, 0.872496> }
triangle { <-0.108634, -0.511081, 0.852640>, <-0.081737, -0.516066, 0.852640>, <-0.086910, -0.548730, 0.831470> }
triangle { <-0.086910, -0.548730, 0.831470>, <-0.115510, -0.543430, 0.831470>, <-0.108634, -0.511081, 0.852640> }
triangle { <-0.115510, -0.543430, 0.831470>, <-0.086910, -0.548730, 0.831470>, <-0.091950, -0.580549, 0.809017> }
triangle { <-0.091950, -0.580549, 0.809017>, <-0.122207, -0.574941, 0.809017>, <-0.115510, -0.543430, 0.831470> }
triangle { <-0.122207, -0.574941, 0.809017>, <-0.091950, -0.580549, 0.809017>, <-0.096848, -0.611472, 0.785317> }
triangle { <-0.096848, -0.611472, 0.785317>, <-0.128717, -0.605565, 0.785317>, <-0.122207, -0.574941, 0.809017> }
triangle { <-0.128717, -0.605565, 0.785317>, <-0.096848, -0.611472, 0.785317>, <-0.101596, -0.641452, 0.760406> }
triangle { <-0.101596, -0.641452, 0.760406>, <-0.135028, -0.635256, 0.760406>, <-0.128717, -0.605565, 0.785317> }
triangle { <-0.135028, -0.635256, 0.760406>, <-0.101596, -0.641452, 0.760406>, <-0.106188, -0.670444, 0.734323> }
triangle { <-0.106188, -0.670444, 0.734323>, <-0.141131, -0.663967, 0.734323>, <-0.135028, -0.635256, 0.760406> }
triangle { <-0.141131, -0.663967, 0.734323>, <-0.106188, -0.670444, 0.734323>, <-0.110616, -0.698401, 0.707107> }
triangle { <-0.110616, -0.698401, 0.707107>, <-0.147016, -0.691655, 0.707107>, <-0.141131, -0.663967, 0.734323> }
triangle { <-0.147016, -0.691655, 0.707107>, <-0.110616, -0.698401, 0.707107>, <-0.114873, -0.725282, 0.678801> }
triangle { <-0.114873, -0.725282, 0.678801>, <-0.152674, -0.718276, 0.678801>, <-0.147016, -0.691655, 0.707107> }
triangle { <-0.152674, -0.718276, 0.678801>, <-0.114873, -0.725282, 0.678801>, <-0.118954, -0.751044, 0.649448> }
triangle { <-0.118954, -0.751044, 0.649448>, <-0.158097, -0.743789, 0.649448>, <-0.152674, -0.718276, 0.678801> }
triangle { <-0.158097, -0.743789, 0.649448>, <-0.118954, -0.751044, 0.649448>, <-0.122851, -0.775648, 0.619094> }
triangle { <-0.122851, -0.775648, 0.619094>, <-0.163277, -0.768156, 0.619094>, <-0.158097, -0.743789, 0.649448> }
triangle { <-0.163277, -0.768156, 0.619094>, <-0.122851, -0.775648, 0.619094>, <-0.126558, -0.799057, 0.587785> }
triangle { <-0.126558, -0.799057, 0.587785>, <-0.168204, -0.791338, 0.587785>, <-0.163277, -0.768156, 0.619094> }
triangle { <-0.168204, -0.791338, 0.587785>, <-0.126558, -0.799057, 0.587785>, <-0.130071, -0.821233, 0.555570> }
triangle { <-0.130071, -0.821233, 0.555570>, <-0.172872, -0.813300, 0.555570>, <-0.168204, -0.791338, 0.587785> }
triangle { <-0.172872, -0.813300, 0.555570>, <-0.130071, -0.821233, 0.555570>, <-0.133382, -0.842143, 0.522499> }
triangle { <-0.133382, -0.842143, 0.522499>, <-0.177274, -0.834008, 0.522499>, <-0.172872, -0.813300, 0.555570> }
triangle { <-0.177274, -0.834008, 0.522499>, <-0.133382, -0.842143, 0.522499>, <-0.136488, -0.861754, 0.488621> }
triangle { <-0.136488, -0.861754, 0.488621>, <-0.181402, -0.853430, 0.488621>, <-0.177274, -0.834008, 0.522499> }
triangle { <-0.181402, -0.853430, 0.488621>, <-0.136488, -0.861754, 0.488621>, <-0.139384, -0.880037, 0.453990> }
triangle { <-0.139384, -0.880037, 0.453990>, <-0.185251, -0.871536, 0.453990>, <-0.181402, -0.853430, 0.488621> }
triangle { <-0.185251, -0.871536, 0.453990>, <-0.139384, -0.880037, 0.453990>, <-0.142065, -0.896962, 0.418660> }
triangle { <-0.142065, -0.896962, 0.418660>, <-0.188814, -0.888298, 0.418660>, <-0.185251, -0.871536, 0.453990> }
triangle { <-0.188814, -0.888298, 0.418660>, <-0.142065, -0.896962, 0.418660>, <-0.144527, -0.912505, 0.382683> }
triangle { <-0.144527, -0.912505, 0.382683>, <-0.192085, -0.903691, 0.382683>, <-0.188814, -0.888298, 0.418660> }
triangle { <-0.192085, -0.903691, 0.382683>, <-0.144527, -0.912505, 0.382683>, <-0.146765, -0.926641, 0.346117> }
triangle { <-0.146765, -0.926641, 0.346117>, <-0.195061, -0.917690, 0.346117>, <-0.192085, -0.903691, 0.382683> }
triangle { <-0.195061, -0.917690, 0.346117>, <-0.146765, -0.926641, 0.346117>, <-0.148778, -0.939347, 0.309017> }
triangle { <-0.148778, -0.939347, 0.309017>, <-0.197736, -0.930274, 0.309017>, <-0.195061, -0.917690, 0.346117> }
triangle { <-0.197736, -0.930274, 0.309017>, <-0.148778, -0.939347, 0.309017>, <-0.150561, -0.950606, 0.271440> }
triangle { <-0.150561, -0.950606, 0.271440>, <-0.200106, -0.941423, 0.271440>, <-0.197736, -0.930274, 0.309017> }
triangle { <-0.200106, -0.941423, 0.271440>, <-0.150561, -0.950606, 0.271440>, <-0.152112, -0.960398, 0.233445> }
triangle { <-0.152112, -0.960398, 0.233445>, <-0.202167, -0.951121, 0.233445>, <-0.200106, -0.941423, 0.271440> }
triangle { <-0.202167, -0.951121, 0.233445>, <-0.152112, -0.960398, 0.233445>, <-0.153429, -0.968710, 0.195090> }
triangle { <-0.153429, -0.968710, 0.195090>, <-0.203917, -0.959353, 0.195090>, <-0.202167, -0.951121, 0.233445> }
triangle { <-0.203917, -0.959353, 0.195090>, <-0.153429, -0.968710, 0.195090>, <-0.154508, -0.975528, 0.156434> }
triangle { <-0.154508, -0.975528, 0.156434>, <-0.205352, -0.966105, 0.156434>, <-0.203917, -0.959353, 0.195090> }
triangle { <-0.205352, -0.966105, 0.156434>, <-0.154508, -0.975528, 0.156434>, <-0.155350, -0.980842, 0.117537> }
triangle { <-0.155350, -0.980842, 0.117537>, <-0.206471, -0.971368, 0.117537>, <-0.205352, -0.966105, 0.156434> }
triangle { <-0.206471, -0.971368, 0.117537>, <-0.155350, -0.980842, 0.117537>, <-0.155952, -0.984644, 0.078459> }
triangle { <-0.155952, -0.984644, 0.078459>, <-0.207271, -0.975132, 0.078459>, <-0.206471, -0.971368, 0.117537> }
triangle { <-0.207271, -0.975132, 0.078459>, <-0.155952, -0.984644, 0.078459>, <-0.156314, -0.986927, 0.039260> }
triangle { <-0.156314, -0.986927, 0.039260>, <-0.207751, -0.977393, 0.039260>, <-0.207271, -0.975132, 0.078459> }
triangle { <-0.207751, -0.977393, 0.039260>, <-0.156314, -0.986927, 0.039260>, <-0.156434, -0.987688, -0.000000> }
triangle { <-0.156434, -0.987688, -0.000000>, <-0.207912, -0.978148, -0.000000>, <-0.207751, -0.977393, 0.039260> }
triangle { <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <-0.004104, -0.039045, 0.999229> }
triangle { <-0.004104, -0.039045, 0.999229>, <-0.006142, -0.038776, 0.999229>, <0.000000, 0.000000, 1.000000> }
triangle { <-0.006142, -0.038776, 0.999229>, <-0.004104, -0.039045, 0.999229>, <-0.008201, -0.078029, 0.996917> }
triangle { <-0.008201, -0.078029, 0.996917>, <-0.012274, -0.077493, 0.996917>, <-0.006142, -0.038776, 0.999229> }
triangle { <-0.012274, -0.077493, 0.996917>, <-0.008201, -0.078029, 0.996917>, <-0.012286, -0.116894, 0.993068> }
triangle { <-0.012286, -0.116894, 0.993068>, <-0.018387, -0.116090, 0.993068>, <-0.012274, -0.077493, 0.996917> }
triangle { <-0.018387, -0.116090, 0.993068>, <-0.012286, -0.116894, 0.993068>, <-0.016352, -0.155578, 0.987688> }
triangle { <-0.016352, -0.155578, 0.987688>, <-0.024472, -0.154508, 0.987688>, <-0.018387, -0.116090, 0.993068> }
triangle { <-0.024472, -0.154508, 0.987688>, <-0.016352, -0.155578, 0.987688>, <-0.020392, -0.194022, 0.980785> }
triangle { <-0.020392, -0.194022, 0.980785>, <-0.030519, -0.192688, 0.980785>, <-0.024472, -0.154508, 0.987688> }
triangle { <-0.030519, -0.192688, 0.980785>, <-0.020392, -0.194022, 0.980785>, <-0.024402, -0.232167, 0.972370> }
triangle { <-0.024402, -0.232167, 0.972370>, <-0.036519, -0.230571, 0.972370>, <-0.030519, -0.192688, 0.980785> }
triangle { <-0.036519, -0.230571, 0.972370>, <-0.024402, -0.232167, 0.972370>, <-0.028373, -0.269953, 0.962455> }
triangle { <-0.028373, -0.269953, 0.962455>, <-0.042463, -0.268099, 0.962455>, <-0.036519, -0.230571, 0.972370> }
triangle { <-0.042463, -0.268099, 0.962455>, <-0.028373, -0.269953, 0.962455>, <-0.032301, -0.307324, 0.951057> }
triangle { <-0.032301, -0.307324, 0.951057>, <-0.048341, -0.305212, 0.951057>, <-0.042463, -0.268099, 0.962455> }
triangle { <-0.048341, -0.305212, 0.951057>, <-0.032301, -0.307324, 0.951057>, <-0.036179, -0.344221, 0.938191> }
triangle { <-0.036179, -0.344221, 0.938191>, <-0.054145, -0.341856, 0.938191>, <-0.048341, -0.305212, 0.951057> }
triangle { <-0.054145, -0.341856, 0.938191>, <-0.036179, -0.344221, 0.938191>, <-0.040001, -0.380587, 0.923880> }
triangle { <-0.040001, -0.380587, 0.923880>, <-0.059865, -0.377972, 0.923880>, <-0.054145, -0.341856, 0.938191> }
triangle { <-0.059865, -0.377972, 0.923880>, <-0.040001, -0.380587, 0.923880>, <-0.043762, -0.416366, 0.908143> }
triangle { <-0.043762, -0.416366, 0.908143>, <-0.065493, -0.413505, 0.908143>, <-0.059865, -0.377972, 0.923880> }
triangle { <-0.065493, -0.413505, 0.908143>, <-0.043762, -0.416366, 0.908143>, <-0.047455, -0.451503, 0.891007> }
triangle { <-0.047455, -0.451503, 0.891007>, <-0.071020, -0.448401, 0.891007>, <-0.065493, -0.413505, 0.908143> }
triangle { <-0.071020, -0.448401, 0.891007>, <-0.047455, -0.451503, 0.891007>, <-0.051075, -0.485945, 0.872496> }
triangle { <-0.051075, -0.485945, 0.872496>, <-0.076437, -0.482606, 0.872496>, <-0.071020, -0.448401, 0.891007> }
triangle { <-0.076437, -0.482606, 0.872496>, <-0.051075, -0.485945, 0.872496>, <-0.054616, -0.519636, 0.852640> }
triangle { <-0.054616, -0.519636, 0.852640>, <-0.081737, -0.516066, 0.852640>, <-0.076437, -0.482606, 0.872496> }
triangle { <-0.081737, -0.516066, 0.852640>, <-0.054616, -0.519636, 0.852640>, <-0.058073, -0.552527, 0.831470> }
triangle { <-0.058073, -0.552527, 0.831470>, <-0.086910, -0.548730, 0.831470>, <-0.081737, -0.516066, 0.852640> }
triangle { <-0.086910, -0.548730, 0.831470>, <-0.058073, -0.552527, 0.831470>, <-0.061440, -0.584565, 0.809017> }
triangle { <-0.061440, -0.584565, 0.809017>, <-0.091950, -0.580549, 0.809017>, <-0.086910, -0.548730, 0.831470> }
triangle { <-0.091950, -0.580549, 0.809017>, <-0.061440, -0.584565, 0.809017>, <-0.064713, -0.615702, 0.785317> }
triangle { <-0.064713, -0.615702, 0.785317>, <-0.096848, -0.611472, 0.785317>, <-0.091950, -0.580549, 0.809017> }
triangle { <-0.096848, -0.611472, 0.785317>, <-0.064713, -0.615702, 0.785317>, <-0.067886, -0.645890, 0.760406> }
triangle { <-0.067886, -0.645890, 0.760406>, <-0.101596, -0.641452, 0.760406>, <-0.096848, -0.611472, 0.785317> }
triangle { <-0.101596, -0.641452, 0.760406>, <-0.067886, -0.645890, 0.760406>, <-0.070954, -0.675082, 0.734323> }
triangle { <-0.070954, -0.675082, 0.734323>, <-0.106188, -0.670444, 0.734323>, <-0.101596, -0.641452, 0.760406> }
triangle { <-0.106188, -0.670444, 0.734323>, <-0.070954, -0.675082, 0.734323>, <-0.073913, -0.703233, 0.707107> }
triangle { <-0.073913, -0.703233, 0.707107>, <-0.110616, -0.698401, 0.707107>, <-0.106188, -0.670444, 0.734323> }
triangle { <-0.110616, -0.698401, 0.707107>, <-0.073913, -0.703233, 0.707107>, <-0.076758, -0.730300, 0.678801> }
triangle { <-0.076758, -0.730300, 0.678801>, <-0.114873, -0.725282, 0.678801>, <-0.110616, -0.698401, 0.707107> }
triangle { <-0.114873, -0.725282, 0.678801>, <-0.076758, -0.730300, 0.678801>, <-0.079484, -0.756240, 0.649448> }
triangle { <-0.079484, -0.756240, 0.649448>, <-0.118954, -0.751044, 0.649448>, <-0.114873, -0.725282, 0.678801> }
triangle { <-0.118954, -0.751044, 0.649448>, <-0.079484, -0.756240, 0.649448>, <-0.082088, -0.781015, 0.619094> }
triangle { <-0.082088, -0.781015, 0.619094>, <-0.122851, -0.775648, 0.619094>, <-0.118954, -0.751044, 0.649448> }
triangle { <-0.122851, -0.775648, 0.619094>, <-0.082088, -0.781015, 0.619094>, <-0.084565, -0.804585, 0.587785> }
triangle { <-0.084565, -0.804585, 0.587785>, <-0.126558, -0.799057, 0.587785>, <-0.122851, -0.775648, 0.619094> }
triangle { <-0.126558, -0.799057, 0.587785>, <-0.084565, -0.804585, 0.587785>, <-0.086912, -0.826915, 0.555570> }
triangle { <-0.086912, -0.826915, 0.555570>, <-0.130071, -0.821233, 0.555570>, <-0.126558, -0.799057, 0.587785> }
triangle { <-0.130071, -0.821233, 0.555570>, <-0.086912, -0.826915, 0.555570>, <-0.089125, -0.847969, 0.522499> }
triangle { <-0.089125, -0.847969, 0.522499>, <-0.133382, -0.842143, 0.522499>, <-0.130071, -0.821233, 0.555570> }
triangle { <-0.133382, -0.842143, 0.522499>, <-0.089125, -0.847969, 0.522499>, <-0.091201, -0.867716, 0.488621> }
triangle { <-0.091201, -0.867716, 0.488621>, <-0.136488, -0.861754, 0.488621>, <-0.133382, -0.842143, 0.522499> }
triangle { <-0.136488, -0.861754, 0.488621>, <-0.091201, -0.867716, 0.488621>, <-0.093136, -0.886125, 0.453990> }
triangle { <-0.093136, -0.886125, 0.453990>, <-0.139384, -0.880037, 0.453990>, <-0.136488, -0.861754, 0.488621> }
triangle { <-0.139384, -0.880037, 0.453990>, <-0.093136, -0.886125, 0.453990>, <-0.094927, -0.903168, 0.418660> }
triangle { <-0.094927, -0.903168, 0.418660>, <-0.142065, -0.896962, 0.418660>, <-0.139384, -0.880037, 0.453990> }
triangle { <-0.142065, -0.896962, 0.418660>, <-0.094927, -0.903168, 0.418660>, <-0.096572, -0.918818, 0.382683> }
triangle { <-0.096572, -0.918818, 0.382683>, <-0.144527, -0.912505, 0.382683>, <-0.142065, -0.896962, 0.418660> }
triangle { <-0.144527, -0.912505, 0.382683>, <-0.096572, -0.918818, 0.382683>, <-0.098068, -0.933052, 0.346117> }
triangle { <-0.098068, -0.933052, 0.346117>, <-0.146765, -0.926641, 0.346117>, <-0.144527, -0.912505, 0.382683> }
triangle { <-0.146765, -0.926641, 0.346117>, <-0.098068, -0.933052, 0.346117>, <-0.099412, -0.945847, 0.309017> }
triangle { <-0.099412, -0.945847, 0.309017>, <-0.148778, -0.939347, 0.309017>, <-0.146765, -0.926641, 0.346117> }
triangle { <-0.148778, -0.939347, 0.309017>, <-0.099412, -0.945847, 0.309017>, <-0.100604, -0.957183, 0.271440> }
triangle { <-0.100604, -0.957183, 0.271440>, <-0.150561, -0.950606, 0.271440>, <-0.148778, -0.939347, 0.309017> }
triangle { <-0.150561, -0.950606, 0.271440>, <-0.100604, -0.957183, 0.271440>, <-0.101640, -0.967043, 0.233445> }
triangle { <-0.101640, -0.967043, 0.233445>, <-0.152112, -0.960398, 0.233445>, <-0.150561, -0.950606, 0.271440> }
triangle { <-0.152112, -0.960398, 0.233445>, <-0.101640, -0.967043, 0.233445>, <-0.102520, -0.975412, 0.195090> }
triangle { <-0.102520, -0.975412, 0.195090>, <-0.153429, -0.968710, 0.195090>, <-0.152112, -0.960398, 0.233445> }
triangle { <-0.153429, -0.968710, 0.195090>, <-0.102520, -0.975412, 0.195090>, <-0.103242, -0.982278, 0.156434> }
triangle { <-0.103242, -0.982278, 0.156434>, <-0.154508, -0.975528, 0.156434>, <-0.153429, -0.968710, 0.195090> }
triangle { <-0.154508, -0.975528, 0.156434>, <-0.103242, -0.982278, 0.156434>, <-0.103804, -0.987628, 0.117537> }
triangle { <-0.103804, -0.987628, 0.117537>, <-0.155350, -0.980842, 0.117537>, <-0.154508, -0.975528, 0.156434> }
triangle { <-0.155350, -0.980842, 0.117537>, <-0.103804, -0.987628, 0.117537>, <-0.104206, -0.991456, 0.078459> }
triangle { <-0.104206, -0.991456, 0.078459>, <-0.155952, -0.984644, 0.078459>, <-0.155350, -0.980842, 0.117537> }
triangle { <-0.155952, -0.984644, 0.078459>, <-0.104206, -0.991456, 0.078459>, <-0.104448, -0.993755, 0.039260> }
triangle { <-0.104448, -0.993755, 0.039260>, <-0.156314, -0.986927, 0.039260>, <-0.155952, -0.984644, 0.078459> }
triangle { <-0.156314, -0.986927, 0.039260>, <-0.104448, -0.993755, 0.039260>, <-0.104528, -0.994522, -0.000000> }
triangle { <-0.104528, -0.994522, -0.000000>, <-0.156434, -0.987688, -0.000000>, <-0.156314, -0.986927, 0.039260> }
triangle { <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <-0.002055, -0.039206, 0.999229> }
triangle { <-0.002055, -0.039206, 0.999229>, <-0.004104, -0.039045, 0.999229>, <0.000000, 0.000000, 1.000000> }
triangle { <-0.004104, -0.039045, 0.999229>, <-0.002055, -0.039206, 0.999229>, <-0.004106, -0.078352, 0.996917> }
triangle { <-0.004106, -0.078352, 0.996917>, <-0.008201, -0.078029, 0.996917>, <-0.004104, -0.039045, 0.999229> }
triangle { <-0.008201, -0.078029, 0.996917>, <-0.004106, -0.078352, 0.996917>, <-0.006151, -0.117376, 0.993068> }
triangle { <-0.006151, -0.117376, 0.993068>, <-0.012286, -0.116894, 0.993068>, <-0.008201, -0.078029, 0.996917> }
triangle { <-0.012286, -0.116894, 0.993068>, <-0.006151, -0.117376, 0.993068>, <-0.008187, -0.156220, 0.987688> }
triangle { <-0.008187, -0.156220, 0.987688>, <-0.016352, -0.155578, 0.987688>, <-0.012286, -0.116894, 0.993068> }
triangle { <-0.016352, -0.155578, 0.987688>, <-0.008187, -0.156220, 0.987688>, <-0.010210, -0.194823, 0.980785> }
triangle { <-0.010210, -0.194823, 0.980785>, <-0.020392, -0.194022, 0.980785>, <-0.016352, -0.155578, 0.987688> }
triangle { <-0.020392, -0.194022, 0.980785>, <-0.010210, -0.194823, 0.980785>, <-0.012218, -0.233125, 0.972370> }
triangle { <-0.012218, -0.233125, 0.972370>, <-0.024402, -0.232167, 0.972370>, <-0.020392, -0.194022, 0.980785> }
triangle { <-0.024402, -0.232167, 0.972370>, <-0.012218, -0.233125, 0.972370>, <-0.014206, -0.271068, 0.962455> }
triangle { <-0.014206, -0.271068, 0.962455>, <-0.028373, -0.269953, 0.962455>, <-0.024402, -0.232167, 0.972370> }
triangle { <-0.028373, -0.269953, 0.962455>, <-0.014206, -0.271068, 0.962455>, <-0.016173, -0.308593, 0.951057> }
triangle { <-0.016173, -0.308593, 0.951057>, <-0.032301, -0.307324, 0.951057>, <-0.028373, -0.269953, 0.962455> }
triangle { <-0.032301, -0.307324, 0.951057>, <-0.016173, -0.308593, 0.951057>, <-0.018114, -0.345643, 0.938191> }
triangle { <-0.018114, -0.345643, 0.938191>, <-0.036179, -0.344221, 0.938191>, <-0.032301, -0.307324, 0.951057> }
triangle { <-0.036179, -0.344221, 0.938191>, <-0.018114, -0.345643, 0.938191>, <-0.020028, -0.382159, 0.923880> }
triangle { <-0.020028, -0.382159, 0.923880>, <-0.040001, -0.380587, 0.923880>, <-0.036179, -0.344221, 0.938191> }
triangle { <-0.040001, -0.380587, 0.923880>, <-0.020028, -0.382159, 0.923880>, <-0.021911, -0.418086, 0.908143> }
triangle { <-0.021911, -0.418086, 0.908143>, <-0.043762, -0.416366, 0.908143>, <-0.040001, -0.380587, 0.923880> }
triangle { <-0.043762, -0.416366, 0.908143>, <-0.021911, -0.418086, 0.908143>, <-0.023760, -0.453368, 0.891007> }
triangle { <-0.023760, -0.453368, 0.891007>, <-0.047455, -0.451503, 0.891007>, <-0.043762, -0.416366, 0.908143> }
triangle { <-0.047455, -0.451503, 0.891007>, <-0.023760, -0.453368, 0.891007>, <-0.025572, -0.487952, 0.872496> }
triangle { <-0.025572, -0.487952, 0.872496>, <-0.051075, -0.485945, 0.872496>, <-0.047455, -0.451503, 0.891007> }
triangle { <-0.051075, -0.485945, 0.872496>, <-0.025572, -0.487952, 0.872496>, <-0.027345, -0.521782, 0.852640> }
triangle { <-0.027345, -0.521782, 0.852640>, <-0.054616, -0.519636, 0.852640>, <-0.051075, -0.485945, 0.872496> }
triangle { <-0.054616, -0.519636, 0.852640>, <-0.027345, -0.521782, 0.852640>, <-0.029076, -0.554809, 0.831470> }
triangle { <-0.029076, -0.554809, 0.831470>, <-0.058073, -0.552527, 0.831470>, <-0.054616, -0.519636, 0.852640> }
triangle { <-0.058073, -0.552527, 0.831470>, <-0.029076, -0.554809, 0.831470>, <-0.030762, -0.586980, 0.809017> }
triangle { <-0.030762, -0.586980, 0.809017>, <-0.061440, -0.584565, 0.809017>, <-0.058073, -0.552527, 0.831470> }
triangle { <-0.061440, -0.584565, 0.809017>, <-0.030762, -0.586980, 0.809017>, <-0.032401, -0.618246, 0.785317> }
triangle { <-0.032401, -0.618246, 0.785317>, <-0.064713, -0.615702, 0.785317>, <-0.061440, -0.584565, 0.809017> }
triangle { <-0.064713, -0.615702, 0.785317>, <-0.032401, -0.618246, 0.785317>, <-0.033989, -0.648558, 0.760406> }
triangle { <-0.033989, -0.648558, 0.760406>, <-0.067886, -0.645890, 0.760406>, <-0.064713, -0.615702, 0.785317> }
triangle { <-0.067886, -0.645890, 0.760406>, <-0.033989, -0.648558, 0.760406>, <-0.035526, -0.677870, 0.734323> }
triangle { <-0.035526, -0.677870, 0.734323>, <-0.070954, -0.675082, 0.734323>, <-0.067886, -0.645890, 0.760406> }
triangle { <-0.070954, -0.675082, 0.734323>, <-0.035526, -0.677870, 0.734323>, <-0.037007, -0.706138, 0.707107> }
triangle { <-0.037007, -0.706138, 0.707107>, <-0.073913, -0.703233, 0.707107>, <-0.070954, -0.675082, 0.734323> }
triangle { <-0.073913, -0.703233, 0.707107>, <-0.037007, -0.706138, 0.707107>, <-0.038431, -0.733316, 0.678801> }
triangle { <-0.038431, -0.733316, 0.678801>, <-0.076758, -0.730300, 0.678801>, <-0.073913, -0.703233, 0.707107> }
triangle { <-0.076758, -0.730300, 0.678801>, <-0.038431, -0.733316, 0.678801>, <-0.039797, -0.759364, 0.649448> }
triangle { <-0.039797, -0.759364, 0.649448>, <-0.079484, -0.756240, 0.649448>, <-0.076758, -0.730300, 0.678801> }
triangle { <-0.079484, -0.756240, 0.649448>, <-0.039797, -0.759364, 0.649448>, <-0.041100, -0.784241, 0.619094> }
triangle { <-0.041100, -0.784241, 0.619094>, <-0.082088, -0.781015, 0.619094>, <-0.079484, -0.756240, 0.649448> }
triangle { <-0.082088, -0.781015, 0.619094>, <-0.041100, -0.784241, 0.619094>, <-0.042341, -0.807908, 0.587785> }
triangle { <-0.042341, -0.807908, 0.587785>, <-0.084565, -0.804585, 0.587785>, <-0.082088, -0.781015, 0.619094> }
triangle { <-0.084565, -0.804585, 0.587785>, <-0.042341, -0.807908, 0.587785>, <-0.043516, -0.830330, 0.555570> }
triangle { <-0.043516, -0.830330, 0.555570>, <-0.086912, -0.826915, 0.555570>, <-0.084565, -0.804585, 0.587785> }
triangle { <-0.086912, -0.826915, 0.555570>, <-0.043516, -0.830330, 0.555570>, <-0.044624, -0.851472, 0.522499> }
triangle { <-0.044624, -0.851472, 0.522499>, <-0.089125, -0.847969, 0.522499>, <-0.086912, -0.826915, 0.555570> }
triangle { <-0.089125, -0.847969, 0.522499>, <-0.044624, -0.851472, 0.522499>, <-0.045663, -0.871300, 0.488621> }
triangle { <-0.045663, -0.871300, 0.488621>, <-0.091201, -0.867716, 0.488621>, <-0.089125, -0.847969, 0.522499> }
triangle { <-0.091201, -0.867716, 0.488621>, <-0.045663, -0.871300, 0.488621>, <-0.046632, -0.889785, 0.453990> }
triangle { <-0.046632, -0.889785, 0.453990>, <-0.093136, -0.886125, 0.453990>, <-0.091201, -0.867716, 0.488621> }
triangle { <-0.093136, -0.886125, 0.453990>, <-0.046632, -0.889785, 0.453990>, <-0.047529, -0.906899, 0.418660> }
triangle { <-0.047529, -0.906899, 0.418660>, <-0.094927, -0.903168, 0.418660>, <-0.093136, -0.886125, 0.453990> }
triangle { <-0.094927, -0.903168, 0.418660>, <-0.047529, -0.906899, 0.418660>, <-0.048352, -0.922613, 0.382683> }
triangle { <-0.048352, -0.922613, 0.382683>, <-0.096572, -0.918818, 0.382683>, <-0.094927, -0.903168, 0.418660> }
triangle { <-0.096572, -0.918818, 0.382683>, <-0.048352, -0.922613, 0.382683>, <-0.049101, -0.936906, 0.346117> }
triangle { <-0.049101, -0.936906, 0.346117>, <-0.098068, -0.933052, 0.346117>, <-0.096572, -0.918818, 0.382683> }
triangle { <-0.098068, -0.933052, 0.346117>, <-0.049101, -0.936906, 0.346117>, <-0.049774, -0.949753, 0.309017> }
triangle { <-0.049774, -0.949753, 0.309017>, <-0.099412, -0.945847, 0.309017>, <-0.098068, -0.933052, 0.346117> }
triangle { <-0.099412, -0.945847, 0.309017>, <-0.049774, -0.949753, 0.309017>, <-0.050371, -0.961136, 0.271440> }
triangle { <-0.050371, -0.961136, 0.271440>, <-0.100604, -0.957183, 0.271440>, <-0.099412, -0.945847, 0.309017> }
triangle { <-0.100604, -0.957183, 0.271440>, <-0.050371, -0.961136, 0.271440>, <-0.050890, -0.971037, 0.233445> }
triangle { <-0.050890, -0.971037, 0.233445>, <-0.101640, -0.967043, 0.233445>, <-0.100604, -0.957183, 0.271440> }
triangle { <-0.101640, -0.967043, 0.233445>, <-0.050890, -0.971037, 0.233445>, <-0.051330, -0.979441, 0.195090> }
triangle { <-0.051330, -0.979441, 0.195090>, <-0.102520, -0.975412, 0.195090>, <-0.101640, -0.967043, 0.233445> }
triangle { <-0.102520, -0.975412, 0.195090>, <-0.051330, -0.979441, 0.195090>, <-0.051692, -0.986335, 0.156434> }
triangle { <-0.051692, -0.986335, 0.156434>, <-0.103242, -0.982278, 0.156434>, <-0.102520, -0.975412, 0.195090> }
triangle { <-0.103242, -0.982278, 0.156434>, <-0.051692, -0.986335, 0.156434>, <-0.051973, -0.991707, 0.117537> }
triangle { <-0.051973, -0.991707, 0.117537>, <-0.103804, -0.987628, 0.117537>, <-0.103242, -0.982278, 0.156434> }
triangle { <-0.103804, -0.987628, 0.117537>, <-0.051973, -0.991707, 0.117537>, <-0.052175, -0.995551, 0.078459> }
triangle { <-0.052175, -0.995551, 0.078459>, <-0.104206, -0.991456, 0.078459>, <-0.103804, -0.987628, 0.117537> }
triangle { <-0.104206, -0.991456, 0.078459>, <-0.052175, -0.995551, 0.078459>, <-0.052296, -0.997860, 0.039260> }
triangle { <-0.052296, -0.997860, 0.039260>, <-0.104448, -0.993755, 0.039260>, <-0.104206, -0.991456, 0.078459> }
triangle { <-0.104448, -0.993755, 0.039260>, <-0.052296, -0.997860, 0.039260>, <-0.052336, -0.998630, -0.000000> }
triangle { <-0.052336, -0.998630, -0.000000>, <-0.104528, -0.994522, -0.000000>, <-0.104448, -0.993755, 0.039260> }
triangle { <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.000000, -0.039260, 0.999229> }
triangle { <0.000000, -0.039260, 0.999229>, <-0.002055, -0.039206, 0.999229>, <0.000000, 0.000000, 1.000000> }
triangle { <-0.002055, -0.039206, 0.999229>, <0.000000, -0.039260, 0.999229>, <0.000000, -0.078459, 0.996917> }
triangle { <0.000000, -0.078459, 0.996917>, <-0.004106, -0.078352, 0.996917>, <-0.002055, -0.039206, 0.999229> }
triangle { <-0.004106, -0.078352, 0.996917>, <0.000000, -0.078459, 0.996917>, <0.000000, -0.117537, 0.993068> }
triangle { <0.000000, -0.117537, 0.993068>, <-0.006151, -0.117376, 0.993068>, <-0.004106, -0.078352, 0.996917> }
triangle { <-0.006151, -0.117376, 0.993068>, <0.000000, -0.117537, 0.993068>, <0.000000, -0.156434, 0.987688> }
triangle { <0.000000, -0.156434, 0.987688>, <-0.008187, -0.156220, 0.987688>, <-0.006151, -0.117376, 0.993068> }
triangle { <-0.008187, -0.156220, 0.987688>, <0.000000, -0.156434, 0.987688>, <0.000000, -0.195090, 0.980785> }
triangle { <0.000000, -0.195090, 0.980785>, <-0.010210, -0.194823, 0.980785>, <-0.008187, -0.156220, 0.987688> }
triangle { <-0.010210, -0.194823, 0.980785>, <0.000000, -0.195090, 0.980785>, <0.000000, -0.233445, 0.972370> }
triangle { <0.000000, -0.233445, 0.972370>, <-0.012218, -0.233125, 0.972370>, <-0.010210, -0.194823, 0.980785> }
triangle { <-0.012218, -0.233125, 0.972370>, <0.000000, -0.233445, 0.972370>, <0.000000, -0.271440, 0.962455> }
triangle { <0.000000, -0.271440, 0.962455>, <-0.014206, -0.271068, 0.962455>, <-0.012218, -0.233125, 0.972370> }
triangle { <-0.014206, -0.271068, 0.962455>, <0.000000, -0.271440, 0.962455>, <0.000000, -0.309017, 0.951057> }
triangle { <0.000000, -0.309017, 0.951057>, <-0.016173, -0.308593, 0.951057>, <-0.014206, -0.271068, 0.962455> }
triangle { <-0.016173, -0.308593, 0.951057>, <0.000000, -0.309017, 0.951057>, <0.000000, -0.346117, 0.938191> }
triangle { <0.000000, -0.346117, 0.938191>, <-0.018114, -0.345643, 0.938191>, <-0.016173, -0.308593, 0.951057> }
triangle { <-0.018114, -0.345643, 0.938191>, <0.000000, -0.346117, 0.938191>, <0.000000, -0.382683, 0.923880> }
triangle { <0.000000, -0.382683, 0.923880>, <-0.020028, -0.382159, 0.923880>, <-0.018114, -0.345643, 0.938191> }
triangle { <-0.020028, -0.382159, 0.923880>, <0.000000, -0.382683, 0.923880>, <0.000000, -0.418660, 0.908143> }
triangle { <0.000000, -0.418660, 0.908143>, <-0.021911, -0.418086, 0.908143>, <-0.020028, -0.382159, 0.923880> }
triangle { <-0.021911, -0.418086, 0.908143>, <0.000000, -0.418660, 0.908143>, <0.000000, -0.453990, 0.891007> }
triangle { <0.000000, -0.453990, 0.891007>, <-0.023760, -0.453368, 0.891007>, <-0.021911, -0.418086, 0.908143> }
triangle { <-0.023760, -0.453368, 0.891007>, <0.000000, -0.453990, 0.891007>, <0.000000, -0.488621, 0.872496> }
triangle { <0.000000, -0.488621, 0.872496>, <-0.025572, -0.487952, 0.872496>, <-0.023760, -0.453368, 0.891007> }
triangle { <-0.025572, -0.487952, 0.872496>, <0.000000, -0.488621, 0.872496>, <0.000000, -0.522499, 0.852640> }
triangle { <0.000000, -0.522499, 0.852640>, <-0.027345, -0.521782, 0.852640>, <-0.025572, -0.487952, 0.872496> }
triangle { <-0.027345, -0.521782, 0.852640>, <0.000000, -0.522499, 0.852640>, <0.000000, -0.555570, 0.831470> }
triangle { <0.000000, -0.555570, 0.831470>, <-0.029076, -0.554809, 0.831470>, <-0.027345, -0.521782, 0.852640> }
triangle { <-0.029076, -0.554809, 0.831470>, <0.000000, -0.555570, 0.831470>, <0.000000, -0.587785, 0.809017> }
triangle { <0.000000, -0.587785, 0.809017>, <-0.030762, -0.586980, 0.809017>, <-0.029076, -0.554809, 0.831470> }
triangle { <-0.030762, -0.586980, 0.809017>, <0.000000, -0.587785, 0.809017>, <0.000000, -0.619094, 0.785317> }
triangle { <0.000000, -0.619094, 0.785317>, <-0.032401, -0.618246, 0.785317>, <-0.030762, -0.586980, 0.809017> }
triangle { <-0.032401, -0.618246, 0.785317>, <0.000000, -0.619094, 0.785317>, <0.000000, -0.649448, 0.760406> }
triangle { <0.000000, -0.649448, 0.760406>, <-0.033989, -0.648558, 0.760406>, <-0.032401, -0.618246, 0.785317> }
triangle { <-0.033989, -0.648558, 0.760406>, <0.000000, -0.649448, 0.760406>, <0.000000, -0.678801, 0.734323> }
triangle { <0.000000, -0.678801, 0.734323>, <-0.035526, -0.677870, 0.734323>, <-0.033989, -0.648558, 0.760406> }
triangle { <-0.035526, -0.677870, 0.734323>, <0.000000, -0.678801, 0.734323>, <0.000000, -0.707107, 0.707107> }
triangle { <0.000000, -0.707107, 0.707107>, <-0.037007, -0.706138, 0.707107>, <-0.035526, -0.677870, 0.734323> }
triangle { <-0.037007, -0.706138, 0.707107>, <0.000000, -0.707107, 0.707107>, <0.000000, -0.734323, 0.678801> }
triangle { <0.000000, -0.734323, 0.678801>, <-0.038431, -0.733316, 0.678801>, <-0.037007, -0.706138, 0.707107> }
triangle { <-0.038431, -0.733316, 0.678801>, <0.000000, -0.734323, 0.678801>, <0.000000, -0.760406, 0.649448> }
triangle { <0.000000, -0.760406, 0.649448>, <-0.039797, -0.759364, 0.649448>, <-0.038431, -0.733316, 0.678801> }
triangle { <-0.039797, -0.759364, 0.649448>, <0.000000, -0.760406, 0.649448>, <0.000000, -0.785317, 0.619094> }
triangle { <0.000000, -0.785317, 0.619094>, <-0.041100, -0.784241, 0.619094>, <-0.039797, -0.759364, 0.649448> }
triangle { <-0.041100, -0.784241, 0.619094>, <0.000000, -0.785317, 0.619094>, <0.000000, -0.809017, 0.587785> }
triangle { <0.000000, -0.809017, 0.587785>, <-0.042341, -0.807908, 0.587785>, <-0.041100, -0.784241, 0.619094> }
triangle { <-0.042341, -0.807908, 0.587785>, <0.000000, -0.809017, 0.587785>, <0.000000, -0.831470, 0.555570> }
triangle { <0.000000, -0.831470, 0.555570>, <-0.043516, -0.830330, 0.555570>, <-0.042341, -0.807908, 0.587785> }
triangle { <-0.043516, -0.830330, 0.555570>, <0.000000, -0.831470, 0.555570>, <0.000000, -0.852640, 0.522499> }
triangle { <0.000000, -0.852640, 0.522499>, <-0.044624, -0.851472, 0.522499>, <-0.043516, -0.830330, 0.555570> }
triangle { <-0.044624, -0.851472, 0.522499>, <0.000000, -0.852640, 0.522499>, <0.000000, -0.872496, 0.488621> }
triangle { <0.000000, -0.872496, 0.488621>, <-0.045663, -0.871300, 0.488621>, <-0.044624, -0.851472, 0.522499> }
triangle { <-0.045663, -0.871300, 0.488621>, <0.000000, -0.872496, 0.488621>, <0.000000, -0.891007, 0.453990> }
triangle { <0.000000, -0.891007, 0.453990>, <-0.046632, -0.889785, 0.453990>, <-0.045663, -0.871300, 0.488621> }
triangle { <-0.046632, -0.889785, 0.453990>, <0.000000, -0.891007, 0.453990>, <0.000000, -0.908143, 0.418660> }
triangle { <0.000000, -0.908143, 0.418660>, <-0.047529, -0.906899, 0.418660>, <-0.046632, -0.889785, 0.453990> }
triangle { <-0.047529, -0.906899, 0.418660>, <0.000000, -0.908143, 0.418660>, <0.000000, -0.923880, 0.382683> }
triangle { <0.000000, -0.923880, 0.382683>, <-0.048352, -0.922613, 0.382683>, <-0.047529, -0.906899, 0.418660> }
triangle { <-0.048352, -0.922613, 0.382683>, <0.000000, -0.923880, 0.382683>, <0.000000, -0.938191, 0.346117> }
triangle { <0.000000, -0.938191, 0.346117>, <-0.049101, -0.936906, 0.346117>, <-0.048352, -0.922613, 0.382683> }
triangle { <-0.049101, -0.936906, 0.346117>, <0.000000, -0.938191, 0.346117>, <0.000000, -0.951057, 0.309017> }
triangle { <0.000000, -0.951057, 0.309017>, <-0.049774, -0.949753, 0.309017>, <-0.049101, -0.936906, 0.346117> }
triangle { <-0.049774, -0.949753, 0.309017>, <0.000000, -0.951057, 0.309017>, <0.000000, -0.962455, 0.271440> }
triangle { <0.000000, -0.962455, 0.271440>, <-0.050371, -0.961136, 0.271440>, <-0.049774, -0.949753, 0.309017> }
triangle { <-0.050371, -0.961136, 0.271440>, <0.000000, -0.962455, 0.271440>, <0.000000, -0.972370, 0.233445> }
triangle { <0.000000, -0.972370, 0.233445>, <-0.050890, -0.971037, 0.233445>, <-0.050371, -0.961136, 0.271440> }
triangle { <-0.050890, -0.971037, 0.233445>, <0.000000, -0.972370, 0.233445>, <0.000000, -0.980785, 0.195090> }
triangle { <0.000000, -0.980785, 0.195090>, <-0.051330, -0.979441, 0.195090>, <-0.050890, -0.971037, 0.233445> }
triangle { <-0.051330, -0.979441, 0.195090>, <0.000000, -0.980785, 0.195090>, <0.000000, -0.987688, 0.156434> }
triangle { <0.000000, -0.987688, 0.156434>, <-0.051692, -0.986335, 0.156434>, <-0.051330, -0.979441, 0.195090> }
triangle { <-0.051692, -0.986335, 0.156434>, <0.000000, -0.987688, 0.156434>, <0.000000, -0.993068, 0.117537> }
triangle { <0.000000, -0.993068, 0.117537>, <-0.051973, -0.991707, 0.117537>, <-0.051692, -0.986335, 0.156434> }
triangle { <-0.051973, -0.991707, 0.117537>, <0.000000, -0.993068, 0.117537>, <0.000000, -0.996917, 0.078459> }
triangle { <0.000000, -0.996917, 0.078459>, <-0.052175, -0.995551, 0.078459>, <-0.051973, -0.991707, 0.117537> }
triangle { <-0.052175, -0.995551, 0.078459>, <0.000000, -0.996917, 0.078459>, <0.000000, -0.999229, 0.039260> }
triangle { <0.000000, -0.999229, 0.039260>, <-0.052296, -0.997860, 0.039260>, <-0.052175, -0.995551, 0.078459> }
triangle { <-0.052296, -0.997860, 0.039260>, <0.000000, -0.999229, 0.039260>, <0.000000, -1.000000, -0.000000> }
triangle { <0.000000, -1.000000, -0.000000>, <-0.052336, -0.998630, -0.000000>, <-0.052296, -0.997860, 0.039260> }
triangle { <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.002055, -0.039206, 0.999229> }
triangle { <0.002055, -0.039206, 0.999229>, <0.000000, -0.039260, 0.999229>, <0.000000, 0.000000, 1.000000> }
triangle { <0.000000, -0.039260, 0.999229>, <0.002055, -0.039206, 0.999229>, <0.004106, -0.078352, 0.996917> }
triangle { <0.004106, -0.078352, 0.996917>, <0.000000, -0.078459, 0.996917>, <0.000000, -0.039260, 0.999229> }
triangle { <0.000000, -0.078459, 0.996917>, <0.004106, -0.078352, 0.996917>, <0.006151, -0.117376, 0.993068> }
triangle { <0.006151, -0.117376, 0.993068>, <0.000000, -0.117537, 0.993068>, <0.000000, -0.078459, 0.996917> }
triangle { <0.000000, -0.117537, 0.993068>, <0.006151, -0.117376, 0.993068>, <0.008187, -0.156220, 0.987688> }
triangle { <0.008187, -0.156220, 0.987688>, <0.000000, -0.156434, 0.987688>, <0.000000, -0.117537, 0.993068> }
triangle { <0.000000, -0.156434, 0.987688>, <0.008187, -0.156220, 0.987688>, <0.010210, -0.194823, 0.980785> }
triangle { <0.010210, -0.194823, 0.980785>, <0.000000, -0.195090, 0.980785>, <0.000000, -0.156434, 0.987688> }
triangle { <0.000000, -0.195090, 0.980785>, <0.010210, -0.194823, 0.980785>, <0.012218, -0.233125, 0.972370> }
triangle { <0.012218, -0.233125, 0.972370>, <0.000000, -0.233445, 0.972370>, <0.000000, -0.195090, 0.980785> }
triangle { <0.000000, -0.233445, 0.972370>, <0.012218, -0.233125, 0.972370>, <0.014206, -0.271068, 0.962455> }
triangle { <0.014206, -0.271068, 0.962455>, <0.000000, -0.271440, 0.962455>, <0.000000, -0.233445, 0.972370> }
triangle { <0.000000, -0.271440, 0.962455>, <0.014206, -0.271068, 0.962455>, <0.016173, -0.308593, 0.951057> }
triangle { <0.016173, -0.308593, 0.951057>, <0.000000, -0.309017, 0.951057>, <0.000000, -0.271440, 0.962455> }
triangle { <0.000000, -0.309017, 0.951057>, <0.016173, -0.308593, 0.951057>, <0.018114, -0.345643, 0.938191> }
triangle { <0.018114, -0.345643, 0.938191>, <0.000000, -0.346117, 0.938191>, <0.000000, -0.309017, 0.951057> }
triangle { <0.000000, -0.346117, 0.938191>, <0.018114, -0.345643, 0.938191>, <0.020028, -0.382159, 0.923880> }
triangle { <0.020028, -0.382159, 0.923880>, <0.000000, -0.382683, 0.923880>, <0.000000, -0.346117, 0.938191> }
triangle { <0.000000, -0.382683, 0.923880>, <0.020028, -0.382159, 0.923880>, <0.021911, -0.418086, 0.908143> }
triangle { <0.021911, -0.418086, 0.908143>, <0.000000, -0.418660, 0.908143>, <0.000000, -0.382683, 0.923880> }
triangle { <0.000000, -0.418660, 0.908143>, <0.021911, -0.418086, 0.908143>, <0.023760, -0.453368, 0.891007> }
triangle { <0.023760, -0.453368, 0.891007>, <0.000000, -0.453990, 0.891007>, <0.000000, -0.418660, 0.908143> }
triangle { <0.000000, -0.453990, 0.891007>, <0.023760, -0.453368, 0.891007>, <0.025572, -0.487952, 0.872496> }
triangle { <0.025572, -0.487952, 0.872496>, <0.000000, -0.488621, 0.872496>, <0.000000, -0.453990, 0.891007> }
triangle { <0.000000, -0.488621, 0.872496>, <0.025572, -0.487952, 0.872496>, <0.027345, -0.521782, 0.852640> }
triangle { <0.027345, -0.521782, 0.852640>, <0.000000, -0.522499, 0.852640>, <0.000000, -0.488621, 0.872496> }
triangle { <0.000000, -0.522499, 0.852640>, <0.027345, -0.521782, 0.852640>, <0.029076, -0.554809, 0.831470> }
triangle { <0.029076, -0.554809, 0.831470>, <0.000000, -0.555570, 0.831470>, <0.000000, -0.522499, 0.852640> }
triangle { <0.000000, -0.555570, 0.831470>, <0.029076, -0.554809, 0.831470>, <0.030762, -0.586980, 0.809017> }
triangle { <0.030762, -0.586980, 0.809017>, <0.000000, -0.587785, 0.809017>, <0.000000, -0.555570, 0.831470> }
triangle { <0.000000, -0.587785, 0.809017>, <0.030762, -0.586980, 0.809017>, <0.032401, -0.618246, 0.785317> }
triangle { <0.032401, -0.618246, 0.785317>, <0.000000, -0.619094, 0.785317>, <0.000000, -0.587785, 0.809017> }
triangle { <0.000000, -0.619094, 0.785317>, <0.032401, -0.618246, 0.785317>, <0.033989, -0.648558, 0.760406> }
triangle { <0.033989, -0.648558, 0.760406>, <0.000000, -0.649448, 0.760406>, <0.000000, -0.619094, 0.785317> }
triangle { <0.000000, -0.649448, 0.760406>, <0.033989, -0.648558, 0.760406>, <0.035526, -0.677870, 0.734323> }
triangle { <0.035526, -0.677870, 0.734323>, <0.000000, -0.678801, 0.734323>, <0.000000, -0.649448, 0.760406> }
triangle { <0.000000, -0.678801, 0.734323>, <0.035526, -0.677870, 0.734323>, <0.037007, -0.706138, 0.707107> }
triangle { <0.037007, -0.706138, 0.707107>, <0.000000, -0.707107, 0.707107>, <0.000000, -0.678801, 0.734323> }
triangle { <0.000000, -0.707107, 0.707107>, <0.037007, -0.706138, 0.707107>, <0.038431, -0.733316, 0.678801> }
triangle { <0.038431, -0.733316, 0.678801>, <0.000000, -0.734323, 0.678801>, <0.000000, -0.707107, 0.707107> }
triangle { <0.000000, -0.734323, 0.678801>, <0.038431, -0.733316, 0.678801>, <0.039797, -0.759364, 0.649448> }
triangle { <0.039797, -0.759364, 0.649448>, <0.000000, -0.760406, 0.649448>, <0.000000, -0.734323, 0.678801> }
triangle { <0.000000, -0.760406, 0.649448>, <0.039797, -0.759364, 0.649448>, <0.041100, -0.784241, 0.619094> }
triangle { <0.041100, -0.784241, 0.619094>, <0.000000, -0.785317, 0.619094>, <0.000000, -0.760406, 0.649448> }
triangle { <0.000000, -0.785317, 0.619094>, <0.041100, -0.784241, 0.619094>, <0.042341, -0.807908, 0.587785> }
triangle { <0.042341, -0.807908, 0.587785>, <0.000000, -0.809017, 0.587785>, <0.000000, -0.785317, 0.619094> }
triangle { <0.000000, -0.809017, 0.587785>, <0.042341, -0.807908, 0.587785>, <0.043516, -0.830330, 0.555570> }
triangle { <0.043516, -0.830330, 0.555570>, <0.000000, -0.831470, 0.555570>, <0.000000, -0.809017, 0.587785> }
triangle { <0.000000, -0.831470, 0.555570>, <0.043516, -0.830330, 0.555570>, <0.044624, -0.851472, 0.522499> }
triangle { <0.044624, -0.851472, 0.522499>, <0.000000, -0.852640, 0.522499>, <0.000000, -0.831470, 0.555570> }
triangle { <0.000000, -0.852640, 0.522499>, <0.044624, -0.851472, 0.522499>, <0.045663, -0.871300, 0.488621> }
triangle { <0.045663, -0.871300, 0.488621>, <0.000000, -0.872496, 0.488621>, <0.000000, -0.852640, 0.522499> }
triangle { <0.000000, -0.872496, 0.488621>, <0.045663, -0.871300, 0.488621>, <0.046632, -0.889785, 0.453990> }
triangle { <0.046632, -0.889785, 0.453990>, <0.000000, -0.891007, 0.453990>, <0.000000, -0.872496, 0.488621> }
triangle { <0.000000, -0.891007, 0.453990>, <0.046632, -0.889785, 0.453990>, <0.047529, -0.906899, 0.418660> }
triangle { <0.047529, -0.906899, 0.418660>, <0.000000, -0.908143, 0.418660>, <0.000000, -0.891007, 0.453990> }
triangle { <0.000000, -0.908143, 0.418660>, <0.047529, -0.906899, 0.418660>, <0.048352, -0.922613, 0.382683> }
triangle { <0.048352, -0.922613, 0.382683>, <0.000000, -0.923880, 0.382683>, <0.000000, -0.908143, 0.418660> }
triangle { <0.000000, -0.923880, 0.382683>, <0.048352, -0.922613, 0.382683>, <0.049101, -0.936906, 0.346117> }
triangle { <0.049101, -0.936906, 0.346117>, <0.000000, -0.938191, 0.346117>, <0.000000, -0.923880, 0.382683> }
triangle { <0.000000, -0.938191, 0.346117>, <0.049101, -0.936906, 0.346117>, <0.049774, -0.949753, 0.309017> }
triangle { <0.049774, -0.949753, 0.309017>, <0.000000, -0.951057, 0.309017>, <0.000000, -0.938191, 0.346117> }
triangle { <0.000000, -0.951057, 0.309017>, <0.049774, -0.949753, 0.309017>, <0.050371, -0.961136, 0.271440> }
triangle { <0.050371, -0.961136, 0.271440>, <0.000000, -0.962455, 0.271440>, <0.000000, -0.951057, 0.309017> }
triangle { <0.000000, -0.962455, 0.271440>, <0.050371, -0.961136, 0.271440>, <0.050890, -0.971037, 0.233445> }
triangle { <0.050890, -0.971037, 0.233445>, <0.000000, -0.972370, 0.233445>, <0.000000, -0.962455, 0.271440> }
triangle { <0.000000, -0.972370, 0.233445>, <0.050890, -0.971037, 0.233445>, <0.051330, -0.979441, 0.195090> }
triangle { <0.051330, -0.979441, 0.195090>, <0.000000, -0.980785, 0.195090>, <0.000000, -0.972370, 0.233445> }
triangle { <0.000000, -0.980785, 0.195090>, <0.051330, -0.979441, 0.195090>, <0.051692, -0.986335, 0.156434> }
triangle { <0.051692, -0.986335, 0.156434>, <0.000000, -0.987688, 0.156434>, <0.000000, -0.980785, 0.195090> }
triangle { <0.000000, -0.987688, 0.156434>, <0.051692, -0.986335, 0.156434>, <0.051973, -0.991707, 0.117537> }
triangle { <0.051973, -0.991707, 0.117537>, <0.000000, -0.993068, 0.117537>, <0.000000, -0.987688, 0.156434> }
triangle { <0.000000, -0.993068, 0.117537>, <0.051973, -0.991707, 0.117537>, <0.052175, -0.995551, 0.078459> }
triangle { <0.052175, -0.995551, 0.078459>, <0.000000, -0.996917, 0.078459>, <0.000000, -0.993068, 0.117537> }
triangle { <0.000000, -0.996917, 0.078459>, <0.052175, -0.995551, 0.078459>, <0.052296, -0.997860, 0.039260> }
triangle { <0.052296, -0.997860, 0.039260>, <0.000000, -0.999229, 0.039260>, <0.000000, -0.996917, 0.078459> }
triangle { <0.000000, -0.999229, 0.039260>, <0.052296, -0.997860, 0.039260>, <0.052336, -0.998630, -0.000000> }
triangle { <0.052336, -0.998630, -0.000000>, <0.000000, -1.000000, -0.000000>, <0.000000, -0.999229, 0.039260> }
triangle { <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.004104, -0.039045, 0.999229> }
triangle { <0.004104, -0.039045, 0.999229>, <0.002055, -0.039206, 0.999229>, <0.000000, 0.000000, 1.000000> }
triangle { <0.002055, -0.039206, 0.999229>, <0.004104, -0.039045, 0.999229>, <0.008201, -0.078029, 0.996917> }
triangle { <0.008201, -0.078029, 0.996917>, <0.004106, -0.078352, 0.996917>, <0.002055, -0.039206, 0.999229> }
triangle { <0.004106, -0.078352, 0.996917>, <0.008201, -0.078029, 0.996917>, <0.012286, -0.116894, 0.993068> }
triangle { <0.012286, -0.116894, 0.993068>, <0.006151, -0.117376, 0.993068>, <0.004106, -0.078352, 0.996917> }
triangle { <0.006151, -0.117376, 0.993068>, <0.012286, -0.116894, 0.993068>, <0.016352, -0.155578, 0.987688> }
triangle { <0.016352, -0.155578, 0.987688>, <0.008187, -0.156220, 0.987688>, <0.006151, -0.117376, 0.993068> }
triangle { <0.008187, -0.156220, 0.987688>, <0.016352, -0.155578, 0.987688>, <0.020392, -0.194022, 0.980785> }
triangle { <0.020392, -0.194022, 0.980785>, <0.010210, -0.194823, 0.980785>, <0.008187, -0.156220, 0.987688> }
triangle { <0.010210, -0.194823, 0.980785>, <0.020392, -0.194022, 0.980785>, <0.024402, -0.232167, 0.972370> }
triangle { <0.024402, -0.232167, 0.972370>, <0.012218, -0.233125, 0.972370>, <0.010210, -0.194823, 0.980785> }
triangle { <0.012218, -0.233125, 0.972370>, <0.024402, -0.232167, 0.972370>, <0.028373, -0.269953, 0.962455> }
triangle { <0.028373, -0.269953, 0.962455>, <0.014206, -0.271068, 0.962455>, <0.012218, -0.233125, 0.972370> }
triangle { <0.014206, -0.271068, 0.962455>, <0.028373, -0.269953, 0.962455>, <0.032301, -0.307324, 0.951057> }
triangle { <0.032301, -0.307324, 0.951057>, <0.016173, -0.308593, 0.951057>, <0.014206, -0.271068, 0.962455> }
triangle { <0.016173, -0.308593, 0.951057>, <0.032301, -0.307324, 0.951057>, <0.036179, -0.344221, 0.938191> }
triangle { <0.036179, -0.344221, 0.938191>, <0.018114, -0.345643, 0.938191>, <0.016173, -0.308593, 0.951057> }
triangle { <0.018114, -0.345643, 0.938191>, <0.036179, -0.344221, 0.938191>, <0.040001, -0.380587, 0.923880> }
triangle { <0.040001, -0.380587, 0.923880>, <0.020028, -0.382159, 0.923880>, <0.018114, -0.345643, 0.938191> }
triangle { <0.020028, -0.382159, 0.923880>, <0.040001, -0.380587, 0.923880>, <0.043762, -0.416366, 0.908143> }
triangle { <0.043762, -0.416366, 0.908143>, <0.021911, -0.418086, 0.908143>, <0.020028, -0.382159, 0.923880> }
triangle { <0.021911, -0.418086, 0.908143>, <0.043762, -0.416366, 0.908143>, <0.047455, -0.451503, 0.891007> }
triangle { <0.047455, -0.451503, 0.891007>, <0.023760, -0.453368, 0.891007>, <0.021911, -0.418086, 0.908143> }
triangle { <0.023760, -0.453368, 0.891007>, <0.047455, -0.451503, 0.891007>, <0.051075, -0.485945, 0.872496> }
triangle { <0.051075, -0.485945, 0.872496>, <0.025572, -0.487952, 0.872496>, <0.023760, -0.453368, 0.891007> }
triangle { <0.025572, -0.487952, 0.872496>, <0.051075, -0.485945, 0.872496>, <0.054616, -0.519636, 0.852640> }
triangle { <0.054616, -0.519636, 0.852640>, <0.027345, -0.521782, 0.852640>, <0.025572, -0.487952, 0.872496> }
triangle { <0.027345, -0.521782, 0.852640>, <0.054616, -0.519636, 0.852640>, <0.058073, -0.552527, 0.831470> }
triangle { <0.058073, -0.552527, 0.831470>, <0.029076, -0.554809, 0.831470>, <0.027345, -0.521782, 0.852640> }
triangle { <0.029076, -0.554809, 0.831470>, <0.058073, -0.552527, 0.831470>, <0.061440, -0.584565, 0.809017> }
triangle { <0.061440, -0.584565, 0.809017>, <0.030762, -0.586980, 0.809017>, <0.029076, -0.554809, 0.831470> }
triangle { <0.030762, -0.586980, 0.809017>, <0.061440, -0.584565, 0.809017>, <0.064713, -0.615702, 0.785317> }
triangle { <0.064713, -0.615702, 0.785317>, <0.032401, -0.618246, 0.785317>, <0.030762, -0.586980, 0.809017> }
triangle { <0.032401, -0.618246, 0.785317>, <0.064713, -0.615702, 0.785317>, <0.067886, -0.645890, 0.760406> }
triangle { <0.067886, -0.645890, 0.760406>, <0.033989, -0.648558, 0.760406>, <0.032401, -0.618246, 0.785317> }
triangle { <0.033989, -0.648558, 0.760406>, <0.067886, -0.645890, 0.760406>, <0.070954, -0.675082, 0.734323> }
triangle { <0.070954, -0.675082, 0.734323>, <0.035526, -0.677870, 0.734323>, <0.033989, -0.648558, 0.760406> }
triangle { <0.035526, -0.677870, 0.734323>, <0.070954, -0.675082, 0.734323>, <0.073913, -0.703233, 0.707107> }
triangle { <0.073913, -0.703233, 0.707107>, <0.037007, -0.706138, 0.707107>, <0.035526, -0.677870, 0.734323> }
triangle { <0.037007, -0.706138, 0.707107>, <0.073913, -0.703233, 0.707107>, <0.076758, -0.730300, 0.678801> }
triangle { <0.076758, -0.730300, 0.678801>, <0.038431, -0.733316, 0.678801>, <0.037007, -0.706138, 0.707107> }
triangle { <0.038431, -0.733316, 0.678801>, <0.076758, -0.730300, 0.678801>, <0.079484, -0.756240, 0.649448> }
triangle { <0.079484, -0.756240, 0.649448>, <0.039797, -0.759364, 0.649448>, <0.038431, -0.733316, 0.678801> }
triangle { <0.039797, -0.759364, 0.649448>, <0.079484, -0.756240, 0.649448>, <0.082088, -0.781015, 0.619094> }
triangle { <0.082088, -0.781015, 0.619094>, <0.041100, -0.784241, 0.619094>, <0.039797, -0.759364, 0.649448> }
triangle { <0.041100, -0.784241, 0.619094>, <0.082088, -0.781015, 0.619094>, <0.084565, -0.804585, 0.587785> }
triangle { <0.084565, -0.804585, 0.587785>, <0.042341, -0.807908, 0.587785>, <0.041100, -0.784241, 0.619094> }
triangle { <0.042341, -0.807908, 0.587785>, <0.084565, -0.804585, 0.587785>, <0.086912, -0.826915, 0.555570> }
triangle { <0.086912, -0.826915, 0.555570>, <0.043516, -0.830330, 0.555570>, <0.042341, -0.807908, 0.587785> }
triangle { <0.043516, -0.830330, 0.555570>, <0.086912, -0.826915, 0.555570>, <0.089125, -0.847969, 0.522499> }
triangle { <0.089125, -0.847969, 0.522499>, <0.044624, -0.851472, 0.522499>, <0.043516, -0.830330, 0.555570> }
triangle { <0.044624, -0.851472, 0.522499>, <0.089125, -0.847969, 0.522499>, <0.091201, -0.867716, 0.488621> }
triangle { <0.091201, -0.867716, 0.488621>, <0.045663, -0.871300, 0.488621>, <0.044624, -0.851472, 0.522499> }
triangle { <0.045663, -0.871300, 0.488621>, <0.091201, -0.867716, 0.488621>, <0.093136, -0.886125, 0.453990> }
triangle { <0.093136, -0.886125, 0.453990>, <0.046632, -0.889785, 0.453990>, <0.045663, -0.871300, 0.488621> }
triangle { <0.046632, -0.889785, 0.453990>, <0.093136, -0.886125, 0.453990>, <0.094927, -0.903168, 0.418660> }
triangle { <0.094927, -0.903168, 0.418660>, <0.047529, -0.906899, 0.418660>, <0.046632, -0.889785, 0.453990> }
triangle { <0.047529, -0.906899, 0.418660>, <0.094927, -0.903168, 0.418660>, <0.096572, -0.918818, 0.382683> }
triangle { <0.096572, -0.918818, 0.382683>, <0.048352, -0.922613, 0.382683>, <0.047529, -0.906899, 0.418660> }
triangle { <0.048352, -0.922613, 0.382683>, <0.096572, -0.918818, 0.382683>, <0.098068, -0.933052, 0.346117> }
triangle { <0.098068, -0.933052, 0.346117>, <0.049101, -0.936906, 0.346117>, <0.048352, -0.922613, 0.382683> }
triangle { <0.049101, -0.936906, 0.346117>, <0.098068, -0.933052, 0.346117>, <0.099412, -0.945847, 0.309017> }
triangle { <0.099412, -0.945847, 0.309017>, <0.049774, -0.949753, 0.309017>, <0.049101, -0.936906, 0.346117> }
triangle { <0.049774, -0.949753, 0.309017>, <0.099412, -0.945847, 0.309017>, <0.100604, -0.957183, 0.271440> }
triangle { <0.100604, -0.957183, 0.271440>, <0.050371, -0.961136, 0.271440>, <0.049774, -0.949753, 0.309017> }
triangle { <0.050371, -0.961136, 0.271440>, <0.100604, -0.957183, 0.271440>, <0.101640, -0.967043, 0.233445> }
triangle { <0.101640, -0.967043, 0.233445>, <0.050890, -0.971037, 0.233445>, <0.050371, -0.961136, 0.271440> }
triangle { <0.050890, -0.971037, 0.233445>, <0.101640, -0.967043, 0.233445>, <0.102520, -0.975412, 0.195090> }
triangle { <0.102520, -0.975412, 0.195090>, <0.051330, -0.979441, 0.195090>, <0.050890, -0.971037, 0.233445> }
triangle { <0.051330, -0.979441, 0.195090>, <0.102520, -0.975412, 0.195090>, <0.103242, -0.982278, 0.156434> }
triangle { <0.103242, -0.982278, 0.156434>, <0.051692, -0.986335, 0.156434>, <0.051330, -0.979441, 0.195090> }
triangle { <0.051692, -0.986335, 0.156434>, <0.103242, -0.982278, 0.156434>, <0.103804, -0.987628, 0.117537> }
triangle { <0.103804, -0.987628, 0.117537>, <0.051973, -0.991707, 0.117537>, <0.051692, -0.986335, 0.156434> }
triangle { <0.051973, -0.991707, 0.117537>, <0.103804, -0.987628, 0.117537>, <0.104206, -0.991456, 0.078459> }
triangle { <0.104206, -0.991456, 0.078459>, <0.052175, -0.995551, 0.078459>, <0.051973, -0.991707, 0.117537> }
triangle { <0.052175, -0.995551, 0.078459>, <0.104206, -0.991456, 0.078459>, <0.104448, -0.993755, 0.039260> }
triangle { <0.104448, -0.993755, 0.039260>, <0.052296, -0.997860, 0.039260>, <0.052175, -0.995551, 0.078459> }
triangle { <0.052296, -0.997860, 0.039260>, <0.104448, -0.993755, 0.039260>, <0.104528, -0.994522, -0.000000> }
triangle { <0.104528, -0.994522, -0.000000>, <0.052336, -0.998630, -0.000000>, <0.052296, -0.997860, 0.039260> }
triangle { <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.006142, -0.038776, 0.999229> }
triangle { <0.006142, -0.038776, 0.999229>, <0.004104, -0.039045, 0.999229>, <0.000000, 0.000000, 1.000000> }
triangle { <0.004104, -0.039045, 0.999229>, <0.006142, -0.038776, 0.999229>, <0.012274, -0.077493, 0.996917> }
triangle { <0.012274, -0.077493, 0.996917>, <0.008201, -0.078029, 0.996917>, <0.004104, -0.039045, 0.999229> }
triangle { <0.008201, -0.078029, 0.996917>, <0.012274, -0.077493, 0.996917>, <0.018387, -0.116090, 0.993068> }
triangle { <0.018387, -0.116090, 0.993068>, <0.012286, -0.116894, 0.993068>, <0.008201, -0.078029, 0.996917> }
triangle { <0.012286, -0.116894, 0.993068>, <0.018387, -0.116090, 0.993068>, <0.024472, -0.154508, 0.987688> }
triangle { <0.024472, -0.154508, 0.987688>, <0.016352, -0.155578, 0.987688>, <0.012286, -0.116894, 0.993068> }
triangle { <0.016352, -0.155578, 0.987688>, <0.024472, -0.154508, 0.987688>, <0.030519, -0.192688, 0.980785> }
triangle { <0.030519, -0.192688, 0.980785>, <0.020392, -0.194022, 0.980785>, <0.016352, -0.155578, 0.987688> }
triangle { <0.020392, -0.194022, 0.980785>, <0.030519, -0.192688, 0.980785>, <0.036519, -0.230571, 0.972370> }
triangle { <0.036519, -0.230571, 0.972370>, <0.024402, -0.232167, 0.972370>, <0.020392, -0.194022, 0.980785> }
triangle { <0.024402, -0.232167, 0.972370>, <0.036519, -0.230571, 0.972370>, <0.042463, -0.268099, 0.962455> }
triangle { <0.042463, -0.268099, 0.962455>, <0.028373, -0.269953, 0.962455>, <0.024402, -0.232167, 0.972370> }
triangle { <0.028373, -0.269953, 0.962455>, <0.042463, -0.268099, 0.962455>, <0.048341, -0.305212, 0.951057> }
triangle { <0.048341, -0.305212, 0.951057>, <0.032301, -0.307324, 0.951057>, <0.028373, -0.269953, 0.962455> }
triangle { <0.032301, -0.307324, 0.951057>, <0.048341, -0.305212, 0.951057>, <0.054145, -0.341856, 0.938191> }
triangle { <0.054145, -0.341856, 0.938191>, <0.036179, -0.344221, 0.938191>, <0.032301, -0.307324, 0.951057> }
triangle { <0.036179, -0.344221, 0.938191>, <0.054145, -0.341856, 0.938191>, <0.059865, -0.377972, 0.923880> }
triangle { <0.059865, -0.377972, 0.923880>, <0.040001, -0.380587, 0.923880>, <0.036179, -0.344221, 0.938191> }
triangle { <0.040001, -0.380587, 0.923880>, <0.059865, -0.377972, 0.923880>, <0.065493, -0.413505, 0.908143> }
triangle { <0.065493, -0.413505, 0.908143>, <0.043762, -0.416366, 0.908143>, <0.040001, -0.380587, 0.923880> }
triangle { <0.043762, -0.416366, 0.908143>, <0.065493, -0.413505, 0.908143>, <0.071020, -0.448401, 0.891007> }
triangle { <0.071020, -0.448401, 0.891007>, <0.047455, -0.451503, 0.891007>, <0.043762, -0.416366, 0.908143> }
triangle { <0.047455, -0.451503, 0.891007>, <0.071020, -0.448401, 0.891007>, <0.076437, -0.482606, 0.872496> }
triangle { <0.076437, -0.482606, 0.872496>, <0.051075, -0.485945, 0.872496>, <0.047455, -0.451503, 0.891007> }
triangle { <0.051075, -0.485945, 0.872496>, <0.076437, -0.482606, 0.872496>, <0.081737, -0.516066, 0.852640> }
triangle { <0.081737, -0.516066, 0.852640>, <0.054616, -0.519636, 0.852640>, <0.051075, -0.485945, 0.872496> }
triangle { <0.054616, -0.519636, 0.852640>, <0.081737, -0.516066, 0.852640>, <0.086910, -0.548730, 0.831470> }
triangle { <0.086910, -0.548730, 0.831470>, <0.058073, -0.552527, 0.831470>, <0.054616, -0.519636, 0.852640> }
triangle { <0.058073, -0.552527, 0.831470>, <0.086910, -0.548730, 0.831470>, <0.091950, -0.580549, 0.809017> }
triangle { <0.091950, -0.580549, 0.809017>, <0.061440, -0.584565, 0.809017>, <0.058073, -0.552527, 0.831470> }
triangle { <0.061440, -0.584565, 0.809017>, <0.091950, -0.580549, 0.809017>, <0.096848, -0.611472, 0.785317> }
triangle { <0.096848, -0.611472, 0.785317>, <0.064713, -0.615702, 0.785317>, <0.061440, -0.584565, 0.809017> }
triangle { <0.064713, -0.615702, 0.785317>, <0.096848, -0.611472, 0.785317>, <0.101596, -0.641452, 0.760406> }
triangle { <0.101596, -0.641452, 0.760406>, <0.067886, -0.645890, 0.760406>, <0.064713, -0.615702, 0.785317> }
triangle { <0.067886, -0.645890, 0.760406>, <0.101596, -0.641452, 0.760406>, <0.106188, -0.670444, 0.734323> }
triangle { <0.106188, -0.670444, 0.734323>, <0.070954, -0.675082, 0.734323>, <0.067886, -0.645890, 0.760406> }
triangle { <0.070954, -0.675082, 0.734323>, <0.106188, -0.670444, 0.734323>, <0.110616, -0.698401, 0.707107> }
triangle { <0.110616, -0.698401, 0.707107>, <0.073913, -0.703233, 0.707107>, <0.070954, -0.675082, 0.734323> }
triangle { <0.073913, -0.703233, 0.707107>, <0.110616, -0.698401, 0.707107>, <0.114873, -0.725282, 0.678801> }
triangle { <0.114873, -0.725282, 0.678801>, <0.076758, -0.730300, 0.678801>, <0.073913, -0.703233, 0.707107> }
triangle { <0.076758, -0.730300, 0.678801>, <0.114873, -0.725282, 0.678801>, <0.118954, -0.751044, 0.649448> }
triangle { <0.118954, -0.751044, 0.649448>, <0.079484, -0.756240, 0.649448>, <0.076758, -0.730300, 0.678801> }
triangle { <0.079484, -0.756240, 0.649448>, <0.118954, -0.751044, 0.649448>, <0.122851, -0.775648, 0.619094> }
triangle { <0.122851, -0.775648, 0.619094>, <0.082088, -0.781015, 0.619094>, <0.079484, -0.756240, 0.649448> }
triangle { <0.082088, -0.781015, 0.619094>, <0.122851, -0.775648, 0.619094>, <0.126558, -0.799057, 0.587785> }
triangle { <0.126558, -0.799057, 0.587785>, <0.084565, -0.804585, 0.587785>, <0.082088, -0.781015, 0.619094> }
triangle { <0.084565, -0.804585, 0.587785>, <0.126558, -0.799057, 0.587785>, <0.130071, -0.821233, 0.555570> }
triangle { <0.130071, -0.821233, 0.555570>, <0.086912, -0.826915, 0.555570>, <0.084565, -0.804585, 0.587785> }
triangle { <0.086912, -0.826915, 0.555570>, <0.130071, -0.821233, 0.555570>, <0.133382, -0.842143, 0.522499> }
triangle { <0.133382, -0.842143, 0.522499>, <0.089125, -0.847969, 0.522499>, <0.086912, -0.826915, 0.555570> }
triangle { <0.089125, -0.847969, 0.522499>, <0.133382, -0.842143, 0.522499>, <0.136488, -0.861754, 0.488621> }
triangle { <0.136488, -0.861754, 0.488621>, <0.091201, -0.867716, 0.488621>, <0.089125, -0.847969, 0.522499> }
triangle { <0.091201, -0.867716, 0.488621>, <0.136488, -0.861754, 0.488621>, <0.139384, -0.880037, 0.453990> }
triangle { <0.139384, -0.880037, 0.453990>, <0.093136, -0.886125, 0.453990>, <0.091201, -0.867716, 0.488621> }
triangle { <0.093136, -0.886125, 0.453990>, <0.139384, -0.880037, 0.453990>, <0.142065, -0.896962, 0.418660> }
triangle { <0.142065, -0.896962, 0.418660>, <0.094927, -0.903168, 0.418660>, <0.093136, -0.886125, 0.453990> }
triangle { <0.094927, -0.903168, 0.418660>, <0.142065, -0.896962, 0.418660>, <0.144527, -0.912505, 0.382683> }
triangle { <0.144527, -0.912505, 0.382683>, <0.096572, -0.918818, 0.382683>, <0.094927, -0.903168, 0.418660> }
triangle { <0.096572, -0.918818, 0.382683>, <0.144527, -0.912505, 0.382683>, <0.146765, -0.926641, 0.346117> }
triangle { <0.146765, -0.926641, 0.346117>, <0.098068, -0.933052, 0.346117>, <0.096572, -0.918818, 0.382683> }
triangle { <0.098068, -0.933052, 0.346117>, <0.146765, -0.926641, 0.346117>, <0.148778, -0.939347, 0.309017> }
triangle { <0.148778, -0.939347, 0.309017>, <0.099412, -0.945847, 0.309017>, <0.098068, -0.933052, 0.346117> }
triangle { <0.099412, -0.945847, 0.309017>, <0.148778, -0.939347, 0.309017>, <0.150561, -0.950606, 0.271440> }
triangle { <0.150561, -0.950606, 0.271440>, <0.100604, -0.957183, 0.271440>, <0.099412, -0.945847, 0.309017> }
triangle { <0.100604, -0.957183, 0.271440>, <0.150561, -0.950606, 0.271440>, <0.152112, -0.960398, 0.233445> }
triangle { <0.152112, -0.960398, 0.233445>, <0.101640, -0.967043, 0.233445>, <0.100604, -0.957183, 0.271440> }
triangle { <0.101640, -0.967043, 0.233445>, <0.152112, -0.960398, 0.233445>, <0.153429, -0.968710, 0.195090> }
triangle { <0.153429, -0.968710, 0.195090>, <0.102520, -0.975412, 0.195090>, <0.101640, -0.967043, 0.233445> }
triangle { <0.102520, -0.975412, 0.195090>, <0.153429, -0.968710, 0.195090>, <0.154508, -0.975528, 0.156434> }
triangle { <0.154508, -0.975528, 0.156434>, <0.103242, -0.982278, 0.156434>, <0.102520, -0.975412, 0.195090> }
triangle { <0.103242, -0.982278, 0.156434>, <0.154508, -0.975528, 0.156434>, <0.155350, -0.980842, 0.117537> }
triangle { <0.155350, -0.980842, 0.117537>, <0.103804, -0.987628, 0.117537>, <0.103242, -0.982278, 0.156434> }
triangle { <0.103804, -0.987628, 0.117537>, <0.155350, -0.980842, 0.117537>, <0.155952, -0.984644, 0.078459> }
triangle { <0.155952, -0.984644, 0.078459>, <0.104206, -0.991456, 0.078459>, <0.103804, -0.987628, 0.117537> }
triangle { <0.104206, -0.991456, 0.078459>, <0.155952, -0.984644, 0.078459>, <0.156314, -0.986927, 0.039260> }
triangle { <0.156314, -0.986927, 0.039260>, <0.104448, -0.993755, 0.039260>, <0.104206, -0.991456, 0.078459> }
triangle { <0.104448, -0.993755, 0.039260>, <0.156314, -0.986927, 0.039260>, <0.156434, -0.987688, -0.000000> }
triangle { <0.156434, -0.987688, -0.000000>, <0.104528, -0.994522, -0.000000>, <0.104448, -0.993755, 0.039260> }
triangle { <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.008163, -0.038402, 0.999229> }
triangle { <0.008163, -0.038402, 0.999229>, <0.006142, -0.038776, 0.999229>, <0.000000, 0.000000, 1.000000> }
triangle { <0.006142, -0.038776, 0.999229>, <0.008163, -0.038402, 0.999229>, <0.016313, -0.076745, 0.996917> }
triangle { <0.016313, -0.076745, 0.996917>, <0.012274, -0.077493, 0.996917>, <0.006142, -0.038776, 0.999229> }
triangle { <0.012274, -0.077493, 0.996917>, <0.016313, -0.076745, 0.996917>, <0.024437, -0.114969, 0.993068> }
triangle { <0.024437, -0.114969, 0.993068>, <0.018387, -0.116090, 0.993068>, <0.012274, -0.077493, 0.996917> }
triangle { <0.018387, -0.116090, 0.993068>, <0.024437, -0.114969, 0.993068>, <0.032525, -0.153016, 0.987688> }
triangle { <0.032525, -0.153016, 0.987688>, <0.024472, -0.154508, 0.987688>, <0.018387, -0.116090, 0.993068> }
triangle { <0.024472, -0.154508, 0.987688>, <0.032525, -0.153016, 0.987688>, <0.040562, -0.190827, 0.980785> }
triangle { <0.040562, -0.190827, 0.980785>, <0.030519, -0.192688, 0.980785>, <0.024472, -0.154508, 0.987688> }
triangle { <0.030519, -0.192688, 0.980785>, <0.040562, -0.190827, 0.980785>, <0.048536, -0.228344, 0.972370> }
triangle { <0.048536, -0.228344, 0.972370>, <0.036519, -0.230571, 0.972370>, <0.030519, -0.192688, 0.980785> }
triangle { <0.036519, -0.230571, 0.972370>, <0.048536, -0.228344, 0.972370>, <0.056436, -0.265509, 0.962455> }
triangle { <0.056436, -0.265509, 0.962455>, <0.042463, -0.268099, 0.962455>, <0.036519, -0.230571, 0.972370> }
triangle { <0.042463, -0.268099, 0.962455>, <0.056436, -0.265509, 0.962455>, <0.064248, -0.302264, 0.951057> }
triangle { <0.064248, -0.302264, 0.951057>, <0.048341, -0.305212, 0.951057>, <0.042463, -0.268099, 0.962455> }
triangle { <0.048341, -0.305212, 0.951057>, <0.064248, -0.302264, 0.951057>, <0.071962, -0.338554, 0.938191> }
triangle { <0.071962, -0.338554, 0.938191>, <0.054145, -0.341856, 0.938191>, <0.048341, -0.305212, 0.951057> }
triangle { <0.054145, -0.341856, 0.938191>, <0.071962, -0.338554, 0.938191>, <0.079564, -0.374321, 0.923880> }
triangle { <0.079564, -0.374321, 0.923880>, <0.059865, -0.377972, 0.923880>, <0.054145, -0.341856, 0.938191> }
triangle { <0.059865, -0.377972, 0.923880>, <0.079564, -0.374321, 0.923880>, <0.087044, -0.409511, 0.908143> }
triangle { <0.087044, -0.409511, 0.908143>, <0.065493, -0.413505, 0.908143>, <0.059865, -0.377972, 0.923880> }
triangle { <0.065493, -0.413505, 0.908143>, <0.087044, -0.409511, 0.908143>, <0.094390, -0.444070, 0.891007> }
triangle { <0.094390, -0.444070, 0.891007>, <0.071020, -0.448401, 0.891007>, <0.065493, -0.413505, 0.908143> }
triangle { <0.071020, -0.448401, 0.891007>, <0.094390, -0.444070, 0.891007>, <0.101590, -0.477944, 0.872496> }
triangle { <0.101590, -0.477944, 0.872496>, <0.076437, -0.482606, 0.872496>, <0.071020, -0.448401, 0.891007> }
triangle { <0.076437, -0.482606, 0.872496>, <0.101590, -0.477944, 0.872496>, <0.108634, -0.511081, 0.852640> }
triangle { <0.108634, -0.511081, 0.852640>, <0.081737, -0.516066, 0.852640>, <0.076437, -0.482606, 0.872496> }
triangle { <0.081737, -0.516066, 0.852640>, <0.108634, -0.511081, 0.852640>, <0.115510, -0.543430, 0.831470> }
triangle { <0.115510, -0.543430, 0.831470>, <0.086910, -0.548730, 0.831470>, <0.081737, -0.516066, 0.852640> }
triangle { <0.086910, -0.548730, 0.831470>, <0.115510, -0.543430, 0.831470>, <0.122207, -0.574941, 0.809017> }
triangle { <0.122207, -0.574941, 0.809017>, <0.091950, -0.580549, 0.809017>, <0.086910, -0.548730, 0.831470> }
triangle { <0.091950, -0.580549, 0.809017>, <0.122207, -0.574941, 0.809017>, <0.128717, -0.605565, 0.785317> }
triangle { <0.128717, -0.605565, 0.785317>, <0.096848, -0.611472, 0.785317>, <0.091950, -0.580549, 0.809017> }
triangle { <0.096848, -0.611472, 0.785317>, <0.128717, -0.605565, 0.785317>, <0.135028, -0.635256, 0.760406> }
triangle { <0.135028, -0.635256, 0.760406>, <0.101596, -0.641452, 0.760406>, <0.096848, -0.611472, 0.785317> }
triangle { <0.101596, -0.641452, 0.760406>, <0.135028, -0.635256, 0.760406>, <0.141131, -0.663967, 0.734323> }
triangle { <0.141131, -0.663967, 0.734323>, <0.106188, -0.670444, 0.734323>, <0.101596, -0.641452, 0.760406> }
triangle { <0.106188, -0.670444, 0.734323>, <0.141131, -0.663967, 0.734323>, <0.147016, -0.691655, 0.707107> }
triangle { <0.147016, -0.691655, 0.707107>, <0.110616, -0.698401, 0.707107>, <0.106188, -0.670444, 0.734323> }
triangle { <0.110616, -0.698401, 0.707107>, <0.147016, -0.691655, 0.707107>, <0.152674, -0.718276, 0.678801> }
triangle { <0.152674, -0.718276, 0.678801>, <0.114873, -0.725282, 0.678801>, <0.110616, -0.698401, 0.707107> }
triangle { <0.114873, -0.725282, 0.678801>, <0.152674, -0.718276, 0.678801>, <0.158097, -0.743789, 0.649448> }
triangle { <0.158097, -0.743789, 0.649448>, <0.118954, -0.751044, 0.649448>, <0.114873, -0.725282, 0.678801> }
triangle { <0.118954, -0.751044, 0.649448>, <0.158097, -0.743789, 0.649448>, <0.163277, -0.768156, 0.619094> }
triangle { <0.163277, -0.768156, 0.619094>, <0.122851, -0.775648, 0.619094>, <0.118954, -0.751044, 0.649448> }
triangle { <0.122851, -0.775648, 0.619094>, <0.163277, -0.768156, 0.619094>, <0.168204, -0.791338, 0.587785> }
triangle { <0.168204, -0.791338, 0.587785>, <0.126558, -0.799057, 0.587785>, <0.122851, -0.775648, 0.619094> }
triangle { <0.126558, -0.799057, 0.587785>, <0.168204, -0.791338, 0.587785>, <0.172872, -0.813300, 0.555570> }
triangle { <0.172872, -0.813300, 0.555570>, <0.130071, -0.821233, 0.555570>, <0.126558, -0.799057, 0.587785> }
triangle { <0.130071, -0.821233, 0.555570>, <0.172872, -0.813300, 0.555570>, <0.177274, -0.834008, 0.522499> }
triangle { <0.177274, -0.834008, 0.522499>, <0.133382, -0.842143, 0.522499>, <0.130071, -0.821233, 0.555570> }
triangle { <0.133382, -0.842143, 0.522499>, <0.177274, -0.834008, 0.522499>, <0.181402, -0.853430, 0.488621> }
triangle { <0.181402, -0.853430, 0.488621>, <0.136488, -0.861754, 0.488621>, <0.133382, -0.842143, 0.522499> }
triangle { <0.136488, -0.861754, 0.488621>, <0.181402, -0.853430, 0.488621>, <0.185251, -0.871536, 0.453990> }
triangle { <0.185251, -0.871536, 0.453990>, <0.139384, -0.880037, 0.453990>, <0.136488, -0.861754, 0.488621> }
triangle { <0.139384, -0.880037, 0.453990>, <0.185251, -0.871536, 0.453990>, <0.188814, -0.888298, 0.418660> }
triangle { <0.188814, -0.888298, 0.418660>, <0.142065, -0.896962, 0.418660>, <0.139384, -0.880037, 0.453990> }
triangle { <0.142065, -0.896962, 0.418660>, <0.188814, -0.888298, 0.418660>, <0.192085, -0.903691, 0.382683> }
triangle { <0.192085, -0.903691, 0.382683>, <0.144527, -0.912505, 0.382683>, <0.142065, -0.896962, 0.418660> }
triangle { <0.144527, -0.912505, 0.382683>, <0.192085, -0.903691, 0.382683>, <0.195061, -0.917690, 0.346117> }
triangle { <0.195061, -0.917690, 0.346117>, <0.146765, -0.926641, 0.346117>, <0.144527, -0.912505, 0.382683> }
triangle { <0.146765, -0.926641, 0.346117>, <0.195061, -0.917690, 0.346117>, <0.197736, -0.930274, 0.309017> }
triangle { <0.197736, -0.930274, 0.309017>, <0.148778, -0.939347, 0.309017>, <0.146765, -0.926641, 0.346117> }
triangle { <0.148778, -0.939347, 0.309017>, <0.197736, -0.930274, 0.309017>, <0.200106, -0.941423, 0.271440> }
triangle { <0.200106, -0.941423, 0.271440>, <0.150561, -0.950606, 0.271440>, <0.148778, -0.939347, 0.309017> }
triangle { <0.150561, -0.950606, 0.271440>, <0.200106, -0.941423, 0.271440>, <0.202167, -0.951121, 0.233445> }
triangle { <0.202167, -0.951121, 0.233445>, <0.152112, -0.960398, 0.233445>, <0.150561, -0.950606, 0.271440> }
triangle { <0.152112, -0.960398, 0.233445>, <0.202167, -0.951121, 0.233445>, <0.203917, -0.959353, 0.195090> }
triangle { <0.203917, -0.959353, 0.195090>, <0.153429, -0.968710, 0.195090>, <0.152112, -0.960398, 0.233445> }
triangle { <0.153429, -0.968710, 0.195090>, <0.203917, -0.959353, 0.195090>, <0.205352, -0.966105, 0.156434> }
triangle { <0.205352, -0.966105, 0.156434>, <0.154508, -0.975528, 0.156434>, <0.153429, -0.968710, 0.195090> }
triangle { <0.154508, -0.975528, 0.156434>, <0.205352, -0.966105, 0.156434>, <0.206471, -0.971368, 0.117537> }
triangle { <0.206471, -0.971368, 0.117537>, <0.155350, -0.980842, 0.117537>, <0.154508, -0.975528, 0.156434> }
triangle { <0.155350, -0.980842, 0.117537>, <0.206471, -0.971368, 0.117537>, <0.207271, -0.975132, 0.078459> }
triangle { <0.207271, -0.975132, 0.078459>, <0.155952, -0.984644, 0.078459>, <0.155350, -0.980842, 0.117537> }
triangle { <0.155952, -0.984644, 0.078459>, <0.207271, -0.975132, 0.078459>, <0.207751, -0.977393, 0.039260> }
triangle { <0.207751, -0.977393, 0.039260>, <0.156314, -0.986927, 0.039260>, <0.155952, -0.984644, 0.078459> }
triangle { <0.156314, -0.986927, 0.039260>, <0.207751, -0.977393, 0.039260>, <0.207912, -0.978148, -0.000000> }
triangle { <0.207912, -0.978148, -0.000000>, <0.156434, -0.987688, -0.000000>, <0.156314, -0.986927, 0.039260> }
triangle { <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.010161, -0.037922, 0.999229> }
triangle { <0.010161, -0.037922, 0.999229>, <0.008163, -0.038402, 0.999229>, <0.000000, 0.000000, 1.000000> }
triangle { <0.008163, -0.038402, 0.999229>, <0.010161, -0.037922, 0.999229>, <0.020307, -0.075786, 0.996917> }
triangle { <0.020307, -0.075786, 0.996917>, <0.016313, -0.076745, 0.996917>, <0.008163, -0.038402, 0.999229> }
triangle { <0.016313, -0.076745, 0.996917>, <0.020307, -0.075786, 0.996917>, <0.030421, -0.113532, 0.993068> }
triangle { <0.030421, -0.113532, 0.993068>, <0.024437, -0.114969, 0.993068>, <0.016313, -0.076745, 0.996917> }
triangle { <0.024437, -0.114969, 0.993068>, <0.030421, -0.113532, 0.993068>, <0.040488, -0.151104, 0.987688> }
triangle { <0.040488, -0.151104, 0.987688>, <0.032525, -0.153016, 0.987688>, <0.024437, -0.114969, 0.993068> }
triangle { <0.032525, -0.153016, 0.987688>, <0.040488, -0.151104, 0.987688>, <0.050493, -0.188443, 0.980785> }
triangle { <0.050493, -0.188443, 0.980785>, <0.040562, -0.190827, 0.980785>, <0.032525, -0.153016, 0.987688> }
triangle { <0.040562, -0.190827, 0.980785>, <0.050493, -0.188443, 0.980785>, <0.060420, -0.225491, 0.972370> }
triangle { <0.060420, -0.225491, 0.972370>, <0.048536, -0.228344, 0.972370>, <0.040562, -0.190827, 0.980785> }
triangle { <0.048536, -0.228344, 0.972370>, <0.060420, -0.225491, 0.972370>, <0.070254, -0.262191, 0.962455> }
triangle { <0.070254, -0.262191, 0.962455>, <0.056436, -0.265509, 0.962455>, <0.048536, -0.228344, 0.972370> }
triangle { <0.056436, -0.265509, 0.962455>, <0.070254, -0.262191, 0.962455>, <0.079979, -0.298487, 0.951057> }
triangle { <0.079979, -0.298487, 0.951057>, <0.064248, -0.302264, 0.951057>, <0.056436, -0.265509, 0.962455> }
triangle { <0.064248, -0.302264, 0.951057>, <0.079979, -0.298487, 0.951057>, <0.089582, -0.334323, 0.938191> }
triangle { <0.089582, -0.334323, 0.938191>, <0.071962, -0.338554, 0.938191>, <0.064248, -0.302264, 0.951057> }
triangle { <0.071962, -0.338554, 0.938191>, <0.089582, -0.334323, 0.938191>, <0.099046, -0.369644, 0.923880> }
triangle { <0.099046, -0.369644, 0.923880>, <0.079564, -0.374321, 0.923880>, <0.071962, -0.338554, 0.938191> }
triangle { <0.079564, -0.374321, 0.923880>, <0.099046, -0.369644, 0.923880>, <0.108357, -0.404394, 0.908143> }
triangle { <0.108357, -0.404394, 0.908143>, <0.087044, -0.409511, 0.908143>, <0.079564, -0.374321, 0.923880> }
triangle { <0.087044, -0.409511, 0.908143>, <0.108357, -0.404394, 0.908143>, <0.117501, -0.438521, 0.891007> }
triangle { <0.117501, -0.438521, 0.891007>, <0.094390, -0.444070, 0.891007>, <0.087044, -0.409511, 0.908143> }
triangle { <0.094390, -0.444070, 0.891007>, <0.117501, -0.438521, 0.891007>, <0.126464, -0.471972, 0.872496> }
triangle { <0.126464, -0.471972, 0.872496>, <0.101590, -0.477944, 0.872496>, <0.094390, -0.444070, 0.891007> }
triangle { <0.101590, -0.477944, 0.872496>, <0.126464, -0.471972, 0.872496>, <0.135233, -0.504695, 0.852640> }
triangle { <0.135233, -0.504695, 0.852640>, <0.108634, -0.511081, 0.852640>, <0.101590, -0.477944, 0.872496> }
triangle { <0.108634, -0.511081, 0.852640>, <0.135233, -0.504695, 0.852640>, <0.143792, -0.536640, 0.831470> }
triangle { <0.143792, -0.536640, 0.831470>, <0.115510, -0.543430, 0.831470>, <0.108634, -0.511081, 0.852640> }
triangle { <0.115510, -0.543430, 0.831470>, <0.143792, -0.536640, 0.831470>, <0.152130, -0.567757, 0.809017> }
triangle { <0.152130, -0.567757, 0.809017>, <0.122207, -0.574941, 0.809017>, <0.115510, -0.543430, 0.831470> }
triangle { <0.122207, -0.574941, 0.809017>, <0.152130, -0.567757, 0.809017>, <0.160233, -0.597999, 0.785317> }
triangle { <0.160233, -0.597999, 0.785317>, <0.128717, -0.605565, 0.785317>, <0.122207, -0.574941, 0.809017> }
triangle { <0.128717, -0.605565, 0.785317>, <0.160233, -0.597999, 0.785317>, <0.168090, -0.627319, 0.760406> }
triangle { <0.168090, -0.627319, 0.760406>, <0.135028, -0.635256, 0.760406>, <0.128717, -0.605565, 0.785317> }
triangle { <0.135028, -0.635256, 0.760406>, <0.168090, -0.627319, 0.760406>, <0.175687, -0.655671, 0.734323> }
triangle { <0.175687, -0.655671, 0.734323>, <0.141131, -0.663967, 0.734323>, <0.135028, -0.635256, 0.760406> }
triangle { <0.141131, -0.663967, 0.734323>, <0.175687, -0.655671, 0.734323>, <0.183013, -0.683013, 0.707107> }
triangle { <0.183013, -0.683013, 0.707107>, <0.147016, -0.691655, 0.707107>, <0.141131, -0.663967, 0.734323> }
triangle { <0.147016, -0.691655, 0.707107>, <0.183013, -0.683013, 0.707107>, <0.190057, -0.709301, 0.678801> }
triangle { <0.190057, -0.709301, 0.678801>, <0.152674, -0.718276, 0.678801>, <0.147016, -0.691655, 0.707107> }
triangle { <0.152674, -0.718276, 0.678801>, <0.190057, -0.709301, 0.678801>, <0.196808, -0.734496, 0.649448> }
triangle { <0.196808, -0.734496, 0.649448>, <0.158097, -0.743789, 0.649448>, <0.152674, -0.718276, 0.678801> }
triangle { <0.158097, -0.743789, 0.649448>, <0.196808, -0.734496, 0.649448>, <0.203255, -0.758558, 0.619094> }
triangle { <0.203255, -0.758558, 0.619094>, <0.163277, -0.768156, 0.619094>, <0.158097, -0.743789, 0.649448> }
triangle { <0.163277, -0.768156, 0.619094>, <0.203255, -0.758558, 0.619094>, <0.209389, -0.781450, 0.587785> }
triangle { <0.209389, -0.781450, 0.587785>, <0.168204, -0.791338, 0.587785>, <0.163277, -0.768156, 0.619094> }
triangle { <0.168204, -0.791338, 0.587785>, <0.209389, -0.781450, 0.587785>, <0.215200, -0.803138, 0.555570> }
triangle { <0.215200, -0.803138, 0.555570>, <0.172872, -0.813300, 0.555570>, <0.168204, -0.791338, 0.587785> }
triangle { <0.172872, -0.813300, 0.555570>, <0.215200, -0.803138, 0.555570>, <0.220680, -0.823587, 0.522499> }
triangle { <0.220680, -0.823587, 0.522499>, <0.177274, -0.834008, 0.522499>, <0.172872, -0.813300, 0.555570> }
triangle { <0.177274, -0.834008, 0.522499>, <0.220680, -0.823587, 0.522499>, <0.225819, -0.842766, 0.488621> }
triangle { <0.225819, -0.842766, 0.488621>, <0.181402, -0.853430, 0.488621>, <0.177274, -0.834008, 0.522499> }
triangle { <0.181402, -0.853430, 0.488621>, <0.225819, -0.842766, 0.488621>, <0.230609, -0.860646, 0.453990> }
triangle { <0.230609, -0.860646, 0.453990>, <0.185251, -0.871536, 0.453990>, <0.181402, -0.853430, 0.488621> }
triangle { <0.185251, -0.871536, 0.453990>, <0.230609, -0.860646, 0.453990>, <0.235045, -0.877199, 0.418660> }
triangle { <0.235045, -0.877199, 0.418660>, <0.188814, -0.888298, 0.418660>, <0.185251, -0.871536, 0.453990> }
triangle { <0.188814, -0.888298, 0.418660>, <0.235045, -0.877199, 0.418660>, <0.239118, -0.892399, 0.382683> }
triangle { <0.239118, -0.892399, 0.382683>, <0.192085, -0.903691, 0.382683>, <0.188814, -0.888298, 0.418660> }
triangle { <0.192085, -0.903691, 0.382683>, <0.239118, -0.892399, 0.382683>, <0.242822, -0.906223, 0.346117> }
triangle { <0.242822, -0.906223, 0.346117>, <0.195061, -0.917690, 0.346117>, <0.192085, -0.903691, 0.382683> }
triangle { <0.195061, -0.917690, 0.346117>, <0.242822, -0.906223, 0.346117>, <0.246152, -0.918650, 0.309017> }
triangle { <0.246152, -0.918650, 0.309017>, <0.197736, -0.930274, 0.309017>, <0.195061, -0.917690, 0.346117> }
triangle { <0.197736, -0.930274, 0.309017>, <0.246152, -0.918650, 0.309017>, <0.249102, -0.929660, 0.271440> }
triangle { <0.249102, -0.929660, 0.271440>, <0.200106, -0.941423, 0.271440>, <0.197736, -0.930274, 0.309017> }
triangle { <0.200106, -0.941423, 0.271440>, <0.249102, -0.929660, 0.271440>, <0.251668, -0.939237, 0.233445> }
triangle { <0.251668, -0.939237, 0.233445>, <0.202167, -0.951121, 0.233445>, <0.200106, -0.941423, 0.271440> }
triangle { <0.202167, -0.951121, 0.233445>, <0.251668, -0.939237, 0.233445>, <0.253846, -0.947366, 0.195090> }
triangle { <0.253846, -0.947366, 0.195090>, <0.203917, -0.959353, 0.195090>, <0.202167, -0.951121, 0.233445> }
triangle { <0.203917, -0.959353, 0.195090>, <0.253846, -0.947366, 0.195090>, <0.255633, -0.954034, 0.156434> }
triangle { <0.255633, -0.954034, 0.156434>, <0.205352, -0.966105, 0.156434>, <0.203917, -0.959353, 0.195090> }
triangle { <0.205352, -0.966105, 0.156434>, <0.255633, -0.954034, 0.156434>, <0.257025, -0.959230, 0.117537> }
triangle { <0.257025, -0.959230, 0.117537>, <0.206471, -0.971368, 0.117537>, <0.205352, -0.966105, 0.156434> }
triangle { <0.206471, -0.971368, 0.117537>, <0.257025, -0.959230, 0.117537>, <0.258021, -0.962948, 0.078459> }
triangle { <0.258021, -0.962948, 0.078459>, <0.207271, -0.975132, 0.078459>, <0.206471, -0.971368, 0.117537> }
triangle { <0.207271, -0.975132, 0.078459>, <0.258021, -0.962948, 0.078459>, <0.258620, -0.965181, 0.039260> }
triangle { <0.258620, -0.965181, 0.039260>, <0.207751, -0.977393, 0.039260>, <0.207271, -0.975132, 0.078459> }
triangle { <0.207751, -0.977393, 0.039260>, <0.258620, -0.965181, 0.039260>, <0.258819, -0.965926, -0.000000> }
triangle { <0.258819, -0.965926, -0.000000>, <0.207912, -0.978148, -0.000000>, <0.207751, -0.977393, 0.039260> }
triangle { <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.012132, -0.037338, 0.999229> }
triangle { <0.012132, -0.037338, 0.999229>, <0.010161, -0.037922, 0.999229>, <0.000000, 0.000000, 1.000000> }
triangle { <0.010161, -0.037922, 0.999229>, <0.012132, -0.037338, 0.999229>, <0.024245, -0.074619, 0.996917> }
triangle { <0.024245, -0.074619, 0.996917>, <0.020307, -0.075786, 0.996917>, <0.010161, -0.037922, 0.999229> }
triangle { <0.020307, -0.075786, 0.996917>, <0.024245, -0.074619, 0.996917>, <0.036321, -0.111785, 0.993068> }
triangle { <0.036321, -0.111785, 0.993068>, <0.030421, -0.113532, 0.993068>, <0.020307, -0.075786, 0.996917> }
triangle { <0.030421, -0.113532, 0.993068>, <0.036321, -0.111785, 0.993068>, <0.048341, -0.148778, 0.987688> }
triangle { <0.048341, -0.148778, 0.987688>, <0.040488, -0.151104, 0.987688>, <0.030421, -0.113532, 0.993068> }
triangle { <0.040488, -0.151104, 0.987688>, <0.048341, -0.148778, 0.987688>, <0.060286, -0.185542, 0.980785> }
triangle { <0.060286, -0.185542, 0.980785>, <0.050493, -0.188443, 0.980785>, <0.040488, -0.151104, 0.987688> }
triangle { <0.050493, -0.188443, 0.980785>, <0.060286, -0.185542, 0.980785>, <0.072139, -0.222020, 0.972370> }
triangle { <0.072139, -0.222020, 0.972370>, <0.060420, -0.225491, 0.972370>, <0.050493, -0.188443, 0.980785> }
triangle { <0.060420, -0.225491, 0.972370>, <0.072139, -0.222020, 0.972370>, <0.083880, -0.258155, 0.962455> }
triangle { <0.083880, -0.258155, 0.962455>, <0.070254, -0.262191, 0.962455>, <0.060420, -0.225491, 0.972370> }
triangle { <0.070254, -0.262191, 0.962455>, <0.083880, -0.258155, 0.962455>, <0.095492, -0.293893, 0.951057> }
triangle { <0.095492, -0.293893, 0.951057>, <0.079979, -0.298487, 0.951057>, <0.070254, -0.262191, 0.962455> }
triangle { <0.079979, -0.298487, 0.951057>, <0.095492, -0.293893, 0.951057>, <0.106956, -0.329177, 0.938191> }
triangle { <0.106956, -0.329177, 0.938191>, <0.089582, -0.334323, 0.938191>, <0.079979, -0.298487, 0.951057> }
triangle { <0.089582, -0.334323, 0.938191>, <0.106956, -0.329177, 0.938191>, <0.118256, -0.363954, 0.923880> }
triangle { <0.118256, -0.363954, 0.923880>, <0.099046, -0.369644, 0.923880>, <0.089582, -0.334323, 0.938191> }
triangle { <0.099046, -0.369644, 0.923880>, <0.118256, -0.363954, 0.923880>, <0.129373, -0.398169, 0.908143> }
triangle { <0.129373, -0.398169, 0.908143>, <0.108357, -0.404394, 0.908143>, <0.099046, -0.369644, 0.923880> }
triangle { <0.108357, -0.404394, 0.908143>, <0.129373, -0.398169, 0.908143>, <0.140291, -0.431771, 0.891007> }
triangle { <0.140291, -0.431771, 0.891007>, <0.117501, -0.438521, 0.891007>, <0.108357, -0.404394, 0.908143> }
triangle { <0.117501, -0.438521, 0.891007>, <0.140291, -0.431771, 0.891007>, <0.150992, -0.464706, 0.872496> }
triangle { <0.150992, -0.464706, 0.872496>, <0.126464, -0.471972, 0.872496>, <0.117501, -0.438521, 0.891007> }
triangle { <0.126464, -0.471972, 0.872496>, <0.150992, -0.464706, 0.872496>, <0.161461, -0.496926, 0.852640> }
triangle { <0.161461, -0.496926, 0.852640>, <0.135233, -0.504695, 0.852640>, <0.126464, -0.471972, 0.872496> }
triangle { <0.135233, -0.504695, 0.852640>, <0.161461, -0.496926, 0.852640>, <0.171681, -0.528379, 0.831470> }
triangle { <0.171681, -0.528379, 0.831470>, <0.143792, -0.536640, 0.831470>, <0.135233, -0.504695, 0.852640> }
triangle { <0.143792, -0.536640, 0.831470>, <0.171681, -0.528379, 0.831470>, <0.181636, -0.559017, 0.809017> }
triangle { <0.181636, -0.559017, 0.809017>, <0.152130, -0.567757, 0.809017>, <0.143792, -0.536640, 0.831470> }
triangle { <0.152130, -0.567757, 0.809017>, <0.181636, -0.559017, 0.809017>, <0.191311, -0.588793, 0.785317> }
triangle { <0.191311, -0.588793, 0.785317>, <0.160233, -0.597999, 0.785317>, <0.152130, -0.567757, 0.809017> }
triangle { <0.160233, -0.597999, 0.785317>, <0.191311, -0.588793, 0.785317>, <0.200690, -0.617662, 0.760406> }
triangle { <0.200690, -0.617662, 0.760406>, <0.168090, -0.627319, 0.760406>, <0.160233, -0.597999, 0.785317> }
triangle { <0.168090, -0.627319, 0.760406>, <0.200690, -0.617662, 0.760406>, <0.209761, -0.645578, 0.734323> }
triangle { <0.209761, -0.645578, 0.734323>, <0.175687, -0.655671, 0.734323>, <0.168090, -0.627319, 0.760406> }
triangle { <0.175687, -0.655671, 0.734323>, <0.209761, -0.645578, 0.734323>, <0.218508, -0.672499, 0.707107> }
triangle { <0.218508, -0.672499, 0.707107>, <0.183013, -0.683013, 0.707107>, <0.175687, -0.655671, 0.734323> }
triangle { <0.183013, -0.683013, 0.707107>, <0.218508, -0.672499, 0.707107>, <0.226918, -0.698382, 0.678801> }
triangle { <0.226918, -0.698382, 0.678801>, <0.190057, -0.709301, 0.678801>, <0.183013, -0.683013, 0.707107> }
triangle { <0.190057, -0.709301, 0.678801>, <0.226918, -0.698382, 0.678801>, <0.234978, -0.723189, 0.649448> }
triangle { <0.234978, -0.723189, 0.649448>, <0.196808, -0.734496, 0.649448>, <0.190057, -0.709301, 0.678801> }
triangle { <0.196808, -0.734496, 0.649448>, <0.234978, -0.723189, 0.649448>, <0.242676, -0.746881, 0.619094> }
triangle { <0.242676, -0.746881, 0.619094>, <0.203255, -0.758558, 0.619094>, <0.196808, -0.734496, 0.649448> }
triangle { <0.203255, -0.758558, 0.619094>, <0.242676, -0.746881, 0.619094>, <0.250000, -0.769421, 0.587785> }
triangle { <0.250000, -0.769421, 0.587785>, <0.209389, -0.781450, 0.587785>, <0.203255, -0.758558, 0.619094> }
triangle { <0.209389, -0.781450, 0.587785>, <0.250000, -0.769421, 0.587785>, <0.256938, -0.790775, 0.555570> }
triangle { <0.256938, -0.790775, 0.555570>, <0.215200, -0.803138, 0.555570>, <0.209389, -0.781450, 0.587785> }
triangle { <0.215200, -0.803138, 0.555570>, <0.256938, -0.790775, 0.555570>, <0.263480, -0.810909, 0.522499> }
triangle { <0.263480, -0.810909, 0.522499>, <0.220680, -0.823587, 0.522499>, <0.215200, -0.803138, 0.555570> }
triangle { <0.220680, -0.823587, 0.522499>, <0.263480, -0.810909, 0.522499>, <0.269616, -0.829793, 0.488621> }
triangle { <0.269616, -0.829793, 0.488621>, <0.225819, -0.842766, 0.488621>, <0.220680, -0.823587, 0.522499> }
triangle { <0.225819, -0.842766, 0.488621>, <0.269616, -0.829793, 0.488621>, <0.275336, -0.847398, 0.453990> }
triangle { <0.275336, -0.847398, 0.453990>, <0.230609, -0.860646, 0.453990>, <0.225819, -0.842766, 0.488621> }
triangle { <0.230609, -0.860646, 0.453990>, <0.275336, -0.847398, 0.453990>, <0.280632, -0.863695, 0.418660> }
triangle { <0.280632, -0.863695, 0.418660>, <0.235045, -0.877199, 0.418660>, <0.230609, -0.860646, 0.453990> }
triangle { <0.235045, -0.877199, 0.418660>, <0.280632, -0.863695, 0.418660>, <0.285494, -0.878662, 0.382683> }
triangle { <0.285494, -0.878662, 0.382683>, <0.239118, -0.892399, 0.382683>, <0.235045, -0.877199, 0.418660> }
triangle { <0.239118, -0.892399, 0.382683>, <0.285494, -0.878662, 0.382683>, <0.289917, -0.892273, 0.346117> }
triangle { <0.289917, -0.892273, 0.346117>, <0.242822, -0.906223, 0.346117>, <0.239118, -0.892399, 0.382683> }
triangle { <0.242822, -0.906223, 0.346117>, <0.289917, -0.892273, 0.346117>, <0.293893, -0.904508, 0.309017> }
triangle { <0.293893, -0.904508, 0.309017>, <0.246152, -0.918650, 0.309017>, <0.242822, -0.906223, 0.346117> }
triangle { <0.246152, -0.918650, 0.309017>, <0.293893, -0.904508, 0.309017>, <0.297415, -0.915349, 0.271440> }
triangle { <0.297415, -0.915349, 0.271440>, <0.249102, -0.929660, 0.271440>, <0.246152, -0.918650, 0.309017> }
triangle { <0.249102, -0.929660, 0.271440>, <0.297415, -0.915349, 0.271440>, <0.300479, -0.924779, 0.233445> }
triangle { <0.300479, -0.924779, 0.233445>, <0.251668, -0.939237, 0.233445>, <0.249102, -0.929660, 0.271440> }
triangle { <0.251668, -0.939237, 0.233445>, <0.300479, -0.924779, 0.233445>, <0.303079, -0.932782, 0.195090> }
triangle { <0.303079, -0.932782, 0.195090>, <0.253846, -0.947366, 0.195090>, <0.251668, -0.939237, 0.233445> }
triangle { <0.253846, -0.947366, 0.195090>, <0.303079, -0.932782, 0.195090>, <0.305212, -0.939347, 0.156434> }
triangle { <0.305212, -0.939347, 0.156434>, <0.255633, -0.954034, 0.156434>, <0.253846, -0.947366, 0.195090> }
triangle { <0.255633, -0.954034, 0.156434>, <0.305212, -0.939347, 0.156434>, <0.306875, -0.944464, 0.117537> }
triangle { <0.306875, -0.944464, 0.117537>, <0.257025, -0.959230, 0.117537>, <0.255633, -0.954034, 0.156434> }
triangle { <0.257025, -0.959230, 0.117537>, <0.306875, -0.944464, 0.117537>, <0.308064, -0.948125, 0.078459> }
triangle { <0.308064, -0.948125, 0.078459>, <0.258021, -0.962948, 0.078459>, <0.257025, -0.959230, 0.117537> }
triangle { <0.258021, -0.962948, 0.078459>, <0.308064, -0.948125, 0.078459>, <0.308779, -0.950323, 0.039260> }
triangle { <0.308779, -0.950323, 0.039260>, <0.258620, -0.965181, 0.039260>, <0.258021, -0.962948, 0.078459> }
triangle { <0.258620, -0.965181, 0.039260>, <0.308779, -0.950323, 0.039260>, <0.309017, -0.951057, -0.000000> }
triangle { <0.309017, -0.951057, -0.000000>, <0.258819, -0.965926, -0.000000>, <0.258620, -0.965181, 0.039260> }
triangle { <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.014069, -0.036652, 0.999229> }
triangle { <0.014069, -0.036652, 0.999229>, <0.012132, -0.037338, 0.999229>, <0.000000, 0.000000, 1.000000> }
triangle { <0.012132, -0.037338, 0.999229>, <0.014069, -0.036652, 0.999229>, <0.028117, -0.073248, 0.996917> }
triangle { <0.028117, -0.073248, 0.996917>, <0.024245, -0.074619, 0.996917>, <0.012132, -0.037338, 0.999229> }
triangle { <0.024245, -0.074619, 0.996917>, <0.028117, -0.073248, 0.996917>, <0.042122, -0.109731, 0.993068> }
triangle { <0.042122, -0.109731, 0.993068>, <0.036321, -0.111785, 0.993068>, <0.024245, -0.074619, 0.996917> }
triangle { <0.036321, -0.111785, 0.993068>, <0.042122, -0.109731, 0.993068>, <0.056061, -0.146044, 0.987688> }
triangle { <0.056061, -0.146044, 0.987688>, <0.048341, -0.148778, 0.987688>, <0.036321, -0.111785, 0.993068> }
triangle { <0.048341, -0.148778, 0.987688>, <0.056061, -0.146044, 0.987688>, <0.069914, -0.182133, 0.980785> }
triangle { <0.069914, -0.182133, 0.980785>, <0.060286, -0.185542, 0.980785>, <0.048341, -0.148778, 0.987688> }
triangle { <0.060286, -0.185542, 0.980785>, <0.069914, -0.182133, 0.980785>, <0.083659, -0.217940, 0.972370> }
triangle { <0.083659, -0.217940, 0.972370>, <0.072139, -0.222020, 0.972370>, <0.060286, -0.185542, 0.980785> }
triangle { <0.072139, -0.222020, 0.972370>, <0.083659, -0.217940, 0.972370>, <0.097276, -0.253411, 0.962455> }
triangle { <0.097276, -0.253411, 0.962455>, <0.083880, -0.258155, 0.962455>, <0.072139, -0.222020, 0.972370> }
triangle { <0.083880, -0.258155, 0.962455>, <0.097276, -0.253411, 0.962455>, <0.110742, -0.288492, 0.951057> }
triangle { <0.110742, -0.288492, 0.951057>, <0.095492, -0.293893, 0.951057>, <0.083880, -0.258155, 0.962455> }
triangle { <0.095492, -0.293893, 0.951057>, <0.110742, -0.288492, 0.951057>, <0.124037, -0.323128, 0.938191> }
triangle { <0.124037, -0.323128, 0.938191>, <0.106956, -0.329177, 0.938191>, <0.095492, -0.293893, 0.951057> }
triangle { <0.106956, -0.329177, 0.938191>, <0.124037, -0.323128, 0.938191>, <0.137141, -0.357266, 0.923880> }
triangle { <0.137141, -0.357266, 0.923880>, <0.118256, -0.363954, 0.923880>, <0.106956, -0.329177, 0.938191> }
triangle { <0.118256, -0.363954, 0.923880>, <0.137141, -0.357266, 0.923880>, <0.150034, -0.390853, 0.908143> }
triangle { <0.150034, -0.390853, 0.908143>, <0.129373, -0.398169, 0.908143>, <0.118256, -0.363954, 0.923880> }
triangle { <0.129373, -0.398169, 0.908143>, <0.150034, -0.390853, 0.908143>, <0.162696, -0.423837, 0.891007> }
triangle { <0.162696, -0.423837, 0.891007>, <0.140291, -0.431771, 0.891007>, <0.129373, -0.398169, 0.908143> }
triangle { <0.140291, -0.431771, 0.891007>, <0.162696, -0.423837, 0.891007>, <0.175106, -0.456167, 0.872496> }
triangle { <0.175106, -0.456167, 0.872496>, <0.150992, -0.464706, 0.872496>, <0.140291, -0.431771, 0.891007> }
triangle { <0.150992, -0.464706, 0.872496>, <0.175106, -0.456167, 0.872496>, <0.187247, -0.487794, 0.852640> }
triangle { <0.187247, -0.487794, 0.852640>, <0.161461, -0.496926, 0.852640>, <0.150992, -0.464706, 0.872496> }
triangle { <0.161461, -0.496926, 0.852640>, <0.187247, -0.487794, 0.852640>, <0.199099, -0.518669, 0.831470> }
triangle { <0.199099, -0.518669, 0.831470>, <0.171681, -0.528379, 0.831470>, <0.161461, -0.496926, 0.852640> }
triangle { <0.171681, -0.528379, 0.831470>, <0.199099, -0.518669, 0.831470>, <0.210643, -0.548745, 0.809017> }
triangle { <0.210643, -0.548745, 0.809017>, <0.181636, -0.559017, 0.809017>, <0.171681, -0.528379, 0.831470> }
triangle { <0.181636, -0.559017, 0.809017>, <0.210643, -0.548745, 0.809017>, <0.221863, -0.577974, 0.785317> }
triangle { <0.221863, -0.577974, 0.785317>, <0.191311, -0.588793, 0.785317>, <0.181636, -0.559017, 0.809017> }
triangle { <0.191311, -0.588793, 0.785317>, <0.221863, -0.577974, 0.785317>, <0.232741, -0.606312, 0.760406> }
triangle { <0.232741, -0.606312, 0.760406>, <0.200690, -0.617662, 0.760406>, <0.191311, -0.588793, 0.785317> }
triangle { <0.200690, -0.617662, 0.760406>, <0.232741, -0.606312, 0.760406>, <0.243260, -0.633715, 0.734323> }
triangle { <0.243260, -0.633715, 0.734323>, <0.209761, -0.645578, 0.734323>, <0.200690, -0.617662, 0.760406> }
triangle { <0.209761, -0.645578, 0.734323>, <0.243260, -0.633715, 0.734323>, <0.253404, -0.660141, 0.707107> }
triangle { <0.253404, -0.660141, 0.707107>, <0.218508, -0.672499, 0.707107>, <0.209761, -0.645578, 0.734323> }
triangle { <0.218508, -0.672499, 0.707107>, <0.253404, -0.660141, 0.707107>, <0.263158, -0.685549, 0.678801> }
triangle { <0.263158, -0.685549, 0.678801>, <0.226918, -0.698382, 0.678801>, <0.218508, -0.672499, 0.707107> }
triangle { <0.226918, -0.698382, 0.678801>, <0.263158, -0.685549, 0.678801>, <0.272505, -0.709900, 0.649448> }
triangle { <0.272505, -0.709900, 0.649448>, <0.234978, -0.723189, 0.649448>, <0.226918, -0.698382, 0.678801> }
triangle { <0.234978, -0.723189, 0.649448>, <0.272505, -0.709900, 0.649448>, <0.281432, -0.733157, 0.619094> }
triangle { <0.281432, -0.733157, 0.619094>, <0.242676, -0.746881, 0.619094>, <0.234978, -0.723189, 0.649448> }
triangle { <0.242676, -0.746881, 0.619094>, <0.281432, -0.733157, 0.619094>, <0.289926, -0.755282, 0.587785> }
triangle { <0.289926, -0.755282, 0.587785>, <0.250000, -0.769421, 0.587785>, <0.242676, -0.746881, 0.619094> }
triangle { <0.250000, -0.769421, 0.587785>, <0.289926, -0.755282, 0.587785>, <0.297972, -0.776244, 0.555570> }
triangle { <0.297972, -0.776244, 0.555570>, <0.256938, -0.790775, 0.555570>, <0.250000, -0.769421, 0.587785> }
triangle { <0.256938, -0.790775, 0.555570>, <0.297972, -0.776244, 0.555570>, <0.305559, -0.796008, 0.522499> }
triangle { <0.305559, -0.796008, 0.522499>, <0.263480, -0.810909, 0.522499>, <0.256938, -0.790775, 0.555570> }
triangle { <0.263480, -0.810909, 0.522499>, <0.305559, -0.796008, 0.522499>, <0.312675, -0.814545, 0.488621> }
triangle { <0.312675, -0.814545, 0.488621>, <0.269616, -0.829793, 0.488621>, <0.263480, -0.810909, 0.522499> }
triangle { <0.269616, -0.829793, 0.488621>, <0.312675, -0.814545, 0.488621>, <0.319308, -0.831826, 0.453990> }
triangle { <0.319308, -0.831826, 0.453990>, <0.275336, -0.847398, 0.453990>, <0.269616, -0.829793, 0.488621> }
triangle { <0.275336, -0.847398, 0.453990>, <0.319308, -0.831826, 0.453990>, <0.325449, -0.847825, 0.418660> }
triangle { <0.325449, -0.847825, 0.418660>, <0.280632, -0.863695, 0.418660>, <0.275336, -0.847398, 0.453990> }
triangle { <0.280632, -0.863695, 0.418660>, <0.325449, -0.847825, 0.418660>, <0.331089, -0.862516, 0.382683> }
triangle { <0.331089, -0.862516, 0.382683>, <0.285494, -0.878662, 0.382683>, <0.280632, -0.863695, 0.418660> }
triangle { <0.285494, -0.878662, 0.382683>, <0.331089, -0.862516, 0.382683>, <0.336218, -0.875877, 0.346117> }
triangle { <0.336218, -0.875877, 0.346117>, <0.289917, -0.892273, 0.346117>, <0.285494, -0.878662, 0.382683> }
triangle { <0.289917, -0.892273, 0.346117>, <0.336218, -0.875877, 0.346117>, <0.340828, -0.887888, 0.309017> }
triangle { <0.340828, -0.887888, 0.309017>, <0.293893, -0.904508, 0.309017>, <0.289917, -0.892273, 0.346117> }
triangle { <0.293893, -0.904508, 0.309017>, <0.340828, -0.887888, 0.309017>, <0.344913, -0.898529, 0.271440> }
triangle { <0.344913, -0.898529, 0.271440>, <0.297415, -0.915349, 0.271440>, <0.293893, -0.904508, 0.309017> }
triangle { <0.297415, -0.915349, 0.271440>, <0.344913, -0.898529, 0.271440>, <0.348466, -0.907786, 0.233445> }
triangle { <0.348466, -0.907786, 0.233445>, <0.300479, -0.924779, 0.233445>, <0.297415, -0.915349, 0.271440> }
triangle { <0.300479, -0.924779, 0.233445>, <0.348466, -0.907786, 0.233445>, <0.351482, -0.915642, 0.195090> }
triangle { <0.351482, -0.915642, 0.195090>, <0.303079, -0.932782, 0.195090>, <0.300479, -0.924779, 0.233445> }
triangle { <0.303079, -0.932782, 0.195090>, <0.351482, -0.915642, 0.195090>, <0.353956, -0.922087, 0.156434> }
triangle { <0.353956, -0.922087, 0.156434>, <0.305212, -0.939347, 0.156434>, <0.303079, -0.932782, 0.195090> }
triangle { <0.305212, -0.939347, 0.156434>, <0.353956, -0.922087, 0.156434>, <0.355884, -0.927109, 0.117537> }
triangle { <0.355884, -0.927109, 0.117537>, <0.306875, -0.944464, 0.117537>, <0.305212, -0.939347, 0.156434> }
triangle { <0.306875, -0.944464, 0.117537>, <0.355884, -0.927109, 0.117537>, <0.357263, -0.930703, 0.078459> }
triangle { <0.357263, -0.930703, 0.078459>, <0.308064, -0.948125, 0.078459>, <0.306875, -0.944464, 0.117537> }
triangle { <0.308064, -0.948125, 0.078459>, <0.357263, -0.930703, 0.078459>, <0.358092, -0.932861, 0.039260> }
triangle { <0.358092, -0.932861, 0.039260>, <0.308779, -0.950323, 0.039260>, <0.308064, -0.948125, 0.078459> }
triangle { <0.308779, -0.950323, 0.039260>, <0.358092, -0.932861, 0.039260>, <0.358368, -0.933580, -0.000000> }
triangle { <0.358368, -0.933580, -0.000000>, <0.309017, -0.951057, -0.000000>, <0.308779, -0.950323, 0.039260> }
triangle { <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.015968, -0.035866, 0.999229> }
triangle { <0.015968, -0.035866, 0.999229>, <0.014069, -0.036652, 0.999229>, <0.000000, 0.000000, 1.000000> }
triangle { <0.014069, -0.036652, 0.999229>, <0.015968, -0.035866, 0.999229>, <0.031912, -0.071676, 0.996917> }
triangle { <0.031912, -0.071676, 0.996917>, <0.028117, -0.073248, 0.996917>, <0.014069, -0.036652, 0.999229> }
triangle { <0.028117, -0.073248, 0.996917>, <0.031912, -0.071676, 0.996917>, <0.047807, -0.107376, 0.993068> }
triangle { <0.047807, -0.107376, 0.993068>, <0.042122, -0.109731, 0.993068>, <0.028117, -0.073248, 0.996917> }
triangle { <0.042122, -0.109731, 0.993068>, <0.047807, -0.107376, 0.993068>, <0.063628, -0.142910, 0.987688> }
triangle { <0.063628, -0.142910, 0.987688>, <0.056061, -0.146044, 0.987688>, <0.042122, -0.109731, 0.993068> }
triangle { <0.056061, -0.146044, 0.987688>, <0.063628, -0.142910, 0.987688>, <0.079350, -0.178224, 0.980785> }
triangle { <0.079350, -0.178224, 0.980785>, <0.069914, -0.182133, 0.980785>, <0.056061, -0.146044, 0.987688> }
triangle { <0.069914, -0.182133, 0.980785>, <0.079350, -0.178224, 0.980785>, <0.094951, -0.213263, 0.972370> }
triangle { <0.094951, -0.213263, 0.972370>, <0.083659, -0.217940, 0.972370>, <0.069914, -0.182133, 0.980785> }
triangle { <0.083659, -0.217940, 0.972370>, <0.094951, -0.213263, 0.972370>, <0.110405, -0.247973, 0.962455> }
triangle { <0.110405, -0.247973, 0.962455>, <0.097276, -0.253411, 0.962455>, <0.083659, -0.217940, 0.972370> }
triangle { <0.097276, -0.253411, 0.962455>, <0.110405, -0.247973, 0.962455>, <0.125689, -0.282301, 0.951057> }
triangle { <0.125689, -0.282301, 0.951057>, <0.110742, -0.288492, 0.951057>, <0.097276, -0.253411, 0.962455> }
triangle { <0.110742, -0.288492, 0.951057>, <0.125689, -0.282301, 0.951057>, <0.140778, -0.316194, 0.938191> }
triangle { <0.140778, -0.316194, 0.938191>, <0.124037, -0.323128, 0.938191>, <0.110742, -0.288492, 0.951057> }
triangle { <0.124037, -0.323128, 0.938191>, <0.140778, -0.316194, 0.938191>, <0.155651, -0.349599, 0.923880> }
triangle { <0.155651, -0.349599, 0.923880>, <0.137141, -0.357266, 0.923880>, <0.124037, -0.323128, 0.938191> }
triangle { <0.137141, -0.357266, 0.923880>, <0.155651, -0.349599, 0.923880>, <0.170284, -0.382465, 0.908143> }
triangle { <0.170284, -0.382465, 0.908143>, <0.150034, -0.390853, 0.908143>, <0.137141, -0.357266, 0.923880> }
triangle { <0.150034, -0.390853, 0.908143>, <0.170284, -0.382465, 0.908143>, <0.184655, -0.414741, 0.891007> }
triangle { <0.184655, -0.414741, 0.891007>, <0.162696, -0.423837, 0.891007>, <0.150034, -0.390853, 0.908143> }
triangle { <0.162696, -0.423837, 0.891007>, <0.184655, -0.414741, 0.891007>, <0.198740, -0.446378, 0.872496> }
triangle { <0.198740, -0.446378, 0.872496>, <0.175106, -0.456167, 0.872496>, <0.162696, -0.423837, 0.891007> }
triangle { <0.175106, -0.456167, 0.872496>, <0.198740, -0.446378, 0.872496>, <0.212519, -0.477326, 0.852640> }
triangle { <0.212519, -0.477326, 0.852640>, <0.187247, -0.487794, 0.852640>, <0.175106, -0.456167, 0.872496> }
triangle { <0.187247, -0.487794, 0.852640>, <0.212519, -0.477326, 0.852640>, <0.225971, -0.507539, 0.831470> }
triangle { <0.225971, -0.507539, 0.831470>, <0.199099, -0.518669, 0.831470>, <0.187247, -0.487794, 0.852640> }
triangle { <0.199099, -0.518669, 0.831470>, <0.225971, -0.507539, 0.831470>, <0.239074, -0.536969, 0.809017> }
triangle { <0.239074, -0.536969, 0.809017>, <0.210643, -0.548745, 0.809017>, <0.199099, -0.518669, 0.831470> }
triangle { <0.210643, -0.548745, 0.809017>, <0.239074, -0.536969, 0.809017>, <0.251808, -0.565570, 0.785317> }
triangle { <0.251808, -0.565570, 0.785317>, <0.221863, -0.577974, 0.785317>, <0.210643, -0.548745, 0.809017> }
triangle { <0.221863, -0.577974, 0.785317>, <0.251808, -0.565570, 0.785317>, <0.264154, -0.593300, 0.760406> }
triangle { <0.264154, -0.593300, 0.760406>, <0.232741, -0.606312, 0.760406>, <0.221863, -0.577974, 0.785317> }
triangle { <0.232741, -0.606312, 0.760406>, <0.264154, -0.593300, 0.760406>, <0.276093, -0.620115, 0.734323> }
triangle { <0.276093, -0.620115, 0.734323>, <0.243260, -0.633715, 0.734323>, <0.232741, -0.606312, 0.760406> }
triangle { <0.243260, -0.633715, 0.734323>, <0.276093, -0.620115, 0.734323>, <0.287606, -0.645974, 0.707107> }
triangle { <0.287606, -0.645974, 0.707107>, <0.253404, -0.660141, 0.707107>, <0.243260, -0.633715, 0.734323> }
triangle { <0.253404, -0.660141, 0.707107>, <0.287606, -0.645974, 0.707107>, <0.298676, -0.670837, 0.678801> }
triangle { <0.298676, -0.670837, 0.678801>, <0.263158, -0.685549, 0.678801>, <0.253404, -0.660141, 0.707107> }
triangle { <0.263158, -0.685549, 0.678801>, <0.298676, -0.670837, 0.678801>, <0.309285, -0.694665, 0.649448> }
triangle { <0.309285, -0.694665, 0.649448>, <0.272505, -0.709900, 0.649448>, <0.263158, -0.685549, 0.678801> }
triangle { <0.272505, -0.709900, 0.649448>, <0.309285, -0.694665, 0.649448>, <0.319417, -0.717423, 0.619094> }
triangle { <0.319417, -0.717423, 0.619094>, <0.281432, -0.733157, 0.619094>, <0.272505, -0.709900, 0.649448> }
triangle { <0.281432, -0.733157, 0.619094>, <0.319417, -0.717423, 0.619094>, <0.329057, -0.739074, 0.587785> }
triangle { <0.329057, -0.739074, 0.587785>, <0.289926, -0.755282, 0.587785>, <0.281432, -0.733157, 0.619094> }
triangle { <0.289926, -0.755282, 0.587785>, <0.329057, -0.739074, 0.587785>, <0.338189, -0.759585, 0.555570> }
triangle { <0.338189, -0.759585, 0.555570>, <0.297972, -0.776244, 0.555570>, <0.289926, -0.755282, 0.587785> }
triangle { <0.297972, -0.776244, 0.555570>, <0.338189, -0.759585, 0.555570>, <0.346800, -0.778926, 0.522499> }
triangle { <0.346800, -0.778926, 0.522499>, <0.305559, -0.796008, 0.522499>, <0.297972, -0.776244, 0.555570> }
triangle { <0.305559, -0.796008, 0.522499>, <0.346800, -0.778926, 0.522499>, <0.354876, -0.797065, 0.488621> }
triangle { <0.354876, -0.797065, 0.488621>, <0.312675, -0.814545, 0.488621>, <0.305559, -0.796008, 0.522499> }
triangle { <0.312675, -0.814545, 0.488621>, <0.354876, -0.797065, 0.488621>, <0.362405, -0.813975, 0.453990> }
triangle { <0.362405, -0.813975, 0.453990>, <0.319308, -0.831826, 0.453990>, <0.312675, -0.814545, 0.488621> }
triangle { <0.319308, -0.831826, 0.453990>, <0.362405, -0.813975, 0.453990>, <0.369375, -0.829630, 0.418660> }
triangle { <0.369375, -0.829630, 0.418660>, <0.325449, -0.847825, 0.418660>, <0.319308, -0.831826, 0.453990> }
triangle { <0.325449, -0.847825, 0.418660>, <0.369375, -0.829630, 0.418660>, <0.375776, -0.844006, 0.382683> }
triangle { <0.375776, -0.844006, 0.382683>, <0.331089, -0.862516, 0.382683>, <0.325449, -0.847825, 0.418660> }
triangle { <0.331089, -0.862516, 0.382683>, <0.375776, -0.844006, 0.382683>, <0.381597, -0.857080, 0.346117> }
triangle { <0.381597, -0.857080, 0.346117>, <0.336218, -0.875877, 0.346117>, <0.331089, -0.862516, 0.382683> }
triangle { <0.336218, -0.875877, 0.346117>, <0.381597, -0.857080, 0.346117>, <0.386830, -0.868833, 0.309017> }
triangle { <0.386830, -0.868833, 0.309017>, <0.340828, -0.887888, 0.309017>, <0.336218, -0.875877, 0.346117> }
triangle { <0.340828, -0.887888, 0.309017>, <0.386830, -0.868833, 0.309017>, <0.391466, -0.879247, 0.271440> }
triangle { <0.391466, -0.879247, 0.271440>, <0.344913, -0.898529, 0.271440>, <0.340828, -0.887888, 0.309017> }
triangle { <0.344913, -0.898529, 0.271440>, <0.391466, -0.879247, 0.271440>, <0.395498, -0.888304, 0.233445> }
triangle { <0.395498, -0.888304, 0.233445>, <0.348466, -0.907786, 0.233445>, <0.344913, -0.898529, 0.271440> }
triangle { <0.348466, -0.907786, 0.233445>, <0.395498, -0.888304, 0.233445>, <0.398921, -0.895992, 0.195090> }
triangle { <0.398921, -0.895992, 0.195090>, <0.351482, -0.915642, 0.195090>, <0.348466, -0.907786, 0.233445> }
triangle { <0.351482, -0.915642, 0.195090>, <0.398921, -0.895992, 0.195090>, <0.401729, -0.902298, 0.156434> }
triangle { <0.401729, -0.902298, 0.156434>, <0.353956, -0.922087, 0.156434>, <0.351482, -0.915642, 0.195090> }
triangle { <0.353956, -0.922087, 0.156434>, <0.401729, -0.902298, 0.156434>, <0.403917, -0.907213, 0.117537> }
triangle { <0.403917, -0.907213, 0.117537>, <0.355884, -0.927109, 0.117537>, <0.353956, -0.922087, 0.156434> }
triangle { <0.355884, -0.927109, 0.117537>, <0.403917, -0.907213, 0.117537>, <0.405483, -0.910729, 0.078459> }
triangle { <0.405483, -0.910729, 0.078459>, <0.357263, -0.930703, 0.078459>, <0.355884, -0.927109, 0.117537> }
triangle { <0.357263, -0.930703, 0.078459>, <0.405483, -0.910729, 0.078459>, <0.406423, -0.912841, 0.039260> }
triangle { <0.406423, -0.912841, 0.039260>, <0.358092, -0.932861, 0.039260>, <0.357263, -0.930703, 0.078459> }
triangle { <0.358092, -0.932861, 0.039260>, <0.406423, -0.912841, 0.039260>, <0.406737, -0.913545, -0.000000> }
triangle { <0.406737, -0.913545, -0.000000>, <0.358368, -0.933580, -0.000000>, <0.358092, -0.932861, 0.039260> }
triangle { <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.017824, -0.034981, 0.999229> }
triangle { <0.017824, -0.034981, 0.999229>, <0.015968, -0.035866, 0.999229>, <0.000000, 0.000000, 1.000000> }
triangle { <0.015968, -0.035866, 0.999229>, <0.017824, -0.034981, 0.999229>, <0.035620, -0.069908, 0.996917> }
triangle { <0.035620, -0.069908, 0.996917>, <0.031912, -0.071676, 0.996917>, <0.015968, -0.035866, 0.999229> }
triangle { <0.031912, -0.071676, 0.996917>, <0.035620, -0.069908, 0.996917>, <0.053361, -0.104727, 0.993068> }
triangle { <0.053361, -0.104727, 0.993068>, <0.047807, -0.107376, 0.993068>, <0.031912, -0.071676, 0.996917> }
triangle { <0.047807, -0.107376, 0.993068>, <0.053361, -0.104727, 0.993068>, <0.071020, -0.139384, 0.987688> }
triangle { <0.071020, -0.139384, 0.987688>, <0.063628, -0.142910, 0.987688>, <0.047807, -0.107376, 0.993068> }
triangle { <0.063628, -0.142910, 0.987688>, <0.071020, -0.139384, 0.987688>, <0.088569, -0.173827, 0.980785> }
triangle { <0.088569, -0.173827, 0.980785>, <0.079350, -0.178224, 0.980785>, <0.063628, -0.142910, 0.987688> }
triangle { <0.079350, -0.178224, 0.980785>, <0.088569, -0.173827, 0.980785>, <0.105982, -0.208001, 0.972370> }
triangle { <0.105982, -0.208001, 0.972370>, <0.094951, -0.213263, 0.972370>, <0.079350, -0.178224, 0.980785> }
triangle { <0.094951, -0.213263, 0.972370>, <0.105982, -0.208001, 0.972370>, <0.123231, -0.241855, 0.962455> }
triangle { <0.123231, -0.241855, 0.962455>, <0.110405, -0.247973, 0.962455>, <0.094951, -0.213263, 0.972370> }
triangle { <0.110405, -0.247973, 0.962455>, <0.123231, -0.241855, 0.962455>, <0.140291, -0.275336, 0.951057> }
triangle { <0.140291, -0.275336, 0.951057>, <0.125689, -0.282301, 0.951057>, <0.110405, -0.247973, 0.962455> }
triangle { <0.125689, -0.282301, 0.951057>, <0.140291, -0.275336, 0.951057>, <0.157134, -0.308393, 0.938191> }
triangle { <0.157134, -0.308393, 0.938191>, <0.140778, -0.316194, 0.938191>, <0.125689, -0.282301, 0.951057> }
triangle { <0.140778, -0.316194, 0.938191>, <0.157134, -0.308393, 0.938191>, <0.173735, -0.340973, 0.923880> }
triangle { <0.173735, -0.340973, 0.923880>, <0.155651, -0.349599, 0.923880>, <0.140778, -0.316194, 0.938191> }
triangle { <0.155651, -0.349599, 0.923880>, <0.173735, -0.340973, 0.923880>, <0.190068, -0.373029, 0.908143> }
triangle { <0.190068, -0.373029, 0.908143>, <0.170284, -0.382465, 0.908143>, <0.155651, -0.349599, 0.923880> }
triangle { <0.170284, -0.382465, 0.908143>, <0.190068, -0.373029, 0.908143>, <0.206107, -0.404508, 0.891007> }
triangle { <0.206107, -0.404508, 0.891007>, <0.184655, -0.414741, 0.891007>, <0.170284, -0.382465, 0.908143> }
triangle { <0.184655, -0.414741, 0.891007>, <0.206107, -0.404508, 0.891007>, <0.221829, -0.435365, 0.872496> }
triangle { <0.221829, -0.435365, 0.872496>, <0.198740, -0.446378, 0.872496>, <0.184655, -0.414741, 0.891007> }
triangle { <0.198740, -0.446378, 0.872496>, <0.221829, -0.435365, 0.872496>, <0.237209, -0.465550, 0.852640> }
triangle { <0.237209, -0.465550, 0.852640>, <0.212519, -0.477326, 0.852640>, <0.198740, -0.446378, 0.872496> }
triangle { <0.212519, -0.477326, 0.852640>, <0.237209, -0.465550, 0.852640>, <0.252224, -0.495017, 0.831470> }
triangle { <0.252224, -0.495017, 0.831470>, <0.225971, -0.507539, 0.831470>, <0.212519, -0.477326, 0.852640> }
triangle { <0.225971, -0.507539, 0.831470>, <0.252224, -0.495017, 0.831470>, <0.266849, -0.523720, 0.809017> }
triangle { <0.266849, -0.523720, 0.809017>, <0.239074, -0.536969, 0.809017>, <0.225971, -0.507539, 0.831470> }
triangle { <0.239074, -0.536969, 0.809017>, <0.266849, -0.523720, 0.809017>, <0.281063, -0.551617, 0.785317> }
triangle { <0.281063, -0.551617, 0.785317>, <0.251808, -0.565570, 0.785317>, <0.239074, -0.536969, 0.809017> }
triangle { <0.251808, -0.565570, 0.785317>, <0.281063, -0.551617, 0.785317>, <0.294843, -0.578662, 0.760406> }
triangle { <0.294843, -0.578662, 0.760406>, <0.264154, -0.593300, 0.760406>, <0.251808, -0.565570, 0.785317> }
triangle { <0.264154, -0.593300, 0.760406>, <0.294843, -0.578662, 0.760406>, <0.308169, -0.604816, 0.734323> }
triangle { <0.308169, -0.604816, 0.734323>, <0.276093, -0.620115, 0.734323>, <0.264154, -0.593300, 0.760406> }
triangle { <0.276093, -0.620115, 0.734323>, <0.308169, -0.604816, 0.734323>, <0.321020, -0.630037, 0.707107> }
triangle { <0.321020, -0.630037, 0.707107>, <0.287606, -0.645974, 0.707107>, <0.276093, -0.620115, 0.734323> }
triangle { <0.287606, -0.645974, 0.707107>, <0.321020, -0.630037, 0.707107>, <0.333375, -0.654286, 0.678801> }
triangle { <0.333375, -0.654286, 0.678801>, <0.298676, -0.670837, 0.678801>, <0.287606, -0.645974, 0.707107> }
triangle { <0.298676, -0.670837, 0.678801>, <0.333375, -0.654286, 0.678801>, <0.345217, -0.677527, 0.649448> }
triangle { <0.345217, -0.677527, 0.649448>, <0.309285, -0.694665, 0.649448>, <0.298676, -0.670837, 0.678801> }
triangle { <0.309285, -0.694665, 0.649448>, <0.345217, -0.677527, 0.649448>, <0.356526, -0.699723, 0.619094> }
triangle { <0.356526, -0.699723, 0.619094>, <0.319417, -0.717423, 0.619094>, <0.309285, -0.694665, 0.649448> }
triangle { <0.319417, -0.717423, 0.619094>, <0.356526, -0.699723, 0.619094>, <0.367286, -0.720839, 0.587785> }
triangle { <0.367286, -0.720839, 0.587785>, <0.329057, -0.739074, 0.587785>, <0.319417, -0.717423, 0.619094> }
triangle { <0.329057, -0.739074, 0.587785>, <0.367286, -0.720839, 0.587785>, <0.377479, -0.740845, 0.555570> }
triangle { <0.377479, -0.740845, 0.555570>, <0.338189, -0.759585, 0.555570>, <0.329057, -0.739074, 0.587785> }
triangle { <0.338189, -0.759585, 0.555570>, <0.377479, -0.740845, 0.555570>, <0.387091, -0.759708, 0.522499> }
triangle { <0.387091, -0.759708, 0.522499>, <0.346800, -0.778926, 0.522499>, <0.338189, -0.759585, 0.555570> }
triangle { <0.346800, -0.778926, 0.522499>, <0.387091, -0.759708, 0.522499>, <0.396105, -0.777400, 0.488621> }
triangle { <0.396105, -0.777400, 0.488621>, <0.354876, -0.797065, 0.488621>, <0.346800, -0.778926, 0.522499> }
triangle { <0.354876, -0.797065, 0.488621>, <0.396105, -0.777400, 0.488621>, <0.404508, -0.793893, 0.453990> }
triangle { <0.404508, -0.793893, 0.453990>, <0.362405, -0.813975, 0.453990>, <0.354876, -0.797065, 0.488621> }
triangle { <0.362405, -0.813975, 0.453990>, <0.404508, -0.793893, 0.453990>, <0.412288, -0.809161, 0.418660> }
triangle { <0.412288, -0.809161, 0.418660>, <0.369375, -0.829630, 0.418660>, <0.362405, -0.813975, 0.453990> }
triangle { <0.369375, -0.829630, 0.418660>, <0.412288, -0.809161, 0.418660>, <0.419433, -0.823183, 0.382683> }
triangle { <0.419433, -0.823183, 0.382683>, <0.375776, -0.844006, 0.382683>, <0.369375, -0.829630, 0.418660> }
triangle { <0.375776, -0.844006, 0.382683>, <0.419433, -0.823183, 0.382683>, <0.425930, -0.835935, 0.346117> }
triangle { <0.425930, -0.835935, 0.346117>, <0.381597, -0.857080, 0.346117>, <0.375776, -0.844006, 0.382683> }
triangle { <0.381597, -0.857080, 0.346117>, <0.425930, -0.835935, 0.346117>, <0.431771, -0.847398, 0.309017> }
triangle { <0.431771, -0.847398, 0.309017>, <0.386830, -0.868833, 0.309017>, <0.381597, -0.857080, 0.346117> }
triangle { <0.386830, -0.868833, 0.309017>, <0.431771, -0.847398, 0.309017>, <0.436946, -0.857554, 0.271440> }
triangle { <0.436946, -0.857554, 0.271440>, <0.391466, -0.879247, 0.271440>, <0.386830, -0.868833, 0.309017> }
triangle { <0.391466, -0.879247, 0.271440>, <0.436946, -0.857554, 0.271440>, <0.441447, -0.866388, 0.233445> }
triangle { <0.441447, -0.866388, 0.233445>, <0.395498, -0.888304, 0.233445>, <0.391466, -0.879247, 0.271440> }
triangle { <0.395498, -0.888304, 0.233445>, <0.441447, -0.866388, 0.233445>, <0.445267, -0.873886, 0.195090> }
triangle { <0.445267, -0.873886, 0.195090>, <0.398921, -0.895992, 0.195090>, <0.395498, -0.888304, 0.233445> }
triangle { <0.398921, -0.895992, 0.195090>, <0.445267, -0.873886, 0.195090>, <0.448401, -0.880037, 0.156434> }
triangle { <0.448401, -0.880037, 0.156434>, <0.401729, -0.902298, 0.156434>, <0.398921, -0.895992, 0.195090> }
triangle { <0.401729, -0.902298, 0.156434>, <0.448401, -0.880037, 0.156434>, <0.450844, -0.884830, 0.117537> }
triangle { <0.450844, -0.884830, 0.117537>, <0.403917, -0.907213, 0.117537>, <0.401729, -0.902298, 0.156434> }
triangle { <0.403917, -0.907213, 0.117537>, <0.450844, -0.884830, 0.117537>, <0.452591, -0.888260, 0.078459> }
triangle { <0.452591, -0.888260, 0.078459>, <0.405483, -0.910729, 0.078459>, <0.403917, -0.907213, 0.117537> }
triangle { <0.405483, -0.910729, 0.078459>, <0.452591, -0.888260, 0.078459>, <0.453640, -0.890320, 0.039260> }
triangle { <0.453640, -0.890320, 0.039260>, <0.406423, -0.912841, 0.039260>, <0.405483, -0.910729, 0.078459> }
triangle { <0.406423, -0.912841, 0.039260>, <0.453640, -0.890320, 0.039260>, <0.453991, -0.891007, -0.000000> }
triangle { <0.453991, -0.891007, -0.000000>, <0.406737, -0.913545, -0.000000>, <0.406423, -0.912841, 0.039260> }
triangle { <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.019630, -0.034000, 0.999229> }
triangle { <0.019630, -0.034000, 0.999229>, <0.017824, -0.034981, 0.999229>, <0.000000, 0.000000, 1.000000> }
triangle { <0.017824, -0.034981, 0.999229>, <0.019630, -0.034000, 0.999229>, <0.039230, -0.067948, 0.996917> }
triangle { <0.039230, -0.067948, 0.996917>, <0.035620, -0.069908, 0.996917>, <0.017824, -0.034981, 0.999229> }
triangle { <0.035620, -0.069908, 0.996917>, <0.039230, -0.067948, 0.996917>, <0.058769, -0.101790, 0.993068> }
triangle { <0.058769, -0.101790, 0.993068>, <0.053361, -0.104727, 0.993068>, <0.035620, -0.069908, 0.996917> }
triangle { <0.053361, -0.104727, 0.993068>, <0.058769, -0.101790, 0.993068>, <0.078217, -0.135476, 0.987688> }
triangle { <0.078217, -0.135476, 0.987688>, <0.071020, -0.139384, 0.987688>, <0.053361, -0.104727, 0.993068> }
triangle { <0.071020, -0.139384, 0.987688>, <0.078217, -0.135476, 0.987688>, <0.097545, -0.168953, 0.980785> }
triangle { <0.097545, -0.168953, 0.980785>, <0.088569, -0.173827, 0.980785>, <0.071020, -0.139384, 0.987688> }
triangle { <0.088569, -0.173827, 0.980785>, <0.097545, -0.168953, 0.980785>, <0.116723, -0.202170, 0.972370> }
triangle { <0.116723, -0.202170, 0.972370>, <0.105982, -0.208001, 0.972370>, <0.088569, -0.173827, 0.980785> }
triangle { <0.105982, -0.208001, 0.972370>, <0.116723, -0.202170, 0.972370>, <0.135720, -0.235074, 0.962455> }
triangle { <0.135720, -0.235074, 0.962455>, <0.123231, -0.241855, 0.962455>, <0.105982, -0.208001, 0.972370> }
triangle { <0.123231, -0.241855, 0.962455>, <0.135720, -0.235074, 0.962455>, <0.154508, -0.267617, 0.951057> }
triangle { <0.154508, -0.267617, 0.951057>, <0.140291, -0.275336, 0.951057>, <0.123231, -0.241855, 0.962455> }
triangle { <0.140291, -0.275336, 0.951057>, <0.154508, -0.267617, 0.951057>, <0.173059, -0.299746, 0.938191> }
triangle { <0.173059, -0.299746, 0.938191>, <0.157134, -0.308393, 0.938191>, <0.140291, -0.275336, 0.951057> }
triangle { <0.157134, -0.308393, 0.938191>, <0.173059, -0.299746, 0.938191>, <0.191342, -0.331414, 0.923880> }
triangle { <0.191342, -0.331414, 0.923880>, <0.173735, -0.340973, 0.923880>, <0.157134, -0.308393, 0.938191> }
triangle { <0.173735, -0.340973, 0.923880>, <0.191342, -0.331414, 0.923880>, <0.209330, -0.362570, 0.908143> }
triangle { <0.209330, -0.362570, 0.908143>, <0.190068, -0.373029, 0.908143>, <0.173735, -0.340973, 0.923880> }
triangle { <0.190068, -0.373029, 0.908143>, <0.209330, -0.362570, 0.908143>, <0.226995, -0.393167, 0.891007> }
triangle { <0.226995, -0.393167, 0.891007>, <0.206107, -0.404508, 0.891007>, <0.190068, -0.373029, 0.908143> }
triangle { <0.206107, -0.404508, 0.891007>, <0.226995, -0.393167, 0.891007>, <0.244311, -0.423158, 0.872496> }
triangle { <0.244311, -0.423158, 0.872496>, <0.221829, -0.435365, 0.872496>, <0.206107, -0.404508, 0.891007> }
triangle { <0.221829, -0.435365, 0.872496>, <0.244311, -0.423158, 0.872496>, <0.261249, -0.452497, 0.852640> }
triangle { <0.261249, -0.452497, 0.852640>, <0.237209, -0.465550, 0.852640>, <0.221829, -0.435365, 0.872496> }
triangle { <0.237209, -0.465550, 0.852640>, <0.261249, -0.452497, 0.852640>, <0.277785, -0.481138, 0.831470> }
triangle { <0.277785, -0.481138, 0.831470>, <0.252224, -0.495017, 0.831470>, <0.237209, -0.465550, 0.852640> }
triangle { <0.252224, -0.495017, 0.831470>, <0.277785, -0.481138, 0.831470>, <0.293893, -0.509037, 0.809017> }
triangle { <0.293893, -0.509037, 0.809017>, <0.266849, -0.523720, 0.809017>, <0.252224, -0.495017, 0.831470> }
triangle { <0.266849, -0.523720, 0.809017>, <0.293893, -0.509037, 0.809017>, <0.309547, -0.536151, 0.785317> }
triangle { <0.309547, -0.536151, 0.785317>, <0.281063, -0.551617, 0.785317>, <0.266849, -0.523720, 0.809017> }
triangle { <0.281063, -0.551617, 0.785317>, <0.309547, -0.536151, 0.785317>, <0.324724, -0.562439, 0.760406> }
triangle { <0.324724, -0.562439, 0.760406>, <0.294843, -0.578662, 0.760406>, <0.281063, -0.551617, 0.785317> }
triangle { <0.294843, -0.578662, 0.760406>, <0.324724, -0.562439, 0.760406>, <0.339400, -0.587859, 0.734323> }
triangle { <0.339400, -0.587859, 0.734323>, <0.308169, -0.604816, 0.734323>, <0.294843, -0.578662, 0.760406> }
triangle { <0.308169, -0.604816, 0.734323>, <0.339400, -0.587859, 0.734323>, <0.353553, -0.612372, 0.707107> }
triangle { <0.353553, -0.612372, 0.707107>, <0.321020, -0.630037, 0.707107>, <0.308169, -0.604816, 0.734323> }
triangle { <0.321020, -0.630037, 0.707107>, <0.353553, -0.612372, 0.707107>, <0.367161, -0.635942, 0.678801> }
triangle { <0.367161, -0.635942, 0.678801>, <0.333375, -0.654286, 0.678801>, <0.321020, -0.630037, 0.707107> }
triangle { <0.333375, -0.654286, 0.678801>, <0.367161, -0.635942, 0.678801>, <0.380203, -0.658531, 0.649448> }
triangle { <0.380203, -0.658531, 0.649448>, <0.345217, -0.677527, 0.649448>, <0.333375, -0.654286, 0.678801> }
triangle { <0.345217, -0.677527, 0.649448>, <0.380203, -0.658531, 0.649448>, <0.392658, -0.680104, 0.619094> }
triangle { <0.392658, -0.680104, 0.619094>, <0.356526, -0.699723, 0.619094>, <0.345217, -0.677527, 0.649448> }
triangle { <0.356526, -0.699723, 0.619094>, <0.392658, -0.680104, 0.619094>, <0.404508, -0.700629, 0.587785> }
triangle { <0.404508, -0.700629, 0.587785>, <0.367286, -0.720839, 0.587785>, <0.356526, -0.699723, 0.619094> }
triangle { <0.367286, -0.720839, 0.587785>, <0.404508, -0.700629, 0.587785>, <0.415735, -0.720074, 0.555570> }
triangle { <0.415735, -0.720074, 0.555570>, <0.377479, -0.740845, 0.555570>, <0.367286, -0.720839, 0.587785> }
triangle { <0.377479, -0.740845, 0.555570>, <0.415735, -0.720074, 0.555570>, <0.426320, -0.738408, 0.522499> }
triangle { <0.426320, -0.738408, 0.522499>, <0.387091, -0.759708, 0.522499>, <0.377479, -0.740845, 0.555570> }
triangle { <0.387091, -0.759708, 0.522499>, <0.426320, -0.738408, 0.522499>, <0.436248, -0.755604, 0.488621> }
triangle { <0.436248, -0.755604, 0.488621>, <0.396105, -0.777400, 0.488621>, <0.387091, -0.759708, 0.522499> }
triangle { <0.396105, -0.777400, 0.488621>, <0.436248, -0.755604, 0.488621>, <0.445503, -0.771634, 0.453990> }
triangle { <0.445503, -0.771634, 0.453990>, <0.404508, -0.793893, 0.453990>, <0.396105, -0.777400, 0.488621> }
triangle { <0.404508, -0.793893, 0.453990>, <0.445503, -0.771634, 0.453990>, <0.454072, -0.786475, 0.418660> }
triangle { <0.454072, -0.786475, 0.418660>, <0.412288, -0.809161, 0.418660>, <0.404508, -0.793893, 0.453990> }
triangle { <0.412288, -0.809161, 0.418660>, <0.454072, -0.786475, 0.418660>, <0.461940, -0.800103, 0.382683> }
triangle { <0.461940, -0.800103, 0.382683>, <0.419433, -0.823183, 0.382683>, <0.412288, -0.809161, 0.418660> }
triangle { <0.419433, -0.823183, 0.382683>, <0.461940, -0.800103, 0.382683>, <0.469096, -0.812498, 0.346117> }
triangle { <0.469096, -0.812498, 0.346117>, <0.425930, -0.835935, 0.346117>, <0.419433, -0.823183, 0.382683> }
triangle { <0.425930, -0.835935, 0.346117>, <0.469096, -0.812498, 0.346117>, <0.475528, -0.823639, 0.309017> }
triangle { <0.475528, -0.823639, 0.309017>, <0.431771, -0.847398, 0.309017>, <0.425930, -0.835935, 0.346117> }
triangle { <0.431771, -0.847398, 0.309017>, <0.475528, -0.823639, 0.309017>, <0.481228, -0.833511, 0.271440> }
triangle { <0.481228, -0.833511, 0.271440>, <0.436946, -0.857554, 0.271440>, <0.431771, -0.847398, 0.309017> }
triangle { <0.436946, -0.857554, 0.271440>, <0.481228, -0.833511, 0.271440>, <0.486185, -0.842097, 0.233445> }
triangle { <0.486185, -0.842097, 0.233445>, <0.441447, -0.866388, 0.233445>, <0.436946, -0.857554, 0.271440> }
triangle { <0.441447, -0.866388, 0.233445>, <0.486185, -0.842097, 0.233445>, <0.490393, -0.849385, 0.195090> }
triangle { <0.490393, -0.849385, 0.195090>, <0.445267, -0.873886, 0.195090>, <0.441447, -0.866388, 0.233445> }
triangle { <0.445267, -0.873886, 0.195090>, <0.490393, -0.849385, 0.195090>, <0.493844, -0.855363, 0.156434> }
triangle { <0.493844, -0.855363, 0.156434>, <0.448401, -0.880037, 0.156434>, <0.445267, -0.873886, 0.195090> }
triangle { <0.448401, -0.880037, 0.156434>, <0.493844, -0.855363, 0.156434>, <0.496534, -0.860023, 0.117537> }
triangle { <0.496534, -0.860023, 0.117537>, <0.450844, -0.884830, 0.117537>, <0.448401, -0.880037, 0.156434> }
triangle { <0.450844, -0.884830, 0.117537>, <0.496534, -0.860023, 0.117537>, <0.498459, -0.863356, 0.078459> }
triangle { <0.498459, -0.863356, 0.078459>, <0.452591, -0.888260, 0.078459>, <0.450844, -0.884830, 0.117537> }
triangle { <0.452591, -0.888260, 0.078459>, <0.498459, -0.863356, 0.078459>, <0.499615, -0.865358, 0.039260> }
triangle { <0.499615, -0.865358, 0.039260>, <0.453640, -0.890320, 0.039260>, <0.452591, -0.888260, 0.078459> }
triangle { <0.453640, -0.890320, 0.039260>, <0.499615, -0.865358, 0.039260>, <0.500000, -0.866025, -0.000000> }
triangle { <0.500000, -0.866025, -0.000000>, <0.453991, -0.891007, -0.000000>, <0.453640, -0.890320, 0.039260> }
triangle { <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.021382, -0.032926, 0.999229> }
triangle { <0.021382, -0.032926, 0.999229>, <0.019630, -0.034000, 0.999229>, <0.000000, 0.000000, 1.000000> }
triangle { <0.019630, -0.034000, 0.999229>, <0.021382, -0.032926, 0.999229>, <0.042732, -0.065801, 0.996917> }
triangle { <0.042732, -0.065801, 0.996917>, <0.039230, -0.067948, 0.996917>, <0.019630, -0.034000, 0.999229> }
triangle { <0.039230, -0.067948, 0.996917>, <0.042732, -0.065801, 0.996917>, <0.064015, -0.098575, 0.993068> }
triangle { <0.064015, -0.098575, 0.993068>, <0.058769, -0.101790, 0.993068>, <0.039230, -0.067948, 0.996917> }
triangle { <0.058769, -0.101790, 0.993068>, <0.064015, -0.098575, 0.993068>, <0.085200, -0.131197, 0.987688> }
triangle { <0.085200, -0.131197, 0.987688>, <0.078217, -0.135476, 0.987688>, <0.058769, -0.101790, 0.993068> }
triangle { <0.078217, -0.135476, 0.987688>, <0.085200, -0.131197, 0.987688>, <0.106254, -0.163617, 0.980785> }
triangle { <0.106254, -0.163617, 0.980785>, <0.097545, -0.168953, 0.980785>, <0.078217, -0.135476, 0.987688> }
triangle { <0.097545, -0.168953, 0.980785>, <0.106254, -0.163617, 0.980785>, <0.127143, -0.195784, 0.972370> }
triangle { <0.127143, -0.195784, 0.972370>, <0.116723, -0.202170, 0.972370>, <0.097545, -0.168953, 0.980785> }
triangle { <0.116723, -0.202170, 0.972370>, <0.127143, -0.195784, 0.972370>, <0.147837, -0.227649, 0.962455> }
triangle { <0.147837, -0.227649, 0.962455>, <0.135720, -0.235074, 0.962455>, <0.116723, -0.202170, 0.972370> }
triangle { <0.135720, -0.235074, 0.962455>, <0.147837, -0.227649, 0.962455>, <0.168303, -0.259163, 0.951057> }
triangle { <0.168303, -0.259163, 0.951057>, <0.154508, -0.267617, 0.951057>, <0.135720, -0.235074, 0.962455> }
triangle { <0.154508, -0.267617, 0.951057>, <0.168303, -0.259163, 0.951057>, <0.188509, -0.290278, 0.938191> }
triangle { <0.188509, -0.290278, 0.938191>, <0.173059, -0.299746, 0.938191>, <0.154508, -0.267617, 0.951057> }
triangle { <0.173059, -0.299746, 0.938191>, <0.188509, -0.290278, 0.938191>, <0.208424, -0.320945, 0.923880> }
triangle { <0.208424, -0.320945, 0.923880>, <0.191342, -0.331414, 0.923880>, <0.173059, -0.299746, 0.938191> }
triangle { <0.191342, -0.331414, 0.923880>, <0.208424, -0.320945, 0.923880>, <0.228018, -0.351118, 0.908143> }
triangle { <0.228018, -0.351118, 0.908143>, <0.209330, -0.362570, 0.908143>, <0.191342, -0.331414, 0.923880> }
triangle { <0.209330, -0.362570, 0.908143>, <0.228018, -0.351118, 0.908143>, <0.247261, -0.380748, 0.891007> }
triangle { <0.247261, -0.380748, 0.891007>, <0.226995, -0.393167, 0.891007>, <0.209330, -0.362570, 0.908143> }
triangle { <0.226995, -0.393167, 0.891007>, <0.247261, -0.380748, 0.891007>, <0.266122, -0.409792, 0.872496> }
triangle { <0.266122, -0.409792, 0.872496>, <0.244311, -0.423158, 0.872496>, <0.226995, -0.393167, 0.891007> }
triangle { <0.244311, -0.423158, 0.872496>, <0.266122, -0.409792, 0.872496>, <0.284573, -0.438204, 0.852640> }
triangle { <0.284573, -0.438204, 0.852640>, <0.261249, -0.452497, 0.852640>, <0.244311, -0.423158, 0.872496> }
triangle { <0.261249, -0.452497, 0.852640>, <0.284573, -0.438204, 0.852640>, <0.302585, -0.465940, 0.831470> }
triangle { <0.302585, -0.465940, 0.831470>, <0.277785, -0.481138, 0.831470>, <0.261249, -0.452497, 0.852640> }
triangle { <0.277785, -0.481138, 0.831470>, <0.302585, -0.465940, 0.831470>, <0.320131, -0.492958, 0.809017> }
triangle { <0.320131, -0.492958, 0.809017>, <0.293893, -0.509037, 0.809017>, <0.277785, -0.481138, 0.831470> }
triangle { <0.293893, -0.509037, 0.809017>, <0.320131, -0.492958, 0.809017>, <0.337183, -0.519216, 0.785317> }
triangle { <0.337183, -0.519216, 0.785317>, <0.309547, -0.536151, 0.785317>, <0.293893, -0.509037, 0.809017> }
triangle { <0.309547, -0.536151, 0.785317>, <0.337183, -0.519216, 0.785317>, <0.353715, -0.544673, 0.760406> }
triangle { <0.353715, -0.544673, 0.760406>, <0.324724, -0.562439, 0.760406>, <0.309547, -0.536151, 0.785317> }
triangle { <0.324724, -0.562439, 0.760406>, <0.353715, -0.544673, 0.760406>, <0.369701, -0.569290, 0.734323> }
triangle { <0.369701, -0.569290, 0.734323>, <0.339400, -0.587859, 0.734323>, <0.324724, -0.562439, 0.760406> }
triangle { <0.339400, -0.587859, 0.734323>, <0.369701, -0.569290, 0.734323>, <0.385118, -0.593030, 0.707107> }
triangle { <0.385118, -0.593030, 0.707107>, <0.353553, -0.612372, 0.707107>, <0.339400, -0.587859, 0.734323> }
triangle { <0.353553, -0.612372, 0.707107>, <0.385118, -0.593030, 0.707107>, <0.399941, -0.615855, 0.678801> }
triangle { <0.399941, -0.615855, 0.678801>, <0.367161, -0.635942, 0.678801>, <0.353553, -0.612372, 0.707107> }
triangle { <0.367161, -0.635942, 0.678801>, <0.399941, -0.615855, 0.678801>, <0.414147, -0.637730, 0.649448> }
triangle { <0.414147, -0.637730, 0.649448>, <0.380203, -0.658531, 0.649448>, <0.367161, -0.635942, 0.678801> }
triangle { <0.380203, -0.658531, 0.649448>, <0.414147, -0.637730, 0.649448>, <0.427714, -0.658622, 0.619094> }
triangle { <0.427714, -0.658622, 0.619094>, <0.392658, -0.680104, 0.619094>, <0.380203, -0.658531, 0.649448> }
triangle { <0.392658, -0.680104, 0.619094>, <0.427714, -0.658622, 0.619094>, <0.440622, -0.678499, 0.587785> }
triangle { <0.440622, -0.678499, 0.587785>, <0.404508, -0.700629, 0.587785>, <0.392658, -0.680104, 0.619094> }
triangle { <0.404508, -0.700629, 0.587785>, <0.440622, -0.678499, 0.587785>, <0.452851, -0.697329, 0.555570> }
triangle { <0.452851, -0.697329, 0.555570>, <0.415735, -0.720074, 0.555570>, <0.404508, -0.700629, 0.587785> }
triangle { <0.415735, -0.720074, 0.555570>, <0.452851, -0.697329, 0.555570>, <0.464381, -0.715084, 0.522499> }
triangle { <0.464381, -0.715084, 0.522499>, <0.426320, -0.738408, 0.522499>, <0.415735, -0.720074, 0.555570> }
triangle { <0.426320, -0.738408, 0.522499>, <0.464381, -0.715084, 0.522499>, <0.475195, -0.731737, 0.488621> }
triangle { <0.475195, -0.731737, 0.488621>, <0.436248, -0.755604, 0.488621>, <0.426320, -0.738408, 0.522499> }
triangle { <0.436248, -0.755604, 0.488621>, <0.475195, -0.731737, 0.488621>, <0.485277, -0.747261, 0.453990> }
triangle { <0.485277, -0.747261, 0.453990>, <0.445503, -0.771634, 0.453990>, <0.436248, -0.755604, 0.488621> }
triangle { <0.445503, -0.771634, 0.453990>, <0.485277, -0.747261, 0.453990>, <0.494610, -0.761633, 0.418660> }
triangle { <0.494610, -0.761633, 0.418660>, <0.454072, -0.786475, 0.418660>, <0.445503, -0.771634, 0.453990> }
triangle { <0.454072, -0.786475, 0.418660>, <0.494610, -0.761633, 0.418660>, <0.503181, -0.774831, 0.382683> }
triangle { <0.503181, -0.774831, 0.382683>, <0.461940, -0.800103, 0.382683>, <0.454072, -0.786475, 0.418660> }
triangle { <0.461940, -0.800103, 0.382683>, <0.503181, -0.774831, 0.382683>, <0.510976, -0.786833, 0.346117> }
triangle { <0.510976, -0.786833, 0.346117>, <0.469096, -0.812498, 0.346117>, <0.461940, -0.800103, 0.382683> }
triangle { <0.469096, -0.812498, 0.346117>, <0.510976, -0.786833, 0.346117>, <0.517983, -0.797623, 0.309017> }
triangle { <0.517983, -0.797623, 0.309017>, <0.475528, -0.823639, 0.309017>, <0.469096, -0.812498, 0.346117> }
triangle { <0.475528, -0.823639, 0.309017>, <0.517983, -0.797623, 0.309017>, <0.524191, -0.807183, 0.271440> }
triangle { <0.524191, -0.807183, 0.271440>, <0.481228, -0.833511, 0.271440>, <0.475528, -0.823639, 0.309017> }
triangle { <0.481228, -0.833511, 0.271440>, <0.524191, -0.807183, 0.271440>, <0.529591, -0.815498, 0.233445> }
triangle { <0.529591, -0.815498, 0.233445>, <0.486185, -0.842097, 0.233445>, <0.481228, -0.833511, 0.271440> }
triangle { <0.486185, -0.842097, 0.233445>, <0.529591, -0.815498, 0.233445>, <0.534174, -0.822556, 0.195090> }
triangle { <0.534174, -0.822556, 0.195090>, <0.490393, -0.849385, 0.195090>, <0.486185, -0.842097, 0.233445> }
triangle { <0.490393, -0.849385, 0.195090>, <0.534174, -0.822556, 0.195090>, <0.537934, -0.828345, 0.156434> }
triangle { <0.537934, -0.828345, 0.156434>, <0.493844, -0.855363, 0.156434>, <0.490393, -0.849385, 0.195090> }
triangle { <0.493844, -0.855363, 0.156434>, <0.537934, -0.828345, 0.156434>, <0.540864, -0.832857, 0.117537> }
triangle { <0.540864, -0.832857, 0.117537>, <0.496534, -0.860023, 0.117537>, <0.493844, -0.855363, 0.156434> }
triangle { <0.496534, -0.860023, 0.117537>, <0.540864, -0.832857, 0.117537>, <0.542960, -0.836085, 0.078459> }
triangle { <0.542960, -0.836085, 0.078459>, <0.498459, -0.863356, 0.078459>, <0.496534, -0.860023, 0.117537> }
triangle { <0.498459, -0.863356, 0.078459>, <0.542960, -0.836085, 0.078459>, <0.544219, -0.838024, 0.039260> }
triangle { <0.544219, -0.838024, 0.039260>, <0.499615, -0.865358, 0.039260>, <0.498459, -0.863356, 0.078459> }
triangle { <0.499615, -0.865358, 0.039260>, <0.544219, -0.838024, 0.039260>, <0.544639, -0.838671, -0.000000> }
triangle { <0.544639, -0.838671, -0.000000>, <0.500000, -0.866025, -0.000000>, <0.499615, -0.865358, 0.039260> }
triangle { <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.023076, -0.031762, 0.999229> }
triangle { <0.023076, -0.031762, 0.999229>, <0.021382, -0.032926, 0.999229>, <0.000000, 0.000000, 1.000000> }
triangle { <0.021382, -0.032926, 0.999229>, <0.023076, -0.031762, 0.999229>, <0.046117, -0.063475, 0.996917> }
triangle { <0.046117, -0.063475, 0.996917>, <0.042732, -0.065801, 0.996917>, <0.021382, -0.032926, 0.999229> }
triangle { <0.042732, -0.065801, 0.996917>, <0.046117, -0.063475, 0.996917>, <0.069087, -0.095090, 0.993068> }
triangle { <0.069087, -0.095090, 0.993068>, <0.064015, -0.098575, 0.993068>, <0.042732, -0.065801, 0.996917> }
triangle { <0.064015, -0.098575, 0.993068>, <0.069087, -0.095090, 0.993068>, <0.091950, -0.126558, 0.987688> }
triangle { <0.091950, -0.126558, 0.987688>, <0.085200, -0.131197, 0.987688>, <0.064015, -0.098575, 0.993068> }
triangle { <0.085200, -0.131197, 0.987688>, <0.091950, -0.126558, 0.987688>, <0.114671, -0.157831, 0.980785> }
triangle { <0.114671, -0.157831, 0.980785>, <0.106254, -0.163617, 0.980785>, <0.085200, -0.131197, 0.987688> }
triangle { <0.106254, -0.163617, 0.980785>, <0.114671, -0.157831, 0.980785>, <0.137216, -0.188861, 0.972370> }
triangle { <0.137216, -0.188861, 0.972370>, <0.127143, -0.195784, 0.972370>, <0.106254, -0.163617, 0.980785> }
triangle { <0.127143, -0.195784, 0.972370>, <0.137216, -0.188861, 0.972370>, <0.159549, -0.219600, 0.962455> }
triangle { <0.159549, -0.219600, 0.962455>, <0.147837, -0.227649, 0.962455>, <0.127143, -0.195784, 0.972370> }
triangle { <0.147837, -0.227649, 0.962455>, <0.159549, -0.219600, 0.962455>, <0.181636, -0.250000, 0.951057> }
triangle { <0.181636, -0.250000, 0.951057>, <0.168303, -0.259163, 0.951057>, <0.147837, -0.227649, 0.962455> }
triangle { <0.168303, -0.259163, 0.951057>, <0.181636, -0.250000, 0.951057>, <0.203443, -0.280015, 0.938191> }
triangle { <0.203443, -0.280015, 0.938191>, <0.188509, -0.290278, 0.938191>, <0.168303, -0.259163, 0.951057> }
triangle { <0.188509, -0.290278, 0.938191>, <0.203443, -0.280015, 0.938191>, <0.224936, -0.309597, 0.923880> }
triangle { <0.224936, -0.309597, 0.923880>, <0.208424, -0.320945, 0.923880>, <0.188509, -0.290278, 0.938191> }
triangle { <0.208424, -0.320945, 0.923880>, <0.224936, -0.309597, 0.923880>, <0.246082, -0.338703, 0.908143> }
triangle { <0.246082, -0.338703, 0.908143>, <0.228018, -0.351118, 0.908143>, <0.208424, -0.320945, 0.923880> }
triangle { <0.228018, -0.351118, 0.908143>, <0.246082, -0.338703, 0.908143>, <0.266849, -0.367286, 0.891007> }
triangle { <0.266849, -0.367286, 0.891007>, <0.247261, -0.380748, 0.891007>, <0.228018, -0.351118, 0.908143> }
triangle { <0.247261, -0.380748, 0.891007>, <0.266849, -0.367286, 0.891007>, <0.287204, -0.395303, 0.872496> }
triangle { <0.287204, -0.395303, 0.872496>, <0.266122, -0.409792, 0.872496>, <0.247261, -0.380748, 0.891007> }
triangle { <0.266122, -0.409792, 0.872496>, <0.287204, -0.395303, 0.872496>, <0.307117, -0.422710, 0.852640> }
triangle { <0.307117, -0.422710, 0.852640>, <0.284573, -0.438204, 0.852640>, <0.266122, -0.409792, 0.872496> }
triangle { <0.284573, -0.438204, 0.852640>, <0.307117, -0.422710, 0.852640>, <0.326556, -0.449466, 0.831470> }
triangle { <0.326556, -0.449466, 0.831470>, <0.302585, -0.465940, 0.831470>, <0.284573, -0.438204, 0.852640> }
triangle { <0.302585, -0.465940, 0.831470>, <0.326556, -0.449466, 0.831470>, <0.345492, -0.475528, 0.809017> }
triangle { <0.345492, -0.475528, 0.809017>, <0.320131, -0.492958, 0.809017>, <0.302585, -0.465940, 0.831470> }
triangle { <0.320131, -0.492958, 0.809017>, <0.345492, -0.475528, 0.809017>, <0.363894, -0.500858, 0.785317> }
triangle { <0.363894, -0.500858, 0.785317>, <0.337183, -0.519216, 0.785317>, <0.320131, -0.492958, 0.809017> }
triangle { <0.337183, -0.519216, 0.785317>, <0.363894, -0.500858, 0.785317>, <0.381736, -0.525415, 0.760406> }
triangle { <0.381736, -0.525415, 0.760406>, <0.353715, -0.544673, 0.760406>, <0.337183, -0.519216, 0.785317> }
triangle { <0.353715, -0.544673, 0.760406>, <0.381736, -0.525415, 0.760406>, <0.398989, -0.549161, 0.734323> }
triangle { <0.398989, -0.549161, 0.734323>, <0.369701, -0.569290, 0.734323>, <0.353715, -0.544673, 0.760406> }
triangle { <0.369701, -0.569290, 0.734323>, <0.398989, -0.549161, 0.734323>, <0.415627, -0.572061, 0.707107> }
triangle { <0.415627, -0.572061, 0.707107>, <0.385118, -0.593030, 0.707107>, <0.369701, -0.569290, 0.734323> }
triangle { <0.385118, -0.593030, 0.707107>, <0.415627, -0.572061, 0.707107>, <0.431624, -0.594079, 0.678801> }
triangle { <0.431624, -0.594079, 0.678801>, <0.399941, -0.615855, 0.678801>, <0.385118, -0.593030, 0.707107> }
triangle { <0.399941, -0.615855, 0.678801>, <0.431624, -0.594079, 0.678801>, <0.446955, -0.615181, 0.649448> }
triangle { <0.446955, -0.615181, 0.649448>, <0.414147, -0.637730, 0.649448>, <0.399941, -0.615855, 0.678801> }
triangle { <0.414147, -0.637730, 0.649448>, <0.446955, -0.615181, 0.649448>, <0.461598, -0.635335, 0.619094> }
triangle { <0.461598, -0.635335, 0.619094>, <0.427714, -0.658622, 0.619094>, <0.414147, -0.637730, 0.649448> }
triangle { <0.427714, -0.658622, 0.619094>, <0.461598, -0.635335, 0.619094>, <0.475528, -0.654508, 0.587785> }
triangle { <0.475528, -0.654508, 0.587785>, <0.440622, -0.678499, 0.587785>, <0.427714, -0.658622, 0.619094> }
triangle { <0.440622, -0.678499, 0.587785>, <0.475528, -0.654508, 0.587785>, <0.488726, -0.672673, 0.555570> }
triangle { <0.488726, -0.672673, 0.555570>, <0.452851, -0.697329, 0.555570>, <0.440622, -0.678499, 0.587785> }
triangle { <0.452851, -0.697329, 0.555570>, <0.488726, -0.672673, 0.555570>, <0.501169, -0.689800, 0.522499> }
triangle { <0.501169, -0.689800, 0.522499>, <0.464381, -0.715084, 0.522499>, <0.452851, -0.697329, 0.555570> }
triangle { <0.464381, -0.715084, 0.522499>, <0.501169, -0.689800, 0.522499>, <0.512840, -0.705864, 0.488621> }
triangle { <0.512840, -0.705864, 0.488621>, <0.475195, -0.731737, 0.488621>, <0.464381, -0.715084, 0.522499> }
triangle { <0.475195, -0.731737, 0.488621>, <0.512840, -0.705864, 0.488621>, <0.523720, -0.720839, 0.453990> }
triangle { <0.523720, -0.720839, 0.453990>, <0.485277, -0.747261, 0.453990>, <0.475195, -0.731737, 0.488621> }
triangle { <0.485277, -0.747261, 0.453990>, <0.523720, -0.720839, 0.453990>, <0.533793, -0.734703, 0.418660> }
triangle { <0.533793, -0.734703, 0.418660>, <0.494610, -0.761633, 0.418660>, <0.485277, -0.747261, 0.453990> }
triangle { <0.494610, -0.761633, 0.418660>, <0.533793, -0.734703, 0.418660>, <0.543043, -0.747434, 0.382683> }
triangle { <0.543043, -0.747434, 0.382683>, <0.503181, -0.774831, 0.382683>, <0.494610, -0.761633, 0.418660> }
triangle { <0.503181, -0.774831, 0.382683>, <0.543043, -0.747434, 0.382683>, <0.551455, -0.759013, 0.346117> }
triangle { <0.551455, -0.759013, 0.346117>, <0.510976, -0.786833, 0.346117>, <0.503181, -0.774831, 0.382683> }
triangle { <0.510976, -0.786833, 0.346117>, <0.551455, -0.759013, 0.346117>, <0.559017, -0.769421, 0.309017> }
triangle { <0.559017, -0.769421, 0.309017>, <0.517983, -0.797623, 0.309017>, <0.510976, -0.786833, 0.346117> }
triangle { <0.517983, -0.797623, 0.309017>, <0.559017, -0.769421, 0.309017>, <0.565717, -0.778643, 0.271440> }
triangle { <0.565717, -0.778643, 0.271440>, <0.524191, -0.807183, 0.271440>, <0.517983, -0.797623, 0.309017> }
triangle { <0.524191, -0.807183, 0.271440>, <0.565717, -0.778643, 0.271440>, <0.571545, -0.786664, 0.233445> }
triangle { <0.571545, -0.786664, 0.233445>, <0.529591, -0.815498, 0.233445>, <0.524191, -0.807183, 0.271440> }
triangle { <0.529591, -0.815498, 0.233445>, <0.571545, -0.786664, 0.233445>, <0.576491, -0.793472, 0.195090> }
triangle { <0.576491, -0.793472, 0.195090>, <0.534174, -0.822556, 0.195090>, <0.529591, -0.815498, 0.233445> }
triangle { <0.534174, -0.822556, 0.195090>, <0.576491, -0.793472, 0.195090>, <0.580549, -0.799057, 0.156434> }
triangle { <0.580549, -0.799057, 0.156434>, <0.537934, -0.828345, 0.156434>, <0.534174, -0.822556, 0.195090> }
triangle { <0.537934, -0.828345, 0.156434>, <0.580549, -0.799057, 0.156434>, <0.583711, -0.803409, 0.117537> }
triangle { <0.583711, -0.803409, 0.117537>, <0.540864, -0.832857, 0.117537>, <0.537934, -0.828345, 0.156434> }
triangle { <0.540864, -0.832857, 0.117537>, <0.583711, -0.803409, 0.117537>, <0.585973, -0.806523, 0.078459> }
triangle { <0.585973, -0.806523, 0.078459>, <0.542960, -0.836085, 0.078459>, <0.540864, -0.832857, 0.117537> }
triangle { <0.542960, -0.836085, 0.078459>, <0.585973, -0.806523, 0.078459>, <0.587332, -0.808393, 0.039260> }
triangle { <0.587332, -0.808393, 0.039260>, <0.544219, -0.838024, 0.039260>, <0.542960, -0.836085, 0.078459> }
triangle { <0.544219, -0.838024, 0.039260>, <0.587332, -0.808393, 0.039260>, <0.587785, -0.809017, -0.000000> }
triangle { <0.587785, -0.809017, -0.000000>, <0.544639, -0.838671, -0.000000>, <0.544219, -0.838024, 0.039260> }
triangle { <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.024707, -0.030511, 0.999229> }
triangle { <0.024707, -0.030511, 0.999229>, <0.023076, -0.031762, 0.999229>, <0.000000, 0.000000, 1.000000> }
triangle { <0.023076, -0.031762, 0.999229>, <0.024707, -0.030511, 0.999229>, <0.049376, -0.060974, 0.996917> }
triangle { <0.049376, -0.060974, 0.996917>, <0.046117, -0.063475, 0.996917>, <0.023076, -0.031762, 0.999229> }
triangle { <0.046117, -0.063475, 0.996917>, <0.049376, -0.060974, 0.996917>, <0.073969, -0.091344, 0.993068> }
triangle { <0.073969, -0.091344, 0.993068>, <0.069087, -0.095090, 0.993068>, <0.046117, -0.063475, 0.996917> }
triangle { <0.069087, -0.095090, 0.993068>, <0.073969, -0.091344, 0.993068>, <0.098447, -0.121572, 0.987688> }
triangle { <0.098447, -0.121572, 0.987688>, <0.091950, -0.126558, 0.987688>, <0.069087, -0.095090, 0.993068> }
triangle { <0.091950, -0.126558, 0.987688>, <0.098447, -0.121572, 0.987688>, <0.122774, -0.151614, 0.980785> }
triangle { <0.122774, -0.151614, 0.980785>, <0.114671, -0.157831, 0.980785>, <0.091950, -0.126558, 0.987688> }
triangle { <0.114671, -0.157831, 0.980785>, <0.122774, -0.151614, 0.980785>, <0.146912, -0.181421, 0.972370> }
triangle { <0.146912, -0.181421, 0.972370>, <0.137216, -0.188861, 0.972370>, <0.114671, -0.157831, 0.980785> }
triangle { <0.137216, -0.188861, 0.972370>, <0.146912, -0.181421, 0.972370>, <0.170823, -0.210949, 0.962455> }
triangle { <0.170823, -0.210949, 0.962455>, <0.159549, -0.219600, 0.962455>, <0.137216, -0.188861, 0.972370> }
triangle { <0.159549, -0.219600, 0.962455>, <0.170823, -0.210949, 0.962455>, <0.194471, -0.240151, 0.951057> }
triangle { <0.194471, -0.240151, 0.951057>, <0.181636, -0.250000, 0.951057>, <0.159549, -0.219600, 0.962455> }
triangle { <0.181636, -0.250000, 0.951057>, <0.194471, -0.240151, 0.951057>, <0.217819, -0.268983, 0.938191> }
triangle { <0.217819, -0.268983, 0.938191>, <0.203443, -0.280015, 0.938191>, <0.181636, -0.250000, 0.951057> }
triangle { <0.203443, -0.280015, 0.938191>, <0.217819, -0.268983, 0.938191>, <0.240830, -0.297401, 0.923880> }
triangle { <0.240830, -0.297401, 0.923880>, <0.224936, -0.309597, 0.923880>, <0.203443, -0.280015, 0.938191> }
triangle { <0.224936, -0.309597, 0.923880>, <0.240830, -0.297401, 0.923880>, <0.263471, -0.325360, 0.908143> }
triangle { <0.263471, -0.325360, 0.908143>, <0.246082, -0.338703, 0.908143>, <0.224936, -0.309597, 0.923880> }
triangle { <0.246082, -0.338703, 0.908143>, <0.263471, -0.325360, 0.908143>, <0.285705, -0.352817, 0.891007> }
triangle { <0.285705, -0.352817, 0.891007>, <0.266849, -0.367286, 0.891007>, <0.246082, -0.338703, 0.908143> }
triangle { <0.266849, -0.367286, 0.891007>, <0.285705, -0.352817, 0.891007>, <0.307499, -0.379730, 0.872496> }
triangle { <0.307499, -0.379730, 0.872496>, <0.287204, -0.395303, 0.872496>, <0.266849, -0.367286, 0.891007> }
triangle { <0.287204, -0.395303, 0.872496>, <0.307499, -0.379730, 0.872496>, <0.328819, -0.406058, 0.852640> }
triangle { <0.328819, -0.406058, 0.852640>, <0.307117, -0.422710, 0.852640>, <0.287204, -0.395303, 0.872496> }
triangle { <0.307117, -0.422710, 0.852640>, <0.328819, -0.406058, 0.852640>, <0.349632, -0.431759, 0.831470> }
triangle { <0.349632, -0.431759, 0.831470>, <0.326556, -0.449466, 0.831470>, <0.307117, -0.422710, 0.852640> }
triangle { <0.326556, -0.449466, 0.831470>, <0.349632, -0.431759, 0.831470>, <0.369905, -0.456795, 0.809017> }
triangle { <0.369905, -0.456795, 0.809017>, <0.345492, -0.475528, 0.809017>, <0.326556, -0.449466, 0.831470> }
triangle { <0.345492, -0.475528, 0.809017>, <0.369905, -0.456795, 0.809017>, <0.389608, -0.481126, 0.785317> }
triangle { <0.389608, -0.481126, 0.785317>, <0.363894, -0.500858, 0.785317>, <0.345492, -0.475528, 0.809017> }
triangle { <0.363894, -0.500858, 0.785317>, <0.389608, -0.481126, 0.785317>, <0.408711, -0.504716, 0.760406> }
triangle { <0.408711, -0.504716, 0.760406>, <0.381736, -0.525415, 0.760406>, <0.363894, -0.500858, 0.785317> }
triangle { <0.381736, -0.525415, 0.760406>, <0.408711, -0.504716, 0.760406>, <0.427183, -0.527527, 0.734323> }
triangle { <0.427183, -0.527527, 0.734323>, <0.398989, -0.549161, 0.734323>, <0.381736, -0.525415, 0.760406> }
triangle { <0.398989, -0.549161, 0.734323>, <0.427183, -0.527527, 0.734323>, <0.444997, -0.549525, 0.707107> }
triangle { <0.444997, -0.549525, 0.707107>, <0.415627, -0.572061, 0.707107>, <0.398989, -0.549161, 0.734323> }
triangle { <0.415627, -0.572061, 0.707107>, <0.444997, -0.549525, 0.707107>, <0.462124, -0.570676, 0.678801> }
triangle { <0.462124, -0.570676, 0.678801>, <0.431624, -0.594079, 0.678801>, <0.415627, -0.572061, 0.707107> }
triangle { <0.431624, -0.594079, 0.678801>, <0.462124, -0.570676, 0.678801>, <0.478539, -0.590946, 0.649448> }
triangle { <0.478539, -0.590946, 0.649448>, <0.446955, -0.615181, 0.649448>, <0.431624, -0.594079, 0.678801> }
triangle { <0.446955, -0.615181, 0.649448>, <0.478539, -0.590946, 0.649448>, <0.494216, -0.610306, 0.619094> }
triangle { <0.494216, -0.610306, 0.619094>, <0.461598, -0.635335, 0.619094>, <0.446955, -0.615181, 0.649448> }
triangle { <0.461598, -0.635335, 0.619094>, <0.494216, -0.610306, 0.619094>, <0.509131, -0.628724, 0.587785> }
triangle { <0.509131, -0.628724, 0.587785>, <0.475528, -0.654508, 0.587785>, <0.461598, -0.635335, 0.619094> }
triangle { <0.475528, -0.654508, 0.587785>, <0.509131, -0.628724, 0.587785>, <0.523261, -0.646173, 0.555570> }
triangle { <0.523261, -0.646173, 0.555570>, <0.488726, -0.672673, 0.555570>, <0.475528, -0.654508, 0.587785> }
triangle { <0.488726, -0.672673, 0.555570>, <0.523261, -0.646173, 0.555570>, <0.536584, -0.662626, 0.522499> }
triangle { <0.536584, -0.662626, 0.522499>, <0.501169, -0.689800, 0.522499>, <0.488726, -0.672673, 0.555570> }
triangle { <0.501169, -0.689800, 0.522499>, <0.536584, -0.662626, 0.522499>, <0.549080, -0.678057, 0.488621> }
triangle { <0.549080, -0.678057, 0.488621>, <0.512840, -0.705864, 0.488621>, <0.501169, -0.689800, 0.522499> }
triangle { <0.512840, -0.705864, 0.488621>, <0.549080, -0.678057, 0.488621>, <0.560729, -0.692442, 0.453990> }
triangle { <0.560729, -0.692442, 0.453990>, <0.523720, -0.720839, 0.453990>, <0.512840, -0.705864, 0.488621> }
triangle { <0.523720, -0.720839, 0.453990>, <0.560729, -0.692442, 0.453990>, <0.571513, -0.705760, 0.418660> }
triangle { <0.571513, -0.705760, 0.418660>, <0.533793, -0.734703, 0.418660>, <0.523720, -0.720839, 0.453990> }
triangle { <0.533793, -0.734703, 0.418660>, <0.571513, -0.705760, 0.418660>, <0.581416, -0.717989, 0.382683> }
triangle { <0.581416, -0.717989, 0.382683>, <0.543043, -0.747434, 0.382683>, <0.533793, -0.734703, 0.418660> }
triangle { <0.543043, -0.747434, 0.382683>, <0.581416, -0.717989, 0.382683>, <0.590423, -0.729112, 0.346117> }
triangle { <0.590423, -0.729112, 0.346117>, <0.551455, -0.759013, 0.346117>, <0.543043, -0.747434, 0.382683> }
triangle { <0.551455, -0.759013, 0.346117>, <0.590423, -0.729112, 0.346117>, <0.598519, -0.739110, 0.309017> }
triangle { <0.598519, -0.739110, 0.309017>, <0.559017, -0.769421, 0.309017>, <0.551455, -0.759013, 0.346117> }
triangle { <0.559017, -0.769421, 0.309017>, <0.598519, -0.739110, 0.309017>, <0.605693, -0.747968, 0.271440> }
triangle { <0.605693, -0.747968, 0.271440>, <0.565717, -0.778643, 0.271440>, <0.559017, -0.769421, 0.309017> }
triangle { <0.565717, -0.778643, 0.271440>, <0.605693, -0.747968, 0.271440>, <0.611932, -0.755673, 0.233445> }
triangle { <0.611932, -0.755673, 0.233445>, <0.571545, -0.786664, 0.233445>, <0.565717, -0.778643, 0.271440> }
triangle { <0.571545, -0.786664, 0.233445>, <0.611932, -0.755673, 0.233445>, <0.617228, -0.762213, 0.195090> }
triangle { <0.617228, -0.762213, 0.195090>, <0.576491, -0.793472, 0.195090>, <0.571545, -0.786664, 0.233445> }
triangle { <0.576491, -0.793472, 0.195090>, <0.617228, -0.762213, 0.195090>, <0.621572, -0.767578, 0.156434> }
triangle { <0.621572, -0.767578, 0.156434>, <0.580549, -0.799057, 0.156434>, <0.576491, -0.793472, 0.195090> }
triangle { <0.580549, -0.799057, 0.156434>, <0.621572, -0.767578, 0.156434>, <0.624958, -0.771759, 0.117537> }
triangle { <0.624958, -0.771759, 0.117537>, <0.583711, -0.803409, 0.117537>, <0.580549, -0.799057, 0.156434> }
triangle { <0.583711, -0.803409, 0.117537>, <0.624958, -0.771759, 0.117537>, <0.627380, -0.774750, 0.078459> }
triangle { <0.627380, -0.774750, 0.078459>, <0.585973, -0.806523, 0.078459>, <0.583711, -0.803409, 0.117537> }
triangle { <0.585973, -0.806523, 0.078459>, <0.627380, -0.774750, 0.078459>, <0.628835, -0.776547, 0.039260> }
triangle { <0.628835, -0.776547, 0.039260>, <0.587332, -0.808393, 0.039260>, <0.585973, -0.806523, 0.078459> }
triangle { <0.587332, -0.808393, 0.039260>, <0.628835, -0.776547, 0.039260>, <0.629320, -0.777146, -0.000000> }
triangle { <0.629320, -0.777146, -0.000000>, <0.587785, -0.809017, -0.000000>, <0.587332, -0.808393, 0.039260> }
triangle { <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.026270, -0.029176, 0.999229> }
triangle { <0.026270, -0.029176, 0.999229>, <0.024707, -0.030511, 0.999229>, <0.000000, 0.000000, 1.000000> }
triangle { <0.024707, -0.030511, 0.999229>, <0.026270, -0.029176, 0.999229>, <0.052499, -0.058306, 0.996917> }
triangle { <0.052499, -0.058306, 0.996917>, <0.049376, -0.060974, 0.996917>, <0.024707, -0.030511, 0.999229> }
triangle { <0.049376, -0.060974, 0.996917>, <0.052499, -0.058306, 0.996917>, <0.078648, -0.087347, 0.993068> }
triangle { <0.078648, -0.087347, 0.993068>, <0.073969, -0.091344, 0.993068>, <0.049376, -0.060974, 0.996917> }
triangle { <0.073969, -0.091344, 0.993068>, <0.078648, -0.087347, 0.993068>, <0.104675, -0.116253, 0.987688> }
triangle { <0.104675, -0.116253, 0.987688>, <0.098447, -0.121572, 0.987688>, <0.073969, -0.091344, 0.993068> }
triangle { <0.098447, -0.121572, 0.987688>, <0.104675, -0.116253, 0.987688>, <0.130541, -0.144980, 0.980785> }
triangle { <0.130541, -0.144980, 0.980785>, <0.122774, -0.151614, 0.980785>, <0.098447, -0.121572, 0.987688> }
triangle { <0.122774, -0.151614, 0.980785>, <0.130541, -0.144980, 0.980785>, <0.156205, -0.173484, 0.972370> }
triangle { <0.156205, -0.173484, 0.972370>, <0.146912, -0.181421, 0.972370>, <0.122774, -0.151614, 0.980785> }
triangle { <0.146912, -0.181421, 0.972370>, <0.156205, -0.173484, 0.972370>, <0.181629, -0.201720, 0.962455> }
triangle { <0.181629, -0.201720, 0.962455>, <0.170823, -0.210949, 0.962455>, <0.146912, -0.181421, 0.972370> }
triangle { <0.170823, -0.210949, 0.962455>, <0.181629, -0.201720, 0.962455>, <0.206773, -0.229644, 0.951057> }
triangle { <0.206773, -0.229644, 0.951057>, <0.194471, -0.240151, 0.951057>, <0.170823, -0.210949, 0.962455> }
triangle { <0.194471, -0.240151, 0.951057>, <0.206773, -0.229644, 0.951057>, <0.231598, -0.257215, 0.938191> }
triangle { <0.231598, -0.257215, 0.938191>, <0.217819, -0.268983, 0.938191>, <0.194471, -0.240151, 0.951057> }
triangle { <0.217819, -0.268983, 0.938191>, <0.231598, -0.257215, 0.938191>, <0.256065, -0.284389, 0.923880> }
triangle { <0.256065, -0.284389, 0.923880>, <0.240830, -0.297401, 0.923880>, <0.217819, -0.268983, 0.938191> }
triangle { <0.240830, -0.297401, 0.923880>, <0.256065, -0.284389, 0.923880>, <0.280138, -0.311125, 0.908143> }
triangle { <0.280138, -0.311125, 0.908143>, <0.263471, -0.325360, 0.908143>, <0.240830, -0.297401, 0.923880> }
triangle { <0.263471, -0.325360, 0.908143>, <0.280138, -0.311125, 0.908143>, <0.303779, -0.337381, 0.891007> }
triangle { <0.303779, -0.337381, 0.891007>, <0.285705, -0.352817, 0.891007>, <0.263471, -0.325360, 0.908143> }
triangle { <0.285705, -0.352817, 0.891007>, <0.303779, -0.337381, 0.891007>, <0.326951, -0.363116, 0.872496> }
triangle { <0.326951, -0.363116, 0.872496>, <0.307499, -0.379730, 0.872496>, <0.285705, -0.352817, 0.891007> }
triangle { <0.307499, -0.379730, 0.872496>, <0.326951, -0.363116, 0.872496>, <0.349620, -0.388292, 0.852640> }
triangle { <0.349620, -0.388292, 0.852640>, <0.328819, -0.406058, 0.852640>, <0.307499, -0.379730, 0.872496> }
triangle { <0.328819, -0.406058, 0.852640>, <0.349620, -0.388292, 0.852640>, <0.371749, -0.412869, 0.831470> }
triangle { <0.371749, -0.412869, 0.831470>, <0.349632, -0.431759, 0.831470>, <0.328819, -0.406058, 0.852640> }
triangle { <0.349632, -0.431759, 0.831470>, <0.371749, -0.412869, 0.831470>, <0.393305, -0.436810, 0.809017> }
triangle { <0.393305, -0.436810, 0.809017>, <0.369905, -0.456795, 0.809017>, <0.349632, -0.431759, 0.831470> }
triangle { <0.369905, -0.456795, 0.809017>, <0.393305, -0.436810, 0.809017>, <0.414255, -0.460076, 0.785317> }
triangle { <0.414255, -0.460076, 0.785317>, <0.389608, -0.481126, 0.785317>, <0.369905, -0.456795, 0.809017> }
triangle { <0.389608, -0.481126, 0.785317>, <0.414255, -0.460076, 0.785317>, <0.434566, -0.482634, 0.760406> }
triangle { <0.434566, -0.482634, 0.760406>, <0.408711, -0.504716, 0.760406>, <0.389608, -0.481126, 0.785317> }
triangle { <0.408711, -0.504716, 0.760406>, <0.434566, -0.482634, 0.760406>, <0.454206, -0.504447, 0.734323> }
triangle { <0.454206, -0.504447, 0.734323>, <0.427183, -0.527527, 0.734323>, <0.408711, -0.504716, 0.760406> }
triangle { <0.427183, -0.527527, 0.734323>, <0.454206, -0.504447, 0.734323>, <0.473147, -0.525483, 0.707107> }
triangle { <0.473147, -0.525483, 0.707107>, <0.444997, -0.549525, 0.707107>, <0.427183, -0.527527, 0.734323> }
triangle { <0.444997, -0.549525, 0.707107>, <0.473147, -0.525483, 0.707107>, <0.491358, -0.545708, 0.678801> }
triangle { <0.491358, -0.545708, 0.678801>, <0.462124, -0.570676, 0.678801>, <0.444997, -0.549525, 0.707107> }
triangle { <0.462124, -0.570676, 0.678801>, <0.491358, -0.545708, 0.678801>, <0.508811, -0.565092, 0.649448> }
triangle { <0.508811, -0.565092, 0.649448>, <0.478539, -0.590946, 0.649448>, <0.462124, -0.570676, 0.678801> }
triangle { <0.478539, -0.590946, 0.649448>, <0.508811, -0.565092, 0.649448>, <0.525480, -0.583604, 0.619094> }
triangle { <0.525480, -0.583604, 0.619094>, <0.494216, -0.610306, 0.619094>, <0.478539, -0.590946, 0.649448> }
triangle { <0.494216, -0.610306, 0.619094>, <0.525480, -0.583604, 0.619094>, <0.541338, -0.601217, 0.587785> }
triangle { <0.541338, -0.601217, 0.587785>, <0.509131, -0.628724, 0.587785>, <0.494216, -0.610306, 0.619094> }
triangle { <0.509131, -0.628724, 0.587785>, <0.541338, -0.601217, 0.587785>, <0.556362, -0.617902, 0.555570> }
triangle { <0.556362, -0.617902, 0.555570>, <0.523261, -0.646173, 0.555570>, <0.509131, -0.628724, 0.587785> }
triangle { <0.523261, -0.646173, 0.555570>, <0.556362, -0.617902, 0.555570>, <0.570528, -0.633635, 0.522499> }
triangle { <0.570528, -0.633635, 0.522499>, <0.536584, -0.662626, 0.522499>, <0.523261, -0.646173, 0.555570> }
triangle { <0.536584, -0.662626, 0.522499>, <0.570528, -0.633635, 0.522499>, <0.583814, -0.648391, 0.488621> }
triangle { <0.583814, -0.648391, 0.488621>, <0.549080, -0.678057, 0.488621>, <0.536584, -0.662626, 0.522499> }
triangle { <0.549080, -0.678057, 0.488621>, <0.583814, -0.648391, 0.488621>, <0.596200, -0.662147, 0.453990> }
triangle { <0.596200, -0.662147, 0.453990>, <0.560729, -0.692442, 0.453990>, <0.549080, -0.678057, 0.488621> }
triangle { <0.560729, -0.692442, 0.453990>, <0.596200, -0.662147, 0.453990>, <0.607666, -0.674882, 0.418660> }
triangle { <0.607666, -0.674882, 0.418660>, <0.571513, -0.705760, 0.418660>, <0.560729, -0.692442, 0.453990> }
triangle { <0.571513, -0.705760, 0.418660>, <0.607666, -0.674882, 0.418660>, <0.618196, -0.686576, 0.382683> }
triangle { <0.618196, -0.686576, 0.382683>, <0.581416, -0.717989, 0.382683>, <0.571513, -0.705760, 0.418660> }
triangle { <0.581416, -0.717989, 0.382683>, <0.618196, -0.686576, 0.382683>, <0.627773, -0.697212, 0.346117> }
triangle { <0.627773, -0.697212, 0.346117>, <0.590423, -0.729112, 0.346117>, <0.581416, -0.717989, 0.382683> }
triangle { <0.590423, -0.729112, 0.346117>, <0.627773, -0.697212, 0.346117>, <0.636381, -0.706773, 0.309017> }
triangle { <0.636381, -0.706773, 0.309017>, <0.598519, -0.739110, 0.309017>, <0.590423, -0.729112, 0.346117> }
triangle { <0.598519, -0.739110, 0.309017>, <0.636381, -0.706773, 0.309017>, <0.644008, -0.715244, 0.271440> }
triangle { <0.644008, -0.715244, 0.271440>, <0.605693, -0.747968, 0.271440>, <0.598519, -0.739110, 0.309017> }
triangle { <0.605693, -0.747968, 0.271440>, <0.644008, -0.715244, 0.271440>, <0.650642, -0.722612, 0.233445> }
triangle { <0.650642, -0.722612, 0.233445>, <0.611932, -0.755673, 0.233445>, <0.605693, -0.747968, 0.271440> }
triangle { <0.611932, -0.755673, 0.233445>, <0.650642, -0.722612, 0.233445>, <0.656273, -0.728866, 0.195090> }
triangle { <0.656273, -0.728866, 0.195090>, <0.617228, -0.762213, 0.195090>, <0.611932, -0.755673, 0.233445> }
triangle { <0.617228, -0.762213, 0.195090>, <0.656273, -0.728866, 0.195090>, <0.660892, -0.733995, 0.156434> }
triangle { <0.660892, -0.733995, 0.156434>, <0.621572, -0.767578, 0.156434>, <0.617228, -0.762213, 0.195090> }
triangle { <0.621572, -0.767578, 0.156434>, <0.660892, -0.733995, 0.156434>, <0.664492, -0.737994, 0.117537> }
triangle { <0.664492, -0.737994, 0.117537>, <0.624958, -0.771759, 0.117537>, <0.621572, -0.767578, 0.156434> }
triangle { <0.624958, -0.771759, 0.117537>, <0.664492, -0.737994, 0.117537>, <0.667068, -0.740854, 0.078459> }
triangle { <0.667068, -0.740854, 0.078459>, <0.627380, -0.774750, 0.078459>, <0.624958, -0.771759, 0.117537> }
triangle { <0.627380, -0.774750, 0.078459>, <0.667068, -0.740854, 0.078459>, <0.668615, -0.742572, 0.039260> }
triangle { <0.668615, -0.742572, 0.039260>, <0.628835, -0.776547, 0.039260>, <0.627380, -0.774750, 0.078459> }
triangle { <0.628835, -0.776547, 0.039260>, <0.668615, -0.742572, 0.039260>, <0.669131, -0.743145, -0.000000> }
triangle { <0.669131, -0.743145, -0.000000>, <0.629320, -0.777146, -0.000000>, <0.628835, -0.776547, 0.039260> }
triangle { <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.027761, -0.027761, 0.999229> }
triangle { <0.027761, -0.027761, 0.999229>, <0.026270, -0.029176, 0.999229>, <0.000000, 0.000000, 1.000000> }
triangle { <0.026270, -0.029176, 0.999229>, <0.027761, -0.027761, 0.999229>, <0.055479, -0.055479, 0.996917> }
triangle { <0.055479, -0.055479, 0.996917>, <0.052499, -0.058306, 0.996917>, <0.026270, -0.029176, 0.999229> }
triangle { <0.052499, -0.058306, 0.996917>, <0.055479, -0.055479, 0.996917>, <0.083111, -0.083111, 0.993068> }
triangle { <0.083111, -0.083111, 0.993068>, <0.078648, -0.087347, 0.993068>, <0.052499, -0.058306, 0.996917> }
triangle { <0.078648, -0.087347, 0.993068>, <0.083111, -0.083111, 0.993068>, <0.110616, -0.110616, 0.987688> }
triangle { <0.110616, -0.110616, 0.987688>, <0.104675, -0.116253, 0.987688>, <0.078648, -0.087347, 0.993068> }
triangle { <0.104675, -0.116253, 0.987688>, <0.110616, -0.110616, 0.987688>, <0.137950, -0.137950, 0.980785> }
triangle { <0.137950, -0.137950, 0.980785>, <0.130541, -0.144980, 0.980785>, <0.104675, -0.116253, 0.987688> }
triangle { <0.130541, -0.144980, 0.980785>, <0.137950, -0.137950, 0.980785>, <0.165071, -0.165071, 0.972370> }
triangle { <0.165071, -0.165071, 0.972370>, <0.156205, -0.173484, 0.972370>, <0.130541, -0.144980, 0.980785> }
triangle { <0.156205, -0.173484, 0.972370>, <0.165071, -0.165071, 0.972370>, <0.191937, -0.191937, 0.962455> }
triangle { <0.191937, -0.191937, 0.962455>, <0.181629, -0.201720, 0.962455>, <0.156205, -0.173484, 0.972370> }
triangle { <0.181629, -0.201720, 0.962455>, <0.191937, -0.191937, 0.962455>, <0.218508, -0.218508, 0.951057> }
triangle { <0.218508, -0.218508, 0.951057>, <0.206773, -0.229644, 0.951057>, <0.181629, -0.201720, 0.962455> }
triangle { <0.206773, -0.229644, 0.951057>, <0.218508, -0.218508, 0.951057>, <0.244742, -0.244742, 0.938191> }
triangle { <0.244742, -0.244742, 0.938191>, <0.231598, -0.257215, 0.938191>, <0.206773, -0.229644, 0.951057> }
triangle { <0.231598, -0.257215, 0.938191>, <0.244742, -0.244742, 0.938191>, <0.270598, -0.270598, 0.923880> }
triangle { <0.270598, -0.270598, 0.923880>, <0.256065, -0.284389, 0.923880>, <0.231598, -0.257215, 0.938191> }
triangle { <0.256065, -0.284389, 0.923880>, <0.270598, -0.270598, 0.923880>, <0.296037, -0.296037, 0.908143> }
triangle { <0.296037, -0.296037, 0.908143>, <0.280138, -0.311125, 0.908143>, <0.256065, -0.284389, 0.923880> }
triangle { <0.280138, -0.311125, 0.908143>, <0.296037, -0.296037, 0.908143>, <0.321020, -0.321020, 0.891007> }
triangle { <0.321020, -0.321020, 0.891007>, <0.303779, -0.337381, 0.891007>, <0.280138, -0.311125, 0.908143> }
triangle { <0.303779, -0.337381, 0.891007>, <0.321020, -0.321020, 0.891007>, <0.345507, -0.345507, 0.872496> }
triangle { <0.345507, -0.345507, 0.872496>, <0.326951, -0.363116, 0.872496>, <0.303779, -0.337381, 0.891007> }
triangle { <0.326951, -0.363116, 0.872496>, <0.345507, -0.345507, 0.872496>, <0.369462, -0.369462, 0.852640> }
triangle { <0.369462, -0.369462, 0.852640>, <0.349620, -0.388292, 0.852640>, <0.326951, -0.363116, 0.872496> }
triangle { <0.349620, -0.388292, 0.852640>, <0.369462, -0.369462, 0.852640>, <0.392847, -0.392847, 0.831470> }
triangle { <0.392847, -0.392847, 0.831470>, <0.371749, -0.412869, 0.831470>, <0.349620, -0.388292, 0.852640> }
triangle { <0.371749, -0.412869, 0.831470>, <0.392847, -0.392847, 0.831470>, <0.415627, -0.415627, 0.809017> }
triangle { <0.415627, -0.415627, 0.809017>, <0.393305, -0.436810, 0.809017>, <0.371749, -0.412869, 0.831470> }
triangle { <0.393305, -0.436810, 0.809017>, <0.415627, -0.415627, 0.809017>, <0.437766, -0.437766, 0.785317> }
triangle { <0.437766, -0.437766, 0.785317>, <0.414255, -0.460076, 0.785317>, <0.393305, -0.436810, 0.809017> }
triangle { <0.414255, -0.460076, 0.785317>, <0.437766, -0.437766, 0.785317>, <0.459229, -0.459229, 0.760406> }
triangle { <0.459229, -0.459229, 0.760406>, <0.434566, -0.482634, 0.760406>, <0.414255, -0.460076, 0.785317> }
triangle { <0.434566, -0.482634, 0.760406>, <0.459229, -0.459229, 0.760406>, <0.479985, -0.479985, 0.734323> }
triangle { <0.479985, -0.479985, 0.734323>, <0.454206, -0.504447, 0.734323>, <0.434566, -0.482634, 0.760406> }
triangle { <0.454206, -0.504447, 0.734323>, <0.479985, -0.479985, 0.734323>, <0.500000, -0.500000, 0.707107> }
triangle { <0.500000, -0.500000, 0.707107>, <0.473147, -0.525483, 0.707107>, <0.454206, -0.504447, 0.734323> }
triangle { <0.473147, -0.525483, 0.707107>, <0.500000, -0.500000, 0.707107>, <0.519244, -0.519244, 0.678801> }
triangle { <0.519244, -0.519244, 0.678801>, <0.491358, -0.545708, 0.678801>, <0.473147, -0.525483, 0.707107> }
triangle { <0.491358, -0.545708, 0.678801>, <0.519244, -0.519244, 0.678801>, <0.537688, -0.537688, 0.649448> }
triangle { <0.537688, -0.537688, 0.649448>, <0.508811, -0.565092, 0.649448>, <0.491358, -0.545708, 0.678801> }
triangle { <0.508811, -0.565092, 0.649448>, <0.537688, -0.537688, 0.649448>, <0.555303, -0.555303, 0.619094> }
triangle { <0.555303, -0.555303, 0.619094>, <0.525480, -0.583604, 0.619094>, <0.508811, -0.565092, 0.649448> }
triangle { <0.525480, -0.583604, 0.619094>, <0.555303, -0.555303, 0.619094>, <0.572061, -0.572061, 0.587785> }
triangle { <0.572061, -0.572061, 0.587785>, <0.541338, -0.601217, 0.587785>, <0.525480, -0.583604, 0.619094> }
triangle { <0.541338, -0.601217, 0.587785>, <0.572061, -0.572061, 0.587785>, <0.587938, -0.587938, 0.555570> }
triangle { <0.587938, -0.587938, 0.555570>, <0.556362, -0.617902, 0.555570>, <0.541338, -0.601217, 0.587785> }
triangle { <0.556362, -0.617902, 0.555570>, <0.587938, -0.587938, 0.555570>, <0.602908, -0.602908, 0.522499> }
triangle { <0.602908, -0.602908, 0.522499>, <0.570528, -0.633635, 0.522499>, <0.556362, -0.617902, 0.555570> }
triangle { <0.570528, -0.633635, 0.522499>, <0.602908, -0.602908, 0.522499>, <0.616948, -0.616948, 0.488621> }
triangle { <0.616948, -0.616948, 0.488621>, <0.583814, -0.648391, 0.488621>, <0.570528, -0.633635, 0.522499> }
triangle { <0.583814, -0.648391, 0.488621>, <0.616948, -0.616948, 0.488621>, <0.630037, -0.630037, 0.453990> }
triangle { <0.630037, -0.630037, 0.453990>, <0.596200, -0.662147, 0.453990>, <0.583814, -0.648391, 0.488621> }
triangle { <0.596200, -0.662147, 0.453990>, <0.630037, -0.630037, 0.453990>, <0.642154, -0.642154, 0.418660> }
triangle { <0.642154, -0.642154, 0.418660>, <0.607666, -0.674882, 0.418660>, <0.596200, -0.662147, 0.453990> }
triangle { <0.607666, -0.674882, 0.418660>, <0.642154, -0.642154, 0.418660>, <0.653281, -0.653281, 0.382683> }
triangle { <0.653281, -0.653281, 0.382683>, <0.618196, -0.686576, 0.382683>, <0.607666, -0.674882, 0.418660> }
triangle { <0.618196, -0.686576, 0.382683>, <0.653281, -0.653281, 0.382683>, <0.663401, -0.663401, 0.346117> }
triangle { <0.663401, -0.663401, 0.346117>, <0.627773, -0.697212, 0.346117>, <0.618196, -0.686576, 0.382683> }
triangle { <0.627773, -0.697212, 0.346117>, <0.663401, -0.663401, 0.346117>, <0.672499, -0.672499, 0.309017> }
triangle { <0.672499, -0.672499, 0.309017>, <0.636381, -0.706773, 0.309017>, <0.627773, -0.697212, 0.346117> }
triangle { <0.636381, -0.706773, 0.309017>, <0.672499, -0.672499, 0.309017>, <0.680559, -0.680559, 0.271440> }
triangle { <0.680559, -0.680559, 0.271440>, <0.644008, -0.715244, 0.271440>, <0.636381, -0.706773, 0.309017> }
triangle { <0.644008, -0.715244, 0.271440>, <0.680559, -0.680559, 0.271440>, <0.687569, -0.687569, 0.233445> }
triangle { <0.687569, -0.687569, 0.233445>, <0.650642, -0.722612, 0.233445>, <0.644008, -0.715244, 0.271440> }
triangle { <0.650642, -0.722612, 0.233445>, <0.687569, -0.687569, 0.233445>, <0.693520, -0.693520, 0.195090> }
triangle { <0.693520, -0.693520, 0.195090>, <0.656273, -0.728866, 0.195090>, <0.650642, -0.722612, 0.233445> }
triangle { <0.656273, -0.728866, 0.195090>, <0.693520, -0.693520, 0.195090>, <0.698401, -0.698401, 0.156434> }
triangle { <0.698401, -0.698401, 0.156434>, <0.660892, -0.733995, 0.156434>, <0.656273, -0.728866, 0.195090> }
triangle { <0.660892, -0.733995, 0.156434>, <0.698401, -0.698401, 0.156434>, <0.702205, -0.702205, 0.117537> }
triangle { <0.702205, -0.702205, 0.117537>, <0.664492, -0.737994, 0.117537>, <0.660892, -0.733995, 0.156434> }
triangle { <0.664492, -0.737994, 0.117537>, <0.702205, -0.702205, 0.117537>, <0.704927, -0.704927, 0.078459> }
triangle { <0.704927, -0.704927, 0.078459>, <0.667068, -0.740854, 0.078459>, <0.664492, -0.737994, 0.117537> }
triangle { <0.667068, -0.740854, 0.078459>, <0.704927, -0.704927, 0.078459>, <0.706562, -0.706562, 0.039260> }
triangle { <0.706562, -0.706562, 0.039260>, <0.668615, -0.742572, 0.039260>, <0.667068, -0.740854, 0.078459> }
triangle { <0.668615, -0.742572, 0.039260>, <0.706562, -0.706562, 0.039260>, <0.707107, -0.707107, -0.000000> }
triangle { <0.707107, -0.707107, -0.000000>, <0.669131, -0.743145, -0.000000>, <0.668615, -0.742572, 0.039260> }
triangle { <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.029176, -0.026270, 0.999229> }
triangle { <0.029176, -0.026270, 0.999229>, <0.027761, -0.027761, 0.999229>, <0.000000, 0.000000, 1.000000> }
triangle { <0.027761, -0.027761, 0.999229>, <0.029176, -0.026270, 0.999229>, <0.058306, -0.052499, 0.996917> }
triangle { <0.058306, -0.052499, 0.996917>, <0.055479, -0.055479, 0.996917>, <0.027761, -0.027761, 0.999229> }
triangle { <0.055479, -0.055479, 0.996917>, <0.058306, -0.052499, 0.996917>, <0.087347, -0.078648, 0.993068> }
triangle { <0.087347, -0.078648, 0.993068>, <0.083111, -0.083111, 0.993068>, <0.055479, -0.055479, 0.996917> }
triangle { <0.083111, -0.083111, 0.993068>, <0.087347, -0.078648, 0.993068>, <0.116253, -0.104675, 0.987688> }
triangle { <0.116253, -0.104675, 0.987688>, <0.110616, -0.110616, 0.987688>, <0.083111, -0.083111, 0.993068> }
triangle { <0.110616, -0.110616, 0.987688>, <0.116253, -0.104675, 0.987688>, <0.144980, -0.130541, 0.980785> }
triangle { <0.144980, -0.130541, 0.980785>, <0.137950, -0.137950, 0.980785>, <0.110616, -0.110616, 0.987688> }
triangle { <0.137950, -0.137950, 0.980785>, <0.144980, -0.130541, 0.980785>, <0.173484, -0.156205, 0.972370> }
triangle { <0.173484, -0.156205, 0.972370>, <0.165071, -0.165071, 0.972370>, <0.137950, -0.137950, 0.980785> }
triangle { <0.165071, -0.165071, 0.972370>, <0.173484, -0.156205, 0.972370>, <0.201720, -0.181629, 0.962455> }
triangle { <0.201720, -0.181629, 0.962455>, <0.191937, -0.191937, 0.962455>, <0.165071, -0.165071, 0.972370> }
triangle { <0.191937, -0.191937, 0.962455>, <0.201720, -0.181629, 0.962455>, <0.229644, -0.206773, 0.951057> }
triangle { <0.229644, -0.206773, 0.951057>, <0.218508, -0.218508, 0.951057>, <0.191937, -0.191937, 0.962455> }
triangle { <0.218508, -0.218508, 0.951057>, <0.229644, -0.206773, 0.951057>, <0.257215, -0.231598, 0.938191> }
triangle { <0.257215, -0.231598, 0.938191>, <0.244742, -0.244742, 0.938191>, <0.218508, -0.218508, 0.951057> }
triangle { <0.244742, -0.244742, 0.938191>, <0.257215, -0.231598, 0.938191>, <0.284389, -0.256065, 0.923880> }
triangle { <0.284389, -0.256065, 0.923880>, <0.270598, -0.270598, 0.923880>, <0.244742, -0.244742, 0.938191> }
triangle { <0.270598, -0.270598, 0.923880>, <0.284389, -0.256065, 0.923880>, <0.311125, -0.280138, 0.908143> }
triangle { <0.311125, -0.280138, 0.908143>, <0.296037, -0.296037, 0.908143>, <0.270598, -0.270598, 0.923880> }
triangle { <0.296037, -0.296037, 0.908143>, <0.311125, -0.280138, 0.908143>, <0.337381, -0.303779, 0.891007> }
triangle { <0.337381, -0.303779, 0.891007>, <0.321020, -0.321020, 0.891007>, <0.296037, -0.296037, 0.908143> }
triangle { <0.321020, -0.321020, 0.891007>, <0.337381, -0.303779, 0.891007>, <0.363116, -0.326951, 0.872496> }
triangle { <0.363116, -0.326951, 0.872496>, <0.345507, -0.345507, 0.872496>, <0.321020, -0.321020, 0.891007> }
triangle { <0.345507, -0.345507, 0.872496>, <0.363116, -0.326951, 0.872496>, <0.388292, -0.349620, 0.852640> }
triangle { <0.388292, -0.349620, 0.852640>, <0.369462, -0.369462, 0.852640>, <0.345507, -0.345507, 0.872496> }
triangle { <0.369462, -0.369462, 0.852640>, <0.388292, -0.349620, 0.852640>, <0.412869, -0.371749, 0.831470> }
triangle { <0.412869, -0.371749, 0.831470>, <0.392847, -0.392847, 0.831470>, <0.369462, -0.369462, 0.852640> }
triangle { <0.392847, -0.392847, 0.831470>, <0.412869, -0.371749, 0.831470>, <0.436810, -0.393305, 0.809017> }
triangle { <0.436810, -0.393305, 0.809017>, <0.415627, -0.415627, 0.809017>, <0.392847, -0.392847, 0.831470> }
triangle { <0.415627, -0.415627, 0.809017>, <0.436810, -0.393305, 0.809017>, <0.460076, -0.414255, 0.785317> }
triangle { <0.460076, -0.414255, 0.785317>, <0.437766, -0.437766, 0.785317>, <0.415627, -0.415627, 0.809017> }
triangle { <0.437766, -0.437766, 0.785317>, <0.460076, -0.414255, 0.785317>, <0.482634, -0.434566, 0.760406> }
triangle { <0.482634, -0.434566, 0.760406>, <0.459229, -0.459229, 0.760406>, <0.437766, -0.437766, 0.785317> }
triangle { <0.459229, -0.459229, 0.760406>, <0.482634, -0.434566, 0.760406>, <0.504447, -0.454206, 0.734323> }
triangle { <0.504447, -0.454206, 0.734323>, <0.479985, -0.479985, 0.734323>, <0.459229, -0.459229, 0.760406> }
triangle { <0.479985, -0.479985, 0.734323>, <0.504447, -0.454206, 0.734323>, <0.525483, -0.473147, 0.707107> }
triangle { <0.525483, -0.473147, 0.707107>, <0.500000, -0.500000, 0.707107>, <0.479985, -0.479985, 0.734323> }
triangle { <0.500000, -0.500000, 0.707107>, <0.525483, -0.473147, 0.707107>, <0.545708, -0.491358, 0.678801> }
triangle { <0.545708, -0.491358, 0.678801>, <0.519244, -0.519244, 0.678801>, <0.500000, -0.500000, 0.707107> }
triangle { <0.519244, -0.519244, 0.678801>, <0.545708, -0.491358, 0.678801>, <0.565092, -0.508811, 0.649448> }
triangle { <0.565092, -0.508811, 0.649448>, <0.537688, -0.537688, 0.649448>, <0.519244, -0.519244, 0.678801> }
triangle { <0.537688, -0.537688, 0.649448>, <0.565092, -0.508811, 0.649448>, <0.583604, -0.525480, 0.619094> }
triangle { <0.583604, -0.525480, 0.619094>, <0.555303, -0.555303, 0.619094>, <0.537688, -0.537688, 0.649448> }
triangle { <0.555303, -0.555303, 0.619094>, <0.583604, -0.525480, 0.619094>, <0.601217, -0.541338, 0.587785> }
triangle { <0.601217, -0.541338, 0.587785>, <0.572061, -0.572061, 0.587785>, <0.555303, -0.555303, 0.619094> }
triangle { <0.572061, -0.572061, 0.587785>, <0.601217, -0.541338, 0.587785>, <0.617902, -0.556362, 0.555570> }
triangle { <0.617902, -0.556362, 0.555570>, <0.587938, -0.587938, 0.555570>, <0.572061, -0.572061, 0.587785> }
triangle { <0.587938, -0.587938, 0.555570>, <0.617902, -0.556362, 0.555570>, <0.633635, -0.570528, 0.522499> }
triangle { <0.633635, -0.570528, 0.522499>, <0.602908, -0.602908, 0.522499>, <0.587938, -0.587938, 0.555570> }
triangle { <0.602908, -0.602908, 0.522499>, <0.633635, -0.570528, 0.522499>, <0.648391, -0.583814, 0.488621> }
triangle { <0.648391, -0.583814, 0.488621>, <0.616948, -0.616948, 0.488621>, <0.602908, -0.602908, 0.522499> }
triangle { <0.616948, -0.616948, 0.488621>, <0.648391, -0.583814, 0.488621>, <0.662147, -0.596200, 0.453990> }
triangle { <0.662147, -0.596200, 0.453990>, <0.630037, -0.630037, 0.453990>, <0.616948, -0.616948, 0.488621> }
triangle { <0.630037, -0.630037, 0.453990>, <0.662147, -0.596200, 0.453990>, <0.674882, -0.607666, 0.418660> }
triangle { <0.674882, -0.607666, 0.418660>, <0.642154, -0.642154, 0.418660>, <0.630037, -0.630037, 0.453990> }
triangle { <0.642154, -0.642154, 0.418660>, <0.674882, -0.607666, 0.418660>, <0.686576, -0.618196, 0.382683> }
triangle { <0.686576, -0.618196, 0.382683>, <0.653281, -0.653281, 0.382683>, <0.642154, -0.642154, 0.418660> }
triangle { <0.653281, -0.653281, 0.382683>, <0.686576, -0.618196, 0.382683>, <0.697212, -0.627773, 0.346117> }
triangle { <0.697212, -0.627773, 0.346117>, <0.663401, -0.663401, 0.346117>, <0.653281, -0.653281, 0.382683> }
triangle { <0.663401, -0.663401, 0.346117>, <0.697212, -0.627773, 0.346117>, <0.706773, -0.636381, 0.309017> }
triangle { <0.706773, -0.636381, 0.309017>, <0.672499, -0.672499, 0.309017>, <0.663401, -0.663401, 0.346117> }
triangle { <0.672499, -0.672499, 0.309017>, <0.706773, -0.636381, 0.309017>, <0.715244, -0.644008, 0.271440> }
triangle { <0.715244, -0.644008, 0.271440>, <0.680559, -0.680559, 0.271440>, <0.672499, -0.672499, 0.309017> }
triangle { <0.680559, -0.680559, 0.271440>, <0.715244, -0.644008, 0.271440>, <0.722612, -0.650642, 0.233445> }
triangle { <0.722612, -0.650642, 0.233445>, <0.687569, -0.687569, 0.233445>, <0.680559, -0.680559, 0.271440> }
triangle { <0.687569, -0.687569, 0.233445>, <0.722612, -0.650642, 0.233445>, <0.728866, -0.656273, 0.195090> }
triangle { <0.728866, -0.656273, 0.195090>, <0.693520, -0.693520, 0.195090>, <0.687569, -0.687569, 0.233445> }
triangle { <0.693520, -0.693520, 0.195090>, <0.728866, -0.656273, 0.195090>, <0.733995, -0.660892, 0.156434> }
triangle { <0.733995, -0.660892, 0.156434>, <0.698401, -0.698401, 0.156434>, <0.693520, -0.693520, 0.195090> }
triangle { <0.698401, -0.698401, 0.156434>, <0.733995, -0.660892, 0.156434>, <0.737994, -0.664492, 0.117537> }
triangle { <0.737994, -0.664492, 0.117537>, <0.702205, -0.702205, 0.117537>, <0.698401, -0.698401, 0.156434> }
triangle { <0.702205, -0.702205, 0.117537>, <0.737994, -0.664492, 0.117537>, <0.740854, -0.667068, 0.078459> }
triangle { <0.740854, -0.667068, 0.078459>, <0.704927, -0.704927, 0.078459>, <0.702205, -0.702205, 0.117537> }
triangle { <0.704927, -0.704927, 0.078459>, <0.740854, -0.667068, 0.078459>, <0.742572, -0.668615, 0.039260> }
triangle { <0.742572, -0.668615, 0.039260>, <0.706562, -0.706562, 0.039260>, <0.704927, -0.704927, 0.078459> }
triangle { <0.706562, -0.706562, 0.039260>, <0.742572, -0.668615, 0.039260>, <0.743145, -0.669131, -0.000000> }
triangle { <0.743145, -0.669131, -0.000000>, <0.707107, -0.707107, -0.000000>, <0.706562, -0.706562, 0.039260> }
triangle { <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.030511, -0.024707, 0.999229> }
triangle { <0.030511, -0.024707, 0.999229>, <0.029176, -0.026270, 0.999229>, <0.000000, 0.000000, 1.000000> }
triangle { <0.029176, -0.026270, 0.999229>, <0.030511, -0.024707, 0.999229>, <0.060974, -0.049376, 0.996917> }
triangle { <0.060974, -0.049376, 0.996917>, <0.058306, -0.052499, 0.996917>, <0.029176, -0.026270, 0.999229> }
triangle { <0.058306, -0.052499, 0.996917>, <0.060974, -0.049376, 0.996917>, <0.091344, -0.073969, 0.993068> }
triangle { <0.091344, -0.073969, 0.993068>, <0.087347, -0.078648, 0.993068>, <0.058306, -0.052499, 0.996917> }
triangle { <0.087347, -0.078648, 0.993068>, <0.091344, -0.073969, 0.993068>, <0.121572, -0.098447, 0.987688> }
triangle { <0.121572, -0.098447, 0.987688>, <0.116253, -0.104675, 0.987688>, <0.087347, -0.078648, 0.993068> }
triangle { <0.116253, -0.104675, 0.987688>, <0.121572, -0.098447, 0.987688>, <0.151614, -0.122774, 0.980785> }
triangle { <0.151614, -0.122774, 0.980785>, <0.144980, -0.130541, 0.980785>, <0.116253, -0.104675, 0.987688> }
triangle { <0.144980, -0.130541, 0.980785>, <0.151614, -0.122774, 0.980785>, <0.181421, -0.146912, 0.972370> }
triangle { <0.181421, -0.146912, 0.972370>, <0.173484, -0.156205, 0.972370>, <0.144980, -0.130541, 0.980785> }
triangle { <0.173484, -0.156205, 0.972370>, <0.181421, -0.146912, 0.972370>, <0.210949, -0.170823, 0.962455> }
triangle { <0.210949, -0.170823, 0.962455>, <0.201720, -0.181629, 0.962455>, <0.173484, -0.156205, 0.972370> }
triangle { <0.201720, -0.181629, 0.962455>, <0.210949, -0.170823, 0.962455>, <0.240151, -0.194471, 0.951057> }
triangle { <0.240151, -0.194471, 0.951057>, <0.229644, -0.206773, 0.951057>, <0.201720, -0.181629, 0.962455> }
triangle { <0.229644, -0.206773, 0.951057>, <0.240151, -0.194471, 0.951057>, <0.268983, -0.217819, 0.938191> }
triangle { <0.268983, -0.217819, 0.938191>, <0.257215, -0.231598, 0.938191>, <0.229644, -0.206773, 0.951057> }
triangle { <0.257215, -0.231598, 0.938191>, <0.268983, -0.217819, 0.938191>, <0.297401, -0.240830, 0.923880> }
triangle { <0.297401, -0.240830, 0.923880>, <0.284389, -0.256065, 0.923880>, <0.257215, -0.231598, 0.938191> }
triangle { <0.284389, -0.256065, 0.923880>, <0.297401, -0.240830, 0.923880>, <0.325360, -0.263471, 0.908143> }
triangle { <0.325360, -0.263471, 0.908143>, <0.311125, -0.280138, 0.908143>, <0.284389, -0.256065, 0.923880> }
triangle { <0.311125, -0.280138, 0.908143>, <0.325360, -0.263471, 0.908143>, <0.352817, -0.285705, 0.891007> }
triangle { <0.352817, -0.285705, 0.891007>, <0.337381, -0.303779, 0.891007>, <0.311125, -0.280138, 0.908143> }
triangle { <0.337381, -0.303779, 0.891007>, <0.352817, -0.285705, 0.891007>, <0.379730, -0.307499, 0.872496> }
triangle { <0.379730, -0.307499, 0.872496>, <0.363116, -0.326951, 0.872496>, <0.337381, -0.303779, 0.891007> }
triangle { <0.363116, -0.326951, 0.872496>, <0.379730, -0.307499, 0.872496>, <0.406058, -0.328819, 0.852640> }
triangle { <0.406058, -0.328819, 0.852640>, <0.388292, -0.349620, 0.852640>, <0.363116, -0.326951, 0.872496> }
triangle { <0.388292, -0.349620, 0.852640>, <0.406058, -0.328819, 0.852640>, <0.431759, -0.349632, 0.831470> }
triangle { <0.431759, -0.349632, 0.831470>, <0.412869, -0.371749, 0.831470>, <0.388292, -0.349620, 0.852640> }
triangle { <0.412869, -0.371749, 0.831470>, <0.431759, -0.349632, 0.831470>, <0.456795, -0.369905, 0.809017> }
triangle { <0.456795, -0.369905, 0.809017>, <0.436810, -0.393305, 0.809017>, <0.412869, -0.371749, 0.831470> }
triangle { <0.436810, -0.393305, 0.809017>, <0.456795, -0.369905, 0.809017>, <0.481126, -0.389608, 0.785317> }
triangle { <0.481126, -0.389608, 0.785317>, <0.460076, -0.414255, 0.785317>, <0.436810, -0.393305, 0.809017> }
triangle { <0.460076, -0.414255, 0.785317>, <0.481126, -0.389608, 0.785317>, <0.504716, -0.408711, 0.760406> }
triangle { <0.504716, -0.408711, 0.760406>, <0.482634, -0.434566, 0.760406>, <0.460076, -0.414255, 0.785317> }
triangle { <0.482634, -0.434566, 0.760406>, <0.504716, -0.408711, 0.760406>, <0.527527, -0.427183, 0.734323> }
triangle { <0.527527, -0.427183, 0.734323>, <0.504447, -0.454206, 0.734323>, <0.482634, -0.434566, 0.760406> }
triangle { <0.504447, -0.454206, 0.734323>, <0.527527, -0.427183, 0.734323>, <0.549525, -0.444997, 0.707107> }
triangle { <0.549525, -0.444997, 0.707107>, <0.525483, -0.473147, 0.707107>, <0.504447, -0.454206, 0.734323> }
triangle { <0.525483, -0.473147, 0.707107>, <0.549525, -0.444997, 0.707107>, <0.570676, -0.462124, 0.678801> }
triangle { <0.570676, -0.462124, 0.678801>, <0.545708, -0.491358, 0.678801>, <0.525483, -0.473147, 0.707107> }
triangle { <0.545708, -0.491358, 0.678801>, <0.570676, -0.462124, 0.678801>, <0.590946, -0.478539, 0.649448> }
triangle { <0.590946, -0.478539, 0.649448>, <0.565092, -0.508811, 0.649448>, <0.545708, -0.491358, 0.678801> }
triangle { <0.565092, -0.508811, 0.649448>, <0.590946, -0.478539, 0.649448>, <0.610306, -0.494216, 0.619094> }
triangle { <0.610306, -0.494216, 0.619094>, <0.583604, -0.525480, 0.619094>, <0.565092, -0.508811, 0.649448> }
triangle { <0.583604, -0.525480, 0.619094>, <0.610306, -0.494216, 0.619094>, <0.628724, -0.509131, 0.587785> }
triangle { <0.628724, -0.509131, 0.587785>, <0.601217, -0.541338, 0.587785>, <0.583604, -0.525480, 0.619094> }
triangle { <0.601217, -0.541338, 0.587785>, <0.628724, -0.509131, 0.587785>, <0.646173, -0.523261, 0.555570> }
triangle { <0.646173, -0.523261, 0.555570>, <0.617902, -0.556362, 0.555570>, <0.601217, -0.541338, 0.587785> }
triangle { <0.617902, -0.556362, 0.555570>, <0.646173, -0.523261, 0.555570>, <0.662626, -0.536584, 0.522499> }
triangle { <0.662626, -0.536584, 0.522499>, <0.633635, -0.570528, 0.522499>, <0.617902, -0.556362, 0.555570> }
triangle { <0.633635, -0.570528, 0.522499>, <0.662626, -0.536584, 0.522499>, <0.678057, -0.549080, 0.488621> }
triangle { <0.678057, -0.549080, 0.488621>, <0.648391, -0.583814, 0.488621>, <0.633635, -0.570528, 0.522499> }
triangle { <0.648391, -0.583814, 0.488621>, <0.678057, -0.549080, 0.488621>, <0.692442, -0.560729, 0.453990> }
triangle { <0.692442, -0.560729, 0.453990>, <0.662147, -0.596200, 0.453990>, <0.648391, -0.583814, 0.488621> }
triangle { <0.662147, -0.596200, 0.453990>, <0.692442, -0.560729, 0.453990>, <0.705760, -0.571513, 0.418660> }
triangle { <0.705760, -0.571513, 0.418660>, <0.674882, -0.607666, 0.418660>, <0.662147, -0.596200, 0.453990> }
triangle { <0.674882, -0.607666, 0.418660>, <0.705760, -0.571513, 0.418660>, <0.717989, -0.581416, 0.382683> }
triangle { <0.717989, -0.581416, 0.382683>, <0.686576, -0.618196, 0.382683>, <0.674882, -0.607666, 0.418660> }
triangle { <0.686576, -0.618196, 0.382683>, <0.717989, -0.581416, 0.382683>, <0.729112, -0.590423, 0.346117> }
triangle { <0.729112, -0.590423, 0.346117>, <0.697212, -0.627773, 0.346117>, <0.686576, -0.618196, 0.382683> }
triangle { <0.697212, -0.627773, 0.346117>, <0.729112, -0.590423, 0.346117>, <0.739110, -0.598519, 0.309017> }
triangle { <0.739110, -0.598519, 0.309017>, <0.706773, -0.636381, 0.309017>, <0.697212, -0.627773, 0.346117> }
triangle { <0.706773, -0.636381, 0.309017>, <0.739110, -0.598519, 0.309017>, <0.747968, -0.605693, 0.271440> }
triangle { <0.747968, -0.605693, 0.271440>, <0.715244, -0.644008, 0.271440>, <0.706773, -0.636381, 0.309017> }
triangle { <0.715244, -0.644008, 0.271440>, <0.747968, -0.605693, 0.271440>, <0.755673, -0.611932, 0.233445> }
triangle { <0.755673, -0.611932, 0.233445>, <0.722612, -0.650642, 0.233445>, <0.715244, -0.644008, 0.271440> }
triangle { <0.722612, -0.650642, 0.233445>, <0.755673, -0.611932, 0.233445>, <0.762213, -0.617228, 0.195090> }
triangle { <0.762213, -0.617228, 0.195090>, <0.728866, -0.656273, 0.195090>, <0.722612, -0.650642, 0.233445> }
triangle { <0.728866, -0.656273, 0.195090>, <0.762213, -0.617228, 0.195090>, <0.767578, -0.621572, 0.156434> }
triangle { <0.767578, -0.621572, 0.156434>, <0.733995, -0.660892, 0.156434>, <0.728866, -0.656273, 0.195090> }
triangle { <0.733995, -0.660892, 0.156434>, <0.767578, -0.621572, 0.156434>, <0.771759, -0.624958, 0.117537> }
triangle { <0.771759, -0.624958, 0.117537>, <0.737994, -0.664492, 0.117537>, <0.733995, -0.660892, 0.156434> }
triangle { <0.737994, -0.664492, 0.117537>, <0.771759, -0.624958, 0.117537>, <0.774750, -0.627380, 0.078459> }
triangle { <0.774750, -0.627380, 0.078459>, <0.740854, -0.667068, 0.078459>, <0.737994, -0.664492, 0.117537> }
triangle { <0.740854, -0.667068, 0.078459>, <0.774750, -0.627380, 0.078459>, <0.776547, -0.628835, 0.039260> }
triangle { <0.776547, -0.628835, 0.039260>, <0.742572, -0.668615, 0.039260>, <0.740854, -0.667068, 0.078459> }
triangle { <0.742572, -0.668615, 0.039260>, <0.776547, -0.628835, 0.039260>, <0.777146, -0.629320, -0.000000> }
triangle { <0.777146, -0.629320, -0.000000>, <0.743145, -0.669131, -0.000000>, <0.742572, -0.668615, 0.039260> }
triangle { <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.031762, -0.023076, 0.999229> }
triangle { <0.031762, -0.023076, 0.999229>, <0.030511, -0.024707, 0.999229>, <0.000000, 0.000000, 1.000000> }
triangle { <0.030511, -0.024707, 0.999229>, <0.031762, -0.023076, 0.999229>, <0.063475, -0.046117, 0.996917> }
triangle { <0.063475, -0.046117, 0.996917>, <0.060974, -0.049376, 0.996917>, <0.030511, -0.024707, 0.999229> }
triangle { <0.060974, -0.049376, 0.996917>, <0.063475, -0.046117, 0.996917>, <0.095090, -0.069087, 0.993068> }
triangle { <0.095090, -0.069087, 0.993068>, <0.091344, -0.073969, 0.993068>, <0.060974, -0.049376, 0.996917> }
triangle { <0.091344, -0.073969, 0.993068>, <0.095090, -0.069087, 0.993068>, <0.126558, -0.091950, 0.987688> }
triangle { <0.126558, -0.091950, 0.987688>, <0.121572, -0.098447, 0.987688>, <0.091344, -0.073969, 0.993068> }
triangle { <0.121572, -0.098447, 0.987688>, <0.126558, -0.091950, 0.987688>, <0.157831, -0.114671, 0.980785> }
triangle { <0.157831, -0.114671, 0.980785>, <0.151614, -0.122774, 0.980785>, <0.121572, -0.098447, 0.987688> }
triangle { <0.151614, -0.122774, 0.980785>, <0.157831, -0.114671, 0.980785>, <0.188861, -0.137216, 0.972370> }
triangle { <0.188861, -0.137216, 0.972370>, <0.181421, -0.146912, 0.972370>, <0.151614, -0.122774, 0.980785> }
triangle { <0.181421, -0.146912, 0.972370>, <0.188861, -0.137216, 0.972370>, <0.219600, -0.159549, 0.962455> }
triangle { <0.219600, -0.159549, 0.962455>, <0.210949, -0.170823, 0.962455>, <0.181421, -0.146912, 0.972370> }
triangle { <0.210949, -0.170823, 0.962455>, <0.219600, -0.159549, 0.962455>, <0.250000, -0.181636, 0.951057> }
triangle { <0.250000, -0.181636, 0.951057>, <0.240151, -0.194471, 0.951057>, <0.210949, -0.170823, 0.962455> }
triangle { <0.240151, -0.194471, 0.951057>, <0.250000, -0.181636, 0.951057>, <0.280015, -0.203443, 0.938191> }
triangle { <0.280015, -0.203443, 0.938191>, <0.268983, -0.217819, 0.938191>, <0.240151, -0.194471, 0.951057> }
triangle { <0.268983, -0.217819, 0.938191>, <0.280015, -0.203443, 0.938191>, <0.309597, -0.224936, 0.923880> }
triangle { <0.309597, -0.224936, 0.923880>, <0.297401, -0.240830, 0.923880>, <0.268983, -0.217819, 0.938191> }
triangle { <0.297401, -0.240830, 0.923880>, <0.309597, -0.224936, 0.923880>, <0.338703, -0.246082, 0.908143> }
triangle { <0.338703, -0.246082, 0.908143>, <0.325360, -0.263471, 0.908143>, <0.297401, -0.240830, 0.923880> }
triangle { <0.325360, -0.263471, 0.908143>, <0.338703, -0.246082, 0.908143>, <0.367286, -0.266849, 0.891007> }
triangle { <0.367286, -0.266849, 0.891007>, <0.352817, -0.285705, 0.891007>, <0.325360, -0.263471, 0.908143> }
triangle { <0.352817, -0.285705, 0.891007>, <0.367286, -0.266849, 0.891007>, <0.395303, -0.287204, 0.872496> }
triangle { <0.395303, -0.287204, 0.872496>, <0.379730, -0.307499, 0.872496>, <0.352817, -0.285705, 0.891007> }
triangle { <0.379730, -0.307499, 0.872496>, <0.395303, -0.287204, 0.872496>, <0.422710, -0.307117, 0.852640> }
triangle { <0.422710, -0.307117, 0.852640>, <0.406058, -0.328819, 0.852640>, <0.379730, -0.307499, 0.872496> }
triangle { <0.406058, -0.328819, 0.852640>, <0.422710, -0.307117, 0.852640>, <0.449466, -0.326556, 0.831470> }
triangle { <0.449466, -0.326556, 0.831470>, <0.431759, -0.349632, 0.831470>, <0.406058, -0.328819, 0.852640> }
triangle { <0.431759, -0.349632, 0.831470>, <0.449466, -0.326556, 0.831470>, <0.475528, -0.345492, 0.809017> }
triangle { <0.475528, -0.345492, 0.809017>, <0.456795, -0.369905, 0.809017>, <0.431759, -0.349632, 0.831470> }
triangle { <0.456795, -0.369905, 0.809017>, <0.475528, -0.345492, 0.809017>, <0.500858, -0.363894, 0.785317> }
triangle { <0.500858, -0.363894, 0.785317>, <0.481126, -0.389608, 0.785317>, <0.456795, -0.369905, 0.809017> }
triangle { <0.481126, -0.389608, 0.785317>, <0.500858, -0.363894, 0.785317>, <0.525415, -0.381736, 0.760406> }
triangle { <0.525415, -0.381736, 0.760406>, <0.504716, -0.408711, 0.760406>, <0.481126, -0.389608, 0.785317> }
triangle { <0.504716, -0.408711, 0.760406>, <0.525415, -0.381736, 0.760406>, <0.549161, -0.398989, 0.734323> }
triangle { <0.549161, -0.398989, 0.734323>, <0.527527, -0.427183, 0.734323>, <0.504716, -0.408711, 0.760406> }
triangle { <0.527527, -0.427183, 0.734323>, <0.549161, -0.398989, 0.734323>, <0.572061, -0.415627, 0.707107> }
triangle { <0.572061, -0.415627, 0.707107>, <0.549525, -0.444997, 0.707107>, <0.527527, -0.427183, 0.734323> }
triangle { <0.549525, -0.444997, 0.707107>, <0.572061, -0.415627, 0.707107>, <0.594079, -0.431624, 0.678801> }
triangle { <0.594079, -0.431624, 0.678801>, <0.570676, -0.462124, 0.678801>, <0.549525, -0.444997, 0.707107> }
triangle { <0.570676, -0.462124, 0.678801>, <0.594079, -0.431624, 0.678801>, <0.615181, -0.446955, 0.649448> }
triangle { <0.615181, -0.446955, 0.649448>, <0.590946, -0.478539, 0.649448>, <0.570676, -0.462124, 0.678801> }
triangle { <0.590946, -0.478539, 0.649448>, <0.615181, -0.446955, 0.649448>, <0.635335, -0.461598, 0.619094> }
triangle { <0.635335, -0.461598, 0.619094>, <0.610306, -0.494216, 0.619094>, <0.590946, -0.478539, 0.649448> }
triangle { <0.610306, -0.494216, 0.619094>, <0.635335, -0.461598, 0.619094>, <0.654508, -0.475528, 0.587785> }
triangle { <0.654508, -0.475528, 0.587785>, <0.628724, -0.509131, 0.587785>, <0.610306, -0.494216, 0.619094> }
triangle { <0.628724, -0.509131, 0.587785>, <0.654508, -0.475528, 0.587785>, <0.672673, -0.488726, 0.555570> }
triangle { <0.672673, -0.488726, 0.555570>, <0.646173, -0.523261, 0.555570>, <0.628724, -0.509131, 0.587785> }
triangle { <0.646173, -0.523261, 0.555570>, <0.672673, -0.488726, 0.555570>, <0.689800, -0.501169, 0.522499> }
triangle { <0.689800, -0.501169, 0.522499>, <0.662626, -0.536584, 0.522499>, <0.646173, -0.523261, 0.555570> }
triangle { <0.662626, -0.536584, 0.522499>, <0.689800, -0.501169, 0.522499>, <0.705864, -0.512840, 0.488621> }
triangle { <0.705864, -0.512840, 0.488621>, <0.678057, -0.549080, 0.488621>, <0.662626, -0.536584, 0.522499> }
triangle { <0.678057, -0.549080, 0.488621>, <0.705864, -0.512840, 0.488621>, <0.720839, -0.523720, 0.453990> }
triangle { <0.720839, -0.523720, 0.453990>, <0.692442, -0.560729, 0.453990>, <0.678057, -0.549080, 0.488621> }
triangle { <0.692442, -0.560729, 0.453990>, <0.720839, -0.523720, 0.453990>, <0.734703, -0.533793, 0.418660> }
triangle { <0.734703, -0.533793, 0.418660>, <0.705760, -0.571513, 0.418660>, <0.692442, -0.560729, 0.453990> }
triangle { <0.705760, -0.571513, 0.418660>, <0.734703, -0.533793, 0.418660>, <0.747434, -0.543043, 0.382683> }
triangle { <0.747434, -0.543043, 0.382683>, <0.717989, -0.581416, 0.382683>, <0.705760, -0.571513, 0.418660> }
triangle { <0.717989, -0.581416, 0.382683>, <0.747434, -0.543043, 0.382683>, <0.759013, -0.551455, 0.346117> }
triangle { <0.759013, -0.551455, 0.346117>, <0.729112, -0.590423, 0.346117>, <0.717989, -0.581416, 0.382683> }
triangle { <0.729112, -0.590423, 0.346117>, <0.759013, -0.551455, 0.346117>, <0.769421, -0.559017, 0.309017> }
triangle { <0.769421, -0.559017, 0.309017>, <0.739110, -0.598519, 0.309017>, <0.729112, -0.590423, 0.346117> }
triangle { <0.739110, -0.598519, 0.309017>, <0.769421, -0.559017, 0.309017>, <0.778643, -0.565717, 0.271440> }
triangle { <0.778643, -0.565717, 0.271440>, <0.747968, -0.605693, 0.271440>, <0.739110, -0.598519, 0.309017> }
triangle { <0.747968, -0.605693, 0.271440>, <0.778643, -0.565717, 0.271440>, <0.786664, -0.571545, 0.233445> }
triangle { <0.786664, -0.571545, 0.233445>, <0.755673, -0.611932, 0.233445>, <0.747968, -0.605693, 0.271440> }
triangle { <0.755673, -0.611932, 0.233445>, <0.786664, -0.571545, 0.233445>, <0.793472, -0.576491, 0.195090> }
triangle { <0.793472, -0.576491, 0.195090>, <0.762213, -0.617228, 0.195090>, <0.755673, -0.611932, 0.233445> }
triangle { <0.762213, -0.617228, 0.195090>, <0.793472, -0.576491, 0.195090>, <0.799057, -0.580549, 0.156434> }
triangle { <0.799057, -0.580549, 0.156434>, <0.767578, -0.621572, 0.156434>, <0.762213, -0.617228, 0.195090> }
triangle { <0.767578, -0.621572, 0.156434>, <0.799057, -0.580549, 0.156434>, <0.803409, -0.583711, 0.117537> }
triangle { <0.803409, -0.583711, 0.117537>, <0.771759, -0.624958, 0.117537>, <0.767578, -0.621572, 0.156434> }
triangle { <0.771759, -0.624958, 0.117537>, <0.803409, -0.583711, 0.117537>, <0.806523, -0.585973, 0.078459> }
triangle { <0.806523, -0.585973, 0.078459>, <0.774750, -0.627380, 0.078459>, <0.771759, -0.624958, 0.117537> }
triangle { <0.774750, -0.627380, 0.078459>, <0.806523, -0.585973, 0.078459>, <0.808393, -0.587332, 0.039260> }
triangle { <0.808393, -0.587332, 0.039260>, <0.776547, -0.628835, 0.039260>, <0.774750, -0.627380, 0.078459> }
triangle { <0.776547, -0.628835, 0.039260>, <0.808393, -0.587332, 0.039260>, <0.809017, -0.587785, -0.000000> }
triangle { <0.809017, -0.587785, -0.000000>, <0.777146, -0.629320, -0.000000>, <0.776547, -0.628835, 0.039260> }
triangle { <0.000000, 0.000000, 1.000000>, <0.000000, 0.000000, 1.000000>, <0.032926, -0.021382, 0.999229> }
triangle { <0.032926, -0.021382, 0.999229>, <0.031762, -0.023076, 0.999229>, <0.000000, 0.000000, 1.000000> }
triangle { <0.031762, -0.023076, 0.999229>, <0.032926, -0.021382, 0.999229>, <0.065801, -0.042732, 0.996917> }
triangle { <0.065801, -0.042732, 0.996917>, <0.063475, -0.046117, 0.996917>, <0.031762, -0.023076, 0.999229> }
triangle { <0.063475, -0.046117, 0.996917>, <0.065801, -0.042732, 0.996917>, <0.098575, -0.064015, 0.993068> }
triangle { <0.098575, -0.064015, 0.993068>, <0.095090, -0.069087, 0.993068>, <0.063475, -0.046117, 0.996917> }
triangle { <0.095090, -0.069087, 0.993068>, <0.098575, -0.0