// Persistence of Vision Ray Tracer Scene Description File
// File: ?.pov
// Vers: 3.1
// Desc: Basic Scene Example
// Date: mm/dd/yy
// Auth: ?[esp]
//

#version 3.1 ;

#include "colors.inc"
#include "textures.inc"
#include "skies.inc"
#include "golds.inc"

global_settings {assumed_gamma 2.2}

// ----------------------------------------
camera{
  location  <0.0, 0.0, -4.0>
  direction 1.5*z
  right     9/16*x
  look_at   <0.0, 2.50,  0.0>
}

sky_sphere{S_Cloud3}

/*
sky_sphere{
  pigment
  { gradient y
    color_map { [0.0 color blue 0.6] [1.0 color rgb 1] }
  }
}
*/

light_source{0*x color <1,1,1> translate <0, 0, -30>}

// ----------------------------------------

//plane { y, -1 pigment {Grey} finish {ambient 0.4 diffuse 0.3 roughness .1 phong 6 phong_size 7}}

#declare win = union {

triangle { <0,1 ,0 >,<1 ,1 ,0 >,<1 ,0 ,0 >}
triangle { <0,0 ,0 >,<0 ,1 ,0 >,<1 ,0 ,0 >}

}//win

object {win texture{pigment{image_map{tga "/home/matt/images/gates3a-mos.tga" 
once map_type 0}}}// filter all 0.5}}} 
finish{ambient .7}
translate<-.5,-.5,-.5> scale <1,1.05,1> scale 1.4 translate <0,3,0> }

#declare script = union {

text {ttf "/home/matt/fonts/fonts/calligra.ttf" 
"Eula Ch 16, vs 66" .1, 0
texture {T09}
scale .2 translate 2*y translate -.75*x
}

text {ttf "/home/matt/fonts/fonts/calligra.ttf" 
"And a Window opened" .1, 0
texture {T09}
scale .13 translate 1.8*y translate -.7*x
}

text {ttf "/home/matt/fonts/fonts/calligra.ttf" 
"in the Heavens" .1, 0
texture {T09}
scale .13 translate 1.65*y translate -.3*x
}
}//union

object {script translate -0.5*z }
