#declare LowWing = false;

#macro HalfWing(low)
	union{
    difference{
        intersection{
            cylinder{<-2, -1, 0>, <-2, 1, 0>, 2}
            plane{-x, 2} 
            cylinder{<0, -1, 6>, <0, 1, 6>, 6}
            plane{y, 0.0001}
            plane{-y, 0}
        }
        cylinder{<-2.2, -1, 1.8>, <-2.2, 1, 1.8>, 0.3}
        cylinder{<-2.2, -1, 1.3>, <-2.2, 1, 1.3>, 0.35} 
        cylinder{<-2.15, -1, 1.0>, <-2.15, 1, 1.0>, 0.35}
        cylinder{<-2.05, -1, 0.6>, <-2.05, 1, 0.6>, 0.35}
        cylinder{<-1.9, -1, 0.2>, <-1.9, 1, 0.2>, 0.35}
    }
    // stripes
    texture{
        pigment{
            onion
            color_map{
                [0 0.45 color rgb <1, 0.5, 0.1> color rgb <1, 0.5, 0.1>]
                [0.45 0.53 color rgb <1, 0.5, 0.1> color rgb 0] 
                [0.53 0.58 color rgb 0 color rgb 0]
                [0.58 0.65 color rgb 0 color rgb <1, 0.5, 0.1>]
                [0.65 color rgb <1, 0.5, 0.1>]
            }       
            frequency 180          
            turbulence 0.1
            scale 40
            translate <-4.7, 0, 4>
        }  
        finish{ambient 0 diffuse 0.8 brilliance 0.4}
    }         
    // base
    texture{
        pigment{
            onion
            color_map{
                [0 0.1 color rgb <1, 0.5, 0.1> color rgb <1, 0.5, 0.1>]
                [0.1 0.11 color rgb <1, 0.5, 0.1> color rgb 0]
                [0.11 0.115 color rgb 0 color rgb 0] 
                [0.115 0.12 color rgb 0 color rgbf <0, 0, 0, 1>]
                [0.12 color rgbf <0, 0, 0, 1>]
            }                 
            turbulence 0.05
            scale 3.5
            translate <6.1, 0, 4>
        } 
        finish{ambient 0 diffuse 0.8 brilliance 0.4}
    }
    texture{
        pigment{
            onion
            color_map{
                [0 0.65 color rgbf <0, 0, 0, 1> color rgbf <0, 0, 0, 1>]
                [0.65 0.75 color rgbf <0, 0, 0, 1> color rgb 0]
                [0.75 color rgb 0]
            } 
            scale 2
            translate <-1.45, 0, 0.27>
            rotate -y*12
        } 
        finish{ambient 0 diffuse 0.8 brilliance 0.4}
    } 
    // low
    texture{
        pigment{
            onion
            color_map{
                [0 0.95 color rgbf <0, 0, 0, 1> color rgbf <0, 0, 0, 1>]
                [0.95 0.98 color rgbf <0, 0, 0, 1> color rgb 0]
                [0.98 color rgb 0]
            } 
            scale 6
            translate <0, 0, 6>
            rotate y*3
            translate -z*0.14
        } 
        finish{ambient 0 diffuse 0.8 brilliance 0.4}
    } 
    // cut    
    texture{
        pigment{
            onion
            color_map{
                [0 0.2 color rgb 0  color rgb 0]
                [0.2 0.25 color rgb 0 color rgbf <0, 0, 0, 1>]
                [0.25 1 color rgbf <0, 0, 0, 1> color rgbf <0, 0, 0, 1>]
            } 
            scale 2.8
            translate <-2.2, 0, 1.8>
        } 
        finish{ambient 0 diffuse 0.8 brilliance 0.4}
    }
    texture{
        pigment{
            onion
            color_map{
                [0 0.2 color rgb 0  color rgb 0]
                [0.2 0.25 color rgb 0 color rgbf <0, 0, 0, 1>]
                [0.25 1 color rgbf <0, 0, 0, 1> color rgbf <0, 0, 0, 1>]
            } 
            scale 2.8
            translate<-2.2, 0, 1.3>
        } 
        finish{ambient 0 diffuse 0.8 brilliance 0.4}
    } 
    texture{
        pigment{
            onion
            color_map{
                [0 0.2 color rgb 0  color rgb 0]
                [0.2 0.25 color rgb 0 color rgbf <0, 0, 0, 1>]
                [0.25 1 color rgbf <0, 0, 0, 1> color rgbf <0, 0, 0, 1>]
            } 
            scale 2.8
            translate<-2.15, 0, 1.0>
        } 
        finish{ambient 0 diffuse 0.8 brilliance 0.4}
    }
    texture{
        pigment{
            onion
            color_map{
                [0 0.2 color rgb 0  color rgb 0]
                [0.2 0.25 color rgb 0 color rgbf <0, 0, 0, 1>]
                [0.25 1 color rgbf <0, 0, 0, 1> color rgbf <0, 0, 0, 1>]
            } 
            scale 2.8
            translate<-2.05, 0, 0.6>
        } 
        finish{ambient 0 diffuse 0.8 brilliance 0.4}
    }
    texture{
        pigment{
            onion
            color_map{
                [0 0.2 color rgb 0  color rgb 0]
                [0.2 0.25 color rgb 0 color rgbf <0, 0, 0, 1>]
                [0.25 1 color rgbf <0, 0, 0, 1> color rgbf <0, 0, 0, 1>]
            } 
            scale 2.8
            translate<-1.9, 0, 0.2>
        } 
        finish{ambient 0 diffuse 0.8 brilliance 0.4}
    } 
    // spots
    #if(low = false)
    texture{
        pigment{
            onion
            color_map{
                [0 0.01 color rgb <1, 0.5, 0.1>  color rgb <1, 0.5, 0.1>]
                [0.01 0.015 color rgb <1, 0.5, 0.1>  color rgbf <1, 0.5, 0.1, 1>]
                [0.015 color rgbf 1]
            } 
            scale <18, 1, 12>
            rotate y*20 
            translate<-1.6, 0, 1.76>
        } 
        finish{ambient 0 diffuse 0.8 brilliance 0.4}
    }  
    #end
    texture{
        pigment{
            onion
            color_map{
                [0 0.01 color rgb 1  color rgb 1]
                [0.01 color rgbf 1]
            } 
            scale <3, 1, 7>     
            rotate -y*20
            translate<-1.8, 0, 1.55>
        } 
        finish{ambient 0 diffuse 0.8 brilliance 0.4}
    }
    texture{
        pigment{
            onion
            color_map{
                [0 0.01 color rgb 1  color rgb 1]
                [0.01 color rgbf 1]
            } 
            scale <2.5, 1, 7>     
            rotate -y*10
            translate<-1.74, 0, 1.36>
        } 
        finish{ambient 0 diffuse 0.8 brilliance 0.4}
    }
    texture{
        pigment{
            onion
            color_map{
                [0 0.01 color rgb 1  color rgb 1]
                [0.01 color rgbf 1]
            } 
            scale <2.5, 1, 7>     
            rotate -y*10
            translate<-1.72, 0, 1.15>
        } 
        finish{ambient 0 diffuse 0.8 brilliance 0.4}
    }
    texture{
        pigment{
            onion
            color_map{
                [0 0.01 color rgb 1  color rgb 1]
                [0.01 color rgbf 1]
            } 
            scale <2.5, 1, 7>     
            translate<-1.7, 0, 0.95>
        } 
        finish{ambient 0 diffuse 0.8 brilliance 0.4}
    }
    texture{
        pigment{
            onion
            color_map{
                [0 0.01 color rgb 1  color rgb 1]
                [0.01 color rgbf 1]
            } 
            scale <2.5, 1, 7>     
            rotate -y*10
            translate<-1.62, 0, 0.75>
        } 
        finish{ambient 0 diffuse 0.8 brilliance 0.4}
    }
    texture{
        pigment{
            onion
            color_map{
                [0 0.01 color rgb 1  color rgb 1]
                [0.01 color rgbf 1]
            } 
            scale <2.5, 1, 7>     
            rotate -y*5
            translate<-1.57, 0, 0.55>
        } 
        finish{ambient 0 diffuse 0.8 brilliance 0.4}
    } 
    texture{
        pigment{
            onion
            color_map{
                [0 0.01 color rgb 1  color rgb 1]
                [0.01 color rgbf 1]
            } 
            scale <2.5, 1, 7>     
            rotate -y*15
            translate<-1.48, 0, 0.35>
        } 
        finish{ambient 0 diffuse 0.8 brilliance 0.4}
    }  
    // small spots
    texture{
        pigment{
            onion
            color_map{
                [0 0.005 color rgb 1  color rgb 1]
                [0.005 color rgbf 1]
            } 
            scale <4, 1, 6> 
            translate<-1.9, 0, 1.6>
        } 
        finish{ambient 0 diffuse 0.8 brilliance 0.4}
    } 
    texture{
        pigment{
            onion
            color_map{
                [0 0.005 color rgb 1  color rgb 1]
                [0.005 color rgbf 1]
            } 
            scale <4, 1, 6> 
            translate<-1.8, 0, 1.23>
        } 
        finish{ambient 0 diffuse 0.8 brilliance 0.4}
    }
    texture{
        pigment{
            onion
            color_map{
                [0 0.005 color rgb 1  color rgb 1]
                [0.005 color rgbf 1]
            } 
            scale <4, 1, 6> 
            translate<-1.76, 0, 0.88>
        } 
        finish{ambient 0 diffuse 0.8 brilliance 0.4}
    }
} 
#end

#declare ButterflyBody = union {
    // middle
    sphere{0, 1 scale<0.1, 0.1, 0.4>} 
    // back
    sphere{
    	0, 1 
    	texture{ 
        	pigment{
        		gradient z
        		color_map{
        			[0.0 0.3 color rgb <0.35, 0.25, 0.2> color rgb <0.35, 0.25, 0.2>]
        			[0.3 0.5 color rgb <0.35, 0.25, 0.2> color rgb <0.45, 0.3, 0.25>]
        			[0.5 0.8 color rgb <0.45, 0.3, 0.25> color rgb <0.45, 0.3, 0.25>]
        			[0.8 1.0 color rgb <0.45, 0.3, 0.25> color rgb <0.35, 0.25, 0.2>]
        		}         
        		frequency 4                      
        	}
        	finish{ambient 0 diffuse 0.7 phong 0}
        	translate z*1
    	}
    	
    	scale<0.12, 0.12, 0.6> 
    	translate -z*0.5
    }
    // eyes
    union{
    	sphere{0, 0.05 translate<-0.05, 0.03, 0.3>} 
    	sphere{0, 0.05 translate<0.05, 0.03, 0.3>} 
    	
    	texture{ 
        	pigment{color rgb 0} 
        	finish{ambient 0 diffuse 0.7 phong 1 phong_size 30}
    	} 
    }
    // mouth
    sphere{0, 0.03 scale <1, 1, 3> translate<-0.02, -0.01, 0.35>}
    sphere{0, 0.03 scale <1, 1, 3> translate<0.02, -0.01, 0.35>}
    // moustache
    difference {
        torus{1, 0.013 rotate x*90 translate -x*1}
        plane{y, 0}
        rotate y*70
        translate<-0.02, 0.01, 0.35>
    }
    difference {
        torus{1, 0.013 rotate x*90 translate x*1}
        plane{y, 0} 
        rotate -y*70
        translate<0.02, 0.01, 0.35>
    } 
    texture{ 
        pigment{color rgb <0.35, 0.25, 0.2>} 
        finish{ambient 0 diffuse 0.7 phong 0}
    } 
}     

#declare LeftWing = union {
    object{HalfWing(false) rotate -y*15} 
    object{HalfWing(true) scale <0.95, 1, 0.8> rotate x*180 translate y*0.00005 rotate -y*6}    
}                                                                                      

#declare RightWing = union {
	object{HalfWing(false) rotate -y*15 rotate z*180 translate y*0.0001} 
    object{HalfWing(true) scale <0.95, 1, 0.8> rotate <180, -6, -180> translate -y*0.00005} 
}
               
#declare Butterfly = union {               
    object{LeftWing rotate -z*20 translate -x*0.06}
    object{RightWing rotate z*20 translate x*0.06}
    object{ButterflyBody}
    scale 0.4 
    translate 0.045
}