#macro Hair(Object, Count, Center, Height, HairColor)
	#local R0 = 0.001;
	#local way = 0;
	#local theta = 0;    
	#local lseed = seed(1000);
	#local realHeight = Height/5 + ((4 * Height)/5 * rand(lseed));
	#while (theta < pi)
		#local way = way + 2 * pi * sin(theta);
		#local theta = theta + (pi / Count);
	#end
	#local part = way / Count;
	#local theta = pi / Count;
	#local last = 0;
	#while (theta < pi)
		#local way = 2 * pi * sin(theta);
		#local startangle = -2 * pi * last / way;
		#local stepangle = 2 * pi * part / way;
		#local way = way + last;
		#while (way >= part)
			#local way = way - part;
			#local startangle = startangle + stepangle;
			#local PointInRange = Center + <sin(theta) * cos(startangle), sin(theta) * sin(startangle), cos(theta)>;
			#local Normal = <0, 0, 0>;
			#local P0 = trace(Object, PointInRange, Center - PointInRange, Normal);
			cone { P0 R0 P0 + realHeight * Normal 0 texture{HairColor} no_shadow}
		#end
		#local last = way;
		#local theta = theta + (pi / Count);
	#end
#end  

#declare FairHair = texture {
	pigment { color rgb 0.8}
	finish{ambient 0.1 diffuse 0.8 phong 0}
}

#declare Center = union {
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.0023, -0.0002, 0.0000> <-0.0023, -0.0002, 0.0013> <-0.0013, -0.0001, 0.0023> <-0.0000, 0.0000, 0.0023>
		<-0.0598, 0.2900, 0.0000> <-0.0598, 0.2900, 0.0013> <-0.0534, 0.2907, 0.0061> <-0.0521, 0.2908, 0.0061>
		<-0.1573, 0.6736, 0.0000> <-0.1573, 0.6736, 0.0097> <-0.1496, 0.6748, 0.0132> <-0.1399, 0.6759, 0.0132>
		<-0.1938, 0.9672, 0.0000> <-0.1938, 0.9672, 0.0097> <-0.1834, 0.9684, 0.0151> <-0.1738, 0.9694, 0.0151>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.0023, -0.0002, 0.0000> <-0.0598, 0.2900, 0.0000> <-0.1573, 0.6736, 0.0000> <-0.1938, 0.9672, 0.0000>
		<-0.0023, -0.0002, -0.0013> <-0.0598, 0.2900, -0.0013> <-0.1573, 0.6735, -0.0097> <-0.1938, 0.9671, -0.0097>
		<-0.0012, -0.0001, -0.0023> <-0.0534, 0.2907, -0.0061> <-0.1496, 0.6747, -0.0132> <-0.1834, 0.9682, -0.0151>
		<0.0000, -0.0000, -0.0023> <-0.0521, 0.2908, -0.0061> <-0.1399, 0.6758, -0.0132> <-0.1738, 0.9693, -0.0151>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.0000, -0.0000, -0.0023> <-0.0521, 0.2908, -0.0061> <-0.1399, 0.6758, -0.0132> <-0.1738, 0.9693, -0.0151>
		<0.0013, 0.0001, -0.0023> <-0.0509, 0.2909, -0.0061> <-0.1302, 0.6768, -0.0132> <-0.1641, 0.9703, -0.0151>
		<0.0023, 0.0002, -0.0013> <-0.0445, 0.2916, -0.0013> <-0.1225, 0.6780, -0.0097> <-0.1537, 0.9715, -0.0097>
		<0.0023, 0.0002, 0.0000> <-0.0445, 0.2916, 0.0000> <-0.1225, 0.6781, 0.0000> <-0.1537, 0.9715, 0.0000>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.0023, 0.0002, 0.0000> <-0.0445, 0.2916, 0.0000> <-0.1225, 0.6781, 0.0000> <-0.1537, 0.9715, 0.0000>
		<0.0023, 0.0002, 0.0013> <-0.0445, 0.2916, 0.0013> <-0.1225, 0.6781, 0.0097> <-0.1537, 0.9716, 0.0097>
		<0.0012, 0.0001, 0.0023> <-0.0509, 0.2909, 0.0061> <-0.1302, 0.6769, 0.0132> <-0.1641, 0.9705, 0.0151>
		<-0.0000, 0.0000, 0.0023> <-0.0521, 0.2908, 0.0061> <-0.1399, 0.6759, 0.0132> <-0.1738, 0.9694, 0.0151>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.1938, 0.9672, 0.0000> <-0.1938, 0.9672, 0.0097> <-0.1834, 0.9684, 0.0151> <-0.1738, 0.9694, 0.0151>
		<-0.2290, 1.2503, 0.0000> <-0.2290, 1.2504, 0.0097> <-0.2161, 1.2512, 0.0169> <-0.2064, 1.2522, 0.0169>
		<-0.2519, 1.6320, 0.0000> <-0.2519, 1.6320, 0.0094> <-0.2413, 1.6327, 0.0150> <-0.2318, 1.6327, 0.0150>
		<-0.2407, 1.9171, 0.0000> <-0.2407, 1.9172, 0.0094> <-0.2306, 1.9172, 0.0146> <-0.2211, 1.9172, 0.0146>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.1938, 0.9672, 0.0000> <-0.2290, 1.2503, 0.0000> <-0.2519, 1.6320, 0.0000> <-0.2407, 1.9171, 0.0000>
		<-0.1938, 0.9671, -0.0097> <-0.2290, 1.2503, -0.0097> <-0.2519, 1.6320, -0.0094> <-0.2407, 1.9171, -0.0094>
		<-0.1834, 0.9682, -0.0151> <-0.2160, 1.2510, -0.0169> <-0.2412, 1.6326, -0.0150> <-0.2306, 1.9171, -0.0146>
		<-0.1738, 0.9693, -0.0151> <-0.2064, 1.2521, -0.0169> <-0.2318, 1.6326, -0.0150> <-0.2211, 1.9171, -0.0146>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.1738, 0.9693, -0.0151> <-0.2064, 1.2521, -0.0169> <-0.2318, 1.6326, -0.0150> <-0.2211, 1.9171, -0.0146>
		<-0.1641, 0.9703, -0.0151> <-0.1967, 1.2531, -0.0169> <-0.2224, 1.6326, -0.0150> <-0.2117, 1.9171, -0.0146>
		<-0.1537, 0.9715, -0.0097> <-0.1837, 1.2539, -0.0097> <-0.2118, 1.6332, -0.0094> <-0.2016, 1.9171, -0.0094>
		<-0.1537, 0.9715, 0.0000> <-0.1837, 1.2540, 0.0000> <-0.2118, 1.6333, 0.0000> <-0.2016, 1.9171, 0.0000>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.1537, 0.9715, 0.0000> <-0.1837, 1.2540, 0.0000> <-0.2118, 1.6333, 0.0000> <-0.2016, 1.9171, 0.0000>
		<-0.1537, 0.9716, 0.0097> <-0.1837, 1.2540, 0.0097> <-0.2118, 1.6333, 0.0094> <-0.2016, 1.9172, 0.0094>
		<-0.1641, 0.9705, 0.0151> <-0.1967, 1.2533, 0.0169> <-0.2224, 1.6327, 0.0150> <-0.2117, 1.9172, 0.0146>
		<-0.1738, 0.9694, 0.0151> <-0.2064, 1.2522, 0.0169> <-0.2318, 1.6327, 0.0150> <-0.2211, 1.9172, 0.0146>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.2407, 1.9171, 0.0000> <-0.2407, 1.9172, 0.0094> <-0.2306, 1.9172, 0.0146> <-0.2211, 1.9172, 0.0146>
		<-0.2292, 2.2091, 0.0000> <-0.2292, 2.2091, 0.0094> <-0.2196, 2.2082, 0.0142> <-0.2102, 2.2082, 0.0142>
		<-0.1767, 2.5970, 0.0000> <-0.1767, 2.5970, 0.0082> <-0.1652, 2.5960, 0.0147> <-0.1571, 2.5947, 0.0147>
		<-0.1187, 2.8834, 0.0000> <-0.1187, 2.8834, 0.0082> <-0.1100, 2.8820, 0.0127> <-0.1020, 2.8807, 0.0127>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.2407, 1.9171, 0.0000> <-0.2292, 2.2091, 0.0000> <-0.1767, 2.5970, 0.0000> <-0.1187, 2.8834, 0.0000>
		<-0.2407, 1.9171, -0.0094> <-0.2292, 2.2090, -0.0094> <-0.1767, 2.5970, -0.0082> <-0.1187, 2.8833, -0.0082>
		<-0.2306, 1.9171, -0.0146> <-0.2196, 2.2081, -0.0142> <-0.1652, 2.5959, -0.0147> <-0.1100, 2.8819, -0.0127>
		<-0.2211, 1.9171, -0.0146> <-0.2102, 2.2081, -0.0142> <-0.1571, 2.5946, -0.0147> <-0.1020, 2.8806, -0.0127>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.2211, 1.9171, -0.0146> <-0.2102, 2.2081, -0.0142> <-0.1571, 2.5946, -0.0147> <-0.1020, 2.8806, -0.0127>
		<-0.2117, 1.9171, -0.0146> <-0.2008, 2.2081, -0.0142> <-0.1491, 2.5933, -0.0147> <-0.0939, 2.8792, -0.0127>
		<-0.2016, 1.9171, -0.0094> <-0.1912, 2.2072, -0.0094> <-0.1376, 2.5923, -0.0082> <-0.0852, 2.8778, -0.0082>
		<-0.2016, 1.9171, 0.0000> <-0.1912, 2.2073, 0.0000> <-0.1376, 2.5923, 0.0000> <-0.0852, 2.8779, 0.0000>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.2016, 1.9171, 0.0000> <-0.1912, 2.2073, 0.0000> <-0.1376, 2.5923, 0.0000> <-0.0852, 2.8779, 0.0000>
		<-0.2016, 1.9172, 0.0094> <-0.1912, 2.2073, 0.0094> <-0.1376, 2.5923, 0.0082> <-0.0852, 2.8779, 0.0082>
		<-0.2117, 1.9172, 0.0146> <-0.2008, 2.2082, 0.0142> <-0.1491, 2.5934, 0.0147> <-0.0939, 2.8793, 0.0127>
		<-0.2211, 1.9172, 0.0146> <-0.2102, 2.2082, 0.0142> <-0.1571, 2.5947, 0.0147> <-0.1020, 2.8807, 0.0127>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.1414, 3.8051, 0.0000> <0.0634, 3.5286, 0.0000> <-0.0617, 3.1650, 0.0000> <-0.1187, 2.8834, 0.0000>
		<0.1414, 3.8051, 0.0008> <0.0634, 3.5286, 0.0008> <-0.0617, 3.1650, 0.0082> <-0.1187, 2.8834, 0.0082>
		<0.1421, 3.8049, 0.0016> <0.0686, 3.5277, 0.0049> <-0.0557, 3.1636, 0.0107> <-0.1100, 2.8820, 0.0127>
		<0.1429, 3.8047, 0.0016> <0.0695, 3.5275, 0.0049> <-0.0476, 3.1623, 0.0107> <-0.1020, 2.8807, 0.0127>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.1414, 3.8051, 0.0000> <0.1414, 3.8051, -0.0008> <0.1421, 3.8049, -0.0016> <0.1429, 3.8047, -0.0016>
		<0.0634, 3.5286, 0.0000> <0.0634, 3.5286, -0.0008> <0.0686, 3.5277, -0.0049> <0.0694, 3.5274, -0.0049>
		<-0.0617, 3.1650, 0.0000> <-0.0617, 3.1649, -0.0082> <-0.0557, 3.1635, -0.0107> <-0.0477, 3.1622, -0.0107>
		<-0.1187, 2.8834, 0.0000> <-0.1187, 2.8833, -0.0082> <-0.1100, 2.8819, -0.0127> <-0.1020, 2.8806, -0.0127>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.1429, 3.8047, -0.0016> <0.1437, 3.8044, -0.0016> <0.1444, 3.8042, -0.0008> <0.1444, 3.8042, 0.0000>
		<0.0694, 3.5274, -0.0049> <0.0703, 3.5272, -0.0049> <0.0755, 3.5263, -0.0008> <0.0755, 3.5263, 0.0000>
		<-0.0477, 3.1622, -0.0107> <-0.0396, 3.1609, -0.0107> <-0.0336, 3.1594, -0.0082> <-0.0336, 3.1595, 0.0000>
		<-0.1020, 2.8806, -0.0127> <-0.0939, 2.8792, -0.0127> <-0.0852, 2.8778, -0.0082> <-0.0852, 2.8779, 0.0000>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.1444, 3.8042, 0.0000> <0.1444, 3.8042, 0.0008> <0.1437, 3.8044, 0.0016> <0.1429, 3.8047, 0.0016>
		<0.0755, 3.5263, 0.0000> <0.0755, 3.5263, 0.0008> <0.0703, 3.5272, 0.0049> <0.0695, 3.5275, 0.0049>
		<-0.0336, 3.1595, 0.0000> <-0.0336, 3.1595, 0.0082> <-0.0396, 3.1609, 0.0107> <-0.0476, 3.1623, 0.0107>
		<-0.0852, 2.8779, 0.0000> <-0.0852, 2.8779, 0.0082> <-0.0939, 2.8793, 0.0127> <-0.1020, 2.8807, 0.0127>
	}
	
	pigment { rgb <0.96, 0.94, 0.92>}
	finish {ambient 0 diffuse 0.85 phong 0.2}
} 

#declare Right = union {
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.1518, 3.8143, 0.0000> <0.1358, 3.7583, 0.0000> <0.1143, 3.6837, 0.0000> <0.0983, 3.6278, 0.0000>
		<0.1518, 3.8143, 0.0000> <0.1944, 3.7093, 0.0000> <0.1891, 3.6907, 0.0000> <0.1730, 3.6347, 0.0000>
		<0.1518, 3.8143, 0.0000> <0.1944, 3.7093, 0.0000> <0.2449, 3.7152, 0.0000> <0.2727, 3.6440, 0.0000>
		<0.1518, 3.8143, 0.0000> <0.2105, 3.7653, 0.0000> <0.3196, 3.7222, 0.0000> <0.3474, 3.6510, 0.0000>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.2148, 1.5102, 0.0000> <-0.2139, 1.4473, 0.0000> <-0.2092, 1.3635, 0.0000> <-0.2068, 1.3007, 0.0000>
		<-0.0936, 1.5102, 0.0000> <-0.0926, 1.4473, 0.0000> <-0.0915, 1.3840, 0.0000> <-0.0891, 1.3211, 0.0000>
		<0.0681, 1.5102, 0.0000> <0.0660, 1.4678, 0.0000> <0.0726, 1.3906, 0.0000> <0.0679, 1.3484, 0.0000>
		<0.1894, 1.5102, 0.0000> <0.1873, 1.4678, 0.0000> <0.1903, 1.4110, 0.0000> <0.1857, 1.3688, 0.0000>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.2148, 1.5102, 0.0000> <-0.0936, 1.5102, 0.0000> <0.0681, 1.5102, 0.0000> <0.1894, 1.5102, 0.0000>
		<-0.2166, 1.6337, 0.0000> <-0.0954, 1.6337, 0.0000> <0.0729, 1.6076, 0.0000> <0.1942, 1.6076, 0.0000>
		<-0.2193, 1.7983, 0.0000> <-0.0920, 1.7722, 0.0000> <0.0803, 1.7632, 0.0000> <0.2076, 1.7371, 0.0000>
		<-0.2159, 1.9217, 0.0000> <-0.0886, 1.8956, 0.0000> <0.0812, 1.8607, 0.0000> <0.2086, 1.8346, 0.0000>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.2159, 1.9217, 0.0000> <-0.0886, 1.8956, 0.0000> <0.0812, 1.8607, 0.0000> <0.2086, 1.8346, 0.0000>
		<-0.2128, 2.0343, 0.0000> <-0.0854, 2.0081, 0.0000> <0.0819, 1.9252, 0.0000> <0.2092, 1.8990, 0.0000>
		<-0.2036, 2.1843, 0.0000> <-0.0873, 2.1100, 0.0000> <0.0826, 2.0589, 0.0000> <0.1988, 1.9846, 0.0000>
		<-0.1929, 2.2964, 0.0000> <-0.0767, 2.2221, 0.0000> <0.0784, 2.1232, 0.0000> <0.1947, 2.0489, 0.0000>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.1947, 2.0489, 0.0000> <0.1872, 2.1631, 0.0000> <0.1773, 2.3153, 0.0000> <0.1699, 2.4295, 0.0000>
		<0.0784, 2.1232, 0.0000> <0.0709, 2.2373, 0.0000> <0.0795, 2.3517, 0.0000> <0.0721, 2.4659, 0.0000>
		<-0.0767, 2.2221, 0.0000> <-0.0694, 2.2989, 0.0000> <-0.0703, 2.4383, 0.0000> <-0.0583, 2.5144, 0.0000>
		<-0.1929, 2.2964, 0.0000> <-0.1856, 2.3732, 0.0000> <-0.1681, 2.4746, 0.0000> <-0.1561, 2.5508, 0.0000>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.0983, 3.6278, 0.0000> <0.0713, 3.5335, 0.0000> <0.0355, 3.4078, 0.0000> <0.0085, 3.3135, 0.0000>
		<0.1730, 3.6347, 0.0000> <0.1461, 3.5405, 0.0000> <0.1389, 3.4030, 0.0000> <0.1120, 3.3087, 0.0000>
		<0.2727, 3.6440, 0.0000> <0.3112, 3.5452, 0.0000> <0.2481, 3.4083, 0.0000> <0.2500, 3.3023, 0.0000>
		<0.3474, 3.6510, 0.0000> <0.3859, 3.5522, 0.0000> <0.3516, 3.4035, 0.0000> <0.3534, 3.2974, 0.0000>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.1561, 2.5508, 0.0000> <-0.0583, 2.5144, 0.0000> <0.0721, 2.4659, 0.0000> <0.1699, 2.4295, 0.0000>
		<-0.1390, 2.6591, 0.0000> <-0.0412, 2.6227, 0.0000> <0.0830, 2.5755, 0.0000> <0.1808, 2.5391, 0.0000>
		<-0.1139, 2.8030, 0.0000> <-0.0233, 2.7681, 0.0000> <0.1048, 2.7201, 0.0000> <0.1954, 2.6852, 0.0000>
		<-0.0959, 2.9111, 0.0000> <-0.0052, 2.8762, 0.0000> <0.1157, 2.8296, 0.0000> <0.2064, 2.7947, 0.0000>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.1561, 2.5508, 0.0000> <-0.0583, 2.5144, 0.0000> <0.0721, 2.4659, 0.0000> <0.1699, 2.4295, 0.0000>
		<-0.1390, 2.6591, 0.0000> <-0.0412, 2.6227, 0.0000> <0.0830, 2.5755, 0.0000> <0.1808, 2.5391, 0.0000>
		<-0.1139, 2.8030, 0.0000> <-0.0233, 2.7681, 0.0000> <0.1048, 2.7201, 0.0000> <0.1954, 2.6852, 0.0000>
		<-0.0959, 2.9111, 0.0000> <-0.0052, 2.8762, 0.0000> <0.1157, 2.8296, 0.0000> <0.2064, 2.7947, 0.0000>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.2068, 1.3007, 0.0000> <-0.1976, 1.1946, 0.0000> <-0.1876, 1.0529, 0.0000> <-0.1760, 0.9471, 0.0000>
		<-0.0891, 1.3211, 0.0000> <-0.0798, 1.2150, 0.0000> <-0.0996, 1.0268, 0.0000> <-0.0880, 0.9209, 0.0000>
		<0.0679, 1.3484, 0.0000> <0.0509, 1.1953, 0.0000> <0.0916, 1.0269, 0.0000> <0.0293, 0.8860, 0.0000>
		<0.1857, 1.3688, 0.0000> <0.1687, 1.2157, 0.0000> <0.1796, 1.0007, 0.0000> <0.1173, 0.8599, 0.0000>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.2064, 2.7947, 0.0000> <0.2350, 2.8903, 0.0000> <0.2738, 3.0175, 0.0000> <0.3018, 3.1133, 0.0000>
		<0.1157, 2.8296, 0.0000> <0.1443, 2.9252, 0.0000> <0.1774, 3.0505, 0.0000> <0.2054, 3.1462, 0.0000>
		<-0.0052, 2.8762, 0.0000> <0.0177, 2.9698, 0.0000> <0.0527, 3.0969, 0.0000> <0.0769, 3.1901, 0.0000>
		<-0.0959, 2.9111, 0.0000> <-0.0729, 3.0047, 0.0000> <-0.0436, 3.1298, 0.0000> <-0.0194, 3.2230, 0.0000>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.2064, 2.7947, 0.0000> <0.2350, 2.8903, 0.0000> <0.2738, 3.0175, 0.0000> <0.3018, 3.1133, 0.0000>
		<0.1157, 2.8296, 0.0000> <0.1443, 2.9252, 0.0000> <0.1774, 3.0505, 0.0000> <0.2054, 3.1462, 0.0000>
		<-0.0052, 2.8762, 0.0000> <0.0177, 2.9698, 0.0000> <0.0527, 3.0969, 0.0000> <0.0769, 3.1901, 0.0000>
		<-0.0959, 2.9111, 0.0000> <-0.0729, 3.0047, 0.0000> <-0.0436, 3.1298, 0.0000> <-0.0194, 3.2230, 0.0000>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.3534, 3.2974, 0.0000> <0.2500, 3.3023, 0.0000> <0.1120, 3.3087, 0.0000> <0.0085, 3.3135, 0.0000>
		<0.3379, 3.2422, 0.0000> <0.2345, 3.2470, 0.0000> <0.1036, 3.2815, 0.0000> <0.0001, 3.2864, 0.0000>
		<0.3179, 3.1684, 0.0000> <0.2215, 3.2013, 0.0000> <0.0841, 3.2176, 0.0000> <-0.0123, 3.2505, 0.0000>
		<0.3018, 3.1133, 0.0000> <0.2054, 3.1462, 0.0000> <0.0769, 3.1901, 0.0000> <-0.0194, 3.2230, 0.0000>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.1351, 0.6444, 0.0000> <-0.0594, 0.7091, 0.0000> <0.0770, 0.7689, 0.0000> <0.1173, 0.8599, 0.0000>
		<-0.1351, 0.6444, 0.0000> <-0.0717, 0.7999, 0.0000> <-0.0110, 0.7950, 0.0000> <0.0293, 0.8860, 0.0000>
		<-0.1351, 0.6444, 0.0000> <-0.0717, 0.7999, 0.0000> <-0.0781, 0.8298, 0.0000> <-0.0880, 0.9209, 0.0000>
		<-0.1351, 0.6444, 0.0000> <-0.1473, 0.7352, 0.0000> <-0.1661, 0.8560, 0.0000> <-0.1760, 0.9471, 0.0000>
	}
	
    texture{      
	    pigment{
	        gradient y
	        color_map{
	            [0.0 0.6 color rgb <0.96, 0.94, 0.92> color rgb <0.96, 0.94, 0.92>] 
	            [0.6 0.8 color rgb <0.96, 0.94, 0.92> color rgb <0.26, 0.24, 0.22>]
	            [0.8 1.0 color rgb <0.26, 0.24, 0.22> color rgb <0.26, 0.24, 0.22>]
	        }
	        rotate -z*30
	        turbulence 0.3
	        scale 2      
	        translate y*1.65
	    }
		finish{ambient 0 diffuse 0.8 phong 0.1}
		normal{
		    onion
		    slope_map {
                [0 <0.5, 0.5>]   
                [0.2 <1, 0>]   
                [0.8  <1, 0>]   
                [1    <0.5, -0.5>]   
            } 
            turbulence 0.03           
            frequency 25
            scale <0.3, 1, 0.1>
            translate <-1, 15, 0>
		}  
	}
}

#declare Left = union {
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.4115, 0.8216, 0.0000> <-0.4759, 0.9130, 0.0000> <-0.4988, 1.0692, 0.0000> <-0.5142, 1.1799, 0.0000>
		<-0.3405, 0.8693, 0.0000> <-0.4048, 0.9607, 0.0000> <-0.4068, 1.1049, 0.0000> <-0.4222, 1.2157, 0.0000>
		<-0.2458, 0.9329, 0.0000> <-0.2581, 1.0282, 0.0000> <-0.2918, 1.1676, 0.0000> <-0.2996, 1.2633, 0.0000>
		<-0.1748, 0.9806, 0.0000> <-0.1870, 1.0759, 0.0000> <-0.1998, 1.2034, 0.0000> <-0.2076, 1.2991, 0.0000>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.4115, 0.8216, 0.0000> <-0.3405, 0.8693, 0.0000> <-0.2458, 0.9329, 0.0000> <-0.1748, 0.9806, 0.0000>
		<-0.4115, 0.8216, 0.0000> <-0.2793, 0.7824, 0.0000> <-0.2318, 0.8244, 0.0000> <-0.1608, 0.8721, 0.0000>
		<-0.4115, 0.8216, 0.0000> <-0.2793, 0.7824, 0.0000> <-0.2239, 0.7887, 0.0000> <-0.1365, 0.7282, 0.0000>
		<-0.4115, 0.8216, 0.0000> <-0.3503, 0.7347, 0.0000> <-0.2076, 0.6805, 0.0000> <-0.1201, 0.6200, 0.0000>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.5142, 1.1799, 0.0000> <-0.5306, 1.2981, 0.0000> <-0.5129, 1.4584, 0.0000> <-0.5167, 1.5777, 0.0000>
		<-0.4222, 1.2157, 0.0000> <-0.4386, 1.3339, 0.0000> <-0.4233, 1.4382, 0.0000> <-0.4271, 1.5575, 0.0000>
		<-0.2996, 1.2633, 0.0000> <-0.3048, 1.3266, 0.0000> <-0.3064, 1.4671, 0.0000> <-0.3077, 1.5306, 0.0000>
		<-0.2076, 1.2991, 0.0000> <-0.2128, 1.3624, 0.0000> <-0.2168, 1.4470, 0.0000> <-0.2181, 1.5105, 0.0000>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.5167, 1.5777, 0.0000> <-0.5204, 1.6945, 0.0000> <-0.5465, 1.8500, 0.0000> <-0.5392, 1.9666, 0.0000>
		<-0.4271, 1.5575, 0.0000> <-0.4308, 1.6743, 0.0000> <-0.4508, 1.8364, 0.0000> <-0.4435, 1.9530, 0.0000>
		<-0.3077, 1.5306, 0.0000> <-0.3102, 1.6538, 0.0000> <-0.3201, 1.8117, 0.0000> <-0.3160, 1.9348, 0.0000>
		<-0.2181, 1.5105, 0.0000> <-0.2206, 1.6337, 0.0000> <-0.2244, 1.7981, 0.0000> <-0.2203, 1.9212, 0.0000>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.5392, 1.9666, 0.0000> <-0.5302, 2.1096, 0.0000> <-0.4882, 2.2970, 0.0000> <-0.4628, 2.4380, 0.0000>
		<-0.4435, 1.9530, 0.0000> <-0.4345, 2.0960, 0.0000> <-0.4069, 2.2553, 0.0000> <-0.3815, 2.3963, 0.0000>
		<-0.3160, 1.9348, 0.0000> <-0.3122, 2.0484, 0.0000> <-0.2844, 2.2276, 0.0000> <-0.2732, 2.3407, 0.0000>
		<-0.2203, 1.9212, 0.0000> <-0.2166, 2.0348, 0.0000> <-0.2031, 2.1859, 0.0000> <-0.1919, 2.2989, 0.0000>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.4628, 2.4380, 0.0000> <-0.4481, 2.5193, 0.0000> <-0.4261, 2.6274, 0.0000> <-0.4055, 2.7074, 0.0000>
		<-0.3815, 2.3963, 0.0000> <-0.3668, 2.4776, 0.0000> <-0.3518, 2.5802, 0.0000> <-0.3312, 2.6602, 0.0000>
		<-0.2732, 2.3407, 0.0000> <-0.2656, 2.4163, 0.0000> <-0.2437, 2.5221, 0.0000> <-0.2321, 2.5972, 0.0000>
		<-0.1919, 2.2989, 0.0000> <-0.1844, 2.3746, 0.0000> <-0.1694, 2.4748, 0.0000> <-0.1579, 2.5500, 0.0000>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.3237, 2.9768, 0.0000> <-0.3049, 3.0450, 0.0000> <-0.2860, 3.1375, 0.0000> <-0.2682, 3.2059, 0.0000>
		<-0.2576, 2.9460, 0.0000> <-0.2389, 3.0142, 0.0000> <-0.2205, 3.1091, 0.0000> <-0.2027, 3.1775, 0.0000>
		<-0.1696, 2.9050, 0.0000> <-0.1558, 2.9766, 0.0000> <-0.1332, 3.0690, 0.0000> <-0.1154, 3.1397, 0.0000>
		<-0.1036, 2.8743, 0.0000> <-0.0898, 2.9459, 0.0000> <-0.0677, 3.0406, 0.0000> <-0.0499, 3.1113, 0.0000>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.3237, 2.9768, 0.0000> <-0.2576, 2.9460, 0.0000> <-0.1696, 2.9050, 0.0000> <-0.1036, 2.8743, 0.0000>
		<-0.3461, 2.8954, 0.0000> <-0.2801, 2.8646, 0.0000> <-0.1882, 2.8082, 0.0000> <-0.1222, 2.7774, 0.0000>
		<-0.3844, 2.7892, 0.0000> <-0.3101, 2.7419, 0.0000> <-0.2172, 2.6947, 0.0000> <-0.1429, 2.6475, 0.0000>
		<-0.4055, 2.7074, 0.0000> <-0.3312, 2.6602, 0.0000> <-0.2321, 2.5972, 0.0000> <-0.1579, 2.5500, 0.0000>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.0174, 3.7315, 0.0000> <0.0169, 3.7010, 0.0000> <0.0628, 3.6603, 0.0000> <0.0971, 3.6298, 0.0000>
		<-0.0887, 3.6563, 0.0000> <-0.0543, 3.6258, 0.0000> <0.0356, 3.5661, 0.0000> <0.0700, 3.5356, 0.0000>
		<-0.1583, 3.5337, 0.0000> <-0.0952, 3.4963, 0.0000> <-0.0290, 3.4473, 0.0000> <0.0341, 3.4099, 0.0000>
		<-0.2030, 3.4402, 0.0000> <-0.1399, 3.4028, 0.0000> <-0.0557, 3.3530, 0.0000> <0.0073, 3.3156, 0.0000>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.0174, 3.7315, 0.0000> <0.0213, 3.7723, 0.0000> <0.1005, 3.7892, 0.0000> <0.1510, 3.8139, 0.0000>
		<-0.0174, 3.7315, 0.0000> <0.0556, 3.7418, 0.0000> <0.0843, 3.7339, 0.0000> <0.1348, 3.7587, 0.0000>
		<-0.0174, 3.7315, 0.0000> <0.0556, 3.7418, 0.0000> <0.0787, 3.7156, 0.0000> <0.1131, 3.6851, 0.0000>
		<-0.0174, 3.7315, 0.0000> <0.0169, 3.7010, 0.0000> <0.0628, 3.6603, 0.0000> <0.0971, 3.6298, 0.0000>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.2030, 3.4402, 0.0000> <-0.1399, 3.4028, 0.0000> <-0.0557, 3.3530, 0.0000> <0.0073, 3.3156, 0.0000>
		<-0.2344, 3.3743, 0.0000> <-0.1713, 3.3370, 0.0000> <-0.0731, 3.2917, 0.0000> <-0.0100, 3.2543, 0.0000>
		<-0.2498, 3.2765, 0.0000> <-0.1843, 3.2481, 0.0000> <-0.0999, 3.2014, 0.0000> <-0.0344, 3.1730, 0.0000>
		<-0.2682, 3.2059, 0.0000> <-0.2027, 3.1775, 0.0000> <-0.1154, 3.1397, 0.0000> <-0.0499, 3.1113, 0.0000>
	}
	
	texture{      
	    pigment{
	        gradient y
	        color_map{
	            [0.0 0.6 color rgb <0.96, 0.94, 0.92> color rgb <0.96, 0.94, 0.92>] 
	            [0.6 0.8 color rgb <0.96, 0.94, 0.92> color rgb <0.26, 0.24, 0.22>]
	            [0.8 1.0 color rgb <0.26, 0.24, 0.22> color rgb <0.26, 0.24, 0.22>]
	        }
	        rotate -z*30
	        turbulence 0.3
	        scale 2      
	        translate y*1.65
	    }
		finish{ambient 0 diffuse 0.8 phong 0.1}
		normal{
		    onion
		    slope_map {
                [0 <0.5, 0.5>]   
                [0.2 <1, 0>]   
                [0.8  <1, 0>]   
                [1    <0.5, -0.5>]   
            } 
            turbulence 0.03           
            frequency 20
            scale <0.26, 1, 0.1>
            translate <1.5, 15, 0>
		}  
	}
} 

#declare Fix = union {
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.1099, 0.6554, 0.0000> <-0.0972, 0.6567, 0.0000> <-0.0788, 0.6654, 0.0000> <-0.0674, 0.6595, 0.0000>
		<-0.1099, 0.6554, -0.0057> <-0.0972, 0.6567, -0.0057> <-0.0788, 0.6654, -0.0216> <-0.0674, 0.6595, -0.0216>
		<-0.1194, 0.6537, -0.0113> <-0.1192, 0.6527, -0.0207> <-0.1046, 0.6593, -0.0356> <-0.1031, 0.6531, -0.0426>
		<-0.1250, 0.6527, -0.0113> <-0.1248, 0.6517, -0.0207> <-0.1259, 0.6555, -0.0356> <-0.1244, 0.6493, -0.0426>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.1099, 0.6554, 0.0000> <-0.1099, 0.6554, 0.0057> <-0.1194, 0.6537, 0.0113> <-0.1250, 0.6527, 0.0113>
		<-0.0972, 0.6567, 0.0000> <-0.0972, 0.6567, 0.0057> <-0.1192, 0.6527, 0.0207> <-0.1248, 0.6517, 0.0207>
		<-0.0788, 0.6654, 0.0000> <-0.0788, 0.6654, 0.0216> <-0.1046, 0.6593, 0.0356> <-0.1259, 0.6555, 0.0356>
		<-0.0674, 0.6595, 0.0000> <-0.0674, 0.6595, 0.0216> <-0.1031, 0.6531, 0.0426> <-0.1244, 0.6493, 0.0426>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.0674, 0.6595, 0.0000> <-0.0563, 0.6539, 0.0000> <-0.0474, 0.6358, 0.0000> <-0.0469, 0.6234, 0.0000>
		<-0.0674, 0.6595, -0.0216> <-0.0563, 0.6539, -0.0216> <-0.0474, 0.6358, -0.0271> <-0.0469, 0.6234, -0.0271>
		<-0.1031, 0.6531, -0.0426> <-0.1011, 0.6448, -0.0520> <-0.0904, 0.6277, -0.0595> <-0.0881, 0.6152, -0.0583>
		<-0.1244, 0.6493, -0.0426> <-0.1224, 0.6409, -0.0520> <-0.1172, 0.6235, -0.0595> <-0.1149, 0.6111, -0.0583>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.0674, 0.6595, 0.0000> <-0.0674, 0.6595, 0.0216> <-0.1031, 0.6531, 0.0426> <-0.1244, 0.6493, 0.0426>
		<-0.0563, 0.6539, 0.0000> <-0.0563, 0.6539, 0.0216> <-0.1011, 0.6448, 0.0520> <-0.1224, 0.6409, 0.0520>
		<-0.0474, 0.6358, 0.0000> <-0.0474, 0.6358, 0.0271> <-0.0904, 0.6277, 0.0595> <-0.1172, 0.6235, 0.0595>
		<-0.0469, 0.6234, 0.0000> <-0.0469, 0.6234, 0.0271> <-0.0881, 0.6152, 0.0583> <-0.1149, 0.6111, 0.0583>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.0469, 0.6234, 0.0000> <-0.0463, 0.6087, 0.0000> <-0.0672, 0.5916, 0.0000> <-0.0638, 0.5773, 0.0000>
		<-0.0469, 0.6234, -0.0271> <-0.0463, 0.6087, -0.0271> <-0.0672, 0.5916, -0.0174> <-0.0638, 0.5773, -0.0174>
		<-0.0881, 0.6152, -0.0583> <-0.0856, 0.6010, -0.0568> <-0.0949, 0.5865, -0.0347> <-0.0927, 0.5721, -0.0345>
		<-0.1149, 0.6111, -0.0583> <-0.1124, 0.5968, -0.0568> <-0.1121, 0.5834, -0.0347> <-0.1099, 0.5690, -0.0345>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.0469, 0.6234, 0.0000> <-0.0469, 0.6234, 0.0271> <-0.0881, 0.6152, 0.0583> <-0.1149, 0.6111, 0.0583>
		<-0.0463, 0.6087, 0.0000> <-0.0463, 0.6087, 0.0271> <-0.0856, 0.6010, 0.0568> <-0.1124, 0.5968, 0.0568>
		<-0.0672, 0.5916, 0.0000> <-0.0672, 0.5916, 0.0174> <-0.0949, 0.5865, 0.0347> <-0.1121, 0.5834, 0.0347>
		<-0.0638, 0.5773, 0.0000> <-0.0638, 0.5773, 0.0174> <-0.0927, 0.5721, 0.0345> <-0.1099, 0.5690, 0.0345>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.0638, 0.5773, 0.0000> <-0.0597, 0.5596, 0.0000> <-0.0292, 0.5483, 0.0000> <-0.0251, 0.5306, 0.0000>
		<-0.0638, 0.5773, -0.0174> <-0.0597, 0.5596, -0.0174> <-0.0292, 0.5483, -0.0285> <-0.0251, 0.5306, -0.0285>
		<-0.0927, 0.5721, -0.0345> <-0.0901, 0.5551, -0.0341> <-0.0754, 0.5389, -0.0558> <-0.0724, 0.5220, -0.0564>
		<-0.1099, 0.5690, -0.0345> <-0.1073, 0.5520, -0.0341> <-0.1035, 0.5338, -0.0558> <-0.1005, 0.5170, -0.0564>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.0638, 0.5773, 0.0000> <-0.0638, 0.5773, 0.0174> <-0.0927, 0.5721, 0.0345> <-0.1099, 0.5690, 0.0345>
		<-0.0597, 0.5596, 0.0000> <-0.0597, 0.5596, 0.0174> <-0.0901, 0.5551, 0.0341> <-0.1073, 0.5520, 0.0341>
		<-0.0292, 0.5483, 0.0000> <-0.0292, 0.5483, 0.0285> <-0.0754, 0.5389, 0.0558> <-0.1035, 0.5338, 0.0558>
		<-0.0251, 0.5306, 0.0000> <-0.0251, 0.5306, 0.0285> <-0.0724, 0.5220, 0.0564> <-0.1005, 0.5170, 0.0564>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.0251, 0.5306, 0.0000> <0.0022, 0.4131, 0.0000> <0.0274, 0.2537, 0.0000> <0.0390, 0.1337, 0.0000>
		<-0.0251, 0.5306, -0.0285> <0.0022, 0.4131, -0.0285> <0.0274, 0.2537, -0.0258> <0.0390, 0.1337, -0.0258>
		<-0.0724, 0.5220, -0.0564> <-0.0510, 0.4034, -0.0608> <-0.0251, 0.2444, -0.0583> <-0.0037, 0.1260, -0.0509>
		<-0.1005, 0.5170, -0.0564> <-0.0791, 0.3984, -0.0608> <-0.0504, 0.2399, -0.0583> <-0.0290, 0.1214, -0.0509>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.0251, 0.5306, 0.0000> <-0.0251, 0.5306, 0.0285> <-0.0724, 0.5220, 0.0564> <-0.1005, 0.5170, 0.0564>
		<0.0022, 0.4131, 0.0000> <0.0022, 0.4131, 0.0285> <-0.0510, 0.4034, 0.0608> <-0.0791, 0.3984, 0.0608>
		<0.0274, 0.2537, 0.0000> <0.0274, 0.2537, 0.0258> <-0.0251, 0.2444, 0.0583> <-0.0504, 0.2399, 0.0583>
		<0.0390, 0.1337, 0.0000> <0.0390, 0.1337, 0.0258> <-0.0037, 0.1260, 0.0509> <-0.0290, 0.1214, 0.0509>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.0390, 0.1337, 0.0000> <0.0407, 0.1165, 0.0000> <0.0149, 0.0968, 0.0000> <0.0184, 0.0798, 0.0000>
		<0.0390, 0.1337, -0.0258> <0.0407, 0.1165, -0.0258> <0.0149, 0.0968, -0.0146> <0.0184, 0.0798, -0.0146>
		<-0.0037, 0.1260, -0.0509> <-0.0008, 0.1101, -0.0500> <-0.0087, 0.0914, -0.0284> <-0.0059, 0.0754, -0.0290>
		<-0.0290, 0.1214, -0.0509> <-0.0262, 0.1055, -0.0500> <-0.0232, 0.0888, -0.0284> <-0.0203, 0.0728, -0.0290>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.0390, 0.1337, 0.0000> <0.0390, 0.1337, 0.0258> <-0.0037, 0.1260, 0.0509> <-0.0290, 0.1214, 0.0509>
		<0.0407, 0.1165, 0.0000> <0.0407, 0.1165, 0.0258> <-0.0008, 0.1101, 0.0500> <-0.0262, 0.1055, 0.0500>
		<0.0149, 0.0968, 0.0000> <0.0149, 0.0968, 0.0146> <-0.0091, 0.0913, 0.0284> <-0.0235, 0.0887, 0.0284>
		<0.0184, 0.0798, 0.0000> <0.0184, 0.0798, 0.0146> <-0.0059, 0.0754, 0.0290> <-0.0203, 0.0728, 0.0290>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.0184, 0.0798, 0.0000> <0.0218, 0.0633, 0.0000> <0.0518, 0.0559, 0.0000> <0.0584, 0.0404, 0.0000>
		<0.0184, 0.0798, -0.0146> <0.0218, 0.0633, -0.0146> <0.0512, 0.0558, -0.0271> <0.0578, 0.0403, -0.0271>
		<-0.0059, 0.0754, -0.0290> <-0.0027, 0.0581, -0.0296> <0.0126, 0.0434, -0.0517> <0.0157, 0.0263, -0.0546>
		<-0.0203, 0.0728, -0.0290> <-0.0171, 0.0555, -0.0296> <-0.0140, 0.0379, -0.0517> <-0.0109, 0.0208, -0.0546>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.0184, 0.0798, 0.0000> <0.0184, 0.0798, 0.0146> <-0.0059, 0.0754, 0.0290> <-0.0203, 0.0728, 0.0290>
		<0.0218, 0.0633, 0.0000> <0.0218, 0.0633, 0.0146> <-0.0023, 0.0582, 0.0296> <-0.0167, 0.0555, 0.0296>
		<0.0518, 0.0559, 0.0000> <0.0524, 0.0560, 0.0265> <0.0144, 0.0437, 0.0517> <-0.0115, 0.0384, 0.0517>
		<0.0584, 0.0404, 0.0000> <0.0590, 0.0406, 0.0265> <0.0175, 0.0266, 0.0546> <-0.0084, 0.0212, 0.0546>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.0584, 0.0404, 0.0000> <0.0635, 0.0283, 0.0000> <0.0632, 0.0057, 0.0000> <0.0536, -0.0034, 0.0000>
		<0.0578, 0.0403, -0.0271> <0.0629, 0.0282, -0.0271> <0.0632, 0.0057, -0.0221> <0.0536, -0.0034, -0.0221>
		<0.0157, 0.0263, -0.0546> <0.0176, 0.0155, -0.0564> <0.0159, -0.0036, -0.0526> <0.0171, -0.0100, -0.0436>
		<-0.0109, 0.0208, -0.0546> <-0.0089, 0.0100, -0.0564> <-0.0058, -0.0075, -0.0526> <-0.0046, -0.0139, -0.0436>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.0584, 0.0404, 0.0000> <0.0590, 0.0406, 0.0265> <0.0175, 0.0266, 0.0546> <-0.0084, 0.0212, 0.0546>
		<0.0635, 0.0283, 0.0000> <0.0641, 0.0284, 0.0265> <0.0195, 0.0158, 0.0564> <-0.0065, 0.0104, 0.0564>
		<0.0632, 0.0057, 0.0000> <0.0632, 0.0057, 0.0221> <0.0163, -0.0035, 0.0526> <-0.0054, -0.0074, 0.0526>
		<0.0536, -0.0034, 0.0000> <0.0536, -0.0034, 0.0221> <0.0171, -0.0100, 0.0436> <-0.0046, -0.0139, 0.0436>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.0536, -0.0034, 0.0000> <0.0412, -0.0153, 0.0000> <0.0147, -0.0129, 0.0000> <-0.0020, -0.0170, 0.0000>
		<0.0536, -0.0034, -0.0221> <0.0412, -0.0153, -0.0221> <0.0147, -0.0129, -0.0007> <-0.0020, -0.0170, -0.0007>
		<0.0171, -0.0100, -0.0436> <0.0184, -0.0174, -0.0334> <-0.0034, -0.0162, -0.0141> <-0.0033, -0.0173, -0.0015>
		<-0.0046, -0.0139, -0.0436> <-0.0033, -0.0213, -0.0334> <-0.0042, -0.0163, -0.0141> <-0.0040, -0.0174, -0.0015>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.0536, -0.0034, 0.0000> <0.0536, -0.0034, 0.0221> <0.0171, -0.0100, 0.0436> <-0.0046, -0.0139, 0.0436>
		<0.0412, -0.0153, 0.0000> <0.0412, -0.0153, 0.0221> <0.0180, -0.0174, 0.0334> <-0.0038, -0.0214, 0.0334>
		<0.0147, -0.0129, 0.0000> <0.0147, -0.0129, 0.0007> <-0.0034, -0.0162, 0.0141> <-0.0042, -0.0163, 0.0141>
		<-0.0020, -0.0170, 0.0000> <-0.0020, -0.0170, 0.0007> <-0.0033, -0.0173, 0.0015> <-0.0040, -0.0174, 0.0015>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.1250, 0.6527, 0.0113> <-0.1306, 0.6517, 0.0113> <-0.1400, 0.6500, 0.0057> <-0.1400, 0.6500, 0.0000>
		<-0.1248, 0.6517, 0.0207> <-0.1304, 0.6507, 0.0207> <-0.1524, 0.6467, 0.0057> <-0.1524, 0.6467, 0.0000>
		<-0.1259, 0.6555, 0.0356> <-0.1471, 0.6516, 0.0356> <-0.1723, 0.6481, 0.0216> <-0.1723, 0.6481, 0.0000>
		<-0.1244, 0.6493, 0.0426> <-0.1456, 0.6454, 0.0426> <-0.1813, 0.6390, 0.0216> <-0.1813, 0.6390, 0.0000>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.1400, 0.6500, 0.0000> <-0.1400, 0.6500, -0.0057> <-0.1306, 0.6517, -0.0113> <-0.1250, 0.6527, -0.0113>
		<-0.1524, 0.6467, 0.0000> <-0.1524, 0.6467, -0.0057> <-0.1304, 0.6507, -0.0207> <-0.1248, 0.6517, -0.0207>
		<-0.1723, 0.6481, 0.0000> <-0.1723, 0.6481, -0.0216> <-0.1471, 0.6516, -0.0356> <-0.1259, 0.6555, -0.0356>
		<-0.1813, 0.6390, 0.0000> <-0.1813, 0.6390, -0.0216> <-0.1456, 0.6454, -0.0426> <-0.1244, 0.6493, -0.0426>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.1244, 0.6493, 0.0426> <-0.1456, 0.6454, 0.0426> <-0.1813, 0.6390, 0.0216> <-0.1813, 0.6390, 0.0000>
		<-0.1224, 0.6409, 0.0520> <-0.1436, 0.6371, 0.0520> <-0.1894, 0.6308, 0.0216> <-0.1894, 0.6308, 0.0000>
		<-0.1172, 0.6235, 0.0595> <-0.1452, 0.6192, 0.0595> <-0.1921, 0.6123, 0.0283> <-0.1921, 0.6123, 0.0000>
		<-0.1149, 0.6111, 0.0583> <-0.1429, 0.6067, 0.0583> <-0.1885, 0.6014, 0.0283> <-0.1885, 0.6014, 0.0000>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.1813, 0.6390, 0.0000> <-0.1813, 0.6390, -0.0216> <-0.1456, 0.6454, -0.0426> <-0.1244, 0.6493, -0.0426>
		<-0.1894, 0.6308, 0.0000> <-0.1894, 0.6308, -0.0216> <-0.1436, 0.6371, -0.0520> <-0.1224, 0.6409, -0.0520>
		<-0.1921, 0.6123, 0.0000> <-0.1921, 0.6123, -0.0283> <-0.1452, 0.6192, -0.0595> <-0.1172, 0.6235, -0.0595>
		<-0.1885, 0.6014, 0.0000> <-0.1885, 0.6014, -0.0283> <-0.1429, 0.6067, -0.0583> <-0.1149, 0.6111, -0.0583>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.1149, 0.6111, 0.0583> <-0.1429, 0.6067, 0.0583> <-0.1885, 0.6014, 0.0283> <-0.1885, 0.6014, 0.0000>
		<-0.1124, 0.5968, 0.0568> <-0.1403, 0.5924, 0.0568> <-0.1837, 0.5865, 0.0283> <-0.1837, 0.5865, 0.0000>
		<-0.1121, 0.5834, 0.0347> <-0.1292, 0.5803, 0.0347> <-0.1587, 0.5761, 0.0174> <-0.1587, 0.5761, 0.0000>
		<-0.1099, 0.5690, 0.0345> <-0.1270, 0.5659, 0.0345> <-0.1559, 0.5607, 0.0174> <-0.1559, 0.5607, 0.0000>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.1885, 0.6014, 0.0000> <-0.1885, 0.6014, -0.0283> <-0.1429, 0.6067, -0.0583> <-0.1149, 0.6111, -0.0583>
		<-0.1837, 0.5865, 0.0000> <-0.1837, 0.5865, -0.0283> <-0.1403, 0.5924, -0.0568> <-0.1124, 0.5968, -0.0568>
		<-0.1587, 0.5761, 0.0000> <-0.1587, 0.5761, -0.0174> <-0.1292, 0.5803, -0.0347> <-0.1121, 0.5834, -0.0347>
		<-0.1559, 0.5607, 0.0000> <-0.1559, 0.5607, -0.0174> <-0.1270, 0.5659, -0.0345> <-0.1099, 0.5690, -0.0345>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.1099, 0.5690, 0.0345> <-0.1270, 0.5659, 0.0345> <-0.1559, 0.5607, 0.0174> <-0.1559, 0.5607, 0.0000>
		<-0.1073, 0.5520, 0.0341> <-0.1244, 0.5489, 0.0341> <-0.1528, 0.5434, 0.0174> <-0.1528, 0.5434, 0.0000>
		<-0.1035, 0.5338, 0.0558> <-0.1304, 0.5290, 0.0558> <-0.1732, 0.5216, 0.0274> <-0.1732, 0.5216, 0.0000>
		<-0.1005, 0.5170, 0.0564> <-0.1274, 0.5121, 0.0564> <-0.1710, 0.5042, 0.0274> <-0.1710, 0.5042, 0.0000>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.1559, 0.5607, 0.0000> <-0.1559, 0.5607, -0.0174> <-0.1270, 0.5659, -0.0345> <-0.1099, 0.5690, -0.0345>
		<-0.1528, 0.5434, 0.0000> <-0.1528, 0.5434, -0.0174> <-0.1244, 0.5489, -0.0341> <-0.1073, 0.5520, -0.0341>
		<-0.1732, 0.5216, 0.0000> <-0.1732, 0.5216, -0.0274> <-0.1304, 0.5290, -0.0558> <-0.1035, 0.5338, -0.0558>
		<-0.1710, 0.5042, 0.0000> <-0.1710, 0.5042, -0.0274> <-0.1274, 0.5121, -0.0564> <-0.1005, 0.5170, -0.0564>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.1005, 0.5170, 0.0564> <-0.1274, 0.5121, 0.0564> <-0.1710, 0.5042, 0.0274> <-0.1710, 0.5042, 0.0000>
		<-0.0791, 0.3984, 0.0608> <-0.1060, 0.3935, 0.0608> <-0.1554, 0.3846, 0.0274> <-0.1554, 0.3846, 0.0000>
		<-0.0504, 0.2399, 0.0583> <-0.0758, 0.2353, 0.0583> <-0.1269, 0.2259, 0.0258> <-0.1269, 0.2259, 0.0000>
		<-0.0290, 0.1214, 0.0509> <-0.0544, 0.1168, 0.0509> <-0.0971, 0.1091, 0.0258> <-0.0971, 0.1091, 0.0000>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.1710, 0.5042, 0.0000> <-0.1710, 0.5042, -0.0274> <-0.1274, 0.5121, -0.0564> <-0.1005, 0.5170, -0.0564>
		<-0.1554, 0.3846, 0.0000> <-0.1554, 0.3846, -0.0274> <-0.1060, 0.3935, -0.0608> <-0.0791, 0.3984, -0.0608>
		<-0.1269, 0.2259, 0.0000> <-0.1269, 0.2259, -0.0258> <-0.0758, 0.2353, -0.0583> <-0.0504, 0.2399, -0.0583>
		<-0.0971, 0.1091, 0.0000> <-0.0971, 0.1091, -0.0258> <-0.0544, 0.1168, -0.0509> <-0.0290, 0.1214, -0.0509>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.0290, 0.1214, 0.0509> <-0.0544, 0.1168, 0.0509> <-0.0971, 0.1091, 0.0258> <-0.0971, 0.1091, 0.0000>
		<-0.0262, 0.1055, 0.0500> <-0.0515, 0.1009, 0.0500> <-0.0928, 0.0923, 0.0258> <-0.0928, 0.0923, 0.0000>
		<-0.0235, 0.0887, 0.0284> <-0.0380, 0.0861, 0.0284> <-0.0620, 0.0829, 0.0146> <-0.0620, 0.0829, 0.0000>
		<-0.0203, 0.0728, 0.0290> <-0.0347, 0.0702, 0.0290> <-0.0590, 0.0658, 0.0146> <-0.0590, 0.0658, 0.0000>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.0971, 0.1091, 0.0000> <-0.0971, 0.1091, -0.0258> <-0.0544, 0.1168, -0.0509> <-0.0290, 0.1214, -0.0509>
		<-0.0928, 0.0923, 0.0000> <-0.0928, 0.0923, -0.0258> <-0.0515, 0.1009, -0.0500> <-0.0262, 0.1055, -0.0500>
		<-0.0620, 0.0829, 0.0000> <-0.0620, 0.0829, -0.0146> <-0.0376, 0.0862, -0.0284> <-0.0232, 0.0888, -0.0284>
		<-0.0590, 0.0658, 0.0000> <-0.0590, 0.0658, -0.0146> <-0.0347, 0.0702, -0.0290> <-0.0203, 0.0728, -0.0290>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.0203, 0.0728, 0.0290> <-0.0347, 0.0702, 0.0290> <-0.0590, 0.0658, 0.0146> <-0.0590, 0.0658, 0.0000>
		<-0.0167, 0.0555, 0.0296> <-0.0311, 0.0529, 0.0296> <-0.0559, 0.0488, 0.0146> <-0.0559, 0.0488, 0.0000>
		<-0.0115, 0.0384, 0.0517> <-0.0380, 0.0329, 0.0517> <-0.0782, 0.0294, 0.0270> <-0.0788, 0.0293, 0.0000>
		<-0.0084, 0.0212, 0.0546> <-0.0349, 0.0158, 0.0546> <-0.0789, 0.0121, 0.0270> <-0.0796, 0.0120, 0.0000>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.0590, 0.0658, 0.0000> <-0.0590, 0.0658, -0.0146> <-0.0347, 0.0702, -0.0290> <-0.0203, 0.0728, -0.0290>
		<-0.0559, 0.0488, 0.0000> <-0.0559, 0.0488, -0.0146> <-0.0316, 0.0529, -0.0296> <-0.0171, 0.0555, -0.0296>
		<-0.0788, 0.0293, 0.0000> <-0.0794, 0.0291, -0.0264> <-0.0399, 0.0325, -0.0517> <-0.0140, 0.0379, -0.0517>
		<-0.0796, 0.0120, 0.0000> <-0.0801, 0.0119, -0.0264> <-0.0368, 0.0154, -0.0546> <-0.0109, 0.0208, -0.0546>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.0084, 0.0212, 0.0546> <-0.0349, 0.0158, 0.0546> <-0.0789, 0.0121, 0.0270> <-0.0796, 0.0120, 0.0000>
		<-0.0065, 0.0104, 0.0564> <-0.0330, 0.0050, 0.0564> <-0.0795, 0.0001, 0.0270> <-0.0801, -0.0000, 0.0000>
		<-0.0054, -0.0074, 0.0526> <-0.0271, -0.0113, 0.0526> <-0.0740, -0.0199, 0.0221> <-0.0740, -0.0199, 0.0000>
		<-0.0046, -0.0139, 0.0436> <-0.0263, -0.0178, 0.0436> <-0.0629, -0.0244, 0.0221> <-0.0629, -0.0244, 0.0000>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.0796, 0.0120, 0.0000> <-0.0801, 0.0119, -0.0264> <-0.0368, 0.0154, -0.0546> <-0.0109, 0.0208, -0.0546>
		<-0.0801, -0.0000, 0.0000> <-0.0807, -0.0001, -0.0264> <-0.0348, 0.0047, -0.0564> <-0.0089, 0.0100, -0.0564>
		<-0.0740, -0.0199, 0.0000> <-0.0740, -0.0199, -0.0221> <-0.0275, -0.0114, -0.0526> <-0.0058, -0.0075, -0.0526>
		<-0.0629, -0.0244, 0.0000> <-0.0629, -0.0244, -0.0221> <-0.0263, -0.0178, -0.0436> <-0.0046, -0.0139, -0.0436>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.0046, -0.0139, 0.0436> <-0.0263, -0.0178, 0.0436> <-0.0629, -0.0244, 0.0221> <-0.0629, -0.0244, 0.0000>
		<-0.0038, -0.0214, 0.0334> <-0.0255, -0.0253, 0.0334> <-0.0469, -0.0309, 0.0221> <-0.0469, -0.0309, 0.0000>
		<-0.0042, -0.0163, 0.0141> <-0.0049, -0.0165, 0.0141> <-0.0230, -0.0198, 0.0007> <-0.0230, -0.0198, 0.0000>
		<-0.0040, -0.0174, 0.0015> <-0.0047, -0.0175, 0.0015> <-0.0060, -0.0177, 0.0007> <-0.0060, -0.0177, 0.0000>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.0629, -0.0244, 0.0000> <-0.0629, -0.0244, -0.0221> <-0.0263, -0.0178, -0.0436> <-0.0046, -0.0139, -0.0436>
		<-0.0469, -0.0309, 0.0000> <-0.0469, -0.0309, -0.0221> <-0.0250, -0.0252, -0.0334> <-0.0033, -0.0213, -0.0334>
		<-0.0230, -0.0198, 0.0000> <-0.0230, -0.0198, -0.0007> <-0.0049, -0.0165, -0.0141> <-0.0042, -0.0163, -0.0141>
		<-0.0060, -0.0177, 0.0000> <-0.0060, -0.0177, -0.0007> <-0.0047, -0.0175, -0.0015> <-0.0040, -0.0174, -0.0015>
	}
	pigment {color rgb <0.6, 0.55, 0.55>}
	finish {ambient 0.1 diffuse 0.7 phong 0.1}
	normal {crackle 0.5 scale <0.08, 0.04, 0.08>}
}

#declare Rope = union {
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.0270, 0.1375, 0.0000> <0.0340, 0.1218, 0.0000> <0.0487, 0.1022, 0.0000> <0.0503, 0.0850, 0.0000>
		<0.0270, 0.1375, -0.0212> <0.0340, 0.1218, -0.0212> <0.0487, 0.1022, -0.0263> <0.0503, 0.0850, -0.0263>
		<-0.0089, 0.1313, -0.0409> <-0.0061, 0.1148, -0.0438> <0.0028, 0.0939, -0.0517> <0.0057, 0.0773, -0.0507>
		<-0.0298, 0.1276, -0.0409> <-0.0269, 0.1112, -0.0438> <-0.0232, 0.0894, -0.0517> <-0.0203, 0.0727, -0.0507>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.0270, 0.1375, 0.0000> <0.0270, 0.1375, 0.0212> <-0.0089, 0.1313, 0.0409> <-0.0298, 0.1276, 0.0409>
		<0.0340, 0.1218, 0.0000> <0.0340, 0.1218, 0.0212> <-0.0061, 0.1148, 0.0438> <-0.0269, 0.1112, 0.0438>
		<0.0487, 0.1022, 0.0000> <0.0487, 0.1022, 0.0263> <0.0028, 0.0939, 0.0517> <-0.0232, 0.0894, 0.0517>
		<0.0503, 0.0850, 0.0000> <0.0503, 0.0850, 0.0263> <0.0057, 0.0773, 0.0507> <-0.0203, 0.0727, 0.0507>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.0503, 0.0850, 0.0000> <0.0518, 0.0685, 0.0000> <0.0407, 0.0475, 0.0000> <0.0366, 0.0314, 0.0000>
		<0.0503, 0.0850, -0.0263> <0.0518, 0.0685, -0.0263> <0.0407, 0.0475, -0.0180> <0.0366, 0.0314, -0.0180>
		<0.0057, 0.0773, -0.0507> <0.0084, 0.0616, -0.0498> <0.0035, 0.0410, -0.0395> <0.0061, 0.0261, -0.0347>
		<-0.0203, 0.0727, -0.0507> <-0.0175, 0.0571, -0.0498> <-0.0142, 0.0379, -0.0395> <-0.0116, 0.0230, -0.0347>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.0503, 0.0850, 0.0000> <0.0503, 0.0850, 0.0263> <0.0057, 0.0773, 0.0507> <-0.0203, 0.0727, 0.0507>
		<0.0518, 0.0685, 0.0000> <0.0518, 0.0685, 0.0263> <0.0084, 0.0616, 0.0498> <-0.0175, 0.0571, 0.0498>
		<0.0407, 0.0475, 0.0000> <0.0407, 0.0475, 0.0180> <0.0035, 0.0410, 0.0395> <-0.0142, 0.0379, 0.0395>
		<0.0366, 0.0314, 0.0000> <0.0366, 0.0314, 0.0180> <0.0061, 0.0261, 0.0347> <-0.0116, 0.0230, 0.0347>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.0298, 0.1276, 0.0409> <-0.0507, 0.1240, 0.0409> <-0.0866, 0.1177, 0.0212> <-0.0866, 0.1177, 0.0000>
		<-0.0269, 0.1112, 0.0438> <-0.0478, 0.1075, 0.0438> <-0.0879, 0.1005, 0.0212> <-0.0879, 0.1005, 0.0000>
		<-0.0232, 0.0894, 0.0517> <-0.0491, 0.0849, 0.0517> <-0.0951, 0.0771, 0.0263> <-0.0951, 0.0771, 0.0000>
		<-0.0203, 0.0727, 0.0507> <-0.0462, 0.0682, 0.0507> <-0.0908, 0.0605, 0.0263> <-0.0908, 0.0605, 0.0000>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.0866, 0.1177, 0.0000> <-0.0866, 0.1177, -0.0212> <-0.0507, 0.1240, -0.0409> <-0.0298, 0.1276, -0.0409>
		<-0.0879, 0.1005, 0.0000> <-0.0879, 0.1005, -0.0212> <-0.0478, 0.1075, -0.0438> <-0.0269, 0.1112, -0.0438>
		<-0.0951, 0.0771, 0.0000> <-0.0951, 0.0771, -0.0263> <-0.0491, 0.0849, -0.0517> <-0.0232, 0.0894, -0.0517>
		<-0.0908, 0.0605, 0.0000> <-0.0908, 0.0605, -0.0263> <-0.0462, 0.0682, -0.0507> <-0.0203, 0.0727, -0.0507>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.0203, 0.0727, 0.0507> <-0.0462, 0.0682, 0.0507> <-0.0908, 0.0605, 0.0263> <-0.0908, 0.0605, 0.0000>
		<-0.0175, 0.0571, 0.0498> <-0.0435, 0.0526, 0.0498> <-0.0866, 0.0444, 0.0263> <-0.0866, 0.0444, 0.0000>
		<-0.0142, 0.0379, 0.0395> <-0.0319, 0.0348, 0.0395> <-0.0691, 0.0284, 0.0180> <-0.0691, 0.0284, 0.0000>
		<-0.0116, 0.0230, 0.0347> <-0.0293, 0.0199, 0.0347> <-0.0598, 0.0146, 0.0180> <-0.0598, 0.0146, 0.0000>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.0908, 0.0605, 0.0000> <-0.0908, 0.0605, -0.0263> <-0.0462, 0.0682, -0.0507> <-0.0203, 0.0727, -0.0507>
		<-0.0866, 0.0444, 0.0000> <-0.0866, 0.0444, -0.0263> <-0.0435, 0.0526, -0.0498> <-0.0175, 0.0571, -0.0498>
		<-0.0691, 0.0284, 0.0000> <-0.0691, 0.0284, -0.0180> <-0.0319, 0.0348, -0.0395> <-0.0142, 0.0379, -0.0395>
		<-0.0598, 0.0146, 0.0000> <-0.0598, 0.0146, -0.0180> <-0.0293, 0.0199, -0.0347> <-0.0116, 0.0230, -0.0347>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.0622, 0.6320, -0.0059> <-0.0553, 0.6162, -0.0059> <-0.0407, 0.5965, -0.0059> <-0.0392, 0.5794, -0.0059>
		<-0.0622, 0.6320, -0.0271> <-0.0553, 0.6162, -0.0271> <-0.0407, 0.5965, -0.0322> <-0.0392, 0.5794, -0.0322>
		<-0.0981, 0.6260, -0.0467> <-0.0954, 0.6095, -0.0497> <-0.0867, 0.5886, -0.0576> <-0.0839, 0.5719, -0.0566>
		<-0.1191, 0.6225, -0.0467> <-0.1163, 0.6060, -0.0497> <-0.1126, 0.5842, -0.0576> <-0.1098, 0.5675, -0.0566>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.0622, 0.6320, -0.0059> <-0.0622, 0.6320, 0.0153> <-0.0981, 0.6260, 0.0350> <-0.1191, 0.6225, 0.0350>
		<-0.0553, 0.6162, -0.0059> <-0.0553, 0.6162, 0.0153> <-0.0954, 0.6095, 0.0380> <-0.1163, 0.6060, 0.0380>
		<-0.0407, 0.5965, -0.0059> <-0.0407, 0.5965, 0.0204> <-0.0867, 0.5886, 0.0459> <-0.1126, 0.5842, 0.0459>
		<-0.0392, 0.5794, -0.0059> <-0.0392, 0.5794, 0.0204> <-0.0839, 0.5719, 0.0449> <-0.1098, 0.5675, 0.0449>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.0392, 0.5794, -0.0059> <-0.0378, 0.5628, -0.0059> <-0.0490, 0.5419, -0.0059> <-0.0532, 0.5258, -0.0059>
		<-0.0392, 0.5794, -0.0322> <-0.0378, 0.5628, -0.0322> <-0.0490, 0.5419, -0.0239> <-0.0532, 0.5258, -0.0239>
		<-0.0839, 0.5719, -0.0566> <-0.0812, 0.5562, -0.0557> <-0.0862, 0.5357, -0.0454> <-0.0837, 0.5207, -0.0406>
		<-0.1098, 0.5675, -0.0566> <-0.1072, 0.5519, -0.0557> <-0.1040, 0.5327, -0.0454> <-0.1015, 0.5177, -0.0406>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.0392, 0.5794, -0.0059> <-0.0392, 0.5794, 0.0204> <-0.0839, 0.5719, 0.0449> <-0.1098, 0.5675, 0.0449>
		<-0.0378, 0.5628, -0.0059> <-0.0378, 0.5628, 0.0204> <-0.0812, 0.5562, 0.0439> <-0.1072, 0.5519, 0.0439>
		<-0.0490, 0.5419, -0.0059> <-0.0490, 0.5419, 0.0121> <-0.0862, 0.5357, 0.0336> <-0.1040, 0.5327, 0.0336>
		<-0.0532, 0.5258, -0.0059> <-0.0532, 0.5258, 0.0121> <-0.0837, 0.5207, 0.0288> <-0.1015, 0.5177, 0.0288>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.1191, 0.6225, 0.0350> <-0.1400, 0.6190, 0.0350> <-0.1759, 0.6129, 0.0153> <-0.1759, 0.6129, -0.0059>
		<-0.1163, 0.6060, 0.0380> <-0.1372, 0.6025, 0.0380> <-0.1773, 0.5957, 0.0153> <-0.1773, 0.5957, -0.0059>
		<-0.1126, 0.5842, 0.0459> <-0.1386, 0.5799, 0.0459> <-0.1847, 0.5724, 0.0204> <-0.1847, 0.5724, -0.0059>
		<-0.1098, 0.5675, 0.0449> <-0.1358, 0.5632, 0.0449> <-0.1804, 0.5557, 0.0204> <-0.1804, 0.5557, -0.0059>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.1759, 0.6129, -0.0059> <-0.1759, 0.6129, -0.0271> <-0.1400, 0.6190, -0.0467> <-0.1191, 0.6225, -0.0467>
		<-0.1773, 0.5957, -0.0059> <-0.1773, 0.5957, -0.0271> <-0.1372, 0.6025, -0.0497> <-0.1163, 0.6060, -0.0497>
		<-0.1847, 0.5724, -0.0059> <-0.1847, 0.5724, -0.0322> <-0.1386, 0.5799, -0.0576> <-0.1126, 0.5842, -0.0576>
		<-0.1804, 0.5557, -0.0059> <-0.1804, 0.5557, -0.0322> <-0.1358, 0.5632, -0.0566> <-0.1098, 0.5675, -0.0566>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.1098, 0.5675, 0.0449> <-0.1358, 0.5632, 0.0449> <-0.1804, 0.5557, 0.0204> <-0.1804, 0.5557, -0.0059>
		<-0.1072, 0.5519, 0.0439> <-0.1332, 0.5475, 0.0439> <-0.1763, 0.5396, 0.0204> <-0.1763, 0.5396, -0.0059>
		<-0.1040, 0.5327, 0.0336> <-0.1217, 0.5297, 0.0336> <-0.1589, 0.5234, 0.0121> <-0.1589, 0.5234, -0.0059>
		<-0.1015, 0.5177, 0.0288> <-0.1192, 0.5148, 0.0288> <-0.1497, 0.5096, 0.0121> <-0.1497, 0.5096, -0.0059>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.1804, 0.5557, -0.0059> <-0.1804, 0.5557, -0.0322> <-0.1358, 0.5632, -0.0566> <-0.1098, 0.5675, -0.0566>
		<-0.1763, 0.5396, -0.0059> <-0.1763, 0.5396, -0.0322> <-0.1332, 0.5475, -0.0557> <-0.1072, 0.5519, -0.0557>
		<-0.1589, 0.5234, -0.0059> <-0.1589, 0.5234, -0.0239> <-0.1217, 0.5297, -0.0454> <-0.1040, 0.5327, -0.0454>
		<-0.1497, 0.5096, -0.0059> <-0.1497, 0.5096, -0.0239> <-0.1192, 0.5148, -0.0406> <-0.1015, 0.5177, -0.0406>
	}
	pigment {color rgb <0.9, 0.8, 0.8>}
	finish {ambient 0.1 diffuse 0.7 phong 0.1}
	normal {bumps bump_size 0.3 scale 0.01}
}

#declare Sphere1 = sphere{0, 0.16 scale <1, 0.3, 0.3> texture{FairHair}}
#declare Part1 = union{
	Hair(Sphere1, 200, <0, 0, 0>, 0.45, FairHair) 
    Hair(Sphere1, 200, <-0.08, 0, 0>, 0.45, FairHair) 
    Hair(Sphere1, 200, <0.08, 0, 0>, 0.45, FairHair)
    
    rotate z*8
    rotate z*90
    translate <-0.14, 0.76, 0>
} 

#declare Feather2 = union {
	object{Center}
	object{Left}
	object{Right} 
	object{Fix}
	object{Rope}
	object{Part1}
}




