// ============================================================================
//
// is_wrshp.inc - Copyright 2001 Ian Shumsky / OuterArm
//
// ============================================================================
//
// This is the controling scene file for the Jan-Feb 2001 IRTC 'Worship' round.
//
// It first specifies a series of global settings, then adds lights, the
// central symbol and then the surrounding arms. The majority of the work is
// performed by the arms.inc macro file.
//
// ============================================================================

#version unofficial MegaPov 0.6;

// ============================================================================
//
// Scene switches.
//
// ============================================================================

//
// Several controlling switches for the general quality settings.
//

#declare do_radiosity = true;
#declare do_photons = true;
#declare do_area_lights = 4;

//
// Switches for turning on and off the various scene components.
//

#declare do_arms = true;
#declare do_dollar = true;
#declare do_pedestal = true;

// ============================================================================
//
// Global Settings
//
// ============================================================================

global_settings
{
	max_trace_level 32

	#if (do_photons = true)
		photons
		{
			count 10000
			jitter .5
		}
	#end

	#if (do_radiosity = true)
		ambient_light 0.01
		ini_option "+QR"
		radiosity
		{
			pretrace_start 0.08
			pretrace_end   0.02
			count 50
			nearest_count 5
			error_bound 1
			recursion_limit 3
			low_error_factor .5
			gray_threshold 0.0
			minimum_reuse 0.015
			brightness 1
			adc_bailout 0.01/5
			normal on
		}
	#end
}

// ============================================================================
//
// Create the room. This is an inverted box and a plane.
//
// ============================================================================

box
{
	<-6, -1, -6>, <6, 6, 6>
	inverse
	texture
	{
		pigment
		{
			colour rgb <247,224,192>/255 * .6
		}
		#if (do_radiosity = true)
			finish
			{
				ambient 5
			}
		#end
	}
}

plane
{
	y, 0
	texture
	{
		pigment
		{
			colour 0
		}
	}
}

// ============================================================================
//
// Place the camera.
//
// ============================================================================

camera
{
	location <0, 0.85, -0.75>
	look_at <0, 0, 0>
}

// ============================================================================
//
// Create the gold and silver textures for the dollar sign and the podium.
//
// ============================================================================

#declare GoldBase = <1.00, 0.875, 0.575>;
#declare CVect2 = GoldBase - <0.00, 0.15, 0.30>;
#declare P_Gold2 = rgb CVect2;

#declare globe_gold_t = texture
{
	pigment
	{
		P_Gold2
	}
	finish
	{
		ambient 0.25
		brilliance 4
		diffuse 0.5
		blinn 2
		metallic
		specular 0.80
		roughness 1/80
		reflection 0.25
	}
}

#declare P_Silver2 = color rgb <0.94, 0.93, 0.85>;

#declare globe_silver_t = texture
{
	pigment
	{
		P_Silver2
	}
	finish
	{
		ambient 0.25
		brilliance 4
		diffuse 0.5
		blinn 2
		metallic
		specular 0.80
		roughness 1/80
		reflection 0.2
	}
}

// ============================================================================
//
// Add the lights. There are a total of 13 spot lights - 12 surrounding the
// dollar sign and pointing at it and a single light pointing down at the sign.
// The surrounding lights cycle their colour through red, white and blue, while
// the overhead light is white.
//
// ============================================================================

#declare main_light_size = 0.25;

//
// max_lights defines how many lights are circling the $ sign. For best
// results, this should be a multiple of three.
//

#declare max_lights = 12;

//
// Light colour array
//

#declare light_colours = array [3]
{
	rgb <1, 0, 0>,
	rgb <1, 1, 1>,
	rgb <0, 0, 1>
}	

#declare light_count = 0;

#while (light_count < max_lights)
	light_source
	{
		<0, 0, -5>
		colour light_colours [mod(light_count,3)]
		spotlight
		point_at <0, 0.37, 0>
		radius .5*5
		tightness 50
		falloff .8*5
		#if (do_area_lights > 1)
			area_light
			<main_light_size, 0, 0> <0, main_light_size, 0>
			do_area_lights, do_area_lights
			adaptive 0
			jitter
			#if (do_photons = true)
				photons
				{
					reflection on area_light
				}
			#end
		#end
		rotate x*60
		rotate y*(light_count * (360 / max_lights))
	}

	#declare light_count = light_count + 1;
#end

light_source
{
	<0, 5.9, 0>
	colour rgb <1,1,1>
	spotlight
	point_at <0, 0.37, 0>
	radius 1
	tightness 5
	falloff 4
	#if (do_area_lights > 1)
		area_light
		<main_light_size, 0, 0> <0, main_light_size, 0>
		do_area_lights, do_area_lights
		adaptive 0
		jitter
		#if (do_photons = true)
			photons
			{
				reflection on area_light
			}
		#end
	#end
}

// ============================================================================
//
// Build and add the dollar sign and the column.
//
// ============================================================================

//
// Build the dollar sign
//

#declare base_dollar = object
{
	text
	{
		ttf
		"times.ttf",
		"$",
		0.2,
		0
		texture
		{
			globe_gold_t
			normal
			{
				bumps 0.25
			}
		}
		#if (do_photons = true)
			interior
			{
				ior 4
			}
			photons
			{
				target reflection on
			}
		#end
	}
	scale 0.5
}

#declare base_dollar_max = max_extent (base_dollar);
#declare base_dollar_min = min_extent (base_dollar);

#declare origin_dollar = object
{
	base_dollar
	// set it so goes x+, y+, z+
	translate <-(base_dollar_min.x), -(base_dollar_min.y), -(base_dollar_min.z)>
}

#declare origin_dollar_max = max_extent (origin_dollar);
#declare origin_dollar_min = min_extent (origin_dollar);

#declare dollar_max_height = origin_dollar_max.y;

#declare dollar_sign = object
{
	origin_dollar
	translate <-(origin_dollar_max.x/2), 0, -(origin_dollar_max.z/2)>
}

#declare pedestal = union
{
	cylinder
	{
		<0, 0, 0>, <0, 0.1, 0>, 0.15
	}

	#declare pillar_bit_count = 0;
	#while (pillar_bit_count < 12)
		cylinder
		{
			<0, 0, 0>, <0, 0.2, 0>, 0.0025
			translate <0, 0, -0.14>
			rotate y*((360/12)*pillar_bit_count)
		}
		sphere
		{
			<0, 0, 0>, 0.007
			translate <0, 0.15, -0.14>
			rotate y*((360/12)*pillar_bit_count)
		}
		sphere
		{
			<0, 0, 0>, 0.007
			translate <0, 0.2, -0.14>
			rotate y*((360/12)*pillar_bit_count)
		}
			
		#declare pillar_bit_count = pillar_bit_count + 1;
	#end
	
	torus
	{
		0.14,
		0.0025
		translate <0, 0.15, 0>
	}
	torus
	{
		0.14,
		0.0025
		translate <0, 0.2, 0>
	}

	texture
	{
		globe_silver_t
	}
	#if (do_photons = true)
		interior
		{
			ior 4
		}
		photons
		{
			target reflection on
		}
	#end
}

#if (do_dollar = true)
	object
	{
		dollar_sign
		translate <0, 0.1, 0>
	}
#end

#if (do_pedestal = true)
	object
	{
		pedestal
	}
#end	

// ============================================================================
//
// Finally add the arms.
//
// ============================================================================

#if (do_arms = true)
	#include "arm.inc"

	//
	// Specify the various thresholds to be used by the place arm macros.
	//

	#declare female_male_threshold = 0.5;

	#declare left_right_threshold = 0.5;

	#declare pose_threshold = array [5]
	{
		0.02, // 0.0  -> 0.02 is fist
		0.06, // 0.02 -> 0.06 is point
		0.1,  // 0.06 -> 0.1  is pointer
		0.14, // 0.1  -> 0.14 is pointer2
		0.57  // 0.14 -> 0.57 is reach
		      // 0.57 -> 1.0  is reach2
	}

	//
	// Now need to place the arms. We do this be having circles of individual
	// arms radiating out from the central dollar sign. We also want the arms
	// nearest the pedestal to be higher than those furthest away. To do this,
	// we will use a sine curve from the start to the end.
	//

	#declare base_look_loc = <0, dollar_max_height + 0.1, 0.05>;

	#declare arm_thickness = 0.015;
	#declare arm_out = 0.05;

	#declare max_arm_height = 0.135;

	// Starting point
	#declare start_ring_rad = 0.30;

	// End point. 1.0 is good 1.2 is better, but uses too much memory.
	#declare max_ring_rad = 1.0;

	#declare max_length = max_ring_rad - start_ring_rad;
	#declare line_ratio = 90 / (max_length);

	#declare ring_rad = start_ring_rad;

	#while (ring_rad < max_ring_rad)
		//
		// Need to find the position of the arm. The distance (z) from
		// the dollar is simply the current ring_rad. The height (y) is
		// somewhere between 0 and the max, depending upon the current
		// distance and a sine function.
		//

		#declare cdfs = ring_rad - start_ring_rad;
		#declare base_arm_height = (cos (radians (cdfs * line_ratio))) * max_arm_height;
		#declare base_arm_loc = <0, base_arm_height, ring_rad>;

		#declare no_of_arms = floor ((pi * ring_rad * ring_rad) / arm_thickness);
		#declare each_click = 360 / no_of_arms;

		#declare arm_count = 0;
		#while (arm_count < no_of_arms)
			#declare arm_loc = vrotate (base_arm_loc, <0, arm_count * each_click, 0>);
			#declare look_loc = vrotate (base_look_loc, <0, arm_count * each_click, 0>);

			put_arm (female_male_threshold, left_right_threshold, pose_threshold, arm_loc, look_loc)
			#declare arm_count = arm_count + 1;
		#end
		#declare ring_rad = ring_rad + arm_out;
	#end
#end

