/*****************************************************************************
/
/ Author: Ali Lakhia
/ File:   kaaba.pov
/ Date:   January 10th, 2001
/
*****************************************************************************/

// Adjust gamma value for PC
global_settings { assumed_gamma 2.2 }

// Get all the included files
#include "colors.inc"
#include "texture.inc"
#include "metals.inc"

// Options to reduce complexity in scene, set to 0 to turn object off
#declare Draw_kaaba = 1;
#declare Draw_kaaba_accessories = 1;
#declare Draw_walls = 1;
#declare Draw_walls_upper = 1;          // Only drawn #if (Draw_walls)
#declare Draw_walls_lower = 1;          // Only drawn #if (Draw_walls)
#declare Draw_walls_lower_back = 1;     // Only drawn #if (Draw_walls)
#declare Draw_mountains = 1;
#declare Draw_buildings = 1;
#declare Draw_minars = 1;
#declare Draw_haze = 1;
#declare Draw_people = 1;
#declare Lights_on = 1;                 // Any positive float, 0=off

// Options severely slow down rendering
#declare Extra_lights_on = 0;           // Only drawn #if (Lights_on)
#declare Area_lights_on = 0;            // Any positive integer, 0=off
#declare Minar_area_lights_on = 0;      // Any positive integer, 0=off
#declare Focus_blur_on = 0;

// Constants
#declare Lights_color = <1, 1, 0.83>;   // Light yellow
#declare Haze_color = rgbft <246/255, 141/255, 21/255, 0, 120/255>;

//////////////////////////////////////////////////////////////////////////////
// Miscellaneous & Center stuff
//////////////////////////////////////////////////////////////////////////////

// Get miscellaneous definitions
#include "misc.inc"

// Kaaba floor
object {
  Kaaba_floor
}

// Draw Kaaba accessories unless disabled
#if (Draw_kaaba_accessories)
  object {
    Half_ring
    translate -0.75*x
  }
  object {
    Center_lamp
    translate <-5, 0, -4>
  }
  object {
    Center_lamp
    translate <5, 0, -4>
  }
  object {
    Center_lamp
    translate <-5, 0, 4>
  }
  object {
    Center_lamp
//    translate <5, 0, 5.5>
    translate <5, 0, 4>
  }
  object {
    Center_lamp
    translate <-10, 0, 0>
  }
  object {
    Center_lamp
    translate <10, 0, 0>
  }
#end

// Draw kaaba unless disabled
#if (Draw_kaaba)
  object {
    Kaaba
    pigment { Black }
    translate 0.75*x
  }
#end

// Draw people if desired
#if (Draw_people)
  #include "people.inc"                 // Include file for people
  // Start from the center, then left to right
  Create_people(2.5, 5.2, 0.125, 0.42)
  Create_people(5.5, 8.2, -0.05, 0.42)
  Create_people(8.5, 10.5, -0.02, 0.16)
  Create_people(8.5, 9.2, 0.34, 0.4)
  Create_people(10.8, 13.2, -0.02, 0.085)
  Create_people(10.8, 11.6, 0.076, 0.12)
#end

// Draw haze if desired
#if (Draw_haze)
  fog {
    fog_type 2
    fog_offset 3
    fog_alt 24
    color Haze_color
    distance 4000
  }
#end

// Create the sky
sky_sphere {
  Mecca_sky_sphere
}

//////////////////////////////////////////////////////////////////////////////
// Camera & Lights stuff
//////////////////////////////////////////////////////////////////////////////

// Use this camera to render the final scene
#declare Render_camera = camera
{
  right <4/3, 0, 0>
  up <0, 1, 0>
  sky <0, 1, 0>
  direction <0, 0, 1.8>

  // Kaaba in center; walls & lamp in view; 
  // minars, sky, buildings, mountains hidden
  location <0, 4, -14>
  look_at <0.8, .6, 0>

  // Minar & walls in center; kaaba & lamp on left
  // Too close to floor. Mountain look soso. Kaaba cut off from left
  location <-2, 2, -15>
  look_at <10.5, 6, 13>

  // Minar & walls in center; kaaba & lamp on left
  // Close to floor. Mountains soso. Kaaba blends too easily with background
  location <-2.2, 3.2, -15>
  look_at <9.2, 6, 13>

  // Minar, walls, mountains visible. 
  // 75% of kaaba cut from bottom, floor barely visible
  location <-2.2, 6.7, -15>
  look_at <9.2, 6, 13>

  // Minar, walls, mountains visible. 
  // 50% of kaaba cut off from bottom, floor barely visible
  location <-2.2, 6.4, -18>
  look_at <9.2, 5.8, 13>

  // Minar on far right, kaaba far left
  location <9.2, 6.4, -22>
  look_at <2.2, 5.8, 21>

  // Same as before, camera positioned higher
  location <9.2, 10.4, -22>
  look_at <3.2, 5.8, 21>

  // Use Focal Blur
  #if (Focus_blur_on)
    focal_point <0, 0, 10>
    aperture 0.1
    blur_samples 25
  #end
}

// Camera for testing of scene objects, etc.
#declare Testing_camera = camera
{
  right <4/3, 0, 0>
  up <0, 1, 0>
  sky <0, 1, 0>
  direction <0, 0, 1.8>
//  location <-5.5, 6, 0>                 // side view of kaaba
//  look_at <0.8, .7, 0>
//  location <0, 7.7, 0>                  // top view of kaaba
//  look_at <0, .7, 0>
//  location <0, 4, 3>                    // top view of walls
//  look_at <0.8, 2.6, 7>                
//  location <2, 4, -3>                   // full view of walls
//  look_at <4.8, 2.8, 7>                
//  location <1, 3.2, 5>                  // closeup of upper walls
//  look_at <0, 3.6, 7>
//  location <2, 1, 2>                    // closeup of lower walls
//  look_at <0, 1.5, 8>
//  location <0, 4, -14>                  // look at sky
//  look_at <0.8, 6.6, 0>
//  location <-1, 2.4, -8>                // look at the lamp
//  look_at <-1, .8, -6>
//  location <10.5, 5.6, 8.2>             // minar 1/6 (base)
//  look_at <10.5, 6.6, 12.2>
//  location <8.5, 8, 10.2>               // minar 2/6 (large frame)
//  look_at <10.5, 8.1, 12.2>
//  location <8.5, 10.2, 10.2>            // minar 3/6 (window view)
//  look_at <10.5, 10.5, 12.2>
//  location <8.5, 11.2, 10.2>            // minar 4/6 (rim view)
//  look_at <10.5, 11.5, 12.2>
//  location <8.5, 12, 10.2>              // minar 5/6 (small frame + dome)
//  look_at <10.5, 12.3, 12.2>
//  location <8, 13.3, 10.2>              // minar 6/6 (crescent)
//  look_at <10.5, 13.45, 12.2>
//  location <0, 9, 4>                    // overview of minar (front)
//  look_at <10.5, 9.5, 12.2>
//  location <8, 6, 8>                    // overview of both minars (front)
//  look_at <13.5, 7, 12.2>
//  location <5, 7, 8>                    // closeup of minar railing
//  look_at <14.5, 6.5, 12.2>
//  location <0, 10, -30>                 // overview of scene (north)
//  look_at <0.8, 6.6, 0>
//  location <0, 65, 10>                  // overview of scene (top)
//  look_at <0, 0, 10>
  location <0, 185, 70>                 // overview of scene w/ mountains (top)
  look_at <0, 0, 70>
//  location <2, 55, 10>                  // overview of walls (top)
//  look_at <2, 0, 10>
//  location <12, 35, 12>                 // overview of minars (top)
//  look_at <12, 0, 12>
//  location <0, 9.1, 0.1>                // Closeup of people (top)
//  look_at <0, 0, 3.1>
//  location <7.2, 1, 6>                  // Close to the crack
//  look_at <9.2, 0.8, 13>
}

camera {
//  Testing_camera
  Render_camera
}

light_source {
  <22, 32, -10>
  color Gray50
  media_interaction off
  #if (Area_lights_on)
    area_light <0, 1, 0>, <1, 0, 0>, 1, Area_lights_on
  #end
  fade_distance 50
  fade_power 2
}
light_source {
  <-20, 15, -10>
  color Gray70
  media_interaction off
  #if (Area_lights_on)
    area_light <0, 1, 0>, <1, 0, 0>, 1, Area_lights_on
  #end
  fade_distance 20
  fade_power 2
}
light_source {
  <0, 0, 0>
  color Gray10
  shadowless
  fade_distance 4
  fade_power 1
}


//////////////////////////////////////////////////////////////////////////////
// Circumference objects
//////////////////////////////////////////////////////////////////////////////

// Draw walls unless disabled
#if (Draw_walls)
  #include "lwalls.inc"                 // Include file for lower walls
  #include "uwalls.inc"                 // Include file for upper walls

  union {
    union {
      object {
        Join_two_walls(5, 2, 15)
        clipped_by {
          Clip_left(5, 2, 15)
        }
        Position_wall(5, 2, 15)
      }
      Join_two_walls(5, 2, 15)
      clipped_by {
        Clip_left(5, 2, 15)
      }
      Position_wall(13, 2, 15)
    }
    Join_two_walls(13, 2, 15)
    translate <-1.56*7, 0, 8>
    pigment { white_marble }            // White marble is default pigment
  }
#end

// Draw minars unless disabled
#if (Draw_minars)
  #include "minars.inc"                 // Include file for minars
  union {
    object {
      Minar
      translate <-0.5, 0, 0>
    }
    object {
      Minar
      translate <3*1.56 + 0.5, 0, 0>
    }
    object {
      Minar_wall
      texture { very_light_brown_concrete }
    }
    rotate 30*y
    translate <10.2, 5.664, 12.2>       // 2.36*1.4 + 2.36 = 5.664
  }
#end

//////////////////////////////////////////////////////////////////////////////
// Exterior Objects
//////////////////////////////////////////////////////////////////////////////

// Draw buildings unless disabled
#if (Draw_buildings)
  union {
    random_buildings(14, 5, 35, 3, 6, 4)
    translate <-38, 0, 62>
  }
  union {
    random_buildings(14, 5, 35, 3, 6, 4)
    scale .6
    translate <-24, 0, 32>
  }
#else
  // Create bounding boxes for testing
  box { <0,0,0>, <5, 5, 29>
    pigment { Yellow }
    translate <-38, 0, 62>
  }
  box { <0,0,0>, <5,6,35>
    pigment { Yellow }
    scale .6
    translate <-24, 0, 32>
  }
#end

// Draw mountains unless disabled
#if (Draw_mountains)
  union {
    // The mountain in the front
    height_field {
      pgm "terrain5.pgm"
      smooth
      water_level .02
      scale <50, 12, 30>
      translate <-18, 3, 26>
      texture { T_Grnt4 scale .5 }
    }
    // The mountain to the left
    height_field {
      pgm "terrain6.pgm"
      smooth
      water_level .06
      scale <92, 26, 30>
      translate <-91, 0, 90>
      texture { T_Grnt4 scale .5 }
    }
    // The mountain, way out in the back
    height_field {
      pgm "terrain5.pgm"
      smooth
      water_level .02
      scale <155, 32, 30>
      translate <-60, -1, 156>
      texture { T_Grnt4 }
    }
  }
#end