// Persistence of Vision Ray Tracer Scene Description File
// File: mg_altar.pov
// Vers: 3.1g
// Desc: Altars of Ego
// Date: Feb 14, 2001
// Auth: Marjorie



#include "colors.inc"	
#include "textures.inc"	
#include "ws_tex.inc"//texture file


global_settings{
	adc_bailout 0.0039
	ambient_light color White+Gray05
	assumed_gamma 1.8
	irid_wavelength rgb <0.25,0.18,0.14>
	max_intersections 64                 
	max_trace_level 10
	number_of_waves 10
	radiosity{
	          brightness 3.33
	          count 300//
	          distance_maximum  150.0
	          error_bound 0.3
	          gray_threshold  0.5
	}

}

sphere { <0,0,0> 10000  
  hollow 
  texture{
    cielo_03 
    scale <8990,9990,8990>
  } 
}


//Lights -Luces

light_source
{
  0*x 
  color Gold+Wheat filter 0.2 
  translate <5, 15, -5>
  fade_power 2
  fade_distance 8
  
}


light_source
{
  0*x 
  DarkSlateGray   
  translate <-1, 5, 6>
  fade_power 2
  fade_distance 15
  
} 


light_source
{
  0*x                     
  color Copper+Gold
  spotlight               
  translate <2.2,10,80> 
  point_at <-40,10,120>      
  radius 50                
  tightness 20            
  falloff 30               
  fade_power 2
  fade_distance 5
  

}


camera
{
  location  <3 ,0.5 ,-4.10> 
  right     1.5/2*x
  aperture 40
  angle 48
  look_at   <2.8 , 1.25 , 1.0>  
} 




//se quedan como estn 

//upper mask / mascara arriba
#include "mask1.inc"

object{ 
  mask1 
  scale 1.25 
  rotate -45*x
  rotate 29*y 
  translate <5.3,3.4,4.0>
}    

//front mask /mascara frontal

object {
  mask1 
  scale 1.25 
  rotate -25*x 
  rotate -30*y  
  rotate 15*z 
  translate <2.5,0.09,-1.10> 
}   


//planos horizontales
union{
  plane{
    y, 
    -0.05 
    hollow on
    interior {ior 1.33}
    texture {  
      pigment { Black filter 0.7} 
      normal  { agate 0.25  scale 2} 
      finish  {
        brilliance 6.0
        reflection 0.6
        phong 0.8
        phong_size 120
      }
    }
        
  }

//plano superpuesto

  plane {
    y, 
    -0.04 
    hollow on
    interior {ior 1.33} 
    texture  {liquido }
  }

}


//platforms / plataformas

#include "plataforma.inc"

object{
  plataforma 
  rotate -120*y 
  translate <1,-0.05,5>
}

object{
  plataforma 
  rotate -60*y 
  translate <4.5,-0.05,3.55>
} 


object{
  plataforma 
  rotate -70*y 
  translate <-2.3,-0.95,8.03>
}   



//under water / abajo

object {
  plataforma 
  scale 0.80
  translate <2.2,-1.65,0.95>
}   

//stairs / escaleras

#include "stairs_b.inc"

object {
  stairs_b
  texture {Streaky_Steel_Metal}
  scale <3,5,3>
  translate <-56,18,150>
}  

  
//rear / trapos atras
#include "trapos2.inc"
object {
  trapos2 
  rotate -30*y 
  translate <2.2,2.8,6.5>
}

//shoe / zapato 
//

#include "zapato.inc"
object{
  zapato 
  scale 0.20 
  rotate -90*x 
  rotate -38*y 
  translate <3.6,0.08,-1.55>
} 


//group /grupo01
#declare G_01=
union{
 
  #include "cand01.inc"
  //candelabro
  object{cand01 scale <0.56,0.75,0.56>  translate <2.0,0.95,0.65>} 
 
  // boca_02
  #include "mouth02.inc"
  object {mouth02 rotate -28*y translate <1.27,2.04,0.69>} 
 
  // boca_03
  #include "mouth03.inc"
  object {mouth03  translate <2.5,2.8,0.45>}    

}


object{
  G_01 
  translate <1.5,1.75,3.0>
}


#include "gema.inc"

object{
  gema 
  scale 0.25 
  rotate 35*y 
  translate <4.55,2.25,6.50>
}

//group02 /group02
//coins - monedas

object {
  moneda1
  translate <2.97,-0.045,-2.50>
    
}
  
object{
  G_02 
  translate -0.042*y
}  
  
/*

[600x800, AA 0.3]
Width=600
Height=800
Antialias=On
Antialias_Threshold=0.250
Antialias_Depth=4
Jitter_Amount=0.5
Radiosity=On



*/