/*
 *	OfferingCCP.inc
 *
 *	"An Offering to the POV-Ray Gods"
 *
 *	Created for the Jan-Feb 2001 IRTC topic "Worship"
 *	Copyright (c) 2001 Mark Wagner
 */

/* Macro for filling an object with closely-packed objects
 * Adapted from a macro by Greg M. Johnson
 */

#version unofficial MegaPOV 0.5;

#macro Reorient(Axis1,Axis2)
      #declare vX1=vnormalize(Axis1);                   //john vansickle
      #declare vX2=vnormalize(Axis2);
      #declare vY=vnormalize(vcross(vX1,vX2));
      #declare vZ1=vnormalize(vcross(vX1,vY));
      #declare vZ2=vnormalize(vcross(vX2,vY));
      matrix < vX1.x, vY.x,vZ1.x, vX1.y,vY.y,vZ1.y, vX1.z,vY.z, vZ1.z, 0,0,0 >
      matrix < vX2.x,vX2.y,vX2.z,  vY.x,vY.y, vY.z, vZ2.x,vZ2.y,vZ2.z, 0,0,0 >
#end



/* MyObject is the object to fill
 * _radii is the approximate radius of the objects to fill it with
 * Objects is an array containing the objects to fill it with
 * Colors is an array containing the colors to use
 * Seed is the random seed to use
 */ 
#macro Spherer(MyObject,_radii,Objects,Colors,Seed)
	#local Rand1 = seed(Seed);
	#local NumObjs = dimension_size(Objects, 1);
	#local NumColors = dimension_size(Colors, 1);
union{
        #declare MyObject=object{MyObject Reorient(<1,1,1>,y)} // this aligns dense packed planes w/ y normal.
                               
        #local MaxExt=max_extent(MyObject);
        #local MinExt=min_extent(MyObject);
        #local minx=MinExt.x;
        #local miny=MinExt.y;
        #local minz=MinExt.z;
        #local maxx=MaxExt.x;
        #local maxy=MaxExt.y;
        #local maxz=MaxExt.z;
        
        #declare obfun=pigment {object {MyObject color Black color White}}

                #local summy=0;
                #local lx=(maxx-minx);
                #local ly=(maxy-miny);
                #local lz=(maxz-minz);
                
                #local dx=2*(2^0.5)*_radii;
                #local dy=2*(2^0.5)*_radii;
                #local dz=2*(2^0.5)*_radii;
                
                #local xinterval=1+int(lx/dx);
                #local yinterval=1+int(ly/dy);
                #local zinterval=1+int(lz/dz);                         
                            
                #local dd=array[5]                            
                
                #local drr=(2^0.5)*_radii;
                                                
                #local dd[1]=<0,0,0>;
                #local dd[2]=<0,drr,drr>;
                #local dd[3]=<drr,0,drr>;
                #local dd[4]=<drr,drr,0>;                                
                                        
                #local ix=0;
                #while(ix<xinterval)
                        #local iy=0;
                        #while(iy<yinterval)
                                #local iz=0;
                                #while(iz<zinterval)
                                                       
                                        #declare nnnn=1;
                                        #while(nnnn<5)                                                       
                                                       
                                                #local place=dd[nnnn]+<minx+ix*dx,miny+iy*dy,minz+iz*dz>;                                                                                
                                                #local blank=eval_pigment(obfun,place);
                                        
                                                #if (blank.x>0)
                                                        object{Objects[int(rand(Rand1)*NumObjs)] rotate <rand(Rand1)*360,rand(Rand1)*360,rand(Rand1)*360> translate place pigment{Colors[int(rand(Rand1)*NumColors)]}}
                                                #end                                                
                                            
                                        #declare nnnn=nnnn+1;
                                        #end
                                        
                                #local  iz=iz+1;
                                #end
                        #local iy=iy+1;
                        #end
                #local ix=ix+1;
                #end

        pigment{SeaGreen}
        finish{ambient 0.1}       
        
        Reorient(y,<1,1,1>)        
}
                
#end

//-----END OF MACRO, EXAMPLE OF USE--------------