#version unofficial MegaPov 0.6;

// variables globales: n1, n2, Points[n1][n2], Normals[n1][n2]

#macro ReadClothFile(nomfile)

	#debug "Reading cloth file...\n"

	#fopen file nomfile read
	#declare n1=0;
	#declare n2=0;
	#local temp=0;
	#local tempx=0;
	#local tempy=0;
	#local tempz=0;
	#read(file, n1, n2, temp, temp)

	#declare Points = array[n1][n2]

	#local i=0;
	#while (i<n1)
		#local j=0;
		#while (j<n2)
			#read(file, tempx, tempy, tempz, temp, temp, temp)
			#declare Points[i][j] = <tempx, tempy, tempz>;
			#local j=j+1;
		#end
		#local i=i+1;
	#end
	#fclose file
#end



// This array dictates the order in which to look when averaging normals: look clock-wise.                                                                
#declare La0 = array[4][2] {{0,-1}, {1,0}, {0,1}, {-1,0}}
#declare La1 = array[8][2] {{-1,-1}, {0,-1}, {1,-1}, {1,0}, {1,1}, {0,1}, {-1,1}, {-1,0}}

// NormSum(i, j, precision) takes the indices of a node as arguments and returns the normalized sum of the normals
// of the surrounding triangles.
#macro NormSum(i, j, _precision)

	#if (_precision) NormSum1(i,j)
	#else NormSum0(i,j) #end

#end


#macro NormSum0(i, j)
 #local _m = 0;
 #local _normsum = <0, 0, 0>;

	#while ( (_m < 4) )
		#if ( (i+La0[_m][0]<=(n1-1)) & (i+La0[_m][0]>=0) & (j+La0[_m][1]<=(n2-1)) & (j+La0[_m][1]>=0) &
			  (i+La0[mod(_m+1,4)][0]<=(n1-1)) & (i+La0[mod(_m+1,4)][0]>=0) & (j+La0[mod(_m+1,4)][1]<=(n2-1)) & (j+La0[mod(_m+1,4)][1]>=0) )
			#local _normsum = _normsum+vcross(points[i][j]-points[i+La0[_m][0]][j+La0[_m][1]], points[i][j]-points[i+La0[mod(_m+1,4)][0]][j+La0[mod(_m+1,4)][1]]);
		#end
		#local _m = _m + 1;
	#end

	(vnormalize(_normsum))
#end        

#macro NormSum1(i, j)
 #local _m = 0;
 #local _normsum = <0, 0, 0>;
  
	#while ( (_m < 8) )
		#if ( (i+La1[_m][0]<=(n1-1)) & (i+La1[_m][0]>=0) & (j+La1[_m][1]<=(n2-1)) & (j+La1[_m][1]>=0) &
			  (i+La1[mod(_m+1,8)][0]<=(n1-1)) & (i+La1[mod(_m+1,8)][0]>=0) & (j+La1[mod(_m+1,8)][1]<=(n2-1)) & (j+La1[mod(_m+1,8)][1]>=0) )
			#local _normsum = _normsum+vcross(points[i][j]-points[i+La1[_m][0]][j+La1[_m][1]], points[i][j]-points[i+La1[mod(_m+1,8)][0]][j+La1[mod(_m+1,8)][1]]);
		#end
		#local _m = _m + 1;
    #end

	(vnormalize(_normsum))
#end        
      

#macro GetNormals(points, nx, ny)

#debug "\nCalculating Normals\n"

#ifndef (Normal_Precision)
	#declare Normal_Precision = 0;
#end

#declare Normals = array[nx][ny]

	#local i = 0;
	#while (i < nx)
		#local j = 0;
		#while (j < ny)
			#if (Normal_Precision)
				#declare Normals[i][j] = NormSum1(i, j);
			#else
				#declare Normals[i][j] = NormSum0(i, j);
			#end
			#local j = j + 1;
		#end
		#local i = i + 1;
	#end
#end




#macro DrawTriangles(points, nx, ny, uvon, file, filename)
 #local i = 0;
 #debug "DrawTriangles\n"

	#if (file)
		#fopen c_idfile filename write
		#write(c_idfile, "#version unofficial megapov 0.6;\n")
	#end

	#while (i < nx)
		#local j = 0;
		#while (j < ny)
			#if (((j+1) <= (ny-1)) & ((i+1) <= (nx-1)))
				#if (file)
					#write(c_idfile, "triangle {\n")
					#write(c_idfile, points[i][j],   ", ")
					#write(c_idfile, points[i][j+1], ", ")
					#write(c_idfile, points[i+1][j])
					#if (uvon)
						#write (c_idfile, "\nuv_vectors ")
						#write (c_idfile, "<", i/(nx-1), ",", j/(ny-1), ">, ")
						#write (c_idfile, "<", i/(nx-1), ",", (j+1)/(ny-1), ">, ")
						#write (c_idfile, "<", (i+1)/(nx-1), ",", j/(ny-1), "> ")
					#end
					#write(c_idfile, "}\n")
				#else
					triangle { points[i][j], points[i][j+1], points[i+1][j]
					#if (uvon)
						uv_vectors <i/(nx-1), j/(ny-1)>, <i/(nx-1), (j+1)/(ny-1)>, <(i+1)/(nx-1), j/(ny-1)>
					#end
					}
				#end
			#end

			#if (((j-1) >= 0) & ((i-1) >= 0))
				#if (file)
					#write(c_idfile, "triangle {\n")
					#write(c_idfile, points[i][j],   ", ")
					#write(c_idfile, points[i][j-1], ", ")
					#write(c_idfile, points[i-1][j])
					#if (uvon)
						#write (c_idfile, "\nuv_vectors ")
						#write (c_idfile, "<", i/(nx-1), ",", j/(ny-1), ">, ")
						#write (c_idfile, "<", i/(nx-1), ",", (j-1)/(ny-1), ">, ")
						#write (c_idfile, "<", (i-1)/(nx-1), ",", j/(ny-1), "> ")
					#end
					#write(c_idfile, "}\n")
				#else
					triangle { points[i][j], points[i][j-1], points[i-1][j]
					#if (uvon)
						uv_vectors <i/(nx-1), j/(ny-1)>, <i/(nx-1), (j-1)/(ny-1)>, <(i-1)/(nx-1), j/(ny-1)>
					#end
					}
				#end
			#end
			#local j = j + 1;
		#end
		#local i = i + 1;
	#end

	#if (file)
		#fclose c_idfile
	#end

#end                                                


#macro DrawSmoothTriangles(points, nx, ny, uvon, file, filename)

	GetNormals(points, nx, ny)

	#if (file)
		#fopen c_idfile filename write
		#write(c_idfile, "#version unofficial megapov 0.6;\n")
	#end

	#debug "\nDraw Smooth Triangles\n"
	DrawSmoothTriangles1(points, Normals, nx, ny, uvon, <0,0>, <1,1>, file)

	#if (file)
		#fclose c_idfile
	#end

#end


#macro DrawSmoothTriangles1(points, normals, nx, ny, uvon, uvmin, uvmax, file)

	#if (uvon)
		#local ulng = (uvmax.x-uvmin.x);
		#local vlng = (uvmax.y-uvmin.y);
	#end

	#local i = 0;
	#while (i < nx)
		#local j = 0; 
		#while (j < ny)

			#if (((j+1) <= (ny-1)) & ((i+1) <= (nx-1)))
				#if (file)
					#write(c_idfile, "smooth_triangle {\n")
					#write(c_idfile, points[i][j],   ", ", normals[i][j], ", ")
					#write(c_idfile, points[i][j+1], ", ", normals[i][j+1], ", ")
					#write(c_idfile, points[i+1][j], ", ", normals[i+1][j], " ")
					#if (uvon)
						#write (c_idfile, "\nuv_vectors ")
						#write (c_idfile, "<", uvmin.x + ulng*i/(nx-1), ",", uvmin.y + vlng*j/(ny-1), ">, ")
						#write (c_idfile, "<", uvmin.x + ulng*i/(nx-1), ",", uvmin.y + vlng*(j+1)/(ny-1), ">, ")
						#write (c_idfile, "<", uvmin.x + ulng*(i+1)/(nx-1), ",", uvmin.y + vlng*j/(ny-1), "> ")
					#end
					#write(c_idfile, "}\n")
				#else
					smooth_triangle { points[i][j],   normals[i][j],
					                  points[i][j+1], normals[i][j+1],
					                  points[i+1][j], normals[i+1][j]
					#if (uvon)
						uv_vectors <uvmin.x + ulng*i/(nx-1), uvmin.y + vlng*j/(ny-1)>,
						           <uvmin.x + ulng*i/(nx-1), uvmin.y + vlng*(j+1)/(ny-1)>,
						           <uvmin.x + ulng*(i+1)/(nx-1), uvmin.y + vlng*j/(ny-1)>
					#end
					}
				#end
			#end

			#if (((j-1) >= 0) & ((i-1) >= 0))
				#if (file)
					#write(c_idfile, "smooth_triangle {\n")
					#write(c_idfile, points[i][j],   ", ", normals[i][j], ", ")
					#write(c_idfile, points[i][j-1], ", ", normals[i][j-1], ", ")
					#write(c_idfile, points[i-1][j], ", ", normals[i-1][j], " ")
					#if (uvon)
						#write (c_idfile, "\nuv_vectors ")
						#write (c_idfile, "<", uvmin.x + ulng*i/(nx-1), ",", uvmin.y + vlng*j/(ny-1), ">, ")
						#write (c_idfile, "<", uvmin.x + ulng*i/(nx-1), ",", uvmin.y + vlng*(j-1)/(ny-1), ">, ")
						#write (c_idfile, "<", uvmin.x + ulng*(i-1)/(nx-1), ",", uvmin.y + vlng*j/(ny-1), "> ")
					#end
					#write(c_idfile, "}\n")
				#else
					smooth_triangle { points[i][j],   normals[i][j],
					                  points[i][j-1], normals[i][j-1],
					                  points[i-1][j], normals[i-1][j]
					#if (uvon)
						uv_vectors <uvmin.x + ulng*i/(nx-1), uvmin.y + vlng*j/(ny-1)>,
						           <uvmin.x + ulng*i/(nx-1), uvmin.y + vlng*(j-1)/(ny-1)>,
						           <uvmin.x + ulng*(i-1)/(nx-1), uvmin.y + vlng*j/(ny-1)>
					#end
					}
				#end
			#end
			#local j = j + 1;
		#end
		#local i = i + 1;
	#end

#end                                                




#macro DrawDoubleSmoothTriangles(points, nx, ny, ep, uvon, uvep, file, filename)

	#if (uvon)
		#local ulng = 1-2*uvep.x;
		#local vlng = 1-2*uvep.y;
	#end

	#if (file)
		#fopen c_idfile filename write
		#write(c_idfile, "#version unofficial megapov 0.6;\n")
	#end

	GetNormals(points, nx, ny)

	#debug "\nCalculating additional points and normals\n"

	#local Joints1 = array[ny]
	#local Norms1 = array[ny]
	#local j=0;
	#while (j<(ny-1))
		#local Norms1[j] = vnormalize(vcross(points[0][j+1]-points[0][j], -ep*Normals[0][j]));
		#local Joints1[j] = points[0][j] - .5*ep*Normals[0][j] + .5*ep*Norms1[j];
		#local j=j+1;
	#end
	#local Norms1[ny-1] = vnormalize(vcross(points[0][ny-2]-points[0][ny-1], -ep*Normals[0][ny-1]));
	#local Joints1[ny-1] = points[0][ny-1] - .5*ep*Normals[0][ny-1] + .5*ep*Norms1[ny-1];

	#local Joints2 = array[ny]
	#local Norms2 = array[ny]
	#local j=0;
	#while (j<(ny-1))
		#local Norms2[j] = vnormalize(vcross(-ep*Normals[nx-1][j], points[nx-1][j+1]-points[nx-1][j]));
		#local Joints2[j] = points[nx-1][j] - .5*ep*Normals[nx-1][j] + .5*ep*Norms2[j];
		#local j=j+1;
	#end
	#local Norms2[ny-1] = vnormalize(vcross(-ep*Normals[nx-1][ny-1], points[nx-1][ny-1]-points[nx-1][ny-2]));
	#local Joints2[ny-1] = points[nx-1][ny-1] - .5*ep*Normals[nx-1][ny-1] + .5*ep*Norms2[ny-1];

	#local Joints3 = array[nx]
	#local Norms3 = array[nx]
	#local i=0;
	#while (i<(nx-1))
		#local Norms3[i] = vnormalize(vcross(-ep*Normals[i][0], points[i+1][0]-points[i][0]));
		#local Joints3[i] = points[i][0] - .5*ep*Normals[i][0] + .5*ep*Norms3[i];
		#local i=i+1;
	#end
	#local Norms3[nx-1] = vnormalize(vcross(-ep*Normals[nx-1][0], points[nx-1][0]-points[nx-2][0]));
	#local Joints3[nx-1] = points[nx-1][0] - .5*ep*Normals[nx-1][0] + .5*ep*Norms3[nx-1];

	#local Joints4 = array[nx]
	#local Norms4 = array[nx]
	#local i=0;
	#while (i<(nx-1))
		#local Norms4[i] = vnormalize(vcross(ep*Normals[i][ny-1], points[i+1][ny-1]-points[i][ny-1]));
		#local Joints4[i] = points[i][ny-1] - .5*ep*Normals[i][ny-1] + .5*ep*Norms4[i];
		#local i=i+1;
	#end
	#local Norms4[nx-1] = vnormalize(vcross(ep*Normals[nx-1][ny-1], points[nx-1][ny-1]-points[nx-2][ny-1]));
	#local Joints4[nx-1] = points[nx-1][ny-1] - .5*ep*Normals[nx-1][ny-1] + .5*ep*Norms4[nx-1];

	#local points2 = array[nx][ny]
	#local Normals2 = array[nx][ny]
	#local i=0;
	#while (i < nx)
		#local j = 0; 
		#while (j < ny)
			#local points2[i][j] = points[i][j]-ep*Normals[i][j];
			#local Normals2[i][j] = -Normals[i][j];
			#local j = j + 1;
		#end
		#local i = i + 1;
	#end

	#declare Normals[0][0] = 2*Normals[0][0] + Norms1[0] + Norms3[0];
	#declare Normals2[0][0] = 2*Normals2[0][0] + Norms1[0] + Norms3[0];
	#declare Normals[0][ny-1] = 2*Normals[0][ny-1] + Norms1[ny-1] + Norms4[0];
	#declare Normals2[0][ny-1] = 2*Normals2[0][ny-1] + Norms1[ny-1] + Norms4[0];
	#declare Normals[nx-1][0] = 2*Normals[nx-1][0] + Norms3[nx-1] + Norms2[0];
	#declare Normals2[nx-1][0] = 2*Normals2[nx-1][0] + Norms3[nx-1] + Norms2[0];
	#declare Normals[nx-1][ny-1] = 2*Normals[nx-1][ny-1] + Norms4[nx-1] + Norms2[ny-1];
	#declare Normals2[nx-1][ny-1] = 2*Normals2[nx-1][ny-1] + Norms4[nx-1] + Norms2[ny-1];

	#local j=1;
	#while (j<(ny-1))
		#declare Normals[0][j] = 2*Normals[0][j] + Norms1[j];
		#declare Normals2[0][j] = 2*Normals2[0][j] + Norms1[j];
		#local j=j+1;
	#end
	#local j=1;
	#while (j<(ny-1))
		#declare Normals[nx-1][j] = 2*Normals[nx-1][j] + Norms2[j];
		#declare Normals2[nx-1][j] = 2*Normals2[nx-1][j] + Norms2[j];
		#local j=j+1;
	#end
	#local i=1;
	#while (i<(nx-1))
		#declare Normals[i][0] = 2*Normals[i][0] + Norms3[i];
		#declare Normals2[i][0] = 2*Normals2[i][0] + Norms3[i];
		#local i=i+1;
	#end
	#local i=1;
	#while (i<(nx-1))
		#declare Normals[i][ny-1] = 2*Normals[i][ny-1] + Norms4[i];
		#declare Normals2[i][ny-1] = 2*Normals2[i][ny-1] + Norms4[i];
		#local i=i+1;
	#end
	
	#debug "\nDraw Fisrt Set of Smooth Triangles\n"
	DrawSmoothTriangles1(points, Normals, nx, ny, uvon, uvep, <1-uvep.x,1-uvep.y>, file)

	#debug "\nDraw Second Set of Smooth Triangles\n"
	DrawSmoothTriangles1(points2, Normals2, nx, ny, uvon, uvep, <1-uvep.x,1-uvep.y>, file)

	#debug "\nDraw Joints Triangles\n"
	#local j=0;
	#while (j<(ny-1))
		#if (file)
			#write(c_idfile, "smooth_triangle {\n")
			#write(c_idfile, Joints1[j],   ", ", Norms1[j], ", ")
			#write(c_idfile, points[0][j], ", ", Normals[0][j], ", ")
			#write(c_idfile, points[0][j+1], ", ", Normals[0][j+1], " ")
			#if (uvon)
				#write (c_idfile, "\nuv_vectors ")
				#write (c_idfile, "<", 0, ",", uvep.y + vlng*j/(ny-1), ">, ")
				#write (c_idfile, "<", uvep.x, ",", uvep.y + vlng*j/(ny-1), ">, ")
				#write (c_idfile, "<", uvep.x, ",", uvep.y + vlng*(j+1)/(ny-1), "> ")
			#end
			#write(c_idfile, "}\n")
			#write(c_idfile, "smooth_triangle {\n")
			#write(c_idfile, Joints1[j],   ", ", Norms1[j], ", ")
			#write(c_idfile, points[0][j+1], ", ", Normals[0][j+1], ", ")
			#write(c_idfile, Joints1[j+1], ", ", Norms1[j+1], " ")
			#if (uvon)
				#write (c_idfile, "\nuv_vectors ")
				#write (c_idfile, "<", 0, ",", uvep.y + vlng*j/(ny-1), ">, ")
				#write (c_idfile, "<", uvep.x, ",", uvep.y + vlng*(j+1)/(ny-1), ">, ")
				#write (c_idfile, "<", 0, ",", uvep.y + vlng*(j+1)/(ny-1), "> ")
			#end
			#write(c_idfile, "}\n")
			#write(c_idfile, "smooth_triangle {\n")
			#write(c_idfile, Joints1[j],   ", ", Norms1[j], ", ")
			#write(c_idfile, Joints1[j+1], ", ", Norms1[j+1], ", ")
			#write(c_idfile, points2[0][j+1], ", ", Normals2[0][j+1], " ")
			#if (uvon)
				#write (c_idfile, "\nuv_vectors ")
				#write (c_idfile, "<", 0, ",", uvep.y + vlng*j/(ny-1), ">, ")
				#write (c_idfile, "<", 0, ",", uvep.y + vlng*(j+1)/(ny-1), ">, ")
				#write (c_idfile, "<", uvep.x, ",", uvep.y + vlng*(j+1)/(ny-1), "> ")
			#end
			#write(c_idfile, "}\n")
			#write(c_idfile, "smooth_triangle {\n")
			#write(c_idfile, Joints1[j],   ", ", Norms1[j], ", ")
			#write(c_idfile, points2[0][j+1], ", ", Normals2[0][j+1], ", ")
			#write(c_idfile, points2[0][j], ", ", Normals2[0][j], " ")
			#if (uvon)
				#write (c_idfile, "\nuv_vectors ")
				#write (c_idfile, "<", 0, ",", uvep.y + vlng*j/(ny-1), ">, ")
				#write (c_idfile, "<", uvep.x, ",", uvep.y + vlng*(j+1)/(ny-1), ">, ")
				#write (c_idfile, "<", uvep.x, ",", uvep.y + vlng*j/(ny-1), "> ")
			#end
			#write(c_idfile, "}\n")
		#else
			smooth_triangle { Joints1[j], Norms1[j],
			                  points[0][j], Normals[0][j],
			                  points[0][j+1], Normals[0][j+1]
				#if (uvon)
					uv_vectors <0, uvep.y + vlng*j/(ny-1)>,
					           <uvep.x, uvep.y + vlng*j/(ny-1)>,
					           <uvep.x, uvep.y + vlng*(j+1)/(ny-1)>
				#end
			}
			smooth_triangle { Joints1[j], Norms1[j],
			                  points[0][j+1], Normals[0][j+1],
			                  Joints1[j+1], Norms1[j+1] 
				#if (uvon)
					uv_vectors <0, uvep.y + vlng*j/(ny-1)>,
					           <uvep.x, uvep.y + vlng*(j+1)/(ny-1)>,
					           <0, uvep.y + vlng*(j+1)/(ny-1)>
				#end
			}
			smooth_triangle { Joints1[j], Norms1[j],
			                  Joints1[j+1], Norms1[j+1] ,
			                  points2[0][j+1], Normals2[0][j+1]
				#if (uvon)
					uv_vectors <0, uvep.y + vlng*j/(ny-1)>,
					           <0, uvep.y + vlng*(j+1)/(ny-1)>,
					           <uvep.x, uvep.y + vlng*(j+1)/(ny-1)>
				#end
			}
			smooth_triangle { Joints1[j], Norms1[j],
			                  points2[0][j+1], Normals2[0][j+1],
			                  points2[0][j], Normals2[0][j]
				#if (uvon)
					uv_vectors <0, uvep.y + vlng*j/(ny-1)>,
					           <uvep.x, uvep.y + vlng*(j+1)/(ny-1)>,
					           <uvep.x, uvep.y + vlng*j/(ny-1)>
				#end
			}
		#end
		#local j=j+1;
	#end
	#local j=0;
	#while (j<(ny-1))
		#if (file)
			#write(c_idfile, "smooth_triangle {\n")
			#write(c_idfile, Joints2[j],   ", ", Norms2[j], ", ")
			#write(c_idfile, points[nx-1][j], ", ", Normals[nx-1][j], ", ")
			#write(c_idfile, points[nx-1][j+1], ", ", Normals[nx-1][j+1], " ")
			#if (uvon)
				#write (c_idfile, "\nuv_vectors ")
				#write (c_idfile, "<", 1, ",", uvep.y + vlng*j/(ny-1), ">, ")
				#write (c_idfile, "<", 1-uvep.x, ",", uvep.y + vlng*j/(ny-1), ">, ")
				#write (c_idfile, "<", 1-uvep.x, ",", uvep.y + vlng*(j+1)/(ny-1), "> ")
			#end
			#write(c_idfile, "}\n")
			#write(c_idfile, "smooth_triangle {\n")
			#write(c_idfile, Joints2[j],   ", ", Norms2[j], ", ")
			#write(c_idfile, points[nx-1][j+1], ", ", Normals[nx-1][j+1], ", ")
			#write(c_idfile, Joints2[j+1], ", ", Norms2[j+1], " ")
			#if (uvon)
				#write (c_idfile, "\nuv_vectors ")
				#write (c_idfile, "<", 1, ",", uvep.y + vlng*j/(ny-1), ">, ")
				#write (c_idfile, "<", 1-uvep.x, ",", uvep.y + vlng*(j+1)/(ny-1), ">, ")
				#write (c_idfile, "<", 1, ",", uvep.y + vlng*(j+1)/(ny-1), "> ")
			#end
			#write(c_idfile, "}\n")
			#write(c_idfile, "smooth_triangle {\n")
			#write(c_idfile, Joints2[j],   ", ", Norms2[j], ", ")
			#write(c_idfile, Joints2[j+1], ", ", Norms2[j+1], ", ")
			#write(c_idfile, points2[nx-1][j+1], ", ", Normals2[nx-1][j+1], " ")
			#if (uvon)
				#write (c_idfile, "\nuv_vectors ")
				#write (c_idfile, "<", 1, ",", uvep.y + vlng*j/(ny-1), ">, ")
				#write (c_idfile, "<", 1, ",", uvep.y + vlng*(j+1)/(ny-1), ">, ")
				#write (c_idfile, "<", 1-uvep.x, ",", uvep.y + vlng*(j+1)/(ny-1), "> ")
			#end
			#write(c_idfile, "}\n")
			#write(c_idfile, "smooth_triangle {\n")
			#write(c_idfile, Joints2[j],   ", ", Norms2[j], ", ")
			#write(c_idfile, points2[nx-1][j+1], ", ", Normals2[nx-1][j+1], ", ")
			#write(c_idfile, points2[nx-1][j], ", ", Normals2[nx-1][j], " ")
			#if (uvon)
				#write (c_idfile, "\nuv_vectors ")
				#write (c_idfile, "<", 1, ",", uvep.y + vlng*j/(ny-1), ">, ")
				#write (c_idfile, "<", 1-uvep.x, ",", uvep.y + vlng*(j+1)/(ny-1), ">, ")
				#write (c_idfile, "<", 1-uvep.x, ",", uvep.y + vlng*j/(ny-1), "> ")
			#end
			#write(c_idfile, "}\n")
		#else
			smooth_triangle { Joints2[j], Norms2[j],
			                  points[nx-1][j], Normals[nx-1][j],
			                  points[nx-1][j+1], Normals[nx-1][j+1]
				#if (uvon)
					uv_vectors <1, uvep.y + vlng*j/(ny-1)>,
					           <1-uvep.x, uvep.y + vlng*(j+1)/(ny-1)>,
					           <1-uvep.x, uvep.y + vlng*(j+1)/(ny-1)>
				#end
			}
			smooth_triangle { Joints2[j], Norms2[j],
			                  points[nx-1][j+1], Normals[nx-1][j+1],
			                  Joints2[j+1], Norms2[j+1]
				#if (uvon)
					uv_vectors <1, uvep.y + vlng*j/(ny-1)>,
					           <1-uvep.x, uvep.y + vlng*(j+1)/(ny-1)>,
					           <1, uvep.y + vlng*(j+1)/(ny-1)>
				#end
			}
			smooth_triangle { Joints2[j], Norms2[j],
			                  Joints2[j+1], Norms2[j+1] ,
			                  points2[nx-1][j+1], Normals2[nx-1][j+1]
				#if (uvon)
					uv_vectors <1, uvep.y + vlng*j/(ny-1)>,
					           <1, uvep.y + vlng*(j+1)/(ny-1)>,
					           <1-uvep.x, uvep.y + vlng*(j+1)/(ny-1)>
				#end
			}
			smooth_triangle { Joints2[j], Norms2[j],
			                  points2[nx-1][j+1], Normals2[nx-1][j+1],
			                  points2[nx-1][j], Normals2[nx-1][j]
				#if (uvon)
					uv_vectors <1, uvep.y + vlng*j/(ny-1)>,
					           <1-uvep.x, uvep.y + vlng*(j+1)/(ny-1)>,
					           <1-uvep.x, uvep.y + vlng*j/(ny-1)>
				#end
			}
		#end
		#local j=j+1;
	#end
	#local i=0;
	#while (i<(nx-1))
		#if (file)
			#write(c_idfile, "smooth_triangle {\n")
			#write(c_idfile, Joints3[i],   ", ", Norms3[i], ", ")
			#write(c_idfile, points[i][0], ", ", Normals[i][0], ", ")
			#write(c_idfile, points[i+1][0], ", ", Normals[i+1][0], " ")
			#if (uvon)
				#write (c_idfile, "\nuv_vectors ")
				#write (c_idfile, "<", uvep.x + ulng*i/(nx-1), ",", 0, ">, ")
				#write (c_idfile, "<", uvep.x + ulng*i/(nx-1), ",", uvep.y, ">, ")
				#write (c_idfile, "<", uvep.x + ulng*(i+1)/(nx-1), ",", uvep.y, "> ")
			#end
			#write(c_idfile, "}\n")
			#write(c_idfile, "smooth_triangle {\n")
			#write(c_idfile, Joints3[i],   ", ", Norms3[i], ", ")
			#write(c_idfile, points[i+1][0], ", ", Normals[i+1][0], ", ")
			#write(c_idfile, Joints3[i+1], ", ", Norms3[i+1], " ")
			#if (uvon)
				#write (c_idfile, "\nuv_vectors ")
				#write (c_idfile, "<", uvep.x + ulng*i/(nx-1), ",", 0, ">, ")
				#write (c_idfile, "<", uvep.x + ulng*(i+1)/(nx-1), ",", uvep.y, ">, ")
				#write (c_idfile, "<", uvep.x + ulng*(i+1)/(nx-1), ",", 0, "> ")
			#end
			#write(c_idfile, "}\n")
			#write(c_idfile, "smooth_triangle {\n")
			#write(c_idfile, Joints3[i],   ", ", Norms3[i], ", ")
			#write(c_idfile, Joints3[i+1], ", ", Norms3[i+1], ", ")
			#write(c_idfile, points2[i+1][0], ", ", Normals2[i+1][0], " ")
			#if (uvon)
				#write (c_idfile, "\nuv_vectors ")
				#write (c_idfile, "<", uvep.x + ulng*i/(nx-1), ",", 0, ">, ")
				#write (c_idfile, "<", uvep.x + ulng*(i+1)/(nx-1), ",", 0, ">, ")
				#write (c_idfile, "<", uvep.x + ulng*(i+1)/(nx-1), ",", uvep.y, "> ")
			#end
			#write(c_idfile, "}\n")
			#write(c_idfile, "smooth_triangle {\n")
			#write(c_idfile, Joints3[i],   ", ", Norms3[i], ", ")
			#write(c_idfile, points2[i+1][0], ", ", Normals2[i+1][0], ", ")
			#write(c_idfile, points2[i][0], ", ", Normals2[i][0], " ")
			#if (uvon)
				#write (c_idfile, "\nuv_vectors ")
				#write (c_idfile, "<", uvep.x + ulng*i/(nx-1), ",", 0, ">, ")
				#write (c_idfile, "<", uvep.x + ulng*(i+1)/(nx-1), ",", uvep.y, ">, ")
				#write (c_idfile, "<", uvep.x + ulng*i/(nx-1), ",", uvep.y, "> ")
			#end
			#write(c_idfile, "}\n")
		#else
			smooth_triangle { Joints3[i], Norms3[i],
			                  points[i][0], Normals[i][0],
			                  points[i+1][0], Normals[i+1][0]
				#if (uvon)
					uv_vectors <uvep.x + ulng*i/(nx-1), 0>,
					           <uvep.x + ulng*i/(nx-1), uvep.y>,
					           <uvep.x + ulng*(i+1)/(nx-1), uvep.y>
				#end
			}
			smooth_triangle { Joints3[i], Norms3[i],
			                  points[i+1][0], Normals[i+1][0],
			                  Joints3[i+1], Norms3[i+1] 
				#if (uvon)
					uv_vectors <uvep.x + ulng*i/(nx-1), 0>,
					           <uvep.x + ulng*(i+1)/(nx-1), uvep.y>,
					           <uvep.x + ulng*(i+1)/(nx-1), 0>
				#end
			}
			smooth_triangle { Joints3[i], Norms3[i],
			                  Joints3[i+1], Norms3[i+1] ,
			                  points2[i+1][0], Normals2[i+1][0]
				#if (uvon)
					uv_vectors <uvep.x + ulng*i/(nx-1), 0>,
					           <uvep.x + ulng*(i+1)/(nx-1), 0>,
					           <uvep.x + ulng*(i+1)/(nx-1), uvep.y>
				#end
			}
			smooth_triangle { Joints3[i], Norms3[i],
			                  points2[i+1][0], Normals2[i+1][0],
			                  points2[i][0], Normals2[i][0]
				#if (uvon)
					uv_vectors <uvep.x + ulng*i/(nx-1), 0>,
					           <uvep.x + ulng*(i+1)/(nx-1), uvep.y>,
					           <uvep.x + ulng*i/(nx-1), uvep.y>
				#end
			}
		#end
		#local i=i+1;
	#end
	#local i=0;
	#while (i<(nx-1))
		#if (file)
			#write(c_idfile, "smooth_triangle {\n")
			#write(c_idfile, Joints4[i],   ", ", Norms4[i], ", ")
			#write(c_idfile, points[i][ny-1], ", ", Normals[i][ny-1], ", ")
			#write(c_idfile, points[i+1][ny-1], ", ", Normals[i+1][ny-1], " ")
			#if (uvon)
				#write (c_idfile, "\nuv_vectors ")
				#write (c_idfile, "<", uvep.x + ulng*i/(nx-1), ",", 1, ">, ")
				#write (c_idfile, "<", uvep.x + ulng*i/(nx-1), ",", 1-uvep.y, ">, ")
				#write (c_idfile, "<", uvep.x + ulng*(i+1)/(nx-1), ",", 1-uvep.y, "> ")
			#end
			#write(c_idfile, "}\n")
			#write(c_idfile, "smooth_triangle {\n")
			#write(c_idfile, Joints4[i],   ", ", Norms4[i], ", ")
			#write(c_idfile, points[i+1][ny-1], ", ", Normals[i+1][ny-1], ", ")
			#write(c_idfile, Joints4[i+1], ", ", Norms4[i+1], " ")
			#if (uvon)
				#write (c_idfile, "\nuv_vectors ")
				#write (c_idfile, "<", uvep.x + ulng*i/(nx-1), ",", 1, ">, ")
				#write (c_idfile, "<", uvep.x + ulng*(i+1)/(nx-1), ",", 1-uvep.y, ">, ")
				#write (c_idfile, "<", uvep.x + ulng*(i+1)/(nx-1), ",", 1, "> ")
			#end
			#write(c_idfile, "}\n")
			#write(c_idfile, "smooth_triangle {\n")
			#write(c_idfile, Joints4[i],   ", ", Norms4[i], ", ")
			#write(c_idfile, Joints4[i+1], ", ", Norms4[i+1], ", ")
			#write(c_idfile, points2[i+1][ny-1], ", ", Normals2[i+1][ny-1], " ")
			#if (uvon)
				#write (c_idfile, "\nuv_vectors ")
				#write (c_idfile, "<", uvep.x + ulng*i/(nx-1), ",", 1, ">, ")
				#write (c_idfile, "<", uvep.x + ulng*(i+1)/(nx-1), ",", 1, ">, ")
				#write (c_idfile, "<", uvep.x + ulng*(i+1)/(nx-1), ",", 1-uvep.y, "> ")
			#end
			#write(c_idfile, "}\n")
			#write(c_idfile, "smooth_triangle {\n")
			#write(c_idfile, Joints4[i],   ", ", Norms4[i], ", ")
			#write(c_idfile, points2[i+1][ny-1], ", ", Normals2[i+1][ny-1], ", ")
			#write(c_idfile, points2[i][ny-1], ", ", Normals2[i][ny-1], " ")
			#if (uvon)
				#write (c_idfile, "\nuv_vectors ")
				#write (c_idfile, "<", uvep.x + ulng*i/(nx-1), ",", 1, ">, ")
				#write (c_idfile, "<", uvep.x + ulng*(i+1)/(nx-1), ",", 1-uvep.y, ">, ")
				#write (c_idfile, "<", uvep.x + ulng*i/(nx-1), ",", 1-uvep.y, "> ")
			#end
			#write(c_idfile, "}\n")
		#else
			smooth_triangle { Joints4[i], Norms4[i],
			                  points[i][ny-1], Normals[i][ny-1],
			                  points[i+1][ny-1], Normals[i+1][ny-1]
				#if (uvon)
					uv_vectors <uvep.x + ulng*i/(nx-1), 1>,
					           <uvep.x + ulng*i/(nx-1), 1-uvep.y>,
					           <uvep.x + ulng*(i+1)/(nx-1), 1-uvep.y>
				#end
			}
			smooth_triangle { Joints4[i], Norms4[i],
			                  points[i+1][ny-1], Normals[i+1][ny-1],
			                  Joints4[i+1], Norms4[i+1] 
				#if (uvon)
					uv_vectors <uvep.x + ulng*i/(nx-1), 1>,
					           <uvep.x + ulng*(i+1)/(nx-1), 1-uvep.y>,
					           <uvep.x + ulng*(i+1)/(nx-1), 1>
				#end
			}
			smooth_triangle { Joints4[i], Norms4[i],
			                  Joints4[i+1], Norms4[i+1] ,
			                  points2[i+1][ny-1], Normals2[i+1][ny-1]
				#if (uvon)
					uv_vectors <uvep.x + ulng*i/(nx-1), 1>,
					           <uvep.x + ulng*(i+1)/(nx-1), 1>,
					           <uvep.x + ulng*(i+1)/(nx-1), 1-uvep.y>
				#end
			}
			smooth_triangle { Joints4[i], Norms4[i],
			                  points2[i+1][ny-1], Normals2[i+1][ny-1],
			                  points2[i][ny-1], Normals2[i][ny-1]
				#if (uvon)
					uv_vectors <uvep.x + ulng*i/(nx-1), 1>,
					           <uvep.x + ulng*(i+1)/(nx-1), 1-uvep.y>,
					           <uvep.x + ulng*i/(nx-1), 1-uvep.y>
				#end
			}
		#end
		#local i=i+1;
	#end

	#if (file)
		#fclose c_idfile
	#end

#end
