#version unofficial MegaPov 0.5;

#ifndef(main)
#include "wrmat.inc"
// 0 for simple throne, 1 for complex throne and 2 for full textures
#declare room = 3;
camera { location <.5,2.01,-2> look_at <-.2,.5,0> }
light_source { <0,3,0> color rgb 1 }
#end

/************** Scene **************/
//roof 
box { <-2,2,-3> <2,2.2,2> texture { floor_material } }

// floor
height_field {
  png "wall_normal.png"
  texture { floor_material } 
  smooth
  scale <4,.05,4>
  translate <-2,0,-2>
}
box { <2,0,2> <1.85,2,1.85> texture { dark_wood } }
box { <2,0,-2> <1.85,2,-1.85> texture { dark_wood } }
box { <-2,0,2> <-1.85,2,1.85> texture { dark_wood } }
box { <-2,0,-2> <-1.85,2,-1.85> texture { dark_wood } }

// corridor wall
box { 
  <-2,-1,-3.25> <2,3,-3> 
  texture { pigment { color rgb 2 } finish { ambient 0 }}
}

// front wall
difference {
  box { <-2,-1,-2> <2,2,-2.25> }
  box { <-.5,0,-2.5> <.5,1.5,-1.75> }
  texture { brick_wall }
}

// door
/*box {
  <0,0,.0625> <1,1.5,-.0625> pigment { color rgb 1 }
*/
union {
  height_field {
    ppm "wood_normal.ppm"
    smooth
    scale <1,.025,1.5>
    rotate x*-90
    translate z*-.0385
  }
  height_field {
    ppm "wood_normal.ppm"
    smooth
    rotate z*180
    translate <1,0,0>
    scale <1,.025,1.5>
    rotate x*-90
    translate z*.0385
  }
  height_field {
    ppm "wood_normal.ppm"
    smooth
    scale <1,.0125,.125>
    translate <0,1.495,-.06>
  }
  box { <0,1.3,-0.0625> <0.9,1.2,-0.0675> texture { dark_metal } }
  superellipsoid { <.5,.5> rotate <45,45,0> scale <.0075,.0075,.005> translate <0.875,1.23,-.0685> texture { dark_metal } }
  superellipsoid { <.5,.5> rotate <45,45,0> rotate <0,0,33> scale <.0075,.0075,.005> translate <0.875,1.27,-.0685> texture { dark_metal } }
  superellipsoid { <.5,.5> rotate <45,45,0> scale <.0075,.0075,.005> translate <0.8,1.23,-.0685> texture { dark_metal } }
  superellipsoid { <.5,.5> rotate <45,45,0> rotate <0,0,33> scale <.0075,.0075,.005> translate <0.8,1.27,-.0685> texture { dark_metal } }
  texture { dark_wood }
  rotate y*-65
  translate <-.5,0,-2.125>
}

// left wall
difference {
  height_field {
    png "wall_normal.png"
    texture { floor_material }
    smooth
    scale <4.2,.05,4.2>
    rotate x*-90
    rotate y*-90
    translate <-2,0,-2>
  }
  box { <-1.5,1,-.25> <-3,1.5,.25> texture { floor_material } }
  plane { x 0 translate x*-2.2 texture { floor_material } }
}

// window bars
%i = 0;
%n = 1;
union {
  #while (i<n+1)
    %tmp = .5*(i+1)/(n+2);
    cylinder { <-2.125,1,-.25+tmp> <-2.125,1.5,-.25+tmp> .025 }
    %i=i+1;
  #end
  texture { dark_metal }
}
// right wall
/*
box { 
  <2,-1,-2> <2.5,2,2>
  texture { brick_wall rotate y*-90 }
}
*/
height_field {
  png "wall_normal.png"
  texture { floor_material }
  smooth
  scale <4.75,.05,4>
  rotate x*-90
  rotate y*90
  translate <2,-.05,2.75>
}

// back wall
/*
box { 
  <-2,-1,2> <2,2,2.25>
  texture { brick_wall rotate y*180 }
}
*/
height_field {
  png "wall_normal.png"
  texture { floor_material }
  smooth
  scale <4.2,.05,4.3>
  rotate x*-90
  translate <-2,-.05,2>
}
#declare cha = 
union {
  difference {
    torus { .03 .01 rotate z*90 }
    plane { y 0 }
  }
  cylinder { <0,0,.03> <0,-.015,.03> .01 }
  cylinder { <0,0,-.03> <0,-.015,-.03> .01 }
  difference {
    torus { .03 .01 rotate z*90 }
    plane { -y 0 }
    translate y*-.015
  }
}
#local chain =
union {
  #local i = 0;
  #local n = 20;
  #while (i<n)
  object {
    cha
    rotate y*(mod(i,2)*80-40)
    translate y*i*-.065
  }
    #local i=i+1;
  #end
  texture { dark_metal }
}
object { chain translate <.7,1.7,1.9> }
object { chain translate <-1,1.5,1.9> }


