// Parametric variable form
#version unofficial MegaPov 0.6;

#declare uMin = 0; // Minimum u value
#declare uMax = 9.25*pi; // Maximum u value
#declare uNum = 150; // Number of points in u direction
#declare uWrap = 0; // u wraps around if != 0
#declare uSeed = 8266; // Random number seed for u parameter

#declare vMin = 0; // Minimum v value
#declare vMax = radians(340); // Maximum v value
#declare vNum = 18; // Number of points in v direction
#declare vWrap = 1; // v wraps around if != 0
#declare vSeed = 1425; // Random number seed for v parameter

#declare IsRnd = true; // True if random number used
#declare IsUV = true; // True if object is to be UV-mapped

#declare Detail = "Partial"
/* Detail values
  Verbose = Line by line details
  Partial = Operations only
  Other = Filename only
*/

/* For all macro functions
	i = Current value of u parameter
	j = Current value of v parameter
	p = Current value of u variance (0...1)
	q = Current value of v variance (0...1)
	vc= Current 3D point
*/

// Optional functions
#macro cen(i)
	#local rad = pow(i+.01, 0.8);
  <cos(i)*rad, sin(i)*rad, 0>
#end

#macro dir(i)
  vnormalize(cen(i-1e-4)-cen(i+1e-4))
#end

#macro norm(i)
  vnormalize(dir(i-1e-4)-dir(i+1e-4))
#end

#macro ortho(i)
  vcross(dir(i),norm(i))
#end

#macro pntround(i,u0,v0)
	cen(i)+norm(i)*u0+ortho(i)*v0
#end

#macro vturb(vc, siz)
	vc + vturbulence( 2, 0.6, 7, vc )*siz
#end

// point function
#macro pnt(i, j, p, q)
	#local u0 = sin(j)*sin(i*.06)*.8;
	#local v0 = cos(j)*sin(i*.06)*.8;

	#local pt0 = pntround( i, u0, v0 );	
  
	pt0*.03
#end

#declare Smooth = 0; // Smooth flag
