#version unofficial MegaPov 0.7;

#declare stgStep = 2;
#declare stgFloor = -stgStep*6;
#local stgRad0 = 33;
#local stgRad1 = stgRad0+10;
#local stgRad2 = stgRad0+20;
#local stgCut = stgRad0-15;
#local stgPos = stgRad0-25;
#local stgWid0 = sqrt(stgRad0*stgRad0-stgCut*stgCut);
#local stgWid1 = sqrt(stgRad1*stgRad1-stgCut*stgCut);
#local stgWid2 = sqrt(stgRad2*stgRad2-stgCut*stgCut);
#local stgWid3 = 60-stgWid0;
#local stgPos2 = 60-stgWid3*.5;

// Platform
#declare stgPlatRound = difference {
	box { <-70, -stgStep*8, -70>, <70, 0, -10> }
	cylinder { <0, -stgStep*6, stgPos>, <0,  stgStep, stgPos>, stgRad0 }
	cylinder { <0, -stgStep*4, stgPos>, <0,  stgStep, stgPos>, stgRad1 }
	cylinder { <0, -stgStep*2, stgPos>, <0,  stgStep, stgPos>, stgRad2 }
}

#declare stgPlatLow = intersection {
	cylinder { <0, -stgStep*8, -stgCut>, <0, -stgStep*6, -stgCut>, stgRad0 }
	box { <-stgWid0, -stgStep*8.1, -10>, <stgWid0, -stgStep*5.9, stgCut> }
}

#macro stgAngStep(in, out, alt)
	box { <-out, alt, -10>, < -in, alt+stgStep, 0> }
	box { <  in, alt, -10>, < out, alt+stgStep, 0> }
	intersection {
		box { <-out, alt+stgStep, -10>, < -in, alt+stgStep*2, 0> }
		plane { < 10, 0, out-in>, 0 translate x*-out }
	}
	intersection {
		box { <  in, alt+stgStep, -10>, < out, alt+stgStep*2, 0> }
		plane { <-10, 0, out-in>, 0 translate x*out }
	}
#end

#declare stgPlatform = union {
	object { stgPlatRound }
	object { stgPlatLow }
	box { <-70, -stgStep*8, -10>, <-60, 0, 0> }
	box { < 60, -stgStep*8, -10>, < 70, 0, 0> }
	stgAngStep( stgWid0, stgWid1, -stgStep*6 )
	stgAngStep( stgWid1, stgWid2, -stgStep*4 )
	stgAngStep( stgWid2, 60, -stgStep*2 )
	//uv_mapping
	texture { Carpet }
}

// Stairs
#local stgStairShear = 0;
#local stgStairWid = stgStep*2.6;
#local stgStairNum = 8;
#declare stgBack = -stgStairWid*(stgStairNum+1);
#declare stgAlt = stgStep*stgStairNum;

#macro stgOutSteps(pos, wid, shift)
	#local step = union {
		box { < -wid*.5, 0, -stgStep*2.5 >, < wid*.5, stgStep, 0 > }
		cylinder { <-wid*.5, stgStep*.9, 0>, <wid*.5, stgStep*.9, 0>, stgStep*.1 }
	}
	union {
		ObjLine( step, x*pos, <0, stgStep, -stgStairWid>, stgStairNum )
		intersection {
			box { <pos-wid*.5, 0, stgBack>, <pos+wid*.5, stgAlt, 0> }
			plane { <0, -stgBack, stgAlt+stgStep>, 0 translate y*.3 }
		}
		matrix < 
		   1.000, 0.0, 0.0,
		   0.0,   1.0, 0.0,
		   shift, 0.0, 1.000,
  		 0.0,   0.0, -10.0
		>
	}
#end

#declare stgStairs = union {
	stgOutSteps(-65, 9.6,-stgStairShear )
	stgOutSteps( 65, 9.6, stgStairShear )
	texture { StageCol }
}

// Railing
#declare stgStile = sor { 21, 
	< 0.40,-0.10 >, < 0.30, 0.00 >, < 0.20, 0.35 >, < 0.45, 0.40 >, < 0.20, 0.45 >, 
	< 0.25, 1.40 >, < 0.20, 2.35 >, < 0.45, 2.40 >, < 0.20, 2.45 >, < 0.25, 3.40 >, 
	< 0.20, 4.35 >, < 0.45, 4.40 >, < 0.20, 4.45 >, < 0.25, 5.40 >, < 0.20, 6.35 >, 
	< 0.45, 6.40 >, < 0.20, 6.45 >, < 0.25, 7.40 >, < 0.20, 8.35 >, < 0.30, 8.70 >, 
	< 0.40, 8.80 >//, < 0.25, 9.40 >, < 0.20,10.35 >, < 0.30,10.70 >, < 0.40,10.80 >
}

#macro stgStairStileSet(pos, wid, shift)
	#local alt = 1;
	#local cnt = pos;
	#local dep = -10.3;
	#while (alt<=stgStairNum)
		object { stgStile translate <cnt-wid*.5, alt*stgStep, dep> }
		object { stgStile translate <cnt+wid*.5, alt*stgStep, dep> }
		#local alt = alt + 1;
		#local dep = dep - stgStairWid;
		#local cnt = cnt - shift*stgStairWid;
	#end
#end

#macro stgStairRail(pos,dep)
	box { <pos-.25, 0, dep>, <pos+.25, .5, 0> }
	box { <pos-.15, .5, dep>, <pos+.15, .6, 0> }
	cylinder { <pos-.15, .5, dep>, <pos-.15, .5, 0>, .1 }
	cylinder { <pos+.15, .5, dep>, <pos+.15, .5, 0>, .1 }
#end

#macro stgStairRailSet(pos, wid, shift)
	union {
		stgStairRail(pos-wid*.5,-stgStairWid*stgStairNum)
		stgStairRail(pos+wid*.5,-stgStairWid*stgStairNum)
		matrix <
			1.0, 0.0, 0.0,
			0.0, 1.0, 0.0,
			shift, -stgStep/stgStairWid, 1.0,
			0.0, 8.2+stgStep, -9
		>
	}
#end

#macro stgCirRail(wid,alt)
	intersection {
		union {
			difference {
				cylinder { y* 0, y*.5, wid+.5 }
				cylinder { y*-1, y*.6, wid }
			}
			difference {
				cylinder { y*.5, y*.6, wid+.4 }
				cylinder { y*.4, y*.7, wid+.1 }
			}
			torus { wid+.1, .1 translate y*.5 }
			torus { wid+.4, .1 translate y*.5 }
			translate < 0, alt, 0 >
		}
		plane { z, -stgCut }
	}
#end

#macro stgRail(wid,alt)
	union {
		box { <-wid*.5, alt, 0 >, < wid*.5, alt+.5, .5> }
		box { <-wid*.5, alt+.5, .1 >, < wid*.5, alt+.6, .4> }
		cylinder { <-wid*.5, alt+.5, .1>, < wid*.5, alt+.5, .1>, .1 }
		cylinder { <-wid*.5, alt+.5, .4>, < wid*.5, alt+.5, .4>, .1 }
	}
#end

#macro stgStileSet(wid, alt)
	stgRail(wid, alt)
	stgRail(wid, 9.2+alt)
	object { stgStile translate <0, alt+.5, .25> }
	#local dst = 3;
	#local i = dst;
	#while (i<wid*.5)
		 object { stgStile translate < i, alt+.5, .25> }
		 object { stgStile translate <-i, alt+.5, .25> }
		 #local i = i + dst;
	#end
#end

#macro stgCirStileSet(wid, alt)
	stgCirRail(wid, alt)
	stgCirRail(wid, 9.2+alt)
	object { stgStile translate <0, alt+.5, -wid-.25> }
	#local ang = 3/(wid+.25);
	#local i = ang;
	#while (cos(i)*wid>stgCut)
		 object { stgStile translate <0, alt+.5, -wid-.25> rotate y*degrees(i) }
		 object { stgStile translate <0, alt+.5, -wid-.25> rotate -y*degrees(i) }
		 #local i = i + ang;
	#end
#end

#declare stgRailing = union {
	stgCirStileSet( stgRad0, -stgStep*4 )
	stgCirStileSet( stgRad1, -stgStep*2 )
	stgCirStileSet( stgRad2, 0 )
	union { stgStileSet( 60-stgWid2, 0 ) translate < 30+stgWid2*.5,0,-10.5-stgPos> }
	union { stgStileSet( 60-stgWid2, 0 ) translate <-30-stgWid2*.5,0,-10.5-stgPos> }
	translate z*stgPos
	texture { stgRailCol }
}

#declare stgOutRail = union {
	union { stgCirStileSet( stgRad0, 0 ) scale <1, 1, -1> translate z*-stgCut }
	union { stgStileSet( stgWid3, 0 ) translate x*stgPos2 }
	union { stgStileSet( stgWid3, 0 ) translate -x*stgPos2 }
	stgStairStileSet(-65, 9.0,-stgStairShear )
	stgStairStileSet( 65, 9.0, stgStairShear )
	stgStairRailSet(-65, 9.0,-stgStairShear )
	stgStairRailSet( 65, 9.0, stgStairShear )
	texture { stgRailCol }
}

#declare Floor = difference {
	box { <-70, -stgStep*8, 0>, <70, .01, 200> }
	cylinder { <0, -stgStep*9, -stgCut>, <0, stgStep, -stgCut>, stgRad0 }
	plane { -y, 0 texture { FloorCol } }
	texture { StageCol }
}

#declare Stage = union {
	box { <-70, 0, -70>, <70, stgAlt, stgBack> texture { StageCol } }
	object { stgStairs }
	object { stgPlatform }
	object { stgOutRail }
	object { stgRailing }
}

// Main hall
#declare WallBrace = union {
	difference {
		box { < 0, 0, -0.8 >, < 1, 40, 0.8 > }
		cylinder { <0.5, -1,-0.8>, <0.5, 41,-0.8>, .6 scale <2, 1, 1> }
		cylinder { <0.5, -1, 0.8>, <0.5, 41, 0.8>, .6 scale <2, 1, 1> }
	}
	cylinder { <1.0, -1, 0.0>, <1.0, 41, 0.0>, .2 }
}

#declare wBraceSet = union {
	ObjLine( WallBrace, z*-24.7, z*4, 13 )
	ObjLine( WallBrace, z*-23.3, z*4, 13 )
}

#declare Arch = quadric { <0, 0, 0.5>, <0, 0, 0>, <-2, 1, 0>, 0 }

#declare SideWall = union {
	difference {
		box { <-72, 0, -70>, <-71, 40, 200> }
		object { Arch translate <-71, 39,  64.0> }
		object { Arch translate <-71, 39, 136.0> }
	}
	box { <-72, -stgStep*8, -70>, <-70, 0, 200 > }
	ObjLine( box { < 0.4, 0,-10>, < 0.6, 40, 10> texture { StainGlass } }, <-72, 0,  62.5>, z*75, 2 )
	ObjLine( wBraceSet, <-71, 0, 27>, z*73, 3 )
	texture { WallTex }
}

#macro xRoof0(i) ((i+35)/7) #end
#macro yRoof(i) (15*(i/36+1)*(i/36+1)*(i/36+1)+55) #end
#macro mRoof(i) (5e5*(yRoof(i+1e-6)-yRoof(i-1e-6))) #end

#macro rLin(i,j) 
	function { j-15*(i/36+1)*(i/36+1)*(i/36+1)-55 }
#end

#macro rCut(i,j) 
	function { -j+15*(i/36+1)*(i/36+1)*(i/36+1)+53 }
#end

#macro Iso(fnc)
	isosurface {
		fnc(x,y)
		eval <1.5, 4, .95>
		max_trace 4
		contained_by { box { <-72, 40, -.5>, <0, 70, .5> } }
		threshold 0
	}
#end

#declare RoofLine = isosurface {
	function { y-15*cub(1-abs(x)/36)-55 }
	eval <1.5, 4, .95>
	max_trace 4
	contained_by { box { <-72, 40, -.5>, <72, 70, .5> } }
	threshold 0
}

#declare BraceTop = isosurface {
	function { (-y+15*cub(1-abs(x)/36)+53) & (y-15*cub(1-abs(x)/36)-55) }
	eval <1.5, 4, .95>
	max_trace 4
	contained_by { box { <-72, 40, -.5>, <72, 70, .5> } }
	threshold 0
}

#declare BackWall = union {
	box { <-72, -stgStep*8, -.5>, <72, 40, .5> }
	object { RoofLine }
	texture { WallTex }
}

#declare RoofSlat = intersection {
	box { <-1, -.3, -70>, <1, .3, 200> }
	plane { < 1, 1, 0 >, 0 translate < 0.9, 0.25, 0 > }
	plane { < 1,-1, 0 >, 0 translate < 0.9,-0.25, 0 > }
	plane { <-1, 1, 0 >, 0 translate <-0.9, 0.25, 0 > }
	plane { <-1,-1, 0 >, 0 translate <-0.9,-0.25, 0 > }
}

#declare RoofSlats = union {
	#local xp = -71.5;
	#while (xp<0.5)
		#local yp = yRoof(xp);
		#local ang = atan2(mRoof(xp),1);
		object { RoofSlat rotate z*degrees(ang) translate <xp, yp, 0> }
		#local xp = xp + (1*cos(ang)+.3*sin(ang))*1.53;
	#end
	//object { RoofSlat translate y*68 }
	texture { RoofTex }
}

#declare BraceDiag = intersection {
	box { <0, 0, -.5>, <2, 24, 0.5> rotate z*-45 }
	plane { -y, 0 }
	translate <0.5, 40, 0>
}

#declare RoofBrace = union {
	box { <-71, 0, -.5>, <-70, 40, 0.5> }
	box { < 70, 0, -.5>, < 71, 40, 0.5> }
	box { <-71, 38, -.5>, <71, 40, 0.5> }
	object { BraceTop }
	object { BraceDiag }
	object { BraceDiag rotate y*180 }
	object { BraceDiag translate x*-37 }
	object { BraceDiag translate x*-37 rotate y*180 }
	//bounded_by { box { <-71, 0, -.5>, <71, 70, 0.5> } }
	texture { RoofTex }
}

#declare Room = union {
	object { RoofSlats }
	object { RoofSlats scale <-1, 1, 1> }
	object { RoofBrace translate z*-69.0 }
	object { RoofBrace translate z*-20.0 }
	object { RoofBrace translate z*  1.0 }
	object { RoofBrace translate z* 53.0 }
	object { RoofBrace translate z* 74.0 }
	object { RoofBrace translate z*126.0 }
	object { RoofBrace translate z*147.0 }
	object { RoofBrace translate z*199.0 }
	object { SideWall }
	object { SideWall scale <-1, 1, 1> }
	object { BackWall translate z* -70 }
	object { BackWall translate z* 200 }
	object { Floor }
}
