//***************************************************
// Interspersion macro ver 0.1r001217a include file
// Persistence Of Vision raytracer version 3.1g
// By S.Nishimura
//***************************************************


//**********************************************************************************
//#macro Locus_function(Mv,Mh,Func_type)
// #switch (Func_type)
//  #case(0) #local Mv=radians(90); #local Mh=6/5*cos(Sp)+1-sin(Sp); #break
//  #case(1) #local Mv=1/2*Sp; #local Mh=radians(0); #break
//  #case(2) #local Mv=radians(90); #local Mh=-1/2*pow(Sp,2); #break
// #end
//#end
//----------------------------------------------------------------------------------
// locuse of uniform velocity motion
#macro Uvm_locus(P0,Lr,Func_type)
 #local Sp=-pi; #local Ep=pi; #local Ap=pi/8; #local Mv=0; #local Mh=0;
 #while(Sp<Ep)
  Locus_function(Mv,Mh,Func_type)
 #local Tf=transform { rotate(90-degrees(Mv))*z rotate(-degrees(Mh))*y translate P0 }
//#if(mod(Sp,Ap*2)=0) object { Obj_seg rotate -45*x transform Tf } #else object { Obj_seg rotate 45*x transform Tf } #end
 #if(mod(Sp,Ap*2)=0) object { Locus_seg01 transform Tf } #else object { Locus_seg02 transform Tf } #end
// next stage value
 #local P0=P0+<Lr*sin(Mv)*cos(Mh),Lr*cos(Mv),Lr*sin(Mv)*sin(Mh)>; // polar coordinates
 #local Sp=Sp+Ap;
#end // while end
#end // macro end
//**********************************************************************************
//**********************************************************************************
#macro Regular_interval(Tf_type,P0,Lr,Pr,Func_type)
 #local Sp=Pr.x; #local Ep=Pr.y; #local Ap=Pr.z;
#while(Sp<Ep)
 #switch (Func_type)
  #case(0) #local Mv=radians(90);#local Mh=radians(0);#break
  #case(1) #local Mv= Sp+pi/2; #local Mh=radians(90); #break
  #case(2) #local Mv=-Sp+pi/2; #local Mh=radians(90); #break
  #case(3) #local Mv=0;        #local Mh= Sp+pi/2;    #break
  #case(4) #local Mv=0;        #local Mh=-Sp+pi/2;    #break
  #case(5) #local Mv=radians( 0); #local Mh=Sp/2+pi; #break
  #case(6) #local Mv=radians(90); #local Mh= 1/4*Sp; #break
  #case(7) #local Mv=radians(90); #local Mh=-1/4*Sp; #break
 #end
//
 #switch (Tf_type)
  #case(0) #local Tf=transform { translate P0 } #break // Position
  #case(1) #local Tf=transform { rotate(-degrees(Mh))*y translate P0 } #break // Succession
  #case(2) #local Tf=transform { rotate(degrees(Mv))*z rotate(-degrees(Mh))*y translate P0 } #break // Interspersion
 #end
//
object { Obj_seg transform Tf }
//
 #local P0=P0+<Lr*cos(Mv)*cos(Mh),Lr*sin(Mv),Lr*cos(Mv)*sin(Mh)>; // Spherical coordinates
 #local Sp=Sp+Ap;
#end // while end
#end // macro end
//----------------------------------------------------------------------------------
// Interspersion 
#macro Interspersion(Tf_type,Pstart,Lr,Prange,Func_type)
 #local P0=Pstart; #local Pr=Prange;
 Regular_interval(Tf_type,P0,Lr,Pr,Func_type)
#end // macro end
//**********************************************************************************