//***************************************************
// Normal vector macro ver 0.2r001223a include file
// Persistence Of Vision raytracer version 3.1g
// By S.Nishimura
//***************************************************


//**********************************************************************************
#macro Spherical_coordinates(Vp,RR,HH,VV)
 #local RR=vlength(Vp); #local Rh=vlength(<Vp.x,0,Vp.z>);
 #if(Rh!=0) 
  #if(Vp.z/Rh>=0) #local Sg=1; #else #local Sg=-1; #end
  #local HH=Sg*acos(Vp.x/Rh);
 #else #local HH=0; #end
 #if(Vp.y/RR>=0) #local Sg=1; #else #local Sg=-1; #end 
 #local VV=Sg*acos(Rh/RR);
#end
//----------------------------------------------------------------------------------
#macro Normal_vector(Tp1,Tp2,Tp3,Vn)
 #local Va=Tp3-Tp2; #local Vb=Tp2-Tp1;
 #local Lx=Va.y*Vb.z-Va.z*Vb.y; #local My=Va.z*Vb.x-Va.x*Vb.z; #local Nz=Va.x*Vb.y-Va.y*Vb.x;
 #local Dc=-Tp1.x*Lx-Tp1.y*My-Tp1.z*Nz;
 #if(Dc>=0) #local Sg=1; #else #local Sg=-1; #end
 #local Vn=<-Lx*Sg,-My*Sg,-Nz*Sg>;
#end
//**********************************************************************************
//--------------------------- sample functions -------------------------------------
/*
#macro Surface_function(Ss,Se,Px,Py,Pz,Func_type)
 #switch(Func_type)
 #case(0) #local Px=Ss; #local Pz=Se; 
          #local Rp=pow(6,2)-pow(Px,2)-pow(Pz,2);
          #if(Rp>0) #local Py=sqrt(Rp); #else #local Py=-sqrt(abs(Rp)); #end #break
 
 #case(1) #local Rp=pow(Se,2)+3;
          #local Px=5*Se*cos(Ss); #local Py=3*sqrt(Rp); #local Pz=5*Se*sin(Ss); #break
 
 #case(2) #local Pr=6;
          #local Px=Pr*cos(Se)*cos(Ss); #local Py=Pr*sin(Se); #local Pz=Pr*cos(Se)*sin(Ss); #break
 
 #case(3) #local Rr=6;
          #local Px=Rr*sin(Se)*cos(Ss); #local Py=Rr*cos(Se); #local Pz=Rr*sin(Se)*sin(Ss); #break
 #end
#end
*/
//--------------------------- sample objects ----------------------------------------
/*
#local Obj_seg = cylinder { 0,<6,0,0>, 0.2 }
#local Obj_seg = torus { 3, 0.2 rotate -90*x clipped_by { plane { y,0 rotate 180*z } } clipped_by { plane { x,0 rotate 180*y } } }
*/
//--------------------------- sample parameters ------------------------------------
/*
object { Normal_tri2u(<pi*-2,pi*2,pi/4 >,<pi*-2,pi*2,pi/4 >,0)
object { Normal_tri4u(<pi*-1,pi*1,pi/8 >,<0,pi/2,pi/8 >,1)
object { Normal_tri2u(<pi*-1,pi*1,pi/16>,<0,pi/2,pi/16>,2)
object { Normal_tri4u(<pi*-1,pi*1,pi/16>,<0,pi/2,pi/16>,3)
*/
//**********************************************************************************
#macro Normal_tri4u(Vs,Ve,Func_type) // normal obj set
 #local Px=0; #local Py=0; #local Pz=0;
 union {
 #local Se=Ve.x; #local Ee=Ve.y; #local Ae=Ve.z;
 #while(Se<Ee)
  #local Ss=Vs.x; #local Es=Vs.y; #local As=Vs.z;
  #while(Ss<Es)
   Surface_function(Ss-As/2,Se-Ae/2,Px,Py,Pz,Func_type) #local Pd11=< Px, Py, Pz >;   
   Surface_function(Ss-As/2,Se+Ae/2,Px,Py,Pz,Func_type) #local Pd12=< Px, Py, Pz >;  
   Surface_function(Ss+As/2,Se+Ae/2,Px,Py,Pz,Func_type) #local Pd22=< Px, Py, Pz >;   
   Surface_function(Ss+As/2,Se-Ae/2,Px,Py,Pz,Func_type) #local Pd21=< Px, Py, Pz >;
   Surface_function(Ss     ,Se     ,Px,Py,Pz,Func_type) #local Pd00=< Px, Py, Pz >;
   //triangle { Pd11, Pd12, Pd00 }
   #local Vn=<0,0,0>; Normal_vector(Pd11, Pd12, Pd00, Vn)
   #local RR=0; #local HH=0; #local VV=0; Spherical_coordinates(Vn,RR,HH,VV)
   #local Tf=transform { rotate degrees(VV)*z rotate -degrees(HH)*y }
   object { Obj_seg  transform Tf translate Pd11 }
   //object { Obj_seg  transform Tf translate Pd12 }
   object { Obj_seg  transform Tf translate Pd00 }
   //triangle { Pd12, Pd22, Pd00 }
   Normal_vector(Pd12, Pd22, Pd00, Vn)
   Spherical_coordinates(Vn,RR,HH,VV)
   #local Tf=transform { rotate degrees(VV)*z rotate -degrees(HH)*y }
   object { Obj_seg  transform Tf translate Pd12 }
   //object { Obj_seg  transform Tf translate Pd22 }
   //object { Obj_seg  transform Tf translate Pd00 }
   //triangle { Pd22, Pd21, Pd00 }
   Normal_vector(Pd22, Pd21, Pd00, Vn)
   Spherical_coordinates(Vn,RR,HH,VV)
   #local Tf=transform { rotate degrees(VV)*z rotate -degrees(HH)*y }
   object { Obj_seg  transform Tf translate Pd22 }
   //object { Obj_seg  transform Tf translate Pd21 }
   object { Obj_seg  transform Tf translate Pd00 }
   //triangle { Pd21, Pd11, Pd00 }
   Normal_vector(Pd21, Pd11, Pd00, Vn)
   Spherical_coordinates(Vn,RR,HH,VV)
   #local Tf=transform { rotate degrees(VV)*z rotate -degrees(HH)*y }
   object { Obj_seg  transform Tf translate Pd21 }
   //object { Obj_seg  transform Tf translate Pd11 }
   //object { Obj_seg  transform Tf translate Pd00 } 
   #local Ss=Ss+As;
  #end
  #local Se=Se+Ae;
 #end
 }
#end // macro end
//**********************************************************************************
#macro Surface_tri4m(Vs,Ve,Func_type) // mesh data set
 #local Px=0; #local Py=0; #local Pz=0;
 mesh {
 #local Se=Ve.x; #local Ee=Ve.y; #local Ae=Ve.z;
 #while(Se<Ee)
  #local Ss=Vs.x; #local Es=Vs.y; #local As=Vs.z;
  #while(Ss<Es)
   Surface_function(Ss-As/2,Se-Ae/2,Px,Py,Pz,Func_type) #local Pd11=< Px, Py, Pz >;   
   Surface_function(Ss-As/2,Se+Ae/2,Px,Py,Pz,Func_type) #local Pd12=< Px, Py, Pz >;  
   Surface_function(Ss+As/2,Se+Ae/2,Px,Py,Pz,Func_type) #local Pd22=< Px, Py, Pz >;   
   Surface_function(Ss+As/2,Se-Ae/2,Px,Py,Pz,Func_type) #local Pd21=< Px, Py, Pz >;
   Surface_function(Ss     ,Se     ,Px,Py,Pz,Func_type) #local Pd00=< Px, Py, Pz >;
   triangle { Pd11, Pd12, Pd00 }
   triangle { Pd12, Pd22, Pd00 }
   triangle { Pd22, Pd21, Pd00 }
   triangle { Pd21, Pd11, Pd00 } 
   #local Ss=Ss+As;
  #end
  #local Se=Se+Ae;
 #end
 }
#end // macro end
//**********************************************************************************
#macro Smooth_tri4m(Vs,Ve,Func_type)
 #local Smax=8; #local Pmax=4; #local Snv=array[Pmax][Smax]
 #local i=0; #while(i<Pmax) #local j=0; #while(j<Smax) #local Snv[i][j]=<0,0,0>; #local j=j+1; #end #local i=i+1; #end
 #local Px=0; #local Py=0; #local Pz=0; #local Vn=<0,0,0>;
 mesh {
 #local Se=Ve.x; #local Ee=Ve.y; #local Ae=Ve.z;
 #while(Se<Ee)
  #local Ss=Vs.x; #local Es=Vs.y; #local As=Vs.z;
  #while(Ss<Es)
   Surface_function(Ss-As/2,Se-Ae/2,Px,Py,Pz,Func_type) #local Pd11=< Px, Py, Pz >;   
   Surface_function(Ss-As/2,Se+Ae/2,Px,Py,Pz,Func_type) #local Pd12=< Px, Py, Pz >;  
   Surface_function(Ss+As/2,Se+Ae/2,Px,Py,Pz,Func_type) #local Pd22=< Px, Py, Pz >;   
   Surface_function(Ss+As/2,Se-Ae/2,Px,Py,Pz,Func_type) #local Pd21=< Px, Py, Pz >;
   Surface_function(Ss     ,Se     ,Px,Py,Pz,Func_type) #local Pd00=< Px, Py, Pz >;
   // Pd11
   Surface_function(Ss-As/2,   Se-Ae*3/2, Px,Py,Pz,Func_type) #local Pd01=< Px, Py, Pz >;
   Surface_function(Ss-As,     Se-Ae,     Px,Py,Pz,Func_type) #local Pd02=< Px, Py, Pz >;
   Surface_function(Ss-As*3/2, Se-Ae/2,   Px,Py,Pz,Func_type) #local Pd03=< Px, Py, Pz >;
   Surface_function(Ss-As,     Se,        Px,Py,Pz,Func_type) #local Pd04=< Px, Py, Pz >;
   Surface_function(Ss,        Se-Ae,     Px,Py,Pz,Func_type) #local Pd08=< Px, Py, Pz >;
   Normal_vector(Pd01, Pd02, Pd11, Vn) #local Snv[0][0]=Vn;
   Normal_vector(Pd02, Pd03, Pd11, Vn) #local Snv[0][1]=Vn;
   Normal_vector(Pd03, Pd04, Pd11, Vn) #local Snv[0][2]=Vn;
   Normal_vector(Pd04, Pd12, Pd11, Vn) #local Snv[0][3]=Vn;
   Normal_vector(Pd12, Pd00, Pd11, Vn) #local Snv[0][4]=Vn;
   Normal_vector(Pd00, Pd21, Pd11, Vn) #local Snv[0][5]=Vn;
   Normal_vector(Pd21, Pd08, Pd11, Vn) #local Snv[0][6]=Vn;
   Normal_vector(Pd08, Pd01, Pd11, Vn) #local Snv[0][7]=Vn;
   #local Nv11=(Snv[0][0]+Snv[0][1]+Snv[0][2]+Snv[0][3]+Snv[0][4]+Snv[0][5]+Snv[0][6]+Snv[0][7]);
   // Pd12
   #local Pd02=Pd04;
   Surface_function(Ss-As*3/2, Se+Ae/2,   Px,Py,Pz,Func_type) #local Pd03=< Px, Py, Pz >;
   Surface_function(Ss-As,     Se+Ae,     Px,Py,Pz,Func_type) #local Pd04=< Px, Py, Pz >;
   Surface_function(Ss-As/2,   Se+Ae*3/2, Px,Py,Pz,Func_type) #local Pd05=< Px, Py, Pz >;
   Surface_function(Ss,        Se+Ae,     Px,Py,Pz,Func_type) #local Pd06=< Px, Py, Pz >;
   #local Snv[1][0]=Snv[0][3];
   Normal_vector(Pd02, Pd03, Pd12, Vn) #local Snv[1][1]=Vn;
   Normal_vector(Pd03, Pd04, Pd12, Vn) #local Snv[1][2]=Vn;
   Normal_vector(Pd04, Pd05, Pd12, Vn) #local Snv[1][3]=Vn;
   Normal_vector(Pd05, Pd06, Pd12, Vn) #local Snv[1][4]=Vn;
   Normal_vector(Pd06, Pd22, Pd12, Vn) #local Snv[1][5]=Vn;
   Normal_vector(Pd22, Pd00, Pd12, Vn) #local Snv[1][6]=Vn;
   #local Snv[1][7]=Snv[0][4];
   #local Nv12=(Snv[1][0]+Snv[1][1]+Snv[1][2]+Snv[1][3]+Snv[1][4]+Snv[1][5]+Snv[1][6]+Snv[1][7]);
   // Pd22
   #local Pd04=Pd06;
   Surface_function(Ss+As/2,   Se+Ae*3/2, Px,Py,Pz,Func_type) #local Pd05=< Px, Py, Pz >;
   Surface_function(Ss+As,     Se+Ae,     Px,Py,Pz,Func_type) #local Pd06=< Px, Py, Pz >;
   Surface_function(Ss+As*3/2, Se+Ae/2,   Px,Py,Pz,Func_type) #local Pd07=< Px, Py, Pz >;
   Surface_function(Ss+As,     Se,        Px,Py,Pz,Func_type) #local Pd08=< Px, Py, Pz >;
   Normal_vector(Pd21, Pd00, Pd22, Vn) #local Snv[2][0]=Vn;
   #local Snv[2][1]=Snv[1][6];
   #local Snv[2][2]=Snv[1][5];
   Normal_vector(Pd04, Pd05, Pd22, Vn) #local Snv[2][3]=Vn;
   Normal_vector(Pd05, Pd06, Pd22, Vn) #local Snv[2][4]=Vn;
   Normal_vector(Pd06, Pd07, Pd22, Vn) #local Snv[2][5]=Vn;
   Normal_vector(Pd07, Pd08, Pd22, Vn) #local Snv[2][6]=Vn;
   Normal_vector(Pd08, Pd11, Pd22, Vn) #local Snv[2][7]=Vn;
   #local Nv22=(Snv[2][0]+Snv[2][1]+Snv[2][2]+Snv[2][3]+Snv[2][4]+Snv[2][5]+Snv[2][6]+Snv[2][7]);
   // Pd21
   Surface_function(Ss+As/2,   Se-Ae*3/2, Px,Py,Pz,Func_type) #local Pd01=< Px, Py, Pz >;
   Surface_function(Ss,        Se-Ae,     Px,Py,Pz,Func_type) #local Pd02=< Px, Py, Pz >;
   #local Pd06=Pd08;   
   Surface_function(Ss+As*3/2, Se-Ae/2,   Px,Py,Pz,Func_type) #local Pd07=< Px, Py, Pz >;
   Surface_function(Ss+As,     Se-Ae,     Px,Py,Pz,Func_type) #local Pd08=< Px, Py, Pz >;
   Normal_vector(Pd01, Pd02, Pd21, Vn) #local Snv[3][0]=Vn;
   #local Snv[3][1]=Snv[0][6];
   #local Snv[3][2]=Snv[0][5];
   #local Snv[3][3]=Snv[2][0];
   #local Snv[3][4]=Snv[2][7];
   Normal_vector(Pd06, Pd07, Pd21, Vn) #local Snv[3][5]=Vn;
   Normal_vector(Pd07, Pd08, Pd21, Vn) #local Snv[3][6]=Vn;
   Normal_vector(Pd08, Pd01, Pd21, Vn) #local Snv[3][7]=Vn;
   #local Nv21=(Snv[3][0]+Snv[3][1]+Snv[3][2]+Snv[3][3]+Snv[3][4]+Snv[3][5]+Snv[3][6]+Snv[3][7]);
   // Pd00
   #local Nv00=(Snv[0][4]+Snv[1][6]+Snv[2][0]+Snv[3][2]);
   //
   smooth_triangle { Pd11,Nv11, Pd12,Nv12, Pd00,Nv00 }
   smooth_triangle { Pd12,Nv12, Pd22,Nv22, Pd00,Nv00 }
   smooth_triangle { Pd22,Nv22, Pd21,Nv21, Pd00,Nv00 }
   smooth_triangle { Pd21,Nv21, Pd11,Nv11, Pd00,Nv00 } 
   #local Ss=Ss+As;
  #end
  #local Se=Se+Ae;
 #end
 }
#end // macro end
//**********************************************************************************
//**********************************************************************************
#macro Normal_tri2u(Vs,Ve,Func_type) // normal obj set
 #local Px=0; #local Py=0; #local Pz=0;
 union {
 #local Se=Ve.x; #local Ee=Ve.y; #local Ae=Ve.z;
 #while(Se<Ee)
  #local Ss=Vs.x; #local Es=Vs.y; #local As=Vs.z;
  #while(Ss<Es)
   Surface_function(Ss,     Se,     Px,Py,Pz,Func_type) #local Pd11=< Px, Py, Pz >;   
   Surface_function(Ss,     Se+Ae,  Px,Py,Pz,Func_type) #local Pd12=< Px, Py, Pz >;  
   Surface_function(Ss+As,  Se+Ae,  Px,Py,Pz,Func_type) #local Pd22=< Px, Py, Pz >;    
   Surface_function(Ss+As,  Se   ,  Px,Py,Pz,Func_type) #local Pd21=< Px, Py, Pz >;
   //triangle { Pd11, Pd12, Pd22 }
   #local Vn=<0,0,0>; Normal_vector(Pd11, Pd12, Pd22, Vn)
   #local RR=0; #local HH=0; #local VV=0; Spherical_coordinates(Vn,RR,HH,VV)
   #local Tf=transform { rotate degrees(VV)*z rotate -degrees(HH)*y }
   //object { Obj_seg  transform Tf translate Pd11 }
   object { Obj_seg  transform Tf translate Pd12 }
   //object { Obj_seg  transform Tf translate Pd22 }
   //triangle { Pd11, Pd21, Pd22 }
   Normal_vector(Pd11, Pd22, Pd21, Vn)
   Spherical_coordinates(Vn,RR,HH,VV)
   #local Tf=transform { rotate degrees(VV)*z rotate -degrees(HH)*y }
   //object { Obj_seg  transform Tf translate Pd11 }
   //object { Obj_seg  transform Tf translate Pd22 }
   object { Obj_seg  transform Tf translate Pd21 }
   #local Ss=Ss+As;
  #end
  #local Se=Se+Ae;
 #end
 }
#end // macro end
//**********************************************************************************
#macro Surface_tri2m(Vs,Ve,Func_type) // mesh data set
 #local Px=0; #local Py=0; #local Pz=0;
 mesh {
 #local Se=Ve.x; #local Ee=Ve.y; #local Ae=Ve.z;
 #while(Se<Ee)
  #local Ss=Vs.x; #local Es=Vs.y; #local As=Vs.z;
  #while(Ss<Es)
   Surface_function(Ss,     Se,     Px,Py,Pz,Func_type) #local Pd11=< Px, Py, Pz >;   
   Surface_function(Ss,     Se+Ae,  Px,Py,Pz,Func_type) #local Pd12=< Px, Py, Pz >;  
   Surface_function(Ss+As,  Se+Ae,  Px,Py,Pz,Func_type) #local Pd22=< Px, Py, Pz >;    
   Surface_function(Ss+As,  Se   ,  Px,Py,Pz,Func_type) #local Pd21=< Px, Py, Pz >;
   triangle { Pd11, Pd12, Pd22 }
   triangle { Pd11, Pd21, Pd22 }
   #local Ss=Ss+As;
  #end
  #local Se=Se+Ae;
 #end
 }
#end // macro end
//**********************************************************************************
#macro Smooth_tri2m(Vs,Ve,Func_type)
 #local Smax=6; #local Pmax=4; #local Snv=array[Pmax][Smax]
 #local i=0; #while(i<Pmax) #local j=0; #while(j<Smax) #local Snv[i][j]=<0,0,0>; #local j=j+1; #end #local i=i+1; #end
 #local Px=0; #local Py=0; #local Pz=0; #local Vn=<0,0,0>;
 mesh {
 #local Se=Ve.x; #local Ee=Ve.y; #local Ae=Ve.z;
 #while(Se<Ee)
  #local Ss=Vs.x; #local Es=Vs.y; #local As=Vs.z;
  #while(Ss<Es)
   Surface_function(Ss,     Se,     Px,Py,Pz,Func_type) #local Pd11=< Px, Py, Pz >;
   Surface_function(Ss,     Se+Ae,  Px,Py,Pz,Func_type) #local Pd12=< Px, Py, Pz >;  
   Surface_function(Ss+As,  Se+Ae,  Px,Py,Pz,Func_type) #local Pd22=< Px, Py, Pz >;    
   Surface_function(Ss+As,  Se   ,  Px,Py,Pz,Func_type) #local Pd21=< Px, Py, Pz >;
   // Pd11
   Surface_function(Ss,    Se-Ae, Px,Py,Pz,Func_type) #local Pd01=< Px, Py, Pz >;
   Surface_function(Ss-As, Se-Ae, Px,Py,Pz,Func_type) #local Pd02=< Px, Py, Pz >;
   Surface_function(Ss-As, Se,    Px,Py,Pz,Func_type) #local Pd03=< Px, Py, Pz >;
   Normal_vector(Pd02, Pd11, Pd01, Vn) #local Snv[0][0]=Vn;
   Normal_vector(Pd02, Pd03, Pd11, Vn) #local Snv[0][1]=Vn;
   Normal_vector(Pd03, Pd12, Pd11, Vn) #local Snv[0][2]=Vn;
   Normal_vector(Pd11, Pd12, Pd22, Vn) #local Snv[0][3]=Vn;
   Normal_vector(Pd11, Pd22, Pd21, Vn) #local Snv[0][4]=Vn;
   Normal_vector(Pd01, Pd11, Pd21, Vn) #local Snv[0][5]=Vn;
   #local Nv11=(Snv[0][0]+Snv[0][1]+Snv[0][2]+Snv[0][3]+Snv[0][4]+Snv[0][5])/Smax;
   // Pd12
   #local Pd02=Pd03;
   Surface_function(Ss-As, Se+Ae,   Px,Py,Pz,Func_type) #local Pd03=< Px, Py, Pz >;
   Surface_function(Ss   , Se+Ae*2, Px,Py,Pz,Func_type) #local Pd04=< Px, Py, Pz >;
   Surface_function(Ss+As, Se+Ae*2, Px,Py,Pz,Func_type) #local Pd05=< Px, Py, Pz >;
   #local Snv[1][0]=Snv[0][2];
   Normal_vector(Pd02, Pd03, Pd12, Vn) #local Snv[1][1]=Vn;
   Normal_vector(Pd03, Pd04, Pd12, Vn) #local Snv[1][2]=Vn;
   Normal_vector(Pd12, Pd04, Pd05, Vn) #local Snv[1][3]=Vn;
   Normal_vector(Pd12, Pd05, Pd22, Vn) #local Snv[1][4]=Vn;
   #local Snv[1][5]=Snv[0][3];
   #local Nv12=(Snv[1][0]+Snv[1][1]+Snv[1][2]+Snv[1][3]+Snv[1][4]+Snv[1][5])/Smax;
   // Pd22
   #local Pd04=Pd05;
   Surface_function(Ss+As*2, Se+Ae*2, Px,Py,Pz,Func_type) #local Pd05=< Px, Py, Pz >;
   Surface_function(Ss+As*2, Se+Ae  , Px,Py,Pz,Func_type) #local Pd06=< Px, Py, Pz >;
   #local Snv[2][0]=Snv[0][4];
   #local Snv[2][1]=Snv[0][3];
   #local Snv[2][2]=Snv[1][4];
   Normal_vector(Pd22, Pd04, Pd05, Vn) #local Snv[2][3]=Vn;
   Normal_vector(Pd22, Pd05, Pd06, Vn) #local Snv[2][4]=Vn;
   Normal_vector(Pd21, Pd22, Pd06, Vn) #local Snv[2][5]=Vn;
   #local Nv22=(Snv[2][0]+Snv[2][1]+Snv[2][2]+Snv[2][3]+Snv[2][4]+Snv[2][5])/Smax;
   // Pd21
   Surface_function(Ss+As, Se-Ae, Px,Py,Pz,Func_type) #local Pd01=< Px, Py, Pz >;
   Surface_function(Ss   , Se-Ae, Px,Py,Pz,Func_type) #local Pd02=< Px, Py, Pz >;
   #local Pd05=Pd06;
   Surface_function(Ss+As*2, Se,  Px,Py,Pz,Func_type) #local Pd06=< Px, Py, Pz >;
   Normal_vector(Pd02, Pd21, Pd01, Vn) #local Snv[3][0]=Vn;
   #local Snv[3][1]=Snv[0][5];
   #local Snv[3][2]=Snv[0][4];
   #local Snv[3][3]=Snv[2][5];
   Normal_vector(Pd21, Pd05, Pd06, Vn) #local Snv[3][4]=Vn;
   Normal_vector(Pd01, Pd21, Pd06, Vn) #local Snv[3][5]=Vn;
   #local Nv21=(Snv[3][0]+Snv[3][1]+Snv[3][2]+Snv[3][3]+Snv[3][4]+Snv[3][5])/Smax;
   //
   smooth_triangle { Pd11,Nv11, Pd12,Nv12, Pd22,Nv22 }
   smooth_triangle { Pd11,Nv11, Pd22,Nv22, Pd21,Nv21 }
   #local Ss=Ss+As;
  #end
  #local Se=Se+Ae;
 #end
 }
#end // macro end
//**********************************************************************************