//****************************************************
// Planetary orbit macro ver 0.1r001112a include file
// Persistence Of Vision raytracer version 3.1g
// By S.Nishimura
//****************************************************


//**********************************************************************************
#macro Julian_days(Year,Month,Day,LMT,LON,JD)
 #local YY=Year; #local MM=Month;
 #if(MM<3) #local YY=YY-1; #local MM=MM+12; #end
 #local YM=int(365.25*YY)+int(30.59*(MM-2));
 #local JD=YM+Day+LMT/24-LON/360+1721086.5;
 #if(JD>2299150) #local JD=JD+int(YY/400)-int(YY/100)+2; #end
#end
//**********************************************************************************
#macro Rectangular_cnv(PML,PNL,OMG,INC,PEC,PAX,PTA,PRR,Pp)
 #local PMA=radians(mod(PML-PNL+360,360));
 #local MPG=(2*PEC-pow(PEC,3)/4)*sin(PMA)+pow(PEC,2)*5/4*sin(2*PMA)+pow(PEC,3)*13/12*sin(3*PMA);
 #local PTA=mod(degrees(PMA+MPG)+360,360); #local PRR=PAX*(1-pow(PEC,2))/(1+PEC*cos(radians(PTA)));
// center of the sun rectangular coordinates
 #local UU=mod(PTA+PNL-OMG+360,360);
 #local XX=PRR*(cos(radians(UU))*cos(radians(OMG))-sin(radians(UU))*sin(radians(OMG))*cos(radians(INC)));
 #local YY=PRR*sin(radians(UU))*sin(radians(INC));
 #local ZZ=PRR*(cos(radians(UU))*sin(radians(OMG))+sin(radians(UU))*cos(radians(OMG))*cos(radians(INC)));
 #local Pp=< XX,YY,ZZ >;
#end
//**********************************************************************************
#macro Spherical_cnv(Pp,RR,LL,TB)
 #local Rh=vlength(<Pp.x,0,Pp.z>);
 #if(Pp.z/Rh>=0) #local Sg=1; #else #local Sg=-1; #end
 #local LL=mod(degrees(Sg*acos(Pp.x/Rh))+360,360);
 #if(Pp.y/RR>=0) #local Sg=1; #else #local Sg=-1; #end
 #local TB=degrees(Sg*acos(Rh/RR));
#end
//**********************************************************************************
#macro Orbit_func(EC,AX,Tp,P0,Func_type)
 #switch(Func_type)
 #case(0) #local Rr=AX*(1-pow(EC,2))/(1+EC*cos(Tp));
          #local Px=Rr*cos(Tp); #local Py=0; #local Pz=Rr*sin(Tp);#break
 #end
 #local P0=< Px,Py,Pz >;
#end
//----------------------------------------------------------------------------------
#macro Planetary_orbit(Lw,EC,AX,TA,Func_type)
 #local Te=TA+2*pi; #local Ta=pi/26; #local P0=< 0, 0, 0 >;
 #local Ts=TA; #while(Ts<Te)
  Orbit_func(EC,AX,Ts   ,P0,Func_type) #local P1=P0;
  Orbit_func(EC,AX,Ts+Ta,P0,Func_type) #local P2=P0;
  sphere { P1, Lw } cylinder { P1, P2, Lw } 
 #local Ts=Ts+Ta; #end 
#end
//**********************************************************************************
#macro Earth_orbit(Cgap,Pe)
// SUN definition to earth
 #local SML=mod(280.6824+36000.769325*Cgap+7.22222*1e-4*pow(Cgap,2),360);
 #local SPL=mod(281.2206+1.717697*Cgap+4.83333*1e-4*pow(Cgap,2)+2.77777*1e-6*pow(Cgap,3),360);
 #local SEC=0.0167498-4.258*1e-5*Cgap-1.37*1e-7*pow(Cgap,2);
 #local SAX=1.00000129;
// center of the earth spherical coordinates
 #local SMA=radians(mod(SML-SPL+360,360));
 #local SMPG=1.91946*sin(SMA)+2.00939*1e-2*sin(2*SMA)-4.78889*1e-3*sin(SMA)*Cgap-1.44444*1e-5*sin(SMA)*pow(Cgap,2);
 #local SL=SML+SMPG; #local SLAT=0;
 #local STA=radians(mod(SL-SPL+360,360)); #local SRR=SAX*(1-pow(SEC,2))/(1+SEC*cos(STA));
// center of the earth rectangular coordinates
 #local XX=SRR*cos(radians(SLAT))*cos(radians(SL));
 #local YY=SRR*sin(radians(SLAT));
 #local ZZ=SRR*cos(radians(SLAT))*sin(radians(SL));
 #local Ps=< XX,YY,ZZ >;
// center of the sun rectangular coordinates 
 #local Pe=-Ps;
// center of the sun spherical coordinates 
 #local LL=0; #local TB=0; Spherical_cnv(Pe,SRR,LL,TB)
//
 union { Planetary_orbit(Lw,SEC,SAX,STA,0) pigment { P_orbit } rotate (-SPL+180)*y }
#end
//**********************************************************************************
#macro Mercury_orbit(Cgap,Pm)
// mars definition  
 #local PML=mod(182.27175+149474.07244*Cgap+2.01944*1e-3*pow(Cgap,2),360);
 #local PNL=mod(75.89717+1.553469*Cgap+3.08639*1e-4*pow(Cgap,2),360);
 #local OMG=mod(47.144736+1.18476*Cgap+2.23194*1e-4*pow(Cgap,2),360);
 #local INC=mod(7.003014+1.73833*1e-3*Cgap-1.55555*1e-5*pow(Cgap,2),360);
 #local PEC=0.20561494+0.0203*1e-3*Cgap-0.04*1e-6*pow(Cgap,2);
 #local PAX=0.3870984;
// center of the sun rectangular coordinates
 #local TA=0; #local RR=0; Rectangular_cnv(PML,PNL,OMG,INC,PEC,PAX,TA,RR,Pm)
// center of the sun spherical coordinates 
 #local LL=0; #local TB=0; Spherical_cnv(Pm,RR,LL,TB)
//union { Planetary_orbit(0.008,PEC,PAX,TA,0) pigment { color rgbt < R9, G9, B9, 0.7 > } rotate < 0, -PNL,-INC > }
 union { Planetary_orbit(Lw,PEC,PAX,TA,0) pigment { P_orbit } rotate < 0, TA, TB > rotate -LL*y }
#end
//**********************************************************************************
#macro Venus_orbit(Cgap,Pv)
// mars definition  
 #local PML=mod(344.36936+58519.2126*Cgap+9.8055*1e-4*pow(Cgap,2),360);
 #local PNL=mod(130.14075+1.37230*Cgap-1.6472*1e-3*pow(Cgap,2),360);
 #local OMG=mod(75.7881+0.91403*Cgap+4.189*1e-4*pow(Cgap,2),360);
 #local INC=mod(3.3936+1.2522*1e-3*Cgap-4.333*1e-6*pow(Cgap,2),360);
 #local PEC=0.00681636-0.5384*1e-4*Cgap+0.126*1e-6*pow(Cgap,2);
 #local PAX=0.72333015;
// center of the sun rectangular coordinates
 #local TA=0; #local RR=0; Rectangular_cnv(PML,PNL,OMG,INC,PEC,PAX,TA,RR,Pv)
// center of the sun spherical coordinates 
 #local LL=0; #local TB=0; Spherical_cnv(Pv,RR,LL,TB)
//union { Planetary_orbit(0.008,PEC,PAX,TA,0) pigment { color rgbt < R9, G9, B9, 0.7 > } rotate < 0, -PNL,-INC > }
 union { Planetary_orbit(Lw,PEC,PAX,TA,0) pigment { P_orbit } rotate < 0, TA, TB > rotate -LL*y }
#end
//**********************************************************************************
#macro Mars_orbit(Cgap,Pm)
// mars definition  
 #local PML=mod(294.26478+19141.69625*Cgap+3.15028*1e-4*pow(Cgap,2),360);
 #local PNL=mod(334.21833+1.840394*Cgap+3.35917*1e-4*pow(Cgap,2),360);
 #local OMG=mod(48.78670+0.776944*Cgap-6.02778*1e-4*pow(Cgap,2),360);
 #local INC=mod(1.85030-6.49028*1e-4*Cgap+2.625*1e-5*pow(Cgap,2),360);
 #local PEC=0.0933088+0.095284*1e-3*Cgap-0.122*1e-6*pow(Cgap,2);
 #local PAX=1.5236781;
// center of the sun rectangular coordinates
 #local TA=0; #local RR=0; Rectangular_cnv(PML,PNL,OMG,INC,PEC,PAX,TA,RR,Pm)
// center of the sun spherical coordinates 
 #local LL=0; #local TB=0; Spherical_cnv(Pm,RR,LL,TB)
//union { Planetary_orbit(0.008,PEC,PAX,TA,0) pigment { color rgbt < R9, G9, B9, 0.7 > } rotate < 0, -PNL,-INC > }
 union { Planetary_orbit(Lw,PEC,PAX,TA,0) pigment { P_orbit } rotate < 0, TA, TB > rotate -LL*y }
#end
//**********************************************************************************
//
#macro Moon_orbit(JD,Pm)
// mars definition
 #local Cgap=(JD-2378496)/36525;  
 #local MML=mod(335.723436+481267.887361*Cgap+3.38888*1e-3*pow(Cgap,2)+1.83333*1e-6*pow(Cgap,3),360);
 #local PNL=mod(225.397325+4069.053805*Cgap-1.02869*1e-2*pow(Cgap,2)-1.22222*1e-5*pow(Cgap,3),360);
 #local OMG=mod(33.272936-1934.144694*Cgap+2.08028*1e-3*pow(Cgap,2)+2.08333*1e-6*pow(Cgap,3),360);
 #local INC=5.144433;
 #local MEC=0.05490897;
 #local MAX=60.2682*6378/(14960*1e+4);
//
 #local G0=mod(110.32601+477198.8436*Cgap+0.0142039*pow(Cgap,2)+1.42083*1e-5*pow(Cgap,3),360);
 #local W0=mod(192.12428+6003.1975*Cgap-0.0125555*pow(Cgap,2)-1.25597*1e-5*pow(Cgap,3),360);
 #local G1=mod(0.40885+35999.0552*Cgap-1.98806*1e-4*pow(Cgap,2),360);
 #local W1=mod(246.2310+1935.8602*Cgap-1.64472*1e-3*pow(Cgap,2)-1.84028*1e-6*pow(Cgap,3),360);
//
 #local AA=mod(G0-2*G1+2*(W0-W1),360); #local BB=mod(AA+G0,360);
 #local CC=mod(G1+180,360); #local DD=mod(AA-G1+360,360); #local EE=mod(BB-G1+360,360);
 #local HH=mod(AA-W0+360,360);
//
 #local A0=1.2408*sin(radians(AA)); #local B0=0.5958*sin(radians(BB)); #local C0=0.1828*sin(radians(CC));
 #local D0=0.0550*sin(radians(DD)); #local E0=0.0431*sin(radians(EE));
 #local H0=0.1453*sin(radians(HH));
//
 #local MML=MML+A0+B0+C0+D0+E0; 
// center of the earth rectangular coordinates
 #local TA=0; #local RR=0; Rectangular_cnv(MML,PNL,OMG,INC,MEC,MAX,TA,RR,Pm)
// center of the earth spherical coordinates 
 #local LL=0; #local TB=0; Spherical_cnv(Pm,RR,LL,TB) #local TB=TB+H0;
// center of the earth rectangular coordinates
 #local XX=RR*cos(radians(TB))*cos(radians(LL));
 #local YY=RR*sin(radians(TB));
 #local ZZ=RR*cos(radians(TB))*sin(radians(LL));
 #local Pm=< XX,YY,ZZ >;
//union { Planetary_orbit(0.00015,MEC,MAX,TA,0) pigment { color rgbt < R9, G9, B9, 0.7 > } scale < Cmoon, 1, Cmoon > rotate < 0, -PNL,-INC > translate Pearth }
 union { Planetary_orbit(Lw,MEC,MAX,TA,0) pigment { P_orbit } scale < Cmoon, 1, Cmoon > rotate < 0, TA, TB > rotate -LL*y translate Pearth }
#end
//**********************************************************************************
#macro Inner_planet(Year,Month,Day,HH,LON) // heliocentric
// planet definition
//#local Erev=365; #local Mrev=88; #local Vrev=225; #local Krev=Erev*1.88;
//#local AU=14960*1e+4; #local Srad=Erad*109;#local Mrad=2440/AU; #local Vrad=6052/AU; #local Krad=3394/AU;
#local Er=6378; //(Km)
#local Erad=Er/127500; #local Srad=Erad*109/70; #local Merr=Erad/2; #local Venr=Erad*6052/Er; #local Marr=Erad*3394/Er;
#local Mrad=Erad/2;
//----------------------------------------------------------------------------------
// orbit definition
coordinate_color(  150, 0.8, 0.6, 1, 9 ) //coordinate_color(  210, 0.9, 0.3, 1, 9 )
#local P_orbit = pigment { color rgb < R9, G9, B9 > }
//----------------------------------------------------------------------------------
#local Ppos=< 0, 0, 0 >; #local Cmoon=50; #local Sc=120;
#local JD=0; Julian_days(Year,Month,Day,HH,LON,JD) #local Cgap=(JD-2415021)/36525;
union {
 coordinate_color( -30, 0.9, 0.5, 1, 1 )
 sphere { 0, Srad hollow pigment { color rgbf < R1, G1, B1, 0.8 > } finish { ambient 0.9 } }
 //
 #local Lw=0.008;
 coordinate_color( 150+Month*2, 0.9, 0.5, 1, 1 )
 Mercury_orbit(Cgap,Ppos) sphere { Ppos, Merr pigment { color rgb < R1, G1, B1 > } }
 coordinate_color(   0+Month*2, 0.9, 0.5, 1, 2 )
 Venus_orbit(Cgap,Ppos)   sphere { Ppos, Venr pigment { color rgb < R2, G2, B2 > } }
 coordinate_color(  90+Month*2, 0.9, 0.5, 1, 3 )
 Earth_orbit(Cgap,Ppos)   sphere { Ppos, Erad pigment { color rgb < R3, G3, B3 > } } #local Pearth=Ppos;
 coordinate_color( -30+Month*2, 0.9, 0.5, 1, 4 )
 Mars_orbit(Cgap,Ppos)    sphere { Ppos, Marr pigment { color rgb < R4, G4, B4 > } }
 //
 #local Lw=Lw/(Cmoon+4);
 coordinate_color( 30, 0.9, 0.5, 1, 1 )
 Moon_orbit(JD,Ppos) sphere { Pearth+Ppos*Cmoon, Mrad pigment { color rgb < R1, G1, B1 > } }
 scale Sc
}
#end // macro end
//**********************************************************************************
// parameter (Year,Month,Day,Hour(LMT),Longitude)
//object { Inner_planet(1349, 7,14, 4, 0) rotate -90*x }
//object { Inner_planet( 182,12,22,18, 0) rotate -90*x }
//**********************************************************************************