// All the roots Scene File
// Persistence Of Vision raytracer version 3.1g
// By S.Nishimura


#include "coordinate_color.mcr.inc"


global_settings { assumed_gamma 2.2 }


camera { location < 0, 0, -400 >
	 look_at < 0, 0, 0 >
	 angle 60 }

light_source { < -150, -100, -400 > color rgb 0.3
    spotlight
    radius 10
    falloff 15
    tightness 10
    fade_distance 300
    fade_power 1
    point_at < -130, -120, -20 >
    shadowless
 }
light_source { < 150, -50, -1000 > color rgb 0.8 fade_distance 600 fade_power 1 shadowless }
light_source { < 150, 0, -400 > color rgb 0.6
    spotlight
    radius 10
    falloff 15
    tightness 10
    fade_distance 230
    fade_power 1
    point_at < 130, -140, -20 >
 }


//**********************************************************************************
coordinate_color( 150, 0.3, 0.3, 1, 0 )
background { color rgb < R0, G0, B0 > }
//**********************************************************************************
coordinate_color( 90, 0.8, 0.4, 3, 1 )
sky_sphere {
    pigment { bozo
              turbulence 0.6
              octaves 8
              lambda 4
              omega 0.6
              color_map {
                           [ 0.0 rgbt < 0, 0, 0, 0.9 > ]
                           [ 0.1 rgbt < R1, G1, B1, 0.8 > ]
                           [ 0.4 rgbt < R2, G2, B2, 0.7 > ]
                           [ 0.5 rgbt < R3, G3, B3, 0.8 > ]
                           [ 0.6 rgbt < R2, G2, B2, 0.7 > ]
                           [ 0.9 rgbt < R1, G1, B1, 0.8 > ]
                           [ 1.0 rgbt < 0, 0, 0, 0.9 > ] }
              scale < 12, 1.5, 12 >*0.1 }
scale 0.4 }
//**********************************************************************************
#local M_sky =
media { emission 0.015
        intervals 40
        samples 1, 1
        confidence 0.9
        variance 0.1
        density { bozo
                  turbulence 0.6
                  octaves 8
                  lambda 4
                  omega 0.6
                  color_map { [ 0.0 rgbt < 0, 0, 0, 1 > ]
                              [ 0.1 rgb  < R1, G1, B1 > ]
                              [ 0.4 rgbt < R2, G2, B2, 1 > ]
                              [ 0.5 rgbt < R3, G3, B3, 1 > ]
                              [ 0.6 rgbt < R2, G2, B2, 1 > ]
                              [ 0.9 rgb  < R1, G1, B1 > ]
                              [ 1.0 rgbt < 0, 0, 0, 1 > ] }
                  rotate 180*y rotate -90*x
                  scale < 12, 1.5, 12 >*100 }
}
#local Big_sky=
sphere { 0, 100 hollow
  pigment { color rgbf < 1, 1, 1, 1 > }
  finish { ambient 0 diffuse 0 }
  interior { media { M_sky } }
}
object { Big_sky scale 2 translate 100*z }
//**********************************************************************************
#include "Planetary_orbit.mcr.inc"
//----------------------------------------------------------------------------------
// heliocentric
// parameter (Year,Month,Day,Hour(LMT),Longitude)
union {
 light_source { 0 color rgb 0.2 fade_distance 800 fade_power 1 }
 object { Inner_planet(2001, 2,10,12, 0) rotate -25*x scale 1.2 }
 translate < 10, 135, 25+50 >
}
//**********************************************************************************
#include "curved_line.mcr.inc"
//----------------------------------------------------------------------------------
// curve functions
#macro Curve_function(Sp,Px0,Pz0,Func_type)
 #switch(Func_type)
 #case( 0) #local Px0= 2*cos(radians(45*Sp)); #local Pz0= 2*sin(radians(45*Sp)); #break // octagon
 #case( 1) #local Px0= Sp; #local Pz0= 4/Px0*sin(Px0); #break
 #case( 2) #local Px0= 2.2*cos(Sp); #local Pz0= 1.8*sin(Sp); #break // ellipse
 #case( 3) #local Px0= Sp; #local Pz0= 1/4*pow(Px0,2); #break
 #case( 4) #local Px0= 3*cos(Sp); #local Pz0= 2*sin(Sp); #break // ellipse
 #end
#end
//**********************************************************************************
#include "Interspersion.mcr.inc"
//----------------------------------------------------------------------------------
// definition
#local Lw=1.5; #local Lr=Lw*2;
//---------------------------------------------------------------------------------- 
coordinate_color( 200, 0.7, 0.6, 2, 1 )
#local P_hair = pigment { color rgb < R1, G1, B1 > }
#local F_hair = finish { metallic specular 0.3 roughness 0.1 diffuse 0.7 reflection 0.2 }
#local T_hair = texture { pigment { P_hair } finish { F_hair } }
//----------------------------------------------------------------------------------
#local Hair_obj =
union {
#local Obj_seg = union { Curved_line(Lw/20,pi/24,pi/2,pi/8,-(1.8*cos(pi/24))/(2.8*sin(pi/24)),2) rotate < -90, 90, 0 > rotate 10*x scale 20 }
#local Dn=64/Lw; #local Tz=Lr*Dn/pi*cos(pi/4); #local Ty=Lr*Dn/pi*sin(pi/4)+10; 
 union { Interspersion(1,< 0,Ty,Tz >,Lr,pi*< 1/4, 3/4, 1/Dn >,1) }
#local Obj_seg = union { Curved_line(Lw/20,pi/2,pi-pi/8,pi/8,-(1.8*cos(pi/2))/(2.8*sin(pi/2)),2) rotate < -90, 90, 0 > scale 20 }
 union { Interspersion(1,< 0,Ty,Tz >,Lr,pi*< 1/4, 3/4, 1/Dn >,1) }
#local Obj_seg = union { Curved_line(Lw/20,pi*0.1,pi*3,pi/8,cos(pi*0.6),1) rotate < -90, 90, 0 > scale 20 }
#local Dn=32/Lw; #local Tx=Lr*Dn/pi*cos(pi/4)+1; #local Tz=Lr*Dn/pi*sin(pi/4)-1;
#local Hair_seg = union { Interspersion(2,< Tx,0,Tz >,Lr,pi*< 1/4, 3/4, 1/Dn >,3) }
 object { Hair_seg }
 object { Hair_seg rotate  90*y } object { Hair_seg rotate  86*y }
 object { Hair_seg rotate -90*y } object { Hair_seg rotate -86*y }
#local Obj_seg = union { Curved_line(Lw/20,pi*0.1,pi/2.1,pi/12,cos(pi*0.6),1) rotate < -90, 90, 0 > scale 20 } 
#local Hair_seg = union { Interspersion(2,< Tx,0,Tz >,Lr,pi*< 1/4, 3/4, 1/Dn >,3) rotate 180*y }
 object { Hair_seg }
 object { Hair_seg rotate  15*y }
 object { Hair_seg rotate -15*y }
}
//----------------------------------------------------------------------------------
#include "FaceR03a.dat.inc"
union {
 object { Hair_obj texture { T_hair } scale < 1, 1.5, 1 > translate < 0, 10, 0 > }
 union { object { dxfobj0 } object { dxfobj1 } object { dxfobj2 } /*object { dxfobj3 }*/ pigment { color rgb < R2,G2,B2> } }
 light_source { < 0, 0, -40 > color rgb 0.6 fade_distance 60 fade_power 1 shadowless }
 scale 1.2 translate < 10, -45, 60+50 >
}
//**********************************************************************************
// definition
#local Lw=1.2; #local Lr=Lw*2; #local Dn=16/Lw;
//----------------------------------------------------------------------------------
coordinate_color( 220, 0.9, 0.6, 1, 1 )
#local P_hair = pigment { color rgb < R1, G1, B1 > }
//#local F_hair = finish { metallic specular 0.3 roughness 0.1 diffuse 0.7 reflection 0.2 }
#local T_hair = texture { pigment { P_hair } finish { F_hair } }
//----------------------------------------------------------------------------------
#local Hair_obj =
union {
#local Obj_seg = union { Curved_line(Lw/20,pi*0,pi*1.5,pi/8,1e-12,3) rotate < -90, 0, 90 > scale 20 }
 union { Interspersion(2,< 0, 100, 0 >,Lr,pi*< -1, 1, 1/Dn >,6) }
 union { Interspersion(2,< 0, 100, 0 >,Lr,pi*< -1, 1, 1/Dn >,7) rotate 180*y }
#local Obj_seg = union { Curved_line(Lw/20,pi*0,pi*0.5,pi/8,-2/3*cos(pi*0)/sin(1e-12),4) rotate < -90, -90, 0 > translate -1.8*x scale 20 }
 union { Interspersion(2,< 15, 68, 0 >,Lr,pi*< -1, 1, 1/Dn >,5) scale < 1.2, 1.5, 1.2 >*0.82 }
#local Obj_seg = union { Curved_line(Lw/20,pi*0,pi*0.5,pi/8,-2/3*cos(pi*0)/sin(1e-12),4) rotate < -90, -90, 0 > translate 1*z scale 20 }
 union { Interspersion(2,< 20, 48, 0 >,Lr,pi*< -1, 1, 1/Dn >,5) scale < 1.2, 2.5, 1.2 >*0.7 }
 union { Interspersion(2,< 20, 48, 0 >,Lr,pi*< -1, 1, 1/Dn >,5) scale < 1.2, 2.5, 1.8 >*0.7 rotate 180*y }
}
//----------------------------------------------------------------------------------
//#include "FaceR03a.dat.inc"
coordinate_color( 270, 0.88, 0.96, 1, 9 )
#local T_face = texture { pigment { color rgb < R9, G9, B9 > } normal { bumps 0.1 scale 0.08 } }
union {
 object { Hair_obj texture { T_hair } }
 union { object { dxfobj0 } object { dxfobj1 } object { dxfobj2 } /*object { dxfobj3 }*/ texture { T_face } }
 light_source { < 0, 0, -40 > color rgb 0.6 fade_distance 60 fade_power 1 shadowless }
 rotate 20*y translate < 130, -140, -20 >
}
//**********************************************************************************
#include "Normal_vector.mcr.inc"
//----------------------------------------------------------------------------------
#macro Surface_function(Ss,Se,Px,Py,Pz,Func_type)
 #switch(Func_type)
 #case(0) #local Pr=0.5*sin(pi*Se)+0.5*pow(Se,2)+0.5;
          #local Px=2*Pr*cos(Ss); #local Py=2*Se; #local Pz=2*Pr*sin(Ss);#break

 #case(1) #local Rr=max(2.5*0.85,2.5*abs(cos(Se)));
          #local Px=Rr*sin(Se)*cos(Ss); #local Py=1.2*Rr*cos(Se); #local Pz=Rr*sin(Se)*sin(Ss);#break
 #end
#end  // macro end
//**********************************************************************************
coordinate_color( 270, 0.9, 0.6, 3, 1 )
#local T_glass =
 texture {
  pigment { ripples
            color_map { [ 0.0 rgbf < R2, G2, B2, 0.8 > ]
                        [ 0.5 rgbf < R3, G3, B3, 0.8 > ]
                        [ 1.0 rgbf < R1, G1, B1, 0.8 > ] } scale 4 }
  finish { ambient 0.1 diffuse 0.1 reflection 0.3 specular 1 roughness 0.001 }
}
#local Glass_obj = object { Surface_tri4m(pi*< -1, 1, 1/18 >,pi*< -1/3.8, 1/2.2, 1/12 >,0) }
// object
object { Glass_obj texture { T_glass } interior { ior 1.4 } scale 10*2 translate < -194, -125, 55 > }
//**********************************************************************************
// definition
coordinate_color( 30, 0.99, 0.6, 3, 1 )
#local T_lemon =
 texture {
  pigment { ripples
            color_map { [ 0.00 rgb < R2, G2, B2 > ]
                        [ 0.01 rgb < R1, G1, B1 > ]
                        [ 1.00 rgb < R1, G1, B1 > ] } scale 2 }
 finish { ambient 0.3 reflection 0.4 specular 0.8 roughness 0.001 }
 normal { bumps 0.4 scale 0.08 }
}
#local Lemon_obj = object { Surface_tri4m(pi*< -1, 1, 1/12 >,pi*< 0, 1, 1/18 >,1) }
// object
object { Lemon_obj texture { T_lemon } scale 8*2 rotate < -30, 0, 90 > translate <  -98, -125,  10 > }
object { Lemon_obj texture { T_lemon } scale 8*2 rotate <  10, 0, 90 > translate < -178, -125, 120 > }
//**********************************************************************************
#macro Ipow(Zp,Np)
 #local Rzp=vlength(Zp);
 #if(Rzp=0) #local Hzp=0; #else
 #if(Zp.y/Rzp>=0) #local Sg=1; #else #local Sg=-1; #end
 #local Hzp=Sg*acos(Zp.x/Rzp); #end
 #local Zp=< pow(Rzp,Np)*cos(Np*Hzp), pow(Rzp,Np)*sin(Np*Hzp) >;
#end
//----------------------------------------------------------------------------------
#macro Mandel_fractal(Sr,Er,Si,Ei,Az,Ii,En)
#local Lr=Az/sqrt(2);

#local Px=Sr; #while(Px<Er)
 #local Pz=Si; #while(Pz<Ei)
  #local Z0=< 0, 0 >; #local C0=< Px, Pz >;
  #local Sn=1; #while(Sn<En+1)
   Ipow(Z0,Ii) #local Zn=Z0+C0; #local Z0=Zn; #local Py=Sn/En;
   #if(vlength(Zn)>2) #local Sn=En; #end
  #local Sn=Sn+1; #end
  #if(Py>(En-1)/En) cylinder { < Px, 0, Pz-0.4 >, < Px, Py, Pz-0.4 >, Lr } #end 
 #local Pz=Pz+Az; #end
#local Px=Px+Az; #end

#end // macro end 
//----------------------------------------------------------------------------------
coordinate_color( 30, 0.5, 0.7, 2, 1 )
#local P_mandel =
 pigment { wood
            turbulence < 0.6, 1.0, 0.3 >
            color_map { [ 0.0 rgb < R1, G1, B1 > ]
                        [ 1.0 rgb < R1, G1, B1 > ] } scale 0.3 }
union { Mandel_fractal( -1.5,1.5,-1.4,1.6,3/60,6,30 )
 pigment { P_mandel }
 finish { ambient 0.6 diffuse 0.5 reflection 0.3 }
 rotate 18*y rotate -90*x scale 10 rotate 60*y
 translate < 278, 192, 160 > 
}  
//**********************************************************************************
coordinate_color( 356, 1.00, 0.45, 1, 1 )
coordinate_color(  16, 1.00, 0.40, 1, 2 )
coordinate_color( 349, 0.31, 0.55, 1, 3 )
#local M_spark =
 media { emission rgb 0.01
             //intervals 30
             //samples 1,1
             confidence 0.999
             variance 0.001
             density { spherical
                       color_map { [ 0.0 rgb < 0, 0, 0 > ]
                                   [ 0.4 rgb < R1, G1, B1 > ]
                                   [ 0.6 rgb < R2, G2, B2 > ]
                                   [ 0.8 rgb < R3, G3, B3 > ]
                                   [ 0.9 rgb < R1, G1, B1 > ]
                                   [ 1.0 rgb < 0, 0, 0 > ] } scale 21.5 }
 }
//
#local Spark_seg = sphere { 0, 30 pigment { color rgbt < 1, 1, 1, 1 > } interior { media { M_spark } } scale 5 hollow }
//
#local Spark_obj =
merge {
 //sphere { 0, 32 pigment { color rgb 1 } finish { ambient 0 diffuse 0 reflection 1 } }
 object { Spark_seg scale < 10, 0.1, 0.1 > rotate 60*z }
 object { Spark_seg scale < 10, 0.1, 0.1 > rotate 120*z }
 object { Spark_seg scale < 10, 0.1, 0.1 > rotate 180*z }
 object { Spark_seg scale < 10, 0.1, 0.1 > rotate 90*y }
 no_shadow
}
//
object { Spark_obj rotate < -50, 100, 0 > translate < -1140, 400, 1800 > }
//**********************************************************************************


// Signature
//#include "Sealreverse.sgn.inc"
//object { Sealing scale 0.4 translate < -55, -41, -300 > }