//  Persistance of Vision Raytracer V3.0
//  World definition file.

//  By Michael Lewis

//
//  Contains 2 lights, 3 textures and 64 primitives.
//
//

//  Date : 02/26/2001    (26.02.2001)
//







global_settings {
  adc_bailout 0.003922
  ambient_light <1.0,1.0,1.0>
  assumed_gamma 1.8
  hf_gray_16 off
  irid_wavelength <0.25,0.18,0.14>
  max_intersections 64
  max_trace_level 10
  number_of_waves 10
  radiosity {
    brightness       3.3
    count            100
    distance_maximum 0.0
    error_bound      0.4
    gray_threshold   0.5
    low_error_factor 0.8
    minimum_reuse    0.015
    nearest_count    6
    recursion_limit  1
  }
}

background { color <0.000,0.000,0.000> }

camera {  //  Camera StdCam
  location  <-23.535, -10.278, 5.509>
  direction <0.0,     0.0,  1.8883>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.33333, 0.0,  0.0>
  look_at   <-1.840, 1.697, 3.752>
}

//    Other cameras are commented out.
/*
camera {  //  Camera SpotCam001
  location  <39.750, -106.361, 78.969> // Attached to Sun
  direction <0.0,     0.0,  0.9022>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.33333, 0.0,  0.0>
  look_at   <36.153, -76.922, 52.128> // Following Sun
}

*/

// *******  L I G H T S *******
light_source {   // Spotlight Sun
  <39.750, -106.361, 78.969>
  color  rgb <0.980, 0.337, 0.267>
  spotlight
    point_at  <36.153, -76.922, 52.128>
    falloff   29.0  // outer radius (in deg)
      radius    26.1  // inner radius
  fade_distance  5.0
  fade_power 1.0
}

light_source { // AreaL001
  <42.694, 28.708, 10.555>
  color  rgb<1.000, 1.000, 1.000>
  area_light <140.389, 0.000, 0.000>, <0.000, 130.083, 0.000>, 3, 3
  adaptive 1
  jitter
}



// ********  TEXTURES  *******
//

#include "snow.inc"



// ********  REFERENCED OBJECTS  *******



// ********  OBJECTS  *******





sphere { // Sky
  <0,0,0>,1
  texture {
    skystuff
  }
  scale 200.0
  translate  <-31.123874, -63.803942, 0.0>
  hollow
}


box { // ground
  <-1, -1, -1>, <1, 1, 1>
  texture {
    Snow
  }
  scale <105.845238, 92.448349, 1.0>
  translate  <60.691555, 49.798199, -1.2>
}


#declare TempleRoof2 = prism {
  conic_sweep
  linear_spline
  0.0,1.0
  5  // control points
  <-1.0, -1.0>,
  <1.0, -1.0>,
  <1.0, 1.0>,
  <-1.0, 1.0>,
  <-1.0, -1.0>
  rotate <90,0,90>
  texture {
    Stone
  }
  scale <2.0, 2.0, 1.5>
  rotate <180.0, 0.0, 180.0>
  translate  8.1*z
}
union { // PMid2
  box { // PyramidStone25
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Stone
    }
    scale <7.0, 7.0, 0.2>
  }
  box { // PyramidStone26
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Stone
    }
    scale <6.6, 6.6, 0.2>
    translate  0.4*z
  }
  box { // PyramidStone27
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Stone
    }
    scale <6.2, 6.2, 0.2>
    translate  0.8*z
  }
  box { // PyramidStone28
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Stone
    }
    scale <5.8, 5.8, 0.2>
    translate  1.2*z
  }
  box { // PyramidStone29
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Stone
    }
    scale <5.4, 5.4, 0.2>
    translate  1.6*z
  }
  box { // PyramidStone30
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Stone
    }
    scale <5.0, 5.0, 0.2>
    translate  2.0*z
  }
  box { // PyramidStone31
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Stone
    }
    scale <4.6, 4.6, 0.2>
    translate  2.4*z
  }
  box { // PyramidStone32
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Stone
    }
    scale <4.2, 4.2, 0.2>
    translate  2.8*z
  }
  box { // PyramidStone33
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Stone
    }
    scale <3.8, 3.8, 0.2>
    translate  3.2*z
  }
  box { // PyramidStone34
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Stone
    }
    scale <3.4, 3.4, 0.2>
    translate  3.6*z
  }
  box { // PyramidStone35
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Stone
    }
    scale <3.0, 3.0, 0.2>
    translate  4.0*z
  }
  box { // PyramidStone36
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Stone
    }
    scale <2.0, 2.0, 0.3>
    translate  4.5*z
  }
  cylinder { // TemplePillar9
    <0,0,1>, <0,0,0>, 1 
    texture {
      Stone
    }
    scale <0.35, 0.35, 1.8>
    translate  <-1.5, 1.5, 4.8>
  }
  cylinder { // TemplePillar10
    <0,0,1>, <0,0,0>, 1 
    texture {
      Stone
    }
    scale <0.35, 0.35, 1.8>
    translate  <1.5, 1.5, 4.8>
  }
  cylinder { // TemplePillar11
    <0,0,1>, <0,0,0>, 1 
    texture {
      Stone
    }
    scale <0.35, 0.35, 1.8>
    translate  <1.5, -1.5, 4.8>
  }
  cylinder { // TemplePillar12
    <0,0,1>, <0,0,0>, 1 
    texture {
      Stone
    }
    scale <0.35, 0.35, 1.8>
    translate  <-1.5, -1.5, 4.8>
  }
  object { TempleRoof2 }
  sphere { // SnowmanButt2
    <0,0,0>,1
    texture {
      Snow
    }
    scale 0.4
    translate  5.25*z
  }
  sphere { // SnowmanChest2
    <0,0,0>,1
    texture {
      Snow
    }
    scale 0.3
    translate  5.8*z
  }
  sphere { // SnowmanHead2
    <0,0,0>,1
    texture {
      Snow
    }
    scale 0.2
    translate  6.2*z
  }
  rotate 30.753605*z
  translate  <79.174565, 17.17276, 0.0>
}


#declare TempleRoof1 = prism {
  conic_sweep
  linear_spline
  0.0,1.0
  5  // control points
  <-1.0, -1.0>,
  <1.0, -1.0>,
  <1.0, 1.0>,
  <-1.0, 1.0>,
  <-1.0, -1.0>
  rotate <90,0,90>
  texture {
    Stone
  }
  scale <2.0, 2.0, 1.5>
  rotate <180.0, 0.0, 180.0>
  translate  8.1*z
}
union { // PMid1
  box { // PyramidStone13
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Stone
    }
    scale <7.0, 7.0, 0.2>
  }
  box { // PyramidStone14
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Stone
    }
    scale <6.6, 6.6, 0.2>
    translate  0.4*z
  }
  box { // PyramidStone15
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Stone
    }
    scale <6.2, 6.2, 0.2>
    translate  0.8*z
  }
  box { // PyramidStone16
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Stone
    }
    scale <5.8, 5.8, 0.2>
    translate  1.2*z
  }
  box { // PyramidStone17
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Stone
    }
    scale <5.4, 5.4, 0.2>
    translate  1.6*z
  }
  box { // PyramidStone18
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Stone
    }
    scale <5.0, 5.0, 0.2>
    translate  2.0*z
  }
  box { // PyramidStone19
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Stone
    }
    scale <4.6, 4.6, 0.2>
    translate  2.4*z
  }
  box { // PyramidStone20
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Stone
    }
    scale <4.2, 4.2, 0.2>
    translate  2.8*z
  }
  box { // PyramidStone21
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Stone
    }
    scale <3.8, 3.8, 0.2>
    translate  3.2*z
  }
  box { // PyramidStone22
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Stone
    }
    scale <3.4, 3.4, 0.2>
    translate  3.6*z
  }
  box { // PyramidStone23
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Stone
    }
    scale <3.0, 3.0, 0.2>
    translate  4.0*z
  }
  box { // PyramidStone24
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Stone
    }
    scale <2.0, 2.0, 0.3>
    translate  4.5*z
  }
  cylinder { // TemplePillar5
    <0,0,1>, <0,0,0>, 1 
    texture {
      Stone
    }
    scale <0.35, 0.35, 1.8>
    translate  <-1.5, 1.5, 4.8>
  }
  cylinder { // TemplePillar6
    <0,0,1>, <0,0,0>, 1 
    texture {
      Stone
    }
    scale <0.35, 0.35, 1.8>
    translate  <1.5, 1.5, 4.8>
  }
  cylinder { // TemplePillar7
    <0,0,1>, <0,0,0>, 1 
    texture {
      Stone
    }
    scale <0.35, 0.35, 1.8>
    translate  <1.5, -1.5, 4.8>
  }
  cylinder { // TemplePillar8
    <0,0,1>, <0,0,0>, 1 
    texture {
      Stone
    }
    scale <0.35, 0.35, 1.8>
    translate  <-1.5, -1.5, 4.8>
  }
  object { TempleRoof1 }
  sphere { // SnowmanButt1
    <0,0,0>,1
    texture {
      Snow
    }
    scale 0.4
    translate  5.25*z
  }
  sphere { // SnowmanChest1
    <0,0,0>,1
    texture {
      Snow
    }
    scale 0.3
    translate  5.8*z
  }
  sphere { // SnowmanHead1
    <0,0,0>,1
    texture {
      Snow
    }
    scale 0.2
    translate  6.2*z
  }
  rotate 30.753605*z
  translate  <52.963256, 58.528381, 0.0>
}


#declare TempleRoof = prism {
  conic_sweep
  linear_spline
  0.0,1.0
  5  // control points
  <-1.0, -1.0>,
  <1.0, -1.0>,
  <1.0, 1.0>,
  <-1.0, 1.0>,
  <-1.0, -1.0>
  rotate <90,0,90>
  texture {
    Stone
  }
  scale <2.0, 2.0, 1.5>
  rotate <180.0, 0.0, 180.0>
  translate  8.1*z
}
union { // PMid
  box { // PyramidStone1
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Stone
    }
    scale <7.0, 7.0, 0.2>
  }
  box { // PyramidStone2
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Stone
    }
    scale <6.6, 6.6, 0.2>
    translate  0.4*z
  }
  box { // PyramidStone3
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Stone
    }
    scale <6.2, 6.2, 0.2>
    translate  0.8*z
  }
  box { // PyramidStone4
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Stone
    }
    scale <5.8, 5.8, 0.2>
    translate  1.2*z
  }
  box { // PyramidStone5
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Stone
    }
    scale <5.4, 5.4, 0.2>
    translate  1.6*z
  }
  box { // PyramidStone6
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Stone
    }
    scale <5.0, 5.0, 0.2>
    translate  2.0*z
  }
  box { // PyramidStone7
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Stone
    }
    scale <4.6, 4.6, 0.2>
    translate  2.4*z
  }
  box { // PyramidStone8
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Stone
    }
    scale <4.2, 4.2, 0.2>
    translate  2.8*z
  }
  box { // PyramidStone9
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Stone
    }
    scale <3.8, 3.8, 0.2>
    translate  3.2*z
  }
  box { // PyramidStone10
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Stone
    }
    scale <3.4, 3.4, 0.2>
    translate  3.6*z
  }
  box { // PyramidStone11
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Stone
    }
    scale <3.0, 3.0, 0.2>
    translate  4.0*z
  }
  box { // PyramidStone12
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Stone
    }
    scale <2.0, 2.0, 0.3>
    translate  4.5*z
  }
  cylinder { // TemplePillar1
    <0,0,1>, <0,0,0>, 1 
    texture {
      Stone
    }
    scale <0.35, 0.35, 1.8>
    translate  <-1.5, 1.5, 4.8>
  }
  cylinder { // TemplePillar2
    <0,0,1>, <0,0,0>, 1 
    texture {
      Stone
    }
    scale <0.35, 0.35, 1.8>
    translate  <1.5, 1.5, 4.8>
  }
  cylinder { // TemplePillar3
    <0,0,1>, <0,0,0>, 1 
    texture {
      Stone
    }
    scale <0.35, 0.35, 1.8>
    translate  <1.5, -1.5, 4.8>
  }
  cylinder { // TemplePillar4
    <0,0,1>, <0,0,0>, 1 
    texture {
      Stone
    }
    scale <0.35, 0.35, 1.8>
    translate  <-1.5, -1.5, 4.8>
  }
  object { TempleRoof }
  sphere { // SnowmanButt
    <0,0,0>,1
    texture {
      Snow
    }
    scale 0.4
    translate  5.25*z
  }
  sphere { // SnowmanChest
    <0,0,0>,1
    texture {
      Snow
    }
    scale 0.3
    translate  5.8*z
  }
  sphere { // SnowmanHead
    <0,0,0>,1
    texture {
      Snow
    }
    scale 0.2
    translate  6.2*z
  }
}

fog
{
 distance 1
 color rgbt <.8,.76,.81659,.6>
 fog_type 2
 fog_offset 0
 fog_alt 5
 turbulence .36334
 turb_depth .0256
}
