// Persistence of Vision Ray Tracer Scene Description File
// File: ?.pov
// Vers: 3.1g.wmp.0.6a
// Desc: Basic Scene Example
// Date: dd/mm/yy
// Auth: Tom Melly, http://www.tomandlu.co.uk, tom@tomandlu.co.uk
//

// Persistence of Vision Ray Tracer Scene Description File
// File: ?.pov
// Vers: 3.1g.wmp.0.6a
// Desc: Basic Scene Example
// Date: dd/mm/yy
// Auth: Tom Melly, http://www.tomandlu.co.uk, tom@tomandlu.co.uk
//

#version unofficial MegaPov 0.6;

#include "colors.inc"

// ----------------------------------------

#macro MakeCube(CubeRot)
box{
  0,1/2 translate -1/4
  texture{CubeTex}
  interior{I_Glass}
  translate z*3.75
  rotate y*CubeRot
}
#end
  
#declare n = 0;
#declare Swap = true;
#declare CubeGems =
union{
  #while(n<360)
    #if(Swap)
      #declare CubeTex = texture{T_Ruby_Glass}
      #declare Swap = false;
    #else
      #declare CubeTex = texture{
        finish { F_Glass4 }
        pigment { color rgbf <0.1, 0.15, 0.75, 0.9> }
      }
      #declare Swap = true;
    #end
    MakeCube(n)
    #declare n = n+10;
  #end
  translate y*2
}

#macro MakeTear(TearRot)
  union{
    sphere{0, 1/2}
    cone{y*1/4, 1/4, y*1, 0}
    texture{T_Green_Glass}
    interior{I_Glass}
    rotate x*-10
    translate z*4
    rotate y*TearRot
  }
#end  

#declare n = 0;
#declare TearGems =
union{
  #while(n<360)
    MakeTear(n)
    #declare n = n+20;
  #end
  translate y*1/2
}

union{
  difference{
    cone{0, 4, y*2.5, 3.5}
    cone{y*-0.01, 3.99, y*2.51, 3.49}
  }
  union{
    cylinder{0, z*-1, 1 texture{T_Gold_4C} normal{granite 1/4}}
    sphere{0, 2/3 scale<1,1,1/4> translate z*-1 texture{T_Ruby_Glass} interior{I_Glass}}
    scale<1,1.5,1> rotate x*20 translate z*-4 translate y*-1/2 rotate y*10
  }
  object{CubeGems}
  object{TearGems}
  texture{
    agate scale 1/4
    texture_map{
      [1/2 T_Gold_4C normal{granite 1/4}]
      [1/2 pigment{rgbf 1}]
    }
  }
  scale 1
  rotate z*-10  
  rotate x*-35
  translate<1.5,88,-32>
}
