// Persistence of Vision Ray Tracer Scene Description File
// File: ?.pov
// Vers: 3.1g.wmp.0.6a
// Desc: Basic Scene Example
// Date: dd/mm/yy
// Auth: Tom Melly, http://www.tomandlu.co.uk, tom@tomandlu.co.uk
//

#version unofficial MegaPov 0.6;

//jewels for hat center
#macro MakeCenterGem(GemTex, ZR)
difference{
  sphere{0,1}
  plane{x, 0 rotate y*-15}  
  plane{-x, 0 rotate y*15}
  texture{GemTex}
  interior{I_Glass}
  rotate x*-90
  rotate z*ZR
}
#end

#declare CenterGems =
union{
  MakeCenterGem(T_Ruby_Glass, 0)
  MakeCenterGem(T_Green_Glass, (360/8)*1)
  MakeCenterGem(T_Ruby_Glass, (360/8)*2)
  MakeCenterGem(T_Green_Glass, (360/8)*3)
  MakeCenterGem(T_Ruby_Glass, (360/8)*4)
  MakeCenterGem(T_Green_Glass, (360/8)*5)
  MakeCenterGem(T_Ruby_Glass, (360/8)*6)
  MakeCenterGem(T_Green_Glass, (360/8)*7)
  scale 1.5
}

#declare turban =
union{
  union{
    difference{sphere{0,5.0} plane{y, 0}}
    torus{3.5,1.6}
    rotate z*-35
    pigment{rgb<226/255, 127/255, 67/255>}
    normal{average normal_map{[marble 10 scale 2 turbulence 1/5 rotate z*55][wrinkles 1/2 scale 1/2]}}
    finish{reflection 0.1 diffuse 0.8 brilliance 4 specular 0.6 roughness 0.05 metallic 0}
  }  
  union{
    difference{sphere{0,4.9} plane{y, 0}}
    torus{3.5,1.5}
    rotate z*35
    pigment{rgb<226/255, 127/255, 67/255>}
    normal{average normal_map{[marble 10 scale 2 turbulence 1/5 rotate z*-55][wrinkles 1/2 scale 1/2]}}
    finish{reflection 0.1 diffuse 0.8 brilliance 4 specular 0.6 roughness 0.05 metallic 0}
  }
  
  scale<1.5,1.25,0.75>
}

#declare centre_piece = 
union{
  sphere{0, 2}
  #declare Count = -45;
  #while(Count <= 45)
    union{
      sphere{0,1/3 texture{T_Green_Glass} interior{I_Glass} translate z*(-2/3)}
      sphere{0, 2/3}
      translate< 2.5, 0, 1/10> rotate z*Count
    }
    union{
      sphere{0,1/3 texture{T_Green_Glass} interior{I_Glass} translate z*(-2/3)}
      sphere{0, 2/3}
      translate<-2.5, 0, 1/10> rotate z*Count
    }
    #declare Count = Count + 45;
  #end
  object{CenterGems translate z*-2}
  scale<1,1,1/4>
  texture{T_Gold_4C}
  normal{granite 1/10}
  translate <0,1,-3.95>
}  

#declare outer_torus =
difference{
  torus{2, 1/2}
  plane{z,0.001}
}

#declare inner_torus =
difference{
  torus{1, 1/2 translate<1,0,0>}
  plane{-z, -0.001}
}

#declare turban_torus_part =
union{
  object{outer_torus}
  object{inner_torus}//2.5,-45degZ ,0
  sphere{0,1}
  sphere{0,1/2 texture{T_Green_Glass} translate y*-1}
  #declare n = 0;
  #declare oddGem = true;
  #while(n<12)
    sphere{0,1/6 texture{T_Ruby_Glass} interior{I_Glass} translate x*-2 rotate y*((180/12)*n) translate y*(-1/2)}
    #if(oddGem)
      sphere{0,1/6 texture{T_Ruby_Glass} interior{I_Glass} translate x*1 rotate y*((180/12)*n) translate y*(-1/2) translate x*1}
      #declare oddGem = false;
    #else
      #declare oddGem = true;
    #end
    #declare n = n+1;
  #end
}

#declare turban_torus_part_fringe =
union{
  object{outer_torus}
  object{inner_torus}//2.5,-45degZ ,0
  sphere{0,1}
  sphere{0,1/2 texture{T_Green_Glass} translate y*-1}
}

#declare turban_torus =
union{
  object{
    turban_torus_part
    texture{T_Gold_4C}
    normal{granite 1/10}
  }
  object{
    turban_torus_part_fringe
    scale<5/4, 1/3, 5/4>
    texture{
      pigment{YellowGreen*0.5}
      normal{average normal_map{
        [granite 0.1]
        [bozo 1]
      }}
      finish{diffuse 0.5 reflection 0.2 brilliance 5 specular 0.7 roughness 0.001 irid{0.3 thickness 1/2 turbulence 1/4}}
    }
  }
  rotate x*90
  rotate z*205
  translate <-4,-1.5,-3>
}

#declare peacock =
union{
  sphere{0, 1 scale<3/4, 1, 1/4>}
  sphere{0, 1/2 translate z*(-1/4) texture{T_Vicksbottle_Glass} interior{I_Glass}}
  sphere{y*1, 1 scale<1,1,1/5> translate z*0.25}
  #declare N = 60;
  #while(N <= 300)
    sphere{y*-1, 1/2 scale<1/2,1,1/6> rotate z*N translate z*0.5 translate y*1}
    sphere{0, 1.5
      pigment{
        cylindrical
        rotate x*90
        scale 1.5
        pigment_map{
          [0.5 rgb<211/255, 140/255, 122/255>]
          [0.5 SummerSky]
          [0.7 SummerSky]
          [0.7 Navy]
        }
      }
      translate y*-2.25
      normal{wrinkles 0.5}
      finish{diffuse 0.5 reflection 0.1 brilliance 5 specular 0.7 roughness 0.001}// irid{0.1 thickness 1/4 turbulence 1/8}}
      scale<2/3,1,1/7> rotate z*N translate z*0.75 translate y*1
    }      
    #declare N = N + 30;
  #end
  difference{
    cylinder{z*0.75, z*1, 6}
    plane{y, 0}
    texture{
      pigment{average pigment_map{
        [radial frequency 60 rotate x*90 pigment_map{[0 ForestGreen*0.1][1 ForestGreen*0.5]}]
        [spherical scale 5 pigment_map{[0 Yellow*0.5][1/6 YellowGreen*0.25][1 Green*0.25]} turbulence 0.1]
      }}
      normal{average normal_map{
        [granite 0.1]
        [bozo 1]
      }}
      finish{diffuse 0.5 reflection 0.2 brilliance 5 specular 0.7 roughness 0.001 irid{0.3 thickness 1/2 turbulence 1/4}}
    }
  }
  texture{T_Gold_4C}
  normal{granite 1/10}
  scale 1
  translate <0,4,-3.95>
}

#declare full_hat =
union{
  object{turban}
  union{
    object{centre_piece}
    object{turban_torus}
    object{turban_torus translate<-2,-2,1>}
    object{turban_torus scale<-1,1,1>}
    object{turban_torus translate<-2,-2,1> scale<-1,1,1>}
    object{peacock translate z*0.75}
    object{peacock rotate z*70 translate<-2, -1, 1.5>}
    object{peacock rotate z*-70 translate<2, -1, 1.5>}
  }
}

//#declare foobar =
object{
  full_hat
  
  translate x*5
  rotate y*-15
  translate x*-5

  rotate x*25
  rotate z*-15

  translate<5.5,101,-35>
}

  


