// Persistence of Vision Ray Tracer Scene Description File
// File: ?.pov
// Vers: 3.1g.wmp.0.6a
// Desc: Basic Scene Example
// Date: dd/mm/yy
// Auth: Tom Melly, http://www.tomandlu.co.uk, tom@tomandlu.co.uk
//

// Persistence of Vision Ray Tracer Scene Description File
// File: ?.pov
// Vers: 3.1g.wmp.0.6a
// Desc: Basic Scene Example
// Date: dd/mm/yy
// Auth: Tom Melly, http://www.tomandlu.co.uk, tom@tomandlu.co.uk
//

#version unofficial MegaPov 0.6;

// ----------------------------------------

#declare One_Petal =
intersection{
  difference{
    sphere{<-1,0,0>, 1.00}
    sphere{<-1,0,0>, 0.98}
  }
  sphere{0,0.5}
  translate y*0.5
  translate x*0.1
}

#declare Rand1 = seed(463245);

#macro MakeRose()
  #declare Count = 1;
  #declare Rose1 =
  union{
    #while(Count <= 35)
      object{
        One_Petal
        #declare n = rand(Rand1);
        scale <1,1,( 0.25 + (Count/35) + n/4 )>
        #declare n = rand(Rand1);
        rotate x*( (n*10)-5 )
        #declare n = rand(Rand1);
        rotate z*( - ( (sqrt(Count*8)) + (40*n) ) )
        #declare n = rand(Rand1);
        rotate y*( Count*(35 + (35*n)) )
      }
      #declare Count = Count + 1;
    #end
    sphere{0, 0.2}
    rotate x*-90
    scale 2
  }
#end
   
#init_3d_spline {"Rose_Spline1",
  <-0.001,-7,5>,
  <-10,0,-2>,
  <-12,-15,-8>,
  <0,-65,-10>,
  <11,-15,-8>,
  <9,0,1>,
  <0.001,-5,5>,
}

#declare rose_count = 0;
#declare PigCount = 4;
#declare RoseGarland =
union{
  #while(rose_count<1)
    #if(PigCount = 5)
      #declare ThisPigment = pigment{Yellow}
      #declare ThisFinish = finish{diffuse 0.8 ambient 0.2}
      #declare PigCount = 1;
    #else
      #declare ThisPigment = pigment{Red}
      #declare ThisFinish = finish{diffuse 0.7 ambient 0}
      #declare PigCount = PigCount + 1;
    #end
    MakeRose()
    object{
      Rose1
      pigment{ThisPigment}
      normal{bozo 2 scale 1/4}
      finish{ThisFinish}
      scale 1.5
      translate eval_3d_spline ("Rose_Spline1", rose_count)
    }
    #if(rose_count > 0.45 & rose_count < 0.55)
      #if(rose_count > 0.475 & rose_count < 0.525)
        #declare rose_count = rose_count + 0.065;
      #else
        #declare rose_count = rose_count + 0.060;
      #end      
    #else
      #declare rose_count = rose_count + 0.015;
    #end    
  #end  
}

object{
  RoseGarland
  //scale<1.5, 1, 1.0>
  translate<1,86,-30> //z was -35
}