// Persistence of Vision Ray Tracer Scene Description File
// File: waist_fans2.inc
// Vers: 3.1g.wmp.0.6a
// Desc: Basic Scene Example
// Date: dd/mm/yy
// Auth: Tom Melly, http://www.tomandlu.co.uk, tom@tomandlu.co.uk
//

#version unofficial MegaPov 0.6;

#declare Pattern_Base_Pig =
pigment{rgb<246/255, 117/255, 1/255>}


#declare Rand1 = seed(777);//575967435(nice) //654//12348

#declare MandelPig =
pigment{
  mandel 500
  pigment_map{
    [0 Pattern_Base_Pig]
    #declare n = 0.004;
    #while(n <1)
      [n rgb<rand(Rand1), rand(Rand1), rand(Rand1)>]
      #declare n = n+(0.004 * (rand(Rand1)+1) ); //0.0044 looks ok
    #end
  }
  rotate z*-90
  scale <3, 6, 1>
  translate y*-22
}


#macro MakePartPanel(TransA, PlaneA, PanelTex)
  #declare PartPanel =
  difference{
    sphere{
      0,10
    }
    plane{
      x,0
      rotate z*2
      rotate y*10
    }
    plane{
      -x, 0
      rotate z*-2
      rotate y*-11
    }
    plane{
      y, PlaneA
    }
    translate y*-10
    translate y*TransA
    rotate x*-90
    scale 5
    texture{
      PanelTex
      normal{average normal_map{[marble 1/2 scale 5 turbulence 1][quilted 1/2 scale 1/3][bozo][bozo 1 scale 1/4]}}
      finish{reflection 0.1 diffuse 0.6 brilliance 5 specular 0.6 roughness 0.005 metallic 0}
    }
  }
#end

#declare PurplePig =
pigment{
  bozo
  pigment_map{
    #declare n = 0;
    #while(n<=1)
      [n rgb<rand(Rand1) rand(Rand1) rand(Rand1)>]
      #declare n = n + 0.1;
    #end
  }
}

MakePartPanel(0.00,7.00, texture{pigment{Pattern_Base_Pig}})
#declare PPA = PartPanel
MakePartPanel(0.01,7.50, texture{pigment{PurplePig}})
#declare PPB = PartPanel
MakePartPanel(0.02,8.25,  texture{pigment{MandelPig}})
#declare PPC = PartPanel

#declare OneFan =
union{
  object{PPA}
  object{PPB}
  object{PPC}
}


#declare AllFans =
intersection{
  union{
    object{OneFan}
    object{OneFan rotate z*25 translate z*1}
    object{OneFan rotate z*50 translate z*2}
    object{OneFan rotate z*-25 translate z*1}
    object{OneFan rotate z*-50 translate z*2}
  }
  plane{y, 0 pigment{rgb<226/255, 127/255, 67/255>}}
  rotate x*25 translate<-2, 65, -35>
}

object{AllFans}

