#version unofficial MegaPov 0.6;
#include "colors.inc"

//============================ READ THIS FIRST ==============================
/*
For bandwidth (file size) and copyright (esp. Poser models) purposes, the
various meshes and uv-maps are not supplied.  The "switches" section here
below has these elements turned off.

The "etabli" (tools support) section needs a "machin.msh" mesh file, which
can be generated by feeding the provided "fmplaid.pov" scene into ClothRay
or POVMan patches.

Coding is not as clean as it could.  If you want a cleaner version, with
english comments, ask fabien.mosen@skynet.be.  (I'll happily do it, but
won't do it until at least 1 person wants it !!)
*/
//============================ dfinition d'units ==========================
#declare CentiMetre = 1;
#declare Metre = CentiMetre*100;
#declare KiloMetre = Metre*1000;

//============================ switches de la scne ==========================
#declare FloconSwitch   = 1; //flocons de neige
#declare GlaceTexSwitch = 1; //texture de glace (0=opaque)
#declare ClebsSwitch    = 0; //les chiens
#declare EtabliSwitch   = 1; //tabli avec outils
#declare SculptSwitch   = 1; //l'ensemble des sculptures
#declare MontagneSwitch = 1; //le grand HF
#declare TracesSwitch   = 1; //le petit HF
#declare HF_Res = 500; //rsolution du grand HF. finale 500, tests 250

//===================================CAMERA, LUMIERES, ENVIR.==========================
camera {location <0,50,0> look_at <-1000,150,0> angle 100}

//principale :
light_source {<40,50,30>*KiloMetre White*1.2}
//bleute, sans ombres, de "dbouchage" :
light_source {<40,50,30>*KiloMetre <.91,.89,1>*.9 shadowless rotate y*180}
//pour clairer les "cracks" du HF (sinon y'a des crevasses noires)
light_source {<0,-5,0>*KiloMetre White*5}
//pour simuler la lumire renvoye par le sol
light_source {<0,-5,0>*KiloMetre White*1 shadowless}

global_settings {max_trace_level 20 
                 adc_bailout 1/25
                 //photons {spacing 1 gather 5,15}
                 }

sky_sphere {
 pigment {gradient y color_map {
   [0.0 color rgb <0.722,0.788,0.851>]
   [0.3 color rgb <0.639,0.749,0.843>]
   [0.6 color rgb <0.537,0.682,0.784>]
   [1.0 color rgb <0.482,0.624,0.757>]
 }
 turbulence .2 lambda 3 octaves 6 omega .8 }
 }
 fog {distance 15000 Gray70 transmit .7}
//=================================== TEXTURE GLACE ==========================
#declare Glace = material {
texture {
pigment {rgbft <.98,.98,1,.7,.3>}
normal {bumps .2 scale 1 turbulence .5}
finish {phong .2
        //reflection .1
        reflection_type 1 reflection_min .1 reflection_max 1 
        conserve_energy
}        
}
interior {
 ior 1.309
 media {emission .006
        absorption .006
        }

}
}

#if (GlaceTexSwitch = off)
 #declare Glace = material {texture {pigment {White*1.5}}}
#else #end

//===================================FLOCONS DE NEIGE==========================

#declare Flocon = sphere {
<0,0,0>,2 pigment {White transmit 1} hollow
interior {
 media {emission 1
  density
  {
  spherical color_map {[0 Black][1 White*.5]}
  turbulence .6
  } 
  }
 }       
}

#declare Flocon2 = sphere {
<0,0,0>,2 pigment {White transmit 1} hollow
interior {
 media {emission 1
  density
  {
  spherical color_map {[0 Black][1 White*.5]}
  turbulence .6
  } 
  }
 }       
}
           
#declare Flocons = union {
#declare I=0;
#while (I < 1*FloconSwitch)
 object {Flocon rotate <rand(r1),rand(r1),rand(r1)>*360 scale rand(r1)*1+.5 translate <rand(r1),rand(r1),rand(r1)>*500}
#declare I=I+.001;
#end             
no_shadow
}

#declare Flocons2 = union {
#declare I=0;
#while (I < 1*FloconSwitch)
 object {Flocon2 rotate <rand(r1),rand(r1),rand(r1)>*360 scale rand(r1)*1+.5 translate <rand(r1),rand(r1),rand(r1)>*<100,500,500>}
#declare I=I+.001;
#end             
no_shadow
}

//=================================== HF RELIEF MONTAGNE ==========================
#declare Fun1=function {"ridgedmf", <1,2,7,1,2>}

#declare PigFrac = pigment {function Fun1*.2 color_map {[0 Black][.5 White][1 White]}}

#if (MontagneSwitch)
#declare Montagne_HF = 
height_field {pattern HF_Res,HF_Res
              {
              hf_gray_16 
              PigFrac
              scale 2
              }        
              smooth      
              translate <-.5,-.55,-.5>       
              scale <1,1,1>*.5*KiloMetre
              }

#declare Montagne3 =
object {Montagne_HF          
              hollow
              translate y*1125 
              rotate y*70
              pigment {White}
              finish {ambient <.8,.8,1>*.3}
              }    
#end              
//=================================== HF traces de pas ==========================
#if (TracesSwitch)
//#declare PigTraces = pigment {bumps color_map {[0 Black][1 White]} warp {turbulence .2} scale .005}
#declare BozoPig = pigment {bozo color_map {[0 Black][1 White]}}
#declare PigTraces = pigment {
 average
 pigment_map {
 [.3 BozoPig scale 1]
 [.3 BozoPig scale .3]
 [.3 BozoPig scale .1]
 }
 scale .01
}

#declare Traces_HF = 
height_field {pattern HF_Res*1.2,HF_Res*1.2
              {
              hf_gray_16 
              PigTraces
              }        
              smooth      
              pigment {slope y color_map {[0 White][.5 White*.9][1 White]}}
              finish {ambient <.8,.8,1>*.4}
              translate <-1,0,-.5>
              scale <500,12,1000>
              rotate <-10,0,5>
              translate y*13
              }   
#end              
//=================================== Sculptures ==========================
#if (SculptSwitch = on)

#include "sculpt.inc"

merge {
 object {Socle}
 object {OsGeant scale .8 translate y*92}
 rotate y*40 translate <-150,-30,0> 
 material {Glace} 
 //pigment {Green} 
 hollow
 photons {target 1 refraction on reflection off}
 //===========RESERVE OS================
 }
 
// Table de Loi 
merge {
 object {Socle}
 object {FM_Sculpt_B1 scale .7 rotate x*-30 translate y*110}
 rotate y*90 translate <-220,0,200> 
 material {Glace}
 //pigment {Cyan}
 hollow
 photons {target 1 refraction on reflection off}
 }  
 
//Roi Mage 
merge {
 object {Socle}
 object {FM_Sculpt_B2 scale .5 rotate y*90 translate y*90}
  translate <-120,-50,120> 
 material {Glace} 
 //pigment {Magenta}
 hollow
 photons {target 1 refraction on reflection off}
 } 
 
//Jesus ?
merge {
 object {Socle translate y*-20}
 object {FM_Sculpt_B3 rotate y*30 translate y*90}
 scale 1.2
 rotate y*80 translate <-200,-30,100> 
 material {Glace}
 //pigment {Red}
 hollow                                         
 photons {target 1 refraction on reflection off}
 }                   

 //----------MARTIAL-----------
//ALlezLa
merge {
 object {Socle}
 object {MR_Sculpt_B3 rotate y*70 translate y*90}
 scale 1.1
 rotate y*80 translate <-200,-50,-80> 
 material {Glace} 
 //pigment {Blue} 
 hollow
 photons {target 1 refraction on reflection off}
 }

//tentation 
merge {
        object {Socle scale <.8,1,.8> rotate y*40 translate y*-5}
        object {MR_Sculpt_B4  translate y*85}
        scale 1.2  
        rotate y*0 translate <-150,-80,-100> 
        material {Glace} 
       //  pigment {Orange}
         hollow
         photons {target 1 refraction on reflection off}
 }


#else #end //SculptSwitch

//=================================== PLACEMENTS DIVERS ==========================
object {Flocons translate <-200,0,-250>}
//object {Flocons2 translate <-100,0,-250>}

#if (MontagneSwitch) object {Montagne3} #end//grand hf 

#if (TracesSwitch)   object {Traces_HF} #end//petit hf traces de pas

#if (EtabliSwitch=1)
 #include "outils005.inc"

 #declare Etabli=
union { 
object {Plaid scale <1,.5,1> translate y*0} //rotate y*20    translate y*.001
object {Maillet rotate x*-85 rotate y*  5 translate <05,9,-25>}// rotate y*20 translate <-10,0,0>}
object {Bur1_a  rotate x*-90 rotate y* 10 translate <-15,11,-40> }// rotate y*15  translate <-5,0.2,-10> } 
object {Bur1_b  rotate x* 90 rotate y*-40 translate <-25,10,-55>}// rotate y*10  }// <20,0,-3>
object {Scie2  scale <.5,.5,1> rotate x* 90 rotate y*110 rotate z*-10 translate <18,11,-55>}//  }// ou Scie1 <30,0,0>
}

 object {Etabli scale .8 rotate y*-90 rotate <-10,0,7> translate <-100,4,0>}
#else #end

//=================================== PLACEMENTS CHIENS ==========================
#if (ClebsSwitch=on)

//texture  mettre en layer, pour l'aoi.
#declare Velours = texture {pigment {aoi color_map {[0 Clear][.5 White filter .3][1 Clear]}}
                            //pigment {aoi color_map {[0 Clear][.5 Red][1 Clear]}}
                            normal {bumps .2}
                            }

//les deux chiens  fourrure beige
#declare T_def_mat = 
texture {
	pigment {image_map {png "maps\clebs1"} scale <1,-1,1>}
	normal {bump_map {png "maps\clebs1"} 5 scale <1,-1,1>} 
	finish  {crand .03 specular .1 brilliance .6}}
texture {Velours}

#include "meshes\clebs1_g.inc"
object{ P_Figure_1 scale 130 rotate y*-30 translate <-100,4,-33>}
object{ P_Figure_1 scale 100 rotate y*-90 translate <-100,17,30>}


//le petit chien debout
#declare P_CHIEN3= pigment {image_map{png "maps\Chien"}}
#declare T_CHIEN3=texture {pigment {P_CHIEN3} 
                           normal {bump_map {png "maps\Chien"} 5 scale <1,-1,1>} 
	                   finish  {crand .03 specular .1 brilliance .6} 
	                   }
                  texture {Velours}   
                  
#include "meshes\Chien2.inc"
#declare Chien3 = object {Chien2 scale 90 }
object {Chien3 rotate y*-60 translate <-100,7,-10> }

//le chien-loup
#declare T_CHIEN=texture {pigment {image_map{png "maps\wolfmap"}} 
                          normal {bump_map {png "maps\wolfmap"} 5 scale <1,-1,1>} 
	                  finish  {crand .03 specular .1 brilliance .6} 
	                  }
                 texture {Velours}
                 
#include "meshes\wolf.inc"
//object {Chien scale .5 rotate <-90,-110,0> translate <-90,30,20>}
difference{
object {Chien scale .5 rotate <-90,0,0> }
box {<-1,-.1,1.2><1,2,6> 
     //texture {T_CHIEN} 
     pigment {rgb <0.690,0.494,0.482>}
     rotate x*-56  translate <0,-.285,-35> } //  

// transformation comme avant
rotate y*-110 translate <-90,32,20>
}

#else #end