//fires, clouds, lanterns, lamps, etc.

#declare gold_texture = texture
{
        pigment
        {
                dents
                color_map
                {
                        [ 0.0 color rgb< 1, 0.8, 0 > ]
                        [ 0.1 color rgb< 1, 0.8, 0.5 > ]
                }
        }
        finish
        {
                reflection 0.9
                phong 1
        }
}

#declare cloud_material = material
{
        texture
        {
                pigment
                {
                        color rgbt< 1, 1, 1, 1 >
                }
        }
        interior
        {
                media
                {
                        scattering 
                        {
                                5
                                color rgb< 3, 3, 3 >
                        }
                        density
                        {
                                spherical
                                color_map
                                {
                                        [ 0.0  rgb <0.0, 0.0, 0.0> ]
                                        [ 0.5  rgb <0.0, 0.0, 0.0> ]
                                        [ 1.0  rgb <5.0, 5.0, 5.0> ]
                                }
                                turbulence 0.2
                                omega 0.8
                                triangle_wave
                        }
                }
        }
}

#declare smoke_material = material
{
        texture
        {
                pigment
                {
                        color rgbt< 1, 1, 1, 1 >
                }
        }
        interior
        {
                media
                {
                        scattering 
                        {
                                3
                                color rgb< 1, 1, 1 >
                        }
                        density
                        {
                                spherical
                                color_map
                                {
                                        [ 0.0  rgb <0.0, 0.0, 0.0> ]
                                        [ 0.5  rgb <0.0, 0.0, 0.0> ]
                                        [ 1.0  rgb <50, 50, 50> ]
                                }
                                turbulence 0.5
                                omega 0.8
                                triangle_wave
                        }
                }
        }
}


#declare fire_material = material
{
        texture
        {
                pigment
                {
                        color rgbt< 1, 1, 1, 1 >
                }
        }
        interior
        {
                media
                {
                        emission rgb < 12, 7, 3 >
                        density
                        {
                                spherical
                                color_map
                                {
                                        [ 0.0  rgb <0.0, 0.0, 0.0> ]
                                        [ 0.5  rgb <0.0, 0.0, 0.0> ]
                                        [ 1.0  rgb <5, 5, 5> ]
                                }
                                turbulence 0.5
                                omega 0.8
                                triangle_wave
                        }
                }
        }
}

#declare lamp = union
{
        cylinder
        {
                < 0,-1,0 > < 0,1,0 >,1
                scale< 1, 10, 1 >
                translate< 0, 2, 0 >
        }
        sphere
        {
                < 0, 0, 0 >, 1
                scale< 2, 2, 2 >
                translate< 0, -5, 0 >
        }
        difference
        {
                sphere
                {
                        < 0, 0, 0 >, 1
                        scale< 5, 5, 5 >
                        translate< 0, -10, 0 >
                }
                union
                {       
                        cylinder
                        {
                                < -1, 0, 0 > < 1, 0, 0 >,1
                                scale< 5, 3, 3 >
                        }
                        cylinder
                        {
                                < 0, 0, -1 > < 0, 0, 1 >,1
                                scale< 3, 3, 5 >
                        }
                        translate< 0, -10, 0 >
                }
        }
        difference
        {
                sphere
                {
                        < 0, 0, 0 >,1
                }
                box
                {
                        < 1, 1, 1 > < -1, 0, -1 >
                }
                scale< 5, 5, 5 >
                translate< 0, 15, 0 >

        }
}

#declare fire = union
{       
        sphere
        {
                <0,0,0>,1              
                material{smoke_material}
                rotate< 90, 0, 0 >
                scale< 1, 4, 1 >
                translate< 0, 1.5, 0 >   
                hollow
        } 
        sphere
        {
                <0,0,0>,1
                material{fire_material}
                scale< 1, 2, 1 >
                hollow
        }
}

#declare lamp_with_fire = union
{       
        object
        {
                lamp
                hollow
                texture
                {
                        gold_texture
                }
        }
        object
        {
                fire
                hollow
                translate< 0, 3.9, 0 >
                scale< 5, 5, 5 >
        }
}

#declare cloud = sphere
{
        < 0, 0, 0 >,1
        hollow
        material
        {
                cloud_material
        }
}        