//the world

#declare ground_texture = texture
{
        pigment
        {
                color rgb< 1.0, 0.8, 0 >
        }
        normal
        {
                waves 0.06
                frequency 10000000.0
                scale 100.0
                turbulence 0.3
        }
        finish
        {
                roughness 30
                specular 0.2
        }  

}

#declare small_moon_texture = texture
{
        pigment
        {
                bozo
                color_map
                {
                        [0.0 color rgb < 0.2, 0.6, 0.6 > ]
                        [0.5 color rgb < 0.8, 0.6, 0.2 > ]
                        [1.0 color rgb < 1, 1, 1 > ]
                }
                turbulence 2
        }
        normal
        {
                bump_map
                {
                        png "moonbump"
                        map_type 2
                        bump_size 5
                }
        }
}

#declare big_moon_texture = texture
{
        pigment
        {
                bozo
                color_map
                {
                        [0.0 color rgb < 0.8, 0.6, 0.1 > ]
                        [1.0 color rgb < 0.5, 0.0, 0.0 > ]
                }
                turbulence 1
        }
        normal
        {
                bump_map
                {
                        png "moonbump"
                        map_type 2
                        bump_size 10
                }
        }
}

#declare air_material = material
{
        texture
        {
                pigment
                {
                        color rgbt< 1, 1, 1, 1 >
                }
        }
        interior
        {
                media
                {
                        scattering 
                        {
                                1
                                color rgb< 0.25, 0.5, 1.0 >
                        }
                        density
                        {
                                spherical
                                color_map
                                {
                                        [ 0.0  rgb <0.0, 0.0, 0.0> ]
                                        [ 0.01  rgb <0.001, 0.001, 0.001> ]
                                        //[ 0.00005  rgb <0.005, 0.005, 0.005> ]
                                }
                                triangle_wave
                        }
                }
        }
}

#declare sand_material = material
{
        texture
        {
                pigment
                {
                        color rgbt< 1, 1, 1, 1 >
                }
        }
        interior
        {
                media
                {
                        scattering 
                        {
                                3
                                color rgb< 10, 5, 0 >
                        }
                        density
                        {
                                spherical
                                color_map
                                {
                                        [ 0.0  rgb <0.0, 0.0, 0.0> ]
                                        [ 0.5  rgb <5, 5, 5> ]
                                        [ 1.0  rgb <2.5, 2.5, 2.5> ]
                                }
                                triangle_wave
                        }
                }
        }
}

#declare planet = sphere
{
        < 0, 0, 0 >,1
}

#declare world = union
{       
        object
        {
                planet
                texture{ ground_texture }
        } 
        object
        {
                planet
                material{ sand_material }
                hollow
                scale< 1.0005, 1.0005, 1.0005 >
        } 
        object
        {
                planet
                material{ air_material }
                hollow
                scale< 1.25, 1.25, 1.25 >
        }    
}

#declare small_moon = union
{
        object
        {
                planet
                texture{ small_moon_texture }
        }
}

#declare big_moon = union
{
        object
        {
                planet
                texture{ big_moon_texture }
        }
}

#declare planet_system = union
{
        object{ world }
        object
        {
                big_moon
                scale< 0.5, 0.5, 0.5 >
                translate< 10, 0, 0 >
                rotate< 0, 0, 22 >
                rotate< 0, 90, 0 >
        }
        object
        {
                small_moon
                scale< 0.1, 0.1, 0.1 >
                translate< 5, 0 ,0 >
                rotate< 0, 0, 22 >
                rotate< 0, 97, 0 >
        }
}
        