//
//    EMAIL: castlewrks@aol.com
//    NAME: Robert J Becraft
//    TOPIC:  Fortress
//    COPYRIGHT: I SUBMIT TO THE STANDARD RAYTRACING COMPETITION COPYRIGHT.
//    TITLE: "Asgard"
//    COUNTRY: USA
//    WEBPAGE: http://www.angelfire.com/md2/castlewrks <<<<<<<------- VERY Important.
//             http://www.geocities.com/siliconvalley/labs/6080
//    RENDERER USED:  MegaPov 0.7
//    TOOLS USED: Povray (image creation), I_view32 (TGA>JPG conversion), 
//                PaintShop Pro (add copyright), FastZip98 (zip)
//    RENDER TIME: about 5 hours 51 minutes, 270 meg
//    HARDWARE USED: Pentium 700
//    IMAGE DESCRIPTION:
//
//    This image is a conceptual image of Asgard from near the Bifrost rainbow bridge.
//    Asgard is the kingdom of the norse gods and floats above the other worlds resting
//    on the tree Yggdrasil.                                                         
//    
//
//    DESCRIPTION OF HOW THIS IMAGE WAS CREATED:
//
//    This image was created first by researching Asgard and the technical details of how
//    Asgard should look.  After that it was a matter of creating the objects to carry off
//    the illusion.  The fortress is a circular collection of towers replicated around its
//    perimeter.  The gate is designed as the approach off of the rainbow.  Many of the gods
//    were afraid they would break the bridge, thus treaded there very lightly.
//    
//    To create the illusion of the Yggdrasil tree, I spent 90% of my time messing with a
//    variety of textures, code etc.  The result is represented here...my goal was to have
//    great arms of the tree stretching upwards to support Asgard.  I also spent alot of
//    time on getting textures for the swirling clouds below Asgard to come out right.  The
//    white fog all but obscured these.
// 
//    Stalagtites were created by inverting the heightfields.  The fortress walls have a
//    large block scale to them since they were built by a giant who hauled large stones
//    with the aid of his horse.  He was contracted by the gods to build the wall and would
//    have received Freya as his wife.  When the gods realized he would complete the wall by
//    the contracted date, Loki distracted his horse.  The giant got pissed and went to
//    complain and was wacked on the head by Thor, killing him.
//
//    Asgard was actually a large land-mass that contained kingdoms for each of the gods. 
//    This picture only shows the entry point to that land.  The mountains in the background
//    are part of the Asgard mountain range that separated this part of Asgard from other
//    lands.  They were created by a random repetition of heightfields and hazed with a purple 
//    fog.
//
//    In the center of Asgard all the gods had temples.  Odin was able to look down on man
//    in Midgard from his temple, so I have represented that in the center on a hill behind
//    the giant built walls. 
//  
//    The final additions were some soldiers for scale and pointier stalagtites for the
//    underside of Asgard.
//
#version unofficial MegaPov 0.7;                                 
#include "kolors.inc"   // ken's kolor file
#include "stones1.inc"
#include "glass.inc"
#include "woods.inc"
#include "metals.inc"
#include "textures.inc"
#include "../med/brick.inc" 
#include "castletext.inc" 
#declare RS=seed(144);

global_settings {
                    max_trace_level 30          // default POV setting is 5
                 //   max_intersections 256    // default POV setting is 64... istack_overflows not= 0 increase
                 }

#declare XX=on;               // turns on yggdrasil tree
//#declare CloudPlane=off;    // turns off clouds (upper/lower)
//#declare MenOff=off;        // turns off men

camera {      
 //   location <15,10,-1388> look_at <0,5,-100>      
    location <15,10,-1188> look_at <0,5,-100>          
}

light_source{<500,500,-5000> color White*2}  // BIG light    

difference{
  sphere {<0,0,0> 400000}
  sphere {<0,0,0> 399999}
  box{<-400001,-400001,-400001><400001,0,400001>}


 texture{
  pigment {
    wrinkles //gradient y
    color_map {
      [0 color rgb <.65,.7,.9>]
      [1 color rgb <0.2, 0.5, 1>]
    }
    scale 1
  }
}
} // difference

difference{
  sphere {<0,0,0> 200000}
  sphere {<0,0,0> 199999}
  box{<-400001,-400001,-400001><400001,0,400001>}

 texture{
  pigment {
    bozo //wrinkles
    turbulence 50
    octaves 260
    lambda 5 //3 to 6
    omega 0.55 //0.2 to 0.6
    color_map {
     // [0 color rgbt <1, 1, 1, 1>]
      [0 color rgbt <0.98, 0.99, 0.99, .8>] 
      [0.5 color rgbt <1, 1, 1, 1>]           
      [1.0 color rgbt <0.98, 0.99, 0.99, .8>]      
     // [1 color rgbt <1, 1, 1, 1>]
    }
   // scale <.8, .1, .8>
  } 
  scale 80000000
 } // texture
} // difference

difference{
  sphere {<0,0,0> 6000}
  sphere {<0,0,0> 5999}
  box{<-8001,8001,-8001><8001,0,8001>}
 texture{pigment{color Black}}
}

fog {                                                 // White ground fog
  distance 500
  colour rgb<0.53, 0.62, 0.72>
  fog_type 2
  fog_offset 5
  fog_alt 30
  turbulence 1.0
  turb_depth 3.0
}

fog {                                                 // Pink/purple ground fog
  distance 8000
  colour rgb<0.53, 0.22, 0.72>
  fog_type 2
  fog_offset 50
  fog_alt 100
  turbulence 1.0
  turb_depth 3.0
}

#ifndef(CloudPlane)

plane {y, 5500 // clouds over fortress
  texture {
    pigment {
       wrinkles 
      //bozo
      turbulence 40
      omega .8
    lambda 5 //3 to 6
    omega 0.53 //0.2 to 0.6
      color_map {
        [0 color Gray40]
        [.15 color Gray90]
        [.2 color White]
       // [.55 color Clear]
       // [.6 color White]
        [.8 color Clear]
        [1 color Clear]
      } // color_map
    } // pigment
  finish {ambient .5 diffuse .8}
  scale <8000000,1,8000000>
//translate <-500,900,-10000>
 }  // texture
hollow
} // plane

plane {y, -250 // clouds under fortress
  texture {
    pigment {
      wrinkles //bozo
      turbulence 60
      omega .8
    lambda 5 //3 to 6
    omega 0.53 //0.2 to 0.6
      color_map {
        [0 color Gray40]
        [.15 color Gray90]
        [.2 color White]
       // [.55 color Clear]
       // [.6 color White]
        [.8 color Clear]
        [1 color Clear]
      } // color_map
    } // pigment
  finish {ambient .5 diffuse .8}
  scale 1600000
//translate <-500,900,-10000>
 }  // texture
hollow
} // plane
          
#end //ifndef(CloudPlane)                 


//--------------------- CSG Objects
#declare TLeaf3=
//texture {  
         pigment { crackle
           color_map {
            [0.0 color Clear]
            [0.1 color Clear]
            [0.17 color DarkGreen]
            [1.0 color Gray10] } }
//        finish { ambient .81 diffuse .0998 }
//        rotate<90,90,90>
//        scale .5
//}
#declare TLeaf2=
//texture {  
         pigment { crackle
           color_map {
            [0.0 color Clear]
            [0.2 color Clear]
            [0.27 color Green]
            [1.0 color ForestGreen] } }
//        finish { ambient .41 diffuse .998 } 
//        rotate<50,50,50>        
//        scale .5
//}
#declare TLeaf=
//texture {  
         pigment { crackle
           color_map {
            [0.0 color Clear]
            [0.2 color Clear]
            [0.27 color ForestGreen]
            [1.0 color Gray10] } }
//        finish { ambient .81 diffuse .0998 }
//        scale .5
//}
#declare Branch=pigment{crackle
           color_map {
            [0.0 color Gray10]
            [0.08 color DarkBrown]
            [0.12 color Clear]
            [1.0 color Clear] }
}      

#declare TLeafN=texture{
       pigment{crackle
            pigment_map{
              [0.1 TLeaf2]
              [0.3 Branch]
              [0.5 TLeaf] 
              [0.8 Branch]
              [1.0 TLeaf3]
            }
       }
       scale .5     
} 
#declare TreeTrunkTexture = texture {
  pigment { granite
     color_map {
      [0.1 color White]
      [0.2 color Gray10]
      [0.4 color Gray30]
      [0.6 color Gray]
      [0.8 color DarkBrown]
      [0.9 color DarkGreen] 
     }
   }
   scale <.51,7.5,.51> 
   normal{granite .05}
}          

//#declare TLeafN=texture{pigment{color Green}}

      
#macro TreeTop(YScale,TexSc,TOD,TX,TY,TZ,TXO,TYO,TZO)
 
//sphere { 0,1 scale<10,1,10>
  cone{<TX,TY,TZ>TOD/10 <TX+TXO,TY+TYO,TZ+TZO> TOD
       texture {  
         pigment { crackle
           color_map {
            [0.0 color Gray10]
            [0.08 color DarkBrown]
            [0.12 color Clear]
            [1.0 color Clear] } }
//        finish { ambient .001 diffuse .998 }
        scale <1,YScale,1>
       }
//       finish { ambient .000002 diffuse .999998 } 
  }


  #declare RC=1;
  #while (RC<=30)
     #declare RD=rand(RS)*TOD/2*3/5+TOD/2*2/5;
     #declare ROY=rand(RS)*360;
     #declare RY=rand(RS)*TOD-(TOD/2);
     #declare RZ=rand(RS)*TOD+5;
     #declare RSX=rand(RS)*1+.25;
     #declare RSY=rand(RS)*1+.25;
     #declare RSZ=rand(RS)*1+.25;
               
     sphere{ 0,RD
             scale<RSX,RSY,RSZ> 
             translate<0,0,RZ> 
             rotate<0,ROY,0>
             translate<0,RY,0>
             translate<TX+TXO,TY+TYO,TZ+TZO>
       texture {  TLeafN scale TexSc}
      }
     #declare RSX=rand(RS)*1+.25;
     #declare RSY=rand(RS)*1+.25;
     #declare RSZ=rand(RS)*1+.25;
                     
      sphere{ 0,RD*8/10 
             scale<RSX,RSY,RSZ>      
             translate<0,0,RZ> 
             rotate<0,ROY,0>
             translate<0,RY,0>
             translate<TX+TXO,TY+TYO,TZ+TZO>
       texture {  TLeafN scale TexSc }
      }
     #declare RSX=rand(RS)*1+.25;
     #declare RSY=rand(RS)*1+.25;
     #declare RSZ=rand(RS)*1+.25;
                     
      sphere{ 0,RD*7/10
             scale<RSX,RSY,RSZ>       
             translate<0,0,RZ> 
             rotate<0,ROY,0>
             translate<0,RY,0>
             translate<TX+TXO,TY+TYO,TZ+TZO>
       texture {  TLeafN scale TexSc}
      }
      
    #declare RC=RC+1;
  #end 
#end  // macro TreeTop
                    
#ifdef(XX) 
//TreeTop(20,1,5,  0, 5,0,-20,20,0)
  
  // Heavier Branches
  #declare ADiam=750;
  #declare RS=seed(8427);
  #declare C1=-33;
  #while (C1<=33)
    #declare R1X=0;    // start x
    #declare R1Y=rand(RS)*20-10;  // start y
    #declare R1Z=ADiam+30;  // start z
    #declare S1=rand(RS)*10+30;  // # of segements
    #declare S1C=1;       // counter 
    #declare RBD=rand(RS)*1+1;  // branch start diameter
    #declare RZR=400;
    #declare RYR=400;

    union{    
      #while (S1C<S1)
    
        #declare RZRR=rand(RS)*RZR/S1;
        #declare RZ1=R1Z-RZRR;
        #declare RYRR=rand(RS)*RYR/S1;    //+(rand(RS)*10-5);
        #declare RY1=R1Y-RYRR;
        #declare RX1=rand(RS)*25-12.5; // offset left/right

        cone{<R1X,R1Y,R1Z> RBD <RX1,RY1,RZ1> RBD*1.5}
        sphere{<R1X,R1Y,R1Z> RBD}       
        
        #declare S1=-10;
        #while (S1<10)        
          TreeTop(30,3,8,  R1X,R1Y,R1Z,S1+1,S1,0)
          #declare S1=S1+10;
        #end
        
        #declare R1X=RX1;
        #declare R1Y=RY1;
        #declare R1Z=RZ1;
        #declare RBD=RBD*(1+.5/S1);
        #declare RYR=RYR-RYRR;
        #declare RZR=RZR-RZRR;
       
        #declare S1C=S1C+1; // next segement
      #end
      #declare EY=rand(RS)*150+50;
      #declare EX=rand(RS)*100-50;
      cone{<R1X,R1Y,R1Z> RBD <0,-590+EY,ADiam-300+EX> RBD*3} 
      sphere{<0,-590+EY,ADiam-300+EX> RBD*3.5}
      
      rotate<0,C1+180,0> // position branch in proper place 
      translate<EX,0,0>
      texture{TreeTrunkTexture}
     }
            
    #declare C1=C1+rand(RS)*2+2; //+48*3.5/48;
  #end

#end //ifdef(XX)

#declare Minuret=union{
  cone{<0,-3,0>.5 <0,5,0> 4}
  cylinder{<0,5,0><0,15,0> 4}
  cylinder{<0,15,0><0,15.2,0> 4.1 texture{T_Stone8}}
  cone{<0,15.2,0> 4.1 <0,20,0> 0 texture{Gold_Nugget}}
}

#declare Tower1a=difference{
   union{
     cone{<0,0,0> 21.5 <0,30,0> 20} // tapered bottom
     cylinder{<0,30,0><0,70,0> 20}
     cylinder{<0,35,0><0,35.5,0> 20.1 texture{T_Stone8}} // white bands
     cylinder{<0,45,0><0,45.5,0> 20.1 texture{T_Stone8}}
     cylinder{<0,55,0><0,55.5,0> 20.1 texture{T_Stone8}}               
     cylinder{<0,65,0><0,65.5,0> 20.1 texture{T_Stone8}}
     cylinder{<0,69.9,0><0,70,0> 20.1 texture{T_Stone8}}
   }
   cylinder{<0,67,0><0,70.1,0> 18}
   #declare R1=0;
   #while (R1<=180)
       box{<-.75,68.5,-20.2><.75,70.1,20.2> rotate<0,R1,0>}
       #declare R1=R1+15;
   #end
}
#declare Tower1=union{
   object{Tower1a}
   cylinder{<0,67,0> <0,73,0> 15 texture{T_MixBrick scale .25}}
   cylinder{<0,73,0> <0,73.5,0> 15.2 texture{T_Stone8}}
   cylinder{<0,73.5,0><0,73.75,0> 15.3 texture{T_Stone8}}
   cone{<0,73.75,0> 15.31 <0,102,0> 0 texture{Gold_Nugget}} //Bright_Bronze}}
   
   #declare R1=0;
   #while (R1<=180)
      triangle{<-15.4,72.75,0><15.4,72.75,0><0,103,0> texture{Gold_Nugget} rotate<0,R1,0>}
      #declare R1=R1+15;
   #end
   cone{<0,102,0> .15 <0,104,0> .05 texture{Gold_Nugget}}
   sphere{<0,104,0> .15 texture{Gold_Nugget}}
   
   #declare R1=45;
   #while (R1<=360)
       object{Minuret translate<20,63,0> rotate<0,R1,0>}
       #declare R1=R1+90;
   #end      
}
        
#declare Asgard=union{        
  #declare ADiam=750;
                                       
  difference{
    union{
      cylinder{<0,0,0><0,35,0> ADiam-50}
      cylinder{<0,0,0><0,8,0> ADiam-49.8 texture{T_TanBrick }} // foundation courses
    }
    cylinder{<0,0,0><0,35.1,0> ADiam-60} // cut out the middle 
    #declare R1=0;
    #while(R1<180)
       box{<-ADiam,33,-.75><ADiam,35.1,.75> rotate<0,R1,0>}
       #declare R1=R1+.5;
    #end
   texture{T_WhiteBrick scale .75}
  }// difference
  
  #declare R1=0;           // place the towers
  #while (R1<=360)
     object{Tower1 texture{T_MixBrick scale .25}
              translate<0,0,ADiam-50> rotate<0,R1,0>}
     #declare R1=R1+15;
  #end
} // Asgard   

#declare Gate_Arch=difference{
   cylinder{<0,0,-3.05><0,0,3.05>3.3}
   cylinder{<0,0,-3.06><0,0,3.06>2.95}
   #declare RC=-95;
   #while (RC<95)
      box{<-.01,4,-3.06><.01,0,3.06> rotate<0,0,RC>}
      #declare RC=RC+10;
   #end
   box{<-3.4,-3.4,-3.06><3.4,0,3.06>} // shave off bottom
   box{<-3.4,0,-2.5><3.4,3.4,-2>} // portcullis slot   
  texture{T_Stone8 scale .25}
}
  
#declare Asgard_Main_Gate=union{
  difference{
     box{<-10,0,-3><10,40,3>}
     box{<-5,0,-3.1><5,10,3.1>}
     cylinder{<0,10,-3.1><0,10,3.1> 5}
  }
  object{Gate_Arch scale 5/3 translate<0,10,0>}
  object{Tower1 translate<-30,-15,0>}
  cone{<0,0,0>20 <0,-30,0> 4 texture{T_WhiteBrick scale .25} translate<-30,-15,0>}
  object{Tower1 translate<30,-15,0>}
  cone{<0,0,0>20 <0,-30,0> 4 texture{T_WhiteBrick scale .25} translate<30,-15,0>}
 texture{T_WhiteBrick scale .25}
}

#declare Column=union{
  box{<-.2,0,-.2><.2,.2,.2>}
  box{<-.18,.2,-.18><.18,.3,.18>}
  cylinder{<0,.3,0><0,.35,0> .17}
  cylinder{<0,.35,0><0,3.6,0> .16}
  cylinder{<0,3.6,0><0,3.7,0> .17}
  cylinder{<0,3.7,0><0,3.8,0> .18}
 texture{T_Stone8 scale .2}
}                 
#declare RailOrnament=union{
  torus{.25,.045 rotate<90,0,0>}
  torus{.25,.045 rotate<90,0,0> translate<0,.5,0>}
  torus{.25,.045 rotate<90,0,0> translate<.5,.25,0>}
  torus{.25,.045 rotate<90,0,0> translate<-.5,.25,0>}
  cylinder{<0,-.25,0><0,.75,0> .045}
  cylinder{<-.75,.25,0><.75,.25,0> .045}
  translate<0,.25,0>   // move up slightly to 0
  texture{Gold_Nugget}
}
#declare Gate_Bal=union{
  box{<-1.6,3,-3.8><1.6,3.1,3.8> texture{T_Stone8 scale .25}}

  object{RailOrnament translate<-.7,3.5,-2.95>} // frontside
  object{RailOrnament translate<.7,3.5,-2.95>}              
  object{RailOrnament translate<-.7,3.5,2.95>} // farside
  object{RailOrnament translate<.7,3.5,2.95>}
  
  object{RailOrnament rotate<0,90,0> translate<-1.55,3.35,-1.75>}
  object{RailOrnament rotate<0,90,0> translate<-1.55,3.35,-2.25>}
  object{RailOrnament rotate<0,90,0> translate<-1.55,3.35,-.75>}
  object{RailOrnament rotate<0,90,0> translate<-1.55,3.35,-.25>}     
  object{RailOrnament rotate<0,90,0> translate<-1.55,3.35,1.75>}
  object{RailOrnament rotate<0,90,0> translate<-1.55,3.35,2.25>}
  object{RailOrnament rotate<0,90,0> translate<-1.55,3.35,.75>}
  object{RailOrnament rotate<0,90,0> translate<-1.55,3.35,.25>}

  object{RailOrnament rotate<0,90,0> translate<1.55,3.35,-1.75>}
  object{RailOrnament rotate<0,90,0> translate<1.55,3.35,-2.25>}
  object{RailOrnament rotate<0,90,0> translate<1.55,3.35,-.75>}
  object{RailOrnament rotate<0,90,0> translate<1.55,3.35,-.25>}     
  object{RailOrnament rotate<0,90,0> translate<1.55,3.35,1.75>}
  object{RailOrnament rotate<0,90,0> translate<1.55,3.35,2.25>}
  object{RailOrnament rotate<0,90,0> translate<1.55,3.35,.75>}
  object{RailOrnament rotate<0,90,0> translate<1.55,3.35,.25>}          
      
  object{Column translate<-1.5,3,-3>}
  object{Column translate<1.5,3,-3>}    
  object{Column translate<-1.5,3,3>}
  object{Column translate<1.5,3,3>}  
  object{Column translate<-1.5,3,-1.5>}
  object{Column translate<1.5,3,1.5>}
  object{Column translate<-1.5,3,0>}
  object{Column translate<1.5,3,0>}    
  box{<-1.6,6.8,-3.8><1.6,6.9,3.8> texture{T_Stone8 scale .25}} 
}

#declare Gate_Balcony=union{
  box{<-1.5,-3,-3.7><1.5,3,3.7>}

  object{Gate_Bal}  
  
  box{<-1.5,6.9,-3.7><1.5,8,3.7>} 

  object{Gate_Bal translate<0,4.9,0>}  
  
  box{<-1.5,11.9,-3.7><1.5,14,3.7>}
 texture{T_WhiteBrick scale .06}
}

#declare GateOrnament=union{
  torus{.25,.05 rotate<90,0,0>}
  cone{<0,-.2,0>.05 <0,1,0> 0 }
  sphere{<0,1.1,0> .1}
  texture{Gold_Nugget}
}

#declare GateCap=union{
   box{<-5.2,0,-3.2><5.2,.2,3.2>}
   #declare C1=-5;
   #while(C1<=5)
      cylinder{<C1+.1,.2,-2.85><C1+.1,.8,-2.85> .2}
      #declare C1=C1+.4;
   #end
   #declare C1=-4.5;                   
   #while(C1<=4.5)
      object{GateOrnament translate<C1,5.35,0>}
      #declare C1=C1+.5;
   #end
   #declare C1=-4;                   
   #while(C1<=4)
      triangle{<C1,1,-3.3><C1,5.1,0><C1,1,3.3> texture{Gold_Nugget}}
      #declare C1=C1+1;
   #end      
      
   box{<-5.2,.8,-3.2><5.2,1,3.2>}
   union{
     triangle{<-5.2,1,-3.2><5.2,1,-3.2><-4,5,0>}
     triangle{<5.2,1,-3.2><-4,5,0><4,5,0>}
     triangle{<5.2,1,-3.2><4,5,0><5.2,1,3.2>}
     
     triangle{<-8.2,-1,-3.2><8.2,-1,-3.2><-7,3,0>}
     triangle{<8.2,-1,-3.2><-7,3,0><7,3,0>}
     
     triangle{<-8.2,-1,-3.4><-5.0,-1,-3.4><-6.6,3,-2>}  // left side
     triangle{<-5.0,-1,-3.4><-6.6,3,-2><-6.6,3,2>}
     triangle{<-5.0,-1,-3.4><-6.6,3,2><-5.0,-1,3.4>}    
     triangle{<-8.2,-1,-3.4><-6.6,3,-2><-6.6,3,2>}
     triangle{<-8.2,-1,-3.4><-6.6,3,2><-8.2,-1,3.4>}
     
     triangle{<8.2,-1,-3.4><5.0,-1,-3.4><6.6,3,-2>}  // right side
     triangle{<5.0,-1,-3.4><6.6,3,-2><6.6,3,2>}
     triangle{<5.0,-1,-3.4><6.6,3,2><5.0,-1,3.4>}    
     triangle{<8.2,-1,-3.4><6.6,3,-2><6.6,3,2>}
     triangle{<8.2,-1,-3.4><6.6,3,2><8.2,-1,3.4>}
     
    texture{Gold_Nugget}
   }
   
   box{<-8.2,-1.1,-3.4><-5.0,-1,3.4>}
   box{<5.0,-1.1,-3.4><8.2,-1,3.4>}
   
   texture{T_Stone8 scale .1}
}  
#declare Gate1=difference{
  union{
   object{GateCap translate<0,15,0>}
   box{<-5,-3,-3><5,15,3>}
   box{<-5,7.9,-3.1><5,8,3.1> texture{T_Stone8 scale .2}}
   box{<-5,11.8,-3.1><5,11.9,3.1> texture{T_Stone8 scale .2}} 
                          
   box{<-5,-.25,-3.2><5,0,3.2> }
   box{<-5,-3,-3.3><5,-.25,3.3> texture{T_TanBrick scale .12}}
   
   box{<-5,-3,-3.2><-4.5,15,3.2>}
   box{<-5,-3,-3.4><-4.75,15,3.4>}
//   box{<-8,-3,-3.6><-4.9,15,3.6>}     
   object{Gate_Balcony translate<-6.5,0,0>}
   box{<-8,-3,-3.7><-4.9,-.25,3.7> texture{T_TanBrick scale .12}}         
   
   box{<5,-3,-3.2><4.5,15,3.2>}
   box{<5,-3,-3.4><4.75,15,3.4>}
//   box{<8,-3,-3.6><4.9,15,3.6>}            
   object{Gate_Balcony translate<6.5,0,0>}   
   box{<8,-3,-3.7><4.9,-.25,3.7> texture{T_TanBrick scale .12}}   
   }
  box{<-3,-.1,-3.1><3,4,3.1>}
  cylinder{<0,4,-3.1><0,4,3.1>3}
   
  box{<-3,4,-2.5><3,8,-2>} // porcullis slot
  box{<-3.5,0,-2.35><3.5,4,-2.15>}
  
 texture{T_MixBrick scale<.06,.06,.06>}
} 

#declare Portcullis=union{
  #declare R1=-3;
  #while (R1<=3)
     cylinder{<0,.5,0><0,7,0> .035 translate<R1,0,0>}
     cone{<0,.5,0> .045 <0,.25,0> .01 translate<R1,0,0>}
     cone{<0,.25,0> .045 <0,0,0> 0 translate<R1,0,0>} 
     sphere{<R1,.6,-.06> .01}  // rivets
     sphere{<R1,1.55,-.06> .01}
     sphere{<R1,2.55,-.06> .01}
     sphere{<R1,3.55,-.06> .01}
     sphere{<R1,4.55,-.06> .01}
     #declare R1=R1+.3;
  #end
  box{<-3,.55,-.06><3,.65,.06>}
  box{<-3,1.5,-.06><3,1.6,.06>}
  box{<-3,2.5,-.06><3,2.6,.06>}
  box{<-3,3.5,-.06><3,3.6,.06>}
  box{<-3,4.5,-.06><3,4.6,.06>}
 texture{Gold_Nugget}
} 

#declare Door=union{
  difference{
    union{
       box{<-2.9,.04,-.02><2.9,4,.02>}
       cylinder{<0,3.9,-.02><0,3.9,.02>2.9}
    }
    #declare R1=.3;
    #while (R1<=3)
      box{<R1-.01,0,-.03><R1+.01,7.2,.03>}
      #declare R1=R1+.3;
    #end
    box{<-3.1,-.1,-.03><0,7.2,.03>}
  }
  box{<0,.5,-.06><3,.7,.06> texture{T_Wood5 scale .2}}
  box{<0,1.5,-.06><3,1.7,.06> texture{T_Wood5 scale .2}}  
  box{<0,3,-.06><3,3.2,.06> texture{T_Wood5 scale .2}}
  box{<0,4.5,-.06><3,4.7,.06> texture{T_Wood5 scale .2}}  
  box{<0,5,-.06><3,5.2,.06> texture{T_Wood5 scale .2}}
  union{
    #declare Rx=.15;
    #while (Rx<=2.85)
       sphere{<Rx,.6,-.06>  .05}
       sphere{<Rx,1.6,-.06> .05}
       sphere{<Rx,3.1,-.06> .05}
       sphere{<Rx,4.6,-.06> .05}
       sphere{<Rx,5.1,-.06> .05}     
       sphere{<Rx,.6,.06>   .05}
       sphere{<Rx,1.6,.06>  .05}
       sphere{<Rx,3.1,.06>  .05}
       sphere{<Rx,4.6,.06>  .05}
       sphere{<Rx,5.1,.06>  .05}       
       #declare Rx=Rx+.3;
    #end
   texture{pigment{color Black}}
  }
       
 texture{T_Wood5 rotate<90,0,0> scale .1}
}
#declare L_Door=object{Door translate<-3,0,0> rotate<0,130,0> translate<-3,0,0>}  
     
#declare Gate=union{
  object{Gate1}
  object{Portcullis translate<0,4,-2.25>}
  object{Gate_Arch translate<0,4,0>}
  
  object{Door translate<-3,0,0> rotate<0,50,0> translate<3,0,0> translate<0,0,2>}
  object{L_Door translate<0,0,2>}
  
  box{<-4.4,3.8,-3.2><-2.8,4,-2.3> texture{T_Stone8 scale .02}}
  box{<2.8,3.8,-3.2><4.4,4,-2.3> texture{T_Stone8 scale .02}}       
  box{<-4,3.8,-2.15><-2.8,4,3.2> texture{T_Stone8 scale .02}}
  box{<2.8,3.8,-2.15><4,4,3.2> texture{T_Stone8 scale .02}}  

  object{Column translate<-4.5,0,-3>}
  object{Column translate<4.5,0,-3>}
  
  object{Column translate<-3,0,-3>}
  object{Column translate<3,0,-3>}
  
  object{Column translate<-3,0,-1.5>}
  object{Column translate<3,0,-1.5>}  
  
  object{Column translate<-3,0,0>}
  object{Column translate<3,0,0>} 
  
  object{Column translate<-3,0,-1.5>}
  object{Column translate<3,0,-1.5>}   
      
  object{Column translate<-3,0,3>}
  object{Column translate<3,0,3>}  
} 

//#declare Cob= superellipsoid { <.3, .3> }

//#declare Cobble=union{
//    object{Cob scale .05 texture{pigment{color Gray}}}
  //  box{<-.05,-.05,-.05><.05,.05,.05> texture{pigment{color Gray}}}
//    box{<-.056,-.056,-.05><.056,.03,.056> texture{pigment{color Tan}}}  // dirt between stones 
//}
//#declare Cobble_Lane=union{
// #declare gap=.005;
// #declare X=seed(38);
// #declare XX=-1.4;

// #while (XX<1.4)
//  #declare ZZ=-9;
  
//  #while (ZZ<4)

    // Assumes 1pov unit=1meter scale
    //  XX and YY are position in street

//    #declare ROY=rand(X)*5-2.5;         // random rotation of stone -2.5 to +2.5 degrees
//    #declare RY=rand(X)*.02-.01;        // adjusts elevation of stone -.01 to +.01 cm
//    #declare RX=rand(X)*gap-(gap/2);    // where "gap" is your mortar joint size
//    #declare RZ=rand(X)*gap-(gap/2);    // RX and RZ move the stone about the slot 
//    #declare RYA=abs(XX)/10;            // hump adjustment  1/2 of street width

//    object{Cobble rotate<0,ROY,0> translate<XX+RX,RY-RYA+.25,ZZ+RZ>}
    
//    #declare ZZ=ZZ+.11;
//  #end
  
//  #declare XX=XX+.11;
// #end
// #declare Y=-10;
// #while (Y<=3)
//   #declare RY1=rand(X)*.02-.01;
//   #declare RY2=rand(X)*.02-.01;
//   #declare ROY1=rand(X)*2-1;
//   #declare ROY2=rand(X)*2-1; 
//   union{                            
//     box{<-.085,-.05,-.2><.085,.20+RY,.2> rotate<0,ROY1,0> translate<-1.41,RY1,Y>}
//     box{<-.085,-.05,-.2><.085,.20+RY,.2> rotate<0,ROY2,0> translate<1.41,RY2,Y>}
//    texture{T_Stone8 scale .25}
//   }
//   #declare Y=Y+.42;
// #end
 
//}

#declare Wooden_Bridge=union{
  #declare R1=-15;
  #while(R1<=15)
    box{<-3,0,R1><3,.1,R1+.28> texture{T_Wood5}}
    #declare R1=R1+.3;
  #end
  box{<-2.9,-.5,-15><-2.7,0,15> texture{T_Wood5 rotate<0,90,0>}}
  box{<2.7,-.5,-15><2.9,0,15> texture{T_Wood5 rotate<0,90,0>}}
  box{<-3.1,1.5,-15><-2.9,1.7,15> texture{T_Wood5 rotate<0,90,0>}}
  box{<2.9,1.5,-15><3.1,1.7,15> texture{T_Wood5 rotate<0,90,0>}}
  #declare R1=-10;
  #while (R1<=15)
     box{<-3,-.5,R1-.1><-2.9,1.5,R1+.1> texture{T_Wood5 rotate<90,0,0>}}
     box{<2.9,-.5,R1-.1><3,1.5,R1+.1> texture{T_Wood5 rotate<90,0,0>}}
     #declare R1=R1+5;
  #end
}
#declare Full_Bridge=union{
   #declare R1=18;
   #while (R1<=400)
      object{Wooden_Bridge translate<0,0,R1>}
      #declare R1=R1+30;
   #end
}

#declare Gate_Complex=union{
  object{Gate}
  object{Full_Bridge}
//  object{Cobble_Lane translate<-1.5,0,0>}
//  object{Cobble_Lane translate<1.5,0,0>}
}

#declare Cloud=union{ // end of byfrost rainbow
 #declare RSS=seed(3393);
 #declare S1=1;
 #while (S1<440)
   #declare RX=rand(RSS)*5-2.5;
   #declare RY=rand(RSS)*1.75-.825;
   #declare RZ=rand(RSS)*8-4;
   #declare RSZ=rand(RSS)*.35+.1;
   #declare CX=rand(RSS);
   #declare CY=rand(RSS);
   #declare CZ=rand(RSS);
   sphere{<RX,RY+1,RZ> RSZ          texture{ 
            pigment{crackle 
                     color_map {[0.0 rgbt <CX,CY,CZ,.95>]
                                [.1 rgbt <CX,CY,CZ,.85>]
                                [.15 rgbt <1.0,1.0,1.0,1.0>]
                                [1.0 rgbt <1.0,1.0,1.0,1.0>]
                               }
                   } scale .1
           } finish{ambient 1.5}
           }
   #declare S1=S1+1;
 #end    
}


object{Asgard_Main_Gate rotate<0,0,0> translate<0,5,-ADiam-40> rotate<0,0,0>}
object{Gate_Complex translate<0,5,-ADiam-400>}  
object{Cloud translate<1,4,-ADiam-400-13>} // position in front of gate arch

TreeTop(5,.81,8, -5,-25,-ADiam-400,0,21,0) // tree under Gate_Complex
TreeTop(5,.81,6,  5,-20,-ADiam-400,0,19,0) 

object{Asgard}  

union{
#declare C1=90;
#while (C1<=210)

  #declare RSY=rand(RS)*200+25;
  #declare RSZ=rand(RS)*25;
  object {   //  Asgard bottom
                height_field { png  "../graphics/asgard1.png" water_level .05 }
                texture { pigment { color Tan1 } }
                rotate<180,0,0>
                scale < 100, RSY, 100 >   translate < 0, RSY*.05, ADiam+10-RSZ >
                rotate<0,C1,0>
  }
  #declare C1=C1+5;
#end
} // union

union{
#declare C1=90;
#while (C1<=210)

  #declare RSY=rand(RS)*500+7000;
  #declare ROY=rand(RS)*360;
  
    object { 
                height_field { png  "../graphics/hills1.png" }
                texture { pigment { color Gray60 } }
                 scale <50000, RSY, 50000 >   
                 translate<-25000,0,-25000> // center
                 rotate<0,ROY,0>
                 translate < 0, 0, 65000 >
                 rotate<0,C1+210,0>
  }

    object { 
                height_field { png  "../graphics/hills1.png" }
                 scale <50000, RSY+1, 50000 >   
                 translate<-25000,0,-25000> // center
                texture {          
                   pigment { crackle
                        color_map {
                          [0.0 color Clear]
                          [0.1 color Clear]
                          [0.17 color Khaki]
                          [1.0 color Gray10] 
                        } 
                    } // pigment 
                  } // texture                 
                 rotate<0,ROY,0>
                 translate < 0, 0, 65000 >
                 rotate<0,C1+210,0>
  }
  
  #declare C1=C1+rand(RS)*10+15;
#end
} // union

#ifndef(MenOff)
#render "***Men are on"  
  #declare R1=seed(23)
  #include "..\med\horse.inc"  // Horse definitions
  #include "..\roman\romsold.inc"  // include the roman soldier defs
  
  object{SolSpear translate<1.2,5,-ADiam-400-2>}  
  object{SolSpear rotate<0,-45,0> translate<0,5,-ADiam-400-1.5>}   
  object{SolSpear rotate<0,-90,0> translate<0,5,-ADiam-400>}  
  
  object{SolSpear translate<6,8.1,-ADiam-400-2>}  
  object{SolSpear translate<7,13.1,-ADiam-400-2>}  
  
  object{SolSpear rotate<0,90,0> translate<1.2,5,-ADiam-350>}  
  object{SolSpear rotate<0,90,0> translate<1.2,5,-ADiam-340>}  
  object{SolSpear rotate<0,90,0> translate<1.2,5,-ADiam-330>}  
  object{SolSpear rotate<0,90,0> translate<1.2,5,-ADiam-300>}  
  
#end     

// Asgard Hill for temples 

#declare OdinsTemple=union{
  box{<-150,9,-100><150,10,100>}
  box{<-151,8,-101><151,9,101>}
  box{<-152,7,-102><152,8,102>}
  box{<-153,6,-103><153,7,103>}
  box{<-154,5,-104><154,6,104>}
  box{<-155,4,-105><155,5,105>}
  box{<-156,3,-106><156,4,106>}
  box{<-157,2,-107><157,3,107>}
  box{<-158,1,-108><158,2,108>}
  box{<-159,0,-109><159,1,109>}
  
  box{<-151,30,-100><151,31,100>}
  box{<-151.2,31,-100.2><151.2,31.5,100.2>}
  box{<-151.3,31.5,-100.3><151.3,31.75,100.3>}
  
  #declare C1=-150;
  #while (C1<=150)
     #if (abs(C1)<=100)
       cone{<0,10,0>1 <0,30,0> .8 translate<-49,0,C1>}
       cone{<0,10,0>1 <0,30,0> .8 translate<49,0,C1>}
     #end 
     cone{<0,10,0>1 <0,30,0> .8 translate<C1,0,-99>}
     cone{<0,10,0>1 <0,30,0> .8 translate<C1,0,99>}
     
     #declare C1=C1+10;
  #end

  box{<-151,50,-100><151,51,100>}
  box{<-151.2,51,-100.2><151.2,51.5,100.2>}
  box{<-151.3,51.5,-100.3><151.3,51.75,100.3>}
  
  #declare C1=-150;
  #while (C1<=150)
     #if (abs(C1)<=100)
       cone{<0,30,0>1 <0,50,0> .8 translate<-49,0,C1>}
       cone{<0,30,0>1 <0,50,0> .8 translate<49,0,C1>}
     #end 
     cone{<0,30,0>1 <0,50,0> .8 translate<C1,0,-99>}
     cone{<0,30,0>1 <0,50,0> .8 translate<C1,0,99>}
     
     #declare C1=C1+10;
  #end
  
  box{<-.5,75,-100><.5,76,100>}
                       
  union{                       
    triangle{<-150,51.75,-100><150,51.75,-100><150,75,0>}
    triangle{<-150,51.75,-100><150,75,0><-150,75,0>}
    triangle{<-150,51.75,100><150,51.75,100><150,75,0>}
    triangle{<-150,51.75,100><150,75,0><-150,75,0>}  
   texture{Bright_Bronze}
  }
  
  texture{T_Stone8}
}     
     
  
#declare ADiam=900;

    object { 
                height_field { png  "../graphics/CASTIIa.png" water_level .01}
                texture { pigment { color Gray60 } }
                 scale <ADiam, 75, ADiam >   
                 translate<-ADiam/2,0,-ADiam/2> // center
  }

    object { 
                height_field { png  "../graphics/CASTIIa.png" water_level .01}
                 scale <ADiam, 75.2, ADiam >   
                translate<-ADiam/2,0,-ADiam/2> // center
                texture {          
                   pigment { crackle
                        color_map {
                          [0.0 color Clear]
                          [0.1 color Clear]
                          [0.17 color Khaki]
                          [1.0 color Gray10] 
                        } 
                    } // pigment 
                  } // texture                 
  }
  
object{OdinsTemple translate<100,60,0>}
               
         
