#ifndef( Blocs_inc )
#declare Blocs_inc = 1;
// Persistence of Vision Ray Tracer Scene Description File
// File: Blocks.inc
// Vers: 3.1
// Desc: 
// Date: 2000.03.17
// Auth: Masanori Imazu

#macro Cone2( Height, Radius, RoundB, RoundT )
	#local AngleBottom = atan2( Height, Radius );
	#local AngleTop = pi/2 - AngleBottom;
	#local dHeightTopShpere = RoundT/sin( AngleTop );
	#local HeightTopSphere = Height - dHeightTopShpere;
	#local ConeTRadius = RoundT*cos( AngleTop );
	#local ConeTHeight = Height - dHeightTopShpere + RoundT*sin( AngleTop );
	#local dRadiusTorus = RoundB/tan( AngleBottom/2 );
	#local RadiusTorus = Radius - dRadiusTorus;
	#local ConeBHeight = dRadiusTorus*sin( AngleBottom );
	#local ConeBRadius = Radius - dRadiusTorus*cos( AngleBottom );
	union{
		sphere{ 0, RoundT translate HeightTopSphere*y }
		torus{ RadiusTorus, RoundB translate RoundB*y }
		cone{ ConeBHeight*y, ConeBRadius, ConeTHeight*y, ConeTRadius }
		cylinder{ 0, ConeBHeight*y, RadiusTorus }
	}
#end

#macro Cone( Height, Radius, Round )
	Cone2( Height, Radius, Round, Round )
#end

#macro RightTriangle2( Length1, Length2, Thickness, Round )
	#local VertexSphere = sphere{ 0, Round }
	#local Angle1 = atan2( Length2, Length1 );
	#local Length3 = Length1/cos( Angle1 );
	#local dLength1 = Round/tan( Angle1/2 );
	#local Angle2 = pi/2 - Angle1;
	#local dLength2 = Round/tan( Angle2/2 );
	#local EdgeCylinder1 = cylinder{ < Round, Round, 0 >, < Length1-dLength1, Round, 0 >, Round }
	#local EdgeCylinder2 = cylinder{ < Round, Round, 0 >, < Round, Length2-dLength2, 0 >, Round }
	#local EdgeCylinder3 = cylinder{ < Length1-dLength1, Round, 0 >, < Round, Length2-dLength2, 0 >, Round }
	#local EdgeCylinder4 = cylinder{ Round*z, (Thickness-Round)*z, Round }
	#local UBox = box{ 0, 1 }
	#local EdgeUnion =
		union{
			object{ EdgeCylinder1 }
			object{ EdgeCylinder2 }
			object{ EdgeCylinder3 }
			object{ VertexSphere translate< Round, Round, 0 > }
			object{ VertexSphere translate< Length1-dLength1, Round, 0 > }
			object{ VertexSphere translate< Round, Length2-dLength2, 0 > }
		}

	union{
		object{ EdgeUnion translate Round*z }
		object{ EdgeUnion translate (Thickness-Round)*z }
		object{ EdgeCylinder4 translate< Round, Round, 0 > }
		object{ EdgeCylinder4 translate< Length1-dLength1, Round, 0 > }
		object{ EdgeCylinder4 translate< Round, Length2-dLength2, 0 > }
		object{ UBox scale< Length1-Round-dLength1, Round, Thickness-2*Round > translate < Round, 0, Round > }
		object{ UBox scale< Round, Length2-Round-dLength2, Thickness-2*Round > translate < 0, Round, Round > }
		object{ UBox scale< Length3-dLength1-dLength2, Round, Thickness-2*Round >
			rotate -degrees( Angle1 )*z
			translate< Round, Length2-dLength2, Round >
		}
		prism{
			linear_sweep
			linear_spline
			-Thickness, 0, 4,
			< Round, Round >, < Length1-dLength1, Round >, < Round, Length2-dLength2 >, < Round, Round >
			rotate -90*x
		}
	}
#end

#macro RightTriangle( Length, Thickness, Round )
	RightTriangle2( Length, Length, Thickness, Round )
#end

#macro Box( LengthX, LengthY, LengthZ, Round )
	#local EdgeCylinderX = cylinder{ Round*x, (LengthX-Round)*x, Round }
	#local EdgeCylinderY = cylinder{ Round*y, (LengthY-Round)*y, Round }
	#local EdgeCylinderZ = cylinder{ Round*z, (LengthZ-Round)*z, Round }
	#local VertexSphere = sphere{ 0, Round }
	#local UBox = box{ 0, 1 }
	#local EdgeUnion =
		union{
			object{ EdgeCylinderX translate Round*y }
			object{ EdgeCylinderX translate (LengthY-Round)*y }
			object{ EdgeCylinderY translate Round*x }
			object{ EdgeCylinderY translate (LengthX-Round)*x }
			object{ VertexSphere translate< Round, Round, 0 > }
			object{ VertexSphere translate< LengthX-Round, Round, 0 > }
			object{ VertexSphere translate< Round, LengthY-Round, 0 > }
			object{ VertexSphere translate< LengthX-Round, LengthY-Round, 0 > }
		}

	union{
		object{ EdgeUnion translate Round*z }
		object{ EdgeUnion translate (LengthZ-Round)*z }
		object{ EdgeCylinderZ translate< Round, Round, 0 > }
		object{ EdgeCylinderZ translate< LengthX-Round, Round, 0 > }
		object{ EdgeCylinderZ translate< Round, LengthY-Round, 0 > }
		object{ EdgeCylinderZ translate< LengthX-Round, LengthY-Round, 0 > }
		object{ UBox scale< LengthX, LengthY-2*Round, LengthZ-2*Round > translate< 0, Round, Round > }
		object{ UBox scale< LengthX-2*Round, LengthY, LengthZ-2*Round > translate< Round, 0, Round > }
		object{ UBox scale< LengthX-2*Round, LengthY-2*Round, LengthZ > translate< Round, Round, 0 > }
	}
#end

#macro Cylinder( Height, Radius, Round )
	#local EdgeTorus = torus{ Radius-Round, Round }
	union{
		object{ EdgeTorus translate Round*y }
		object{ EdgeTorus translate (Height-Round)*y }
		cylinder{ Round*y, (Height-Round)*y, Radius }
		cylinder{ 0, Height*y, Radius-Round }
	}
#end

#end
