#ifndef( Chest_inc )
#declare Chest_inc = true;
// Persistence of Vision Ray Tracer Scene Description File
// File: Chest.inc
// Vers: 3.1
// Desc: 
// Date: 2001.04.04
// Auth: Masanori Imazu

// ==== Standard POV-Ray Includes ====
#include "colors.inc"	// Standard Color definitions
//#include "textures.inc"	// Standard Texture definitions
#include "woods.inc"
#include "metals.inc"

#local ChestW = 1200;
#local ChestD = 500;
#local ChestN = 3;
#local DrawerH = 200;//180;
#local BoardT = 20;
#local Slit = 4;
#local ChestR = 5;
#local ChestH = ChestN*(DrawerH+BoardT+2*Slit) + BoardT;

#include "Blocks.inc"

#local HorizontalBoard = object{ Box( ChestW, BoardT, ChestD, ChestR ) }

#local SideBoard = object{ Box( BoardT, ChestH, ChestD, ChestR ) }

#local HandleW = 140;
#local HandleH = 70;
#local HandleD = 40;
#local HandleT = 4;
#local HandleR = 25;
#local Handle =
	difference{
		sphere{ 0, 0.5 scale < HandleW, HandleH, HandleD > }
		sphere{ 0, 0.5 scale < HandleW-2*HandleT, HandleH-2*HandleT, HandleD-2*HandleT > }
		object{
			Box( HandleW+2*HandleR+2, HandleH/2+HandleR+1, HandleD+HandleR+1, HandleR )
			translate < -(HandleW/2+HandleR+1), -(HandleH/2+HandleR+1), -(HandleD+HandleR+1) >
		}
		texture{ T_Gold_4C }
	}

#local DrawerW = ChestW-2*(BoardT+Slit);
#local Drawer =
	union{
		difference{
			Box( DrawerW, DrawerH, BoardT, ChestR )
			sphere{ 0, 0.5
				scale < HandleW, HandleH, HandleD >
				translate < DrawerW/2, DrawerH/2, 0 >
			}
		}
		object{ Handle translate < DrawerW/2, DrawerH/2, 0 > }
	}

#local ChestTexture = texture{ T_Wood19 rotate 100 scale 100 }
#local _TempSeed = seed(0);
#declare Chest =
	union{
		object{
			SideBoard
			texture{ ChestTexture translate rand(_TempSeed)*500 }
		}
		object{
			SideBoard
			texture{ ChestTexture translate rand(_TempSeed)*500 }
			translate (ChestW-BoardT)*x
		}
		#local _TempN = ChestN + 1;
		#while( _TempN )
			#local _TempN = _TempN - 1;
			object{
				HorizontalBoard
				translate _TempN*(DrawerH+BoardT+2*Slit)*y
				texture{ ChestTexture translate rand(_TempSeed)*500 }
			}
		#end

		#local _TempN = ChestN;
		#while( _TempN )
			#local _TempN = _TempN - 1;
			object{
				Drawer
				translate < BoardT+Slit, BoardT+Slit+_TempN*(DrawerH+BoardT+2*Slit), 0 >
				texture{ ChestTexture translate rand(_TempSeed)*500 }
			}
		#end

		translate < -ChestW, 0, -ChestD >
	}

#end
