// Persistence of Vision Ray Tracer Scene Description File
// File: Tree.pov // inc
// Vers: 3.1
// Desc: 
// Date: 2001.04.07
// Auth: Masanori Imazu

// ==== Standard POV-Ray Includes ====
#include "colors.inc"	// Standard Color definitions
//#include "textures.inc"	// Standard Texture definitions

/*
#macro AngleAroundY( V )
	#if( Vec.x = 0 )
		#if( V.z = 0 )
			0
		#else
			( V.z > 0 ) ? pi/2 : -pi/2
		#end
	#else
		#if( V.z = 0 )
			( V.x > 0 ) ? 0 : pi
		#else
			atan2( V.z, V.x )
		#end
	#end
#end

#macro Acos2( a, b )
	#if( b = 0 )
		0
	#else
		acos( a/b )
	#end
#end
*/

#macro Branches(
		Obj, Seed, Nest, Seg, MinLen
		//, Org // , Vec
		, BaseLen, RndRatL, ShortenRat
		, BaseAng, RndRatA
		, BaseTwist, RndRatT
		, BaseRot, RndRatR
	)

	#local CurrentL = ( (1-RndRatL)+2*RndRatL*rand(Seed) ) * BaseLen;
	#local Twist0 = ( (1-RndRatT)+2*RndRatT*rand(Seed) )*BaseTwist;
	#local Branch = object{ Obj scale < BaseLen, CurrentL, BaseLen > }

	#local Cond = false;
	#if( Nest > 0 )
		#if( CurrentL >= MinLen )
			#local Cond = true;
		#end
	#end

	#if( Cond )
		union{
			object{ Branch }

			#local Twist = ( (1-RndRatT)+2*RndRatT*rand(Seed) )*BaseTwist;
			#local SegC = 0;
			#while( SegC < Seg )
				#local Ang = ( (1-RndRatA)+2*RndRatA*rand(Seed) )*BaseAng;
				#local Rot = Twist + BaseRot*( SegC + ( (1-RndRatR)+2*RndRatR*rand(Seed) ) );
				object{
					Branches(
						Obj, Seed, Nest-1, Seg, MinLen
						//, CurrentL*y // , Vec
						, CurrentL*ShortenRat, RndRatL, ShortenRat
						, BaseAng, RndRatA
						, BaseTwist, RndRatT
						, BaseRot, RndRatR
					)
					rotate Ang*z
					rotate Rot*y
					translate CurrentL*y
				}
				#local SegC = SegC + 1;
			#end
		}
	#else
		object{ Branch }
	#end
#end

#local BranchObj = cone { 0, 0.08, 1*y, 0.06 pigment{ MediumWood } }
			//cylinder{ 0, y, 0.1 pigment{ Green } }

#declare TreeNest = 6;
#declare TreeSeg = 3;
#declare BranchMinLen = 100;
#declare BranchBaseLen = 1000;
#declare BranchBaseAng = 50;
#declare BranchBaseRot = 360/TreeSeg;
#declare BranchBaseTwist = BranchBaseRot/2;

#declare Tree =
	Branches(	// 2 is better
		BranchObj, seed(2), TreeNest, TreeSeg, BranchMinLen
		//, Org // , Vec
		, BranchBaseLen, 0.3, 0.7
		, BranchBaseAng, 0.5
		, BranchBaseTwist, 0.3
		, BranchBaseRot, 0.7
	)

plane{ y, 0 pigment { White } }

object { Tree
	//rotate 90*y
}

light_source{ < 2000, 3000, -10000 > White }

camera{
	location < 0, 2000, -15000 >
	look_at 1500*y
	angle 30
}

/*
	#local CurrentL = ( (1-RndRatL)+2*RndRatL*rand(Seed) ) * BaseLen;
	#local RotZ = degrees( Acos2( Vec.y, vlength(Vec) ) );
	#local RotY = degrees( AngleAroundY(Vec) );
	object{ Obj scale < BaseLen, CurrentL, BaseLen > rotate RotZ rotate RotY }
	//#local NextVec = vaxis_rotate( z, 0, RotZ );
	#local NextOrg = Org + CurrentL*vnormalize( Vec );
	#if( Nest > 0 )
		#if( CurrentLen > MinLen )
			#local Twist0 = ( (1-RndRatT)+2*RndRatT*rand(Seed) )*BaseTwist;
			#local SegC = 0;
			#while( SegC < Seg )
				#local Ang = ************
				#local Rot = Twist + BaseRot*( SegC + ( (1-RndRatR)+2*RndRatR*rand(Seed) ) );
				#local NextVec
				Branches(
					Obj, Seed, MaxNest-1, Seg, MinLen
					, NextOrg, NextVec
					, ShortenRat*CurrentLen, RndRatL, ShortenRat
					, BaseAng, RndRatA
					, BaseTwist, RndRatT
					, BaseRot, RndRatR
				)
				#local SegC = SegC + 1;
			#end
		#end
	#end

#end
*/
