// Persistence of Vision Ray Tracer Scene Description File
// File: blkfrtrs.pov
// Vers: 3.1
// Desc: 
// Date: 2000.03.17
// Auth: Masanori Imazu

#version unofficial MegaPov 0.7;

global_settings{
	motion_blur 10, 0.1
}

// ==== Standard POV-Ray Includes ====
#include "colors.inc"	// Standard Color definitions
//#include "textures.inc"	// Standard Texture definitions

#declare NColors = 5;

#declare Colors = array[NColors]
	{
		rgb< 1.0, 0.2, 0.2 >,
		rgb< 0.1, 1.0, 0.2 >,
		rgb< 0.2, 0.2, 1.0 >,
		rgb< 1.0, 1.0, 0.1 >,
		rgb< 0.1, 1.0, 1.0 >
	}

#macro RandColor( Seed )
	Colors[ rand(Seed)*NColors ]
#end

#include "Blocks.inc"

#declare BoxSizeW1 = 120;
#declare BoxSizeH1 = 120;
#declare BoxSizeD1 = 120;
#declare BoxRoundness1 = 10;
#declare BoxBlock1 =
	object{
		Box( BoxSizeW1, BoxSizeH1, BoxSizeD1, BoxRoundness1 )
		translate -< BoxSizeW1, 0, BoxSizeD1 >/2
	}

#declare BoxSizeW2 = 200;
#declare BoxSizeH2 = 50;
#declare BoxSizeD2 = 100;
#declare BoxRoundness2 = 6;
#declare BoxBlock2 =
	object{
		Box( BoxSizeW2, BoxSizeH2, BoxSizeD2, BoxRoundness2 )
		translate -< BoxSizeW2, 0, BoxSizeD2 >/2
	}

#declare CylinderHeight = BoxSizeH1;
#declare CylinderRadius = 50;
#declare CylinderRoundness = 10;
#declare CylinderBlock =
	object{
		Cylinder( CylinderHeight, CylinderRadius, CylinderRoundness )
	}

#declare TriangleSize = 100;
#declare TriangleThickness = 50;
#declare TriangleRoundness = 10;
#declare TriangleBlock =
	object{
		RightTriangle( TriangleSize, TriangleThickness, TriangleRoundness )
		rotate -135*z
		translate < 0, TriangleSize/sqrt(2), -TriangleThickness/2 >
	}

#declare ConeHeight = 90;
#declare ConeRadius = 60;
#declare ConeRoundness = 10;
#declare ConicBlock =
	object{
		Cone( ConeHeight, ConeRadius, ConeRoundness )
	}

//===========================================================================================

#declare RoomW = 3000;
#declare RoomD = 4000;
#declare RoomH = 3000;
#declare WallT = 100;
#declare WindowW = 1200;
#declare WindowH = 1100;
#declare WindowFrameT = 30;
#declare WindowFrameD = WallT+10;
#declare T_Window = texture{ pigment{ White } finish{ ambient 0.3 } }
#declare WindowHollow = box{ 0, 1 translate -0.5*x scale < WindowFrameD+1, WindowH, WindowW > texture{ T_Window } }
#declare WindowFrame =
	box{ 0, 1 translate -0.5*x
		scale < WindowFrameD, WindowH+2*WindowFrameT, WindowW+2*WindowFrameT >
		translate -WindowFrameT*y
		texture{ T_Window }
	}

#declare WindowPos1 = < (RoomW+WallT)/2, 750, -1300 >;
#declare WindowPos2 = < -800, 750, (RoomD+WallT)/2 >;
difference{	// Room
	union{
		difference{
			box{ 0, 1
				translate < -0.5, 0, -0.5 > scale < RoomW+2*WallT, RoomH+2*WallT, RoomD+2*WallT >
				translate -WallT*y
			}
			box{ 0, 1 translate < -0.5, 0, -0.5 > scale < RoomW, RoomH, RoomD > }
		}
		object{ WindowFrame translate WindowPos1 }
		object{ WindowFrame rotate 90*y translate WindowPos2 }
	}
	object{ WindowHollow translate WindowPos1 }
	object{ WindowHollow rotate 90*y translate WindowPos2 }
	pigment{
		checker
		rgb< 1.0, 0.95, 0.95 >, rgb< 0.9, 0.8, 0.8 >
		scale < 150, 300, 150 >
	}
	finish{ diffuse 0.7 ambient 0.1 }
}

#declare WindowpaneFrameW = 50;
#declare WindowpaneFrameT = 20;
#declare WindowpaneFrameR = 5;
#declare WindowGap = 5;

#declare WindowpaneFrameV = Box( WindowpaneFrameW, WindowH-2*WindowGap, WindowpaneFrameT, WindowpaneFrameR )
#declare WindowpaneFrameH = Box( WindowW/2-2*WindowGap, WindowpaneFrameW, WindowpaneFrameT, WindowpaneFrameR )
#declare WindowpaneFrameV2 = Box( WindowpaneFrameW/2, WindowH-2*WindowGap, WindowpaneFrameT, WindowpaneFrameR )
#declare WindowpaneFrameH2 = Box( WindowW/2-2*WindowGap, WindowpaneFrameW/2, WindowpaneFrameT, WindowpaneFrameR )
#declare Glass =
	box{ 0, 1
		scale < WindowW/2-WindowpaneFrameW, WindowH-WindowpaneFrameW, 4 >
		pigment{ rgbt 1 }
		finish{ reflection 0.3 }
		interior{ ior 1.4 }
	}

#declare Windowpane =
	union{
		object{ WindowpaneFrameV }
		object{ WindowpaneFrameV translate (WindowW/2-WindowpaneFrameW-2*WindowGap)*x }
		object{ WindowpaneFrameH }
		object{ WindowpaneFrameH translate (WindowH-WindowpaneFrameW-2*WindowGap)*y }
		object{ Glass translate < WindowpaneFrameW/2, WindowpaneFrameW/2, WindowpaneFrameT/2 > }
		object{ WindowpaneFrameV2 translate (WindowW/4-WindowpaneFrameW/2)*x }
		#declare N = 2;
		#while( N )
			object{ WindowpaneFrameH
				translate (WindowpaneFrameW+(WindowH-2*(WindowpaneFrameW+WindowGap))/3*N)*y
			}
			#declare N = N - 1;
		#end
		pigment{ White }
		finish{ ambient 0.3 }
	}

object{ Windowpane
	rotate -110*y
	translate WindowPos2 + < WindowW-WindowGap, WindowGap, 0 >
}

object{ Windowpane
	scale < 1, 1, -1 >
	rotate -80*y
	translate WindowPos2 + < WindowGap, WindowGap, 0 >
}

#include "Chest.inc"
object{ Chest translate < 200, 0, RoomD/2 > }

#include "Rack.inc"
#include "TV.inc"
union{
	object{ Rack }
	object{ TV translate TVHeight*y }
	rotate 20*y
	translate < 800, 0, 1300 >
}

#declare F_Blocks = finish{ ambient 0.1 diffuse 0.7 phong 0.6 }
union{
	#declare S = seed(0);
	object{ BoxBlock1 pigment{ RandColor(S) } finish{ F_Blocks } rotate  20*y translate< -290, 0,  30 > }
	object{ BoxBlock1 pigment{ RandColor(S) } finish{ F_Blocks } rotate -10*y translate< -120, 0, -10 > }
	object{ BoxBlock1 pigment{ RandColor(S) } finish{ F_Blocks } rotate  15*y translate<  100, 0,  20 > }
	object{ BoxBlock1 pigment{ RandColor(S) } finish{ F_Blocks } rotate -40*y translate<  280, 0,  50 > }
	#declare Height = BoxSizeH1;
	object{ CylinderBlock pigment{ RandColor(S) } finish{ F_Blocks } translate< -320, Height,  50 > }
	object{ BoxBlock1 pigment{ RandColor(S) } finish{ F_Blocks } rotate -10*y translate< -110, Height, -10 > }
	object{ BoxBlock1 pigment{ RandColor(S) } finish{ F_Blocks } rotate -20*y translate<   80, Height,  20 > }
	object{ CylinderBlock pigment{ Magenta } finish{ F_Blocks } translate<  270, Height,  50 > }
	#declare Height = Height + BoxSizeH1;
	object{ BoxBlock2 pigment{ RandColor(S) } finish{ F_Blocks } rotate  15*y translate< -210, Height, 10 > }
	object{ BoxBlock2 pigment{ RandColor(S) } finish{ F_Blocks } rotate  -5*y translate<    0, Height,  0 > }
	object{ BoxBlock2 pigment{ RandColor(S) } finish{ F_Blocks } rotate -10*y translate<  220, Height, 30 > }
	#declare Height = Height + BoxSizeH2;
	object{ CylinderBlock pigment{ RandColor(S) } finish{ F_Blocks } translate< -200, Height,  10 > }
	object{ BoxBlock1 pigment{ RandColor(S) } finish{ F_Blocks } rotate 5*y translate< -5, Height, 0 > }
	object{ CylinderBlock pigment{ RandColor(S) } finish{ F_Blocks } translate<  200, Height,  20 > }
	#declare Height = Height + CylinderHeight;
	object{ BoxBlock2 pigment{ RandColor(S) } finish{ F_Blocks } rotate   5*y translate< -120, Height, 10 > }
	object{ BoxBlock2 pigment{ RandColor(S) } finish{ F_Blocks } rotate  -5*y translate<  105, Height,  0 > }
	#declare Height = Height + BoxSizeH2;
	object{ CylinderBlock pigment{ RandColor(S) } finish{ F_Blocks } translate< -80, Height,  0 > }
	object{ CylinderBlock pigment{ RandColor(S) } finish{ F_Blocks } translate<  70, Height, 10 > }
	object{ ConicBlock pigment{ RandColor(S) } finish{ F_Blocks } translate< -190, Height, 0 > }
	object{ ConicBlock pigment{ RandColor(S) } finish{ F_Blocks } translate<  180, Height, 0 > }
	#declare Height = Height + CylinderHeight;
	object{ BoxBlock2 pigment{ RandColor(S) } finish{ F_Blocks } rotate -3*y translate< 0, Height, 0 > }
	#declare Height = Height + BoxSizeH2;
	object{ TriangleBlock pigment{ RandColor(S) } finish{ F_Blocks } rotate -5*y translate< -3, Height, 4 > }

	union{
		#declare R = 450;
		#declare A = 240;
		#declare N = 10;
		#declare APitch = A/(N-1);
		#declare A0 = (180-A)/2;
		#declare Cnt = N;
		#while( Cnt )
			#declare Cnt = Cnt - 1;
			object{ CylinderBlock
				pigment{ RandColor(S) } finish{ F_Blocks }
				//rotate 60*(rand(S)-0.5)*y
				translate R*(1+(rand(S)-0.5)*0.1)*x
				rotate -( A0 + Cnt*APitch )*y
			}
		#end

		#declare Height = CylinderHeight;
		#declare Cnt = N-1;
		#while( Cnt )
			#declare Cnt = Cnt - 1;
			object{ BoxBlock1
				pigment{ RandColor(S) } finish{ F_Blocks }
				rotate 60*(rand(S)-0.5)*y
				translate R*(1+(rand(S)-0.5)*0.1)*x
				rotate -( A0 + (Cnt+0.5)*APitch )*y
				translate Height*y
			}
		#end

		#declare Height = Height + BoxSizeH1;
		#declare Cnt = N;
		#while( Cnt )
			#declare Cnt = Cnt - 1;
			object{ BoxBlock1
				pigment{ RandColor(S) } finish{ F_Blocks }
				rotate 60*(rand(S)-0.5)*y
				translate R*(1+(rand(S)-0.5)*0.1)*x
				rotate -( A0 + Cnt*APitch )*y
				translate Height*y
			}
		#end

		translate 300*z
	}

	translate < -80, 0, 0 >
}

object{ CylinderBlock
	pigment{ RandColor(S) } finish{ F_Blocks }
	rotate 90*z
	rotate 50*y
	translate< -470, CylinderRadius, -150 >
}

#include "ToyCar.inc"
object{ ToyCar scale 0.7 rotate 70*y translate < 420, 0, -120 > }

sky_sphere{
	pigment{
		gradient y
		color_map{
			[ 0 color Cyan ]
			[ 1 color Blue ]
		}
		translate -0.3
	}
}

#include "CherryTree.inc"
object{ CherryTree translate < 700, 0, RoomD/2+1500 > }

#declare N = 10;
#while( N )
	object{ Petal2
		rotate rand(S)*360*y
		rotate 180*int(rand(S)*2)*x
		translate < rand(S)*600-300, 1, -rand(S)*500-100 >
	}
	#declare N = N - 1;
#end

motion_blur{
	union{
		#declare N = 15;
		#declare S = seed(0);
		#while( N )
			object{ Petal2
				rotate rand(S)*360*y
				rotate (rand(S)+rand(S)*clock)*360*x
				rotate rand(S)*360*y
				#declare V = < -1+0.3*rand(S), -2-0.3*rand(S), -0.5+rand(S) >;
				translate < rand(S)*500-100, rand(S)*500, -rand(S)*300-200 >
					+ 30*V*clock
			}
			#declare N = N - 1;
		#end
	}
}

light_source{ < 110000, 71000, -60000 > White }
light_source{ < -1000, 2000, -1000 > White*0.5 }

camera{
	location < -500, 200, -1600 > look_at < -30, 350, 0 > angle 40
	focal_point 350*y aperture 50.0 blur_samples 80
}
