/*
   HF Generator : mountain
   *
   This HF is later retouched with PCPaintbrush to create a more realistic
   mountain, creating some surfaces for the snow. The snow is a material
   map created with a selfmade program to detect the slope.
*/

#version 3.0
global_settings {
 //assumed_gamma 2.2 hf_gray_16
 ambient_light 0.0
}

#include "colors.inc"
#include "textures.inc"


plane {z,12
 pigment{
  quilted
  turbulence .3
  color_map{
   [0.0 White]
   [0.55 Gray10]
   [1.0 White]
  }
  scale 3
 }
}

plane {z,-2
 pigment{
  leopard
  turbulence .3
  color_map{
   [0.0 Clear]
   [0.2 Clear]
   [0.7 White filter .8]
   [0.8 Clear]
   [1.0 Clear]
  }
 }
}

// Main spotlight creates crater mountain
light_source {-z*5 color 1  spotlight point_at z*10
  radius 14 falloff 22
}

// Dim spotlight softens outer edges further
light_source {-z*5 color .5  spotlight point_at z*10
  radius 4 falloff 30
}


