#include "colors.inc"
#include "stones.inc"
#include "woods.inc"
#include "metals.inc"

//* * * * C A M E R A   P O S I T I O N S * * * *
camera {
    location <0,30,-100>
    look_at <0,20,0>
}
light_source{ 
    <0,30,-100> 
    color Gray60 
}

//* * * * S K Y   P A R A M E T E R S

light_source { // The Sun
    <-1000, 1000, -1000>
    color White
    area_light <100, 0, 0>, <0, 0, 100>, 2, 2
    adaptive 1
    jitter
  }

fog {  // The Sky 
    distance 2500
    color SkyBlue 
    fog_type 2
    fog_offset 2500 
    fog_alt 1
  }

box { // The Clouds
    <-10000,1000,-10000>
    <10000,2000,10000>
    pigment {
      bozo
      turbulence 0.65
      octaves 6
      omega 0.7
      lambda 2
      scale 2000
      color_map {
          [0.0 0.1 color rgb <0.85, 0.85, 0.85>
                   color rgb <0.75, 0.75, 0.75>]
          [0.1 0.5 color rgb <0.75, 0.75, 0.75>
                   color rgbt <1, 1, 1, 1>]
          [0.5 1.0 color rgbt <1, 1, 1, 1>
                   color rgbt <1, 1, 1, 1>]
      }
      scale <0.5, 0.2, 0.5>
      translate <-800,0,-1000>
    }
    finish { ambient 2 } 
    no_shadow
}

//* * * * L A N D   P A R A M E T E R S * * * *


difference { // The Ground
    box {
        <-10000,0,-10000>
        <10000,-100,10000>
    }
    box { // Cut Out Area For Moat
        <-100,-100,-100>,<100,1,100> 
    }
    pigment { 
        gradient y
        scale <1,20,1>
        turbulence .1
        translate y*3
        color_map {
            [0 GreenYellow*1.25 ]
            [.24 GreenYellow*.75 ]
            [.25 Brown*.75 ]
            [.5 Brown*1.25 ]
            [.75 Brown*1.75 ]
            [.76 GreenYellow*1.75 ]
    
        }
    }
    finish { crand .25 }
}
   


height_field { // The Mountain Range
    tga "castlehf.tga"
    smooth
    translate <-.5, -.5, -.5>
    scale <2000, 500, 1000>
    translate z*500
    pigment { 
        bozo
        scale 20
        turbulence 1
        color_map {
            [0.0 ForestGreen ]
            [0.3 ForestGreen*.9]
            [0.6 ForestGreen*1.1]
            //[0.8 ForestGreen]
            [1 Gray30 ]
        }
    }
    finish { crand .25 }
}
    

// Draw the Moat Area

union { // Moat
    superellipsoid { //Island the Castle Sits On
        <.25,.25>
        scale 40
        translate y*-39
    }
    superellipsoid { // West Bank
        <.25,.25>
        scale <40,40,120>
        translate <-90,-39,0>
    }
    superellipsoid { // North Bank
        <.25,.25>
        scale <140,40,40>
        translate <0,-39,90>
    }
    superellipsoid { // East Bank
        <.25,.25>
        scale <40,40,120>
        translate <90,-39,0>
    }
    superellipsoid { // South Bank
    <.25,.25>
    scale <120,40,40>
    translate <0,-39,-90>
    }
    pigment { 
        gradient y
        scale <1,30,1>
        turbulence .05
        translate y*7
        color_map {
            [0 GreenYellow*1.25 ]
            [.24 GreenYellow*.75 ]
            [.25 Brown*.75 ]
            [.5 Brown*1.25 ]
            [.75 Brown*1.75 ]
            [.76 GreenYellow*1.75 ]
        }
    }
    finish { crand .25 }
}

box { //Put Water in the Moat
    <-50,-100,-50>,<50,-1,50>
    normal {crackle .1 scale 2 turbulence .75}
    pigment {color NavyBlue transmit .8 }
    finish {reflection .9 diffuse 1}
    interior { ior 1.33}
} 


//**** ADD THE TREES

        #declare TREE_RAND = seed(0);
        #declare Wiggle_Flag = on;
        #declare Branches_On_End_Flag = on;

        #declare Number_Of_Large_Branches = 2;
        #declare Number_Of_Medium_Branches = 4;
        #declare Number_Of_Small_Branches = 8;

        #declare Large_Branch_Minimum_Angle = 0;
        #declare Large_Branch_Maximum_Angle = 60;

        #declare Medium_Branch_Minimum_Angle = 20;
        #declare Medium_Branch_Maximum_Angle = 80;
        
        #declare Small_Branch_Minimum_Angle = 20;
        #declare Small_Branch_Maximum_Angle = 80;

        #declare Tree_Trunk_Size = 10;

        #declare Large_Branch_Size_Min = 4;
        #declare Large_Branch_Size_Max = 8;

        #declare Medium_Branch_Size_Min = 2;
        #declare Medium_Branch_Size_Max = 3;

        #declare Small_Branch_Size_Min = 2;
        #declare Small_Branch_Size_Max = 4;

        #declare Leaf_Type = 4;

        #declare TREE_MESH_SIZE = 200;

        #declare Leaf_Texture = texture { T_Stone18 scale 0.5 }
        #declare Bark_Texture = texture { T_Stone14
                normal { bumps 2.0 scale 0.1 } }

// Now go and build the tree, then show it.

        #declare numtrees=1;
        #declare random = seed(2);
        #declare random2 = seed(3);
        #while (numtrees < 30 )         
        #declare Number_Of_Large_Branches = rand(random)*2+2;
        #declare Number_Of_Medium_Branches = Number_Of_Large_Branches*2;
        #declare Number_Of_Small_Branches = Number_Of_Large_Branches*4;
        #include "ptd_tree.inc"
        object { 
            Complete_Tree 
            translate <rand(random)*200+50,.9,rand(random)*1000-100>
        }
        object { 
            Complete_Tree 
            translate <-(rand(random2)*200+50),.9,rand(random2)*800-100>
        }
        #declare numtrees=numtrees+1;
        #end

//* * * * B U I L D   T H E   F O R T R E S S 

// Build Brick Pigments
#declare P_RedBrickC = pigment { 
      bozo
      scale 50
      color_map {
        [0.00 color Gray60 ] //Mid Tone
        [0.20 color Gray50 ] //Darkest
        [0.80 color Gray70 ] //Lightest
        [1.00 color Gray60 ] //Mid Tone
      }
      warp { repeat x*8 offset <0,45,0> }
      warp { repeat y*3 offset <60,0,0> }  
    }

#declare P_RedBrick = pigment {
      brick pigment { colour rgbt <1,1,1,1> }, pigment { P_RedBrickC }
      mortar 0.35
      scale .5
    }

#declare T_RedBrick = texture {
      pigment { P_RedBrick turbulence .075}
      normal { granite 0.1 }
    }

#declare T_Mortar = texture {
      pigment { colour rgb <0.90,0.89,0.85> }
      normal { granite 0.05 scale 0.3 }
    }

//Build Repeating Tower Objects
#declare TowerDoor=union {
    box {<-1.5,0,-1>,<1.5,6,5>}
    cylinder {<0,3,-1>,<0,3,5>,1.5 scale <1,2,1>}
    box {<-1,0,-1.5>,<5,6,1.5>}
    cylinder {<-1,3,0>,<5,3,0>,1.5 scale <1,2,1>}
    pigment { color White }
}

#declare Tower_Top = difference {
    union {
        cylinder { <0,40,0>,<0,46,0>,6 }
        cylinder { <0,40,0>,<0,46,0>,5.85 texture { T_Mortar} }
    }
    union {
        cylinder { <0,41,0>,<0,46.1,0>,5.25 }
        box {<-6.1,44.5,2>,<6.1,46,-2> rotate y*-30}
        box {<-6.1,44.5,2>,<6.1,46,-2> rotate y*60 }
       
    }                              
}

#declare Tower = difference {
    union {
        cylinder { <0,0,0>,<0,40,0>,5  }
        cylinder { <0,0,0>,<0,40,0>,4.85 texture { T_Mortar} }
        object { Tower_Top }
    }
    object { TowerDoor translate y*30 }
    //pigment { White }
    texture { T_RedBrick }
}

#declare Wall = union {
    box {<-25,0,-2>, <25,30,2>} // Main Wall
    box {<-25,30,-1.25>,<25,33,-2>} // Lower Teeth
    box {<-25,0,-1.40>,<25,33,-1.85> texture { T_Mortar } }
    box {<-25,30,1.25>,<25,33,2>}
    box {<-25,0,1.40>,<25,33,1.85> texture { T_Mortar } }
    #declare X=-25;
    #while ( X < 25 )
        box {<1+X,33,-1.25>,<X+5,34.5,-2>}
        box {<1+X,33,1.25>,<X+5,34.5,2>}
        #declare X=X+8;
    #end 
    //pigment { White }
    texture { T_RedBrick }
}       
        
//***Build the Actual Tower
object { Tower translate <-25,0,-25>} // SW Tower
object { Tower rotate y*-90 translate <25,0,-25>} // SE Tower
object { Tower rotate y*90 translate <-25,0,25>} // NW Tower
object { Tower rotate y*180 translate <25,0,25>} //NE Tower
object { Wall translate z*25 } // N Wall
object { Wall rotate y*90 translate x*-25 } // W Wall
object { Wall rotate y*90 translate x*25 } // E Wall
object { Wall translate z*-25 } // S Wall

box { // Drawbridge
    <-8,0,-25>,<8,30,-28>
    texture { T_Wood12 rotate x*90 }
}

#declare BodyTrunk = union { //***BODY***
    blob { //Trunk
        threshold .7
        sphere { <0,5.75,0>, .8, 2 pigment { Flesh } } //Head
        sphere { <.35,11.5,-.5>, .35, -2.5 scale <2,.5,1> pigment { Black } } //Eye
        sphere { <-.35,11.5,-.5>, .35, -1.5 scale <2,.5,1> pigment { Black } } //Eye
        sphere { <0,5.55,-.45>, .15, 1 pigment { Flesh } } //Mouth
        sphere { <0,10.6,-.5>, .2, -1.5 scale <2,.5,1> pigment { Black } } //Mouth
        cylinder {<0,5.5,0>,<0,5,0>,.5,1 pigment { Flesh } } //Neck
        sphere { <-.6,4.5,0>, .65, 1 normal { bumps 1 scale .5 } } //L. Shoulder
        sphere { <.6,4.5,0>, .65, 1 normal { bumps 1 scale .5 } } //R. Shoulder
        cylinder {<0,4,0>,<0,2.5,0>,2,1 normal { bumps 1 scale .5 } } //Body
        pigment { Brown }
        
        
    }
    difference {
        sphere { 
            <0,5.75,0>,.65 
            texture { T_Chrome_5B }
        }
        box { <-.7,4.95,-.7>,<.7,5.75,0>}
        scale <1,1.4,1>
        translate y*-2.2
    } 
}

#declare BodyLegs = union { 
    blob { //Right Leg
        threshold .7    
        cylinder {<0,0,0>,<0,1.7,0>,1, 1} //Thigh
        cylinder {<0,0,0>,<0,1.8,0>,1, 1 rotate x*-20 translate y*1.7 } //Leg
        sphere {<0,0,0>,1,-.9 translate y*1.7} //Fix Bulge        
        rotate <-170,0,0>
        translate <-.4,2.2,0>
        pigment { color DarkBrown }
    }
    blob { //Left Leg
        threshold .7    
        cylinder {<0,0,0>,<0,1.7,0>,1, 1} //Thigh 
        cylinder {<0,0,0>,<0,1.8,0>,1, 1 rotate x*-20 translate y*1.7 } //Leg
        sphere {<0,0,0>,1,-.9 translate y*1.7} //Fix Bulge        
        rotate <-180,-30,10>
        translate <.4,2.2,0>
        pigment { color DarkBrown }
    }
}    
    
    
#declare Guard = union {
    object { BodyTrunk }
    object { BodyLegs }
    blob { //Right Arm
        threshold .7    
        cylinder {<0,0,0>,<0,1.3,0>,.7, 1} //Upper Arm
        cylinder {<0,0,0>,<0,1.3,0>,.7, .9 rotate <0,0,-60> translate y*1.3 } //Lower Arm
        sphere {<0,0,0>,.7,-.9 translate y*1.3} //Fix Bulge        
        rotate <-30,30,120>
        translate <-.8,4.5,0>
        pigment { color DarkBrown }
    }
    blob { //Left Arm
        threshold .7    
        cylinder {<0,0,0>,<0,1.3,0>,.7, 1} //Upper Arm
        cylinder {<0,0,0>,<0,1.3,0>,.7, .9  rotate z*-30 translate y*1.3 } //Lower Arm
        sphere {<0,0,0>,.7,-.9 translate y*1.3} //Fix Bulge        
        rotate <0,0,-160>
        translate <.8,4.5,0>
        pigment { color DarkBrown }
    }
    cylinder {
        <-2.5,-1,-1.5>,<-2.5,5.5,-1.5>,.1
        pigment { color Brown }
    }
    cone {
        <-2.5,5.5,-1.5>,.175
        <-2.5,6.5,-1.5>,0
        texture { T_Chrome_2B }
    }
}
 
object { Guard translate <-10,30,-25> }
object { Guard rotate y*20 translate <15,30,-25>}
 

#declare FlagPiece = difference {
    cylinder { <0,8,0>,<0,10,0>,.2 }
    union {
        box { <-1.1,7.9,-1>,<1.1,10.1,0> }
        cylinder { <0,-7.9,0>,<0,10.1,0>,.19  }
    }
    scale <1,1,.5>
}




#declare Flag= union {    
    object { FlagPiece }
    object { FlagPiece rotate y*180 translate x*.4 }
    object { FlagPiece translate x*.8 }
    object { FlagPiece rotate y*180 translate x*1.2 }
    object { FlagPiece translate x*1.6 }
    object { FlagPiece rotate y*180 translate x*2 }
    object { FlagPiece translate x*2.4 }
    object { FlagPiece rotate y*180 translate x*2.8 }
    cylinder { <0,0,0>,<0,10,0>,.3 
    pigment { Brown }
    }
    pigment { color Red }
}

#declare Flag2= union {    
    object { FlagPiece }
    object { FlagPiece rotate y*180 translate x*.4 }
    object { FlagPiece translate x*.8 }
    object { FlagPiece rotate y*180 translate x*1.2 }
    object { FlagPiece translate x*1.6 }
    object { FlagPiece rotate y*180 translate x*2 }
    object { FlagPiece translate x*2.4 }
    object { FlagPiece rotate y*180 translate x*2.8 }
    pigment {
        image_map { 
            gif "shield.gif" 
            once 
            transmit 255, 1
        }
        scale 1.5
        translate <.8,8.25,0>
    }
}



object { Flag translate <-25,40,-25> }
object { Flag2 translate <-25,40,-25.01> }
object { Flag translate <25,40,-25> }
object { Flag2 translate <25,40,-25.01> }
object { Flag translate <-25,40,25> }
object { Flag2 translate <-25,40,24.99> }
object { Flag translate <25,40,25> }                                        
object { Flag2 translate <25,40,24.99> }


