#version unofficial megapov 0.6;

// mines

#declare Pat_Rust = pigment {
	bozo
	scale .4
	warp { turbulence .3 lambda 3 }
	scale 4
	warp { turbulence .7 lambda 7 }
	scale .05
	color_map {
		[0.45 rgb 0]
		[0.50 rgb 1]
	}
}

#declare Norm_Rust = normal {
	pigment_pattern { Pat_Rust }
	normal_map {
		[0.45 bumps .3 turbulence .3 scale .1 ]
		[0.50 bumps 1.3 turbulence .3 scale .01 ]
	}
}

#declare txtMine1 = texture {
	pigment {
		pigment_pattern { Pat_Rust }
		pigment_map {
			[0 color rgb <.3, .3, .4>]
			[1 color rgb <.5, .3, .1>]
		}
	}
	normal {
		average
		normal_map {
			[1 pigment_pattern { Pat_Rust } bump_size 1.5 ]
			[1 Norm_Rust ]
		}
	}
	finish{specular 0.05 roughness 0.2 reflection 0.05 }
}
#declare txtMine2 = texture {
	pigment {
		pigment_pattern { Pat_Rust }
		pigment_map {
			[0 color rgb <.3, .3, .4>*.8]
			[1 color rgb <.5, .3, .1>*.8]
		}
	}
	normal {
		average
		normal_map {
			[1 pigment_pattern { Pat_Rust } bump_size 1.5 ]
			[1 Norm_Rust ]
		}
	}
	finish{specular 0.5 roughness 0.1 reflection 0.15 }
}
#declare txtMine = texture {
	pigment_pattern {
		gradient y
		warp { turbulence .3 octaves 2 }
		scale <.6, 3, .6>
		translate -y
	}
	texture_map {
		[0.40 txtMine2]
		[0.42 txtMine1]
	}
}


#declare Piquant = union{
        #declare rPiq1=0.08;
        #declare rPiq2=rPiq1*0.3;
        #declare yPiq=0.4;
        cone{0,rPiq1,y*yPiq,rPiq2}
        sphere{0,rPiq2 translate y*yPiq}
        sphere{0,rPiq1*1.5 scale <1,0.3,1>}
        #declare i=0;#while (i<360) sphere{0,0.015 scale <2,1,2> translate <rPiq1*2.8,-0.04,0> rotate y*i} #declare i=i+30;#end
        translate y
}                                 

#declare Piquant2 = union{
        #declare rPiq1=0.08;
        #declare rPiq2=rPiq1*0.3;
        #declare yPiq=0.4;
        cone{0,rPiq1,y*yPiq,rPiq2}
        sphere{0,rPiq2 translate y*yPiq}
        sphere{0,rPiq1*1.5 scale <1,0.3,1>}
        translate y
}                                 

#declare rd=seed(132);

//===============================
// hi-res mine
//===============================

#if (Use_Iso_Mines)
#declare hfs=function{pigment{image_map{png "minemap" map_type 1 interpolate 2}}}
#declare r0=0.03;
#end

#declare TeteMine =union {
#if (Use_Iso_Mines)
	isosurface {
		function{x*x+y*y+z*z-1 
			+(1 - hfs(x,y,z))*r0
			+noise3d(x*10,y*10,z*10)*0.05}
		threshold 0
		contained_by{sphere{0,1}}
	}
#else
	sphere { 0, 1 }
#end
	#declare i=0;
	#while (i<360)                              
		#declare j=0;
		#while (j<180)
			object{Piquant rotate z*(i+rand(rd)*2) rotate y*(j+rand(rd)*2)}
			#declare j=j+45;
		#end
		#declare i=i+45;
	#end
	object{Piquant rotate 90*y}
	object{Piquant rotate -90*y}
	rotate 360*rand(rd)        

	bounded_by{sphere{0,1+yPiq+rPiq2}}
}                                      


//===============================
// low-res mine
//===============================

#declare TeteMine2 =union {
	sphere { 0, 1 }
	#declare i=0;
	#while (i<360)                              
		#declare j=0;
		#while (j<180)
			object{Piquant2 rotate z*(i+rand(rd)*2) rotate y*(j+rand(rd)*2)}
			#declare j=j+45;
		#end
		#declare i=i+45;
	#end
	object{Piquant2 rotate 90*y}
	object{Piquant2 rotate -90*y}
	rotate 360*rand(rd)        

	bounded_by{sphere{0,1+yPiq+rPiq2}}
}                                      

