#include "colors.inc"
#include "finish.inc"
#include "textures.inc"
#include "glass.inc"
#include "spline.inc"
#include "blob_macro.inc"
#include "eye_macro.inc"
#include "eye.inc"
#include "hexa.inc"

#declare HexColorLow=color Brown;
#declare HexColorHigh=color Pink;
#declare StenaColorLow=color MandarinOrange;
#declare StenaColorHigh=color Flesh;
#declare TunelColor=color Orange;
#declare SkloColor=color Gold;





#declare Hexagon_layout_on=1;
#declare Steny_layout_on=1;
#declare Detailny_tunel=1;
#declare TunelNearDetail=1;
#declare Jadra_on=1;
#declare Virus_on=1;
#declare Virus_detail=1;
#declare bumpmaps_on=1;
#declare bumpmaps_hex_on=1;
#declare Tentacles_on=1;
#declare Bunkove_veci_on=1;
#declare Lightre_on=1;
#declare Lightre_iba_blizke=1;
#declare Near_distance=8;
#declare HexCount=600; 
#declare TentCount=20; 
#declare StenyCount=1000; //1000
#declare Fog_on=1;


#if (Bunkove_veci_on | Jadra_on)
  #include "dna.inc"
  #include "nucleus.inc"
#end


#declare clipping_plane=plane{-z, 1.38}

#declare layoutColorOn=1;     //   BUG??????
#declare d=0.18;
#declare dir=array[4]{<-1,-1,0>,<-1,1,0>,<1,-1,0>,<1,1,0>}

#declare nx=8;
#declare ny=35;
#declare ox=-4;
#declare oy=-3;
Layout(ox,oy,nx,ny)

//#background{Gray90}
#declare sila=2;
sky_sphere{
pigment{
  marble 
  color_map {
    [0.0 rgb sila*<0.8, 0.8, 0.6>]
    [0.8 rgb sila*<0.8, 0.4, 0.4>]
    [1.0 rgb sila*<0.8, 0.2, 0.2>]
  }
  turbulence 1
}}

#if(Fog_on)
fog{color Pink filter 0.8 fog_type 2 fog_offset .81 fog_alt 0.001 distance 8 
    turbulence <15, 15, 15>
    omega 0.35
    lambda 1.25
    octaves 5
}
#end


#if(TunelNearDetail)
#declare TunelNearTexture = texture
 {
  #declare pr=1;

  pigment
 {
    marble
//    gradient x
    turbulence 0.6
 lambda 2.25
    color_map
  {

      [0.00 color rgbt<1.000, 1.000, 1.000, pr>]
      [0.30 color rgbf<1.000, 1.000, 1.000, pr>]
      [0.30 color rgbf<0.400, 0.400, 1.000, pr>]
      [0.50 color rgb<0.898, 0.898, 1>]
      [0.60 color rgbf<0.400, 0.400, 1.000, pr>]
      [0.60 color rgbf<1.000, 1.000, 1.000, pr>]
      [1.00 color rgbt<1.000, 1.000, 1.000, pr>]
    }
    
    scale 0.4
  }
  finish {
    ambient 1.0
  }
}
#else #declare TunelNearTexture=texture{pigment{color Pink}finish{Shiny}}
#end


//////////////////////
// CAMERA

#declare Camera_location=vaxis_rotate(vaxis_rotate(-2.5*z,x,19),y,3)-0.3*y; 
#declare Camera_look_at=vaxis_rotate(vaxis_rotate(0,x,19),y,3)-0.3*y; 
#camera{
  location Camera_location
  look_at Camera_look_at

/*   location -12.5*z
   look_at <0,0,0>
   rotate x*90
   rotate y*3*/
  
//  angle 40
}






/////////////////////////////////////////
// SVETLA

#if (1)
  // len docasne - v stredoch buniek
  light_source{<0.7 ,-0.4, 0.5+-((3+d*sqrt(3))/2)> color Gray40}
  light_source{<-0.7 ,-0.4, 0.5+-((3+d*sqrt(3))/2)> color Gray40}
#end

light_source{ <00,100,00> color 1.2*White}
light_source{ <0,7,-1> color .7*White}
light_source{ Camera_location color White}

////////////////////////////////
// POSTAVY

#if (Jadra_on)
 object{Nucleus(0.1,300,Cyan) scale 0.1 rotate y*45 translate <0.7 ,-0.4, 0.5+-((3+d*sqrt(3))/2)> }
 object{Nucleus(-0.1,300,Green) scale 0.1 rotate y*-45 rotate x*20 translate <-0.7 ,-0.4, 0.5+-((3+d*sqrt(3))/2)> }
#end


#if (Virus_on)
  #include "virus1.inc"
  #include "jet1.inc"
  #declare Svir=seed(112);
  #declare NVir=26;
  #declare Viruspos=array[NVir]
  #declare Virusrot=array[NVir]
  #declare i=0;#while(i<NVir)
    #declare Viruspos[i]=vaxis_rotate(<0,0.8+2*rand(Svir),3+10*rand(Svir)>,y,80*(rand(Svir)-0.5));
    #declare Virusrot[i]=<0,-30-90*rand(Svir),-20-10*rand(Svir)>;
    #declare i=i+1;
  #end
  #declare Viruspos[0]=<-0.8,.5,0>;
  #declare Viruspos[1]=<0.2,.6,1>;
  #declare Viruspos[2]=<2,.6,2>;
  #declare Virusrot[0]=<0,-120,-20>;
  #declare Virusrot[1]=<0,-90,-30>;
  #declare Virusrot[2]=<0,-30,-30>;
  #declare Svg=seed(11);
  
  #declare iq=0;#while(iq<NVir)
    #if (Virus_detail=0)
      sphere{0 0.1 translate Viruspos[iq] pigment{color Green}}
    #else  
    object{Jet1(1,Virus1(1,0),2,int(3*rand(Svir)),10*rand(Svg)) scale 0.085
      rotate y*Virusrot[iq].y
      rotate x*Virusrot[iq].z
      translate Viruspos[iq]
    }
    #end
    #declare iq=iq+1;
  #end
  
  
/*  object{Jet1(1,Virus1(1,0),2,1) scale 0.085 rotate y*-120 rotate x*-20  translate <-0.8,.5,0>}
  object{Jet1(1,Virus1(1,0),2,0) scale 0.085 rotate y*-90 rotate x*-30  translate <0.2,.6,1>}
  object{Jet1(1,Virus1(1,0),2,1) scale 0.085 rotate y*-30 rotate x*-30  translate <2,.6,2>}
*/
#end


//lightre
#if (Lightre_on)
  #include "lighter.inc"
  #declare Ls=seed(12);
  
  #declare N=5;
  #declare A=array[N]{<0,1.4,0>,<-0.5,2.5,0>,<1,3,0>,<1,4,0>,<0,4.5,0>}
  #declare As=array[ny][nx]
  #declare Rs=array[ny][nx]
  #declare Hrs=array[ny][nx]
  #declare Clrs=array[ny][nx]
  #declare Opens=array[ny][nx]  
  
#declare i=2;#while(i<ny-1)
  #declare j=0;#while(j<nx)
    #declare Rs[i][j]=rand(Ls)*360;
    #declare Hrs[i][j]=(rand(Ls)-0.5)*60+80;
    #declare As[i][j]=A
    #declare Opens[i][j]=0.1+0.2*(rand(Ls)-0.5);
    #declare Clrs[i][j]=#alternative(rand(Ls))#case(0.3)color Green;#case(0.3)color DarkSlateBlue;#case(0.4)color Gold;#end
    #declare j=j+1;
  #end
  #declare i=i+1;
#end

#declare pol=div(nx,2);
#declare Rs[2][pol]=-135;
#declare As[2][pol]=array[N]{<0,1.4,0>,<-.5,1.5,0>,<-.5,1.8,0>,<-1,2,0>,<-1,3.5,0>}
#declare Hrs[2][pol]=110;

#declare Rs[5][pol]=-40; 
#declare Hrs[5][pol]=90;
#declare Clrs[5][pol]=Cyan;

#declare Rs[3][pol]=80;
//#declare Rs[3][pol+1]=0;

#declare i=2;#while(i<ny-1)
  #declare j=0;#while(j<nx)
  
  #if (vlength(Points[i][j]-Camera_location)<5)
  #if(Lightre_iba_blizke)#declare tmp=0;#else#declare tmp=1;#end    
  object{lighter(N,As[i][j],Hrs[i][j],tmp,tmp,Opens[i][j],Clrs[i][j],1,0,35)
    rotate y*Rs[i][j]
    scale 0.12
    translate Points[i][j]-0.05*y
  }
  #else#if((vlength(Points[i][j]-Camera_location)<10)&(Lightre_iba_blizke=0))
  object{lighter(N,As[i][j],Hrs[i][j],0,0,Opens[i][j],Clrs[i][j],0,0,10)
    rotate y*Rs[i][j]
    scale 0.12
    translate Points[i][j]
  }
  
#end#end
    #declare j=j+1;
  #end
  #declare i=i+1;
#end


#end


////////////////////////////
// TUNELY

#macro Tunel(A,B,rr)
   #local rot=5*180;
   #local vr=0.5*rr*sin(radians(60));
   #local mr=0.2*rr;
   #local dv=0.5*rr;
   #local dm=0.7*rr;
   #declare rotx=2*degrees(acos(vlength((<B.x,0,B.z>-<A.x,0,A.z>+
                            x*vlength(<B.x,0,B.z>-<A.x,0,A.z>))/2)/
                           vlength(<B.x,0,B.z>-<A.x,0,A.z>)));
   #declare rotz=degrees(asin( (B.y-A.y)    /
                           vlength(B-A)));
			   
   #macro vSp(n,txt,x_rot)
   merge{    
     #local i=0;#while(i<=n)
       sphere{0, vr 
         translate x*i/n
         translate dv*z 
	 rotate x*i/n*rot 
         #if(txt)
     //   texture{TunelNearTexture scale vr rotate -z*degrees(atan2(dv,i*180/rot))}
          texture{TunelNearTexture scale vr rotate -z*30}
	 #end  
	 rotate x*x_rot
       }
       #local i=i+1;
     #end
   }
  #end
  
   #macro mSp(n) merge{    
     #local i=0;#while(i<=n)
       #local j=0;#while(j<3)
         sphere{0, mr translate dm*z rotate x*(60+120*j+i/n*rot) translate x*i/n
           #local clr=#switch(j)#case(0) Scarlet;#break#case(1)DarkOliveGreen;#break#case(2)DarkSlateBlue;#break#end
	   pigment{
	     bozo
	     turbulence 10
	     color_map{
	       [0.0 0.8*clr]
	       [0.98 1.2*clr]
	       [1.0 color White]
	     }
	     scale mr   
	    }
	    finish{Shiny}

	 } 	 
	 #local j=j+1;
       #end	 
       #local i=i+1;
     #end
   }
   #end
   
 #if(vlength(Camera_location-(A+B)/2)>2*Near_distance | (Detailny_tunel=0))
   cylinder{A,B,rr pigment{color Pink}}
 #else#if(vlength(Camera_location-(A+B)/2)>Near_distance) 
   #local i=0;#while(i<3)
   object{
     vSp(30,1,i*120)
     scale <vlength(B-A),1,1>
     rotate z*rotz
     rotate y*-rotx
     translate A
//     pigment{color TunelColor }
     finish{phong 0.4 phong_size 100}			   
   }     			   
   #local i=i+1;
   #end      

   object{mSp(30)
     rotate x*i*120
     scale <vlength(B-A),1,1>
     rotate z*rotz
     rotate y*-rotx
     translate A
     finish{phong 0.4 phong_size 100}			   
   }     			   

 #else

   #local i=0;#while(i<3)
   object{
     vSp(80,1,i*120)
     rotate x*i*120
     scale <vlength(B-A),1,1>
     rotate z*rotz
     rotate y*-rotx
     translate A
    
     finish{phong 0.8 phong_size 1000}			   
   }     			   
   #local i=i+1;
   #end      

   object{mSp(100)
     rotate x*i*120
     scale <vlength(B-A),1,1>
     rotate z*rotz
     rotate y*-rotx
     translate A
     finish{phong 0.4 phong_size 100}			   
   }     			   
 #end#end
#end

#declare i=2;#while(i<ny-1)
  #declare j=0;#while(j<nx)
    Tunel(Points[i][j],Points[i+1][j],0.1)
    #declare j=j+1;
  #end
  #declare i=i+1;
#end


#declare i=2;#while(i<ny-1) 
  #declare j=0;#while(j<nx)
    #declare tmpy=i+dir[mod(i+oy+400000,4)].y;
    #declare tmpx=j+dir[mod(i+oy+400000,4)].x;
    #if ((tmpy>=0)&(tmpy<ny)&(tmpx>=0)&(tmpx<nx))
      Tunel(Points[i][j],Points[tmpy][tmpx],0.1)
    #end  
    #declare j=j+1;
  #end
  #declare i=i+2;
#end




////////////////////////////////
// SESTUHOLNIKY

#declare Hex_pigment=
  pigment{
    onion
    color_map{
      [0.0 color White]
      [1.0 color Black]
    }
  }


#if (layoutColorOn)
  #declare layoutColor=color Red;
  #declare layoutPosition=<1,1,1>;
#end

#declare Sb=seed(1);

#macro elem_hex(siz)
  sphere{ 0 1 
  scale 1.4
    #ifdef(layoutColor)
     translate 6*y*sin(layoutColor.red)-2
     pigment{color HexColorHigh*(layoutColor.red)+HexColorLow*0.5*(1-layoutColor.red)}
    #else 
     pigment{color HexColorLow}
    #end
    #if (bumpmaps_hex_on)
    normal{
      bumps 
      translate <100*rand(Sb),100*rand(Sb),100*rand(Sb)>
      bump_size 1.8-6*sin(layoutColor.red)
      scale 0.06
    }
    #end
    scale siz
  }    
#end

#declare St=seed(1234);

#macro tentacle(siz)
  #local N=6;
  #local A=array[N]
  #local A[0]=<0,0,0>;
  #local A[N-1]=<0,1/3,0>;
  #local i=1;#while(i<N-1)
    #local A[i]=<0.13,i/(3*(N-1)),0>; //.13
    #local A[i]=vaxis_rotate(A[i],y,360*rand(St));
    #local i=i+1;
  #end
  union{
    #local d=vlength(Camera_location-layoutPosition);
    #if (d<8) #local stepss=1+15*(9-d)/d; #else #local stepss=3;#end
    #local i=0;#while(i<1)
      cone{ Spline(N,A,i) 0.4*siz*(1-i)+0.02*siz*i
            Spline(N,A,i+1/stepss)  0.4*siz*(1-i-1/stepss)+0.02*siz*(i+1/stepss) 
              #ifdef(layoutColor)
                 translate 6*siz*y*sin(layoutColor.red)-2*siz
                 pigment{color 0.5*Flesh*(1-i)+1.1*White*i}
              #else 
                 pigment{color Flesh}
              #end
	    }
      #local i=i+1/stepss;
    #end  
  }
#end


#macro Hexagon_layout(objekt)
union{
#if (Hexagon_layout_on)
layout{
  object{objekt}
  layout_on_top
  layout_count HexCount
  layout_size 0.04
  layout_distance 0.01
  layout_adjust_normal 0.0
  "elem_hex"
}
#end
#if (Tentacles_on)
layout{
  object{objekt}
  layout_on_top
  layout_count TentCount
  layout_size 0.01
  layout_distance 0.05
  layout_adjust_normal 0.0
  layout_random_stream St
  "tentacle"
}
#end
#if (Hexagon_layout_on=0)
object{objekt}
#end
}
#end


#declare pnts=array[6]

#declare i=2;#while(i<ny-3)
  #declare j=0;#while(j<nx)
    #declare pnts[0]=Points[i][j];
    #declare pnts[1]=Points[i+1][j];
    #declare pnts[2]=Points[i+2][j];
    #declare pnts[3]=Points[i+3][j];
    #declare zle=0;

    #declare tmpy=i+1+dir[mod(i+oy+400000,4)].y;
    #declare tmpx=j+dir[mod(i+oy+400000,4)].x;
    #if ((tmpy<0)|(tmpy>=ny)|(tmpx<0)|(tmpx>=nx))
      #declare zle=1;
    #else
      #declare pnts[4]=Points[tmpy][tmpx];
      #declare pnts[5]=Points[tmpy-1][tmpx];
    #end
    #if (zle=0)
      #declare C=Centers[div(i,2)+2][j-(1-mod(div(i,2),2))];
      #declare patcs=
      union{
        #declare k=0;#while(k<6)
          triangle{pnts[k],pnts[mod(k+1,6)],C}
	  #declare k=k+1;
	#end
	translate -C
      }
      object{
        patcs
	pigment{
          onion
	    scale 1.5
	    color_map{
	      [0.0 color HexColorHigh]
	      #ifdef (layoutColor)
  	        [1.0 color 0.5*HexColorLow]
	      #else
	        [1.0 color HexColorHigh]
	      #end    
	    }    
	  }
	#if (bumpmaps_on)
	normal{
	  bumps
	  bump_size 10
	  scale 0.01
	}
	#end
	translate C
      }
      #if ((vlength(C-Camera_location)<Near_distance)&(C.x>-4)&(C.x<4))
        Hexagon_layout(object{patcs scale 0.9 texture{pigment{Hex_pigment scale 1.5}}translate C})
      #end
    #end
    #declare j=j+1;
  #end
  #declare i=i+2;
#end

object{
Hexagon_layout(
triangle{
  Points[2][div(nx,2)]
  Points[2][div(nx,2)+1]
  Points[3][div(nx,2)+1]
  pigment{
    onion
    scale 1.1
    color_map{
     [0.0 color 1.5*White]
     [1.0 color Black]
    }
    translate <0.7 ,-0.2, 0.4+-((3+d*sqrt(3))/2)>
  }
}
)
translate <d/2,0,-0.5*d>}

object{
Hexagon_layout(
triangle{
  Points[2][div(nx,2)]
  Points[3][div(nx,2)]
  Points[2][div(nx,2)-1]
  pigment{
    onion
    scale 1.1
    color_map{
     [0.0 color 1.5*White]
     [1.0 color Black]
    }
    translate <-0.7 ,-0.2, 0.4+-((3+d*sqrt(3))/2)>
  }
}
)
translate <d/2,-0.02,-0.5*d>}



////////////////////////
// STENY

#declare Steny_pigment=pigment{
  bozo
  scale 0.23
  color_map{
   [0.0 color Black]
   [1.0 color White]
  }
}





#declare Steny=
 union{
  sphere{0 0.5 scale <1.4,1.5,1.3> translate <0.7 ,-0.2, 0.4+-((3+d*sqrt(3))/2)> }
  sphere{0 0.5 scale <1.4,1.5,1.3> translate <-0.7 ,-0.2,0.4+ -((3+d*sqrt(3))/2)>}
  clipped_by{clipping_plane}
  clipped_by{plane{y,-0.1}}
}

#if (Bunkove_veci_on)
#declare vec_obj=Vec()
#macro vec_macro(siz)
object{vec_obj rotate<360*rand(Sv),360*rand(Sv),360*rand(Sv)> scale siz}
#end
#declare Sv=seed(3);
 layout{
    union{
       sphere{0 0.4 scale <1.4,1.5,1.3> translate <0.7 ,-0.2, 0.4+-((3+d*sqrt(3))/2)> }
       sphere{0 0.4 scale <1.4,1.5,1.3> translate <-0.7 ,-0.2,0.4+ -((3+d*sqrt(3))/2)>}
       clipped_by{clipping_plane}
       clipped_by{plane{y,-0.1}}
     }
   layout_inside
   layout_count 15
   layout_random_stream Sv
   layout_size 0.1
   layout_distance 0.4
   "vec_macro"
 }

//  object{Vec() scale 0.4 rotate <0,0,0> translate <0.7, -0.4,-0.6>}
#end


#macro elem_stena(siz)
  sphere{ 0 1
    #ifdef (layoutColor)
     scale <1.2,1.5+0.75*layoutColor.red,1.2> 
     pigment{color StenaColorHigh*layoutColor.red+StenaColorLow*(1-layoutColor.red)}
    #else 
      scale <1.2,1.5,1.2> 
      pigment{color StenaColorHigh}
    #end  
    #if (bumpmaps_on) normal{bumps bump_size 1.2 scale 0.1}#end
    scale siz
  }    
#end

#if (Steny_layout_on) 
  layout{
    object{Steny texture{pigment{Steny_pigment}}}
    layout_surface
    layout_count StenyCount
    layout_adjust_normal 1
    layout_size 0.06
    layout_distance 0.03
    "elem_stena"
  }
#else
  object{Steny texture{pigment{Steny_pigment}}}
#end




