//#declare Dna_test=1;
#ifdef(Dna_test)
#include "colors.inc"
#include "spline.inc"
#include "finish.inc"
#end

background{White}
#camera{
  location <0,0,-4>
  look_at 0
}

light_source{ <10,10,-30> color White}

#macro Dna()
#local A=array[7]{-x,-x+y,x+y,x-y,-x-y,-2*x-y+z,z}
#local N=7;
#local i=0;#while(i<N)#local A[i]=A[i]*2;#local i=i+1;#end


#macro GenColor(S)
 #alternative(rand(S))
   #case(0.25)Red;
   #case(0.25)Green;
   #case(0.25)Blue;
   #case(0.25)Yellow;
 #end 
#end

#macro EqColor(c1,c2)
c2.red=c1.red&c2.green=c1.green&c2.blue=c1.blue
#end

union{
#local S=seed(1);
#local eps=1e-4;
#local fi=0;
#local Steps=60;
#local rounds=4;
#local oldc1=color Black;
#local oldc2=color Black;
#local i=0;#while (i<Steps)
  #local pos=i*(1-2*eps)/Steps+eps;
  #local dot=Spline(N,A,pos+eps)-Spline(N,A,pos-eps); 
  #local nrm=vaxis_rotate(SplineNormal(N,A,pos),dot,fi);
  #local fi=fi+360*rounds/Steps;
  #local sp=Spline(N,A,pos);
  #local c1=GenColor(S)  
  #local c2=c1;#while(EqColor(c1,c2))
    #local c2=GenColor(S)
  #end
  #while (i>0&((EqColor(c1,oldc1))|(EqColor(c2,oldc2))))
    #local c1=GenColor(S)  
    #local c2=c1;#while(EqColor(c1,c2))
      #local c2=GenColor(S)
    #end
  #end
  sphere{sp 0.06  translate 0.3*nrm pigment{color c1}}
  cylinder{0.2*nrm, 0.01*nrm, 0.04 translate sp pigment{color c1}}
  cylinder{0.3*nrm, 0, 0.02 translate sp pigment{color c1}}
  sphere{sp 0.06  translate -0.3*nrm pigment{color c2}}
  cylinder{-0.2*nrm, -0.01*nrm, 0.04 translate sp pigment{color c2}}
  cylinder{-0.3*nrm, 0, 0.02 translate sp pigment{color c2}}
  #if (i>0)
    cylinder{oldsp+0.3*oldnrm, sp+0.3*nrm, 0.02 pigment{color Gray20}}
    cylinder{oldsp+-0.3*oldnrm, sp-0.3*nrm, 0.02 pigment{color Gray20}}
  #end
  #local oldsp=sp;
  #local oldnrm=nrm;
  #local oldc1=c1;
  #local oldc2=c2;
  #local i=i+1;
#end
}
#end


#macro Vec()
union{
#local N=3;
#local A=array[N]{-x,.7*y,x}

merge{
#local eps=1e-4;
#local fi=0;
#local i=0.1+eps;#while (i<0.9-eps)
  #local dot=Spline(N,A,i+eps)-Spline(N,A,i-eps);
  #local nrm=vaxis_rotate(SplineNormal(N,A,i),dot,fi);
  #local fi=fi+10;
  #local sp=Spline(N,A,i);
  sphere{sp 0.5 pigment{color DarkSlateBlue transmit 0.7}
  finish{Shiny}
  }
  #local i=i+0.01;
#end
}


merge{
#local eps=1e-4;
#local fi=0;
#local i=eps;#while (i<1-eps)
  #local dot=Spline(N,A,i+eps)-Spline(N,A,i-eps);
  #local nrm=vaxis_rotate(SplineNormal(N,A,i),dot,fi);
  #local fi=fi+10;
  #local sp=Spline(N,A,i);
  sphere{sp 0.08  translate 0.3*nrm pigment{color CadetBlue}}
  cylinder{sp,sp+0.3*nrm,0.03 pigment{color CadetBlue}}
  sphere{sp 0.08  translate -0.3*nrm pigment{color CadetBlue}}
  cylinder{sp,sp-0.3*nrm,0.03 pigment{color CadetBlue}}
  #local i=i+0.01;
#end
}


}
#end

#ifdef(Dna_test)
//Dna()
Vec()
#end
