#macro lash(siz)
#local rr=0.04;
#local n=10;
#local a=30;
#local ve=<0,0,0>;
#local w=vrotate(y,<-a/n,0,0>);
union{
  #local i=0;
  #while (i<n)
    cone{ve  (1-i/n)*rr  ve+w*1/n (1-(i+1)/n)*rr  rotate x*a/n}
    #local i=i+1;
    #local ve=ve+w*1/n;
    #local w=vrotate(w,<a/n,0,0>);
  #end
  scale siz
  pigment{color Black}
}
#end



#macro Eye(lid_height,lash_count,eyecolor,lid_angle,lid_color)
#local EyeScale=<0.4,.6,0.4>;

union{
  difference{
    sphere{0 1.05 scale EyeScale}
    plane{y 0 rotate z*-lid_angle translate y*lid_height}
    pigment{color lid_color}
    finish{ specular 0.2 roughness 0.015}
  }
  
  sphere{0 1 #eye(2, color eyecolor, 1, x*90, 1.1, <0.1,-0.2,0> ) 
    scale EyeScale
  }
  
#if (lash_count>0)  
  layout {   
    difference{ //eyelid
      sphere{0 1.05 scale EyeScale}
      plane{y 0 rotate z*-10 translate y*lid_height}
      plane{-y 0 rotate z*-10 translate y*(lid_height+0.01)}
      plane{-z 0 rotate y*20}
      plane{-z 0 rotate y*-50}
      
      rotate x*90
    }
  
    layout_on_top
    layout_adjust_normal 1.0
    layout_count lash_count
    layout_size 0.21
    layout_distance 0.005
    
    "lash"
  
     rotate x*-90
  }
#end  
}
#end
