//#declare Lighter_test=1;
#ifdef (Lighter_test)
#include "blob_macro.inc"
#include "colors.inc"
#include "textures.inc"
#include "glass.inc"
#include "spline.inc"
#include "eye_macro.inc"
#include "eye.inc"

#camera{location <1,4,-8>
look_at <0,2,0>
orthographic
}
light_source{<-10,-10,-30> color White}
light_source{<10,10,-30> color White}
background{Gray20}

#declare N=5;
#declare A=array[N]{<0,1.4,0>,<-0.5,2.5,0>,<1,3,0>,<1,4,0>,<0,4.5,0>}

#end

#declare Lighter_txt=texture{
pigment{image_map{tga "snow.tga"}}
}

#declare lighter_head=
  blob{
    threshold blob_threshold
    cylinder{0.5*y 0.8*y bp(0.5,0.7)  scale <0.8,1,1>}
    sphere{0 bp(0.5,0.7)  scale <0.8,1,1>}
    sphere{0 bp(.4,0.96) scale <1,0.8,1> rotate z*30 translate 0.5*x}
    clipped_by{plane{y,0.7}}
  }

#declare Sle=seed(1234);

#macro lighter_elem(siz)
  #local Nl=3;
  #local Al=array[Nl]
  #local Al[0]=<0,0,0>;
  #local i=1;#while(i<Nl)
    #local Al[i]=<.5,1.7*i/(Nl),0>;
    #local Al[i]=vaxis_rotate(Al[i],y,360*rand(Sle));
    #local i=i+1;
  #end
  union{
    #local stepss=10;
    #local i=0;#while(i<1)
      cone{ Spline(Nl,Al,i) 0.2*siz*(1-i)+0.02*siz*i
            Spline(Nl,Al,i+1/stepss)  0.2*siz*(1-i-1/stepss)+0.02*siz*(i+1/stepss) 
                 pigment{color 0.1*Red*i+Pink*(1-i)}
	    }
      #local i=i+1/stepss;
    #end  
    scale siz
  }
#end


#macro lighter_elem2(siz)
  #local Nl=3;
  #local Al=array[Nl]
  #local Al[0]=<0,0,0>;
  #local i=1;#while(i<Nl)
    #local Al[i]=<.6,1.2*i/(Nl),0>;
    #local Al[i]=vaxis_rotate(Al[i],y,360*rand(Sle));
    #local i=i+1;
  #end
  union{
    #local stepss=3;
    #local i=0;#while(i<1)
      cone{ Spline(Nl,Al,i) .8*siz*(1-i)+0.02*siz*i
            Spline(Nl,Al,i+1/stepss)  .8*siz*(1-i-1/stepss)+0.02*siz*(i+1/stepss) 
//                 pigment{color 0.1*Flesh*i+White*(1-i)}
	    }
      #local i=i+1/stepss;
    #end  
    scale siz
  }
#end


#declare podstavec=
blob{
  threshold blob_threshold
  sphere{ 0 bp(1,3.2) scale <0.8,1,0.8> }// pigment{color Pink}}
  sphere{0 bp(1,2) scale 0.4*<0.8,1,0.8> translate y}// pigment{color Blue}}
  scale 1.2
  clipped_by{plane{-y,0}}
}  

#macro lighter(N,A,hrot,layout_on,lashes_on,open_eye,beam_color,beam_on,svetlo_on,nd)
union{
object{podstavec}
#if (layout_on=1)
layout{
  object{podstavec clipped_by{plane{-y,-1.2}}}
    layout_surface
    layout_adjust_normal 0.7
    layout_count 100//100
    layout_size 0.5
    layout_distance 0.005
    layout_random_stream Sle
    "lighter_elem"
}
#end


#local i=0;#while(i<nd)
  sphere{0 1 scale 0.5*i*i/(nd*nd)+0.13*(1-i*i/(nd*nd)) translate Spline(N,A,i/nd)}// pigment{color Pink}}
  #local i=i+1;
#end  


union{
  object{lighter_head}
#if (beam_on)
  cylinder{0.6*y, 300*y, .49  pigment{color White transmit 1}
  hollow
  interior{
    media {
      intervals 10
      emission 50*beam_color
      density{
        bozo	
	turbulence 0.8
	lambda 1
	omega 0.1
	color_map{
	  [0.0 rgb 0.4]
	  [1.0 rgb 0.55] //0.8
	}
	scale .3
      }
      density{cylindrical
        color_map{
	  [0.0 rgb 0]
	  [0.1 rgb 0.001]
	  [0.3 rgb 0.027]
	  [0.5 rgb 0.125]
	  [0.7 rgb 0.49]
	  [1.0 rgb 1.0]
	}
      }        
      samples 1, 10         
      confidence 0.9999
      variance 1/1000
      ratio 0.9
    }
  }
  scale <.8,1,1>
 }

#if (svetlo_on)
 light_source{<0,0.9,0>  color 2*beam_color
   cylinder
   point_at 5*y
   radius 10
   falloff 10
//   media_attenuation on
 }
#end 
#end

#if (layout_on=1)
  layout{
    object{lighter_head}
    layout_surface
    layout_adjust_normal 0.1
    layout_count 700 //700
    layout_size 0.2
    layout_distance 0.005

    "lighter_elem2"
    
  }     
#end  
  torus{ 0.5 0.06 scale <0.8,1,1> translate y*0.7 texture{Bright_Bronze}}
  cylinder{ 0.5*y 0.7*y 0.49 scale <0.8,1,1>
    pigment{color beam_color}
    normal{
      onion
      bump_size 10
      scale .02
      slope_map{
        [0.0 0]
	[1.0 1]
	}
     }	
     
    finish{F_Glass4}
  }
  object{Eye(open_eye,lashes_on*150,beam_color,10,color 0.7*Pink) 
   rotate y*90 rotate z*-90 scale 0.45
   translate <0.68,0.3,-0.23>}

  object{Eye(open_eye,lashes_on*150,beam_color,10,color 0.7*Pink) 
   rotate y*90 rotate z*90 scale 0.45 scale -1
   translate <0.68,0.3,0.23>}
 
  translate y*0.1
  rotate z*hrot
  translate A[N-1] 
}

  texture{Lighter_txt}


}
#end



#ifdef (Lighter_test)
  object{union{
    lighter(N,A,95,1,1,0.3,Cyan,1,1,50) 
    box{-1,1 scale <0.01,15,2> rotate y*0 translate -4*x pigment{color DarkGreen}}
   }    
    
    translate 3*x}
  object{lighter(N,A,80,1,1,-0.1,Green,1,1,50) rotate y*-80 translate -3*x}
#end