#include "colors.inc"
#include "textures.inc"
#include "woods.inc"

#declare the_soup_on = 1;
#declare the_soup_easy = 0;
#declare the_table_on = 1;
#declare the_cheese_on = 1;
#declare the_cheese_skelet = 0;
#declare the_mouse_on = 1;
#declare the_mouse_detail = 1;

#if (the_soup_on > 0)
#include "soup.pov"
#end

#if (the_cheese_on > 0)
#include "cheese.pov"
#end

#if (the_mouse_on > 0)
#include "mouse.pov"
#end

camera {
  location <-2.5, 2.3, -1.9>
  look_at <-0.2, 0.6, 0.2>
  scale 0.8
}

background { color White }

light_source { <50, 200, -100> colour Gray80 }
light_source { <-20, 40, -20> colour Gray50 }
light_source { <-30, -10, -50> colour Gray50 shadowless}

#declare theTable=box {
    <-3,-1,-3> <10,0,10>
    texture {
        // pigment { P_WoodGrain2A  color_map { M_Wood2A }}
        T_Wood34 
        rotate x*-30
        //rotate y*-15
        scale 2*2
    }
    /*
    normal { wood
             turbulence 0.04
             octaves 3
             scale <0.15, .15, 1>
        scale 2
    }
    */
    //texture { pigment {checker colour Green, colour Red}}
}

#declare theWalls=union {
    box {
        <-3,-1,4> <6,5,5>
    }
    box {
        <6,-1,-3> <6,5,5>
    }
    texture {
        pigment {
            color White
        }
        normal {
            wrinkles
            scale 0.1
            bump_size 0.5
        }
    }
}

#if (the_table_on > 0)
object {theTable}
object {theWalls}
#end

#if (the_cheese_on > 0)
object {
    theCheese
    translate y*1
    scale <-1,1,1>
    scale 0.5
    rotate y*55
    translate x*-1
}
#end

#if (the_mouse_on > 0)
object {
    theMouse
    scale 0.25
    translate <-0.95,1,0.05>
}
#end

#if (the_soup_on > 0)
object {
    theSoup
    translate <1.7,0,0.7>
}
#end
