
#ifdef (the_mouse_on)
#declare debugMode=0;
#else
#include "colors.inc"
#include "textures.inc"
#declare debugMode=1;
#declare the_mouse_detail=0;
#end

#declare mouselayoutcount=10000;

#declare random1 = seed(1);

#declare elTexture=
//texture {pigment{White_Marble}}
texture {
    normal { bumps scale 0.03 bump_size 0.1}
    pigment { color <0.6,0.3,0.01> }
}

#macro element(siz)
union {
    cone {
        <0,0,0>, siz
        <0,siz*3,0>, siz*0.6
    }
    cone {
        <0,0,0>, siz*0.6
        <0,siz*3,0>, siz*0.3
        rotate x*45*(rand(random1)*2-1)
        translate y*siz*3
    }
    // texture { elTexture }
    rotate z*30*(rand(random1)*2-1)
}
#end

#macro felement(siz)
#if (layoutColor.green < 0.7)
    #declare layoutSuccess=0;
#end
union {
    object {
        element(siz)
        rotate z*22
    }
    object {
        element(siz)
        rotate x*22
    }
    object {
        element(siz)
        rotate x*-12
        rotate z*-12
    }
    rotate x*30*(rand(random1)*2-1)
}
#end

#declare mouseTexture=
texture {
    normal { bumps scale 0.03 bump_size 0.1 }
    pigment { color <1,0.95,0.9> }
    //finish { diffuse 1 }
}

#macro hand()
blob {
    threshold 1
    cylinder { <0,0.5,0> <0,1,0> 0.2 4 } 
    cylinder { <0.2,0,0> <0,0.5,0> 0.2 4 } 
    cylinder { <-0.05,1,0> <-0.1,1.3,-0.1> 0.1 4 }
    cylinder { <0.05,1,0> <0.1,1.3,-0.1> 0.1 4 }
    cylinder { <0,1,0.05> <0,1.4,0.1> 0.1 4 }
    scale 0.5
    texture {mouseTexture}
}
#end

#macro foot()
blob {
    threshold 1
    cylinder { <0,0,0> <0,-1,0> 0.2 4 } 
    cylinder { <-0.05,-1,0> <-0.3,-1,-0.2> 0.1 4 }
    cylinder { <0.05,-1,0> <0.2,-1,-0.3> 0.1 4 }
    cylinder { <0,-1,0.05> <0,-1,0.3> 0.1 4 }
    scale 0.5
    texture {mouseTexture}
}
#end

#macro ear()
difference {
blob {
    threshold 0.2
    sphere { <0,0,0> 1 4 scale <0.55,1,0.15> }
    sphere { <0,0,-0.5> 1 strength -15 scale <0.4,1,0.15> }
}           
box {
    <-1,-1,-1> <1,-0.5,1>
}
    scale <0.5,0.4,0.5>*0.9
    texture {mouseTexture}
}
#end

#macro eye()
sphere {
    <0,0,0>
    0.08
    pigment {color rgb <1.0,0.6,0.5>}
    finish {
        phong 1
        //phong_size 0.5
    }
}
#end

#declare theMouseLayout=
union{
    blob {
        threshold 1
        sphere { <0,0,0> 1 5 scale <0.5,1,0.5> translate y*1}
        sphere { <0,0,0> 0.5 5 scale <0.7,1,0.7> translate y*2}
        sphere { <0,1.9,-0.3> 0.1 1 }
        sphere { <0,1.8,-0.2> 0.3 2 }
        texture {mouseTexture}
    }
    sphere { <0,1.9,-0.34> 0.07
        pigment {color rgb <0.3,0.3,0.3> }
    }
    object {
        hand()
        rotate z*90
        translate <-0.3,1.2,-0.2>
    }
    object {
        hand()
        rotate z*-155
        translate <0.3,1.4,-0.2>
    }
    object {
        foot()
        rotate z*-25
        rotate x*15
        translate <-0.1,0.6,-0.1>
    }
    object {
        foot()
        rotate z*15
        rotate x*10
        translate <0.1,0.6,-0.1>
    }
    object {
        ear()
        rotate z*35
        rotate x*15
        translate <-0.25,2.2,-0.1>
    }
    object {
        ear()
        rotate z*-45
        rotate x*25
        translate <0.22,2.2,-0.1>
    }
    object {
        eye()
        translate <0.08,2.08,-0.2>
    }
    object {
        eye()
        translate <-0.08,2.08,-0.2>
    }
}

#declare theSpear=
union {
    #declare spw=2.1;
    cylinder {
        <0,0,0> <0,spw,0> 0.05
    }
    cone {
        <0,0,0> 0.11 <0,0.5,0> 0
        translate y*spw
    }
    texture {
        Bronze_Texture
    }
    //scale 0.5
    rotate z*9
    translate <-0.79,0,-0.22>
}

#macro flake(siz)
sphere {
    <0,0,0> siz
    scale <1,0.1,1>
}
#end

#declare theShield=
union {
    #declare shieldHelper=
    intersection {
            sphere {
                <0,0,0> 1
                scale <0.5,1,0.2>
                translate x*-0.1
            }
            sphere {
                <0,0,0> 1
                scale <0.5,1,0.2>
                translate x*0.1
            }
            sphere {
                <0,0,0> 1
                scale <0.5,0.7,0.2>
                translate y*-0.5
            }
    }
    object {shieldHelper}
    layout {
        object {shieldHelper rotate x*90}
        layout_on_top
        layout_distance 0.05
        layout_random_stream seed(65)
        layout_size 0.05
        layout_count 250
        //layout_adjust_normal 0.8
        "flake"
        rotate x*-90
    }
    texture {
        Bronze_Texture
    }
    scale 0.9
    rotate z*-6
    rotate y*-30
    translate <0.65,1.3,-0.25>
}

#if (the_mouse_detail > 0)

#declare layoutColor=rgb <0,0,0>;

#declare theMouseLayout2=layout {
    object {theMouseLayout}
    layout_surface2
    layout_adjust_normal 1
    layout_size 0.01
    layout_distance 0.0075
    layout_count mouselayoutcount
    layout_random_stream seed(66)
    layout_retries 10000
    "felement"
    texture {mouseTexture}
}

#end

#declare theMouse=
union {
    object {theMouseLayout}
#if (the_mouse_detail>0)
    object {theMouseLayout2}
#end
    object { theSpear }
    object { theShield }
    translate y*-0.1    
}

#if (debugMode>0)
box {
   -1, <1,0,1>
   pigment {color Green}
}
camera {
  location <0, 1.9, -5>
  look_at <0, 1.9, 0.5>
  scale 0.6
  //rotate y*-140
}
light_source { <50, 200, -100> colour Gray70 }
light_source { <-20, 40, -20> colour Gray70 }
light_source { <100, 80, -200> colour Gray70 }
background { color White }
object { theMouse }
#end
