
#version unofficial MegaPov 0.7;


    #ifndef (Redond)
        #declare Redond = 0.05;           //Es el redondeado que tendr el mosaico
    #end
    #ifndef (X_Size)
        #declare X_Size = 0.5;            //Unidades en X del mosaico
    #end
    #ifndef (Y_Size)
        #declare Y_Size = 0.05;           //Unidades en Y del mosaico
    #end
    #ifndef (Z_Size)
        #declare Z_Size = 0.5;            //Unidades en Z del mosaico
    #end
    
    /*Piso*/
    #ifndef (Max_X)
        #declare Max_X = 10;            //Longitud mxima de mosaicos en X
    #end
    #ifndef (Max_Z)
        #declare Max_Z = 10;            //Longitud mxima de mosaicos en Z
    #end
    #ifndef (XZ_Move)
         #declare XZ_Move = 0.01;        //El mximo movimiento aleatorio que tendrn los mosaicos en Z y X
    #end
    
    /*Textura*/
    #ifndef (Text_Piedra1)
        #declare Text_Piedra1 = texture { T_Stone24 }
    #end
    #ifndef (Spec_Index)
        #declare Spec_Index = 0.07;
    #end
    #ifndef (Roug_Index)
        #declare Roug_Index = 1;
    #end
    #ifndef (Norm_Piedra)
        #declare Norm_Piedra = normal{
            agate 1
            scale 0.3
        }
    #end

#declare InRan = seed(777);
#declare mozaico = superellipsoid { <Redond, Redond>
    scale <0.5*X_Size, 0.5*Y_Size, 0.5*Z_Size>
}

#declare Piso = union {
    #declare PCont1 = 1;
    #declare PCont2 = 1;
    #while (PCont1 <= Max_Z)
        #while (PCont2 <= Max_X)
            object { mozaico
                    texture { Text_Piedra1
                        scale <rand(InRan)*10+5, rand(InRan)*10+5, rand(InRan)*10+5>
                        translate <rand(InRan)*2, rand(InRan)*2, rand(InRan)*2>
                        rotate <rand(InRan)*360, rand(InRan)*360, rand(InRan)*360>
                    }
                    normal { Norm_Piedra
                        scale (rand(InRan)/2)+0.5
                        translate <rand(InRan)*2, rand(InRan)*2, rand(InRan)*2>
                        rotate <rand(InRan)*360, rand(InRan)*360, rand(InRan)*360>
                    }                    
                    finish {
                        specular  Spec_Index
                        roughness Roug_Index
                    } 
                translate <PCont2*X_Size, pow(-1, int(rand(InRan)/0.5)+1)*mod(rand(InRan), 0.5)*2*XZ_Move, PCont1*Z_Size>
                rotate <pow(-1, int(rand(InRan)/0.5)+1)*mod(rand(InRan), 0.5)*20*XZ_Move, 0, pow(-1, int(rand(InRan)/0.5)+1)*mod(rand(InRan), 0.5)*20*XZ_Move>
            }
            #declare PCont2 = PCont2 + 1;
        #end
        #declare PCont1 = PCont1 + 1;
        #declare PCont2 = 1;
    #end
}  