// Persistence of Vision Ray Tracer Scene Description File
// File: MystCastle.pov
// Vers: 3.1g
// Desc: My Castle 
// Date: 16.5.00
// Auth: Florian Kastell
// Updt: 29.04.01
                                                                     
/*-----------------------------------------the global settings---------------------------------------------*/

global_settings{assumed_gamma 2.2}


/*---------------------------------------------the includes------------------------------------------------*/

#include "castle_tex.inc"
#include "cam_tower_pos.inc"

/*---------------------------------------------the settings------------------------------------------------*/

camera{location <-4,1,-12.3> look_at <-10,7.8,0>}
light_source{<-20,50,-70> rgb <.8, .45, .45> fade_distance 55 fade_power 5 area_light <0, 0, 0>, <3, 3, 0>, 3, 3 adaptive 1 jitter}
light_source{<-6,5,6> rgb <1.6, .5, .5> fade_distance 4.5 fade_power 2 area_light <0, 0, 0>, <3, 3, 0>, 3, 3 adaptive 1 jitter}


//the fog for this camera position
fog {color rgbt <1,.3,.3,.7> distance 12 fog_type 2 fog_offset .85 fog_alt .42 turbulence .5 turb_depth .5}

//look on specific towers ( insert the tower-N(see "cam_tower_pos.inc") after _Pos_ )
//camera{location Cam_Pos_L
//   look_at Cam_Pos_Look_C}
// light_source{Light_Pos_C rgb 1}   


#declare Sky_Type= false;
#declare Drawbridge_open= true;


/*------------------------------------------plane, sky and fog---------------------------------------------*/

//the ground
#declare Ground=
 height_field{
  tga "landscape.tga"
   scale <285,10,450>
    texture
     {gradient y
      texture_map{
       [0.0 Ground_Tex1]
       [0.12 Ground_Tex2]
       [0.5 Ground_Tex3]
       [0.7 Ground_Tex4]
       [1.0 Ground_Tex5]
     }
     scale <.5,10,.5>
    }
   smooth water_level .01
   translate <-132.5,-7.7,-295>
 }

//the sea
#declare Sea=
 plane{<0,1,0>, -6 texture{Sea_Tex}}

//the sky
#if (Sky_Type)
 sky_sphere{pigment{gradient y color_map{[0 rgb <.8,.8,1>][1 rgb <0,0,1>]} scale 2 translate -1}}
 plane{<0,1,0>, 3500  hollow texture{Sky_Tex scale 3500} finish{ambient .9}no_shadow}
 fog {color rgbf <.7,.7,.8,.9> distance 700 fog_type 2 fog_offset -26 fog_alt 15 turbulence .5 turb_depth .6}
 fog {color rgbt <1,1,1,.8> distance 3500}
#else
 sky_sphere{pigment{gradient y color_map{[0 rgb <.3,0,0>][.3 rgb <.2,0,0>][1 rgb 0]} scale 2 translate -1}}
 plane{<0,1,0>, 3500  hollow texture{Sky_Tex1_a scale 3500} finish{ambient .9}no_shadow}
 plane{<0,1,0>, 4000  hollow texture{Sky_Tex1_b scale 3500} finish{ambient .9}rotate y*7 translate <100,0,-100> no_shadow}
 fog {color rgbf <.5,.1,.1,.7> distance 400 fog_type 2 fog_offset -46 fog_alt 25 turbulence .5 turb_depth .6}
 fog {color rgbt <.8,.1,.1,.9> distance 3500}
#end


/*-------------------------------------------The castle----------------------------------------------------*/

//The Tower declaration
#declare Tower_Height = 16.5;
#declare Tower_Radius_bottom = 3;
#declare Tower_Radius_top = 3.5;
#declare Tower_Inner_Radius = 2.5;

#declare Tower_Pos_A = <0,0,0>;
#declare Tower_Pos_B = <-16,0,0>;
#declare Tower_Pos_C = <-16,0,12>;
#declare Tower_Pos_D = <0,0,12>;
#declare Tower_Pos_E = <30,0,12>;
#declare Tower_Pos_F = <60,0,16>;
#declare Tower_Pos_G = <70,0,50>;
#declare Tower_Pos_H = <46,0,78>;
#declare Tower_Pos_I = <5,0,84>;
#declare Tower_Pos_J = <-32,0,74>;
#declare Tower_Pos_K = <-56,0,44>;
#declare Tower_Pos_L = <-48,0,12>;


#declare Tower= 
  union{
    difference{
      union{
        difference{
          union{ cylinder{<0, 0, 0>, <0, 15, 0>,Tower_Radius_bottom}
                 cone{<0, 0, 0>, 3.8  <0, 15, 0>,0}//this is the thick base
          }
          //this is the entrance
          box{<-.75, 0, -3.801>, <.75, 1.8, -2.385> texture{Tower_Tex2}}
          cylinder{<0,-.6501,0><0,.765,0>,.75 rotate x*90 translate <0,1.8,-3.151> texture{Tower_Tex2}}
        }  
        cone{<0, 9, 0>, 0  <0, 15, 0>,3.5 texture{Tower_Tex2}}//this is the thick top
      }
      cylinder{<0, -.001, 0>, <0, 14.6, 0>, Tower_Inner_Radius}
    }
    //this is the outlook
    difference{      
      cylinder{<0, 15, 0>, <0, 16.5, 0>, Tower_Radius_top}
      cylinder{<0, 15, 0>, <0, 16.51>, 3.1}
    }
    //these are the embrasures
    #declare Embrasure_Num = 14;
    #declare Embrasure_Box =
      intersection{
        box{<0,0,-.5><-.4,1,.5>}
        cylinder{<-3.501, -.001, 0>, <-3.501, 1.001, 0>,3.5}
      }
    #declare Embrasure_Count = 1;
    #while (Embrasure_Count <= Embrasure_Num)
      object{Embrasure_Box translate x*Tower_Radius_top rotate y*360/Embrasure_Num*Embrasure_Count translate y*Tower_Height}
      #declare Embrasure_Count = Embrasure_Count+1;
    #end
  }


//the Wall declarations

//the thing above the gate 
#declare Outpost_Height= 13.75;
#declare Outpost_Radius_bottom= 1.25;
#declare Outpost_Radius_top= 1.5;
#declare Outpost_Inner_Radius= 1;
#declare Outpost_Pos= <-8,6.75,-1>;

#declare Outpost= 
union{
  difference{
    union{
      //Main-Tower-Part
      cylinder{<0, 1, 0>, <0, 5.75, 0>,Outpost_Radius_bottom}
      //Low-Edge
      cone{<0, 0, 0>,.2  <0, 1, 0>,Outpost_Radius_bottom}
      //High-Edge
      cone{<0, 1, 0>,0  <0, 6, 0>,Outpost_Radius_top texture{Tower_Tex2}}
    }
    cylinder{<0, 3, 0>,<0, 7.01, 0>, Outpost_Inner_Radius}
    cylinder{<0, -0.01, 0>,<0, 4, 0>, .15}
  }
  //this is the outpost
  difference{      
    cylinder{<0, 6, 0>,<0, 6.75, 0>, Outpost_Radius_top}
    cylinder{<0, 5.99, 0>,<0, 7, 0>, 1.3 texture{Tower_Tex}}
    cone{<0, 1.01, 0>,0 <0, 6.01, 0>,1.3 texture{Tower_Tex2}}
  }
  //these are the embrasures
  #declare Embrasure_Num = 12;
  #declare Embrasure_Box =
    intersection{
      box{<0,0,-.5><-.2,1,.5> scale .5 translate x*Outpost_Radius_top}
      cylinder{<0, -.001, 0>, <0, 1.001, 0>,Outpost_Radius_top}
    }
    #declare Embrasure_Count = 1;
    #while (Embrasure_Count <= Embrasure_Num)
      object{Embrasure_Box rotate y*360/Embrasure_Num*Embrasure_Count
                           translate y*Outpost_Height
                           translate y*-7}
    #declare Embrasure_Count = Embrasure_Count+1;
    #end
}


//the Walls
#declare Wall_AB=
union{
  difference{
    box{< -13.1, 0, -1>, < -2.9, 14, 1>}
    box{<-10.49, 0, -1.1>, <-5.51, 4, 1.1>texture{Wall_Tex}}
    cylinder{<0,-1.1,0><0,1.1,0>,2.499 rotate x*90 translate <-8,4,0>texture{Wall_Tex}}
    //these are the slits for the lever-apparatus
    box{<-5.5, 6.3, -1.1>,<-5.1, 12.75, .75>texture{Wall_Tex}}
    box{<-10.9, 6.3, -1.1>,<-10.5, 12.75, .75>texture{Wall_Tex}}
    box{<-5.5, 6.3, -.75>,<-5.1, -1, 1.1>texture{Wall_Tex}}
    box{<-10.9, 6.3, -.75>,<-10.5, -1, 1.1>texture{Wall_Tex}}
    //texture{Wall_Tex}
  }
  difference{
    object{Outpost translate Outpost_Pos texture{Tower_Tex}}
    box{<-2,-.01,0>,<2,7.5,3>texture{Tower_Tex} translate Outpost_Pos}
  }
}
#declare Wall_BC=
 box{< -17, 0, 2.9>, < -15, 12, 9.1>}
#declare Wall_CD=
 difference{
  box{< -13.1, 0, 11>, < -2.9, 12, 13>texture{Wall_Tex}}
  box{<-10.49, 0, 10.9>, <-5.51, 4, 13.1>texture{Wall_Tex}}
  cylinder{<0,-1.1,0><0,1.1,0>,2.5 rotate x*90 translate <-8,4,12>texture{Wall_Tex}}
 }
#declare Wall_Between_ABCD=
 difference{
  box{<-15, 10, 1>, <-1, 10.5, 11> texture{Tower_Tex}}
  cylinder{<0, 9.99, 0>, <0, 10.51, 0>, Tower_Radius_bottom texture{Tower_Tex}}
  cylinder{<-16, 9.99, 0>, <-16, 10.51, 0>, Tower_Radius_bottom texture{Tower_Tex}}
  cylinder{<-16, 9.99, 12>, <-16, 10.51, 12>, Tower_Radius_bottom texture{Tower_Tex}}
  cylinder{<0, 9.99, 12>, <0, 10.51, 12>, Tower_Radius_bottom texture{Tower_Tex}}
 }
#declare Wall_DA= box{< -1, 0, 2.9>, < 1, 12, 9.1>}
#declare Wall_DE= box{< 2.9, 0, 11>, < 27.3, 12, 13>}
#declare Wall_EF= box{< 0, 0, -1>, < 24.8, 12, 1> rotate y*-7.5946433 translate <32.8, 0, 12.1>}
#declare Wall_FG= box{< 0, 0, -1>, < 30.3, 12, 1> rotate y*-73.61046 translate <60.55, 0, 18.5 >}
#declare Wall_GH= box{< 0, 0, -1>, < 31.6, 12, 1> rotate y*-130.60129 translate <68.25, 0, 52.2>}
#declare Wall_HI= box{< 0, 0, -1>, < 36.1, 12, 1> rotate y*-171.67435 translate <43.25, 0, 78.4>}
#declare Wall_IJ= box{< 0, 0, -1>, < 33, 12, 1> rotate y*-15.124007 translate <-29.4, 0, 74.5>}
#declare Wall_JK= box{< 0, 0, -1>, < 33.2, 12, 1> rotate y*-51.340192 translate <-54.35, 0, 46.15>}
#declare Wall_KL= box{< 0, 0, -1>, < 27.95, 12, 1> rotate y*-104.03624 translate <-48.7, 0, 14.4>}
#declare Wall_LC= box{< -45.6, 0, 11>, < -18.7, 12, 13>}

//Drawbridge-Plank
#declare Plank=
difference{
 box{<-.5, 0, 0><0, .1, -8>}
 box{<-.4, -.5, -.5><.4, .5, .5> rotate x*45 translate <-.39, 0, -8.66>}
 box{<-.4, -.5, -.5><.4, .5, .5> rotate x*45 translate <-.39, .1, -8.66>}
 box{<-.4, -.5, -.5><.4, .5, .5> rotate x*45 translate <-.39, 0, .66>}
 box{<-.4, -.5, -.5><.4, .5, .5> rotate x*45 translate <-.39, .1, .66>}
 box{<-.3, -.5, -8.1><.3, .5, .1> rotate z*45 translate <-.88, 0, 0>}
 box{<-.3, -.5, -8.1><.3, .5, .1> rotate z*-45 translate <-.88, .1, 0>}
 box{<-.3, -.5, -8.1><.3, .5, .1> rotate z*-45 translate <.38, 0, 0>}
 box{<-.3, -.5, -8.1><.3, .5, .1> rotate z*45 translate <.38, .1, 0>}
}


//Drawbridge declaration
#declare Drawbridge=
 union{
  object{Plank texture{Wood_Tex}}
  object{Plank texture{Wood_Tex} translate x*-.5}
  object{Plank texture{Wood_Tex} translate x*-1}
  object{Plank texture{Wood_Tex} translate x*-1.5}
  object{Plank texture{Wood_Tex} translate x*-2}
  object{Plank texture{Wood_Tex} translate x*-2.5}
  object{Plank texture{Wood_Tex} translate x*-3}
  object{Plank texture{Wood_Tex} translate x*-3.5}
  object{Plank texture{Wood_Tex} translate x*-4}
  object{Plank texture{Wood_Tex} translate x*-4.5}
  object{Plank texture{Wood_Tex} translate x*-5}
  object{Plank texture{Wood_Tex} translate x*-5.5}
                   
  object{Plank texture{Wood_Tex} rotate y*90 translate <0, -.1, -7> scale <.75, .5, 1>}
  object{Plank texture{Wood_Tex} rotate y*90 translate <0, -.1, -4.25> scale <.75, .5, 1>}
  object{Plank texture{Wood_Tex} rotate y*90 translate <0, -.1, -1.5> scale <.75, .5, 1>}
  object{Plank texture{Wood_Tex} rotate y*30 translate <-.25, -.2, -.75> scale <1.25, .5, 1>}
  difference{
   object{Plank texture{Wood_Tex} rotate y*-30 translate <-4.12, -.2, -.5> scale <1.25, .5, 1>}
   object{Plank texture{Wood_Tex} rotate y*30 translate <-.25, -.2, -.75> scale <1.25, .5, 1>}
  }
  scale <1,1,.85>
 }

//the lever
#declare Lever=
 box{<-.15, -.15, 6><.15, .15, -6>}

//the lever-apparatus
#declare Lever_Apparatus=
 union{
  object{Lever translate <-5.25, 6.55, 0>}
  object{Lever translate <-10.75, 6.55, 0>}
  box{<-.15, .15, 5.7><.15, 1.25, 6> translate <-5.25, 6.55, 0>}
  box{<-.15, .15, 5.7><.15, 1.25, 6> translate <-10.75, 6.55, 0>}
  box{<-10.9, 1.25, 5.7><-5.1, 1.55, 6> translate <0, 6.55, 0>}
  box{<-.15, .15, 2.7><.15, 1.25, 3> translate <-5.25, 6.55, 0>}
  box{<-.15, .15, 2.7><.15, 1.25, 3> translate <-10.75, 6.55, 0>}
  box{<-10.9, 1.25, 2.7><-5.1, 1.55, 3> translate <0, 6.55, 0>}
  box{<-10.9, 1.25, 3><-10.6, 1.55, 5.7> translate <0, 6.55, 0>}
  box{<-5.4, 1.25, 3><-5.1, 1.55, 5.7> translate <0, 6.55, 0>}
  texture{Wood_Tex}
 }


#declare ChainBegin = <0,6.55,-5.95>;
#declare ChainLink=
 union{
  intersection{
   torus{.3,.1 translate <0,0,-.2>}
   box{<-1,-1,-.2><1,1,1>}
  }
  cylinder{<.3,0,-.2><.3,0,-.8>,.1}
  cylinder{<-.3,0,-.2><-.3,0,-.8>,.1}
  intersection{
   torus{.3,.1 translate <0,0,-.8>}
   box{<-1,-1,-.8><1,1,-2>}
  }
 pigment{rgb <.6,.45,.45>}
// finish{roughness .1}
 }


#declare ChainLength = 7;
#declare ChainScale = .2;
#declare ChainInitSpin = 0;
#declare AddLinks = 0;
#declare ChainRot = <5,0,0>;
#declare ChainTurb = off;
#declare ChainTurbRot = 20;
#declare DegreeCorrection = on;
#declare PrimeLinkStraight = off;
#declare ChainBendTotal = 20;
#declare TweakLastLink = 0;
#declare GenerateChain = on;
#declare KillPrimeLink = off;

//Lets create the Chain!
#include "LinkGen.inc"
     
    
//Shield declaration (Shield-Main-Concept made by Tim Wenclawiak, modified by Florian Kastell)
#declare Shield=
 union{
  intersection{
   difference{
    intersection{
     cylinder{<0,0,0><0,1,0>,12 scale <.5,1,.35> translate x*5}
     cylinder{<0,-1,0><0,2,0>,12 scale <.5,1,.35> translate x*-5}
     box{<-2,-1,-3><2,2,1>}
    }
    cylinder{<.5,-1,0>,<.5,2,0>,1 scale <1,1,2> translate z*1}
    cylinder{<-.5,-1,0>,<-.5,2,0>,1 scale <1,1,2> translate z*1}
    scale <1,1,1.25>
   }
   cylinder{<0,0,-3><0,0,1>,1 scale <1,.125,1>}
   pigment{checker color rgb z*1 color rgb x*1 translate z*1.1}finish{phong .1 phong_size .2 metallic}translate z*2 scale <1,1,1.5>
  }
  difference{
   union{
    sphere{<0, 0, 0>,.15 pigment{color rgb <.5,.5,.5>}finish{specular .2 phong .2 phong_size .2 reflection .2 metallic}scale <1,.7,1> translate <0,.13,.15>}
    torus{.15,.04 pigment{color rgb <.5,.5,.5>}finish{specular .2 phong .2 phong_size .2 reflection .2 metallic}translate <0,.13,.15>}
   }
   box{<-.2,.01,-.1><.2,-.5,.35>}
  }scale .75
 }

             
//The MainTower

#declare MainTower_Height= 25;

//Embrasur
#declare Embrasur= box{<-.5,0,-.5><.5,1,.5>}

//MainTower_Tower declaration
#declare MainTower_Tower=
 difference{
  union{
   box{<-4, 0, -4>,<4, MainTower_Height-1.5, 4>}
   difference{
    box{<-5, MainTower_Height-4, -5>,<5, MainTower_Height, 5>}
    box{<-4, MainTower_Height-1.48, -4>,<4, MainTower_Height+0.01, 4>}
   }
   object{Embrasur translate <-4.5, MainTower_Height, -4.5>}
   object{Embrasur translate <0, MainTower_Height, -4.5>}
   object{Embrasur translate <4.5, MainTower_Height, -4.5>}
   object{Embrasur translate <-4.5, MainTower_Height, 0>}
   object{Embrasur translate <4.5, MainTower_Height, 0>}
   object{Embrasur translate <-4.5, MainTower_Height, 4.5>}
   object{Embrasur translate <0, MainTower_Height, 4.5>}
   object{Embrasur translate <4.5, MainTower_Height, 4.5>}
   object{Embrasur translate <-2.25, MainTower_Height, -4.5>}
   object{Embrasur translate <2.25, MainTower_Height, -4.5>}
   object{Embrasur translate <-4.5, MainTower_Height, -2.25>}
   object{Embrasur translate <4.5, MainTower_Height, -2.25>}
   object{Embrasur translate <-4.5, MainTower_Height, 2.25>}
   object{Embrasur translate <4.5, MainTower_Height, 2.25>}
   object{Embrasur translate <-2.25, MainTower_Height, 4.5>}
   object{Embrasur translate <2.25, MainTower_Height, 4.5>}
  }
  box{<-3.5, 0.2, -3.5>,<3.5, MainTower_Height-1.7, 3.5>}
 }

//MainTower_Wall declaration
#declare MainTower_Wall= 
 union{box{<-8.55, 0, -1>,<8.55, 20, 1> texture{Wall_Tex}}
  intersection{
   box{<-8.55, 0, -4>,<8.55, 15, -1> texture{Wall_Tex}}
   box{<-8.55, 0, 0>,<8.55, 20, 3> texture{Wall_Tex} rotate x*15 translate z*-3}
  }
 }
                  
//Ground underneeth the roof declaration

//Pyramid Size
//only x and z
#declare Base_Size = <15,0,15>;
//x,y,z
#declare Cap_Size = <7,1,7>;

#declare Roof=
 union{
  difference{
   box{<-24.01, 19, .99>, <-.99, 19.5, 24.01>}
   box{<-4, 0, -4>,<4, 23.5, 4>}
   box{<-4, 0, -4>,<4, 23.5, 4> translate <-25, 0, 0>}
   box{<-4, 0, -4>,<4, 23.5, 4> translate <-25, 0, 25>}
   box{<-4, 0, -4>,<4, 23.5, 4> translate <0, 0, 25>}
  }
  mesh{
  //Base-Plane
   triangle{ (Base_Size/2)*-1,(Base_Size/2),<-Base_Size.x/2,0,Base_Size.z/2> }
   triangle{ (Base_Size/2)*-1,(Base_Size/2),<Base_Size.x/2,0,-Base_Size.z/2> }
  //Cap-Plane
   triangle{ Cap_Size*<.5,1,.5>, Cap_Size*<-.5,1,-.5>, <-Cap_Size.x/2,Cap_Size.y,Cap_Size.z/2> }
   triangle{ Cap_Size*<.5,1,.5>, Cap_Size*<-.5,1,-.5>, <Cap_Size.x/2,Cap_Size.y,-Cap_Size.z/2> }
  //Right Side
   triangle{ Cap_Size*<.5,1,.5>, Cap_Size*<.5,1,-.5>, Base_Size*<.5,0,.5> }
   triangle{ Cap_Size*<.5,1,-.5>, Base_Size*<.5,1,.5>, Base_Size*<.5,0,-.5> }
  //Left Side
   triangle{ Cap_Size*<-.5,1,.5>, Cap_Size*<-.5,1,-.5>, Base_Size*<-.5,0,.5> }
   triangle{ Cap_Size*<-.5,1,-.5>, Base_Size*<-.5,1,.5>, Base_Size*<-.5,0,-.5> }
  //Front Side
   triangle{ Cap_Size*<.5,1,-.5>, Cap_Size*<-.5,1,-.5>, Base_Size*<.5,0,-.5>}
   triangle{ Cap_Size*<-.5,1,-.5>, Base_Size*<-.5,1,-.5>, Base_Size*<.5,0,-.5>}
  //Behind Side
   triangle{ Cap_Size*<.5,1,.5>, Cap_Size*<-.5,1,.5>, Base_Size*<.5,0,.5>}
   triangle{ Cap_Size*<-.5,1,.5>, Base_Size*<-.5,1,.5>, Base_Size*<.5,0,.5>}
   translate <-12.5, 19.5, 12.5>
  }
 }

/*
//The Floors -  I'm just working on it

//Main
#declare MainFloor=
 difference{
  box{<-24.01, 3.5, .99>, <-.99, 4, 24.01>}
  box{<-4, 3, -4>,<4, 5, 4>}
  box{<-4, 3, -4>,<4, 5, 4> translate <-25, 0, 0>}
  box{<-4, 3, -4>,<4, 5, 4> translate <-25, 0, 25>}
  box{<-4, 3, -4>,<4, 5, 4> translate <0, 0, 25>}
 }


//The Ground
#declare MainTower_Ground=
  box{<-24.01, 0, .99>, <-.99, .1, 24.01>}


//The stairs to the MainDoor
#declare Step_Height= .15;
#declare Step=
  box{<0,0,-.5><-.4,1,.5>}


#declare MainDoor_Stairs=
  box{<-5, 0, -3>, <2.85, 4, -.99>}

*/


//MainTower declaration
#declare MainTower=
 union{
  object{MainTower_Tower texture{Tower_Tex}}
  object{MainTower_Tower texture{Tower_Tex} translate <-25, 0, 0>}
  object{MainTower_Tower texture{Tower_Tex} translate <-25, 0, 25>}
  object{MainTower_Tower texture{Tower_Tex} translate <0, 0, 25>}

  object{MainTower_Wall translate <-12.46, 0, 0>}
  difference{
   object{MainTower_Wall}
   union{
   //this is the MainDoor
    box{<-.75, 0, -2>, <.75, 1.8, 2> texture{Tower_Tex2}}
    cylinder{<0,-2,0><0,2,0>,.75 rotate x*90 translate <0,1.8,0> texture{Tower_Tex2}}
    translate <2, 4, 0>
   }
   rotate y*90 translate <-25, 0, 12.46>
  }
  object{MainTower_Wall rotate y*180 translate <-12.46, 0, 25>}
  object{MainTower_Wall rotate y*-90 translate <0, 0, 12.46>}
  object{Roof texture{Tower_Tex2}}
  //object{MainFloor texture{Wood_Tex}}
  //object{MainTower_Ground texture{Tower_Tex}}
  //object{MainDoor_Stairs texture{Tower_Tex2}rotate y*90 translate <-25, 0, 12.46>}
 }

             
//The Castle
#declare Castle=
 union{
  union{
   object{Tower rotate y*135 translate Tower_Pos_A}
   object{Tower rotate y*-135 translate Tower_Pos_B}
   object{Tower rotate y*180 translate Tower_Pos_C}
   object{Tower rotate y*180 translate Tower_Pos_D}
   object{Tower rotate y*180 translate Tower_Pos_E}
   object{Tower rotate y*135 translate Tower_Pos_F}
   object{Tower rotate y*80 translate Tower_Pos_G}
   object{Tower rotate y*25 translate Tower_Pos_H}
   object{Tower rotate y*-10 translate Tower_Pos_I}
   object{Tower rotate y*-30 translate Tower_Pos_J}
   object{Tower rotate y*-75 translate Tower_Pos_K}
   object{Tower rotate y*-135 translate Tower_Pos_L}
   texture{Tower_Tex}
  }
  union{
   object{Wall_AB texture{Wall_Tex}}
   object{Wall_BC texture{Wall_Tex}}
   object{Wall_CD texture{Wall_Tex}}
   object{Wall_Between_ABCD texture{Wall_Tex}} 
   object{Wall_DA texture{Wall_Tex}}
   object{Wall_DE texture{Wall_Tex}}
   object{Wall_EF texture{Wall_Tex}}
   object{Wall_FG texture{Wall_Tex}}
   object{Wall_GH texture{Wall_Tex}}
   object{Wall_HI texture{Wall_Tex}}
   object{Wall_IJ texture{Wall_Tex}}
   object{Wall_JK texture{Wall_Tex}}
   object{Wall_KL texture{Wall_Tex}}
   object{Wall_LC texture{Wall_Tex}}
  }

  object{
   Drawbridge
   #if(Drawbridge_open= true)
      rotate x*0
   #else
      rotate x*70
   #end
      translate <-5, 0, -1.2>
  }
  #if(Drawbridge_open= true)
   object{Chain translate <-10.75,0,0>}
   object{Chain translate <-5.25,0,0>}
   object{Lever_Apparatus rotate x*0}
  #else
   object{Chain translate <-10.75,6,4.95>}
   object{Chain translate <-5.25,6,4.95>}
   object{Lever_Apparatus rotate x*90}
  #end
  
  union{
   object{Shield rotate x*-90 translate <-4.25, 9, -1>}
   object{Shield rotate x*-90 translate <-11.75, 9, -1>}
  }
  object{MainTower translate <40, 0, 30>}
 }

object{Castle}

object{Ground} 

object{Sea}