//*****************************************************
// Branch definition Type ver 0.1r000223a include file
// Persistence Of Vision raytracer version 3.1g
// By S.Nishimura
//*****************************************************


//*** branch ************************************************
// input check
#ifndef(V_r1) #local V_r1 =  30;#end
#ifndef(V_a1) #local V_a1 = 135;#end  // 90<=degrees<=180
#ifndef(V_r2) #local V_r2 = 180;#end
#ifndef(V_a2) #local V_a2 =  15;#end  //  0<=degrees<= 90
#ifndef(T_w0) #local T_w0 =   4;#end
#local T_l0 = V_r2/6;
#ifndef(Ground_level) #local Ground_level = 0;#end

// calculation
#local T_x1 = 0;
#local T_y1 = 0;
#local T_x2 = V_r1*cos(radians(V_a1))+T_x1;
#local T_y2 = V_r1*sin(radians(V_a1))+T_y1;
#local T_x3 = V_r2*cos(radians(V_a2))+T_x2;
#local T_y3 = V_r2*sin(radians(V_a2))+T_y2;

#local T_r1 = (sqrt((T_x1-T_x2)*(T_x1-T_x2)+(T_y1-T_y2)*(T_y1-T_y2))
              -sqrt((T_x2-T_x3)*(T_x2-T_x3)+(T_y2-T_y3)*(T_y2-T_y3))
              +sqrt((T_x3-T_x1)*(T_x3-T_x1)+(T_y3-T_y1)*(T_y3-T_y1)))/2;
#local T_r2 = (sqrt((T_x1-T_x2)*(T_x1-T_x2)+(T_y1-T_y2)*(T_y1-T_y2))
              +sqrt((T_x2-T_x3)*(T_x2-T_x3)+(T_y2-T_y3)*(T_y2-T_y3))
              -sqrt((T_x3-T_x1)*(T_x3-T_x1)+(T_y3-T_y1)*(T_y3-T_y1)))/2;
#local T_r3 =(-sqrt((T_x1-T_x2)*(T_x1-T_x2)+(T_y1-T_y2)*(T_y1-T_y2))
              +sqrt((T_x2-T_x3)*(T_x2-T_x3)+(T_y2-T_y3)*(T_y2-T_y3))
              +sqrt((T_x3-T_x1)*(T_x3-T_x1)+(T_y3-T_y1)*(T_y3-T_y1)))/2;

// definition
#local R_z1 = degrees(atan2(( T_y1-T_y2),(T_x1-T_x2)));
#local R_z2 = degrees(atan2(( T_y2-T_y3),(T_x2-T_x3)));
#local Torus_s1 =
object {
    torus { T_r1,T_w0 sturm rotate -90*x }
    clipped_by { plane { x, 0 } rotate (-90)*z }
    clipped_by { plane { x, 0 } rotate (-90-(180-R_z1))*z }
    translate < T_x1, T_y1, 0  >
}
#local Torus_s2 =
object {
    torus { T_r2,T_w0 sturm rotate -90*x }
    clipped_by { plane { x, 0 } rotate (-90+R_z1)*z }
    clipped_by { plane { x, 0 } rotate (-90+R_z2)*z }
    translate < T_x2, T_y2, 0 >
}
#local Torus_s3 =
object {
    torus { T_r3,T_w0 sturm rotate -90*x }
    clipped_by { plane { x, 0 } rotate (90)*z }
    clipped_by { plane { x, 0 } rotate (90+R_z2)*z }
    translate < T_x3, T_y3, 0 >
}
//
#declare Branch_seg =
union {
 object { Torus_s1 }
 object { Torus_s2 }
 object { Torus_s3 }
 cone { < 0, T_y3, 0 >, T_w0, < 0, T_y3+T_l0, 0 >, T_w0/2 translate -(T_r3-T_x3)*x }
 translate < T_r1-T_x1, Ground_level, 0 >
}


