// Flashes of light Scene file
// Persistence Of Vision raytracer version 3.1g
// By S.Nishimura


#include "coordinate_color.mcr.inc"


global_settings { assumed_gamma 2.2 }


camera { right 4/3*x
         sky z
         location < -60, 100, -510 >
         look_at 0
         angle 60 }

light_source { < 0, 0,-500 > color 1 *0.5 shadowless }
light_source { < 0, 500, 0 > color 1 fade_distance 300 fade_power 1 }
light_source { < 500, 0, 0 > color 1 *0.5 shadowless }


//
coordinate_color( 120, 0.3, 0.5, 1, 0 )
background { color rgb < R0, G0, B0 > }
//*****************************************************************************
//
coordinate_color(360,0,0.85,1,2)
coordinate_color(360,0,0.75,1,3)
coordinate_color(150,0.19,0.35,1,4)
#local P_cloud_a =
 pigment { wrinkles
           turbulence 0.65
           octaves 6
           omega 0.7
           lambda 2
           color_map { [0.0,0.1 color rgb <R2,G2,B2> color rgb <R3,G3,B3> ]
                       [0.1,0.5 color rgb <R3,G3,B3> color rgb <R4,G4,B4> ]
                       [0.5,1.001 color rgb <R4,G4,B4> color rgb <R4,G4,B4> ] }
           scale <6,1,6>
 }
//
coordinate_color(180,0.12,0.60,1,5)
coordinate_color(150,0.18,0.25,1,6)
coordinate_color(150,0.25,0.15,1,7)
#local P_cloud_b =
 pigment { bozo
           turbulence 0.65
           octaves 6
           omega 0.7
           lambda 2
           color_map { [0.0,0.1 color rgb <R2,G2,B2> color rgb <R5,G5,B5> ]
                       [0.1,0.5 color rgb <R5,G5,B5> color rgb <R6,G6,B6> ]
                       [0.5,1.001 color rgb <R6,G6,B6> color rgb <R7,G7,B7> ] }
           scale <6,4,6>
 }
//
coordinate_color(23,0.84,0.47,1,1)
#local S_cloud =
sky_sphere {
 pigment { gradient y 
           pigment_map { [0.01 rgb <R1,G1,B1> ]
                         [0.25 P_cloud_a scale 0.25 rotate 5*z ]
                         [0.60 P_cloud_b scale <0.25,0.15,0.25> rotate 10*z ] } }
 pigment { P_cloud_b }
}
//
sky_sphere { S_cloud scale 0.2 rotate 180*y }
//-----------------------------------------------------------------------------
#local Gl=-20; #local Zc=375; // initialize
//-----------------------------------------------------------------------------
// fog definition
coordinate_color( 198, 1.0, 0.45, 1, 1)
fog{ color rgb < R1, G1, B1 >
     fog_type 2
     fog_alt 2
     fog_offset -80
     distance 1.5
     turbulence <.15, .15, .15>
     omega 0.35
     lambda 1.25
     octaves 5
}
coordinate_color( 21, 1.0, 0.3, 1, 1 )
fog{ color rgb < R1, G1, B1 >
     fog_type 2
     fog_alt 4
     fog_offset -80*3
     distance 1.5
     turbulence <.2, .2, .2>
     omega 0.40
     lambda 1.25
     octaves 5
}
//-----------------------------------------------------------------------------
// ground
coordinate_color( 90, 1.0, 0.5, 1, 1 )
coordinate_color( 60, 1.0, 0.7, 1, 2 )
coordinate_color( 30, 1.0, 0.7, 1, 3 )
#local P_ground =
  pigment { wrinkles
            //turbulence 0.2
            //octaves 4
            //lambda 3
            //omega 0.5
            color_map { [ 0.0 rgb < R1, G1, B1 > ]
                        [ 0.5 rgb < R2, G2, B2 > ]
                        [ 1.0 rgb < R3, G3, B3 > ] } rotate 90*z scale 100 }
#local N_ground =
 normal { ripples
          turbulence 0.2
          normal_map { [ 0.0 agate ]
                       [ 0.5 agate scale 0.9 ]
                       [ 1.0 agate ] }
 scale 100 }
//
plane { y, Gl pigment { P_ground } normal { N_ground } }
//*****************************************************************************
// dome
coordinate_color( 90, 0.1, 0.9, 1, 3 )
#local T_dome =
 texture {
  pigment { hexagon color rgbt < R3, G3, B3, 0.1 >,color rgbt < R3, G3, B3, 0.2 >,color rgbt < R3, G3, B3, 0.3 > }
  finish { metallic reflection 0.5 brilliance 8 phong 0.75 phong_size 80 }
}
#local Dome_top = difference { sphere { 0,200 } box { <-201,-201,-201>,<201,100,201> } }
#local Dome_top =
 difference {
  object { Dome_top }
  #local Ei=18; #local Si=0; #while(Si<Ei) box { <140,120,-10>,<170,201,10> rotate 360*Si/Ei*y } #local Si=Si+1; #end
}
#local Dome_seg =
union {
 object { Dome_top translate 30*y }
 torus { 200*cos(asin(100/200)),10 translate 130*y }
 torus { 200*cos(asin(100/200)),10 translate 100*y } 
 difference { sphere { 0,200 } box { <-201, 100,-201>,<201,201,201> } }
 torus { 200,20 }
 cylinder { 0, 200*y, 20 }
 #local Ei=7; #local Si=0; #while(Si<Ei) cylinder { <-200,80,0>,<200,80,0>, 10 open rotate 360*Si/Ei*y } #local Si=Si+1; #end
 scale < 1,0.6,1 >
}
//
#local Dome_obj =
union {
 object { Dome_seg }
 #local Ei=5; #local Si=0; #while(Si<Ei) object { Dome_seg scale 0.3 translate (220*1.3)*x rotate (10+360*Si/Ei)*y } #local Si=Si+1; #end
}
//
object { Dome_obj texture { T_dome } translate <-450,Gl,Zc+450 > }
object { Dome_obj texture { T_dome } translate <   0,Gl,Zc > }
object { Dome_obj texture { T_dome } rotate 20*y translate < 450,Gl,Zc+450 > }
//-----------------------------------------------------------------------------
// spark
coordinate_color( 356, 1.00, 0.45, 1, 1 )
coordinate_color(  16, 1.00, 0.40, 1, 2 )
coordinate_color( 349, 0.31, 0.55, 1, 3 )
#local M_spark =
 media { emission rgb 0.03
             //intervals 10
             //samples on,1
             confidence 0.999
             variance 0.001
             density { spherical
                       color_map { [ 0.0 rgb < 0, 0, 0 > ]
                                   [ 0.4 rgb < R1, G1, B1 > ]
                                   [ 0.6 rgb < R2, G2, B2 > ]
                                   [ 0.8 rgb < R3, G3, B3 > ]
                                   [ 0.9 rgb < R1, G1, B1 > ]
                                   [ 1.0 rgb < 0, 0, 0 > ] } scale 10*2.15 }
 }
//
#local Spark_seg = difference { sphere { 0, 30 } cylinder { 0,31*z 31 } }
#local Spark_seg = object {Spark_seg hollow pigment { color rgbt < 1, 1, 1, 1 > } interior { media { M_spark } } scale 5 }
//
#local Spark_obj =
merge {
 #local Ei=20;
 #local Si=0; #while( Si<Ei )
 object { Spark_seg scale < 0.06, 0.1, 10 > rotate <90,0,-20> translate (220*1.3)*x rotate (8+360*Si/Ei)*y }
 #local Si=Si+1; #end
 no_shadow
}
//
object { Spark_obj translate <0,Gl,Zc> }
//
#local Flash_seg = torus { 10,2 hollow pigment { color rgbt < 1, 1, 1, 1 > } interior { media { M_spark } } scale 5 }
object { Flash_seg scale <6,1,6> translate <0,Gl+10,Zc> }
//-----------------------------------------------------------------------------
// grass
coordinate_color( 90, 1.0, 0.6, 1, 1 )
coordinate_color( 90, 1.0, 0.4, 1, 2 )
coordinate_color( 90, 1.0, 0.2, 1, 3 )
#local T_grass =
texture {
 pigment { gradient z
           color_map { [ 0.0 rgb < R1, G1, B1 > ]
                       [ 0.5 rgb < R2, G2, B2 > ]
                       [ 1.0 rgb < R3, G3, B3 > ] } scale 0.6 }
}
#include "Grass_P01a.gen.inc"
#local Arrange_seg = union { Grass_gen(6,10,30,8) }
//
union { Arrange_y(<   4,Gl/0.6, 4>, 24, 6,2,10) scale < 1, 0.6, 1 > }
union { Arrange_y(<-110,Gl/0.6,50>, 24, 6,2,10) scale 0.6 }
union { Arrange_y(< 120,Gl/0.6,50>, 24, 6,2,10) scale 0.6 }
//
union { Arrange_y(<0,Gl/0.6,Zc>,310,16,3,8) scale < 1, 0.6, 1 > rotate 26*y }
object { Arrange_seg scale < 1, 0.6, 1 >*0.6 translate < -70,Gl,-340 > }
//-----------------------------------------------------------------------------
// stubble
#include "Stub_P01a.def.inc"
object { Stubble_seg rotate -20*y translate < 140, Gl+5, 0 > }
//-----------------------------------------------------------------------------
// tree
#include "Tree_P01a.def.inc"
object { Tree scale 0.6 rotate 40*y translate < 230, Gl, -80 > }
//-----------------------------------------------------------------------------
// fighter
#local Cockpit_org = difference { sphere { 0,50 } box { <-51,-51,-51>,<51,25,51> } }
#local Cockpit_seg =
 difference {
  object { Cockpit_org }
  #local Ei=18; #local Si=0; #while(Si<Ei) box { <25,30,-3>,<45,51,3> rotate 360*Si/Ei*y } #local Si=Si+1; #end
}
#local Cockpit_seg = union { object { Cockpit_seg } object { Cockpit_org scale 0.9 } }
#local Wing_R = difference { box { <0,-8,-20>,< 30,-12,-80> } box { <0,-7,-20>,<-30,-13,-90> rotate -10*y } }
#local Wing_L = difference { box { <0,-8,-20>,<-30,-12,-80> } box { <0,-7,-20>,< 30,-13,-90> rotate  10*y } }
//
coordinate_color(100,0.2,0.5,1,2)
coordinate_color(100,  0,0.5,1,3)
coordinate_color(100,  0,0.3,1,4)
#local T_fighter =
texture {
 pigment { marble
           turbulence 0.8 
           color_map { [ 0.0 rgb < R2, G2, B2 > ]
                       [ 0.5 rgb < R3, G3, B3 > ]
                       [ 1.0 rgb < R4, G4, B4 > ] } scale 5 }
 finish { metallic reflection 0.5 brilliance 8 phong 0.75 phong_size 80 }
}
//
#local Fighter =
union {
 union { sphere { 90*z,4 } cone { 60*z,10,90*z,4 } cylinder { 0, 60*z, 10 } sphere { 0,10 } }
 //
 object { Cockpit_seg translate < 0,-25,-40> scale 0.4 }
 superellipsoid { < 0.24, 0.24 > scale < 8, 10, 40 > translate <-10, -10, -40 > }
 box { <-10,0,0>,<10,-15,-60> }
 superellipsoid { < 0.24, 0.24 > scale < 8, 10, 40 > translate < 10, -10, -40 > }
 //
 object { Spark_seg scale <0.08,0.08,2.8> translate <-77,-14,-45> }
 union { sphere { 0,8 } cylinder { 0, -30*z, 8 } cone { -20*z,8,-40*z,7 } translate <-77,-14,-45> }
 object { Wing_L rotate <0,60,2> translate <0,0,-44> }
 superellipsoid { < 0.28, 0.28 > scale < 30, 4, 30 > rotate 45*y translate < 0, -10, -30 > }
 object { Wing_R rotate <0,-60,-2> translate <0,0,-44> }
 union { sphere { 0,8 } cylinder { 0, -30*z, 8 } cone { -20*z,8,-40*z,7 } translate <77,-14,-45> }
 object { Spark_seg scale <0.08,0.08,2.8> translate <77,-14,-45> }
 //
 union { sphere { -18*z,8 scale <1,1,4> } cylinder { -(18*4)*z, -(18*4+10)*z, 8 } cone { -(18*4+10)*z,8,-(18*4+10+14)*z,7 } translate -5*y }
 object { Wing_R rotate < 90, 90, 0 > scale <0.4,0.4,0.6> translate <4,-15,-64-10> }
}
object {Fighter texture { T_fighter } rotate -120*y rotate 20*x translate <50,340,860> }
object {Fighter texture { T_fighter } rotate -30*y rotate 10*x translate <-99,60,-350> }
//*****************************************************************************


// Signature
/*
#include "Sealpositive.sgn.inc"
object { Sealing scale 0.6 
         rotate < degrees(atan2(100,sqrt(pow(-60,2)+pow(-510,2)))), 180+degrees(atan2(-60,-510)), 0 >
         rotate 30*z rotate -7*y translate < -78, 2, -400 > }*/
